// Camera Hood (C)2012 Vik Olliver. See bronwyn@holloway.co.nz for licencing details.

camera_length=48.5;
hood_overhang=9;
camera_ht=24;
camera_width=24.5;
screw_level=5;
screw_rad=1.6;
screw_ht=1;
fillet=4.5/2;
wall=1.5;

module fillet_edge() rotate([90,0,0]) translate ([-fillet,0,0]) intersection() {
	difference() {
		cylinder(h=camera_length+hood_overhang,r=fillet+wall,center=true,$fn=20);
		cylinder(h=1+camera_length+hood_overhang,r=fillet,center=true,$fn=20);
	}
	translate([0,0,(camera_length+hood_overhang)/-2-0.1])
		cube([fillet+wall+1,fillet+wall+1,camera_length+hood_overhang+1]);
}

// Basic filleted box
module basic_box() union () {
	translate([camera_width/2,0,-fillet]) fillet_edge();
	translate([camera_width/-2+fillet,0,0]) rotate([0,-90,0]) fillet_edge();
	// Top
	translate([0,0,wall/2])
		cube([camera_width-2*fillet,camera_length+hood_overhang,wall],
			center=true);
	translate([(wall+camera_width)/2,0,(camera_ht+fillet)/-2])
		cube([wall,camera_length+hood_overhang,camera_ht-fillet],center=true);
	translate([(wall+camera_width)/-2,0,(camera_ht+fillet)/-2])
		cube([wall,camera_length+hood_overhang,camera_ht-fillet],center=true);
}

//camera mockup
//%%translate([0,-hood_overhang/2,camera_ht/-2]) cube([camera_width,camera_length,camera_ht],center=true);
module hood() {
	difference () {
		basic_box();
		translate([0,camera_length/2,0]) rotate([-12,0,0]) translate([0,18,0])
			cube([camera_width*2,30,camera_ht*3],center=true);
	}
	// Screws
	translate ([camera_width/2+wall,camera_length/2-7,screw_level-camera_ht]) rotate([0,90,0]) cylinder(h=screw_ht,r=screw_rad,$fn=10);
	translate ([camera_width/2+wall,camera_length/-2+4,screw_level-camera_ht]) rotate([0,90,0]) cylinder(h=screw_ht,r=screw_rad,$fn=10);
	translate ([camera_width/-2-wall,camera_length/2-7,screw_level-camera_ht]) rotate([0,-90,0]) cylinder(h=screw_ht,r=screw_rad,$fn=10);
	translate ([camera_width/-2-wall,camera_length/-2+4,screw_level-camera_ht]) rotate([0,-90,0]) cylinder(h=screw_ht,r=screw_rad,$fn=10);
}

translate([0,camera_width*0.7,(camera_length+hood_overhang)/2]) rotate([90,0,90]) hood();