/*
OPENSCAD script to make a chompy dinorsoar head from http://www.thingiverse.com/thing:25779 sue the Model T.Rex by Moceri
By the DoomMeister

Attribution 3.0 Unported (CC BY 3.0) 

    to Share  to copy, distribute and transmit the work
    to Remix  to adapt the work
    to make commercial use of the work

Under the following conditions:

    Attribution  You must attribute Sue: The Model T. Rex to Moceri 

This file is not fully parametric and SCAD does not seem to like the fully detailed STL so use the reduced quality one to begin with.

*/

env_x = 44.75;
env_y = 29.37;
env_z = 48.29;
cheek = 17.29;

excess = 10;
clearance = 0.25;
hole_size = 4;

width = env_y/3;
pivot_x = env_x/4;
pivot_z = hole_size *1.5;
hole_rad = (hole_size + clearance)/2;
cheek_rad = cheek/2;

qual = 20;
model = "Sue_Moceri_bin_b.stl";//use bin_red for working, bin for rendering
//draw
!dino();
translate([0,-1.5*env_y,0])joint_lower();
translate([0,1.5*env_y,0])joint_upper();
translate([0,3*env_y,0])joint_pin();

//modules
module dino()
{


	joint_upper();
	joint_lower();
	difference()	
	{
		union()
		{
		translate([env_x/5,env_y/1.3,0])rotate([90,0,0])joint_pin();
		translate([env_x/5,-env_y/1.3,0])rotate([-90,0,0])joint_pin();
		}
		translate([-env_x/2,-(env_y+excess)/2,-env_z])cube([env_x,env_y+excess,env_z]);
	}
}


module joint_lower()
{
	difference()
	{
		union()
		{
			difference()
			{
				import (model,convexity=5);
				translate([0,-(env_y+excess)/2,-excess/2])cube([env_x,env_y+excess,env_z+excess]);
				translate([-5,-(env_y+excess)/2,pivot_z*3.5])cube([env_x,env_y+excess,env_z+excess]);
			}
			translate([-1,-(width-clearance)/2,0])cube([pivot_x+1,width-clearance,hole_size*3]);
			translate([pivot_x,(width-clearance)/2,pivot_z])rotate([90,0,0])cylinder(r = pivot_z, h= width-clearance,$fn=qual);
		}
	translate([pivot_x,(env_y+excess)/2,pivot_z])rotate([90,0,0])cylinder(r = hole_rad, h= env_y+excess,$fn=qual);
	translate([0,(env_y-clearance)/2,cheek_rad])rotate([90,0,0])cylinder(r=cheek_rad+clearance, h = width, $fn=qual);
	translate([0,-(width-clearance)/2,cheek_rad])rotate([90,0,0])cylinder(r=cheek_rad+clearance, h = width, $fn=qual);
	translate([-cheek_rad,-(env_y-clearance)/2,-1])cube([cheek_rad,width,(cheek_rad)+1]);
	translate([-cheek_rad,(width-clearance)/2,-1])cube([cheek_rad,width,(cheek_rad)+1]);
	}
}

module joint_upper()
{
	difference()
	{
		union()
		{
			difference()
			{
				import (model,convexity=5);
				difference()
				{
					translate([-env_x,-(env_y+excess)/2,-excess/2])cube([env_x,env_y+excess,env_z+excess]);
					translate([0,(env_y+excess)/2,cheek_rad])rotate([90,0,0])cylinder(r=cheek_rad-clearance, h = env_y+excess, $fn=qual);
				}
				hull()
				{
					translate([-1,-(width)/2,0])cube([pivot_x+1,width,hole_size*3]);
					translate([pivot_x,(width-clearance)/2,pivot_z])rotate([90,0,0])cylinder(r = pivot_z+clearance, h= width,$fn=qual);
					translate([0,(width)/2,cheek_rad])rotate([90,0,0])cylinder(r=cheek_rad+clearance, h = width, $fn=qual);
				}
				translate([pivot_x,-(width)/2,0])cube([pivot_z,width,pivot_z]);
			}

		}
	translate([pivot_x,(env_y+excess)/2,pivot_z])rotate([90,0,0])cylinder(r = hole_rad, h= env_y+excess,$fn=qual);

	}
}

module joint_pin()
{

			difference()
			{
				import (model,convexity=5);
				difference()
				{
					translate([-(env_x+excess)/2,-(env_y+excess)/2,-excess/2])cube([env_x+excess,env_y+excess,env_z+excess]);
					translate([pivot_x,(env_y+excess)/2,pivot_z])rotate([90,0,0])cylinder(r=hole_size/2, h = env_y+excess, $fn=qual);
				}

				

			}

}