/* Created by Andy Perkins on 7/1/2012 v0.1
Unofficial Sample logos for OpenLab Idaho

-Change as you will

-uses the nobori battle flag by Zheng3:  http://www.thingiverse.com/thing:24056
-Uses smallsidefont.scad http://www.thingiverse.com/thing:12618 by Brett Beauregard (br3tt)
-Used Polygon Rabbit to create polygon cog and beaker by tracing original OpenLab Idaho logos.  Thingiverse item 13348 by PieterBos.  http://www.thingiverse.com/thing:13348

*/

include <smallsidefont.scad>;

difference() {
	union() {
		difference() {
			import_stl("battle_flag_nobori.stl");  //http://www.thingiverse.com/thing:24056
		        //  translate([-10,-35,0])  cube([70,70,10]);
		}	
		translate([-15.8,0,15])  rotate([0,90,0]) scale([0.3,0.3,3]) cog();
		translate([-14.64,-7.5,0])  cube([1.5,17,35]);		

	translate([-17.2,1,16.5])  rotate([-90,0,0])  rotate([0,90,0]) scale([0.32,0.32,5]) beaker(); 



}
	translate([-14.64,-9.5,35])  cube([5,20,30]);	//subract lower half of original nobori flag.
	//chip();		       //comment out if you do not want chip
	//OLI_text();	       //comment out if you do not want OLI text
}

module  cog() 
{ 
color  ([0,0.2,0]) 
{ 
      linear_extrude( height = 1.3, center=false, convexity = 10, twist = 0, $fn = 1)
            polygon(points = [
[2.57,30.14]
,[-1.86,30.29]
,[-3.14,25.86]
,[-8.14,24.14]
,[-11.14,28.00]
,[-15.00,25.71]
,[-14.00,21.14]
,[-17.00,17.71]
,[-21.71,18.57]
,[-24.14,15.00]
,[-20.57,11.57]
,[-21.57,7.00]
,[-26.57,5.43]
,[-26.43,1.14]
,[-22.00,0.14]
,[-20.57,-4.86]
,[-23.86,-8.29]
,[-21.86,-11.86]
,[-17.14,-10.71]
,[-13.86,-14.00]
,[-15.00,-18.43]
,[-11.43,-20.71]
,[-7.57,-17.71]
,[-3.43,-18.43]
,[-2.00,-23.43]
,[2.57,-23.29]
,[4.00,-18.71]
,[8.57,-17.43]
,[11.86,-20.57]
,[15.57,-18.71]
,[14.43,-14.14]
,[18.00,-10.71]
,[22.43,-11.71]
,[24.71,-8.00]
,[21.71,-4.86]
,[22.57,0.00]
,[27.14,1.43]
,[27.14,5.71]
,[22.71,7.00]
,[21.71,11.29]
,[24.43,15.00]
,[22.43,18.86]
,[18.14,17.86]
,[14.71,21.14]
,[15.57,25.57]
,[11.86,27.86]
,[8.71,24.00]
,[3.71,26.00]
]
,paths = [
[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47]]
            );
}
}
//start
module  beaker() 
{ 
color  ([0.4,0.6,0.6]) 
{ 
      linear_extrude( height = 1.3, center=false, convexity = 10, twist = 0, $fn = 10) 
            polygon(points = [
[4.14,20.86]
,[4.00,8.14]
,[12.14,-7.00]
,[11.00,-8.29]
,[-10.29,-8.29]
,[-11.57,-7.00]
,[-3.43,8.00]
,[-3.43,20.71]
,[-7.14,19.57]
,[-6.00,18.00]
,[-6.14,8.00]
,[-14.57,-6.14]
,[-11.14,-10.57]
,[11.86,-10.43]
,[15.57,-6.57]
,[6.86,8.14]
,[6.86,17.86]
,[8.00,19.43]
]
,paths = [
[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17]]
            );
}
}

module chip() {
	translate([2,2,0]) rotate([0,0,38]) {
	translate([-1.0,0.5,0]) cube([0.5,5,2]);
	translate([0,0.5,0]) cube([0.5,5,2]);
	translate([1,0.5,0]) cube([0.5,5,2]);
	translate ([3,3,0]) rotate([0,0,90]) {
	translate([-1,0.25,0]) cube([0.5,5,2]);
	translate([0,0.25,0]) cube([0.5,5,2]);
	translate([1,0.25,0]) cube([0.5,5,2]);
           }

	translate([0.25,3.25,0]) cube([3,3,3], center=true);
	}
}

module OLI_text() {

	translate([-3,-4,1]) rotate ([0,0,90])  scale(1.25) writeText(0.3,0.5,2,["O"],1,[0],3);//was 0,0,130
	translate([-1,-3,1]) rotate ([0,0,-90])  scale(1.25) writeText(0.3,0.5,2,["L"],1,[0],3);  //rotate ([0,0,-75]) 
	translate([6.5,-4,1]) rotate ([0,0,90])  scale(1.25) writeText(0.3,0.5,2,["I"],1,[0],3);  // rotate ([0,0,80]) 
}