//Variables
r=50; //Radius of the chopper wheel.
r_hub=15/2+3; //Distance of holes from Motorshaft
h=5; //Thickness of the filter wheel
y=5; //The thickness of the outer edge
z=5; //The diameter of the motor shaft.
n=14; // Number of holes in the chopper wheel
a=6; //m3 nut Diameter
b=3; //m3 nut thickness
c=3; //m3 screw diameter
//________________________________________________


chopper_wheel();

//______________________MODULES____________________________//
module chopper_wheel(){
difference(){
cylinder(h,r,r); //Main body of the chopper wheel
for ( i = [0 : n] )
cylinder(h,(r-y),(r-y));
cylinder(h,(z+1)/2,(z+1)/2);

}
difference(){	
for ( i = [0 :n] ){
				rotate( i * 360 / n, [0, 0, 1])
				translate([0,0,0])
				slot(r_hub);
			}
cylinder(15,(z*3)/2+1,(z*3)/2+1);
}
difference(){
cylinder(15,(z*3)/2+3,(z*3)/2+3);
rotate([90,0,0])translate([0,10,4])hexagon(b,a/2);
translate([0,-5.5,15])cube([a,b,h*2],center=true);
translate([0,0,10])#rotate([90,0,0])cylinder(100,(c+1)/2,(c+1)/2);
cylinder(h*5,(z+1)/2,(z+1)/2);
}
}
module a(){
cube([x,x,h],center= true); //This is for a cube shaped hole
}

module b(){
translate([0,0,-h/2])cylinder(h,x/2,x/2); //This is for a cylinder shaped hole.
}

module slot(r_hub){
linear_extrude(height = h, center = false, convexity = 10, twist = 0)
polygon ([[sin(360/(n*4))*r,cos(360/(n*4))*r],[sin(360/(n*4))*-r,cos(360/(n*4))*r],[sin(-360/(n*4))*r_hub,cos(-360/(n*4))*r_hub],[sin(-360/(n*4))*-r_hub,cos(-360/(n*4))*r_hub]]);
}
module reg_polygon(sides,radius)
{
  function dia(r) = sqrt(pow(r*2,2)/2);  //sqrt((r*2^2)/2) if only we had an exponention op
  if(sides<2) square([radius,0]);
  if(sides==3) triangle(radius);
  if(sides==4) square([dia(radius),dia(radius)],center=true);
  if(sides>4) circle(r=radius,$fn=sides);
}

module hexagon_f(radius)
{
  reg_polygon(6,radius);
}

module hexagon(height,radius) 
{
  linear_extrude(height=height) hexagon_f(radius);
}