x=8.5; //Diameter of the Fiber Optic Cable
y=10;   //Fiber optic Cable holder Thickness
z=3;     //Fiber optic CableLens Holder Lip Size
X=50; //Base Diameter
Y=25;  //Base Height
a=3; //Set Screw Diameter
b=6; //Set Screw Nut Daimeter
c=3; //Set Screw Nut Thickness
d=8; //Guide Rod Diameter
e=25; //Guide Rod Length
f=3;    // Thumb Screw Head Height
g=6;   //Thumb Screw Head Diameter
i=3;    //Thumb Screw Diameter
j=3;    //PL Board Hole Diameter
k=50.8; //Filter length
l=50.8; //Filter Width
m=3; //Filter Height
n=3; //Filter Bracket Screw Diameter
o=6; //Filter Bracket Screw Nut Diameter
p=3; //Filter Bracket Screw Nut Thickness
q=10;//spacing of rod holders

rod_holder();
#translate([-q,0,0])rotate([0,0,180])rod_holder();
#translate([-q-5,-5,0]) cube([q*2,10,10]);//this makes the connector - note this is not completely parametric if you adjust q you will need to adjustthe translation.

module rod_holder(){

difference(){
translate([(x+15)/2,0,0])guide_rod();
rotate([0,0,90]){
#translate([0,((x+7)/-2)-((d)),(d+6)/2])rotate([90,0,0])cylinder(50,(a+1)/2,(a+1)/2);
translate([((x+7.5)/2)+((d+6)),0,0])rotate([0,0,90])set_screw1((d+6)/2);
}
}
translate([((x+7.5)/2)+((d+6)),0,0])rotate([0,0,90])set_screw((d+6)/2);
}

module guide_rod(){
difference(){
translate([0,e/2,(d+6)/2])rotate([90,0,0])cylinder(e,(d+6)/2, (d+6)/2);
translate([0,(e/2)+1,(d+6)/2])rotate([90,0,0])cylinder(e+2,(d+1)/2, (d+1)/2);
}
difference(){
translate([0,0,(d+6)/4])cube([(d+6),e,(d+6)/2], center = true);
translate([0,(e/2)+1,(d+6)/2])rotate([90,0,0])cylinder(e+2,(d+1)/2, (d+1)/2);
}
}


module set_screw(h){
difference(){
translate([0,5,h])rotate([90,0,0])cylinder(10,(b+3)/2, (b+3)/2);
translate([0,10,h])rotate([90,0,0])cylinder(200,(a+1)/2, (a+1)/2);
translate([0,0,h])nuttrap();
}
difference(){
translate([0,0,h/2])cube([(b+3),10,h], center = true);
translate([0,6,h])rotate([90,0,0])cylinder(12,(a+1)/2, (a+1)/2);
translate([0,0,h])nuttrap();
}
}


module nuttrap(){
translate([0,(c+1)/2,0])rotate([90,0,0])hexagon(c+1,(b+1)/2);
translate([0,0,(b*3)/2])cube([b+1,c+1,b*3],center = true);
}

module set_screw1(h){
translate([0,5,h])rotate([90,0,0])cylinder(10,(b+3)/2, (b+3)/2);
translate([0,0,h/2])cube([(b+3),10,h], center = true);
} 

module hexagonf(radius)
{
reg_polygon(6,radius);
}
module hexagon(height,radius) 
{
linear_extrude(height=height) hexagonf(radius);
}

module reg_polygon(sides,radius)
{
function dia(r) = sqrt(pow(r*2,2)/2); //sqrt((r*2^2)/2) if only we had an exponention op
if(sides<2) square([radius,0]);
if(sides==3) triangle(radius);
if(sides==4) square([dia(radius),dia(radius)],center=true);
if(sides>4) circle(r=radius,$fn=sides);
}  
