r=30;
size=112;
gap=0.25;
half_gap=gap/2;
size_hole_inside = 0.8; 

flat=1;
assembled=2;
withwalls=true;
wall_thickness=3;

part_layout=flat;

//your_shape_here();

part(1);
//part(2);
//part(3);
//part(4);



module your_shape_here()
{
	rotate(7)
	rotate([5,0,0])
	rotate([0,-10,0])
	translate([0,0,-6])
	scale([0.77,0.91,0.77])
	import("heart.stl");

//	translate([3,3,0])
//	sphere(r=r,$fn=80);

//	cube(r*2,center=true);
}

module part(part_number=1)
{
//	translate([((part_number==2)&&(part_layout==flat))?r*2.7:0,0,0])
//	translate(((part_number==3)&&(part_layout==flat))?[r*2.7,r*2,0]:[0,0,0])
//	translate(((part_number==4)&&(part_layout==flat))?[0,r*2,0]:[0,0,0])

	rotate([0,((part_number==2)&&(part_layout==flat))?180:0,0])

	rotate([0,((part_number==3)&&(part_layout==flat))?-90:0,0])

	rotate([0,((part_number==4)&&(part_layout==flat))?90:0,0])
	
	render()
	difference()
		{
		your_shape_here();

		if (part_number==1)
			{
			part_negative();
//			stamp();
			}
		else if (part_number==2)
 			{
			rotate([0,180,0])
			part_negative();
//			rotate([0,180,0])
//			stamp();
			}
		else if (part_number==3)
			rotate([0,90,0])
			rotate(180)
			mirror([1,0,0])
			part_negative();
		else if (part_number==4)
			rotate([0,90,0])
			rotate(180)
			mirror([1,0,0])
			rotate([0,180,0])
			part_negative();

           if (withwalls==false)
			scale([size_hole_inside,size_hole_inside,size_hole_inside])
			your_shape_here();
		else
		{
		render()	
      	difference()
			{
			scale([size_hole_inside,size_hole_inside,size_hole_inside])
			your_shape_here();
	 
			if (part_number==1)
				walls();
			else if (part_number==2)
 				rotate([0,180,0])
				walls();
			else if (part_number==3)
				rotate([0,90,0])
				rotate(180)
				mirror([1,0,0])
				walls();
			else if (part_number==4)
				rotate([0,90,0])
				rotate(180)
				mirror([1,0,0])
				rotate([0,180,0])
				walls();
			}
		}
		}	
}


module walls()
{
	render()
	union()
	{	
		translate([-size-r/2-half_gap,-size+half_gap+wall_thickness,-1-size])
		cube([2*size,size,2*size]);

 		translate([-wall_thickness,0,r/2-half_gap-wall_thickness])
		cube([size,size,size]);
	}
}

module part_negative()
{
	render()
	union()
	{			
	translate([-r/2-half_gap,-size+half_gap,-1])
	cube([size,size,size]);
	
	translate([0,0,-size/2+half_gap])
	cube([size,size,size],true);
	

	translate([-r/2,0,0])
	rotate([0,-45,0])
	translate([-half_gap,-r/2-gap+half_gap,-1])
	cube([size,r/2+gap,size]);
	
	translate([0,r/2-half_gap,r/2-half_gap])
	cube([size,size,size]);
	
	render ()
	intersection()
	{
		translate([-half_gap,-2,r/2-half_gap])
		cube([size,size,size]);
		
		translate([0,0,r/2])
		rotate([0,-45,0])
		translate([-1,-1,-half_gap])
		cube([size,size,size]);
	}
	}
}

//module stamp()
//{
//translate([0,-0.2,0])
//difference()
//{
//scale([0.7,0.7,0.7])
//import("B.stl");
//rotate([0,180,0])
//your_shape_here();
//}
//}

module assembled()
{
	part();
	rotate([0,180,0])
	part();
	
	rotate([0,90,0])
	rotate(180)
	mirror([1,0,0])
	{
		part();
		rotate([0,180,0])
		part();
	}
}