/*******************************************
 Open-face mold generator script
 Author: Jason Webb
 Website: http://cs.unk.edu/~webb
 Last revised: 9/28/2012
********************************************/
/**********************************
 Parameters
**********************************/
// Model parameters
model_filename = "Sample inputs/superformula-tray.stl";		// Model to place on base of mold
model_scale = 1;				// Scale factor for the model
model_translate = [-50,-34,5];		// Translation vector to move model around
model_rotate = [0,0,0];			// Rotational vector to apply to model

// Mold parameters
mold_width = 100;		// Width of the mold
mold_height = 70;		// Height of the mold
mold_depth = 10;

generate_mold();

/*********************************************************
 Create a single, open-face mold surrounding an external STL file. 
**********************************************************/
module generate_mold() {
	difference() {
		translate([0, 0, mold_depth/2])
			cube([mold_width, mold_height, mold_depth], center = true);

		// Scale, translate and import an external STL
		scale(model_scale)
			translate(model_translate)
				rotate(model_rotate)
					import(model_filename);
	}
}