/*

a recursive snowflake made entirely of hexagons

openSCAD code courtesy of D J Moews

hexagonal holes have been created
so that the snowflake can be hung
as an ornament

replace hexagon_less calls with
hexagon calls for a snowflake
without holes

The module sixfold() creates a recursive tree of 
hexagons, with maximum tree level up to 3

The parameters to the module sixfold() are:

ht --- height of snowflake
rr --- level 0 basic unit of length
        (the basic unit is used for translations between one level and its successor)
s1a --- side of level 0 hexagon, as fraction of level 0 basic unit
s1b --- ratio by which basic unit decreases between level 0 and level 1
s2a --- side of level 1 hexagon, as fraction of level 1 basic unit
s2b --- ratio by which basic unit decreases between level 1 and level 2
s3a --- side of level 2 hexagon, as fraction of level 2 basic unit
s3b --- side of level 3 hexagon, as fraction of level 3 basic unit
jj --- number of maximum level to use

pcm

*/



sixfold(3, 25, 0.36, 0.5, 0.73, 0.4, 0.73, 0.36, 3);


module sixfold(ht, rr, s1a, s1b, s2a, s2b, s3a, s3b, jj)
{
  if (jj == 0)
  {
     hexagon_less(rr*s1a,ht);
  } else
  {
   union() {
    for( j = [
           [0,0,0],
          [0,0,60],
                   [0,0,120],
         [0,0,180],
                    [0,0,240],
        [0,0,300]
                    ])
      {
        rotate(j)
       union() {
         hexagon_less(rr*s1a,ht);
         translate([rr,0,0])
            sixfold2(ht, rr*s1b, s2a, s2b, s3a, s3b, jj-1);
      }
    }
  }
  }
}

module sixfold2(ht, rr, s1a, s1b, s2a, s2b, jj)
{
   if (jj == 0)
  {
     hexagon_less(rr*s1a,ht);
  } else
  {
   union() {
    for( j = [
           [0,0,0],
          [0,0,60],
                   [0,0,120],
         [0,0,180],
                    [0,0,240],
        [0,0,300]
                    ])
      {
        rotate(j)
       union() {
         hexagon_less(rr*s1a,ht);
         translate([rr,0,0])
            sixfold3(ht, rr*s1b, s2a, s2b, jj-1);
      }
    }
  }
  }
}

module sixfold3(ht, rr, s1a, s1b,  jj)
{
   if (jj == 0)
  {
     hexagon_less(rr*s1a,ht);
  } else
  {
   union() {
    for( j = [
           [0,0,0],
          [0,0,60],
                   [0,0,120],
         [0,0,180],
                    [0,0,240],
        [0,0,300]
                    ])
      {
        rotate(j)
       union() {
         hexagon_less(rr*s1a,ht);
         translate([rr,0,0])
            hexagon( rr*s1b, ht);
      }
    }
  }
  }
}


module hexagon(rr,ht)
{

linear_extrude(height=ht)

polygon([
          [ rr,0 ],
           [ .5*rr, (sqrt(3)/2)*rr],
           [-0.5*rr,(sqrt(3)/2)*rr],
           [- rr,0 ],
           [-0.5*rr, -(sqrt(3)/2)*rr],
           [0.5*rr,-(sqrt(3)/2)*rr],
           [rr,0],
           ]);
}


module hexagon_less(rr,ht)
{
difference()
{
hexagon(rr,ht);

translate([0,0,-1])
scale([.45,.45,1])
hexagon(rr,ht+2);
}}


