/*

a recursive snowflake made entirely of hypocycloids

openSCAD code courtesy of D J Moews

hypocycloid holes have been created
so that the snowflake can be hung
as an ornament

replace hypo_less calls with
hypo calls for a snowflake
without holes

The module sixfold() creates a recursive tree of 
hypocycloids, with maximum tree level up to 3

The parameters to the module sixfold() are:

ht --- height of snowflake
rr --- level 0 basic unit of length
        (the basic unit is used for translations between one level and its successor)
s1a --- size of level 0 hypocycloid, as fraction of level 0 basic unit
s1b --- ratio by which basic unit decreases between level 0 and level 1
s2a --- size of level 1 hypocycloid, as fraction of level 1 basic unit
s2b --- ratio by which basic unit decreases between level 1 and level 2
s3a --- size of level 2 hypocycloid, as fraction of level 2 basic unit
s3b --- size of level 3 hypocycloid, as fraction of level 3 basic unit
jj --- number of maximum level to use


pcm

*/



sixfold(3, 25, 0.36, 0.5, 0.73, 0.4, 0.73, 0.36, 3);



module sixfold(ht, rr, s1a, s1b, s2a, s2b, s3a, s3b, jj)
{
  if (jj == 0)
  {
     hypo_less(rr*s1a,ht);
  } else
  {
   union() {
    for( j = [
           [0,0,0],
          [0,0,60],
                   [0,0,120],
         [0,0,180],
                    [0,0,240],
        [0,0,300]
                    ])
      {
        rotate(j)
       union() {
         hypo_less(rr*s1a,ht);
         translate([rr,0,0])
            sixfold2(ht, rr*s1b, s2a, s2b, s3a, s3b, jj-1);
      }
    }
  }
  }
}

module sixfold2(ht, rr, s1a, s1b, s2a, s2b, jj)
{
   if (jj == 0)
  {
     hypo_less(rr*s1a,ht);
  } else
  {
   union() {
    for( j = [
           [0,0,0],
          [0,0,60],
                   [0,0,120],
         [0,0,180],
                    [0,0,240],
        [0,0,300]
                    ])
      {
        rotate(j)
       union() {
         hypo_less(rr*s1a,ht);
         translate([rr,0,0])
            sixfold3(ht, rr*s1b, s2a, s2b, jj-1);
      }
    }
  }
  }
}

module sixfold3(ht, rr, s1a, s1b,  jj)
{
   if (jj == 0)
  {
     hypo_less(rr*s1a,ht);
  } else
  {
   union() {
    for( j = [
           [0,0,0],
          [0,0,60],
                   [0,0,120],
         [0,0,180],
                    [0,0,240],
        [0,0,300]
                    ])
      {
        rotate(j)
       union() {
         hypo_less(rr*s1a,ht);
         translate([rr,0,0])
            hypo( rr*s1b, ht);
      }
    }
  }
  }
}




module hypo_less(rr,ht)
{
difference()
{
hypo(rr,ht);

translate([0,0,-1])
scale([.4,.4,1])
hypo(rr,ht+2);
}}


module hypo(n,ht1)
{


/*

parametric equations are:

x = n * cos(t) + b * cos(nt/b)
y = n * sin(t) - b * sin(nt/b)


 n = a - b

special cases -

circle b = 0

segment of a line a = 2 * b

deltoid  a = 3 * b

astroid  a = 4 * b

n/b + 1 cusps if n/b is integer

symmetric about x axis

also symmetric about y axis if n/b is an odd integer


*/
 b = n/5;
t = 5;


linear_extrude(height=ht1)

polygon ([

            [cos(-36*t)*n + b*cos(-36*(n*t/b)),n*sin(-36*t) - b*sin(-36*(n*t/b))],
            [cos(-35*t)*n + b*cos(-35*(n*t/b)),n*sin(-35*t) - b*sin(-35*(n*t/b))],
            [cos(-34*t)*n + b*cos(-34*(n*t/b)),n*sin(-34*t) - b*sin(-34*(n*t/b))],
            [cos(-33*t)*n + b*cos(-33*(n*t/b)),n*sin(-33*t) - b*sin(-33*(n*t/b))],
            [cos(-32*t)*n + b*cos(-32*(n*t/b)),n*sin(-32*t) - b*sin(-32*(n*t/b))],
            [cos(-31*t)*n + b*cos(-31*(n*t/b)),n*sin(-31*t) - b*sin(-31*(n*t/b))],
            [cos(-30*t)*n + b*cos(-30*(n*t/b)),n*sin(-30*t) - b*sin(-30*(n*t/b))],
            [cos(-29*t)*n + b*cos(-29*(n*t/b)),n*sin(-29*t) - b*sin(-29*(n*t/b))],
            [cos(-28*t)*n + b*cos(-28*(n*t/b)),n*sin(-28*t) - b*sin(-28*(n*t/b))],
            [cos(-27*t)*n + b*cos(-27*(n*t/b)),n*sin(-27*t) - b*sin(-27*(n*t/b))],
            [cos(-26*t)*n + b*cos(-26*(n*t/b)),n*sin(-26*t) - b*sin(-26*(n*t/b))],
            [cos(-25*t)*n + b*cos(-25*(n*t/b)),n*sin(-25*t) - b*sin(-25*(n*t/b))],
            [cos(-24*t)*n + b*cos(-24*(n*t/b)),n*sin(-24*t) - b*sin(-24*(n*t/b))],
            [cos(-23*t)*n + b*cos(-23*(n*t/b)),n*sin(-23*t) - b*sin(-23*(n*t/b))],
            [cos(-22*t)*n + b*cos(-22*(n*t/b)),n*sin(-22*t) - b*sin(-22*(n*t/b))],
            [cos(-21*t)*n + b*cos(-21*(n*t/b)),n*sin(-21*t) - b*sin(-21*(n*t/b))],
            [cos(-20*t)*n + b*cos(-20*(n*t/b)),n*sin(-20*t) - b*sin(-20*(n*t/b))],
            [cos(-19*t)*n + b*cos(-19*(n*t/b)),n*sin(-19*t) - b*sin(-19*(n*t/b))],
            [cos(-18*t)*n + b*cos(-18*(n*t/b)),n*sin(-18*t) - b*sin(-18*(n*t/b))],
            [cos(-17*t)*n + b*cos(-17*(n*t/b)),n*sin(-17*t) - b*sin(-17*(n*t/b))],
            [cos(-16*t)*n + b*cos(-16*(n*t/b)),n*sin(-16*t) - b*sin(-16*(n*t/b))],
            [cos(-15*t)*n + b*cos(-15*(n*t/b)),n*sin(-15*t) - b*sin(-15*(n*t/b))],
            [cos(-14*t)*n + b*cos(-14*(n*t/b)),n*sin(-14*t) - b*sin(-14*(n*t/b))],
            [cos(-13*t)*n + b*cos(-13*(n*t/b)),n*sin(-13*t) - b*sin(-13*(n*t/b))],
            [cos(-12*t)*n + b*cos(-12*(n*t/b)),n*sin(-12*t) - b*sin(-12*(n*t/b))],
            [cos(-11*t)*n + b*cos(-11*(n*t/b)),n*sin(-11*t) - b*sin(-11*(n*t/b))],
            [cos(-10*t)*n + b*cos(-10*(n*t/b)),n*sin(-10*t) - b*sin(-10*(n*t/b))],
            [cos(-9*t)*n + b*cos(-9*(n*t/b)),n*sin(-9*t) - b*sin(-9*(n*t/b))],
            [cos(-8*t)*n + b*cos(-8*(n*t/b)),n*sin(-8*t) - b*sin(-8*(n*t/b))],
            [cos(-7*t)*n + b*cos(-7*(n*t/b)),n*sin(-7*t) - b*sin(-7*(n*t/b))],
            [cos(-6*t)*n + b*cos(-6*(n*t/b)),n*sin(-6*t) - b*sin(-6*(n*t/b))],
            [cos(-5*t)*n + b*cos(-5*(n*t/b)),n*sin(-5*t) - b*sin(-5*(n*t/b))],
            [cos(-4*t)*n + b*cos(-4*(n*t/b)),n*sin(-4*t) - b*sin(-4*(n*t/b))],
            [cos(-3*t)*n + b*cos(-3*(n*t/b)),n*sin(-3*t) - b*sin(-3*(n*t/b))],
            [cos(-2*t)*n + b*cos(-2*(n*t/b)),n*sin(-2*t) - b*sin(-2*(n*t/b))],
            [cos(-1*t)*n + b*cos(-1*(n*t/b)),n*sin(-1*t) - b*sin(-1*(n*t/b))],
            [cos(0*t)*n + b*cos(0*(n*t/b)),n*sin(0*t) - b*sin(0*(n*t/b))],
            [cos(1*t)*n + b*cos(1*(n*t/b)),n*sin(1*t) - b*sin(1*(n*t/b))],
            [cos(2*t)*n + b*cos(2*(n*t/b)),n*sin(2*t) - b*sin(2*(n*t/b))],
            [cos(3*t)*n + b*cos(3*(n*t/b)),n*sin(3*t) - b*sin(3*(n*t/b))],
            [cos(4*t)*n + b*cos(4*(n*t/b)),n*sin(4*t) - b*sin(4*(n*t/b))],
            [cos(5*t)*n + b*cos(5*(n*t/b)),n*sin(5*t) - b*sin(5*(n*t/b))],
            [cos(6*t)*n + b*cos(6*(n*t/b)),n*sin(6*t) - b*sin(6*(n*t/b))],
            [cos(7*t)*n + b*cos(7*(n*t/b)),n*sin(7*t) - b*sin(7*(n*t/b))],
            [cos(8*t)*n + b*cos(8*(n*t/b)),n*sin(8*t) - b*sin(8*(n*t/b))],
            [cos(9*t)*n + b*cos(9*(n*t/b)),n*sin(9*t) - b*sin(9*(n*t/b))],
            [cos(10*t)*n + b*cos(10*(n*t/b)),n*sin(10*t) - b*sin(10*(n*t/b))],
            [cos(11*t)*n + b*cos(11*(n*t/b)),n*sin(11*t) - b*sin(11*(n*t/b))],
            [cos(12*t)*n + b*cos(12*(n*t/b)),n*sin(12*t) - b*sin(12*(n*t/b))],
            [cos(13*t)*n + b*cos(13*(n*t/b)),n*sin(13*t) - b*sin(13*(n*t/b))],
            [cos(14*t)*n + b*cos(14*(n*t/b)),n*sin(14*t) - b*sin(14*(n*t/b))],
            [cos(15*t)*n + b*cos(15*(n*t/b)),n*sin(15*t) - b*sin(15*(n*t/b))],
            [cos(16*t)*n + b*cos(16*(n*t/b)),n*sin(16*t) - b*sin(16*(n*t/b))],
            [cos(17*t)*n + b*cos(17*(n*t/b)),n*sin(17*t) - b*sin(17*(n*t/b))],
            [cos(18*t)*n + b*cos(18*(n*t/b)),n*sin(18*t) - b*sin(18*(n*t/b))],
            [cos(19*t)*n + b*cos(19*(n*t/b)),n*sin(19*t) - b*sin(19*(n*t/b))],
            [cos(20*t)*n + b*cos(20*(n*t/b)),n*sin(20*t) - b*sin(20*(n*t/b))],
            [cos(21*t)*n + b*cos(21*(n*t/b)),n*sin(21*t) - b*sin(21*(n*t/b))],
            [cos(22*t)*n + b*cos(22*(n*t/b)),n*sin(22*t) - b*sin(22*(n*t/b))],
            [cos(23*t)*n + b*cos(23*(n*t/b)),n*sin(23*t) - b*sin(23*(n*t/b))],
            [cos(24*t)*n + b*cos(24*(n*t/b)),n*sin(24*t) - b*sin(24*(n*t/b))],
            [cos(25*t)*n + b*cos(25*(n*t/b)),n*sin(25*t) - b*sin(25*(n*t/b))],
            [cos(26*t)*n + b*cos(26*(n*t/b)),n*sin(26*t) - b*sin(26*(n*t/b))],
            [cos(27*t)*n + b*cos(27*(n*t/b)),n*sin(27*t) - b*sin(27*(n*t/b))],
            [cos(28*t)*n + b*cos(28*(n*t/b)),n*sin(28*t) - b*sin(28*(n*t/b))],
            [cos(29*t)*n + b*cos(29*(n*t/b)),n*sin(29*t) - b*sin(29*(n*t/b))],
            [cos(30*t)*n + b*cos(30*(n*t/b)),n*sin(30*t) - b*sin(30*(n*t/b))],
            [cos(31*t)*n + b*cos(31*(n*t/b)),n*sin(31*t) - b*sin(31*(n*t/b))],
            [cos(32*t)*n + b*cos(32*(n*t/b)),n*sin(32*t) - b*sin(32*(n*t/b))],
            [cos(33*t)*n + b*cos(33*(n*t/b)),n*sin(33*t) - b*sin(33*(n*t/b))],
            [cos(34*t)*n + b*cos(34*(n*t/b)),n*sin(34*t) - b*sin(34*(n*t/b))],
            [cos(35*t)*n + b*cos(35*(n*t/b)),n*sin(35*t) - b*sin(35*(n*t/b))],
            [cos(36*t)*n + b*cos(36*(n*t/b)),n*sin(36*t) - b*sin(36*(n*t/b))],


         ]);

}






