
/*
Polishable whistle
easy filing of channel & blade
custom Rotor addable
adjustable widow length

> channel will add vertikal flanks for filament piece holding
(filament as moving part) 


 full channel needed => exac t center :)
   channel longer than rail -> thinner rounder :)


# make channel 45° at the ends so that no support will be in the channel !!
# add support structures for the two sliders - NO use autosupport.
# round rail ends

# make overhangfree version for singleprint?
# thicken but not widen!! channel linearly on entry side 

MAYBE
two tiny cylinders in hull of rail??
# some snapfit
# make 3 oval O rings for hold together and maybe add a rail like structure in minus x direction  ?
    > eiter glue or - YES glue & weld
# round mouthpiece maybe
# cut endorsing colorholes (side part removal ok) easy!
# maybe slant window walls (outward on channel slider inward on blade slider)

LATER!
# add mechanism
(a lever with common rotation point above blade slider)
that changes the resonant volume and window size at the same time with different rates
   in a matched way for maximum loudness at any frequency
   push1 push5 / pull1 pull5 (lock channelpos)
*/

// compensate for pegvolume loss rmain=0.75
// cutvolumgain! 

// 11x5

trail = 6; // 7 t_rail (-2?) <<<<<<<<<<<<<<<<<<
lrail = 50;

wwindow = 11; // width of window
lwindow = 5; // ??   TO IMPLEMENT
wchannel = wwindow;
tchannel = 1.33; // 1 critical
lchannel = 50;
lblade = 40; // the whole blade-stick
ledge = trail*0.75; // lendth of the sharp edge -- atan
// if channelshift>0: edge jumps why? solve! leglength changes too :(
railshift = 18; // shift ro hold channel & blade equally well

shift = 3; // positioning offset from center for demo
channelshift = lwindow/2+shift; // helper value
bladeshift = lwindow/2-shift; // helper value


eps=0.01;

dplug = 0;
t = 1.5; // main wall thickness (keep changes slidersize)
dt = 0.75; // additional wallthickness
rmain = 25/2+0.75*0; // outer main chamber radius
rin = rmain-t; // inner main chamber radius
hin = 20-5; // main hight

dpin = 8;
dpeg = 7; rpeg=dpeg/2;
s0 = rin-rpeg;
s1 = s0*0.75; //7 ??

h0 = hin/2+s1+t+dplug;

$fa = 360/60;
$fs = 0.3;

f=1.5; // cone channel widening

clear=0.1;

lchannellegs = rin*2-t;
lbladeprotrusion = lchannellegs; // includes

debug=false;


// ##################################################
demo();
//halve();
//channelslider(false);
//bladeslider(false);
//scale([-1,1,1]) halve();
// ###################################################


module demo()
{
  translate([0,0,2*h0+0]) scale([1,1,-1]) halve();
  color("orange") halve();
  channelslider(false);
  bladeslider(false);
}


module channelslider(support=false)
{
  translate([0,rin-channelshift,0])
  difference()
  {
    color("darkslateblue") translate([0,-lchannel/2-rin+lchannellegs,0])
      rail(lchannel,clear-eps);

    color("darkslateblue") translate([0+rin,0,h0])
    hull()
    {
      cube([20,2*rin-t,wchannel],center=true); // window wide z
      cube([20,2*rin,wchannel-t],center=true); // window long y
    }
    // make the channel conical later?
    color("blue")
    translate([0+rin,-lchannel/2,h0]) // <<<<<<<<<<<<<<<<<<< conify
      translate([0,-1.5*t,0])
    {
      hull()
      {
        cube([tchannel,(lchannel+2*t)-lchannellegs+2*eps+t,wchannel-2*eps],center=true);
        translate([0,-((lchannel+2*t)-lchannellegs+2*eps)/2,0])
          cube([tchannel*f,eps,wchannel-2*eps],center=true);
      }
      // maybe the following has to be deactivated for functionality  
      // V-groove overhang mending to avoids support material in the channel
      translate([0,t/4,wchannel/2]) rotate(-90,[1,0,0])
        cylinder(r1=tchannel/2*f,r2=tchannel/2,h=(lchannel+2*t)-lchannellegs+t/2+2*eps,center=true,$fn=4);   
      translate([0,t/4,-wchannel/2]) rotate(-90,[1,0,0])
        cylinder(r1=tchannel/2*f,r2=tchannel/2,h=(lchannel+2*t)-lchannellegs+t/2+2*eps,center=true,$fn=4);
      // edge softening to avoid turbolences
      translate([0,+((lchannel+2*t)-lchannellegs+2*eps)/2+lwindow/2-eps,wchannel/2]) rotate(-90,[1,0,0])
        cylinder(r1=tchannel/2,r2=0,h=lwindow-t,center=true,$fn=4);   
      translate([0,+((lchannel+2*t)-lchannellegs+2*eps)/2+lwindow/2-eps,-wchannel/2]) rotate(-90,[1,0,0])
        cylinder(r1=tchannel/2,r2=0,h=lwindow-t,center=true,$fn=4);
  
    }
  }
}

module bladeslider(support=false)
{
  scale([1,-1,1]) 
  translate([0,-bladeshift,0])
  {
  // blades edge
  color("red")
  translate([rin,-ledge,h0]) scale([(trail-2*clear),2*ledge,1]) // incorrect!!
  rotate(45,[0,0,1])
    cube([1/sqrt(2),1/sqrt(2),wchannel-2*eps],center=true);

  difference()
  {
    color("green") translate([0,-ledge,0])
    translate([0,-((lblade-ledge+2*t)/2)+t,0])
      rail(lblade-ledge,clear);

    // cut off sides (upper)
    translate([0+rin,+rin-lbladeprotrusion,h0+wchannel])
    hull()
    {
      cube([20,2*rin-t,wchannel],center=true);
      cube([20,2*rin,wchannel-t],center=true);
    }
    // cut off sides (lower)
    translate([0+rin,+rin-lbladeprotrusion,h0-wchannel])
    hull()
    {
      cube([20,2*rin-t,wchannel],center=true);
      cube([20,2*rin,wchannel-t],center=true);
    }
  }
  }
}


module halve()
{

difference()
{

  difference()
  {
    union()
    {
      hull() // main body
      {
        translate([0,0,s1-2*t])
        cylinder(r=rmain+dt,h=h0-s1+2*t);
        cylinder(r=rmain-s1+2*t,h=h0);
      }
      translate([0,lrail/2-railshift,0])
      hull() // outer rail hull
      {
        translate([rin,0,h0/2])
          cube([trail,lrail,h0],center=true);
        translate([rin,0,(h0+(s1-2*t))/2])
          cube([trail+2*t+2*dt,lrail,h0-(s1-2*t)],center=true);
        translate([rin,0,(h0+(s1-2*t))/2])
          cube([trail,lrail+2*t,h0-(s1-2*t)],center=true);
      } 
    }
    // endorsement cut
    translate([rin,lrail/2+railshift/2-t/2,h0]) scale([1,0.75,1]) rotate(90,[0,1,0]) 
      cylinder(r=hin/2,h=2*trail,center=true,$fn=32);
    
    translate([0,railshift/2,0]) // ??
      rail(lrail*2,0); // rail cutter
  
    //rail main opening
    translate([5+rin,0,h0+s1/2])
    hull()
    {
      cube([10,2*rin-2*t,h0*2],center=true);
      cube([10,2*rin,h0*2-2*t],center=true);
    }
    difference() // main ring cavity
    {
      translate([0,0,t+s1/2])
      cylinder(r=rin,h=h0);
      translate([0,0,s1/2])
      #cylinder(r=rpeg,h=h0-s1/2); 
    }
  
    translate([0,0,-eps]) // incone material saving
    cylinder(r1=rpeg+s0/2-1,r2=0,h=s1-1); 
  
    //debug cut in halve <<<<<<<<<<<<<<<<<<<<<<<
    if(debug)
    {
      translate([-h0,0,h0/2])
      cube([2*h0,2*h0,2*h0],center=true);
    }
  
    translate([0,0,t]) // sealing slants
    scale([1,1,s1/s0])
      quatorus(rpeg+s0/2,s0/sqrt(2),64);
  }
  translate([0,0,0]) // mount or thread hole
    cylinder(r=1.75,h=(h0-s1/2)*1.5); // <<< use
}
}



// assymertic! beveled at neg y
module rail(l,clr = 0)
{
  hull() // rail channel
  {
    translate([rin,0,h0]) // widest z
      cube([trail-2*t-2*clr,l+eps,2*h0-2*t-2*clr],center=true);
    translate([rin,0,h0]) // thickest x
      cube([trail-2*clr,l+eps,2*h0-2*t-s1-2*clr],center=true);
    translate([rin,0-t,h0]) // longest y
      cube([trail-2*t-2*clr,l+eps+2*t,2*h0-2*t-s1-2*clr],center=true);
  } 
}

module quatorus(rbig,rsmall,vert)
{
  rotate_extrude($fn=vert,convexity=5)
  translate([rbig,0,0])
  rotate(45,[0,0,1])
  square(rsmall);
}

//translate([40,0,0]) ringclamp1();

module ringclamp1(l=12,w=6,h=4,t=1)
{
  difference()
  {
    union()
    {
      hull()
      {
        cube([l+2*t,w,h],center=true);
        cube([l,w+2*t,h],center=true);
        cube([l+2*t,w+t,h/3],center=true);
      }
      hull()
      {
        translate([0,+(w/2+2),0]) cylinder(r=1+t,h=h,center=true);
        translate([0,-(w/2+2),0]) cylinder(r=1+t,h=h,center=true);
      }
    }
    cube([l,w,2*h],center=true);

    hull()
    {
      translate([0,+(w/2+2),0]) cylinder(r=1,h=2*h,center=true);
      translate([0,-(w/2+2),0]) cylinder(r=1,h=2*h,center=true);
    }
  }
}
