// License CC-BY-SA
// Please do more!

// w is narrow dim
// l is long dim
// t is thickness

$fn=24;

cuvette = [16.3, 103, 15]; // [diameter, height, z_beam] z_beam is the distance from the bottom of the vial to the beam

w_brd_led_sens = 26.4;
l_brd_led_sens = 45.6;
t_brd_led_sens = 1.5;
d_holes_led_sens = 3;

//holes are square off corners:
offset_holes_led_sens = 2.5;
// The LED and sensor are 5.5 mm off center, low on the proto boards:
center_brd_led_sens = [l_brd_led_sens/2, w_brd_led_sens/2-5.5]; // l, w 
dims_connector = [9.3, 20.5, 9];
offset_connector = [29.5, 3.25]; // l, w with text normal
offset_pins_led_sens = [36.4, 8.5]; // l, w with text normal
pins_pitch = 2.54;

pad_led_sens = 1;
t_wall = 3;

r_corner_case_o = 4;
r_corner_case_i = r_corner_case_o-t_wall;
x_case_o = l_brd_led_sens+2*(t_wall+pad_led_sens+2*r_corner_case_o);
y_case_o = x_case_o;
z_case_o = w_brd_led_sens+2*(t_wall+pad_led_sens);
x_case_i = x_case_o-2*t_wall;
y_case_i = x_case_i;
z_case_i = z_case_o;
overhang_case_top = 4;
r_corner_case_top = r_corner_case_o+overhang_case_top;
z_case_top = t_wall*3;
d_cover_holes = 3;
xy_scale = 1.01;
indent_lid = 2;

z_sensor_center = t_wall+pad_led_sens+center_brd_led_sens[1];
echo("sensor distance from bottom=", z_sensor_center-t_wall);

// cuvette holder dims
overlap_holder = 4;
xmaj_holder = 28;
xmin_holder = xmaj_holder-2*overlap_holder;
y_holder = 20;
z_holder = z_case_i+z_case_top-2*t_wall;
d_lightpath = 6;
depth_sensor = (z_sensor_center-t_wall<cuvette[2]) ? z_sensor_center-t_wall : cuvette[2];
echo("depth sensor",depth_sensor);

// lid dims
x_dim_lid = x_case_o/1.5;
y_dim_lid = y_case_o/1.5;
r_corner_lid_o = 5;
r_corner_lid_i = r_corner_lid_o-t_wall;

z_dim_lid = cuvette[1]-2*r_corner_lid_o-depth_sensor+indent_lid+t_wall-3*t_wall;
echo("z_dim_lid=", z_dim_lid);
x_brds = t_wall+pad_led_sens+2*r_corner_case_o;


module big_plate() {
	case(0);
	
	translate([-40, -45, 0])
		lid();
	
	
	translate([4, -20, z_case_top])
		rotate([180, 0, 0])
			top();
	
	
	translate([-50, 40, z_holder+t_wall])
		rotate([180, 0, 0])
			difference() {
				holder_body(d_lightpath);
			
				translate([xmaj_holder/2, y_holder/2, 0])
					scale([1.05, 1.05, 1])
						vial_cylindrical(cuvette);
			}
}

module assembly() {
	difference() {
		union(){
			case(0);
			
			translate ([0, 0, z_case_o])
				top();
			
			translate([(x_case_o-xmaj_holder)/2, (y_case_o-y_holder-t_wall)/2, t_wall])
				difference() {
					holder_body(d_lightpath);
			
					translate([xmaj_holder/2, y_holder/2, 0])
						scale([1.05, 1.05, 1])
							vial_cylindrical(cuvette);
				}
		}

	//following makes a cutaway on the y axis, midpoint	
	//	translate([x_case_o/2, -150, -1])
	//		cube([300, 300, 300]);
	}
}

module lid() {

	translate([-x_dim_lid/2+r_corner_lid_o, -y_dim_lid/2+r_corner_lid_o, 0])
		difference() {
			translate([0, 0, r_corner_lid_o])
				round_box(x_dim_lid, y_dim_lid, z_dim_lid+2*r_corner_lid_o-t_wall+5, r_corner_lid_o);

			translate([0, 0, r_corner_lid_i+t_wall])
				round_box(x_dim_lid-2*t_wall, y_dim_lid-2*t_wall, z_dim_lid+2*r_corner_lid_i-t_wall+5, r_corner_lid_i);

			translate([-r_corner_lid_o-1, -r_corner_lid_o-1, z_dim_lid+5])
				cube([x_dim_lid+2, y_dim_lid+2, r_corner_lid_o*2]);
		}
}

module round_box(x, y, z, r) {
	minkowski() {
		cube([x-2*r, y-2*r, z-2*r]);
	
		sphere(r=r);
	}
}

module vial_cylindrical(dims) {
	if(dims[2]>z_sensor_center-t_wall) {
		echo("insufficient z for desired depth");
		translate([0, 0, dims[0]/2]){
			sphere(r=dims[0]/2);
		
			cylinder(r=dims[0]/2, h=dims[1]);
		}
	}
	else {
		translate([0, 0, dims[0]/2+t_wall+pad_led_sens+center_brd_led_sens[1]-dims[2]]){
			sphere(r=dims[0]/2);
		
			cylinder(r=dims[0]/2, h=dims[1]);
		}

	}
}

module top() {
	xyscale_holder = 1.05;

	difference() {
		translate([r_corner_case_o, r_corner_case_o, 0])
				difference() {
					minkowski() {
						cube([x_case_o-2*r_corner_case_o, y_case_o-2*r_corner_case_o, z_case_top/2]);

						//sphere(r=r_corner_case_top);
						cylinder(r1=r_corner_case_top, r2=r_corner_case_o, h=z_case_top/2);
					}
			
					translate([-x_case_o*(xy_scale-1), -x_case_o*(xy_scale-1), -1])
						scale([xy_scale, xy_scale, (t_wall+1)/z_case_o])
							exterior();
			
				}
	
		// holes and nut trap for cover screws
		translate([r_corner_case_o, r_corner_case_o, -1])
				cylinder(r=d_cover_holes/2, h= z_case_top+2);

		translate([x_case_o-r_corner_case_o, r_corner_case_o, -1])
				cylinder(r=d_cover_holes/2, h= z_case_top+2);

		translate([x_case_o-r_corner_case_o, y_case_o-r_corner_case_o, -1])
				cylinder(r=d_cover_holes/2, h= z_case_top+2);

		translate([r_corner_case_o, y_case_o-r_corner_case_o, -1])
				cylinder(r=d_cover_holes/2, h= z_case_top+2);

		// cuvette holder cutout
		translate([(x_case_o-xmaj_holder*xyscale_holder)/2, (y_case_o-y_holder*xyscale_holder-t_wall)/2, -t_wall*2])
			scale([xyscale_holder, xyscale_holder, 1])
				holder_body(0);

		// lid indent
		translate([(x_case_o-x_dim_lid+2*r_corner_lid_o)/2, (y_case_o-y_dim_lid+2*r_corner_lid_o)/2, z_case_top-indent_lid])
			difference() {
				minkowski() {
					cube([x_dim_lid-2*r_corner_lid_o, y_dim_lid-2*r_corner_lid_o, 5]);
	
					cylinder(r=r_corner_lid_o+0.5, h=5);
				}

				translate([0.5, 0.5, 0])
					minkowski() {
						cube([x_dim_lid-2*(r_corner_lid_i+t_wall)-1, y_dim_lid-2*(r_corner_lid_i+t_wall)-1, 5]);
		
						cylinder(r=r_corner_lid_i, h=5);
					}
	
			}
	}
}

module holder_body(d_beam) {
	r_corner = 2;
	overlap = 4;

	translate([-overlap/2, -overlap/2, z_holder])
		minkowski() {
			cube([xmaj_holder+2*overlap-2*r_corner, y_holder+2*overlap-2*r_corner, t_wall/2]);
	
			cylinder(r=r_corner, h=t_wall/2);
		}

	difference() {
		cube([xmaj_holder, y_holder, z_holder+1]);
	
		translate([-1, y_holder/2, -1])
			cube([overlap_holder+1, y_holder, z_holder+1]);
	
		translate([xmaj_holder-overlap_holder, y_holder/2, -1])
			cube([overlap_holder+1, y_holder, z_holder+1]);
	
		// light path
			translate([xmaj_holder/2, -1, z_sensor_center])
				rotate([270, 0, 0])
					cylinder(r=d_beam/2, h=y_holder+2);
	}
}

module case(show_brds=1) {
	xyscale_holder = 1.05;

	difference() {
		// exterior
		translate([r_corner_case_o, r_corner_case_o, 0])
			exterior();

		// interior
		translate([t_wall, t_wall, t_wall])
			interior(3.5);

		// hole for cable
		translate([23, y_case_i+t_wall-1, 17])
			rotate([270, 0, 0])
				cylinder(r=4, h=t_wall+2);

		// mounting holes for boards
		translate([x_brds, -1, t_wall+2*pad_led_sens+w_brd_led_sens])
			rotate([270, 0, 0])
				led_sens_brd_holes(y_case_o+2);

		// holes and nut trap for cover screws
		translate([r_corner_case_o, r_corner_case_o, z_case_o])
			rotate([0, 0, 45])
				boss();

		translate([x_case_o-r_corner_case_o, r_corner_case_o, z_case_o])
			rotate([0, 0, 135])
				boss();

		translate([x_case_o-r_corner_case_o, y_case_o-r_corner_case_o, z_case_o])
			rotate([0, 0, 225])
				boss();

		translate([r_corner_case_o, y_case_o-r_corner_case_o, z_case_o])
			rotate([0, 0, 315])
				boss();

		if (show_brds == 0) {
			// opening for 10 pin connector on sensor board
//			translate([x_case_o-x_brds, y_case_o-t_wall-pad_led_sens, t_wall+2*pad_led_sens+w_brd_led_sens])
//				rotate([90, 180, 0])
//					board_led_sens(0, 0); // arg is which board, 1 for led, anything else for sensor
		}
	}
	
	// center baffle
	translate([0, (x_case_o-t_wall)/2, 0])
		difference() {
			union() {
				cube([x_case_o, t_wall, z_case_o]);

				translate([(x_case_o-(xmin_holder*xyscale_holder+2*t_wall))/2, 0, 0])
					cube([xmin_holder*xyscale_holder+2*t_wall, y_holder*xyscale_holder/2+t_wall, z_case_o]);
			}
	
			//opening for cuvette holder
			translate([(x_case_o-xmaj_holder*xyscale_holder)/2, -y_holder*xyscale_holder/2, 0])
				scale([xyscale_holder, xyscale_holder, 1])
					holder_body(0);

			translate([(x_case_o-(xmin_holder*xyscale_holder+2*t_wall))/2-1, t_wall, overlap_holder*2])
				cube([xmin_holder*xyscale_holder+2*t_wall+2, y_holder*xyscale_holder/2+t_wall+2, z_case_o]);

			// hole for wire
			translate([x_case_o-t_wall-8, -1, z_case_o/2])
				rotate([270, 0, 0])
					cylinder(r=2, h=t_wall+2);
		}

	if (show_brds != 0) {
		translate([x_brds, t_wall+pad_led_sens, t_wall+2*pad_led_sens+w_brd_led_sens])
			rotate([270, 0, 0])
				#board_led_sens(1, 0); // arg is which board, 1 for led, anything else for sensor
		
		translate([x_case_o-x_brds, y_case_o-t_wall-pad_led_sens, t_wall+2*pad_led_sens+w_brd_led_sens])
			rotate([90, 180, 0])
				#board_led_sens(0, 0); // arg is which board, 1 for led, anything else for sensor
	}
}

module exterior() {
	minkowski() {
		cube([x_case_o-r_corner_case_o*2, y_case_o-r_corner_case_o*2, z_case_o/2]);

		cylinder(r=r_corner_case_o, h=z_case_o/2);
	}
}

module interior(standoffs=1) {
	difference() {
		cube([x_case_i, y_case_i, z_case_i]);

		translate([r_corner_case_o-t_wall, r_corner_case_o-t_wall, -1])
			cylinder(r=r_corner_case_o, h=z_case_i+2);

		translate([x_case_i-r_corner_case_o+t_wall, r_corner_case_o-t_wall, -1])
			cylinder(r=r_corner_case_o, h=z_case_i+2);

		translate([x_case_i-r_corner_case_o+t_wall, y_case_i-r_corner_case_o+t_wall, -1])
			cylinder(r=r_corner_case_o, h=z_case_i+2);

		translate([r_corner_case_o-t_wall, y_case_i-r_corner_case_o+t_wall, -1])
			cylinder(r=r_corner_case_o, h=z_case_i+2);

		if (standoffs>0) {
			translate([t_wall+pad_led_sens+r_corner_case_o+r_corner_case_i, standoffs-0.5, pad_led_sens+1])
				rotate([90, 0, 0])
					led_sens_brd_standoffs(standoffs);

			translate([t_wall+pad_led_sens+r_corner_case_o+r_corner_case_i, y_case_i-standoffs+0.5, z_case_i-pad_led_sens-t_wall*2+1])
				rotate([270, 0, 0])
					led_sens_brd_standoffs(standoffs);
		}
	}
}

module boss() {
	h_hole = 10;
	d_nut = 6.5;
	h_nut = 2.6;
	depth_nut=5;

	translate([0, 0, -h_hole])
		cylinder(r=d_cover_holes/2, h=h_hole+1);

	translate([0, 0, -depth_nut])
		hull() {
			cylinder(r=d_nut/2, h=h_nut, $fn=6);

			translate([5, 0, 0])
				cylinder(r=d_nut/2, h=h_nut, $fn=6);
		}		
}

module board_led_sens(which, nopins=1) {
	difference() {
		union() {
			cube([l_brd_led_sens, w_brd_led_sens, t_brd_led_sens]);

			if (nopins!=1) {
				if (which==1) {
					for (i=[0:3]) {
						translate([offset_pins_led_sens[0], i*pins_pitch+offset_pins_led_sens[1], 0])
							cylinder(r=0.4, h = 10+t_brd_led_sens);
					}
				}
				else {
					for (i=[0:3]) {
						translate([l_brd_led_sens-offset_pins_led_sens[0], i*pins_pitch+offset_pins_led_sens[1], 0])
							cylinder(r=0.4, h = 10+t_brd_led_sens);
					}
				}
			}

			if (which!=1) {
				translate([offset_connector[0], offset_connector[1], -dims_connector[2]])
					cube(dims_connector);
			}
		}

		translate([0, 0, -1])
			led_sens_brd_holes(t_brd_led_sens+2);
	}
}

module led_sens_brd_holes(length) {

	translate([offset_holes_led_sens, offset_holes_led_sens, 0])
		cylinder(r=d_holes_led_sens/2, h=length);

	translate([l_brd_led_sens-offset_holes_led_sens, offset_holes_led_sens, 0])
		cylinder(r=d_holes_led_sens/2, h=length);

	translate([offset_holes_led_sens, w_brd_led_sens-offset_holes_led_sens, 0])
		cylinder(r=d_holes_led_sens/2, h=length);

	translate([l_brd_led_sens-offset_holes_led_sens, w_brd_led_sens-offset_holes_led_sens, 0])
		cylinder(r=d_holes_led_sens/2, h=length);
	
}

module led_sens_brd_standoffs(length) {

	translate([offset_holes_led_sens, offset_holes_led_sens, 0])
		cylinder(r1=d_holes_led_sens/2+1, r2=d_holes_led_sens/2+2.5, h=length);

	translate([l_brd_led_sens-offset_holes_led_sens, offset_holes_led_sens, 0])
		cylinder(r1=d_holes_led_sens/2+1, r2=d_holes_led_sens/2+2.5, h=length);

	translate([offset_holes_led_sens, w_brd_led_sens-offset_holes_led_sens, 0])
		cylinder(r1=d_holes_led_sens/2+1, r2=d_holes_led_sens/2+2.5, h=length);

	translate([l_brd_led_sens-offset_holes_led_sens, w_brd_led_sens-offset_holes_led_sens, 0])
		cylinder(r1=d_holes_led_sens/2+1, r2=d_holes_led_sens/2+2.5, h=length);
	
}

assembly();