wallsize = 1.4;
radius = 13;
thickness = 2.5;
plate = 1.25;
innerradius = radius/2.8;
boxcut = radius/0.7;

keyhole = 1.4;

difference() {
    union() {
		cylinder(r=radius,h=thickness);
	}
	cylinder(r=innerradius, h=thickness);
	intersection() {
		rotate(-20) cube(size=[boxcut,boxcut,thickness]);
		rotate(20)  cube(size=[boxcut,boxcut,thickness]);
	}

translate([0,0,plate])
difference() {
    union() {
		cylinder(r=radius-wallsize,h=thickness);
	}
	cylinder(r=innerradius+wallsize, h=thickness);
	intersection() {
		translate([-wallsize,0,0]) rotate(-20) cube(size=[boxcut,boxcut,thickness]);
		translate([0,-wallsize,0]) rotate(20)  cube(size=[boxcut,boxcut,thickness]);
	}
}

	//hole for keyring
	translate([0,-radius+wallsize+keyhole,0]) cylinder(r=keyhole, h=thickness, $fs=0.5);
}

