use <utils/build_plate.scad>
use <write/Write.scad>

// preview[view:west, tilt:bottom]

/***CUSTOMIZER VARIABLES***/

pattern_toggle = 1; //[0:Off, 1:On]
pattern_shape = 6; //[3:Triangle (3-sided),4:Square (4-sided),5:Pentagon (5-sided),6:Hexagon (6-sided),7:Heptagon (7-sided),8:Octogon (8-sided),9:Nonagon (9-sided),10:Decagon (10-sided),11:Hendecagon (11-sided),12:Dodecagon (12-sided),30:Circle (30-sided)]
pattern_radius = 12; //[8:22]
pattern_overlap = 20; //[0:100]
pattern_rotation = 0; //[0:180]
line_thickness = 4; //[2:Thin,4:Medium,6:Thick,8:Extra Thick]
message_toggle = 1; //[0:Off, 1:On]
//16 characters max
message = "NOKIA";
message_font = "write/orbitron.dxf";//["write/Letters.dxf":Basic,"write/orbitron.dxf":Futuristic,"write/BlackRose.dxf":Fancy]


//for display only, doesn't contribute to final object
build_plate_selector = -1; //[-1:None,0:Replicator 2,1: Replicator,2:Thingomatic]

/***NON-CUSTOMIZABLE VARIABLES***/
circle_res = 16*1;
circle_res_ports = 8*1;
circle_res_backport = 12*1;
circle_res_tabs = 4*1;
width = 66.66*1;
length = 122.03*1;
pattern_height = .8*1;
case_height = 9.99*1;
pattern_thickness = line_thickness*.4;
fudge = .1*1;


/***END OF VARIABLES***/


build_plate(build_plate_selector);


//pattern case
rotate([0,0,180])
	difference(){	
			color([13/256,85/256,174/256])
				translate([7,0,0])
				rotate([0,0,-90])
				compiled_nokia_case();
			if(pattern_toggle == 1){
				rotate([0,0,-90])
					intersection(){
						difference(){
							if(message_toggle == 0){
								color([13/256,85/256,174/256])
									translate([0,0,pattern_height/2])
										cube([width - .4*8*2,length-.4*8*2,pattern_height+fudge*2],center = true);
							}else{
								color([13/256,85/256,174/256])
									translate([0,15,pattern_height/2])
										cube([width - .4*8*2,length - 15 -.4*8*2,pattern_height+fudge*2],center = true);
							}
							color([13/256,85/256,174/256])
							hull(){
								translate([12.65,53,pattern_height/2])
								cylinder(h = 5 +fudge, r = 6.45+.4*8,center = true, $fn = circle_res_backport);
								translate([-12.65,53,pattern_height/2])
								cylinder(h = 5 +fudge, r = 6.45+.4*8,center = true, $fn = circle_res_backport);
							}
						}
						color([63/256,135/256,224/256])
							honeycomb(width,length,pattern_height*2,pattern_radius,pattern_overlap,pattern_thickness,pattern_shape,pattern_rotation);
							
					}
			}
			if(message_toggle == 1)
				color([63/256,135/256,224/256])
				translate([-length/2+17,0,0])
				scale([1,-1,1])
				rotate([0,0,-90])
				scale([20/max(5,len(message)),18/max(5,len(message)),1.6])
				write(message,space=1.05,center = true,font = message_font);
		
	}
color([13/256,85/256,174/256])
translate([0,40,0])
rotate([0,0,90])
820_BUTTON_A();





module honeycomb(w,l,h,r,rmod,th,sides,rot){
	
	columns = l/(r*3)+1;
	rows = w/(r*sqrt(3)/2*2);

	translate([-w/2,l/2,0])
		rotate([0,0,-90])
			linear_extrude(height = h, center = true, convexity = 10)
			for(i = [-1:rows+1]){
				
				translate([0,r*sqrt(3)/2*i*2,0])
				//scale([1*(1+(i/10)),1,1])
					for(i = [0:columns]){
						translate([r*i*3,0,0])
							for(i = [0:1]){
								translate([r*1.5*i,r*sqrt(3)/2*i,0])
									rotate([0,0,rot])
									difference(){
										if(sides < 5){
											circle(r = r+th+(r*rmod/50)+fudge, center = true, $fn = sides);
											//cylinder(height = h, r = r+th+(r*rmod/50), center = true, $fn = sides);
										} else {
											circle(r = r+(r*rmod/50)+fudge, center = true, $fn = sides);
											//cylinder(height = h, r = r+(r*rmod/50), center = true, $fn = sides);
										}
										circle(r = r-th+(r*rmod/50), center = true, $fn = sides);
										//cylinder(height = h+1, r = r-th+(r*rmod/50), center = true, $fn = sides);
									}
							}
					}
			}
}

module compiled_nokia_case(){

polyhedron(triangles = [
[2,0,1],[13,22,21],[6,13,12],[3,6,5],[471,477,488],[8,18,25],[11,0,2],[15,36,32],[4,15,16],[7,3,1],[18,37,28],[18,10,19],[2,5,10],[568,586,602],[24,16,32],[7,16,24],[6,7,14],[10,29,19],[5,20,10],[24,33,39],[31,14,24],[23,6,14],[38,44,29],[21,38,20],[328,358,356],[40,39,45],[30,31,40],[22,23,30],[4,26,15],[647,683,685],[93,117,137],[72,92,117],[90,93,133],[71,72,93],[131,90,132],[89,71,90],[133,137,189],[113,89,131],[88,70,89],[181,229,204],[150,216,181],[149,205,150],[216,249,229],[205,250,216],[182,230,205],[257,269,249],[237,257,250],[222,237,230],[238,248,269],[223,238,257],[207,223,237],[361,450,423],[130,155,182],[155,217,182],[187,222,217],[222,188,189],[132,133,188],[155,132,187],[130,131,155],[606,453,480],[335,293,342],[505,497,484],[349,456,438],[101,130,149],[606,616,426],[319,183,151],[577,372,399],[473,455,484],[134,115,158],[158,115,135],[116,136,159],[156,114,134],[91,118,136],[125,203,148],[101,149,150],[370,338,615],[48,36,15],[387,40,45],[384,305,351],[29,43,37],[42,43,52],[28,37,42],[296,275,295],[369,337,370],[336,314,337],[320,295,314],[41,33,32],[251,256,232],[274,275,256],[467,446,419],[357,360,330],[321,344,360],[296,320,344],[289,251,231],[251,290,274],[290,314,295],[419,446,418],[330,360,359],[344,368,359],[344,336,368],[313,290,270],[315,314,290],[359,390,358],[390,368,396],[396,336,369],[338,315,313],[370,337,315],[41,32,36],[358,422,356],[390,425,422],[396,397,425],[203,321,357],[321,228,296],[670,673,683],[340,371,399],[317,340,372],[316,339,371],[292,316,340],[316,318,339],[292,291,316],[371,398,426],[291,294,318],[272,273,291],[391,312,334],[366,311,312],[333,332,311],[423,366,391],[424,333,366],[394,365,333],[469,424,423],[451,394,424],[452,395,394],[468,469,450],[480,451,469],[453,452,451],[410,436,435],[365,343,319],[395,343,365],[452,376,395],[452,453,426],[339,376,398],[339,343,376],[318,319,343],[498,527,528],[377,432,406],[581,576,564],[271,292,317],[373,341,372],[571,468,447],[108,83,61],[559,470,482],[186,219,218],[254,255,236],[233,220,236],[219,235,234],[233,234,235],[599,591,611],[129,294,273],[218,234,233],[311,332,151],[364,393,421],[108,128,127],[400,429,428],[428,430,403],[260,277,259],[374,403,430],[427,429,400],[342,374,402],[126,232,256],[479,467,583],[405,44,38],[51,70,69],[52,92,72],[9,8,17],[350,22,30],[313,270,289],[43,29,44],[335,271,293],[231,252,271],[293,317,341],[401,427,510],[374,375,403],[464,465,444],[385,386,351],[415,416,386],[443,444,416],[477,478,488],[462,465,478],[479,466,446],[489,463,466],[464,443,463],[431,477,471],[477,441,462],[441,416,444],[588,572,537],[446,466,445],[463,442,445],[463,415,442],[439,441,461],[414,416,441],[445,417,388],[417,442,440],[440,415,385],[384,414,439],[351,386,414],[45,39,46],[388,387,352],[417,413,387],[440,350,413],[4,1,27],[489,494,464],[472,476,456],[432,472,434],[483,487,476],[454,483,472],[483,500,487],[454,491,483],[476,460,438],[491,504,500],[473,497,491],[481,482,470],[485,490,482],[492,496,490],[457,485,481],[458,492,485],[474,493,492],[411,458,457],[437,474,458],[459,475,474],[382,411,436],[383,437,411],[412,459,437],[204,229,215],[249,269,215],[447,450,361],[493,499,502],[475,499,493],[459,486,475],[459,412,438],[487,486,460],[487,499,486],[500,502,499],[42,71,70],[638,659,664],[605,630,608],[106,87,68],[175,170,174],[144,199,145],[434,456,349],[595,637,618],[109,85,127],[526,543,542],[345,378,347],[224,239,261],[219,220,235],[506,513,547],[438,412,299],[640,671,622],[507,513,506],[408,381,347],[347,378,379],[550,549,530],[346,379,378],[348,381,408],[322,346,345],[356,422,569],[647,625,670],[584,425,397],[100,64,101],[413,30,40],[439,461,431],[404,433,377],[471,455,433],[252,231,206],[673,655,656],[613,592,593],[633,613,614],[655,633,634],[25,18,28],[679,680,667],[674,675,679],[625,583,602],[670,625,626],[673,670,648],[680,619,660],[680,657,661],[656,634,657],[288,330,329],[604,626,602],[648,626,604],[633,648,627],[657,639,661],[634,635,657],[604,586,570],[585,627,604],[603,633,627],[615,596,639],[593,615,635],[569,570,556],[584,585,569],[592,603,584],[185,126,256],[617,577,594],[595,578,577],[658,617,636],[637,595,617],[682,658,676],[677,637,658],[636,594,616],[652,677,682],[665,659,677],[573,574,559],[589,590,573],[608,609,589],[590,588,574],[609,610,590],[631,632,609],[607,572,588],[629,607,610],[650,629,632],[571,558,572],[587,571,607],[606,587,629],[435,481,470],[435,436,457],[630,653,631],[653,654,631],[672,650,654],[650,651,616],[676,636,651],[653,676,672],[630,682,653],[616,594,399],[536,601,555],[189,137,208],[322,404,377],[88,113,82],[184,87,106],[226,225,242],[573,482,490],[528,546,547],[598,621,644],[641,620,662],[669,663,662],[643,644,668],[669,642,666],[137,117,191],[449,448,389],[685,679,684],[338,367,596],[643,666,642],[639,597,619],[367,313,335],[618,597,579],[660,619,618],[498,455,471],[544,505,512],[122,143,177],[307,308,326],[67,103,184],[402,430,428],[279,278,261],[260,261,278],[279,259,277],[282,258,276],[297,276,259],[66,104,79],[98,143,41],[464,495,465],[195,192,160],[511,503,524],[525,542,543],[526,524,541],[510,523,540],[540,542,525],[272,292,271],[204,334,312],[412,383,299],[52,72,71],[649,652,630],[455,473,454],[422,425,584],[592,397,370],[121,170,190],[0,9,27],[124,151,103],[531,490,496],[207,189,197],[637,659,638],[248,238,382],[240,281,280],[150,181,99],[95,76,96],[531,496,502],[69,88,112],[48,35,49],[147,146,202],[507,528,547],[578,595,579],[533,563,552],[193,162,194],[517,509,532],[652,504,497],[465,495,478],[8,25,17],[268,310,246],[525,541,524],[598,620,544],[406,434,407],[214,179,201],[79,103,77],[156,118,224],[454,432,377],[110,86,152],[679,667,684],[649,628,645],[65,148,123],[420,421,393],[164,53,54],[223,383,382],[175,168,170],[280,281,299],[555,566,567],[106,67,184],[186,83,152],[185,275,296],[159,136,158],[582,605,600],[351,305,350],[116,135,115],[545,512,506],[127,85,110],[143,213,177],[587,480,468],[253,272,252],[294,183,319],[380,379,346],[109,84,85],[669,668,644],[300,281,325],[246,214,247],[327,355,326],[199,200,178],[55,56,175],[673,674,685],[239,298,348],[211,198,168],[600,567,566],[565,575,581],[180,201,179],[448,355,327],[554,535,536],[534,519,520],[435,537,392],[287,307,354],[516,508,514],[515,501,508],[518,509,501],[561,538,548],[538,522,529],[522,521,514],[560,561,551],[517,532,550],[310,268,409],[623,601,678],[178,200,202],[105,104,66],[364,363,331],[27,35,26],[107,113,130],[78,64,105],[143,176,227],[195,121,196],[501,509,495],[285,266,245],[265,286,304],[283,303,325],[243,262,242],[267,262,243],[266,267,244],[304,286,305],[263,241,264],[283,263,284],[139,119,140],[140,162,193],[192,195,210],[75,97,96],[97,75,94],[120,94,119],[160,138,141],[63,169,74],[60,57,165],[57,53,164],[74,169,166],[58,173,175],[58,59,172],[59,60,167],[63,62,174],[109,128,108],[2,1,3],[13,21,12],[6,12,5],[3,5,2],[660,667,680],[471,488,667],[471,667,660],[8,11,18],[11,8,0],[15,32,16],[4,16,7],[7,1,4],[18,19,37],[18,11,10],[2,10,11],[557,570,586],[557,586,568],[24,32,33],[7,24,14],[6,3,7],[10,20,29],[5,12,20],[24,39,31],[31,23,14],[23,13,6],[38,29,20],[21,20,12],[557,556,570],[328,356,556],[328,556,557],[40,31,39],[30,23,31],[22,13,23],[15,35,48],[15,26,35],[681,685,684],[678,685,681],[678,647,685],[678,646,647],[93,137,133],[72,117,93],[90,133,132],[71,93,90],[131,89,90],[89,70,71],[133,189,188],[113,88,89],[88,69,70],[181,216,229],[150,205,216],[149,182,205],[216,250,249],[205,230,250],[182,217,230],[257,249,250],[237,250,230],[222,230,217],[238,269,257],[223,257,237],[207,237,222],[361,423,391],[130,182,149],[155,187,217],[187,188,222],[222,189,207],[132,188,187],[155,131,132],[130,113,131],[606,480,587],[335,342,401],[335,401,503],[597,335,503],[597,503,511],[597,511,579],[544,497,505],[544,665,497],[641,664,665],[620,665,544],[620,641,665],[349,438,323],[101,107,130],[606,426,453],[319,151,332],[577,399,594],[484,498,505],[484,455,498],[134,158,157],[158,135,159],[116,159,135],[156,134,157],[91,136,116],[125,228,203],[126,185,228],[126,228,125],[100,150,99],[100,101,150],[370,615,593],[49,36,48],[65,36,49],[65,309,36],[123,357,309],[123,309,65],[387,45,352],[21,55,38],[95,138,54],[138,160,54],[54,160,73],[73,160,74],[384,302,305],[384,283,302],[55,62,38],[62,63,38],[63,74,38],[226,241,194],[194,241,263],[384,263,283],[209,194,263],[38,263,384],[192,209,263],[192,263,38],[160,38,74],[160,192,38],[29,37,19],[42,37,43],[28,42,51],[296,295,320],[369,370,397],[336,337,369],[320,314,336],[46,39,33],[46,33,41],[251,274,256],[274,295,275],[583,568,602],[467,419,568],[467,568,583],[357,330,309],[321,360,357],[296,344,321],[289,270,251],[251,270,290],[290,295,274],[353,418,388],[353,419,418],[330,359,329],[344,359,360],[344,320,336],[313,315,290],[315,337,314],[359,358,329],[390,359,368],[396,368,336],[338,313,367],[370,315,338],[288,309,330],[98,41,36],[98,36,309],[176,309,288],[176,98,309],[358,390,422],[390,396,425],[396,369,397],[148,357,123],[148,203,357],[321,203,228],[670,683,647],[340,399,372],[317,372,341],[316,371,340],[292,340,317],[316,291,318],[292,272,291],[371,426,399],[291,273,294],[272,253,273],[391,366,312],[366,333,311],[333,365,332],[423,424,366],[424,394,333],[394,395,365],[469,423,450],[451,424,469],[452,394,451],[468,450,447],[480,469,468],[453,451,480],[269,248,215],[410,435,409],[248,409,215],[248,410,409],[365,319,332],[395,376,343],[452,398,376],[452,426,398],[339,398,371],[339,318,343],[318,294,319],[498,528,507],[322,406,407],[322,377,406],[576,591,599],[576,599,564],[271,317,293],[427,373,372],[510,427,372],[510,372,577],[523,577,578],[523,510,577],[571,447,558],[108,61,84],[559,482,573],[186,218,206],[254,236,221],[233,236,255],[219,234,218],[233,235,220],[622,611,612],[622,599,611],[129,273,111],[254,233,255],[206,218,233],[206,233,254],[311,151,124],[311,124,102],[364,421,363],[152,127,153],[83,108,127],[83,127,152],[400,428,375],[428,403,375],[258,259,276],[224,260,259],[224,259,258],[374,430,402],[427,400,373],[342,402,401],[125,80,232],[125,232,126],[479,583,625],[405,38,384],[61,69,86],[61,51,69],[91,114,92],[91,92,52],[9,0,8],[350,30,413],[313,289,335],[404,405,439],[43,44,405],[43,405,404],[335,289,271],[231,271,289],[342,341,373],[342,293,341],[401,510,503],[373,400,375],[342,375,374],[342,373,375],[464,444,443],[385,351,350],[415,386,385],[443,416,415],[477,462,478],[462,444,465],[479,446,467],[489,466,479],[464,463,489],[431,461,477],[477,461,441],[441,444,462],[588,537,574],[446,445,418],[463,445,466],[463,443,415],[439,414,441],[414,386,416],[445,388,418],[417,445,442],[440,442,415],[384,439,405],[351,414,384],[352,353,388],[45,46,353],[45,353,352],[388,417,387],[417,440,413],[440,385,350],[4,27,26],[489,552,494],[489,533,552],[472,456,434],[432,434,406],[483,476,472],[454,472,432],[483,491,500],[454,473,491],[476,438,456],[491,497,504],[473,484,497],[481,485,482],[485,492,490],[492,493,496],[457,458,485],[458,474,492],[474,475,493],[411,457,436],[437,458,411],[459,474,437],[382,436,410],[383,411,382],[412,437,383],[334,361,391],[204,215,361],[204,361,334],[249,215,229],[572,558,537],[447,361,392],[558,392,537],[558,447,392],[493,502,496],[475,486,499],[459,460,486],[459,438,460],[487,460,476],[487,500,499],[500,504,502],[42,70,51],[621,664,641],[621,638,664],[628,649,630],[628,630,605],[68,82,81],[68,112,82],[68,87,112],[167,165,142],[165,164,142],[164,166,142],[325,303,300],[174,170,171],[163,141,121],[141,96,121],[96,97,121],[195,196,210],[210,196,193],[193,196,161],[267,240,262],[262,240,242],[240,264,242],[300,303,284],[171,170,169],[170,121,169],[121,97,169],[169,97,166],[97,120,166],[196,300,284],[161,196,284],[161,284,264],[161,264,240],[139,161,240],[139,240,142],[120,142,166],[120,139,142],[144,145,122],[434,349,324],[595,618,579],[109,127,128],[523,542,540],[511,526,542],[511,542,523],[348,347,381],[298,345,347],[298,347,348],[224,261,260],[221,236,220],[186,220,219],[186,221,220],[506,547,546],[438,299,323],[640,622,612],[505,506,512],[498,507,506],[498,506,505],[408,347,380],[347,379,380],[562,560,549],[562,549,550],[346,378,345],[348,408,407],[322,345,298],[356,569,556],[533,489,479],[646,625,647],[519,533,479],[520,519,479],[520,479,625],[624,625,646],[535,520,625],[601,625,624],[536,535,625],[536,625,601],[584,397,592],[68,81,107],[68,107,101],[68,101,64],[413,40,387],[439,431,404],[404,431,433],[471,433,431],[28,51,61],[28,61,83],[28,83,186],[231,186,206],[231,28,186],[673,656,674],[613,593,614],[633,614,634],[655,634,656],[232,231,251],[47,25,28],[50,47,28],[67,50,28],[67,28,231],[67,231,232],[67,232,80],[679,675,680],[674,656,675],[625,602,626],[670,626,648],[673,648,655],[680,661,619],[680,675,657],[656,657,675],[328,329,358],[328,288,329],[604,602,586],[648,604,627],[633,655,648],[657,635,639],[634,614,635],[604,570,585],[585,603,627],[603,613,633],[615,639,635],[593,635,614],[569,585,570],[584,603,585],[592,613,603],[185,256,275],[617,594,636],[595,577,617],[658,636,676],[637,617,658],[682,677,658],[677,659,637],[636,616,651],[652,665,677],[665,664,659],[573,590,574],[589,609,590],[608,631,609],[590,610,588],[609,632,610],[631,654,632],[607,588,610],[629,610,632],[650,632,654],[571,572,607],[587,607,629],[606,629,650],[537,559,574],[435,470,559],[435,559,537],[435,457,481],[630,631,608],[653,672,654],[672,651,650],[650,616,606],[676,651,672],[653,682,676],[630,652,682],[616,399,426],[554,565,535],[535,565,520],[601,566,555],[601,582,566],[623,582,601],[623,645,582],[623,671,645],[534,671,623],[534,622,671],[534,599,622],[520,599,534],[520,564,599],[520,565,564],[189,208,197],[298,404,322],[239,404,298],[239,43,404],[91,52,43],[224,43,239],[118,91,43],[118,43,224],[88,82,112],[154,129,184],[184,111,87],[184,129,111],[226,242,264],[226,264,241],[573,490,589],[544,545,546],[527,546,528],[527,544,546],[598,644,643],[641,662,663],[669,662,642],[643,668,666],[669,666,668],[137,191,208],[449,389,420],[685,674,679],[338,596,615],[620,642,662],[598,643,642],[598,642,620],[639,619,661],[596,597,639],[367,335,597],[367,597,596],[618,619,597],[660,618,638],[527,498,471],[527,471,660],[621,660,638],[598,527,660],[598,660,621],[544,512,545],[122,177,144],[307,326,354],[67,65,103],[427,428,429],[401,402,428],[401,428,427],[297,279,282],[279,261,239],[279,239,282],[260,278,277],[279,277,278],[282,276,297],[297,259,279],[66,79,77],[227,176,287],[176,288,287],[143,122,41],[122,145,41],[145,178,41],[178,146,41],[41,146,46],[46,146,353],[287,288,307],[307,288,308],[308,288,327],[327,288,389],[288,328,389],[328,557,389],[419,353,568],[568,353,557],[146,147,353],[147,179,353],[179,214,353],[353,214,246],[557,353,246],[557,246,331],[557,331,363],[557,363,421],[557,421,420],[557,420,389],[494,508,464],[464,501,495],[464,508,501],[195,160,163],[511,524,526],[525,543,541],[526,541,543],[510,540,539],[540,525,539],[272,271,252],[204,312,181],[223,207,198],[299,383,280],[223,198,211],[383,211,280],[383,223,211],[52,71,42],[611,502,504],[612,611,504],[612,504,652],[640,652,649],[640,612,652],[455,454,433],[422,584,569],[592,370,593],[121,190,301],[196,301,300],[196,121,301],[0,27,1],[183,154,184],[151,184,103],[151,183,184],[576,581,562],[605,608,589],[600,605,589],[581,575,562],[567,600,589],[562,575,560],[560,575,561],[561,575,538],[518,490,531],[515,490,518],[538,575,522],[522,575,521],[567,589,490],[516,490,515],[575,567,490],[521,490,516],[521,575,490],[207,197,198],[637,638,618],[248,382,410],[142,240,280],[142,280,211],[142,211,168],[99,181,105],[105,181,104],[102,312,311],[104,181,312],[79,312,102],[79,104,312],[95,96,141],[95,141,138],[591,502,611],[532,531,502],[550,532,502],[550,502,591],[562,591,576],[562,550,591],[253,254,273],[69,112,87],[273,87,111],[273,69,87],[273,86,69],[273,152,86],[273,221,152],[273,254,221],[34,47,50],[34,50,49],[34,49,35],[147,202,180],[507,547,513],[578,579,511],[578,511,523],[553,580,563],[553,563,533],[553,533,519],[210,194,209],[210,193,194],[509,518,531],[509,531,532],[652,497,665],[478,563,580],[478,495,563],[25,47,34],[25,34,17],[310,362,331],[310,331,246],[539,525,510],[525,524,503],[525,503,510],[598,544,527],[434,324,407],[117,92,114],[191,117,114],[191,114,156],[190,191,156],[407,324,348],[190,156,258],[301,190,258],[301,258,282],[301,282,348],[301,348,324],[214,201,247],[102,124,103],[102,103,79],[156,224,258],[454,377,433],[110,152,153],[478,580,488],[580,553,488],[488,553,534],[684,667,681],[667,488,534],[681,667,678],[667,534,623],[667,623,678],[649,645,671],[649,671,640],[67,80,125],[65,125,148],[65,67,125],[420,393,449],[166,54,73],[166,164,54],[223,382,238],[172,167,142],[172,142,168],[173,168,175],[173,172,168],[281,300,299],[300,301,324],[300,324,349],[300,349,323],[300,323,299],[555,567,575],[554,575,565],[554,555,575],[106,50,67],[68,50,106],[64,50,68],[103,65,77],[77,65,49],[66,77,49],[64,49,50],[78,66,49],[78,49,64],[186,152,221],[185,296,228],[158,156,157],[158,118,156],[158,136,118],[645,628,605],[645,605,582],[22,55,21],[54,53,95],[53,57,95],[95,57,76],[76,57,75],[305,286,350],[286,265,350],[22,56,55],[22,58,56],[194,162,226],[162,140,226],[226,140,225],[57,60,75],[75,60,94],[265,245,350],[245,244,350],[350,244,22],[22,59,58],[22,60,59],[22,94,60],[225,140,119],[22,119,94],[243,225,119],[243,119,22],[243,22,244],[114,115,134],[91,116,115],[91,115,114],[545,506,546],[127,110,153],[227,213,143],[227,212,213],[227,306,212],[227,287,306],[587,468,571],[253,252,206],[253,206,254],[294,154,183],[294,129,154],[408,380,407],[380,346,322],[380,322,407],[85,86,110],[85,61,86],[85,84,61],[663,669,641],[669,644,621],[669,621,641],[281,304,325],[281,285,304],[281,266,285],[281,267,266],[281,240,267],[246,247,268],[327,326,308],[199,178,145],[55,175,174],[55,174,62],[673,685,683],[239,348,282],[168,198,170],[170,191,190],[170,208,191],[170,197,208],[170,198,197],[600,566,582],[565,581,564],[180,179,147],[448,327,389],[554,536,555],[534,553,519],[310,409,362],[435,392,364],[435,364,362],[435,362,409],[287,354,306],[516,514,521],[515,508,516],[518,501,515],[561,548,551],[538,529,548],[522,514,529],[560,551,549],[517,550,530],[393,364,392],[393,392,361],[268,247,409],[247,201,409],[201,180,409],[449,393,361],[180,215,409],[448,449,361],[355,448,361],[326,355,361],[354,326,361],[202,215,180],[200,215,202],[306,354,361],[212,306,361],[212,361,215],[199,215,200],[213,212,215],[144,215,199],[177,213,215],[177,215,144],[678,624,646],[678,601,624],[178,202,146],[105,66,78],[364,331,362],[27,34,35],[27,17,34],[27,9,17],[81,82,113],[81,113,107],[64,100,99],[64,99,105],[143,98,176],[195,163,121],[509,517,495],[508,494,514],[514,494,529],[494,552,529],[552,563,529],[517,530,495],[495,530,563],[563,530,549],[563,549,551],[563,551,548],[563,548,529],[285,245,265],[265,304,285],[283,325,302],[243,242,225],[267,243,244],[266,244,245],[325,305,302],[325,304,305],[263,264,284],[283,284,303],[139,140,161],[140,193,161],[192,210,209],[75,96,76],[97,94,120],[120,119,139],[160,141,163],[63,171,169],[60,165,167],[57,164,165],[74,166,73],[58,175,56],[58,172,173],[59,167,172],[63,174,171],[109,108,84]], points = [
[30.111294,62.407951,7.487133],[30.111294,62.407951,2.500000],[31.916580,62.048866,7.487133],[31.916580,62.048866,2.500000],[30.092186,62.213974,1.543291],[33.447021,61.026253,7.487133],[33.447021,61.026253,2.500000],[31.836639,61.855865,1.543291],[30.092186,62.213974,8.443842],[23.470001,62.407951,7.487133],[33.299301,60.878540,8.443842],[31.836639,61.855865,8.443842],[34.469631,59.495811,7.487133],[34.469631,59.495811,2.500000],[33.299309,60.878540,1.543291],[30.038683,61.670746,0.732233],[31.623192,61.340553,0.732233],[23.389929,62.214645,8.443842],[31.623192,61.340553,9.254900],[32.904900,60.484138,9.254900],[34.276634,59.415871,8.443842],[34.828720,57.690529,7.487133],[34.828720,57.690529,2.500000],[34.276634,59.415871,1.543291],[32.904903,60.484138,0.732233],[30.038681,61.670746,9.254900],[23.389929,62.214645,1.543291],[23.470001,62.407951,2.500000],[30.636614,60.567551,10.016792],[33.761322,59.202423,9.254900],[34.634739,57.671417,1.543291],[33.761322,59.202423,0.732233],[31.308731,60.581375,0.190301],[32.323853,59.903091,0.190301],[23.221041,61.806915,9.052927],[23.221041,61.806915,0.934332],[29.958927,60.860977,0.190301],[32.218273,59.804230,10.052154],[34.634739,57.671417,8.443842],[33.002144,58.887962,0.190301],[34.091515,57.617912,0.732233],[30.941132,59.693916,0.000000],[31.792343,59.371597,9.450001],[32.976154,58.291405,10.021820],[34.091515,57.617912,9.254900],[33.281746,57.538162,0.190301],[32.114681,58.520363,0.000000],[22.894655,61.671722,9.254900],[22.894655,61.671722,0.732233],[22.620001,61.557953,0.656086],[22.620001,61.557953,9.335279],[30.308567,60.055641,9.450001],[32.460251,57.965698,9.450001],[34.828720,18.111874,6.519607],[34.828720,18.459406,7.287133],[34.828720,38.511047,7.287133],[34.828720,38.858582,6.519607],[34.828720,18.517530,5.590263],[34.828720,38.452919,5.590263],[34.828720,37.730442,5.184606],[34.828720,19.240011,5.184606],[11.749353,60.101479,9.450001],[34.796253,38.452919,7.448950],[34.714859,37.730442,7.854607],[22.549999,61.557953,5.679657],[17.361053,61.557953,0.655609],[20.000000,61.557953,3.129657],[17.361053,61.557953,9.335784],[21.803122,61.557953,7.482780],[28.634239,60.101479,8.362184],[30.308567,60.055641,8.362184],[31.792343,59.371597,8.362184],[32.460251,57.965698,8.362184],[34.796329,18.517530,7.448950],[34.715237,19.240011,7.854607],[34.828720,7.253098,5.590263],[34.828720,7.658756,6.519607],[18.196877,61.557953,3.876535],[21.803122,61.557953,3.876535],[18.196877,60.142303,3.876535],[17.084494,61.672508,9.254900],[21.803122,60.867599,7.482780],[21.464163,60.840477,7.623180],[9.249356,60.101479,9.450001],[11.749353,59.849007,9.450001],[11.749353,59.849007,8.774574],[11.749353,60.101479,8.362184],[20.000000,60.299820,8.229657],[28.634239,60.544479,8.066180],[30.437977,60.340919,8.066180],[32.018669,59.586327,8.056346],[32.522293,47.285187,9.450001],[32.522293,56.213425,8.362184],[32.738091,58.040802,8.066180],[34.828720,6.599347,5.184606],[34.828720,7.311222,7.287133],[33.708725,7.658756,6.519606],[33.708725,7.253098,5.590263],[11.749352,59.907951,0.000000],[22.057289,60.568535,4.490149],[22.549999,60.818550,5.679657],[22.305626,60.942551,6.269628],[17.942709,60.568535,4.490149],[17.450001,61.557953,5.679657],[20.000000,59.623505,3.129657],[21.803122,60.142303,3.876535],[20.000000,61.557953,8.229657],[21.963842,60.942551,7.094763],[9.249356,59.849007,9.450001],[11.749353,59.499008,9.112288],[11.749353,59.849007,8.362184],[19.605333,60.544479,8.066180],[20.394667,60.544479,8.066180],[28.634239,60.840477,7.623180],[32.522293,47.285187,8.362184],[32.269779,47.285187,8.774574],[32.269779,47.285187,9.450001],[32.965294,56.213425,8.066180],[32.522293,44.785187,9.450001],[34.828720,-1.883723,5.184606],[33.708725,6.599347,5.184606],[33.708725,10.050219,8.196383],[15.116308,52.147903,0.000000],[17.084494,61.672508,0.732233],[17.450001,60.818550,5.679657],[16.760014,61.806915,9.054161],[16.590843,62.215324,8.443842],[9.249356,59.849007,8.774574],[9.249356,59.499008,9.112288],[18.535835,60.840477,7.623180],[28.634239,60.942551,7.094763],[30.551252,60.614388,7.623180],[32.160297,59.742622,7.606527],[33.011562,58.154076,7.623180],[32.269779,47.285187,8.362184],[31.919777,47.285187,9.112288],[32.269779,44.785187,9.450001],[33.261295,56.213425,7.623180],[34.796436,7.253098,7.448950],[33.708725,-1.883723,5.184606],[34.828720,-2.537476,5.590263],[33.708725,7.253098,7.448950],[33.708725,16.187702,4.845636],[12.648000,52.638878,0.000000],[15.116308,52.147903,1.619628],[17.208839,50.749718,0.000000],[19.098000,46.188881,0.000000],[18.607021,43.720573,0.000000],[16.760014,61.806915,0.933025],[28.634239,60.942551,6.269628],[28.634239,60.568535,4.490149],[17.694374,60.942551,6.269628],[9.249356,60.101479,8.362184],[9.249356,59.849007,8.362184],[18.196877,60.867599,7.482779],[30.591030,60.710419,7.094763],[32.522293,44.785187,8.362184],[32.269779,44.785187,8.362184],[32.269779,44.785187,8.774574],[31.919777,44.785187,9.112288],[34.715511,6.599347,7.854607],[33.708725,-2.537476,5.590263],[34.828720,-2.943132,6.519607],[33.708725,6.599347,7.854607],[33.708725,18.111874,6.519607],[33.708725,18.517530,5.590263],[33.708725,18.517530,7.448950],[33.708725,19.240011,5.184606],[33.708725,41.088341,4.845636],[33.708725,19.240011,7.854607],[33.708725,41.088341,8.196383],[33.708725,37.730442,7.854607],[33.708725,37.730442,5.184606],[33.708725,38.452919,5.590263],[33.708725,38.452919,7.448950],[33.708725,38.858582,6.519606],[7.259669,59.907951,0.000000],[12.648000,52.638878,1.619628],[18.607021,48.657188,0.000000],[17.208839,41.628036,0.000000],[18.607021,43.720573,1.619627],[28.634239,59.520645,2.981582],[30.591024,60.710419,6.269628],[18.036156,60.942551,7.094763],[18.196877,61.557953,7.482779],[16.511053,62.407951,7.487133],[-12.747634,60.101479,9.450001],[32.221058,59.799545,7.063579],[33.107590,58.193855,7.094763],[33.354061,56.213425,7.094763],[32.770432,41.088341,8.196383],[32.965294,41.088341,8.066180],[34.715679,-1.883723,7.854607],[33.708725,-2.943132,6.519607],[34.828720,-2.595599,7.287133],[33.708725,-1.883723,7.854607],[33.708725,-5.864514,8.196383],[33.354061,41.088341,7.094763],[33.354053,41.088341,6.269628],[17.208839,50.749718,1.619627],[18.607021,48.657188,1.619627],[17.208839,41.628036,1.619627],[19.098000,46.188881,1.619627],[16.590843,62.215324,1.543291],[28.634239,57.992897,1.973588],[30.413210,60.335388,4.490149],[-15.247631,60.101479,9.450001],[33.354053,56.213425,6.269628],[33.261295,41.088341,7.623180],[34.796459,-2.537475,7.448950],[33.708725,-2.537475,7.448950],[33.056641,41.088341,4.845636],[0.000000,52.638878,1.619627],[9.249356,52.638878,1.619627],[15.116308,40.229858,0.000000],[28.634239,56.213425,1.619628],[29.944641,59.310257,2.981581],[32.158684,59.769394,6.269628],[-15.247631,59.849007,9.450001],[-12.747634,59.849007,9.450001],[-12.747634,59.849007,8.774574],[-12.747634,60.101479,8.362184],[33.107590,58.193855,6.269628],[32.982395,56.213425,4.490149],[32.522293,-7.745806,9.450001],[34.828720,-28.435822,6.519607],[34.828720,-28.783356,7.287133],[-0.986006,52.638878,0.000000],[16.511053,62.407951,2.500000],[29.316862,57.859314,1.973588],[31.849304,59.452133,4.490149],[-30.636614,60.567551,10.016792],[-30.038681,61.670746,9.254900],[-15.247631,59.849007,8.774574],[-15.247631,59.499008,9.112288],[-12.747634,59.499008,9.112288],[-12.747634,59.849007,8.362184],[32.738209,58.010391,4.490149],[31.939201,56.213425,2.981582],[32.522293,-10.245800,9.450001],[33.708725,-25.311405,4.845636],[34.796299,-28.841480,7.448950],[33.708725,-28.435822,6.519606],[34.828720,-28.841480,5.590263],[34.828720,-29.441269,5.184606],[34.828720,-38.032265,5.184606],[12.648001,39.738876,0.000000],[15.116308,40.229858,1.619627],[30.413712,56.213425,1.973588],[29.895893,57.475533,1.973588],[31.029053,58.617546,2.981581],[-31.623192,61.340553,9.254900],[-30.308567,60.055641,9.450001],[-28.634239,60.101479,8.362184],[-15.247631,60.101479,8.362184],[-15.247631,59.849007,8.362184],[-30.092186,62.213974,8.443842],[31.724121,57.530777,2.981581],[32.522293,-7.745806,8.362184],[32.269779,-7.745806,8.774574],[32.269779,-7.745806,9.450001],[32.269779,-10.245800,9.450001],[33.708725,-28.841480,5.590263],[34.715023,-29.441269,7.854607],[33.708725,-28.841480,7.448950],[34.828720,-38.632050,5.590263],[33.708725,-38.032265,5.184606],[33.708725,-29.441269,5.184606],[12.648001,39.738876,1.619627],[30.279907,56.896271,1.973588],[-32.904900,60.484138,9.254900],[-31.792343,59.371597,9.450001],[-30.308567,60.055641,8.362184],[-28.634239,60.544479,8.066180],[-31.836639,61.855865,8.443842],[-30.111294,62.407951,7.487133],[32.269779,-7.745806,8.362184],[31.919777,-7.745806,9.112288],[31.919777,-10.245800,9.112288],[32.269779,-10.245800,8.774574],[33.056641,-41.363129,4.845636],[33.708725,-41.363129,4.845636],[32.522293,-10.245800,8.362184],[34.715023,-38.032265,7.854607],[33.708725,-29.441269,7.854607],[33.708725,-38.632050,5.590263],[34.828720,-39.037712,6.519607],[-12.648002,52.638878,0.000000],[-30.941132,59.693916,0.000000],[-32.218273,59.804230,10.052154],[-33.299301,60.878540,8.443842],[-30.437977,60.340919,8.066180],[-31.792343,59.371597,8.362184],[-32.460251,57.965698,9.450001],[-28.634239,60.840477,7.623180],[-31.916580,62.048866,7.487133],[-30.111294,62.407951,2.500000],[32.269779,-10.245800,8.362184],[32.522293,-45.213387,9.450001],[33.354053,-41.363129,6.269628],[33.708725,-41.363129,8.196383],[32.770432,-41.363129,8.196383],[34.796299,-38.632050,7.448950],[33.708725,-38.032265,7.854607],[33.708725,-39.037712,6.519607],[34.828720,-38.690178,7.287133],[-12.648002,52.638878,1.619627],[-15.116307,52.147903,0.000000],[-17.208839,50.749718,0.000000],[-29.958927,60.860977,0.190301],[0.000000,39.738876,1.619627],[-28.634239,60.568535,4.490149],[-28.634239,59.520645,2.981582],[-33.761322,59.202423,9.254900],[-33.447021,61.026253,7.487133],[-34.276634,59.415871,8.443842],[-32.018669,59.586327,8.056346],[-32.460251,57.965698,8.362184],[-30.551252,60.614388,7.623180],[-28.634239,60.942551,7.094763],[-31.916580,62.048866,2.500000],[-30.092186,62.213974,1.543291],[32.522293,-47.713394,9.450001],[33.354061,-41.363129,7.094763],[32.965294,-41.363129,8.066180],[33.708725,-38.632050,7.448950],[-17.208839,50.749718,1.619628],[-18.607025,48.657188,0.000000],[-32.114681,58.520363,0.000000],[-32.323853,59.903091,0.190301],[-31.308731,60.581375,0.190301],[-12.648000,39.738876,0.000000],[-28.634239,60.942551,6.269628],[-30.413210,60.335388,4.490149],[-28.634239,57.992897,1.973588],[-32.976154,58.291405,10.021820],[-33.447021,61.026253,2.500000],[-34.469631,59.495811,7.487133],[-34.634739,57.671417,8.443842],[-32.160297,59.742622,7.606527],[-32.738091,58.040802,8.066180],[-32.522293,56.213425,8.362184],[-32.522293,47.285187,9.450001],[-30.591030,60.710419,7.094763],[-31.836639,61.855865,1.543291],[32.269779,-45.213387,9.450001],[32.269779,-47.713394,9.450001],[32.269779,-45.213387,8.774574],[32.522293,-45.213387,8.362184],[33.261295,-41.363129,7.623180],[34.828720,-57.904564,2.500000],[34.828720,-57.904564,7.487133],[33.281746,-57.752197,0.190301],[32.114681,-58.734398,0.000000],[-15.116307,52.147903,1.619628],[-18.607025,48.657188,1.619628],[-33.281746,57.538162,0.190301],[-30.038683,61.670746,0.732233],[-33.002144,58.887962,0.190301],[-32.904903,60.484138,0.732233],[-31.623192,61.340553,0.732233],[-28.634239,56.213425,1.619628],[-12.648000,39.738876,1.619627],[-15.116309,40.229858,0.000000],[-15.116309,40.229858,1.619627],[-30.591024,60.710419,6.269628],[-29.944641,59.310257,2.981581],[-34.091515,57.617912,9.254900],[-33.299309,60.878540,1.543291],[-34.469631,59.495811,2.500000],[-34.828720,57.690529,7.487133],[-33.011562,58.154076,7.623180],[-32.965294,56.213425,8.066180],[-32.522293,47.285187,8.362184],[-32.269779,47.285187,9.450001],[-32.269779,47.285187,8.774574],[-32.221058,59.799545,7.063579],[32.460251,-58.179733,9.450001],[31.919777,-45.213387,9.112288],[31.919777,-47.713394,9.112288],[32.269779,-47.713394,8.774574],[32.269779,-45.213387,8.362184],[31.939201,-56.427460,2.981582],[32.982395,-56.427460,4.490149],[34.634739,-57.885460,8.443842],[34.469631,-59.709854,2.500000],[34.469631,-59.709854,7.487133],[34.091515,-57.831955,0.732233],[33.002144,-59.102005,0.190301],[-19.098003,46.188881,0.000000],[-33.761322,59.202423,0.732233],[-29.316862,57.859314,1.973588],[-28.634239,39.185226,1.619628],[-17.208839,41.628036,1.619627],[-31.849304,59.452133,4.490149],[-32.158684,59.769394,6.269628],[-34.276634,59.415871,1.543291],[-34.828720,57.690529,2.500000],[-33.107590,58.193855,7.094763],[-33.261295,56.213425,7.623180],[-32.269779,47.285187,8.362184],[-32.522293,44.785187,9.450001],[-32.269779,44.785187,9.450001],[-31.919777,47.285187,9.112288],[32.976154,-58.505440,10.021820],[34.091515,-57.831955,9.254900],[32.522293,-56.427460,8.362184],[32.522293,-47.713394,8.362184],[32.269779,-47.713394,8.362184],[28.634239,-47.713394,1.619628],[30.413712,-56.427460,1.973588],[31.724121,-57.744812,2.981581],[33.354053,-56.427460,6.269628],[34.634739,-57.885460,1.543291],[34.276634,-59.629913,8.443842],[33.447021,-61.240295,2.500000],[33.447021,-61.240295,7.487133],[33.761322,-59.416466,0.732233],[32.323853,-60.117134,0.190301],[30.941132,-59.907951,0.000000],[-18.607025,43.720573,0.000000],[-17.208839,41.628036,0.000000],[-34.091515,57.617912,0.732233],[-29.895893,57.475533,1.973588],[-31.029053,58.617546,2.981581],[-34.634739,57.671417,1.543291],[-33.354061,56.213425,7.094763],[-32.522293,44.785187,8.362184],[-32.269779,44.785187,8.774574],[-32.269779,44.785187,8.362184],[-31.919777,44.785187,9.112288],[32.218273,-60.018272,10.052154],[32.460251,-58.179733,8.362184],[31.792343,-59.585640,9.450001],[32.965294,-56.427460,8.066180],[28.634239,-56.427460,1.619628],[30.279907,-57.110306,1.973588],[32.738209,-58.224434,4.490149],[33.354061,-56.427460,7.094763],[33.761322,-59.416466,9.254900],[34.276634,-59.629913,1.543291],[33.299301,-61.092583,8.443842],[33.299309,-61.092583,1.543291],[31.916580,-62.262901,2.500000],[31.916580,-62.262901,7.487133],[32.904903,-60.698181,0.732233],[31.308731,-60.795418,0.190301],[-30.413712,56.213425,1.973588],[-19.098003,46.188881,1.619627],[-18.607025,43.720573,1.619627],[-30.279907,56.896271,1.973588],[-32.738209,58.010391,4.490149],[-33.107590,58.193855,6.269628],[-33.354053,56.213425,6.269628],[31.792343,-59.585640,8.362184],[30.308567,-60.269684,9.450001],[33.261295,-56.427460,7.623180],[29.895893,-57.689575,1.973588],[31.029053,-58.831589,2.981581],[33.107590,-58.407890,6.269628],[33.107590,-58.407890,7.094763],[32.904900,-60.698181,9.254900],[31.836639,-62.069908,8.443842],[31.836639,-62.069908,1.543291],[30.111294,-62.621994,2.500000],[30.111294,-62.621994,7.487133],[31.623192,-61.554596,0.732233],[29.958927,-61.075020,0.190301],[-31.939201,56.213425,2.981582],[-31.724121,57.530777,2.981581],[28.634239,-58.206940,1.973588],[30.636614,-60.781593,10.016792],[32.738091,-58.254837,8.066180],[30.308567,-60.269684,8.362184],[31.849304,-59.666176,4.490149],[32.158684,-59.983429,6.269628],[33.011562,-58.368118,7.623180],[31.623192,-61.554596,9.254900],[30.092186,-62.428009,8.443842],[30.038683,-61.884789,0.732233],[-32.982395,56.213425,4.490149],[29.316862,-58.073357,1.973588],[28.634239,-59.734688,2.981582],[32.018669,-59.800362,8.056346],[28.634239,-60.315514,8.362184],[29.944641,-59.524292,2.981581],[32.221058,-60.013580,7.063579],[32.160297,-59.956665,7.606527],[30.038681,-61.884789,9.254900],[30.092186,-62.428009,1.543291],[28.634239,-60.782578,4.490149],[30.437977,-60.554955,8.066180],[30.413210,-60.549431,4.490149],[30.591024,-60.924454,6.269628],[22.199873,-62.621994,2.500000],[22.199873,-62.621994,7.487133],[28.634239,-61.156586,6.269628],[28.634239,-60.758514,8.066180],[22.199875,-60.315514,9.450001],[30.591030,-60.924454,7.094763],[30.551252,-60.828423,7.623180],[21.696484,-62.621994,5.579105],[28.634239,-61.156593,7.094763],[-32.522293,-42.316116,9.450001],[28.634239,-61.054520,7.623180],[22.199875,-60.315514,8.362184],[22.199875,-60.063049,8.774574],[22.199875,-60.063049,9.450001],[21.489721,-62.621994,5.079939],[21.489721,-62.621994,6.078271],[-32.522293,-42.316116,8.362184],[-32.522293,-44.816124,9.450001],[22.199875,-60.063049,8.362184],[22.199875,-59.713051,9.112288],[20.990555,-62.621994,4.873178],[21.696484,-61.011452,5.579105],[21.489721,-60.906540,5.079939],[20.990555,-62.621994,6.285033],[21.489721,-61.116371,6.078271],[5.686989,-62.228874,1.241240],[5.085948,-61.979919,0.868676],[20.990557,-60.863083,4.873178],[13.509430,-60.863083,4.873178],[-32.522293,-44.816124,8.362184],[-32.269779,-42.316116,9.450001],[-32.269779,-42.316116,8.774574],[-32.269779,-44.816124,9.450001],[5.999998,-60.315514,9.450001],[5.999998,-60.063049,9.450001],[13.509430,-62.621994,4.873178],[13.509430,-62.621994,6.285033],[21.027746,-61.156586,6.269628],[20.990557,-61.156586,6.285033],[5.770632,-62.430809,1.543291],[5.085948,-61.979919,9.118475],[3.375340,-61.979919,0.868209],[0.000000,-61.979919,0.867162],[-28.634239,-56.427460,1.619628],[13.010264,-60.906540,5.079939],[-32.269779,-42.316116,8.362184],[-32.269779,-44.816124,8.362184],[-31.919777,-42.316116,9.112288],[-32.269779,-44.816124,8.774574],[-31.919777,-44.816124,9.112288],[5.999998,-60.315514,8.362184],[5.999998,-60.063049,8.362184],[5.999998,-60.063049,8.774574],[5.999998,-59.713051,9.112288],[13.010264,-62.621994,5.079939],[13.010264,-62.621994,6.078271],[13.509430,-61.156586,6.285033],[12.803502,-62.621994,5.579105],[5.849823,-62.621994,2.500000],[5.686989,-62.228874,8.745918],[0.167383,-61.979919,4.689142],[-1.267798,-61.979919,4.689142],[-33.281746,-57.752197,0.190301],[-32.114681,-58.734398,0.000000],[-30.413712,-56.427460,1.973588],[-28.634239,-58.206940,1.973588],[13.010264,-61.116371,6.078271],[12.803502,-61.011452,5.579105],[13.472239,-61.156586,6.269628],[5.849823,-62.621994,7.487133],[3.915488,-61.979919,5.055223],[3.549407,-61.979919,4.689142],[-3.549407,-61.979919,4.689142],[-3.549407,-60.824402,4.689142],[-30.941132,-59.907951,0.000000],[-34.091515,-57.831955,0.732233],[-33.002144,-59.102005,0.190301],[-31.939201,-56.427460,2.981582],[-30.279907,-57.110306,1.973588],[-28.634239,-59.734688,2.981582],[-29.316862,-58.073357,1.973588],[3.549407,-60.824402,4.689142],[3.915488,-61.156586,6.269628],[-32.965294,-56.427460,8.066180],[-32.522293,-56.427460,8.362184],[-32.460251,-58.179733,9.450001],[5.770632,-62.430809,8.443842],[3.915488,-60.901344,5.055223],[-3.915487,-61.979919,5.055223],[-29.958927,-61.075020,0.190301],[-34.634739,-57.885460,1.543291],[-33.761322,-59.416466,0.732233],[-32.323853,-60.117134,0.190301],[-32.982395,-56.427460,4.490149],[-29.895893,-57.689575,1.973588],[-28.634239,-60.782578,4.490149],[-29.944641,-59.524292,2.981581],[3.915488,-61.156586,6.454424],[-34.828720,-57.904564,2.500000],[-34.828720,-57.904564,7.487133],[-33.261295,-56.427460,7.623180],[-32.460251,-58.179733,8.362184],[-34.091515,-57.831955,9.254900],[-32.976154,-58.505440,10.021820],[-5.999998,-60.315514,9.450001],[3.915488,-61.979919,6.454424],[-3.915487,-60.901344,5.055223],[-5.123278,-61.979919,0.868689],[-31.308731,-60.795418,0.190301],[-34.276634,-59.629913,1.543291],[-32.904903,-60.698181,0.732233],[-3.915487,-61.156586,6.269628],[-33.354053,-56.427460,6.269628],[-31.724121,-57.744812,2.981581],[-28.634239,-61.156586,6.269628],[-30.413210,-60.549431,4.490149],[-31.029053,-58.831589,2.981581],[3.275148,-61.156593,7.094763],[2.879784,-61.080223,7.490128],[-34.469631,-59.709854,2.500000],[-34.469631,-59.709854,7.487133],[-34.634739,-57.885460,8.443842],[-33.354061,-56.427460,7.094763],[-32.738091,-58.254837,8.066180],[-31.792343,-59.585640,9.450001],[-32.218273,-60.018272,10.052154],[-5.999998,-60.315514,8.362184],[-20.999998,-60.315514,9.450001],[2.879784,-61.979919,7.490128],[-5.123278,-61.979919,9.118464],[-5.423960,-62.104462,1.055095],[-30.038683,-61.884789,0.732233],[-31.623192,-61.554596,0.732233],[-33.299309,-61.092583,1.543291],[-3.915487,-61.156586,6.454424],[-32.738209,-58.224434,4.490149],[-28.634239,-61.156593,7.094763],[-30.591024,-60.924454,6.269628],[-31.849304,-59.666176,4.490149],[-33.447021,-61.240295,2.500000],[-33.447021,-61.240295,7.487133],[-34.276634,-59.629913,8.443842],[-33.011562,-58.368118,7.623180],[-31.792343,-59.585640,8.362184],[-30.308567,-60.269684,9.450001],[-33.761322,-59.416466,9.254900],[-2.879783,-61.080223,7.490128],[-20.999998,-60.315514,8.362184],[-5.999998,-60.063049,8.774574],[-5.999998,-60.063049,9.450001],[-20.999998,-60.063049,9.450001],[-3.915487,-61.979919,6.454424],[-5.724319,-62.228874,1.241249],[-5.807959,-62.430801,1.543291],[-31.836639,-62.069908,1.543291],[-3.275147,-61.156593,7.094763],[-33.107590,-58.407890,6.269628],[-33.107590,-58.407890,7.094763],[-28.634239,-61.054520,7.623180],[-30.591030,-60.924454,7.094763],[-32.158684,-59.983429,6.269628],[-31.916580,-62.262901,2.500000],[-31.916580,-62.262901,7.487133],[-33.299301,-61.092583,8.443842],[-32.018669,-59.800362,8.056346],[-30.308567,-60.269684,8.362184],[-30.636614,-60.781593,10.016792],[-32.904900,-60.698181,9.254900],[-5.999998,-60.063049,8.362184],[-20.999998,-60.063049,8.362184],[-28.634239,-60.315514,8.362184],[-28.634239,-60.758514,8.066180],[-5.999998,-59.713051,9.112288],[-30.038681,-61.884789,9.254900],[-20.999998,-59.713051,9.112288],[-20.999998,-60.063049,8.774574],[-30.092186,-62.428009,1.543291],[-2.879783,-61.979919,7.490128],[-32.221058,-60.013580,7.063579],[-30.111294,-62.621994,2.500000],[-30.111294,-62.621994,7.487133],[-31.836639,-62.069908,8.443842],[-32.160297,-59.956665,7.606527],[-30.437977,-60.554955,8.066180],[-5.724319,-62.228874,8.745907],[-30.092186,-62.428009,8.443842],[-31.623192,-61.554596,9.254900],[-5.772683,-62.345642,8.571249],[-30.551252,-60.828423,7.623180],[-5.887153,-62.621994,2.500000],[-5.807959,-62.430801,8.443842],[-5.887153,-62.621994,7.487133]]);


}





function 820_BUTTON_A_triangles() = [
[2,1,0],[3,2,0],[6,5,4],[7,6,4],[10,9,8],[11,10,8],[3,0,9],[10,3,9],[0,7,12],[9,0,12],[13,8,9],[12,13,9],[7,4,14],[12,7,14],[12,14,15],[13,12,15],[18,17,16],[19,18,16],[11,8,17],[18,11,17],[20,16,17],[17,8,13],[17,13,20],[23,22,21],[24,23,21],[19,16,22],[23,19,22],[16,20,25],[22,16,25],[26,21,22],[25,26,22],[20,28,27],[25,20,27],[25,27,29],[26,25,29],[32,31,30],[33,32,30],[24,21,31],[32,24,31],[34,30,31],[31,21,26],[31,26,34],[37,36,35],[38,37,35],[33,30,36],[37,33,36],[30,34,39],[36,30,39],[40,35,36],[39,40,36],[34,42,41],[39,34,41],[39,41,43],[40,39,43],[46,45,44],[47,46,44],[38,35,45],[46,38,45],[35,40,48],[45,35,48],[49,44,45],[48,49,45],[40,43,50],[48,40,50],[48,50,51],[49,48,51],[54,53,52],[55,54,52],[47,44,53],[54,47,53],[44,49,56],[53,44,56],[57,52,53],[56,57,53],[49,51,58],[56,49,58],[56,58,59],[57,56,59],[62,61,60],[63,62,60],[55,52,61],[62,55,61],[52,57,64],[61,52,64],[65,60,61],[64,65,61],[57,59,66],[64,57,66],[64,66,67],[65,64,67],[60,65,68],[69,60,68],[69,68,70],[70,72,71],[70,71,69],[68,74,73],[70,68,73],[70,73,75],[72,70,75],[71,72,76],[76,78,77],[76,77,71],[72,75,79],[76,72,79],[76,79,80],[78,76,80],[77,78,81],[82,77,81],[82,81,83],[83,85,84],[83,84,82],[81,87,86],[83,81,86],[83,86,88],[85,83,88],[84,85,89],[89,91,90],[89,90,84],[85,88,92],[89,85,92],[89,92,93],[91,89,93],[91,93,94],[95,91,94],[97,96,2],[97,2,3],[2,96,98],[10,99,97],[3,10,97],[18,100,99],[11,18,99],[1,98,101],[2,98,1],[101,102,1],[10,11,99],[6,7,0],[1,6,0],[19,100,18],[23,100,19],[100,23,103],[23,24,103],[32,104,103],[24,32,103],[37,105,104],[33,37,104],[46,106,105],[38,46,105],[32,33,104],[37,38,105],[46,47,106],[107,106,47],[6,102,108],[1,102,6],[108,5,6],[20,13,15],[28,20,15],[5,110,109],[4,5,109],[110,5,108],[15,14,111],[109,111,14],[28,15,111],[112,28,111],[109,14,4],[27,28,112],[29,42,34],[26,29,34],[41,42,113],[114,113,42],[29,114,42],[29,27,114],[27,112,114],[50,43,115],[50,116,51],[116,50,115],[113,115,41],[41,115,43],[55,107,54],[107,55,117],[117,55,62],[63,118,117],[62,63,117],[118,69,119],[63,60,69],[63,69,118],[67,74,68],[65,67,68],[71,119,69],[120,119,71],[82,121,120],[77,82,120],[84,122,121],[82,84,121],[90,123,122],[84,90,122],[125,124,123],[90,125,123],[80,87,81],[78,80,81],[90,95,125],[95,90,91],[71,77,120],[59,58,126],[66,59,126],[128,127,74],[67,128,74],[73,74,127],[67,66,128],[58,116,126],[66,126,128],[79,75,129],[73,127,129],[130,79,129],[75,73,129],[51,116,58],[130,131,87],[80,130,87],[86,87,131],[95,132,125],[92,88,133],[132,95,94],[88,86,133],[86,131,133],[94,93,134],[134,135,94],[132,94,135],[133,134,92],[92,134,93],[130,80,79],[47,54,107],[138,137,136],[139,138,136],[141,139,140],[140,143,142],[140,142,141],[139,136,144],[140,139,144],[140,144,145],[143,140,145],[142,143,146],[147,142,146],[147,146,148],[148,150,149],[148,149,147],[146,152,151],[148,146,151],[148,151,153],[150,148,153],[149,150,154],[154,156,155],[154,155,149],[150,153,157],[154,150,157],[154,157,158],[156,154,158],[155,156,159],[159,161,160],[159,160,155],[156,158,162],[159,156,162],[159,162,163],[161,159,163],[160,161,164],[165,160,164],[168,167,166],[169,168,166],[170,165,167],[168,170,167],[165,164,171],[167,165,171],[172,166,167],[171,172,167],[164,174,173],[171,164,173],[171,173,175],[172,171,175],[178,177,176],[179,178,176],[169,166,177],[178,169,177],[166,172,180],[177,166,180],[181,176,177],[180,181,177],[172,175,182],[180,172,182],[180,182,183],[181,180,183],[186,185,184],[187,186,184],[179,176,185],[186,179,185],[176,181,188],[185,176,188],[189,184,185],[188,189,185],[181,183,190],[188,181,190],[188,190,191],[189,188,191],[194,193,192],[195,194,192],[187,184,193],[194,187,193],[196,192,193],[193,184,189],[193,189,196],[199,198,197],[200,199,197],[195,192,198],[199,195,198],[192,196,201],[198,192,201],[202,197,198],[201,202,198],[196,204,203],[201,196,203],[201,203,205],[202,201,205],[208,207,206],[209,208,206],[200,197,207],[208,200,207],[197,202,210],[207,197,210],[211,206,207],[210,211,207],[202,205,212],[210,202,212],[210,212,213],[211,210,213],[216,215,214],[217,216,214],[209,206,215],[216,209,215],[206,211,218],[215,206,218],[219,214,215],[218,219,215],[211,213,220],[218,211,220],[218,220,221],[219,218,221],[224,223,222],[225,224,222],[217,214,223],[224,217,223],[226,222,223],[223,214,219],[223,219,226],[225,222,227],[228,225,227],[230,229,141],[231,230,141],[141,229,138],[142,232,231],[141,142,231],[232,142,147],[233,232,147],[138,234,137],[229,234,138],[141,138,139],[145,152,146],[143,145,146],[149,235,233],[147,149,233],[155,236,235],[149,155,235],[168,238,237],[170,168,237],[237,236,160],[170,237,160],[236,155,160],[168,169,238],[169,178,239],[160,165,170],[238,169,239],[136,137,240],[144,136,240],[242,241,152],[145,242,152],[151,152,241],[145,144,242],[137,243,240],[144,240,242],[244,151,241],[153,244,157],[153,151,244],[243,137,234],[158,157,245],[162,158,245],[164,161,163],[174,164,163],[163,162,246],[246,162,245],[174,163,246],[247,174,246],[175,173,248],[247,248,173],[175,248,182],[247,173,174],[245,157,244],[186,249,239],[179,186,239],[187,250,249],[186,187,249],[195,251,250],[194,195,250],[200,252,251],[199,200,251],[187,194,250],[195,199,251],[208,252,200],[253,208,209],[208,253,252],[209,216,253],[217,254,253],[216,217,253],[225,255,254],[224,225,254],[255,228,256],[217,224,254],[225,228,255],[228,227,257],[256,228,257],[183,182,258],[190,183,258],[196,189,191],[204,196,191],[191,190,259],[259,190,258],[204,191,259],[260,204,259],[204,260,261],[203,204,261],[203,261,205],[258,182,248],[221,226,219],[263,262,226],[227,262,257],[226,262,227],[226,264,263],[265,212,261],[212,265,213],[213,265,220],[221,220,266],[221,266,226],[264,226,266],[266,220,265],[261,212,205],[222,226,227],[178,179,239],[269,268,267],[270,267,268],[271,270,268],[272,270,271],[273,272,271],[274,273,271],[271,268,275],[271,275,274],[278,277,276],[276,273,274],[276,274,278],[279,272,273],[276,279,273],[280,279,276],[277,280,276],[281,280,277],[282,281,277],[283,281,282],[284,283,282],[285,284,282],[282,277,278],[282,278,285],[286,285,278],[278,274,287],[278,287,286],[290,289,288],[288,285,286],[288,286,290],[288,292,291],[291,284,285],[291,285,288],[293,283,284],[291,293,284],[294,293,291],[292,294,291],[295,294,292],[296,295,292],[297,295,296],[298,297,296],[289,298,296],[296,292,288],[296,288,289],[301,300,299],[299,298,289],[299,289,301],[302,297,298],[299,302,298],[303,302,299],[300,303,299],[303,300,304],[307,306,305],[305,309,308],[305,308,307],[305,306,310],[311,305,310],[309,305,311],[312,309,311],[314,308,313],[313,316,315],[313,315,314],[317,309,312],[318,317,312],[319,317,318],[320,319,318],[308,309,317],[317,319,313],[317,313,308],[313,319,321],[321,322,316],[321,316,313],[321,319,320],[323,321,320],[322,321,323],[324,322,323],[325,322,324],[326,325,324],[327,325,326],[328,327,326],[316,322,325],[325,327,329],[325,329,316],[329,327,330],[330,332,331],[330,331,329],[330,327,328],[333,330,328],[332,330,333],[334,332,333],[315,316,329],[329,331,335],[329,335,315],[336,332,334],[337,336,334],[338,336,337],[339,338,337],[331,332,336],[336,338,340],[336,340,331],[341,338,339],[265,261,302],[302,303,265],[266,303,304],[265,303,266],[302,261,297],[258,293,259],[297,260,295],[260,297,261],[295,260,259],[259,294,295],[264,304,301],[301,304,300],[264,301,342],[342,301,290],[293,294,259],[283,293,258],[289,290,301],[290,286,342],[343,286,287],[264,266,304],[283,258,248],[248,247,280],[280,281,248],[279,280,247],[283,248,281],[279,247,246],[246,245,272],[244,241,267],[270,245,244],[270,272,245],[279,246,272],[267,270,244],[274,275,287],[269,240,243],[240,269,242],[344,275,243],[269,275,268],[275,344,287],[243,275,269],[269,241,242],[287,344,343],[241,269,267],[315,345,342],[286,315,342],[340,345,335],[345,340,110],[110,341,109],[341,110,340],[341,339,111],[341,340,338],[315,335,345],[335,331,340],[109,341,111],[343,315,286],[337,334,114],[114,112,337],[339,337,112],[111,339,112],[114,334,113],[333,328,115],[328,326,115],[116,115,326],[333,115,113],[334,333,113],[326,324,116],[308,314,307],[324,323,126],[315,343,314],[307,314,346],[346,314,343],[306,307,135],[135,307,346],[133,135,134],[135,133,306],[306,133,131],[320,318,128],[128,318,127],[320,128,126],[323,320,126],[127,318,312],[312,311,129],[311,310,129],[130,310,131],[310,130,129],[127,312,129],[131,310,306],[116,324,126],[349,348,347],[350,349,347],[353,352,351],[354,353,351],[347,354,355],[355,357,356],[355,356,347],[354,351,358],[355,354,358],[355,358,359],[357,355,359],[362,361,360],[363,362,360],[364,356,361],[362,364,361],[365,360,361],[361,356,357],[361,357,365],[368,367,366],[369,368,366],[363,360,367],[368,363,367],[360,365,370],[367,360,370],[371,366,367],[370,371,367],[365,373,372],[370,365,372],[370,372,374],[371,370,374],[377,376,375],[378,377,375],[369,366,376],[377,369,376],[366,371,379],[376,366,379],[380,375,376],[379,380,376],[371,374,381],[379,371,381],[379,381,382],[380,379,382],[385,384,383],[386,385,383],[378,375,384],[385,378,384],[387,383,384],[384,375,380],[384,380,387],[390,389,388],[391,390,388],[386,383,389],[390,386,389],[383,387,392],[389,383,392],[393,388,389],[392,393,389],[387,395,394],[392,387,394],[392,394,396],[393,392,396],[399,398,397],[400,399,397],[391,388,398],[399,391,398],[388,393,401],[398,388,401],[402,397,398],[401,402,398],[393,396,403],[401,393,403],[401,403,404],[402,401,404],[407,406,405],[408,407,405],[400,397,406],[407,400,406],[397,402,409],[406,397,409],[410,405,406],[409,410,406],[402,404,411],[409,402,411],[409,411,412],[410,409,412],[415,414,413],[416,415,413],[408,405,414],[415,408,414],[417,413,414],[414,405,410],[414,410,417],[420,419,418],[421,420,418],[416,413,419],[420,416,419],[413,417,422],[419,413,422],[423,418,419],[422,423,419],[417,425,424],[422,417,424],[422,424,426],[423,422,426],[429,428,427],[430,429,427],[421,418,428],[429,421,428],[418,423,431],[428,418,431],[432,427,428],[431,432,428],[423,426,433],[431,423,433],[431,433,434],[432,431,434],[437,436,435],[438,437,435],[430,427,436],[437,430,436],[427,432,439],[436,427,439],[440,435,436],[439,440,436],[432,434,441],[439,432,441],[439,441,442],[440,439,442],[445,444,443],[446,445,443],[438,435,444],[445,438,444],[447,443,444],[444,435,440],[444,440,447],[450,449,448],[451,450,448],[446,443,449],[450,446,449],[443,447,452],[449,443,452],[453,448,449],[452,453,449],[447,455,454],[452,447,454],[452,454,456],[453,452,456],[451,448,457],[458,451,457],[453,456,459],[460,453,459],[462,461,349],[462,349,350],[349,461,463],[464,364,362],[347,356,364],[350,347,364],[462,350,364],[464,462,364],[465,464,362],[348,349,463],[353,354,347],[348,353,347],[348,463,466],[362,363,465],[465,363,368],[467,465,368],[377,467,369],[467,377,468],[369,467,368],[468,377,378],[390,470,469],[386,390,469],[385,469,468],[378,385,468],[399,471,470],[391,399,470],[385,386,469],[390,391,470],[399,400,471],[407,472,471],[400,407,471],[353,466,473],[348,466,353],[353,473,352],[359,373,365],[357,359,365],[352,473,474],[352,474,475],[351,352,475],[351,475,358],[359,358,476],[476,477,373],[359,476,373],[476,358,475],[374,372,478],[381,374,478],[382,395,387],[380,382,387],[480,479,395],[382,480,395],[382,381,480],[372,477,478],[480,381,478],[396,394,481],[396,481,482],[403,396,482],[481,394,479],[395,479,394],[477,372,373],[472,407,408],[415,483,472],[408,415,472],[483,415,416],[429,485,484],[421,429,484],[420,484,483],[416,420,483],[430,437,485],[485,429,430],[484,420,421],[486,485,437],[445,486,438],[486,445,487],[438,486,437],[487,446,450],[458,489,488],[451,458,488],[488,487,450],[446,487,445],[450,451,488],[490,458,457],[458,490,489],[453,460,457],[448,453,457],[457,491,490],[460,491,457],[411,404,482],[412,411,492],[412,425,417],[410,412,417],[426,424,493],[424,425,494],[492,494,425],[412,492,425],[411,482,492],[434,433,495],[493,495,433],[441,434,495],[494,493,424],[426,493,433],[482,404,403],[447,440,442],[455,447,442],[442,441,496],[460,497,491],[459,497,460],[454,455,498],[496,498,455],[442,496,455],[499,454,498],[459,456,499],[499,500,459],[497,459,500],[499,456,454],[496,441,495],[503,502,501],[504,503,501],[507,506,505],[508,507,505],[511,510,509],[512,511,509],[504,501,510],[511,504,510],[501,508,513],[510,501,513],[514,509,510],[513,514,510],[508,505,515],[513,508,515],[513,515,516],[514,513,516],[519,518,517],[520,519,517],[512,509,518],[519,512,518],[521,517,518],[518,509,514],[518,514,521],[524,523,522],[525,524,522],[520,517,523],[524,520,523],[517,521,526],[523,517,526],[527,522,523],[526,527,523],[521,529,528],[526,521,528],[526,528,530],[527,526,530],[533,532,531],[534,533,531],[525,522,532],[533,525,532],[522,527,535],[532,522,535],[536,531,532],[535,536,532],[527,530,537],[535,527,537],[535,537,538],[536,535,538],[541,540,539],[542,541,539],[534,531,540],[541,534,540],[531,536,543],[540,531,543],[544,539,540],[543,544,540],[536,538,545],[543,536,545],[543,545,546],[544,543,546],[549,548,547],[550,549,547],[542,539,548],[549,542,548],[551,547,548],[548,539,544],[548,544,551],[554,553,552],[555,554,552],[550,547,553],[554,550,553],[547,551,556],[553,547,556],[557,552,553],[556,557,553],[551,559,558],[556,551,558],[556,558,560],[557,556,560],[563,562,561],[564,563,561],[555,552,562],[563,555,562],[552,557,565],[562,552,565],[566,561,562],[565,566,562],[557,560,567],[565,557,567],[565,567,568],[566,565,568],[571,570,569],[572,571,569],[564,561,570],[571,564,570],[561,566,573],[570,561,573],[574,569,570],[573,574,570],[566,568,575],[573,566,575],[573,575,576],[574,573,576],[579,578,577],[580,579,577],[572,569,578],[579,572,578],[581,577,578],[578,569,574],[578,574,581],[584,583,582],[585,584,582],[580,577,583],[584,580,583],[577,581,586],[583,577,586],[587,582,583],[586,587,583],[581,589,588],[586,581,588],[586,588,590],[587,586,590],[593,592,591],[594,593,591],[585,582,592],[593,585,592],[582,587,595],[592,582,595],[596,591,592],[595,596,592],[587,590,597],[595,587,597],[595,597,598],[596,595,598],[601,600,599],[602,601,599],[594,591,600],[601,594,600],[591,596,603],[600,591,603],[604,599,600],[603,604,600],[596,598,605],[603,596,605],[603,605,606],[604,603,606],[609,608,607],[610,609,607],[602,599,608],[609,602,608],[611,607,608],[608,599,604],[608,604,611],[610,607,612],[613,610,612],[614,503,504],[503,614,615],[503,615,616],[512,617,614],[511,512,614],[511,614,504],[502,616,618],[503,616,502],[618,507,502],[512,519,617],[507,508,501],[502,507,501],[519,520,619],[617,519,619],[620,524,525],[524,620,619],[524,619,520],[620,525,533],[542,622,621],[541,542,621],[534,621,620],[533,534,620],[550,623,622],[549,550,622],[534,541,621],[542,549,622],[550,554,623],[555,623,554],[507,624,506],[624,507,618],[506,624,625],[516,529,521],[514,516,521],[626,506,625],[506,626,505],[505,626,515],[516,515,627],[627,628,529],[516,627,529],[627,515,626],[530,528,629],[537,530,629],[545,538,630],[546,559,551],[544,546,551],[538,537,630],[528,628,629],[537,629,630],[632,631,559],[546,632,559],[559,631,558],[630,632,545],[545,632,546],[628,528,529],[633,555,563],[555,633,623],[564,634,633],[563,564,633],[572,635,634],[571,572,634],[580,636,635],[579,580,635],[564,571,634],[585,637,584],[636,580,584],[635,572,579],[636,584,637],[638,593,594],[593,638,637],[593,637,585],[638,594,601],[610,640,639],[609,610,639],[602,639,638],[601,602,638],[640,613,641],[602,609,639],[610,613,640],[613,612,642],[641,613,642],[560,558,643],[567,560,643],[575,568,644],[576,589,581],[574,576,581],[568,567,644],[644,567,643],[576,575,645],[645,575,644],[588,589,646],[645,646,589],[576,645,589],[647,588,646],[643,558,631],[597,590,647],[648,612,611],[612,648,642],[604,606,611],[611,649,648],[611,650,649],[651,597,647],[597,651,598],[598,651,605],[606,605,652],[606,652,611],[650,611,652],[652,605,651],[647,590,588],[612,607,611],[655,654,653],[653,657,656],[653,656,655],[653,654,658],[659,653,658],[657,653,659],[660,657,659],[662,656,661],[661,664,663],[661,663,662],[665,657,660],[666,665,660],[667,665,666],[668,667,666],[656,657,665],[665,667,661],[665,661,656],[661,667,669],[669,670,664],[669,664,661],[669,667,668],[671,669,668],[670,669,671],[672,670,671],[675,674,673],[676,673,674],[677,676,674],[678,676,677],[679,678,677],[680,679,677],[677,674,681],[677,681,680],[684,683,682],[682,679,680],[682,680,684],[685,678,679],[682,685,679],[686,685,682],[683,686,682],[687,686,683],[688,687,683],[689,687,688],[690,689,688],[691,690,688],[688,683,684],[688,684,691],[663,691,684],[684,680,662],[684,662,663],[694,693,692],[692,691,663],[692,663,694],[692,696,695],[695,690,691],[695,691,692],[697,689,690],[695,697,690],[698,697,695],[696,698,695],[699,698,696],[700,699,696],[701,699,700],[702,701,700],[693,702,700],[700,696,692],[700,692,693],[705,704,703],[703,702,693],[703,693,705],[706,701,702],[703,706,702],[707,706,703],[704,707,703],[707,704,708],[709,670,672],[710,709,672],[711,709,710],[712,711,710],[664,670,709],[709,711,713],[709,713,664],[713,711,714],[714,716,715],[714,715,713],[714,711,712],[717,714,712],[716,714,717],[718,716,717],[663,664,713],[713,715,694],[713,694,663],[719,716,718],[720,719,718],[721,719,720],[722,721,720],[715,716,719],[719,721,723],[719,723,715],[724,721,722],[652,651,707],[706,707,651],[708,652,707],[706,651,647],[644,698,645],[647,646,701],[647,701,706],[646,645,699],[699,701,646],[650,708,705],[705,708,704],[650,705,725],[705,693,694],[698,699,645],[689,697,644],[697,698,644],[650,652,708],[689,644,643],[643,631,687],[686,687,631],[686,631,632],[689,643,687],[686,632,685],[632,630,678],[673,629,628],[629,676,630],[628,627,673],[685,632,678],[676,678,630],[673,676,629],[626,625,675],[726,681,625],[675,681,674],[726,662,681],[625,681,675],[675,627,626],[681,662,680],[627,675,673],[694,725,705],[724,723,721],[723,724,474],[475,474,724],[725,694,723],[724,722,476],[723,694,715],[722,720,477],[475,724,476],[725,723,474],[478,477,720],[722,477,476],[480,478,718],[720,718,478],[480,718,717],[717,712,479],[481,712,710],[712,481,479],[481,710,672],[480,717,479],[671,668,492],[668,666,494],[482,672,671],[655,656,662],[499,654,500],[499,498,654],[500,654,655],[726,500,655],[726,655,662],[493,660,659],[660,493,494],[494,666,660],[492,668,494],[482,671,492],[659,658,495],[496,658,498],[658,496,495],[493,659,495],[498,658,654],[481,672,482],[729,728,727],[730,729,727],[733,732,731],[734,733,731],[727,734,735],[735,737,736],[735,736,727],[734,731,738],[735,734,738],[735,738,739],[737,735,739],[742,741,740],[743,742,740],[744,736,741],[742,744,741],[745,740,741],[741,736,737],[741,737,745],[748,747,746],[749,748,746],[743,740,747],[748,743,747],[740,745,750],[747,740,750],[751,746,747],[750,751,747],[745,753,752],[750,745,752],[750,752,754],[751,750,754],[757,756,755],[758,757,755],[749,746,756],[757,749,756],[746,751,759],[756,746,759],[760,755,756],[759,760,756],[751,754,761],[759,751,761],[759,761,762],[760,759,762],[765,764,763],[766,765,763],[758,755,764],[765,758,764],[767,763,764],[764,755,760],[764,760,767],[770,769,768],[771,770,768],[766,763,769],[770,766,769],[763,767,772],[769,763,772],[773,768,769],[772,773,769],[767,775,774],[772,767,774],[772,774,776],[773,772,776],[779,778,777],[780,779,777],[771,768,778],[779,771,778],[768,773,781],[778,768,781],[782,777,778],[781,782,778],[773,776,783],[781,773,783],[781,783,784],[782,781,784],[787,786,785],[788,787,785],[780,777,786],[787,780,786],[777,782,789],[786,777,789],[790,785,786],[789,790,786],[782,784,791],[789,782,791],[789,791,792],[790,789,792],[795,794,793],[796,795,793],[788,785,794],[795,788,794],[797,793,794],[794,785,790],[794,790,797],[800,799,798],[801,800,798],[796,793,799],[800,796,799],[793,797,802],[799,793,802],[803,798,799],[802,803,799],[797,805,804],[802,797,804],[802,804,806],[803,802,806],[809,808,807],[810,809,807],[801,798,808],[809,801,808],[798,803,811],[808,798,811],[812,807,808],[811,812,808],[803,806,813],[811,803,813],[811,813,814],[812,811,814],[817,816,815],[818,817,815],[810,807,816],[817,810,816],[807,812,819],[816,807,819],[820,815,816],[819,820,816],[812,814,821],[819,812,821],[819,821,822],[820,819,822],[825,824,823],[826,825,823],[818,815,824],[825,818,824],[815,820,827],[824,815,827],[828,823,824],[827,828,824],[820,822,829],[827,820,829],[827,829,830],[828,827,830],[833,832,831],[834,833,831],[826,823,832],[833,826,832],[835,831,832],[832,823,828],[832,828,835],[834,831,836],[837,834,836],[839,838,729],[839,729,730],[729,838,840],[744,841,839],[730,744,839],[742,842,841],[744,742,841],[728,840,843],[729,840,728],[844,733,728],[843,844,728],[733,734,727],[728,733,727],[727,736,744],[730,727,744],[743,842,742],[748,842,743],[842,748,845],[845,748,749],[757,846,845],[749,757,845],[770,848,847],[766,770,847],[765,847,846],[758,765,846],[757,758,846],[848,771,779],[849,848,779],[848,770,771],[847,765,766],[733,844,732],[732,844,850],[739,753,745],[737,739,745],[731,732,851],[851,732,850],[731,851,738],[738,851,852],[852,853,753],[739,852,753],[752,753,853],[852,739,738],[754,752,854],[761,754,854],[762,775,767],[760,762,767],[856,855,775],[762,856,775],[762,761,856],[761,854,856],[776,774,857],[783,857,858],[784,783,858],[857,783,776],[857,774,855],[855,774,775],[854,752,853],[787,859,849],[780,787,849],[795,860,859],[788,795,859],[800,861,860],[796,800,860],[809,862,861],[801,809,861],[787,788,859],[861,800,801],[860,795,796],[810,862,809],[817,862,810],[862,817,863],[863,817,818],[825,864,863],[818,825,863],[837,866,865],[834,837,865],[833,865,864],[826,833,864],[825,826,864],[837,836,867],[866,837,867],[865,833,834],[791,784,858],[792,805,797],[790,792,797],[804,805,868],[869,868,805],[792,869,805],[792,791,869],[791,858,869],[813,806,870],[813,871,814],[871,813,870],[868,870,804],[804,870,806],[830,835,828],[873,836,872],[836,873,867],[835,874,872],[835,872,836],[875,874,835],[814,871,876],[821,814,876],[821,876,822],[822,876,829],[830,829,877],[830,877,835],[875,835,877],[877,829,876],[831,835,836],[849,779,780],[880,879,878],[881,880,878],[884,883,882],[885,884,882],[888,887,886],[889,888,886],[881,878,887],[888,881,887],[878,885,890],[887,878,890],[891,886,887],[890,891,887],[885,882,892],[890,885,892],[890,892,893],[891,890,893],[896,895,894],[897,896,894],[889,886,895],[896,889,895],[898,894,895],[895,886,891],[895,891,898],[901,900,899],[902,901,899],[897,894,900],[901,897,900],[894,898,903],[900,894,903],[904,899,900],[903,904,900],[898,906,905],[903,898,905],[903,905,907],[904,903,907],[910,909,908],[911,910,908],[902,899,909],[910,902,909],[899,904,912],[909,899,912],[913,908,909],[912,913,909],[904,907,914],[912,904,914],[912,914,915],[913,912,915],[918,917,916],[919,918,916],[911,908,917],[918,911,917],[908,913,920],[917,908,920],[921,916,917],[920,921,917],[913,915,922],[920,913,922],[920,922,923],[921,920,923],[926,925,924],[927,926,924],[919,916,925],[926,919,925],[928,924,925],[925,916,921],[925,921,928],[931,930,929],[932,931,929],[927,924,930],[931,927,930],[924,928,933],[930,924,933],[934,929,930],[933,934,930],[928,936,935],[933,928,935],[933,935,937],[934,933,937],[940,939,938],[941,940,938],[932,929,939],[940,932,939],[929,934,942],[939,929,942],[943,938,939],[942,943,939],[934,937,944],[942,934,944],[942,944,945],[943,942,945],[948,947,946],[949,948,946],[941,938,947],[948,941,947],[938,943,950],[947,938,950],[951,946,947],[950,951,947],[943,945,952],[950,943,952],[950,952,953],[951,950,953],[956,955,954],[957,956,954],[949,946,955],[956,949,955],[958,954,955],[955,946,951],[955,951,958],[961,960,959],[962,961,959],[957,954,960],[961,957,960],[954,958,963],[960,954,963],[964,959,960],[963,964,960],[958,966,965],[963,958,965],[963,965,967],[964,963,967],[970,969,968],[971,970,968],[962,959,969],[970,962,969],[959,964,972],[969,959,972],[973,968,969],[972,973,969],[964,967,974],[972,964,974],[972,974,975],[973,972,975],[978,977,976],[979,978,976],[971,968,977],[978,971,977],[968,973,980],[977,968,980],[981,976,977],[980,981,977],[973,975,982],[980,973,982],[980,982,983],[981,980,983],[986,985,984],[987,986,984],[979,976,985],[986,979,985],[988,984,985],[985,976,981],[985,981,988],[987,984,989],[990,987,989],[991,880,881],[880,991,992],[880,992,993],[889,994,991],[888,889,991],[888,991,881],[880,993,995],[879,880,995],[996,884,879],[995,996,879],[889,896,994],[896,897,997],[884,885,878],[879,884,878],[994,896,997],[998,901,902],[901,998,997],[901,997,897],[998,902,910],[919,1000,999],[918,919,999],[911,999,998],[910,911,998],[927,1001,1000],[926,927,1000],[911,918,999],[919,926,1000],[927,931,1001],[932,1001,931],[884,996,1002],[883,884,1002],[893,906,898],[891,893,898],[883,1002,1003],[1004,883,1003],[883,1004,882],[882,1004,892],[893,892,1005],[1005,1006,906],[893,1005,906],[1005,892,1004],[907,905,1007],[914,907,1007],[922,915,1008],[923,936,928],[921,923,928],[915,914,1008],[905,1006,1007],[914,1007,1008],[1010,1009,936],[923,1010,936],[936,1009,935],[1008,1010,922],[922,1010,923],[1006,905,906],[1011,932,940],[932,1011,1001],[941,1012,1011],[940,941,1011],[949,1013,1012],[948,949,1012],[957,1014,1013],[956,957,1013],[941,948,1012],[962,1015,961],[1014,957,961],[1013,949,956],[1014,961,1015],[1016,970,971],[970,1016,1015],[970,1015,962],[1016,971,978],[987,1018,1017],[986,987,1017],[979,1017,1016],[978,979,1016],[1018,990,1019],[979,986,1017],[987,990,1018],[990,989,1020],[1019,990,1020],[937,935,1021],[944,937,1021],[952,945,1022],[953,966,958],[951,953,958],[945,944,1022],[1022,944,1021],[953,952,1023],[1023,952,1022],[965,966,1024],[1023,1024,966],[953,1023,966],[1025,965,1024],[1021,935,1009],[974,967,1025],[1026,989,988],[989,1026,1020],[981,983,988],[988,1027,1026],[988,1028,1027],[1029,974,1025],[974,1029,975],[975,1029,982],[983,982,1030],[983,1030,988],[1028,988,1030],[1030,982,1029],[1025,967,965],[989,984,988],[1033,1032,1031],[1031,1035,1034],[1031,1034,1033],[1031,1032,1036],[1037,1031,1036],[1035,1031,1037],[1038,1035,1037],[1040,1034,1039],[1039,1042,1041],[1039,1041,1040],[1043,1035,1038],[1044,1043,1038],[1045,1043,1044],[1046,1045,1044],[1034,1035,1043],[1043,1045,1039],[1043,1039,1034],[1039,1045,1047],[1047,1048,1042],[1047,1042,1039],[1047,1045,1046],[1049,1047,1046],[1048,1047,1049],[1050,1048,1049],[1053,1052,1051],[1054,1051,1052],[1055,1054,1052],[1056,1054,1055],[1057,1056,1055],[1058,1057,1055],[1055,1052,1059],[1055,1059,1058],[1062,1061,1060],[1060,1057,1058],[1060,1058,1062],[1063,1056,1057],[1060,1063,1057],[1064,1063,1060],[1061,1064,1060],[1065,1064,1061],[1066,1065,1061],[1067,1065,1066],[1068,1067,1066],[1069,1068,1066],[1066,1061,1062],[1066,1062,1069],[1041,1069,1062],[1062,1058,1040],[1062,1040,1041],[1072,1071,1070],[1070,1069,1041],[1070,1041,1072],[1070,1074,1073],[1073,1068,1069],[1073,1069,1070],[1075,1067,1068],[1073,1075,1068],[1076,1075,1073],[1074,1076,1073],[1077,1076,1074],[1078,1077,1074],[1079,1077,1078],[1080,1079,1078],[1071,1080,1078],[1078,1074,1070],[1078,1070,1071],[1083,1082,1081],[1081,1080,1071],[1081,1071,1083],[1084,1079,1080],[1081,1084,1080],[1085,1084,1081],[1082,1085,1081],[1085,1082,1086],[1087,1048,1050],[1088,1087,1050],[1089,1087,1088],[1090,1089,1088],[1042,1048,1087],[1087,1089,1091],[1087,1091,1042],[1091,1089,1092],[1092,1094,1093],[1092,1093,1091],[1092,1089,1090],[1095,1092,1090],[1094,1092,1095],[1096,1094,1095],[1041,1042,1091],[1091,1093,1072],[1091,1072,1041],[1097,1094,1096],[1098,1097,1096],[1099,1097,1098],[1100,1099,1098],[1093,1094,1097],[1097,1099,1101],[1097,1101,1093],[1102,1099,1100],[1030,1029,1085],[1084,1085,1029],[1086,1030,1085],[1084,1029,1025],[1023,1022,1076],[1024,1079,1025],[1077,1024,1023],[1022,1021,1067],[1084,1025,1079],[1028,1030,1086],[1083,1086,1082],[1086,1083,1028],[1103,1028,1083],[1076,1077,1023],[1067,1075,1022],[1075,1076,1022],[1077,1079,1024],[1067,1021,1065],[1065,1009,1064],[1009,1065,1021],[1064,1009,1010],[1064,1010,1063],[1010,1008,1056],[1051,1007,1006],[1007,1054,1008],[1006,1005,1051],[1063,1010,1056],[1054,1056,1008],[1051,1054,1007],[1004,1003,1053],[1104,1059,1003],[1053,1059,1052],[1104,1040,1059],[1003,1059,1053],[1053,1005,1004],[1059,1040,1058],[1005,1053,1051],[1083,1071,1072],[850,1101,1102],[1101,850,1103],[851,850,1102],[1102,1100,852],[1101,1072,1093],[1072,1101,1103],[1102,1101,1099],[851,1102,852],[1072,1103,1083],[1098,1096,854],[854,853,1098],[1100,1098,853],[852,1100,853],[854,1096,856],[1095,1090,855],[857,855,1090],[1095,855,856],[1096,1095,856],[1090,1088,857],[857,1088,1050],[1049,1046,869],[1046,1044,868],[858,1050,1049],[1034,1040,1033],[1032,1033,875],[875,877,1032],[1104,875,1033],[1104,1033,1040],[870,1038,1037],[1038,870,868],[868,1044,1038],[869,1046,868],[858,1049,869],[1037,1036,871],[876,1036,877],[1036,876,871],[870,1037,871],[877,1036,1032],[858,857,1050],[1107,1106,1105],[1108,1107,1105],[1110,1109,1108],[1105,1110,1108],[1113,1112,1111],[1114,1113,1111],[1114,1116,1115],[1113,1114,1115],[1119,1118,1117],[1121,1120,1119],[1117,1122,1121],[1121,1119,1117],[1119,1124,1123],[1123,1125,1118],[1123,1118,1119],[1126,1124,1119],[1120,1126,1119],[1129,1128,1127],[1127,1126,1120],[1127,1120,1129],[1128,1131,1130],[1134,1133,1132],[1135,1134,1132],[1134,1137,1136],[1136,1138,1133],[1136,1133,1134],[1141,1140,1139],[1139,1137,1134],[1139,1134,1141],[1141,1134,1135],[1142,1141,1135],[1144,1143,1138],[1136,1144,1138],[1145,1144,1136],[1137,1145,1136],[1146,1145,1137],[1139,1146,1137],[1147,1146,1139],[1140,1147,1139],[1148,1147,1140],[1149,1148,1140],[1150,1148,1149],[1151,1150,1149],[1150,1151,1118],[1118,1152,1150],[1153,1141,1142],[1154,1153,1142],[1153,1151,1149],[1149,1140,1141],[1149,1141,1153],[1118,1151,1153],[1117,1118,1153],[1117,1153,1154],[1122,1117,1154],[1157,1156,1155],[1159,1158,1157],[1155,1160,1159],[1159,1157,1155],[1160,1155,1161],[1163,1162,1156],[1164,1163,1156],[1165,1163,1164],[1166,1165,1164],[1167,1157,1158],[1168,1167,1158],[1167,1166,1164],[1164,1156,1157],[1164,1157,1167],[1138,1166,1167],[1133,1138,1167],[1133,1167,1168],[1132,1133,1168],[1171,1170,1169],[1174,1173,1172],[1172,1169,1175],[1172,1175,1174],[1178,1177,1176],[1176,1173,1174],[1176,1174,1178],[1177,1178,1160],[1159,1160,1178],[1178,1174,1179],[1178,1179,1159],[1182,1181,1180],[1183,1182,1180],[1182,1142,1135],[1135,1132,1181],[1135,1181,1182],[1184,1122,1154],[1154,1142,1182],[1154,1182,1184],[1184,1182,1183],[1185,1184,1183],[1188,1187,1186],[1189,1188,1186],[1158,1159,1187],[1188,1158,1187],[1181,1132,1168],[1168,1158,1188],[1168,1188,1181],[1181,1188,1189],[1180,1181,1189],[1192,1191,1190],[1190,1194,1193],[1190,1193,1192],[1195,1185,1192],[1193,1195,1192],[1198,1197,1196],[1196,1200,1199],[1196,1199,1198],[1183,1180,1198],[1199,1183,1198],[1185,1183,1199],[1192,1185,1199],[1199,1200,1201],[1201,1191,1192],[1201,1192,1199],[1204,1203,1202],[1202,1206,1205],[1202,1205,1204],[1189,1186,1204],[1205,1189,1204],[1180,1189,1205],[1198,1180,1205],[1205,1206,1207],[1207,1197,1198],[1207,1198,1205],[1210,1209,1208],[1211,1210,1208],[1212,1210,1211],[1213,1212,1211],[1216,1215,1214],[1209,1216,1214],[1190,1191,1215],[1216,1190,1215],[1194,1190,1216],[1217,1194,1216],[1216,1209,1210],[1210,1212,1217],[1210,1217,1216],[1220,1219,1218],[1221,1220,1218],[1222,1220,1221],[1223,1222,1221],[1224,1222,1223],[1225,1224,1223],[1226,1224,1225],[1227,1226,1225],[1228,1219,1220],[1220,1222,1229],[1220,1229,1228],[1196,1197,1228],[1229,1196,1228],[1200,1196,1229],[1230,1200,1229],[1229,1222,1224],[1224,1226,1230],[1224,1230,1229],[1230,1226,1231],[1231,1233,1232],[1231,1232,1230],[1201,1200,1230],[1232,1201,1230],[1191,1201,1232],[1215,1191,1232],[1232,1233,1234],[1234,1214,1215],[1234,1215,1232],[1231,1226,1227],[1235,1231,1227],[1233,1231,1235],[1236,1233,1235],[1234,1233,1236],[1237,1234,1236],[1214,1234,1237],[1238,1214,1237],[1241,1240,1239],[1242,1241,1239],[1243,1241,1242],[1244,1243,1242],[1247,1246,1245],[1240,1247,1245],[1202,1203,1246],[1247,1202,1246],[1206,1202,1247],[1248,1206,1247],[1247,1240,1241],[1241,1243,1248],[1241,1248,1247],[1248,1243,1249],[1249,1251,1250],[1249,1250,1248],[1207,1206,1248],[1250,1207,1248],[1197,1207,1250],[1228,1197,1250],[1228,1250,1251],[1219,1228,1251],[1249,1243,1244],[1252,1249,1244],[1251,1249,1252],[1253,1251,1252],[1256,1255,1254],[1257,1256,1254],[1258,1245,1246],[1259,1256,1258],[1246,1203,1259],[1259,1258,1246],[1130,838,839],[838,1130,1131],[1130,839,841],[841,1128,1130],[1131,1128,1129],[1127,841,842],[841,1127,1128],[1260,838,1131],[842,845,1124],[842,1126,1127],[846,1123,845],[842,1124,1126],[1123,1124,845],[1152,1118,846],[846,1118,1125],[1125,1123,846],[846,847,1152],[1129,1120,1121],[1152,847,1150],[1261,1260,1121],[1122,1184,1121],[1129,1121,1260],[1131,1129,1260],[847,848,1147],[847,1148,1150],[849,1144,848],[847,1147,1148],[1146,1147,848],[1144,1145,848],[1145,1146,848],[1144,849,1143],[1161,860,861],[1161,1155,860],[861,862,1177],[1160,861,1177],[1161,861,1160],[1176,862,863],[1176,1177,862],[1176,863,1173],[1171,864,865],[864,1171,1169],[865,866,1171],[1170,1171,866],[1169,1172,864],[863,1172,1173],[1170,1175,1169],[863,864,1172],[1170,866,1262],[859,860,1162],[859,1165,849],[1138,1143,1165],[1166,1138,1165],[1162,1163,859],[1163,1165,859],[1155,1156,1162],[1175,1262,1263],[1175,1170,1262],[1179,1174,1175],[1263,1179,1175],[1179,1264,1187],[1263,1264,1179],[1159,1179,1187],[860,1155,1162],[1143,849,1165],[1121,1195,1261],[1266,1265,1193],[1195,1193,1265],[1194,1266,1193],[1184,1195,1121],[1267,1194,1217],[1194,1267,1266],[1217,1212,1267],[254,1212,1213],[1184,1185,1195],[1208,1209,1214],[1238,1208,1214],[1213,1211,253],[1208,1238,252],[252,1211,1208],[1267,1212,254],[1261,1195,1265],[1237,251,1238],[1237,1236,251],[250,251,1236],[252,1238,251],[255,256,1267],[1211,252,253],[254,255,1267],[254,1213,253],[1235,1227,250],[1225,1223,249],[249,1227,1225],[1221,249,1223],[1221,239,249],[1227,249,250],[1236,1235,250],[1218,239,1221],[1186,1187,1268],[1203,1204,1259],[1204,1186,1269],[1218,1219,1251],[1253,1218,1251],[1240,1245,1239],[1259,1270,1255],[1270,1259,1269],[1186,1268,1269],[1259,1204,1269],[1259,1255,1256],[1258,1256,235],[1255,1271,1254],[1270,1271,1255],[236,1245,1258],[1268,1187,1264],[239,1218,1253],[1252,1244,238],[238,1253,1252],[237,1244,1242],[1244,237,238],[237,1239,236],[1239,237,1242],[1253,238,239],[1257,235,1256],[1254,233,1257],[235,1257,233],[235,236,1258],[232,233,1254],[230,231,1271],[1271,231,232],[1271,232,1254],[1239,1245,236],[1274,1273,1272],[1275,1274,1272],[1277,1276,1273],[1274,1277,1273],[1275,1278,1274],[1277,1274,1279],[1279,1274,1278],[1281,1280,1277],[1279,1281,1277],[1278,1282,1279],[1281,1279,1283],[1283,1279,1282],[1285,1280,1284],[1287,1284,1286],[1286,1284,1280],[1288,1286,1280],[1281,1288,1280],[1291,1290,1289],[1292,1291,1289],[1290,1291,1293],[1295,1293,1294],[1294,1293,1291],[1293,1297,1296],[1290,1293,1296],[1295,1298,1297],[1293,1295,1297],[1292,1299,1291],[1294,1291,1300],[1300,1291,1299],[1294,1300,1301],[1278,1301,1282],[1282,1301,1300],[1303,1302,1298],[1295,1303,1298],[1305,1304,1302],[1303,1305,1302],[1295,1294,1303],[1305,1303,1301],[1301,1303,1294],[1278,1275,1305],[1301,1278,1305],[1308,1307,1306],[1309,1308,1306],[1307,1308,1310],[1312,1310,1311],[1311,1310,1308],[1310,1314,1313],[1307,1310,1313],[1312,1315,1314],[1310,1312,1314],[1309,1316,1308],[1311,1308,1317],[1317,1308,1316],[1311,1317,1318],[1292,1318,1299],[1299,1318,1317],[1320,1319,1315],[1312,1320,1315],[1322,1321,1319],[1320,1322,1319],[1312,1311,1320],[1322,1320,1318],[1318,1320,1311],[1322,1318,1323],[1289,1323,1292],[1292,1323,1318],[1323,1324,1321],[1322,1323,1321],[1289,1325,1324],[1323,1289,1324],[1328,1327,1326],[1329,1328,1326],[1331,1326,1330],[1332,1330,1327],[1327,1330,1326],[1328,1334,1333],[1309,1333,1316],[1316,1333,1334],[1333,1335,1327],[1328,1333,1327],[1335,1333,1336],[1306,1336,1309],[1309,1336,1333],[1336,1338,1337],[1335,1336,1337],[1306,1339,1338],[1336,1306,1338],[1342,1341,1340],[1343,1342,1340],[1345,1342,1344],[1346,1344,1343],[1343,1344,1342],[1349,1348,1347],[1345,1347,1342],[1342,1347,1348],[1348,1350,1341],[1342,1348,1341],[1353,1352,1351],[1354,1353,1351],[1357,1356,1355],[1287,1357,1355],[1359,1358,1350],[1348,1359,1350],[1352,1359,1351],[1349,1351,1348],[1348,1351,1359],[1362,1361,1360],[1363,1362,1360],[1365,1364,1361],[1362,1365,1361],[1367,1366,1364],[1365,1367,1364],[1343,1340,1366],[1367,1343,1366],[1370,1369,1368],[1371,1370,1368],[1373,1372,1369],[1370,1373,1369],[1375,1374,1372],[1373,1375,1372],[1363,1360,1374],[1375,1363,1374],[1378,1377,1376],[1380,1376,1379],[1379,1376,1377],[1377,1382,1381],[1379,1377,1381],[1331,1384,1383],[1385,1331,1383],[1386,1376,1380],[1387,1386,1380],[1389,1388,1382],[1377,1389,1382],[1391,1389,1390],[1378,1390,1377],[1377,1390,1389],[1393,1371,1392],[1391,1392,1389],[1389,1392,1371],[1371,1368,1388],[1389,1371,1388],[1396,1395,1394],[1397,1396,1394],[1350,1396,1341],[1340,1341,1397],[1397,1341,1396],[1400,1399,1398],[1401,1400,1398],[1364,1400,1361],[1360,1361,1401],[1401,1361,1400],[1340,1397,1366],[1364,1366,1400],[1400,1366,1397],[1397,1394,1399],[1400,1397,1399],[1404,1403,1402],[1405,1404,1402],[1372,1404,1369],[1368,1369,1405],[1405,1369,1404],[1360,1401,1374],[1372,1374,1404],[1404,1374,1401],[1401,1398,1403],[1404,1401,1403],[1368,1405,1388],[1382,1388,1406],[1406,1388,1405],[1405,1402,1407],[1406,1405,1407],[1394,1408,1399],[1398,1399,1409],[1409,1399,1408],[1398,1409,1403],[1402,1403,1410],[1410,1403,1409],[1408,1412,1411],[1409,1408,1411],[1409,1411,1413],[1410,1409,1413],[1412,1415,1414],[1411,1412,1414],[1411,1414,1416],[1413,1411,1416],[1415,1418,1417],[1414,1415,1417],[1414,1417,1419],[1416,1414,1419],[1418,1421,1420],[1417,1418,1420],[1417,1420,1422],[1419,1417,1422],[1421,1424,1423],[1420,1421,1423],[1420,1423,1425],[1422,1420,1425],[1424,1427,1426],[1423,1424,1426],[1423,1426,1428],[1425,1423,1428],[1430,1426,1429],[1431,1429,1427],[1427,1429,1426],[1433,1428,1432],[1430,1432,1426],[1426,1432,1428],[1436,1435,1434],[1438,1434,1437],[1437,1434,1435],[1439,1437,1435],[1440,1439,1435],[1442,1441,1437],[1439,1442,1437],[1438,1437,1443],[1444,1443,1441],[1441,1443,1437],[1440,1431,1439],[1442,1439,1445],[1445,1439,1431],[1444,1441,1446],[1448,1446,1447],[1447,1446,1441],[1449,1447,1441],[1442,1449,1441],[1452,1451,1450],[1453,1452,1450],[1451,1452,1454],[1456,1454,1455],[1455,1454,1452],[1454,1458,1457],[1451,1454,1457],[1456,1459,1458],[1454,1456,1458],[1453,1430,1452],[1455,1452,1429],[1429,1452,1430],[1455,1429,1460],[1440,1460,1431],[1431,1460,1429],[1460,1461,1456],[1455,1460,1456],[1440,1435,1461],[1460,1440,1461],[1464,1463,1462],[1465,1464,1462],[1467,1466,1463],[1464,1467,1463],[1465,1433,1464],[1467,1464,1432],[1432,1464,1433],[1467,1432,1468],[1453,1468,1430],[1430,1468,1432],[1471,1470,1469],[1466,1471,1469],[1473,1472,1470],[1471,1473,1470],[1466,1467,1471],[1473,1471,1468],[1468,1471,1467],[1473,1468,1474],[1450,1474,1453],[1453,1474,1468],[1474,1475,1472],[1473,1474,1472],[1450,1476,1475],[1474,1450,1475],[1479,1478,1477],[1480,1479,1477],[1482,1477,1481],[1483,1481,1478],[1478,1481,1477],[1479,1485,1484],[1465,1484,1433],[1433,1484,1485],[1483,1478,1486],[1488,1486,1487],[1487,1486,1478],[1484,1487,1478],[1479,1484,1478],[1465,1462,1487],[1484,1465,1487],[1488,1487,1489],[1490,1489,1462],[1462,1489,1487],[1493,1492,1491],[1495,1491,1494],[1494,1491,1492],[1496,1491,1495],[1497,1496,1495],[1498,1493,1491],[1496,1498,1491],[1500,1499,1492],[1493,1500,1492],[1448,1502,1501],[1446,1448,1501],[1505,1504,1503],[1506,1505,1503],[1508,1507,1499],[1500,1508,1499],[1503,1508,1509],[1510,1509,1500],[1500,1509,1508],[1513,1512,1511],[1514,1513,1511],[1516,1515,1513],[1517,1516,1513],[1519,1518,1515],[1516,1519,1515],[1518,1520,1515],[1513,1515,1512],[1512,1515,1520],[1523,1522,1521],[1518,1521,1520],[1520,1521,1522],[1524,1521,1518],[1519,1524,1518],[1525,1523,1521],[1524,1525,1521],[1495,1494,1522],[1523,1495,1522],[1528,1527,1526],[1529,1528,1526],[1531,1530,1528],[1532,1531,1528],[1534,1533,1530],[1531,1534,1530],[1533,1535,1530],[1528,1530,1527],[1527,1530,1535],[1538,1537,1536],[1533,1536,1535],[1535,1536,1537],[1539,1536,1533],[1534,1539,1533],[1540,1538,1536],[1539,1540,1536],[1542,1541,1538],[1540,1542,1538],[1543,1514,1541],[1542,1543,1541],[1514,1511,1541],[1538,1541,1537],[1537,1541,1511],[1546,1545,1544],[1548,1544,1547],[1547,1544,1545],[1545,1550,1549],[1547,1545,1549],[1552,1548,1551],[1553,1552,1551],[1481,1555,1554],[1482,1481,1554],[1557,1556,1550],[1545,1557,1550],[1559,1558,1557],[1560,1559,1557],[1561,1529,1558],[1559,1561,1558],[1529,1526,1558],[1557,1558,1556],[1556,1558,1526],[1564,1563,1562],[1565,1564,1562],[1499,1564,1492],[1494,1492,1565],[1565,1492,1564],[1568,1567,1566],[1569,1568,1566],[1520,1568,1512],[1511,1512,1569],[1569,1512,1568],[1494,1565,1522],[1520,1522,1568],[1568,1522,1565],[1565,1562,1567],[1568,1565,1567],[1572,1571,1570],[1573,1572,1570],[1535,1572,1527],[1526,1527,1573],[1573,1527,1572],[1511,1569,1537],[1535,1537,1572],[1572,1537,1569],[1569,1566,1571],[1572,1569,1571],[1526,1573,1556],[1550,1556,1574],[1574,1556,1573],[1573,1570,1575],[1574,1573,1575],[1562,1576,1567],[1566,1567,1577],[1577,1567,1576],[1566,1577,1571],[1570,1571,1578],[1578,1571,1577],[1580,1577,1579],[1581,1579,1576],[1576,1579,1577],[1583,1578,1582],[1580,1582,1577],[1577,1582,1578],[1586,1585,1584],[1588,1584,1587],[1587,1584,1585],[1579,1587,1585],[1580,1579,1585],[1581,1589,1587],[1579,1581,1587],[1588,1587,1590],[1591,1590,1589],[1589,1590,1587],[1594,1593,1592],[1596,1592,1595],[1595,1592,1593],[1582,1595,1593],[1583,1582,1593],[1580,1585,1595],[1582,1580,1595],[1596,1595,1597],[1586,1597,1585],[1585,1597,1595],[1600,1599,1598],[1602,1598,1601],[1601,1598,1599],[1604,1603,1599],[1591,1605,1603],[1601,1599,1605],[1603,1605,1599],[1608,1607,1606],[1609,1608,1606],[1602,1601,1609],[1608,1609,1610],[1610,1609,1601],[1613,1612,1611],[1614,1613,1611],[1616,1615,1612],[1613,1616,1612],[1618,1614,1617],[1619,1618,1617],[1584,1618,1619],[1586,1584,1619],[1588,1620,1618],[1584,1588,1618],[1614,1618,1613],[1616,1613,1620],[1620,1613,1618],[1616,1620,1621],[1623,1621,1622],[1622,1621,1620],[1590,1622,1620],[1588,1590,1620],[1591,1603,1622],[1590,1591,1622],[1603,1604,1623],[1622,1603,1623],[1621,1624,1615],[1616,1621,1615],[1623,1625,1624],[1621,1623,1624],[1628,1627,1626],[1629,1628,1626],[1631,1630,1627],[1628,1631,1627],[1633,1629,1632],[1634,1633,1632],[1592,1633,1634],[1594,1592,1634],[1596,1635,1633],[1592,1596,1633],[1629,1633,1628],[1631,1628,1635],[1635,1628,1633],[1631,1635,1636],[1638,1636,1637],[1637,1636,1635],[1597,1637,1635],[1596,1597,1635],[1586,1619,1637],[1597,1586,1637],[1638,1637,1639],[1617,1639,1619],[1619,1639,1637],[1636,1640,1630],[1631,1636,1630],[1638,1641,1640],[1636,1638,1640],[1639,1642,1641],[1638,1639,1641],[1617,1643,1642],[1639,1617,1642],[1646,1645,1644],[1648,1644,1647],[1647,1644,1645],[1644,1650,1649],[1646,1644,1649],[1632,1651,1634],[1647,1652,1651],[1594,1634,1652],[1651,1652,1634],[1648,1647,1653],[1654,1653,1651],[1651,1653,1647],[1657,1656,1655],[1658,1657,1655],[1660,1657,1659],[1661,1659,1658],[1658,1659,1657],[1663,1662,1657],[1660,1663,1657],[1662,1664,1656],[1657,1662,1656],[1665,1659,1661],[1666,1665,1661],[1667,1660,1659],[1665,1667,1659],[1669,1668,1667],[1670,1663,1668],[1660,1667,1663],[1668,1663,1667],[1673,1672,1671],[1670,1671,1663],[1663,1671,1672],[1675,1674,1673],[1676,1675,1673],[1679,1678,1677],[1680,1679,1677],[1681,1679,1680],[1682,1681,1680],[1685,1684,1683],[1681,1683,1679],[1679,1683,1684],[1684,1686,1678],[1679,1684,1678],[1687,1683,1681],[1688,1687,1681],[1689,1685,1683],[1687,1689,1683],[1691,1690,1685],[1689,1691,1685],[1693,1692,1690],[1691,1693,1690],[1695,1694,1686],[1684,1695,1686],[1692,1695,1690],[1685,1690,1684],[1684,1690,1695],[1661,1658,1695],[1692,1661,1695],[1658,1655,1694],[1695,1658,1694],[1698,1697,1696],[1699,1698,1696],[1700,1698,1699],[1701,1700,1699],[1704,1703,1702],[1700,1702,1698],[1698,1702,1703],[1703,1705,1697],[1698,1703,1697],[1706,1702,1700],[1707,1706,1700],[1708,1704,1702],[1706,1708,1702],[1710,1709,1704],[1708,1710,1704],[1712,1711,1709],[1710,1712,1709],[1714,1713,1711],[1712,1714,1711],[1715,1682,1713],[1714,1715,1713],[1717,1716,1705],[1703,1717,1705],[1711,1717,1709],[1704,1709,1703],[1703,1709,1717],[1682,1680,1713],[1711,1713,1717],[1717,1713,1680],[1680,1677,1716],[1717,1680,1716],[1720,1719,1718],[1721,1720,1718],[1724,1723,1722],[1719,1722,1725],[1725,1722,1723],[1728,1727,1726],[1729,1723,1727],[1724,1726,1723],[1727,1723,1726],[1731,1730,1729],[1727,1731,1729],[1732,1701,1730],[1731,1732,1730],[1735,1734,1733],[1736,1735,1733],[1729,1735,1736],[1723,1729,1736],[1701,1699,1730],[1729,1730,1735],[1735,1730,1699],[1699,1696,1734],[1735,1699,1734],[1739,1738,1737],[1740,1739,1737],[1664,1739,1656],[1655,1656,1740],[1740,1656,1739],[1743,1742,1741],[1744,1743,1741],[1686,1743,1678],[1677,1678,1744],[1744,1678,1743],[1655,1740,1694],[1686,1694,1743],[1743,1694,1740],[1740,1737,1742],[1743,1740,1742],[1747,1746,1745],[1748,1747,1745],[1705,1747,1697],[1696,1697,1748],[1748,1697,1747],[1677,1744,1716],[1705,1716,1747],[1747,1716,1744],[1744,1741,1746],[1747,1744,1746],[1696,1748,1734],[1733,1734,1749],[1749,1734,1748],[1748,1745,1750],[1749,1748,1750],[1741,1742,1751],[1752,1741,1751],[1753,1751,1742],[1737,1753,1742],[1745,1746,1754],[1755,1745,1754],[1752,1754,1746],[1741,1752,1746],[1758,1757,1756],[1760,1756,1759],[1759,1756,1757],[1761,1759,1757],[1762,1761,1757],[1764,1763,1759],[1761,1764,1759],[1763,1765,1760],[1759,1763,1760],[1762,1753,1761],[1764,1761,1766],[1766,1761,1753],[1769,1768,1767],[1770,1769,1767],[1771,1769,1770],[1772,1771,1770],[1774,1773,1769],[1771,1774,1769],[1768,1769,1775],[1776,1775,1773],[1773,1775,1769],[1772,1752,1771],[1774,1771,1751],[1751,1771,1752],[1774,1751,1777],[1762,1777,1753],[1753,1777,1751],[1776,1773,1778],[1780,1778,1779],[1779,1778,1773],[1777,1779,1773],[1774,1777,1773],[1762,1757,1779],[1777,1762,1779],[1757,1758,1780],[1779,1757,1780],[1783,1782,1781],[1784,1783,1781],[1785,1783,1784],[1786,1785,1784],[1788,1787,1783],[1785,1788,1783],[1782,1783,1789],[1790,1789,1787],[1787,1789,1783],[1786,1755,1785],[1788,1785,1754],[1754,1785,1755],[1788,1754,1791],[1772,1791,1752],[1752,1791,1754],[1790,1787,1792],[1794,1792,1793],[1793,1792,1787],[1791,1793,1787],[1788,1791,1787],[1772,1770,1793],[1791,1772,1793],[1794,1793,1795],[1767,1795,1770],[1770,1795,1793],[1798,1797,1796],[1786,1796,1755],[1755,1796,1797],[1801,1800,1799],[1802,1801,1799],[1796,1801,1802],[1798,1796,1802],[1786,1784,1801],[1796,1786,1801],[1800,1801,1803],[1781,1803,1784],[1784,1803,1801],[1806,1805,1804],[1808,1804,1807],[1807,1804,1805],[1811,1810,1809],[1806,1809,1805],[1805,1809,1810],[1756,1813,1812],[1758,1756,1812],[1760,1814,1813],[1756,1760,1813],[1816,1765,1815],[1818,1815,1817],[1817,1815,1765],[1821,1820,1819],[1818,1821,1819],[1824,1823,1822],[1811,1822,1810],[1810,1822,1823],[1825,1824,1822],[1826,1825,1822],[1829,1828,1827],[1830,1829,1827],[1832,1831,1828],[1829,1832,1828],[1775,1834,1833],[1768,1775,1833],[1776,1835,1834],[1775,1776,1834],[1778,1836,1835],[1776,1778,1835],[1780,1837,1836],[1778,1780,1836],[1789,1839,1838],[1782,1789,1838],[1790,1840,1839],[1789,1790,1839],[1792,1841,1840],[1790,1792,1840],[1794,1842,1841],[1792,1794,1841],[1795,1843,1842],[1794,1795,1842],[1767,1844,1843],[1795,1767,1843],[1847,1846,1845],[1848,1847,1845],[1850,1849,1846],[1847,1850,1846],[1852,1851,1849],[1850,1852,1849],[1854,1853,1851],[1852,1854,1851],[1857,1856,1855],[1858,1857,1855],[1860,1859,1856],[1855,1856,1861],[1861,1856,1859],[1864,1863,1862],[1865,1864,1862],[1864,1867,1866],[1868,1866,1799],[1799,1866,1867],[1803,1870,1869],[1800,1803,1869],[1781,1871,1870],[1803,1781,1870],[1874,1873,1872],[1860,1872,1859],[1859,1872,1873],[1877,1876,1875],[1874,1875,1873],[1873,1875,1876],[1810,1878,1805],[1807,1805,1879],[1879,1805,1878],[1882,1881,1880],[1883,1882,1880],[1827,1882,1883],[1853,1827,1883],[1831,1884,1828],[1827,1828,1882],[1882,1828,1884],[1884,1885,1881],[1882,1884,1881],[1831,1886,1884],[1807,1879,1886],[1885,1884,1879],[1886,1879,1884],[1845,1888,1887],[1890,1889,1888],[1876,1887,1889],[1888,1889,1887],[1892,1891,1890],[1888,1892,1890],[1849,1892,1846],[1845,1846,1888],[1888,1846,1892],[1853,1883,1851],[1849,1851,1892],[1892,1851,1883],[1883,1880,1891],[1892,1883,1891],[1876,1889,1873],[1859,1873,1893],[1893,1873,1889],[1283,1115,1894],[1894,1895,1283],[1288,1895,1286],[1288,1283,1895],[1357,1896,1356],[1357,1286,1895],[1357,1287,1286],[1356,1898,1897],[1357,1895,1896],[1281,1283,1288],[1355,1897,1899],[1897,1355,1356],[1284,1900,1285],[1284,1899,1900],[1280,1285,1276],[1284,1287,1899],[1899,1287,1355],[1285,1900,1901],[1356,1896,1898],[1115,1283,1282],[1896,1902,1898],[1353,1896,1352],[1903,1359,1352],[1902,1896,1353],[1359,1903,1358],[1395,1905,1904],[1408,1395,1904],[1358,1903,1905],[1903,1352,1896],[1906,1408,1904],[1902,1353,1907],[1349,1908,1354],[1354,1908,1907],[1907,1353,1354],[1349,1354,1351],[1396,1350,1358],[1396,1358,1905],[1905,1395,1396],[1347,1908,1349],[1412,1408,1906],[1909,1412,1906],[1272,1304,1305],[1275,1272,1305],[1910,1272,1273],[1911,1302,1304],[1911,1298,1302],[1304,1272,1910],[1280,1276,1277],[1300,1299,1113],[1113,1299,1317],[1296,1325,1289],[1290,1296,1289],[1300,1113,1282],[1297,1298,1912],[1325,1296,1913],[1912,1296,1297],[1912,1913,1296],[1912,1298,1911],[1273,1276,1901],[1282,1113,1115],[1915,1344,1914],[1901,1910,1273],[1347,1345,1915],[1346,1343,1367],[1344,1346,1914],[1345,1344,1915],[1285,1901,1276],[1916,1914,1346],[1916,1367,1365],[1917,1916,1365],[1917,1365,1362],[1346,1367,1916],[1917,1362,1918],[1395,1408,1394],[1910,1911,1304],[1347,1915,1908],[1363,1918,1362],[1909,1919,1412],[1415,1919,1920],[1421,1418,1921],[1922,1421,1921],[1418,1415,1920],[1921,1418,1920],[1424,1924,1923],[1926,1925,1445],[1925,1927,1449],[1427,1424,1923],[1926,1427,1923],[1421,1922,1924],[1447,1449,1927],[1442,1445,1449],[1449,1445,1925],[1928,1502,1448],[1444,1501,1929],[1446,1501,1444],[1448,1447,1928],[1929,1443,1444],[1928,1447,1927],[1926,1445,1427],[1928,1505,1930],[1505,1928,1504],[1931,1505,1506],[1505,1931,1930],[1928,1930,1932],[1504,1933,1508],[1933,1504,1928],[1508,1503,1504],[1507,1508,1933],[1933,1934,1507],[1506,1503,1935],[1501,1502,1936],[1506,1935,1931],[1502,1932,1936],[1937,1509,1510],[1509,1937,1935],[1938,1937,1510],[1498,1510,1500],[1503,1509,1935],[1936,1929,1501],[1507,1564,1499],[1932,1502,1928],[1421,1924,1424],[1438,1443,1939],[1431,1427,1445],[1438,1939,1434],[1461,1435,1436],[1457,1476,1450],[1451,1457,1450],[1461,1459,1456],[1941,1459,1940],[1461,1940,1459],[1458,1941,1457],[1941,1458,1459],[1940,1461,1436],[1941,1942,1457],[1434,1943,1436],[1939,1443,1929],[1938,1496,1944],[1939,1943,1434],[1498,1938,1510],[1525,1497,1495],[1523,1525,1495],[1496,1497,1944],[1498,1496,1938],[1525,1944,1497],[1945,1525,1524],[1519,1946,1945],[1519,1945,1524],[1945,1944,1525],[1517,1947,1946],[1516,1517,1946],[1519,1516,1946],[1943,1940,1436],[1493,1498,1500],[1543,1517,1513],[1514,1543,1513],[1919,1415,1412],[1321,1324,1948],[1321,1948,1319],[1948,1315,1319],[1315,1949,1314],[1949,1315,1948],[1948,1324,1913],[1325,1913,1324],[1313,1314,1949],[1313,1339,1306],[1307,1313,1306],[1339,1313,1950],[1337,1338,1951],[1950,1338,1339],[1951,1338,1950],[1313,1949,1950],[1327,1335,1337],[1317,1316,1112],[1113,1317,1112],[1373,1953,1952],[1953,1393,1954],[1370,1393,1953],[1952,1918,1375],[1375,1373,1952],[1370,1371,1393],[1373,1370,1953],[1918,1363,1375],[1954,1392,1955],[1954,1393,1392],[1390,1956,1955],[1332,1337,1951],[1955,1392,1391],[1402,1410,1407],[1958,1957,1410],[1413,1958,1410],[1956,1390,1378],[1391,1390,1955],[1959,1958,1413],[1416,1959,1413],[1334,1328,1329],[1334,1329,1960],[1332,1961,1330],[1332,1951,1961],[1331,1330,1962],[1962,1330,1961],[1327,1337,1332],[1963,1384,1962],[1960,1326,1385],[1112,1334,1964],[1964,1334,1960],[1326,1331,1385],[1329,1326,1960],[1963,1383,1384],[1383,1963,1965],[1385,1383,1966],[1966,1383,1965],[1385,1966,1960],[1965,1967,1966],[1331,1962,1384],[1334,1112,1316],[1968,1386,1387],[1380,1966,1387],[1387,1967,1968],[1381,1382,1406],[1378,1376,1386],[1386,1968,1956],[1969,1406,1407],[1380,1379,1970],[1970,1381,1969],[1381,1970,1379],[1381,1406,1969],[1970,1966,1380],[1969,1407,1971],[1410,1957,1971],[1410,1971,1407],[1416,1972,1959],[1387,1966,1967],[1378,1386,1956],[1973,1972,1416],[1419,1973,1416],[1475,1476,1942],[1469,1463,1466],[1475,1974,1472],[1974,1475,1942],[1470,1974,1469],[1974,1470,1472],[1490,1463,1975],[1457,1942,1476],[1469,1975,1463],[1976,1973,1419],[1422,1976,1419],[1978,1977,1425],[1428,1978,1425],[1979,1976,1422],[1425,1979,1422],[1489,1490,1980],[1981,1488,1489],[1462,1463,1490],[1428,1433,1485],[1469,1974,1975],[1947,1543,1542],[1982,1542,1540],[1542,1982,1947],[1539,1534,1982],[1982,1534,1983],[1540,1539,1982],[1983,1534,1531],[1984,1983,1532],[1984,1532,1561],[1531,1532,1983],[1975,1980,1490],[1561,1532,1528],[1529,1561,1528],[1984,1559,1985],[1561,1559,1984],[1980,1981,1489],[1543,1947,1517],[1560,1985,1559],[1479,1480,1485],[1485,1480,1986],[1486,1987,1483],[1987,1486,1981],[1481,1987,1555],[1987,1481,1483],[1555,1987,1988],[1428,1485,1978],[1425,1977,1979],[1477,1482,1989],[1990,1477,1989],[1990,1986,1480],[1989,1482,1554],[1986,1978,1485],[1990,1480,1477],[1555,1988,1554],[1981,1486,1488],[1991,1985,1546],[1991,1544,1992],[1560,1545,1546],[1546,1985,1560],[1546,1544,1991],[1992,1544,1548],[1553,1989,1993],[1993,1989,1994],[1995,1553,1993],[1552,1553,1995],[1992,1552,1995],[1989,1554,1994],[1548,1547,1551],[1552,1992,1548],[1551,1996,1989],[1996,1551,1547],[1551,1989,1553],[1996,1547,1549],[1994,1554,1988],[1545,1560,1557],[1563,1934,1997],[1581,1576,1998],[1999,1581,1998],[1576,1563,1997],[1605,2001,2000],[1608,1610,2000],[2002,1607,1608],[1608,2000,2002],[1589,1581,1999],[2001,1589,1999],[1610,1605,2000],[1564,1934,1563],[1605,1610,1601],[1576,1997,1998],[1589,2001,1605],[1609,1606,2003],[1602,2003,1598],[2003,1602,1609],[2004,1598,2003],[1606,2005,2003],[1607,2005,1606],[1934,1564,1507],[2002,1675,2006],[1675,2002,1674],[2007,2006,1675],[1675,1676,2007],[2006,2008,1607],[1674,2009,1672],[2009,1674,2002],[2007,1676,2010],[1672,1673,1674],[2010,1676,1673],[2009,1662,1672],[2012,2011,1668],[2010,1671,2011],[2008,2005,1607],[1671,1670,2011],[1668,1669,2012],[1673,1671,2010],[1670,1668,2011],[1662,1663,1672],[2006,1607,2002],[1562,1563,1576],[1599,1600,1604],[1625,1623,1604],[1625,1604,2013],[1591,1589,1605],[1624,1625,2014],[1611,1643,1617],[1614,1611,1617],[1624,2014,1615],[1615,2015,1612],[2015,1615,2014],[1643,1611,2016],[2015,1611,1612],[2015,2016,1611],[2014,1625,2013],[2013,1604,1600],[2012,1669,2017],[1669,1665,2017],[2004,2013,1600],[1667,1665,1669],[1661,1692,1693],[1666,1661,1693],[1666,1693,2017],[1665,1666,2017],[2018,2017,1693],[2018,1691,1689],[2018,1693,1691],[2019,1689,1687],[1689,2019,2018],[2019,1687,1688],[1715,1688,1681],[1682,1715,1681],[2019,1688,2020],[1598,2004,1600],[1688,1715,2020],[1662,2009,1664],[1738,1739,2021],[2022,1738,2021],[1764,1766,2023],[2024,1764,2023],[1766,1738,2022],[2023,1766,2022],[1817,1821,1818],[1821,1817,2024],[1818,2025,1815],[1819,2025,1818],[1815,2025,2026],[1763,2024,1817],[2024,2027,1821],[2009,2021,1739],[1664,2009,1739],[1737,1738,1766],[1753,1737,1766],[1763,1764,2024],[1814,1765,1816],[2026,1816,1815],[1763,1817,1765],[2026,2028,1816],[1820,2027,2029],[2027,1820,1821],[2029,2030,1820],[1820,2030,1819],[2029,2027,2031],[1823,2032,1878],[1825,2027,1824],[1824,2027,1823],[2032,1107,1878],[2027,2032,1823],[1825,2031,2027],[2034,1826,2033],[1826,2034,1825],[2033,1826,1811],[2031,1825,2034],[1822,1811,1826],[1811,1809,2033],[1878,1810,1823],[1107,1879,1878],[2030,2025,1819],[1809,2035,2033],[2036,1813,2028],[1780,1758,1812],[1837,1780,1812],[2036,1812,1813],[1837,1812,2036],[1813,1814,2028],[1765,1814,1760],[1836,1837,2037],[1833,1844,1767],[1768,1833,1767],[1836,2037,1835],[1835,2038,1834],[2038,1835,2037],[1844,1833,2039],[2038,1833,1834],[2038,2039,1833],[1837,2036,2037],[1804,2035,1806],[2035,1804,2040],[1809,1806,2035],[1804,1808,2040],[1807,1886,1808],[2040,1808,2041],[1886,2041,1808],[2041,1832,2042],[2041,1886,1832],[2042,1829,1830],[1829,2042,1832],[2043,2042,1830],[1832,1886,1831],[1854,1830,1827],[1853,1854,1827],[1881,1885,1108],[1885,1879,1108],[1816,2028,1814],[1854,2043,1830],[1108,1879,1107],[1641,1642,2044],[1641,2044,1640],[2044,1630,1640],[1630,2045,1627],[2045,1630,2044],[2044,1642,2016],[1626,1627,2045],[1575,1570,1578],[2047,2046,1583],[1593,2047,1583],[2046,2048,1578],[1583,2046,1578],[1632,1654,1651],[2049,1654,1632],[2049,1632,1626],[1593,1594,1652],[1626,1632,1629],[1626,2045,2049],[2016,1642,1643],[2020,1714,2050],[2020,1715,1714],[1708,2051,2050],[2050,1714,1712],[1712,1710,2050],[1708,1706,2051],[1706,1707,2051],[1710,1708,2050],[2051,1707,2052],[2053,2052,1728],[1726,2053,1728],[2052,1731,1728],[2049,2054,1654],[1732,1707,1700],[1701,1732,1700],[1732,2052,1707],[1731,1727,1728],[1732,1731,2052],[2054,1653,1654],[2055,1574,1575],[1645,1652,1647],[1593,1652,2047],[1578,2048,2056],[1648,1653,2057],[1644,2057,1650],[2057,1644,1648],[1650,2057,2058],[2054,2057,1653],[1549,2055,1996],[1549,1574,2055],[2055,1575,2056],[1578,2056,1575],[1645,1646,2059],[2059,2047,1652],[2060,2059,1646],[2060,1646,1649],[1652,1645,2059],[1650,2058,1649],[1550,1574,1549],[2062,2061,1722],[2061,1726,1724],[1736,1725,1723],[2062,1722,1719],[1724,1722,2061],[1733,2063,1736],[2060,2064,1721],[2065,1721,2064],[1720,1721,2065],[2060,1649,2064],[2062,1720,2065],[2064,1649,2066],[1719,1725,1718],[1720,2062,1719],[1718,2063,2060],[2063,1718,1725],[1718,2060,1721],[1725,1736,2063],[1733,1749,2067],[2063,1733,2067],[2058,2066,1649],[1726,2061,2053],[1842,1843,2068],[1842,2068,1841],[2068,1840,1841],[1840,2069,1839],[2069,1840,2068],[2068,1843,2039],[1838,1839,2069],[1838,1871,1781],[1782,1838,1781],[1750,1745,1755],[1797,1750,1755],[1838,2070,1871],[1838,2069,2070],[1869,1870,2071],[2070,1870,1871],[1870,2070,2071],[1800,1869,1799],[2043,1852,2072],[2043,1854,1852],[2072,1850,1847],[1850,2072,1852],[1891,1880,1108],[1891,1108,1890],[1880,1881,1108],[2072,1847,1848],[1877,2073,1887],[1848,2073,2072],[1875,2074,1877],[2074,1875,2075],[1848,1887,2073],[2074,2073,1877],[1887,1876,1877],[1890,1108,1889],[1845,1887,1848],[1893,1889,1108],[1109,1893,1108],[1843,1844,2039],[1874,2075,1875],[2067,1749,1750],[2076,1797,1798],[2076,2077,1750],[1797,2076,1750],[1799,1869,1868],[2078,1868,2071],[1802,1799,1867],[1798,1802,2079],[1868,1869,2071],[1868,2078,1866],[2077,2067,1750],[1802,1867,2079],[2076,1798,2079],[1867,1865,2079],[1866,2080,1864],[2080,1866,2078],[1863,1864,2080],[1864,1865,1867],[2080,2081,1863],[2079,1865,2082],[1857,2083,1860],[1858,2084,1857],[1857,2084,2083],[2083,2075,1872],[1872,1860,2083],[1872,2075,1874],[1861,1859,1893],[1860,1856,1857],[1862,2085,2082],[2085,1862,2081],[2082,2085,2086],[1862,2082,1865],[2086,1858,2082],[2081,1862,1863],[1861,2082,1855],[1858,2086,2084],[1893,2087,1861],[2087,1893,1109],[2087,2082,1861],[1855,2082,1858],[2090,2089,2088],[2088,2092,2091],[2088,2091,2090],[2088,2094,2093],[2093,2095,2092],[2093,2092,2088],[2089,2097,2096],[2096,2094,2088],[2096,2088,2089],[2100,2099,2098],[2098,2097,2089],[2098,2089,2100],[2098,2099,2101],[2102,2101,2099],[2103,2102,2099],[2106,2105,2104],[2104,2108,2107],[2104,2107,2106],[2104,2110,2109],[2109,2111,2108],[2109,2108,2104],[2105,2113,2112],[2112,2110,2104],[2112,2104,2105],[2116,2115,2114],[2114,2113,2105],[2114,2105,2116],[2092,2095,2117],[2117,2115,2116],[2117,2116,2092],[2091,2092,2116],[2116,2105,2106],[2116,2106,2091],[2120,2119,2118],[2121,2120,2118],[2124,2123,2122],[2122,2121,2125],[2122,2125,2124],[2128,2127,2126],[2126,2123,2124],[2126,2124,2128],[2108,2111,2129],[2129,2127,2128],[2129,2128,2108],[2107,2108,2128],[2128,2124,2130],[2128,2130,2107],[2131,2091,2106],[2106,2107,2132],[2106,2132,2131],[2131,2132,2133],[2134,2131,2133],[2134,2133,2135],[2136,2134,2135],[2135,2138,2137],[2137,2139,2136],[2137,2136,2135],[2142,2141,2140],[2140,2144,2143],[2140,2143,2142],[2143,2144,2145],[2145,2147,2146],[2145,2146,2143],[2139,2142,2143],[2143,2146,2148],[2143,2148,2139],[2146,2147,2149],[2149,2151,2150],[2149,2150,2146],[2153,2151,2152],[2154,2153,2152],[2157,2156,2155],[2155,2159,2158],[2155,2158,2157],[2158,2159,2160],[2160,2162,2161],[2160,2161,2158],[2138,2157,2158],[2158,2161,2137],[2158,2137,2138],[2137,2161,2163],[2163,2142,2139],[2163,2139,2137],[2161,2162,2164],[2164,2165,2163],[2164,2163,2161],[2163,2165,2166],[2166,2141,2142],[2166,2142,2163],[2169,2168,2167],[2170,2169,2167],[2172,2169,2171],[2171,2174,2173],[2171,2173,2172],[2176,2173,2175],[2175,2157,2138],[2175,2138,2176],[2173,2174,2177],[2177,2178,2175],[2177,2175,2173],[2175,2178,2179],[2179,2156,2157],[2179,2157,2175],[461,462,2102],[464,465,2101],[2102,462,464],[2102,2103,461],[2101,465,2098],[2100,2103,2099],[2101,2102,464],[2180,461,2103],[467,468,2096],[470,2117,469],[468,469,2093],[467,2096,2097],[2096,468,2094],[471,2114,470],[465,467,2097],[2098,465,2097],[2100,2089,2090],[2093,2094,468],[2181,2180,2090],[2131,2181,2090],[2090,2180,2100],[2103,2100,2180],[2131,2182,2181],[2117,2095,469],[2114,2115,470],[2115,2117,470],[2091,2131,2090],[2112,2113,471],[2182,2131,2134],[2183,2182,2134],[2113,2114,471],[2095,2093,469],[2112,471,472],[472,483,2109],[2112,472,2110],[484,2129,483],[472,2109,2110],[2111,2109,483],[2127,2129,484],[2129,2111,483],[2127,484,2126],[486,487,2120],[488,489,2119],[2119,487,488],[2121,486,2120],[485,2126,484],[2119,2120,487],[2123,2126,485],[2122,485,486],[2119,489,2184],[2118,2119,2184],[2121,2122,486],[2122,2123,485],[2132,2107,2130],[2124,2125,2130],[2185,2132,2130],[2186,2133,2132],[2187,2186,2132],[2125,2118,2184],[2118,2125,2121],[2184,2188,2125],[2188,2130,2125],[2130,2188,2189],[2132,2185,2190],[2132,2190,2187],[2185,2130,2189],[2191,2133,2186],[2183,2134,2136],[2192,2183,2136],[2194,2148,2193],[2192,2136,2194],[2153,2150,2151],[2150,2153,2193],[2151,2149,2152],[2193,2148,2150],[1019,2193,2153],[2148,2146,2150],[2136,2139,2148],[2136,2148,2194],[2147,2145,1015],[2144,2140,1014],[1014,2145,2144],[1016,2149,2147],[2149,1016,2152],[2154,2152,1017],[1014,1015,2145],[1015,1016,2147],[1013,1014,2140],[1018,1019,2154],[1016,1017,2152],[1017,1018,2154],[2153,2154,1019],[2141,2166,1013],[2165,2164,1012],[1012,2166,2165],[2164,1011,1012],[1011,2162,2160],[2164,2162,1011],[1011,2160,1001],[2166,1012,1013],[1013,2140,2141],[2138,2135,2176],[2173,2176,2172],[2135,2195,2176],[2159,2155,1001],[2196,2168,2172],[1000,2155,2156],[2176,2197,2172],[2133,2191,2198],[2200,2199,2135],[2135,2198,2200],[2195,2201,2176],[2197,2196,2172],[2176,2201,2197],[2135,2199,2195],[2135,2133,2198],[2179,2178,999],[2177,2174,998],[999,2178,2177],[2179,1000,2156],[998,999,2177],[999,1000,2179],[1001,2155,1000],[998,2174,2171],[2169,2170,997],[2171,2169,997],[2168,2169,2172],[2167,994,2170],[991,2167,992],[2167,991,994],[2168,2196,992],[2167,2168,992],[2170,994,997],[998,2171,997],[1001,2160,2159],[2204,2203,2202],[2202,2206,2205],[2202,2205,2204],[2209,2208,2207],[2206,2209,2207],[2210,2209,2206],[2202,2210,2206],[2211,2210,2202],[2203,2211,2202],[2212,2211,2203],[2213,2212,2203],[2214,2212,2213],[2215,2214,2213],[2216,2215,2213],[2213,2203,2204],[2213,2204,2216],[96,97,2217],[99,100,2217],[2217,97,99],[103,104,2214],[105,106,2212],[2214,104,105],[2217,100,103],[121,122,2218],[123,124,2218],[2218,122,123],[107,117,2211],[118,119,2209],[119,120,2208],[2210,117,118],[120,121,2208],[2211,106,107],[2214,2215,2217],[2211,2212,106],[2212,2214,105],[1106,2217,2216],[2204,1105,2216],[1106,2216,1105],[2215,2216,2217],[103,2214,2217],[2209,2210,118],[2208,2209,119],[1105,2205,1110],[2207,2205,2206],[2218,2205,2207],[2205,2218,1110],[2218,2207,2208],[1105,2204,2205],[2218,2208,121],[2210,2211,117],[2221,2220,2219],[2222,2221,2219],[2223,2221,2222],[2224,2223,2222],[2225,2220,2221],[2221,2223,2226],[2221,2226,2225],[2226,2223,2227],[2227,2229,2228],[2227,2228,2226],[2227,2223,2224],[2230,2227,2224],[2229,2227,2230],[2231,2229,2230],[2232,1116,2228],[1114,2226,2228],[1114,2228,1116],[2229,2232,2228],[2229,2231,2232],[634,2230,2224],[2231,2230,635],[637,2232,2231],[2224,633,634],[2226,1114,1111],[2225,2226,1111],[2225,2233,2220],[1111,2233,2225],[2222,623,2224],[2219,2220,2233],[2222,2219,622],[2219,2233,620],[2224,623,633],[636,637,2231],[634,635,2230],[635,636,2231],[640,641,2232],[638,639,2232],[639,640,2232],[2232,637,638],[622,623,2222],[620,621,2219],[621,622,2219],[617,619,2233],[615,614,2233],[614,617,2233],[619,620,2233],[2236,2235,2234],[2237,2236,2234],[2238,2236,2237],[2239,2238,2237],[2242,2241,2240],[2238,2240,2236],[2236,2240,2241],[2241,2243,2235],[2236,2241,2235],[2244,2240,2238],[2245,2244,2238],[2246,2242,2240],[2244,2246,2240],[2248,2247,2242],[2246,2248,2242],[2250,2249,2247],[2248,2250,2247],[2253,2252,2251],[2254,2253,2251],[2256,2255,2243],[2241,2256,2243],[2249,2256,2247],[2242,2247,2241],[2241,2247,2256],[2259,2258,2257],[2261,2257,2260],[2260,2257,2258],[2258,2263,2262],[2260,2258,2262],[2265,2261,2264],[2266,2265,2264],[2267,2257,2261],[2265,2267,2261],[2268,2259,2257],[2267,2268,2257],[2270,2269,2259],[2268,2270,2259],[2272,2271,2269],[2270,2272,2269],[2274,2273,2271],[2272,2274,2271],[2275,2239,2273],[2274,2275,2273],[2277,2276,2263],[2258,2277,2263],[2271,2277,2269],[2259,2269,2258],[2258,2269,2277],[2239,2237,2273],[2271,2273,2277],[2277,2273,2237],[2237,2234,2276],[2277,2237,2276],[2280,2279,2278],[2282,2278,2281],[2281,2278,2279],[2283,2281,2279],[2284,2283,2279],[2286,2285,2281],[2283,2286,2281],[2285,2287,2282],[2281,2285,2282],[2234,2235,2283],[2284,2234,2283],[2286,2283,2235],[2243,2286,2235],[2287,2285,2288],[2290,2288,2289],[2289,2288,2285],[2291,2289,2285],[2286,2291,2285],[2294,2293,2292],[2295,2294,2292],[2297,2292,2296],[2298,2296,2293],[2293,2296,2292],[2263,2276,2299],[2294,2263,2299],[2284,2299,2276],[2234,2284,2276],[2301,2300,2298],[2293,2301,2298],[2299,2301,2293],[2294,2299,2293],[2284,2279,2301],[2299,2284,2301],[2300,2301,2302],[2280,2302,2279],[2279,2302,2301],[2305,2304,2303],[2308,2307,2306],[2310,2306,2309],[2309,2306,2307],[2312,2309,2311],[2313,2311,2307],[2307,2311,2309],[2315,2314,2309],[2312,2315,2309],[2314,2316,2310],[2309,2314,2310],[2317,2311,2313],[2318,2317,2313],[2315,2320,2319],[2323,2322,2321],[2324,2319,2322],[2316,2314,2325],[2327,2325,2326],[2326,2325,2314],[2324,2326,2319],[2315,2319,2314],[2314,2319,2326],[2330,2329,2328],[2332,2328,2331],[2331,2328,2329],[2334,2331,2333],[2335,2333,2329],[2329,2333,2331],[2337,2332,2336],[2338,2337,2336],[2332,2337,2328],[2330,2328,2339],[2318,2313,2340],[2341,2318,2340],[2343,2342,2335],[2329,2343,2335],[2344,2343,2329],[2330,2344,2329],[2313,2307,2340],[2344,2340,2343],[2343,2340,2307],[2342,2343,2345],[2308,2345,2307],[2307,2345,2343],[2306,2347,2346],[2308,2306,2346],[2316,2325,2348],[2327,2349,2325],[2351,2350,2349],[2334,2353,2352],[2354,2334,2352],[2334,2333,2353],[2335,2355,2333],[2308,2346,2356],[2345,2308,2356],[2359,2358,2357],[2361,2360,2358],[2364,2363,2362],[2365,2364,2362],[2367,2366,2363],[2364,2367,2363],[2365,2368,2364],[2367,2364,2369],[2369,2364,2368],[2371,2369,2370],[2372,2370,2368],[2368,2370,2369],[2374,2373,2369],[2371,2374,2369],[2373,2375,2367],[2369,2373,2367],[2375,2373,2376],[2378,2376,2377],[2377,2376,2373],[2361,2377,2360],[2374,2360,2373],[2373,2360,2377],[2376,2380,2379],[2375,2376,2379],[2378,2381,2380],[2376,2378,2380],[2384,2383,2382],[2385,2384,2382],[2388,2387,2386],[2389,2388,2386],[2391,2390,2387],[2388,2391,2387],[2393,2392,2390],[2391,2393,2390],[2396,2395,2394],[2398,2394,2397],[2397,2394,2395],[2388,2397,2391],[2393,2391,2395],[2395,2391,2397],[2400,2399,2393],[2395,2400,2393],[2401,2400,2395],[2396,2401,2395],[2372,2368,2402],[2401,2402,2400],[2400,2402,2368],[2399,2400,2403],[2365,2403,2368],[2368,2403,2400],[2403,2405,2404],[2399,2403,2404],[2365,2362,2405],[2403,2365,2405],[1107,2032,2253],[2253,2032,2252],[1107,2253,2254],[2251,2252,2250],[2254,2251,2217],[2032,2027,2252],[1107,2254,1106],[2250,2027,2249],[2256,2249,2027],[2024,2256,2027],[2022,2255,2023],[2255,2256,2024],[2023,2255,2024],[2291,2022,2021],[2289,2291,2021],[2009,2289,2021],[2027,2250,2252],[2251,2250,96],[2248,96,2250],[2217,1106,2254],[2251,96,2217],[2244,98,2246],[98,96,2246],[96,2248,2246],[2245,98,2244],[2243,2255,2291],[2286,2243,2291],[2255,2022,2291],[2290,2289,2009],[2002,2290,2009],[2002,2000,2290],[2304,2305,2000],[2001,2304,2000],[2288,2290,2305],[2303,2288,2305],[2305,2290,2000],[2304,2001,1266],[1265,1266,1999],[1998,1265,1999],[1260,1261,1998],[1997,1260,1998],[2323,1934,2322],[1934,2323,1997],[1933,2324,2322],[2322,1934,1933],[2001,1999,1266],[2323,1260,1997],[2288,2303,256],[256,2303,1267],[2288,256,2287],[2282,2287,256],[257,2282,256],[1267,2304,1266],[2303,2304,1267],[1261,1265,1998],[838,2322,2319],[2321,2322,838],[840,838,2320],[2321,838,1260],[2320,838,2319],[1260,2323,2321],[2312,2320,2315],[98,2275,101],[2275,98,2245],[2238,2239,2275],[2245,2238,2275],[101,2275,2274],[101,2272,102],[2272,101,2274],[102,2272,2270],[2278,2282,257],[2270,2268,102],[102,2268,108],[108,2267,2265],[2267,108,2268],[108,2265,2266],[110,2266,2264],[2266,110,108],[2264,2261,2260],[110,2264,345],[2262,2263,2294],[2295,2262,2294],[2260,2262,345],[2262,2295,342],[345,2262,342],[2295,2292,342],[2292,2297,264],[342,2292,264],[2260,345,2264],[2302,2280,262],[257,2280,2278],[262,2280,257],[2298,2300,262],[262,2300,2302],[844,843,2339],[2317,840,2311],[2311,840,2312],[840,2317,2318],[2341,843,2318],[2341,2340,843],[843,840,2318],[843,2340,2344],[263,2298,262],[2298,263,2296],[2296,263,2297],[2297,263,264],[2337,2338,850],[844,2337,850],[2339,2344,2330],[2328,844,2339],[844,2328,2337],[850,2338,2336],[843,2344,2339],[2320,2312,840],[2326,2324,1933],[1928,2326,1933],[1928,1927,2327],[2326,1928,2327],[2349,2327,1927],[1925,2349,1927],[1926,2351,1925],[2193,1926,1923],[2194,1923,1924],[2183,2192,1922],[1921,2183,1922],[2182,1920,1919],[2183,1921,1920],[2192,1924,1922],[2182,1919,1909],[2351,2349,1925],[1019,2349,2350],[1019,2348,2325],[2325,2349,1019],[2316,2348,2310],[2351,2193,2350],[1926,2193,2351],[1019,1020,2348],[2350,2193,1019],[1923,2194,2193],[2192,2194,1924],[2182,2183,1920],[1909,2181,2182],[1909,1906,2181],[2180,1906,1904],[1904,1905,2359],[2358,2359,1905],[1905,1903,2361],[2358,1905,2361],[2180,1904,2359],[2377,2361,1903],[1896,2377,1903],[2378,2377,1896],[1895,2378,1896],[2384,1894,2383],[1894,2384,1895],[2383,1115,2382],[1115,2383,1894],[2381,1895,2384],[2358,2360,461],[2357,2180,2359],[2357,461,2180],[2360,2374,461],[2358,461,2357],[2381,2385,641],[2385,2381,2384],[2385,2382,2232],[2380,2381,641],[641,2385,2232],[2382,1116,2232],[2379,2380,641],[2382,1115,1116],[2378,1895,2381],[1906,2180,2181],[2374,2371,463],[461,2374,463],[2306,1020,2347],[1020,2306,2310],[2342,2345,1026],[2347,1020,2346],[463,2371,2370],[2356,1026,2345],[2346,1026,2356],[2401,2396,473],[466,2401,473],[1026,2346,1020],[466,463,2372],[2342,1026,2355],[2310,2348,1020],[2336,2332,2331],[2336,1103,850],[2336,2331,1103],[2354,1103,2331],[2334,2354,2331],[1103,2354,1028],[1026,1027,2355],[1027,2353,2333],[2352,2353,1028],[1028,2353,1027],[2352,1028,2354],[474,473,2398],[1027,2333,2355],[2335,2342,2355],[2370,2372,463],[2379,2366,2367],[2375,2379,2367],[2372,2402,466],[2402,2401,466],[2366,642,2363],[641,642,2366],[2379,641,2366],[2363,642,2362],[2405,2362,648],[648,649,2392],[2404,648,2392],[648,2404,2405],[2362,642,648],[2393,2399,2404],[2392,2393,2404],[2396,2394,473],[725,474,2398],[2397,725,2398],[2389,2397,2388],[2397,2389,725],[2394,2398,473],[2392,649,2390],[2390,649,2387],[2386,650,2389],[650,2386,2387],[2387,649,650],[2389,650,725],[2408,2407,2406],[2410,2406,2409],[2409,2406,2407],[2413,2412,2411],[2414,2413,2411],[2409,2407,2415],[2416,2409,2415],[2419,2418,2417],[2420,2419,2417],[2423,2422,2421],[2420,2421,2419],[2419,2421,2422],[2425,2419,2424],[2426,2424,2422],[2422,2424,2419],[2425,2427,2418],[2419,2425,2418],[2430,2429,2428],[2423,2428,2422],[2422,2428,2429],[2426,2422,2431],[2432,2431,2429],[2429,2431,2422],[2432,2433,2431],[2430,2428,2434],[2437,2436,2435],[2440,2439,2438],[2441,2440,2438],[2439,2443,2442],[2438,2439,2442],[2446,2445,2444],[2447,2446,2444],[2450,2449,2448],[2451,2450,2448],[2449,2453,2452],[2448,2449,2452],[2450,2454,2449],[2453,2449,2455],[2455,2449,2454],[2457,2455,2456],[2458,2456,2454],[2454,2456,2455],[2440,2459,2439],[2443,2439,2460],[2460,2439,2459],[2455,2459,2440],[2453,2455,2440],[2457,2461,2459],[2455,2457,2459],[2463,2460,2462],[2461,2462,2459],[2459,2462,2460],[2466,2465,2464],[2408,2464,2407],[2407,2464,2465],[2407,2465,2467],[2415,2407,2467],[2470,2469,2468],[2472,2468,2471],[2471,2468,2469],[2474,2471,2473],[2475,2473,2469],[2469,2473,2471],[2478,2477,2476],[2470,2476,2469],[2469,2476,2477],[2417,2418,2479],[2478,2479,2477],[2477,2479,2418],[2481,2477,2480],[2427,2480,2418],[2418,2480,2477],[2475,2469,2482],[2481,2482,2477],[2477,2482,2469],[2485,2484,2483],[2486,2485,2483],[2484,2488,2487],[2483,2484,2487],[2488,2490,2489],[2487,2488,2489],[2443,2492,2491],[2442,2443,2491],[2492,2494,2493],[2491,2492,2493],[2496,2495,2485],[2494,2496,2485],[2443,2460,2492],[2494,2492,2496],[2496,2492,2460],[2498,2496,2497],[2463,2497,2460],[2460,2497,2496],[2498,2499,2495],[2496,2498,2495],[2485,2495,2484],[2488,2484,2500],[2500,2484,2495],[2502,2500,2501],[2499,2501,2495],[2495,2501,2500],[2087,1109,2413],[2082,2410,2079],[2079,2409,2076],[2087,2414,2082],[2409,2077,2076],[2414,2087,2413],[2416,2063,2067],[2416,230,2063],[230,2060,2063],[2060,230,2059],[1109,2412,2413],[1271,2047,2059],[1268,2048,2046],[1264,2056,2048],[2046,2047,1269],[2433,2432,1996],[2055,2433,1996],[2432,2429,1989],[1996,2432,1989],[2430,2434,1986],[1990,2430,1986],[2196,1978,1986],[2429,2430,1990],[1989,2429,1990],[2055,2056,2433],[2411,2082,2414],[2412,1110,2218],[1110,2412,1109],[2411,2218,124],[2218,2411,2412],[2067,2077,2416],[1271,1270,2047],[1269,2047,1270],[1264,2048,1268],[2046,1269,1268],[2059,230,1271],[124,2410,2082],[2433,2056,1262],[2428,2423,992],[992,2196,2434],[1978,2197,2201],[2196,2197,1978],[2428,992,2434],[2431,2433,866],[1986,2434,2196],[2082,2411,124],[1978,2201,1977],[2199,1976,1979],[2191,1972,1973],[2186,1959,1972],[1973,1976,2198],[2185,1957,1958],[2189,1971,1957],[1971,2436,1969],[2188,2436,1971],[1969,2436,2437],[2190,1958,1959],[1979,1977,2195],[2458,2454,1966],[1970,2458,1966],[1964,1960,2446],[1112,1964,2447],[2454,2450,1960],[1966,2454,1960],[2435,2456,2458],[2437,2435,2458],[2451,2446,1960],[2450,2451,1960],[2446,2447,1964],[2437,2458,1970],[1969,2437,1970],[1112,2447,2444],[2200,1976,2199],[2191,2186,1972],[2198,2191,1973],[2200,2198,1976],[2187,2190,1959],[1958,2190,2185],[2185,2189,1957],[2188,1971,2189],[2188,2184,2436],[2187,1959,2186],[2456,2435,489],[2451,2445,2446],[615,2445,2451],[2233,2444,2445],[489,2435,2184],[2448,2452,615],[2452,2441,616],[615,2452,616],[1111,2444,2233],[2233,2445,615],[489,2457,2456],[2451,2448,615],[2436,2184,2435],[2444,1111,1112],[2199,1979,2195],[1977,2201,2195],[2056,1264,1263],[2416,2077,2409],[230,2416,229],[1262,866,2433],[2409,2079,2410],[2406,125,2408],[2406,2410,124],[2408,125,2464],[2480,873,2481],[229,2416,2415],[234,229,2415],[125,2406,124],[2424,2426,867],[2423,2421,993],[2426,866,867],[993,992,2423],[867,2427,2425],[867,873,2427],[2420,2417,993],[873,2480,2427],[2425,2424,867],[2421,2420,993],[1262,2056,1263],[2464,132,2466],[132,2464,125],[2415,2467,234],[135,346,2465],[2466,135,2465],[132,135,2466],[343,2465,346],[343,344,2467],[2465,343,2467],[344,243,234],[344,234,2467],[2481,872,2482],[2481,873,872],[2475,2482,872],[872,874,2475],[2474,2473,874],[874,2473,2475],[2474,874,875],[2474,1104,2471],[1104,2474,875],[2472,2471,1104],[2417,2479,995],[2461,2457,489],[490,2461,489],[2462,490,2463],[2462,2461,490],[995,993,2417],[491,497,2499],[2498,491,2499],[2497,2463,490],[491,2497,490],[2498,2497,491],[2479,2478,996],[995,2479,996],[2452,2453,2440],[2441,2452,2440],[2438,616,2441],[2438,2442,618],[616,2438,618],[2491,2493,618],[624,618,2493],[2486,624,2493],[2491,618,2442],[2485,2486,2493],[2494,2485,2493],[2476,2470,996],[2499,497,2501],[2470,2468,1002],[996,2470,1002],[2476,996,2478],[2468,2472,1002],[1002,2472,1003],[497,2502,2501],[2502,497,500],[2472,1104,1003],[500,726,2500],[2502,500,2500],[2486,2483,624],[624,2483,2487],[2500,2490,2488],[2490,2500,726],[2490,726,625],[2487,2489,625],[625,2489,2490],[2487,625,624],[2426,2431,866],[2505,2504,2503],[2506,2505,2503],[2506,2503,2507],[2508,2506,2507],[2511,2510,2509],[2512,2511,2509],[2512,2509,2513],[2514,2512,2513],[2514,2513,2515],[2516,2514,2515],[2516,2515,2517],[2518,2516,2517],[2518,2517,2519],[2520,2518,2519],[2520,2519,2521],[2522,2520,2521],[2522,2521,2523],[2524,2522,2523],[2524,2523,2525],[2526,2524,2525],[2529,2528,2527],[2530,2529,2527],[2530,2527,2531],[2532,2530,2531],[2532,2531,2533],[2534,2532,2533],[2534,2533,2535],[2536,2534,2535],[2536,2535,2537],[2538,2536,2537],[2538,2537,2539],[2540,2538,2539],[2540,2539,2541],[2542,2540,2541],[2542,2541,2543],[2544,2542,2543],[2544,2543,2545],[2546,2544,2545],[2546,2545,2547],[2548,2546,2547],[2551,2550,2549],[2552,2551,2549],[2552,2549,2553],[2554,2552,2553],[2557,2556,2555],[2558,2557,2555],[2558,2555,2559],[2560,2558,2559],[2560,2559,2561],[2562,2560,2561],[2562,2561,2563],[2564,2562,2563],[2564,2563,2565],[2566,2564,2565],[2566,2565,2567],[2568,2566,2567],[2568,2567,2569],[2570,2568,2569],[2570,2569,2571],[2572,2570,2571],[2575,2574,2573],[2576,2575,2573],[2576,2573,2577],[2578,2576,2577],[2578,2577,2579],[2580,2578,2579],[2580,2579,2581],[2582,2580,2581],[2582,2581,2583],[2584,2582,2583],[2584,2583,2585],[2586,2584,2585],[2586,2585,2587],[2588,2586,2587],[2588,2587,2589],[2590,2588,2589],[2590,2589,2591],[2592,2590,2591],[2592,2591,2593],[2594,2592,2593],[2595,2505,2086],[2085,2595,2086],[2505,2595,2504],[2086,2505,2506],[2086,2506,2084],[2083,2512,2075],[2516,2074,2075],[2514,2516,2075],[2508,2511,2083],[2084,2508,2083],[2074,2520,2073],[2506,2508,2084],[2511,2512,2083],[2512,2514,2075],[2507,2510,2511],[2508,2507,2511],[2516,2518,2074],[2520,2522,2073],[2522,2524,2073],[2074,2518,2520],[2526,2072,2073],[2524,2526,2073],[2043,2072,2526],[2041,2042,2530],[2042,2043,2529],[2035,2040,2538],[2033,2542,2544],[2546,2034,2033],[2544,2546,2033],[2033,2035,2542],[2040,2041,2534],[2529,2526,2596],[2043,2526,2529],[2041,2530,2532],[2041,2532,2534],[2530,2042,2529],[2538,2040,2536],[2534,2536,2040],[2035,2538,2540],[2035,2540,2542],[2029,2031,2597],[2598,2029,2597],[2548,2597,2031],[2034,2548,2031],[2503,2504,2599],[2600,2510,2507],[2599,2600,2507],[2507,2503,2599],[2513,2509,2601],[2517,2515,2602],[2519,2517,2602],[2515,2513,2601],[2509,2510,2600],[2504,2603,2599],[2509,2600,2601],[2515,2601,2602],[2523,2521,2604],[2525,2604,2596],[2604,2525,2523],[2526,2525,2596],[2519,2602,2604],[2521,2519,2604],[2603,2504,2595],[2527,2528,2605],[2533,2531,2605],[2535,2533,2606],[2531,2527,2605],[2548,2547,2597],[2034,2546,2548],[2528,2529,2596],[2537,2535,2606],[2541,2539,2607],[2533,2605,2606],[2537,2606,2607],[2608,2541,2607],[2539,2537,2607],[2545,2543,2608],[2609,2545,2608],[2545,2609,2547],[2547,2609,2597],[2608,2543,2541],[2610,2597,2609],[2605,2528,2596],[2030,2551,2552],[2551,2598,2550],[2598,2551,2030],[2029,2598,2030],[2030,2552,2025],[2554,2557,2026],[2025,2554,2026],[2028,2562,2036],[2566,2037,2036],[2564,2566,2036],[2026,2558,2028],[2037,2570,2038],[2552,2554,2025],[2557,2558,2026],[2558,2560,2028],[2553,2556,2557],[2554,2553,2557],[2562,2564,2036],[2566,2568,2037],[2568,2570,2037],[2028,2560,2562],[2572,2038,2570],[2039,2572,2575],[2068,2039,2575],[2576,2069,2068],[2580,2070,2069],[2572,2039,2038],[2070,2584,2071],[2078,2592,2080],[2592,2594,2080],[2071,2588,2078],[2594,2611,2081],[2080,2594,2081],[2575,2576,2068],[2578,2580,2069],[2580,2582,2070],[2069,2576,2578],[2584,2586,2071],[2588,2590,2078],[2590,2592,2078],[2071,2586,2588],[2070,2582,2584],[2611,2595,2085],[2081,2611,2085],[2575,2572,2612],[2549,2550,2613],[2614,2556,2553],[2613,2614,2553],[2553,2549,2613],[2559,2555,2615],[2563,2561,2616],[2565,2563,2616],[2561,2559,2615],[2555,2556,2614],[2550,2610,2613],[2555,2614,2615],[2561,2615,2616],[2569,2567,2617],[2571,2617,2612],[2617,2571,2569],[2572,2571,2612],[2565,2616,2617],[2567,2565,2617],[2610,2550,2598],[2573,2574,2618],[2579,2577,2618],[2581,2579,2619],[2577,2573,2618],[2593,2611,2594],[2611,2603,2595],[2585,2583,2620],[2574,2575,2612],[2583,2581,2619],[2619,2579,2618],[2587,2585,2620],[2583,2619,2620],[2620,2621,2587],[2589,2587,2621],[2589,2621,2622],[2591,2589,2622],[2611,2593,2622],[2622,2593,2591],[2611,2622,2603],[2618,2574,2612],[2610,2598,2597],[2625,2624,2623],[2626,2625,2623],[2626,2623,2627],[2628,2626,2627],[2631,2630,2629],[2632,2631,2629],[2632,2629,2633],[2634,2632,2633],[2634,2633,2635],[2636,2634,2635],[2636,2635,2637],[2638,2636,2637],[2638,2637,2639],[2640,2638,2639],[2640,2639,2641],[2642,2640,2641],[2642,2641,2643],[2644,2642,2643],[2644,2643,2645],[2646,2644,2645],[2649,2648,2647],[2650,2649,2647],[2650,2647,2651],[2652,2650,2651],[2652,2651,2653],[2654,2652,2653],[2654,2653,2655],[2656,2654,2655],[2656,2655,2657],[2658,2656,2657],[2658,2657,2659],[2660,2658,2659],[2660,2659,2661],[2662,2660,2661],[2662,2661,2663],[2664,2662,2663],[2664,2663,2665],[2666,2664,2665],[2666,2665,2667],[2668,2666,2667],[2671,2670,2669],[2672,2671,2669],[2672,2669,2673],[2674,2672,2673],[2677,2676,2675],[2678,2677,2675],[2678,2675,2679],[2680,2678,2679],[2680,2679,2681],[2682,2680,2681],[2682,2681,2683],[2684,2682,2683],[2684,2683,2685],[2686,2684,2685],[2686,2685,2687],[2688,2686,2687],[2688,2687,2689],[2690,2688,2689],[2690,2689,2691],[2692,2690,2691],[2695,2694,2693],[2696,2695,2693],[2696,2693,2697],[2698,2696,2697],[2698,2697,2699],[2700,2698,2699],[2700,2699,2701],[2702,2700,2701],[2702,2701,2703],[2704,2702,2703],[2704,2703,2705],[2706,2704,2705],[2706,2705,2707],[2708,2706,2707],[2708,2707,2709],[2710,2708,2709],[2710,2709,2711],[2712,2710,2711],[2712,2711,2713],[2714,2712,2713],[2715,2625,2065],[2064,2715,2065],[2625,2715,2624],[2065,2625,2626],[2065,2626,2062],[2061,2632,2053],[2053,2636,2052],[2628,2631,2061],[2062,2628,2061],[2640,2051,2052],[2638,2640,2052],[2626,2628,2062],[2631,2632,2061],[2632,2634,2053],[2627,2630,2631],[2628,2627,2631],[2636,2638,2052],[2640,2642,2051],[2642,2644,2051],[2053,2634,2636],[2050,2051,2644],[2020,2050,2646],[2018,2019,2650],[2019,2020,2649],[2658,2012,2017],[2656,2658,2017],[2011,2662,2664],[2011,2666,2010],[2662,2011,2012],[2660,2662,2012],[2017,2018,2654],[2649,2646,2716],[2020,2646,2649],[2018,2650,2652],[2018,2652,2654],[2650,2019,2649],[2654,2656,2017],[2012,2658,2660],[2006,2007,2717],[2718,2006,2717],[2668,2717,2007],[2010,2668,2007],[2646,2050,2644],[2623,2624,2719],[2720,2630,2627],[2719,2720,2627],[2627,2623,2719],[2633,2629,2721],[2637,2635,2722],[2639,2637,2722],[2635,2633,2721],[2629,2630,2720],[2624,2723,2719],[2629,2720,2721],[2635,2721,2722],[2643,2641,2724],[2645,2724,2716],[2724,2645,2643],[2646,2645,2716],[2639,2722,2724],[2641,2639,2724],[2723,2624,2715],[2647,2648,2725],[2653,2651,2725],[2655,2653,2726],[2651,2647,2725],[2664,2666,2011],[2668,2667,2717],[2010,2666,2668],[2648,2649,2716],[2657,2655,2726],[2661,2659,2727],[2653,2725,2726],[2657,2726,2727],[2728,2661,2727],[2659,2657,2727],[2665,2663,2728],[2729,2665,2728],[2665,2729,2667],[2667,2729,2717],[2728,2663,2661],[2730,2717,2729],[2725,2648,2716],[2008,2671,2672],[2671,2718,2670],[2718,2671,2008],[2006,2718,2008],[2674,2005,2008],[2672,2674,2008],[2674,2677,2003],[2005,2674,2003],[2004,2682,2013],[2686,2014,2013],[2684,2686,2013],[2003,2678,2004],[2014,2690,2015],[2677,2678,2003],[2678,2680,2004],[2673,2676,2677],[2674,2673,2677],[2682,2684,2013],[2686,2688,2014],[2688,2690,2014],[2004,2680,2682],[2692,2015,2690],[2016,2692,2695],[2044,2016,2695],[2696,2045,2044],[2700,2049,2045],[2692,2016,2015],[2704,2054,2049],[2702,2704,2049],[2714,2058,2057],[2712,2714,2057],[2708,2057,2054],[2706,2708,2054],[2714,2731,2066],[2058,2714,2066],[2695,2696,2044],[2698,2700,2045],[2700,2702,2049],[2045,2696,2698],[2704,2706,2054],[2708,2710,2057],[2710,2712,2057],[2731,2715,2064],[2066,2731,2064],[2695,2692,2732],[2669,2670,2733],[2734,2676,2673],[2733,2734,2673],[2673,2669,2733],[2679,2675,2735],[2683,2681,2736],[2685,2683,2736],[2681,2679,2735],[2675,2676,2734],[2670,2730,2733],[2675,2734,2735],[2681,2735,2736],[2689,2687,2737],[2691,2737,2732],[2737,2691,2689],[2692,2691,2732],[2685,2736,2737],[2687,2685,2737],[2730,2670,2718],[2693,2694,2738],[2699,2697,2738],[2701,2699,2739],[2697,2693,2738],[2713,2731,2714],[2731,2723,2715],[2705,2703,2740],[2694,2695,2732],[2703,2701,2739],[2739,2699,2738],[2707,2705,2740],[2703,2739,2740],[2740,2741,2707],[2709,2707,2741],[2709,2741,2742],[2711,2709,2742],[2731,2713,2742],[2742,2713,2711],[2731,2742,2723],[2738,2694,2732],[2730,2718,2717],[2745,2744,2743],[2746,2745,2743],[2746,2743,2747],[2748,2746,2747],[2751,2750,2749],[2752,2751,2749],[2752,2749,2753],[2754,2752,2753],[2754,2753,2755],[2756,2754,2755],[2756,2755,2757],[2758,2756,2757],[2758,2757,2759],[2760,2758,2759],[2760,2759,2761],[2762,2760,2761],[2762,2761,2763],[2764,2762,2763],[2764,2763,2765],[2766,2764,2765],[2769,2768,2767],[2770,2769,2767],[2770,2767,2771],[2772,2770,2771],[2772,2771,2773],[2774,2772,2773],[2774,2773,2775],[2776,2774,2775],[2776,2775,2777],[2778,2776,2777],[2778,2777,2779],[2780,2778,2779],[2780,2779,2781],[2782,2780,2781],[2782,2781,2783],[2784,2782,2783],[2784,2783,2785],[2786,2784,2785],[2786,2785,2787],[2788,2786,2787],[2791,2790,2789],[2792,2791,2789],[2792,2789,2793],[2794,2792,2793],[2797,2796,2795],[2798,2797,2795],[2798,2795,2799],[2800,2798,2799],[2800,2799,2801],[2802,2800,2801],[2802,2801,2803],[2804,2802,2803],[2804,2803,2805],[2806,2804,2805],[2806,2805,2807],[2808,2806,2807],[2808,2807,2809],[2810,2808,2809],[2810,2809,2811],[2812,2810,2811],[2815,2814,2813],[2816,2815,2813],[2816,2813,2817],[2818,2816,2817],[2818,2817,2819],[2820,2818,2819],[2820,2819,2821],[2822,2820,2821],[2822,2821,2823],[2824,2822,2823],[2824,2823,2825],[2826,2824,2825],[2826,2825,2827],[2828,2826,2827],[2828,2827,2829],[2830,2828,2829],[2830,2829,2831],[2832,2830,2831],[2832,2831,2833],[2834,2832,2833],[2835,2745,1995],[1993,2835,1995],[2745,2835,2744],[1995,2745,2746],[2748,1992,1995],[2746,2748,1995],[1991,2752,1985],[1985,2756,1984],[2748,2751,1991],[1992,2748,1991],[1984,2760,1983],[2751,2752,1991],[2752,2754,1985],[2747,2750,2751],[2748,2747,2751],[2756,2758,1984],[2760,2762,1983],[2762,2764,1983],[1984,2758,2760],[1985,2754,2756],[1982,1983,2764],[1947,1982,2766],[1945,1946,2770],[1946,1947,2769],[1938,1944,2778],[1937,2782,2784],[2786,1935,1937],[2784,2786,1937],[1937,1938,2782],[1944,1945,2774],[2769,2766,2836],[1947,2766,2769],[1945,2770,2772],[1945,2772,2774],[2770,1946,2769],[2778,1944,2776],[2774,2776,1944],[1938,2778,2780],[1938,2780,2782],[1930,1931,2837],[2838,1930,2837],[2788,2837,1931],[1935,2788,1931],[2766,1982,2764],[2743,2744,2839],[2840,2750,2747],[2839,2840,2747],[2747,2743,2839],[2753,2749,2841],[2757,2755,2842],[2759,2757,2842],[2755,2753,2841],[2749,2750,2840],[2744,2843,2839],[2749,2840,2841],[2755,2841,2842],[2763,2761,2844],[2765,2844,2836],[2844,2765,2763],[2766,2765,2836],[2759,2842,2844],[2761,2759,2844],[2843,2744,2835],[2767,2768,2845],[2773,2771,2845],[2775,2773,2846],[2771,2767,2845],[2788,2787,2837],[1935,2786,2788],[2768,2769,2836],[2777,2775,2846],[2781,2779,2847],[2773,2845,2846],[2777,2846,2847],[2848,2781,2847],[2779,2777,2847],[2785,2783,2848],[2849,2785,2848],[2785,2849,2787],[2787,2849,2837],[2848,2783,2781],[2850,2837,2849],[2845,2768,2836],[1932,2791,2792],[2791,2838,2790],[2838,2791,1932],[1930,2838,1932],[1932,2792,1936],[2794,2797,1929],[1936,2794,1929],[1939,2802,1943],[2806,1940,1943],[2804,2806,1943],[1929,2798,1939],[1940,2810,1941],[2792,2794,1936],[2797,2798,1929],[2798,2800,1939],[2793,2796,2797],[2794,2793,2797],[2802,2804,1943],[2806,2808,1940],[2808,2810,1940],[1939,2800,2802],[2812,1941,2810],[1942,2812,2815],[1974,1942,2815],[2818,1975,1974],[2816,2818,1974],[2820,1980,1975],[2812,1942,1941],[1980,2824,1981],[1987,2832,1988],[2832,2834,1988],[1981,2828,1987],[2834,2851,1994],[1988,2834,1994],[2815,2816,1974],[2818,2820,1975],[2820,2822,1980],[2824,2826,1981],[2828,2830,1987],[2830,2832,1987],[1981,2826,2828],[1980,2822,2824],[2851,2835,1993],[1994,2851,1993],[2815,2812,2852],[2789,2790,2853],[2854,2796,2793],[2853,2854,2793],[2793,2789,2853],[2799,2795,2855],[2803,2801,2856],[2805,2803,2856],[2801,2799,2855],[2795,2796,2854],[2790,2850,2853],[2795,2854,2855],[2801,2855,2856],[2809,2807,2857],[2811,2857,2852],[2857,2811,2809],[2812,2811,2852],[2805,2856,2857],[2807,2805,2857],[2850,2790,2838],[2813,2814,2858],[2819,2817,2858],[2821,2819,2859],[2817,2813,2858],[2833,2851,2834],[2851,2843,2835],[2825,2823,2860],[2814,2815,2852],[2823,2821,2859],[2859,2819,2858],[2827,2825,2860],[2823,2859,2860],[2860,2861,2827],[2829,2827,2861],[2829,2861,2862],[2831,2829,2862],[2851,2833,2862],[2862,2833,2831],[2851,2862,2843],[2858,2814,2852],[2850,2838,2837],[2865,2864,2863],[2866,2865,2863],[2866,2863,2867],[2868,2866,2867],[2871,2870,2869],[2872,2871,2869],[2872,2869,2873],[2874,2872,2873],[2874,2873,2875],[2876,2874,2875],[2876,2875,2877],[2878,2876,2877],[2878,2877,2879],[2880,2878,2879],[2880,2879,2881],[2882,2880,2881],[2882,2881,2883],[2884,2882,2883],[2884,2883,2885],[2886,2884,2885],[2889,2888,2887],[2890,2889,2887],[2890,2887,2891],[2892,2890,2891],[2892,2891,2893],[2894,2892,2893],[2894,2893,2895],[2896,2894,2895],[2896,2895,2897],[2898,2896,2897],[2898,2897,2899],[2900,2898,2899],[2900,2899,2901],[2902,2900,2901],[2902,2901,2903],[2904,2902,2903],[2904,2903,2905],[2906,2904,2905],[2906,2905,2907],[2908,2906,2907],[2911,2910,2909],[2912,2911,2909],[2912,2909,2913],[2914,2912,2913],[2917,2916,2915],[2918,2917,2915],[2918,2915,2919],[2920,2918,2919],[2920,2919,2921],[2922,2920,2921],[2922,2921,2923],[2924,2922,2923],[2924,2923,2925],[2926,2924,2925],[2926,2925,2927],[2928,2926,2927],[2928,2927,2929],[2930,2928,2929],[2930,2929,2931],[2932,2930,2931],[2935,2934,2933],[2936,2935,2933],[2936,2933,2937],[2938,2936,2937],[2938,2937,2939],[2940,2938,2939],[2940,2939,2941],[2942,2940,2941],[2942,2941,2943],[2944,2942,2943],[2944,2943,2945],[2946,2944,2945],[2946,2945,2947],[2948,2946,2947],[2948,2947,2949],[2950,2948,2949],[2950,2949,2951],[2952,2950,2951],[2952,2951,2953],[2954,2952,2953],[2955,2865,1967],[1965,2955,1967],[2865,2955,2864],[1967,2865,2866],[1967,2866,1968],[2872,1955,1956],[2871,2872,1956],[1955,2876,1954],[2868,2871,1956],[1968,2868,1956],[1954,2880,1953],[2866,2868,1968],[2872,2874,1955],[2867,2870,2871],[2868,2867,2871],[2876,2878,1954],[2880,2882,1953],[2882,2884,1953],[1954,2878,2880],[1955,2874,2876],[2886,1952,1953],[2884,2886,1953],[1918,1952,2886],[1916,1917,2890],[1917,1918,2889],[2898,1915,1914],[2896,2898,1914],[1908,2902,2904],[1908,2906,1907],[1908,1915,2902],[1914,1916,2894],[2889,2886,2956],[1918,2886,2889],[1916,2890,2892],[1916,2892,2894],[2890,1917,2889],[2894,2896,1914],[1915,2898,2900],[1915,2900,2902],[1898,1902,2957],[2958,1898,2957],[2908,2957,1902],[1907,2908,1902],[2863,2864,2959],[2960,2870,2867],[2959,2960,2867],[2867,2863,2959],[2873,2869,2961],[2877,2875,2962],[2879,2877,2962],[2875,2873,2961],[2869,2870,2960],[2864,2963,2959],[2869,2960,2961],[2875,2961,2962],[2883,2881,2964],[2885,2964,2956],[2964,2885,2883],[2886,2885,2956],[2879,2962,2964],[2881,2879,2964],[2963,2864,2955],[2887,2888,2965],[2893,2891,2965],[2895,2893,2966],[2891,2887,2965],[2904,2906,1908],[2908,2907,2957],[1907,2906,2908],[2888,2889,2956],[2897,2895,2966],[2901,2899,2967],[2893,2965,2966],[2897,2966,2967],[2968,2901,2967],[2899,2897,2967],[2905,2903,2968],[2969,2905,2968],[2905,2969,2907],[2907,2969,2957],[2968,2903,2901],[2970,2957,2969],[2965,2888,2956],[1897,2911,2912],[2911,2958,2910],[2958,2911,1897],[1898,2958,1897],[1897,2912,1899],[2914,2917,1900],[1899,2914,1900],[1901,2922,1910],[1910,2926,1911],[1900,2918,1901],[1911,2930,1912],[2912,2914,1899],[2917,2918,1900],[2918,2920,1901],[2913,2916,2917],[2914,2913,2917],[2922,2924,1910],[2926,2928,1911],[2928,2930,1911],[1910,2924,2926],[1901,2920,2922],[2932,1912,2930],[1913,2932,2935],[1948,1913,2935],[2936,1949,1948],[2935,2936,1948],[2940,1950,1949],[2932,1913,1912],[2946,1951,1950],[2944,2946,1950],[2952,1962,1961],[2950,2952,1961],[2952,2954,1962],[2950,1961,1951],[2948,2950,1951],[2954,2971,1963],[1962,2954,1963],[2938,2940,1949],[2940,2942,1950],[1949,2936,2938],[1951,2946,2948],[1950,2942,2944],[2971,2955,1965],[1963,2971,1965],[2935,2932,2972],[2909,2910,2973],[2974,2916,2913],[2973,2974,2913],[2913,2909,2973],[2919,2915,2975],[2923,2921,2976],[2925,2923,2976],[2921,2919,2975],[2915,2916,2974],[2910,2970,2973],[2915,2974,2975],[2921,2975,2976],[2929,2927,2977],[2931,2977,2972],[2977,2931,2929],[2932,2931,2972],[2925,2976,2977],[2927,2925,2977],[2970,2910,2958],[2933,2934,2978],[2939,2937,2978],[2941,2939,2979],[2937,2933,2978],[2953,2971,2954],[2971,2963,2955],[2945,2943,2980],[2934,2935,2972],[2943,2941,2979],[2979,2939,2978],[2947,2945,2980],[2943,2979,2980],[2980,2981,2947],[2949,2947,2981],[2949,2981,2982],[2951,2949,2982],[2971,2953,2982],[2982,2953,2951],[2971,2982,2963],[2978,2934,2972],[2970,2958,2957],[2985,2984,2983],[2986,2985,2983],[2984,2988,2987],[2983,2984,2987],[2986,2983,2989],[2990,2986,2989],[2983,2987,2991],[2989,2983,2991],[2965,2985,2966],[2984,2965,2956],[2967,2966,2985],[2969,2985,2986],[2985,2968,2967],[2968,2985,2969],[2965,2984,2985],[2961,2988,2962],[2960,2988,2961],[2964,2962,2988],[2988,2984,2964],[2959,2987,2988],[2963,2987,2959],[2959,2988,2960],[2956,2964,2984],[2986,2970,2969],[2974,2973,2990],[2986,2990,2973],[2975,2974,2990],[2986,2973,2970],[2990,2977,2976],[2989,2977,2990],[2990,2976,2975],[2989,2972,2977],[2991,2982,2981],[2982,2991,2987],[2978,2989,2991],[2982,2987,2963],[2991,2980,2979],[2991,2981,2980],[2991,2979,2978],[2972,2989,2978],[2994,2993,2992],[2995,2994,2992],[2995,2992,2996],[2997,2995,2996],[2993,2999,2998],[2992,2993,2998],[2992,2998,3000],[2996,2992,3000],[2737,2736,2994],[2737,2995,2732],[2994,2736,2735],[2734,2733,2994],[2995,2737,2994],[2993,2994,2733],[2733,2730,2993],[2734,2994,2735],[2740,2739,2997],[2997,2741,2740],[2997,2739,2738],[2995,2997,2738],[2742,2996,2723],[2996,2742,2997],[2997,2742,2741],[2738,2732,2995],[2729,2999,2993],[2998,2999,2725],[2729,2728,2999],[2726,2999,2727],[2725,2999,2726],[2727,2999,2728],[2998,2725,2716],[3000,2720,2719],[2720,3000,2721],[2723,2996,2719],[2996,3000,2719],[2722,3000,2724],[2721,3000,2722],[3000,2998,2724],[2998,2716,2724],[2730,2729,2993],[3003,3002,3001],[3004,3003,3001],[3004,3001,3005],[3006,3004,3005],[3002,3008,3007],[3001,3002,3007],[3001,3007,3009],[3005,3001,3009],[3003,2856,2855],[3003,2857,2856],[2855,2854,3003],[2853,2850,3002],[2857,3003,3004],[3002,3003,2853],[2850,2849,3002],[2853,3003,2854],[3006,2859,2858],[3006,2860,2859],[2858,2852,3004],[3006,2861,2860],[2862,2861,3006],[3006,3005,2862],[3006,2858,3004],[2852,2857,3004],[2849,2848,3008],[2845,3007,3008],[3008,2848,2847],[2846,2845,3008],[2836,3007,2845],[3008,2847,2846],[3007,2836,2844],[3005,3009,2839],[2839,2843,3005],[3009,2840,2839],[3005,2843,2862],[2842,2841,3009],[2840,3009,2841],[3009,2844,2842],[3007,2844,3009],[3008,3002,2849],[3012,3011,3010],[3013,3012,3010],[3013,3010,3014],[3015,3013,3014],[3011,3017,3016],[3010,3011,3016],[3010,3016,3018],[3014,3010,3018],[3012,2616,2615],[3012,2617,2616],[2615,2614,3012],[2613,2610,3011],[2617,3012,3013],[3011,3012,2613],[2610,2609,3011],[2613,3012,2614],[3015,2619,2618],[3015,2620,2619],[2618,2612,3013],[3015,2621,2620],[2622,2621,3015],[3015,3014,2622],[3015,2618,3013],[2612,2617,3013],[2609,2608,3017],[2605,3016,3017],[3017,2608,2607],[2606,2605,3017],[2596,3016,2605],[3017,2607,2606],[3016,2596,2604],[3014,3018,2599],[2599,2603,3014],[3018,2600,2599],[3014,2603,2622],[2602,2601,3018],[2600,3018,2601],[3018,2604,2602],[3016,2604,3018],[3017,3011,2609]];
function 820_BUTTON_A_points() = [
[-0.099998,37.783546,0.055171],[-0.099998,37.695007,0.023685],[-0.500000,37.695007,0.023685],[-0.500000,37.783546,0.055171],[1.099998,37.783546,0.055171],[1.099998,37.695007,0.023685],[0.700001,37.695007,0.023685],[0.700001,37.783546,0.055171],[-0.099998,37.951485,0.140195],[-0.099998,37.869011,0.093926],[-0.500000,37.869011,0.093926],[-0.500000,37.951485,0.140195],[0.700001,37.869011,0.093926],[0.700001,37.951485,0.140195],[1.099998,37.869011,0.093926],[1.099998,37.951485,0.140195],[-0.099998,38.108559,0.258814],[-0.099998,38.032837,0.195911],[-0.500000,38.032837,0.195911],[-0.500000,38.108559,0.258814],[0.700001,38.108559,0.258814],[-0.099998,38.234962,0.397459],[-0.099998,38.175278,0.325586],[-0.500000,38.175278,0.325586],[-0.500000,38.234962,0.397459],[0.700001,38.175278,0.325586],[0.700001,38.234962,0.397459],[1.099998,38.175278,0.325586],[1.099998,38.108559,0.258814],[1.099998,38.234962,0.397459],[-0.099998,38.336922,0.564740],[-0.099998,38.290611,0.479361],[-0.500000,38.290611,0.479361],[-0.500000,38.336922,0.564740],[0.700001,38.336922,0.564740],[-0.099998,38.400879,0.740644],[-0.099998,38.373657,0.652267],[-0.500000,38.373657,0.652267],[-0.500000,38.400879,0.740644],[0.700001,38.373657,0.652267],[0.700001,38.400879,0.740644],[1.099998,38.373657,0.652267],[1.099998,38.336922,0.564740],[1.099998,38.400879,0.740644],[-0.099998,38.428665,0.923605],[-0.099998,38.419548,0.832946],[-0.500000,38.419548,0.832946],[-0.500000,38.428665,0.923605],[0.700001,38.419548,0.832946],[0.700001,38.428665,0.923605],[1.099998,38.419548,0.832946],[1.099998,38.428665,0.923605],[-0.099998,38.421669,1.094429],[-0.099998,38.429146,1.008193],[-0.500000,38.429146,1.008193],[-0.500000,38.421669,1.094429],[0.700001,38.429146,1.008193],[0.700001,38.421669,1.094429],[1.099998,38.429146,1.008193],[1.099998,38.421669,1.094429],[-0.099998,38.379395,1.273711],[-0.099998,38.405258,1.183764],[-0.500000,38.405258,1.183764],[-0.500000,38.379395,1.273711],[0.700001,38.405258,1.183764],[0.700001,38.379395,1.273711],[1.099998,38.405258,1.183764],[1.099998,38.379395,1.273711],[0.700001,38.299118,1.448663],[-0.099998,38.299118,1.448663],[0.700001,38.248116,1.526985],[-0.099998,38.189041,1.601275],[0.700001,38.189041,1.601275],[1.099998,38.248116,1.526985],[1.099998,38.299118,1.448663],[1.099998,38.189041,1.601275],[0.700001,38.122505,1.670485],[-0.099998,38.049309,1.733675],[0.700001,38.049309,1.733675],[1.099998,38.122505,1.670485],[1.099998,38.049309,1.733675],[0.700001,37.886986,1.839050],[-0.099998,37.886986,1.839050],[0.700001,37.800163,1.880241],[-0.099998,37.711166,1.913457],[0.700001,37.711166,1.913457],[1.099998,37.800163,1.880241],[1.099998,37.886986,1.839050],[1.099998,37.711166,1.913457],[0.700001,37.621185,1.938719],[-0.099998,37.531357,1.956236],[0.700001,37.531357,1.956236],[1.099998,37.621185,1.938719],[1.099998,37.531357,1.956236],[1.099998,37.442696,1.966374],[0.700001,37.442696,1.966374],[-0.900002,37.605713,0.000000],[-0.900002,37.773567,0.051201],[-0.419998,37.605713,0.000000],[-0.900002,37.935081,0.130232],[-0.900002,38.082390,0.235705],[0.060001,37.605713,0.000000],[0.540001,37.605713,0.000000],[-0.900002,38.208351,0.363732],[-0.900002,38.307587,0.508363],[-0.900002,38.377289,0.662476],[-0.900002,38.417320,0.818854],[-0.900002,38.429886,0.971137],[1.020000,37.605713,0.000000],[1.500000,37.783546,0.055171],[1.500000,37.605713,0.000000],[1.500000,37.951485,0.140195],[1.500000,38.108559,0.258814],[1.500000,38.336922,0.564740],[1.500000,38.234962,0.397459],[1.500000,38.400879,0.740644],[1.500000,38.428665,0.923605],[-0.900002,38.411957,1.152825],[-0.900002,38.354492,1.338676],[-0.900002,38.254852,1.517521],[-0.900002,38.115372,1.677176],[-0.900002,37.943680,1.806869],[-0.900002,37.751343,1.899522],[-0.900002,37.551476,1.952958],[-0.900002,37.356079,1.969628],[-0.099998,37.356079,1.969628],[1.500000,38.421669,1.094429],[1.500000,38.299118,1.448663],[1.500000,38.379395,1.273711],[1.500000,38.189041,1.601275],[1.500000,38.049309,1.733675],[1.500000,37.886986,1.839050],[0.700001,37.356079,1.969628],[1.500000,37.711166,1.913457],[1.500000,37.531357,1.956236],[1.500000,37.356079,1.969628],[1.099998,19.703489,1.954929],[1.099998,19.796377,1.966061],[0.700001,19.796377,1.966061],[0.700001,19.703489,1.954929],[0.700001,19.612547,1.936448],[-0.099998,19.703489,1.954929],[-0.099998,19.521574,1.910010],[0.700001,19.521574,1.910010],[1.099998,19.612547,1.936448],[1.099998,19.521574,1.910010],[0.700001,19.343475,1.832235],[-0.099998,19.343475,1.832235],[0.700001,19.263149,1.783789],[-0.099998,19.187243,1.728450],[0.700001,19.187243,1.728450],[1.099998,19.263149,1.783789],[1.099998,19.343475,1.832235],[1.099998,19.187243,1.728450],[0.700001,19.116329,1.666374],[-0.099998,19.051796,1.598628],[0.700001,19.051796,1.598628],[1.099998,19.116329,1.666374],[1.099998,19.051796,1.598628],[0.700001,18.993135,1.524344],[-0.099998,18.942520,1.446085],[0.700001,18.942520,1.446085],[1.099998,18.993135,1.524344],[1.099998,18.942520,1.446085],[0.700001,18.861954,1.268408],[-0.099998,18.861954,1.268408],[-0.099998,18.820684,1.088346],[-0.099998,18.836565,1.178030],[-0.500000,18.836565,1.178030],[-0.500000,18.820684,1.088346],[-0.500000,18.861954,1.268408],[0.700001,18.836565,1.178030],[0.700001,18.820684,1.088346],[1.099998,18.836565,1.178030],[1.099998,18.861954,1.268408],[1.099998,18.820684,1.088346],[-0.099998,18.815317,0.909386],[-0.099998,18.813654,0.998177],[-0.500000,18.813654,0.998177],[-0.500000,18.815317,0.909386],[0.700001,18.813654,0.998177],[0.700001,18.815317,0.909386],[1.099998,18.813654,0.998177],[1.099998,18.815317,0.909386],[-0.099998,18.845490,0.728342],[-0.099998,18.825703,0.819582],[-0.500000,18.825703,0.819582],[-0.500000,18.845490,0.728342],[0.700001,18.825703,0.819582],[0.700001,18.845490,0.728342],[1.099998,18.825703,0.819582],[1.099998,18.845490,0.728342],[-0.099998,18.912939,0.551014],[-0.099998,18.874353,0.639148],[-0.500000,18.874353,0.639148],[-0.500000,18.912939,0.551014],[0.700001,18.912939,0.551014],[-0.099998,19.010025,0.395030],[-0.099998,18.957401,0.471444],[-0.500000,18.957401,0.471444],[-0.500000,19.010025,0.395030],[0.700001,18.957401,0.471444],[0.700001,19.010025,0.395030],[1.099998,18.957401,0.471444],[1.099998,18.912939,0.551014],[1.099998,19.010025,0.395030],[-0.099998,19.137854,0.255843],[-0.099998,19.070387,0.322833],[-0.500000,19.070387,0.322833],[-0.500000,19.137854,0.255843],[0.700001,19.070387,0.322833],[0.700001,19.137854,0.255843],[1.099998,19.070387,0.322833],[1.099998,19.137854,0.255843],[-0.099998,19.290661,0.140815],[-0.099998,19.211605,0.194932],[-0.500000,19.211605,0.194932],[-0.500000,19.290661,0.140815],[0.700001,19.211605,0.194932],[0.700001,19.290661,0.140815],[1.099998,19.211605,0.194932],[1.099998,19.290661,0.140815],[-0.099998,19.460260,0.054905],[-0.099998,19.373932,0.094028],[-0.500000,19.373932,0.094028],[-0.500000,19.460260,0.054905],[0.700001,19.460260,0.054905],[-0.099998,19.548475,0.023582],[-0.500000,19.548475,0.023582],[-0.099998,19.887062,1.969628],[-0.900002,19.887062,1.969628],[-0.900002,19.691671,1.952958],[-0.900002,19.491802,1.899522],[-0.900002,19.299467,1.806869],[0.700001,19.887062,1.969628],[-0.900002,19.127769,1.677176],[-0.900002,18.988295,1.517521],[-0.900002,18.888655,1.338676],[-0.900002,18.831188,1.152825],[-0.900002,18.813261,0.971137],[1.500000,19.703489,1.954929],[1.500000,19.343475,1.832235],[1.500000,19.521574,1.910010],[1.500000,19.887062,1.969628],[1.500000,19.187243,1.728450],[1.500000,19.051796,1.598628],[1.500000,18.942520,1.446085],[1.500000,18.861954,1.268408],[1.500000,18.820684,1.088346],[-0.900002,18.825823,0.818854],[-0.900002,18.865854,0.662476],[-0.900002,18.935555,0.508363],[-0.900002,19.034796,0.363732],[-0.900002,19.160753,0.235705],[-0.900002,19.308064,0.130232],[-0.900002,19.469576,0.051201],[-0.900002,19.637436,0.000000],[-0.299999,19.637436,0.000000],[1.500000,18.815317,0.909386],[1.500000,18.845490,0.728342],[1.500000,18.912939,0.551014],[1.500000,19.010025,0.395030],[0.299999,19.637436,0.000000],[0.900002,19.637436,0.000000],[1.500000,19.637436,0.000000],[1.500000,19.137854,0.255843],[1.500000,19.290661,0.140815],[1.500000,19.426281,1.723424],[1.500000,20.039299,1.723424],[1.500000,20.039299,1.846526],[1.500000,19.426281,1.600323],[1.500000,20.039299,1.600323],[1.500000,19.426281,1.477221],[1.500000,20.039299,1.477221],[1.500000,21.265339,1.477221],[1.500000,21.265339,1.723424],[1.500000,20.039299,1.354119],[1.500000,20.039299,1.231018],[1.500000,21.265339,1.231018],[1.500000,19.426281,1.354119],[1.500000,19.426281,1.231018],[1.500000,19.426281,1.107916],[1.500000,20.039299,1.107916],[1.500000,19.426281,0.984814],[1.500000,20.039299,0.984814],[1.500000,21.265339,0.984814],[1.500000,23.717417,0.984814],[1.500000,23.717417,1.477221],[1.500000,21.265339,0.738611],[1.500000,21.265339,0.492407],[1.500000,23.717417,0.492407],[1.500000,20.039299,0.861712],[1.500000,20.039299,0.738611],[1.500000,19.426281,0.861712],[1.500000,19.426281,0.738611],[1.500000,19.426281,0.615509],[1.500000,20.039299,0.615509],[1.500000,19.426281,0.492407],[1.500000,20.039299,0.492407],[1.500000,20.039299,0.369306],[1.500000,20.039299,0.246204],[1.500000,21.265339,0.246204],[1.500000,19.426281,0.369306],[1.500000,19.426281,0.246204],[1.500000,20.039299,0.123102],[1.500000,37.203842,1.600323],[1.500000,37.203842,1.723424],[1.500000,35.977806,1.723424],[1.500000,35.977806,1.477221],[1.500000,37.203842,1.477221],[1.500000,37.816864,1.723424],[1.500000,37.816864,1.600323],[1.500000,37.816864,1.477221],[1.500000,35.977806,1.231018],[1.500000,33.525726,1.477221],[1.500000,33.525726,0.984814],[1.500000,35.977806,0.984814],[1.500000,37.203842,1.354119],[1.500000,37.816864,1.354119],[1.500000,37.203842,1.231018],[1.500000,37.816864,1.231018],[1.500000,37.203842,1.107916],[1.500000,37.203842,0.984814],[1.500000,37.816864,1.107916],[1.500000,37.816864,0.984814],[1.500000,37.203842,0.861712],[1.500000,37.816864,0.861712],[1.500000,37.203842,0.738611],[1.500000,37.816864,0.738611],[1.500000,35.977806,0.738611],[1.500000,37.203842,0.615509],[1.500000,35.977806,0.492407],[1.500000,37.203842,0.492407],[1.500000,37.816864,0.615509],[1.500000,37.816864,0.492407],[1.500000,33.525726,0.492407],[1.500000,37.203842,0.369306],[1.500000,37.816864,0.369306],[1.500000,37.203842,0.246204],[1.500000,37.816864,0.246204],[1.500000,35.977806,0.246204],[1.500000,37.203842,0.123102],[1.500000,25.626860,0.000000],[1.500000,28.621572,1.969628],[1.500000,24.254318,1.969628],[1.500000,31.616285,0.000000],[1.500000,32.988831,1.969628],[-0.099998,-29.414543,0.056040],[-0.099998,-29.496786,0.024648],[-0.500000,-29.496786,0.024648],[-0.500000,-29.414543,0.056040],[1.099998,-29.414543,0.056040],[1.099998,-29.496786,0.024648],[0.700001,-29.496786,0.024648],[0.700001,-29.414543,0.056040],[0.700001,-29.335157,0.093671],[-0.099998,-29.258514,0.137752],[0.700001,-29.258514,0.137752],[1.099998,-29.335157,0.093671],[1.099998,-29.258514,0.137752],[-0.099998,-29.112495,0.248007],[-0.099998,-29.183100,0.189813],[-0.500000,-29.183100,0.189813],[-0.500000,-29.112495,0.248007],[-0.500000,-29.258514,0.137752],[0.700001,-29.112495,0.248007],[-0.099998,-28.992155,0.376149],[-0.099998,-29.049335,0.309811],[-0.500000,-29.049335,0.309811],[-0.500000,-28.992155,0.376149],[0.700001,-29.049335,0.309811],[0.700001,-28.992155,0.376149],[1.099998,-29.049335,0.309811],[1.099998,-29.112495,0.248007],[1.099998,-28.992155,0.376149],[-0.099998,-28.895641,0.523092],[-0.099998,-28.940281,0.448080],[-0.500000,-28.940281,0.448080],[-0.500000,-28.895641,0.523092],[0.700001,-28.940281,0.448080],[0.700001,-28.895641,0.523092],[1.099998,-28.940281,0.448080],[1.099998,-28.895641,0.523092],[-0.099998,-28.825169,0.689979],[-0.099998,-28.856091,0.605854],[-0.500000,-28.856091,0.605854],[-0.500000,-28.825169,0.689979],[0.700001,-28.825169,0.689979],[-0.099998,-28.788450,0.858096],[-0.099998,-28.802732,0.774390],[-0.500000,-28.802732,0.774390],[-0.500000,-28.788450,0.858096],[0.700001,-28.802732,0.774390],[0.700001,-28.788450,0.858096],[1.099998,-28.802732,0.774390],[1.099998,-28.825169,0.689979],[1.099998,-28.788450,0.858096],[-0.099998,-28.782572,1.024745],[-0.099998,-28.781780,0.942144],[-0.500000,-28.781780,0.942144],[-0.500000,-28.782572,1.024745],[0.700001,-28.781780,0.942144],[0.700001,-28.782572,1.024745],[1.099998,-28.781780,0.942144],[1.099998,-28.782572,1.024745],[-0.099998,-28.807280,1.194399],[-0.099998,-28.790878,1.108843],[-0.500000,-28.790878,1.108843],[-0.500000,-28.807280,1.194399],[0.700001,-28.790878,1.108843],[0.700001,-28.807280,1.194399],[1.099998,-28.790878,1.108843],[1.099998,-28.807280,1.194399],[-0.099998,-28.865257,1.364094],[-0.099998,-28.831930,1.279522],[-0.500000,-28.831930,1.279522],[-0.500000,-28.865257,1.364094],[0.700001,-28.865257,1.364094],[-0.099998,-28.949482,1.514581],[-0.099998,-28.903694,1.440495],[-0.500000,-28.903694,1.440495],[-0.500000,-28.949482,1.514581],[0.700001,-28.903694,1.440495],[0.700001,-28.949482,1.514581],[1.099998,-28.903694,1.440495],[1.099998,-28.865257,1.364094],[1.099998,-28.949482,1.514581],[-0.099998,-29.060740,1.651031],[-0.099998,-29.001835,1.584802],[-0.500000,-29.001835,1.584802],[-0.500000,-29.060740,1.651031],[0.700001,-29.001835,1.584802],[0.700001,-29.060740,1.651031],[1.099998,-29.001835,1.584802],[1.099998,-29.060740,1.651031],[-0.099998,-29.195812,1.768524],[-0.099998,-29.125629,1.712496],[-0.500000,-29.125629,1.712496],[-0.500000,-29.195812,1.768524],[0.700001,-29.125629,1.712496],[0.700001,-29.195812,1.768524],[1.099998,-29.125629,1.712496],[1.099998,-29.195812,1.768524],[-0.099998,-29.348728,1.862197],[-0.099998,-29.270473,1.818562],[-0.500000,-29.270473,1.818562],[-0.500000,-29.348728,1.862197],[0.700001,-29.348728,1.862197],[-0.099998,-29.512270,1.929350],[-0.099998,-29.429642,1.899165],[-0.500000,-29.429642,1.899165],[-0.500000,-29.512270,1.929350],[0.700001,-29.429642,1.899165],[0.700001,-29.512270,1.929350],[1.099998,-29.429642,1.899165],[1.099998,-29.348728,1.862197],[1.099998,-29.512270,1.929350],[-0.099998,-29.595686,1.952784],[-0.500000,-29.595686,1.952784],[1.099998,-29.595686,1.952784],[0.700001,-29.595686,1.952784],[-0.900002,-29.579983,0.000000],[-0.900002,-29.415098,0.055804],[-0.299999,-29.579983,0.000000],[-0.900002,-29.257675,0.138280],[-0.900002,-29.115034,0.245732],[0.299999,-29.579983,0.000000],[-0.900002,-28.993694,0.374206],[-0.900002,-28.898418,0.517955],[-0.900002,-28.831625,0.670259],[-0.900002,-28.793270,0.824392],[-0.900002,-28.781223,0.974444],[-0.900002,-28.795189,1.135923],[0.900002,-29.579983,0.000000],[1.500000,-29.579983,0.000000],[1.500000,-29.414543,0.056040],[1.500000,-29.258514,0.137752],[1.500000,-29.112495,0.248007],[1.500000,-28.992155,0.376149],[1.500000,-28.825169,0.689979],[1.500000,-28.895641,0.523092],[1.500000,-28.788450,0.858096],[1.500000,-28.782572,1.024745],[-0.900002,-28.839762,1.301635],[-0.900002,-28.917322,1.464105],[-0.900002,-29.027361,1.614920],[-0.900002,-29.166090,1.745967],[-0.900002,-29.326769,1.850782],[-0.900002,-29.500771,1.925578],[-0.900002,-29.679018,1.969628],[-0.299999,-29.679018,1.969628],[0.299999,-29.679018,1.969628],[1.500000,-28.807280,1.194399],[1.500000,-28.949482,1.514581],[1.500000,-28.865257,1.364094],[1.500000,-29.060740,1.651031],[1.500000,-29.195812,1.768524],[0.900002,-29.679018,1.969628],[1.500000,-29.348728,1.862197],[1.500000,-29.512270,1.929350],[1.500000,-29.679018,1.969628],[-0.099998,-37.701202,1.928586],[-0.099998,-37.616608,1.952497],[-0.500000,-37.616608,1.952497],[-0.500000,-37.701202,1.928586],[1.099998,-37.701202,1.928586],[1.099998,-37.616608,1.952497],[0.700001,-37.616608,1.952497],[0.700001,-37.701202,1.928586],[-0.099998,-37.863785,1.861486],[-0.099998,-37.783348,1.898390],[-0.500000,-37.783348,1.898390],[-0.500000,-37.863785,1.861486],[0.700001,-37.783348,1.898390],[0.700001,-37.863785,1.861486],[1.099998,-37.783348,1.898390],[1.099998,-37.863785,1.861486],[-0.099998,-38.018433,1.766221],[-0.099998,-37.942963,1.817132],[-0.500000,-37.942963,1.817132],[-0.500000,-38.018433,1.766221],[0.700001,-38.018433,1.766221],[-0.099998,-38.150803,1.650579],[-0.099998,-38.087173,1.711014],[-0.500000,-38.087173,1.711014],[-0.500000,-38.150803,1.650579],[0.700001,-38.087173,1.711014],[0.700001,-38.150803,1.650579],[1.099998,-38.087173,1.711014],[1.099998,-38.018433,1.766221],[1.099998,-38.150803,1.650579],[-0.099998,-38.261833,1.514270],[-0.099998,-38.209587,1.584414],[-0.500000,-38.209587,1.584414],[-0.500000,-38.261833,1.514270],[0.700001,-38.209587,1.584414],[0.700001,-38.261833,1.514270],[1.099998,-38.209587,1.584414],[1.099998,-38.261833,1.514270],[-0.099998,-38.347374,1.360678],[-0.099998,-38.308434,1.438668],[-0.500000,-38.308434,1.438668],[-0.500000,-38.347374,1.360678],[0.700001,-38.308434,1.438668],[0.700001,-38.347374,1.360678],[1.099998,-38.308434,1.438668],[1.099998,-38.347374,1.360678],[-0.099998,-38.404854,1.190079],[-0.099998,-38.380493,1.275632],[-0.500000,-38.380493,1.275632],[-0.500000,-38.404854,1.190079],[0.700001,-38.404854,1.190079],[-0.099998,-38.428703,1.021541],[-0.099998,-38.420769,1.105070],[-0.500000,-38.420769,1.105070],[-0.500000,-38.428703,1.021541],[0.700001,-38.420769,1.105070],[0.700001,-38.428703,1.021541],[1.099998,-38.420769,1.105070],[1.099998,-38.404854,1.190079],[1.099998,-38.428703,1.021541],[-0.099998,-38.421852,0.851810],[-0.099998,-38.429153,0.937484],[-0.500000,-38.429153,0.937484],[-0.500000,-38.421852,0.851810],[0.700001,-38.429153,0.937484],[0.700001,-38.421852,0.851810],[1.099998,-38.429153,0.937484],[1.099998,-38.421852,0.851810],[-0.099998,-38.383156,0.681307],[-0.099998,-38.406708,0.766877],[-0.500000,-38.406708,0.766877],[-0.500000,-38.383156,0.681307],[0.700001,-38.406708,0.766877],[0.700001,-38.383156,0.681307],[1.099998,-38.406708,0.766877],[1.099998,-38.383156,0.681307],[-0.099998,-38.313995,0.520362],[-0.099998,-38.352600,0.600165],[-0.500000,-38.352600,0.600165],[-0.500000,-38.313995,0.520362],[0.700001,-38.313995,0.520362],[-0.099998,-38.218819,0.375978],[-0.099998,-38.269897,0.446672],[-0.500000,-38.269897,0.446672],[-0.500000,-38.218819,0.375978],[0.700001,-38.269897,0.446672],[0.700001,-38.218819,0.375978],[1.099998,-38.269897,0.446672],[1.099998,-38.313995,0.520362],[1.099998,-38.218819,0.375978],[-0.099998,-38.097359,0.246882],[-0.099998,-38.161125,0.309121],[-0.500000,-38.161125,0.309121],[-0.500000,-38.097359,0.246882],[0.700001,-38.161125,0.309121],[0.700001,-38.097359,0.246882],[1.099998,-38.161125,0.309121],[1.099998,-38.097359,0.246882],[-0.099998,-37.954407,0.138896],[-0.099998,-38.028191,0.189950],[-0.500000,-38.028191,0.189950],[-0.500000,-37.954407,0.138896],[0.700001,-38.028191,0.189950],[0.700001,-37.954407,0.138896],[1.099998,-38.028191,0.189950],[1.099998,-37.954407,0.138896],[-0.099998,-37.796532,0.056027],[-0.099998,-37.876877,0.094159],[-0.500000,-37.876877,0.094159],[-0.500000,-37.796532,0.056027],[0.700001,-37.796532,0.056027],[-0.099998,-37.714302,0.024642],[-0.500000,-37.714302,0.024642],[-0.900002,-37.710335,1.925578],[-0.900002,-37.532089,1.969628],[-0.299999,-37.532089,1.969628],[-0.900002,-37.884338,1.850782],[0.299999,-37.532089,1.969628],[-0.900002,-38.045021,1.745967],[-0.900002,-38.183746,1.614920],[-0.900002,-38.293785,1.464105],[-0.900002,-38.371346,1.301635],[-0.900002,-38.415916,1.135923],[0.900002,-37.532089,1.969628],[1.500000,-37.532089,1.969628],[1.500000,-37.701202,1.928586],[1.500000,-37.863785,1.861486],[1.500000,-38.018433,1.766221],[1.500000,-38.150803,1.650579],[1.500000,-38.261833,1.514270],[1.500000,-38.404854,1.190079],[1.500000,-38.347374,1.360678],[-0.900002,-38.429886,0.974444],[-0.900002,-38.417839,0.824392],[-0.900002,-38.379478,0.670259],[-0.900002,-38.312691,0.517955],[-0.900002,-38.217415,0.374206],[-0.900002,-38.096069,0.245732],[-0.900002,-37.953430,0.138280],[-0.900002,-37.796005,0.055804],[-0.900002,-37.631126,0.000000],[-0.299999,-37.631126,0.000000],[1.500000,-38.428703,1.021541],[1.500000,-38.421852,0.851810],[1.500000,-38.383156,0.681307],[1.500000,-38.313995,0.520362],[1.500000,-38.218819,0.375978],[0.299999,-37.631126,0.000000],[0.900002,-37.631126,0.000000],[1.500000,-37.631126,0.000000],[1.500000,-38.097359,0.246882],[1.500000,-37.954407,0.138896],[1.500000,-29.987307,1.600323],[1.500000,-29.987307,1.723424],[1.500000,-31.193388,1.723424],[1.500000,-31.193388,1.477221],[1.500000,-29.987307,1.477221],[1.500000,-29.384266,1.723424],[1.500000,-29.384266,1.600323],[1.500000,-29.384266,1.477221],[1.500000,-31.193388,1.231018],[1.500000,-33.605553,1.477221],[1.500000,-33.605553,0.984814],[1.500000,-31.193388,0.984814],[1.500000,-29.987307,1.354119],[1.500000,-29.384266,1.354119],[1.500000,-29.987307,1.231018],[1.500000,-29.384266,1.231018],[1.500000,-29.987307,1.107916],[1.500000,-29.987307,0.984814],[1.500000,-29.384266,1.107916],[1.500000,-29.384266,0.984814],[1.500000,-37.826843,1.723424],[1.500000,-37.223801,1.723424],[1.500000,-37.223801,1.846526],[1.500000,-37.826843,1.600323],[1.500000,-37.223801,1.600323],[1.500000,-37.826843,1.477221],[1.500000,-37.223801,1.477221],[1.500000,-36.017715,1.477221],[1.500000,-36.017715,1.723424],[1.500000,-37.223801,1.354119],[1.500000,-37.223801,1.231018],[1.500000,-36.017715,1.231018],[1.500000,-37.826843,1.354119],[1.500000,-37.826843,1.231018],[1.500000,-37.826843,1.107916],[1.500000,-37.223801,1.107916],[1.500000,-37.826843,0.984814],[1.500000,-37.223801,0.984814],[1.500000,-36.017715,0.984814],[1.500000,-36.017715,0.738611],[1.500000,-36.017715,0.492407],[1.500000,-33.605553,0.492407],[1.500000,-37.223801,0.861712],[1.500000,-37.223801,0.738611],[1.500000,-37.826843,0.861712],[1.500000,-37.826843,0.738611],[1.500000,-37.826843,0.615509],[1.500000,-37.223801,0.615509],[1.500000,-37.826843,0.492407],[1.500000,-37.223801,0.492407],[1.500000,-37.223801,0.369306],[1.500000,-37.223801,0.246204],[1.500000,-36.017715,0.246204],[1.500000,-37.826843,0.369306],[1.500000,-37.826843,0.246204],[1.500000,-37.223801,0.123102],[1.500000,-29.987307,0.861712],[1.500000,-29.384266,0.861712],[1.500000,-29.987307,0.738611],[1.500000,-29.384266,0.738611],[1.500000,-31.193388,0.738611],[1.500000,-29.987307,0.615509],[1.500000,-31.193388,0.492407],[1.500000,-29.987307,0.492407],[1.500000,-29.384266,0.615509],[1.500000,-29.384266,0.492407],[1.500000,-29.987307,0.369306],[1.500000,-29.384266,0.369306],[1.500000,-29.987307,0.246204],[1.500000,-29.384266,0.246204],[1.500000,-31.193388,0.246204],[1.500000,-29.987307,0.123102],[1.500000,-33.605553,0.000000],[1.500000,-33.605553,1.969628],[-0.099998,6.715487,0.056040],[-0.099998,6.633245,0.024648],[-0.500000,6.633245,0.024648],[-0.500000,6.715487,0.056040],[1.099998,6.715487,0.056040],[1.099998,6.633245,0.024648],[0.700001,6.633245,0.024648],[0.700001,6.715487,0.056040],[0.700001,6.794873,0.093671],[-0.099998,6.871517,0.137752],[0.700001,6.871517,0.137752],[1.099998,6.794873,0.093671],[1.099998,6.871517,0.137752],[-0.099998,7.017534,0.248007],[-0.099998,6.946931,0.189813],[-0.500000,6.946931,0.189813],[-0.500000,7.017534,0.248007],[-0.500000,6.871517,0.137752],[0.700001,7.017534,0.248007],[-0.099998,7.137876,0.376149],[-0.099998,7.080696,0.309811],[-0.500000,7.080696,0.309811],[-0.500000,7.137876,0.376149],[0.700001,7.080696,0.309811],[0.700001,7.137876,0.376149],[1.099998,7.080696,0.309811],[1.099998,7.017534,0.248007],[1.099998,7.137876,0.376149],[-0.099998,7.234388,0.523092],[-0.099998,7.189749,0.448080],[-0.500000,7.189749,0.448080],[-0.500000,7.234388,0.523092],[0.700001,7.189749,0.448080],[0.700001,7.234388,0.523092],[1.099998,7.189749,0.448080],[1.099998,7.234388,0.523092],[-0.099998,7.304862,0.689979],[-0.099998,7.273940,0.605854],[-0.500000,7.273940,0.605854],[-0.500000,7.304862,0.689979],[0.700001,7.304862,0.689979],[-0.099998,7.341579,0.858096],[-0.099998,7.327299,0.774390],[-0.500000,7.327299,0.774390],[-0.500000,7.341579,0.858096],[0.700001,7.327299,0.774390],[0.700001,7.341579,0.858096],[1.099998,7.327299,0.774390],[1.099998,7.304862,0.689979],[1.099998,7.341579,0.858096],[-0.099998,7.347459,1.024745],[-0.099998,7.348251,0.942144],[-0.500000,7.348251,0.942144],[-0.500000,7.347459,1.024745],[0.700001,7.348251,0.942144],[0.700001,7.347459,1.024745],[1.099998,7.348251,0.942144],[1.099998,7.347459,1.024745],[-0.099998,7.322751,1.194400],[-0.099998,7.339152,1.108843],[-0.500000,7.339152,1.108843],[-0.500000,7.322751,1.194400],[0.700001,7.339152,1.108843],[0.700001,7.322751,1.194400],[1.099998,7.339152,1.108843],[1.099998,7.322751,1.194400],[-0.099998,7.264773,1.364094],[-0.099998,7.298101,1.279522],[-0.500000,7.298101,1.279522],[-0.500000,7.264773,1.364094],[0.700001,7.264773,1.364094],[-0.099998,7.180548,1.514581],[-0.099998,7.226335,1.440496],[-0.500000,7.226335,1.440496],[-0.500000,7.180548,1.514581],[0.700001,7.226335,1.440496],[0.700001,7.180548,1.514581],[1.099998,7.226335,1.440496],[1.099998,7.264773,1.364094],[1.099998,7.180548,1.514581],[-0.099998,7.069291,1.651031],[-0.099998,7.128195,1.584803],[-0.500000,7.128195,1.584803],[-0.500000,7.069291,1.651031],[0.700001,7.128195,1.584803],[0.700001,7.069291,1.651031],[1.099998,7.128195,1.584803],[1.099998,7.069291,1.651031],[-0.099998,6.934219,1.768524],[-0.099998,7.004400,1.712496],[-0.500000,7.004400,1.712496],[-0.500000,6.934219,1.768524],[0.700001,7.004400,1.712496],[0.700001,6.934219,1.768524],[1.099998,7.004400,1.712496],[1.099998,6.934219,1.768524],[-0.099998,6.781301,1.862198],[-0.099998,6.859557,1.818563],[-0.500000,6.859557,1.818563],[-0.500000,6.781301,1.862198],[0.700001,6.859557,1.818563],[0.700001,6.781301,1.862198],[1.099998,6.859557,1.818563],[1.099998,6.781301,1.862198],[-0.099998,6.617760,1.929350],[-0.099998,6.700387,1.899165],[-0.500000,6.700387,1.899165],[-0.500000,6.617760,1.929350],[0.700001,6.617760,1.929350],[-0.099998,6.534343,1.952784],[-0.500000,6.534343,1.952784],[-0.900002,6.550046,0.000000],[-0.900002,6.714932,0.055804],[-0.299999,6.550046,0.000000],[-0.900002,6.872355,0.138280],[-0.900002,7.014996,0.245732],[0.299999,6.550046,0.000000],[0.900002,6.550046,0.000000],[-0.900002,7.136337,0.374206],[-0.900002,7.231611,0.517955],[-0.900002,7.298405,0.670259],[-0.900002,7.336759,0.824392],[-0.900002,7.348806,0.974444],[1.500000,6.550046,0.000000],[1.500000,6.715487,0.056040],[1.500000,6.871517,0.137752],[1.500000,7.017534,0.248007],[1.500000,7.137876,0.376149],[1.500000,7.304862,0.689979],[1.500000,7.234388,0.523092],[1.500000,7.341579,0.858096],[1.500000,7.347459,1.024745],[-0.900002,7.334842,1.135923],[-0.900002,7.290268,1.301635],[-0.900002,7.212708,1.464105],[-0.900002,7.102669,1.614920],[-0.900002,6.963941,1.745967],[-0.900002,6.803262,1.850782],[-0.900002,6.629260,1.925578],[-0.900002,6.451011,1.969628],[-0.419998,6.451011,1.969628],[1.500000,7.264773,1.364094],[1.500000,7.322751,1.194400],[1.500000,7.180548,1.514581],[1.500000,7.069291,1.651031],[0.540001,6.451011,1.969628],[0.060001,6.451011,1.969628],[1.020000,6.451011,1.969628],[1.500000,6.451012,1.969628],[1.500000,6.934219,1.768524],[1.500000,6.781301,1.862198],[-0.099998,-1.571170,1.928586],[-0.099998,-1.486577,1.952497],[-0.500000,-1.486577,1.952497],[-0.500000,-1.571170,1.928586],[1.099998,-1.571170,1.928586],[1.099998,-1.486577,1.952497],[0.700001,-1.486577,1.952497],[0.700001,-1.571170,1.928586],[-0.099998,-1.733751,1.861486],[-0.099998,-1.653319,1.898390],[-0.500000,-1.653319,1.898390],[-0.500000,-1.733751,1.861486],[0.700001,-1.653319,1.898390],[0.700001,-1.733751,1.861486],[1.099998,-1.653319,1.898390],[1.099998,-1.733751,1.861486],[-0.099998,-1.888400,1.766221],[-0.099998,-1.812933,1.817132],[-0.500000,-1.812933,1.817132],[-0.500000,-1.888400,1.766221],[0.700001,-1.888400,1.766221],[-0.099998,-2.020776,1.650579],[-0.099998,-1.957147,1.711014],[-0.500000,-1.957147,1.711014],[-0.500000,-2.020776,1.650579],[0.700001,-1.957147,1.711014],[0.700001,-2.020776,1.650579],[1.099998,-1.957147,1.711014],[1.099998,-1.888400,1.766221],[1.099998,-2.020776,1.650579],[-0.099998,-2.131806,1.514270],[-0.099998,-2.079558,1.584414],[-0.500000,-2.079558,1.584414],[-0.500000,-2.131806,1.514270],[0.700001,-2.079558,1.584414],[0.700001,-2.131806,1.514270],[1.099998,-2.079558,1.584414],[1.099998,-2.131806,1.514270],[-0.099998,-2.217347,1.360678],[-0.099998,-2.178401,1.438668],[-0.500000,-2.178401,1.438668],[-0.500000,-2.217347,1.360678],[0.700001,-2.178401,1.438668],[0.700001,-2.217347,1.360678],[1.099998,-2.178401,1.438668],[1.099998,-2.217347,1.360678],[-0.099998,-2.274823,1.190079],[-0.099998,-2.250463,1.275632],[-0.500000,-2.250463,1.275632],[-0.500000,-2.274823,1.190079],[0.700001,-2.274823,1.190079],[-0.099998,-2.298671,1.021541],[-0.099998,-2.290735,1.105070],[-0.500000,-2.290735,1.105070],[-0.500000,-2.298671,1.021541],[0.700001,-2.290735,1.105070],[0.700001,-2.298671,1.021541],[1.099998,-2.290735,1.105070],[1.099998,-2.274823,1.190079],[1.099998,-2.298671,1.021541],[-0.099998,-2.291821,0.851810],[-0.099998,-2.299125,0.937484],[-0.500000,-2.299125,0.937484],[-0.500000,-2.291821,0.851810],[0.700001,-2.299125,0.937484],[0.700001,-2.291821,0.851810],[1.099998,-2.299125,0.937484],[1.099998,-2.291821,0.851810],[-0.099998,-2.253127,0.681307],[-0.099998,-2.276681,0.766877],[-0.500000,-2.276681,0.766877],[-0.500000,-2.253127,0.681307],[0.700001,-2.276681,0.766877],[0.700001,-2.253127,0.681307],[1.099998,-2.276681,0.766877],[1.099998,-2.253127,0.681307],[-0.099998,-2.183964,0.520362],[-0.099998,-2.222568,0.600165],[-0.500000,-2.222568,0.600165],[-0.500000,-2.183964,0.520362],[0.700001,-2.183964,0.520362],[-0.099998,-2.088787,0.375978],[-0.099998,-2.139870,0.446672],[-0.500000,-2.139870,0.446672],[-0.500000,-2.088787,0.375978],[0.700001,-2.139870,0.446672],[0.700001,-2.088787,0.375978],[1.099998,-2.139870,0.446672],[1.099998,-2.183964,0.520362],[1.099998,-2.088787,0.375978],[-0.099998,-1.967328,0.246882],[-0.099998,-2.031094,0.309121],[-0.500000,-2.031094,0.309121],[-0.500000,-1.967328,0.246882],[0.700001,-2.031094,0.309121],[0.700001,-1.967328,0.246882],[1.099998,-2.031094,0.309121],[1.099998,-1.967328,0.246882],[-0.099998,-1.824377,0.138896],[-0.099998,-1.898160,0.189950],[-0.500000,-1.898160,0.189950],[-0.500000,-1.824377,0.138896],[0.700001,-1.898160,0.189950],[0.700001,-1.824377,0.138896],[1.099998,-1.898160,0.189950],[1.099998,-1.824377,0.138896],[-0.099998,-1.666502,0.056027],[-0.099998,-1.746850,0.094159],[-0.500000,-1.746850,0.094159],[-0.500000,-1.666502,0.056027],[0.700001,-1.666502,0.056027],[-0.099998,-1.584275,0.024642],[-0.500000,-1.584275,0.024642],[-0.900002,-1.580306,1.925578],[-0.900002,-1.402058,1.969628],[-0.419998,-1.402058,1.969628],[-0.900002,-1.754308,1.850782],[0.060001,-1.402058,1.969628],[0.540001,-1.402058,1.969628],[-0.900002,-1.914987,1.745967],[-0.900002,-2.053715,1.614920],[-0.900002,-2.163755,1.464105],[-0.900002,-2.241314,1.301635],[-0.900002,-2.285888,1.135923],[1.020000,-1.402058,1.969628],[1.500000,-1.402058,1.969628],[1.500000,-1.571170,1.928586],[1.500000,-1.733751,1.861486],[1.500000,-1.888400,1.766221],[1.500000,-2.020776,1.650579],[1.500000,-2.131806,1.514270],[1.500000,-2.274823,1.190079],[1.500000,-2.217347,1.360678],[-0.900002,-2.299852,0.974444],[-0.900002,-2.287806,0.824392],[-0.900002,-2.249451,0.670259],[-0.900002,-2.182657,0.517955],[-0.900002,-2.087383,0.374206],[-0.900002,-1.966042,0.245732],[-0.900002,-1.823401,0.138280],[-0.900002,-1.665979,0.055804],[-0.900002,-1.501093,0.000000],[-0.299999,-1.501093,0.000000],[1.500000,-2.298671,1.021541],[1.500000,-2.291821,0.851810],[1.500000,-2.253127,0.681307],[1.500000,-2.183964,0.520362],[1.500000,-2.088787,0.375978],[0.299999,-1.501093,0.000000],[0.900002,-1.501093,0.000000],[1.500000,-1.501093,0.000000],[1.500000,-1.967328,0.246882],[1.500000,-1.824377,0.138896],[1.500000,6.142724,1.600323],[1.500000,6.142724,1.723424],[1.500000,4.936641,1.723424],[1.500000,4.936641,1.477221],[1.500000,6.142724,1.477221],[1.500000,6.745765,1.723424],[1.500000,6.745765,1.600323],[1.500000,6.745765,1.477221],[1.500000,4.936641,1.231018],[1.500000,2.524477,1.477221],[1.500000,2.524477,0.984814],[1.500000,4.936641,0.984814],[1.500000,6.142724,1.354119],[1.500000,6.745765,1.354119],[1.500000,6.142724,1.231018],[1.500000,6.745765,1.231018],[1.500000,6.142724,1.107916],[1.500000,6.142724,0.984814],[1.500000,6.745765,1.107916],[1.500000,6.745765,0.984814],[1.500000,-1.696811,1.723424],[1.500000,-1.093770,1.723424],[1.500000,-1.093770,1.846526],[1.500000,-1.696811,1.600323],[1.500000,-1.093770,1.600323],[1.500000,-1.696811,1.477221],[1.500000,-1.093770,1.477221],[1.500000,0.112312,1.477221],[1.500000,0.112312,1.723424],[1.500000,-1.093770,1.354119],[1.500000,-1.093770,1.231018],[1.500000,0.112312,1.231018],[1.500000,-1.696811,1.354119],[1.500000,-1.696811,1.231018],[1.500000,-1.696811,1.107916],[1.500000,-1.093770,1.107916],[1.500000,-1.696811,0.984814],[1.500000,-1.093770,0.984814],[1.500000,0.112312,0.984814],[1.500000,0.112312,0.738611],[1.500000,0.112312,0.492407],[1.500000,2.524477,0.492407],[1.500000,-1.093770,0.861712],[1.500000,-1.093770,0.738611],[1.500000,-1.696811,0.861712],[1.500000,-1.696811,0.738611],[1.500000,-1.696811,0.615509],[1.500000,-1.093770,0.615509],[1.500000,-1.696811,0.492407],[1.500000,-1.093770,0.492407],[1.500000,-1.093770,0.369306],[1.500000,-1.093770,0.246204],[1.500000,0.112312,0.246204],[1.500000,-1.696811,0.369306],[1.500000,-1.696811,0.246204],[1.500000,-1.093770,0.123102],[1.500000,6.142724,0.861712],[1.500000,6.745765,0.861712],[1.500000,6.142724,0.738611],[1.500000,6.745765,0.738611],[1.500000,4.936641,0.738611],[1.500000,6.142724,0.615509],[1.500000,4.936641,0.492407],[1.500000,6.142724,0.492407],[1.500000,6.745765,0.615509],[1.500000,6.745765,0.492407],[1.500000,6.142724,0.369306],[1.500000,6.745765,0.369306],[1.500000,6.142724,0.246204],[1.500000,6.745765,0.246204],[1.500000,4.936641,0.246204],[1.500000,6.142724,0.123102],[1.500000,2.524477,0.000000],[1.500000,2.524477,1.969628],[-0.900002,40.825729,0.984814],[-0.900002,40.825729,0.000000],[-1.500000,40.825729,0.000000],[-1.500000,40.825729,0.984814],[-1.500000,40.825729,1.969628],[-0.900002,40.825729,1.969628],[-0.900002,-40.825729,1.969628],[-1.500000,-40.825729,1.969628],[-1.500000,-40.825729,0.984814],[-0.900002,-40.825729,0.984814],[-1.500000,-40.825729,0.000000],[-0.900002,-40.825729,0.000000],[-0.900002,8.970274,0.492413],[-0.900002,8.130522,0.492413],[-0.900002,8.130522,0.369310],[-0.900002,8.130522,0.246207],[-0.900002,9.810027,0.246207],[-0.900002,9.810027,0.492413],[-0.900002,7.290768,0.430862],[-0.900002,7.290768,0.369310],[-0.900002,7.290768,0.492413],[-0.900002,7.290768,0.246207],[-0.900002,7.290768,0.184656],[-0.900002,7.290768,0.123104],[-0.900002,8.130522,0.123104],[-0.900002,6.870892,0.061553],[-0.900002,7.290768,0.061553],[-0.900002,9.810027,0.984825],[-0.900002,8.970274,0.984825],[-0.900002,8.970274,0.861722],[-0.900002,9.810027,0.861722],[-0.900002,8.130522,0.923274],[-0.900002,8.130522,0.861722],[-0.900002,8.130522,0.984825],[-0.900002,8.130522,0.800171],[-0.900002,8.130522,0.738619],[-0.900002,8.970274,0.738619],[-0.900002,9.810027,0.738619],[-0.900002,7.710645,0.984825],[-0.900002,7.710645,0.923274],[-0.900002,7.710645,0.861722],[-0.900002,7.710645,0.800171],[-0.900002,7.710645,0.738619],[-0.900002,7.710645,0.677068],[-0.900002,8.130522,0.677068],[-0.900002,7.710645,0.615516],[-0.900002,8.130522,0.615516],[-0.900002,7.290768,0.615516],[-0.900002,8.970274,0.615516],[-0.900002,9.810027,0.615516],[-0.900002,8.130522,1.354134],[-0.900002,8.130522,1.231031],[-0.900002,8.970274,1.231031],[-0.900002,9.810027,1.231031],[-0.900002,9.810027,1.477237],[-0.900002,8.130522,1.477237],[-0.900002,7.290768,1.354134],[-0.900002,7.710645,1.231031],[-0.900002,7.710645,1.169480],[-0.900002,8.130522,1.169480],[-0.900002,7.710645,1.107928],[-0.900002,8.130522,1.107928],[-0.900002,8.970274,1.107928],[-0.900002,9.810027,1.107928],[-0.900002,7.290768,1.846546],[-0.900002,7.290768,1.908098],[-0.900002,6.870892,1.908098],[-0.900002,7.290768,1.784995],[-0.900002,7.290768,1.723443],[-0.900002,8.130522,1.723443],[-0.900002,8.130522,1.846546],[-0.900002,7.290768,1.661892],[-0.900002,7.290768,1.600340],[-0.900002,8.130522,1.600340],[-0.900002,9.810027,1.723443],[-0.900002,13.169039,0.984825],[-0.900002,11.489533,0.984825],[-0.900002,11.489533,0.738619],[-0.900002,13.169039,0.738619],[-0.900002,11.489533,0.492413],[-0.900002,13.169039,0.492413],[-0.900002,13.169039,1.477237],[-0.900002,11.489533,1.477237],[-0.900002,11.489533,1.231031],[-0.900002,13.169039,1.231031],[-0.900002,16.528051,0.369310],[-0.900002,16.528051,0.492413],[-0.900002,14.848545,0.492413],[-0.900002,14.848545,0.246207],[-0.900002,16.528051,0.246207],[-0.900002,13.169039,0.246207],[-0.900002,16.528051,0.861722],[-0.900002,16.528051,0.984825],[-0.900002,14.848545,0.984825],[-0.900002,14.848545,0.738619],[-0.900002,16.528051,0.738619],[-0.900002,16.528051,0.615516],[-0.900002,16.528051,1.354134],[-0.900002,16.528051,1.477237],[-0.900002,14.848545,1.477237],[-0.900002,14.848545,1.231031],[-0.900002,16.528051,1.231031],[-0.900002,16.528051,1.107928],[-0.900002,18.627434,0.369310],[-0.900002,18.207558,0.369310],[-0.900002,18.207558,0.307759],[-0.900002,18.627434,0.307759],[-0.900002,18.207558,0.246207],[-0.900002,18.627434,0.246207],[-0.900002,18.207558,0.492413],[-0.900002,17.367804,0.492413],[-0.900002,17.367804,0.369310],[-0.900002,17.367804,0.246207],[-0.900002,18.627434,0.984825],[-0.900002,18.207558,0.984825],[-0.900002,18.207558,0.923274],[-0.900002,18.627434,0.923274],[-0.900002,18.207558,0.861722],[-0.900002,18.627434,0.861722],[-0.900002,18.207558,0.800171],[-0.900002,18.627434,0.800171],[-0.900002,18.207558,0.738619],[-0.900002,18.627434,0.738619],[-0.900002,17.367804,0.984825],[-0.900002,17.367804,0.861722],[-0.900002,17.367804,0.738619],[-0.900002,18.207558,0.677068],[-0.900002,17.367804,0.615516],[-0.900002,18.207558,0.615516],[-0.900002,18.207558,0.553965],[-0.900002,18.627434,0.677068],[-0.900002,18.627434,0.615516],[-0.900002,18.627434,0.553965],[-0.900002,18.627434,0.492413],[-0.900002,18.627434,1.354134],[-0.900002,18.207558,1.354134],[-0.900002,18.207558,1.292583],[-0.900002,18.627434,1.292583],[-0.900002,18.207558,1.231031],[-0.900002,18.627434,1.231031],[-0.900002,18.207558,1.477237],[-0.900002,17.367804,1.477237],[-0.900002,17.367804,1.354134],[-0.900002,17.367804,1.231031],[-0.900002,18.207558,1.169480],[-0.900002,17.367804,1.107928],[-0.900002,18.207558,1.107928],[-0.900002,18.627434,1.169480],[-0.900002,18.627434,1.107928],[-0.900002,19.047310,1.846546],[-0.900002,18.207558,1.846546],[-0.900002,18.207558,1.723443],[-0.900002,19.047310,1.723443],[-0.900002,18.207558,1.600340],[-0.900002,16.528051,1.723443],[-0.900002,8.731278,0.000000],[-0.900002,10.912510,0.000000],[-0.900002,8.130518,1.969628],[-0.900002,9.810024,1.969628],[-0.900002,11.489531,1.969628],[-0.900002,13.093741,0.000000],[-0.900002,15.274973,0.000000],[-0.900002,17.456203,0.000000],[-0.900002,13.169037,1.969628],[-0.900002,14.848543,1.969628],[-0.900002,16.528049,1.969628],[-0.900002,18.207556,1.969628],[-1.500000,-34.701874,0.492407],[-1.500000,-34.701874,0.430856],[-1.500000,-35.110130,0.430856],[-1.500000,-35.110130,0.492407],[-1.500000,-34.701874,0.369306],[-1.500000,-35.110130,0.369306],[-1.500000,-35.926643,0.492407],[-1.500000,-35.926643,0.369306],[-1.500000,-35.110130,0.246204],[-1.500000,-35.926643,0.246204],[-1.500000,-37.559669,0.492407],[-1.500000,-37.559669,0.246204],[-1.500000,-34.293617,0.184653],[-1.500000,-34.293617,0.246204],[-1.500000,-35.110130,0.123102],[-1.500000,-34.293617,0.123102],[-1.500000,-35.926643,0.123102],[-1.500000,-35.110130,0.984814],[-1.500000,-35.110130,0.861712],[-1.500000,-35.926643,0.861712],[-1.500000,-35.926643,0.984814],[-1.500000,-35.110130,0.800161],[-1.500000,-35.926643,0.738611],[-1.500000,-35.110130,0.738611],[-1.500000,-34.701874,0.861712],[-1.500000,-34.701874,0.800161],[-1.500000,-34.701874,0.738611],[-1.500000,-37.559669,0.984814],[-1.500000,-37.559669,0.738611],[-1.500000,-35.926643,0.615509],[-1.500000,-34.701874,0.677060],[-1.500000,-35.110130,0.677060],[-1.500000,-34.701874,0.615509],[-1.500000,-35.110130,0.615509],[-1.500000,-35.110130,1.477221],[-1.500000,-35.110130,1.354119],[-1.500000,-35.926643,1.354119],[-1.500000,-35.926643,1.477221],[-1.500000,-35.110130,1.292568],[-1.500000,-35.926643,1.231018],[-1.500000,-35.110130,1.231018],[-1.500000,-34.701874,1.354119],[-1.500000,-34.701874,1.292568],[-1.500000,-34.701874,1.231018],[-1.500000,-37.559669,1.477221],[-1.500000,-37.559669,1.231018],[-1.500000,-35.926643,1.107916],[-1.500000,-34.701874,1.169466],[-1.500000,-35.110130,1.169466],[-1.500000,-34.701874,1.107916],[-1.500000,-35.110130,1.107916],[-1.500000,-35.110130,1.046365],[-1.500000,-34.701874,1.046365],[-1.500000,-34.701874,0.984814],[-1.500000,-35.110130,1.846526],[-1.500000,-35.110130,1.723424],[-1.500000,-35.926643,1.723424],[-1.500000,-35.926643,1.846526],[-1.500000,-34.293617,1.784975],[-1.500000,-34.293617,1.846526],[-1.500000,-34.293617,1.723424],[-1.500000,-35.926643,1.600323],[-1.500000,-37.559669,1.723424],[-1.500000,-35.110130,1.600323],[-1.500000,-35.110130,1.538772],[-1.500000,-34.701874,1.600323],[-1.500000,-34.701874,1.538772],[-1.500000,-34.701874,1.477221],[-1.500000,-31.027555,0.492407],[-1.500000,-31.027555,0.369306],[-1.500000,-31.844069,0.369306],[-1.500000,-31.844069,0.492407],[-1.500000,-32.660583,0.430856],[-1.500000,-32.660583,0.369306],[-1.500000,-32.660583,0.492407],[-1.500000,-32.660583,0.307755],[-1.500000,-31.844069,0.246204],[-1.500000,-32.660583,0.246204],[-1.500000,-31.027555,0.246204],[-1.500000,-32.660583,0.184653],[-1.500000,-32.660583,0.123102],[-1.500000,-33.068840,0.123102],[-1.500000,-33.068840,0.184653],[-1.500000,-33.885353,0.123102],[-1.500000,-33.885353,0.061551],[-1.500000,-34.293617,0.061551],[-1.500000,-31.027555,0.123102],[-1.500000,-31.844069,0.123102],[-1.500000,-31.027555,0.984814],[-1.500000,-31.027555,0.861712],[-1.500000,-31.844069,0.861712],[-1.500000,-31.844069,0.984814],[-1.500000,-31.027555,0.738611],[-1.500000,-31.844069,0.738611],[-1.500000,-31.027555,0.615509],[-1.500000,-31.844069,0.615509],[-1.500000,-31.027555,1.477221],[-1.500000,-31.027555,1.354119],[-1.500000,-31.844069,1.354119],[-1.500000,-31.844069,1.477221],[-1.500000,-31.027555,1.231018],[-1.500000,-31.844069,1.231018],[-1.500000,-31.027555,1.107916],[-1.500000,-31.844069,1.107916],[-1.500000,-32.660583,1.784975],[-1.500000,-31.844069,1.723424],[-1.500000,-32.660583,1.723424],[-1.500000,-31.844069,1.846526],[-1.500000,-32.660583,1.846526],[-1.500000,-31.027555,1.846526],[-1.500000,-31.027555,1.723424],[-1.500000,-33.885353,1.908077],[-1.500000,-33.885353,1.846526],[-1.500000,-34.293617,1.908077],[-1.500000,-33.068840,1.784975],[-1.500000,-33.068840,1.846526],[-1.500000,-31.027555,1.600323],[-1.500000,-31.844069,1.600323],[-1.500000,-32.660583,1.661874],[-1.500000,-32.660583,1.600323],[-1.500000,-32.660583,1.538772],[-1.500000,-32.660583,1.477221],[-1.500000,-27.761497,0.492407],[-1.500000,-27.761497,0.246204],[-1.500000,-29.394526,0.246204],[-1.500000,-29.394526,0.492407],[-1.500000,-27.761497,0.984814],[-1.500000,-27.761497,0.738611],[-1.500000,-29.394526,0.738611],[-1.500000,-29.394526,0.984814],[-1.500000,-27.761497,1.477221],[-1.500000,-27.761497,1.231018],[-1.500000,-29.394526,1.231018],[-1.500000,-29.394526,1.477221],[-1.500000,-29.394526,1.723424],[-1.500000,-27.761497,1.723424],[-1.500000,-24.495438,0.492407],[-1.500000,-24.495438,0.984814],[-1.500000,-24.495438,1.477221],[-1.500000,-21.229380,0.984814],[-1.500000,-21.229380,0.492407],[-1.500000,-21.229380,1.477221],[-1.500000,-17.963322,0.984814],[-1.500000,-17.963322,0.492407],[-1.500000,-17.963322,1.477221],[-1.500000,-14.697263,0.984814],[-1.500000,-14.697263,0.492407],[-1.500000,-14.697263,1.477221],[-1.500000,-11.431204,0.984814],[-1.500000,-11.431204,0.492407],[-1.500000,-11.431204,1.477221],[-1.500000,-8.165146,0.984814],[-1.500000,-8.165146,0.492407],[-1.500000,-8.165146,1.477221],[-1.500000,-4.899087,0.984814],[-1.500000,-4.899087,0.492407],[-1.500000,-4.899087,1.477221],[-1.500000,-1.633029,0.738611],[-1.500000,-1.633029,0.984814],[-1.500000,-1.633029,0.492407],[-1.500000,-1.633029,1.231018],[-1.500000,-1.633029,1.477221],[-1.500000,1.633030,0.430856],[-1.500000,0.816515,0.492407],[-1.500000,1.633030,0.492407],[-1.500000,0.816515,0.369306],[-1.500000,1.633030,0.369306],[-1.500000,0.000001,0.369306],[-1.500000,0.000001,0.492407],[-1.500000,0.816515,0.246204],[-1.500000,0.000001,0.246204],[-1.500000,1.633030,0.307755],[-1.500000,1.633030,0.246204],[-1.500000,-1.633029,0.246204],[-1.500000,1.633030,0.184653],[-1.500000,0.816515,0.123102],[-1.500000,1.633030,0.123102],[-1.500000,0.000001,0.123102],[-1.500000,0.816515,0.984814],[-1.500000,0.816515,0.861712],[-1.500000,0.000001,0.861712],[-1.500000,0.000001,0.984814],[-1.500000,0.816515,0.800161],[-1.500000,0.000001,0.738611],[-1.500000,0.816515,0.738611],[-1.500000,1.224773,0.861712],[-1.500000,1.224773,0.800161],[-1.500000,1.224773,0.738611],[-1.500000,0.000001,0.615509],[-1.500000,0.816515,0.615509],[-1.500000,0.816515,1.477221],[-1.500000,0.816515,1.354119],[-1.500000,0.000001,1.354119],[-1.500000,0.000001,1.477221],[-1.500000,0.816515,1.231018],[-1.500000,0.000001,1.231018],[-1.500000,0.000001,1.107916],[-1.500000,1.224773,1.231018],[-1.500000,1.224773,1.169466],[-1.500000,0.816515,1.169466],[-1.500000,1.224773,1.107916],[-1.500000,0.816515,1.107916],[-1.500000,0.816515,1.046365],[-1.500000,1.224773,1.046365],[-1.500000,1.224773,0.984814],[-1.500000,0.816515,1.846526],[-1.500000,0.816515,1.723424],[-1.500000,0.000001,1.723424],[-1.500000,0.000001,1.846526],[-1.500000,1.633030,1.784975],[-1.500000,1.633030,1.846526],[-1.500000,1.633030,1.723424],[-1.500000,0.000001,1.600323],[-1.500000,-1.633029,1.723424],[-1.500000,1.633030,1.661874],[-1.500000,0.816515,1.600323],[-1.500000,1.633030,1.600323],[-1.500000,1.633030,1.538772],[-1.500000,1.633030,1.477221],[-1.500000,4.082574,0.430856],[-1.500000,4.899089,0.369306],[-1.500000,4.082574,0.369306],[-1.500000,4.899089,0.492407],[-1.500000,4.082574,0.492407],[-1.500000,3.674317,0.430856],[-1.500000,3.674317,0.492407],[-1.500000,3.674317,0.369306],[-1.500000,4.899089,0.246204],[-1.500000,4.082574,0.246204],[-1.500000,2.041287,0.184653],[-1.500000,2.041287,0.123102],[-1.500000,3.266059,0.123102],[-1.500000,3.266059,0.061551],[-1.500000,2.857802,0.061551],[-1.500000,2.857802,0.123102],[-1.500000,4.899089,0.123102],[-1.500000,4.082574,0.123102],[-1.500000,3.266059,0.184653],[-1.500000,3.266059,0.246204],[-1.500000,4.899089,0.984814],[-1.500000,4.899089,0.861712],[-1.500000,4.082574,0.861712],[-1.500000,4.082574,0.984814],[-1.500000,4.082574,0.800161],[-1.500000,3.674317,0.800161],[-1.500000,3.674317,0.861712],[-1.500000,4.082574,0.738611],[-1.500000,3.674317,0.738611],[-1.500000,4.899089,0.738611],[-1.500000,4.082574,0.677060],[-1.500000,4.899089,0.615509],[-1.500000,4.082574,0.615509],[-1.500000,3.674317,0.677060],[-1.500000,3.674317,0.615509],[-1.500000,4.899089,1.477221],[-1.500000,4.899089,1.354119],[-1.500000,4.082574,1.354119],[-1.500000,4.082574,1.477221],[-1.500000,4.082574,1.292568],[-1.500000,3.674317,1.292568],[-1.500000,3.674317,1.354119],[-1.500000,4.082574,1.231018],[-1.500000,3.674317,1.231018],[-1.500000,4.899089,1.231018],[-1.500000,4.082574,1.169466],[-1.500000,4.899089,1.107916],[-1.500000,4.082574,1.107916],[-1.500000,3.674317,1.169466],[-1.500000,3.674317,1.107916],[-1.500000,4.082574,1.046365],[-1.500000,3.674317,1.046365],[-1.500000,3.674317,0.984814],[-1.500000,3.266059,1.784975],[-1.500000,4.082574,1.723424],[-1.500000,3.266059,1.723424],[-1.500000,4.082574,1.846526],[-1.500000,3.266059,1.846526],[-1.500000,4.899089,1.846526],[-1.500000,4.899089,1.723424],[-1.500000,3.266059,1.908077],[-1.500000,2.857802,1.846526],[-1.500000,2.857802,1.908077],[-1.500000,2.041287,1.846526],[-1.500000,2.041287,1.784975],[-1.500000,4.899089,1.600323],[-1.500000,4.082574,1.600323],[-1.500000,4.082574,1.538772],[-1.500000,3.674317,1.538772],[-1.500000,3.674317,1.600323],[-1.500000,3.674317,1.477221],[-1.500000,8.165148,0.492407],[-1.500000,8.165148,0.246204],[-1.500000,6.532118,0.246204],[-1.500000,6.532118,0.492407],[-1.500000,8.165148,0.984814],[-1.500000,8.165148,0.738611],[-1.500000,6.532118,0.738611],[-1.500000,6.532118,0.984814],[-1.500000,8.165148,1.477221],[-1.500000,8.165148,1.231018],[-1.500000,6.532118,1.231018],[-1.500000,6.532118,1.477221],[-1.500000,6.532118,1.723424],[-1.500000,8.165148,1.723424],[-1.500000,11.431206,0.492407],[-1.500000,11.431206,0.984814],[-1.500000,11.431206,1.477221],[-1.500000,14.697265,0.738611],[-1.500000,14.697265,0.984814],[-1.500000,14.697265,0.492407],[-1.500000,14.697265,1.231018],[-1.500000,14.697265,1.477221],[-1.500000,17.963324,0.861712],[-1.500000,16.330294,0.984814],[-1.500000,17.963324,0.984814],[-1.500000,16.330294,0.738611],[-1.500000,17.963324,0.738611],[-1.500000,16.330294,0.492407],[-1.500000,17.963324,0.615509],[-1.500000,17.963324,0.492407],[-1.500000,17.963324,1.354119],[-1.500000,16.330294,1.477221],[-1.500000,17.963324,1.477221],[-1.500000,16.330294,1.231018],[-1.500000,17.963324,1.231018],[-1.500000,17.963324,1.107916],[-1.500000,20.412867,0.307755],[-1.500000,19.596352,0.369306],[-1.500000,20.412867,0.369306],[-1.500000,19.596352,0.246204],[-1.500000,20.412867,0.246204],[-1.500000,18.779837,0.492407],[-1.500000,19.596352,0.492407],[-1.500000,17.963324,0.246204],[-1.500000,20.821125,0.184653],[-1.500000,20.821125,0.123102],[-1.500000,20.412867,0.123102],[-1.500000,20.412867,0.184653],[-1.500000,19.596352,0.123102],[-1.500000,20.004610,0.861712],[-1.500000,20.004610,0.800161],[-1.500000,19.596352,0.800161],[-1.500000,19.596352,0.861712],[-1.500000,20.004610,0.738611],[-1.500000,19.596352,0.738611],[-1.500000,19.596352,0.984814],[-1.500000,18.779837,0.861712],[-1.500000,18.779837,0.984814],[-1.500000,18.779837,0.738611],[-1.500000,19.596352,0.677060],[-1.500000,18.779837,0.615509],[-1.500000,19.596352,0.615509],[-1.500000,20.004610,0.677060],[-1.500000,20.004610,0.615509],[-1.500000,20.004610,1.354119],[-1.500000,20.004610,1.292568],[-1.500000,19.596352,1.292568],[-1.500000,19.596352,1.354119],[-1.500000,20.004610,1.231018],[-1.500000,19.596352,1.231018],[-1.500000,19.596352,1.477221],[-1.500000,18.779837,1.354119],[-1.500000,18.779837,1.477221],[-1.500000,18.779837,1.231018],[-1.500000,19.596352,1.169466],[-1.500000,18.779837,1.107916],[-1.500000,19.596352,1.107916],[-1.500000,19.596352,1.046365],[-1.500000,20.004610,1.169466],[-1.500000,20.004610,1.107916],[-1.500000,20.004610,1.046365],[-1.500000,20.004610,0.984814],[-1.500000,20.412867,1.784975],[-1.500000,19.596352,1.846526],[-1.500000,20.412867,1.846526],[-1.500000,19.596352,1.723424],[-1.500000,20.412867,1.723424],[-1.500000,20.821125,1.846526],[-1.500000,20.821125,1.784975],[-1.500000,19.596352,1.600323],[-1.500000,17.963324,1.723424],[-1.500000,20.412867,1.661874],[-1.500000,20.412867,1.600323],[-1.500000,24.495440,0.492407],[-1.500000,24.495440,0.369306],[-1.500000,23.678925,0.369306],[-1.500000,23.678925,0.492407],[-1.500000,22.862411,0.430856],[-1.500000,22.862411,0.369306],[-1.500000,22.862411,0.492407],[-1.500000,23.678925,0.246204],[-1.500000,22.862411,0.246204],[-1.500000,24.495440,0.246204],[-1.500000,22.454153,0.430856],[-1.500000,22.454153,0.492407],[-1.500000,22.454153,0.369306],[-1.500000,22.045897,0.307755],[-1.500000,22.045897,0.369306],[-1.500000,22.045897,0.246204],[-1.500000,22.045897,0.184653],[-1.500000,22.862411,0.123102],[-1.500000,22.045897,0.123102],[-1.500000,22.045897,0.061551],[-1.500000,21.637638,0.061551],[-1.500000,21.637638,0.123102],[-1.500000,24.495440,0.984814],[-1.500000,24.495440,0.861712],[-1.500000,23.678925,0.861712],[-1.500000,23.678925,0.984814],[-1.500000,22.862411,0.861712],[-1.500000,22.862411,0.984814],[-1.500000,22.862411,0.800161],[-1.500000,23.678925,0.738611],[-1.500000,22.862411,0.738611],[-1.500000,24.495440,0.738611],[-1.500000,22.454153,0.800161],[-1.500000,22.454153,0.861712],[-1.500000,22.454153,0.738611],[-1.500000,22.862411,0.677060],[-1.500000,22.454153,0.677060],[-1.500000,22.862411,0.615509],[-1.500000,22.454153,0.615509],[-1.500000,24.495440,0.615509],[-1.500000,23.678925,0.615509],[-1.500000,24.495440,1.477221],[-1.500000,24.495440,1.354119],[-1.500000,23.678925,1.354119],[-1.500000,23.678925,1.477221],[-1.500000,22.862411,1.354119],[-1.500000,22.862411,1.477221],[-1.500000,22.862411,1.292568],[-1.500000,23.678925,1.231018],[-1.500000,22.862411,1.231018],[-1.500000,24.495440,1.231018],[-1.500000,22.454153,1.292568],[-1.500000,22.454153,1.354119],[-1.500000,22.454153,1.231018],[-1.500000,22.862411,1.169466],[-1.500000,22.454153,1.169466],[-1.500000,22.862411,1.107916],[-1.500000,22.454153,1.107916],[-1.500000,22.862411,1.046365],[-1.500000,22.454153,1.046365],[-1.500000,22.454153,0.984814],[-1.500000,24.495440,1.107916],[-1.500000,23.678925,1.107916],[-1.500000,22.045897,1.908077],[-1.500000,22.045897,1.846526],[-1.500000,21.637638,1.846526],[-1.500000,21.637638,1.908077],[-1.500000,22.045897,1.784975],[-1.500000,22.862411,1.723424],[-1.500000,22.045897,1.723424],[-1.500000,22.862411,1.846526],[-1.500000,22.045897,1.661874],[-1.500000,22.454153,1.600323],[-1.500000,22.045897,1.600323],[-1.500000,22.862411,1.600323],[-1.500000,22.862411,1.538772],[-1.500000,22.454153,1.538772],[-1.500000,22.454153,1.477221],[-1.500000,24.495440,1.723424],[-1.500000,24.495440,1.600323],[-1.500000,23.678925,1.600323],[-1.500000,23.678925,1.723424],[-1.500000,27.761499,0.492407],[-1.500000,27.761499,0.246204],[-1.500000,26.128469,0.246204],[-1.500000,26.128469,0.492407],[-1.500000,27.761499,0.984814],[-1.500000,27.761499,0.738611],[-1.500000,26.128469,0.738611],[-1.500000,26.128469,0.984814],[-1.500000,27.761499,1.477221],[-1.500000,27.761499,1.231018],[-1.500000,26.128469,1.231018],[-1.500000,26.128469,1.477221],[-1.500000,26.128469,1.723424],[-1.500000,27.761499,1.723424],[-1.500000,31.027557,0.738611],[-1.500000,31.027557,0.984814],[-1.500000,31.027557,0.492407],[-1.500000,31.027557,1.231018],[-1.500000,31.027557,1.477221],[-1.500000,34.293617,0.430856],[-1.500000,33.477104,0.492407],[-1.500000,34.293617,0.492407],[-1.500000,33.477104,0.369306],[-1.500000,34.293617,0.369306],[-1.500000,32.660583,0.369306],[-1.500000,32.660583,0.492407],[-1.500000,33.477104,0.246204],[-1.500000,32.660583,0.246204],[-1.500000,34.293617,0.246204],[-1.500000,31.027557,0.246204],[-1.500000,34.293617,0.984814],[-1.500000,34.293617,0.861712],[-1.500000,33.477104,0.861712],[-1.500000,33.477104,0.984814],[-1.500000,32.660583,0.861712],[-1.500000,32.660583,0.984814],[-1.500000,33.477104,0.738611],[-1.500000,32.660583,0.738611],[-1.500000,34.293617,0.800161],[-1.500000,34.293617,0.738611],[-1.500000,32.660583,0.615509],[-1.500000,34.293617,0.677060],[-1.500000,33.477104,0.615509],[-1.500000,34.293617,0.615509],[-1.500000,34.293617,1.477221],[-1.500000,34.293617,1.354119],[-1.500000,33.477104,1.354119],[-1.500000,33.477104,1.477221],[-1.500000,32.660583,1.354119],[-1.500000,32.660583,1.477221],[-1.500000,33.477104,1.231018],[-1.500000,32.660583,1.231018],[-1.500000,34.293617,1.292568],[-1.500000,34.293617,1.231018],[-1.500000,32.660583,1.107916],[-1.500000,34.293617,1.169466],[-1.500000,33.477104,1.107916],[-1.500000,34.293617,1.107916],[-1.500000,34.293617,1.046365],[-1.500000,32.660583,1.600323],[-1.500000,31.027557,1.723424],[-1.500000,32.660583,1.723424],[-1.500000,34.293617,1.723424],[-1.500000,34.293617,1.600323],[-1.500000,33.477104,1.600323],[-1.500000,33.477104,1.723424],[-1.500000,34.293617,1.538772],[-1.500000,36.743156,0.430856],[-1.500000,37.559677,0.369306],[-1.500000,36.743156,0.369306],[-1.500000,37.559677,0.492407],[-1.500000,36.743156,0.492407],[-1.500000,36.743156,0.307755],[-1.500000,37.559677,0.246204],[-1.500000,36.743156,0.246204],[-1.500000,34.701874,0.492407],[-1.500000,34.701874,0.430856],[-1.500000,34.701874,0.369306],[-1.500000,35.110130,0.184653],[-1.500000,35.110130,0.246204],[-1.500000,34.293617,0.123102],[-1.500000,35.110130,0.123102],[-1.500000,35.518387,0.123102],[-1.500000,35.518387,0.061551],[-1.500000,35.110130,0.061551],[-1.500000,36.743156,0.184653],[-1.500000,37.559677,0.123102],[-1.500000,36.743156,0.123102],[-1.500000,36.334900,0.123102],[-1.500000,36.334900,0.184653],[-1.500000,37.559677,0.861712],[-1.500000,37.559677,0.800161],[-1.500000,37.151421,0.800161],[-1.500000,37.151421,0.861712],[-1.500000,37.559677,0.738611],[-1.500000,37.151421,0.738611],[-1.500000,34.701874,0.861712],[-1.500000,34.701874,0.800161],[-1.500000,34.701874,0.738611],[-1.500000,34.701874,0.677060],[-1.500000,34.701874,0.615509],[-1.500000,34.701874,1.354119],[-1.500000,34.701874,1.292568],[-1.500000,34.701874,1.231018],[-1.500000,34.701874,1.169466],[-1.500000,34.701874,1.107916],[-1.500000,34.701874,1.046365],[-1.500000,34.701874,0.984814],[-1.500000,37.559677,1.231018],[-1.500000,37.559677,1.169466],[-1.500000,37.151421,1.169466],[-1.500000,37.151421,1.231018],[-1.500000,37.559677,1.107916],[-1.500000,37.151421,1.107916],[-1.500000,37.559677,1.046365],[-1.500000,37.151421,1.046365],[-1.500000,37.559677,0.984814],[-1.500000,37.151421,0.984814],[-1.500000,36.743156,1.846526],[-1.500000,36.743156,1.784975],[-1.500000,36.334900,1.784975],[-1.500000,36.334900,1.846526],[-1.500000,37.559677,1.723424],[-1.500000,36.743156,1.723424],[-1.500000,37.559677,1.846526],[-1.500000,35.518387,1.908077],[-1.500000,35.518387,1.846526],[-1.500000,35.110130,1.846526],[-1.500000,35.110130,1.908077],[-1.500000,35.110130,1.784975],[-1.500000,34.293617,1.846526],[-1.500000,35.110130,1.723424],[-1.500000,34.701874,1.600323],[-1.500000,34.701874,1.538772],[-1.500000,34.701874,1.477221],[-1.500000,36.743156,1.661874],[-1.500000,37.559677,1.600323],[-1.500000,36.743156,1.600323],[-1.500000,36.743156,1.538772],[-1.500000,37.559677,1.477221],[-1.500000,36.743156,1.477221],[-1.500000,39.192703,0.246204],[-1.500000,39.192703,0.492407],[-1.500000,39.192703,0.984814],[-1.500000,39.192703,0.861712],[-1.500000,38.376190,0.861712],[-1.500000,38.376190,0.984814],[-1.500000,38.376190,0.738611],[-1.500000,39.192703,0.738611],[-1.500000,37.559677,0.615509],[-1.500000,37.559677,1.354119],[-1.500000,38.376190,1.231018],[-1.500000,39.192703,1.477221],[-1.500000,39.192703,1.231018],[-1.500000,39.192703,1.107916],[-1.500000,38.376190,1.107916],[-1.500000,39.192703,1.723424],[-1.500000,-38.424217,0.000000],[-1.500000,-36.022705,0.000000],[-1.500000,-33.621193,0.000000],[-1.500000,-33.779709,0.125015],[-1.500000,-33.605553,0.109896],[-1.500000,-33.952347,0.171491],[-1.500000,-34.119789,0.252124],[-1.500000,-34.262589,0.358542],[-1.500000,-33.438828,0.123741],[-1.500000,-31.219677,0.000000],[-1.500000,-26.416649,0.000000],[-1.500000,-28.818163,0.000000],[-1.500000,-24.015135,0.000000],[-1.500000,-33.268143,0.168087],[-1.500000,-33.103165,0.245051],[-1.500000,-21.613623,0.000000],[-1.500000,-34.382042,0.490694],[-1.500000,-34.475586,0.651676],[-1.500000,-34.529617,0.820007],[-1.500000,-34.546463,0.984814],[-1.500000,-32.831856,0.486925],[-1.500000,-32.954536,0.353132],[-1.500000,-32.739960,0.641835],[-1.500000,-32.683167,0.812089],[-1.500000,-32.664642,0.984814],[-1.500000,-19.212109,0.000000],[-1.500000,-16.810595,0.000000],[-1.500000,-14.409081,0.000000],[-1.500000,-12.007567,0.000000],[-1.500000,-7.204540,0.000000],[-1.500000,-9.606053,0.000000],[-1.500000,-2.401513,0.000000],[-1.500000,-4.803027,0.000000],[-1.500000,0.000001,0.000000],[-1.500000,2.401515,0.000000],[-1.500000,2.010242,0.252124],[-1.500000,2.524477,0.109896],[-1.500000,2.691200,0.123741],[-1.500000,2.350318,0.125015],[-1.500000,4.803028,0.000000],[-1.500000,7.204542,0.000000],[-1.500000,2.861887,0.168087],[-1.500000,2.177686,0.171491],[-1.500000,3.026864,0.245051],[-1.500000,3.175494,0.353132],[-1.500000,1.867442,0.358542],[-1.500000,1.654446,0.651676],[-1.500000,1.600413,0.820007],[-1.500000,1.583569,0.984814],[-1.500000,1.747989,0.490694],[-1.500000,3.298175,0.486925],[-1.500000,3.390074,0.641835],[-1.500000,3.446867,0.812089],[-1.500000,3.465384,0.984814],[-1.500000,-34.527946,1.157539],[-1.500000,-34.471153,1.327793],[-1.500000,-34.379250,1.482704],[-1.500000,-34.256569,1.616496],[-1.500000,-32.681488,1.149621],[-1.500000,-32.735519,1.317952],[-1.500000,-32.829063,1.478934],[-1.500000,-32.948517,1.611086],[-1.500000,-33.091316,1.717505],[-1.500000,-24.015135,1.969628],[-1.500000,-21.613623,1.969628],[-1.500000,-19.212109,1.969628],[-1.500000,-36.022705,1.969628],[-1.500000,-34.107941,1.724577],[-1.500000,-33.942963,1.801542],[-1.500000,-33.772278,1.845887],[-1.500000,-38.424217,1.969628],[-1.500000,-33.605553,1.859732],[-1.500000,-33.621193,1.969628],[-1.500000,-33.431396,1.844613],[-1.500000,-33.258766,1.798137],[-1.500000,-28.818163,1.969628],[-1.500000,-31.219677,1.969628],[-1.500000,-26.416649,1.969628],[-1.500000,-16.810595,1.969628],[-1.500000,-14.409081,1.969628],[-1.500000,1.602087,1.157539],[-1.500000,1.658880,1.327793],[-1.500000,-12.007567,1.969628],[-1.500000,-7.204540,1.969628],[-1.500000,-4.803027,1.969628],[-1.500000,-9.606053,1.969628],[-1.500000,1.750779,1.482704],[-1.500000,1.873459,1.616496],[-1.500000,3.448541,1.149621],[-1.500000,3.394508,1.317952],[-1.500000,3.300965,1.478934],[-1.500000,3.181511,1.611086],[-1.500000,-2.401513,1.969628],[-1.500000,2.022090,1.724577],[-1.500000,2.187066,1.801542],[-1.500000,2.401515,1.969628],[-1.500000,0.000001,1.969628],[-1.500000,3.038711,1.717505],[-1.500000,2.871268,1.798137],[-1.500000,2.524477,1.859732],[-1.500000,2.357753,1.845887],[-1.500000,2.698636,1.844613],[-1.500000,4.803028,1.969628],[-1.500000,9.606055,0.000000],[-1.500000,12.007569,0.000000],[-1.500000,14.409082,0.000000],[-1.500000,19.212111,0.000000],[-1.500000,16.810596,0.000000],[-1.500000,21.613625,0.000000],[-1.500000,20.760765,0.252124],[-1.500000,20.617966,0.358542],[-1.500000,20.928209,0.171491],[-1.500000,21.275000,0.109896],[-1.500000,21.441725,0.123741],[-1.500000,21.100842,0.125015],[-1.500000,24.015137,0.000000],[-1.500000,21.612411,0.168087],[-1.500000,21.777388,0.245051],[-1.500000,21.926018,0.353132],[-1.500000,20.498512,0.490694],[-1.500000,20.404970,0.651676],[-1.500000,20.350937,0.820007],[-1.500000,20.334093,0.984814],[-1.500000,22.048698,0.486925],[-1.500000,22.140598,0.641835],[-1.500000,22.197390,0.812089],[-1.500000,22.215908,0.984814],[-1.500000,26.416651,0.000000],[-1.500000,28.818165,0.000000],[-1.500000,31.219679,0.000000],[-1.500000,33.621193,0.000000],[-1.500000,35.475914,0.171491],[-1.500000,35.308464,0.252124],[-1.500000,36.022705,0.000000],[-1.500000,35.165665,0.358542],[-1.500000,35.822701,0.109896],[-1.500000,35.648544,0.125015],[-1.500000,35.989426,0.123741],[-1.500000,38.424217,0.000000],[-1.500000,36.325089,0.245051],[-1.500000,36.160110,0.168087],[-1.500000,36.473717,0.353132],[-1.500000,35.046211,0.490694],[-1.500000,34.952675,0.651676],[-1.500000,34.898636,0.820007],[-1.500000,34.881798,0.984814],[-1.500000,36.596397,0.486925],[-1.500000,36.688301,0.641835],[-1.500000,36.745094,0.812089],[-1.500000,36.763611,0.984814],[-1.500000,20.352612,1.157539],[-1.500000,20.409403,1.327793],[-1.500000,14.409082,1.969628],[-1.500000,16.810596,1.969628],[-1.500000,12.007569,1.969628],[-1.500000,20.501303,1.482704],[-1.500000,22.199064,1.149621],[-1.500000,22.145031,1.317952],[-1.500000,22.051489,1.478934],[-1.500000,21.932035,1.611086],[-1.500000,20.623983,1.616496],[-1.500000,7.204542,1.969628],[-1.500000,9.606055,1.969628],[-1.500000,20.772614,1.724577],[-1.500000,20.937590,1.801542],[-1.500000,19.212111,1.969628],[-1.500000,21.613625,1.969628],[-1.500000,21.789236,1.717505],[-1.500000,21.621792,1.798137],[-1.500000,24.015137,1.969628],[-1.500000,21.275000,1.859732],[-1.500000,21.449160,1.844613],[-1.500000,21.108276,1.845887],[-1.500000,26.416651,1.969628],[-1.500000,34.900314,1.157539],[-1.500000,34.957108,1.327793],[-1.500000,35.049004,1.482704],[-1.500000,35.171684,1.616496],[-1.500000,36.746765,1.149621],[-1.500000,36.692734,1.317952],[-1.500000,36.599190,1.478934],[-1.500000,36.479736,1.611086],[-1.500000,31.219679,1.969628],[-1.500000,28.818165,1.969628],[-1.500000,35.320312,1.724577],[-1.500000,33.621193,1.969628],[-1.500000,35.485291,1.801542],[-1.500000,35.655975,1.845887],[-1.500000,36.022705,1.969628],[-1.500000,36.336937,1.717505],[-1.500000,36.169495,1.798137],[-1.500000,35.822701,1.859732],[-1.500000,35.996864,1.844613],[-1.500000,38.424217,1.969628],[-0.900002,-27.322601,0.492414],[-0.900002,-27.322601,0.328277],[-0.900002,-24.966188,0.328277],[-0.900002,-24.966188,0.656551],[-0.900002,-27.322601,0.656551],[-0.900002,-28.500809,0.574482],[-0.900002,-28.500809,0.492414],[-0.900002,-28.500809,0.656551],[-0.900002,-28.500809,0.410345],[-0.900002,-28.500809,0.328277],[-0.900002,-28.500809,0.246208],[-0.900002,-28.500809,0.164139],[-0.900002,-27.322601,0.164139],[-0.900002,-29.089912,0.164139],[-0.900002,-29.089912,0.082070],[-0.900002,-28.500809,0.082070],[-0.900002,-27.322601,1.148963],[-0.900002,-27.322601,0.984826],[-0.900002,-24.966188,0.984826],[-0.900002,-24.966188,1.313100],[-0.900002,-27.322601,1.313100],[-0.900002,-28.500809,1.231031],[-0.900002,-28.500809,1.148963],[-0.900002,-28.500809,1.313100],[-0.900002,-28.500809,1.066894],[-0.900002,-28.500809,0.984826],[-0.900002,-28.500809,0.902757],[-0.900002,-28.500809,0.820688],[-0.900002,-27.322601,0.820688],[-0.900002,-28.500809,0.738620],[-0.900002,-28.500809,1.887580],[-0.900002,-29.089912,1.887580],[-0.900002,-29.089912,1.805512],[-0.900002,-28.500809,1.805512],[-0.900002,-28.500809,1.723443],[-0.900002,-28.500809,1.641375],[-0.900002,-27.322601,1.641375],[-0.900002,-27.322601,1.805512],[-0.900002,-28.500809,1.559306],[-0.900002,-28.500809,1.477237],[-0.900002,-27.322601,1.477237],[-0.900002,-28.500809,1.395169],[-0.900002,-24.966188,1.641375],[-0.900002,-20.253365,0.656551],[-0.900002,-20.253365,1.313100],[-0.900002,-15.540538,1.313100],[-0.900002,-15.540538,0.656551],[-0.900002,-10.827713,1.313100],[-0.900002,-10.827713,0.656551],[-0.900002,-6.114887,0.984826],[-0.900002,-6.114887,1.313100],[-0.900002,-6.114887,0.656551],[-0.900002,-2.580268,0.574482],[-0.900002,-2.580268,0.656551],[-0.900002,-3.758475,0.656551],[-0.900002,-3.758475,0.492414],[-0.900002,-2.580268,0.492414],[-0.900002,-2.580268,0.410345],[-0.900002,-3.758475,0.328277],[-0.900002,-2.580268,0.328277],[-0.900002,-6.114887,0.328277],[-0.900002,-2.580268,0.246208],[-0.900002,-3.758475,0.164139],[-0.900002,-2.580268,0.164139],[-0.900002,-1.991165,0.164139],[-0.900002,-2.580268,0.082070],[-0.900002,-1.991165,0.082070],[-0.900002,-2.580268,1.231031],[-0.900002,-2.580268,1.313100],[-0.900002,-3.758475,1.313100],[-0.900002,-3.758475,1.148963],[-0.900002,-2.580268,1.148963],[-0.900002,-2.580268,1.066894],[-0.900002,-3.758475,0.984826],[-0.900002,-2.580268,0.984826],[-0.900002,-3.758475,0.820688],[-0.900002,-2.580268,0.902757],[-0.900002,-2.580268,0.820688],[-0.900002,-2.580268,0.738620],[-0.900002,-1.991165,1.887580],[-0.900002,-2.580268,1.887580],[-0.900002,-2.580268,1.805512],[-0.900002,-1.991165,1.805512],[-0.900002,-2.580268,1.723443],[-0.900002,-3.758475,1.805512],[-0.900002,-3.758475,1.641375],[-0.900002,-2.580268,1.641375],[-0.900002,-3.758475,1.477237],[-0.900002,-6.114887,1.641375],[-0.900002,-2.580268,1.559306],[-0.900002,-2.580268,1.477237],[-0.900002,-2.580268,1.395169],[-0.900002,-26.070122,0.000000],[-0.900002,-22.560261,0.000000],[-0.900002,-19.050400,0.000000],[-0.900002,-15.540538,0.000000],[-0.900002,-27.911709,1.969628],[-0.900002,-22.609779,1.969628],[-0.900002,-17.307848,1.969628],[-0.900002,-19.075159,1.969628],[-0.900002,-26.144398,1.969628],[-0.900002,-24.377089,1.969628],[-0.900002,-20.842468,1.969628],[-0.900002,-15.540538,1.969628],[-0.900002,-12.030677,0.000000],[-0.900002,-5.010954,0.000000],[-0.900002,-8.520816,0.000000],[-0.900002,-8.471298,1.969628],[-0.900002,-3.169368,1.969628],[-0.900002,-4.936678,1.969628],[-0.900002,-13.773229,1.969628],[-0.900002,-10.238608,1.969628],[-0.900002,-12.005919,1.969628],[-0.900002,-6.703988,1.969628],[-0.900002,39.090904,1.231018],[-0.900002,39.090904,0.984814],[-0.900002,39.958321,0.984814],[-0.900002,39.958321,1.477221],[-0.900002,39.090904,1.477221],[-0.900002,39.090904,1.723424],[-0.900002,38.657204,1.723424],[-0.900002,38.657204,1.477221],[-0.900002,38.657204,1.231018],[-0.900002,38.657204,0.984814],[-0.900002,38.657204,0.738611],[-0.900002,39.090904,0.738611],[-0.900002,38.657204,0.492407],[-0.900002,39.090904,0.492407],[-0.900002,39.958321,0.492407],[-0.900002,39.215721,0.000000],[-0.900002,39.090904,1.969628],[-0.900002,-38.767204,1.477221],[-0.900002,-39.178909,1.477221],[-0.900002,-39.178909,1.231018],[-0.900002,-38.767204,1.231018],[-0.900002,-39.178909,0.984814],[-0.900002,-38.767204,0.984814],[-0.900002,-40.002319,1.477221],[-0.900002,-40.002319,0.984814],[-0.900002,-39.178909,0.738611],[-0.900002,-40.002319,0.492407],[-0.900002,-39.178909,0.492407],[-0.900002,-38.767204,0.738611],[-0.900002,-38.767204,0.492407],[-0.900002,-39.228424,0.000000],[-0.900002,-39.178909,1.969628],[0.000000,30.619299,0.000000],[-0.375000,30.619299,0.000000],[-0.375000,33.170906,0.000000],[0.000000,33.170906,0.000000],[-0.375000,35.722519,0.000000],[0.000000,35.722519,0.000000],[-0.562500,35.722519,0.000000],[-0.750000,33.170906,0.000000],[-0.750000,35.722519,0.000000],[-0.750000,30.619299,0.000000],[-0.562500,36.998322,0.000000],[-0.375000,36.998322,0.000000],[-0.750000,36.998322,0.000000],[-0.937500,35.722519,0.000000],[-0.937500,36.998322,0.000000],[-1.125000,35.722519,0.000000],[-1.125000,36.998322,0.000000],[-1.125000,38.274124,0.000000],[-1.312500,38.274124,0.000000],[-1.312500,39.549927,0.000000],[-1.125000,39.549927,0.000000],[-1.125000,30.619299,0.000000],[-1.125000,33.170906,0.000000],[0.937500,35.722519,0.000000],[0.750000,33.170906,0.000000],[0.750000,35.722519,0.000000],[1.125000,33.170906,0.000000],[1.125000,35.722519,0.000000],[1.125000,30.619299,0.000000],[0.750000,30.619299,0.000000],[1.312500,35.722519,0.000000],[1.125000,36.998322,0.000000],[1.312500,36.998322,0.000000],[0.937500,36.998322,0.000000],[0.750000,36.998322,0.000000],[0.562500,35.722519,0.000000],[0.562500,36.998322,0.000000],[0.375000,35.722519,0.000000],[0.375000,36.998322,0.000000],[0.187500,35.722519,0.000000],[0.187500,36.998322,0.000000],[0.000000,36.998322,0.000000],[0.375000,30.619299,0.000000],[0.375000,33.170906,0.000000],[-0.187500,20.412867,0.000000],[0.000000,22.964476,0.000000],[0.000000,20.412867,0.000000],[-0.375000,22.964476,0.000000],[-0.375000,20.412867,0.000000],[-0.375000,25.516083,0.000000],[0.000000,25.516083,0.000000],[-0.750000,22.964476,0.000000],[-0.750000,25.516083,0.000000],[-0.750000,20.412867,0.000000],[-0.937500,20.412867,0.000000],[-1.125000,22.964476,0.000000],[-1.125000,20.412867,0.000000],[-1.125000,25.516083,0.000000],[1.125000,22.964476,0.000000],[0.750000,22.964476,0.000000],[0.750000,25.516083,0.000000],[1.125000,25.516083,0.000000],[0.937500,20.412867,0.000000],[1.125000,20.412867,0.000000],[0.750000,20.412867,0.000000],[0.375000,25.516083,0.000000],[0.375000,20.412867,0.000000],[0.375000,22.964476,0.000000],[0.187500,20.412867,0.000000],[-0.937500,19.137062,0.000000],[-1.125000,17.861259,0.000000],[-1.125000,19.137062,0.000000],[-0.187500,0.000001,0.000000],[0.000000,2.551609,0.000000],[0.000000,0.000001,0.000000],[-0.375000,2.551609,0.000000],[-0.375000,0.000001,0.000000],[-0.187500,5.103217,0.000000],[-0.375000,5.103217,0.000000],[0.000000,5.103217,0.000000],[-0.750000,2.551609,0.000000],[-0.750000,5.103217,0.000000],[-0.750000,0.000001,0.000000],[-0.187500,6.379022,0.000000],[0.000000,6.379022,0.000000],[-0.937500,5.103217,0.000000],[-0.750000,6.379022,0.000000],[-0.937500,7.654826,0.000000],[-1.125000,6.379022,0.000000],[-1.125000,7.654826,0.000000],[-1.125000,5.103217,0.000000],[-0.937500,0.000001,0.000000],[-1.125000,2.551609,0.000000],[-1.125000,0.000001,0.000000],[0.937500,5.103217,0.000000],[0.750000,2.551609,0.000000],[0.750000,5.103217,0.000000],[1.125000,2.551609,0.000000],[1.125000,5.103217,0.000000],[0.937500,0.000001,0.000000],[1.125000,0.000001,0.000000],[0.750000,0.000001,0.000000],[1.312500,5.103217,0.000000],[1.125000,6.379022,0.000000],[1.312500,6.379022,0.000000],[0.750000,6.379022,0.000000],[0.187500,5.103217,0.000000],[0.187500,6.379022,0.000000],[0.375000,0.000001,0.000000],[0.375000,2.551609,0.000000],[0.375000,5.103217,0.000000],[0.187500,0.000001,0.000000],[0.000000,-1.275803,0.000000],[-0.187500,-1.275803,0.000000],[-0.750000,-1.275803,0.000000],[-1.125000,-1.275803,0.000000],[-0.937500,-2.551607,0.000000],[-1.125000,-2.551607,0.000000],[1.312500,-1.275803,0.000000],[1.125000,-1.275803,0.000000],[1.312500,0.000001,0.000000],[0.750000,-1.275803,0.000000],[0.187500,-1.275803,0.000000],[-0.937500,-28.067690,0.000000],[-1.125000,-29.343494,0.000000],[-1.125000,-28.067690,0.000000],[-0.937500,-30.619299,0.000000],[-1.125000,-30.619299,0.000000],[0.000000,-36.998322,0.000000],[-0.187500,-36.998322,0.000000],[-0.187500,-35.722511,0.000000],[0.000000,-35.722511,0.000000],[-0.375000,-36.998322,0.000000],[-0.375000,-35.722511,0.000000],[0.000000,-33.170906,0.000000],[-0.375000,-33.170906,0.000000],[-0.187500,-30.619299,0.000000],[-0.375000,-30.619299,0.000000],[0.000000,-30.619299,0.000000],[-0.750000,-33.170906,0.000000],[-0.750000,-30.619299,0.000000],[-0.750000,-35.722511,0.000000],[-0.937500,-35.722511,0.000000],[-1.125000,-33.170906,0.000000],[-1.125000,-35.722511,0.000000],[-0.750000,-36.998322,0.000000],[-0.937500,-36.998322,0.000000],[-1.125000,-36.998322,0.000000],[-1.125000,-39.549927,0.000000],[-1.312500,-39.549927,0.000000],[-1.312500,-38.274124,0.000000],[-1.125000,-38.274124,0.000000],[1.312500,-36.998322,0.000000],[1.125000,-36.998322,0.000000],[1.125000,-35.722511,0.000000],[1.312500,-35.722511,0.000000],[0.937500,-36.998322,0.000000],[0.937500,-35.722511,0.000000],[0.750000,-36.998322,0.000000],[0.750000,-35.722511,0.000000],[0.937500,-30.619299,0.000000],[0.750000,-33.170906,0.000000],[0.750000,-30.619299,0.000000],[1.125000,-33.170906,0.000000],[1.125000,-30.619299,0.000000],[0.375000,-35.722511,0.000000],[0.375000,-33.170906,0.000000],[0.375000,-30.619299,0.000000],[0.187500,-30.619299,0.000000],[0.187500,-35.722511,0.000000],[0.375000,-36.998322,0.000000],[0.187500,-36.998322,0.000000],[-0.375000,35.722519,1.969628],[0.000000,30.619299,1.969628],[0.000000,35.722519,1.969628],[-0.750000,30.619299,1.969628],[-0.750000,35.722519,1.969628],[-1.125000,38.274124,1.969628],[-1.125000,39.549927,1.969628],[-1.312500,39.549927,1.969628],[-1.312500,38.274124,1.969628],[0.000000,25.516083,1.969628],[-0.750000,25.516083,1.969628],[0.000000,0.000001,1.969628],[0.000000,2.551609,1.969628],[-0.375000,2.551609,1.969628],[-0.375000,0.000001,1.969628],[-0.562500,0.000001,1.969628],[-0.750000,2.551609,1.969628],[-0.750000,0.000001,1.969628],[-0.562500,5.103217,1.969628],[-0.375000,5.103217,1.969628],[-0.750000,5.103217,1.969628],[0.000000,5.103217,1.969628],[-0.937500,0.000001,1.969628],[-1.125000,2.551609,1.969628],[-1.125000,0.000001,1.969628],[-0.937500,5.103217,1.969628],[-1.125000,5.103217,1.969628],[-1.125000,6.379022,1.969628],[-1.125000,-1.275803,1.969628],[-0.937500,-29.343494,1.969628],[-1.125000,-28.067690,1.969628],[-1.125000,-29.343494,1.969628],[-0.187500,-36.998322,1.969628],[-0.187500,-35.722511,1.969628],[-0.375000,-35.722511,1.969628],[-0.375000,-36.998322,1.969628],[0.000000,-36.998322,1.969628],[0.000000,-35.722511,1.969628],[-1.125000,-39.549927,1.969628],[-1.125000,-38.274124,1.969628],[-1.312500,-38.274124,1.969628],[-1.312500,-39.549927,1.969628],[-0.937500,-36.998322,1.969628],[-0.937500,-35.722511,1.969628],[-1.125000,-35.722511,1.969628],[-1.125000,-36.998322,1.969628],[-0.750000,-36.998322,1.969628],[-0.750000,-35.722511,1.969628],[-1.125000,-33.170906,1.969628],[-0.750000,-33.170906,1.969628],[-0.937500,-30.619299,1.969628],[-0.750000,-30.619299,1.969628],[-1.125000,-30.619299,1.969628],[-0.375000,-33.170906,1.969628],[0.000000,-33.170906,1.969628],[-0.375000,-30.619299,1.969628],[-0.187500,-30.619299,1.969628],[0.000000,-30.619299,1.969628],[0.375000,35.722519,1.969628],[0.750000,30.619299,1.969628],[0.750000,35.722519,1.969628],[0.750000,25.516083,1.969628],[0.937500,0.000001,1.969628],[0.750000,2.551609,1.969628],[0.750000,0.000001,1.969628],[1.125000,2.551609,1.969628],[1.125000,0.000001,1.969628],[0.937500,5.103217,1.969628],[1.125000,5.103217,1.969628],[0.750000,5.103217,1.969628],[0.562500,0.000001,1.969628],[0.375000,2.551609,1.969628],[0.375000,0.000001,1.969628],[0.187500,0.000001,1.969628],[0.187500,5.103217,1.969628],[0.375000,5.103217,1.969628],[0.562500,5.103217,1.969628],[0.937500,-36.998322,1.969628],[0.937500,-35.722511,1.969628],[0.750000,-35.722511,1.969628],[0.750000,-36.998322,1.969628],[1.125000,-36.998322,1.969628],[1.125000,-35.722511,1.969628],[1.312500,-36.998322,1.969628],[1.312500,-35.722511,1.969628],[0.187500,-36.998322,1.969628],[0.187500,-35.722511,1.969628],[0.375000,-36.998322,1.969628],[0.375000,-35.722511,1.969628],[0.750000,-33.170906,1.969628],[0.375000,-33.170906,1.969628],[0.187500,-30.619299,1.969628],[0.375000,-30.619299,1.969628],[0.750000,-30.619299,1.969628],[1.125000,-33.170906,1.969628],[0.937500,-30.619299,1.969628],[1.125000,-30.619299,1.969628],[-2.038296,35.980301,1.493204],[-2.038296,35.928024,1.504761],[-1.858864,35.950966,1.618045],[-1.858864,36.014633,1.603971],[-2.038296,36.032417,1.476655],[-1.858864,36.078110,1.583816],[-2.038296,36.178421,1.397760],[-2.038296,36.133675,1.427894],[-1.858864,36.201431,1.524431],[-1.858864,36.255928,1.487731],[-2.038296,36.220032,1.363540],[-1.858864,36.306602,1.446055],[-2.038296,36.258354,1.325157],[-1.858864,36.353271,1.399309],[-2.038296,36.292267,1.283623],[-1.858864,36.394577,1.348727],[-2.038296,36.323517,1.235953],[-1.858864,36.432632,1.290670],[-2.038296,36.348839,1.186273],[-1.858864,36.463470,1.230165],[-2.038296,36.368134,1.135490],[-1.858864,36.486977,1.168319],[-2.038296,36.381516,1.084477],[-1.858864,36.503265,1.106192],[-2.038296,36.366371,0.828720],[-2.038296,36.380501,0.880362],[-1.858864,36.502029,0.857605],[-1.858864,36.484825,0.794710],[-2.038296,36.346153,0.777404],[-1.858864,36.460205,0.732215],[-2.038296,36.321121,0.729592],[-1.858864,36.429718,0.673985],[-2.038296,36.290581,0.683725],[-1.858864,36.392517,0.618125],[-2.038296,36.255753,0.641615],[-1.858864,36.350105,0.566840],[-2.038296,36.216393,0.602817],[-1.858864,36.302170,0.519589],[-2.038296,36.173080,0.567936],[-1.858864,36.249420,0.477108],[-2.038296,36.126511,0.537457],[-1.858864,36.192703,0.439988],[-2.038296,36.077461,0.511720],[-1.858864,36.132965,0.408644],[-2.038296,36.026749,0.490914],[-1.858864,36.071198,0.383305],[-2.038296,35.665108,0.476424],[-2.038296,35.717384,0.464867],[-1.858864,35.694435,0.351583],[-1.858864,35.630768,0.365658],[-2.038296,35.612984,0.492973],[-1.858864,35.567299,0.385812],[-2.038296,35.466980,0.571868],[-2.038296,35.511726,0.541734],[-1.858864,35.443977,0.445197],[-1.858864,35.389481,0.481897],[-2.038296,35.425377,0.606089],[-1.858864,35.338806,0.523573],[-2.038296,35.387054,0.644472],[-1.858864,35.292137,0.570319],[-2.038296,35.353134,0.686005],[-1.858864,35.250832,0.620901],[-2.038296,35.321892,0.733675],[-1.858864,35.212776,0.678958],[-2.038296,35.296570,0.783356],[-1.858864,35.181938,0.739462],[-2.038296,35.277267,0.834138],[-1.858864,35.158432,0.801309],[-2.038296,35.263893,0.885150],[-1.858864,35.142143,0.863436],[-2.038296,35.279030,1.140909],[-2.038296,35.264908,1.089266],[-1.858864,35.143372,1.112023],[-1.858864,35.160583,1.174918],[-2.038296,35.299248,1.192224],[-1.858864,35.185204,1.237413],[-2.038296,35.324287,1.240036],[-1.858864,35.215691,1.295643],[-2.038296,35.354820,1.285903],[-1.858864,35.252884,1.351503],[-2.038296,35.389656,1.328013],[-1.858864,35.295303,1.402788],[-2.038296,35.429008,1.366811],[-1.858864,35.343239,1.450039],[-2.038296,35.472328,1.401692],[-1.858864,35.395988,1.492520],[-2.038296,35.518890,1.432171],[-1.858864,35.452698,1.529640],[-2.038296,35.567947,1.457908],[-1.858864,35.512436,1.560984],[-2.038296,35.618660,1.478714],[-1.858864,35.574203,1.586323],[-1.858864,35.822701,1.629179],[-2.217728,36.267731,0.984814],[-1.858864,35.945496,0.350645],[-1.858864,35.822701,0.340449],[-2.217728,35.986511,1.369573],[-2.217728,36.066223,1.331174],[-2.217728,36.137383,1.277424],[-2.217728,36.195183,1.211257],[-2.217728,35.822701,1.398627],[-2.217728,36.236481,1.137136],[-2.217728,36.236481,0.832491],[-2.217728,36.195183,0.758371],[-2.217728,36.137383,0.692204],[-2.217728,36.066223,0.638454],[-2.217728,35.986511,0.600055],[-2.217728,35.822701,0.571001],[-1.858864,35.699913,1.618983],[-2.217728,35.377678,0.984814],[-2.217728,35.658890,0.600055],[-2.217728,35.579178,0.638454],[-2.217728,35.508026,0.692204],[-2.217728,35.450218,0.758371],[-2.217728,35.408920,0.832491],[-2.217728,35.408920,1.137136],[-2.217728,35.450218,1.211257],[-2.217728,35.508026,1.277424],[-2.217728,35.579178,1.331174],[-2.217728,35.658890,1.369573],[-2.038296,21.432596,1.493204],[-2.038296,21.380320,1.504761],[-1.858864,21.403267,1.618045],[-1.858864,21.466932,1.603971],[-2.038296,21.484716,1.476655],[-1.858864,21.530407,1.583816],[-2.038296,21.630722,1.397760],[-2.038296,21.585974,1.427894],[-1.858864,21.653728,1.524431],[-1.858864,21.708225,1.487731],[-2.038296,21.672329,1.363540],[-1.858864,21.758898,1.446055],[-2.038296,21.710649,1.325157],[-1.858864,21.805569,1.399309],[-2.038296,21.744566,1.283623],[-1.858864,21.846874,1.348727],[-2.038296,21.775812,1.235953],[-1.858864,21.884928,1.290670],[-2.038296,21.801134,1.186273],[-1.858864,21.915768,1.230165],[-2.038296,21.820435,1.135490],[-1.858864,21.939272,1.168319],[-2.038296,21.833811,1.084477],[-1.858864,21.955561,1.106192],[-2.038296,21.818670,0.828720],[-2.038296,21.832798,0.880362],[-1.858864,21.954329,0.857605],[-1.858864,21.937122,0.794710],[-2.038296,21.798454,0.777404],[-1.858864,21.912502,0.732215],[-2.038296,21.773418,0.729592],[-1.858864,21.882013,0.673985],[-2.038296,21.742880,0.683725],[-1.858864,21.844818,0.618125],[-2.038296,21.708050,0.641615],[-1.858864,21.802402,0.566840],[-2.038296,21.668690,0.602817],[-1.858864,21.754467,0.519589],[-2.038296,21.625378,0.567936],[-1.858864,21.701717,0.477108],[-2.038296,21.578810,0.537457],[-1.858864,21.645002,0.439988],[-2.038296,21.529758,0.511720],[-1.858864,21.585264,0.408644],[-2.038296,21.479044,0.490914],[-1.858864,21.523499,0.383305],[-2.038296,21.117405,0.476424],[-2.038296,21.169682,0.464867],[-1.858864,21.146734,0.351583],[-1.858864,21.083067,0.365658],[-2.038296,21.065285,0.492973],[-1.858864,21.019594,0.385812],[-2.038296,20.919279,0.571868],[-2.038296,20.964027,0.541734],[-1.858864,20.896273,0.445197],[-1.858864,20.841776,0.481897],[-2.038296,20.877672,0.606089],[-1.858864,20.791103,0.523573],[-2.038296,20.839352,0.644472],[-1.858864,20.744432,0.570319],[-2.038296,20.805435,0.686005],[-1.858864,20.703127,0.620901],[-2.038296,20.774189,0.733675],[-1.858864,20.665073,0.678958],[-2.038296,20.748867,0.783356],[-1.858864,20.634233,0.739462],[-2.038296,20.729567,0.834138],[-1.858864,20.610729,0.801309],[-2.038296,20.716190,0.885150],[-1.858864,20.594440,0.863436],[-2.038296,20.731331,1.140909],[-2.038296,20.717203,1.089266],[-1.858864,20.595673,1.112023],[-1.858864,20.612879,1.174918],[-2.038296,20.751547,1.192224],[-1.858864,20.637499,1.237413],[-2.038296,20.776583,1.240036],[-1.858864,20.667988,1.295643],[-2.038296,20.807121,1.285903],[-1.858864,20.705183,1.351503],[-2.038296,20.841951,1.328013],[-1.858864,20.747599,1.402788],[-2.038296,20.881311,1.366811],[-1.858864,20.795534,1.450039],[-2.038296,20.924623,1.401692],[-1.858864,20.848284,1.492520],[-2.038296,20.971191,1.432171],[-1.858864,20.904999,1.529640],[-2.038296,21.020243,1.457908],[-1.858864,20.964735,1.560984],[-2.038296,21.070957,1.478714],[-1.858864,21.026503,1.586323],[-1.858864,21.275000,1.629179],[-2.217728,21.720026,0.984814],[-1.858864,21.397791,0.350645],[-1.858864,21.275000,0.340449],[-2.217728,21.438812,1.369573],[-2.217728,21.518522,1.331174],[-2.217728,21.589680,1.277424],[-2.217728,21.647484,1.211257],[-2.217728,21.275000,1.398627],[-2.217728,21.688780,1.137136],[-2.217728,21.688780,0.832491],[-2.217728,21.647484,0.758371],[-2.217728,21.589680,0.692204],[-2.217728,21.518522,0.638454],[-2.217728,21.438812,0.600055],[-2.217728,21.275000,0.571001],[-1.858864,21.152210,1.618983],[-2.217728,20.829975,0.984814],[-2.217728,21.111189,0.600055],[-2.217728,21.031479,0.638454],[-2.217728,20.960321,0.692204],[-2.217728,20.902517,0.758371],[-2.217728,20.861221,0.832491],[-2.217728,20.861221,1.137136],[-2.217728,20.902517,1.211257],[-2.217728,20.960321,1.277424],[-2.217728,21.031479,1.331174],[-2.217728,21.111189,1.369573],[-2.038296,2.682073,1.493204],[-2.038296,2.629796,1.504761],[-1.858864,2.652743,1.618045],[-1.858864,2.716409,1.603971],[-2.038296,2.734192,1.476655],[-1.858864,2.779884,1.583816],[-2.038296,2.880198,1.397760],[-2.038296,2.835450,1.427894],[-1.858864,2.903204,1.524431],[-1.858864,2.957702,1.487731],[-2.038296,2.921806,1.363540],[-1.858864,3.008374,1.446055],[-2.038296,2.960126,1.325157],[-1.858864,3.055044,1.399309],[-2.038296,2.994042,1.283623],[-1.858864,3.096350,1.348727],[-2.038296,3.025288,1.235953],[-1.858864,3.134403,1.290670],[-2.038296,3.050611,1.186273],[-1.858864,3.165243,1.230165],[-2.038296,3.069911,1.135490],[-1.858864,3.188748,1.168319],[-2.038296,3.083286,1.084477],[-1.858864,3.205038,1.106192],[-2.038296,3.068146,0.828720],[-2.038296,3.082274,0.880362],[-1.858864,3.203805,0.857605],[-1.858864,3.186599,0.794710],[-2.038296,3.047930,0.777404],[-1.858864,3.161978,0.732215],[-2.038296,3.022895,0.729592],[-1.858864,3.131489,0.673985],[-2.038296,2.992355,0.683725],[-1.858864,3.094295,0.618125],[-2.038296,2.957527,0.641615],[-1.858864,3.051878,0.566840],[-2.038296,2.918167,0.602817],[-1.858864,3.003943,0.519589],[-2.038296,2.874855,0.567936],[-1.858864,2.951194,0.477108],[-2.038296,2.828285,0.537457],[-1.858864,2.894478,0.439988],[-2.038296,2.779235,0.511720],[-1.858864,2.834741,0.408644],[-2.038296,2.728519,0.490914],[-1.858864,2.772975,0.383305],[-2.038296,2.366881,0.476424],[-2.038296,2.419158,0.464867],[-1.858864,2.396211,0.351583],[-1.858864,2.332544,0.365658],[-2.038296,2.314762,0.492973],[-1.858864,2.269070,0.385812],[-2.038296,2.168755,0.571868],[-2.038296,2.213503,0.541734],[-1.858864,2.145750,0.445197],[-1.858864,2.091252,0.481897],[-2.038296,2.127148,0.606089],[-1.858864,2.040579,0.523573],[-2.038296,2.088827,0.644472],[-1.858864,1.993909,0.570319],[-2.038296,2.054911,0.686005],[-1.858864,1.952604,0.620901],[-2.038296,2.023665,0.733675],[-1.858864,1.914550,0.678958],[-2.038296,1.998343,0.783356],[-1.858864,1.883711,0.739462],[-2.038296,1.979043,0.834138],[-1.858864,1.860205,0.801309],[-2.038296,1.965667,0.885150],[-1.858864,1.843916,0.863436],[-2.038296,1.980808,1.140909],[-2.038296,1.966680,1.089266],[-1.858864,1.845149,1.112023],[-1.858864,1.862355,1.174918],[-2.038296,2.001024,1.192224],[-1.858864,1.886976,1.237413],[-2.038296,2.026058,1.240036],[-1.858864,1.917464,1.295643],[-2.038296,2.056598,1.285903],[-1.858864,1.954658,1.351503],[-2.038296,2.091427,1.328013],[-1.858864,1.997075,1.402788],[-2.038296,2.130787,1.366811],[-1.858864,2.045011,1.450039],[-2.038296,2.174099,1.401692],[-1.858864,2.097760,1.492520],[-2.038296,2.220668,1.432171],[-1.858864,2.154475,1.529640],[-2.038296,2.269718,1.457908],[-1.858864,2.214212,1.560984],[-2.038296,2.320434,1.478714],[-1.858864,2.275978,1.586323],[-1.858864,2.524477,1.629179],[-2.217728,2.969501,0.984814],[-1.858864,2.647267,0.350645],[-1.858864,2.524477,0.340449],[-2.217728,2.688288,1.369573],[-2.217728,2.767999,1.331174],[-2.217728,2.839157,1.277424],[-2.217728,2.896960,1.211257],[-2.217728,2.524477,1.398627],[-2.217728,2.938256,1.137136],[-2.217728,2.938256,0.832491],[-2.217728,2.896960,0.758371],[-2.217728,2.839157,0.692204],[-2.217728,2.767999,0.638454],[-2.217728,2.688288,0.600055],[-2.217728,2.524477,0.571001],[-1.858864,2.401687,1.618983],[-2.217728,2.079452,0.984814],[-2.217728,2.360666,0.600055],[-2.217728,2.280955,0.638454],[-2.217728,2.209797,0.692204],[-2.217728,2.151993,0.758371],[-2.217728,2.110698,0.832491],[-2.217728,2.110698,1.137136],[-2.217728,2.151993,1.211257],[-2.217728,2.209797,1.277424],[-2.217728,2.280955,1.331174],[-2.217728,2.360666,1.369573],[-2.038296,-33.447960,1.493204],[-2.038296,-33.500237,1.504761],[-1.858864,-33.477287,1.618045],[-1.858864,-33.413620,1.603971],[-2.038296,-33.395836,1.476655],[-1.858864,-33.350143,1.583816],[-2.038296,-33.249832,1.397760],[-2.038296,-33.294579,1.427894],[-1.858864,-33.226830,1.524431],[-1.858864,-33.172325,1.487731],[-2.038296,-33.208221,1.363540],[-1.858864,-33.121658,1.446055],[-2.038296,-33.169907,1.325157],[-1.858864,-33.074989,1.399309],[-2.038296,-33.135986,1.283623],[-1.858864,-33.033684,1.348727],[-2.038296,-33.104744,1.235953],[-1.858864,-32.995628,1.290670],[-2.038296,-33.079422,1.186273],[-1.858864,-32.964790,1.230165],[-2.038296,-33.060120,1.135490],[-1.858864,-32.941284,1.168319],[-2.038296,-33.046745,1.084477],[-1.858864,-32.924995,1.106192],[-2.038296,-33.061882,0.828720],[-2.038296,-33.047760,0.880362],[-1.858864,-32.926224,0.857605],[-1.858864,-32.943428,0.794710],[-2.038296,-33.082100,0.777404],[-1.858864,-32.968056,0.732215],[-2.038296,-33.107132,0.729592],[-1.858864,-32.998543,0.673985],[-2.038296,-33.137672,0.683725],[-1.858864,-33.035736,0.618125],[-2.038296,-33.172501,0.641615],[-1.858864,-33.078156,0.566840],[-2.038296,-33.211861,0.602817],[-1.858864,-33.126091,0.519589],[-2.038296,-33.255173,0.567936],[-1.858864,-33.178833,0.477108],[-2.038296,-33.301743,0.537457],[-1.858864,-33.235550,0.439988],[-2.038296,-33.350792,0.511720],[-1.858864,-33.295288,0.408644],[-2.038296,-33.401512,0.490914],[-1.858864,-33.357056,0.383305],[-2.038296,-33.763153,0.476424],[-2.038296,-33.710869,0.464867],[-1.858864,-33.733818,0.351583],[-1.858864,-33.797485,0.365658],[-2.038296,-33.815269,0.492973],[-1.858864,-33.860962,0.385812],[-2.038296,-33.961273,0.571868],[-2.038296,-33.916527,0.541734],[-1.858864,-33.984283,0.445197],[-1.858864,-34.038780,0.481897],[-2.038296,-34.002884,0.606089],[-1.858864,-34.089447,0.523573],[-2.038296,-34.041206,0.644472],[-1.858864,-34.136124,0.570319],[-2.038296,-34.075119,0.686005],[-1.858864,-34.177429,0.620901],[-2.038296,-34.106361,0.733675],[-1.858864,-34.215477,0.678958],[-2.038296,-34.131691,0.783356],[-1.858864,-34.246323,0.739462],[-2.038296,-34.150986,0.834138],[-1.858864,-34.269821,0.801309],[-2.038296,-34.164360,0.885150],[-1.858864,-34.286118,0.863436],[-2.038296,-34.149223,1.140909],[-2.038296,-34.163353,1.089266],[-1.858864,-34.284882,1.112023],[-1.858864,-34.267677,1.174918],[-2.038296,-34.129005,1.192224],[-1.858864,-34.243057,1.237413],[-2.038296,-34.103973,1.240036],[-1.858864,-34.212563,1.295643],[-2.038296,-34.073433,1.285903],[-1.858864,-34.175369,1.351503],[-2.038296,-34.038605,1.328013],[-1.858864,-34.132957,1.402788],[-2.038296,-33.999245,1.366811],[-1.858864,-34.085022,1.450039],[-2.038296,-33.955933,1.401692],[-1.858864,-34.032272,1.492520],[-2.038296,-33.909363,1.432171],[-1.858864,-33.975555,1.529640],[-2.038296,-33.860313,1.457908],[-1.858864,-33.915817,1.560984],[-2.038296,-33.809593,1.478714],[-1.858864,-33.854050,1.586323],[-1.858864,-33.605553,1.629179],[-2.217728,-33.160530,0.984814],[-1.858864,-33.482765,0.350645],[-1.858864,-33.605553,0.340449],[-2.217728,-33.441742,1.369573],[-2.217728,-33.362030,1.331174],[-2.217728,-33.290871,1.277424],[-2.217728,-33.233070,1.211257],[-2.217728,-33.605553,1.398627],[-2.217728,-33.191772,1.137136],[-2.217728,-33.191772,0.832491],[-2.217728,-33.233070,0.758371],[-2.217728,-33.290871,0.692204],[-2.217728,-33.362030,0.638454],[-2.217728,-33.441742,0.600055],[-2.217728,-33.605553,0.571001],[-1.858864,-33.728340,1.618983],[-2.217728,-34.050575,0.984814],[-2.217728,-33.769363,0.600055],[-2.217728,-33.849075,0.638454],[-2.217728,-33.920235,0.692204],[-2.217728,-33.978035,0.758371],[-2.217728,-34.019333,0.832491],[-2.217728,-34.019333,1.137136],[-2.217728,-33.978035,1.211257],[-2.217728,-33.920235,1.277424],[-2.217728,-33.849075,1.331174],[-2.217728,-33.769363,1.369573],[-2.217728,-33.605553,0.984814],[-2.217728,-33.383041,0.984814],[-2.217728,-33.383041,0.777907],[-2.217728,-33.605553,0.777907],[-2.217728,-33.605553,1.191720],[-2.217728,-33.383041,1.191720],[-2.217728,-33.828064,0.984814],[-2.217728,-33.828064,0.777907],[-2.217728,-33.828064,1.191720],[-2.217728,21.275000,0.984814],[-2.217728,21.275000,0.777907],[-2.217728,21.052488,0.777907],[-2.217728,21.052488,0.984814],[-2.217728,21.275000,1.191720],[-2.217728,21.052488,1.191720],[-2.217728,21.497513,0.984814],[-2.217728,21.497513,0.777907],[-2.217728,21.497513,1.191720],[-2.217728,2.524477,0.984814],[-2.217728,2.524477,0.777907],[-2.217728,2.301965,0.777907],[-2.217728,2.301965,0.984814],[-2.217728,2.524477,1.191720],[-2.217728,2.301965,1.191720],[-2.217728,2.746989,0.984814],[-2.217728,2.746989,0.777907],[-2.217728,2.746989,1.191720],[-2.217728,35.822701,0.984814],[-2.217728,35.822701,0.777907],[-2.217728,35.600189,0.777907],[-2.217728,35.600189,0.984814],[-2.217728,35.822701,1.191720],[-2.217728,35.600189,1.191720],[-2.217728,36.045212,0.984814],[-2.217728,36.045212,0.777907],[-2.217728,36.045212,1.191720]];

module 820_BUTTON_A() {
  polyhedron(triangles = 820_BUTTON_A_triangles(), points = 820_BUTTON_A_points());
};

