//Author:  K1inc41d

include <shapes.scad>

CYLINDER_RADIUS = 30;
CYLINDER_HEIGHT= 60;
CHAMBER_RADIUS=7.5;

CENTER_SHAFT_RADIUS=1.7;
CENTER_SHAFT_SPRING_FOOTING=5;
CENTER_SHAFT_SPRING_FOOTING_DEPTH =35;
CENTER_SHAFT_SPRING_FOOTING_DEPTH_HEX =17;
NOTCH_RADIUS =5.5;
NOTCH_HEIGHT = 4;
EXTRACTOR_NOTCH_DEPTH = 3;
EXTRACTOR_NOTCH_RADIUS = CYLINDER_RADIUS*2/3;
UPPER_EXTRACTOR_SHAFT_RADIUS = 6;
GRIP_SHAFT_LENGTH = 60;

$fn=150;

mainCylinder();

//extractor();
//hexShaft();
//gripShaft();




module mainCylinder(){
	difference(){
		cylinder (CYLINDER_HEIGHT,CYLINDER_RADIUS,CYLINDER_RADIUS);
		chambers();
		fluting();
		stopNotches();
		extractorNotch();
	}	
}

module chambers(){
	for ( i =[0:5]) {
		rotate( i*360/6, [0,0,1])
		translate([CYLINDER_RADIUS*2/3,0,6]) cylinder (CYLINDER_HEIGHT+2, CHAMBER_RADIUS,CHAMBER_RADIUS);
		rotate( i*360/6, [0,0,1])
		translate([CYLINDER_RADIUS*2/3,0,-1]) cylinder (6, CHAMBER_RADIUS,CHAMBER_RADIUS);
	}
}

module fluting(){
	for ( i =[0:5]) {
		rotate( i*60+30, [0,0,1])
		rotate(180,[1,0,0])
		translate([34,0,CYLINDER_HEIGHT/-2+6])
		union(){
			scale ([1,1,CHAMBER_RADIUS/3]) sphere (CHAMBER_RADIUS);
			cylinder (CYLINDER_HEIGHT,CHAMBER_RADIUS,CHAMBER_RADIUS);
		}
	}
}

module stopNotches(){
	for ( i =[0:5]) {
		rotate( i*60, [0,0,1])
		translate([34,0,CYLINDER_HEIGHT-10])
		rotate(90,[1,0,0])
		cylinder(NOTCH_HEIGHT, NOTCH_RADIUS,NOTCH_RADIUS);
	}
}


module extractorNotch(){
	union(){
		translate([0,0,CYLINDER_HEIGHT-EXTRACTOR_NOTCH_DEPTH])
		union(){
			// Upper larger circle
			cylinder(EXTRACTOR_NOTCH_DEPTH+1,EXTRACTOR_NOTCH_RADIUS,EXTRACTOR_NOTCH_RADIUS);
			//The Hexagon
			translate([0,0,-CENTER_SHAFT_SPRING_FOOTING_DEPTH_HEX])
				rotate(30, [0,0,1])
				cylinder(CENTER_SHAFT_SPRING_FOOTING_DEPTH_HEX+3,UPPER_EXTRACTOR_SHAFT_RADIUS+.2,UPPER_EXTRACTOR_SHAFT_RADIUS+.2, $fn=6);
		}
		//constricted center peice.
		translate([0,0,CENTER_SHAFT_SPRING_FOOTING_DEPTH+.6]) cylinder (CYLINDER_HEIGHT+2, CENTER_SHAFT_RADIUS,CENTER_SHAFT_RADIUS);
		//larger bottom hole
		translate([0,0,-1]) cylinder (CENTER_SHAFT_SPRING_FOOTING_DEPTH+1,CENTER_SHAFT_SPRING_FOOTING+.2, CENTER_SHAFT_SPRING_FOOTING+.2); 
	}
}

module extractor(){
	union(){
		
		//star shape
		difference(){
			cylinder(EXTRACTOR_NOTCH_DEPTH,EXTRACTOR_NOTCH_RADIUS,EXTRACTOR_NOTCH_RADIUS);	
			chambers();
			//Hexagon hole in the bottom of the extractor.
			translate([0,0,-1])rotate(30, [0,0,1])	cylinder(2.5,UPPER_EXTRACTOR_SHAFT_RADIUS+.2,UPPER_EXTRACTOR_SHAFT_RADIUS+.2, $fn=6);
		}
		//interesting cap
		difference(){
			//base cap
			translate([0,0,EXTRACTOR_NOTCH_DEPTH-.5])	rotate(30, [0,0,1])cylinder(3,CYLINDER_RADIUS/3, CYLINDER_RADIUS/3, $fn=6);
			//design of cap
			for ( i =[0:5]) {
				rotate( i*60, [0,0,1])
				
				translate([CYLINDER_RADIUS/3,0,EXTRACTOR_NOTCH_DEPTH+1.5])
				rotate(30, [0,0,1])
				cylinder(3,CYLINDER_RADIUS/6, CYLINDER_RADIUS/6, $fn=6);
			}
		}
		//ball top.
		translate([0,0,EXTRACTOR_NOTCH_DEPTH+2.5])sphere(2);
	}
}

module hexShaft(){
	difference(){
		cylinder(CENTER_SHAFT_SPRING_FOOTING_DEPTH_HEX,UPPER_EXTRACTOR_SHAFT_RADIUS,UPPER_EXTRACTOR_SHAFT_RADIUS, $fn=6);
		translate([0,0,-1])cylinder (CENTER_SHAFT_SPRING_FOOTING_DEPTH_HEX+2,CENTER_SHAFT_RADIUS,CENTER_SHAFT_RADIUS);
	}
}

module gripShaft(){
	difference(){
		cylinder (GRIP_SHAFT_LENGTH,CENTER_SHAFT_SPRING_FOOTING, CENTER_SHAFT_SPRING_FOOTING); 
		translate([0,0,-1])cylinder (GRIP_SHAFT_LENGTH+2,CENTER_SHAFT_RADIUS,CENTER_SHAFT_RADIUS);
	}
}