//---------------- Dragon Shoe -----------------

$fn=100;

R = 2;		// Radius of corners
OL = 105.25-2*R;  	// Outer length
OW = 53.5-2*R;		// Outer width
OH = 14;		// Outer height
BC = 1;		// Board clearance (protrusion on underside)
WT = 1.5;		// Wall thickness

translate([2,2,0]) difference()
{
	minkowski()			// outer box
	{
 		cube([OL+(2*WT),OW+(2*WT),0.5*(OH+BC+2*WT)]);
		cylinder(r=2,h=0.5*(OH+BC+2*WT));
	}	
	translate([WT-2,WT-2,WT]) cube([105.25,53.5,15]);  // subtract inner

	// ------- cut out for bed ----------	
	translate([19+WT,60,6.5+WT]) rotate([90,0,0]) minkowski()
	{
		cube([95,13,62]);
		cylinder(2,2,2);
	}
	translate([-3,18.6,2.75+WT])cube([4,13,12]); // USB cutout
	translate([85,27,-0.5*WT]) cylinder(2*WT,10,10); // Finger hole
}
translate([10,7,WT]) cube([1,6,1.5]); 			//support bumps
translate([10,43,WT]) cube([1,6,1.5]);	
translate([66,43,WT]) cube([1,6,1.5]);			

translate([105.75,7,4.5]) cube([1,6,1]); 			//snap ledges
translate([105.75,43,4.5]) cube([1,6,1]);		

// ----------- Support legs to be removed after printing -------------
#difference()
{
	translate([WT+18,WT,WT]) cube([1,53.5,15]);
	for (Y = [0:6]) 
	{
   translate([WT+17,WT+8*Y,WT]) cube([3,6,14]);
	}
}

	
