include <write/Write.scad>

thick=3;
edge=15;
bot=4;
spacing=15;
cx=45.2;
cy=45.2;
pcY=42.5;
pcX=100;
plugX=(pcX-cx)/2;
rH=3.25;
rT=3;

wood_thick=6;

mountT=4;
mountW=15;
mountH=10;
mountR=1.5;



//mount([1,1,1]);
//footholder();
//front_panel();
//powerplug();
//back_panel();
//pcbmount();

module front_panel(){
	union(){	
		translate([2*edge+pcX,0,0])
		rotate([0,180,0])
			difference(){
				cube([2*edge+pcX,bot+edge+spacing+cy+pcY,thick]);
				translate([edge,bot+pcY+spacing,-1])
					cube([cx,cy,thick+2]);
				translate([edge+cx+plugX,bot+pcY+spacing+3/4*cy,-1]){
					cylinder(r=rH,h=thick+2,$fn=50);
					cylinder(r=2*rH,h=thick/2+1,$fn=50);
				}
				translate([edge+cx+plugX,bot+pcY+spacing+1/4*cy,-1]){
					cylinder(r=rT,h=thick+2,$fn=50);
					cylinder(r=2*rT,h=thick/2+1,$fn=50);
				}
				translate([edge+cx+plugX,bot+pcY+spacing+2/4*cy,thick-.9])
					write("Heater",t=2, center=true,h=cy/8,font="write/Letters.dxf");
				translate([edge+cx+plugX,bot+pcY+spacing,thick-.9])
					write("Sensor",t=2, center=true,h=cy/8,font="write/Letters.dxf");
			}
		translate([0,wood_thick+mountT,-0.1])
			cube([2*edge+pcX,mountT,mountT]);
		mount([edge,bot+edge+spacing+cy+pcY-mountT,-.1]);
		mount([edge+pcX-mountW,bot+edge+spacing+cy+pcY-mountT,-.1]);
		footholder([edge,0,-.1]);
		footholder([edge+pcX-mountW,0,-.1]);
		mount([mountT,edge,-.1],[0,0,90]);
		mount([mountT,bot+spacing+cy+pcY-mountW,-.1],[0,0,90]);
		mount([pcX+2*edge,edge,-.1],[0,0,90]);
		mount([pcX+2*edge,bot+spacing+cy+pcY-mountW,-.1],[0,0,90]);
	}
}

module back_panel(){
	union(){	
		translate([2*edge+pcX,0,0])
		rotate([0,180,0])
			difference(){
				cube([2*edge+pcX,bot+edge+spacing+cy+pcY,thick]);
				translate([edge,bot+pcY+spacing,-1])
					powerplug();
			}
		translate([0,wood_thick+mountT,-0.1])
			cube([2*edge+pcX,mountT,mountT]);
		mount([edge,bot+edge+spacing+cy+pcY-mountT,-0.1]);
		mount([edge+pcX-mountW,bot+edge+spacing+cy+pcY-mountT,-0.1]);
		footholder([edge,0,-0.1]);
		footholder([edge+pcX-mountW,0,-0.1]);
		mount([mountT,edge,-0.1],[0,0,90]);
		mount([mountT,bot+spacing+cy+pcY-mountW,-0.1],[0,0,90]);
		mount([pcX+2*edge,edge,-0.1],[0,0,90]);
		mount([pcX+2*edge,bot+spacing+cy+pcY-mountW,-0.1],[0,0,90]);
		translate([edge+cx/4,bot+pcY+spacing+cy/4,-1])
			pcbmount();
	}
	
}

module mount(position=[0,0,0],rotation=[0,0,0]){
	translate(position){
		rotate(rotation){
		difference(){
			union(){
				cube([mountW,mountT,mountH]);
				translate([mountW/2,0,mountH])
					rotate([-90,0,0])
						cylinder(r=mountW/2,h=mountT,$fn=50);
			}
			translate([mountW/2,-1,mountH])
				rotate([-90,0,0])
					cylinder(r=mountR,h=mountT+2,$fn=50);
		}
	}
	}
}

module footholder(position=[0,0,0]){
	translate(position){
		difference(){
			cube([mountW,mountT,2.5*mountH]);
			translate([mountW/2,-1,mountH])
				rotate([-90,0,0]){
					cylinder(r=mountR,h=mountT+2,$fn=50);
					translate([0,-mountH,0]){
						translate([0,0,3])
							cylinder(r=5,h=3,$fn=50);
						cylinder(r=2.5, h=8, $fn=50);
					}
				}
			translate([mountW/2-2.5,-1,2*mountH])
				cube([5,6,10]);
		}
	}
}

module powerplug(){
	difference(){
		cube([27.5,47.25,10]);
		translate([0,42,-1])
			rotate([0,0,45])
				cube([10,10,12]);
		translate([27.5,42,-1])
			rotate([0,0,45])
				cube([10,10,12]);
	}
	translate([-6,22.5,0])
		cylinder(r=1,h=10,$fn=50);
	translate([33.5,22.5,0])
		cylinder(r=1,h=10,$fn=50);

}

pcbW=24.5;
pcbL=21;
pcbT=2;
pcbMT=2;

module pcbmount(){
	difference(){
		cube([pcbW+2*pcbMT,pcbT+2*pcbMT,pcbL]);
		translate([pcbMT,pcbMT,-1])
			cube([pcbW,pcbT,pcbL+2]);
		translate([2*pcbMT,-1,-1])
			cube([pcbW-2*pcbMT,pcbT+2*pcbMT+2,pcbL+2]);
	}

}