// OpenMiniSpec 1a
// Arduino sketch to be paired with the processing sketch for the open source
// mini spectrometer.  Work in progress. 
// peter jansen / the tricorder project / tricorderproject.org
// snapshot of sept 1 2013 / GPL v3 / distributed with no warranty of any kind
// dream | make | share | give

// ------------------------
//     PIN Definitions
// ------------------------
// set pin numbers:
const int ledPin =  13;      // the pin number of the LED 

// AD7940 ADC Pins
const int  CS            =  6;                // Chip select
const int  SCLK          =  5;                // Serial clock
const int  SDATA         =  4;                // Serial data out 
const char  CS_PIN       =  B01000000;        // Chip select
const char  SCLK_PIN     =  B00100000;        // Chip select
const char  SDATA_PIN    =  B00010000;        // Chip select

// TSL1401CL Linear CMOS sensor pins
const int  CCLK          =  3;                // Pixel clock
const int  SI            =  2;                // Serial input
const char  CCLK_PIN     =  B00001000;        // Chip select
const char  SI_PIN       =  B00000100;        // Chip select

// ------------------------
//     Global Variables
// ------------------------
const int   NUM_CHANNELS  =  130;      // Number of pixels on the linear sensor
unsigned int spectral_channels[NUM_CHANNELS];

unsigned long spectral_average[NUM_CHANNELS];
unsigned int spectral_baseline[NUM_CHANNELS];



// ------------------------
//     Functions
// ------------------------

void delayMicrosecLong(unsigned long delay_time) {
  if (delay_time == 0) {
    return;
  }
  if (delay_time < 10000) {
    delayMicroseconds(delay_time);
  } else {
    delay(ceil((float)delay_time/1000.0f));    
  }
}

unsigned int read_ad7940() {
  unsigned int value = 0;
  unsigned int delay_time = 2;
  // Idle
  //digitalWrite(CS, HIGH);  
  PORTD = PORTD | CS_PIN;
  //digitalWrite(SCLK, HIGH);  
  PORTD = PORTD | SCLK_PIN;
  
  // Enable
  //digitalWrite(CS, LOW);    
  PORTD = PORTD ^ CS_PIN;
  
  // Read 16 bits
  for (int i=0; i<16; i++) {
//    char bit = digitalRead(SDATA);
    char bit = (PIND & SDATA_PIN) >> 4;
    //digitalWrite(SCLK, LOW);  
    delayMicroseconds(delay_time);
    PORTD = PORTD ^ SCLK_PIN;

    value = value << 1;    
    value = value + (bit & 0x01);   
    //digitalWrite(SCLK, HIGH);     
    delayMicroseconds(delay_time);    
    PORTD = PORTD ^ SCLK_PIN;

  }
  // Disable
//  digitalWrite(CS, HIGH);    
  delayMicroseconds(delay_time);
  PORTD = PORTD | CS_PIN;
  
  return value;  
}

void read_linear_cmos(unsigned long int_time) {
  unsigned int data = 0;
  unsigned long data_raw = 0;
  int oversample = 1;
  
  // Idle 
  //digitalWrite(CCLK, HIGH);  
  PORTD = PORTD | CCLK_PIN;
  //digitalWrite(SI, LOW);
  if (PORTD && SI_PIN) {
    PORTD = PORTD ^ SI_PIN;
  }
  
  // Two read events -- one to sample the data, and the next to read it out
  for (int a=0; a<2; a++) {
    // Start pulse
//    digitalWrite(CCLK, LOW);  
    PORTD = PORTD ^ CCLK_PIN;
//    digitalWrite(SI, HIGH);  
    PORTD = PORTD | SI_PIN;    

    delayMicrosecLong(int_time);
    data = read_ad7940();

    
//    digitalWrite(CCLK, HIGH);    
    PORTD = PORTD ^ CCLK_PIN;
//    digitalWrite(SI, LOW);
    PORTD = PORTD ^ SI_PIN;    
    delayMicrosecLong(int_time);    
    data = read_ad7940();

  
    // 128 spectral channels
    for (int i=0; i<NUM_CHANNELS; i++) {
//      digitalWrite(CCLK, LOW);    
      PORTD = PORTD ^ CCLK_PIN;      
      delayMicrosecLong(int_time);            
      
      data_raw = 0;
      for (int j=0; j<oversample; j++) {
        data_raw += read_ad7940();
      }
      data = data_raw / oversample;
      
      spectral_channels[i] = data;
//      digitalWrite(CCLK, HIGH);      
      PORTD = PORTD ^ CCLK_PIN;
      delayMicrosecLong(int_time);            
      
      data_raw = 0;
      for (int j=0; j<oversample; j++) {
        data_raw += read_ad7940();
      }
      data = data_raw / oversample;

    }
  }
 
}

void read_linear_cmos_average(unsigned long int_time, int num_averages) {
  
  // Clear spectral average
  for (int j=0; j<NUM_CHANNELS; j++) {
    spectral_average[j] = 0;
  }
 
  // take a number of measurements, storing each result accumulatively
  for (int i=0; i<num_averages; i++) {
    read_linear_cmos(int_time);
    for (int j=0; j<NUM_CHANNELS; j++) {
      spectral_average[j] += spectral_channels[j];
    }
  }
  
  // take the average, and store in spectral_channel
  for (int j=0; j<NUM_CHANNELS; j++) {
    spectral_channels[j] = spectral_average[j] / num_averages;
  }  
  
}

// ------------------------
//     Setup 
// ------------------------
void setup() {
  // initialize the LED pin as an output:
  pinMode(ledPin, OUTPUT);      
  
  // AD7940 ADC Pins
  pinMode(CS, OUTPUT);      
  pinMode(SCLK, OUTPUT);      
  pinMode(MISO, INPUT);      
  
  digitalWrite(CS, HIGH);  
  
      
  // TSL1401CL Linear CMOS sensor pins
  pinMode(CCLK, OUTPUT);     
  pinMode(SI, OUTPUT);   

  digitalWrite(CCLK, HIGH);  
  digitalWrite(SI, LOW);  
  
  
  // Serial console
  Serial.begin(115200); 
  
  delay(100);
}



// ------------------------
//     Main Loop
// ------------------------
void loop() {
  
  unsigned int adc_val = read_ad7940();

  // Delay between sampling
//  delay(500);
  
  // Sample data
  digitalWrite(ledPin, HIGH);    
  read_linear_cmos_average(20, 1);
  digitalWrite(ledPin, LOW);  
 
  // Display data
  char buffer[80];
  int bin_size = 1;
  for (int i=0; i<NUM_CHANNELS; i+=bin_size) {
    long average = 0;
    for (int j=0; j<bin_size; j++) {
      average += spectral_channels[i+j];
    }
    average = average / bin_size;
    
    sprintf (buffer, "%i,%i", i, average);
    Serial.println(buffer);                           
  }  
}

