// Generated with Prismap, written by Jim DeVona
// https://github.com/anoved/prismap

/* [Data] */

// Should be less than or equal to the minimum data value.
lower_bound = 0;

// Should be greater than or equal to the maximum data value.
upper_bound = 1010;

// Alabama
data0 = 91.183;

// Arizona
data1 = 56.071;

// Arkansas
data2 = 54.833;

// California
data3 = 227.581;

// Colorado
data4 = 48.314;

// Connecticut
data5 = 644.756;

// Delaware
data6 = 360.722;

// Florida
data7 = 285.932;

// Georgia
data8 = 163.024;

// Idaho
data9 = 18.758;

// Illinois
data10 = 221.545;

// Indiana
data11 = 178.04;

// Iowa
data12 = 54.137;

// Kansas
data13 = 34.677;

// Kentucky
data14 = 107.386;

// Louisiana
data15 = 87.45;

// Maine
data16 = 37.541;

// Maryland
data17 = 465.358;

// Massachusetts
data18 = 620.36;

// Michigan
data19 = 102.192;

// Minnesota
data20 = 61.008;

// Mississippi
data21 = 61.27;

// Missouri
data22 = 85.919;

// Montana
data23 = 6.729;

// Nebraska
data24 = 23.61;

// Nevada
data25 = 24.426;

// New Hampshire
data26 = 140.8;

// New Jersey
data27 = 1008.094;

// New Mexico
data28 = 16.936;

// New York
data29 = 355.197;

// North Carolina
data30 = 177.179;

// North Dakota
data31 = 9.513;

// Ohio
data32 = 257.368;

// Oklahoma
data33 = 53.669;

// Oregon
data34 = 38.941;

// Pennsylvania
data35 = 275.807;

// Rhode Island
data36 = 681.251;

// South Carolina
data37 = 144.451;

// South Dakota
data38 = 10.558;

// Tennessee
data39 = 150.584;

// Texas
data40 = 93.624;

// Utah
data41 = 32.555;

// Vermont
data42 = 65.085;

// Virginia
data43 = 187.053;

// Washington
data44 = 94.314;

// West Virginia
data45 = 76.476;

// Wisconsin
data46 = 86.827;

// Wyoming
data47 = 5.762;

// preview[view:south, tilt:top diagonal]

/* [Model Options] */

// Maximum x size in output units (typically mm).
x_size_limit = 130;

// Maximum y size in output units (typically mm).
y_size_limit = 130;

// Maximum z size in output units (typically mm).
z_size_limit = 30;

// Must be less than z size limit. Set to 0 to disable floor. (Floor thickness is automatically set to wall thickness if floor is disabled and walls are enabled.)
floor_thickness = 1; // [0:10]

// Must be less than x and y size limits. Set to 0 to disable walls.
wall_thickness = 0; // [0:10]

// Scaling factor applied to all features. This is a fudge factor to facilitate STL export; it forces shared edges to overlap rather than coincide.
inflation = 1.0001;

/* [Hidden] */

x_extent = 4.35517e+06;

y_extent = 2.84167e+06;

z_scale = (z_size_limit - ((floor_thickness == 0 && wall_thickness > 0) ? wall_thickness : floor_thickness)) / (upper_bound - lower_bound);

x_scale = (x_size_limit - wall_thickness) / x_extent;

y_scale = (y_size_limit - wall_thickness) / y_extent;

xy_scale = min(x_scale, y_scale);

function extrusionheight(value) = ((floor_thickness == 0 && wall_thickness > 0) ? wall_thickness : floor_thickness) + (z_scale * (value - lower_bound));

Prismap();

module Floor() {
	translate([-2.23179e+06, -1.56919e+06, 0])
		cube([x_extent, y_extent, floor_thickness > 0 ? floor_thickness : wall_thickness]);
}

module Walls() {
	translate([((x_extent / -2) * xy_scale) - wall_thickness, (y_extent / -2) * xy_scale, 0])
		cube([wall_thickness, (y_extent * xy_scale) + wall_thickness, z_size_limit]);
	translate([(x_extent / -2) * xy_scale, (y_extent / 2) * xy_scale, 0])
		cube([x_extent * xy_scale, wall_thickness, z_size_limit]);
}

module feature0(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[994879.234745259, -926553.0404018479],
			[1000909.4572492209, -939000.8202372785],
			[815888.8289469682, -960026.6849327798],
			[764552.621259031, -971301.0100382419],
			[763883.6542539366, -979846.5202133493],
			[787186.4522890381, -1004711.066184276],
			[784406.8714713082, -1026952.8321024082],
			[779181.8066457523, -1042705.2810674151],
			[696721.2299294063, -1037692.3712700245],
			[679768.9661708601, -869198.1414015491],
			[680552.4847135923, -691280.4007802232],
			[683694.9877222197, -546724.417796469],
			[675682.2819587567, -525851.8476755136],
			[783806.2268445932, -515821.5563475755],
			[894259.1266923466, -505430.32166638796],
			[932623.2324774043, -639612.3105094623],
			[966367.686501287, -746595.5775004284],
			[983244.5546032385, -779490.1163938161],
			[993415.500729052, -798228.1473029329],
			[981052.2740700564, -819360.8871077365],
			[980299.8189741058, -854970.3000449757],
			[987645.2918322897, -875124.6093836062],
			[987756.3753675435, -894849.2426752229],
			[987448.3736520004, -913206.3756713581]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23]
		]);
	}
}

module feature1(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-1091089.0808135828, -254627.72523148544],
			[-1180681.3241351217, -875819.9663039572],
			[-1358523.470686276, -848966.1011059335],
			[-1547701.0171316138, -735637.45977742],
			[-1669793.6155740381, -656058.288961442],
			[-1657192.7986166026, -636539.8865213251],
			[-1645814.137313874, -639421.0503915022],
			[-1631726.6003918939, -619679.4181875229],
			[-1643960.1215130424, -601566.0909624422],
			[-1643649.161260429, -584662.234422955],
			[-1644145.085849206, -564595.998196072],
			[-1622141.506604648, -543156.0062935966],
			[-1605053.8542222688, -494839.3646840162],
			[-1574538.3496871283, -477826.92976781307],
			[-1586420.086488705, -453663.91585924936],
			[-1593250.8665852826, -430926.57413390896],
			[-1596327.3567425949, -410449.3809437646],
			[-1597936.5039785774, -394767.0247135646],
			[-1597617.4786458232, -384700.3540050708],
			[-1588012.343911576, -364449.65233657],
			[-1587738.260008004, -342320.087810507],
			[-1585096.1776791392, -320920.5912473578],
			[-1580186.1724379507, -297535.15359118534],
			[-1584544.0529157573, -281092.94037836284],
			[-1576063.8142209535, -268886.41754159017],
			[-1558532.6160376933, -272516.47950764996],
			[-1544149.858345967, -283494.71159477934],
			[-1533636.4135154802, -290121.0817961303],
			[-1524777.6390231506, -274654.8472523403],
			[-1520479.1239649765, -271746.7011220052],
			[-1503470.3881303542, -184122.2867516868],
			[-1370209.5349102493, -207939.46131755787],
			[-1211340.5341847816, -235443.6634527211]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32]
		]);
	}
}

module feature2(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[538967.2517904781, -422637.9726209092],
			[538708.4933229523, -431895.7321493695],
			[531139.503783034, -448075.1963367616],
			[516934.7307079073, -459862.3836204208],
			[514852.96518966206, -478420.19602421165],
			[502257.963805961, -493834.16926199355],
			[505382.10336680856, -525989.4504445543],
			[496198.5673757557, -536928.9296947035],
			[495112.36236270017, -545821.0644039483],
			[480232.2772335397, -555039.9081321692],
			[480894.1517497315, -571112.8930785247],
			[471073.91201103764, -601463.3915187186],
			[461418.81956210587, -608326.6907248562],
			[446897.54643494665, -624269.5182670499],
			[438938.6385598682, -647641.0698623105],
			[421880.52072337305, -687298.4653468701],
			[421261.94376331277, -713661.685233127],
			[432992.4071994362, -742191.5875452539],
			[429895.84260766185, -764219.1512647389],
			[354782.56063344015, -764112.9936051294],
			[257988.5289748131, -771491.7722302212],
			[172264.7758944994, -773598.9366561164],
			[176000.74366718408, -710529.2846079477],
			[155623.99908281135, -710541.2449340059],
			[138544.2380175601, -712322.4345202008],
			[133808.54172062036, -705125.5226634287],
			[134669.17689994012, -608069.2159161245],
			[134648.73378857144, -500152.7067426182],
			[115860.30660887036, -383127.01320842234],
			[218618.6834821674, -382475.71833395533],
			[311986.52772924857, -379542.78795209463],
			[401107.613647784, -375460.55010005407],
			[497662.2910025434, -376631.0715092726],
			[505577.4100029763, -389882.9765239475],
			[496815.00877554365, -402400.46902544785],
			[488069.7959461649, -414962.2720229529],
			[483551.58252507925, -426306.4874329921]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36]
		]);
	}
}

module feature3(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-1586420.086488705, -453663.91585924936],
			[-1574538.3496871283, -477826.92976781307],
			[-1605053.8542222688, -494839.3646840162],
			[-1622141.506604648, -543156.0062935966],
			[-1644145.085849206, -564595.998196072],
			[-1643649.161260429, -584662.234422955],
			[-1643960.1215130424, -601566.0909624422],
			[-1631726.6003918939, -619679.4181875229],
			[-1645814.137313874, -639421.0503915022],
			[-1657192.7986166026, -636539.8865213251],
			[-1770444.314836898, -624342.7596441564],
			[-1871312.7214209395, -609930.7990545334],
			[-1872790.4243126304, -551343.4554196384],
			[-1913446.37755025, -475870.14367773593],
			[-1950075.9271280044, -453076.5705272466],
			[-1951591.1462835283, -419878.01442569715],
			[-1997782.4398570564, -402296.5917437719],
			[-2020423.4331835199, -365363.32073168166],
			[-2095712.194129317, -333759.3456471535],
			[-2112322.546968733, -310600.689977888],
			[-2106160.0146354353, -249186.70845984187],
			[-2155438.5330482023, -119223.42137947289],
			[-2178889.6396066416, 48568.47171269685],
			[-2168667.864654132, 72360.71993601727],
			[-2193007.8814591174, 118021.9669343161],
			[-2226103.0815637037, 225637.8533500187],
			[-2209531.5453095483, 315342.92406730406],
			[-2231786.8080885476, 386113.78959939064],
			[-2187044.372023283, 468454.820691744],
			[-2160598.715612729, 559957.9185401155],
			[-1846244.3710111876, 466346.19228246465],
			[-1933151.8307977319, 145070.81386780003],
			[-1820536.3338605878, -39020.57404498663],
			[-1707961.7006343629, -216609.99658521375],
			[-1597617.4786458232, -384700.3540050708],
			[-1597936.5039785774, -394767.0247135646],
			[-1596327.3567425949, -410449.3809437646],
			[-1593250.8665852826, -430926.57413390896]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37]
		]);
	}
}

module feature4(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-485247.6906973258, 16239.616207592284],
			[-495798.1189189313, -154511.63888033616],
			[-506701.1583613955, -317070.0125504679],
			[-587215.558296978, -310931.4276556874],
			[-687319.1048231103, -302428.24609595764],
			[-829252.644435238, -288134.2413338632],
			[-960917.084361836, -272289.4373635887],
			[-1091089.0808135888, -254627.7252314897],
			[-1028190.3170236995, 185191.36472662466],
			[-949718.8585374419, 174350.69559794388],
			[-871221.7333972298, 164325.75101443724],
			[-713871.8867724232, 146985.06292452893],
			[-635041.9958765516, 139612.1014263619],
			[-477673.259377907, 127392.49096002155],
			[-485009.44731726515, 19815.000024038145]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14]
		]);
	}
}

module feature5(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1801977.1181090898, 365904.07653143397],
			[1750301.1792497507, 322065.79942067433],
			[1748766.1011311642, 325325.1175813831],
			[1742708.7795107148, 337802.4070306091],
			[1756702.640186202, 352473.1501506397],
			[1748407.8173732767, 360136.8768627868],
			[1731843.5856977853, 443547.1563537867],
			[1790026.7662273052, 456382.8736752255],
			[1860672.5996021347, 472638.19975243177],
			[1877242.5497054157, 414226.1777188439],
			[1876905.6557511853, 397262.1536952702],
			[1844829.1403132651, 382838.7101215612]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11]
		]);
	}
}

module feature6(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1671636.390455777, 75439.80560047744],
			[1695838.234517456, 60796.26608491986],
			[1706153.649548901, 25216.112551389524],
			[1652804.7146579588, 12969.423137934627],
			[1615767.5053579286, 149626.31517201543],
			[1619863.2728060025, 159528.24905118282],
			[1625813.830533006, 166003.7597591199],
			[1643996.8489985054, 164264.08602733022],
			[1634908.984921294, 150300.94205613548],
			[1641762.5673106345, 129933.0600998832]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9]
		]);
	}
}

module feature7(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1526984.1446128855, -1320983.2976877838],
			[1537006.0505339494, -1395073.303735903],
			[1540325.225933957, -1438249.284512158],
			[1527912.1521461143, -1509091.1366552485],
			[1501310.2122782408, -1527850.409592486],
			[1451341.2914417593, -1522600.3896744929],
			[1428185.9119878365, -1477149.3022105864],
			[1387513.7453124363, -1457852.8282674046],
			[1322119.3459893283, -1371605.6755081476],
			[1265377.5217052777, -1294375.093480632],
			[1244945.7240613285, -1253553.820711269],
			[1253494.2623221832, -1177933.084314711],
			[1218647.5012536012, -1121443.4293297648],
			[1133920.671777899, -1039699.6104962776],
			[1095908.7611360624, -1027619.4831678796],
			[1009463.7392990885, -1089221.8873962073],
			[992297.4864433983, -1085692.3905568959],
			[941737.0876069934, -1039484.2410097005],
			[881332.8765540179, -1018489.3740916337],
			[779181.8066457564, -1042705.2810674066],
			[784406.8714713149, -1026952.8321023912],
			[787186.4522890404, -1004711.066184276],
			[763883.6542539357, -979846.5202133394],
			[764552.6212590379, -971301.0100382277],
			[815888.8289469727, -960026.6849327798],
			[1000909.4572492298, -939000.8202372658],
			[1018317.9792176104, -966954.134906188],
			[1110324.471561823, -960248.7279778004],
			[1259952.509104884, -955544.2381162569],
			[1269613.0135434577, -973648.7694468116],
			[1279839.548200683, -962040.8863136237],
			[1274179.1511802352, -923916.1966827188],
			[1284506.7253216084, -918508.091705354],
			[1303665.9582189396, -923747.5868722354],
			[1323078.7694224874, -922723.5285205424],
			[1351435.2223319742, -996104.7629446569],
			[1397477.0448834228, -1084637.8100502396],
			[1451692.9453277648, -1155022.732935921],
			[1460315.3303368748, -1202125.1702474644]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38]
		]);
	}
}

module feature8(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1355654.6320927052, -770917.2086171849],
			[1324365.665348913, -842699.0473226758],
			[1323078.7694224874, -922723.5285205424],
			[1303665.9582189396, -923747.5868722354],
			[1284506.7253216084, -918508.091705354],
			[1274179.1511802352, -923916.1966827188],
			[1279839.548200683, -962040.8863136237],
			[1269613.0135434577, -973648.7694468116],
			[1259952.5091048782, -955544.2381162583],
			[1110324.471561823, -960248.7279778004],
			[1018317.9792176104, -966954.134906188],
			[1000909.4572492252, -939000.8202372672],
			[994879.2347452608, -926553.0404018337],
			[987448.3736520001, -913206.3756713553],
			[987756.3753675413, -894849.242675213],
			[987645.2918322922, -875124.6093836076],
			[980299.8189741095, -854970.3000449771],
			[981052.2740700586, -819360.8871077352],
			[993415.500729051, -798228.1473029244],
			[983244.554603244, -779490.1163938047],
			[966367.6865012888, -746595.5775004241],
			[932623.2324774078, -639612.3105094538],
			[894259.1266923517, -505430.32166638516],
			[960518.3875837249, -498557.419904906],
			[1006096.5524980766, -491682.9785930162],
			[1112750.283596689, -478054.06247368746],
			[1104674.652251114, -488513.4348832856],
			[1093858.3629435343, -511262.4279493141],
			[1119643.66743182, -526228.9935797106],
			[1135545.1581854483, -530757.9138526734],
			[1156690.2282615253, -563143.6881474962],
			[1169870.9058912634, -581073.3141716325],
			[1203996.2387932152, -602531.0723067862],
			[1212060.5836854384, -615252.6339733005],
			[1235471.7464222696, -629927.8327547922],
			[1249722.0480951353, -654429.8646986184],
			[1281217.2481120413, -672065.1220938545],
			[1291522.2554825558, -696082.9072459885],
			[1298694.733835673, -707345.5949860413],
			[1296970.011015249, -715889.2528372221],
			[1315349.3144355768, -725201.9623834537],
			[1327415.6570315338, -744269.7677070812],
			[1330715.9616295886, -765136.0930147133],
			[1339506.4220100252, -767845.4456397025]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43]
		]);
	}
}

module feature9(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-1120310.6884392786, 591458.6611245511],
			[-1165863.5483199926, 318988.91169116844],
			[-1394418.7148459035, 360075.74527118786],
			[-1621903.1255158645, 410487.3710577384],
			[-1575094.9010714847, 604560.80583509],
			[-1561465.179377909, 633790.5919906385],
			[-1564085.1537602695, 649266.0068454738],
			[-1576002.1324744795, 659814.4574582602],
			[-1571748.0517159724, 677055.9864771134],
			[-1555707.5845294876, 699184.2783390081],
			[-1535076.2978706562, 716934.4764041466],
			[-1516640.845330118, 749479.1069153466],
			[-1500538.1033013698, 775156.887198943],
			[-1490058.2504367766, 787595.947312395],
			[-1490110.340707701, 804925.7583217768],
			[-1500058.018471078, 816451.4326764985],
			[-1511995.5116730893, 841212.7692006006],
			[-1506889.936093899, 860314.0498363074],
			[-1509493.7498207912, 878324.2518527951],
			[-1476025.9350215155, 1029512.5204784604],
			[-1443820.2714733449, 1167741.0016725245],
			[-1377422.3214171913, 1152603.2369337126],
			[-1397416.57971863, 1037444.0945491602],
			[-1385616.127880056, 1004575.374183995],
			[-1389952.7177669264, 985048.0779259516],
			[-1380839.4253751186, 964862.5992210284],
			[-1366980.6772184416, 951084.2003821171],
			[-1358940.8881994663, 931733.5162420751],
			[-1346515.497324866, 893981.74992426],
			[-1331630.098397884, 874410.2015541081],
			[-1310562.9490758812, 868997.5829249672],
			[-1323258.1621766614, 846436.9200624829],
			[-1336071.6125066383, 819225.1755692755],
			[-1335821.5805803523, 789990.4891107976],
			[-1345605.2327963135, 784680.5814791381],
			[-1350641.4121473222, 756651.758413706],
			[-1340011.621590006, 743239.6290981236],
			[-1323157.3135177158, 753316.8679490547],
			[-1312721.6799455448, 767173.4640613879],
			[-1304577.9295877346, 762423.1079241931],
			[-1298953.1497042805, 745712.5163109313],
			[-1297500.5986068288, 709635.0813065477],
			[-1287307.0598095835, 693499.0036835836],
			[-1288231.482295632, 664080.924159269],
			[-1285332.9920583249, 655253.6365529123],
			[-1270953.1870282423, 649733.7778049146],
			[-1264990.9595500429, 632136.4358706017],
			[-1257319.5004791305, 601305.991172201],
			[-1240904.036368503, 613914.2355050063],
			[-1217542.9804777028, 605496.1522224589],
			[-1213641.2345959987, 615902.5501813198],
			[-1173319.195106648, 601662.4677786019],
			[-1155832.33348795, 602261.3299398803],
			[-1141630.010797001, 622195.6613041679],
			[-1134177.066890056, 617823.7932185291],
			[-1129615.651223181, 601245.1440474986],
			[-1122595.3826447895, 593866.846008606]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56]
		]);
	}
}

module feature10(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[413511.78566899523, 290431.9024871164],
			[492154.55016212596, 295515.33616536355],
			[572504.0998479411, 301389.6148368294],
			[631820.3507039503, 305493.2748571566],
			[631794.0071026343, 305784.8460042672],
			[656180.9180489018, 307855.25013719813],
			[690822.8523236582, 310896.5029722132],
			[689317.0283288361, 290311.5759850558],
			[687782.8454324792, 269786.84806947585],
			[686236.340125951, 249199.9031204403],
			[684668.7874384414, 228619.1118636948],
			[672981.9740789183, 227497.07132793538],
			[661377.7231614958, 226402.24226171995],
			[661879.4143854197, 220603.80596126226],
			[661507.3420564048, 220569.02193667798],
			[673394.2499366653, 92476.8263938704],
			[685270.1623169619, -35529.91062882849],
			[678930.0877380832, -67151.29249065055],
			[686331.883002108, -74667.18514216742],
			[692392.1759241422, -93158.42430198804],
			[693135.5686423249, -108075.2086211546],
			[686948.0279255004, -115435.45519025235],
			[682720.2353635334, -134288.9834754378],
			[667921.6778218364, -159932.00500330195],
			[659032.8477066847, -190677.41322628516],
			[658333.6223185469, -213260.84400117528],
			[659625.1127003783, -221461.7175782331],
			[651591.6227624593, -237665.741317922],
			[659604.8917742663, -247464.29331270827],
			[645715.3622797328, -256799.20466762656],
			[627663.4060331852, -267631.9563054743],
			[632892.9191507256, -291534.7757329311],
			[622686.3991259176, -301571.3676576713],
			[601703.936740799, -292951.9925376463],
			[579022.8593723109, -288707.9137894184],
			[574181.8829499031, -299854.02178556175],
			[578682.3009313523, -316355.9502774597],
			[562565.0769553587, -300308.884074957],
			[553752.6310537223, -303842.77277905034],
			[541104.8427916721, -277436.7109915498],
			[542996.5994303247, -260577.2932603763],
			[534892.1608019196, -234248.44176292056],
			[526289.0720355026, -231556.990177115],
			[502967.6243244974, -208722.09392549878],
			[493590.36740799295, -208930.59430811863],
			[476253.7497299564, -194336.67482363307],
			[463536.51610376034, -178421.6719945007],
			[467622.98403611605, -158625.7615728667],
			[474189.67310433876, -142024.65892358613],
			[477507.4373541693, -121270.56272017681],
			[460852.0101115688, -104430.72781262669],
			[445900.1585016738, -112524.57892340842],
			[436312.86355268187, -108448.98149037216],
			[433930.0364828339, -89992.52188247326],
			[425917.53514115524, -69273.89227432977],
			[418169.418959446, -64657.999056493434],
			[398719.7959772908, -50792.31292339419],
			[382297.9327416513, -32780.431075879686],
			[367795.36920843733, -10637.770143441136],
			[358971.30359898816, 22160.02985478376],
			[364570.1894317517, 50090.73805282339],
			[365149.85197896266, 70416.34828855135],
			[384626.79790992866, 87962.54743598805],
			[389004.1303522201, 105087.84366772714],
			[398277.13867112534, 124841.21710460518],
			[393991.62203796266, 141850.36909845175],
			[383740.66751082824, 149943.13907858485],
			[389728.12996766384, 169395.6112914207],
			[416332.5063777782, 176375.8320087768],
			[433845.55836635473, 183838.22198440164],
			[438571.00073629466, 192135.31308760404],
			[451443.58352097025, 218148.9876078473],
			[453686.6578830984, 248212.50924458707],
			[445082.6231365282, 257263.29398325237],
			[432363.00137838087, 265422.12182266085],
			[427950.2618824227, 277165.7204040049],
			[418502.19356392114, 282248.95209418365]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76]
		]);
	}
}

module feature11(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[873272.079949264, 240130.66923982697],
			[885361.1665418333, 140365.71528962915],
			[897991.2528166381, 33049.25573289539],
			[906962.5255991552, -43390.9704209101],
			[902941.6497197205, -49155.17229298601],
			[912312.2115079057, -70846.07166064886],
			[909802.7185167253, -79442.23484467284],
			[896168.3909429624, -81289.89663795357],
			[884665.0506371214, -92557.45631488721],
			[864970.3777987148, -90865.38138583697],
			[865680.5739094308, -112250.2685020273],
			[855137.681275264, -121636.34502160994],
			[846541.8420747484, -141835.72796101635],
			[835366.7849642189, -146585.0982000953],
			[820947.6674384268, -181456.3932291075],
			[803256.588251719, -173806.25737626533],
			[796635.0051654564, -160811.8664736941],
			[784661.2054996049, -184346.40762722222],
			[776831.6962276234, -197564.32648858713],
			[757762.3342297402, -186409.08534059624],
			[739850.2361027951, -198826.2791568571],
			[734662.3669071007, -210194.22199841778],
			[707637.6333375041, -195799.4500304711],
			[691087.7527490677, -209552.19042625627],
			[669039.3428113234, -202882.46682347992],
			[669299.244645519, -215182.47758661007],
			[658333.6223185469, -213260.84400117528],
			[659032.8477066847, -190677.41322628516],
			[667921.6778218364, -159932.00500330195],
			[682720.2353635334, -134288.9834754378],
			[686948.0279255004, -115435.45519025235],
			[693135.5686423249, -108075.2086211546],
			[692392.1759241422, -93158.42430198804],
			[686331.883002108, -74667.18514216742],
			[678930.0877380832, -67151.29249065055],
			[685270.1623169619, -35529.91062882849],
			[673394.2499366653, 92476.8263938704],
			[661507.3420564048, 220569.02193667798],
			[661337.5321668849, 226398.48373471692],
			[684668.7874384414, 228619.1118636948],
			[708239.6049171881, 230941.46023512672],
			[715519.1681108043, 231674.73337878904],
			[715572.650227344, 231146.5183653282],
			[799233.6018856107, 239586.69567254424],
			[872161.9814652051, 248757.99055427953]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44]
		]);
	}
}

module feature12(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[453686.6578830984, 248212.50924458707],
			[451443.58352097025, 218148.9876078473],
			[438571.00073629466, 192135.31308760404],
			[433845.55836635473, 183838.22198440164],
			[416332.5063777782, 176375.8320087768],
			[389728.12996766384, 169395.6112914207],
			[383740.66751082824, 149943.13907858485],
			[393991.62203796266, 141850.36909845175],
			[398277.13867112534, 124841.21710460518],
			[389004.1303522201, 105087.84366772714],
			[384626.79790992866, 87962.54743598805],
			[365149.85197896266, 70416.34828855135],
			[364570.1894317517, 50090.73805282339],
			[353190.93052171665, 58822.9210314726],
			[337143.20451160835, 76055.79848882895],
			[250370.6450548837, 70118.63740026859],
			[158920.73280217705, 66706.35154895953],
			[87624.69741636983, 65316.10751371201],
			[16188.733858209309, 64860.87111599556],
			[10939.462078683951, 84947.43508116789],
			[13127.184335136462, 104815.71185124818],
			[11381.79537145815, 123969.21007031061],
			[3265.52767627898, 155991.01379727645],
			[-1967.064666174022, 169271.35817237743],
			[-7605.043909810626, 172859.4068855716],
			[-8156.643895314396, 198544.48563315737],
			[-13039.331349770877, 216947.67571526664],
			[-27094.953382458552, 237912.5333025548],
			[-26895.463576750735, 247081.57476092863],
			[-31735.72593116851, 265441.7565057753],
			[-35159.70563242337, 276508.2794104223],
			[-34987.25071248242, 286676.6774522868],
			[-47390.11676332653, 299094.783894404],
			[-41091.41090314361, 317278.9753849967],
			[-37015.38987256081, 335067.29305877554],
			[-35130.14122386327, 347110.7987415116],
			[-44784.677269653796, 361921.1474485256],
			[-44529.20728638106, 389021.6732550852],
			[-34396.06263271844, 389024.0844158577],
			[48637.27926973938, 388931.6684984633],
			[151855.00785506118, 391899.4988295915],
			[262774.61657746177, 395936.4763052633],
			[362430.82342733763, 398390.0578246817],
			[363833.58920111996, 392401.22083779756],
			[374672.787038693, 375317.8094887604],
			[368310.1102783226, 366556.6456401497],
			[369791.5630778875, 343262.46965486644],
			[373439.95851177775, 333511.47753753315],
			[379340.3915938945, 316168.81666251144],
			[405025.756961865, 306950.755025025],
			[413511.78566899523, 290431.9024871164],
			[418502.19356392114, 282248.95209418365],
			[427950.2618824227, 277165.7204040049],
			[432363.00137838087, 265422.12182266085],
			[445082.6231365282, 257263.29398325237]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54]
		]);
	}
}

module feature13(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[113444.18772588499, -94627.98380009577],
			[114395.28438896766, -213519.05877861028],
			[115579.43841745224, -332152.49794848176],
			[41950.279391049335, -333030.04177828506],
			[-109091.85883023498, -332540.5164674427],
			[-260145.75581700855, -329120.43482082733],
			[-344029.4359079503, -325915.22428510117],
			[-427826.44315506483, -321790.2013211822],
			[-506701.1583613955, -317070.0125504679],
			[-495798.1189189313, -154511.63888033616],
			[-485247.6906973258, 16239.616207592284],
			[-485078.01063809183, 16228.311672565109],
			[-345021.2116282908, 8250.19475649229],
			[-240751.79419176193, 4062.354844575132],
			[-56165.26034198083, 366.8043672737358],
			[54346.4956789168, 353.0340580412715],
			[73563.64975951314, -14285.726361474399],
			[84031.61357358439, -13937.666539341884],
			[86517.68194084588, -30009.709266770093],
			[75385.61971421547, -50696.99241842939],
			[81661.27161703286, -61204.564309574336],
			[91931.16413535661, -84409.92484286148]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21]
		]);
	}
}

module feature14(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1163471.84963894, -183616.66458973283],
			[1135479.589265268, -221356.386611238],
			[1111547.9157839534, -238050.26689973983],
			[1110839.015469508, -247235.61916825027],
			[1103699.587260114, -260095.09277629643],
			[1082823.6058687493, -276461.5090794373],
			[1076892.2698271326, -288222.5448846492],
			[1060664.1130449318, -297442.2453768776],
			[1037372.9694319494, -307001.4678810571],
			[981201.7129538349, -318123.56443680834],
			[906795.0839406145, -322549.5798489695],
			[882819.6699691904, -326723.5898778924],
			[834362.9242263001, -329048.27808441705],
			[785162.2377432985, -333382.00370235683],
			[739878.8936814804, -337317.3792375175],
			[687617.8474145312, -345324.43198719923],
			[684451.9312221635, -340536.18316268193],
			[667800.2238777914, -342245.89034621033],
			[669586.4821546202, -359597.79436739226],
			[549109.9455217876, -368177.6850551523],
			[567162.6767323216, -355144.4143435036],
			[579826.4630833425, -344950.6317849418],
			[576910.0441299934, -327679.46873647283],
			[578682.3009313523, -316355.9502774597],
			[574181.8829499031, -299854.02178556175],
			[579022.8593723109, -288707.9137894184],
			[601703.936740799, -292951.9925376463],
			[622686.3991259176, -301571.3676576713],
			[632892.9191507256, -291534.7757329311],
			[627663.4060331852, -267631.9563054743],
			[645715.3622797328, -256799.20466762656],
			[659604.8917742663, -247464.29331270827],
			[651591.6227624593, -237665.741317922],
			[659625.1127003783, -221461.7175782331],
			[658333.6223185469, -213260.84400117528],
			[669299.244645519, -215182.47758661007],
			[669039.3428113234, -202882.46682347992],
			[691087.7527490677, -209552.19042625627],
			[707637.6333375041, -195799.4500304711],
			[734662.3669071007, -210194.22199841778],
			[739850.2361027951, -198826.2791568571],
			[757762.3342297402, -186409.08534059624],
			[776831.6962276234, -197564.32648858713],
			[784661.2054996049, -184346.40762722222],
			[796635.0051654564, -160811.8664736941],
			[803256.588251719, -173806.25737626533],
			[820947.6674384268, -181456.3932291075],
			[835366.7849642189, -146585.0982000953],
			[846541.8420747484, -141835.72796101635],
			[855137.681275264, -121636.34502160994],
			[865680.5739094308, -112250.2685020273],
			[864970.3777987148, -90865.38138583697],
			[884665.0506371214, -92557.45631488721],
			[896168.3909429624, -81289.89663795357],
			[909802.7185167253, -79442.23484467284],
			[912312.2115079057, -70846.07166064886],
			[902941.6497197205, -49155.17229298601],
			[906962.5255991552, -43390.9704209101],
			[934924.8535575399, -42488.010210872475],
			[950562.6212829951, -51262.31069876813],
			[975319.5372759297, -73318.4457231732],
			[993571.6748258022, -78825.27960937073],
			[1007278.5942900449, -86035.87670856083],
			[1026184.6445391858, -80290.3570697533],
			[1041332.2551793009, -84633.23840989229],
			[1057862.0944338103, -76111.09959497458],
			[1072953.421280729, -72032.02197807355],
			[1081686.7206313803, -86487.75603847986],
			[1098374.6593288227, -94773.38504934894],
			[1101478.6847047776, -105000.03451642198],
			[1103993.3576797477, -127846.05530663132],
			[1116286.7020715324, -143530.70447190639],
			[1122737.2975337903, -159605.21998009871],
			[1136878.8449434466, -172019.39404659052],
			[1147133.5160951277, -184058.8445860649]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74]
		]);
	}
}

module feature15(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[632401.1159484214, -1164401.2925995928],
			[615703.9051064942, -1180225.0871192683],
			[579998.9512569117, -1166369.7745076225],
			[546403.1369947301, -1189675.6936751201],
			[478460.01780469774, -1190323.355250412],
			[405933.8176803725, -1135456.7505067647],
			[325543.90801529237, -1152774.9090025588],
			[257154.40618921936, -1129464.8324118606],
			[199677.86364759252, -1138797.28572437],
			[192903.28857212368, -1126964.4001306165],
			[201926.74627252886, -1110499.7813266914],
			[215399.42484724612, -1095495.7090373535],
			[215074.7511022516, -1073381.3665830197],
			[208168.09355798055, -1066163.5752693352],
			[215515.65663552363, -1039509.8290050761],
			[221067.4495027293, -1027334.9989062123],
			[228768.05884029463, -986571.4411915202],
			[220311.06686211593, -971658.0175580942],
			[209131.5590384227, -946712.6110281856],
			[200779.4157141966, -921214.2575705897],
			[195349.8310747403, -904207.507336276],
			[180276.17363058976, -892052.1940905141],
			[172264.77589450168, -773598.9366561164],
			[257988.52897481289, -771491.7722302155],
			[354782.560633438, -764112.9936051323],
			[429895.8426076617, -764219.1512647361],
			[436572.8889319745, -770208.2728815689],
			[429347.22462619626, -786639.7197571993],
			[443484.3600050843, -808739.7684568486],
			[440549.09119334945, -822650.8434757581],
			[453140.01188524865, -841059.0386819168],
			[441340.95551939565, -853050.20974353],
			[438288.7223020309, -874192.3064650743],
			[421818.96675055585, -892392.7716678658],
			[414886.59276424354, -916011.7435085417],
			[407988.3032608325, -943145.4709044405],
			[397503.935298372, -956051.0790520598],
			[402547.1370476405, -983530.1074367843],
			[483075.480284545, -982750.0929838906],
			[568894.6226791167, -977532.9278548894],
			[567551.2764332942, -996090.8207130913],
			[562745.7431418216, -1014647.0764841647],
			[569506.1073747203, -1028238.356044321],
			[582467.801154104, -1040222.9756518465],
			[587005.2000301376, -1058310.8467035983],
			[589478.7045711414, -1069134.3330090372],
			[609314.0219650256, -1099068.3924691323],
			[611057.1541848994, -1144014.064660373]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47]
		]);
	}
}

module feature16(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[2099812.4994173604, 906771.446104825],
			[2123380.8112359694, 876188.3193343964],
			[2064114.340386774, 800382.7993250986],
			[2001756.797814954, 740788.6608827708],
			[1934689.5418968569, 686421.4813779907],
			[1914312.0160847118, 611825.2000784533],
			[1906874.195503536, 608539.2148750002],
			[1899199.6083188327, 622491.6854384157],
			[1881204.026032899, 634500.0651632069],
			[1880983.3090888194, 645802.9808132304],
			[1815399.4815439908, 839616.9470108617],
			[1840814.9911083214, 864728.4918629576],
			[1851835.9953845586, 920485.281319186],
			[1848801.970004842, 1009738.0754378834],
			[1877172.7953943254, 1105757.4313210829],
			[1908375.1512896556, 1084709.8039623513],
			[1948463.6500374556, 1116958.0625570426],
			[1988407.878900795, 1096014.5142870808],
			[2034609.186110447, 951643.7330099829]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18]
		]);
	}
}

module feature17(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1706153.649548901, 25216.112551389524],
			[1706617.5142849337, 20234.684060112744],
			[1690631.444143075, -27786.361416460753],
			[1672287.496314638, -33742.61063713963],
			[1664785.0051715653, -42618.14045747966],
			[1614369.9648910095, -10432.956236508833],
			[1585178.7679141604, 77574.36519168035],
			[1580063.7019302857, 27324.687776292405],
			[1612237.4256726871, -37722.00756733933],
			[1555297.0019005304, -32250.088923302676],
			[1547370.4422522178, -17957.00835990872],
			[1535283.3233392446, -25423.235384950967],
			[1523352.4220487606, -21735.7574133583],
			[1527440.5105158899, 4383.267712377408],
			[1538944.8364940488, 17487.347135205302],
			[1538524.6731955085, 26583.67092521047],
			[1537555.070234827, 33042.753135076266],
			[1528955.0747202479, 40953.909453154505],
			[1511554.3321041786, 49973.45615029303],
			[1493367.0400016191, 53040.23016691023],
			[1496810.7934919817, 65930.51514194335],
			[1484567.1260758727, 71923.22370562873],
			[1472165.1796488937, 73224.50812690204],
			[1463084.28122835, 85824.64894149452],
			[1450296.910299427, 99424.4503140765],
			[1424109.7384597517, 103181.96021255835],
			[1410480.3347624938, 91935.60898265873],
			[1403409.9184147068, 82176.49003394076],
			[1379131.1944257047, 82041.62780074852],
			[1370671.9195052583, 68592.94245248394],
			[1355743.3615508247, 61295.73368997625],
			[1344430.9506004022, 46158.72557602486],
			[1333981.2487508329, 34134.99743448302],
			[1324477.209690955, 89672.56747520354],
			[1397969.1045461677, 103443.43252439836],
			[1423008.3656783162, 108532.1011993656],
			[1478979.0553250734, 120319.64363450615],
			[1546528.2817401902, 134026.41370482364],
			[1615767.5053579286, 149626.31517201543],
			[1652804.7146579642, 12969.423137936044]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39]
		]);
	}
}

module feature18(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[2006931.248729032, 503720.3158971293],
			[2009886.0106635327, 471500.11745339265],
			[1964127.3796839467, 439485.6735007278],
			[1927268.7411056329, 431297.13871154183],
			[1920605.69776367, 447069.63573143556],
			[1905339.048223588, 456046.0141657033],
			[1891982.1706688912, 482530.91385157924],
			[1860672.5996021337, 472638.1997524289],
			[1790026.766227297, 456382.8736752326],
			[1731843.5856977832, 443547.15635378956],
			[1729192.5585490868, 521834.56816516677],
			[1791067.7996686627, 536039.3026005599],
			[1881020.3243355912, 559469.1566346918],
			[1885715.980267292, 572135.4606210975],
			[1899357.9961515465, 583795.9513090244],
			[1908689.4996039947, 584240.2283897259],
			[1924046.7530084865, 527372.1294115713],
			[1964924.7053982166, 477810.2440386325],
			[1996798.8066699307, 484196.5020399475],
			[1977586.3787518858, 520831.6491716642]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19]
		]);
	}
}

module feature19(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[404326.45738689654, 747013.9927863125],
			[406762.5097827258, 754002.4722284736],
			[410224.9987908363, 764003.6603422004],
			[413717.9331887203, 773949.0391871703],
			[417155.7895586809, 783954.08021464],
			[420620.33813240944, 793960.6627737298],
			[424033.5215479867, 803969.5091681279],
			[427436.23836037033, 813980.3521885994],
			[430867.43964523607, 823935.3178491442],
			[437705.3559696345, 844208.8100457008],
			[444497.0732650053, 864426.7797060267],
			[451201.73461483454, 884652.4906496366],
			[456502.3122935183, 900776.4602602724],
			[458445.7895755032, 907016.2430164261],
			[473587.3144884198, 908627.0931315403],
			[479493.24121887557, 912135.8858989698],
			[533807.0685111093, 944966.1075725696],
			[599072.9593289129, 912667.1579853692],
			[620390.4349543435, 902054.6300602074],
			[641779.1027713019, 891510.3665124476],
			[660502.7066543018, 882352.4518618201],
			[673776.0434283123, 875982.778961371],
			[678801.5149399737, 873493.2588790319],
			[693473.8403750717, 866126.3810954266],
			[708180.7107015743, 858793.0327580583],
			[722885.7307919256, 851486.3647922406],
			[737661.7516141413, 844217.4797614793],
			[752478.4119702345, 836928.2551242976],
			[767323.1234995464, 829727.2419882318],
			[782164.8582953084, 822558.7343906706],
			[797077.7863113885, 815425.9468191124],
			[802403.9756206324, 801145.8201029466],
			[807580.1878026418, 787266.1414257638],
			[825814.7081015079, 778525.7369130162],
			[825851.761327893, 778530.4301627529],
			[822806.4878687726, 767043.9353010111],
			[842505.6972514971, 766100.3068132068],
			[854986.7930837255, 779320.6571823435],
			[856385.8357837202, 776300.3573210775],
			[858967.9174426507, 764000.6358788423],
			[862027.9811131123, 753696.4466581312],
			[878838.2553542744, 738157.5732537305],
			[888157.4277089229, 738520.0822043272],
			[894744.3877161789, 740960.2246237003],
			[898648.0833068837, 740841.8069588956],
			[911084.2505858333, 728840.4103844743],
			[904863.1692699287, 708033.1401858173],
			[920401.3142985007, 700326.253763677],
			[937721.5573513018, 691951.9838989461],
			[958424.5808972415, 682031.0930052735],
			[971109.6834362141, 675971.8668087217],
			[988006.2295551844, 667235.4062488326],
			[992946.1522968847, 651858.7075110996],
			[997128.8638202194, 638986.1021729149],
			[1002734.9830258059, 620915.9145160228],
			[1008455.7521313087, 602449.5496273143],
			[1014176.8456531507, 584104.1359845495],
			[1020285.330338157, 564628.655670491],
			[1026977.5284086871, 543283.7861369114],
			[1032924.309089886, 524325.2960234297],
			[1039482.5668886229, 503615.1991743626],
			[1048111.9989113428, 476684.85429985484],
			[1045769.2089548007, 465443.3531892833],
			[1036298.0218987389, 412690.6252864086],
			[1035955.9062300883, 408418.5894535468],
			[1009064.5620988266, 342707.0522000632],
			[997756.8147490628, 301767.8368360126],
			[997239.0413018974, 300447.46217239567],
			[997678.6289111361, 290062.3996441148],
			[977254.2381392679, 255614.39833663247],
			[948156.8339943056, 250630.45075469336],
			[912872.1734163912, 245973.4243461148],
			[873272.0799492697, 240130.6692398397],
			[872161.9814652072, 248757.9905542951],
			[799233.6018856138, 239586.69567255417],
			[715572.6502273425, 231146.51836534237],
			[715519.1681108035, 231674.73337879754],
			[708239.6049171853, 230941.46023513522],
			[684668.7874384475, 228619.11186370472],
			[686236.3401259476, 249199.9031204545],
			[687782.8454324797, 269786.84806949005],
			[689317.0283288393, 290311.57598506147],
			[690822.8523236568, 310896.5029722274],
			[684581.8523504997, 342592.4169014272],
			[679261.0788970699, 369772.5650146099],
			[672919.5477607325, 402231.4997936021],
			[671041.2188401577, 429336.6045677626],
			[670343.4268341572, 438957.18600913323],
			[672246.6494535115, 465079.1907148854],
			[673863.9460609013, 487691.7380844459],
			[679388.864784891, 518436.0448580816],
			[683999.4534416096, 544548.7404955351],
			[689087.4981926692, 573559.2823832575],
			[700059.0820896586, 596509.5482754356],
			[708893.0057142507, 607668.7364912225],
			[717865.7892134518, 619094.6657026103],
			[700808.2928186903, 628044.6512669973],
			[677883.7503555936, 640099.5856658109],
			[665561.9182017001, 638856.6291369431],
			[652887.6575131135, 637602.1447185066],
			[645164.8141390454, 618711.4784823421],
			[633404.7931898583, 605771.4985217487],
			[631691.480653722, 592673.7203902836],
			[619940.7697859148, 596300.7497753013],
			[619878.8188904289, 596119.1105024071],
			[608860.4770377255, 608277.5704776872],
			[612675.6534664453, 626579.4941042662],
			[596432.6168385904, 626108.2770161915],
			[598154.6581020565, 644392.220079716],
			[601802.8403014595, 653697.4697855685],
			[593952.5764176523, 668638.7233584111],
			[576093.8995758387, 674148.6850508503],
			[570510.7418827626, 692024.6187760433],
			[556242.120870337, 692225.9540799063],
			[535696.4247151641, 690703.9532039904],
			[492282.42499566684, 707381.1632389681],
			[427528.7002007455, 722789.8039854887],
			[420432.20324828394, 742369.3919522826],
			[408872.19009400735, 745293.1388531044],
			[408773.8480670027, 745640.9774607152],
			[404453.5326741902, 743076.487387373],
			[403408.3856181512, 743895.5351921186]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121]
		]);
	}
}

module feature20(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[450715.76976828923, 905910.3475143345],
			[458460.30222374556, 906813.913451938],
			[456502.3122935147, 900776.4602602724],
			[451201.73461483454, 884652.4906496366],
			[444497.0732650053, 864426.7797060267],
			[437705.3559696345, 844208.8100457008],
			[430867.43964523607, 823935.3178491442],
			[418428.4953217245, 823770.0952065951],
			[405994.4527647135, 823565.6948509072],
			[393557.32736501464, 823448.251978709],
			[381124.95396225894, 823291.6082683251],
			[367221.1880532601, 811764.9155825889],
			[353303.3277232761, 800327.7290512774],
			[339297.3305209243, 788918.5601694457],
			[325244.83158818854, 777482.3874221384],
			[316627.5124651302, 771637.4349459667],
			[307955.623733962, 765807.8163498404],
			[299271.26843776245, 759926.6404791959],
			[290607.77613217226, 754119.050583732],
			[287305.3426597244, 751972.1818469182],
			[268624.01135014073, 744995.5177783793],
			[271908.8904179475, 682726.5290872051],
			[269593.70252969704, 682749.6299490598],
			[252080.69611746003, 669758.2406650662],
			[236912.65697096256, 658545.8058317058],
			[227178.1871238469, 637726.0136378357],
			[243362.61601037727, 617463.620340268],
			[238757.5708999948, 589344.3442648753],
			[239749.92560672373, 559249.9101712746],
			[238374.7832888096, 534724.5218812592],
			[260882.90757257116, 514191.4421012644],
			[269844.1212264893, 513541.9839276988],
			[294653.6021563142, 498741.82047944894],
			[303376.08491497335, 491589.7782553574],
			[309185.380805833, 479903.73201136634],
			[328991.5197085426, 461698.9199755044],
			[355263.601871414, 446529.57759582734],
			[358175.52436514525, 437496.1770857273],
			[359769.7395378381, 410792.7884312938],
			[362430.8234273427, 398390.05782467744],
			[262774.6165774656, 395936.4763052633],
			[151855.00785506185, 391899.49882960424],
			[48637.2792697423, 388931.66849846044],
			[-34396.06263271458, 389024.0844158563],
			[-32889.33103752069, 492793.31832960784],
			[-41303.217646293204, 599220.9338981448],
			[-54137.754631587995, 607959.2240081404],
			[-61259.506292134516, 625194.2708006677],
			[-57168.992503350746, 640215.3590351521],
			[-40702.760227278326, 652503.8752579759],
			[-39332.08497549314, 668670.582681972],
			[-39172.95066681625, 688845.8406225374],
			[-43600.76988043939, 705756.083825989],
			[-49564.652187390624, 723798.6226384123],
			[-52864.75493122257, 746412.5309146851],
			[-53533.72351671503, 771770.3566144515],
			[-55913.1074806609, 777851.3819043259],
			[-58539.14715455322, 810467.4694113526],
			[-58705.9745903943, 825413.0491434059],
			[-59976.75903437864, 838720.1321555545],
			[-63288.66021435454, 861286.92100746],
			[-71612.4129727494, 884206.3744038967],
			[-79533.64402826967, 904659.2275318506],
			[-80506.92919471768, 924853.4860468608],
			[-81119.94071797654, 946635.901697701],
			[-78577.89392468399, 960787.3952282016],
			[-77939.36303135376, 973724.7579715305],
			[-84240.46132190667, 989811.6745006139],
			[-85119.67756063226, 1000772.2694032534],
			[58263.05545869946, 1000348.7317310746],
			[58049.1163646583, 1043075.5064377725],
			[81338.59223653692, 1043921.2636833928],
			[94445.54209626908, 983013.296148465],
			[116401.01591227515, 964544.7553378104],
			[165230.8799441975, 958801.1961548107],
			[237046.66223814854, 943357.1881461459],
			[306475.2366038422, 911806.7612420025],
			[362504.48114728054, 929239.7193094424],
			[450677.62398802204, 905907.6581169243]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78]
		]);
	}
}

module feature21(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[675682.281958757, -525851.8476755164],
			[683694.9877222179, -546724.4177964618],
			[680552.4847135945, -691280.4007802232],
			[679768.96617086, -869198.1414015462],
			[696721.2299294056, -1037692.371270016],
			[627349.0526121842, -1050852.0585005854],
			[590606.6451944581, -1070866.6664890521],
			[587005.2000301376, -1058310.8467035983],
			[582467.801154104, -1040222.9756518465],
			[569506.1073747203, -1028238.356044321],
			[562745.7431418216, -1014647.0764841647],
			[567551.2764332942, -996090.8207130913],
			[568894.6226791167, -977532.9278548894],
			[483075.480284545, -982750.0929838906],
			[402547.1370476405, -983530.1074367843],
			[397503.935298372, -956051.0790520598],
			[407988.3032608325, -943145.4709044405],
			[414886.59276424354, -916011.7435085417],
			[421818.96675055585, -892392.7716678658],
			[438288.7223020309, -874192.3064650743],
			[441340.95551939565, -853050.20974353],
			[453140.01188524865, -841059.0386819168],
			[440549.09119334945, -822650.8434757581],
			[443484.3600050843, -808739.7684568486],
			[429347.22462619626, -786639.7197571993],
			[436572.8889319745, -770208.2728815689],
			[429895.8426076617, -764219.1512647361],
			[432992.4071994401, -742191.587545244],
			[421261.9437633167, -713661.6852331185],
			[421880.52072338044, -687298.4653468631],
			[438938.63855987537, -647641.0698622979],
			[446897.54643495486, -624269.5182670584],
			[461418.8195621125, -608326.6907248562],
			[471073.91201104166, -601463.3915187101],
			[480894.15174973063, -571112.8930785106],
			[480232.2772335397, -555039.9081321692],
			[495112.3623627026, -545821.0644039355],
			[496198.5673757594, -536928.9296947093],
			[581067.0365209486, -531035.1229791795]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38]
		]);
	}
}

module feature22(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[116023.93231251818, -332145.7523567329],
			[115579.43841745224, -332152.49794848176],
			[114395.28438896766, -213519.05877861028],
			[113444.18772588499, -94627.98380009577],
			[91931.16413535661, -84409.92484286148],
			[81661.27161703286, -61204.564309574336],
			[75385.61971421547, -50696.99241842939],
			[86517.68194084588, -30009.709266770093],
			[84031.61357358439, -13937.666539341884],
			[73563.64975951314, -14285.726361474399],
			[54346.4956789168, 353.0340580412715],
			[43797.291086901496, 24020.55977832744],
			[31290.218095682085, 38172.41187511759],
			[17812.475200061013, 55697.543926071834],
			[16188.733858209309, 64860.87111599556],
			[87624.69741636983, 65316.10751371201],
			[158920.73280217705, 66706.35154895953],
			[250370.6450548837, 70118.63740026859],
			[337143.20451160835, 76055.79848882895],
			[353190.93052171665, 58822.9210314726],
			[364570.1894317517, 50090.73805282339],
			[358971.30359898816, 22160.02985478376],
			[367795.36920843733, -10637.770143441136],
			[382297.9327416513, -32780.431075879686],
			[398719.7959772908, -50792.31292339419],
			[418169.418959446, -64657.999056493434],
			[425917.53514115524, -69273.89227432977],
			[433930.0364828339, -89992.52188247326],
			[436312.86355268187, -108448.98149037216],
			[445900.1585016738, -112524.57892340842],
			[460852.0101115688, -104430.72781262669],
			[477507.4373541693, -121270.56272017681],
			[474189.67310433876, -142024.65892358613],
			[467622.98403611605, -158625.7615728667],
			[463536.51610376034, -178421.6719945007],
			[476253.7497299564, -194336.67482363307],
			[493590.36740799295, -208930.59430811863],
			[502967.6243244974, -208722.09392549878],
			[526289.0720355026, -231556.990177115],
			[534892.1608019196, -234248.44176292056],
			[542996.5994303247, -260577.2932603763],
			[541104.8427916721, -277436.7109915498],
			[553752.6310537223, -303842.77277905034],
			[562565.0769553587, -300308.884074957],
			[578682.3009313523, -316355.9502774597],
			[576910.0441299934, -327679.46873647283],
			[579826.4630833425, -344950.6317849418],
			[567162.6767323216, -355144.4143435036],
			[549109.9455217876, -368177.6850551523],
			[547689.5469259794, -379052.90807740623],
			[543665.148245233, -395173.50419307774],
			[538967.2517904781, -422637.9726209092],
			[483551.58252507925, -426306.4874329921],
			[488069.7959461649, -414962.2720229529],
			[496815.00877554365, -402400.46902544785],
			[505577.4100029763, -389882.9765239475],
			[497662.2910025434, -376631.0715092726],
			[401107.613647784, -375460.55010005407],
			[311986.52772924857, -379542.78795209463],
			[218618.6834821674, -382475.71833395533],
			[115860.30660887036, -383127.01320842234]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60]
		]);
	}
}

module feature23(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-1129615.651223181, 601245.1440474986],
			[-1134177.066890056, 617823.7932185291],
			[-1141630.010797001, 622195.6613041679],
			[-1155832.33348795, 602261.3299398803],
			[-1173319.195106648, 601662.4677786019],
			[-1213641.2345959987, 615902.5501813198],
			[-1217542.9804777028, 605496.1522224589],
			[-1240904.036368503, 613914.2355050063],
			[-1257319.5004791305, 601305.991172201],
			[-1264990.9595500429, 632136.4358706017],
			[-1270953.1870282423, 649733.7778049146],
			[-1285332.9920583249, 655253.6365529123],
			[-1288231.482295632, 664080.924159269],
			[-1287307.0598095835, 693499.0036835836],
			[-1297500.5986068288, 709635.0813065477],
			[-1298953.1497042805, 745712.5163109313],
			[-1304577.9295877346, 762423.1079241931],
			[-1312721.6799455448, 767173.4640613879],
			[-1323157.3135177158, 753316.8679490547],
			[-1340011.621590006, 743239.6290981236],
			[-1350641.4121473222, 756651.758413706],
			[-1345605.2327963135, 784680.5814791381],
			[-1335821.5805803523, 789990.4891107976],
			[-1336071.6125066383, 819225.1755692755],
			[-1323258.1621766614, 846436.9200624829],
			[-1310562.9490758812, 868997.5829249672],
			[-1331630.098397884, 874410.2015541081],
			[-1346515.497324866, 893981.74992426],
			[-1358940.8881994663, 931733.5162420751],
			[-1366980.6772184416, 951084.2003821171],
			[-1380839.4253751186, 964862.5992210284],
			[-1389952.7177669264, 985048.0779259516],
			[-1385616.127880056, 1004575.374183995],
			[-1397416.57971863, 1037444.0945491602],
			[-1377422.3214171913, 1152603.2369337126],
			[-1174689.2796417281, 1110770.3841375567],
			[-970684.9927067509, 1075685.4986739994],
			[-765644.0702752374, 1047321.562718897],
			[-559755.1951359003, 1025651.0815230531],
			[-576788.159925104, 822426.3344163776],
			[-585076.6054576418, 687572.6645139903],
			[-597841.1535212144, 586500.9208104126],
			[-720725.222556377, 599763.2627798178],
			[-853307.4611252565, 614764.7468366048],
			[-967351.716534483, 631566.3457732669],
			[-1111615.851327541, 653262.0376318394],
			[-1120619.6315960372, 597530.3010285075],
			[-1122595.3826447895, 593866.846008606]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47]
		]);
	}
}

module feature24(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[43797.291086901496, 24020.55977832744],
			[54346.4956789168, 353.0340580412715],
			[-56165.26034198083, 366.8043672737358],
			[-240751.79419176193, 4062.354844575132],
			[-345021.2116282908, 8250.19475649229],
			[-485078.01063809183, 16228.311672565109],
			[-485247.6906973258, 16239.616207592284],
			[-485009.44731726515, 19815.000024038145],
			[-477673.259377907, 127392.49096002155],
			[-635041.9958765516, 139612.1014263619],
			[-616017.9021332068, 360500.63373906835],
			[-466901.29735977086, 348872.90275622415],
			[-352189.04001093854, 342116.11928751675],
			[-198686.78533720734, 336040.8396124589],
			[-179274.8422081937, 321458.6772958109],
			[-151246.82497762845, 311975.02741041186],
			[-144513.45788280774, 316888.26822518604],
			[-126279.02284679713, 316124.1230879433],
			[-98834.74469943461, 316798.4116979291],
			[-79127.54486190586, 302260.70952895435],
			[-58113.611532075425, 292768.94363503],
			[-54679.94619819436, 283510.3519767461],
			[-48102.71855723332, 278114.85935745394],
			[-35159.70563242337, 276508.2794104223],
			[-31735.72593116851, 265441.7565057753],
			[-26895.463576750735, 247081.57476092863],
			[-27094.953382458552, 237912.5333025548],
			[-13039.331349770877, 216947.67571526664],
			[-8156.643895314396, 198544.48563315737],
			[-7605.043909810626, 172859.4068855716],
			[-1967.064666174022, 169271.35817237743],
			[3265.52767627898, 155991.01379727645],
			[11381.79537145815, 123969.21007031061],
			[13127.184335136462, 104815.71185124818],
			[10939.462078683951, 84947.43508116789],
			[16188.733858209309, 64860.87111599556],
			[17812.475200061013, 55697.543926071834],
			[31290.218095682085, 38172.41187511759]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37]
		]);
	}
}

module feature25(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-1503470.3881303573, -184122.2867516868],
			[-1520479.123964978, -271746.7011220123],
			[-1524777.6390231485, -274654.8472523417],
			[-1533636.4135154814, -290121.0817961303],
			[-1544149.85834597, -283494.7115947779],
			[-1558532.6160376964, -272516.47950764856],
			[-1576063.8142209493, -268886.4175415916],
			[-1584544.052915763, -281092.94037836994],
			[-1580186.1724379552, -297535.15359118534],
			[-1585096.1776791383, -320920.5912473535],
			[-1587738.2600080136, -342320.08781051124],
			[-1588012.3439115768, -364449.65233658423],
			[-1597617.478645827, -384700.3540050793],
			[-1707961.7006343685, -216609.99658521943],
			[-1820536.3338605904, -39020.57404499654],
			[-1933151.83079774, 145070.81386779438],
			[-1846244.371011195, 466346.19228246604],
			[-1621970.8777072637, 410199.6369000805],
			[-1621903.1255158645, 410487.3710577384],
			[-1394418.7148459035, 360075.74527118786]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19]
		]);
	}
}

module feature26(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1794438.4525032016, 799462.3088210963],
			[1794310.5189693558, 799486.5641750562],
			[1794133.5588780898, 827872.9744719131],
			[1815399.481543998, 839616.9470108376],
			[1880983.3090888194, 645802.9808132304],
			[1881204.026032899, 634500.0651632069],
			[1899199.6083188327, 622491.6854384157],
			[1906874.195503536, 608539.2148750002],
			[1914312.0160847118, 611825.2000784533],
			[1908689.4996039926, 584240.2283897344],
			[1899357.9961515483, 583795.9513090244],
			[1885715.9802672893, 572135.4606211046],
			[1881020.3243355874, 559469.1566346975],
			[1791067.7996686627, 536039.3026005712],
			[1782145.3040797117, 545597.7106450645],
			[1784313.488257519, 561069.3657853744],
			[1778644.441657893, 589731.8649471757],
			[1779128.733731048, 597038.5304553146],
			[1774870.9202594322, 623096.784545509],
			[1777190.9417637934, 646653.9673384696],
			[1780677.1594584617, 657629.0500762305],
			[1782515.728834731, 685399.1729238419],
			[1779514.8297876301, 703103.3581054227],
			[1779109.6069629462, 714202.5257473512],
			[1791684.6339061954, 723156.989633418],
			[1804488.2593865404, 740013.8603430869],
			[1803639.7696830218, 754113.7141469038],
			[1794086.201361764, 768012.7833013133]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27]
		]);
	}
}

module feature27(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1729783.773704574, 317745.2149300099],
			[1732333.2003197982, 294415.97057241306],
			[1716169.8557794278, 258729.84071563318],
			[1740165.1785391152, 259390.74726482158],
			[1742398.391126232, 177797.52200422523],
			[1705017.8404124668, 80891.69633969691],
			[1692552.7081746561, 107288.28861171391],
			[1673875.5114746927, 108828.95160612963],
			[1641762.5673106345, 129933.0600998832],
			[1634908.984921294, 150300.94205613548],
			[1643996.8489985054, 164264.08602733022],
			[1657753.534345662, 177883.92106776524],
			[1661812.3902339586, 185950.7775234795],
			[1676970.505532903, 204602.45186584213],
			[1684198.504263679, 218753.6021131959],
			[1653122.4872221658, 240941.44509075736],
			[1649088.765177808, 252067.0255116858],
			[1639895.6782095584, 253483.45147564248],
			[1636213.736983796, 270965.1096176852],
			[1642155.0003559545, 286292.4578370991],
			[1634744.2264356646, 299405.4004987607],
			[1644806.782451061, 311785.78340333037],
			[1652479.3168758538, 339143.9588858653],
			[1660700.0462135007, 346116.5508309914]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23]
		]);
	}
}

module feature28(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-613668.3775713139, -655546.2238876555],
			[-629712.3932142929, -863499.9087712249],
			[-712990.1506998354, -856647.1505757791],
			[-874293.1416162013, -840934.318905736],
			[-954821.2377577765, -831881.028001872],
			[-954974.7132152552, -841374.0930041568],
			[-946974.1958113263, -860148.2493522933],
			[-1102244.482971491, -840561.9928797696],
			[-1108563.794668881, -885893.398219321],
			[-1180681.3241351217, -875819.9663039572],
			[-1091089.0808135828, -254627.72523148544],
			[-960917.0843618333, -272289.43736358447],
			[-829252.6444352363, -288134.2413338504],
			[-687319.1048231069, -302428.24609594344],
			[-587215.5582969737, -310931.4276556874],
			[-591314.1484383391, -365803.0308879639]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
		]);
	}
}

module feature29(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1660700.0462135007, 346116.5508309914],
			[1646540.4415608374, 350841.6310022402],
			[1631758.2935279058, 355263.8139023555],
			[1623141.07102175, 369843.07971342816],
			[1622365.1146762338, 382217.8681806405],
			[1611025.3693107285, 389887.0788490581],
			[1590573.495043332, 403064.60868561384],
			[1487356.1016441768, 380245.298377388],
			[1376343.4567147782, 357248.8146755886],
			[1257106.5479377694, 334666.77856742265],
			[1247239.1943281628, 389327.58387552056],
			[1245315.2271575446, 394266.0219946603],
			[1302015.6234135341, 440542.29024224955],
			[1301385.1450636075, 451910.75677281007],
			[1288301.1981583883, 483894.48650759045],
			[1272169.015110446, 503055.4865913459],
			[1283565.780540884, 512079.17416087387],
			[1294084.8894672922, 520421.9777205784],
			[1302555.106239979, 526774.5702499802],
			[1443687.6394425354, 555873.0152088788],
			[1449172.6496696896, 574792.3770449805],
			[1454074.4135065903, 591671.6301973701],
			[1458195.6694961817, 603300.3995715462],
			[1465545.4888354533, 613760.879121314],
			[1525091.210267202, 709181.6110299279],
			[1553067.2364026078, 736747.3700382322],
			[1662287.8977513148, 764350.2164868118],
			[1666353.610968924, 742146.9989219658],
			[1667005.9957520894, 727568.5963665136],
			[1676845.6775643684, 696032.8028296243],
			[1685020.4855795302, 680635.9959059375],
			[1683350.088871098, 656493.4130996967],
			[1697199.9342495217, 630044.080631065],
			[1696504.7883365222, 613244.4403896289],
			[1698908.4443515958, 609488.9691242437],
			[1709659.257901369, 611378.3188576676],
			[1729192.558549088, 521834.5681651625],
			[1731843.5856977853, 443547.1563537867],
			[1748407.8173732767, 360136.8768627868],
			[1756702.640186202, 352473.1501506397],
			[1742708.7795107148, 337802.4070306091],
			[1748766.1011311642, 325325.1175813831],
			[1750259.8342689506, 322230.59386795183],
			[1746131.8940799846, 318486.9385496902],
			[1853245.087671328, 367812.2591425373],
			[1881322.86455944, 353581.7857366676],
			[1782380.4883189553, 293147.3895556239],
			[1733309.7484328048, 280602.55235171627],
			[1732333.2003197982, 294415.97057241306],
			[1729783.773704574, 317745.2149300099]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49]
		]);
	}
}

module feature30(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1686768.7775237674, -195334.89220714435],
			[1722917.5817790113, -301000.0975051742],
			[1687354.405826531, -393262.5229927107],
			[1606444.389677959, -444175.5016799339],
			[1563189.2416487886, -519385.70745613304],
			[1521605.2753533623, -534822.7231518968],
			[1406380.1355116782, -449681.92448161304],
			[1311446.4026008467, -465180.30079065316],
			[1309522.3887723037, -452409.0152797637],
			[1293071.4505249513, -436123.231187433],
			[1285721.0206929261, -444787.39693929453],
			[1283438.3428864377, -435228.5804868487],
			[1242782.7152128043, -436692.11432319664],
			[1164119.924023706, -447973.03268191806],
			[1120831.9335968287, -473571.4887141907],
			[1112750.283596689, -478054.06247368746],
			[1006096.5524980766, -491682.9785930162],
			[1004986.7133472731, -468148.2646347482],
			[1022150.3420507126, -458861.7653440463],
			[1026498.3384561513, -446266.8660669032],
			[1036786.7574755665, -431328.31796368776],
			[1053616.3524247673, -426089.61862759094],
			[1072868.4636278457, -418284.4425107764],
			[1090924.414025672, -406084.9827660681],
			[1097921.3644380833, -395187.23041489185],
			[1112766.9317540743, -384097.3071064533],
			[1111166.7109530664, -376200.57062904094],
			[1130182.1043796, -358229.3677482365],
			[1138432.2079191627, -366861.81983022846],
			[1166404.2839202436, -341510.4836833456],
			[1181227.3190242576, -341431.76398779266],
			[1191288.577315676, -321027.8728059397],
			[1207603.147936513, -313585.17373609554],
			[1204191.1253962961, -298075.5843886133],
			[1204130.148780564, -283993.619189712],
			[1345430.4646690032, -265090.3581123323],
			[1510961.9627273458, -234307.01253317881],
			[1598335.8404527083, -215294.2288315326]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37]
		]);
	}
}

module feature31(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-43600.769880442196, 705756.0838259833],
			[-39172.9506668163, 688845.8406225275],
			[-39332.08497549043, 668670.5826819607],
			[-178176.55414940644, 664886.5586168537],
			[-296683.4845977235, 669365.2546607532],
			[-446078.08537332364, 677270.838250545],
			[-585076.6054576418, 687572.6645139903],
			[-576788.159925104, 822426.3344163776],
			[-559755.1951359003, 1025651.0815230531],
			[-320537.51145338174, 1008594.8021810522],
			[-85119.67756063398, 1000772.2694032564],
			[-84240.46132190587, 989811.6745006077],
			[-77939.36303135818, 973724.7579715305],
			[-78577.89392468928, 960787.3952282037],
			[-81119.94071797933, 946635.9016976902],
			[-80506.92919471768, 924853.4860468608],
			[-79533.644028276, 904659.227531845],
			[-71612.41297275118, 884206.3744038981],
			[-63288.6602143564, 861286.9210074544],
			[-59976.75903437962, 838720.132155546],
			[-58705.97459039895, 825413.0491433917],
			[-58539.1471545514, 810467.4694113526],
			[-55913.10748066186, 777851.3819043202],
			[-53533.72351671496, 771770.35661446],
			[-52864.754931222524, 746412.5309146908],
			[-49564.65218739434, 723798.6226384067]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25]
		]);
	}
}

module feature32(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1126376.3179190594, -72138.05215376266],
			[1118126.9176341968, -88960.42407626697],
			[1098374.6593288227, -94773.38504934894],
			[1081686.7206313803, -86487.75603847986],
			[1072953.421280729, -72032.02197807355],
			[1057862.0944338103, -76111.09959497458],
			[1041332.2551793009, -84633.23840989229],
			[1026184.6445391858, -80290.3570697533],
			[1007278.5942900449, -86035.87670856083],
			[993571.6748258022, -78825.27960937073],
			[975319.5372759297, -73318.4457231732],
			[950562.6212829951, -51262.31069876813],
			[934924.8535575399, -42488.010210872475],
			[906962.5255991552, -43390.9704209101],
			[897991.2528166381, 33049.25573289539],
			[885361.1665418333, 140365.71528962915],
			[873272.079949264, 240130.66923982697],
			[912872.1734163892, 245973.42434611623],
			[948156.8339942995, 250630.4507546948],
			[977254.2381392675, 255614.3983366353],
			[997678.6289111364, 290062.399644119],
			[999634.6760569869, 287430.58064138744],
			[1008580.8509413241, 275589.35498607164],
			[1022484.8145774688, 268630.2915916746],
			[1037366.0563047281, 262079.28137769084],
			[1056770.372779116, 264967.37716705207],
			[1072504.9180810824, 279002.29445086047],
			[1089086.9286025332, 293928.1116883798],
			[1103816.510531168, 307242.72894108435],
			[1121239.0204042392, 323171.6143865306],
			[1136966.624499614, 337567.951914504],
			[1155389.3778205668, 344893.4138855572],
			[1180829.0411989873, 355069.3428920486],
			[1192723.6394899625, 359907.0986391043],
			[1193037.2555464392, 360019.26006060385],
			[1193046.9828042544, 359962.68827779003],
			[1224518.9402134656, 175679.84117014517],
			[1214596.5939893734, 168317.10929526034],
			[1220289.7368171553, 154982.45381694168],
			[1220922.9941162828, 129160.42710227036],
			[1217606.461578417, 99276.28172177437],
			[1213911.0890461628, 74342.76878193414],
			[1214462.6551464326, 62819.9018104302],
			[1196930.220763271, 34234.28895144997],
			[1188587.2287119331, 27385.323114550094],
			[1178292.2424058153, 22556.88952958298],
			[1168203.6196917745, 23428.880405968812],
			[1153357.4821426682, 1729.5126377331596],
			[1153206.0798297704, -18573.05669265095],
			[1152373.8315457553, -29648.331004545526],
			[1145888.233496992, -35124.61698509037],
			[1142953.3254824725, -23038.332694553184],
			[1131631.145394851, -22059.79828942615],
			[1123939.8520854372, -47611.742217647276]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53]
		]);
	}
}

module feature33(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[115860.30660887036, -383127.01320842234],
			[134648.73378857144, -500152.7067426182],
			[134669.17689994012, -608069.2159161245],
			[133808.54172062036, -705125.5226634287],
			[95678.43672549645, -683952.7131888656],
			[70953.63811278483, -672411.0534935121],
			[51056.38125659976, -680078.1199794348],
			[20222.427768950463, -679040.7958140582],
			[1976.6952910627897, -679241.0068746489],
			[-13078.916153867025, -688269.7851316789],
			[-27782.92263303352, -692869.2778608389],
			[-40637.14895523745, -687357.4405342102],
			[-70014.08058620598, -693141.0802632106],
			[-83121.51846375685, -674523.3233678665],
			[-97004.38964478452, -690391.29349258],
			[-120837.84626285279, -682906.3861032608],
			[-145138.91864971764, -665242.434328278],
			[-171656.04267566744, -675811.8944551955],
			[-182551.10624482358, -648854.2411122537],
			[-223321.0251854207, -650456.6906721031],
			[-249174.9646979621, -643698.0282596033],
			[-278201.89939959155, -634861.8881705678],
			[-290328.75485228456, -611404.9530498879],
			[-313498.58835308766, -617921.2017592482],
			[-327266.6174117387, -608316.1536245677],
			[-347494.44858315605, -595523.4913417005],
			[-338057.3980044276, -381142.6368104033],
			[-422544.68398913956, -376957.62136946886],
			[-506982.9814978317, -371843.00470466755],
			[-591314.1484383421, -365803.03088797524],
			[-587215.558296978, -310931.4276556874],
			[-506701.1583613955, -317070.0125504679],
			[-427826.44315506483, -321790.2013211822],
			[-344029.4359079503, -325915.22428510117],
			[-260145.75581700855, -329120.43482082733],
			[-109091.85883023498, -332540.5164674427],
			[41950.279391049335, -333030.04177828506],
			[115579.43841745224, -332152.49794848176],
			[116023.93231251818, -332145.7523567329]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38]
		]);
	}
}

module feature34(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-1621903.1255158628, 410487.3710577454],
			[-1621970.8777072602, 410199.6369000946],
			[-1846244.3710111876, 466346.19228246465],
			[-2160598.715612729, 559957.9185401155],
			[-2157946.5747340587, 648567.0806198028],
			[-2097466.3964387625, 739079.3033354942],
			[-2018998.3259655563, 925767.6095986939],
			[-2000397.7719728895, 1008450.7587762468],
			[-1985071.7711682273, 1003476.444438905],
			[-1964081.1523196574, 996339.1410341338],
			[-1950224.8480879583, 981450.2009176023],
			[-1931886.57063779, 969175.2743554345],
			[-1925111.9715864705, 944922.4518312025],
			[-1928664.4143214468, 926517.8447931613],
			[-1927976.4820914667, 910025.3952550563],
			[-1912936.0447275748, 901087.3574614],
			[-1895554.7338792772, 896281.1237254114],
			[-1865010.9971275951, 899568.2127037594],
			[-1848049.976384292, 898325.7216600882],
			[-1824198.887822285, 886533.2700188132],
			[-1814698.933771964, 877785.8095869842],
			[-1798834.9063486264, 877414.9431096038],
			[-1780354.9276398974, 881603.2800990705],
			[-1748866.7004051062, 871426.1569070424],
			[-1719467.7739570383, 876165.6463404032],
			[-1703349.8409871496, 881240.202216642],
			[-1686582.1478617133, 871768.2101318913],
			[-1658316.2028046353, 876381.3050953104],
			[-1511995.5116730835, 841212.7692006077],
			[-1500058.0184710778, 816451.4326764914],
			[-1490110.3407076974, 804925.7583217754],
			[-1490058.2504367738, 787595.9473124006],
			[-1500538.1033013673, 775156.8871989443],
			[-1516640.845330118, 749479.1069153466],
			[-1535076.297870655, 716934.4764041508],
			[-1555707.5845294876, 699184.2783390166],
			[-1571748.051715973, 677055.9864771107],
			[-1576002.1324744737, 659814.4574582587],
			[-1564085.1537602623, 649266.006845471],
			[-1561465.179377908, 633790.5919906512],
			[-1575094.901071481, 604560.8058350985]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40]
		]);
	}
}

module feature35(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1676970.505532903, 204602.45186584213],
			[1661812.3902339586, 185950.7775234795],
			[1657753.534345662, 177883.92106776524],
			[1643996.8489985054, 164264.08602733022],
			[1625813.830533006, 166003.7597591199],
			[1619863.2728060025, 159528.24905118282],
			[1615767.5053579286, 149626.31517201543],
			[1546528.2817401902, 134026.41370482364],
			[1478979.0553250734, 120319.64363450615],
			[1423008.3656783162, 108532.1011993656],
			[1397969.1045461677, 103443.43252439836],
			[1324477.209690955, 89672.56747520354],
			[1241831.3396623877, 74976.74625507632],
			[1224518.940213466, 175679.8411701551],
			[1193046.9828042525, 359962.68827779003],
			[1193037.2555464352, 360019.26006061514],
			[1212753.7769773614, 368094.3616200522],
			[1245374.430173152, 394206.8330292316],
			[1247239.1943281628, 389327.58387552056],
			[1257106.5479377694, 334666.77856742265],
			[1376343.4567147782, 357248.8146755886],
			[1487356.1016441768, 380245.298377388],
			[1590573.495043332, 403064.60868561384],
			[1611025.3693107285, 389887.0788490581],
			[1622365.1146762338, 382217.8681806405],
			[1623141.07102175, 369843.07971342816],
			[1631758.2935279058, 355263.8139023555],
			[1646540.4415608374, 350841.6310022402],
			[1660700.0462135007, 346116.5508309914],
			[1652479.3168758538, 339143.9588858653],
			[1644806.782451061, 311785.78340333037],
			[1634744.2264356646, 299405.4004987607],
			[1642155.0003559545, 286292.4578370991],
			[1636213.736983796, 270965.1096176852],
			[1639895.6782095584, 253483.45147564248],
			[1649088.7651778131, 252067.02551168718],
			[1653122.4872221658, 240941.44509075736],
			[1684198.504263679, 218753.6021131959]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37]
		]);
	}
}

module feature36(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1920605.69776367, 447069.63573143556],
			[1927268.7411056329, 431297.13871154183],
			[1876905.6557511904, 397262.1536952589],
			[1877242.549705415, 414226.17771884677],
			[1860672.5996021337, 472638.1997524289],
			[1891982.1706688912, 482530.91385157924],
			[1905339.048223588, 456046.0141657033]
		], paths=[
			[0,1,2,3,4,5,6]
		]);
	}
}

module feature37(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1521605.2753533623, -534822.7231518968],
			[1485493.284837697, -583231.1894493863],
			[1479940.7273536462, -622139.8731458299],
			[1396579.2285091619, -710337.6395600195],
			[1355654.6320927052, -770917.2086171849],
			[1339506.4220100252, -767845.4456397025],
			[1330715.9616295886, -765136.0930147133],
			[1327415.6570315338, -744269.7677070812],
			[1315349.3144355768, -725201.9623834537],
			[1296970.011015249, -715889.2528372221],
			[1298694.733835673, -707345.5949860413],
			[1291522.2554825558, -696082.9072459885],
			[1281217.2481120413, -672065.1220938545],
			[1249722.0480951353, -654429.8646986184],
			[1235471.7464222696, -629927.8327547922],
			[1212060.5836854384, -615252.6339733005],
			[1203996.2387932152, -602531.0723067862],
			[1169870.9058912634, -581073.3141716325],
			[1156690.2282615253, -563143.6881474962],
			[1135545.1581854483, -530757.9138526734],
			[1119643.66743182, -526228.9935797106],
			[1093858.3629435343, -511262.4279493141],
			[1104674.652251114, -488513.4348832856],
			[1112750.283596689, -478054.06247368746],
			[1120831.9335968287, -473571.4887141907],
			[1164119.924023706, -447973.03268191806],
			[1242782.7152128043, -436692.11432319664],
			[1283438.3428864377, -435228.5804868487],
			[1285721.0206929261, -444787.39693929453],
			[1293071.4505249513, -436123.231187433],
			[1309522.3887723037, -452409.0152797637],
			[1311446.4026008467, -465180.30079065316],
			[1406380.1355116782, -449681.92448161304]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32]
		]);
	}
}

module feature38(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-58113.611532075425, 292768.94363503],
			[-79127.54486190586, 302260.70952895435],
			[-98834.74469943461, 316798.4116979291],
			[-126279.02284679713, 316124.1230879433],
			[-144513.45788280774, 316888.26822518604],
			[-151246.82497762845, 311975.02741041186],
			[-179274.8422081937, 321458.6772958109],
			[-198686.78533720734, 336040.8396124589],
			[-352189.04001093854, 342116.11928751675],
			[-466901.29735977086, 348872.90275622415],
			[-616017.9021332068, 360500.63373906835],
			[-597841.1535212144, 586500.9208104126],
			[-585076.6054576418, 687572.6645139903],
			[-446078.08537332364, 677270.838250545],
			[-296683.4845977235, 669365.2546607532],
			[-178176.55414940644, 664886.5586168537],
			[-39332.08497549043, 668670.5826819607],
			[-40702.76022728393, 652503.8752579731],
			[-57168.992503354515, 640215.3590351464],
			[-61259.50629213734, 625194.2708006649],
			[-54137.754631589974, 607959.2240081263],
			[-41303.21764629324, 599220.933898139],
			[-32889.331037517855, 492793.3183296036],
			[-34396.06263271844, 389024.0844158577],
			[-44529.20728638106, 389021.6732550852],
			[-44784.677269653796, 361921.1474485256],
			[-35130.14122386327, 347110.7987415116],
			[-37015.38987256081, 335067.29305877554],
			[-41091.41090314361, 317278.9753849967],
			[-47390.11676332653, 299094.783894404],
			[-34987.25071248242, 286676.6774522868],
			[-35159.70563242337, 276508.2794104223],
			[-48102.71855723332, 278114.85935745394],
			[-54679.94619819436, 283510.3519767461]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33]
		]);
	}
}

module feature39(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1204130.148780565, -283993.619189712],
			[1204191.1253962952, -298075.5843886218],
			[1207603.1479365046, -313585.1737360913],
			[1191288.5773156723, -321027.87280594255],
			[1181227.3190242527, -341431.76398779126],
			[1166404.2839202366, -341510.48368334846],
			[1138432.207919166, -366861.8198302412],
			[1130182.1043795974, -358229.3677482365],
			[1111166.7109530647, -376200.5706290523],
			[1112766.931754072, -384097.30710646743],
			[1097921.3644380856, -395187.23041489325],
			[1090924.4140256646, -406084.98276606953],
			[1072868.4636278446, -418284.44251078204],
			[1053616.352424762, -426089.61862759094],
			[1036786.7574755658, -431328.3179636821],
			[1026498.338456145, -446266.866066916],
			[1022150.3420507086, -458861.7653440576],
			[1004986.7133472718, -468148.2646347482],
			[1006096.5524980709, -491682.9785930162],
			[960518.3875837198, -498557.4199049117],
			[894259.1266923466, -505430.32166638796],
			[783806.2268445932, -515821.5563475755],
			[675682.2819587567, -525851.8476755136],
			[581067.036520942, -531035.1229791922],
			[496198.5673757557, -536928.9296947035],
			[505382.10336680856, -525989.4504445543],
			[502257.963805961, -493834.16926199355],
			[514852.96518966206, -478420.19602421165],
			[516934.7307079073, -459862.3836204208],
			[531139.503783034, -448075.1963367616],
			[538708.4933229523, -431895.7321493695],
			[538967.2517904781, -422637.9726209092],
			[543665.148245233, -395173.50419307774],
			[547689.5469259794, -379052.90807740623],
			[549109.9455217876, -368177.6850551523],
			[669586.4821546202, -359597.79436739226],
			[667800.2238777914, -342245.89034621033],
			[684451.9312221635, -340536.18316268193],
			[687617.8474145312, -345324.43198719923],
			[739878.8936814804, -337317.3792375175],
			[785162.2377432985, -333382.00370235683],
			[834362.9242263001, -329048.27808441705],
			[882819.6699691904, -326723.5898778924],
			[906795.0839406145, -322549.5798489695],
			[981201.7129538349, -318123.56443680834],
			[1037372.9694319494, -307001.4678810571],
			[1162167.7059801766, -292737.20961912826]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46]
		]);
	}
}

module feature40(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[220311.06686211593, -971658.0175580942],
			[228768.05884029463, -986571.4411915202],
			[221067.4495027293, -1027334.9989062123],
			[215515.65663552363, -1039509.8290050761],
			[208168.09355798055, -1066163.5752693352],
			[215074.7511022516, -1073381.3665830197],
			[215399.42484724612, -1095495.7090373535],
			[201926.74627252886, -1110499.7813266914],
			[192903.28857212368, -1126964.4001306165],
			[199677.86364759252, -1138797.28572437],
			[121954.90088499009, -1166185.6639749252],
			[37583.95322778942, -1249153.8370209902],
			[-56143.932817253146, -1296849.3877805513],
			[-108425.56833271221, -1349248.746650397],
			[-131068.10074392501, -1398783.7136563025],
			[-133140.148685934, -1475219.8601816995],
			[-129118.72717616687, -1528461.1467569678],
			[-111148.29322148564, -1566406.0103957215],
			[-149224.84423921054, -1569187.8328862174],
			[-217872.17550249214, -1543370.5545761674],
			[-292567.75223429064, -1506840.6644038183],
			[-317784.49757553206, -1453869.56916645],
			[-335967.9254792876, -1375558.6429911961],
			[-389391.68497433496, -1310104.5889079962],
			[-418918.3152697134, -1243661.1805625588],
			[-461901.56607036263, -1165438.9034973597],
			[-524745.7505694971, -1117523.4133538757],
			[-600547.487938765, -1114627.876256922],
			[-665684.6909841262, -1197566.983864601],
			[-740279.794152903, -1158010.8756870353],
			[-785237.5636521826, -1120318.6476276226],
			[-802436.1459833148, -1057471.9105309872],
			[-827174.838160299, -996873.1744159604],
			[-876214.4408496008, -942810.7553746019],
			[-918631.5066724261, -902947.6686538804],
			[-946974.1958113263, -860148.2493522933],
			[-954974.7132152552, -841374.0930041568],
			[-954821.2377577765, -831881.028001872],
			[-874293.1416162013, -840934.318905736],
			[-712990.1506998354, -856647.1505757791],
			[-629712.3932142929, -863499.9087712249],
			[-591314.1484383391, -365803.0308879639],
			[-506982.98149783304, -371843.0047046562],
			[-422544.6839891379, -376957.62136945757],
			[-338057.398004425, -381142.63681039197],
			[-347494.4485831533, -595523.4913416891],
			[-327266.6174117397, -608316.1536245648],
			[-313498.5883530842, -617921.2017592468],
			[-290328.75485227664, -611404.9530498822],
			[-278201.8993995935, -634861.8881705579],
			[-249174.96469795617, -643698.028259592],
			[-223321.02518542082, -650456.6906721088],
			[-182551.10624482218, -648854.2411122425],
			[-171656.04267565935, -675811.8944551842],
			[-145138.9186497174, -665242.4343282637],
			[-120837.84626285385, -682906.3861032579],
			[-97004.389644781, -690391.2934925657],
			[-83121.51846375788, -674523.3233678594],
			[-70014.08058620263, -693141.0802632106],
			[-40637.14895523852, -687357.4405342017],
			[-27782.922633030114, -692869.2778608261],
			[-13078.916153867016, -688269.7851316732],
			[1976.6952910672544, -679241.0068746473],
			[20222.42776894823, -679040.7958140582],
			[51056.38125660422, -680078.1199794348],
			[70953.63811279261, -672411.0534935079],
			[95678.43672549629, -683952.7131888515],
			[133808.54172062254, -705125.5226634244],
			[138544.2380175579, -712322.4345202023],
			[155623.99908281668, -710541.2449339932],
			[176000.7436671863, -710529.2846079477],
			[172264.77589450168, -773598.9366561164],
			[180276.17363058976, -892052.1940905141],
			[195349.8310747403, -904207.507336276],
			[200779.4157141966, -921214.2575705897],
			[209131.5590384227, -946712.6110281856]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75]
		]);
	}
}

module feature41(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-1028190.3170236995, 185191.36472662466],
			[-1091089.0808135902, -254627.7252314911],
			[-1211340.5341847877, -235443.66345271122],
			[-1370209.534910256, -207939.4613175593],
			[-1503470.3881303573, -184122.2867516868],
			[-1394418.714845903, 360075.74527118786],
			[-1165863.548319993, 318988.9116911656],
			[-1184010.5177985502, 212383.28956548782]
		], paths=[
			[0,1,2,3,4,5,6,7]
		]);
	}
}

module feature42(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1794438.4525031997, 799462.3088210892],
			[1794086.2013617638, 768012.7833013076],
			[1803639.7696830188, 754113.7141468896],
			[1804488.259386542, 740013.8603430841],
			[1791684.6339062, 723156.9896334066],
			[1779109.6069629448, 714202.525747337],
			[1779514.8297876297, 703103.3581054198],
			[1782515.7288347331, 685399.1729238334],
			[1780677.1594584638, 657629.0500762305],
			[1777190.941763797, 646653.9673384554],
			[1774870.9202594308, 623096.7845454906],
			[1779128.7337310503, 597038.530455299],
			[1778644.4416578908, 589731.8649471757],
			[1784313.48825752, 561069.3657853702],
			[1782145.304079708, 545597.7106450603],
			[1791067.7996686627, 536039.3026005599],
			[1729192.5585490868, 521834.56816516677],
			[1709659.2579013673, 611378.3188576591],
			[1698908.4443515993, 609488.9691242296],
			[1696504.788336521, 613244.4403896147],
			[1697199.9342495224, 630044.0806310622],
			[1683350.0888710928, 656493.413099694],
			[1685020.485579529, 680635.9959059346],
			[1676845.6775643677, 696032.8028296228],
			[1667005.9957520894, 727568.5963665108],
			[1666353.6109689225, 742146.9989219573],
			[1662287.8977513176, 764350.2164868132],
			[1794310.518969354, 799486.5641750547]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27]
		]);
	}
}

module feature43(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1690631.3413703572, -27786.08750236799],
			[1664672.3784433303, -124581.9492002247],
			[1656280.9952760492, -121945.80032925012],
			[1664784.984806088, -42617.94327626749],
			[1672287.466795467, -33742.597860819245],
			[1420862.3219447935, 72360.08433523717],
			[1467388.6759924144, 50971.114897257474],
			[1472165.2001734392, 73224.44528072777],
			[1484567.0387380286, 71923.50189264452],
			[1496810.7385318095, 65930.73655161756],
			[1493367.080955299, 53040.26379667561],
			[1511554.3217436539, 49973.461886273224],
			[1528955.0462478367, 40954.061385460525],
			[1537555.070234827, 33042.753135076266],
			[1538524.6784475467, 26583.703022782538],
			[1538944.9279182353, 17487.333962716977],
			[1527440.420399692, 4383.562476442567],
			[1523352.3752808152, -21735.69004773485],
			[1535283.3004060504, -25423.180377243727],
			[1547370.454935985, -17956.697693791088],
			[1555296.993466795, -32250.16361165568],
			[1618417.0300717312, -55150.54203888701],
			[1644632.5699725146, -157515.68925706667],
			[1669828.7721477638, -159776.49282512735],
			[1686768.8181960678, -195334.90984332486],
			[1598335.7877111644, -215294.0359538199],
			[1510961.995959805, -234306.85407032756],
			[1345430.571762438, -265090.3140145613],
			[1204130.1973326053, -283993.34076693765],
			[1162167.7445193166, -292737.2815503757],
			[1037373.0167672477, -307001.4707144678],
			[1060664.1965548177, -297442.30569947854],
			[1076892.2551670135, -288222.24841274694],
			[1082823.6302944934, -276461.50348281563],
			[1103699.5653540683, -260094.88851029568],
			[1110839.0589793217, -247235.45090296812],
			[1111547.956433264, -238050.0362721486],
			[1135479.5768520972, -221356.20940441487],
			[1163471.8648019861, -183616.71153979714],
			[1170034.3222256477, -201674.08806871632],
			[1180889.922145367, -210138.46840650763],
			[1194831.0601941068, -216971.51432815296],
			[1218741.7567820014, -199564.22926889162],
			[1229909.089460674, -205655.97279377],
			[1259148.9253654133, -191395.70390758268],
			[1259286.613172579, -181307.93240631215],
			[1269259.2927705601, -183612.77095903683],
			[1278079.985442874, -173889.6840911687],
			[1289786.3841983783, -173486.97841762044],
			[1301356.0192568693, -162777.04715614457],
			[1301386.5106971855, -152457.69371778343],
			[1297800.847228421, -139846.7486470522],
			[1305551.7975337433, -118989.7256505895],
			[1318759.021069289, -101918.70014308293],
			[1319880.9856550714, -85072.06939493687],
			[1330291.8795799704, -63149.09966483469],
			[1333724.942293278, -37989.10939113794],
			[1345987.5271059494, -44471.1707084306],
			[1359435.7621534036, -50055.851128532384],
			[1370236.8766018562, -43690.23804690259],
			[1372266.5348707393, -33031.44910012589],
			[1377646.369716642, -17975.4279573624],
			[1383655.4800941492, -820.3671285163913],
			[1390340.2824408403, -4271.293765622916],
			[1399535.4802070155, 12079.895579622087],
			[1412452.680417361, 29351.93984375431],
			[1420271.4334713581, 42128.74112548937]
		], paths=[
			[0,1,2,3,4],
			[5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66]
		]);
	}
}

module feature44(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-1509493.7498207863, 878324.2518528008],
			[-1506889.9360938957, 860314.0498363216],
			[-1511995.5116730835, 841212.7692006077],
			[-1658316.2028046353, 876381.3050953104],
			[-1686582.1478617133, 871768.2101318913],
			[-1703349.8409871496, 881240.202216642],
			[-1719467.7739570383, 876165.6463404032],
			[-1748866.7004051062, 871426.1569070424],
			[-1780354.9276398974, 881603.2800990705],
			[-1798834.9063486264, 877414.9431096038],
			[-1814698.933771964, 877785.8095869842],
			[-1824198.887822285, 886533.2700188132],
			[-1848049.976384292, 898325.7216600882],
			[-1865010.9971275951, 899568.2127037594],
			[-1895554.7338792772, 896281.1237254114],
			[-1912936.0447275748, 901087.3574614],
			[-1927976.4820914667, 910025.3952550563],
			[-1928664.4143214468, 926517.8447931613],
			[-1925111.9715864705, 944922.4518312025],
			[-1931886.57063779, 969175.2743554345],
			[-1950224.8480879583, 981450.2009176023],
			[-1964081.1523196574, 996339.1410341338],
			[-1985071.7711682273, 1003476.444438905],
			[-2000397.7719728895, 1008450.7587762468],
			[-1986345.5596020028, 1071836.7680389772],
			[-1978756.4759512404, 1169281.132684277],
			[-1982380.7464143033, 1224730.291848827],
			[-1967579.4656517992, 1242747.1872334213],
			[-1882128.3407841006, 1176116.5037415293],
			[-1876474.7998296556, 1064678.852281031],
			[-1851141.0563798842, 1087736.8824085174],
			[-1835851.1019500087, 1178350.0665664696],
			[-1832212.5845631561, 1272485.644545386],
			[-1643297.036735461, 1218352.9439159334],
			[-1443820.2714733416, 1167741.0016725224],
			[-1476025.935021506, 1029512.5204784696]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35]
		]);
	}
}

module feature45(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[1472165.1796488904, 73224.50812688789],
			[1467388.552413677, 50971.197214296895],
			[1420862.3011522996, 72359.83065570783],
			[1420271.4896878642, 42128.554375640684],
			[1412452.6662902771, 29352.027011118345],
			[1399535.4935461956, 12079.763777732695],
			[1390340.302574444, -4271.573693084526],
			[1383655.400923869, -820.4589666906963],
			[1377646.4151441364, -17975.519196560253],
			[1372266.5454459474, -33031.56986794924],
			[1370236.9243678965, -43690.54714481357],
			[1359435.760127766, -50055.89381477011],
			[1345987.5534356239, -44471.4263060337],
			[1333724.9016360273, -37989.35992425682],
			[1330291.8405986677, -63149.31537136685],
			[1319880.9439660113, -85071.98720012668],
			[1318758.9786839648, -101918.9736016861],
			[1305551.822890898, -118989.78062580842],
			[1297800.8464680717, -139846.81393145776],
			[1301386.5560202035, -152457.89995131132],
			[1301355.9564719605, -162777.23786226547],
			[1289786.3840637547, -173487.27270999856],
			[1278079.954953119, -173889.7028742413],
			[1269259.3519683424, -183612.96342730868],
			[1259286.6649044, -181308.12044150085],
			[1259148.83980799, -191395.7032315222],
			[1229909.1455345938, -205656.16592071668],
			[1218741.703240297, -199564.20004976072],
			[1194831.0986458817, -216971.67036435768],
			[1180889.886588381, -210138.47039372884],
			[1170034.3420125286, -201673.98996582758],
			[1163471.84963894, -183616.66458973283],
			[1147133.5160951277, -184058.8445860649],
			[1136878.8449434466, -172019.39404659052],
			[1122737.2975337903, -159605.21998009871],
			[1116286.7020715324, -143530.70447190639],
			[1103993.3576797477, -127846.05530663132],
			[1101478.6847047776, -105000.03451642198],
			[1098374.6593288227, -94773.38504934894],
			[1118126.9176341968, -88960.42407626697],
			[1126376.3179190594, -72138.05215376266],
			[1123939.8520854372, -47611.742217647276],
			[1131631.145394851, -22059.79828942615],
			[1142953.3254824725, -23038.332694553184],
			[1145888.233496992, -35124.61698509037],
			[1152373.8315457553, -29648.331004545526],
			[1153206.0798297704, -18573.05669265095],
			[1153357.4821426682, 1729.5126377331596],
			[1168203.6196917745, 23428.880405968812],
			[1178292.2424058153, 22556.88952958298],
			[1188587.2287119331, 27385.323114550094],
			[1196930.220763271, 34234.28895144997],
			[1214462.6551464326, 62819.9018104302],
			[1213911.0890461628, 74342.76878193414],
			[1217606.461578417, 99276.28172177437],
			[1220922.9941162828, 129160.42710227036],
			[1220289.7368171553, 154982.45381694168],
			[1214596.5939893734, 168317.10929526034],
			[1224518.9402134656, 175679.84117014517],
			[1241831.3396623882, 74976.74625506216],
			[1324477.2096909597, 89672.56747518938],
			[1333981.2487508368, 34134.99743447169],
			[1344430.9506003938, 46158.72557600928],
			[1355743.3615508243, 61295.733689972],
			[1370671.9195052616, 68592.94245247685],
			[1379131.1944257012, 82041.62780074003],
			[1403409.9184147066, 82176.49003392944],
			[1410480.3347624873, 91935.60898265448],
			[1424109.7384597564, 103181.96021254419],
			[1450296.9102994285, 99424.45031406943],
			[1463084.2812283456, 85824.64894149594]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70]
		]);
	}
}

module feature46(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[700808.2928186893, 628044.6512669888],
			[717865.7892134518, 619094.6657026103],
			[708893.0057142499, 607668.7364912112],
			[700059.0820896584, 596509.54827542],
			[689087.4981926698, 573559.2823832518],
			[683999.4534416064, 544548.7404955209],
			[679388.8647848886, 518436.04485806887],
			[673863.9460608955, 487691.7380844459],
			[672246.6494535139, 465079.1907148713],
			[670343.4268341528, 438957.186009129],
			[671041.218840157, 429336.6045677696],
			[672919.5477607304, 402231.4997935922],
			[679261.07889707, 369772.56501460844],
			[684581.8523504998, 342592.4169014258],
			[690822.8523236582, 310896.5029722132],
			[656180.9180489018, 307855.25013719813],
			[631794.0071026343, 305784.8460042672],
			[631820.3507039503, 305493.2748571566],
			[572504.0998479411, 301389.6148368294],
			[492154.55016212596, 295515.33616536355],
			[413511.78566899523, 290431.9024871164],
			[405025.756961865, 306950.755025025],
			[379340.3915938945, 316168.81666251144],
			[373439.95851177775, 333511.47753753315],
			[369791.5630778875, 343262.46965486644],
			[368310.1102783226, 366556.6456401497],
			[374672.787038693, 375317.8094887604],
			[363833.58920111996, 392401.22083779756],
			[362430.82342733763, 398390.0578246817],
			[359769.73953783774, 410792.78843130084],
			[358175.5243651439, 437496.177085716],
			[355263.60187141626, 446529.5775958231],
			[328991.51970854285, 461698.91997550015],
			[309185.38080583204, 479903.73201136634],
			[303376.0849149735, 491589.77825535455],
			[294653.60215630895, 498741.82047943905],
			[269844.12122648465, 513541.98392769595],
			[260882.90757256962, 514191.4421012559],
			[238374.78328880598, 534724.5218812564],
			[239749.9256067237, 559249.910171276],
			[238757.57089999758, 589344.3442648782],
			[243362.61601037538, 617463.6203402694],
			[227178.18712384865, 637726.0136378385],
			[236912.6569709574, 658545.8058316945],
			[252080.69611745828, 669758.2406650648],
			[269593.702529693, 682749.6299490669],
			[271908.8904179455, 682726.5290872093],
			[268624.01135013666, 744995.517778365],
			[287305.3426597219, 751972.1818469111],
			[290607.77613216994, 754119.0505837235],
			[299271.26843776286, 759926.6404791859],
			[307955.6237339581, 765807.8163498262],
			[316627.51246513356, 771637.4349459539],
			[325244.83158818557, 777482.3874221242],
			[339297.3305209263, 788918.5601694429],
			[353303.32772327395, 800327.7290512675],
			[367221.1880532582, 811764.9155825889],
			[381124.95396225376, 823291.6082683209],
			[393557.32736501447, 823448.2519787118],
			[405994.45276470773, 823565.6948508987],
			[418428.4953217239, 823770.095206591],
			[430867.4396452367, 823935.3178491343],
			[427436.23836036597, 813980.3521885951],
			[424033.521547985, 803969.5091681279],
			[420620.3381324065, 793960.6627737326],
			[417155.7895586768, 783954.0802146457],
			[413717.93318872264, 773949.0391871618],
			[410224.99879083276, 764003.6603421975],
			[406762.50978272664, 754002.472228475],
			[404326.457386891, 747013.9927863125],
			[403408.38561815297, 743895.5351921186],
			[404453.5326741898, 743076.4873873801],
			[408773.8480670016, 745640.9774607038],
			[408872.1900940065, 745293.1388531044],
			[420432.2032482797, 742369.3919522784],
			[427528.700200746, 722789.8039854817],
			[492282.424995659, 707381.163238961],
			[535696.4247151645, 690703.9532039862],
			[556242.1208703378, 692225.954079895],
			[570510.7418827642, 692024.6187760263],
			[576093.8995758385, 674148.6850508432],
			[593952.5764176511, 668638.723358404],
			[601802.8403014534, 653697.469785553],
			[598154.6581020565, 644392.2200797047],
			[596432.6168385898, 626108.2770161759],
			[612675.6534664434, 626579.4941042662],
			[608860.4770377255, 608277.5704776872],
			[619878.8188904255, 596119.1105024128],
			[619940.769785914, 596300.74977529],
			[631691.4806537201, 592673.7203902836],
			[633404.7931898554, 605771.4985217388],
			[645164.8141390488, 618711.4784823294],
			[652887.6575131047, 637602.1447184995],
			[665561.918201696, 638856.6291369346],
			[677883.7503555954, 640099.5856658039]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94]
		]);
	}
}

module feature47(height, bx, by) {
	if (height > 0) {
		translate([bx, by, 0]) scale([inflation, inflation, 1]) translate([-bx, -by, 0])
		linear_extrude(height=height) polygon(points=[
			[-1120619.6315960372, 597530.3010285075],
			[-1111615.851327541, 653262.0376318394],
			[-967351.716534483, 631566.3457732669],
			[-853307.4611252565, 614764.7468366048],
			[-720725.222556377, 599763.2627798178],
			[-597841.1535212144, 586500.9208104126],
			[-616017.9021332068, 360500.63373906835],
			[-635041.9958765516, 139612.1014263619],
			[-713871.8867724232, 146985.06292452893],
			[-871221.7333972298, 164325.75101443724],
			[-949718.8585374419, 174350.69559794388],
			[-1028190.3170236995, 185191.36472662466],
			[-1184010.5177985502, 212383.28956548922],
			[-1165863.5483199926, 318988.91169116844],
			[-1120310.6884392786, 591458.6611245511],
			[-1122595.3826447895, 593866.846008606]
		], paths=[
			[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
		]);
	}
}

module Prismap() {
	union() {
		if (wall_thickness > 0) {
			Walls();
		}
		scale([xy_scale, xy_scale, 1]) translate([54203, 148351, 0]) {
			if (floor_thickness > 0 || wall_thickness > 0) {
				Floor();
			}
			feature0(extrusionheight(data0), 838295.8696039888, -774067.8013669015);
			feature1(extrusionheight(data1), -1380441.3481938103, -529971.126527822);
			feature2(extrusionheight(data2), 327413.77919967426, -574529.7433780852);
			feature3(extrusionheight(data3), -1903162.578887838, -39731.56592569337);
			feature4(extrusionheight(data4), -784381.1700957479, -65939.32391192163);
			feature5(extrusionheight(data5), 1804543.0677016005, 397351.9995865531);
			feature6(extrusionheight(data6), 1660960.577453415, 89486.59144852725);
			feature7(extrusionheight(data7), 1152104.4400939462, -1223179.25064892);
			feature8(extrusionheight(data8), 1124956.8793925284, -725851.4159602495);
			feature9(extrusionheight(data9), -1371106.9069775715, 743364.9566818464);
			feature10(extrusionheight(data10), 526053.4361206566, -2729.7236526232446);
			feature11(extrusionheight(data11), 785322.9169132262, 16787.75648383473);
			feature12(extrusionheight(data12), 203148.27055988595, 224240.39793875255);
			feature13(extrusionheight(data13), -195560.8599719716, -158395.21278534638);
			feature14(extrusionheight(data14), 856290.8975803638, -205332.84763301237);
			feature15(extrusionheight(data15), 402332.94592146156, -977218.1744277722);
			feature16(extrusionheight(data16), 1969390.14638998, 862748.6387160213);
			feature17(extrusionheight(data17), 1515547.3619879442, 53504.08735726788);
			feature18(extrusionheight(data18), 1869539.2846063096, 507768.68355063384);
			feature19(extrusionheight(data19), 725760.192264747, 586792.6097181372);
			feature20(extrusionheight(data20), 186670.31233155663, 716426.4660909267);
			feature21(extrusionheight(data21), 547112.5826138888, -798359.2570822842);
			feature22(extrusionheight(data22), 298007.59847077593, -175125.34447208158);
			feature23(extrusionheight(data23), -978585.8874272652, 869552.0788720626);
			feature24(extrusionheight(data24), -290347.7500988174, 180426.83389855482);
			feature25(extrusionheight(data25), -1663785.2728218217, 40822.91913869337);
			feature26(extrusionheight(data26), 1844591.468172072, 687828.1248057045);
			feature27(extrusionheight(data27), 1688571.3087809482, 213504.12358534418);
			feature28(extrusionheight(data28), -883948.4412160476, -570260.5617254032);
			feature29(extrusionheight(data29), 1563319.0458584921, 522476.38441926404);
			feature30(extrusionheight(data30), 1363952.1475631422, -365078.80767952057);
			feature31(extrusionheight(data31), -312124.77806222904, 845268.8200699533);
			feature32(extrusionheight(data32), 1048895.5100813648, 132622.93750562746);
			feature33(extrusionheight(data33), -228322.485769201, -508028.475159558);
			feature34(extrusionheight(data34), -1825328.4830247513, 709325.1978381707);
			feature35(extrusionheight(data35), 1438617.8799050571, 239020.67747034508);
			feature36(extrusionheight(data36), 1893970.6703538834, 439896.5337734191);
			feature37(extrusionheight(data37), 1307731.8191484483, -603072.8945520169);
			feature38(extrusionheight(data38), -324453.61658536235, 482040.4719622063);
			feature39(extrusionheight(data39), 851900.8576561301, -410461.27444220777);
			feature40(extrusionheight(data40), -363103.3271874803, -967495.4318870907);
			feature41(extrusionheight(data41), -1265830.3525770283, 52724.010019848385);
			feature42(extrusionheight(data42), 1733388.0785689298, 660660.5661701107);
			feature43(extrusionheight(data43), 1364002.1790688024, -116888.51271687003);
			feature44(extrusionheight(data44), -1722109.0217231156, 1056849.2068729969);
			feature45(extrusionheight(data45), 1285269.9194888566, -20645.914597106253);
			feature46(extrusionheight(data46), 472521.9881686502, 557183.6101681254);
			feature47(extrusionheight(data47), -890925.8356598823, 396437.06952910067);
		}
	}
}
