use <utils/build_plate.scad>
use <write/Write.scad>

/////////////////////////////////////////////////////////////////////////////////////////
/*								CUSTOMIZER CONTROLS									   */
/////////////////////////////////////////////////////////////////////////////////////////

// preview[view:south, tilt:top]

/*[Shape]*/
box_shape = 1; //[1:Heart,2:Bunny,3:Cat,4:Puppy,5:MakerBot Logo,0:Custom]
//Pick "Custom" from the list above, then draw your own shape here! (Press the "Clear" button below to get rid of the default star)
custom_shape = [[[-15.108665,13.315063],[-49.984974,8.760868],[-24.446339,-15.423332],[-30.892416,-50.000000],[0.000000,-33.184643],[30.892416,-50.000004],[24.446342,-15.423340],[49.984974,8.760864],[15.108676,13.315056],[0.000006,45.077072]],[[0,1,2,3,4,5,6,7,8,9]]]; //[draw_polygon:100x100]

/*[Settings]*/
//in mm
box_maximum_length_or_width = 80; //[40:120]
box_height = 20; //[10:50]
//in mm
box_top_height = 10; //[10:50]
//in mm, .5 should be a good value for a tuned printer
tolerance = .5; //[.25,.3,.35,.4,.45,.5,.55,.6,.65,.7,.75,.8,.85,.9,.95,1]


/*[Build Plate]*/
//for display only, doesn't contribute to final object
build_plate_selector = 0; //[0:Replicator 2,1: Replicator,2:Thingomatic]

/*[Hidden]*/
wall_thickness = .8 * 2 + tolerance;

/////////////////////////////////////////////////////////////////////////////////////////
/*										CODE										   */
/////////////////////////////////////////////////////////////////////////////////////////

build_plate(build_plate_selector);


if(box_shape != 0)
{
	translate([-(box_maximum_length_or_width/2 + 5),0,0]){
		if(box_shape != 2)
		{
			translate([0, -box_maximum_length_or_width/2, 0])
			box(preset_shapes()[box_shape], box_height, wall_thickness, tolerance, box_maximum_length_or_width);
		}
		else
		{
			box(preset_shapes()[box_shape], box_height, wall_thickness, tolerance, box_maximum_length_or_width/100);
		}
		translate([(box_maximum_length_or_width/2 + 5) * 2,0,0])
		{
			if(box_shape != 2)
			{
				translate([0, -box_maximum_length_or_width/2, 0])
				top(preset_shapes()[box_shape], box_top_height, wall_thickness, tolerance, box_maximum_length_or_width);
			}
			else
			{
				top(preset_shapes()[box_shape], box_top_height, wall_thickness, tolerance, box_maximum_length_or_width/100);
			}
		}
	}
}
else
{
	if(len(custom_shape) != 0)
	{
		translate([-(box_maximum_length_or_width/2 + 5),0,0]){
			box(custom_shape, box_height, wall_thickness, tolerance, box_maximum_length_or_width/100);
			translate([(box_maximum_length_or_width/2 + 5) * 2,0,0])
			{
				top(custom_shape, box_top_height, wall_thickness, tolerance, box_maximum_length_or_width/100);
			}
		}
	}
	else
	{
		write("<----------Draw a Shape!",space=1.05,center = true,font = "write/orbitron.dxf");
	}
}

function preset_shapes() =	[
								[custom_shape[0],custom_shape[1]],
								[heart_points(),heart_paths()],
								[bunny_points(),bunny_paths()],
								[cat_points(),cat_paths()],
								[puppy_points(),puppy_paths()],
								[makerbot_logo_points(),makerbot_logo_paths()]
							];

module outset
(
	shape,
	path_index,
	dist,
	scale = 1
)
{
	minkowski(){
		scale([scale,scale])
		polygon(points = shape[0], paths = [shape[1][path_index]], convexity = 10);
		circle(r=dist);
	}
}

module top
(
	shape,
	top_height,
	wall_thickness,
	tolerance,
	scale = 1
)
{
	scale([-1,1,1])
	if(len(shape[0])>3){
		linear_extrude(height=wall_thickness)
			difference(){
				outset(shape,0,.5, scale);
				for(i = [1:len(shape[1])-1]){	
					if(i!=0){
						outset(shape,i,1,scale);
					}
				}
			}
	
		for(i = [0:len(shape[1])-1]){	
		
			linear_extrude(height=top_height-5)
				difference(){
					outset(shape,i,wall_thickness,scale);
					scale([scale,scale])
					polygon(points=shape[0], paths=[shape[1][i]]);
				}
		
		}
		for(i = [0:len(shape[1])-1]){	
		
			linear_extrude(height=top_height)
				difference(){
					outset(shape,i,wall_thickness,scale);
					outset(shape,i,wall_thickness/2+tolerance/2,scale);
				}
		
		}
	}
}

module box
(
	shape,
	box_height,
	wall_thickness,
	tolerance,
	scale = 1
)
{
	if(len(shape[0])>3){
		linear_extrude(height=wall_thickness)
			difference(){
				outset(shape,0,.5,scale);
				for(i = [1:len(shape[1])-1]){	
					if(i!=0){
						outset(shape,i,1,scale);
					}
				}
			}
	
		for(i = [0:len(shape[1])-1]){	
		
			linear_extrude(height=box_height)
				difference(){
					outset(shape,i,wall_thickness,scale);
					scale([scale,scale])
					polygon(points=shape[0], paths=[shape[1][i]]);
				}
		
		}
		for(i = [0:len(shape[1])-1]){	
		
			linear_extrude(height=box_height+5)
				difference(){
					outset(shape,i,wall_thickness/2-tolerance/2,scale);
					scale([scale,scale])
					polygon(points=shape[0], paths=[shape[1][i]]);
				}
		
		}
	}
}


function heart_paths() =	[
								[
									0,1,2,3,4,5,6,7,8,9,
									10,11,12,13,14,15,16,17,18,19,
									20,21,22,23,24,25,26,27,28,29,
									30,31,32,33,34,35,36,37,38,39,
									40,41,42,43,44,45,46,47,48,49,
									50,51,52,53,54,55,56,57,58,59
								]
							];
function heart_points() =	[
								[-0.024897,0.771800],[-0.062056,0.816890],
								[-0.108713,0.851484],[-0.162103,0.875055],
								[-0.219463,0.887075],[-0.278027,0.887019],
								[-0.335033,0.874357],[-0.387715,0.848564],
								[-0.433310,0.809111],[-0.469053,0.755472],
								[-0.492180,0.687120],[-0.499927,0.603527],
								[-0.494870,0.541554],[-0.481662,0.486261],
								[-0.461388,0.436896],[-0.435132,0.392709],
								[-0.403979,0.352949],[-0.369013,0.316865],
								[-0.331320,0.283705],[-0.291983,0.252719],
								[-0.252087,0.223155],[-0.212717,0.194263],
								[-0.174958,0.165291],[-0.139893,0.135488],
								[-0.105912,0.104824],[-0.080041,0.081848],
								[-0.059397,0.063219],[-0.041098,0.045596],
								[-0.022260,0.025637],[0.000000,0.000000],
								[0.022260,0.025637],[0.041098,0.045596],
								[0.059397,0.063219],[0.080041,0.081848],
								[0.105912,0.104824],[0.139893,0.135488],
								[0.174958,0.165291],[0.212717,0.194263],
								[0.252087,0.223155],[0.291983,0.252719],
								[0.331320,0.283705],[0.369013,0.316865],
								[0.403979,0.352949],[0.435132,0.392709],
								[0.461388,0.436896],[0.481662,0.486261],
								[0.494870,0.541554],[0.499927,0.603527],
								[0.492180,0.687120],[0.469053,0.755472],
								[0.433310,0.809111],[0.387715,0.848564],
								[0.335033,0.874357],[0.278027,0.887019],
								[0.219463,0.887075],[0.162103,0.875055],
								[0.108713,0.851484],[0.062056,0.816890],
								[0.024897,0.771800],[0.000000,0.716742]
							];

module heart(scale) {
	scale([scale,scale])
    polygon(points = heart_points(), paths = heart_paths());
};

function cat_paths() =	[
							[
								0,1,2,3,4,5,6,7,8,9,
								10,11,12,13,14,15,16,17,18,19,
								20,21,22,23,24,25,26,27,28,29,
								30,31,32,33,34,35,36,37,38,39,
								40,41,42,43,44,45,46,47,48,49,
								50,51,52,53,54,55,56,57,58,59,
								60,61,62,63,64,65,66,67,68,69,
								70,71,72,73,74,75,76,77,78,79,
								80,81,82,83,84,85,86,87,88,89,
								90,91,92,93,94,95,96,97,98,99,
								100,101,102,103,104,105,106,107,108,109,
								110,111,112,113,114,115,116,117,118,119,
								120,121,122,123,124,125,126,127,128,129,
								130,131,132,133,134,135,136,137,138,139,
								140,141,142,143,144,145,146,147,148,149,
								150,151,152,153,154,155,156,157,158,159,
								160,161,162,163,164,165,166,167,168,169,
								170,171,172,173,174,175,176,177,178,179,
								180,181,182,183,184,185,186,187,188,189,
								190,191,192,193,194,195,196,197,198,199,
								200,201,202,203,204,205,206,207,208,209,
								210,211,212,213,214,215,216,217,218,219,
								220,221,222,223,224,225,226,227,228,229,
								230,231,232,233,234,235,236,237,238,239,
								240,241,242,243,244,245,246,247,248,249,
								250,251,252,253,254,255,256,257,258,259,
								260,261,262,263,264,265,266,267,268,269,
								270,271,272,273,274,275,276,277,278,279,
								280,281,282,283,284,285,286,287,288,289,
								290,291,292,293,294,295,296,297,298,299,
								300,301,302,303,304,305,306,307,308,309,
								310,311,312,313,314,315,316,317,318,319,
								320,321
							]
						];
						
function cat_points() =	[
							[0.083266,0.920822],[0.080107,0.928329],[0.076776,0.935912],
							[0.073265,0.943523],[0.069570,0.951117],[0.065686,0.958645],
							[0.061606,0.966062],[0.057324,0.973320],[0.052836,0.980372],
							[0.048135,0.987173],[0.043216,0.993674],[0.038074,0.999830],
							[0.035729,0.989977],[0.034006,0.979513],[0.032775,0.968662],
							[0.031909,0.957647],[0.031279,0.946693],[0.030755,0.936024],
							[0.030210,0.925864],[0.029515,0.916435],[0.028540,0.907963],
							[0.027158,0.900670],[0.025240,0.894782],[0.022657,0.890521],
							[0.021149,0.889797],[0.018949,0.890089],[0.016137,0.891218],
							[0.012798,0.893006],[0.009013,0.895274],[0.004866,0.897844],
							[0.000438,0.900537],[-0.004187,0.903175],[-0.008927,0.905579],
							[-0.013700,0.907571],[-0.018422,0.908973],[-0.023011,0.909605],
							[-0.025028,0.908536],[-0.026432,0.905311],[-0.027336,0.900204],
							[-0.027854,0.893486],[-0.028100,0.885432],[-0.028189,0.876312],
							[-0.028233,0.866401],[-0.028346,0.855970],[-0.028643,0.845293],
							[-0.029238,0.834641],[-0.030243,0.824288],[-0.031773,0.814506],
							[-0.032436,0.811696],[-0.033347,0.808606],[-0.034446,0.805234],
							[-0.035675,0.801573],[-0.036974,0.797621],[-0.038285,0.793373],
							[-0.039549,0.788825],[-0.040706,0.783973],[-0.041698,0.778812],
							[-0.042466,0.773339],[-0.042950,0.767549],[-0.043092,0.761438],
							[-0.042723,0.754917],[-0.041775,0.748569],[-0.040335,0.742391],
							[-0.038487,0.736379],[-0.036317,0.730529],[-0.033911,0.724838],
							[-0.031353,0.719303],[-0.028731,0.713918],[-0.026128,0.708682],
							[-0.023632,0.703590],[-0.021326,0.698638],[-0.019298,0.693823],
							[-0.017522,0.688955],[-0.015952,0.683902],[-0.014642,0.678747],
							[-0.013643,0.673572],[-0.013009,0.668461],[-0.012792,0.663497],
							[-0.013044,0.658762],[-0.013818,0.654341],[-0.015166,0.650314],
							[-0.017142,0.646767],[-0.019797,0.643781],[-0.023184,0.641440],
							[-0.026025,0.640267],[-0.032114,0.637936],[-0.041009,0.634537],
							[-0.052268,0.630157],[-0.065449,0.624887],[-0.080110,0.618813],
							[-0.095810,0.612027],[-0.112106,0.604615],[-0.128557,0.596668],
							[-0.144721,0.588273],[-0.160155,0.579520],[-0.174419,0.570497],
							[-0.188510,0.558935],[-0.203587,0.542890],[-0.219378,0.522983],
							[-0.235612,0.499837],[-0.252017,0.474074],[-0.268323,0.446317],
							[-0.284257,0.417186],[-0.299549,0.387305],[-0.313926,0.357295],
							[-0.327118,0.327779],[-0.338854,0.299379],[-0.348861,0.272717],
							[-0.353207,0.258732],[-0.356408,0.244597],[-0.358469,0.230305],
							[-0.359396,0.215852],[-0.359195,0.201231],[-0.357873,0.186437],
							[-0.355435,0.171465],[-0.351888,0.156310],[-0.347239,0.140966],
							[-0.341492,0.125428],[-0.334654,0.109690],[-0.326732,0.093748],
							[-0.316833,0.079234],[-0.304276,0.067614],[-0.289382,0.058632],
							[-0.272475,0.052030],[-0.253876,0.047548],[-0.233909,0.044930],
							[-0.212895,0.043918],[-0.191157,0.044254],[-0.169017,0.045680],
							[-0.146798,0.047939],[-0.124821,0.050772],[-0.103410,0.053921],
							[-0.082474,0.056697],[-0.060405,0.058806],[-0.037588,0.060226],
							[-0.014413,0.060935],[0.008733,0.060914],[0.031462,0.060139],
							[0.053388,0.058590],[0.074122,0.056245],[0.093276,0.053084],
							[0.110463,0.049084],[0.125295,0.044224],[0.137385,0.038484],
							[0.147233,0.032487],[0.155684,0.026895],[0.162867,0.021738],
							[0.168912,0.017050],[0.173950,0.012862],[0.178109,0.009205],
							[0.181519,0.006111],[0.184310,0.003612],[0.186611,0.001739],
							[0.188553,0.000524],[0.190265,0.000000],[0.191876,0.000197],
							[0.193102,0.001251],[0.193613,0.003195],[0.193470,0.005909],
							[0.192734,0.009271],[0.191465,0.013162],[0.189723,0.017461],
							[0.187571,0.022047],[0.185067,0.026800],[0.182274,0.031600],
							[0.179251,0.036325],[0.176060,0.040855],[0.172762,0.045070],
							[0.165316,0.052959],[0.156718,0.060342],[0.147318,0.067217],
							[0.137466,0.073581],[0.127511,0.079428],[0.117804,0.084758],
							[0.108694,0.089565],[0.100531,0.093847],[0.093666,0.097600],
							[0.088447,0.100822],[0.085226,0.103507],[0.084351,0.105654],
							[0.085806,0.106953],[0.089154,0.107222],[0.094121,0.106644],
							[0.100433,0.105404],[0.107812,0.103686],[0.115985,0.101675],
							[0.124677,0.099554],[0.133611,0.097509],[0.142514,0.095723],
							[0.151109,0.094381],[0.159121,0.093666],[0.166277,0.093764],
							[0.178951,0.095388],[0.188669,0.097721],[0.195826,0.100608],
							[0.200816,0.103894],[0.204032,0.107423],[0.205869,0.111040],
							[0.206720,0.114590],[0.206980,0.117917],[0.207043,0.120867],
							[0.207303,0.123283],[0.208155,0.125011],[0.209991,0.125895],
							[0.216007,0.127170],[0.221042,0.128797],[0.225182,0.130749],
							[0.228514,0.133000],[0.231123,0.135524],[0.233095,0.138294],
							[0.234518,0.141285],[0.235476,0.144470],[0.236057,0.147822],
							[0.236346,0.151315],[0.236430,0.154924],[0.236395,0.158620],
							[0.235851,0.161375],[0.234345,0.164647],[0.231936,0.168293],
							[0.228685,0.172169],[0.224651,0.176130],[0.219894,0.180032],
							[0.214473,0.183731],[0.208448,0.187082],[0.201878,0.189941],
							[0.194824,0.192164],[0.187344,0.193606],[0.179499,0.194122],
							[0.178374,0.196044],[0.176703,0.201503],[0.174608,0.210047],
							[0.172212,0.221222],[0.169638,0.234574],[0.167007,0.249648],
							[0.164443,0.265992],[0.162068,0.283151],[0.160005,0.300672],
							[0.158375,0.318101],[0.157303,0.334983],[0.156909,0.350866],
							[0.158783,0.354645],[0.163983,0.362117],[0.181805,0.386330],
							[0.193152,0.402168],[0.205270,0.419892],[0.217521,0.439049],
							[0.229268,0.459189],[0.239871,0.479860],[0.248692,0.500610],
							[0.255093,0.520988],[0.258436,0.540542],[0.259124,0.558521],
							[0.258068,0.574109],[0.255459,0.587644],[0.251488,0.599466],
							[0.246347,0.609912],[0.240228,0.619323],[0.233323,0.628037],
							[0.225823,0.636393],[0.217920,0.644730],[0.209806,0.653387],
							[0.201673,0.662704],[0.193712,0.673018],[0.190479,0.680158],
							[0.190386,0.687578],[0.192937,0.695131],[0.197637,0.702666],
							[0.203990,0.710037],[0.211501,0.717093],[0.219674,0.723688],
							[0.228013,0.729671],[0.236023,0.734896],[0.243208,0.739213],
							[0.249072,0.742473],[0.253121,0.744529],[0.254996,0.745823],
							[0.256464,0.747683],[0.257570,0.750044],[0.258359,0.752839],
							[0.258876,0.756002],[0.259166,0.759466],[0.259272,0.763166],
							[0.259241,0.767034],[0.259117,0.771005],[0.258945,0.775012],
							[0.258770,0.778989],[0.258637,0.782870],[0.258682,0.786793],
							[0.258965,0.790919],[0.259408,0.795210],[0.260477,0.804138],
							[0.260952,0.808701],[0.261286,0.813281],[0.261405,0.817841],
							[0.261233,0.822343],[0.260694,0.826750],[0.259714,0.831026],
							[0.258217,0.835133],[0.256021,0.838878],[0.253246,0.841739],
							[0.249987,0.843827],[0.246337,0.845252],[0.242390,0.846124],
							[0.238239,0.846555],[0.233979,0.846654],[0.229703,0.846533],
							[0.225504,0.846303],[0.221476,0.846072],[0.217714,0.845954],
							[0.214310,0.846057],[0.206308,0.857845],[0.197858,0.868486],
							[0.188949,0.877987],[0.179569,0.886355],[0.169707,0.893598],
							[0.159353,0.899724],[0.148494,0.904740],[0.137121,0.908654],
							[0.125222,0.911473],[0.112786,0.913205],[0.099802,0.913857],
							[0.086258,0.913437]
						];
module cat(scale) {
	scale([scale,scale])
    polygon(points = cat_points(), paths = cat_paths());
};

function bunny_paths() =	[
								[
									0,1,2,3,4,5,6,7,8,9,
									10,11,12,13,14,15,16,17,18,19,
									20,21,22,23,24,25,26,27,28,29,
									30,31,32,33,34,35,36,37,38,39,
									40,41,42,43,44,45,46,47,48,49,
									50,51,52,53,54,55,56,57,58,59,
									60,61,62,63,64,65,66,67,68,69,
									70,71,72,73,74,75,76,77,78,79,
									80,81,82,83,84,85,86,87,88,89,
									90,91,92,93,94,95,96,97,98,99,
									100,101,102,103,104,105,106,107,108,109,
									110,111,112,113,114,115,116,117,118,119,
									120,121,122,123,124,125,126,127
								]
							];

function bunny_points() =	[
								[-30.607849,-48.473831],[-38.714745,-48.950043],
								[-40.559818,-48.486679],[-42.201851,-47.493645],
								[-47.306175,-42.282654],[-50.067959,-38.508476],
								[-47.496841,-39.749046],[-46.892071,-39.806171],
								[-46.653542,-39.556297],[-49.260830,-36.213120],
								[-49.681732,-34.902710],[-49.585598,-33.782043],
								[-49.138451,-33.165283],[-48.672112,-33.207165],
								[-46.200596,-35.658916],[-47.279457,-33.120216],
								[-47.321926,-32.230251],[-46.990898,-31.375122],
								[-45.878410,-30.094749],[-43.224831,-28.013985],
								[-42.217957,-27.615326],[-41.118553,-27.667067],
								[-40.805717,-27.398746],[-40.440659,-25.661360],
								[-39.173859,-13.378041],[-37.786060,-6.545761],
								[-36.585690,-3.203835],[-34.921036,-0.177278],
								[-32.697136,2.334522],[-31.352158,3.341671],
								[-28.276741,4.879042],[-24.862782,5.878342],
								[-21.320715,6.457005],[-16.227745,6.793123],
								[-6.193724,6.651176],[-3.917368,6.182596],
								[1.149520,4.628635],[3.496422,4.354591],
								[5.367534,4.861082],[8.187830,6.665401],
								[10.588829,7.390333],[11.411912,7.954811],
								[11.835903,9.095350],[12.399237,12.947439],
								[13.889902,16.162262],[13.933737,17.683546],
								[13.316607,19.065596],[11.898010,21.208532],
								[6.859921,27.302176],[5.617778,29.462534],
								[5.115950,31.361303],[3.388903,42.964180],
								[3.273381,46.066513],[3.726890,48.114418],
								[4.978456,49.315399],[7.242655,49.967201],
								[8.609360,50.079552],[9.707384,49.859634],
								[11.739238,48.611275],[14.175842,46.044868],
								[16.663437,42.226387],[17.125431,47.022690],
								[17.457367,48.010414],[17.989151,48.348061],
								[19.181324,47.905319],[24.528868,44.299988],
								[25.586594,43.349907],[26.602041,41.795021],
								[27.508392,39.332878],[29.795576,26.542974],
								[30.282230,24.476656],[31.117352,22.414083],
								[31.720629,21.625368],[32.642006,21.057058],
								[35.131134,20.683912],[36.914520,20.059973],
								[39.043831,18.184668],[42.450657,14.071085],
								[46.617176,8.405781],[48.564854,5.175398],
								[49.817593,2.084951],[50.067959,0.425432],
								[49.656380,-0.983798],[48.150597,-2.837172],
								[45.817619,-4.786176],[42.303886,-6.914544],
								[36.506889,-8.046309],[35.342590,-8.523187],
								[34.626579,-9.248261],[34.336266,-10.490269],
								[34.565552,-12.031119],[35.052368,-13.404231],
								[37.089733,-17.042198],[37.317879,-18.115067],
								[37.155357,-19.071182],[35.604301,-21.320902],
								[33.913990,-23.043991],[33.883816,-28.314064],
								[33.082306,-30.108660],[31.550901,-32.176041],
								[30.204401,-33.504837],[26.342428,-35.397213],
								[25.570063,-36.226906],[25.784672,-37.377975],
								[26.657942,-38.691196],[35.016315,-47.244415],
								[36.307613,-48.865204],[36.517559,-49.673759],
								[35.642605,-50.079552],[30.526541,-50.070801],
								[27.432796,-49.786285],[24.770382,-49.194931],
								[21.059244,-47.649162],[13.547039,-43.090836],
								[12.276370,-42.541962],[10.688703,-42.258522],
								[3.786492,-43.914528],[2.470330,-44.603432],
								[2.196272,-45.124454],[2.270218,-46.117500],
								[3.513528,-49.225983],[3.376098,-49.617065],
								[2.794866,-49.836327],[-5.766325,-50.020004],
								[-18.879635,-49.768524],[-25.214447,-49.130280],
								[-29.151905,-47.714996],[-30.600498,-48.472359]
							];

module bunny(scale) {
	scale([scale/100,scale/100])
    polygon(points = bunny_points(), paths = bunny_paths());
};

function puppy_paths() =	[
								[
									0,1,2,3,4,5,6,7,8,9,
									10,11,12,13,14,15,16,17,18,19,
									20,21,22,23,24,25,26,27,28,29,
									30,31,32,33,34,35,36,37,38,39,
									40,41,42,43,44,45,46,47,48,49,
									50,51,52,53,54,55,56,57,58,59,
									60,61,62,63,64,65,66,67,68,69,
									70,71,72,73,74,75,76,77,78,79,
									80,81,82,83,84,85,86,87,88,89,
									90,91,92,93,94,95,96,97,98,99,
									100,101,102,103,104,105,106,107,108,109,
									110,111,112,113,114,115,116,117,118,119,
									120,121,122,123,124,125,126,127,128,129,
									130,131,132,133,134,135,136,137,138,139,
									140,141,142,143,144,145,146,147,148,149,
									150,151,152,153,154,155,156,157,158,159,
									160,161,162,163,164,165,166,167,168,169,
									170
								]
							];
							
function puppy_points() =	[
								[0.214769,0.999967],[0.233610,0.998491],
								[0.251091,0.992824],[0.264295,0.985496],
								[0.291107,0.962279],[0.299199,0.959167],
								[0.311654,0.957166],[0.334319,0.959246],
								[0.367133,0.968733],[0.371305,0.977100],
								[0.382527,0.983655],[0.390574,0.983982],
								[0.403944,0.980479],[0.409614,0.975795],
								[0.411297,0.967831],[0.410093,0.960024],
								[0.416119,0.953508],[0.423041,0.939110],
								[0.427735,0.920957],[0.431130,0.894401],
								[0.430138,0.877309],[0.428056,0.870198],
								[0.421546,0.858314],[0.413006,0.848831],
								[0.391431,0.830010],[0.347178,0.783897],
								[0.272816,0.715358],[0.249542,0.686087],
								[0.243767,0.675569],[0.238785,0.659747],
								[0.238019,0.642795],[0.240686,0.624786],
								[0.246002,0.605795],[0.278063,0.521498],
								[0.284857,0.498713],[0.289594,0.475394],
								[0.291490,0.451614],[0.289761,0.427447],
								[0.285200,0.404839],[0.272402,0.368896],
								[0.256565,0.342343],[0.224691,0.303123],
								[0.213115,0.283312],[0.209393,0.271794],
								[0.206262,0.253289],[0.205442,0.211027],
								[0.210716,0.163393],[0.217687,0.131143],
								[0.227334,0.120500],[0.254792,0.105901],
								[0.266567,0.097965],[0.273016,0.086953],
								[0.271952,0.074811],[0.269276,0.070957],
								[0.260962,0.065742],[0.225854,0.058772],
								[0.223210,0.053624],[0.223200,0.042247],
								[0.220529,0.035049],[0.215845,0.029442],
								[0.201457,0.020480],[0.182584,0.014527],
								[0.161879,0.011588],[0.133187,0.012844],
								[0.119505,0.017464],[0.106409,0.027214],
								[0.096398,0.038870],[0.089086,0.052176],
								[0.084087,0.066877],[0.079485,0.099439],
								[0.081096,0.204014],[0.025572,0.175869],
								[-0.000594,0.159484],[-0.023963,0.136235],
								[-0.031462,0.124948],[-0.034705,0.116245],
								[-0.033685,0.104382],[-0.028458,0.096554],
								[-0.024050,0.093313],[-0.013652,0.090391],
								[0.010444,0.090545],[0.022410,0.088905],
								[0.027993,0.086625],[0.037309,0.079094],
								[0.047640,0.067011],[0.054276,0.053850],
								[0.056521,0.039057],[0.055232,0.028015],
								[0.034509,0.021402],[-0.016468,0.010108],
								[-0.059580,0.003473],[-0.104614,0.000000],
								[-0.126413,0.000105],[-0.178421,0.005644],
								[-0.207775,0.009925],[-0.234936,0.016318],
								[-0.259811,0.026513],[-0.271364,0.033565],
								[-0.292642,0.052630],[-0.302344,0.065066],
								[-0.338525,0.058431],[-0.360897,0.057084],
								[-0.384245,0.061140],[-0.404273,0.070127],
								[-0.414608,0.076823],[-0.430904,0.092131],
								[-0.437114,0.100581],[-0.446281,0.118664],
								[-0.451946,0.137782],[-0.456059,0.166978],
								[-0.455576,0.180705],[-0.452177,0.195295],
								[-0.446213,0.210010],[-0.438038,0.224111],
								[-0.428005,0.236861],[-0.416465,0.247521],
								[-0.403772,0.255355],[-0.390279,0.259623],
								[-0.376337,0.259588],[-0.362299,0.254512],
								[-0.348518,0.243657],[-0.335347,0.226285],
								[-0.352114,0.222000],[-0.365892,0.215499],
								[-0.376599,0.206511],[-0.380776,0.200999],
								[-0.386726,0.187768],[-0.388479,0.179981],
								[-0.389490,0.161894],[-0.387096,0.145806],
								[-0.376766,0.123640],[-0.365569,0.112092],
								[-0.351070,0.104662],[-0.342622,0.102904],
								[-0.323405,0.104120],[-0.330357,0.123515],
								[-0.333958,0.144469],[-0.335186,0.165784],
								[-0.334376,0.193639],[-0.326326,0.227496],
								[-0.315466,0.256079],[-0.299834,0.285966],
								[-0.290128,0.300460],[-0.266732,0.326672],
								[-0.179408,0.392272],[-0.106814,0.455311],
								[-0.061761,0.499546],[-0.040222,0.523294],
								[-0.005434,0.567177],[0.015585,0.586334],
								[-0.013136,0.595722],[-0.035261,0.608974],
								[-0.044221,0.617057],[-0.047713,0.622632],
								[-0.052605,0.636713],[-0.055966,0.673013],
								[-0.053096,0.723710],[-0.046138,0.746680],
								[-0.034200,0.771292],[-0.018069,0.795976],
								[0.001471,0.819161],[0.023637,0.839278],
								[0.035459,0.847695],[0.041719,0.879468],
								[0.049382,0.902860],[0.062412,0.927909],
								[0.082420,0.951650],[0.105945,0.968810],
								[0.136881,0.984294],[0.174566,0.995844],
								[0.209366,0.999889]
							];
module puppy(scale) {
	scale([scale,scale])
    polygon(points = puppy_points(), paths = puppy_paths());
};

function makerbot_logo_paths() =	[
										[
											0,1,2,3,4,5,6,7,8,9,
											10,11,12,13,14,15,16,17,18,19,
											20,21,22,23,24,25,26,27,28,29,
											30,31,32,33,34,35,36,37,38,39,
											40,41,42,43,44,45,46,47,48,49,
											50,51,52,53,54,55,56,57,58,59,
											60,61,62,63,64,65,66,67,68,69,
											70,71,72,73,74,75,76,77,78
										]
									];
									
function makerbot_logo_points() =	[
										[-0.241359,0.078300],[-0.239642,0.099592],
										[-0.239642,0.802544],[-0.096716,0.802544],
										[-0.095994,0.085157],[-0.092206,0.065308],
										[-0.087877,0.053280],[-0.078678,0.037049],
										[-0.066280,0.023051],[-0.056576,0.015427],
										[-0.040067,0.006854],[-0.021210,0.001713],
										[0.000000,0.000000],[0.021206,0.001713],
										[0.040068,0.006854],[0.056585,0.015427],
										[0.066293,0.023051],[0.078696,0.037049],
										[0.087896,0.053280],[0.092224,0.065308],
										[0.096009,0.085157],[0.096729,0.802544],
										[0.239680,0.802544],[0.239680,0.099592],
										[0.242725,0.071684],[0.249008,0.053280],
										[0.255103,0.042218],[0.262724,0.032121],
										[0.276726,0.019048],[0.287310,0.012187],
										[0.304994,0.004759],[0.317989,0.001713],
										[0.339291,0.000000],[0.353267,0.000783],
										[0.372495,0.004890],[0.384159,0.009584],
										[0.399931,0.019556],[0.409301,0.028157],
										[0.420985,0.043172],[0.429335,0.060084],
										[0.433048,0.072411],[0.436019,0.099592],
										[0.435578,0.794419],[0.432047,0.823287],
										[0.424986,0.850713],[0.414396,0.876696],
										[0.400280,0.901234],[0.372494,0.935331],
										[0.338923,0.963757],[0.301746,0.984058],
										[0.260963,0.996237],[0.216575,1.000296],
										[-0.216550,1.000296],[-0.260951,0.996237],
										[-0.301739,0.984058],[-0.338911,0.963757],
										[-0.372469,0.935331],[-0.400270,0.901234],
										[-0.420120,0.863885],[-0.432026,0.823287],
										[-0.435993,0.779445],[-0.435993,0.099592],
										[-0.434325,0.078300],[-0.431359,0.065308],
										[-0.424127,0.047628],[-0.417450,0.037049],
										[-0.404721,0.023051],[-0.394898,0.015427],
										[-0.384151,0.009330],[-0.366299,0.003045],
										[-0.353244,0.000761],[-0.331929,0.000190],
										[-0.311361,0.003045],[-0.298850,0.006854],
										[-0.276710,0.019048],[-0.262703,0.032121],
										[-0.255085,0.042218],[-0.246509,0.059174],
										[-0.242695,0.071684]
									];
									
module makerbot_logo(scale) {
	scale([scale,scale])
    polygon(points = makerbot_logo_points(), paths = makerbot_logo_paths());
};