//============================================================
// OpenSCAD Project
// This is to help you to build with OpenStructures project
// OpenStructures Project - http://openstructures.net/
//============================================================

// This Script must be used with "include"
// include <OpenStructures_Grid_Rule_LC.scad>;

// Extend as you wish

//------------------------------------------------------------
// Grid Rule
//------------------------------------------------------------
module Grid_Rule_LC()
{

	difference()
	{
		square([Grid,Grid]);

		_Holes_LC();
	}

}

//------------------------------------------------------------
// L Grid Rule
//------------------------------------------------------------
module L_Grid_Rule_LC()
{

	Grid_Rule_LC();

	translate([Grid,0,0])
		Grid_Rule_LC();

	translate([Grid,Grid,0])
		Grid_Rule_LC();

}

//------------------------------------------------------------
// I Grid Rule
//------------------------------------------------------------
module I_Grid_Rule_LC()
{

	Grid_Rule_LC();

	translate([Grid,0,0])
		Grid_Rule_LC();

	translate([2*Grid,0,0])
		Grid_Rule_LC();

}

//------------------------------------------------------------
// O Grid Rule
//------------------------------------------------------------
module O_Grid_Rule_LC()
{

	I_Grid_Rule_LC();

	translate([0,2*Grid,0])
		I_Grid_Rule_LC();

	translate([2*Grid,Grid,0])
		Grid_Rule_LC();

	translate([0,Grid,0])
		Grid_Rule_LC();

}

//------------------------------------------------------------
// T Grid Rule
//------------------------------------------------------------
module T_Grid_Rule_LC()
{

	L_Grid_Rule_LC();

	translate([2*Grid,0,0])
		Grid_Rule_LC();

}

//------------------------------------------------------------
// H Grid Rule
//------------------------------------------------------------
module H_Grid_Rule_LC()
{

	T_Grid_Rule_LC();

	translate([0,2*Grid,0])
		Grid_Rule_LC();

	translate([Grid,2*Grid,0])
		Grid_Rule_LC();

	translate([2*Grid,2*Grid,0])
		Grid_Rule_LC();

}

//------------------------------------------------------------
// X Grid Rule
//------------------------------------------------------------
module X_Grid_Rule_LC()
{

	T_Grid_Rule_LC();

	translate([Grid,-Grid,0])
		Grid_Rule_LC();

}

//------------------------------------------------------------
// Z Grid Rule
//------------------------------------------------------------
module Z_Grid_Rule_LC()
{

	L_Grid_Rule_LC();

	translate([2*Grid,Grid,0])
		Grid_Rule_LC();

}

//------------------------------------------------------------
// Y Grid Rule
//------------------------------------------------------------
module Y_Grid_Rule_LC()
{

	Z_Grid_Rule_LC();

	translate([Grid,2*Grid,0])
		Grid_Rule_LC();

	translate([0,2*Grid,0])
		Grid_Rule_LC();

}

//------------------------------------------------------------
// 3x3 Grid Rule
//------------------------------------------------------------
module 3x3_Grid_Rule_LC()
{

	O_Grid_Rule_LC();

	translate([Grid,Grid,0])
		Grid_Rule_LC();

}


//------------------------------------------------------------
// 60cm Grid Rule
// Big Laser Cut...
// 12x4cm = 60cm
//------------------------------------------------------------
module 60_Grid_Rule_LC()
{

	for ( i = [0 : 1 : 11] )
	{
		for ( j = [0 : 1 : 11] )
		{
			translate([i*Grid,j*Grid,0])
				Grid_Rule_LC();

		}

	}

}
//==EOF=======================================================