//============================================================
// OpenSCAD Project
// This is to help you to build with OpenStructures project
// OpenStructures Project - http://openstructures.net/
//============================================================

// Open Strucure Main Script
// One Script to rule them all

// Include all scrit
// Open them in Notepad++ for exemple, to work on them
include <OpenStructures_Holes_Library.scad>;	// must be improve
include <OpenStructures_Cube_Rule.scad>;
include <OpenStructures_Grid_Rule.scad>;
include <OpenStructures_Grid_Rule_LC.scad>;	// Laser Cut Library
include <OpenStructures_L_Bracket.scad>;
include <OpenStructures_Round_Grid.scad>;
include <OpenStructures_Bumper.scad>;

//------------------------------------------------------------
// Parameters in millimeter - Recommended values see comment
//------------------------------------------------------------
$fn = 150 ;			// OpenSCAD Resolution
Epsilon = 0.15 ;	// Printer 3D resolution

hd = 5;					// hole diameter in mm
hr = hd/2;			// hole radius

Grid = 40;			// Mendatory, The Grid Base 4x4cm
Thikness = 5;		// must be compatible with rules
							// apply to all pieces except Laser Cut


//------------------------------------------------------------
//
//------------------------------------------------------------
Main();					// Execute the Main module

//------------------------------------------------------------
// Main
// To build what you want
//------------------------------------------------------------
module Main()
{

	View();		// for export, comment if not needed

	// Exemple
	//My_Build();

	// To do : improve
	// Printer volume to see if it's ok
	//%cube([120,120,130],center=false);


	//Cube_Rule();

}

//------------------------------------------------------------
// My Build
// Exemple
//------------------------------------------------------------
module My_Build()
{

	Show_Cube();

	translate([0,2*Grid+Thikness,0]) rotate([90,0,0])

	union()
	{
		// ground
		X_Grid_Rule();

		// Upper
		translate([0,0,3*Grid+Thikness])
			O_Grid_Rule();

		// Back
		translate([0,0,Thikness])
			rotate([0,-90,0])
				I_Grid_Rule();

		// Front
		translate([3*Grid+Thikness,0,Thikness])
			rotate([0,-90,0])
				I_Grid_Rule();

		// Add corner
		translate([-Thikness,0,0])
			Out_Add();

		translate([-Thikness,0,3*Grid+Thikness])
			Out_Add();

		translate([3*Grid,0,3*Grid+Thikness])
			Out_Add();

		translate([3*Grid,0,0])
			Out_Add();
	}

}

//------------------------------------------------------------
// View
// Uncomment the piece you want to export
//------------------------------------------------------------
module View();
{
	//Cube_Rule();

	//Grid_Rule();

	//H_Grid_Rule();
	//I_Grid_Rule();
	//L_Grid_Rule();
	O_Grid_Rule();
	//T_Grid_Rule();
	//X_Grid_Rule();
	//Y_Grid_Rule();
	//Z_Grid_Rule();

	//XxY_Grid_Rule(X=5,Y=3);		// Work in progress
	//3x3_Grid_Rule();
	//60_Grid_Rule();

	//Grid_Rule_LC();

	//H_Grid_Rule_LC();
	//I_Grid_Rule_LC();
	//L_Grid_Rule_LC();
	//O_Grid_Rule_LC();
	//T_Grid_Rule_LC();
	//X_Grid_Rule_LC();
	//Y_Grid_Rule_LC();
	//Z_Grid_Rule_LC();

	//3x3_Grid_Rule_LC();		// Work in progress
	//60_Grid_Rule_LC();

	//in_L_Bracket(N=1);		// Work in progress
	//out_L_Bracket(N=3);		// Work in progress
	//out_L_A();		// Work in progress
	//out_L_B();		// Work in progress
	//out_L_C();		// Work in progress

	//Round_Grid();		// Work in progress

	//Bumper_Dome();		// Work in progress

}

//==EOF=======================================================