//============================================================
// OpenSCAD Project
// This is to help you to build with OpenStructures project
// OpenStructures Project - http://openstructures.net/
//============================================================

// This Script must be used with "include"
// include <OpenStructures_Hole_Library.scad>;

// Extend as you wish

//------------------------------------------------------------
// For 3D Printer
//------------------------------------------------------------
module _Hole(N=1)
{
// TO DO : Improve
	P = Grid * N;

	translate([0,0,P/2])
		cylinder(r=hr,h=P+Epsilon,center=true);
}


module _Holes(N=1)
{
	// center
	translate([Grid/2,Grid/2,0])
		_Hole(N=N);

	// in - 1x1 cm
	translate([Grid/4,Grid/4,0])
		_Hole(N=N);
	translate([Grid*3/4,Grid/4,0])
		_Hole(N=N);
	translate([Grid*3/4,Grid*3/4,0])
		_Hole(N=N);
	translate([Grid/4,Grid*3/4,0])
		_Hole(N=N);
/*		
// TO DO : Improve	- CHEESE	Need it ?
	// around
	translate([0,0,0])
		_Hole(N=N);
	translate([Grid,0,0])
		_Hole(N=N);
	translate([Grid,Grid,0])
		_Hole(N=N);
	translate([0,Grid,0])
		_Hole(N=N);

	translate([Grid/2,0,0])
		_Hole(N=N);
	translate([Grid/2,Grid,0])
		_Hole(N=N);
	translate([0,Grid/2,0])
		_Hole(N=N);
	translate([Grid,Grid/2,0])
		_Hole(N=N);
*/
		
}

//------------------------------------------------------------
// For Laser Cut
//------------------------------------------------------------
module _Hole_LC()
{
	circle(r=hr,center=true);
}

module _Holes_LC()
{
	// center
	translate([Grid/2,Grid/2,0])
		_Hole_LC();

	// corner - 1x1 cm
	translate([Grid/4,Grid/4,0])
		_Hole_LC();
	translate([Grid*3/4,Grid/4,0])
		_Hole_LC();
	translate([Grid*3/4,Grid*3/4,0])
		_Hole_LC();
	translate([Grid/4,Grid*3/4,0])
		_Hole_LC();
}

//==EOF=======================================================