//============================================================
// OpenSCAD Project
// This is to help you to build with OpenStructures project
// OpenStructures Project - http://openstructures.net/
//============================================================

// This Script must be used with "include"
// include <OpenStructures_Grid_Rule.scad>;

// Extend as you wish

//------------------------------------------------------------
// Grid Rule
//------------------------------------------------------------
module Grid_Rule()
{

	difference()
	{
		cube([Grid,Grid,Thikness]);

		_Holes();
	}

}

//------------------------------------------------------------
// H Grid Rule
//------------------------------------------------------------
module H_Grid_Rule()
{
	union()
	{
		T_Grid_Rule();

		translate([0,2*Grid,0])
			Grid_Rule();

		translate([Grid,2*Grid,0])
			Grid_Rule();

		translate([2*Grid,2*Grid,0])
			Grid_Rule();
	}
}

//------------------------------------------------------------
// I Grid Rule
//------------------------------------------------------------
module I_Grid_Rule()
{
	union()
	{
		Grid_Rule();

		translate([Grid,0,0])
			Grid_Rule();

		translate([2*Grid,0,0])
			Grid_Rule();
	}
}

//------------------------------------------------------------
// L Grid Rule
//------------------------------------------------------------
module L_Grid_Rule()
{
	union()
	{
		Grid_Rule();

		translate([Grid,0,0])
			Grid_Rule();

		translate([Grid,Grid,0])
			Grid_Rule();
	}
}

//------------------------------------------------------------
// O Grid Rule
//------------------------------------------------------------
module O_Grid_Rule()
{
	union()
	{
		I_Grid_Rule();

		translate([0,2*Grid,0])
			I_Grid_Rule();

		translate([2*Grid,Grid,0])
			Grid_Rule();

		translate([0,Grid,0])
			Grid_Rule();
	}
}

//------------------------------------------------------------
// T Grid Rule
//------------------------------------------------------------
module T_Grid_Rule()
{
	union()
	{
		L_Grid_Rule();

		translate([2*Grid,0,0])
			Grid_Rule();
	}
}

//------------------------------------------------------------
// X Grid Rule
//------------------------------------------------------------
module X_Grid_Rule()
{
	union()
	{
		T_Grid_Rule();

		translate([Grid,-Grid,0])
			Grid_Rule();
	}
}

//------------------------------------------------------------
// Y Grid Rule
//------------------------------------------------------------
module Y_Grid_Rule()
{
	union()
	{
		Z_Grid_Rule();

		translate([Grid,2*Grid,0])
			Grid_Rule();

		translate([0,2*Grid,0])
			Grid_Rule();
	}
}

//------------------------------------------------------------
// Z Grid Rule
//------------------------------------------------------------
module Z_Grid_Rule()
{
	union()
	{
		L_Grid_Rule();

		translate([2*Grid,Grid,0])
			Grid_Rule();
	}
}

//------------------------------------------------------------
// XxY Grid Rule
//------------------------------------------------------------
module XxY_Grid_Rule(X=1,Y=1)
{
	for (i=[0:1:X-1])
	{
		for (j=[0:1:Y-1])
		{
			translate([i*Grid,j*Grid,0])
				Grid_Rule();
		}
	}
	
	echo("X Y Grid Size : ", 4*X, "cm x ", 4*Y, "cm"); 
}

//------------------------------------------------------------
// 3x3 Grid Rule
//------------------------------------------------------------
module 3x3_Grid_Rule()
{
	union()
	{
		O_Grid_Rule();

		translate([Grid,Grid,0])
			Grid_Rule();
	}
}

//------------------------------------------------------------
// 60cm Grid Rule
// Big printer...
//------------------------------------------------------------
module 60_Grid_Rule()
{
	XxY_Grid_Rule(X=15,Y=15);	// 15*4cm = 60cm
}

//==EOF=======================================================