/*
  Programmer : Brian Ho - OSD training scheme chapter 1 - Smart Traffic Light 
  Date :14th May, 2014
  Project name : 2 way communicate and control traffic light
                 arduino clent part software
                 1) Turn on the RED/AMBER/GREEN for car
                 2) When received Android phone call, the duration for green goto 5 sec
                 3) will send ak signal ask smart phone change icon for pedestrain
 */
 
// Define the traffic light output pins.

int ledgreen = 13;
int ledamber = 12;
int ledred = 11;
int x = 20 ; // define the green color for car time duration to 20sec
String readString; //initialize the receive string from BT

// the setup routine runs once when you press reset:
void setup() 
{                
  // initialize the digital pin as an output.
  pinMode(ledgreen, OUTPUT);
  pinMode(ledred, OUTPUT);
  pinMode(ledamber, OUTPUT); 
  Serial.begin(9600); // Setup the receiving speed at baud 9600 and which is common and for HC-06 default
  
}

      
// Main loop for arduino initial by loop()
void loop() 
    { 
              Serial.write("go"); //send the signal to receiving end cross the road
               Serial.flush();
              delay(100);
            
              
      digitalWrite(ledred, HIGH);   // turn the LED on (HIGH is the voltage level)
      delay(15000);               // wait for a 15 seconds
      digitalWrite(ledred, LOW);    // turn the LED off by making the voltage LOW
            
             Serial.write("stop"); // inform the pedestrain client ready to stop crossing
              Serial.flush();
             delay(100);
           
            
      digitalWrite(ledamber, HIGH);   // turn on amber for the driver ready to go
      delay(4000);                   //delay 4 second before turn green
      digitalWrite(ledamber,LOW);    //Turn off the amber light
      digitalWrite(ledgreen, HIGH);  //Turn on the green light for 30seconds let car driver moving forward
      

         for (x ; x > 0 ; x --)
             {   
                while (Serial.available())
                  {
                    char c = Serial.read(); // read the character from serial until empty
                    readString += c; // incrase the length of the text length for next character
                  }
                if (readString=="on")
                  {
                    x = 5; // when the commancd received, shorten the duration for green LED to 5 sec
                    readString =""; // clear the string temporary register
                  }
                    delay(1000); //delay one second
             }
      x = 20; // reset the green duration back to 20sec
    
    
      digitalWrite(ledgreen, LOW);   //Turn off the green light
      digitalWrite(ledamber,HIGH);   // Before go back to RED, give a transistion and turn on amber for 1 sec
      delay(3000);                  // delay 3 second
      digitalWrite(ledamber,LOW);   //turn off the amber and finished a cycle
                   
      
    }
