//------------------------------------------------------------
//	Stamp-o-Matic
//
//	input comes from:
//   http://chaaawa.com/stamp-o-matic/
//
//	http://thingiverse.com/Benjamin
//	http://www.thingiverse.com/thing:356988
//------------------------------------------------------------

// preview[view:south, tilt:top]

// paste here the Stamp-o-Matic output (see object page).
input = "no_input";

// (mm)
stamp_width = 60;
// (mm)
pattern_thickness = 1.25;
// (mm)
base_thickness = 8;
// margin around pattern (mm)
contour_radius = 2;

module void() {}

dispo_width = stamp_width - 2*contour_radius;

points_array = (input=="no_input"? [[191, 355, 2],[1,[[97,24.44],[97,24.44],[89.32,24.33],[83.361,24.468],[74.5,25.6],[74.5,25.6],[71.229,26.43],[67.5,27.546],[60.5,30.04],[60.5,30.04],[57.269,31.491],[53.648,33.307],[47,37.1],[47,37.1],[44.004,39.21],[40.648,41.877],[34.5,47.51],[34.5,47.51],[31.914,50.354],[29.31,53.491],[25.26,59.12],[25.26,59.12],[23.79,61.722],[22.193,64.831],[19.39,71],[19.39,71],[18.262,74.097],[17.13,77.721],[15.38,84.75],[15.38,84.75],[14.843,88.395],[14.405,92.957],[14,102.5],[14,102.5],[14.085,107.19],[14.32,112.195],[15.09,120.75],[15.09,120.75],[15.737,124.468],[16.706,128.866],[19.08,137.5],[19.08,137.5],[20.52,141.546],[22.29,145.912],[25.92,153.5],[25.92,153.5],[27.883,156.75],[30.328,160.427],[35.42,167.25],[35.42,167.25],[38.198,170.353],[41.638,173.818],[48.75,180.14],[48.75,180.14],[52.508,183.053],[57.015,186.443],[66,192.98],[66,192.98],[69.988,195.932],[73.831,199.011],[79.33,204.09],[79.33,204.09],[81.097,206.277],[83.072,208.968],[86.68,214.5],[86.68,214.5],[88.277,217.382],[90.033,220.793],[93.17,227.5],[93.17,227.5],[94.55,231.085],[96.105,235.674],[98.98,245.5],[98.98,245.5],[100.127,250.225],[101.156,254.958],[102.41,262.25],[103,268],[108.75,267.99],[108.75,267.99],[111.258,267.94],[113.84,267.818],[118,267.43],[121.5,266.87],[123,260.69],[123,260.69],[123.665,256.975],[124.122,252.115],[124.45,238.5],[124.45,238.5],[124.337,230.005],[123.983,223.887],[122.1,214],[122.1,214],[121.049,210.386],[119.882,206.823],[117.77,201.5],[117.77,201.5],[116.733,199.601],[115.416,197.387],[112.62,193.11],[112.62,193.11],[110.421,190.642],[106.745,187.163],[97,179.02],[97,179.02],[91.608,174.666],[86.162,169.988],[77.65,161.91],[77.65,161.91],[74.624,158.439],[71.452,154.473],[66.17,147],[66.17,147],[64.156,143.458],[62.101,139.355],[58.82,131.5],[58.82,131.5],[57.608,127.384],[56.504,122.552],[54.88,112],[54.88,112],[54.345,105.82],[54.162,100.185],[54.84,87.5],[54.84,87.5],[55.414,82.019],[56.103,76.705],[57.48,69],[57.48,69],[58.354,66.231],[59.658,62.763],[62.85,55.5],[62.85,55.5],[64.826,51.837],[67.095,48.252],[71.88,42.25],[71.88,42.25],[74.244,40.035],[76.893,37.888],[81.75,34.78],[81.75,34.78],[84.275,33.778],[86.919,33.085],[93.02,32.53],[93.02,32.53],[96.553,32.647],[99.535,33.117],[106.02,35.64],[106.02,35.64],[109.042,37.293],[111.938,39.238],[116.86,43.64],[116.86,43.64],[118.807,46.043],[120.897,48.986],[124.5,55],[124.5,55],[125.903,57.999],[127.292,61.355],[129.38,67.5],[129.38,67.5],[130.041,70.58],[130.673,74.53],[131.57,83],[131.57,83],[131.875,86.927],[132.251,90.592],[133.03,95.5],[133.03,95.5],[133.643,96.92],[134.68,98.572],[137.44,101.75],[137.44,101.75],[139.158,103.1],[141.202,104.372],[145.25,106.11],[145.25,106.11],[147.295,106.502],[149.721,106.75],[154.5,106.73],[154.5,106.73],[156.797,106.364],[159.355,105.729],[164,104.01],[164,104.01],[165.928,102.972],[167.847,101.802],[170.78,99.64],[170.78,99.64],[171.942,98.299],[172.626,96.703],[173.01,91],[173.01,91],[172.873,87.925],[172.543,84.355],[171.5,77.5],[171.5,77.5],[170.637,74.19],[169.377,70.355],[166.34,63],[166.34,63],[164.132,58.955],[161.519,55.171],[153.58,46.45],[153.58,46.45],[148.584,41.645],[144.425,38.201],[135,32.72],[135,32.72],[130.801,30.784],[126.385,28.955],[119,26.45],[119,26.45],[115.219,25.757],[110.07,25.171],[97,24.44]]],[1,[[114.5,292.06],[114.5,292.06],[112.631,292.183],[110.5,292.493],[106.5,293.49],[106.5,293.49],[104.536,294.429],[102.29,295.917],[97.75,299.95],[97.75,299.95],[95.405,302.635],[93.76,305.043],[91.87,310.25],[91.87,310.25],[91.386,313.036],[91.243,315.553],[91.99,321],[91.99,321],[92.835,323.96],[94.003,326.416],[98.38,331.57],[98.38,331.57],[101.147,334.127],[103.577,335.883],[109,337.94],[109,337.94],[111.433,338.399],[113.988,338.681],[118.25,338.62],[118.25,338.62],[120.001,338.232],[122,337.635],[125.75,336.14],[125.75,336.14],[127.462,335.113],[129.357,333.688],[132.77,330.39],[132.77,330.39],[134.117,328.603],[135.366,326.616],[137.01,323],[137.01,323],[137.389,321.327],[137.697,319.355],[137.98,315.5],[137.98,315.5],[137.877,313.631],[137.613,311.5],[136.76,307.5],[136.76,307.5],[135.939,305.555],[134.618,303.351],[131.03,298.97],[131.03,298.97],[128.911,297.063],[126.648,295.381],[122.5,293.24],[122.5,293.24],[120.631,292.775],[118.5,292.398],[114.5,292.06]]]]: input);

input_width = points_array[0][0];
input_height= points_array[0][1];
tVersion = points_array[0][2] == undef ? 0: points_array[0][2];
sTrace = dispo_width/input_width;
stamp_height = input_height*sTrace + 2*contour_radius;

contour_r = (contour_radius <= 0) ? 0.001 : contour_radius;
//-------------------------------------------------------------------------------
union() {
	color("gray")
	translate([0, 0, base_thickness + pattern_thickness/2 -0.01]) 
	buildFrom(len(points_array)-1);
	
	color("lightgray")
	outline();
}
//-------------------------------------------------------------------------------
module outline() {
	hull() {
		for (i=[1:len(points_array)-1]) {
			if (points_array[i][0] == 1) {
				linear_extrude(height=base_thickness)
				minkowski() {						// idea from Oskar Linde
					circle(r=contour_r, $fn=12); 	// in scad-utils/morphology.scad outset module.
					shape2dNum(i);
				}
			}
		}	
	}
}
//-------------------------------------------------------------------------------
module buildFrom(pIndex) {
	if (pIndex < len(points_array) && pIndex > 0) {
		if (points_array[pIndex][0] == 0) {
			difference() {
				buildFrom(pIndex-1);
				shapeNum(pIndex, 2);
			}
		}
		else {
			union() {
				buildFrom(pIndex-1);
				shapeNum(pIndex);
			}
		}
	}
}
//-------------------------------------------------------------------------------
module shapeNum(pNum, zFact=1) {
	scale([-sTrace, -sTrace, 1])
	translate([-input_width/2, -input_height/2, -pattern_thickness*zFact/2]) 
	linear_extrude(height=pattern_thickness*zFact) {polygon(points_array[pNum][1]);}
}
//-------------------------------------------------------------------------------
module shape2dNum(pNum) {
	scale([-sTrace, -sTrace])
	translate([-input_width/2, -input_height/2]) 
	polygon(points_array[pNum][1]);
}
//-------------------------------------------------------------------------------



