//------------------------------------------------------------
//	Stamp-o-Matic
//
//	input comes from:
//   http://chaaawa.com/stamp-o-matic/
//
//	http://thingiverse.com/Benjamin
//	http://www.thingiverse.com/thing:356988
//------------------------------------------------------------

// preview[view:south, tilt:top]

// paste here the Stamp-o-Matic output (see object page).
input = "no_input";

stamp_width = 60;
pattern_thickness = 1.25;
base_thickness = 8;
contour_radius = 1;// margin around pattern

module void() {}

dispo_width = stamp_width - 2*contour_radius;

points_array = (input=="no_input"?  [[512, 167, 2],[1,[[294.25,13.03],[294.25,13.03],[293.413,13.134],[292.427,13.391],[290.5,14.21],[290.5,14.21],[289.627,14.778],[288.728,15.48],[287.28,16.93],[287.28,16.93],[286.804,17.794],[286.411,18.991],[286.03,21.75],[286.03,21.75],[286.181,23.304],[286.646,24.866],[288.41,27.75],[288.41,27.75],[289.72,29.031],[291.07,29.882],[294.33,30.5],[294.33,30.5],[296.041,30.348],[297.618,29.887],[300.45,28],[300.45,28],[301.642,26.656],[302.44,25.266],[302.99,22],[302.99,22],[302.873,20.518],[302.595,19.064],[301.72,16.91],[301.72,16.91],[301.069,16.203],[300.198,15.448],[298.25,14.16],[298.25,14.16],[297.236,13.71],[296.145,13.347],[294.25,13.03]]],[1,[[43.75,21.03],[43.75,21.03],[43.459,21.81],[43.221,23.948],[43,31],[43,41],[34.25,41.25],[25.5,41.5],[25.5,44.5],[25.5,47.5],[34.25,47.75],[43,48],[42.71,79.25],[42.71,79.25],[42.51,93.465],[42.203,103.686],[41.21,113.25],[41.21,113.25],[40.542,114.442],[39.735,115.312],[37.75,116.04],[37.75,116.04],[36.757,115.925],[35.721,115.575],[34,114.39],[34,114.39],[33.419,113.448],[32.952,112.135],[32.549,109.1],[32.549,109.1],[32.625,107.484],[32.79,105.748],[33.3,102.75],[33.3,102.75],[33.558,101.438],[33.526,100.591],[32.5,100],[32.5,100],[31.698,100.19],[30.63,100.71],[28.25,102.41],[28.25,102.41],[26.866,103.815],[26.027,105.257],[25.5,109.5],[25.5,109.5],[25.615,112.02],[26.078,113.852],[28.75,117.08],[28.75,117.08],[30.269,118.262],[32,119.318],[35.25,120.59],[35.25,120.59],[36.947,120.738],[39.163,120.7],[44,120.12],[44,120.12],[46.365,119.523],[48.736,118.692],[52.4,116.77],[52.4,116.77],[53.727,115.493],[55.203,113.697],[57.88,109.5],[60.46,104.5],[60.73,76.25],[61,48],[64.25,47.75],[64.25,47.75],[65.977,47.524],[66.958,47.043],[67.5,44.5],[67.5,44.5],[67.398,42.896],[66.958,41.956],[64.25,41.25],[61,41],[60.75,35.25],[60.5,29.5],[52.5,25.28],[52.5,25.28],[49.334,23.644],[46.628,22.296],[43.75,21.03]]],[1,[[389,40.55],[389,40.55],[388.065,40.499],[386.622,40.591],[383,41.12],[383,41.12],[380.904,41.677],[378.518,42.548],[374.06,44.75],[374.06,44.75],[372.087,46.132],[370.007,47.866],[366.51,51.5],[366.51,51.5],[365.111,53.526],[363.602,56.087],[360.98,61.5],[360.98,61.5],[359.699,65.105],[358.967,68.756],[358.56,81],[358.56,81],[358.638,88.319],[358.967,93.225],[360.95,100.5],[360.95,100.5],[362.314,103.426],[364.025,106.265],[368.42,111.58],[368.42,111.58],[371.051,114],[373.597,115.893],[379,118.46],[379,118.46],[381.75,119.219],[384.5,119.698],[390,119.82],[390,119.82],[392.414,119.512],[394.916,119.011],[399,117.7],[399,117.7],[400.657,116.812],[402.576,115.632],[406.25,113.01],[406.25,113.01],[407.993,111.331],[409.788,109.103],[412.99,103.75],[412.99,103.75],[414.266,100.681],[415.435,97.145],[417.04,90],[417.04,90],[417.403,86.537],[417.601,82.648],[417.45,75.5],[417.45,75.5],[417.037,72.308],[416.397,68.793],[414.79,62.5],[414.79,62.5],[413.796,59.854],[412.57,57.087],[410.05,52.5],[410.05,52.5],[408.597,50.697],[406.671,48.748],[402.4,45.35],[402.4,45.35],[400.224,44.075],[397.914,42.929],[394,41.53],[394,41.53],[392.525,41.239],[391.091,40.957],[389,40.55]]],[1,[[91.25,41.25],[79,41],[78.99,74.25],[78.99,74.25],[78.913,89.994],[78.695,100.69],[77.71,110],[77.71,110],[76.992,111.086],[76.072,111.918],[73.73,112.75],[73.73,112.75],[72.286,112.995],[71.461,113.552],[71,116.5],[71,120],[79.25,120.58],[79.25,120.58],[82.81,120.78],[86.401,120.896],[92,120.83],[96.5,120.5],[97,114.5],[97,114.5],[97.268,111.815],[97.536,110.387],[98.17,111],[98.17,111],[98.708,112.228],[99.691,113.721],[102.42,116.75],[102.42,116.75],[104.248,118.204],[106.17,119.337],[110.25,120.62],[110.25,120.62],[112.178,120.772],[114.282,120.732],[118,120.14],[118,120.14],[119.573,119.497],[121.263,118.554],[124.19,116.28],[124.19,116.28],[125.313,114.982],[126.395,113.507],[127.94,110.75],[127.94,110.75],[128.375,107.914],[128.71,102.212],[129,84],[129,84],[129.067,72.033],[129.303,64.129],[130.5,56.5],[130.5,56.5],[131.238,55.044],[132.145,53.663],[134,51.75],[134,51.75],[134.778,51.105],[135.408,50.278],[135.97,48.5],[135.97,48.5],[135.86,47.598],[135.588,46.622],[134.72,44.91],[134.72,44.91],[134.069,44.203],[133.198,43.448],[131.25,42.16],[131.25,42.16],[130.099,41.708],[128.633,41.34],[125.5,41],[125.5,41],[123.936,41.098],[122.258,41.366],[119.37,42.25],[119.37,42.25],[118.143,43.128],[116.748,44.595],[114.12,48.5],[111.5,53.5],[111.2,80],[111.2,80],[110.985,94.115],[110.665,102.292],[109.2,107.77],[109.2,107.77],[108.38,108.259],[107.41,108.663],[105.5,109.04],[105.5,109.04],[104.558,108.866],[103.473,108.382],[101.41,106.78],[101.41,106.78],[100.505,105.655],[99.587,104.286],[98.14,101.5],[98.14,101.5],[97.626,98.721],[97.31,93.368],[97.23,74.04],[97.5,49.57],[100.82,48.54],[100.82,48.54],[102.555,47.894],[103.516,47.165],[103.82,44.5],[103.5,41.5],[91.25,41.25]]],[1,[[297.25,41.58],[286,41],[286,74.5],[286,74.5],[285.928,88.352],[285.725,99.441],[285,110.5],[285,110.5],[284.373,111.595],[283.458,112.53],[280.98,113.75],[280.98,113.75],[279.411,114.252],[278.497,114.943],[277.98,117.75],[278,121],[294.5,121],[311,121],[311.01,117.75],[311.01,117.75],[310.902,116.029],[310.446,114.901],[307.79,113.5],[307.79,113.5],[306.335,112.903],[305.197,112.121],[303.88,110],[303.88,110],[303.609,106.96],[303.369,100.526],[303.1,81.25],[303.1,81.25],[303.132,70.459],[303.306,61.643],[304,52.5],[304,52.5],[304.623,51.437],[305.576,50.431],[308,49],[308,49],[309.426,48.398],[310.351,47.673],[311,45.5],[311,45.5],[310.901,44.498],[310.633,43.612],[309.75,42.58],[309.75,42.58],[308.376,42.377],[305.562,42.121],[297.25,41.58]]],[1,[[164.75,42.04],[164.75,42.04],[162.046,42.174],[159.308,42.512],[155,43.6],[155,43.6],[153.453,44.359],[151.835,45.312],[149.15,47.31],[149.15,47.31],[148.061,48.514],[146.831,50.178],[144.55,54],[144.55,54],[143.589,56.105],[142.64,58.503],[141.21,63],[141.21,63],[140.739,65.495],[140.252,68.968],[139.46,77],[139.46,77],[139.27,81.448],[139.295,86.083],[139.94,94.5],[139.94,94.5],[140.543,97.962],[141.34,101.473],[143.1,107],[143.1,107],[144.09,108.975],[145.307,111.023],[147.8,114.38],[147.8,114.38],[149.166,115.642],[150.883,116.953],[154.5,119.1],[154.5,119.1],[156.591,119.878],[159.035,120.46],[164.5,120.95],[164.5,120.95],[167.614,120.842],[169.953,120.456],[173.75,118.47],[177,116],[177.02,132.25],[177.02,132.25],[176.958,139.836],[176.743,145.09],[175.77,149.77],[175.77,149.77],[175.099,150.257],[174.212,150.657],[172.25,151.02],[172.25,151.02],[171.092,151.137],[170.408,151.638],[170,154.5],[170,158],[186.5,158],[203,158],[203,154.5],[203,154.5],[202.917,152.697],[202.591,151.641],[200.75,151.04],[200.75,151.04],[199.757,150.927],[198.721,150.578],[197,149.39],[197,149.39],[196.216,146.806],[195.723,139.522],[195.25,100.6],[195.25,100.6],[195.171,76.067],[195.308,61.457],[196.5,51.25],[196.5,51.25],[197.278,50.336],[198.293,49.515],[200.5,48.5],[200.5,48.5],[201.734,48.121],[202.5,47.5],[203,45],[203,42],[190,42],[177,42],[177,44.5],[177,47],[174,44.5],[174,44.5],[172.231,43.229],[170.394,42.475],[164.75,42.04]]],[1,[[231.25,42.04],[224.5,42.08],[220.37,46.29],[220.37,46.29],[218.631,48.273],[217.088,50.44],[215.12,54.5],[215.12,54.5],[214.674,57.633],[214.318,63.157],[213.99,79],[213.99,79],[213.898,88.112],[213.656,95.278],[212.73,103.42],[212.73,103.42],[212.036,105.108],[211.048,106.802],[208.73,109.42],[208.73,109.42],[207.653,110.324],[206.777,111.253],[205.98,112.75],[205.98,112.75],[206.224,113.473],[206.875,114.514],[209,117],[209,117],[210.757,118.569],[212.436,119.478],[217.5,120],[217.5,120],[220.346,119.89],[222.5,119.5],[226,117.5],[226,117.5],[227.367,116.093],[228.64,114.266],[230.65,109.75],[230.65,109.75],[231.477,106.019],[232.056,100.33],[232.75,79],[232.75,79],[233.031,65.684],[233.397,57.695],[234.84,51.72],[234.84,51.72],[235.72,51.026],[236.892,50.457],[239.5,49.93],[239.5,49.93],[240.882,50.091],[242.427,50.53],[245.25,51.97],[245.25,51.97],[246.4,53.051],[247.504,54.503],[249.07,57.75],[249.07,57.75],[249.493,60.974],[249.767,66.918],[249.82,85.65],[249.5,109.79],[247.5,111.93],[247.5,111.93],[246.584,112.754],[245.572,113.426],[243.75,114.03],[243.75,114.03],[242.911,114.186],[242.372,114.752],[242,117.5],[242,121],[258.5,121],[275,121],[275,117.5],[275,117.5],[274.915,115.759],[274.607,114.688],[273,114],[273,114],[272.065,113.842],[271,113.412],[269,112],[267,110],[266.99,81.75],[266.99,81.75],[267.051,67.916],[267.267,58.922],[268.34,51.5],[268.34,51.5],[269.073,50.663],[270.075,49.866],[272.35,48.75],[272.35,48.75],[273.654,48.247],[274.466,47.546],[275,45],[275,42],[262.5,42],[250,42],[250.01,47.25],[250.01,52.5],[246.76,48.61],[246.76,48.61],[245.278,46.992],[243.649,45.463],[240.75,43.36],[240.75,43.36],[239.147,42.83],[236.832,42.407],[231.25,42.04]]],[1,[[448.5,42.11],[448.5,42.11],[446.052,42.172],[443.823,42.303],[441,42.7],[441,42.7],[440.16,43.158],[438.976,44.002],[436.21,46.37],[436.21,46.37],[434.743,48.017],[433.409,50.007],[431.45,54.5],[431.45,54.5],[430.76,57.925],[430.307,63.013],[429.99,80.25],[429.99,80.25],[429.923,89.969],[429.695,96.971],[428.68,104.25],[428.68,104.25],[427.934,105.686],[426.885,107.191],[424.43,109.69],[421.5,111.89],[423.04,114.69],[423.04,114.69],[423.833,115.881],[424.852,117.041],[427.04,118.74],[427.04,118.74],[428.328,119.216],[430.023,119.612],[433.75,119.99],[433.75,119.99],[435.618,119.884],[437.561,119.596],[440.75,118.64],[440.75,118.64],[442.082,117.699],[443.426,116.221],[445.96,111.89],[448.43,106.5],[448.79,80.5],[448.79,80.5],[449.035,67.793],[449.377,59.441],[450.58,52.25],[450.58,52.25],[451.442,51.192],[452.516,50.492],[455.75,49.98],[455.75,49.98],[457.699,50.115],[459.342,50.61],[462.5,53.04],[465.5,56.13],[465.81,81.81],[465.81,81.81],[465.867,92.924],[465.757,101.52],[465.06,110.25],[465.06,110.25],[464.408,111.494],[463.507,112.495],[460.98,113.75],[460.98,113.75],[459.411,114.252],[458.497,114.943],[457.98,117.75],[458,121],[474.5,121],[491,121],[491,117.5],[491,117.5],[490.913,115.833],[490.623,114.748],[489.25,113.97],[489.25,113.97],[488.413,113.837],[487.427,113.503],[485.5,112.43],[483.5,110.92],[483.19,83.21],[483.19,83.21],[483.132,71.194],[483.242,61.972],[483.94,52.75],[483.94,52.75],[484.591,51.541],[485.527,50.473],[488,49],[488,49],[489.498,48.376],[490.414,47.611],[491,45],[491,42],[478.5,42],[466,42],[465.75,47.25],[465.5,52.5],[463.86,49.5],[463.86,49.5],[462.914,48.159],[461.563,46.728],[458.36,44.28],[458.36,44.28],[456.24,43.249],[454.022,42.572],[448.5,42.11]]],[0,[[387.25,46.04],[387.25,46.04],[387.669,46.084],[388.261,46.233],[389.64,46.75],[389.64,46.75],[390.42,47.317],[391.322,48.308],[393.05,51],[393.05,51],[393.87,53.032],[394.802,55.972],[396.54,63],[396.54,63],[397.35,67.803],[397.797,72.737],[397.75,86],[397.75,86],[397.421,92.476],[396.943,98.061],[395.62,105.75],[395.62,105.75],[394.814,107.998],[393.816,110.235],[391.75,113.64],[391.75,113.64],[390.521,114.904],[389.4,115.611],[386.75,115.64],[386.75,115.64],[385.347,115.084],[384.083,114.062],[381.62,110.25],[381.62,110.25],[380.617,108.012],[379.633,105.427],[378.18,100.5],[378.18,100.5],[377.717,97.848],[377.238,94.325],[376.47,86.5],[376.47,86.5],[376.297,82.296],[376.323,77.641],[376.92,69],[376.92,69],[377.453,65.389],[378.072,61.836],[379.27,56.54],[379.27,56.54],[379.985,54.745],[381.021,52.788],[383.5,49.33],[383.5,49.33],[384.724,48.063],[385.84,47.021],[387.25,46.04]]],[0,[[168.25,47.97],[168.25,47.97],[169.941,48.14],[171.778,48.58],[175,50],[178,52],[178,79],[178,106],[174.25,108.5],[174.25,108.5],[172.42,109.554],[170.5,110.342],[166.75,111],[166.75,111],[165.016,110.868],[163.454,110.483],[161,109],[161,109],[160.176,107.888],[159.412,106.34],[158.41,102.75],[158.41,102.75],[158.212,99.52],[158.116,93.872],[158.25,78.5],[158.25,78.5],[158.521,69.707],[158.91,62.763],[159.99,55],[159.99,55],[160.618,53.502],[161.376,52.007],[162.89,49.72],[162.89,49.72],[163.821,48.967],[165.063,48.413],[168.25,47.97]]]]: input);

input_width = points_array[0][0];
input_height= points_array[0][1];
tVersion = points_array[0][2] == undef ? 0: points_array[0][2];
sTrace = dispo_width/input_width;
stamp_height = input_height*sTrace + 2*contour_radius;

contour_r = (contour_radius <= 0) ? 0.001 : contour_radius;
//-------------------------------------------------------------------------------
union() {
	color("gray")
	translate([0, 0, base_thickness + pattern_thickness/2 -0.01]) 
	buildFrom(len(points_array)-1);
	
	color("lightgray")
	hull() {
		linear_extrude(height=base_thickness)
		minkowski() {						// idea from Oskar Linde
			circle(r=contour_r, $fn=12); 	// in scad-utils/morphology.scad outset module.
			outline();
		}
	}
}
//-------------------------------------------------------------------------------
module outline() {
for (i=[1:len(points_array)-1]) {
		if (points_array[i][0] != 0) {
			shape2dNum(i);
		}
	}	
}
//-------------------------------------------------------------------------------
module buildFrom(pIndex) {
	if (pIndex < len(points_array) && pIndex > 0) {
		if (points_array[pIndex][0] == 0) {
			difference() {
				buildFrom(pIndex-1);
				shapeNum(pIndex, 2);
			}
		}
		else {
			union() {
				buildFrom(pIndex-1);
				shapeNum(pIndex);
			}
		}
	}
}
//-------------------------------------------------------------------------------
module shapeNum(pNum, zFact=1) {
	scale([-sTrace, -sTrace, 1])
	translate([-input_width/2, -input_height/2, -pattern_thickness*zFact/2]) 
	linear_extrude(height=pattern_thickness*zFact) {polygon(points_array[pNum][1]);}
}
//-------------------------------------------------------------------------------
module shape2dNum(pNum) {
	scale([-sTrace, -sTrace])
	translate([-input_width/2, -input_height/2]) 
	polygon(points_array[pNum][1]);
}
//-------------------------------------------------------------------------------



