// Parameterized pcb holder voor OpenLogicSniffer, rev3

pcbx = 49 ; // PCB width
pcby = 93 ; // PCB length
pcbz = 2.5; // PCB height/thickness
pcbmargin = 0.1; // extra margin to make sure corners fit

wallthickness = 1.5; // wall width
bottomthickness = 2; // bottom width

 
module pcbholder(){
difference() { //bakje
        cube([pcbx+pcbmargin+2*wallthickness,pcby+pcbmargin+2*wallthickness,pcbz+bottomthickness], center=false);
        translate([wallthickness,wallthickness,bottomthickness]) cube([pcbx+pcbmargin,pcby+pcbmargin,2*pcbz], center=false);
 }



//bevestigingspuntjes
translate([wallthickness+0.5*pcbmargin,wallthickness+0.5*pcbmargin,pcbz+bottomthickness]) cylinder(2,2,2);

translate([pcbx+wallthickness+0.5*pcbmargin,wallthickness+0.5*pcbmargin,pcbz+bottomthickness]) cylinder(2,2,2);

translate([pcbx+wallthickness+0.5*pcbmargin,pcby+wallthickness+0.5*pcbmargin,pcbz+bottomthickness]) cylinder(2,2,2);

translate([wallthickness+0.5*pcbmargin,pcby+wallthickness+0.5*pcbmargin,pcbz+bottomthickness]) cylinder(2,2,2);


/*
// omklapbaar punt. Uitgecomment, want onnodig groot. Werkt(te) wel.
translate([wallthickness,pcby-30,pcbz+2*bottomthickness]) rotate([90,90,0]) cylinder(10,3,3);

// omklapbaar punt
translate([pcbx+wallthickness+pcbmargin,pcby-10,pcbz+2*bottomthickness]) rotate([90,90,0]) cylinder(10,3,3);
*/

} 

difference(){
pcbholder();
translate([2*wallthickness,pcby+wallthickness,bottomthickness]) cube([pcbx-3,5,pcbz]); // Draden
translate([20,0,bottomthickness]) cube([13,10,10]); // usb

translate([2*wallthickness,pcby-2*wallthickness,bottomthickness/2]) cube([pcbx-3,3,15]); // pinnen van header

}
