thickness=3; //diameter of the ring section
radius=20; //radius of the ring
brochure_separation=10; //distance between the center of two pieces of the brochure



brochure_constant=brochure_separation/2;


// The ring itself
difference(){

	// Extrusion of the circle
	rotate_extrude(convexity = 10, $fn = 100)
	translate([radius, 0, 0])
	circle(d = thickness, $fn = 100);

	// Extrusion of a triangle to break the circle
	linear_extrude(height = thickness, center = true, convexity = 10, twist = 0)
	polygon(points=[[0,0],[radius+thickness/2,brochure_constant], [radius+thickness/2,-brochure_constant]]);
	
	//We have to delete de hole of the brochure
	rotate(a=[0,0,-atan(brochure_constant/(radius+thickness/2))],v=[0,0,0])
	translate([radius,0,0])
	scale([1.05,1.05,1])
	union(){
		translate([0,-thickness/2,0])
		cylinder(d=thickness,h=thickness,$fn=50,center=true);
		translate([0,thickness/2,0])
		cylinder(d=thickness,h=thickness,$fn=50,center=true);
		translate([0,0,0])
		cube([thickness,thickness,thickness],center=true);
	}
}


// First part of the brochure
rotate(a=[0,0,atan(brochure_constant/(radius+thickness/2))],v=[0,0,0])
translate([radius,0,0])
union(){
	translate([0,0,thickness/2+thickness/20])
	cylinder(d=thickness,h=2*thickness+thickness/10,$fn=50,center=true);
	translate ([0,thickness/2,2*thickness-thickness/5])
	union(){
		translate([0,-thickness/2,0])
		cylinder(d=thickness,h=thickness/2,$fn=50,center=true);
		translate([0,thickness/2,0])
		cylinder(d=thickness,h=thickness/2,$fn=50,center=true);
		translate([0,0,0])
		cube([thickness,thickness,thickness/2],center=true);
	}
}

// Second part of the brochure

rotate(a=[0,0,-atan(brochure_constant/(radius+thickness/2))],v=[0,0,0])
translate([radius,0,0])
difference(){
	scale([1.3,1.3,1])
	union(){
		translate([0,-thickness/2,0])
		cylinder(d=thickness,h=thickness,$fn=50,center=true);
		translate([0,thickness/2,0])
		cylinder(d=thickness,h=thickness,$fn=50,center=true);
		translate([0,0,0])
		cube([thickness,thickness,thickness],center=true);
	}

	scale([1.05,1.05,1])
	union(){
		translate([0,-thickness/2,0])
		cylinder(d=thickness,h=thickness,$fn=50,center=true);
		translate([0,thickness/2,0])
		cylinder(d=thickness,h=thickness,$fn=50,center=true);
		translate([0,0,0])
		cube([thickness,thickness,thickness],center=true);
	}
}
