//Fresnel Mirror
//Patrick Roberts 9/20/2014
//7 concentric rings - no way to loop it

W=1; //one half focal width
F=12; //focus distance from mirror plane


angle1 = (atan(W/F)+asin(W/sqrt(W*W+F*F)))/2;
base1=W+(2*W)/cos(2*angle1);

angle2 = (atan(base1/F)+asin(W/sqrt(base1*base1+F*F)))/2;
base2=base1+(2*W)/cos(2*angle2);

angle3 = (atan(base2/F)+asin(W/sqrt(base2*base2+F*F)))/2;
base3=base2+(2*W)/cos(2*angle3);

angle4 = (atan(base3/F)+asin(W/sqrt(base3*base3+F*F)))/2;
base4=base3+(2*W)/cos(2*angle4);

angle5 = (atan(base4/F)+asin(W/sqrt(base4*base4+F*F)))/2;
base5=base4+(2*W)/cos(2*angle5);

angle6 = (atan(base5/F)+asin(W/sqrt(base5*base5+F*F)))/2;
base6=base5+(2*W)/cos(2*angle6);

angle7 = (atan(base6/F)+asin(W/sqrt(base6*base6+F*F)))/2;
base7=base6+(2*W)/cos(2*angle7);

difference(){
cylinder(h = base1*tan(90-2*angle1), r1 = base1, r2 = 0,$fn=100);
translate([0,0,-W*tan(angle1)]) cylinder(h = 2*base1*tan(angle1), r1 = 0, r2 = 2*base1,$fn=100);
translate([0,0,(base1-W)*tan(angle1)]) cylinder(h = base1*tan(90-2*angle1), r1 = base1, r2 = base1,$fn=100);}

difference(){
cylinder(h = base2*tan(90-2*angle2), r1 = base2, r2 = 0,$fn=100);
translate([0,0,-base1*tan(angle2)]) cylinder(h = 2*base2*tan(angle2), r1 = 0, r2 = 2*base2,$fn=100);
translate([0,0,(base2-base1)*tan(angle2)]) cylinder(h = base2*tan(90-2*angle2), r1 = base2, r2 = base2,$fn=100);}

difference(){
cylinder(h = base3*tan(90-2*angle3), r1 = base3, r2 = 0,$fn=100);
translate([0,0,-base2*tan(angle3)]) cylinder(h = 2*base3*tan(angle3), r1 = 0, r2 = 2*base3,$fn=100);
translate([0,0,(base3-base2)*tan(angle3)]) cylinder(h = base3*tan(90-2*angle3), r1 = base3, r2 = base3,$fn=100);}

difference(){
cylinder(h = base4*tan(90-2*angle4), r1 = base4, r2 = 0,$fn=100);
translate([0,0,-base3*tan(angle4)]) cylinder(h = 2*base4*tan(angle4), r1 = 0, r2 = 2*base4,$fn=100);
translate([0,0,(base4-base3)*tan(angle4)]) cylinder(h = base4*tan(90-2*angle4), r1 = base4, r2 = base4,$fn=100);}

difference(){
cylinder(h = base5*tan(90-2*angle5), r1 = base5, r2 = 0,$fn=100);
translate([0,0,-base4*tan(angle5)]) cylinder(h = 2*base5*tan(angle5), r1 = 0, r2 = 2*base5,$fn=100);
translate([0,0,(base5-base4)*tan(angle5)]) cylinder(h = base5*tan(90-2*angle5), r1 = base5, r2 = base5,$fn=100);}

difference(){
cylinder(h = base6*tan(90-2*angle6), r1 = base6, r2 = 0,$fn=100);
translate([0,0,-base5*tan(angle6)]) cylinder(h = 2*base6*tan(angle6), r1 = 0, r2 = 2*base6,$fn=100);
translate([0,0,(base6-base5)*tan(angle6)]) cylinder(h = base6*tan(90-2*angle6), r1 = base6, r2 = base6,$fn=100);}

difference(){
cylinder(h = base7*tan(90-2*angle7), r1 = base7, r2 = 0,$fn=100);
translate([0,0,-base6*tan(angle7)]) cylinder(h = 2*base7*tan(angle7), r1 = 0, r2 = 2*base7,$fn=100);
translate([0,0,(base7-base6)*tan(angle7)]) cylinder(h = base7*tan(90-2*angle7), r1 = base7, r2 = base7,$fn=100);}

translate([0,0,-.5]) cylinder(h = .5, r1 = base7, r2 = base7,$fn=100);
translate([0,0,F]) sphere(r = W,$fn=100);
