$fn = 256;

height = 50;
bottomThickness = 3;

bottomDiameter = 81.5; // was 82
topDiameter = bottomDiameter;

notchWidth = 10;
notchDepth = 12;
notchHeight = height;

markerHeight = 0.4;
markerWidth = 5;
markerAngle = 317.25; // 315
markerTopOffset = 2;
markerFontSize = 3;
markerFontFamily = "Helvetica Neue:style=Bold";

insertPosition = "L"; // "L" or "R"
markerTextOffset = (insertPosition == "R") ? 2.5 : -4.5;
markerTextAngle = (insertPosition == "R") ? 93 : 87;
printMarkerText = false;

smoothEdgeWidth = 10;

canDiameter = 55;

bottleDiameter = 67;

vapeWidth = 31.5;
vapeDepth = 51; // 50.5
vapeCubeDepth = vapeDepth - vapeWidth;

type = "bottle"; // "bottle" OR "smallCan" OR "vape"

mercedesCupholderInsert();

module mercedesCupholderInsert() {
    difference() {
        base();
        cutout();
    }
}

module base() {
    difference() { 
        union() {
            cylinder(h = height, d1 = bottomDiameter, d2 = topDiameter);
            rotate([0, 0, markerAngle]) {
                markerTop();
            }
        }
        rotate([0, 0, 0]) {
            notch();
        }
        rotate([0, 0, 93.5]) { // 95, 95, 92, 90
            notch();
        }
        rotate([0, 0, 180]) { // 180, 178, 184, 180
            notch();
        }
        rotate([0, 0, 274.5]) { // 273, 271, 274, 270
            notch();
        }
        rotate([0, 0, markerAngle]) {
            markerBottom();
        }
    }
}

module notch() {
    translate([bottomDiameter/2 - notchDepth/2, 0, notchHeight/2]) {
        cube([notchDepth, notchWidth, notchHeight], center = true);
    }
}

module markerTop() {
    translate([bottomDiameter/2 - notchDepth/2 + markerTopOffset, 0, height]) {
        marker();
        if (printMarkerText == true) {
            markerText();
        }
    }
}

module markerBottom() {
    translate([bottomDiameter/2 - notchDepth/2, 0, 0]) {
        marker();
    }
}

module marker() {
    cylinder(h = markerHeight, d = markerWidth, $fn = 3);
}

module markerText() {
    linear_extrude(markerHeight) {
        rotate([0, 0, markerTextAngle]) {
            translate([markerTextOffset, 0.6, 0]) {
                text(insertPosition, markerFontSize, markerFontFamily, valign = "top");
            }
        }
    }
}

module cutout() {
    if (type == "smallCan") {
        cutoutSmallCan();
    }
    else if (type == "bottle") {
        cutoutBottle();
    }
    else if (type == "vape") {
        cutoutVape();
    }
}

// e.g. 250ml Red Bull aluminium can
module cutoutSmallCan() {
    translate([0, 0, bottomThickness]) {
        cylinder(d = canDiameter, h = height-bottomThickness);
    }
    translate([0, 0, height/2]) {
        cylinder(h = height/2, d2 = canDiameter+smoothEdgeWidth, d1 = 0);
    }
}

// e.g. 5dl Coke plastic bottle
module cutoutBottle() {
    translate([0, 0, bottomThickness]) {
        cylinder(d = bottleDiameter, h = height-bottomThickness);
    }
    translate([0, 0, height/2]) {
        difference() {
            cylinder(h = height/2, d2 = bottleDiameter+smoothEdgeWidth, d1 = 0);
            rotate([0, 0, markerAngle]) {
                notch();
            }
        }
    }
}

// vape mod
module cutoutVape() {
    rotate([0, 0, 47.25]) {
        translate([0, vapeCubeDepth/2, bottomThickness]) {
            cylinder(d = vapeWidth, h = height-bottomThickness);
        }
        translate([0, -vapeCubeDepth/2, bottomThickness]) {
            cylinder(d = vapeWidth, h = height-bottomThickness);
        }
        hull() {
            translate([0, vapeCubeDepth/2, height/2]) {
                cylinder(h = height/2, d2 = vapeWidth+smoothEdgeWidth, d1 = 0);
            }
            translate([0, -vapeCubeDepth/2, height/2]) {
                cylinder(h = height/2, d2 = vapeWidth+smoothEdgeWidth, d1 = 0);
            }
        }
        translate([-vapeWidth/2, -vapeCubeDepth/2, bottomThickness]) {
            cube([vapeWidth, vapeCubeDepth, height-bottomThickness]);
        }
    }
}