
use <../pins.scad>;
use <MCAD/shapes.scad>;
use <MCAD/regular_shapes.scad>;
use <MCAD/involute_gears.scad>;


//////// FOSHWARE

// Designed by Chris Caswell

// 3Dideas@carrythewhat.com

// christophercaswell@gmail.com

//

// Over-ear headphones design, version 2

// main upgrade, is the easier to print, adjustable headband

// appologize for the state of the code, if you are looking to make changes

// or upgrades to the code base, please contact me and I will help clean it up

// 

// thanks for downloading!












//
/// Measured variables
// 

earcover_width = 75;
earcover_length = 105;
speaker_diameter_outside = 40.3;
speaker_diameter_inside = 30.4;
speaker_overall_height = 8;
speaker_rim_height = 5;
speaker_jack_diameter = 5.83;

//
/// Design variables
//

central_groove_radius = 0;

// Set the size for the headband
// extra small
//headband_width = 200;
// small
headband_width = 210;
// medium
//headband_width = 230;
// large
//headband_width = 250;

headband_height = 25;
headband_thickness = 3.5; // starting thickness of headband
headband_count = 2; // number of arcs in headband (then multiplied by 2)
headband_extra_length = 20;
headband_extra_angle = 40;
headband_extra_thickness = 9;
headphone_jack_diameter = 7;
headphone_jack_outer_diameter = 13;
earcover_pinpeg_radius = 5;
earcover_pinpeg_length = 20;
earcap_pinpeg_radius = 4;
earcap_pinpeg_length = 20;
crown_arc_angle = 15;
arc_scaling = 0.1; // spacing between arcs (was .17)
dovetail_length = 15; // dovetail is connection for 3-piece headband
top_dovetail_length = 30;
headphone_jack_support_depth = 7;
headphone_jack_support_width = 6;

//
/// unilateral stereo
//

speaker_scale = 1.05; // from 1.07
jack_height = 25;
support_length = 15;
jack_separation = earcover_width/2 - headphone_jack_outer_diameter*1.25;
speaker_offset = 0; // lowering both the pin holes and speakers to close gap with cap

//
/// export here
//

// ear cup
//earcover_unilateral_stereo_fixed();
//earcover_unilateral_stereo_removable();
//earcover(); 
earcover_duli();

// ear cup cover
//earcover_cap();
//earcover_cap_duli();

//headbandv2_bottom();
//headbandv2_top();

//pinpeg(r=earcap_pinpeg_radius*.75, h=earcap_pinpeg_length);  
 

// pins
//pin1();
//translate([0,0,10]) pin2();


//
/// Primary design modules
//

module assembly() {
	ear_connector_extra_angle = 0;
	//headbandv2_top();
	//rotate([0,0,-15]) translate([-3,0,3]) headbandv2_bottom();
	//rotate([0,0,15]) rotate([0,180,0]) translate([-3,0,3]) headbandv2_bottom();

	//translate([-(headband_width)/2  * cos(headband_extra_angle/2), 
        //    - (headband_width)/2 * sin(headband_extra_angle/2), 0]) 
        //    translate([headband_extra_thickness/3* cos(headband_extra_angle/2), 
        //    headband_extra_thickness/3 * sin(headband_extra_angle/2), -headband_height/2])
        //    rotate([0,0,180 + headband_extra_angle*2/4 + ear_connector_extra_angle]) 
        //    translate([2,headband_height/2+1,headband_height/2+3]) rotate([0,-90,0]) 
        //        earcover_unilateral_stereo_removable();
        //top_gear();

        //translate([0,headband_width/2+earcap_pinpeg_length/2,
        //    -earcap_pinpeg_radius/2]) rotate([0,0,0]) 
        //    pinpeg(r=earcap_pinpeg_radius*.75, h=earcap_pinpeg_length*.6);
    

}

module top_gear () {
    translate([0,-10,0]) 
    difference() {
        rotate([0,45,0]) rotate([0,0,-45]) translate([0,0,-headband_height/2+2]) 
            scale(0.252) top_gear_sub (144,8);
        translate([0,headband_width/2-8,0]) rotate([-90,0,0]) 
            pinhole(r=earcap_pinpeg_radius*.75, h=earcap_pinpeg_length);
   }
}

module bevel_top_gear (
	gear1_teeth = 41,
	gear2_teeth = 7,
	axis_angle = 90,
	outside_circular_pitch=1000)
{
	outside_pitch_radius1 = gear1_teeth * outside_circular_pitch / 360;
	outside_pitch_radius2 = gear2_teeth * outside_circular_pitch / 360;
	pitch_apex1=outside_pitch_radius2 * sin (axis_angle) +
		(outside_pitch_radius2 * cos (axis_angle) + outside_pitch_radius1) / tan (axis_angle);
	cone_distance = sqrt (pow (pitch_apex1, 2) + pow (outside_pitch_radius1, 2));
	pitch_apex2 = sqrt (pow (cone_distance, 2) - pow (outside_pitch_radius2, 2));
	echo ("cone_distance", cone_distance);
	pitch_angle1 = asin (outside_pitch_radius1 / cone_distance);
	pitch_angle2 = asin (outside_pitch_radius2 / cone_distance);
	echo ("pitch_angle1, pitch_angle2", pitch_angle1, pitch_angle2);
	echo ("pitch_angle1 + pitch_angle2", pitch_angle1 + pitch_angle2);

	rotate([0,0,90])
	translate ([0,0,pitch_apex1+20])
	{
		translate([0,0,-pitch_apex1])
		bevel_gear (
			number_of_teeth=gear1_teeth,
			cone_distance=cone_distance,
			pressure_angle=30,
			outside_circular_pitch=outside_circular_pitch);

                //rotate([0,0,360/gear2_teeth]) 
		//rotate([0,-(pitch_angle1+pitch_angle2),0])
		//translate([0,0,-pitch_apex2])
		//bevel_gear (
		//	number_of_teeth=gear2_teeth,
		//	cone_distance=cone_distance,
		//	pressure_angle=30,
		//	outside_circular_pitch=outside_circular_pitch);
	}
}


module top_gear_sub (
	gear1_teeth = 41,
	gear2_teeth = 7,
	axis_angle = 90,
	outside_circular_pitch=1000)
{
	outside_pitch_radius1 = gear1_teeth * outside_circular_pitch / 360;
	outside_pitch_radius2 = gear2_teeth * outside_circular_pitch / 360;
	pitch_apex1=outside_pitch_radius2 * sin (axis_angle) +
            (outside_pitch_radius2 * cos (axis_angle) + 
            outside_pitch_radius1) / tan (axis_angle);
	cone_distance = sqrt (pow (pitch_apex1, 2) + pow (outside_pitch_radius1, 2));
	pitch_apex2 = sqrt (pow (cone_distance, 2) - pow (outside_pitch_radius2, 2));
	echo ("cone_distance", cone_distance);
	pitch_angle1 = asin (outside_pitch_radius1 / cone_distance);
	pitch_angle2 = asin (outside_pitch_radius2 / cone_distance);
	echo ("pitch_angle1, pitch_angle2", pitch_angle1, pitch_angle2);
	echo ("pitch_angle1 + pitch_angle2", pitch_angle1 + pitch_angle2);
        
        
	rotate([0,0,90])
	translate ([0,0,pitch_apex1+20])
	{

                rotate([0,0,360/gear2_teeth]) 
		rotate([0,-(pitch_angle1+pitch_angle2),0])
		translate([0,0,-pitch_apex2 - headband_width/4])
                scale([1,1,1])
		bevel_gear (
			number_of_teeth=gear2_teeth,
			cone_distance=cone_distance,
			pressure_angle=30,
			outside_circular_pitch=outside_circular_pitch);
                rotate([0,0,360/gear2_teeth]) 
		rotate([0,-(pitch_angle1+pitch_angle2),0])
		translate([0,0,-pitch_apex2 - headband_width/4-headband_thickness*2+1])
                scale(1 / 0.252)
                difference() {
                    cylinder(r=headband_thickness*4*0.95, 
                        h=headband_thickness*1.3, center=true);
                    for(i = [0:10:360]) {
                        rotate([0,0,i])
                        translate([headband_thickness*4-1,0,0])
                        cube([2,1,headband_thickness*4], center=true);
                    }
                }
	}
}

module bevel_gear_pair2 (
	gear1_teeth = 41,
	gear2_teeth = 7,
	axis_angle = 90,
	outside_circular_pitch=1000)
{
	outside_pitch_radius1 = gear1_teeth * outside_circular_pitch / 360;
	outside_pitch_radius2 = gear2_teeth * outside_circular_pitch / 360;
	pitch_apex1=outside_pitch_radius2 * sin (axis_angle) +
		(outside_pitch_radius2 * cos (axis_angle) + outside_pitch_radius1) 
                / tan (axis_angle);
	cone_distance = sqrt (pow (pitch_apex1, 2) + pow (outside_pitch_radius1, 2));
	pitch_apex2 = sqrt (pow (cone_distance, 2) - pow (outside_pitch_radius2, 2));
	echo ("cone_distance", cone_distance);
	pitch_angle1 = asin (outside_pitch_radius1 / cone_distance);
	pitch_angle2 = asin (outside_pitch_radius2 / cone_distance);
	echo ("pitch_angle1, pitch_angle2", pitch_angle1, pitch_angle2);
	echo ("pitch_angle1 + pitch_angle2", pitch_angle1 + pitch_angle2);

	rotate([0,0,90])
	translate ([0,0,pitch_apex1+20])
	{
		translate([0,0,-pitch_apex1])
		bevel_gear (
			number_of_teeth=gear1_teeth,
			cone_distance=cone_distance,
			pressure_angle=30,
			outside_circular_pitch=outside_circular_pitch);
                

		//rotate([0,-(pitch_angle1+pitch_angle2),0])
		//translate([0,0,-pitch_apex2])
		//bevel_gear (
		//	number_of_teeth=gear2_teeth,
		//	cone_distance=cone_distance,
		//	pressure_angle=30,
		//	outside_circular_pitch=outside_circular_pitch);
	}
}

module yuni_logo() {
	linear_extrude(height=5) import("yuni_logo2.dxf");
}

module yuni_text() {
	linear_extrude(height=5) import("yuni_text.dxf");
}

module earcover_dummy() {
	earcover();
}


module earcover() {
    slit_width = 4;
    slit_depth = 10;
    slit_angle = 10;
    num_slits = 2;
    difference() {
    union() {
        translate([0,earcover_length/2 - earcover_width/2, 0]) 
            partial_rotate_extrude(180, central_groove_radius, 10) 
            import("earcover_cross_section2_2.dxf");
        translate([0,-earcover_length/2 + earcover_width/2, 0]) 
            rotate([0,0,180])partial_rotate_extrude(180, central_groove_radius, 10) 
            import("earcover_cross_section2_2.dxf");
        translate([central_groove_radius,earcover_length/6,0]) rotate([90,0,0])
            linear_extrude(height=earcover_length/3)
            import("earcover_cross_section2_2.dxf");
        translate([-central_groove_radius,-earcover_length/6,0]) 
            rotate([0,0,180]) rotate([90,0,0])  
            linear_extrude(height=earcover_length/3)
            import("earcover_cross_section2_2.dxf");
        translate([earcover_width/4,0, earcap_pinpeg_length*4/8-speaker_offset]) 
            // earcap connection
            cylinder(r=earcap_pinpeg_radius*1.5, h=6*earcap_pinpeg_length/8, center=true);
        translate([-earcover_width/4,0, earcap_pinpeg_length*4/8-speaker_offset]) 
            // earcap connection
            cylinder(r=earcap_pinpeg_radius*1.5, h=6*earcap_pinpeg_length/8, center=true);
        translate([0,0,earcap_pinpeg_length/3]) 
            cylinder(r=earcap_pinpeg_radius*1.6, h=4*earcap_pinpeg_length/8, center=true);
    }
    translate([earcover_width/4,0, earcap_pinpeg_length*1.25-speaker_offset]) 
        //earcap connection hole
        rotate([0,180,0])pinhole(r=earcap_pinpeg_radius, h=earcap_pinpeg_length);
    translate([-earcover_width/4,0, earcap_pinpeg_length*1.25-speaker_offset]) 
        //earcap connection hole
        rotate([0,180,0])pinhole(r=earcap_pinpeg_radius, h=earcap_pinpeg_length);
    translate([0,0,-earcover_pinpeg_length/2]) 
        pinhole(r=earcover_pinpeg_radius, h=earcover_pinpeg_length);
    // open back sound holes
    rotate([0,-slit_angle,0]) translate([earcover_width/3,-earcover_length/8,0]) 
        cube([slit_width, slit_depth, 8], center=true);
    rotate([0,slit_angle,0]) translate([-earcover_width/3,-earcover_length/8,0]) 
        cube([slit_width, slit_depth, 8], center=true);
    rotate([0,-slit_angle,0]) translate([earcover_width/3,earcover_length/8,0]) 
        cube([slit_width, slit_depth, 8], center=true);
    rotate([0,slit_angle,0]) translate([-earcover_width/3,earcover_length/8,0]) 
        cube([slit_width, slit_depth, 8], center=true);
    }
}

module earcover_unilateral_stereo_fixed() {
    //speaker_separation_ratio = 0.16; for -15 angle
    speaker_separation_ratio = 0.195;
    angle = 0;
    jack_height = 16;
    difference() {
        union() {
                earcover();
                translate([0,earcover_length*speaker_separation_ratio,-2-speaker_offset]) 
                        rotate([angle,0,0]) speaker_holder();
                translate([0,-earcover_length*speaker_separation_ratio,-2-speaker_offset]) 
                        rotate([-angle,0,0]) speaker_holder();
        }
        translate([0,-earcover_length/2,28 - headphone_jack_support_depth]) 
            cube([headphone_jack_support_width,20,
            headphone_jack_support_depth + 6], center=true);
        translate([0,earcover_length*speaker_separation_ratio,-2]) 
            rotate([angle,0,0]) speaker();
        translate([0,-earcover_length*speaker_separation_ratio,-2]) 
            rotate([-angle,0,0]) speaker();
        translate([0,-earcover_pinpeg_radius*0,-earcover_pinpeg_length/2]) 
                pinhole(r=earcover_pinpeg_radius, h=earcover_pinpeg_length);
        translate([0,-earcover_length/8,0]) rotate([0,180,0])
                yuni_logo();
        
    }
}

module earcover_unilateral_stereo_removable() {
    //speaker_separation_ratio = 0.16; for -15 angle
    speaker_separation_ratio = 0.195;
    angle = 0;
    jack_height = 14;
    support_thickness = 2;
    difference() {
    union() {
    difference() {
            union() {
                    earcover();
                    translate([0,earcover_length*speaker_separation_ratio,-2-speaker_offset]) 
                            rotate([angle,0,0]) speaker_holder();
                    translate([0,-earcover_length*speaker_separation_ratio,-2-speaker_offset]) 
                            rotate([-angle,0,0]) speaker_holder();
                    jack_support();
                    mirror([1,0,0]) jack_support();
            }
        translate([0,-earcover_pinpeg_radius*0,-earcover_pinpeg_length/2]) 
            pinhole(r=earcover_pinpeg_radius, h=earcover_pinpeg_length);
        translate([0,-earcover_length/8,0]) rotate([0,180,0])
            yuni_logo();	
        translate([earcover_width/3,-earcover_length/3+support_length/2-
            support_thickness*3/2,jack_height]) 
            headphone_jack();	
        translate([-earcover_width/3,-earcover_length/3+
            support_length/2-support_thickness*3/2,jack_height]) 
            headphone_jack();
        translate([0,earcover_length*speaker_separation_ratio,-speaker_offset-2]) 
            rotate([angle,0,0]) speaker();
        translate([0,-earcover_length*speaker_separation_ratio,-speaker_offset-2]) 
            rotate([-angle,0,0]) speaker();
    }
    }
        translate([0,-earcover_length*speaker_separation_ratio,-speaker_offset-2]) 
            rotate([-angle,0,0]) speaker();
    
    }
}

module earcover_duli() {
    slit_width = 8;
    slit_depth = 10;
    slit_angle = 10;
    num_slits = 4;
    jack_height = 14;
    difference() {
    union() {
        translate([0,earcover_length/2 - earcover_width/2, 0]) 
            partial_rotate_extrude(180, central_groove_radius, 10) 
            import("earcover_cross_section2_2.dxf");
        translate([0,-earcover_length/2 + earcover_width/2, 0]) 
            rotate([0,0,180])partial_rotate_extrude(180, central_groove_radius, 10) 
            import("earcover_cross_section2_2.dxf");
        translate([central_groove_radius,earcover_length/6,0]) rotate([90,0,0])
            linear_extrude(height=earcover_length/3)
            import("earcover_cross_section2_2.dxf");
        translate([-central_groove_radius,-earcover_length/6,0]) rotate([0,0,180]) rotate([90,0,0])  
            linear_extrude(height=earcover_length/3)
            import("earcover_cross_section2_2.dxf");
        translate([-earcover_width/8, earcover_length*9/32, earcap_pinpeg_length*5/8/1.5])
            cylinder(r=earcap_pinpeg_radius*1.5, h=earcap_pinpeg_length/2*1.5, center=true);
        translate([earcover_width/8, -earcover_length*9/32, earcap_pinpeg_length*5/8/1.5]) 
            cylinder(r=earcap_pinpeg_radius*1.5, h=earcap_pinpeg_length/2*1.5, center=true);
        translate([0,0,earcap_pinpeg_length/3]) 
            cylinder(r=earcap_pinpeg_radius*5, h=6*earcap_pinpeg_length/8, center=true);
        translate([0,0,1]) speaker_holder();
        jack_support_center();
    }
    translate([-earcover_width/8, earcover_length*9/32, earcap_pinpeg_length*1.25]) //earcap connection hole
        rotate([0,180,0])pinhole(r=earcap_pinpeg_radius, h=earcap_pinpeg_length);
    translate([earcover_width/8, -earcover_length*9/32, earcap_pinpeg_length*1.25]) //earcap connection hole
        rotate([0,180,0])pinhole(r=earcap_pinpeg_radius, h=earcap_pinpeg_length);
    translate([0,-earcover_pinpeg_radius*0,-earcover_pinpeg_length/2]) 
        pinhole(r=earcover_pinpeg_radius, h=earcover_pinpeg_length);
    rotate([0,-slit_angle,0]) translate([earcover_width/3,-earcover_length/8,0]) 
        cube([slit_width, slit_depth, 8], center=true);
    rotate([0,slit_angle,0]) translate([-earcover_width/3,-earcover_length/8,0]) 
        cube([slit_width, slit_depth, 8], center=true);
    rotate([0,-slit_angle,0]) translate([earcover_width/3,earcover_length/8,0]) 
        cube([slit_width, slit_depth, 8], center=true);
    rotate([0,slit_angle,0]) translate([-earcover_width/3,earcover_length/8,0]) 
        cube([slit_width, slit_depth, 8], center=true);
    translate([0,0,1]) speaker();
    translate([0,-earcover_length/2 + support_length/2,jack_height]) headphone_jack_duli();
    }
}

module jack_support_center() {
	$fn = 20;
	support_thickness = 2;
	jack_height = 14;
	difference() {
            translate([0,-earcover_width/2.5-support_length+support_thickness,jack_height]) 
                rotate([90,0,0])
                cylinder(r=headphone_jack_outer_diameter/2
                + support_thickness, h=support_length, center=true);
            intersection() {
                translate([0,-earcover_width/2+2,jack_height]) 
                    rotate([90,0,0])
                    cylinder(r=headphone_jack_outer_diameter/2 
                    + support_thickness*2, h=support_length, center=true);
                translate([0,-earcover_length/12,0]) 
                    cylinder(r=(earcover_width)/2, h=earcover_width, center=true);
            }
	}
        translate([0,-earcover_width/2.5-support_length+0.7,
            headphone_jack_diameter/2+1.6]) 
            rotate([45,0,0]) 
            cube([headphone_jack_diameter,
            headphone_jack_diameter,headphone_jack_diameter*1.5], center=true);
        translate([0,-earcover_width/2.5-support_length+5.5,
            headphone_jack_diameter/2-1]) 
            cube([headphone_jack_diameter,
            headphone_jack_diameter,headphone_jack_diameter], center=true);
}


module jack_support() {
    $fn = 20;
    support_thickness = 2;
    w_adj=15;
    l_adj=40;
    jack_height = 14;
    difference() {
    union() {
    difference() {
        translate([-earcover_width/3,-earcover_width/3,jack_height]) rotate([90,0,0])
            cylinder(r=headphone_jack_outer_diameter/2 
            + support_thickness, h=support_length, center=true);
        translate([0,-(earcover_length-l_adj)/4,0]) 
            cylinder(r=(earcover_width-w_adj)/2, h=earcover_width, center=true);
    }
   // translate([-earcover_width/3,-earcover_width/3-4,
   //     headphone_jack_diameter/2+1.6]) 
   //     rotate([0,-45,0]) 
   //     cube([headphone_jack_diameter,
   //     headphone_jack_diameter,headphone_jack_diameter*1.5], center=true);
    intersection() {
        translate([-earcover_width/3,-earcover_width/3-support_length+support_thickness,jack_height]) 
            rotate([90,0,0])
            cylinder(r=headphone_jack_outer_diameter/2 + support_thickness, 
            h=support_length, center=true);
        translate([0,-(earcover_length-l_adj)/4,0]) 
            cylinder(r=(earcover_width-w_adj)/2, h=earcover_width, center=true);
    }
    }
        translate([-earcover_width/3,-earcover_width/3,jack_height])
            translate([0,-support_length/2 + support_thickness,0]) headphone_jack();
    }
}


module headphone_jack() {
    $fn = 20;
    support_thickness = 2;
    rotate([90,0,0])
    union() {
        translate([0,0,support_length/4]) 
            cylinder(r=headphone_jack_diameter/2, h=support_length/2, center=true);
        translate([0,0,-support_length/2]) 
            cylinder(r=headphone_jack_outer_diameter/2, h=support_length, center=true);
        translate([0,0,support_length/2 + support_thickness/2]) 
            cylinder(r=headphone_jack_outer_diameter/2, h=support_length, center=true);
    }
}


module headphone_jack_duli() {
    $fn = 20;
    support_thickness = 2;
    rotate([90,0,0])
    union() {
        translate([0,0,support_length/4]) 
                cylinder(r=headphone_jack_diameter/2, h=support_length/2, center=true);
        translate([0,0,-support_length/4]) 
                cylinder(r=headphone_jack_outer_diameter/2, h=support_length/2, center=true);
        translate([0,0,support_length/4 + support_thickness/2]) 
                cylinder(r=headphone_jack_outer_diameter/2, h=support_length/2, center=true);
    }
}


module earcover_cap() {
		rotate([0,180,0])
	difference() {
	union() {
		translate([earcover_width/4,0, -1.5*earcap_pinpeg_length/8]) // earcap connection
			cylinder(r=earcap_pinpeg_radius*1.75, h=3*earcap_pinpeg_length/8, center=true);
		translate([-earcover_width/4,0, -1.5*earcap_pinpeg_length/8]) // earcap connection
			cylinder(r=earcap_pinpeg_radius*1.75, h=3*earcap_pinpeg_length/8, center=true);
		ovalTube(3, 40, 50, 50, center=true);
	} 
		translate([0,earcover_length/6,0]) sound_holes();
		translate([0,-earcover_length/6,0]) rotate([0,0,180]) sound_holes();
		translate([earcover_width/4,0, -earcap_pinpeg_length]) //earcap connection hole
			pinhole(r=earcap_pinpeg_radius, h=earcap_pinpeg_length);
		translate([-earcover_width/4,0, -earcap_pinpeg_length]) //earcap connection hole
			pinhole(r=earcap_pinpeg_radius, h=earcap_pinpeg_length);
	}
}

module earcover_cap_duli() {
    rotate([0,180,0])
    difference() {
    union() {
        translate([-earcover_width/8,earcover_length*9/32, -1.5*earcap_pinpeg_length/8]) // earcap connection
            cylinder(r=earcap_pinpeg_radius*1.75, h=3*earcap_pinpeg_length/8, center=true);
        translate([earcover_width/8,-earcover_length*9/32, -1.5*earcap_pinpeg_length/8]) // earcap connection
            cylinder(r=earcap_pinpeg_radius*1.75, h=3*earcap_pinpeg_length/8, center=true);
        ovalTube(3, 40, 50, 50, center=true);
    } 
        rotate([0,0,360/16]) sound_holes();
        translate([-earcover_width/8,earcover_length*9/32, -earcap_pinpeg_length]) //earcap connection hole
            pinhole(r=earcap_pinpeg_radius, h=earcap_pinpeg_length);
        translate([earcover_width/8,-earcover_length*9/32, -earcap_pinpeg_length]) //earcap connection hole
            pinhole(r=earcap_pinpeg_radius, h=earcap_pinpeg_length);
    }
}

module speaker_holder() {
    difference() {
        scale([speaker_scale,speaker_scale,0.9])  speaker();
        speaker();
        translate([speaker_diameter_outside * 15/16,0,0]) cube(speaker_diameter_outside, center=true);
        translate([-speaker_diameter_outside * 15/16,0,0]) cube(speaker_diameter_outside, center=true);
    }
}


module sound_holes() {
    hole_radius = 3;
    num_holes = 8;
    num_rings = 2;
    radius = speaker_diameter_outside / 3;
    angle_step = 360 / num_holes;
    for ( theta = [0 : angle_step : 360] ) {
        rotate([0,0,theta]) translate([0, radius, 0]) cylinder(r=hole_radius, h=20, center=true);
        rotate([0,0,theta+angle_step/2]) translate([0, radius/2, 0]) 
                cylinder(r=hole_radius*2/3, h=20, center=true);
    }
}

module headbandv2_top() {
    $fn=150;
    headband_less_angle = -90;
    difference() {
    union() {
        band(headband_width/2+headband_thickness*2, headband_thickness*3, 
            headband_height, headband_less_angle+10);
        scale([1,1- arc_scaling ,1]) 
        band(headband_width/2*1.02, 2, headband_height,headband_less_angle+4);
        //scale([1,1- arc_scaling*3/4 ,1]) 
        //	band(headband_width/2*1.01, 1, headband_height, headband_less_angle+5);
        scale([1,1- arc_scaling/2 ,1]) 
            band(headband_width/2*1.00, 2, headband_height, headband_less_angle+4);
    }
        band(headband_width/2+headband_thickness*1.2, 
            headband_thickness*1.4, headband_height*.8, headband_less_angle+20);
        translate([0,headband_width/2 + headband_thickness*1.5,0]) rotate([90,0,0]) 
            cylinder(r=headband_thickness*4, h=headband_thickness+1, center=true);
        translate([0,headband_width/2+earcap_pinpeg_length-4,0]) rotate([90,0,0]) 
            pinhole(r=earcap_pinpeg_radius*.75, h=earcap_pinpeg_length);
        
    }
            //	translate([0,gap_width,0]) band(headband_width/2+gap_width, 
            //		headband_thickness, headband_height,headband_less_angle+10);
}

module headbandv2_bottom() {
    $fn=150;
    difference() {
    union() {
        translate([0,0,-headband_height/8]) rotate([0,0,48-20/2-5+10]) // main band
            band(headband_width/2*+1, headband_thickness, headband_height*.75,-90 + 12);
        rotate([0,0,-11]) translate([-headband_width/2*0.95,0,-headband_height/8]) 
            rotate([0,0,110]) translate([0,-headband_width/2*.8,0]) // support band
            band(headband_width/2*.8, headband_thickness, headband_height*.75,-160);
        // extended connection with earcovers
        earcup_connector(headband_height);
    }
    
    translate([0,0,headband_thickness/2-5])
    intersection() {
        rotate([180,0,0]) scale(0.263) bevel_top_gear (144,8); // .263 from .252
        rotate([0,0,61]) pie_slice(headband_width*2, 50, 2);
    }
    translate([0,0,headband_width*2-6]) rotate([0,0,61]) 
        pie_slice(headband_width*2, 50, 2);
    translate([0,0,headband_width*2+headband_thickness-3]) rotate([0,0,60-30/2]) 
       pie_slice(headband_width*2, 80, 2);
    translate([0,0,headband_height/2-4.7]) rotate([0,0,50-15]) 
        translate([0,headband_width/2-headband_thickness/2,0]) rotate([0,45,0]) 
        cube([headband_thickness*3,headband_thickness*3,headband_thickness*3], center=true);
    translate([0,0,headband_height/2-11]) rotate([0,0,20]) 
        translate([0,headband_width/2-headband_thickness/2,0]) rotate([0,48,0]) 
        cube([headband_thickness*3,headband_thickness*3,headband_thickness*3], center=true);
    }
    translate([0,0,-headband_height/2 + 6/2]) rotate([0,0,-25.8+30/2+3]) 
        band(headband_width/2*+1, headband_thickness, 6,-175.8); // latch
    
    
//module band (outside_radius, thickness, height, extra_angle = 0) { 
}

// Full headband
module headband_full() {
	$fn=150;
	difference() {
		for ( i = [0 : 1 : headband_count-1] ) { // primary arcs
			scale([1,1- arc_scaling*i ,1]) 
				band(headband_width/2, headband_thickness * (headband_count - i) 
					/ headband_count, headband_height);
			scale([1,1- arc_scaling/2*i ,1]) 
				band(headband_width/2, headband_thickness * (headband_count - i) 
					/ headband_count, headband_height, headband_extra_angle);
			scale([1,1- arc_scaling*3/4*i ,1]) 
				band(headband_width/2, headband_thickness * (headband_count - i) 
					/ headband_count, headband_height, headband_extra_angle);
		}
	}
	// extended connection with earcovers
	translate([0,0,0*headband_height/2]) earcup_connector();
	translate([0,0,0*headband_height/2]) mirror([1,0,0]) earcup_connector();
}

// half headband, with puzzle joint in the middle
module headband_half() {
	$fn=150;
	joint_length = 15;
	ear_connector_extra_angle = 0;
	difference() {
		union() {
			headband_full();
			intersection() { // add the solid structure at the crown, where there is a connection
				difference() {
					cylinder(r=headband_width/2, h=headband_height, center=true);
					scale([1,1- arc_scaling*1,1])
					cylinder(r=headband_width/2, h=headband_height, center=true);
				}
				rotate([0,0,90]) pie_slice(headband_width,crown_arc_angle,30);
			}
		}
		// subtract out the half
		translate([headband_width/2 - dovetail_length, 0, 0]) 
			cube([headband_width, headband_width, headband_width], center=true); 
	}
	translate([-dovetail_length,headband_width/2*(1-arc_scaling/2) - 2,0]) 
		dovetail_inner(joint_length, arc_scaling*headband_width/2+1, headband_height);
}


module earcup_connector(headband_height) {
	$fn=150;
	ear_connector_extra_angle = 0;
	translate([-(headband_width)/2  * cos(headband_extra_angle/2), - (headband_width)/2 * sin(headband_extra_angle/2), 0]) 
	translate([headband_extra_thickness/3* cos(headband_extra_angle/2), 
		headband_extra_thickness/3 * sin(headband_extra_angle/2), -headband_height/2])
	rotate([0,0,180 + headband_extra_angle*2/4 + ear_connector_extra_angle]) 
	union() {
	difference() {
		union() {
			cube([headband_extra_thickness, headband_extra_length - headband_height/4, headband_height], center=false);
			rotate([0,90, 0]) translate([-headband_height/2, 0,0]) 
				cylinder(r=headband_height/2, h=headband_extra_thickness, center=false);
			rotate([0,90, 0]) translate([-headband_height/2, headband_extra_length - headband_height/4,0]) 
				cylinder(r=headband_height/2, h=headband_extra_thickness, center=false);
		}
		//rotate([0,90, 0]) translate([-headband_height/2, headband_extra_length-earcover_pinpeg_radius,0]) 
		//	pinhole(r=earcover_pinpeg_radius, h=earcover_pinpeg_length);
		// angled rise to keep symmetry with warping
		translate([0,headband_height+earcover_pinpeg_radius/2,-headband_height/4]) rotate([45,0,0]) 
			cube([headband_height,headband_height*2,headband_height], center=true);
		translate([0,headband_height+earcover_pinpeg_radius/2,headband_height*5/4]) rotate([-45,0,0]) 
			cube([headband_height,headband_height*2,headband_height], center=true);
		translate([0,-headband_height/2-earcover_pinpeg_radius/2,headband_height*5/4]) rotate([45,0,0]) 
			cube([headband_height,headband_height*2,headband_height], center=true);
		translate([0,-headband_height/2-earcover_pinpeg_radius/2,-headband_height/4]) rotate([-45,0,0]) 
			cube([headband_height,headband_height*2,headband_height], center=true);
		translate([0,headband_height*2,headband_height/2]) 
			cube([headband_height,headband_height*2,headband_height], center=true);
		rotate([0,90, 0]) translate([-headband_height/2, 
                    headband_extra_length-earcover_pinpeg_radius,-earcover_pinpeg_length/2-1]) 
			pinhole(r=earcover_pinpeg_radius, h=earcover_pinpeg_length);
	}
		linear_extrude(height=headband_height*.75) import("earcup_connect.dxf");
	}
}

module pin1() {
	pinpeg(r=earcap_pinpeg_radius, h=earcap_pinpeg_length);
}

module pin2() {
	pinpeg(r=earcover_pinpeg_radius, h=earcover_pinpeg_length);
}

//
/// Props
//

module speaker() {
	translate([0,0,15])
	scale([1,1,1.5])
	union() {
		translate([0,0,speaker_overall_height/4]) 
			cylinder(r=speaker_diameter_outside/2, h=speaker_rim_height, center=true);
		translate([0,0,-speaker_overall_height/4]) 
			cylinder(r=speaker_diameter_inside/2, h=speaker_overall_height-speaker_rim_height, center=true);
	};
}

//
/// Helper functions
//

module band (outside_radius, thickness, height, extra_angle = 0) { 
	// thin-walled half-cylinder 
	angle = 180 + extra_angle;
	intersection () {
		rotate([0,0,-(angle-180)/2]) pie_slice(outside_radius*2, angle, angle/5);
		difference() {
			cylinder(r=outside_radius, h=height, center=true);
			cylinder(r=outside_radius - thickness, h=height*2, center=true);
		}
	}
}

module teardrop_flat(diameter) {
	union() {
		circle(r = diameter/2, $fn = 100, center=true);
		rotate(45) square(diameter/2);
	}
}

module cross_section(diameter, thickness) {
	difference() {
		teardrop_flat(diameter);
		teardrop_flat(diameter - thickness*2);
		translate([0,-diameter/2,0]) square([diameter*2,diameter], center=true);
	}
}

module pie_slice(radius, angle, step) {
	for(theta = [0:step:angle-step]) {
		rotate([0,0,0]) linear_extrude(height = radius*2, center=true)
		polygon( points = [[0,0],[radius * cos(theta+step) ,radius * sin(theta+step)],[radius*cos(theta),radius*sin(theta)]]);
	}
}

module partial_rotate_extrude(angle, radius, convex) {
	intersection () {
		rotate_extrude(convexity=convex) translate([radius,0,0]) child(0);
		pie_slice(100, angle, angle/5);
	}
} 
module dovetail_inner(length, width, depth){
	translate([-length/2,0,0])
	rotate([0,0,180])
	union() {
		//cube([length/2, width, depth] ,center=true);
		translate([-length,0,0]) linear_extrude(height=depth,center=true,convexity=10,twist=0)
			polygon(points=[[0,-width*7/24],[0,width*7/24],[length,0]],center=true);
	}
}

module dovetail_outer(length, width, depth) {
	difference(){
		cube([length, width, depth] ,center=true);
		linear_extrude(height=depth*2,center=true,convexity=10,twist=0)
			polygon(points=[[0,-width*7/24],[0,width*7/24],[length,0]],center=true);
	}
}

module dovetail_subtract(length, width, depth) {
	linear_extrude(height=depth*2,center=true,convexity=10,twist=0)
		polygon(points=[[0,-width*7.5/24],[0,width*7.5/24],[length * 1.1,0]],center=true); 
}

module dovetail_join(length, width, depth) {
	difference(){
		cube([length, width, depth] ,center=true);
		dovetail_subtract(length,width,depth);
	}
}





