

tube_dia       = 46.00; // cardboard tube diameter
tube_thickness = 0.5;   // cardboard thickness
side_thickness = 0.8;   // thickness of the printed spool side(0.8mm )
side_dia       = 100;   // diameter of the printed spool side (10cm  )
side_wall_w    = 0.9;   // wall holding cardboard width (0.9mm)
side_wall_h    = 2;     // wall holding cardboard height (2mm)
base_hole_dia  = 5;     // shaft hole dia (5mm)

//calculated dimensions
baseholeR   = base_hole_dia / 2;

innerholeR  = (tube_dia / 2 - tube_thickness - 0.1 - side_wall_w - baseholeR ) * 0.8 / 2;
innerholeRR = innerholeR/0.8 + baseholeR;
innerholes  = floor(innerholeRR * 2 * 3.1415 * 0.8 / (innerholeR * 2));

outerholeR  = (side_dia / 2 - tube_dia / 2 - tube_thickness - 0.1 - side_wall_w ) * 0.8 / 2;
outerholeRR = side_dia / 2 - outerholeR / 0.8;
outerholes  = floor(outerholeRR * 2 * 3.1415 * 0.8 / (outerholeR * 2));


difference() {
    cylinder(h = side_thickness, r = side_dia / 2, center = false);
    translate (v=[0,0,-0.1]) union(){
        cylinder(h = side_thickness+0.2, r = baseholeR, center = false);

        for ( i = [0 : innerholes - 1] ){
            rotate( i * 360 / innerholes, [0, 0, 1])
            translate([0, innerholeRR, 0])
            cylinder(h = side_thickness+0.2, r = innerholeR, center = false);
        }   

        for ( i = [0 : outerholes - 1] ){
            rotate( i * 360 / outerholes, [0, 0, 1])
            translate([0, outerholeRR, 0])
            cylinder(h = side_thickness+0.2, r = outerholeR, center = false);
        }                
    }
}

translate (v=[0,0,side_thickness]) difference(){
    cylinder(h = side_wall_h, r = tube_dia / 2 + tube_thickness + 0.1 + side_wall_w, center = false);
    translate (v=[0,0,-0.1]) cylinder(h = side_wall_h+0.2, r = tube_dia / 2 + tube_thickness + 0.1, center = false);
}

translate (v=[0,0,side_thickness]) difference(){
    cylinder(h = side_wall_h, r = tube_dia / 2 - tube_thickness + 0.1, center = false);
    translate (v=[0,0,-0.1]) cylinder(h = side_wall_h+0.2, r = tube_dia / 2 - tube_thickness - 0.1 - side_wall_w, center = false);
}

