// soap dish, one piece with drain

bcr = 18;  // bottom corner radius
bx = 110;  // bottom section width
by = 80;   // bottom section depth
th = 15;   // dish height

ucr = 16;  // upper curve radius, upper circle rad
uch = 3;  // top bevil radius, upper circle height
dui = 1; // how far to inset upper rad centers from bottom

difference() {
  soapDishMain();

  intersection() {
    translate([0,0,-1]) scale([0.95,0.93,.91]) 
      soapDishBody(bx,by,th,bcr,ucr);
    translate([0,0,-1]) hexGrid();
  }

  //translate([0,0,-1]) cube([100,100,100]);
}

module soapDishMain() {
  difference() {
    soapDishBody(bx,by,th,bcr,ucr);
    translate([0,0,th+4]) soapCutout(15);
  }
}

module soapCutout(d) {
  hull() {
    scale([bx*.4,by*.4,d]) sphere(r=1,$fn=80);

    for(a=[-1,1]) for(b=[-1,1])
      translate([a*bx*.36,b*by*.32,0])
        scale([ucr*.8,ucr*.8,10]) sphere(r=1,$fn=36);
  }
}

module soapDishBody(bx0,by0,th0,bcr0,ucr0) {
dx = bx0/2-bcr0;
dy = by0/2-bcr0;
du = -dui+bcr0-ucr0;

  hull() {
    for(x=[-1,1]) for(y=[-1,1]) {
      translate([x*dx,y*dy,0])
        cylinder(r=bcr0,h=2,$fn=80);
    }

    for(x=[-1,1]) for(y=[-1,1]) {
      translate([x*(dx+du),y*(dy+du),th0-uch])
        scale([ucr0,ucr0,uch]) sphere(r=1,$fn=60);
    }

  }
}

module hexGrid() {
rh=3.8;
rs=4.4;
c30=cos(30);
translate([-1.5*rs,c30*rs,0])
  for (j=[-7:6]) for (i=[-4:5]) translate([i*rs*3,j*2*c30*rs,0]) hex(rh);
  for (j=[-6:6]) for (i=[-5:5]) translate([i*rs*3,j*2*c30*rs,0]) hex(rh);
}
module hex(r) { cylinder(r1=r-.3,r2=r+.4,h=16,$fn=6); }