/*
 Improved version of the box described in thing:931437

http://www.thingiverse.com/thing:931437

This box has fewer sides and an approximate 4 fold rotation axis.
It is easily "popped open" by pressing on opposite upright faces.

The box is based on a dual to an 18 electron solution of the Thomson
problem:

http://www-wales.ch.cam.ac.uk/~wales/CCD/Thomson/table.html

The dual has 18 faces, 32 vertices, and 48 edges.  Like the previous box it
was made hollow and divided into two parts.  For this box the two parts
are essentially identical, each has 9 faces.  They are connected by tongue
and groove as before - but with a slightly different design adding larger
spheres to the grooves.

if mark = 1  makes the top half with the grooves

if makr = 1 makes the bottom half with the tongue

PCM  July 2015

*/



s_all = 1;
sc32 = 0.875;

mark = 2;


if (mark==2)

    scale([1.5,1.5,1])
   union()
    {
 union()
        {
 wire_frame(inside_edges_9,atoms_twice,2.1,1.85,6);
polyhedron(atoms_twice,faces_less_9);
        }


}


else

if (mark==1)




    scale([1.5,1.5,1])
    difference()
    {

polyhedron(atoms_twice,faces_less_9b);
       union()

{
wire_frame(inside_edges_9,atoms_twice,2.25,2,6);



}
}


else

{}



module wire_frame(edges,points,rs,rb,fc)
{
for (i = [0:len(edges)-1])
{
ee = edges[i];
pp = points[ee[0]];
qq = points[ee[1]];
translate(pp)
sphere(r=rs,center=true,$fn=24);
tx = (qq[0] + pp[0])/2;
ty = (qq[1] + pp[1])/2;
tz = (qq[2] + pp[2])/2;
ax = qq[0] - pp[0] ;
ay = qq[1] - pp[1];
az = qq[2] - pp[2];
translate(v=[tx,ty,tz])
rotate(a = [-acos(az/sqrt(ax*ax+ay*ay+az*az)), 0, -atan2(ax, ay)])
cylinder(r=rb,h=sqrt(ax*ax+ay*ay+az*az),center=true,$fn=fc);
}
}



       atoms_twice =  s_all* [
                 [ -16.64590,  16.53460,  -6.25042]*sc32,
                 [ -17.32210,   4.31634, -17.31200]*sc32,
                 [ -20.68190,  11.07860,   6.25042]*sc32,
                 [ -22.45810,  -6.79058,  -6.25042]*sc32,
                 [ -23.46210,  -0.07872,   6.25042]*sc32,
                 [ -11.20940,  -6.73737,  21.00000]*sc32,
                 [  -6.73737,  11.20940,  21.00000]*sc32,
                 [ -15.30070,  -9.19646,  17.31200]*sc32,
                 [  -9.19646,  15.30070,  17.31200]*sc32,
                 [ -16.53460, -16.64590,  -6.25042]*sc32,
                 [ -11.07860, -20.68190,   6.25042]*sc32,
                 [  -0.07872,  23.46210,   6.25042]*sc32,
                 [  -6.79058,  22.45810,  -6.25042]*sc32,
                 [ -12.69030,   3.16217, -21.00000]*sc32,
                 [  -3.16217, -12.69030, -21.00000]*sc32,
                 [  -4.31634, -17.32210, -17.31200]*sc32,
                 [   4.31634,  17.32210, -17.31200]*sc32,
                 [   3.16217,  12.69030, -21.00000]*sc32,
                 [   0.07872, -23.46210,   6.25042]*sc32,
                 [   9.19646, -15.30070,  17.31200]*sc32,
                 [   6.73737, -11.20940,  21.00000]*sc32,
                 [  11.20940,   6.73737,  21.00000]*sc32,
                 [  15.30070,   9.19646,  17.31200]*sc32,
                 [  11.07860,  20.68190,   6.25042]*sc32,
                 [   6.79058, -22.45810,  -6.25042]*sc32,
                 [  16.53460,  16.64590,  -6.25042]*sc32,
                 [  12.69030,  -3.16217, -21.00000]*sc32,
                 [  17.32210,  -4.31634, -17.31200]*sc32,
                 [  16.64590, -16.53460,  -6.25042]*sc32,
                 [  22.45810,   6.79058,  -6.25042]*sc32,
                 [  20.68190, -11.07860,   6.25042]*sc32,
                 [  23.46210,   0.07872,   6.25042]*sc32,
                 [ -16.64590,  16.53460,  -6.25042],
                 [ -17.32210,   4.31634, -17.31200],
                 [ -20.68190,  11.07860,   6.25042],
                 [ -22.45810,  -6.79058,  -6.25042],
                 [ -23.46210,  -0.07872,   6.25042],
                 [ -11.20940,  -6.73737,  21.00000],
                 [  -6.73737,  11.20940,  21.00000],
                 [ -15.30070,  -9.19646,  17.31200],
                 [  -9.19646,  15.30070,  17.31200],
                 [ -16.53460, -16.64590,  -6.25042],
                 [ -11.07860, -20.68190,   6.25042],
                 [  -0.07872,  23.46210,   6.25042],
                 [  -6.79058,  22.45810,  -6.25042],
                 [ -12.69030,   3.16217, -21.00000],
                 [  -3.16217, -12.69030, -21.00000],
                 [  -4.31634, -17.32210, -17.31200],
                 [   4.31634,  17.32210, -17.31200],
                 [   3.16217,  12.69030, -21.00000],
                 [   0.07872, -23.46210,   6.25042],
                 [   9.19646, -15.30070,  17.31200],
                 [   6.73737, -11.20940,  21.00000],
                 [  11.20940,   6.73737,  21.00000],
                 [  15.30070,   9.19646,  17.31200],
                 [  11.07860,  20.68190,   6.25042],
                 [   6.79058, -22.45810,  -6.25042],
                 [  16.53460,  16.64590,  -6.25042],
                 [  12.69030,  -3.16217, -21.00000],
                 [  17.32210,  -4.31634, -17.31200],
                 [  16.64590, -16.53460,  -6.25042],
                 [  22.45810,   6.79058,  -6.25042],
                 [  20.68190, -11.07860,   6.25042],
                 [  23.46210,   0.07872,   6.25042],
                      ];





  faces_less_9    = [

//[ 20, 21,  6,  5],
//[ 37, 38, 53, 52],
[ 17, 26, 14, 13],
[ 45, 46, 58, 49],
[ 23, 25, 16, 12, 11],
[ 43, 44, 48, 57, 55],
//[  9, 10,  7,  4,  3],
//[ 35, 36, 39, 42, 41],
[  1,  3,  4,  2,  0],
[ 32, 34, 36, 35, 33],
//[ 31, 29, 25, 23, 22],
//[ 54, 55, 57, 61, 63],
[ 29, 31, 30, 28, 27],
[ 59, 60, 62, 63, 61],
//[ 24, 28, 30, 19, 18],
//[ 50, 51, 62, 60, 56],
[ 15, 24, 18, 10,  9],
[ 41, 42, 50, 56, 47],
//[  2,  8, 11, 12,  0],
//[ 32, 44, 43, 40, 34],
[ 13, 14, 15,  9,  3,  1],
[ 33, 35, 41, 47, 46, 45],
//[  4,  7,  5,  6,  8,  2],
//[ 34, 40, 38, 37, 39, 36],
[ 25, 29, 27, 26, 17, 16],
[ 48, 49, 58, 59, 61, 57],
[ 26, 27, 28, 24, 15, 14],
[ 46, 47, 56, 60, 59, 58],
[ 12, 16, 17, 13,  1,  0],
[ 32, 33, 45, 49, 48, 44],
//[ 21, 22, 23, 11,  8,  6],
//[ 38, 40, 43, 55, 54, 53],
//[ 30, 31, 22, 21, 20, 19],
//[ 51, 52, 53, 54, 63, 62],
//[  7, 10, 18, 19, 20,  5],
//[ 37, 52, 51, 50, 42, 39],

  [10,18,50,42],
  [2,4,36,34],
  [23,11,43,55],
  [30,31,63,62],
  [0,2,34,32],
  [4,3,35,36],
  [3,9,41,35],
  [9,10,42,41],
  [18,24,56,50],
  [24,28,60,56],
  [28,30,62,60],
  [31,29,61,63],
  [29,25,57,61],
  [25,23,55,57],
  [11,12,44,43],
  [12,0,32,44],
      ];


  faces_less_9b   = [

[ 20, 21,  6,  5],
[ 37, 38, 53, 52],
//[ 17, 26, 14, 13],
//[ 45, 46, 58, 49],
//[ 23, 25, 16, 12, 11],
//[ 43, 44, 48, 57, 55],
[  9, 10,  7,  4,  3],
[ 35, 36, 39, 42, 41],
//[  1,  3,  4,  2,  0],
//[ 32, 34, 36, 35, 33],
[ 31, 29, 25, 23, 22],
[ 54, 55, 57, 61, 63],
//[ 29, 31, 30, 28, 27],
//[ 59, 60, 62, 63, 61],
[ 24, 28, 30, 19, 18],
[ 50, 51, 62, 60, 56],
//[ 15, 24, 18, 10,  9],
//[ 41, 42, 50, 56, 47],
[  2,  8, 11, 12,  0],
[ 32, 44, 43, 40, 34],
//[ 13, 14, 15,  9,  3,  1],
//[ 33, 35, 41, 47, 46, 45],
[  4,  7,  5,  6,  8,  2],
[ 34, 40, 38, 37, 39, 36],
//[ 25, 29, 27, 26, 17, 16],
//[ 48, 49, 58, 59, 61, 57],
//[ 26, 27, 28, 24, 15, 14],
//[ 46, 47, 56, 60, 59, 58],
//[ 12, 16, 17, 13,  1,  0],
//[ 32, 33, 45, 49, 48, 44],
[ 21, 22, 23, 11,  8,  6],
[ 38, 40, 43, 55, 54, 53],
[ 30, 31, 22, 21, 20, 19],
[ 51, 52, 53, 54, 63, 62],
[  7, 10, 18, 19, 20,  5],
[ 37, 52, 51, 50, 42, 39],

  [42,50,18,10],
  [34,36,4,2],
  [55,43,11,23],
  [62,63,31,30],
  [32,34,2,0],
  [36,35,3,4],
  [35,41,9,3],
  [41,42,10,9],
  [50,56,24,18],
  [56,60,28,24],
  [60,62,30,28],
  [63,61,29,31],
  [61,57,25,29],
  [57,55,23,25],
  [43,44,12,11],
  [44,32,0,12],
      ];

inside_edges_9 = [
 [10,18],
  [2,4,],
  [23,11],
  [30,31],
  [0,2],
  [4,3],
  [3,9],
  [9,10],
  [18,24],
  [24,28],
  [28,30],
  [31,29],
  [29,25],
  [25,23],
  [11,12],
  [12,0],];
