////////////////////////////////////////////////
/////////////// VARIABLES

//Outer Cylinder
cyl_out_height = 13;
cyl_out_diameter = 15.5;
//Inner Cylinder
cyl_in_height = cyl_out_height;
cyl_in_diameter = 13.5;
//Cube -- for cutout
cu_width = 20;
cu_height = 9.5; 
cu_depth = 9;
//Base
base_inner = 9.7;
base_height = 1.2;
//Cone_cube
thin_side_cone = 3.25;
thick_side_cone = 8.1;
width_cone = 15;

//Locating_pins
loc_pin_thin = 10;
loc_pin_thick = 14.02;
loc_pin_height = 6;
loc_pin_width = 7.05;

//Edge
edge_diameter = 12.65;
edge_cube_size = 8.75;
////////////////////////////////////////////////
/////////////// RENDER


//shell(); //main body
//base(); //base
difference(){
composite_shell();
composite_outer_cuts();
}

locating_pin();

//cone_cut();
////////////////////////////////////////////////
/////////////// FUNCTIONS
module composite_outer_cuts(){
    union(){
    side_cuts();
    mirror([1,0,0]){
        side_cuts();
    }
}
}

module composite_shell(){
    union(){
        shell();
        base();
    }
}
module side_cuts() {
    translate([(edge_diameter/2)+(edge_cube_size/2),0 ,-cyl_out_height/2]){
    cube(edge_cube_size, center = true);
    }
}
module locating_pin(){
    translate([0, 0, base_height/2]){
    intersection(){
    cube ([cu_width, loc_pin_height, loc_pin_width], center = true);
    difference(){
    //outer
    $fn = 64;
    cylinder(h = loc_pin_height, r1 = loc_pin_thin/+1.5, r2 = loc_pin_thick/2+2.5, center = true);
    
    //innner
    $fn = 64;
    cylinder(h = loc_pin_height, r1 = loc_pin_thin/2, r2 = loc_pin_thick/2, center = true);
   }
   }
   }
}



module cone_cut(){
    translate([0, 0, base_height/2]){
    resize(newsize=[thick_side_cone,cyl_out_diameter*4,cyl_out_height-(base_height/2)]){
    rotate([0,0,45]){
    $fn = 4;
    cylinder(h = cyl_out_height, r1 = thin_side_cone, r2 = thick_side_cone, center = true);
    }
}
}
}

module shell(){
    $fn = 100;
    difference(){
        cylinder(h = cyl_out_height, d = cyl_out_diameter, center = true);
        cylinder(h = cyl_in_height, d = cyl_in_diameter, center = true);
        translate([0, 0, -(base_height)]){
        cube ([cu_width, cu_height, cu_depth], center = true);
        }
        cone_cut();
    }
}

module base(){
    translate([0, 0, (-((cyl_in_height/2)-(base_height/2)))]){
    $fn = 100;
    difference(){
        //outer
        cylinder(h = base_height, d = cyl_out_diameter, center = true);
        //inner
        cylinder(h = base_height, d = base_inner, center = true);
    }
}
}