// preview[view:south, tilt:top]

use <utils/build_plate.scad>

/* [Text] */
// Possible characters: A-Z, a-z, .!?-
name = "Westley";
move_text_x = 0; // [-20:50]
move_text_y = 0; // [-8:8]
squeeze_text_x = 100; // [10:10:200]
squeeze_text_y = 100; // [10:10:200]
text_style = 0; // [0:Intrude, 1:Extrude, 2:None]

/* [Design] */
// The design on the top of the dagger.
design_top_style = 0; // [0:Intrude, 1:Extrude, 2:None]
// The design on the bottom of the dagger.
design_bottom_style = 0; // [0:Intrude, 1:Extrude, 2:None]

/* [Export Options] */

//Optional: export the model as multiple pieces.
multiple_parts = 0; //  [0:One Piece, 1:Two Pieces (Top/Bottom), 2:Two Pieces (Blade/Hilt)]
part = 1; // [1, 2]



/* [Hidden] */
input = name;
pieces = multiple_parts;
scale_model = model_scale / 100.0;
place_text_x = move_text_x + 3;
place_text_y = move_text_y;
squeeze_x = squeeze_text_x / 100;
squeeze_y = squeeze_text_y / 100;


string = [ for (index = [0 : len(input)-1]) let (letter = input[index]) letter];

function calculateOffset(i) = (i == 0 ? offsetForLetter(string[i]) : offsetForLetter(string[i]) + calculateOffset(i-1));

offsets = [ for (index = [0 : len(string)-1]) let (off = offsetForLetter(string[index])) off ];
echo(offsets);


function sumOffsets(i) = (i == 0 ? offsets[i] : offsets[i] + sumOffsets(i-1));
sum_offsets = [ for (index = [0 : len(string)-1]) let (off = sumOffsets(index)) off ];
real_offsets = concat([0], sum_offsets);
echo(real_offsets);


function placeX(x) = x;
function placeY(x) = sin(((x-26)/2)*18)*1.2 - 1 + place_text_y;


if(pieces == 0){ //One Piece
    if (part == 1){
        drawDagger();
    } else {
        drawDagger();
    }
} else if (pieces == 1){ // Top/Bottom
    if (part == 1){ //Top
        difference(){
            drawDagger();
            translate([-200, -50, -50])
            cube([400, 100, 50]);
        }
    } else if (part == 2){ //Bottom
        rotate([180, 0, 0])
        difference(){
            drawDagger();
            translate([-200, -50, 0])
            cube([400, 100, 50]);
        }
    } else { //Nothing
        placeholder();
    }
} else if(pieces == 2){ // Blade/Hilt
    if (part == 1){ // Blade
        translate([-35, 0, 0])
        difference(){
            drawDagger(); 
            translate([-259, -50, -50])
            cube([200, 100, 100]);
        }
    } else if (part == 2){ // Hilt
        translate([105, 0, 0])
        difference(){
            drawDagger();
            translate([-59, -50, -50])
            cube([400, 100, 100]);
        }
    } else { //Nothing
        placeholder();
    }
} /*else { // Hilt, Blade Top/Bottom
    if (part == 0){ // Blade Top
        translate([-35, 0, 0])
        difference(){
            difference(){
                drawDagger(); 
                translate([-259.44, -50, -50])
                cube([200, 100, 100]);
            }
            
            translate([-200, -50, -50])
            cube([400, 100, 50]);
        }
    } else if (part == 1){ //Blade Bottom
        translate([-35, 0, 0])
        rotate([180, 0, 0])
        difference(){
            difference(){
                drawDagger(); 
                translate([-259.44, -50, -50])
                cube([200, 100, 100]);
            }
            
            translate([-200, -50, 0])
            cube([400, 100, 50]);
        }
    } else { // Hilt
        translate([105, 0, 0])
        difference(){
            drawDagger();
            translate([-59.44, -50, -50])
            cube([400, 100, 100]);
        }
    }
}*/


module placeholder(){
    translate([-100, -100, 0])
    cube(1);
    translate([100, -100, 0])
    cube(1);
    translate([-100, 100, 0])
    cube(1);
    translate([100, 100, 0])
    cube(1);
}




module drawDagger(){
    translate([-22, 0, 0]){ scale(1.1){
        union(){
            difference(){
                color("lightgray")
                Cube_001(); // Draw Blade
                if (design_top_style == 0)
                    DaggerDesign3(); // Design Top
                if (design_bottom_style == 0)
                    DaggerDesign3_001(); //Design Bottom
                if (text_style == 0)
                    drawText();
            }
            
            color("black"){
                if (design_top_style == 1)
                    DaggerDesign3(); // Design Top
                if (design_bottom_style == 1)
                    DaggerDesign3_001(); //Design Bottom
                if (text_style == 1)
                    drawText();
            }
            
            color("darkgray")
            DaggerHandle_fixed(); // Draw Hilt
        }
    }}     
}

module drawText(){
    translate([22, 0, 0])
    rotate([0, 1.2, 0]){
            translate([0, 0, 3])
            scale([squeeze_x, squeeze_y, .6]){
                for(index = [0:len(string)-1]){ // Draw each letter
                    drawLetter(string[index], real_offsets[index]+ place_text_x);
                }
            }
        }
}


module drawLetter (letter, x){
    x_offset = x-(real_offsets[len(real_offsets)-1]/2);
    
    translate([placeX(x_offset), placeY(x_offset), 0]){
    if (letter == "A") LettersManifold_001();
    else if (letter == "B") LettersManifold_002();
    else if (letter == "C") { LettersManifold_003(); }
    else if (letter == "D") { LettersManifold_004(); }
    else if (letter == "E") { LettersManifold_005(); }
    else if (letter == "F") { LettersManifold_006(); }
    else if (letter == "G") { LettersManifold_007(); }
    else if (letter == "H") { LettersManifold_008(); }
    else if (letter == "I") { LettersManifold_009(); }
    else if (letter == "J") { LettersManifold_010(); }
    else if (letter == "K") { LettersManifold_011(); }
    else if (letter == "L") { LettersManifold_012(); }
    else if (letter == "M") { LettersManifold_013(); }
    else if (letter == "N") { LettersManifold_014(); }
    else if (letter == "O") { LettersManifold_015(); }
    else if (letter == "P") { LettersManifold_016(); }
    else if (letter == "Q") { LettersManifold_017(); }
    else if (letter == "R") { LettersManifold_018(); }
    else if (letter == "S") { LettersManifold_019(); }
    else if (letter == "T") { LettersManifold_020(); }
    else if (letter == "U") { LettersManifold_021(); }
    else if (letter == "V") { LettersManifold_022(); }
    else if (letter == "W") { LettersManifold_023(); }
    else if (letter == "X") { LettersManifold_024(); }
    else if (letter == "Y") { LettersManifold_025(); }
    else if (letter == "Z") { LettersManifold_026(); }
    else if (letter == "a") { LettersManifold_027(); }
    else if (letter == "b") { LettersManifold_028(); }
    else if (letter == "c") { LettersManifold_029(); }
    else if (letter == "d") { LettersManifold_030(); }
    else if (letter == "e") { LettersManifold_031(); }
    else if (letter == "f") { LettersManifold_032(); }
    else if (letter == "g") { LettersManifold_033(); }
    else if (letter == "h") { LettersManifold_034(); }
    else if (letter == "i") { LettersManifold_035(); }
    else if (letter == "j") { LettersManifold_036(); }
    else if (letter == "k") { LettersManifold_037(); }
    else if (letter == "l") { LettersManifold_038(); }
    else if (letter == "m") { LettersManifold_039(); }
    else if (letter == "n") { LettersManifold_040(); }
    else if (letter == "o") { LettersManifold_041(); }
    else if (letter == "p") { LettersManifold_042(); }
    else if (letter == "q") { LettersManifold_043(); }
    else if (letter == "r") { LettersManifold_044(); }
    else if (letter == "s") { LettersManifold_045(); }
    else if (letter == "t") { LettersManifold_046(); }
    else if (letter == "u") { LettersManifold_047(); }
    else if (letter == "v") { LettersManifold_048(); }
    else if (letter == "w") { LettersManifold_049(); }
    else if (letter == "x") { LettersManifold_050(); }
    else if (letter == "y") { LettersManifold_051(); }
    else if (letter == "z") { LettersManifold_052(); }
    else if (letter == "!") { LettersManifold_053(); }
    else if (letter == ".") { LettersManifold_054(); }
    else if (letter == "?") { LettersManifold_055(); }
    else if (letter == "-") { LettersManifold(); }

    }
}

function offsetForLetter(letter) = (
    letter == "A" ? 11 : 
    letter == "B" ? 12.4 : 
    letter == "C" ? 11 : 
    letter == "D" ? 13 : 
    letter == "E" ? 9 : 
    letter == "F" ? 9.4 : 
    letter == "G" ? 12.4 : 
    letter == "H" ? 9 : 
    letter == "I" ? 9 : 
    letter == "J" ? 9 : 
    letter == "K" ? 10 : 
    letter == "L" ? 11 : 
    letter == "M" ? 14 : 
    letter == "N" ? 12 : 
    letter == "O" ? 13 : 
    letter == "P" ? 11 : 
    letter == "Q" ? 13 : 
    letter == "R" ? 12 : 
    letter == "S" ? 10 : 
    letter == "T" ? 11 : 
    letter == "U" ? 11.4 : 
    letter == "V" ? 11 : 
    letter == "W" ? 16 : 
    letter == "X" ? 11 : 
    letter == "Y" ? 10.4 : 
    letter == "Z" ? 9.6 : 
    letter == "a" ? 7.4 : 
    letter == "b" ? 6 : 
    letter == "c" ? 5 : 
    letter == "d" ? 6 : 
    letter == "e" ? 4.5 : 
    letter == "f" ? 4.5 : 
    letter == "g" ? 7 : 
    letter == "h" ? 6 : 
    letter == "i" ? 3.4 : 
    letter == "j" ? 4 : 
    letter == "k" ? 6 : 
    letter == "l" ? 3.4 : 
    letter == "m" ? 10 : 
    letter == "n" ? 7 : 
    letter == "o" ? 6 : 
    letter == "p" ? 6 : 
    letter == "q" ? 7 : 
    letter == "r" ? 5 : 
    letter == "s" ? 5 : 
    letter == "t" ? 4.4 : 
    letter == "u" ? 7 : 
    letter == "v" ? 8 : 
    letter == "w" ? 10 : 
    letter == "x" ? 6 : 
    letter == "y" ? 5 : 
    letter == "z" ? 6 : 
    letter == "0" ? 6 : 
    letter == "1" ? 3 : 
    letter == "2" ? 6 : 
    letter == "3" ? 6 : 
    letter == "4" ? 7 : 
    letter == "5" ? 6 : 
    letter == "6" ? 6 : 
    letter == "7" ? 6 : 
    letter == "8" ? 6 : 
    letter == "9" ? 6 : 
    letter == "!" ? 4 :
    letter == "." ? 4 :
    letter == "?" ? 6 :
    letter == "-" ? 8 :
    letter == " " ? 5 : 0
    
);

function DaggerHandle_fixed_dimX() = 115.38;
function DaggerHandle_fixed_dimY() = 40.24;
function DaggerHandle_fixed_dimZ() = 29.89;
function DaggerHandle_fixed_multmatrix() = [[1.000000,0.000000,0.000000,0.000000],[0.000000,1.000000,0.000000,0.000000],[0.000000,0.000000,1.000000,0.000000],[0.000000,0.000000,0.000000,1.000000]];

function DaggerHandle_fixed_triangles() = [
[2,1,0],[3,2,0],[4,3,0],[6,0,5],[1,5,0],[9,8,7],[11,9,10],[12,11,10],[13,12,10],[14,13,10],[7,10,9],[16,14,15],[17,16,15],[18,17,15],[10,15,14],[19,18,15],[20,19,15],[21,20,15],[22,21,15],[23,22,15],[24,23,15],[25,24,15],[26,25,15],[27,26,15],[0,29,28],[30,4,0],[31,30,0],[32,31,0],[33,32,0],[34,33,0],[35,34,0],[36,35,0],[37,36,0],[39,38,37],[28,41,40],[28,40,42],[28,42,43],[28,43,44],[28,44,45],[28,45,46],[28,46,39],[28,39,37],[28,37,0],[47,27,15],[48,47,15],[49,48,15],[50,49,15],[51,50,15],[52,51,15],[53,52,15],[54,53,15],[55,54,15],[56,55,15],[57,56,15],[58,57,15],[59,58,15],[60,59,15],[6,60,15],[0,6,15],[15,61,0],[0,61,62],[62,29,0],[65,64,63],[66,63,64],[67,66,64],[68,67,64],[69,68,64],[70,69,64],[70,71,69],[71,70,72],[74,73,28],[75,74,28],[41,28,73],[65,75,28],[64,65,28],[76,29,62],[62,77,76],[76,79,78],[79,76,77],[76,78,80],[76,80,81],[76,81,82],[76,82,83],[83,84,76],[84,83,85],[84,85,86],[84,86,87],[76,84,28],[28,29,76],[88,10,7],[7,89,88],[91,90,89],[88,89,90],[90,92,88],[88,94,93],[88,93,95],[88,95,96],[94,88,92],[99,98,97],[96,99,97],[88,96,97],[88,97,15],[15,10,88],[100,61,15],[15,97,100],[101,97,98],[97,101,100],[103,102,100],[101,103,100],[104,100,102],[79,77,105],[104,105,77],[100,104,77],[100,77,62],[62,61,100],[106,64,28],[28,84,106],[106,87,107],[87,106,84],[106,107,108],[106,108,109],[106,109,110],[110,111,106],[111,110,112],[106,111,70],[70,64,106],[115,114,113],[115,113,116],[115,118,117],[115,117,119],[115,119,114],[118,115,120],[121,120,7],[120,121,122],[120,122,118],[7,8,123],[7,123,124],[7,124,121],[127,126,125],[130,129,128],[125,130,128],[127,125,128],[133,132,131],[133,131,127],[133,127,128],[132,133,134],[137,136,135],[137,135,138],[137,138,134],[137,134,133],[137,139,136],[139,137,140],[141,140,115],[140,141,142],[140,142,143],[140,143,144],[140,144,139],[115,116,145],[115,145,146],[115,146,147],[115,147,141],[150,149,148],[148,152,151],[150,148,151],[153,150,151],[156,155,154],[155,156,153],[155,153,151],[128,158,157],[128,157,159],[128,159,154],[128,154,155],[158,128,129],[161,160,137],[137,133,161],[161,133,128],[128,162,161],[162,163,161],[163,162,164],[164,162,165],[165,162,166],[167,161,163],[169,161,168],[168,161,170],[170,161,167],[171,161,169],[161,171,160],[172,89,7],[7,120,172],[172,120,115],[115,173,172],[175,174,172],[176,175,172],[173,176,172],[178,177,172],[179,178,172],[174,179,172],[180,172,177],[172,180,181],[89,181,91],[181,89,172],[182,173,115],[115,140,182],[182,140,137],[137,160,182],[184,183,182],[160,184,182],[184,160,171],[185,182,183],[182,185,186],[182,186,187],[176,173,187],[182,187,173],[188,162,128],[128,155,188],[188,155,151],[151,189,188],[189,190,188],[190,189,191],[193,188,192],[192,188,190],[194,188,193],[166,188,194],[188,166,162],[197,196,195],[197,195,198],[197,198,199],[201,200,196],[197,201,196],[201,197,202],[204,202,203],[202,204,205],[202,205,206],[202,206,201],[203,207,204],[210,209,208],[211,210,208],[212,211,208],[215,214,213],[216,212,208],[215,216,208],[214,215,208],[217,213,214],[218,217,214],[219,218,214],[220,219,214],[222,220,221],[220,222,223],[220,223,219],[224,221,197],[221,224,225],[221,225,222],[197,199,226],[197,226,227],[197,227,228],[197,228,224],[229,72,70],[230,229,70],[233,232,231],[234,230,70],[233,234,70],[232,233,70],[235,231,232],[236,235,232],[237,236,232],[208,237,232],[209,238,208],[237,208,238],[240,239,220],[220,214,240],[240,214,208],[208,241,240],[242,240,241],[243,242,241],[244,243,241],[245,244,241],[242,246,240],[240,248,247],[240,247,249],[246,248,240],[249,239,240],[239,249,250],[252,251,203],[203,202,252],[252,202,197],[197,253,252],[255,254,253],[254,256,253],[256,252,253],[258,252,257],[257,252,259],[259,252,256],[252,258,260],[260,261,252],[261,251,252],[251,261,262],[263,253,197],[197,221,263],[263,221,220],[220,239,263],[239,250,264],[264,265,239],[265,263,239],[263,265,266],[266,267,263],[267,268,263],[253,268,255],[268,253,263],[269,241,208],[208,232,269],[269,232,70],[70,111,269],[270,269,111],[271,270,111],[112,271,111],[273,272,269],[270,273,269],[272,274,269],[245,241,269],[274,245,269],[276,275,203],[277,276,203],[203,275,207],[279,277,278],[280,279,278],[281,280,278],[203,278,277],[278,282,281],[284,283,281],[284,281,282],[287,286,285],[285,284,282],[287,285,282],[290,289,288],[289,290,291],[293,292,288],[293,288,289],[293,295,294],[293,294,296],[293,296,297],[293,297,298],[293,298,292],[299,287,282],[300,299,282],[282,301,300],[303,302,300],[303,300,301],[304,303,301],[305,304,301],[306,305,301],[301,307,306],[308,306,307],[289,291,309],[289,309,308],[289,308,307],[151,311,310],[151,310,312],[313,312,310],[151,314,311],[314,151,152],[295,293,315],[312,313,316],[312,316,317],[312,317,315],[312,315,293],[318,289,307],[307,319,318],[319,320,318],[320,319,321],[323,322,318],[323,318,324],[324,318,320],[322,325,318],[318,325,326],[325,327,326],[327,328,326],[328,329,326],[318,326,293],[293,289,318],[330,278,203],[203,251,330],[262,331,251],[330,251,331],[332,330,331],[330,332,333],[333,334,330],[334,335,330],[335,336,330],[336,337,330],[337,338,330],[338,339,330],[330,339,282],[282,278,330],[340,301,282],[282,339,340],[339,338,341],[341,340,339],[343,340,342],[342,340,341],[340,343,344],[344,345,340],[345,319,340],[319,345,321],[340,319,307],[307,301,340],[346,312,293],[293,326,346],[326,329,346],[329,347,346],[347,348,346],[348,349,346],[349,350,346],[346,350,189],[350,351,189],[351,191,189],[346,189,151],[151,312,346],[354,353,352],[352,355,354],[355,352,356],[356,357,355],[353,359,358],[358,352,353],[352,358,360],[360,356,352],[354,355,361],[361,362,354],[362,361,363],[363,364,362],[355,357,365],[365,361,355],[361,365,366],[366,363,361],[354,362,367],[367,368,354],[368,367,369],[369,370,368],[362,364,371],[371,367,362],[367,371,372],[372,369,367],[354,368,373],[373,353,354],[353,373,374],[374,359,353],[368,370,375],[375,373,368],[373,375,376],[376,374,373],[379,378,377],[377,380,379],[382,380,381],[380,377,381],[383,382,381],[364,385,384],[385,364,363],[377,378,363],[378,386,363],[386,385,363],[377,363,366],[366,381,377],[388,371,387],[384,387,364],[387,371,364],[390,372,389],[371,388,391],[391,392,371],[389,372,393],[393,372,392],[392,372,371],[396,395,394],[394,395,397],[397,395,398],[398,395,399],[399,400,398],[399,395,375],[375,370,399],[403,402,401],[404,403,401],[396,404,395],[404,396,403],[395,404,376],[376,375,395],[400,399,405],[405,399,406],[406,399,407],[407,408,406],[408,407,409],[409,407,410],[410,407,411],[411,407,412],[413,411,412],[399,370,369],[369,407,399],[407,369,372],[372,412,407],[401,402,414],[412,415,413],[415,412,416],[416,372,417],[417,372,418],[372,416,412],[418,419,417],[390,420,372],[420,418,372],[420,390,421],[421,390,422],[425,424,423],[428,427,426],[431,430,429],[430,427,429],[427,428,429],[429,428,432],[432,433,429],[436,435,434],[426,437,428],[437,438,428],[438,435,428],[435,436,428],[428,436,439],[439,432,428],[442,441,440],[441,429,440],[429,441,431],[444,443,440],[443,442,440],[446,444,445],[440,445,444],[423,446,445],[425,423,445],[429,433,447],[447,440,429],[440,447,448],[448,445,440],[450,449,436],[434,450,436],[452,439,451],[451,439,453],[451,454,452],[454,455,452],[436,449,439],[449,456,439],[456,453,439],[453,456,457],[460,459,458],[462,461,459],[460,462,459],[462,460,463],[463,464,462],[467,466,465],[467,465,468],[466,467,469],[460,458,466],[469,460,466],[460,469,470],[470,463,460],[473,472,471],[473,471,461],[462,473,461],[473,474,472],[476,475,474],[473,476,474],[476,477,475],[462,464,478],[478,473,462],[473,478,479],[479,476,473],[480,467,468],[483,482,481],[484,483,481],[483,484,485],[486,485,484],[487,486,484],[488,487,484],[487,488,489],[476,491,490],[476,490,477],[481,476,484],[476,481,492],[476,492,491],[484,476,479],[479,488,484],[495,494,493],[495,493,496],[494,495,497],[499,498,497],[499,497,495],[499,500,498],[503,502,501],[501,504,503],[504,501,495],[495,496,505],[495,505,506],[495,506,504],[502,508,507],[507,501,502],[501,507,499],[499,495,501],[504,509,503],[510,503,509],[503,510,511],[503,511,512],[513,512,511],[512,513,514],[512,514,515],[516,504,506],[504,516,517],[504,517,509],[503,512,518],[518,519,503],[519,518,358],[358,359,519],[512,515,520],[520,518,512],[518,520,360],[360,358,518],[503,519,521],[521,502,503],[502,521,522],[522,508,502],[519,359,374],[374,521,519],[521,374,376],[376,522,521],[525,524,523],[523,526,525],[526,523,507],[507,508,526],[524,528,527],[527,523,524],[523,527,499],[499,507,523],[525,526,529],[529,530,525],[530,529,404],[404,401,530],[526,508,522],[522,529,526],[529,522,376],[376,404,529],[525,530,531],[531,524,525],[524,531,532],[532,528,524],[414,530,401],[530,414,533],[530,533,534],[534,535,531],[530,534,531],[531,537,536],[537,531,535],[536,538,532],[531,536,532],[541,540,539],[539,542,541],[542,539,527],[527,528,542],[540,544,543],[543,539,540],[539,543,499],[499,527,539],[541,542,545],[545,546,541],[548,547,546],[545,548,546],[425,546,424],[549,424,546],[547,549,546],[542,528,532],[532,545,542],[550,532,538],[532,550,545],[548,545,551],[550,551,545],[541,546,552],[552,540,541],[540,552,553],[553,544,540],[546,425,445],[445,552,546],[552,445,448],[448,553,552],[556,555,554],[554,557,556],[557,554,543],[543,544,557],[555,559,558],[555,558,560],[555,560,561],[561,554,555],[554,561,499],[499,543,554],[556,557,562],[562,563,556],[563,562,564],[564,565,563],[557,544,553],[553,562,557],[562,553,448],[448,564,562],[556,563,566],[566,567,556],[567,566,469],[469,467,567],[563,565,568],[568,566,563],[566,568,470],[470,469,566],[567,570,569],[567,569,556],[571,556,569],[556,571,555],[573,572,555],[571,573,555],[559,555,572],[467,480,574],[467,574,567],[570,567,574],[576,561,575],[577,575,561],[560,577,561],[578,500,499],[561,576,578],[561,578,499],[581,580,579],[583,580,582],[580,581,582],[584,582,581],[582,584,585],[585,584,586],[586,584,587],[587,584,588],[590,381,589],[381,590,383],[579,589,581],[589,381,581],[581,381,366],[366,584,581],[591,515,514],[594,593,592],[592,593,595],[595,593,596],[593,597,596],[597,593,365],[365,357,597],[588,584,598],[598,584,594],[584,593,594],[593,584,366],[366,365,593],[596,597,599],[597,600,599],[599,600,601],[601,600,602],[600,520,602],[515,602,520],[602,515,603],[603,515,591],[597,357,356],[356,600,597],[600,356,360],[360,520,600],[606,605,604],[607,606,604],[607,608,606],[610,609,607],[439,612,611],[439,611,610],[439,610,607],[608,607,609],[439,452,612],[615,614,613],[616,613,614],[616,614,617],[618,616,617],[619,618,617],[619,604,605],[604,619,617],[620,489,488],[615,620,488],[614,615,488],[614,488,479],[479,617,614],[623,622,621],[621,624,623],[624,621,447],[447,433,624],[622,565,564],[564,621,622],[621,564,448],[448,447,621],[623,624,625],[625,626,623],[626,625,607],[607,604,626],[624,433,432],[432,625,624],[625,432,439],[439,607,625],[623,626,627],[627,628,623],[628,627,478],[478,464,628],[626,604,617],[617,627,626],[627,617,479],[479,478,627],[623,628,629],[629,622,623],[622,629,568],[568,565,622],[628,464,463],[463,629,628],[629,463,470],[470,568,629],[632,631,630],[631,632,633],[632,634,633],[633,634,635],[635,634,636],[636,634,637],[637,638,636],[641,640,639],[639,640,642],[642,640,630],[630,640,632],[632,640,643],[643,634,632],[638,637,644],[644,637,645],[646,644,645],[645,647,646],[647,645,648],[651,650,649],[650,648,649],[648,645,649],[652,651,649],[655,654,653],[653,656,655],[656,653,657],[657,658,656],[654,637,634],[634,653,654],[653,634,643],[643,657,653],[655,656,659],[659,660,655],[660,659,661],[661,662,660],[656,658,663],[663,659,656],[659,663,664],[664,661,659],[655,660,665],[665,666,655],[666,665,667],[667,668,666],[660,662,669],[669,665,660],[665,669,670],[670,667,665],[655,666,671],[671,654,655],[654,671,645],[645,637,654],[666,668,672],[672,671,666],[671,672,649],[649,645,671],[675,674,673],[676,675,673],[678,677,652],[677,679,652],[652,649,678],[681,678,680],[680,678,674],[674,678,673],[673,678,649],[681,680,682],[685,684,683],[684,685,686],[688,686,687],[686,685,687],[687,685,672],[672,668,687],[673,689,676],[689,673,690],[690,673,691],[691,673,683],[683,673,685],[685,673,649],[649,672,685],[687,692,688],[692,687,693],[693,687,694],[695,693,694],[695,697,696],[696,697,698],[697,695,694],[700,698,699],[698,697,699],[687,668,667],[667,694,687],[694,667,670],[670,697,694],[699,701,700],[704,703,702],[703,704,705],[708,707,706],[708,706,709],[706,705,709],[705,710,709],[710,705,704],[711,709,710],[709,711,712],[712,711,713],[716,715,714],[719,718,717],[721,717,720],[717,718,720],[720,722,721],[720,718,723],[723,724,720],[726,715,725],[715,716,725],[719,727,725],[727,726,725],[725,718,719],[718,725,728],[728,723,718],[731,730,729],[722,720,730],[730,720,729],[729,732,731],[734,733,704],[733,735,704],[735,732,704],[732,729,704],[702,734,704],[720,724,736],[736,729,720],[729,736,710],[710,704,729],[739,738,737],[737,741,740],[741,737,738],[744,743,742],[744,742,741],[738,744,741],[744,746,745],[744,745,743],[749,748,747],[738,739,747],[738,747,748],[738,748,750],[750,744,738],[753,752,751],[755,753,754],[753,755,756],[753,756,752],[754,753,757],[757,758,754],[744,759,746],[751,744,753],[744,751,759],[753,744,750],[750,757,753],[754,760,755],[760,754,761],[761,762,760],[761,763,762],[763,761,764],[767,766,765],[767,765,763],[764,767,763],[754,758,768],[768,761,754],[761,768,769],[769,764,761],[767,770,766],[773,772,771],[772,773,774],[774,773,775],[778,777,776],[776,777,771],[771,777,773],[781,780,779],[779,780,782],[784,783,780],[780,781,784],[786,783,785],[785,783,784],[783,786,787],[789,782,788],[788,782,790],[782,789,779],[780,783,791],[791,792,780],[792,791,793],[793,794,792],[775,773,795],[795,773,787],[787,773,783],[773,791,783],[791,773,777],[777,793,791],[780,792,796],[796,797,780],[797,796,669],[669,662,797],[792,794,798],[798,796,792],[796,798,670],[670,669,796],[780,797,799],[799,782,780],[782,799,800],[800,790,782],[797,662,661],[661,799,797],[799,661,664],[664,800,799],[803,802,801],[801,804,803],[804,801,798],[798,794,804],[802,699,697],[697,801,802],[801,697,670],[670,798,801],[803,804,805],[805,806,803],[806,805,807],[807,808,806],[804,794,793],[793,805,804],[805,793,777],[777,807,805],[803,806,809],[809,802,803],[811,810,809],[810,802,809],[802,701,699],[701,802,812],[812,802,810],[806,808,813],[813,809,806],[815,814,813],[814,816,813],[816,809,813],[809,816,811],[819,818,817],[817,820,819],[820,817,813],[813,808,820],[818,716,714],[714,821,818],[821,822,818],[822,823,818],[823,817,818],[817,823,824],[813,825,815],[824,825,817],[825,813,817],[819,820,826],[826,827,819],[827,826,828],[828,829,827],[820,808,807],[807,826,820],[826,807,777],[777,828,826],[819,827,830],[830,818,819],[818,830,725],[725,716,818],[827,829,831],[831,830,827],[830,831,728],[728,725,830],[834,833,832],[832,835,834],[835,832,831],[831,829,835],[833,837,836],[836,832,833],[832,836,728],[728,831,832],[834,835,838],[838,839,834],[839,838,840],[842,839,841],[841,839,843],[843,839,840],[835,829,828],[828,838,835],[838,828,777],[777,840,838],[844,834,839],[834,844,845],[847,846,845],[845,846,834],[846,847,848],[770,767,848],[848,767,846],[839,842,849],[849,850,839],[850,844,839],[834,846,851],[851,833,834],[833,851,852],[852,837,833],[846,767,764],[764,851,846],[851,764,769],[769,852,851],[854,853,840],[853,843,840],[840,855,854],[855,840,856],[856,840,777],[778,856,777],[790,857,788],[860,859,858],[858,862,861],[862,858,859],[862,859,663],[663,658,862],[857,790,863],[863,790,864],[790,800,864],[864,859,860],[859,864,800],[859,800,664],[664,663,859],[861,866,865],[865,866,867],[866,861,862],[867,866,868],[869,868,866],[868,869,870],[870,869,871],[862,658,657],[657,866,862],[866,657,643],[643,869,866],[874,873,872],[873,874,875],[875,876,873],[876,875,877],[877,875,640],[640,641,877],[871,869,878],[878,869,879],[879,869,880],[880,869,874],[869,875,874],[875,869,643],[643,640,875],[883,882,881],[881,884,883],[884,881,736],[736,724,884],[882,886,885],[885,881,882],[881,885,710],[710,736,881],[883,884,887],[887,888,883],[888,887,836],[836,837,888],[884,724,723],[723,887,884],[887,723,728],[728,836,887],[883,888,889],[889,890,883],[890,889,768],[768,758,890],[888,837,852],[852,889,888],[889,852,769],[769,768,889],[883,890,891],[891,882,883],[882,891,892],[892,886,882],[890,758,757],[757,891,890],[891,757,750],[750,892,891],[894,893,885],[886,895,894],[886,894,885],[896,711,710],[897,885,893],[885,897,898],[899,896,710],[898,899,710],[885,898,710],[902,901,900],[901,902,903],[748,904,903],[748,903,902],[748,749,905],[748,905,904],[892,906,886],[895,886,906],[892,902,900],[892,900,907],[892,907,906],[902,892,750],[750,748,902],[910,909,908],[908,911,910],[910,911,912],[912,913,910],[910,913,914],[914,915,910],[910,915,916],[916,909,910],[919,918,917],[921,917,920],[920,917,922],[922,917,923],[917,921,924],[924,919,917],[927,926,925],[925,926,928],[924,929,919],[929,930,919],[930,928,919],[928,926,919],[926,931,919],[919,931,932],[932,933,919],[919,933,934],[934,918,919],[936,935,916],[916,915,936],[936,915,914],[914,937,936],[936,937,938],[938,939,936],[936,939,940],[940,935,936],[942,941,934],[934,933,942],[942,933,932],[932,943,942],[942,943,944],[944,945,942],[942,945,946],[946,941,942],[419,418,947],[947,420,948],[420,947,418],[420,421,948],[422,948,421],[948,422,390],[948,390,389],[948,389,393],[948,393,392],[948,392,949],[949,950,948],[952,951,950],[948,950,951],[954,953,948],[955,954,948],[951,955,948],[947,948,953],[688,692,956],[956,692,957],[688,956,686],[692,693,957],[693,695,957],[695,696,957],[812,958,701],[701,958,700],[700,958,698],[698,958,696],[696,958,957],[958,959,957],[957,959,932],[932,931,957],[957,931,926],[926,956,957],[962,961,960],[960,963,962],[962,963,964],[964,965,962],[962,965,966],[966,961,962],[967,943,932],[932,959,967],[967,959,958],[958,968,967],[967,968,944],[944,943,967],[971,970,969],[970,971,972],[872,873,971],[873,876,971],[876,877,971],[877,641,971],[641,639,971],[639,972,971],[642,630,639],[631,633,630],[635,972,633],[633,972,630],[630,972,639],[972,644,646],[646,647,972],[636,638,635],[644,972,638],[638,972,635],[647,648,972],[648,973,972],[973,974,972],[972,974,975],[975,970,972],[978,977,976],[977,979,976],[981,977,980],[980,977,978],[983,977,982],[982,977,981],[985,984,983],[984,977,983],[977,984,986],[986,987,977],[977,987,988],[988,979,977],[388,989,391],[385,386,384],[387,384,989],[384,386,989],[989,388,387],[382,383,380],[383,590,380],[379,380,378],[386,378,989],[378,380,989],[380,590,989],[580,990,579],[579,990,589],[589,990,590],[590,990,989],[990,580,583],[976,979,990],[979,989,990],[989,979,988],[988,991,989],[989,991,949],[391,989,392],[392,989,949],[992,965,964],[964,993,992],[992,993,916],[916,935,992],[992,935,940],[940,994,992],[992,994,966],[966,965,992],[997,996,995],[955,951,995],[951,952,995],[999,997,998],[998,997,1000],[1000,997,952],[952,997,995],[999,908,997],[908,999,1001],[1001,1002,908],[1002,1003,908],[1003,1004,908],[908,909,997],[997,909,916],[916,993,997],[997,993,964],[964,996,997],[984,1006,1005],[1006,984,1007],[1007,984,985],[1009,1005,1008],[1008,1005,1006],[1011,1005,1010],[1010,1005,1009],[1005,969,970],[969,1005,1011],[1005,970,975],[975,1012,1005],[1005,1012,986],[986,984,1005],[1013,937,914],[914,1014,1013],[1013,1014,934],[934,941,1013],[1013,941,946],[946,1015,1013],[1013,1015,938],[938,937,1013],[1016,913,912],[912,1017,1016],[1016,1017,917],[917,918,1016],[1016,918,934],[934,1014,1016],[1016,1014,914],[914,913,1016],[1019,1018,986],[986,1012,1019],[1019,1012,975],[975,1020,1019],[1019,1020,1021],[1021,1022,1019],[1019,1022,1023],[1023,1018,1019],[1024,950,949],[949,991,1024],[1024,991,988],[988,1025,1024],[1024,1025,1026],[1026,1027,1024],[998,1000,1024],[1024,1027,998],[952,950,1000],[1000,950,1024],[679,1028,652],[652,1028,651],[651,1028,650],[1028,679,677],[678,681,677],[677,681,1028],[1029,681,682],[681,1029,1028],[1030,927,1028],[927,925,1028],[1028,1029,1030],[925,1031,1028],[1031,925,928],[1028,1031,973],[650,1028,648],[648,1028,973],[406,408,405],[408,1032,405],[408,409,1032],[1032,409,1033],[409,410,1033],[415,416,413],[411,413,410],[410,413,1033],[413,416,1033],[416,417,1033],[417,419,1033],[1033,419,947],[947,1034,1033],[1034,947,953],[1034,1035,1033],[1033,1035,995],[995,1032,1033],[1036,1020,975],[975,974,1036],[1036,974,973],[973,1031,1036],[930,1036,928],[928,1036,1031],[929,1036,930],[1036,929,1037],[1036,1037,1021],[1021,1020,1036],[1038,1025,988],[988,987,1038],[1038,987,986],[986,1018,1038],[1038,1018,1023],[1023,1039,1038],[1038,1039,1026],[1026,1025,1038],[1040,963,960],[960,533,414],[960,414,402],[960,402,403],[960,403,396],[960,396,394],[960,394,1040],[397,398,1040],[394,397,1040],[400,405,1032],[400,1032,398],[1032,1040,398],[1040,1032,995],[995,996,1040],[1040,996,964],[964,963,1040],[1042,1041,1023],[1023,1022,1042],[1042,1022,1021],[1021,1043,1042],[1042,1043,917],[917,1017,1042],[1042,1017,912],[912,1041,1042],[1002,1001,1044],[999,1044,1001],[1027,999,998],[1044,999,1027],[1044,1027,1026],[1026,1045,1044],[1044,1045,908],[908,1004,1044],[1003,1044,1004],[954,955,995],[1003,1002,1044],[995,1035,1034],[995,1034,954],[953,954,1034],[680,1046,682],[1046,1029,682],[675,676,674],[689,690,676],[690,1046,676],[676,1046,674],[674,1046,680],[691,1046,690],[683,956,691],[956,1046,691],[684,686,683],[683,686,956],[1046,956,926],[926,1047,1046],[1047,1048,1046],[1048,1030,1029],[1029,1046,1048],[958,814,815],[814,958,816],[816,958,811],[811,958,810],[810,958,812],[960,537,535],[960,535,534],[960,534,533],[960,536,537],[536,960,538],[1049,1043,1021],[1021,1037,1049],[929,924,1037],[924,921,1049],[1037,924,1049],[920,1049,921],[1048,1047,926],[1030,1048,926],[1049,920,922],[922,923,1049],[1030,926,927],[1049,923,917],[917,1043,1049],[1050,1045,1026],[1026,1039,1050],[1050,1039,1023],[1023,1041,1050],[1050,1041,912],[912,911,1050],[1050,911,908],[908,1045,1050],[1053,1052,1051],[1051,1054,1053],[1053,1056,1055],[1055,1052,1053],[1053,1058,1057],[1057,1056,1053],[1053,1054,1059],[1059,1058,1053],[1062,1061,1060],[1062,1060,1063],[1062,1063,1064],[1061,1062,1065],[1066,1065,1062],[1062,1067,1066],[1066,1069,1068],[1068,1071,1070],[1068,1070,1072],[1073,1065,1066],[1074,1073,1066],[1072,1074,1066],[1068,1072,1066],[1066,1076,1075],[1075,1069,1066],[1066,1067,1077],[1077,1076,1066],[1078,1058,1059],[1059,1079,1078],[1078,1080,1057],[1057,1058,1078],[1078,939,938],[938,1080,1078],[1078,1079,940],[940,939,1078],[1081,1076,1077],[1077,1082,1081],[1081,1083,1075],[1075,1076,1081],[1081,945,944],[944,1083,1081],[1081,1082,946],[946,945,1081],[1084,454,451],[453,1085,451],[1084,451,1085],[1085,453,457],[452,455,1084],[612,452,1084],[611,612,1084],[454,1084,455],[1084,1087,1086],[1086,610,611],[1086,611,1084],[1088,1084,1085],[1084,1088,1089],[1084,1089,1090],[1084,1090,1091],[1091,1092,1087],[1087,1084,1091],[721,1093,717],[717,1093,719],[719,1093,727],[721,722,1094],[721,1094,1093],[1094,722,730],[1093,1095,958],[727,1093,726],[726,1093,715],[715,1093,714],[714,1093,821],[821,1093,958],[1093,1069,1075],[1075,1095,1093],[1093,1094,1068],[1068,1069,1093],[1097,1096,960],[960,961,1097],[1097,1099,1098],[1098,1096,1097],[1097,961,966],[966,1099,1097],[1100,1095,1075],[1075,1083,1100],[1100,968,958],[958,1095,1100],[1100,1083,944],[944,968,1100],[737,740,1101],[739,737,1101],[747,739,1101],[749,747,1101],[905,749,1101],[1102,905,1101],[1104,1101,1103],[1101,1104,1102],[894,1102,893],[897,893,1102],[895,906,907],[1102,894,895],[1102,895,907],[903,904,905],[900,901,903],[1102,907,900],[1102,900,903],[1102,903,905],[1102,1106,1105],[898,897,1102],[1105,898,1102],[1102,1104,1107],[1107,1106,1102],[1110,1109,1108],[1110,1108,1111],[1110,1111,1112],[1113,1110,1112],[1116,1115,1114],[1110,1116,1114],[1110,1114,1117],[1110,1117,1109],[1110,1119,1118],[1118,1116,1110],[1110,1113,1120],[1120,1119,1110],[489,620,615],[487,489,615],[615,613,616],[616,618,1121],[615,616,1121],[487,615,1121],[486,487,1121],[608,1121,606],[1121,608,609],[618,619,605],[605,606,1121],[618,605,1121],[1113,1112,1122],[1121,1113,1122],[1122,483,485],[1122,485,486],[1122,486,1121],[483,1122,482],[1121,1123,1120],[1120,1113,1121],[1121,609,610],[1121,610,1086],[1086,1123,1121],[1125,1124,1098],[1098,1099,1125],[1125,1079,1059],[1059,1124,1125],[1125,994,940],[940,1079,1125],[1125,1099,966],[966,994,1125],[1091,1090,1126],[1092,1091,1126],[1129,1128,1127],[1129,1127,1130],[1129,1130,1092],[1129,1092,1126],[1126,1131,1129],[1129,1054,1051],[1133,1132,1051],[1134,1133,1051],[1135,1134,1051],[1128,1051,1132],[1051,1128,1129],[1129,1124,1059],[1059,1054,1129],[1129,1131,1098],[1098,1124,1129],[1138,1137,1136],[1138,1136,1139],[1139,1116,1138],[1116,1139,1140],[1116,1140,1115],[1103,1138,1104],[1138,1103,1141],[1138,1141,1142],[1138,1142,1137],[1138,1143,1107],[1107,1104,1138],[1138,1116,1118],[1118,1143,1138],[1145,1144,1057],[1057,1080,1145],[1145,1082,1077],[1077,1144,1145],[1145,1015,946],[946,1082,1145],[1145,1080,938],[938,1015,1145],[1147,1146,1055],[1055,1056,1147],[1147,1067,1062],[1062,1146,1147],[1147,1144,1077],[1077,1067,1147],[1147,1056,1057],[1057,1144,1147],[1148,1143,1118],[1118,1149,1148],[1148,1150,1107],[1107,1143,1148],[1148,1152,1151],[1151,1150,1148],[1148,1149,1153],[1153,1152,1148],[1154,1123,1086],[1086,1087,1154],[1154,1155,1120],[1120,1123,1154],[1154,1157,1156],[1156,1155,1154],[1092,1130,1087],[1130,1154,1087],[1154,1127,1157],[1127,1154,1130],[1158,712,713],[713,711,1158],[711,896,1158],[896,899,1158],[708,1158,1159],[1159,707,708],[712,1158,709],[709,1158,708],[1160,1070,1158],[1070,1160,1072],[1162,1158,1161],[1161,1158,1071],[1071,1158,1070],[1158,1162,1159],[898,1105,899],[899,1105,1158],[1105,1160,1158],[438,437,1163],[437,426,1164],[437,1164,1163],[426,427,430],[1164,426,430],[457,456,1163],[457,1163,1085],[449,450,434],[434,435,438],[434,438,1163],[449,434,1163],[456,449,1163],[1163,1166,1165],[1165,1085,1163],[1085,1165,1088],[1163,1164,1126],[1126,1166,1163],[1167,1106,1107],[1107,1150,1167],[1167,1160,1105],[1105,1106,1167],[1073,1074,1167],[1167,1168,1073],[1074,1072,1167],[1072,1160,1167],[1167,1150,1151],[1151,1168,1167],[1169,1119,1120],[1120,1155,1169],[1169,1149,1118],[1118,1119,1169],[1169,1170,1153],[1153,1149,1169],[1169,1155,1156],[1156,1170,1169],[1171,443,444],[1171,444,446],[1171,446,423],[1171,423,424],[1171,424,549],[1171,549,960],[960,1096,1171],[1164,431,441],[1171,1164,441],[430,431,1164],[1171,441,442],[1171,442,443],[1171,1131,1126],[1126,1164,1171],[1171,1096,1098],[1098,1131,1171],[1172,1152,1153],[1153,1173,1172],[1172,1174,1151],[1151,1152,1172],[1172,1146,1062],[1062,1174,1172],[1172,1173,1055],[1055,1146,1172],[1175,1128,1132],[1128,1157,1127],[1128,1175,1157],[1132,1133,1175],[1175,1176,1156],[1156,1157,1175],[1175,1135,1051],[1051,1176,1175],[1175,1133,1134],[1165,1166,1126],[1089,1165,1126],[1165,1089,1088],[1175,1134,1135],[1090,1089,1126],[702,703,705],[733,734,702],[1177,733,702],[1177,702,705],[1177,705,706],[1177,706,707],[1159,1177,707],[1094,732,735],[1177,1094,735],[730,731,732],[730,732,1094],[1177,735,733],[1177,1178,1068],[1068,1094,1177],[1162,1179,1159],[1177,1159,1179],[1178,1177,1179],[825,824,958],[824,823,958],[823,822,958],[822,821,958],[815,825,958],[550,538,960],[551,550,960],[548,551,960],[547,548,960],[549,547,960],[1180,1168,1151],[1151,1174,1180],[1180,1060,1061],[1065,1073,1168],[1061,1065,1180],[1065,1168,1180],[1064,1063,1180],[1068,1161,1071],[1162,1161,1179],[1063,1060,1180],[1068,1178,1179],[1068,1179,1161],[1180,1174,1062],[1062,1064,1180],[1181,1170,1156],[1156,1176,1181],[1181,1173,1153],[1153,1170,1181],[1181,1052,1055],[1055,1173,1181],[1181,1176,1051],[1051,1052,1181],[1184,1183,1182],[1182,1185,1184],[1184,1185,1186],[1186,1187,1184],[1184,1187,1188],[1188,1189,1184],[1184,1189,1190],[1190,1183,1184],[1192,1191,1182],[1182,1183,1192],[1192,1183,1190],[1190,1193,1192],[1192,1193,1194],[1194,1195,1192],[1192,1195,1196],[1196,1191,1192],[1198,1197,1182],[1182,1191,1198],[1198,1191,1196],[1196,1199,1198],[1198,1199,1200],[1200,1201,1198],[1198,1201,1202],[1202,1197,1198],[1203,1185,1182],[1182,1197,1203],[1203,1197,1202],[1202,1204,1203],[1203,1204,1205],[1205,1206,1203],[1203,1206,1186],[1186,1185,1203],[1209,1208,1207],[1207,1210,1209],[1209,1210,1211],[1211,1212,1209],[1209,1212,1213],[1213,1214,1209],[1209,1214,1215],[1215,1208,1209],[1217,1216,1207],[1207,1208,1217],[1217,1208,1215],[1215,1218,1217],[1217,1218,1219],[1219,1220,1217],[1217,1220,1221],[1221,1216,1217],[1223,1222,1207],[1207,1216,1223],[1223,1216,1221],[1221,1224,1223],[1223,1224,1200],[1200,1199,1223],[1223,1199,1196],[1196,1222,1223],[1225,1210,1207],[1207,1222,1225],[1225,1222,1196],[1196,1195,1225],[1225,1195,1194],[1194,1226,1225],[1225,1226,1211],[1211,1210,1225],[1229,1228,1227],[1227,1230,1229],[1229,1230,1231],[1231,1232,1229],[1229,1232,1200],[1200,1224,1229],[1229,1224,1221],[1221,1228,1229],[1234,1233,1227],[1227,1228,1234],[1234,1228,1221],[1221,1220,1234],[1234,1220,1219],[1219,1235,1234],[1234,1235,1236],[1236,1233,1234],[1238,1237,1227],[1227,1233,1238],[1238,1233,1236],[1236,1239,1238],[1238,1239,1240],[1240,1241,1238],[1238,1242,1237],[1242,1238,1241],[1243,1230,1227],[1227,1237,1243],[1243,1237,1242],[1242,1244,1243],[1243,1244,1245],[1245,1246,1243],[1243,1246,1231],[1231,1230,1243],[1249,1248,1247],[1247,1250,1249],[1249,1250,1251],[1251,1252,1249],[1249,1252,1253],[1253,1254,1249],[1249,1254,1255],[1255,1248,1249],[1257,1256,1247],[1247,1248,1257],[1257,1248,1255],[1255,1258,1257],[1257,1258,1205],[1205,1204,1257],[1257,1204,1202],[1202,1256,1257],[1260,1259,1247],[1247,1256,1260],[1260,1256,1202],[1202,1201,1260],[1260,1201,1200],[1200,1232,1260],[1260,1232,1231],[1231,1259,1260],[1261,1250,1247],[1247,1259,1261],[1261,1259,1231],[1231,1246,1261],[1261,1246,1245],[1245,1262,1261],[1261,1262,1251],[1251,1250,1261],[1265,1264,1263],[1263,1266,1265],[1265,1266,1267],[1267,1268,1265],[1265,1268,1269],[1269,1270,1265],[1265,1270,1271],[1271,1264,1265],[1273,1272,1263],[1263,1264,1273],[1273,1264,1271],[1271,1274,1273],[1273,1274,1194],[1194,1193,1273],[1273,1193,1190],[1190,1272,1273],[1276,1275,1263],[1263,1272,1276],[1276,1272,1190],[1190,1189,1276],[1276,1189,1188],[1188,1277,1276],[1276,1277,1278],[1278,1275,1276],[1279,1266,1263],[1263,1275,1279],[1279,1275,1278],[1278,1280,1279],[1279,1280,1281],[1281,1282,1279],[1279,1282,1267],[1267,1266,1279],[1285,1284,1283],[1283,1286,1285],[1285,1286,1278],[1278,1277,1285],[1285,1277,1188],[1188,1287,1285],[1285,1287,1288],[1288,1284,1285],[1290,1289,1283],[1283,1284,1290],[1290,1284,1288],[1288,1291,1290],[1290,1291,1292],[1292,1293,1290],[1290,1293,1294],[1294,1289,1290],[1296,1295,1283],[1283,1289,1296],[1296,1289,1294],[1294,1297,1296],[1296,1297,1298],[1298,1299,1296],[1296,1299,1300],[1300,1295,1296],[1301,1286,1283],[1283,1295,1301],[1301,1295,1300],[1300,1302,1301],[1301,1302,1281],[1281,1280,1301],[1301,1280,1278],[1278,1286,1301],[1305,1304,1303],[1303,1306,1305],[1305,1306,1307],[1307,1308,1305],[1305,1308,1309],[1309,1310,1305],[1305,1310,1311],[1311,1304,1305],[1313,1312,1303],[1303,1304,1313],[1313,1304,1311],[1311,1314,1313],[1313,1314,1292],[1292,1291,1313],[1313,1291,1288],[1288,1312,1313],[1316,1315,1303],[1303,1312,1316],[1316,1312,1288],[1288,1287,1316],[1316,1287,1188],[1188,1187,1316],[1316,1187,1186],[1186,1315,1316],[1317,1306,1303],[1303,1315,1317],[1317,1315,1186],[1186,1206,1317],[1317,1206,1205],[1205,1318,1317],[1317,1318,1307],[1307,1306,1317],[1321,1320,1319],[1319,1322,1321],[1321,1322,1323],[1323,1324,1321],[1321,1324,1253],[1253,1252,1321],[1321,1252,1251],[1251,1320,1321],[1326,1325,1319],[1319,1320,1326],[1326,1320,1251],[1251,1262,1326],[1326,1262,1245],[1245,1327,1326],[1326,1327,1328],[1328,1325,1326],[1330,1329,1319],[1319,1325,1330],[1330,1325,1328],[1328,1331,1330],[1330,1331,1332],[1332,1333,1330],[1330,1333,1334],[1334,1329,1330],[1335,1322,1319],[1319,1329,1335],[1335,1329,1334],[1334,1336,1335],[1335,1336,1337],[1337,1338,1335],[1335,1338,1323],[1323,1322,1335],[1341,1340,1339],[1339,1342,1341],[1341,1342,1271],[1271,1270,1341],[1341,1270,1269],[1269,1343,1341],[1341,1343,1344],[1344,1340,1341],[1346,1345,1339],[1339,1340,1346],[1346,1340,1344],[1344,1347,1346],[1346,1347,1348],[1348,1349,1346],[1346,1349,1350],[1350,1345,1346],[1352,1351,1339],[1339,1345,1352],[1352,1345,1350],[1350,1353,1352],[1352,1353,1213],[1213,1212,1352],[1352,1212,1211],[1211,1351,1352],[1354,1342,1339],[1339,1351,1354],[1354,1351,1211],[1211,1226,1354],[1354,1226,1194],[1194,1274,1354],[1354,1274,1271],[1271,1342,1354],[1357,1356,1355],[1355,1358,1357],[1357,1358,1359],[1359,1360,1357],[1357,1360,1361],[1361,1362,1357],[1357,1362,1363],[1363,1356,1357],[1365,1364,1355],[1355,1356,1365],[1363,1366,1365],[1365,1356,1363],[1365,1366,1367],[1367,1368,1365],[1365,1368,1369],[1369,1364,1365],[1371,1370,1355],[1355,1364,1371],[1371,1364,1369],[1369,1372,1371],[1371,1372,1269],[1269,1268,1371],[1371,1268,1267],[1267,1370,1371],[1373,1358,1355],[1355,1370,1373],[1373,1370,1267],[1267,1282,1373],[1373,1282,1281],[1281,1374,1373],[1373,1374,1359],[1359,1358,1373],[1377,1376,1375],[1375,1378,1377],[1377,1378,1379],[1379,1380,1377],[1377,1380,1309],[1309,1308,1377],[1377,1308,1307],[1307,1376,1377],[1382,1381,1375],[1375,1376,1382],[1382,1376,1307],[1307,1318,1382],[1382,1318,1205],[1205,1258,1382],[1382,1258,1255],[1255,1381,1382],[1384,1383,1375],[1375,1381,1384],[1384,1381,1255],[1255,1254,1384],[1384,1254,1253],[1253,1385,1384],[1384,1386,1383],[1386,1384,1385],[1387,1378,1375],[1375,1383,1387],[1387,1383,1386],[1386,1388,1387],[1387,1388,1389],[1389,1390,1387],[1387,1390,1379],[1379,1378,1387],[1393,1392,1391],[1391,1394,1393],[1393,1394,1395],[1395,1396,1393],[1393,1396,1397],[1397,1398,1393],[1393,1398,1399],[1399,1392,1393],[1401,1400,1391],[1391,1392,1401],[1401,1392,1399],[1399,1402,1401],[1401,1402,1219],[1219,1218,1401],[1401,1218,1215],[1215,1400,1401],[1404,1403,1391],[1391,1400,1404],[1404,1400,1215],[1215,1214,1404],[1404,1214,1213],[1213,1405,1404],[1404,1405,1406],[1406,1403,1404],[1407,1394,1391],[1391,1403,1407],[1407,1403,1406],[1406,1408,1407],[1407,1408,1409],[1409,1410,1407],[1407,1410,1395],[1395,1394,1407],[1413,1412,1411],[1411,1414,1413],[1413,1414,1415],[1415,1416,1413],[1413,1416,1240],[1240,1239,1413],[1413,1239,1236],[1236,1412,1413],[1418,1417,1411],[1411,1412,1418],[1418,1412,1236],[1236,1235,1418],[1418,1235,1219],[1219,1402,1418],[1418,1402,1399],[1399,1417,1418],[1420,1419,1411],[1411,1417,1420],[1420,1417,1399],[1399,1398,1420],[1420,1398,1397],[1397,1421,1420],[1420,1421,1422],[1422,1419,1420],[1423,1414,1411],[1411,1419,1423],[1423,1419,1422],[1422,1424,1423],[1423,1424,1425],[1425,1426,1423],[1423,1426,1415],[1415,1414,1423],[1429,1428,1427],[1427,1430,1429],[1429,1430,1431],[1431,1432,1429],[1429,1432,1433],[1433,1434,1429],[1429,1434,1435],[1435,1428,1429],[1437,1436,1427],[1427,1428,1437],[1437,1428,1435],[1435,1438,1437],[1437,1438,1348],[1348,1347,1437],[1437,1347,1344],[1344,1436,1437],[1440,1439,1427],[1427,1436,1440],[1440,1436,1344],[1344,1343,1440],[1440,1343,1269],[1269,1372,1440],[1440,1372,1369],[1369,1439,1440],[1441,1430,1427],[1427,1439,1441],[1441,1439,1369],[1369,1368,1441],[1441,1368,1367],[1367,1442,1441],[1441,1442,1431],[1431,1430,1441],[1445,1444,1443],[1443,1446,1445],[1448,1447,1445],[1445,1446,1448],[1447,1361,1445],[1360,1445,1361],[1445,1360,1359],[1359,1444,1445],[1450,1449,1443],[1443,1444,1450],[1450,1444,1359],[1359,1374,1450],[1450,1374,1281],[1281,1302,1450],[1450,1302,1300],[1300,1449,1450],[1452,1451,1443],[1443,1449,1452],[1452,1449,1300],[1300,1299,1452],[1452,1299,1298],[1298,1453,1452],[1452,1453,1454],[1454,1451,1452],[1455,1446,1443],[1443,1451,1455],[1455,1451,1454],[1454,1456,1455],[1455,1456,1457],[1457,1458,1455],[1455,1458,1448],[1448,1446,1455],[1461,1460,1459],[1459,1462,1461],[1461,1462,1363],[1363,1362,1461],[1461,1362,1361],[1361,1463,1461],[1461,1463,1464],[1464,1460,1461],[1466,1465,1459],[1459,1460,1466],[1466,1460,1464],[1464,1467,1466],[1466,1467,1468],[1468,1469,1466],[1466,1469,1470],[1470,1465,1466],[1472,1471,1459],[1459,1465,1472],[1472,1465,1470],[1470,1473,1472],[1472,1473,1474],[1474,1475,1472],[1472,1475,1476],[1476,1471,1472],[1477,1462,1459],[1459,1471,1477],[1477,1471,1476],[1476,1478,1477],[1477,1478,1367],[1367,1366,1477],[1462,1477,1363],[1366,1363,1477],[1481,1480,1479],[1479,1482,1481],[1481,1482,1483],[1483,1484,1481],[1481,1484,1309],[1309,1380,1481],[1481,1380,1379],[1379,1480,1481],[1486,1485,1479],[1479,1480,1486],[1486,1480,1379],[1379,1390,1486],[1486,1390,1389],[1389,1487,1486],[1486,1487,1488],[1488,1485,1486],[1490,1489,1479],[1479,1485,1490],[1490,1485,1488],[1488,1491,1490],[1490,1491,1492],[1492,1493,1490],[1490,1493,1494],[1494,1489,1490],[1495,1482,1479],[1479,1489,1495],[1495,1489,1494],[1494,1496,1495],[1495,1496,1497],[1497,1498,1495],[1495,1498,1483],[1483,1482,1495],[1501,1500,1499],[1499,1502,1501],[1501,1502,1503],[1503,1504,1501],[1501,1504,1505],[1505,1506,1501],[1501,1506,1507],[1507,1500,1501],[1509,1508,1499],[1499,1500,1509],[1509,1500,1507],[1507,1510,1509],[1509,1510,1292],[1292,1314,1509],[1509,1314,1311],[1311,1508,1509],[1512,1511,1499],[1499,1508,1512],[1512,1508,1311],[1311,1310,1512],[1512,1310,1309],[1309,1484,1512],[1512,1484,1483],[1483,1511,1512],[1513,1502,1499],[1499,1511,1513],[1513,1511,1483],[1483,1498,1513],[1513,1498,1497],[1497,1514,1513],[1513,1514,1503],[1503,1502,1513],[1517,1516,1515],[1515,1518,1517],[1517,1518,1519],[1519,1520,1517],[1517,1520,1521],[1521,1522,1517],[1517,1522,1523],[1523,1516,1517],[1525,1524,1515],[1515,1516,1525],[1525,1516,1523],[1523,1526,1525],[1525,1526,1409],[1409,1408,1525],[1525,1408,1406],[1406,1524,1525],[1528,1527,1515],[1515,1524,1528],[1528,1524,1406],[1406,1405,1528],[1528,1405,1213],[1213,1353,1528],[1528,1353,1350],[1350,1527,1528],[1529,1518,1515],[1515,1527,1529],[1529,1527,1350],[1350,1349,1529],[1529,1349,1348],[1348,1530,1529],[1529,1530,1519],[1519,1518,1529],[1533,1532,1531],[1531,1534,1533],[1533,1534,1535],[1535,1536,1533],[1533,1536,1397],[1397,1396,1533],[1533,1396,1395],[1395,1532,1533],[1538,1537,1531],[1531,1532,1538],[1538,1532,1395],[1395,1410,1538],[1538,1410,1409],[1409,1539,1538],[1538,1539,1540],[1540,1537,1538],[1542,1541,1531],[1531,1537,1542],[1542,1537,1540],[1540,1543,1542],[1542,1543,1544],[1544,1545,1542],[1542,1545,1546],[1546,1541,1542],[1547,1534,1531],[1531,1541,1547],[1547,1541,1546],[1546,1548,1547],[1547,1548,1549],[1549,1550,1547],[1547,1550,1535],[1535,1534,1547],[1553,1552,1551],[1551,1554,1553],[1553,1554,1555],[1555,1556,1553],[1553,1556,1332],[1332,1331,1553],[1553,1331,1328],[1328,1552,1553],[1558,1557,1551],[1551,1552,1558],[1558,1552,1328],[1328,1327,1558],[1558,1327,1245],[1245,1244,1558],[1558,1244,1242],[1242,1557,1558],[1560,1559,1551],[1551,1557,1560],[1242,1241,1560],[1560,1557,1242],[1560,1241,1240],[1240,1561,1560],[1560,1561,1562],[1562,1559,1560],[1563,1554,1551],[1551,1559,1563],[1563,1559,1562],[1562,1564,1563],[1563,1564,1565],[1565,1566,1563],[1563,1566,1555],[1555,1554,1563],[1569,1568,1567],[1567,1570,1569],[1569,1570,1571],[1571,1572,1569],[1569,1572,1573],[1573,1574,1569],[1569,1574,1575],[1575,1568,1569],[1577,1576,1567],[1567,1568,1577],[1577,1568,1575],[1575,1578,1577],[1577,1578,1389],[1389,1388,1577],[1577,1388,1386],[1386,1576,1577],[1580,1579,1567],[1567,1576,1580],[1386,1385,1580],[1580,1576,1386],[1580,1385,1253],[1253,1324,1580],[1580,1324,1323],[1323,1579,1580],[1581,1570,1567],[1567,1579,1581],[1581,1579,1323],[1323,1338,1581],[1581,1338,1337],[1337,1582,1581],[1581,1582,1571],[1571,1570,1581],[1585,1584,1583],[1583,1586,1585],[1585,1586,1587],[1587,1588,1585],[1585,1588,1433],[1433,1432,1585],[1585,1432,1431],[1431,1584,1585],[1590,1589,1583],[1583,1584,1590],[1590,1584,1431],[1431,1442,1590],[1590,1442,1367],[1367,1478,1590],[1590,1478,1476],[1476,1589,1590],[1592,1591,1583],[1583,1589,1592],[1592,1589,1476],[1476,1475,1592],[1592,1475,1474],[1474,1593,1592],[1592,1593,1594],[1594,1591,1592],[1595,1586,1583],[1583,1591,1595],[1595,1591,1594],[1594,1596,1595],[1595,1596,1597],[1597,1598,1595],[1595,1598,1587],[1587,1586,1595],[1601,1600,1599],[1599,1602,1601],[1601,1602,1435],[1435,1434,1601],[1601,1434,1433],[1433,1603,1601],[1601,1603,1604],[1604,1600,1601],[1606,1605,1599],[1599,1600,1606],[1606,1600,1604],[1604,1607,1606],[1606,1607,1608],[1608,1609,1606],[1606,1609,1610],[1610,1605,1606],[1612,1611,1599],[1599,1605,1612],[1612,1605,1610],[1610,1613,1612],[1612,1613,1521],[1521,1520,1612],[1612,1520,1519],[1519,1611,1612],[1614,1602,1599],[1599,1611,1614],[1614,1611,1519],[1519,1530,1614],[1614,1530,1348],[1348,1438,1614],[1614,1438,1435],[1435,1602,1614],[1617,1616,1615],[1615,1618,1617],[1617,1618,1464],[1464,1463,1617],[1617,1463,1361],[1361,1447,1617],[1617,1447,1448],[1448,1616,1617],[1620,1619,1615],[1615,1616,1620],[1620,1616,1448],[1448,1458,1620],[1620,1458,1457],[1457,1621,1620],[1620,1621,1622],[1622,1619,1620],[1624,1623,1615],[1615,1619,1624],[1624,1619,1622],[1622,1625,1624],[1624,1625,1626],[1626,1627,1624],[1624,1627,1628],[1628,1623,1624],[1629,1618,1615],[1615,1623,1629],[1629,1623,1628],[1628,1630,1629],[1629,1630,1468],[1468,1467,1629],[1629,1467,1464],[1464,1618,1629],[1633,1632,1631],[1631,1634,1633],[1633,1634,1635],[1635,1636,1633],[1633,1636,1637],[1637,1638,1633],[1633,1638,1639],[1639,1632,1633],[1641,1640,1631],[1631,1632,1641],[1641,1632,1639],[1639,1642,1641],[1641,1642,1457],[1457,1456,1641],[1641,1456,1454],[1454,1640,1641],[1644,1643,1631],[1631,1640,1644],[1644,1640,1454],[1454,1453,1644],[1644,1453,1298],[1298,1645,1644],[1644,1645,1646],[1646,1643,1644],[1647,1634,1631],[1631,1643,1647],[1647,1643,1646],[1646,1648,1647],[1647,1648,1649],[1649,1650,1647],[1647,1650,1635],[1635,1634,1647],[1653,1652,1651],[1651,1654,1653],[1653,1654,1507],[1507,1506,1653],[1653,1506,1505],[1505,1655,1653],[1653,1655,1656],[1656,1652,1653],[1658,1657,1651],[1651,1652,1658],[1658,1652,1656],[1656,1659,1658],[1658,1659,1649],[1649,1648,1658],[1658,1648,1646],[1646,1657,1658],[1661,1660,1651],[1651,1657,1661],[1661,1657,1646],[1646,1645,1661],[1661,1645,1298],[1298,1297,1661],[1661,1297,1294],[1294,1660,1661],[1662,1654,1651],[1651,1660,1662],[1662,1660,1294],[1294,1293,1662],[1662,1293,1292],[1292,1510,1662],[1662,1510,1507],[1507,1654,1662],[1665,1664,1663],[1663,1666,1665],[1665,1666,1523],[1523,1522,1665],[1665,1522,1521],[1521,1667,1665],[1665,1667,1668],[1668,1664,1665],[1670,1669,1663],[1663,1664,1670],[1670,1664,1668],[1668,1671,1670],[1670,1671,1672],[1672,1673,1670],[1670,1673,1674],[1674,1669,1670],[1676,1675,1663],[1663,1669,1676],[1676,1669,1674],[1674,1677,1676],[1676,1677,1544],[1544,1543,1676],[1676,1543,1540],[1540,1675,1676],[1678,1666,1663],[1663,1675,1678],[1678,1675,1540],[1540,1539,1678],[1678,1539,1409],[1409,1526,1678],[1678,1526,1523],[1523,1666,1678],[1681,1680,1679],[1679,1682,1681],[1681,1682,1683],[1683,1684,1681],[1681,1684,1685],[1685,1686,1681],[1681,1686,1687],[1687,1680,1681],[1689,1688,1679],[1679,1680,1689],[1689,1680,1687],[1687,1690,1689],[1689,1690,1565],[1565,1564,1689],[1689,1564,1562],[1562,1688,1689],[1692,1691,1679],[1679,1688,1692],[1692,1688,1562],[1562,1561,1692],[1692,1561,1240],[1240,1416,1692],[1692,1416,1415],[1415,1691,1692],[1693,1682,1679],[1679,1691,1693],[1693,1691,1415],[1415,1426,1693],[1693,1426,1425],[1425,1694,1693],[1693,1694,1683],[1683,1682,1693],[1697,1696,1695],[1695,1698,1697],[1697,1698,1699],[1699,1700,1697],[1697,1700,1701],[1701,1702,1697],[1697,1702,1703],[1703,1696,1697],[1705,1704,1695],[1695,1696,1705],[1705,1696,1703],[1703,1706,1705],[1705,1706,1337],[1337,1336,1705],[1705,1336,1334],[1334,1704,1705],[1708,1707,1695],[1695,1704,1708],[1708,1704,1334],[1334,1333,1708],[1708,1333,1332],[1332,1709,1708],[1708,1709,1710],[1710,1707,1708],[1711,1698,1695],[1695,1707,1711],[1711,1707,1710],[1710,1712,1711],[1711,1712,1713],[1713,1714,1711],[1711,1714,1699],[1699,1698,1711],[1717,1716,1715],[1715,1718,1717],[1717,1718,1604],[1604,1603,1717],[1717,1603,1433],[1433,1588,1717],[1717,1588,1587],[1587,1716,1717],[1720,1719,1715],[1715,1716,1720],[1720,1716,1587],[1587,1598,1720],[1720,1598,1597],[1597,1721,1720],[1720,1721,1722],[1722,1719,1720],[1724,1723,1715],[1715,1719,1724],[1724,1719,1722],[1722,1725,1724],[1724,1725,1726],[1726,1727,1724],[1724,1727,1728],[1728,1723,1724],[1729,1718,1715],[1715,1723,1729],[1729,1723,1728],[1728,1730,1729],[1729,1730,1608],[1608,1607,1729],[1729,1607,1604],[1604,1718,1729],[1733,1732,1731],[1731,1734,1733],[1733,1734,1735],[1735,1736,1733],[1733,1736,1737],[1737,1738,1733],[1733,1738,1739],[1739,1732,1733],[1741,1740,1731],[1731,1732,1741],[1741,1732,1739],[1739,1742,1741],[1741,1742,1672],[1672,1671,1741],[1741,1671,1668],[1668,1740,1741],[1744,1743,1731],[1731,1740,1744],[1744,1740,1668],[1668,1667,1744],[1744,1667,1521],[1521,1613,1744],[1744,1613,1610],[1610,1743,1744],[1745,1734,1731],[1731,1743,1745],[1745,1743,1610],[1610,1609,1745],[1745,1609,1608],[1608,1746,1745],[1745,1746,1735],[1735,1734,1745],[1749,1748,1747],[1747,1750,1749],[1749,1750,1639],[1639,1638,1749],[1749,1638,1637],[1637,1751,1749],[1749,1751,1752],[1752,1748,1749],[1754,1753,1747],[1747,1748,1754],[1754,1748,1752],[1752,1755,1754],[1754,1755,1756],[1756,1757,1754],[1754,1757,1758],[1758,1753,1754],[1760,1759,1747],[1747,1753,1760],[1760,1753,1758],[1758,1761,1760],[1760,1761,1626],[1626,1625,1760],[1760,1625,1622],[1622,1759,1760],[1762,1750,1747],[1747,1759,1762],[1762,1759,1622],[1622,1621,1762],[1762,1621,1457],[1457,1642,1762],[1762,1642,1639],[1639,1750,1762],[1765,1764,1763],[1763,1766,1765],[1765,1766,1628],[1628,1627,1765],[1765,1627,1626],[1626,1767,1765],[1765,1767,1768],[1768,1764,1765],[1770,1769,1763],[1763,1764,1770],[1770,1764,1768],[1768,1771,1770],[1770,1771,1772],[1772,1773,1770],[1770,1773,1774],[1774,1769,1770],[1776,1775,1763],[1763,1769,1776],[1776,1769,1774],[1774,1777,1776],[1776,1777,1778],[1778,1779,1776],[1776,1779,1780],[1780,1775,1776],[1781,1766,1763],[1763,1775,1781],[1781,1775,1780],[1780,1782,1781],[1781,1782,1468],[1468,1630,1781],[1781,1630,1628],[1628,1766,1781],[1785,1784,1783],[1783,1786,1785],[1785,1786,1787],[1787,1788,1785],[1785,1788,1637],[1637,1636,1785],[1785,1636,1635],[1635,1784,1785],[1790,1789,1783],[1783,1784,1790],[1790,1784,1635],[1635,1650,1790],[1790,1650,1649],[1649,1791,1790],[1790,1791,1792],[1792,1789,1790],[1794,1793,1783],[1783,1789,1794],[1794,1789,1792],[1792,1795,1794],[1794,1795,1796],[1796,1797,1794],[1794,1797,1798],[1798,1793,1794],[1799,1786,1783],[1783,1793,1799],[1799,1793,1798],[1798,1800,1799],[1799,1800,1801],[1801,1802,1799],[1799,1787,1786],[1787,1799,1802],[1805,1804,1803],[1803,1806,1805],[1805,1806,1780],[1780,1779,1805],[1805,1779,1778],[1778,1807,1805],[1805,1807,1808],[1808,1804,1805],[1810,1809,1803],[1803,1804,1810],[1810,1804,1808],[1808,1811,1810],[1810,1811,1812],[1812,1813,1810],[1810,1813,1814],[1814,1809,1810],[1816,1815,1803],[1803,1809,1816],[1816,1809,1814],[1814,1817,1816],[1816,1817,1474],[1474,1473,1816],[1816,1473,1470],[1470,1815,1816],[1818,1806,1803],[1803,1815,1818],[1818,1815,1470],[1470,1469,1818],[1818,1469,1468],[1468,1782,1818],[1818,1782,1780],[1780,1806,1818],[1821,1820,1819],[1819,1822,1821],[1821,1822,1823],[1823,1824,1821],[1821,1824,1492],[1492,1491,1821],[1821,1491,1488],[1488,1820,1821],[1826,1825,1819],[1819,1820,1826],[1826,1820,1488],[1488,1487,1826],[1826,1487,1389],[1389,1578,1826],[1826,1578,1575],[1575,1825,1826],[1828,1827,1819],[1819,1825,1828],[1828,1825,1575],[1575,1574,1828],[1828,1574,1573],[1573,1829,1828],[1828,1829,1830],[1830,1827,1828],[1831,1822,1819],[1819,1827,1831],[1831,1827,1830],[1830,1832,1831],[1831,1832,1833],[1833,1834,1831],[1831,1834,1823],[1823,1822,1831],[1837,1836,1835],[1835,1838,1837],[1837,1838,1839],[1839,1840,1837],[1837,1840,1841],[1841,1842,1837],[1837,1842,1843],[1843,1836,1837],[1845,1844,1835],[1835,1836,1845],[1845,1836,1843],[1843,1846,1845],[1845,1846,1847],[1847,1848,1845],[1845,1848,1849],[1849,1844,1845],[1851,1850,1835],[1835,1844,1851],[1851,1844,1849],[1849,1852,1851],[1851,1852,1505],[1505,1504,1851],[1851,1504,1503],[1503,1850,1851],[1853,1838,1835],[1835,1850,1853],[1853,1850,1503],[1503,1514,1853],[1853,1514,1497],[1497,1854,1853],[1853,1854,1839],[1839,1838,1853],[1857,1856,1855],[1855,1858,1857],[1857,1858,1859],[1859,1860,1857],[1857,1860,1861],[1861,1862,1857],[1857,1862,1863],[1863,1856,1857],[1865,1864,1855],[1855,1856,1865],[1865,1856,1863],[1863,1866,1865],[1865,1866,1425],[1425,1424,1865],[1865,1424,1422],[1422,1864,1865],[1868,1867,1855],[1855,1864,1868],[1868,1864,1422],[1422,1421,1868],[1868,1421,1397],[1397,1536,1868],[1868,1536,1535],[1535,1867,1868],[1869,1858,1855],[1855,1867,1869],[1869,1867,1535],[1535,1550,1869],[1869,1550,1549],[1549,1870,1869],[1869,1870,1859],[1859,1858,1869],[1873,1872,1871],[1871,1874,1873],[1873,1874,1546],[1546,1545,1873],[1873,1545,1544],[1544,1875,1873],[1873,1875,1876],[1876,1872,1873],[1878,1877,1871],[1871,1872,1878],[1878,1872,1876],[1876,1879,1878],[1878,1879,1880],[1880,1881,1878],[1878,1881,1882],[1882,1877,1878],[1884,1883,1871],[1871,1877,1884],[1884,1877,1882],[1882,1885,1884],[1884,1885,1886],[1886,1887,1884],[1884,1887,1888],[1888,1883,1884],[1889,1874,1871],[1871,1883,1889],[1889,1883,1888],[1888,1890,1889],[1889,1890,1549],[1549,1548,1889],[1889,1548,1546],[1546,1874,1889],[1893,1892,1891],[1891,1894,1893],[1893,1894,1895],[1895,1896,1893],[1893,1896,1897],[1897,1898,1893],[1893,1898,1899],[1899,1892,1893],[1901,1900,1891],[1891,1892,1901],[1901,1892,1899],[1899,1902,1901],[1901,1902,1713],[1713,1712,1901],[1901,1712,1710],[1710,1900,1901],[1904,1903,1891],[1891,1900,1904],[1904,1900,1710],[1710,1709,1904],[1904,1709,1332],[1332,1556,1904],[1904,1556,1555],[1555,1903,1904],[1905,1894,1891],[1891,1903,1905],[1905,1903,1555],[1555,1566,1905],[1905,1566,1565],[1565,1906,1905],[1905,1906,1895],[1895,1894,1905],[1909,1908,1907],[1907,1910,1909],[1909,1910,1703],[1703,1702,1909],[1909,1702,1701],[1701,1911,1909],[1909,1911,1912],[1912,1908,1909],[1914,1913,1907],[1907,1908,1914],[1914,1908,1912],[1912,1915,1914],[1914,1915,1916],[1916,1917,1914],[1914,1917,1918],[1918,1913,1914],[1920,1919,1907],[1907,1913,1920],[1920,1913,1918],[1918,1921,1920],[1920,1921,1573],[1573,1572,1920],[1920,1572,1571],[1571,1919,1920],[1922,1910,1907],[1907,1919,1922],[1922,1919,1571],[1571,1582,1922],[1922,1582,1337],[1337,1706,1922],[1922,1706,1703],[1703,1910,1922],[1925,1924,1923],[1923,1926,1925],[1925,1926,1927],[1927,1928,1925],[1925,1928,1737],[1737,1736,1925],[1925,1736,1735],[1735,1924,1925],[1930,1929,1923],[1923,1924,1930],[1930,1924,1735],[1735,1746,1930],[1930,1746,1608],[1608,1730,1930],[1930,1730,1728],[1728,1929,1930],[1932,1931,1923],[1923,1929,1932],[1932,1929,1728],[1728,1727,1932],[1932,1727,1726],[1726,1933,1932],[1932,1933,1934],[1934,1931,1932],[1935,1926,1923],[1923,1931,1935],[1935,1931,1934],[1934,1936,1935],[1935,1936,1937],[1937,1938,1935],[1935,1938,1927],[1927,1926,1935],[1941,1940,1939],[1939,1942,1941],[1941,1942,1943],[1943,1944,1941],[1941,1944,1945],[1945,1946,1941],[1941,1946,1947],[1947,1940,1941],[1949,1948,1939],[1939,1940,1949],[1949,1940,1947],[1947,1950,1949],[1949,1950,1597],[1597,1596,1949],[1949,1596,1594],[1594,1948,1949],[1952,1951,1939],[1939,1948,1952],[1952,1948,1594],[1594,1593,1952],[1952,1593,1474],[1474,1817,1952],[1952,1817,1814],[1814,1951,1952],[1953,1942,1939],[1939,1951,1953],[1953,1951,1814],[1814,1813,1953],[1953,1813,1812],[1812,1954,1953],[1953,1954,1943],[1943,1942,1953],[1957,1956,1955],[1955,1958,1957],[1957,1958,1739],[1739,1738,1957],[1957,1738,1737],[1737,1959,1957],[1957,1959,1960],[1960,1956,1957],[1962,1961,1955],[1955,1956,1962],[1963,1962,1960],[1956,1960,1962],[1962,1963,1964],[1964,1965,1962],[1962,1965,1966],[1966,1961,1962],[1968,1967,1955],[1955,1961,1968],[1968,1961,1966],[1966,1969,1968],[1968,1969,1970],[1970,1971,1968],[1968,1971,1972],[1972,1967,1968],[1973,1958,1955],[1955,1967,1973],[1973,1967,1972],[1972,1974,1973],[1973,1974,1672],[1672,1742,1973],[1973,1742,1739],[1739,1958,1973],[1977,1976,1975],[1975,1978,1977],[1977,1978,1752],[1752,1751,1977],[1977,1751,1637],[1637,1788,1977],[1977,1788,1787],[1787,1976,1977],[1980,1979,1975],[1975,1976,1980],[1976,1787,1980],[1802,1980,1787],[1980,1802,1801],[1801,1981,1980],[1980,1981,1982],[1982,1979,1980],[1984,1983,1975],[1975,1979,1984],[1984,1979,1982],[1982,1985,1984],[1984,1985,1986],[1986,1987,1984],[1984,1987,1988],[1988,1983,1984],[1989,1978,1975],[1975,1983,1989],[1989,1983,1988],[1988,1990,1989],[1989,1990,1756],[1756,1755,1989],[1989,1755,1752],[1752,1978,1989],[1993,1992,1991],[1991,1994,1993],[1993,1994,1995],[1995,1996,1993],[1993,1996,1796],[1796,1795,1993],[1993,1795,1792],[1792,1992,1993],[1998,1997,1991],[1991,1992,1998],[1998,1992,1792],[1792,1791,1998],[1998,1791,1649],[1649,1659,1998],[1998,1659,1656],[1656,1997,1998],[2000,1999,1991],[1991,1997,2000],[2000,1997,1656],[1656,1655,2000],[2000,1655,1505],[1505,1852,2000],[2000,1852,1849],[1849,1999,2000],[2001,1994,1991],[1991,1999,2001],[2001,1999,1849],[1849,1848,2001],[2001,1848,1847],[1847,2002,2001],[2001,2002,1995],[1995,1994,2001],[2005,2004,2003],[2003,2006,2005],[2005,2006,2007],[2007,2008,2005],[2008,2009,2005],[2010,2005,2009],[2005,2010,2011],[2011,2004,2005],[2013,2012,2003],[2003,2004,2013],[2013,2004,2011],[2011,2014,2013],[2013,2014,1801],[1801,1800,2013],[2013,1800,1798],[1798,2012,2013],[2016,2015,2003],[2003,2012,2016],[2016,2012,1798],[1798,1797,2016],[2016,1797,1796],[1796,2017,2016],[2016,2017,2018],[2018,2015,2016],[2019,2006,2003],[2003,2015,2019],[2019,2015,2018],[2018,2020,2019],[2019,2020,2021],[2021,2022,2019],[2019,2022,2007],[2007,2006,2019],[2025,2024,2023],[2023,2026,2025],[2025,2026,1808],[1808,1807,2025],[2025,1807,1778],[1778,2027,2025],[2025,2027,2028],[2028,2024,2025],[2030,2029,2023],[2023,2024,2030],[2030,2024,2028],[2028,2031,2030],[2030,2031,2032],[2032,2033,2030],[2030,2033,2034],[2034,2029,2030],[2036,2035,2023],[2023,2029,2036],[2036,2029,2034],[2034,2037,2036],[2036,2037,2038],[2038,2039,2036],[2036,2039,2040],[2040,2035,2036],[2041,2026,2023],[2023,2035,2041],[2041,2035,2040],[2040,2042,2041],[2041,2042,1812],[1812,1811,2041],[2041,1811,1808],[1808,2026,2041],[2045,2044,2043],[2043,2046,2045],[2045,2046,2047],[2047,2048,2045],[2045,2048,1841],[1841,1840,2045],[2045,1840,1839],[1839,2044,2045],[2050,2049,2043],[2043,2044,2050],[2050,2044,1839],[1839,1854,2050],[2050,1854,1497],[1497,1496,2050],[2050,1496,1494],[1494,2049,2050],[2052,2051,2043],[2043,2049,2052],[2052,2049,1494],[1494,1493,2052],[2052,1493,1492],[1492,2053,2052],[2052,2053,2054],[2054,2051,2052],[2055,2046,2043],[2043,2051,2055],[2055,2051,2054],[2054,2056,2055],[2055,2056,2057],[2057,2058,2055],[2055,2058,2047],[2047,2046,2055],[2061,2060,2059],[2059,2062,2061],[2061,2062,1843],[1843,1842,2061],[2061,1842,1841],[1841,2063,2061],[2061,2063,2064],[2064,2060,2061],[2066,2065,2059],[2059,2060,2066],[2066,2060,2064],[2064,2067,2066],[2066,2067,2068],[2068,2069,2066],[2066,2069,2070],[2070,2065,2066],[2072,2071,2059],[2059,2065,2072],[2072,2065,2070],[2070,2073,2072],[2072,2073,2074],[2074,2075,2072],[2072,2075,2076],[2076,2071,2072],[2077,2062,2059],[2059,2071,2077],[2077,2071,2076],[2076,2078,2077],[2077,2078,1847],[1847,1846,2077],[2077,1846,1843],[1843,2062,2077],[2081,2080,2079],[2079,2082,2081],[2081,2082,1876],[1876,1875,2081],[2081,1875,1544],[1544,1677,2081],[2081,1677,1674],[1674,2080,2081],[2084,2083,2079],[2079,2080,2084],[2084,2080,1674],[1674,1673,2084],[2084,1673,1672],[1672,1974,2084],[2084,1974,1972],[1972,2083,2084],[2086,2085,2079],[2079,2083,2086],[2086,2083,1972],[1972,1971,2086],[2086,1971,1970],[1970,2087,2086],[2086,2087,2088],[2088,2085,2086],[2089,2082,2079],[2079,2085,2089],[2089,2085,2088],[2088,2090,2089],[2089,2090,1880],[1880,1879,2089],[2089,1879,1876],[1876,2082,2089],[2093,2092,2091],[2091,2094,2093],[2093,2094,1863],[1863,1862,2093],[2093,1862,1861],[1861,2095,2093],[2093,2095,2096],[2096,2092,2093],[2098,2097,2091],[2091,2092,2098],[2098,2092,2096],[2096,2099,2098],[2098,2099,2100],[2100,2101,2098],[2098,2101,2102],[2102,2097,2098],[2104,2103,2091],[2091,2097,2104],[2104,2097,2102],[2102,2105,2104],[2104,2105,1685],[1685,1684,2104],[2104,1684,1683],[1683,2103,2104],[2106,2094,2091],[2091,2103,2106],[2106,2103,1683],[1683,1694,2106],[2106,1694,1425],[1425,1866,2106],[2106,1866,1863],[1863,2094,2106],[2109,2108,2107],[2107,2110,2109],[2109,2110,2111],[2111,2112,2109],[2109,2112,1685],[1685,2105,2109],[2109,2105,2102],[2102,2108,2109],[2114,2113,2107],[2107,2108,2114],[2114,2108,2102],[2102,2101,2114],[2114,2101,2100],[2100,2115,2114],[2114,2115,2116],[2116,2113,2114],[2118,2117,2107],[2107,2113,2118],[2118,2113,2116],[2116,2119,2118],[2118,2119,2120],[2120,2121,2118],[2118,2121,2122],[2122,2117,2118],[2123,2110,2107],[2107,2117,2123],[2123,2117,2122],[2122,2124,2123],[2123,2124,2125],[2125,2126,2123],[2123,2126,2111],[2111,2110,2123],[2129,2128,2127],[2127,2130,2129],[2129,2130,2131],[2131,2132,2129],[2129,2132,1897],[1897,1896,2129],[2129,1896,1895],[1895,2128,2129],[2134,2133,2127],[2127,2128,2134],[2134,2128,1895],[1895,1906,2134],[2134,1906,1565],[1565,1690,2134],[2134,1690,1687],[1687,2133,2134],[2136,2135,2127],[2127,2133,2136],[2136,2133,1687],[1687,1686,2136],[2136,1686,1685],[1685,2112,2136],[2136,2112,2111],[2111,2135,2136],[2137,2130,2127],[2127,2135,2137],[2137,2135,2111],[2111,2126,2137],[2137,2126,2125],[2125,2138,2137],[2137,2138,2131],[2131,2130,2137],[2141,2140,2139],[2139,2142,2141],[2141,2142,1899],[1899,1898,2141],[2141,1898,1897],[1897,2143,2141],[2141,2143,2144],[2144,2140,2141],[2146,2145,2139],[2139,2140,2146],[2146,2140,2144],[2144,2147,2146],[2146,2147,2148],[2148,2149,2146],[2146,2149,2150],[2150,2145,2146],[2152,2151,2139],[2139,2145,2152],[2152,2145,2150],[2150,2153,2152],[2152,2153,2154],[2154,2155,2152],[2152,2155,2156],[2156,2151,2152],[2157,2142,2139],[2139,2151,2157],[2157,2151,2156],[2156,2158,2157],[2157,2158,1713],[1713,1902,2157],[2157,1902,1899],[1899,2142,2157],[2161,2160,2159],[2159,2162,2161],[2161,2162,2163],[2163,2164,2161],[2161,2164,2165],[2165,2166,2161],[2161,2166,2167],[2167,2160,2161],[2169,2168,2159],[2159,2160,2169],[2169,2160,2167],[2167,2170,2169],[2169,2170,1833],[1833,1832,2169],[2169,1832,1830],[1830,2168,2169],[2172,2171,2159],[2159,2168,2172],[2172,2168,1830],[1830,1829,2172],[2172,1829,1573],[1573,1921,2172],[2172,1921,1918],[1918,2171,2172],[2173,2162,2159],[2159,2171,2173],[2173,2171,1918],[1918,1917,2173],[2173,1917,1916],[1916,2174,2173],[2173,2174,2163],[2163,2162,2173],[2177,2176,2175],[2175,2178,2177],[2177,2178,2156],[2156,2155,2177],[2177,2155,2154],[2154,2179,2177],[2177,2179,2180],[2180,2176,2177],[2182,2181,2175],[2175,2176,2182],[2182,2176,2180],[2180,2183,2182],[2182,2183,2184],[2184,2185,2182],[2182,2185,2186],[2186,2181,2182],[2188,2187,2175],[2175,2181,2188],[2188,2181,2186],[2186,2189,2188],[2188,2189,1701],[1701,1700,2188],[2188,1700,1699],[1699,2187,2188],[2190,2178,2175],[2175,2187,2190],[2190,2187,1699],[1699,1714,2190],[2190,1714,1713],[1713,2158,2190],[2190,2158,2156],[2156,2178,2190],[2193,2192,2191],[2191,2194,2193],[2193,2194,1947],[1947,1946,2193],[2193,1946,1945],[1945,2195,2193],[2193,2195,2196],[2196,2192,2193],[2198,2197,2191],[2191,2192,2198],[2198,2192,2196],[2196,2199,2198],[2198,2199,2200],[2200,2201,2198],[2198,2201,2202],[2202,2197,2198],[2204,2203,2191],[2191,2197,2204],[2204,2197,2202],[2202,2205,2204],[2204,2205,1726],[1726,1725,2204],[2204,1725,1722],[1722,2203,2204],[2206,2194,2191],[2191,2203,2206],[2206,2203,1722],[1722,1721,2206],[2206,1721,1597],[1597,1950,2206],[2206,1950,1947],[1947,2194,2206],[2209,2208,2207],[2207,2210,2209],[2209,2210,1960],[1960,1959,2209],[2209,1959,1737],[1737,1928,2209],[2209,1928,1927],[1927,2208,2209],[2212,2211,2207],[2207,2208,2212],[2212,2208,1927],[1927,1938,2212],[2212,1938,1937],[1937,2213,2212],[2212,2213,2214],[2214,2211,2212],[2216,2215,2207],[2207,2211,2216],[2216,2211,2214],[2214,2217,2216],[2216,2217,2218],[2218,2219,2216],[2216,2219,2220],[2220,2215,2216],[2221,2210,2207],[2207,2215,2221],[2221,2215,2220],[2220,2222,2221],[2221,2222,1964],[1964,1963,2221],[2221,1960,2210],[1960,2221,1963],[2225,2224,2223],[2223,2226,2225],[2225,2226,2227],[2227,2228,2225],[2225,2228,2229],[2229,2230,2225],[2225,2230,2231],[2231,2224,2225],[2233,2232,2223],[2223,2224,2233],[2233,2224,2231],[2231,2234,2233],[2233,2234,2235],[2235,2236,2233],[2233,2236,2237],[2237,2232,2233],[2239,2238,2223],[2223,2232,2239],[2239,2232,2237],[2237,2240,2239],[2239,2240,1970],[1970,1969,2239],[2239,1969,1966],[1966,2238,2239],[2241,2226,2223],[2223,2238,2241],[2241,2238,1966],[1966,1965,2241],[2241,1965,1964],[1964,2242,2241],[2241,2242,2227],[2227,2226,2241],[2245,2244,2243],[2243,2246,2245],[2245,2246,2011],[2011,2010,2245],[2245,2009,2247],[2009,2245,2010],[2245,2247,2248],[2248,2244,2245],[2250,2249,2243],[2243,2244,2250],[2250,2244,2248],[2248,2251,2250],[2250,2251,2252],[2252,2253,2250],[2250,2253,2254],[2254,2249,2250],[2256,2255,2243],[2243,2249,2256],[2256,2249,2254],[2254,2257,2256],[2256,2257,1986],[1986,1985,2256],[2256,1985,1982],[1982,2255,2256],[2258,2246,2243],[2243,2255,2258],[2258,2255,1982],[1982,1981,2258],[2258,1981,1801],[1801,2014,2258],[2258,2014,2011],[2011,2246,2258],[2261,2260,2259],[2259,2262,2261],[2261,2262,2263],[2263,2264,2261],[2261,2264,2265],[2265,2266,2261],[2261,2266,2267],[2267,2260,2261],[2269,2268,2259],[2259,2260,2269],[2269,2260,2267],[2267,2270,2269],[2269,2270,1772],[1772,1771,2269],[2269,1771,1768],[1768,2268,2269],[2272,2271,2259],[2259,2268,2272],[2272,2268,1768],[1768,1767,2272],[2272,1767,1626],[1626,1761,2272],[2272,1761,1758],[1758,2271,2272],[2273,2262,2259],[2259,2271,2273],[2273,2271,1758],[1758,1757,2273],[2273,1757,1756],[1756,2274,2273],[2273,2274,2263],[2263,2262,2273],[2277,2276,2275],[2275,2278,2277],[2277,2278,2018],[2018,2017,2277],[2277,2017,1796],[1796,1996,2277],[2277,1996,1995],[1995,2276,2277],[2280,2279,2275],[2275,2276,2280],[2280,2276,1995],[1995,2002,2280],[2280,2002,1847],[1847,2078,2280],[2280,2078,2076],[2076,2279,2280],[2282,2281,2275],[2275,2279,2282],[2282,2279,2076],[2076,2075,2282],[2282,2075,2074],[2074,2283,2282],[2282,2283,2284],[2284,2281,2282],[2285,2278,2275],[2275,2281,2285],[2285,2281,2284],[2284,2286,2285],[2285,2286,2021],[2021,2020,2285],[2285,2020,2018],[2018,2278,2285],[2289,2288,2287],[2287,2290,2289],[2289,2290,2291],[2291,2292,2289],[2289,2292,2009],[2009,2008,2289],[2289,2008,2007],[2007,2288,2289],[2294,2293,2287],[2287,2288,2294],[2294,2288,2007],[2007,2022,2294],[2294,2022,2021],[2021,2295,2294],[2294,2295,2296],[2296,2293,2294],[2298,2297,2287],[2287,2293,2298],[2298,2293,2296],[2296,2299,2298],[2298,2299,2300],[2300,2301,2298],[2298,2301,2302],[2302,2297,2298],[2303,2290,2287],[2287,2297,2303],[2303,2297,2302],[2302,2304,2303],[2303,2304,2305],[2305,2306,2303],[2291,2303,2306],[2303,2291,2290],[2309,2308,2307],[2307,2310,2309],[2309,2310,2311],[2311,2312,2309],[2309,2312,2313],[2313,2314,2309],[2309,2314,2315],[2315,2308,2309],[2317,2316,2307],[2307,2308,2317],[2317,2308,2315],[2315,2318,2317],[2317,2318,2057],[2057,2056,2317],[2317,2056,2054],[2054,2316,2317],[2320,2319,2307],[2307,2316,2320],[2320,2316,2054],[2054,2053,2320],[2320,2053,1492],[1492,1824,2320],[2320,1824,1823],[1823,2319,2320],[2321,2310,2307],[2307,2319,2321],[2321,2319,1823],[1823,1834,2321],[2321,1834,1833],[1833,2322,2321],[2321,2322,2311],[2311,2310,2321],[2325,2324,2323],[2323,2326,2325],[2325,2326,2064],[2064,2063,2325],[2325,2063,1841],[1841,2048,2325],[2325,2048,2047],[2047,2324,2325],[2328,2327,2323],[2323,2324,2328],[2328,2324,2047],[2047,2058,2328],[2328,2058,2057],[2057,2329,2328],[2328,2329,2330],[2330,2327,2328],[2332,2331,2323],[2323,2327,2332],[2333,2332,2330],[2327,2330,2332],[2332,2333,2334],[2334,2335,2332],[2332,2335,2336],[2336,2331,2332],[2337,2326,2323],[2323,2331,2337],[2337,2331,2336],[2336,2338,2337],[2337,2338,2068],[2068,2067,2337],[2337,2067,2064],[2064,2326,2337],[2341,2340,2339],[2339,2342,2341],[2341,2342,2096],[2096,2095,2341],[2341,2095,1861],[1861,2343,2341],[2344,2340,2341],[2341,2343,2344],[2346,2345,2339],[2339,2340,2346],[2346,2340,2344],[2344,2347,2346],[2346,2347,2348],[2348,2349,2346],[2346,2349,2350],[2350,2345,2346],[2352,2351,2339],[2339,2345,2352],[2352,2345,2350],[2350,2353,2352],[2352,2353,2354],[2354,2355,2352],[2352,2355,2356],[2356,2351,2352],[2357,2342,2339],[2339,2351,2357],[2357,2351,2356],[2356,2358,2357],[2357,2358,2100],[2100,2099,2357],[2357,2099,2096],[2096,2342,2357],[2361,2360,2359],[2359,2362,2361],[2361,2362,1888],[1888,1887,2361],[2361,1887,1886],[1886,2363,2361],[2361,2363,2364],[2364,2360,2361],[2366,2365,2359],[2359,2360,2366],[2366,2360,2364],[2364,2367,2366],[2366,2367,2348],[2348,2347,2366],[2366,2347,2344],[2344,2365,2366],[2369,2368,2359],[2359,2365,2369],[2343,2369,2344],[2365,2344,2369],[2369,2343,1861],[1861,1860,2369],[2369,1860,1859],[1859,2368,2369],[2370,2362,2359],[2359,2368,2370],[2370,2368,1859],[1859,1870,2370],[2370,1870,1549],[1549,1890,2370],[2370,1890,1888],[1888,2362,2370],[2373,2372,2371],[2371,2374,2373],[2373,2374,2375],[2375,2376,2373],[2373,2376,1886],[1886,1885,2373],[2373,1885,1882],[1882,2372,2373],[2378,2377,2371],[2371,2372,2378],[2378,2372,1882],[1882,1881,2378],[2378,1881,1880],[1880,2379,2378],[2378,2379,2380],[2380,2377,2378],[2382,2381,2371],[2371,2377,2382],[2382,2377,2380],[2380,2383,2382],[2382,2383,2384],[2384,2385,2382],[2382,2385,2386],[2386,2381,2382],[2387,2374,2371],[2371,2381,2387],[2387,2381,2386],[2386,2388,2387],[2387,2388,2389],[2389,2390,2387],[2387,2390,2375],[2375,2374,2387],[2393,2392,2391],[2391,2394,2393],[2393,2394,2144],[2144,2143,2393],[2393,2143,1897],[1897,2132,2393],[2393,2132,2131],[2131,2392,2393],[2396,2395,2391],[2391,2392,2396],[2396,2392,2131],[2131,2138,2396],[2396,2138,2125],[2125,2397,2396],[2396,2397,2398],[2398,2395,2396],[2400,2399,2391],[2391,2395,2400],[2400,2395,2398],[2398,2401,2400],[2400,2401,2402],[2402,2403,2400],[2400,2403,2404],[2404,2399,2400],[2405,2394,2391],[2391,2399,2405],[2405,2399,2404],[2404,2406,2405],[2405,2406,2148],[2148,2147,2405],[2405,2147,2144],[2144,2394,2405],[2409,2408,2407],[2407,2410,2409],[2409,2410,2167],[2167,2166,2409],[2409,2166,2165],[2165,2411,2409],[2409,2411,2412],[2412,2408,2409],[2414,2413,2407],[2407,2408,2414],[2414,2408,2412],[2412,2415,2414],[2414,2415,2416],[2416,2417,2414],[2414,2417,2418],[2418,2413,2414],[2420,2419,2407],[2407,2413,2420],[2420,2413,2418],[2418,2421,2420],[2420,2421,2313],[2313,2312,2420],[2420,2312,2311],[2311,2419,2420],[2422,2410,2407],[2407,2419,2422],[2422,2419,2311],[2311,2322,2422],[2422,2322,1833],[1833,2170,2422],[2422,2170,2167],[2167,2410,2422],[2425,2424,2423],[2423,2426,2425],[2425,2426,2427],[2427,2428,2425],[2425,2428,2165],[2165,2164,2425],[2425,2164,2163],[2163,2424,2425],[2430,2429,2423],[2423,2424,2430],[2430,2424,2163],[2163,2174,2430],[2430,2174,1916],[1916,2431,2430],[2430,2431,2432],[2432,2429,2430],[2434,2433,2423],[2423,2429,2434],[2434,2429,2432],[2432,2435,2434],[2434,2435,2436],[2436,2437,2434],[2434,2437,2438],[2438,2433,2434],[2439,2426,2423],[2423,2433,2439],[2439,2433,2438],[2438,2440,2439],[2439,2440,2441],[2441,2442,2439],[2439,2442,2427],[2427,2426,2439],[2445,2444,2443],[2443,2446,2445],[2445,2446,2447],[2447,2448,2445],[2445,2448,2436],[2436,2435,2445],[2445,2435,2432],[2432,2444,2445],[2450,2449,2443],[2443,2444,2450],[2450,2444,2432],[2432,2431,2450],[2450,2431,1916],[1916,1915,2450],[2450,1915,1912],[1912,2449,2450],[2452,2451,2443],[2443,2449,2452],[2452,2449,1912],[1912,1911,2452],[2452,1911,1701],[1701,2189,2452],[2452,2189,2186],[2186,2451,2452],[2453,2446,2443],[2443,2451,2453],[2453,2451,2186],[2186,2185,2453],[2453,2185,2184],[2184,2454,2453],[2453,2454,2447],[2447,2446,2453],[2457,2456,2455],[2455,2458,2457],[2457,2458,2459],[2459,2460,2457],[2457,2460,2461],[2461,2462,2457],[2457,2462,2463],[2463,2456,2457],[2465,2464,2455],[2455,2456,2465],[2465,2456,2463],[2463,2466,2465],[2465,2466,2184],[2184,2183,2465],[2465,2183,2180],[2180,2464,2465],[2468,2467,2455],[2455,2464,2468],[2468,2464,2180],[2180,2179,2468],[2468,2179,2154],[2154,2469,2468],[2468,2469,2470],[2470,2467,2468],[2471,2458,2455],[2455,2467,2471],[2471,2467,2470],[2470,2472,2471],[2471,2472,2473],[2473,2474,2471],[2458,2471,2459],[2474,2459,2471],[2477,2476,2475],[2475,2478,2477],[2477,2478,2479],[2479,2480,2477],[2477,2480,2481],[2481,2482,2477],[2477,2482,2483],[2483,2476,2477],[2485,2484,2475],[2475,2476,2485],[2485,2476,2483],[2483,2486,2485],[2485,2486,1937],[1937,1936,2485],[2485,1936,1934],[1934,2484,2485],[2488,2487,2475],[2475,2484,2488],[2488,2484,1934],[1934,1933,2488],[2488,1933,1726],[1726,2205,2488],[2488,2205,2202],[2202,2487,2488],[2489,2478,2475],[2475,2487,2489],[2489,2487,2202],[2202,2201,2489],[2489,2201,2200],[2200,2490,2489],[2489,2490,2479],[2479,2478,2489],[2493,2492,2491],[2491,2494,2493],[2493,2494,2495],[2495,2496,2493],[2493,2496,2229],[2229,2228,2493],[2493,2228,2227],[2227,2492,2493],[2498,2497,2491],[2491,2492,2498],[2498,2492,2227],[2227,2242,2498],[2498,2242,1964],[1964,2222,2498],[2498,2222,2220],[2220,2497,2498],[2500,2499,2491],[2491,2497,2500],[2500,2497,2220],[2220,2219,2500],[2500,2219,2218],[2218,2501,2500],[2500,2501,2502],[2502,2499,2500],[2503,2494,2491],[2491,2499,2503],[2503,2499,2502],[2502,2504,2503],[2503,2504,2505],[2505,2506,2503],[2503,2506,2495],[2495,2494,2503],[2509,2508,2507],[2507,2510,2509],[2509,2510,2040],[2040,2039,2509],[2509,2039,2038],[2038,2511,2509],[2509,2511,2512],[2512,2508,2509],[2514,2513,2507],[2507,2508,2514],[2514,2508,2512],[2512,2515,2514],[2514,2515,2516],[2516,2517,2514],[2514,2517,2518],[2518,2513,2514],[2520,2519,2507],[2507,2513,2520],[2520,2513,2518],[2518,2521,2520],[2520,2521,1945],[1945,1944,2520],[2520,1944,1943],[1943,2519,2520],[2522,2510,2507],[2507,2519,2522],[2522,2519,1943],[1943,1954,2522],[2522,1954,1812],[1812,2042,2522],[2522,2042,2040],[2040,2510,2522],[2525,2524,2523],[2523,2526,2525],[2525,2526,2231],[2231,2230,2525],[2230,2229,2525],[2527,2525,2229],[2525,2527,2528],[2528,2524,2525],[2530,2529,2523],[2523,2524,2530],[2530,2524,2528],[2528,2531,2530],[2530,2531,2532],[2532,2533,2530],[2530,2533,2534],[2534,2529,2530],[2536,2535,2523],[2523,2529,2536],[2536,2529,2534],[2534,2537,2536],[2536,2537,2538],[2538,2539,2536],[2536,2539,2540],[2540,2535,2536],[2541,2526,2523],[2523,2535,2541],[2541,2535,2540],[2540,2542,2541],[2541,2542,2235],[2235,2234,2541],[2541,2234,2231],[2231,2526,2541],[2545,2544,2543],[2543,2546,2545],[2545,2546,2088],[2088,2087,2545],[2545,2087,1970],[1970,2240,2545],[2545,2240,2237],[2237,2544,2545],[2548,2547,2543],[2543,2544,2548],[2548,2544,2237],[2237,2236,2548],[2548,2236,2235],[2235,2549,2548],[2548,2549,2550],[2550,2547,2548],[2552,2551,2543],[2543,2547,2552],[2552,2547,2550],[2550,2553,2552],[2552,2553,2384],[2384,2383,2552],[2552,2383,2380],[2380,2551,2552],[2554,2546,2543],[2543,2551,2554],[2554,2551,2380],[2380,2379,2554],[2554,2379,1880],[1880,2090,2554],[2554,2090,2088],[2088,2546,2554],[2557,2556,2555],[2555,2558,2557],[2557,2558,2248],[2248,2247,2557],[2557,2247,2009],[2009,2292,2557],[2557,2292,2291],[2291,2556,2557],[2560,2559,2555],[2555,2556,2560],[2306,2560,2291],[2556,2291,2560],[2560,2306,2305],[2305,2561,2560],[2560,2561,2562],[2562,2559,2560],[2564,2563,2555],[2555,2559,2564],[2564,2559,2562],[2562,2565,2564],[2564,2565,2566],[2566,2567,2564],[2564,2567,2568],[2568,2563,2564],[2569,2558,2555],[2555,2563,2569],[2569,2563,2568],[2568,2570,2569],[2569,2570,2252],[2252,2251,2569],[2569,2251,2248],[2248,2558,2569],[2573,2572,2571],[2571,2574,2573],[2573,2574,2575],[2575,2576,2573],[2573,2576,1986],[1986,2257,2573],[2573,2257,2254],[2254,2572,2573],[2578,2577,2571],[2571,2572,2578],[2578,2572,2254],[2254,2253,2578],[2578,2253,2252],[2252,2579,2578],[2578,2579,2580],[2580,2577,2578],[2582,2581,2571],[2571,2577,2582],[2582,2577,2580],[2580,2583,2582],[2582,2583,2584],[2584,2585,2582],[2582,2585,2586],[2586,2581,2582],[2587,2574,2571],[2571,2581,2587],[2587,2581,2586],[2586,2588,2587],[2587,2588,2589],[2589,2590,2587],[2587,2590,2575],[2575,2574,2587],[2593,2592,2591],[2591,2594,2593],[2593,2594,2595],[2595,2596,2593],[2593,2596,2265],[2265,2264,2593],[2593,2264,2263],[2263,2592,2593],[2598,2597,2591],[2591,2592,2598],[2598,2592,2263],[2263,2274,2598],[2598,2274,1756],[1756,1990,2598],[2598,1990,1988],[1988,2597,2598],[2600,2599,2591],[2591,2597,2600],[2600,2597,1988],[1988,1987,2600],[2600,1987,1986],[1986,2576,2600],[2600,2576,2575],[2575,2599,2600],[2601,2594,2591],[2591,2599,2601],[2601,2599,2575],[2575,2590,2601],[2601,2590,2589],[2589,2602,2601],[2601,2602,2595],[2595,2594,2601],[2605,2604,2603],[2603,2606,2605],[2605,2606,2267],[2267,2266,2605],[2605,2266,2265],[2265,2607,2605],[2605,2607,2608],[2608,2604,2605],[2610,2609,2603],[2603,2604,2610],[2610,2604,2608],[2608,2611,2610],[2610,2611,2612],[2612,2613,2610],[2610,2613,2614],[2614,2609,2610],[2616,2615,2603],[2603,2609,2616],[2616,2609,2614],[2614,2617,2616],[2616,2617,2618],[2618,2619,2616],[2616,2619,2620],[2620,2615,2616],[2621,2606,2603],[2603,2615,2621],[2621,2615,2620],[2620,2622,2621],[2621,2622,1772],[1772,2270,2621],[2621,2270,2267],[2267,2606,2621],[2625,2624,2623],[2623,2626,2625],[2625,2626,2620],[2620,2619,2625],[2625,2619,2618],[2618,2627,2625],[2625,2627,2628],[2628,2624,2625],[2630,2629,2623],[2623,2624,2630],[2630,2624,2628],[2628,2631,2630],[2630,2631,2032],[2032,2031,2630],[2630,2031,2028],[2028,2629,2630],[2633,2632,2623],[2623,2629,2633],[2633,2629,2028],[2028,2027,2633],[2633,2027,1778],[1778,1777,2633],[2633,1777,1774],[1774,2632,2633],[2634,2626,2623],[2623,2632,2634],[2634,2632,1774],[1774,1773,2634],[2634,1773,1772],[1772,2622,2634],[2634,2622,2620],[2620,2626,2634],[2637,2636,2635],[2635,2638,2637],[2637,2638,2639],[2639,2640,2637],[2637,2640,2300],[2300,2299,2637],[2637,2299,2296],[2296,2636,2637],[2642,2641,2635],[2635,2636,2642],[2642,2636,2296],[2296,2295,2642],[2642,2295,2021],[2021,2286,2642],[2642,2286,2284],[2284,2641,2642],[2644,2643,2635],[2635,2641,2644],[2644,2641,2284],[2284,2283,2644],[2644,2283,2074],[2074,2645,2644],[2644,2645,2646],[2646,2643,2644],[2647,2638,2635],[2635,2643,2647],[2647,2643,2646],[2646,2648,2647],[2647,2648,2649],[2649,2650,2647],[2647,2650,2639],[2639,2638,2647],[2653,2652,2651],[2651,2654,2653],[2653,2654,2655],[2655,2656,2653],[2653,2656,2657],[2657,2658,2653],[2653,2658,2659],[2659,2652,2653],[2661,2660,2651],[2651,2652,2661],[2662,2661,2659],[2652,2659,2661],[2661,2662,2305],[2305,2304,2661],[2661,2304,2302],[2302,2660,2661],[2664,2663,2651],[2651,2660,2664],[2664,2660,2302],[2302,2301,2664],[2664,2301,2300],[2300,2665,2664],[2664,2665,2666],[2666,2663,2664],[2667,2654,2651],[2651,2663,2667],[2667,2663,2666],[2666,2668,2667],[2667,2668,2669],[2669,2670,2667],[2667,2670,2655],[2655,2654,2667],[2673,2672,2671],[2671,2674,2673],[2673,2674,2675],[2675,2676,2673],[2673,2676,2038],[2038,2037,2673],[2673,2037,2034],[2034,2672,2673],[2678,2677,2671],[2671,2672,2678],[2678,2672,2034],[2034,2033,2678],[2678,2033,2032],[2032,2679,2678],[2678,2679,2680],[2680,2677,2678],[2682,2681,2671],[2671,2677,2682],[2682,2677,2680],[2680,2683,2682],[2682,2683,2684],[2684,2685,2682],[2682,2686,2681],[2686,2682,2685],[2687,2674,2671],[2671,2681,2687],[2687,2681,2686],[2686,2688,2687],[2687,2688,2689],[2689,2690,2687],[2687,2690,2675],[2675,2674,2687],[2693,2692,2691],[2691,2694,2693],[2693,2694,2646],[2646,2645,2693],[2693,2645,2074],[2074,2073,2693],[2693,2073,2070],[2070,2692,2693],[2696,2695,2691],[2691,2692,2696],[2696,2692,2070],[2070,2069,2696],[2696,2069,2068],[2068,2697,2696],[2696,2697,2698],[2698,2695,2696],[2700,2699,2691],[2691,2695,2700],[2700,2695,2698],[2698,2701,2700],[2700,2701,2702],[2702,2703,2700],[2700,2703,2704],[2704,2699,2700],[2705,2694,2691],[2691,2699,2705],[2705,2699,2704],[2704,2706,2705],[2705,2706,2649],[2649,2648,2705],[2705,2648,2646],[2646,2694,2705],[2709,2708,2707],[2707,2710,2709],[2709,2710,2364],[2364,2363,2709],[2709,2363,1886],[1886,2376,2709],[2709,2376,2375],[2375,2708,2709],[2712,2711,2707],[2707,2708,2712],[2712,2708,2375],[2375,2390,2712],[2712,2390,2389],[2389,2713,2712],[2712,2713,2714],[2714,2711,2712],[2716,2715,2707],[2707,2711,2716],[2716,2711,2714],[2714,2717,2716],[2716,2717,2718],[2718,2719,2716],[2716,2719,2720],[2720,2715,2716],[2721,2710,2707],[2707,2715,2721],[2721,2715,2720],[2720,2722,2721],[2721,2722,2348],[2348,2367,2721],[2721,2367,2364],[2364,2710,2721],[2725,2724,2723],[2723,2726,2725],[2725,2726,2727],[2727,2728,2725],[2725,2728,2120],[2120,2119,2725],[2725,2119,2116],[2116,2724,2725],[2730,2729,2723],[2723,2724,2730],[2730,2724,2116],[2116,2115,2730],[2730,2115,2100],[2100,2358,2730],[2730,2358,2356],[2356,2729,2730],[2732,2731,2723],[2723,2729,2732],[2732,2729,2356],[2356,2355,2732],[2732,2355,2354],[2354,2733,2732],[2732,2733,2734],[2734,2731,2732],[2735,2726,2723],[2723,2731,2735],[2735,2731,2734],[2734,2736,2735],[2735,2736,2737],[2737,2738,2735],[2735,2738,2727],[2727,2726,2735],[2741,2740,2739],[2739,2742,2741],[2741,2742,2743],[2743,2744,2741],[2741,2744,2745],[2745,2746,2741],[2741,2746,2747],[2747,2740,2741],[2749,2748,2739],[2739,2740,2749],[2749,2740,2747],[2747,2750,2749],[2749,2750,2473],[2473,2472,2749],[2749,2472,2470],[2470,2748,2749],[2752,2751,2739],[2739,2748,2752],[2752,2748,2470],[2470,2469,2752],[2752,2469,2154],[2154,2153,2752],[2752,2153,2150],[2150,2751,2752],[2753,2742,2739],[2739,2751,2753],[2753,2751,2150],[2150,2149,2753],[2753,2149,2148],[2148,2754,2753],[2753,2754,2743],[2743,2742,2753],[2757,2756,2755],[2755,2758,2757],[2757,2758,2412],[2412,2411,2757],[2757,2411,2165],[2165,2428,2757],[2757,2428,2427],[2427,2756,2757],[2760,2759,2755],[2755,2756,2760],[2760,2756,2427],[2427,2442,2760],[2760,2442,2441],[2441,2761,2760],[2760,2761,2762],[2762,2759,2760],[2764,2763,2755],[2755,2759,2764],[2764,2759,2762],[2762,2765,2764],[2764,2765,2766],[2766,2767,2764],[2764,2767,2768],[2768,2763,2764],[2769,2758,2755],[2755,2763,2769],[2769,2763,2768],[2768,2770,2769],[2769,2770,2416],[2416,2415,2769],[2769,2415,2412],[2412,2758,2769],[2773,2772,2771],[2771,2774,2773],[2773,2774,2463],[2463,2462,2773],[2773,2462,2461],[2461,2775,2773],[2773,2775,2776],[2776,2772,2773],[2778,2777,2771],[2771,2772,2778],[2778,2772,2776],[2776,2779,2778],[2778,2779,2780],[2780,2781,2778],[2778,2781,2782],[2782,2777,2778],[2784,2783,2771],[2771,2777,2784],[2784,2777,2782],[2782,2785,2784],[2784,2785,2436],[2436,2448,2784],[2784,2448,2447],[2447,2783,2784],[2786,2774,2771],[2771,2783,2786],[2786,2783,2447],[2447,2454,2786],[2786,2454,2184],[2184,2466,2786],[2786,2466,2463],[2463,2774,2786],[2789,2788,2787],[2787,2790,2789],[2789,2790,2791],[2791,2792,2789],[2789,2792,2461],[2461,2460,2789],[2789,2460,2459],[2459,2788,2789],[2794,2793,2787],[2787,2788,2794],[2794,2788,2459],[2459,2474,2794],[2794,2474,2473],[2473,2795,2794],[2794,2795,2796],[2796,2793,2794],[2798,2797,2787],[2787,2793,2798],[2798,2793,2796],[2796,2799,2798],[2798,2799,2800],[2800,2801,2798],[2798,2801,2802],[2802,2797,2798],[2803,2790,2787],[2787,2797,2803],[2803,2797,2802],[2802,2804,2803],[2803,2804,2805],[2805,2806,2803],[2803,2806,2791],[2791,2790,2803],[2809,2808,2807],[2807,2810,2809],[2809,2810,2811],[2811,2812,2809],[2809,2812,2813],[2813,2814,2809],[2809,2814,2815],[2815,2808,2809],[2817,2816,2807],[2807,2808,2817],[2817,2808,2815],[2815,2818,2817],[2817,2818,2200],[2200,2199,2817],[2817,2199,2196],[2196,2816,2817],[2820,2819,2807],[2807,2816,2820],[2820,2816,2196],[2196,2195,2820],[2820,2195,1945],[1945,2521,2820],[2820,2521,2518],[2518,2819,2820],[2821,2810,2807],[2807,2819,2821],[2821,2819,2518],[2518,2517,2821],[2821,2517,2516],[2516,2822,2821],[2821,2822,2811],[2811,2810,2821],[2825,2824,2823],[2823,2826,2825],[2825,2826,2483],[2483,2482,2825],[2825,2482,2481],[2481,2827,2825],[2825,2827,2828],[2828,2824,2825],[2830,2829,2823],[2823,2824,2830],[2830,2824,2828],[2828,2831,2830],[2830,2831,2832],[2832,2833,2830],[2830,2833,2834],[2834,2829,2830],[2836,2835,2823],[2823,2829,2836],[2836,2829,2834],[2834,2837,2836],[2836,2837,2218],[2218,2217,2836],[2836,2217,2214],[2214,2835,2836],[2838,2826,2823],[2823,2835,2838],[2838,2835,2214],[2214,2213,2838],[2838,2213,1937],[1937,2486,2838],[2838,2486,2483],[2483,2826,2838],[2841,2840,2839],[2839,2842,2841],[2841,2842,2843],[2843,2844,2841],[2841,2844,2481],[2481,2480,2841],[2841,2480,2479],[2479,2840,2841],[2846,2845,2839],[2839,2840,2846],[2846,2840,2479],[2479,2490,2846],[2846,2490,2200],[2200,2818,2846],[2846,2818,2815],[2815,2845,2846],[2848,2847,2839],[2839,2845,2848],[2848,2845,2815],[2815,2814,2848],[2848,2814,2813],[2813,2849,2848],[2848,2849,2850],[2850,2847,2848],[2851,2842,2839],[2839,2847,2851],[2851,2847,2850],[2850,2852,2851],[2851,2852,2853],[2853,2854,2851],[2851,2854,2843],[2843,2842,2851],[2857,2856,2855],[2855,2858,2857],[2857,2858,2502],[2502,2501,2857],[2857,2501,2218],[2218,2837,2857],[2857,2837,2834],[2834,2856,2857],[2860,2859,2855],[2855,2856,2860],[2860,2856,2834],[2834,2833,2860],[2860,2833,2832],[2832,2861,2860],[2860,2861,2862],[2862,2859,2860],[2864,2863,2855],[2855,2859,2864],[2864,2859,2862],[2862,2865,2864],[2864,2865,2866],[2866,2867,2864],[2864,2867,2868],[2868,2863,2864],[2869,2858,2855],[2855,2863,2869],[2869,2863,2868],[2868,2870,2869],[2869,2870,2505],[2505,2504,2869],[2869,2504,2502],[2502,2858,2869],[2873,2872,2871],[2871,2874,2873],[2873,2874,2528],[2528,2527,2873],[2873,2229,2496],[2229,2873,2527],[2873,2496,2495],[2495,2872,2873],[2876,2875,2871],[2871,2872,2876],[2876,2872,2495],[2495,2506,2876],[2876,2506,2505],[2505,2877,2876],[2876,2877,2878],[2878,2875,2876],[2880,2879,2871],[2871,2875,2880],[2880,2875,2878],[2878,2881,2880],[2880,2881,2766],[2766,2882,2880],[2880,2882,2883],[2883,2879,2880],[2884,2874,2871],[2871,2879,2884],[2884,2879,2883],[2883,2885,2884],[2884,2885,2532],[2532,2531,2884],[2884,2531,2528],[2528,2874,2884],[2888,2887,2886],[2886,2889,2888],[2888,2889,2512],[2512,2511,2888],[2888,2511,2038],[2038,2676,2888],[2888,2676,2675],[2675,2887,2888],[2891,2890,2886],[2886,2887,2891],[2891,2887,2675],[2675,2690,2891],[2891,2690,2689],[2689,2892,2891],[2891,2892,2893],[2893,2890,2891],[2895,2894,2886],[2886,2890,2895],[2893,2896,2895],[2895,2890,2893],[2895,2896,2897],[2897,2898,2895],[2895,2898,2899],[2899,2894,2895],[2900,2889,2886],[2886,2894,2900],[2900,2894,2899],[2899,2901,2900],[2900,2901,2516],[2516,2515,2900],[2900,2515,2512],[2512,2889,2900],[2904,2903,2902],[2902,2905,2904],[2904,2905,2906],[2906,2907,2904],[2904,2907,2908],[2908,2909,2904],[2904,2909,2910],[2910,2903,2904],[2912,2911,2902],[2902,2903,2912],[2912,2903,2910],[2910,2913,2912],[2912,2913,2914],[2914,2915,2912],[2912,2915,2916],[2916,2911,2912],[2918,2917,2902],[2902,2911,2918],[2918,2911,2916],[2916,2919,2918],[2918,2919,2538],[2538,2537,2918],[2918,2537,2534],[2534,2917,2918],[2920,2905,2902],[2902,2917,2920],[2920,2917,2534],[2534,2533,2920],[2920,2533,2532],[2532,2921,2920],[2920,2906,2905],[2906,2920,2921],[2924,2923,2922],[2922,2925,2924],[2924,2925,2540],[2540,2539,2924],[2924,2539,2538],[2538,2926,2924],[2924,2926,2927],[2927,2923,2924],[2929,2928,2922],[2922,2923,2929],[2929,2923,2927],[2927,2930,2929],[2929,2930,2931],[2931,2932,2929],[2929,2932,2933],[2933,2928,2929],[2935,2934,2922],[2922,2928,2935],[2935,2928,2933],[2933,2936,2935],[2935,2936,2384],[2384,2553,2935],[2935,2553,2550],[2550,2934,2935],[2937,2925,2922],[2922,2934,2937],[2937,2934,2550],[2550,2549,2937],[2937,2549,2235],[2235,2542,2937],[2937,2542,2540],[2540,2925,2937],[2940,2939,2938],[2938,2941,2940],[2940,2941,2659],[2659,2658,2940],[2940,2658,2657],[2657,2942,2940],[2940,2942,2943],[2943,2939,2940],[2945,2944,2938],[2938,2939,2945],[2945,2939,2943],[2943,2946,2945],[2945,2946,2947],[2947,2948,2945],[2945,2948,2949],[2949,2944,2945],[2951,2950,2938],[2938,2944,2951],[2951,2944,2949],[2949,2952,2951],[2951,2952,2566],[2566,2565,2951],[2951,2565,2562],[2562,2950,2951],[2953,2941,2938],[2938,2950,2953],[2953,2950,2562],[2562,2561,2953],[2953,2561,2305],[2305,2662,2953],[2953,2659,2941],[2659,2953,2662],[2956,2955,2954],[2954,2957,2956],[2956,2957,2568],[2568,2567,2956],[2956,2567,2566],[2566,2958,2956],[2956,2958,2959],[2959,2955,2956],[2961,2960,2954],[2954,2955,2961],[2961,2955,2959],[2959,2962,2961],[2961,2962,2963],[2963,2964,2961],[2961,2964,2965],[2965,2960,2961],[2967,2966,2954],[2954,2960,2967],[2967,2960,2965],[2965,2968,2967],[2967,2968,2584],[2584,2583,2967],[2967,2583,2580],[2580,2966,2967],[2969,2957,2954],[2954,2966,2969],[2969,2966,2580],[2580,2579,2969],[2969,2579,2252],[2252,2570,2969],[2969,2570,2568],[2568,2957,2969],[2972,2971,2970],[2970,2973,2972],[2972,2973,2608],[2608,2607,2972],[2972,2607,2265],[2265,2596,2972],[2972,2596,2595],[2595,2971,2972],[2975,2974,2970],[2970,2971,2975],[2975,2971,2595],[2595,2602,2975],[2975,2602,2589],[2589,2976,2975],[2975,2976,2977],[2977,2974,2975],[2979,2978,2970],[2970,2974,2979],[2979,2974,2977],[2977,2980,2979],[2979,2980,2981],[2981,2982,2979],[2979,2982,2983],[2983,2978,2979],[2984,2973,2970],[2970,2978,2984],[2984,2978,2983],[2983,2985,2984],[2984,2985,2612],[2612,2611,2984],[2984,2611,2608],[2608,2973,2984],[2988,2987,2986],[2986,2989,2988],[2988,2989,2628],[2628,2627,2988],[2988,2627,2618],[2618,2990,2988],[2988,2990,2991],[2991,2987,2988],[2993,2992,2986],[2986,2987,2993],[2993,2987,2991],[2991,2994,2993],[2993,2994,2995],[2995,2996,2993],[2993,2996,2997],[2997,2992,2993],[2999,2998,2986],[2986,2992,2999],[2997,3000,2999],[2999,2992,2997],[2999,3000,2684],[2684,2683,2999],[2999,2683,2680],[2680,2998,2999],[3001,2989,2986],[2986,2998,3001],[3001,2998,2680],[2680,2679,3001],[3001,2679,2032],[2032,2631,3001],[3001,2631,2628],[2628,2989,3001],[3004,3003,3002],[3002,3005,3004],[3004,3005,2666],[2666,2665,3004],[3004,2665,2300],[2300,2640,3004],[3004,2640,2639],[2639,3003,3004],[3007,3006,3002],[3002,3003,3007],[3007,3003,2639],[2639,2650,3007],[3007,2650,2649],[2649,3008,3007],[3007,3008,3009],[3009,3006,3007],[3011,3010,3002],[3002,3006,3011],[3011,3006,3009],[3009,3012,3011],[3011,3012,3013],[3013,3014,3011],[3011,3014,3015],[3015,3010,3011],[3016,3005,3002],[3002,3010,3016],[3016,3010,3015],[3015,3017,3016],[3016,3017,2669],[2669,2668,3016],[3016,2668,2666],[2666,3005,3016],[3020,3019,3018],[3018,3021,3020],[3020,3021,3022],[3022,3023,3020],[3020,3023,2657],[2657,2656,3020],[3020,2656,2655],[2655,3019,3020],[3025,3024,3018],[3018,3019,3025],[3025,3019,2655],[2655,2670,3025],[3025,2670,2669],[2669,3026,3025],[3025,3026,3027],[3027,3024,3025],[3029,3028,3018],[3018,3024,3029],[3029,3024,3027],[3027,3030,3029],[3029,3030,3031],[3031,3032,3029],[3029,3032,3033],[3033,3028,3029],[3034,3021,3018],[3018,3028,3034],[3034,3028,3033],[3033,3035,3034],[3034,3035,3036],[3036,3037,3034],[3034,3037,3022],[3022,3021,3034],[3040,3039,3038],[3038,3041,3040],[3040,3041,3042],[3042,3043,3040],[3040,3043,2313],[2313,2421,3040],[3040,2421,2418],[2418,3039,3040],[3045,3044,3038],[3038,3039,3045],[3045,3039,2418],[2418,2417,3045],[3045,2417,2416],[2416,3046,3045],[3045,3046,3047],[3047,3044,3045],[3049,3048,3038],[3038,3044,3049],[3049,3044,3047],[3047,3050,3049],[3049,3050,2866],[2866,3051,3049],[3049,3051,3052],[3052,3048,3049],[3053,3041,3038],[3038,3048,3053],[3053,3048,3052],[3052,3054,3053],[3053,3054,3055],[3055,3056,3053],[3053,3056,3042],[3042,3041,3053],[3059,3058,3057],[3057,3060,3059],[3059,3060,3061],[3061,3062,3059],[3059,3062,2334],[2334,2333,3059],[2330,3058,3059],[3059,2333,2330],[3064,3063,3057],[3057,3058,3064],[3064,3058,2330],[2330,2329,3064],[3064,2329,2057],[2057,2318,3064],[3064,2318,2315],[2315,3063,3064],[3066,3065,3057],[3057,3063,3066],[3066,3063,2315],[2315,2314,3066],[3066,2314,2313],[2313,3043,3066],[3066,3043,3042],[3042,3065,3066],[3067,3060,3057],[3057,3065,3067],[3067,3065,3042],[3042,3056,3067],[3067,3056,3055],[3055,3068,3067],[3067,3068,3061],[3061,3060,3067],[3071,3070,3069],[3069,3072,3071],[3071,3072,2336],[2336,2335,3071],[3071,2335,2334],[2334,3073,3071],[3071,3073,3074],[3074,3070,3071],[3076,3075,3069],[3069,3070,3076],[3076,3070,3074],[3074,3077,3076],[3076,3077,3078],[3078,3079,3076],[3076,3079,3080],[3080,3075,3076],[3082,3081,3069],[3069,3075,3082],[3082,3075,3080],[3080,3083,3082],[3082,3083,2702],[2702,2701,3082],[3082,2701,2698],[2698,3081,3082],[3084,3072,3069],[3069,3081,3084],[3084,3081,2698],[2698,2697,3084],[3084,2697,2068],[2068,2338,3084],[3084,2338,2336],[2336,3072,3084],[3087,3086,3085],[3085,3088,3087],[3087,3088,3089],[3089,3090,3087],[3087,3090,2354],[2354,2353,3087],[3087,2353,2350],[2350,3086,3087],[3092,3091,3085],[3085,3086,3092],[3092,3086,2350],[2350,2349,3092],[3092,2349,2348],[2348,2722,3092],[3092,2722,2720],[2720,3091,3092],[3094,3093,3085],[3085,3091,3094],[3094,3091,2720],[2720,2719,3094],[3094,2719,2718],[2718,3095,3094],[3094,3095,3096],[3096,3093,3094],[3097,3088,3085],[3085,3093,3097],[3097,3093,3096],[3096,3098,3097],[3097,3098,3099],[3099,3100,3097],[3097,3100,3089],[3089,3088,3097],[3103,3102,3101],[3101,3104,3103],[3103,3104,2386],[2386,2385,3103],[3103,2385,2384],[2384,2936,3103],[3103,2936,2933],[2933,3102,3103],[3106,3105,3101],[3101,3102,3106],[3106,3102,2933],[2933,2932,3106],[3106,2932,2931],[2931,3107,3106],[3106,3107,3108],[3108,3105,3106],[3110,3109,3101],[3101,3105,3110],[3110,3105,3108],[3108,3111,3110],[3110,3111,3112],[3112,3113,3110],[3110,3113,3114],[3114,3109,3110],[3115,3104,3101],[3101,3109,3115],[3115,3109,3114],[3114,3116,3115],[3115,3116,2389],[2389,2388,3115],[3115,2388,2386],[2386,3104,3115],[3119,3118,3117],[3117,3120,3119],[3119,3120,3121],[3121,3122,3119],[3119,3122,2120],[2120,2728,3119],[3119,2728,2727],[2727,3118,3119],[3124,3123,3117],[3117,3118,3124],[3124,3118,2727],[2727,2738,3124],[3124,2738,2737],[2737,3125,3124],[3124,3125,3126],[3126,3123,3124],[3128,3127,3117],[3117,3123,3128],[3128,3123,3126],[3126,3129,3128],[3128,3129,3130],[3130,3131,3128],[3128,3131,3132],[3132,3127,3128],[3133,3120,3117],[3117,3127,3133],[3133,3127,3132],[3132,3134,3133],[3133,3134,3135],[3135,3136,3133],[3133,3136,3121],[3121,3120,3133],[3139,3138,3137],[3137,3140,3139],[3139,3140,3141],[3141,3142,3139],[3139,3142,2402],[2402,2401,3139],[3139,2401,2398],[2398,3138,3139],[3144,3143,3137],[3137,3138,3144],[3144,3138,2398],[2398,2397,3144],[3144,2397,2125],[2125,2124,3144],[3144,2124,2122],[2122,3143,3144],[3146,3145,3137],[3137,3143,3146],[3146,3143,2122],[2122,2121,3146],[3146,2121,2120],[2120,3122,3146],[3146,3122,3121],[3121,3145,3146],[3147,3140,3137],[3137,3145,3147],[3147,3145,3121],[3121,3136,3147],[3147,3136,3135],[3135,3148,3147],[3147,3148,3141],[3141,3140,3147],[3151,3150,3149],[3149,3152,3151],[3151,3152,3153],[3153,3154,3151],[3151,3154,2745],[2745,2744,3151],[3151,2744,2743],[2743,3150,3151],[3156,3155,3149],[3149,3150,3156],[3156,3150,2743],[2743,2754,3156],[3156,2754,2148],[2148,2406,3156],[3156,2406,2404],[2404,3155,3156],[3158,3157,3149],[3149,3155,3158],[3158,3155,2404],[2404,2403,3158],[3158,2403,2402],[2402,3159,3158],[3158,3159,3160],[3160,3157,3158],[3161,3152,3149],[3149,3157,3161],[3161,3157,3160],[3160,3162,3161],[3161,3162,3163],[3163,3164,3161],[3164,3153,3161],[3152,3161,3153],[3167,3166,3165],[3165,3168,3167],[3167,3168,2747],[2747,2746,3167],[3167,2746,2745],[2745,3169,3167],[3167,3169,3170],[3170,3166,3167],[3172,3171,3165],[3165,3166,3172],[3172,3166,3170],[3170,3173,3172],[3172,3173,3174],[3174,3175,3172],[3172,3175,3176],[3176,3171,3172],[3178,3177,3165],[3165,3171,3178],[3178,3171,3176],[3176,3179,3178],[3178,3179,2800],[2800,2799,3178],[3178,2799,2796],[2796,3177,3178],[3180,3168,3165],[3165,3177,3180],[3180,3177,2796],[2796,2795,3180],[3180,2795,2473],[2473,2750,3180],[3180,2750,2747],[2747,3168,3180],[3183,3182,3181],[3181,3184,3183],[3183,3184,3185],[3185,3186,3183],[3183,3186,2908],[2908,3187,3183],[3183,3187,3188],[3188,3182,3183],[3190,3189,3181],[3181,3182,3190],[3190,3182,3188],[3188,3191,3190],[3190,3191,2441],[2441,2440,3190],[3190,2440,2438],[2438,3189,3190],[3193,3192,3181],[3181,3189,3193],[3193,3189,2438],[2438,2437,3193],[3193,2437,2436],[2436,2785,3193],[3193,2785,2782],[2782,3192,3193],[3194,3184,3181],[3181,3192,3194],[3194,3192,2782],[2782,2781,3194],[3194,2781,2780],[2780,3195,3194],[3194,3195,3185],[3185,3184,3194],[3198,3197,3196],[3196,3199,3198],[3198,3199,2776],[2776,2775,3198],[2792,3198,2461],[2775,2461,3198],[3198,2792,2791],[2791,3197,3198],[3201,3200,3196],[3196,3197,3201],[3201,3197,2791],[2791,2806,3201],[3201,2806,2805],[2805,3202,3201],[3201,3202,3203],[3203,3200,3201],[3205,3204,3196],[3196,3200,3205],[3205,3200,3203],[3203,3206,3205],[3205,3206,3207],[3207,3208,3205],[3205,3208,3209],[3209,3204,3205],[3210,3199,3196],[3196,3204,3210],[3210,3204,3209],[3209,3211,3210],[3210,3211,2780],[2780,2779,3210],[3210,2779,2776],[2776,3199,3210],[3214,3213,3212],[3212,3215,3214],[3214,3215,2802],[2802,2801,3214],[3214,2801,2800],[2800,3216,3214],[3214,3216,3217],[3217,3213,3214],[3219,3218,3212],[3212,3213,3219],[3219,3213,3217],[3217,3220,3219],[3219,3220,3221],[3221,3222,3219],[3219,3222,3223],[3223,3218,3219],[3225,3224,3212],[3212,3218,3225],[3225,3218,3223],[3223,3226,3225],[3225,3226,3227],[3227,3228,3225],[3225,3228,3229],[3229,3224,3225],[3230,3215,3212],[3212,3224,3230],[3230,3224,3229],[3229,3231,3230],[3230,3231,2805],[2805,2804,3230],[3230,2804,2802],[2802,3215,3230],[3234,3233,3232],[3232,3235,3234],[3234,3235,3236],[3236,3237,3234],[3234,3237,2813],[2813,2812,3234],[3234,2812,2811],[2811,3233,3234],[3239,3238,3232],[3232,3233,3239],[3239,3233,2811],[2811,2822,3239],[3239,2822,2516],[2516,2901,3239],[3239,2901,2899],[2899,3238,3239],[3241,3240,3232],[3232,3238,3241],[3241,3238,2899],[2899,2898,3241],[3241,2898,2897],[2897,3242,3241],[3241,3242,3243],[3243,3240,3241],[3244,3235,3232],[3232,3240,3244],[3244,3240,3243],[3243,3245,3244],[3245,3246,3244],[3247,3244,3246],[3244,3247,3236],[3236,3235,3244],[3250,3249,3248],[3248,3251,3250],[3250,3251,2828],[2828,2827,3250],[3250,2827,2481],[2481,2844,3250],[3250,2844,2843],[2843,3249,3250],[3253,3252,3248],[3248,3249,3253],[3253,3249,2843],[2843,2854,3253],[3253,2854,2853],[2853,3254,3253],[3253,3254,3255],[3255,3252,3253],[3257,3256,3248],[3248,3252,3257],[3257,3252,3255],[3255,3258,3257],[3257,3258,3259],[3259,3260,3257],[3257,3260,3261],[3261,3256,3257],[3262,3251,3248],[3248,3256,3262],[3262,3256,3261],[3261,3263,3262],[3262,3263,2832],[2832,2831,3262],[3262,2831,2828],[2828,3251,3262],[3266,3265,3264],[3264,3267,3266],[3266,3267,2768],[2768,2767,3266],[3266,2767,2766],[2766,2881,3266],[3266,2881,2878],[2878,3265,3266],[3269,3268,3264],[3264,3265,3269],[3269,3265,2878],[2878,2877,3269],[3269,2877,2505],[2505,2870,3269],[3269,2870,2868],[2868,3268,3269],[3271,3270,3264],[3264,3268,3271],[3271,3268,2868],[2868,2867,3271],[3271,2867,2866],[2866,3050,3271],[3271,3050,3047],[3047,3270,3271],[3272,3267,3264],[3264,3270,3272],[3272,3270,3047],[3047,3046,3272],[3272,3046,2416],[2416,2770,3272],[3272,2770,2768],[2768,3267,3272],[3275,3274,3273],[3273,3276,3275],[3275,3276,3188],[3188,3187,3275],[3275,3187,2908],[2908,2907,3275],[3275,2907,2906],[2906,3274,3275],[3278,3277,3273],[3273,3274,3278],[3274,2906,3278],[2921,3278,2906],[3278,2921,2532],[2532,2885,3278],[3278,2885,2883],[2883,3277,3278],[3280,3279,3273],[3273,3277,3280],[3280,3277,2883],[2883,2882,3280],[3280,2882,2766],[2766,2765,3280],[3280,2765,2762],[2762,3279,3280],[3281,3276,3273],[3273,3279,3281],[3281,3279,2762],[2762,2761,3281],[3281,2761,2441],[2441,3191,3281],[3281,3191,3188],[3188,3276,3281],[3284,3283,3282],[3282,3285,3284],[3284,3285,2910],[2910,2909,3284],[3284,2909,2908],[2908,3186,3284],[3284,3186,3185],[3185,3283,3284],[3287,3286,3282],[3282,3283,3287],[3287,3283,3185],[3185,3195,3287],[3287,3195,2780],[2780,3211,3287],[3287,3211,3209],[3209,3286,3287],[3289,3288,3282],[3282,3286,3289],[3289,3286,3209],[3209,3208,3289],[3289,3208,3207],[3207,3290,3289],[3289,3290,3291],[3291,3288,3289],[3292,3285,3282],[3282,3288,3292],[3292,3288,3291],[3291,3293,3292],[3292,3293,2914],[2914,2913,3292],[3292,2913,2910],[2910,3285,3292],[3296,3295,3294],[3294,3297,3296],[3296,3297,2927],[2927,2926,3296],[3296,2926,2538],[2538,2919,3296],[3296,2919,2916],[2916,3295,3296],[3299,3298,3294],[3294,3295,3299],[3299,3295,2916],[2916,2915,3299],[3299,2915,2914],[2914,3300,3299],[3299,3300,3301],[3301,3298,3299],[3303,3302,3294],[3294,3298,3303],[3303,3298,3301],[3301,3304,3303],[3303,3304,3305],[3305,3306,3303],[3303,3306,3307],[3307,3302,3303],[3308,3297,3294],[3294,3302,3308],[3308,3302,3307],[3307,3309,3308],[3308,3309,2931],[2931,2930,3308],[3308,2930,2927],[2927,3297,3308],[3312,3311,3310],[3310,3313,3312],[3312,3313,2943],[2943,2942,3312],[3312,2942,2657],[2657,3023,3312],[3312,3023,3022],[3022,3311,3312],[3315,3314,3310],[3310,3311,3315],[3315,3311,3022],[3022,3037,3315],[3315,3037,3036],[3036,3316,3315],[3315,3316,3317],[3317,3314,3315],[3319,3318,3310],[3310,3314,3319],[3319,3314,3317],[3317,3320,3319],[3319,3320,3321],[3321,3322,3319],[3319,3322,3323],[3323,3318,3319],[3324,3313,3310],[3310,3318,3324],[3324,3318,3323],[3323,3325,3324],[3324,3325,2947],[2947,2946,3324],[3324,2946,2943],[2943,3313,3324],[3328,3327,3326],[3326,3329,3328],[3328,3329,2959],[2959,2958,3328],[3328,2958,2566],[2566,2952,3328],[3328,2952,2949],[2949,3327,3328],[3331,3330,3326],[3326,3327,3331],[3331,3327,2949],[2949,2948,3331],[3331,2948,2947],[2947,3332,3331],[3331,3332,3333],[3333,3330,3331],[3335,3334,3326],[3326,3330,3335],[3335,3330,3333],[3333,3336,3335],[3335,3336,3337],[3337,3338,3335],[3335,3338,3339],[3339,3334,3335],[3340,3329,3326],[3326,3334,3340],[3340,3334,3339],[3339,3341,3340],[3340,3341,2963],[2963,2962,3340],[3340,2962,2959],[2959,3329,3340],[3344,3343,3342],[3342,3345,3344],[3344,3345,2586],[2586,2585,3344],[3344,2585,2584],[2584,3346,3344],[3344,3346,3347],[3347,3343,3344],[3349,3348,3342],[3342,3343,3349],[3349,3343,3347],[3347,3350,3349],[3349,3350,3351],[3351,3352,3349],[3349,3352,3353],[3353,3348,3349],[3355,3354,3342],[3342,3348,3355],[3355,3348,3353],[3353,3356,3355],[3355,3356,2981],[2981,2980,3355],[3355,2980,2977],[2977,3354,3355],[3357,3345,3342],[3342,3354,3357],[3357,3354,2977],[2977,2976,3357],[3357,2976,2589],[2589,2588,3357],[3357,2588,2586],[2586,3345,3357],[3360,3359,3358],[3358,3361,3360],[3360,3361,2991],[2991,2990,3360],[3360,2990,2618],[2618,2617,3360],[3360,2617,2614],[2614,3359,3360],[3363,3362,3358],[3358,3359,3363],[3363,3359,2614],[2614,2613,3363],[3363,2613,2612],[2612,3364,3363],[3363,3364,3365],[3365,3362,3363],[3367,3366,3358],[3358,3362,3367],[3367,3362,3365],[3365,3368,3367],[3367,3368,3369],[3369,3370,3367],[3367,3370,3371],[3371,3366,3367],[3372,3361,3358],[3358,3366,3372],[3372,3366,3371],[3371,3373,3372],[3372,3373,2995],[2995,2994,3372],[3372,2994,2991],[2991,3361,3372],[3376,3375,3374],[3374,3377,3376],[3376,3377,3378],[3378,3379,3376],[3376,3379,3031],[3031,3030,3376],[3376,3030,3027],[3027,3375,3376],[3381,3380,3374],[3374,3375,3381],[3381,3375,3027],[3027,3026,3381],[3381,3026,2669],[2669,3017,3381],[3381,3017,3015],[3015,3380,3381],[3383,3382,3374],[3374,3380,3383],[3383,3380,3015],[3015,3014,3383],[3383,3014,3013],[3013,3384,3383],[3383,3384,3385],[3385,3382,3383],[3386,3377,3374],[3374,3382,3386],[3386,3382,3385],[3385,3387,3386],[3386,3387,3388],[3388,3389,3386],[3386,3389,3378],[3378,3377,3386],[3392,3391,3390],[3390,3393,3392],[3392,3393,3394],[3394,3395,3392],[3392,3395,3396],[3396,3397,3392],[3392,3397,3398],[3398,3391,3392],[3400,3399,3390],[3390,3391,3400],[3391,3398,3400],[3401,3400,3398],[3400,3401,3036],[3036,3035,3400],[3400,3035,3033],[3033,3399,3400],[3403,3402,3390],[3390,3399,3403],[3403,3399,3033],[3033,3032,3403],[3403,3032,3031],[3031,3404,3403],[3403,3404,3405],[3405,3402,3403],[3406,3393,3390],[3390,3402,3406],[3406,3402,3405],[3405,3407,3406],[3406,3407,3408],[3408,3409,3406],[3406,3409,3394],[3394,3393,3406],[3412,3411,3410],[3410,3413,3412],[3412,3413,2686],[2686,2685,3412],[3412,2685,2684],[2684,3414,3412],[3412,3414,3415],[3415,3411,3412],[3417,3416,3410],[3410,3411,3417],[3417,3411,3415],[3415,3418,3417],[3417,3418,3419],[3419,3420,3417],[3417,3420,3421],[3421,3416,3417],[3423,3422,3410],[3410,3416,3423],[3423,3416,3421],[3421,3424,3423],[3423,3424,3425],[3425,3426,3423],[3423,3426,3427],[3427,3422,3423],[3428,3413,3410],[3410,3422,3428],[3428,3422,3427],[3427,3429,3428],[3428,3429,2689],[2689,2688,3428],[3428,2688,2686],[2686,3413,3428],[3432,3431,3430],[3430,3433,3432],[3432,3433,3074],[3074,3073,3432],[3432,3073,2334],[2334,3062,3432],[3432,3062,3061],[3061,3431,3432],[3435,3434,3430],[3430,3431,3435],[3435,3431,3061],[3061,3068,3435],[3435,3068,3055],[3055,3436,3435],[3435,3436,3437],[3437,3434,3435],[3439,3438,3430],[3430,3434,3439],[3439,3434,3437],[3437,3440,3439],[3439,3440,3259],[3259,3441,3439],[3439,3441,3442],[3442,3438,3439],[3443,3433,3430],[3430,3438,3443],[3443,3438,3442],[3442,3444,3443],[3443,3444,3078],[3078,3077,3443],[3443,3077,3074],[3074,3433,3443],[3447,3446,3445],[3445,3448,3447],[3447,3448,2704],[2704,2703,3447],[3447,2703,2702],[2702,3449,3447],[3447,3449,3450],[3450,3446,3447],[3452,3451,3445],[3445,3446,3452],[3452,3446,3450],[3450,3453,3452],[3452,3453,3454],[3454,3455,3452],[3452,3455,3456],[3456,3451,3452],[3458,3457,3445],[3445,3451,3458],[3458,3451,3456],[3456,3459,3458],[3458,3459,3013],[3013,3012,3458],[3458,3012,3009],[3009,3457,3458],[3460,3448,3445],[3445,3457,3460],[3460,3457,3009],[3009,3008,3460],[3460,3008,2649],[2649,2706,3460],[3460,2706,2704],[2704,3448,3460],[3463,3462,3461],[3461,3464,3463],[3463,3464,2734],[2734,2733,3463],[3463,2733,2354],[2354,3090,3463],[3463,3090,3089],[3089,3462,3463],[3466,3465,3461],[3461,3462,3466],[3466,3462,3089],[3089,3100,3466],[3466,3100,3099],[3099,3467,3466],[3466,3467,3468],[3468,3465,3466],[3470,3469,3461],[3461,3465,3470],[3470,3465,3468],[3468,3471,3470],[3470,3471,3472],[3472,3473,3470],[3470,3473,3474],[3474,3469,3470],[3475,3464,3461],[3461,3469,3475],[3475,3469,3474],[3474,3476,3475],[3475,3476,2737],[2737,2736,3475],[3475,2736,2734],[2734,3464,3475],[3479,3478,3477],[3477,3480,3479],[3482,3479,3481],[3480,3481,3479],[3479,3482,2718],[2718,2717,3479],[3479,2717,2714],[2714,3478,3479],[3484,3483,3477],[3477,3478,3484],[3484,3478,2714],[2714,2713,3484],[3484,2713,2389],[2389,3116,3484],[3484,3116,3114],[3114,3483,3484],[3486,3485,3477],[3477,3483,3486],[3486,3483,3114],[3114,3113,3486],[3486,3113,3112],[3112,3487,3486],[3486,3487,3488],[3488,3485,3486],[3489,3480,3477],[3477,3485,3489],[3489,3485,3488],[3488,3490,3489],[3489,3490,3491],[3491,3492,3489],[3489,3492,3481],[3481,3480,3489],[3495,3494,3493],[3493,3496,3495],[3495,3496,3497],[3497,3498,3495],[3495,3498,3499],[3499,3500,3495],[3495,3500,3501],[3501,3494,3495],[3503,3502,3493],[3493,3494,3503],[3503,3494,3501],[3501,3504,3503],[3503,3504,3163],[3163,3162,3503],[3503,3162,3160],[3160,3502,3503],[3506,3505,3493],[3493,3502,3506],[3506,3502,3160],[3160,3159,3506],[3506,3159,2402],[2402,3142,3506],[3506,3142,3141],[3141,3505,3506],[3507,3496,3493],[3493,3505,3507],[3507,3505,3141],[3141,3148,3507],[3507,3148,3135],[3135,3508,3507],[3507,3508,3497],[3497,3496,3507],[3511,3510,3509],[3509,3512,3511],[3511,3512,3170],[3170,3169,3511],[3511,3169,2745],[2745,3154,3511],[3511,3154,3153],[3153,3510,3511],[3514,3513,3509],[3509,3510,3514],[3164,3514,3153],[3510,3153,3514],[3514,3164,3163],[3163,3515,3514],[3514,3515,3516],[3516,3513,3514],[3518,3517,3509],[3509,3513,3518],[3518,3513,3516],[3516,3519,3518],[3518,3519,3520],[3520,3521,3518],[3518,3521,3522],[3522,3517,3518],[3523,3512,3509],[3509,3517,3523],[3523,3517,3522],[3522,3524,3523],[3523,3524,3174],[3174,3173,3523],[3523,3173,3170],[3170,3512,3523],[3527,3526,3525],[3525,3528,3527],[3527,3528,3217],[3217,3216,3527],[3527,3216,2800],[2800,3179,3527],[3527,3179,3176],[3176,3526,3527],[3530,3529,3525],[3525,3526,3530],[3530,3526,3176],[3176,3175,3530],[3530,3175,3174],[3174,3531,3530],[3530,3531,3532],[3532,3529,3530],[3534,3533,3525],[3525,3529,3534],[3534,3529,3532],[3532,3535,3534],[3534,3535,3536],[3536,3537,3534],[3534,3537,3538],[3538,3533,3534],[3539,3528,3525],[3525,3533,3539],[3539,3533,3538],[3538,3540,3539],[3539,3540,3221],[3221,3220,3539],[3539,3220,3217],[3217,3528,3539],[3543,3542,3541],[3541,3544,3543],[3543,3544,3545],[3545,3546,3543],[3543,3546,3207],[3207,3206,3543],[3543,3206,3203],[3203,3542,3543],[3548,3547,3541],[3541,3542,3548],[3548,3542,3203],[3203,3202,3548],[3548,3202,2805],[2805,3231,3548],[3548,3231,3229],[3229,3547,3548],[3550,3549,3541],[3541,3547,3550],[3550,3547,3229],[3229,3228,3550],[3550,3228,3227],[3227,3551,3550],[3550,3551,3552],[3552,3549,3550],[3553,3544,3541],[3541,3549,3553],[3553,3549,3552],[3552,3554,3553],[3553,3554,3555],[3555,3556,3553],[3553,3556,3545],[3545,3544,3553],[3559,3558,3557],[3557,3560,3559],[3559,3560,2850],[2850,2849,3559],[3559,2849,2813],[2813,3237,3559],[3559,3237,3236],[3236,3558,3559],[3562,3561,3557],[3557,3558,3562],[3562,3558,3236],[3236,3247,3562],[3562,3247,3246],[3246,3563,3562],[3562,3563,3564],[3564,3561,3562],[3566,3565,3557],[3557,3561,3566],[3566,3561,3564],[3564,3567,3566],[3566,3567,3568],[3568,3569,3566],[3566,3569,3570],[3570,3565,3566],[3571,3560,3557],[3557,3565,3571],[3571,3565,3570],[3570,3572,3571],[3571,3572,2853],[2853,2852,3571],[3571,2852,2850],[2850,3560,3571],[3575,3574,3573],[3573,3576,3575],[3575,3576,3052],[3052,3051,3575],[3575,3051,2866],[2866,2865,3575],[3575,2865,2862],[2862,3574,3575],[3578,3577,3573],[3573,3574,3578],[3578,3574,2862],[2862,2861,3578],[3578,2861,2832],[2832,3263,3578],[3578,3263,3261],[3261,3577,3578],[3580,3579,3573],[3573,3577,3580],[3580,3577,3261],[3261,3260,3580],[3580,3260,3259],[3259,3440,3580],[3580,3440,3437],[3437,3579,3580],[3581,3576,3573],[3573,3579,3581],[3581,3579,3437],[3437,3436,3581],[3581,3436,3055],[3055,3054,3581],[3581,3054,3052],[3052,3576,3581],[3584,3583,3582],[3582,3585,3584],[3584,3585,3586],[3586,3587,3584],[3584,3587,2897],[2897,2896,3584],[2893,3584,2896],[3584,2893,3583],[3589,3588,3582],[3582,3583,3589],[3589,3583,2893],[2893,2892,3589],[3589,2892,2689],[2689,3429,3589],[3589,3429,3427],[3427,3588,3589],[3591,3590,3582],[3582,3588,3591],[3591,3588,3427],[3427,3426,3591],[3591,3426,3425],[3425,3592,3591],[3591,3592,3593],[3593,3590,3591],[3594,3585,3582],[3582,3590,3594],[3594,3590,3593],[3593,3595,3594],[3594,3595,3596],[3596,3597,3594],[3594,3597,3586],[3586,3585,3594],[3600,3599,3598],[3598,3601,3600],[3600,3601,3291],[3291,3290,3600],[3600,3290,3207],[3207,3546,3600],[3600,3546,3545],[3545,3599,3600],[3603,3602,3598],[3598,3599,3603],[3603,3599,3545],[3545,3556,3603],[3603,3556,3555],[3555,3604,3603],[3603,3604,3605],[3605,3602,3603],[3607,3606,3598],[3598,3602,3607],[3607,3602,3605],[3605,3608,3607],[3607,3608,3305],[3305,3304,3607],[3607,3304,3301],[3301,3606,3607],[3609,3601,3598],[3598,3606,3609],[3609,3606,3301],[3301,3300,3609],[3609,3300,2914],[2914,3293,3609],[3609,3293,3291],[3291,3601,3609],[3612,3611,3610],[3610,3613,3612],[3612,3613,3398],[3398,3397,3612],[3612,3397,3396],[3396,3614,3612],[3612,3614,3615],[3615,3611,3612],[3617,3616,3610],[3610,3611,3617],[3617,3611,3615],[3615,3618,3617],[3617,3618,3619],[3619,3620,3617],[3617,3620,3621],[3621,3616,3617],[3623,3622,3610],[3610,3616,3623],[3623,3616,3621],[3621,3624,3623],[3623,3624,3321],[3321,3320,3623],[3623,3320,3317],[3317,3622,3623],[3625,3613,3610],[3610,3622,3625],[3625,3622,3317],[3317,3316,3625],[3625,3316,3036],[3036,3401,3625],[3401,3398,3625],[3613,3625,3398],[3628,3627,3626],[3626,3629,3628],[3628,3629,3323],[3323,3322,3628],[3628,3322,3321],[3321,3630,3628],[3628,3630,3631],[3631,3627,3628],[3633,3632,3626],[3626,3627,3633],[3633,3627,3631],[3631,3634,3633],[3633,3634,3635],[3635,3636,3633],[3633,3636,3637],[3637,3632,3633],[3639,3638,3626],[3626,3632,3639],[3639,3632,3637],[3637,3640,3639],[3639,3640,3337],[3337,3336,3639],[3639,3336,3333],[3333,3638,3639],[3641,3629,3626],[3626,3638,3641],[3641,3638,3333],[3333,3332,3641],[3641,3332,2947],[2947,3325,3641],[3641,3325,3323],[3323,3629,3641],[3644,3643,3642],[3642,3645,3644],[3644,3645,3347],[3347,3346,3644],[3644,3346,2584],[2584,2968,3644],[3644,2968,2965],[2965,3643,3644],[3647,3646,3642],[3642,3643,3647],[3647,3643,2965],[2965,2964,3647],[3647,2964,2963],[2963,3648,3647],[3647,3648,3649],[3649,3646,3647],[3651,3650,3642],[3642,3646,3651],[3651,3646,3649],[3649,3652,3651],[3651,3652,3653],[3653,3654,3651],[3651,3654,3655],[3655,3650,3651],[3656,3645,3642],[3642,3650,3656],[3656,3650,3655],[3655,3657,3656],[3656,3657,3351],[3351,3350,3656],[3656,3350,3347],[3347,3645,3656],[3660,3659,3658],[3658,3661,3660],[3660,3661,2983],[2983,2982,3660],[3660,2982,2981],[2981,3662,3660],[3660,3662,3663],[3663,3659,3660],[3665,3664,3658],[3658,3659,3665],[3665,3659,3663],[3663,3666,3665],[3665,3666,3667],[3667,3668,3665],[3665,3668,3669],[3669,3664,3665],[3671,3670,3658],[3658,3664,3671],[3671,3664,3669],[3669,3672,3671],[3671,3672,3369],[3369,3368,3671],[3671,3368,3365],[3365,3670,3671],[3673,3661,3658],[3658,3670,3673],[3673,3670,3365],[3365,3364,3673],[3673,3364,2612],[2612,2985,3673],[3673,2985,2983],[2983,3661,3673],[3676,3675,3674],[3674,3677,3676],[3676,3677,3415],[3415,3414,3676],[3676,3414,2684],[2684,3000,3676],[2997,3676,3000],[3676,2997,3675],[3679,3678,3674],[3674,3675,3679],[3679,3675,2997],[2997,2996,3679],[3679,2996,2995],[2995,3680,3679],[3679,3680,3681],[3681,3678,3679],[3683,3682,3674],[3674,3678,3683],[3683,3678,3681],[3681,3684,3683],[3683,3684,3685],[3685,3686,3683],[3683,3686,3687],[3687,3682,3683],[3688,3677,3674],[3674,3682,3688],[3688,3682,3687],[3687,3689,3688],[3688,3689,3419],[3419,3418,3688],[3688,3418,3415],[3415,3677,3688],[3692,3691,3690],[3690,3693,3692],[3692,3693,3405],[3405,3404,3692],[3692,3404,3031],[3031,3379,3692],[3692,3379,3378],[3378,3691,3692],[3695,3694,3690],[3690,3691,3695],[3695,3691,3378],[3378,3389,3695],[3695,3389,3388],[3388,3696,3695],[3695,3696,3697],[3697,3694,3695],[3699,3698,3690],[3690,3694,3699],[3699,3694,3697],[3697,3700,3699],[3699,3700,3701],[3701,3702,3699],[3699,3702,3703],[3703,3698,3699],[3704,3693,3690],[3690,3698,3704],[3704,3698,3703],[3703,3705,3704],[3704,3705,3408],[3408,3407,3704],[3704,3407,3405],[3405,3693,3704],[3708,3707,3706],[3706,3709,3708],[3708,3709,3710],[3710,3711,3708],[3708,3711,3396],[3396,3395,3708],[3708,3395,3394],[3394,3707,3708],[3713,3712,3706],[3706,3707,3713],[3713,3707,3394],[3394,3409,3713],[3713,3409,3408],[3408,3714,3713],[3713,3714,3715],[3715,3712,3713],[3717,3716,3706],[3706,3712,3717],[3717,3712,3715],[3715,3718,3717],[3717,3718,3719],[3719,3720,3717],[3717,3720,3721],[3721,3716,3717],[3722,3709,3706],[3706,3716,3722],[3722,3716,3721],[3721,3723,3722],[3722,3723,3724],[3724,3725,3722],[3722,3725,3710],[3710,3709,3722],[3728,3727,3726],[3726,3729,3728],[3728,3729,3450],[3450,3449,3728],[3728,3449,2702],[2702,3083,3728],[3728,3083,3080],[3080,3727,3728],[3731,3730,3726],[3726,3727,3731],[3731,3727,3080],[3080,3079,3731],[3731,3079,3078],[3078,3732,3731],[3731,3732,3733],[3733,3730,3731],[3735,3734,3726],[3726,3730,3735],[3736,3735,3733],[3730,3733,3735],[3735,3736,3568],[3568,3737,3735],[3735,3737,3738],[3738,3734,3735],[3739,3729,3726],[3726,3734,3739],[3739,3734,3738],[3738,3740,3739],[3739,3740,3454],[3454,3453,3739],[3739,3453,3450],[3450,3729,3739],[3743,3742,3741],[3741,3744,3743],[3743,3744,3096],[3096,3095,3743],[3743,3095,2718],[2718,3482,3743],[3481,3742,3743],[3743,3482,3481],[3746,3745,3741],[3741,3742,3746],[3746,3742,3481],[3481,3492,3746],[3746,3492,3491],[3491,3747,3746],[3746,3747,3748],[3748,3745,3746],[3750,3749,3741],[3741,3745,3750],[3750,3745,3748],[3748,3751,3750],[3750,3751,3752],[3752,3753,3750],[3750,3753,3754],[3754,3749,3750],[3755,3744,3741],[3741,3749,3755],[3755,3749,3754],[3754,3756,3755],[3755,3756,3099],[3099,3098,3755],[3755,3098,3096],[3096,3744,3755],[3759,3758,3757],[3757,3760,3759],[3759,3760,3761],[3761,3762,3759],[3759,3762,3112],[3112,3111,3759],[3759,3111,3108],[3108,3758,3759],[3764,3763,3757],[3757,3758,3764],[3764,3758,3108],[3108,3107,3764],[3764,3107,2931],[2931,3309,3764],[3764,3309,3307],[3307,3763,3764],[3766,3765,3757],[3757,3763,3766],[3766,3763,3307],[3307,3306,3766],[3766,3306,3305],[3305,3767,3766],[3766,3767,3768],[3768,3765,3766],[3769,3760,3757],[3757,3765,3769],[3769,3765,3768],[3768,3770,3769],[3769,3770,3771],[3771,3772,3769],[3769,3772,3761],[3761,3760,3769],[3775,3774,3773],[3773,3776,3775],[3775,3776,3777],[3777,3778,3775],[3775,3778,3130],[3130,3129,3775],[3775,3129,3126],[3126,3774,3775],[3780,3779,3773],[3773,3774,3780],[3780,3774,3126],[3126,3125,3780],[3780,3125,2737],[2737,3476,3780],[3780,3476,3474],[3474,3779,3780],[3782,3781,3773],[3773,3779,3782],[3782,3779,3474],[3474,3473,3782],[3782,3473,3472],[3472,3783,3782],[3782,3783,3784],[3784,3781,3782],[3785,3776,3773],[3773,3781,3785],[3785,3781,3784],[3784,3786,3785],[3785,3786,3787],[3787,3788,3785],[3785,3788,3777],[3777,3776,3785],[3791,3790,3789],[3789,3792,3791],[3791,3792,3793],[3793,3794,3791],[3791,3794,3499],[3499,3498,3791],[3791,3498,3497],[3497,3790,3791],[3796,3795,3789],[3789,3790,3796],[3796,3790,3497],[3497,3508,3796],[3796,3508,3135],[3135,3134,3796],[3796,3134,3132],[3132,3795,3796],[3798,3797,3789],[3789,3795,3798],[3798,3795,3132],[3132,3131,3798],[3798,3131,3130],[3130,3799,3798],[3798,3799,3800],[3800,3797,3798],[3801,3792,3789],[3789,3797,3801],[3801,3797,3800],[3800,3802,3801],[3801,3802,3803],[3803,3804,3801],[3801,3804,3793],[3793,3792,3801],[3807,3806,3805],[3805,3808,3807],[3807,3808,3501],[3501,3500,3807],[3807,3500,3499],[3499,3809,3807],[3807,3809,3810],[3810,3806,3807],[3812,3811,3805],[3805,3806,3812],[3812,3806,3810],[3810,3813,3812],[3812,3813,3814],[3814,3815,3812],[3812,3815,3816],[3816,3811,3812],[3818,3817,3805],[3805,3811,3818],[3818,3811,3816],[3816,3819,3818],[3818,3819,3520],[3520,3519,3818],[3818,3519,3516],[3516,3817,3818],[3820,3808,3805],[3805,3817,3820],[3820,3817,3516],[3516,3515,3820],[3820,3515,3163],[3163,3504,3820],[3820,3504,3501],[3501,3808,3820],[3823,3822,3821],[3821,3824,3823],[3823,3824,3522],[3522,3521,3823],[3823,3521,3520],[3520,3825,3823],[3823,3825,3826],[3826,3822,3823],[3828,3827,3821],[3821,3822,3828],[3828,3822,3826],[3826,3829,3828],[3828,3829,3830],[3830,3831,3828],[3828,3831,3832],[3832,3827,3828],[3834,3833,3821],[3821,3827,3834],[3834,3827,3832],[3832,3835,3834],[3834,3835,3536],[3536,3535,3834],[3834,3535,3532],[3532,3833,3834],[3836,3824,3821],[3821,3833,3836],[3836,3833,3532],[3532,3531,3836],[3836,3531,3174],[3174,3524,3836],[3836,3524,3522],[3522,3824,3836],[3839,3838,3837],[3837,3840,3839],[3839,3840,3841],[3841,3842,3839],[3839,3842,3227],[3227,3226,3839],[3839,3226,3223],[3223,3838,3839],[3844,3843,3837],[3837,3838,3844],[3844,3838,3223],[3223,3222,3844],[3844,3222,3221],[3221,3845,3844],[3844,3845,3846],[3846,3843,3844],[3848,3847,3837],[3837,3843,3848],[3848,3843,3846],[3846,3849,3848],[3848,3849,3850],[3850,3851,3848],[3848,3851,3852],[3852,3847,3848],[3853,3840,3837],[3837,3847,3853],[3853,3847,3852],[3852,3854,3853],[3853,3854,3855],[3855,3856,3853],[3853,3856,3841],[3841,3840,3853],[3859,3858,3857],[3857,3860,3859],[3859,3860,3243],[3243,3242,3859],[3859,3242,2897],[2897,3587,3859],[3859,3587,3586],[3586,3858,3859],[3862,3861,3857],[3857,3858,3862],[3862,3858,3586],[3586,3597,3862],[3862,3597,3596],[3596,3863,3862],[3862,3863,3864],[3864,3861,3862],[3866,3865,3857],[3857,3861,3866],[3866,3861,3864],[3864,3867,3866],[3866,3867,3868],[3868,3869,3866],[3866,3869,3870],[3870,3865,3866],[3871,3860,3857],[3857,3865,3871],[3871,3865,3870],[3870,3872,3871],[3871,3246,3245],[3246,3871,3872],[3871,3245,3243],[3243,3860,3871],[3875,3874,3873],[3873,3876,3875],[3875,3876,3442],[3442,3441,3875],[3875,3441,3259],[3259,3258,3875],[3875,3258,3255],[3255,3874,3875],[3878,3877,3873],[3873,3874,3878],[3878,3874,3255],[3255,3254,3878],[3878,3254,2853],[2853,3572,3878],[3878,3572,3570],[3570,3877,3878],[3880,3879,3873],[3873,3877,3880],[3880,3877,3570],[3570,3569,3880],[3880,3569,3568],[3568,3736,3880],[3733,3879,3880],[3880,3736,3733],[3881,3876,3873],[3873,3879,3881],[3881,3879,3733],[3733,3732,3881],[3881,3732,3078],[3078,3444,3881],[3881,3444,3442],[3442,3876,3881],[3884,3883,3882],[3882,3885,3884],[3884,3885,3615],[3615,3614,3884],[3884,3614,3396],[3396,3711,3884],[3884,3711,3710],[3710,3883,3884],[3887,3886,3882],[3882,3883,3887],[3887,3883,3710],[3710,3725,3887],[3887,3725,3724],[3724,3888,3887],[3887,3888,3889],[3889,3886,3887],[3891,3890,3882],[3882,3886,3891],[3891,3886,3889],[3889,3892,3891],[3891,3892,3893],[3893,3894,3891],[3891,3894,3895],[3895,3890,3891],[3896,3885,3882],[3882,3890,3896],[3896,3890,3895],[3895,3897,3896],[3896,3897,3619],[3619,3618,3896],[3896,3618,3615],[3615,3885,3896],[3900,3899,3898],[3898,3901,3900],[3900,3901,3631],[3631,3630,3900],[3900,3630,3321],[3321,3624,3900],[3900,3624,3621],[3621,3899,3900],[3903,3902,3898],[3898,3899,3903],[3903,3899,3621],[3621,3620,3903],[3903,3620,3619],[3619,3904,3903],[3903,3904,3905],[3905,3902,3903],[3907,3906,3898],[3898,3902,3907],[3907,3902,3905],[3905,3908,3907],[3907,3908,3909],[3909,3910,3907],[3907,3910,3911],[3911,3906,3907],[3912,3901,3898],[3898,3906,3912],[3912,3906,3911],[3911,3913,3912],[3912,3913,3635],[3635,3634,3912],[3912,3634,3631],[3631,3901,3912],[3916,3915,3914],[3914,3917,3916],[3916,3917,3339],[3339,3338,3916],[3916,3338,3337],[3337,3918,3916],[3916,3918,3919],[3919,3915,3916],[3921,3920,3914],[3914,3915,3921],[3921,3915,3919],[3919,3922,3921],[3921,3922,3923],[3923,3924,3921],[3921,3924,3925],[3925,3920,3921],[3927,3926,3914],[3914,3920,3927],[3927,3920,3925],[3925,3928,3927],[3927,3928,3653],[3653,3652,3927],[3927,3652,3649],[3649,3926,3927],[3929,3917,3914],[3914,3926,3929],[3929,3926,3649],[3649,3648,3929],[3929,3648,2963],[2963,3341,3929],[3929,3341,3339],[3339,3917,3929],[3932,3931,3930],[3930,3933,3932],[3932,3933,3663],[3663,3662,3932],[3932,3662,2981],[2981,3356,3932],[3932,3356,3353],[3353,3931,3932],[3935,3934,3930],[3930,3931,3935],[3935,3931,3353],[3353,3352,3935],[3935,3352,3351],[3351,3936,3935],[3935,3936,3937],[3937,3934,3935],[3939,3938,3930],[3930,3934,3939],[3939,3934,3937],[3937,3940,3939],[3939,3940,3941],[3941,3942,3939],[3943,3938,3939],[3939,3942,3943],[3944,3933,3930],[3930,3938,3944],[3944,3938,3943],[3943,3945,3944],[3944,3945,3667],[3667,3666,3944],[3944,3666,3663],[3663,3933,3944],[3948,3947,3946],[3946,3949,3948],[3948,3949,3371],[3371,3370,3948],[3948,3370,3369],[3369,3950,3948],[3948,3950,3951],[3951,3947,3948],[3953,3952,3946],[3946,3947,3953],[3953,3947,3951],[3951,3954,3953],[3953,3954,3955],[3955,3956,3953],[3953,3956,3957],[3957,3952,3953],[3959,3958,3946],[3946,3952,3959],[3959,3952,3957],[3957,3960,3959],[3959,3960,3685],[3685,3684,3959],[3959,3684,3681],[3681,3958,3959],[3961,3949,3946],[3946,3958,3961],[3961,3958,3681],[3681,3680,3961],[3961,3680,2995],[2995,3373,3961],[3961,3373,3371],[3371,3949,3961],[3964,3963,3962],[3962,3965,3964],[3964,3965,3385],[3385,3384,3964],[3964,3384,3013],[3013,3459,3964],[3964,3459,3456],[3456,3963,3964],[3967,3966,3962],[3962,3963,3967],[3967,3963,3456],[3456,3455,3967],[3967,3455,3454],[3454,3968,3967],[3967,3968,3969],[3969,3966,3967],[3971,3970,3962],[3962,3966,3971],[3971,3966,3969],[3969,3972,3971],[3971,3972,3868],[3868,3973,3971],[3971,3973,3974],[3974,3970,3971],[3975,3965,3962],[3962,3970,3975],[3975,3970,3974],[3974,3976,3975],[3975,3976,3388],[3388,3387,3975],[3975,3387,3385],[3385,3965,3975],[3979,3978,3977],[3977,3980,3979],[3979,3980,3981],[3981,3982,3979],[3979,3982,3719],[3719,3718,3979],[3979,3718,3715],[3715,3978,3979],[3984,3983,3977],[3977,3978,3984],[3984,3978,3715],[3715,3714,3984],[3984,3714,3408],[3408,3705,3984],[3984,3705,3703],[3703,3983,3984],[3986,3985,3977],[3977,3983,3986],[3986,3983,3703],[3703,3702,3986],[3986,3702,3701],[3701,3987,3986],[3986,3987,3988],[3988,3985,3986],[3989,3980,3977],[3977,3985,3989],[3989,3985,3988],[3988,3990,3989],[3989,3990,3991],[3991,3992,3989],[3989,3992,3981],[3981,3980,3989],[3995,3994,3993],[3993,3996,3995],[3995,3996,3997],[3997,3998,3995],[3995,3998,3999],[3999,4000,3995],[3995,4000,4001],[4001,3994,3995],[4003,4002,3993],[3993,3994,4003],[4001,4004,4003],[4003,3994,4001],[4003,4004,3724],[3724,3723,4003],[4003,3723,3721],[3721,4002,4003],[4006,4005,3993],[3993,4002,4006],[4006,4002,3721],[3721,3720,4006],[4006,3720,3719],[3719,4007,4006],[4006,4007,4008],[4008,4005,4006],[4009,3996,3993],[3993,4005,4009],[4009,4005,4008],[4008,4010,4009],[4009,4010,4011],[4011,4012,4009],[4009,4012,3997],[3997,3996,4009],[4015,4014,4013],[4013,4016,4015],[4015,4016,4017],[4017,4018,4015],[4015,4018,3425],[3425,3424,4015],[4015,3424,3421],[3421,4014,4015],[4020,4019,4013],[4013,4014,4020],[4020,4014,3421],[3421,3420,4020],[4020,3420,3419],[3419,4021,4020],[4020,4021,4022],[4022,4019,4020],[4024,4023,4013],[4013,4019,4024],[4024,4019,4022],[4022,4025,4024],[4024,4025,4026],[4026,4027,4024],[4024,4027,4028],[4028,4023,4024],[4029,4016,4013],[4013,4023,4029],[4029,4023,4028],[4028,4030,4029],[4029,4030,3991],[3991,4031,4029],[4029,4031,4017],[4017,4016,4029],[4034,4033,4032],[4032,4035,4034],[4034,4035,4036],[4036,4037,4034],[4034,4037,3472],[3472,3471,4034],[4034,3471,3468],[3468,4033,4034],[4039,4038,4032],[4032,4033,4039],[4039,4033,3468],[3468,3467,4039],[4039,3467,3099],[3099,3756,4039],[4039,3756,3754],[3754,4038,4039],[4041,4040,4032],[4032,4038,4041],[4041,4038,3754],[3754,3753,4041],[4041,3753,3752],[3752,4042,4041],[4041,4042,4043],[4043,4040,4041],[4044,4035,4032],[4032,4040,4044],[4044,4040,4043],[4043,4045,4044],[4044,4045,4046],[4046,4047,4044],[4044,4047,4036],[4036,4035,4044],[4050,4049,4048],[4048,4051,4050],[4050,4051,3488],[3488,3487,4050],[4050,3487,3112],[3112,3762,4050],[4050,3762,3761],[3761,4049,4050],[4053,4052,4048],[4048,4049,4053],[4053,4049,3761],[3761,3772,4053],[4053,3772,3771],[3771,4054,4053],[4053,4054,4055],[4055,4052,4053],[4057,4056,4048],[4048,4052,4057],[4057,4052,4055],[4055,4058,4057],[4057,4058,4059],[4059,4060,4057],[4057,4060,4061],[4061,4056,4057],[4062,4051,4048],[4048,4056,4062],[4062,4056,4061],[4061,4063,4062],[4062,4063,3491],[3491,3490,4062],[4062,3490,3488],[3488,4051,4062],[4066,4065,4064],[4064,4067,4066],[4066,4067,4068],[4068,4069,4066],[4066,4069,4070],[4070,4071,4066],[4066,4071,4072],[4072,4065,4066],[4074,4073,4064],[4064,4065,4074],[4065,4072,4074],[4075,4074,4072],[4074,4075,3803],[3803,3802,4074],[4074,3802,3800],[3800,4073,4074],[4077,4076,4064],[4064,4073,4077],[4077,4073,3800],[3800,3799,4077],[4077,3799,3130],[3130,3778,4077],[4077,3778,3777],[3777,4076,4077],[4078,4067,4064],[4064,4076,4078],[4078,4076,3777],[3777,3788,4078],[4078,3788,3787],[3787,4079,4078],[4078,4079,4068],[4068,4067,4078],[4082,4081,4080],[4080,4083,4082],[4082,4083,3810],[3810,3809,4082],[4082,3809,3499],[3499,3794,4082],[4082,3794,3793],[3793,4081,4082],[4085,4084,4080],[4080,4081,4085],[4085,4081,3793],[3793,3804,4085],[4085,3804,3803],[3803,4086,4085],[4085,4086,4087],[4087,4084,4085],[4089,4088,4080],[4080,4084,4089],[4089,4084,4087],[4087,4090,4089],[4089,4090,4091],[4091,4092,4089],[4089,4092,4093],[4093,4088,4089],[4094,4083,4080],[4080,4088,4094],[4094,4088,4093],[4093,4095,4094],[4094,4095,3814],[3814,3813,4094],[4094,3813,3810],[3810,4083,4094],[4098,4097,4096],[4096,4099,4098],[4098,4099,3826],[3826,3825,4098],[4098,3825,3520],[3520,3819,4098],[4098,3819,3816],[3816,4097,4098],[4101,4100,4096],[4096,4097,4101],[4101,4097,3816],[3816,3815,4101],[4101,3815,3814],[3814,4102,4101],[4101,4102,4103],[4103,4100,4101],[4105,4104,4096],[4096,4100,4105],[4105,4100,4103],[4103,4106,4105],[4105,4106,4107],[4107,4108,4105],[4105,4108,4109],[4109,4104,4105],[4110,4099,4096],[4096,4104,4110],[4110,4104,4109],[4109,4111,4110],[4110,4111,3830],[3830,3829,4110],[4110,3829,3826],[3826,4099,4110],[4114,4113,4112],[4112,4115,4114],[4114,4115,3538],[3538,3537,4114],[4114,3537,3536],[3536,4116,4114],[4114,4116,4117],[4117,4113,4114],[4119,4118,4112],[4112,4113,4119],[4119,4113,4117],[4117,4120,4119],[4119,4120,4121],[4121,4122,4119],[4119,4122,4123],[4123,4118,4119],[4125,4124,4112],[4112,4118,4125],[4125,4118,4123],[4123,4126,4125],[4125,4126,3850],[3850,3849,4125],[4125,3849,3846],[3846,4124,4125],[4127,4115,4112],[4112,4124,4127],[4127,4124,3846],[3846,3845,4127],[4127,3845,3221],[3221,3540,4127],[4127,3540,3538],[3538,4115,4127],[4130,4129,4128],[4128,4131,4130],[4130,4131,3552],[3552,3551,4130],[4130,3551,3227],[3227,3842,4130],[4130,3842,3841],[3841,4129,4130],[4133,4132,4128],[4128,4129,4133],[4133,4129,3841],[3841,3856,4133],[4133,3856,3855],[3855,4134,4133],[4133,4134,4135],[4135,4132,4133],[4137,4136,4128],[4128,4132,4137],[4137,4132,4135],[4135,4138,4137],[4137,4138,4139],[4139,4140,4137],[4137,4140,4141],[4141,4136,4137],[4142,4131,4128],[4128,4136,4142],[4142,4136,4141],[4141,4143,4142],[4142,4143,3555],[3555,3554,4142],[4142,3554,3552],[3552,4131,4142],[4146,4145,4144],[4144,4147,4146],[4146,4147,3738],[3738,3737,4146],[4146,3737,3568],[3568,3567,4146],[4146,3567,3564],[3564,4145,4146],[4149,4148,4144],[4144,4145,4149],[4149,4145,3564],[3564,3563,4149],[4149,3563,3246],[3246,3872,4149],[4149,3872,3870],[3870,4148,4149],[4151,4150,4144],[4144,4148,4151],[4151,4148,3870],[3870,3869,4151],[4151,3869,3868],[3868,3972,4151],[4151,3972,3969],[3969,4150,4151],[4152,4147,4144],[4144,4150,4152],[4152,4150,3969],[3969,3968,4152],[4152,3968,3454],[3454,3740,4152],[4152,3740,3738],[3738,4147,4152],[4155,4154,4153],[4153,4156,4155],[4155,4156,3593],[3593,3592,4155],[4155,3592,3425],[3425,4018,4155],[4155,4018,4017],[4017,4154,4155],[4158,4157,4153],[4153,4154,4158],[4158,4154,4017],[4017,4031,4158],[4158,4031,3991],[3991,3990,4158],[4158,3990,3988],[3988,4157,4158],[4160,4159,4153],[4153,4157,4160],[4160,4157,3988],[3988,3987,4160],[4160,3987,3701],[3701,4161,4160],[4160,4161,4162],[4162,4159,4160],[4163,4156,4153],[4153,4159,4163],[4163,4159,4162],[4162,4164,4163],[4163,4164,3596],[3596,3595,4163],[4163,3595,3593],[3593,4156,4163],[4167,4166,4165],[4165,4168,4167],[4167,4168,3768],[3768,3767,4167],[4167,3767,3305],[3305,3608,4167],[4167,3608,3605],[3605,4166,4167],[4170,4169,4165],[4165,4166,4170],[4170,4166,3605],[3605,3604,4170],[4170,3604,3555],[3555,4143,4170],[4170,4143,4141],[4141,4169,4170],[4172,4171,4165],[4165,4169,4172],[4172,4169,4141],[4141,4140,4172],[4172,4140,4139],[4139,4173,4172],[4172,4173,4174],[4174,4171,4172],[4175,4168,4165],[4165,4171,4175],[4175,4171,4174],[4174,4176,4175],[4175,4176,3771],[3771,3770,4175],[4175,3770,3768],[3768,4168,4175],[4179,4178,4177],[4177,4180,4179],[4179,4180,4001],[4001,4000,4179],[4179,4000,3999],[3999,4181,4179],[4179,4181,4182],[4182,4178,4179],[4184,4183,4177],[4177,4178,4184],[4184,4178,4182],[4182,4185,4184],[4184,4185,4186],[4186,4187,4184],[4184,4187,4188],[4188,4183,4184],[4190,4189,4177],[4177,4183,4190],[4190,4183,4188],[4188,4191,4190],[4190,4191,3893],[3893,3892,4190],[4190,3892,3889],[3889,4189,4190],[4192,4180,4177],[4177,4189,4192],[4192,4189,3889],[3889,3888,4192],[4192,3888,3724],[3724,4004,4192],[4004,4001,4192],[4180,4192,4001],[4195,4194,4193],[4193,4196,4195],[4195,4196,3895],[3895,3894,4195],[4195,3894,3893],[3893,4197,4195],[4195,4197,4198],[4198,4194,4195],[4200,4199,4193],[4193,4194,4200],[4200,4194,4198],[4198,4201,4200],[4200,4201,4202],[4202,4203,4200],[4200,4203,4204],[4204,4199,4200],[4206,4205,4193],[4193,4199,4206],[4206,4199,4204],[4204,4207,4206],[4206,4207,3909],[3909,3908,4206],[4206,3908,3905],[3905,4205,4206],[4208,4196,4193],[4193,4205,4208],[4208,4205,3905],[3905,3904,4208],[4208,3904,3619],[3619,3897,4208],[4208,3897,3895],[3895,4196,4208],[4211,4210,4209],[4209,4212,4211],[4211,4212,3919],[3919,3918,4211],[4211,3918,3337],[3337,3640,4211],[4211,3640,3637],[3637,4210,4211],[4214,4213,4209],[4209,4210,4214],[4214,4210,3637],[3637,3636,4214],[4214,3636,3635],[3635,4215,4214],[4214,4215,4216],[4216,4213,4214],[4218,4217,4209],[4209,4213,4218],[4218,4213,4216],[4216,4219,4218],[4218,4219,4220],[4220,4221,4218],[4218,4221,4222],[4222,4217,4218],[4223,4212,4209],[4209,4217,4223],[4223,4217,4222],[4222,4224,4223],[4223,4224,3923],[3923,3922,4223],[4223,3922,3919],[3919,4212,4223],[4227,4226,4225],[4225,4228,4227],[4227,4228,3655],[3655,3654,4227],[4227,3654,3653],[3653,4229,4227],[4227,4229,4230],[4230,4226,4227],[4232,4231,4225],[4225,4226,4232],[4232,4226,4230],[4230,4233,4232],[4232,4233,4234],[4234,4235,4232],[4232,4235,4236],[4236,4231,4232],[4238,4237,4225],[4225,4231,4238],[4238,4231,4236],[4236,4239,4238],[4238,4239,3941],[3941,3940,4238],[4238,3940,3937],[3937,4237,4238],[4240,4228,4225],[4225,4237,4240],[4240,4237,3937],[3937,3936,4240],[4240,3936,3351],[3351,3657,4240],[4240,3657,3655],[3655,4228,4240],[4243,4242,4241],[4241,4244,4243],[4243,4244,3951],[3951,3950,4243],[4243,3950,3369],[3369,3672,4243],[4243,3672,3669],[3669,4242,4243],[4246,4245,4241],[4241,4242,4246],[4246,4242,3669],[3669,3668,4246],[4246,3668,3667],[3667,4247,4246],[4246,4247,4248],[4248,4245,4246],[4250,4249,4241],[4241,4245,4250],[4250,4245,4248],[4248,4251,4250],[4250,4251,4252],[4252,4253,4250],[4250,4253,4254],[4254,4249,4250],[4255,4244,4241],[4241,4249,4255],[4255,4249,4254],[4254,4256,4255],[4255,4256,3955],[3955,3954,4255],[4255,3954,3951],[3951,4244,4255],[4259,4258,4257],[4257,4260,4259],[4259,4260,3687],[3687,3686,4259],[4259,3686,3685],[3685,4261,4259],[4259,4261,4262],[4262,4258,4259],[4264,4263,4257],[4257,4258,4264],[4264,4258,4262],[4262,4265,4264],[4264,4265,4266],[4266,4267,4264],[4264,4267,4268],[4268,4263,4264],[4270,4269,4257],[4257,4263,4270],[4270,4263,4268],[4268,4271,4270],[4270,4271,4026],[4026,4025,4270],[4270,4025,4022],[4022,4269,4270],[4272,4260,4257],[4257,4269,4272],[4272,4269,4022],[4022,4021,4272],[4272,4021,3419],[3419,3689,4272],[4272,3689,3687],[3687,4260,4272],[4275,4274,4273],[4273,4276,4275],[4275,4276,4162],[4162,4161,4275],[4275,4161,3701],[3701,3700,4275],[4275,3700,3697],[3697,4274,4275],[4278,4277,4273],[4273,4274,4278],[4278,4274,3697],[3697,3696,4278],[4278,3696,3388],[3388,3976,4278],[4278,3976,3974],[3974,4277,4278],[4280,4279,4273],[4273,4277,4280],[4280,4277,3974],[3974,3973,4280],[4280,3973,3868],[3868,3867,4280],[4280,3867,3864],[3864,4279,4280],[4281,4276,4273],[4273,4279,4281],[4281,4279,3864],[3864,3863,4281],[4281,3863,3596],[3596,4164,4281],[4281,4164,4162],[4162,4276,4281],[4284,4283,4282],[4282,4285,4284],[4284,4285,4008],[4008,4007,4284],[4284,4007,3719],[3719,3982,4284],[4284,3982,3981],[3981,4283,4284],[4287,4286,4282],[4282,4283,4287],[4287,4283,3981],[3981,3992,4287],[4287,3992,3991],[3991,4030,4287],[4287,4030,4028],[4028,4286,4287],[4289,4288,4282],[4282,4286,4289],[4289,4286,4028],[4028,4027,4289],[4289,4027,4026],[4026,4290,4289],[4289,4290,4291],[4291,4288,4289],[4292,4285,4282],[4282,4288,4292],[4292,4288,4291],[4291,4293,4292],[4292,4293,4011],[4011,4010,4292],[4292,4010,4008],[4008,4285,4292],[4296,4295,4294],[4294,4297,4296],[4299,4298,4296],[4296,4297,4299],[4298,3999,4296],[3998,4296,3999],[4296,3998,3997],[3997,4295,4296],[4301,4300,4294],[4294,4295,4301],[4301,4295,3997],[3997,4012,4301],[4301,4012,4011],[4011,4302,4301],[4301,4302,4303],[4303,4300,4301],[4305,4304,4294],[4294,4300,4305],[4305,4300,4303],[4303,4306,4305],[4305,4306,4307],[4307,4308,4305],[4305,4308,4309],[4309,4304,4305],[4310,4297,4294],[4294,4304,4310],[4310,4304,4309],[4309,4311,4310],[4310,4311,4312],[4312,4313,4310],[4310,4313,4299],[4299,4297,4310],[4316,4315,4314],[4314,4317,4316],[4316,4317,3784],[3784,3783,4316],[4316,3783,3472],[3472,4037,4316],[4316,4037,4036],[4036,4315,4316],[4319,4318,4314],[4314,4315,4319],[4319,4315,4036],[4036,4047,4319],[4319,4047,4046],[4046,4320,4319],[4319,4320,4321],[4321,4318,4319],[4323,4322,4314],[4314,4318,4323],[4323,4318,4321],[4321,4324,4323],[4323,4324,4325],[4325,4326,4323],[4323,4326,4327],[4327,4322,4323],[4328,4317,4314],[4314,4322,4328],[4328,4322,4327],[4327,4329,4328],[4328,4329,3787],[3787,3786,4328],[4328,3786,3784],[3784,4317,4328],[4332,4331,4330],[4330,4333,4332],[4332,4333,4334],[4334,4335,4332],[4332,4335,3752],[3752,3751,4332],[4332,3751,3748],[3748,4331,4332],[4337,4336,4330],[4330,4331,4337],[4337,4331,3748],[3748,3747,4337],[4337,3747,3491],[3491,4063,4337],[4337,4063,4061],[4061,4336,4337],[4339,4338,4330],[4330,4336,4339],[4339,4336,4061],[4061,4060,4339],[4339,4060,4059],[4059,4340,4339],[4339,4340,4341],[4341,4338,4339],[4342,4333,4330],[4330,4338,4342],[4342,4338,4341],[4341,4343,4342],[4342,4343,4344],[4344,4345,4342],[4342,4345,4334],[4334,4333,4342],[4348,4347,4346],[4346,4349,4348],[4348,4349,4350],[4350,4351,4348],[4348,4070,4069],[4070,4348,4351],[4348,4069,4068],[4068,4347,4348],[4353,4352,4346],[4346,4347,4353],[4353,4347,4068],[4068,4079,4353],[4353,4079,3787],[3787,4329,4353],[4353,4329,4327],[4327,4352,4353],[4355,4354,4346],[4346,4352,4355],[4355,4352,4327],[4327,4326,4355],[4355,4326,4325],[4325,4356,4355],[4355,4356,4357],[4357,4354,4355],[4358,4349,4346],[4346,4354,4358],[4358,4354,4357],[4357,4359,4358],[4358,4359,4360],[4360,4361,4358],[4358,4361,4350],[4350,4349,4358],[4364,4363,4362],[4362,4365,4364],[4364,4365,4072],[4072,4071,4364],[4364,4071,4070],[4070,4366,4364],[4364,4366,4367],[4367,4363,4364],[4369,4368,4362],[4362,4363,4369],[4369,4363,4367],[4367,4370,4369],[4369,4370,4371],[4371,4372,4369],[4369,4372,4373],[4373,4368,4369],[4375,4374,4362],[4362,4368,4375],[4375,4368,4373],[4373,4376,4375],[4375,4376,4091],[4091,4090,4375],[4375,4090,4087],[4087,4374,4375],[4377,4365,4362],[4362,4374,4377],[4377,4374,4087],[4087,4086,4377],[4377,4086,3803],[3803,4075,4377],[4377,4072,4365],[4072,4377,4075],[4380,4379,4378],[4378,4381,4380],[4380,4381,4093],[4093,4092,4380],[4380,4092,4091],[4091,4382,4380],[4380,4382,4383],[4383,4379,4380],[4385,4384,4378],[4378,4379,4385],[4385,4379,4383],[4383,4386,4385],[4385,4386,4387],[4387,4388,4385],[4385,4388,4389],[4389,4384,4385],[4391,4390,4378],[4378,4384,4391],[4391,4384,4389],[4389,4392,4391],[4391,4392,4107],[4107,4106,4391],[4391,4106,4103],[4103,4390,4391],[4393,4381,4378],[4378,4390,4393],[4393,4390,4103],[4103,4102,4393],[4393,4102,3814],[3814,4095,4393],[4393,4095,4093],[4093,4381,4393],[4396,4395,4394],[4394,4397,4396],[4396,4397,4117],[4117,4116,4396],[4396,4116,3536],[3536,3835,4396],[4396,3835,3832],[3832,4395,4396],[4399,4398,4394],[4394,4395,4399],[4399,4395,3832],[3832,3831,4399],[4399,3831,3830],[3830,4400,4399],[4399,4400,4401],[4401,4398,4399],[4403,4402,4394],[4394,4398,4403],[4403,4398,4401],[4401,4404,4403],[4403,4404,4405],[4405,4406,4403],[4403,4406,4407],[4407,4402,4403],[4408,4397,4394],[4394,4402,4408],[4408,4402,4407],[4407,4409,4408],[4408,4409,4121],[4121,4120,4408],[4408,4120,4117],[4117,4397,4408],[4412,4411,4410],[4410,4413,4412],[4412,4413,3852],[3852,3851,4412],[4412,3851,3850],[3850,4414,4412],[4412,4414,4415],[4415,4411,4412],[4417,4416,4410],[4410,4411,4417],[4417,4411,4415],[4415,4418,4417],[4417,4418,4419],[4419,4420,4417],[4417,4420,4421],[4421,4416,4417],[4423,4422,4410],[4410,4416,4423],[4423,4416,4421],[4421,4424,4423],[4423,4424,4425],[4425,4426,4423],[4423,4426,4427],[4427,4422,4423],[4428,4413,4410],[4410,4422,4428],[4428,4422,4427],[4427,4429,4428],[4428,4429,3855],[3855,3854,4428],[4428,3854,3852],[3852,4413,4428],[4432,4431,4430],[4430,4433,4432],[4432,4433,4182],[4182,4181,4432],[4432,4181,3999],[3999,4298,4432],[4431,4432,4299],[4298,4299,4432],[4435,4434,4430],[4430,4431,4435],[4435,4431,4299],[4299,4313,4435],[4435,4313,4312],[4312,4436,4435],[4435,4436,4437],[4437,4434,4435],[4439,4438,4430],[4430,4434,4439],[4439,4434,4437],[4437,4440,4439],[4439,4440,4441],[4441,4442,4439],[4439,4442,4443],[4443,4438,4439],[4444,4433,4430],[4430,4438,4444],[4444,4438,4443],[4443,4445,4444],[4444,4445,4186],[4186,4185,4444],[4444,4185,4182],[4182,4433,4444],[4448,4447,4446],[4446,4449,4448],[4448,4449,4198],[4198,4197,4448],[4448,4197,3893],[3893,4191,4448],[4448,4191,4188],[4188,4447,4448],[4451,4450,4446],[4446,4447,4451],[4451,4447,4188],[4188,4187,4451],[4451,4187,4186],[4186,4452,4451],[4451,4452,4453],[4453,4450,4451],[4455,4454,4446],[4446,4450,4455],[4455,4450,4453],[4453,4456,4455],[4455,4456,4457],[4457,4458,4455],[4455,4458,4459],[4459,4454,4455],[4460,4449,4446],[4446,4454,4460],[4460,4454,4459],[4459,4461,4460],[4460,4461,4202],[4202,4201,4460],[4460,4201,4198],[4198,4449,4460],[4464,4463,4462],[4462,4465,4464],[4464,4465,3911],[3911,3910,4464],[4464,3910,3909],[3909,4466,4464],[4464,4466,4467],[4467,4463,4464],[4469,4468,4462],[4462,4463,4469],[4469,4463,4467],[4467,4470,4469],[4469,4470,4471],[4471,4472,4469],[4469,4472,4473],[4473,4468,4469],[4475,4474,4462],[4462,4468,4475],[4475,4468,4473],[4473,4476,4475],[4475,4476,4220],[4220,4219,4475],[4475,4219,4216],[4216,4474,4475],[4477,4465,4462],[4462,4474,4477],[4477,4474,4216],[4216,4215,4477],[4477,4215,3635],[3635,3913,4477],[4477,3913,3911],[3911,4465,4477],[4480,4479,4478],[4478,4481,4480],[4480,4481,4230],[4230,4229,4480],[4480,4229,3653],[3653,3928,4480],[4480,3928,3925],[3925,4479,4480],[4483,4482,4478],[4478,4479,4483],[4483,4479,3925],[3925,3924,4483],[4483,3924,3923],[3923,4484,4483],[4483,4484,4485],[4485,4482,4483],[4487,4486,4478],[4478,4482,4487],[4487,4482,4485],[4485,4488,4487],[4487,4488,4489],[4489,4490,4487],[4491,4486,4487],[4487,4490,4491],[4492,4481,4478],[4478,4486,4492],[4492,4486,4491],[4491,4493,4492],[4492,4493,4234],[4234,4233,4492],[4492,4233,4230],[4230,4481,4492],[4496,4495,4494],[4494,4497,4496],[3942,4496,3943],[4497,3943,4496],[4496,3942,3941],[3941,4498,4496],[4496,4498,4499],[4499,4495,4496],[4501,4500,4494],[4494,4495,4501],[4501,4495,4499],[4499,4502,4501],[4501,4502,4503],[4503,4504,4501],[4501,4504,4505],[4505,4500,4501],[4507,4506,4494],[4494,4500,4507],[4507,4500,4505],[4505,4508,4507],[4507,4508,4252],[4252,4251,4507],[4507,4251,4248],[4248,4506,4507],[4509,4497,4494],[4494,4506,4509],[4509,4506,4248],[4248,4247,4509],[4509,4247,3667],[3667,3945,4509],[4509,3945,3943],[3943,4497,4509],[4512,4511,4510],[4510,4513,4512],[4512,4513,4262],[4262,4261,4512],[4512,4261,3685],[3685,3960,4512],[4512,3960,3957],[3957,4511,4512],[4515,4514,4510],[4510,4511,4515],[4515,4511,3957],[3957,3956,4515],[4515,3956,3955],[3955,4516,4515],[4515,4516,4517],[4517,4514,4515],[4519,4518,4510],[4510,4514,4519],[4519,4514,4517],[4517,4520,4519],[4519,4520,4521],[4521,4522,4519],[4519,4522,4523],[4523,4518,4519],[4524,4513,4510],[4510,4518,4524],[4524,4518,4523],[4523,4525,4524],[4524,4525,4266],[4266,4265,4524],[4524,4265,4262],[4262,4513,4524],[4528,4527,4526],[4526,4529,4528],[4528,4529,4530],[4530,4531,4528],[4528,4531,4307],[4307,4306,4528],[4528,4306,4303],[4303,4527,4528],[4533,4532,4526],[4526,4527,4533],[4533,4527,4303],[4303,4302,4533],[4533,4302,4011],[4011,4293,4533],[4533,4293,4291],[4291,4532,4533],[4535,4534,4526],[4526,4532,4535],[4535,4532,4291],[4291,4290,4535],[4535,4290,4026],[4026,4271,4535],[4535,4271,4268],[4268,4534,4535],[4536,4529,4526],[4526,4534,4536],[4536,4534,4268],[4268,4267,4536],[4536,4267,4266],[4266,4537,4536],[4536,4537,4530],[4530,4529,4536],[4540,4539,4538],[4538,4541,4540],[4540,4541,4542],[4542,4543,4540],[4540,4543,4544],[4544,4545,4540],[4540,4545,4546],[4546,4539,4540],[4548,4547,4538],[4538,4539,4548],[4548,4539,4546],[4546,4549,4548],[4548,4549,4312],[4312,4311,4548],[4548,4311,4309],[4309,4547,4548],[4551,4550,4538],[4538,4547,4551],[4551,4547,4309],[4309,4308,4551],[4551,4308,4307],[4307,4552,4551],[4551,4552,4553],[4553,4550,4551],[4554,4541,4538],[4538,4550,4554],[4554,4550,4553],[4553,4555,4554],[4554,4555,4556],[4556,4557,4554],[4554,4557,4542],[4542,4541,4554],[4560,4559,4558],[4558,4561,4560],[4560,4561,4043],[4043,4042,4560],[4560,4042,3752],[3752,4335,4560],[4560,4335,4334],[4334,4559,4560],[4563,4562,4558],[4558,4559,4563],[4563,4559,4334],[4334,4345,4563],[4563,4345,4344],[4344,4564,4563],[4563,4564,4565],[4565,4562,4563],[4567,4566,4558],[4558,4562,4567],[4567,4562,4565],[4565,4568,4567],[4567,4568,4569],[4569,4570,4567],[4567,4570,4571],[4571,4566,4567],[4572,4561,4558],[4558,4566,4572],[4572,4566,4571],[4571,4573,4572],[4572,4573,4046],[4046,4045,4572],[4572,4045,4043],[4043,4561,4572],[4576,4575,4574],[4574,4577,4576],[4576,4577,4578],[4578,4579,4576],[4576,4579,4059],[4059,4058,4576],[4576,4058,4055],[4055,4575,4576],[4581,4580,4574],[4574,4575,4581],[4581,4575,4055],[4055,4054,4581],[4581,4054,3771],[3771,4176,4581],[4581,4176,4174],[4174,4580,4581],[4583,4582,4574],[4574,4580,4583],[4583,4580,4174],[4174,4173,4583],[4583,4173,4139],[4139,4584,4583],[4583,4584,4585],[4585,4582,4583],[4586,4577,4574],[4574,4582,4586],[4586,4582,4585],[4585,4587,4586],[4586,4587,4588],[4588,4589,4586],[4586,4589,4578],[4578,4577,4586],[4592,4591,4590],[4590,4593,4592],[4592,4593,4367],[4367,4366,4592],[4351,4592,4070],[4366,4070,4592],[4592,4351,4350],[4350,4591,4592],[4595,4594,4590],[4590,4591,4595],[4595,4591,4350],[4350,4361,4595],[4595,4361,4360],[4360,4596,4595],[4595,4596,4597],[4597,4594,4595],[4599,4598,4590],[4590,4594,4599],[4599,4594,4597],[4597,4600,4599],[4599,4600,4601],[4601,4602,4599],[4599,4602,4603],[4603,4598,4599],[4604,4593,4590],[4590,4598,4604],[4604,4598,4603],[4603,4605,4604],[4604,4605,4371],[4371,4370,4604],[4604,4370,4367],[4367,4593,4604],[4608,4607,4606],[4606,4609,4608],[4608,4609,4610],[4610,4611,4608],[4608,4611,4612],[4612,4613,4608],[4608,4613,4614],[4614,4607,4608],[4616,4615,4606],[4606,4607,4616],[4607,4614,4616],[4617,4616,4614],[4616,4617,4360],[4360,4359,4616],[4616,4359,4357],[4357,4615,4616],[4619,4618,4606],[4606,4615,4619],[4619,4615,4357],[4357,4356,4619],[4619,4356,4325],[4325,4620,4619],[4619,4620,4621],[4621,4618,4619],[4622,4609,4606],[4606,4618,4622],[4622,4618,4621],[4621,4623,4622],[4622,4623,4624],[4624,4625,4622],[4622,4625,4610],[4610,4609,4622],[4628,4627,4626],[4626,4629,4628],[4628,4629,4383],[4383,4382,4628],[4628,4382,4091],[4091,4376,4628],[4628,4376,4373],[4373,4627,4628],[4631,4630,4626],[4626,4627,4631],[4631,4627,4373],[4373,4372,4631],[4631,4372,4371],[4371,4632,4631],[4631,4632,4633],[4633,4630,4631],[4635,4634,4626],[4626,4630,4635],[4635,4630,4633],[4633,4636,4635],[4635,4636,4637],[4637,4638,4635],[4635,4638,4639],[4639,4634,4635],[4640,4629,4626],[4626,4634,4640],[4640,4634,4639],[4639,4641,4640],[4640,4641,4387],[4387,4386,4640],[4640,4386,4383],[4383,4629,4640],[4644,4643,4642],[4642,4645,4644],[4644,4645,4109],[4109,4108,4644],[4644,4108,4107],[4107,4646,4644],[4644,4646,4647],[4647,4643,4644],[4649,4648,4642],[4642,4643,4649],[4649,4643,4647],[4647,4650,4649],[4649,4650,4651],[4651,4652,4649],[4649,4652,4653],[4653,4648,4649],[4655,4654,4642],[4642,4648,4655],[4655,4648,4653],[4653,4656,4655],[4655,4656,4405],[4405,4404,4655],[4655,4404,4401],[4401,4654,4655],[4657,4645,4642],[4642,4654,4657],[4657,4654,4401],[4401,4400,4657],[4657,4400,3830],[3830,4111,4657],[4657,4111,4109],[4109,4645,4657],[4660,4659,4658],[4658,4661,4660],[4660,4661,4415],[4415,4414,4660],[4660,4414,3850],[3850,4126,4660],[4660,4126,4123],[4123,4659,4660],[4663,4662,4658],[4658,4659,4663],[4663,4659,4123],[4123,4122,4663],[4663,4122,4121],[4121,4664,4663],[4663,4664,4665],[4665,4662,4663],[4667,4666,4658],[4658,4662,4667],[4667,4662,4665],[4665,4668,4667],[4667,4668,4669],[4669,4670,4667],[4667,4671,4666],[4671,4667,4670],[4672,4661,4658],[4658,4666,4672],[4672,4666,4671],[4671,4673,4672],[4672,4673,4419],[4419,4418,4672],[4672,4418,4415],[4415,4661,4672],[4676,4675,4674],[4674,4677,4676],[4676,4677,4585],[4585,4584,4676],[4676,4584,4139],[4139,4138,4676],[4676,4138,4135],[4135,4675,4676],[4679,4678,4674],[4674,4675,4679],[4679,4675,4135],[4135,4134,4679],[4679,4134,3855],[3855,4429,4679],[4679,4429,4427],[4427,4678,4679],[4681,4680,4674],[4674,4678,4681],[4681,4678,4427],[4427,4426,4681],[4681,4426,4425],[4425,4682,4681],[4681,4682,4683],[4683,4680,4681],[4684,4677,4674],[4674,4680,4684],[4684,4680,4683],[4683,4685,4684],[4684,4685,4588],[4588,4587,4684],[4684,4587,4585],[4585,4677,4684],[4688,4687,4686],[4686,4689,4688],[4688,4689,4546],[4546,4545,4688],[4688,4545,4544],[4544,4690,4688],[4688,4690,4691],[4691,4687,4688],[4693,4692,4686],[4686,4687,4693],[4693,4687,4691],[4691,4694,4693],[4693,4694,4695],[4695,4696,4693],[4693,4696,4697],[4697,4692,4693],[4699,4698,4686],[4686,4692,4699],[4699,4692,4697],[4697,4700,4699],[4699,4700,4441],[4441,4440,4699],[4699,4440,4437],[4437,4698,4699],[4701,4689,4686],[4686,4698,4701],[4701,4698,4437],[4437,4436,4701],[4701,4436,4312],[4312,4549,4701],[4701,4549,4546],[4546,4689,4701],[4704,4703,4702],[4702,4705,4704],[4704,4705,4443],[4443,4442,4704],[4704,4442,4441],[4441,4706,4704],[4704,4706,4707],[4707,4703,4704],[4709,4708,4702],[4702,4703,4709],[4709,4703,4707],[4707,4710,4709],[4709,4710,4711],[4711,4712,4709],[4709,4712,4713],[4713,4708,4709],[4715,4714,4702],[4702,4708,4715],[4715,4708,4713],[4713,4716,4715],[4715,4716,4457],[4457,4456,4715],[4715,4456,4453],[4453,4714,4715],[4717,4705,4702],[4702,4714,4717],[4717,4714,4453],[4453,4452,4717],[4717,4452,4186],[4186,4445,4717],[4717,4445,4443],[4443,4705,4717],[4720,4719,4718],[4718,4721,4720],[4720,4721,4467],[4467,4466,4720],[4720,4466,3909],[3909,4207,4720],[4720,4207,4204],[4204,4719,4720],[4723,4722,4718],[4718,4719,4723],[4723,4719,4204],[4204,4203,4723],[4723,4203,4202],[4202,4724,4723],[4723,4724,4725],[4725,4722,4723],[4727,4726,4718],[4718,4722,4727],[4727,4722,4725],[4725,4728,4727],[4727,4728,4729],[4729,4730,4727],[4727,4730,4731],[4731,4726,4727],[4732,4721,4718],[4718,4726,4732],[4732,4726,4731],[4731,4733,4732],[4732,4733,4471],[4471,4470,4732],[4732,4470,4467],[4467,4721,4732],[4736,4735,4734],[4734,4737,4736],[4736,4737,4222],[4222,4221,4736],[4736,4221,4220],[4220,4738,4736],[4736,4738,4739],[4739,4735,4736],[4741,4740,4734],[4734,4735,4741],[4741,4735,4739],[4739,4742,4741],[4741,4742,4743],[4743,4744,4741],[4741,4744,4745],[4745,4740,4741],[4747,4746,4734],[4734,4740,4747],[4747,4740,4745],[4745,4748,4747],[4747,4748,4489],[4489,4488,4747],[4747,4488,4485],[4485,4746,4747],[4749,4737,4734],[4734,4746,4749],[4749,4746,4485],[4485,4484,4749],[4749,4484,3923],[3923,4224,4749],[4749,4224,4222],[4222,4737,4749],[4752,4751,4750],[4750,4753,4752],[4752,4753,4499],[4499,4498,4752],[4752,4498,3941],[3941,4239,4752],[4752,4239,4236],[4236,4751,4752],[4755,4754,4750],[4750,4751,4755],[4755,4751,4236],[4236,4235,4755],[4755,4235,4234],[4234,4756,4755],[4755,4756,4757],[4757,4754,4755],[4759,4758,4750],[4750,4754,4759],[4759,4754,4757],[4757,4760,4759],[4759,4760,4761],[4761,4762,4759],[4759,4762,4763],[4763,4758,4759],[4764,4753,4750],[4750,4758,4764],[4764,4758,4763],[4763,4765,4764],[4764,4765,4503],[4503,4502,4764],[4764,4502,4499],[4499,4753,4764],[4768,4767,4766],[4766,4769,4768],[4768,4769,4254],[4254,4253,4768],[4768,4253,4252],[4252,4770,4768],[4768,4770,4771],[4771,4767,4768],[4773,4772,4766],[4766,4767,4773],[4773,4767,4771],[4771,4774,4773],[4773,4774,4775],[4775,4776,4773],[4773,4776,4777],[4777,4772,4773],[4779,4778,4766],[4766,4772,4779],[4779,4772,4777],[4777,4780,4779],[4779,4780,4521],[4521,4520,4779],[4779,4520,4517],[4517,4778,4779],[4781,4769,4766],[4766,4778,4781],[4781,4778,4517],[4517,4516,4781],[4781,4516,3955],[3955,4256,4781],[4781,4256,4254],[4254,4769,4781],[4784,4783,4782],[4782,4785,4784],[4784,4785,4553],[4553,4552,4784],[4784,4552,4307],[4307,4531,4784],[4784,4531,4530],[4530,4783,4784],[4787,4786,4782],[4782,4783,4787],[4787,4783,4530],[4530,4537,4787],[4787,4537,4266],[4266,4525,4787],[4787,4525,4523],[4523,4786,4787],[4789,4788,4782],[4782,4786,4789],[4789,4786,4523],[4523,4522,4789],[4789,4522,4521],[4521,4790,4789],[4789,4790,4791],[4791,4788,4789],[4792,4785,4782],[4782,4788,4792],[4792,4788,4791],[4791,4793,4792],[4792,4793,4556],[4556,4555,4792],[4792,4555,4553],[4553,4785,4792],[4796,4795,4794],[4794,4797,4796],[4796,4797,4798],[4798,4799,4796],[4796,4799,4544],[4544,4543,4796],[4796,4543,4542],[4542,4795,4796],[4801,4800,4794],[4794,4795,4801],[4801,4795,4542],[4542,4557,4801],[4801,4557,4556],[4556,4802,4801],[4801,4802,4803],[4803,4800,4801],[4805,4804,4794],[4794,4800,4805],[4805,4800,4803],[4803,4806,4805],[4805,4806,4807],[4807,4808,4805],[4805,4808,4809],[4809,4804,4805],[4810,4797,4794],[4794,4804,4810],[4810,4804,4809],[4809,4811,4810],[4810,4811,4812],[4812,4813,4810],[4810,4798,4797],[4798,4810,4813],[4816,4815,4814],[4814,4817,4816],[4816,4817,4621],[4621,4620,4816],[4816,4620,4325],[4325,4324,4816],[4816,4324,4321],[4321,4815,4816],[4819,4818,4814],[4814,4815,4819],[4819,4815,4321],[4321,4320,4819],[4819,4320,4046],[4046,4573,4819],[4819,4573,4571],[4571,4818,4819],[4821,4820,4814],[4814,4818,4821],[4821,4818,4571],[4571,4570,4821],[4821,4570,4569],[4569,4822,4821],[4821,4822,4823],[4823,4820,4821],[4824,4817,4814],[4814,4820,4824],[4824,4820,4823],[4823,4825,4824],[4824,4825,4624],[4624,4623,4824],[4824,4623,4621],[4621,4817,4824],[4828,4827,4826],[4826,4829,4828],[4828,4829,4341],[4341,4340,4828],[4828,4340,4059],[4059,4579,4828],[4828,4579,4578],[4578,4827,4828],[4831,4830,4826],[4826,4827,4831],[4831,4827,4578],[4578,4589,4831],[4831,4589,4588],[4588,4832,4831],[4831,4832,4833],[4833,4830,4831],[4835,4834,4826],[4826,4830,4835],[4835,4830,4833],[4833,4836,4835],[4835,4836,4837],[4837,4838,4835],[4835,4838,4839],[4839,4834,4835],[4840,4829,4826],[4826,4834,4840],[4840,4834,4839],[4839,4841,4840],[4840,4841,4344],[4344,4343,4840],[4840,4343,4341],[4341,4829,4840],[4844,4843,4842],[4842,4845,4844],[4844,4845,4614],[4614,4613,4844],[4844,4613,4612],[4612,4846,4844],[4844,4846,4847],[4847,4843,4844],[4849,4848,4842],[4842,4843,4849],[4849,4843,4847],[4847,4850,4849],[4849,4850,4851],[4851,4852,4849],[4849,4852,4853],[4853,4848,4849],[4855,4854,4842],[4842,4848,4855],[4855,4848,4853],[4853,4856,4855],[4855,4856,4601],[4601,4600,4855],[4855,4600,4597],[4597,4854,4855],[4857,4845,4842],[4842,4854,4857],[4857,4854,4597],[4597,4596,4857],[4857,4596,4360],[4360,4617,4857],[4857,4617,4614],[4614,4845,4857],[4860,4859,4858],[4858,4861,4860],[4860,4861,4603],[4603,4602,4860],[4860,4602,4601],[4601,4862,4860],[4860,4862,4863],[4863,4859,4860],[4865,4864,4858],[4858,4859,4865],[4865,4859,4863],[4863,4866,4865],[4865,4866,4867],[4867,4868,4865],[4865,4868,4869],[4869,4864,4865],[4871,4870,4858],[4858,4864,4871],[4871,4864,4869],[4869,4872,4871],[4871,4872,4637],[4637,4636,4871],[4871,4636,4633],[4633,4870,4871],[4873,4861,4858],[4858,4870,4873],[4873,4870,4633],[4633,4632,4873],[4873,4632,4371],[4371,4605,4873],[4873,4605,4603],[4603,4861,4873],[4876,4875,4874],[4874,4877,4876],[4876,4877,4878],[4878,4879,4876],[4876,4879,4612],[4612,4611,4876],[4876,4611,4610],[4610,4875,4876],[4881,4880,4874],[4874,4875,4881],[4881,4875,4610],[4610,4625,4881],[4881,4625,4624],[4624,4882,4881],[4881,4882,4883],[4883,4880,4881],[4885,4884,4874],[4874,4880,4885],[4885,4880,4883],[4883,4886,4885],[4885,4886,4887],[4887,4888,4885],[4885,4888,4889],[4889,4884,4885],[4890,4877,4874],[4874,4884,4890],[4890,4884,4889],[4889,4891,4890],[4890,4891,4892],[4892,4893,4890],[4890,4893,4878],[4878,4877,4890],[4896,4895,4894],[4894,4897,4896],[4896,4897,4647],[4647,4646,4896],[4896,4646,4107],[4107,4392,4896],[4896,4392,4389],[4389,4895,4896],[4899,4898,4894],[4894,4895,4899],[4899,4895,4389],[4389,4388,4899],[4899,4388,4387],[4387,4900,4899],[4899,4900,4901],[4901,4898,4899],[4903,4902,4894],[4894,4898,4903],[4903,4898,4901],[4901,4904,4903],[4903,4904,4905],[4905,4906,4903],[4903,4906,4907],[4907,4902,4903],[4908,4897,4894],[4894,4902,4908],[4908,4902,4907],[4907,4909,4908],[4908,4909,4651],[4651,4650,4908],[4908,4650,4647],[4647,4897,4908],[4912,4911,4910],[4910,4913,4912],[4912,4913,4407],[4407,4406,4912],[4912,4406,4405],[4405,4914,4912],[4912,4914,4915],[4915,4911,4912],[4917,4916,4910],[4910,4911,4917],[4917,4911,4915],[4915,4918,4917],[4917,4920,4919],[4920,4917,4918],[4917,4919,4921],[4921,4916,4917],[4923,4922,4910],[4910,4916,4923],[4923,4916,4921],[4921,4924,4923],[4923,4924,4669],[4669,4668,4923],[4923,4668,4665],[4665,4922,4923],[4925,4913,4910],[4910,4922,4925],[4925,4922,4665],[4665,4664,4925],[4925,4664,4121],[4121,4409,4925],[4925,4409,4407],[4407,4913,4925],[4928,4927,4926],[4926,4929,4928],[4928,4929,4930],[4930,4931,4928],[4928,4931,4425],[4425,4424,4928],[4421,4928,4424],[4928,4421,4927],[4933,4932,4926],[4926,4927,4933],[4933,4927,4421],[4421,4420,4933],[4933,4420,4419],[4419,4934,4933],[4933,4934,4935],[4935,4932,4933],[4937,4936,4926],[4926,4932,4937],[4937,4932,4935],[4935,4938,4937],[4937,4938,4939],[4939,4940,4937],[4937,4940,4941],[4941,4936,4937],[4942,4929,4926],[4926,4936,4942],[4942,4936,4941],[4941,4943,4942],[4942,4943,4944],[4944,4945,4942],[4942,4945,4930],[4930,4929,4942],[4948,4947,4946],[4946,4949,4948],[4948,4949,4691],[4691,4690,4948],[4948,4690,4544],[4544,4799,4948],[4948,4799,4798],[4798,4947,4948],[4951,4950,4946],[4946,4947,4951],[4947,4798,4951],[4813,4951,4798],[4951,4813,4812],[4812,4952,4951],[4951,4952,4953],[4953,4950,4951],[4955,4954,4946],[4946,4950,4955],[4955,4950,4953],[4953,4956,4955],[143,142,4955],[4956,143,4955],[4957,4955,147],[141,147,4955],[142,141,4955],[4955,4957,4958],[4958,4954,4955],[4959,4949,4946],[4946,4954,4959],[4959,4954,4958],[4958,4960,4959],[4959,4960,4695],[4695,4694,4959],[4959,4694,4691],[4691,4949,4959],[4963,4962,4961],[4961,4964,4963],[4963,4964,4707],[4707,4706,4963],[4963,4706,4441],[4441,4700,4963],[4963,4700,4697],[4697,4962,4963],[4966,4965,4961],[4961,4962,4966],[4966,4962,4697],[4697,4696,4966],[4966,4696,4695],[4695,4967,4966],[4966,4967,4968],[4968,4965,4966],[4970,4969,4961],[4961,4965,4970],[4970,4965,4968],[9,4968,8],[9,11,4970],[4968,9,4970],[11,12,4970],[12,13,4970],[14,4970,13],[14,16,4971],[4970,14,4971],[4971,4969,4970],[4972,4964,4961],[4961,4969,4972],[4972,4969,4971],[4971,4973,4972],[4972,4973,4711],[4711,4710,4972],[4972,4710,4707],[4707,4964,4972],[4976,4975,4974],[4974,4977,4976],[4976,4977,4459],[4459,4458,4976],[4976,4458,4457],[4457,4978,4976],[4976,4978,4979],[4979,4975,4976],[4981,4980,4974],[4974,4975,4981],[4981,4975,4979],[4979,4982,4981],[4981,4982,4983],[4983,4984,4981],[4981,4984,4985],[4985,4980,4981],[4987,4986,4974],[4974,4980,4987],[4987,4980,4985],[4985,4988,4987],[4987,4988,4729],[4729,4728,4987],[4987,4728,4725],[4725,4986,4987],[4989,4977,4974],[4974,4986,4989],[4989,4986,4725],[4725,4724,4989],[4989,4724,4202],[4202,4461,4989],[4989,4461,4459],[4459,4977,4989],[4992,4991,4990],[4990,4993,4992],[4992,4993,4739],[4739,4738,4992],[4992,4738,4220],[4220,4476,4992],[4992,4476,4473],[4473,4991,4992],[4995,4994,4990],[4990,4991,4995],[4995,4991,4473],[4473,4472,4995],[4995,4472,4471],[4471,4996,4995],[4995,4996,4997],[4997,4994,4995],[4999,4998,4990],[4990,4994,4999],[4999,4994,4997],[4997,5000,4999],[4999,5000,5001],[5001,5002,4999],[4999,5002,5003],[5003,4998,4999],[5004,4993,4990],[4990,4998,5004],[5004,4998,5003],[5003,5005,5004],[5004,5005,4743],[4743,4742,5004],[5004,4742,4739],[4739,4993,5004],[5008,5007,5006],[5006,5009,5008],[5009,4491,5008],[4490,5008,4491],[5008,4490,4489],[4489,5010,5008],[5008,5010,5011],[5011,5007,5008],[5013,5012,5006],[5006,5007,5013],[5013,5007,5011],[5011,5014,5013],[5013,5014,5015],[5015,5016,5013],[5013,5016,5017],[5017,5012,5013],[5019,5018,5006],[5006,5012,5019],[5019,5012,5017],[5017,5020,5019],[5019,5020,4761],[4761,4760,5019],[5019,4760,4757],[4757,5018,5019],[5021,5009,5006],[5006,5018,5021],[5021,5018,4757],[4757,4756,5021],[5021,4756,4234],[4234,4493,5021],[5021,4493,4491],[4491,5009,5021],[5024,5023,5022],[5022,5025,5024],[5024,5025,4771],[4771,4770,5024],[5024,4770,4252],[4252,4508,5024],[5024,4508,4505],[4505,5023,5024],[5027,5026,5022],[5022,5023,5027],[5027,5023,4505],[4505,4504,5027],[5027,4504,4503],[4503,5028,5027],[5027,5028,5029],[5029,5026,5027],[5031,5030,5022],[5022,5026,5031],[5031,5026,5029],[5029,5032,5031],[5031,5032,5033],[5033,5034,5031],[5031,5034,5035],[5035,5030,5031],[5036,5025,5022],[5022,5030,5036],[5036,5030,5035],[5035,5037,5036],[5036,5037,4775],[4775,4774,5036],[5036,4774,4771],[4771,5025,5036],[5040,5039,5038],[5038,5041,5040],[5040,5041,5042],[5042,5043,5040],[5040,5043,4807],[4807,4806,5040],[5040,4806,4803],[4803,5039,5040],[5045,5044,5038],[5038,5039,5045],[5045,5039,4803],[4803,4802,5045],[5045,4802,4556],[4556,4793,5045],[5045,4793,4791],[4791,5044,5045],[5047,5046,5038],[5038,5044,5047],[5047,5044,4791],[4791,4790,5047],[5047,4790,4521],[4521,4780,5047],[5047,4780,4777],[4777,5046,5047],[5048,5041,5038],[5038,5046,5048],[5048,5046,4777],[4777,4776,5048],[5048,4776,4775],[4775,5049,5048],[5048,5049,5042],[5042,5041,5048],[5052,5051,5050],[5050,5053,5052],[5052,5053,5054],[5054,5055,5052],[5057,5052,5056],[5055,5056,5052],[5052,5057,5058],[5058,5051,5052],[5060,5059,5050],[5050,5051,5060],[5060,5051,5058],[5058,5061,5060],[5060,5061,4812],[4812,4811,5060],[5060,4811,4809],[4809,5059,5060],[5063,5062,5050],[5050,5059,5063],[5063,5059,4809],[4809,4808,5063],[5063,4808,4807],[4807,5064,5063],[5063,5064,5065],[5065,5062,5063],[5066,5053,5050],[5050,5062,5066],[5066,5062,5065],[5065,5067,5066],[5066,5067,5068],[5068,5069,5066],[5066,5069,5054],[5054,5053,5066],[5072,5071,5070],[5070,5073,5072],[5072,5073,5074],[5074,5075,5072],[5072,5075,4569],[4569,4568,5072],[5072,4568,4565],[4565,5071,5072],[5077,5076,5070],[5070,5071,5077],[5077,5071,4565],[4565,4564,5077],[5077,4564,4344],[4344,4841,5077],[5077,4841,4839],[4839,5076,5077],[5079,5078,5070],[5070,5076,5079],[5079,5076,4839],[4839,4838,5079],[5079,4838,4837],[4837,5080,5079],[5079,5080,5081],[5081,5078,5079],[5082,5073,5070],[5070,5078,5082],[5082,5078,5081],[5081,5083,5082],[5082,5083,5084],[5084,5085,5082],[5082,5085,5074],[5074,5073,5082],[5088,5087,5086],[5086,5089,5088],[5088,5089,4847],[4847,4846,5088],[5088,4846,4612],[4612,4879,5088],[5088,4879,4878],[4878,5087,5088],[5091,5090,5086],[5086,5087,5091],[5091,5087,4878],[4878,4893,5091],[5091,4893,4892],[4892,5092,5091],[5091,5092,5093],[5093,5090,5091],[5095,5094,5086],[5086,5090,5095],[5095,5090,5093],[5093,5096,5095],[5095,5096,5097],[5097,5098,5095],[5095,5098,5099],[5099,5094,5095],[5100,5089,5086],[5086,5094,5100],[5100,5094,5099],[5099,5101,5100],[5100,5101,4851],[4851,4850,5100],[5100,4850,4847],[4847,5089,5100],[5104,5103,5102],[5102,5105,5104],[5104,5105,4863],[4863,4862,5104],[5104,4862,4601],[4601,4856,5104],[5104,4856,4853],[4853,5103,5104],[5107,5106,5102],[5102,5103,5107],[5107,5103,4853],[4853,4852,5107],[5107,4852,4851],[4851,5108,5107],[5107,5108,5109],[5109,5106,5107],[5111,5110,5102],[5102,5106,5111],[5111,5106,5109],[5109,5112,5111],[5111,5112,5113],[5113,5114,5111],[5111,5114,5115],[5115,5110,5111],[5116,5105,5102],[5102,5110,5116],[5116,5110,5115],[5115,5117,5116],[5116,5117,4867],[4867,4866,5116],[5116,4866,4863],[4863,5105,5116],[5120,5119,5118],[5118,5121,5120],[5120,5121,5122],[5122,5123,5120],[5120,5123,4887],[4887,4886,5120],[5120,4886,4883],[4883,5119,5120],[5125,5124,5118],[5118,5119,5125],[5125,5119,4883],[4883,4882,5125],[5125,4882,4624],[4624,4825,5125],[5125,4825,4823],[4823,5124,5125],[5127,5126,5118],[5118,5124,5127],[5127,5124,4823],[4823,4822,5127],[5127,4822,4569],[4569,5075,5127],[5127,5075,5074],[5074,5126,5127],[5128,5121,5118],[5118,5126,5128],[5128,5126,5074],[5074,5085,5128],[5128,5085,5084],[5084,5129,5128],[5128,5129,5122],[5122,5121,5128],[5132,5131,5130],[5130,5133,5132],[5132,5133,5134],[5134,5135,5132],[5132,5135,5136],[5136,5137,5132],[5131,5132,5138],[5137,5138,5132],[5140,5139,5130],[5130,5131,5140],[5140,5131,5138],[5138,5141,5140],[5140,5141,4892],[4892,4891,5140],[5140,4891,4889],[4889,5139,5140],[5143,5142,5130],[5130,5139,5143],[5143,5139,4889],[4889,4888,5143],[5143,4888,4887],[4887,5144,5143],[5143,5144,5145],[5145,5142,5143],[5146,5133,5130],[5130,5142,5146],[5146,5142,5145],[5145,5147,5146],[5146,5147,5148],[5148,5149,5146],[5146,5149,5134],[5134,5133,5146],[5152,5151,5150],[5150,5153,5152],[5152,5153,4639],[4639,4638,5152],[5152,4638,4637],[4637,5154,5152],[5152,5154,5155],[5155,5151,5152],[5157,5156,5150],[5150,5151,5157],[5157,5151,5155],[5155,5158,5157],[5157,5158,5159],[5159,5160,5157],[5157,5160,5161],[5161,5156,5157],[5163,5162,5150],[5150,5156,5163],[5163,5156,5161],[5161,5164,5163],[5163,5164,4905],[4905,4904,5163],[5163,4904,4901],[4901,5162,5163],[5165,5153,5150],[5150,5162,5165],[5165,5162,4901],[4901,4900,5165],[5165,4900,4387],[4387,4641,5165],[5165,4641,4639],[4639,5153,5165],[5168,5167,5166],[5166,5169,5168],[5168,5169,4915],[4915,4914,5168],[5168,4914,4405],[4405,4656,5168],[5168,4656,4653],[4653,5167,5168],[5171,5170,5166],[5166,5167,5171],[5171,5167,4653],[4653,4652,5171],[5171,4652,4651],[4651,5172,5171],[5171,5172,5173],[5173,5170,5171],[5175,5174,5166],[5166,5170,5175],[5175,5170,5173],[5173,5176,5175],[5175,5176,5177],[5177,5178,5175],[5175,5178,5179],[5179,5174,5175],[5180,5169,5166],[5166,5174,5180],[5180,5174,5179],[5179,5181,5180],[5180,5181,4920],[4920,4918,5180],[5180,4918,4915],[4915,5169,5180],[5184,5183,5182],[5182,5185,5184],[4671,4670,5184],[5184,5185,4671],[5184,4670,4669],[4669,5186,5184],[5184,5186,5187],[5187,5183,5184],[5189,5188,5182],[5182,5183,5189],[5189,5183,5187],[5187,5190,5189],[5189,5190,5191],[5191,5192,5189],[5189,5192,5193],[5193,5188,5189],[5195,5194,5182],[5182,5188,5195],[5195,5188,5193],[5193,5196,5195],[5195,5196,4939],[4939,4938,5195],[5195,4938,4935],[4935,5194,5195],[5197,5185,5182],[5182,5194,5197],[5197,5194,4935],[4935,4934,5197],[5197,4934,4419],[4419,4673,5197],[5197,4673,4671],[4671,5185,5197],[5200,5199,5198],[5198,5201,5200],[4683,4682,5200],[5200,5201,4683],[5200,4682,4425],[4425,4931,5200],[5200,4931,4930],[4930,5199,5200],[5203,5202,5198],[5198,5199,5203],[5203,5199,4930],[4930,4945,5203],[5203,4945,4944],[4944,5204,5203],[5203,5204,5205],[5205,5202,5203],[5207,5206,5198],[5198,5202,5207],[5207,5202,5205],[5205,5208,5207],[5207,5208,4837],[4837,4836,5207],[5207,4836,4833],[4833,5206,5207],[5209,5201,5198],[5198,5206,5209],[5209,5206,4833],[4833,4832,5209],[5209,4832,4588],[4588,4685,5209],[5209,4685,4683],[4683,5201,5209],[5212,5211,5210],[5210,5213,5212],[5212,5213,5058],[5058,5057,5212],[5212,5057,5056],[5056,5214,5212],[5212,5214,5215],[5215,5211,5212],[5216,5210,131],[131,5210,127],[127,5210,126],[5211,126,5210],[126,5211,125],[125,5215,130],[5215,125,5211],[130,5215,129],[129,5215,158],[158,5215,157],[132,5216,131],[5218,5217,5210],[5210,5216,5218],[5216,134,5218],[134,138,5218],[134,5216,132],[138,135,5218],[135,136,139],[5218,135,139],[5218,139,144],[143,4956,144],[5218,144,4956],[5218,4956,4953],[4953,5217,5218],[5219,5213,5210],[5210,5217,5219],[5219,5217,4953],[4953,4952,5219],[5219,4952,4812],[4812,5061,5219],[5219,5061,5058],[5058,5213,5219],[113,4958,116],[145,116,4958],[146,145,4958],[4957,146,4958],[146,4957,147],[123,8,4968],[124,123,4968],[119,117,5220],[122,5220,118],[117,118,5220],[121,124,4968],[122,121,4968],[5220,122,4968],[4968,4967,5220],[5220,4967,4695],[4695,4960,5220],[5220,4960,4958],[114,119,5220],[113,114,5220],[4958,113,5220],[5223,5222,5221],[5221,5224,5223],[5223,5224,4979],[4979,4978,5223],[5223,4978,4457],[4457,4716,5223],[5223,4716,4713],[4713,5222,5223],[5226,5225,5221],[5221,5222,5226],[5226,5222,4713],[4713,4712,5226],[5226,4712,4711],[4711,5227,5226],[5226,5227,5228],[5228,5225,5226],[5230,5229,5221],[5221,5225,5230],[5230,5225,5228],[5228,5231,5230],[5230,5231,5232],[5232,5233,5230],[5230,5233,5234],[5234,5229,5230],[5235,5224,5221],[5221,5229,5235],[5235,5229,5234],[5234,5236,5235],[5235,5236,4983],[4983,4982,5235],[5235,4982,4979],[4979,5224,5235],[5239,5238,5237],[5237,5240,5239],[5239,5240,4731],[4731,4730,5239],[5239,4730,4729],[4729,5241,5239],[5239,5241,5242],[5242,5238,5239],[5244,5243,5237],[5237,5238,5244],[5244,5238,5242],[5242,5245,5244],[5244,5245,5246],[5246,5247,5244],[5244,5247,5248],[5248,5243,5244],[5250,5249,5237],[5237,5243,5250],[5248,5251,5250],[5250,5243,5248],[5250,5251,5001],[5001,5000,5250],[5250,5000,4997],[4997,5249,5250],[5252,5240,5237],[5237,5249,5252],[5252,5249,4997],[4997,4996,5252],[5252,4996,4471],[4471,4733,5252],[5252,4733,4731],[4731,5240,5252],[5255,5254,5253],[5253,5256,5255],[5255,5256,5011],[5011,5010,5255],[5255,5010,4489],[4489,4748,5255],[5255,4748,4745],[4745,5254,5255],[5258,5257,5253],[5253,5254,5258],[5258,5254,4745],[4745,4744,5258],[5258,4744,4743],[4743,5259,5258],[5258,5259,5260],[5260,5257,5258],[5262,5261,5253],[5253,5257,5262],[5262,5257,5260],[5260,5263,5262],[5262,5263,5264],[5264,5265,5262],[5262,5265,5266],[5266,5261,5262],[5267,5256,5253],[5253,5261,5267],[5267,5261,5266],[5266,5268,5267],[5267,5268,5015],[5015,5014,5267],[5267,5014,5011],[5011,5256,5267],[5271,5270,5269],[5269,5272,5271],[5271,5272,4763],[4763,4762,5271],[5271,4762,4761],[4761,5273,5271],[5271,5273,5274],[5274,5270,5271],[5276,5275,5269],[5269,5270,5276],[5276,5270,5274],[5274,5277,5276],[5276,5277,5278],[5278,5279,5276],[5276,5279,5280],[5280,5275,5276],[5282,5281,5269],[5269,5275,5282],[5282,5275,5280],[5280,5283,5282],[5282,5283,5033],[5033,5032,5282],[5282,5032,5029],[5029,5281,5282],[5284,5272,5269],[5269,5281,5284],[5284,5281,5029],[5029,5028,5284],[5284,5028,4503],[4503,4765,5284],[5284,4765,4763],[4763,5272,5284],[5287,5286,5285],[5285,5288,5287],[5287,5288,5065],[5065,5064,5287],[5287,5064,4807],[4807,5043,5287],[5287,5043,5042],[5042,5286,5287],[5290,5289,5285],[5285,5286,5290],[5290,5286,5042],[5042,5049,5290],[5290,5049,4775],[4775,5037,5290],[5290,5037,5035],[5035,5289,5290],[5292,5291,5285],[5285,5289,5292],[5292,5289,5035],[5035,5034,5292],[5292,5034,5033],[5033,5293,5292],[5292,5293,5294],[5294,5291,5292],[5295,5288,5285],[5285,5291,5295],[5295,5291,5294],[5294,5296,5295],[5295,5296,5068],[5068,5067,5295],[5295,5067,5065],[5065,5288,5295],[5299,5298,5297],[5297,5300,5299],[5299,5300,5301],[5301,5302,5299],[5299,5302,5056],[5056,5055,5299],[5299,5055,5054],[5054,5298,5299],[5304,5303,5297],[5297,5298,5304],[5304,5298,5054],[5054,5069,5304],[5304,5069,5068],[5068,5305,5304],[5304,5305,5306],[5306,5303,5304],[5308,5307,5297],[5297,5303,5308],[5308,5303,5306],[5306,5309,5308],[5308,5309,5310],[5310,5311,5308],[5308,5311,5312],[5312,5307,5308],[5313,5300,5297],[5297,5307,5313],[5313,5307,5312],[5312,5314,5313],[5313,5314,5315],[5315,5316,5313],[5313,5301,5300],[5301,5313,5316],[5319,5318,5317],[5317,5320,5319],[5138,5137,5319],[5319,5320,5138],[5321,5319,5136],[5137,5136,5319],[5319,5321,5322],[5322,5318,5319],[5324,5323,5317],[5317,5318,5324],[5324,5318,5322],[5322,5325,5324],[5324,5325,5326],[5326,5327,5324],[5324,5327,5328],[5328,5323,5324],[5330,5329,5317],[5317,5323,5330],[5330,5323,5328],[5328,5331,5330],[5330,5331,5097],[5097,5096,5330],[5330,5096,5093],[5093,5329,5330],[5332,5320,5317],[5317,5329,5332],[5332,5329,5093],[5093,5092,5332],[5332,5092,4892],[4892,5141,5332],[5332,5141,5138],[5138,5320,5332],[5335,5334,5333],[5333,5336,5335],[5335,5336,5099],[5099,5098,5335],[5335,5098,5097],[5097,5337,5335],[5335,5337,5338],[5338,5334,5335],[5340,5339,5333],[5333,5334,5340],[5340,5334,5338],[5338,5341,5340],[5340,5341,5342],[5342,5343,5340],[5340,5343,5344],[5344,5339,5340],[5346,5345,5333],[5333,5339,5346],[5346,5339,5344],[5344,5347,5346],[5346,5347,5113],[5113,5112,5346],[5346,5112,5109],[5109,5345,5346],[5348,5336,5333],[5333,5345,5348],[5348,5345,5109],[5109,5108,5348],[5348,5108,4851],[4851,5101,5348],[5348,5101,5099],[5099,5336,5348],[5351,5350,5349],[5349,5352,5351],[5351,5352,5155],[5155,5154,5351],[5351,5154,4637],[4637,4872,5351],[5351,4872,4869],[4869,5350,5351],[5354,5353,5349],[5349,5350,5354],[5354,5350,4869],[4869,4868,5354],[5354,4868,4867],[4867,5355,5354],[5354,5355,5356],[5356,5353,5354],[5358,5357,5349],[5349,5353,5358],[5358,5353,5356],[5356,5359,5358],[5358,5359,5360],[5360,5361,5358],[5358,5361,5362],[5362,5357,5358],[5363,5352,5349],[5349,5357,5363],[5363,5357,5362],[5362,5364,5363],[5363,5364,5159],[5159,5158,5363],[5363,5158,5155],[5155,5352,5363],[5367,5366,5365],[5365,5368,5367],[5367,5368,5145],[5145,5144,5367],[5367,5144,4887],[4887,5123,5367],[5367,5123,5122],[5122,5366,5367],[5370,5369,5365],[5365,5366,5370],[5370,5366,5122],[5122,5129,5370],[5370,5129,5084],[5084,5371,5370],[5370,5371,5372],[5372,5369,5370],[5374,5373,5365],[5365,5369,5374],[5374,5369,5372],[5372,5375,5374],[5374,5375,5376],[5376,5377,5374],[5374,5377,5378],[5378,5373,5374],[5379,5368,5365],[5365,5373,5379],[5379,5373,5378],[5378,5380,5379],[5379,5380,5148],[5148,5147,5379],[5379,5147,5145],[5145,5368,5379],[5383,5382,5381],[5381,5384,5383],[5383,5384,5385],[5385,5386,5383],[5383,5386,5136],[5136,5135,5383],[5383,5135,5134],[5134,5382,5383],[5388,5387,5381],[5381,5382,5388],[5388,5382,5134],[5134,5149,5388],[5388,5149,5148],[5148,5389,5388],[5388,5389,5390],[5390,5387,5388],[5392,5391,5381],[5381,5387,5392],[5392,5387,5390],[5390,5393,5392],[5392,5393,5394],[5394,5395,5392],[5392,5395,5396],[5396,5391,5392],[5397,5384,5381],[5381,5391,5397],[5397,5391,5396],[5396,5398,5397],[5397,5398,5399],[5399,5400,5397],[5397,5400,5385],[5385,5384,5397],[5403,5402,5401],[5401,5404,5403],[5403,5404,4907],[4907,4906,5403],[5403,4906,4905],[4905,5405,5403],[5403,5405,5406],[5406,5402,5403],[5408,5407,5401],[5401,5402,5408],[5408,5402,5406],[5406,5409,5408],[5408,5409,5410],[5410,5411,5408],[5408,5411,5412],[5412,5407,5408],[5414,5413,5401],[5401,5407,5414],[5414,5407,5412],[5412,5415,5414],[5414,5415,5177],[5177,5176,5414],[5414,5176,5173],[5173,5413,5414],[5416,5404,5401],[5401,5413,5416],[5416,5413,5173],[5173,5172,5416],[5416,5172,4651],[4651,4909,5416],[5416,4909,4907],[4907,5404,5416],[5419,5418,5417],[5417,5420,5419],[5419,5420,5187],[5187,5186,5419],[5419,5186,4669],[4669,4924,5419],[5419,4924,4921],[4921,5418,5419],[5422,5421,5417],[5417,5418,5422],[5422,5418,4921],[4921,4919,5422],[5423,5422,4920],[4919,4920,5422],[5422,5423,5424],[5424,5421,5422],[5426,5425,5417],[5417,5421,5426],[5426,5421,5424],[5424,5427,5426],[5426,5427,5428],[5428,5429,5426],[5426,5429,5430],[5430,5425,5426],[5431,5420,5417],[5417,5425,5431],[5431,5425,5430],[5430,5432,5431],[5431,5432,5191],[5191,5190,5431],[5431,5190,5187],[5187,5420,5431],[5435,5434,5433],[5433,5436,5435],[5435,5436,4941],[4941,4940,5435],[5435,4940,4939],[4939,5437,5435],[5435,5437,5438],[5438,5434,5435],[5440,5439,5433],[5433,5434,5440],[5440,5434,5438],[5438,5441,5440],[5440,5441,5442],[5442,5443,5440],[5440,5443,5444],[5444,5439,5440],[5446,5445,5433],[5433,5439,5446],[5446,5439,5444],[5444,5447,5446],[5446,5447,5376],[5376,5448,5446],[5446,5448,5449],[5449,5445,5446],[5450,5436,5433],[5433,5445,5450],[5450,5445,5449],[5449,5451,5450],[5450,5451,4944],[4944,4943,5450],[5450,4943,4941],[4941,5436,5450],[5453,149,5452],[149,5453,148],[5454,5452,150],[150,5452,149],[5452,5454,5215],[5215,5214,5452],[5452,5214,5056],[5056,5302,5452],[5452,5302,5301],[5301,5453,5452],[311,5455,310],[311,314,5455],[5455,314,5453],[314,152,5453],[152,148,5453],[5316,5455,5301],[5453,5301,5455],[5455,5316,5315],[5315,5456,5455],[5456,316,5455],[316,5456,317],[313,5455,316],[313,310,5455],[156,5454,153],[153,5454,150],[159,157,5215],[5454,154,5215],[154,159,5215],[154,5454,156],[5457,19,20],[18,19,4971],[19,5457,4971],[4971,17,18],[16,17,4971],[23,5458,22],[5458,23,5459],[24,5459,23],[25,5459,24],[5459,26,5460],[26,5459,25],[5459,5460,5232],[5232,5231,5459],[5459,5231,5228],[5228,5458,5459],[20,21,5457],[21,5461,5457],[5461,22,5458],[22,5461,21],[5461,5458,5228],[5228,5227,5461],[5461,5227,4711],[4711,4973,5461],[5461,4973,4971],[4971,5457,5461],[5464,5463,5462],[5462,5465,5464],[5464,5465,5242],[5242,5241,5464],[5464,5241,4729],[4729,4988,5464],[5464,4988,4985],[4985,5463,5464],[5467,5466,5462],[5462,5463,5467],[5467,5463,4985],[4985,4984,5467],[5467,4984,4983],[4983,5468,5467],[5467,5468,5469],[5469,5466,5467],[5471,5470,5462],[5462,5466,5471],[5471,5466,5469],[5469,5472,5471],[5471,5472,5473],[5473,5474,5471],[5471,5474,5475],[5475,5470,5471],[5476,5465,5462],[5462,5470,5476],[5476,5470,5475],[5475,5477,5476],[5476,5477,5246],[5246,5245,5476],[5476,5245,5242],[5242,5465,5476],[5480,5479,5478],[5478,5481,5480],[5480,5481,5003],[5003,5002,5480],[5480,5002,5001],[5001,5482,5480],[5480,5482,5483],[5483,5479,5480],[5485,5484,5478],[5478,5479,5485],[5485,5479,5483],[5483,5486,5485],[5485,5486,5487],[5487,5488,5485],[5485,5488,5489],[5489,5484,5485],[5491,5490,5478],[5478,5484,5491],[5491,5484,5489],[5489,5492,5491],[5491,5492,5264],[5264,5263,5491],[5491,5263,5260],[5260,5490,5491],[5493,5481,5478],[5478,5490,5493],[5493,5490,5260],[5260,5259,5493],[5493,5259,4743],[4743,5005,5493],[5493,5005,5003],[5003,5481,5493],[5496,5495,5494],[5494,5497,5496],[5496,5497,5274],[5274,5273,5496],[5496,5273,4761],[4761,5020,5496],[5496,5020,5017],[5017,5495,5496],[5499,5498,5494],[5494,5495,5499],[5499,5495,5017],[5017,5016,5499],[5499,5016,5015],[5015,5500,5499],[5499,5500,5501],[5501,5498,5499],[5503,5502,5494],[5494,5498,5503],[5503,5498,5501],[5501,5504,5503],[5503,5504,5505],[5505,5506,5503],[5503,5506,5507],[5507,5502,5503],[5508,5497,5494],[5494,5502,5508],[5508,5502,5507],[5507,5509,5508],[5508,5509,5278],[5278,5277,5508],[5508,5277,5274],[5274,5497,5508],[5512,5511,5510],[5510,5513,5512],[5512,5513,5514],[5514,5515,5512],[5512,5515,5310],[5310,5309,5512],[5512,5309,5306],[5306,5511,5512],[5517,5516,5510],[5510,5511,5517],[5517,5511,5306],[5306,5305,5517],[5517,5305,5068],[5068,5296,5517],[5517,5296,5294],[5294,5516,5517],[5519,5518,5510],[5510,5516,5519],[5519,5516,5294],[5294,5293,5519],[5519,5293,5033],[5033,5283,5519],[5519,5283,5280],[5280,5518,5519],[5520,5513,5510],[5510,5518,5520],[5520,5518,5280],[5280,5279,5520],[5520,5279,5278],[5278,5521,5520],[5520,5521,5514],[5514,5513,5520],[5524,5523,5522],[5522,5525,5524],[5524,5525,5526],[5526,5527,5524],[303,304,5527],[304,5524,5527],[5524,305,5528],[305,5524,304],[5524,5528,5529],[5529,5523,5524],[5531,5530,5522],[5522,5523,5531],[5531,5523,5529],[5529,5532,5531],[5531,5532,5315],[5315,5314,5531],[5531,5314,5312],[5312,5530,5531],[5534,5533,5522],[5522,5530,5534],[5534,5530,5312],[5312,5311,5534],[5534,5311,5310],[5310,5535,5534],[5534,5535,5536],[5536,5533,5534],[5537,5525,5522],[5522,5533,5537],[5537,5533,5536],[5536,5538,5537],[5537,5538,5539],[5539,5540,5537],[5537,5540,5526],[5526,5525,5537],[5543,5542,5541],[5541,5544,5543],[5543,5544,5081],[5081,5080,5543],[5543,5080,4837],[4837,5208,5543],[5543,5208,5205],[5205,5542,5543],[5546,5545,5541],[5541,5542,5546],[5546,5542,5205],[5205,5204,5546],[5546,5204,4944],[4944,5451,5546],[5546,5451,5449],[5449,5545,5546],[5548,5547,5541],[5541,5545,5548],[5548,5545,5449],[5449,5448,5548],[5548,5448,5376],[5376,5375,5548],[5548,5375,5372],[5372,5547,5548],[5549,5544,5541],[5541,5547,5549],[5549,5547,5372],[5372,5371,5549],[5549,5371,5084],[5084,5083,5549],[5549,5083,5081],[5081,5544,5549],[5552,5551,5550],[5550,5553,5552],[5552,5553,5322],[5322,5321,5552],[5552,5321,5136],[5136,5386,5552],[5552,5386,5385],[5385,5551,5552],[5555,5554,5550],[5550,5551,5555],[5555,5551,5385],[5385,5400,5555],[5555,5400,5399],[5399,5556,5555],[5555,5556,5557],[5557,5554,5555],[5559,5558,5550],[5550,5554,5559],[5559,5554,5557],[5557,5560,5559],[5559,5560,5561],[5561,5562,5559],[5559,5562,5563],[5563,5558,5559],[5564,5553,5550],[5550,5558,5564],[5564,5558,5563],[5563,5565,5564],[5564,5565,5326],[5326,5325,5564],[5564,5325,5322],[5322,5553,5564],[5568,5567,5566],[5566,5569,5568],[5568,5569,5338],[5338,5337,5568],[5568,5337,5097],[5097,5331,5568],[5568,5331,5328],[5328,5567,5568],[5571,5570,5566],[5566,5567,5571],[5571,5567,5328],[5328,5327,5571],[5571,5327,5326],[5326,5572,5571],[5571,5572,5573],[5573,5570,5571],[5575,5574,5566],[5566,5570,5575],[5575,5570,5573],[5573,5576,5575],[5575,5576,5577],[5577,5578,5575],[5575,5578,5579],[5579,5574,5575],[5580,5569,5566],[5566,5574,5580],[5580,5574,5579],[5579,5581,5580],[5580,5581,5342],[5342,5341,5580],[5580,5341,5338],[5338,5569,5580],[5584,5583,5582],[5582,5585,5584],[5584,5585,5115],[5115,5114,5584],[5584,5114,5113],[5113,5586,5584],[5584,5586,5587],[5587,5583,5584],[5589,5588,5582],[5582,5583,5589],[5589,5583,5587],[5587,5590,5589],[5589,5590,5591],[5591,5592,5589],[5589,5592,5593],[5593,5588,5589],[5595,5594,5582],[5582,5588,5595],[5595,5588,5593],[5593,5596,5595],[5595,5596,5360],[5360,5359,5595],[5595,5359,5356],[5356,5594,5595],[5597,5585,5582],[5582,5594,5597],[5597,5594,5356],[5356,5355,5597],[5597,5355,4867],[4867,5117,5597],[5597,5117,5115],[5115,5585,5597],[5600,5599,5598],[5598,5601,5600],[5600,5601,5602],[5602,5603,5600],[5600,5603,5394],[5394,5393,5600],[5600,5393,5390],[5390,5599,5600],[5605,5604,5598],[5598,5599,5605],[5605,5599,5390],[5390,5389,5605],[5605,5389,5148],[5148,5380,5605],[5605,5380,5378],[5378,5604,5605],[5607,5606,5598],[5598,5604,5607],[5607,5604,5378],[5378,5377,5607],[5607,5377,5376],[5376,5447,5607],[5607,5447,5444],[5444,5606,5607],[5608,5601,5598],[5598,5606,5608],[5608,5606,5444],[5444,5443,5608],[5608,5443,5442],[5442,5609,5608],[5608,5609,5602],[5602,5601,5608],[5612,5611,5610],[5610,5613,5612],[5612,5613,5614],[5614,5615,5612],[5612,5615,5616],[5616,5617,5612],[5612,5617,5618],[5618,5611,5612],[5620,5619,5610],[5610,5611,5620],[5620,5611,5618],[5618,5621,5620],[5620,5621,5399],[5399,5398,5620],[5620,5398,5396],[5396,5619,5620],[5623,5622,5610],[5610,5619,5623],[5623,5619,5396],[5396,5395,5623],[5623,5395,5394],[5394,5624,5623],[5623,5624,5625],[5625,5622,5623],[5626,5613,5610],[5610,5622,5626],[5626,5622,5625],[5625,5627,5626],[5626,5627,5628],[5628,5629,5626],[5626,5629,5614],[5614,5613,5626],[5632,5631,5630],[5630,5633,5632],[5632,5633,5406],[5406,5405,5632],[5632,5405,4905],[4905,5164,5632],[5632,5164,5161],[5161,5631,5632],[5635,5634,5630],[5630,5631,5635],[5635,5631,5161],[5161,5160,5635],[5635,5160,5159],[5159,5636,5635],[5635,5636,5637],[5637,5634,5635],[5639,5638,5630],[5630,5634,5639],[5639,5634,5637],[5637,5640,5639],[5639,5640,5641],[5641,5642,5639],[5639,5642,5643],[5643,5638,5639],[5644,5633,5630],[5630,5638,5644],[5644,5638,5643],[5643,5645,5644],[5644,5645,5410],[5410,5409,5644],[5644,5409,5406],[5406,5633,5644],[5648,5647,5646],[5646,5649,5648],[5648,5649,5179],[5179,5178,5648],[5648,5178,5177],[5177,5650,5648],[5648,5650,5651],[5651,5647,5648],[5653,5652,5646],[5646,5647,5653],[5653,5647,5651],[5651,5654,5653],[5653,5654,5655],[5655,5656,5653],[5653,5656,5657],[5657,5652,5653],[5659,5658,5646],[5646,5652,5659],[5659,5652,5657],[5657,5660,5659],[5659,5660,5428],[5428,5427,5659],[5659,5427,5424],[5424,5658,5659],[5661,5649,5646],[5646,5658,5661],[5661,5658,5424],[5424,5423,5661],[5661,5423,4920],[4920,5181,5661],[5661,5181,5179],[5179,5649,5661],[5664,5663,5662],[5662,5665,5664],[5664,5665,5438],[5438,5437,5664],[5664,5437,4939],[4939,5196,5664],[5664,5196,5193],[5193,5663,5664],[5667,5666,5662],[5662,5663,5667],[5667,5663,5193],[5193,5192,5667],[5667,5192,5191],[5191,5668,5667],[5667,5668,5669],[5669,5666,5667],[5671,5670,5662],[5662,5666,5671],[5671,5666,5669],[5669,5672,5671],[5671,5672,5673],[5673,5674,5671],[5671,5674,5675],[5675,5670,5671],[5676,5665,5662],[5662,5670,5676],[5676,5670,5675],[5675,5677,5676],[5676,5677,5442],[5442,5441,5676],[5676,5441,5438],[5438,5665,5676],[290,288,5529],[5528,291,5529],[291,290,5529],[291,5528,309],[5528,308,309],[308,5528,306],[306,5528,305],[294,295,5456],[295,315,5456],[315,317,5456],[296,294,5456],[5456,5315,296],[5532,297,5315],[297,296,5315],[5529,298,5532],[298,297,5532],[288,292,5529],[292,298,5529],[5680,5679,5678],[5678,5681,5680],[5680,5681,5234],[5234,5233,5680],[5680,5233,5232],[5232,5682,5680],[5680,5682,5683],[5683,5679,5680],[5685,5684,5678],[5678,5679,5685],[5685,5679,5683],[5683,5686,5685],[5685,5686,5687],[5687,5688,5685],[5685,5688,5689],[5689,5684,5685],[5691,5690,5678],[5678,5684,5691],[5691,5684,5689],[5689,5692,5691],[5691,5692,5473],[5473,5472,5691],[5691,5472,5469],[5469,5690,5691],[5693,5681,5678],[5678,5690,5693],[5693,5690,5469],[5469,5468,5693],[5693,5468,4983],[4983,5236,5693],[5693,5236,5234],[5234,5681,5693],[5696,5695,5694],[5694,5697,5696],[5696,5697,5483],[5483,5482,5696],[5696,5482,5001],[5001,5251,5696],[5248,5696,5251],[5696,5248,5695],[5699,5698,5694],[5694,5695,5699],[5699,5695,5248],[5248,5247,5699],[5699,5247,5246],[5246,5700,5699],[5699,5700,5701],[5701,5698,5699],[5703,5702,5694],[5694,5698,5703],[5703,5698,5701],[5701,5704,5703],[5703,5704,5705],[5705,5706,5703],[5703,5706,5707],[5707,5702,5703],[5708,5697,5694],[5694,5702,5708],[5708,5702,5707],[5707,5709,5708],[5708,5709,5487],[5487,5486,5708],[5708,5486,5483],[5483,5697,5708],[5712,5711,5710],[5710,5713,5712],[5712,5713,5266],[5266,5265,5712],[5712,5265,5264],[5264,5714,5712],[5712,5714,5715],[5715,5711,5712],[5717,5716,5710],[5710,5711,5717],[5717,5711,5715],[5715,5718,5717],[5717,5718,5719],[5719,5720,5717],[5717,5720,5721],[5721,5716,5717],[5723,5722,5710],[5710,5716,5723],[5723,5716,5721],[5721,5724,5723],[5723,5724,5505],[5505,5504,5723],[5723,5504,5501],[5501,5722,5723],[5725,5713,5710],[5710,5722,5725],[5725,5722,5501],[5501,5500,5725],[5725,5500,5015],[5015,5268,5725],[5725,5268,5266],[5266,5713,5725],[5728,5727,5726],[5726,5729,5728],[5728,5729,5536],[5536,5535,5728],[5728,5535,5310],[5310,5515,5728],[5728,5515,5514],[5514,5727,5728],[5731,5730,5726],[5726,5727,5731],[5731,5727,5514],[5514,5521,5731],[5731,5521,5278],[5278,5509,5731],[5731,5509,5507],[5507,5730,5731],[5733,5732,5726],[5726,5730,5733],[5733,5730,5507],[5507,5506,5733],[5733,5506,5505],[5505,5734,5733],[5733,5734,5735],[5735,5732,5733],[5736,5729,5726],[5726,5732,5736],[5736,5732,5735],[5735,5737,5736],[5736,5737,5539],[5539,5538,5736],[5736,5538,5536],[5536,5729,5736],[5740,5739,5738],[5738,5741,5740],[285,286,5741],[286,5740,5741],[287,5740,286],[5740,287,299],[299,300,5740],[300,302,5740],[5527,302,303],[302,5527,5740],[5740,5527,5526],[5526,5739,5740],[5743,5742,5738],[5738,5739,5743],[5743,5739,5526],[5526,5540,5743],[5743,5540,5539],[5539,5744,5743],[5743,5744,5745],[5745,5742,5743],[5747,5746,5738],[5738,5742,5747],[5747,5742,5745],[5745,5748,5747],[5747,5748,5749],[5749,5750,5747],[5747,5750,5751],[5751,5746,5747],[5752,5741,5738],[5738,5746,5752],[5752,5746,5751],[275,276,5751],[276,5752,5751],[279,5752,277],[277,5752,276],[5752,279,280],[280,281,5752],[281,283,5752],[5741,284,285],[283,284,5752],[284,5741,5752],[5755,5754,5753],[5753,5756,5755],[5755,5756,5618],[5618,5617,5755],[5755,5617,5616],[5616,5757,5755],[5755,5757,5758],[5758,5754,5755],[5760,5759,5753],[5753,5754,5760],[5760,5754,5758],[5758,5761,5760],[5760,5761,5762],[5762,5763,5760],[5760,5763,5764],[5764,5759,5760],[5766,5765,5753],[5753,5759,5766],[5766,5759,5764],[5764,5767,5766],[5766,5767,5561],[5561,5560,5766],[5766,5560,5557],[5557,5765,5766],[5768,5756,5753],[5753,5765,5768],[5768,5765,5557],[5557,5556,5768],[5768,5556,5399],[5399,5621,5768],[5768,5621,5618],[5618,5756,5768],[5771,5770,5769],[5769,5772,5771],[5771,5772,5563],[5563,5562,5771],[5771,5562,5561],[5561,5773,5771],[5771,5773,5774],[5774,5770,5771],[5776,5775,5769],[5769,5770,5776],[5776,5770,5774],[5774,5777,5776],[5776,5777,5778],[5778,5779,5776],[5776,5779,5780],[5780,5775,5776],[5782,5781,5769],[5769,5775,5782],[5782,5775,5780],[5780,5783,5782],[5782,5783,5577],[5577,5576,5782],[5782,5576,5573],[5573,5781,5782],[5784,5772,5769],[5769,5781,5784],[5784,5781,5573],[5573,5572,5784],[5784,5572,5326],[5326,5565,5784],[5784,5565,5563],[5563,5772,5784],[5787,5786,5785],[5785,5788,5787],[5787,5788,5587],[5587,5586,5787],[5787,5586,5113],[5113,5347,5787],[5787,5347,5344],[5344,5786,5787],[5790,5789,5785],[5785,5786,5790],[5790,5786,5344],[5344,5343,5790],[5790,5343,5342],[5342,5791,5790],[5790,5791,5792],[5792,5789,5790],[5794,5793,5785],[5785,5789,5794],[5794,5789,5792],[5792,5795,5794],[5794,5795,5796],[5796,5797,5794],[5794,5797,5798],[5798,5793,5794],[5799,5788,5785],[5785,5793,5799],[5799,5793,5798],[5798,5800,5799],[5799,5800,5591],[5591,5590,5799],[5799,5590,5587],[5587,5788,5799],[5803,5802,5801],[5801,5804,5803],[5803,5804,5362],[5362,5361,5803],[5803,5361,5360],[5360,5805,5803],[5803,5805,5806],[5806,5802,5803],[5808,5807,5801],[5801,5802,5808],[5808,5802,5806],[5806,5809,5808],[5808,5809,5810],[5810,5811,5808],[5808,5811,5812],[5812,5807,5808],[5814,5813,5801],[5801,5807,5814],[5807,5812,5814],[5815,5814,5812],[5814,5815,5641],[5641,5640,5814],[5814,5640,5637],[5637,5813,5814],[5816,5804,5801],[5801,5813,5816],[5816,5813,5637],[5637,5636,5816],[5816,5636,5159],[5159,5364,5816],[5816,5364,5362],[5362,5804,5816],[5819,5818,5817],[5817,5820,5819],[5819,5820,5625],[5625,5624,5819],[5819,5624,5394],[5394,5603,5819],[5819,5603,5602],[5602,5818,5819],[5822,5821,5817],[5817,5818,5822],[5822,5818,5602],[5602,5609,5822],[5822,5609,5442],[5442,5677,5822],[5822,5677,5675],[5675,5821,5822],[5824,5823,5817],[5817,5821,5824],[5824,5821,5675],[5675,5674,5824],[5824,5674,5673],[5673,5825,5824],[5824,5825,5826],[5826,5823,5824],[5827,5820,5817],[5817,5823,5827],[5827,5823,5826],[5826,5828,5827],[5827,5828,5628],[5628,5627,5827],[5827,5627,5625],[5625,5820,5827],[5831,5830,5829],[5829,5832,5831],[5831,5832,5833],[5833,5834,5831],[5831,5834,5616],[5616,5615,5831],[5831,5615,5614],[5614,5830,5831],[5836,5835,5829],[5829,5830,5836],[5836,5830,5614],[5614,5629,5836],[5836,5629,5628],[5628,5837,5836],[5836,5837,5838],[5838,5835,5836],[5840,5839,5829],[5829,5835,5840],[5840,5835,5838],[5838,5841,5840],[5840,5841,5842],[5842,5843,5840],[5840,5843,5844],[5844,5839,5840],[5845,5832,5829],[5829,5839,5845],[5845,5839,5844],[5844,5846,5845],[5845,5846,5847],[5847,5848,5845],[5845,5848,5833],[5833,5832,5845],[5851,5850,5849],[5849,5852,5851],[5851,5852,5651],[5651,5650,5851],[5851,5650,5177],[5177,5415,5851],[5851,5415,5412],[5412,5850,5851],[5854,5853,5849],[5849,5850,5854],[5854,5850,5412],[5412,5411,5854],[5854,5411,5410],[5410,5855,5854],[5854,5855,5856],[5856,5853,5854],[5858,5857,5849],[5849,5853,5858],[5858,5853,5856],[5856,5859,5858],[5858,5859,5860],[5860,5861,5858],[5858,5861,5862],[5862,5857,5858],[5863,5852,5849],[5849,5857,5863],[5863,5857,5862],[5862,5864,5863],[5863,5864,5655],[5655,5654,5863],[5863,5654,5651],[5651,5852,5863],[5867,5866,5865],[5865,5868,5867],[5867,5868,5430],[5430,5429,5867],[5867,5429,5428],[5428,5869,5867],[5867,5869,5870],[5870,5866,5867],[5872,5871,5865],[5865,5866,5872],[5872,5866,5870],[5870,5873,5872],[5872,5873,5874],[5874,5875,5872],[5872,5875,5876],[5876,5871,5872],[5878,5877,5865],[5865,5871,5878],[5878,5871,5876],[5876,5879,5878],[5878,5879,5673],[5673,5672,5878],[5878,5672,5669],[5669,5877,5878],[5880,5868,5865],[5865,5877,5880],[5880,5877,5669],[5669,5668,5880],[5880,5668,5191],[5191,5432,5880],[5880,5432,5430],[5430,5868,5880],[48,49,5881],[49,50,5881],[50,51,5881],[51,5683,5881],[5683,5682,5881],[5881,5682,5232],[5232,5460,5881],[47,5460,27],[27,5460,26],[5460,47,5881],[48,5881,47],[54,55,5687],[54,5687,5686],[53,54,5686],[53,5686,5683],[52,53,5683],[51,52,5683],[5884,5883,5882],[5882,5885,5884],[5884,5885,5475],[5475,5474,5884],[5884,5474,5473],[5473,5886,5884],[5884,5886,5887],[5887,5883,5884],[5889,5888,5882],[5882,5883,5889],[5889,5883,5887],[5887,5890,5889],[5889,5890,5891],[5891,5892,5889],[5889,5892,5893],[5893,5888,5889],[5895,5894,5882],[5882,5888,5895],[5895,5888,5893],[5893,5896,5895],[5895,5896,5705],[5705,5704,5895],[5895,5704,5701],[5701,5894,5895],[5897,5885,5882],[5882,5894,5897],[5897,5894,5701],[5701,5700,5897],[5897,5700,5246],[5246,5477,5897],[5897,5477,5475],[5475,5885,5897],[5900,5899,5898],[5898,5901,5900],[5900,5901,5715],[5715,5714,5900],[5900,5714,5264],[5264,5492,5900],[5900,5492,5489],[5489,5899,5900],[5903,5902,5898],[5898,5899,5903],[5903,5899,5489],[5489,5488,5903],[5903,5488,5487],[5487,5904,5903],[5903,5904,5905],[5905,5902,5903],[5907,5906,5898],[5898,5902,5907],[5907,5902,5905],[5905,5908,5907],[5907,5908,5909],[5909,5910,5907],[5907,5910,5911],[5911,5906,5907],[5912,5901,5898],[5898,5906,5912],[5912,5906,5911],[5911,5913,5912],[5912,5913,5719],[5719,5718,5912],[5912,5718,5715],[5715,5901,5912],[5916,5915,5914],[5914,5917,5916],[5916,5917,5918],[5918,5919,5916],[5916,5919,5749],[5749,5748,5916],[5916,5748,5745],[5745,5915,5916],[5921,5920,5914],[5914,5915,5921],[5921,5915,5745],[5745,5744,5921],[5921,5744,5539],[5539,5737,5921],[5921,5737,5735],[5735,5920,5921],[5923,5922,5914],[5914,5920,5923],[5923,5920,5735],[5735,5734,5923],[5923,5734,5505],[5505,5724,5923],[5923,5724,5721],[5721,5922,5923],[5924,5917,5914],[5914,5922,5924],[5924,5922,5721],[5721,5720,5924],[5924,5720,5719],[5719,5925,5924],[5924,5925,5918],[5918,5917,5924],[195,5926,198],[199,198,5927],[198,5926,5927],[5927,226,199],[226,5927,227],[5928,201,206],[200,201,5926],[201,5928,5926],[5926,195,196],[196,200,5926],[207,5751,204],[204,5751,205],[5751,207,275],[206,205,5928],[205,5751,5928],[5930,5929,5926],[5926,5928,5930],[5930,5928,5751],[5751,5750,5930],[5930,5750,5749],[5749,5931,5930],[5930,5931,5932],[5932,5929,5930],[5933,5927,5926],[5926,5929,5933],[5933,5929,5932],[5932,5934,5933],[5933,5934,5935],[5935,5936,5933],[224,228,5936],[228,5933,5936],[5936,225,224],[227,5927,228],[5927,5933,228],[5939,5938,5937],[5937,5940,5939],[5939,5940,5758],[5758,5757,5939],[5939,5757,5616],[5616,5834,5939],[5939,5834,5833],[5833,5938,5939],[5942,5941,5937],[5937,5938,5942],[5942,5938,5833],[5833,5848,5942],[5942,5848,5847],[5847,5943,5942],[5942,5943,5944],[5944,5941,5942],[5946,5945,5937],[5937,5941,5946],[5946,5941,5944],[5944,5947,5946],[5946,5947,5948],[5948,5949,5946],[5946,5949,5950],[5950,5945,5946],[5951,5940,5937],[5937,5945,5951],[5951,5945,5950],[5950,5952,5951],[5951,5952,5762],[5762,5761,5951],[5951,5761,5758],[5758,5940,5951],[5955,5954,5953],[5953,5956,5955],[5955,5956,5774],[5774,5773,5955],[5955,5773,5561],[5561,5767,5955],[5955,5767,5764],[5764,5954,5955],[5958,5957,5953],[5953,5954,5958],[5958,5954,5764],[5764,5763,5958],[5958,5763,5762],[5762,5959,5958],[5958,5959,5960],[5960,5957,5958],[5962,5961,5953],[5953,5957,5962],[5962,5957,5960],[5960,5963,5962],[5962,5963,5964],[5964,5965,5962],[5962,5965,5966],[5966,5961,5962],[5967,5956,5953],[5953,5961,5967],[5967,5961,5966],[5966,5968,5967],[5967,5968,5778],[5778,5777,5967],[5967,5777,5774],[5774,5956,5967],[5971,5970,5969],[5969,5972,5971],[5971,5972,5579],[5579,5578,5971],[5971,5578,5577],[5577,5973,5971],[5971,5973,5974],[5974,5970,5971],[5976,5975,5969],[5969,5970,5976],[5976,5970,5974],[5974,5977,5976],[5976,5977,5978],[5978,5979,5976],[5976,5979,5980],[5980,5975,5976],[5982,5981,5969],[5969,5975,5982],[5982,5975,5980],[5980,5983,5982],[5982,5983,5796],[5796,5795,5982],[5982,5795,5792],[5792,5981,5982],[5984,5972,5969],[5969,5981,5984],[5984,5981,5792],[5792,5791,5984],[5984,5791,5342],[5342,5581,5984],[5984,5581,5579],[5579,5972,5984],[5987,5986,5985],[5985,5988,5987],[5987,5988,5806],[5806,5805,5987],[5987,5805,5360],[5360,5596,5987],[5987,5596,5593],[5593,5986,5987],[5990,5989,5985],[5985,5986,5990],[5990,5986,5593],[5593,5592,5990],[5990,5592,5591],[5591,5991,5990],[5990,5991,5992],[5992,5989,5990],[5994,5993,5985],[5985,5989,5994],[5994,5989,5992],[5992,5995,5994],[5994,5995,5996],[5996,5997,5994],[5994,5997,5998],[5998,5993,5994],[5999,5988,5985],[5985,5993,5999],[5999,5993,5998],[5998,6000,5999],[5999,6000,5810],[5810,5809,5999],[5999,5809,5806],[5806,5988,5999],[6003,6002,6001],[6001,6004,6003],[6003,6004,6005],[6005,6006,6003],[6003,6006,5842],[5842,5841,6003],[6003,5841,5838],[5838,6002,6003],[6008,6007,6001],[6001,6002,6008],[6008,6002,5838],[5838,5837,6008],[6008,5837,5628],[5628,5828,6008],[6008,5828,5826],[5826,6007,6008],[6010,6009,6001],[6001,6007,6010],[6010,6007,5826],[5826,5825,6010],[6010,5825,5673],[5673,5879,6010],[6010,5879,5876],[5876,6009,6010],[6011,6004,6001],[6001,6009,6011],[6011,6009,5876],[5876,5875,6011],[6011,5875,5874],[5874,6012,6011],[6011,6012,6005],[6005,6004,6011],[6015,6014,6013],[6013,6016,6015],[6015,6016,6017],[6017,6018,6015],[6015,6018,6019],[6019,6020,6015],[6015,6020,6021],[6021,6014,6015],[6023,6022,6013],[6013,6014,6023],[6023,6014,6021],[6021,6024,6023],[6023,6024,5847],[5847,5846,6023],[6023,5846,5844],[5844,6022,6023],[6026,6025,6013],[6013,6022,6026],[6026,6022,5844],[5844,5843,6026],[6026,5843,5842],[5842,6027,6026],[6026,6027,6028],[6028,6025,6026],[6029,6016,6013],[6013,6025,6029],[6029,6025,6028],[6028,6030,6029],[6029,6030,6031],[6031,6032,6029],[6029,6032,6017],[6017,6016,6029],[6035,6034,6033],[6033,6036,6035],[6035,6036,5643],[5643,5642,6035],[6035,5642,5641],[5641,6037,6035],[6035,6037,6038],[6038,6034,6035],[6040,6039,6033],[6033,6034,6040],[6040,6034,6038],[6038,6041,6040],[6040,6041,6042],[6042,6043,6040],[6040,6043,6044],[6044,6039,6040],[6046,6045,6033],[6033,6039,6046],[6046,6039,6044],[6044,6047,6046],[6046,6047,5860],[5860,5859,6046],[6046,5859,5856],[5856,6045,6046],[6048,6036,6033],[6033,6045,6048],[6048,6045,5856],[5856,5855,6048],[6048,5855,5410],[5410,5645,6048],[6048,5645,5643],[5643,6036,6048],[6051,6050,6049],[6049,6052,6051],[6051,6052,5870],[5870,5869,6051],[6051,5869,5428],[5428,5660,6051],[6051,5660,5657],[5657,6050,6051],[6054,6053,6049],[6049,6050,6054],[6054,6050,5657],[5657,5656,6054],[6054,5656,5655],[5655,6055,6054],[6054,6055,6056],[6056,6053,6054],[6058,6057,6049],[6049,6053,6058],[6058,6053,6056],[6056,6059,6058],[6058,6059,6060],[6060,6061,6058],[6058,6061,6062],[6062,6057,6058],[6063,6052,6049],[6049,6057,6063],[6063,6057,6062],[6062,6064,6063],[6063,6064,5874],[5874,5873,6063],[6063,5873,5870],[5870,6052,6063],[6067,6066,6065],[6065,6068,6067],[6067,6068,5887],[5887,5886,6067],[6067,5886,5473],[5473,5692,6067],[6067,5692,5689],[5689,6066,6067],[6070,6069,6065],[6065,6066,6070],[6070,6066,5689],[5689,5688,6070],[6070,5688,5687],[57,58,6070],[5687,57,6070],[58,59,6070],[59,60,6070],[6069,6070,60],[6072,6071,6065],[6065,6069,6072],[6,5,6069],[60,6,6069],[6072,6069,5],[1,2,6072],[5,1,6072],[2,3,6072],[4,30,6072],[3,4,6072],[31,6072,30],[6072,31,6073],[6073,6071,6072],[6074,6068,6065],[6065,6071,6074],[6074,6071,6073],[6073,6075,6074],[6074,6075,5891],[5891,5890,6074],[6074,5890,5887],[5887,6068,6074],[6078,6077,6076],[6076,6079,6078],[6078,6079,5707],[5707,5706,6078],[6078,5706,5705],[5705,6080,6078],[6078,6080,6081],[6081,6077,6078],[6083,6082,6076],[6076,6077,6083],[6083,6077,6081],[6081,6084,6083],[6083,6084,6085],[6085,6086,6083],[6083,6086,6087],[6087,6082,6083],[6089,6088,6076],[6076,6082,6089],[6089,6082,6087],[6087,6090,6089],[6089,6090,5909],[5909,5908,6089],[6089,5908,5905],[5905,6088,6089],[6091,6079,6076],[6076,6088,6091],[6091,6088,5905],[5905,5904,6091],[6091,5904,5487],[5487,5709,6091],[6091,5709,5707],[5707,6079,6091],[6094,6093,6092],[6092,6095,6094],[6094,6095,5932],[5932,5931,6094],[6094,5931,5749],[5749,5919,6094],[6094,5919,5918],[5918,6093,6094],[6097,6096,6092],[6092,6093,6097],[6097,6093,5918],[5918,5925,6097],[6097,5925,5719],[5719,5913,6097],[6097,5913,5911],[5911,6096,6097],[6099,6098,6092],[6092,6096,6099],[6099,6096,5911],[5911,5910,6099],[6099,5910,5909],[5909,6100,6099],[6099,6100,6101],[6101,6098,6099],[6102,6095,6092],[6092,6098,6102],[6102,6098,6101],[6101,6103,6102],[6102,6103,5935],[5935,5934,6102],[6102,5934,5932],[5932,6095,6102],[213,6104,215],[6105,213,217],[6104,213,6105],[6105,217,218],[6105,218,219],[219,223,6105],[223,222,6105],[222,225,6105],[225,5936,6105],[6105,5936,5935],[5935,6106,6105],[6105,6106,6107],[6107,6104,6105],[216,215,6104],[216,6104,6107],[212,216,6107],[211,212,6107],[210,211,6108],[6107,6108,211],[6108,6109,210],[209,210,6109],[238,209,6109],[237,238,6109],[236,237,6109],[6112,6111,6110],[6110,6113,6112],[6112,6113,6021],[6021,6020,6112],[6112,6020,6019],[6019,6114,6112],[6112,6114,6115],[6115,6111,6112],[6117,6116,6110],[6110,6111,6117],[6117,6111,6115],[6115,6118,6117],[6117,6118,6119],[6119,6120,6117],[6117,6120,6121],[6121,6116,6117],[6123,6122,6110],[6110,6116,6123],[6123,6116,6121],[6121,6124,6123],[6123,6124,5948],[5948,5947,6123],[6123,5947,5944],[5944,6122,6123],[6125,6113,6110],[6110,6122,6125],[6125,6122,5944],[5944,5943,6125],[6125,5943,5847],[5847,6024,6125],[6125,6024,6021],[6021,6113,6125],[6128,6127,6126],[6126,6129,6128],[6128,6129,5950],[5950,5949,6128],[6128,5949,5948],[5948,6130,6128],[6128,6130,6131],[6131,6127,6128],[6133,6132,6126],[6126,6127,6133],[6133,6127,6131],[6131,6134,6133],[6133,6134,6135],[6135,6136,6133],[6133,6136,6137],[6137,6132,6133],[6139,6138,6126],[6126,6132,6139],[6139,6132,6137],[6137,6140,6139],[6139,6140,5964],[5964,5963,6139],[6139,5963,5960],[5960,6138,6139],[6141,6129,6126],[6126,6138,6141],[6141,6138,5960],[5960,5959,6141],[6141,5959,5762],[5762,5952,6141],[6141,5952,5950],[5950,6129,6141],[6144,6143,6142],[6142,6145,6144],[6144,6145,5974],[5974,5973,6144],[6144,5973,5577],[5577,5783,6144],[6144,5783,5780],[5780,6143,6144],[6147,6146,6142],[6142,6143,6147],[6147,6143,5780],[5780,5779,6147],[6147,5779,5778],[5778,6148,6147],[6147,6148,6149],[6149,6146,6147],[6151,6150,6142],[6142,6146,6151],[6151,6146,6149],[6149,6152,6151],[6151,6152,6153],[6153,6154,6151],[6151,6154,6155],[6155,6150,6151],[6156,6145,6142],[6142,6150,6156],[6156,6150,6155],[6155,6157,6156],[6156,6157,5978],[5978,5977,6156],[6156,5977,5974],[5974,6145,6156],[6160,6159,6158],[6158,6161,6160],[6160,6161,5798],[5798,5797,6160],[6160,5797,5796],[5796,6162,6160],[6160,6162,6163],[6163,6159,6160],[6165,6164,6158],[6158,6159,6165],[6165,6159,6163],[6163,6166,6165],[6165,6166,6167],[6167,6168,6165],[6165,6168,6169],[6169,6164,6165],[6171,6170,6158],[6158,6164,6171],[6171,6164,6169],[6169,6172,6171],[6171,6172,5996],[5996,5995,6171],[6171,5995,5992],[5992,6170,6171],[6173,6161,6158],[6158,6170,6173],[6173,6170,5992],[5992,5991,6173],[6173,5991,5591],[5591,5800,6173],[6173,5800,5798],[5798,6161,6173],[6176,6175,6174],[6174,6177,6176],[6176,6177,6038],[6038,6037,6176],[6176,6037,5641],[5641,5815,6176],[5812,6175,6176],[6176,5815,5812],[6179,6178,6174],[6174,6175,6179],[6179,6175,5812],[5812,5811,6179],[6179,5811,5810],[5810,6180,6179],[6179,6180,6181],[6181,6178,6179],[6183,6182,6174],[6174,6178,6183],[6183,6178,6181],[6181,6184,6183],[6183,6184,6185],[6185,6186,6183],[6183,6186,6187],[6187,6182,6183],[6188,6177,6174],[6174,6182,6188],[6188,6182,6187],[6187,6189,6188],[6188,6189,6042],[6042,6041,6188],[6188,6041,6038],[6038,6177,6188],[6192,6191,6190],[6190,6193,6192],[6192,6193,6028],[6028,6027,6192],[6192,6027,5842],[5842,6006,6192],[6192,6006,6005],[6005,6191,6192],[6195,6194,6190],[6190,6191,6195],[6195,6191,6005],[6005,6012,6195],[6195,6012,5874],[5874,6064,6195],[6195,6064,6062],[6062,6194,6195],[6197,6196,6190],[6190,6194,6197],[6197,6194,6062],[6062,6061,6197],[6197,6061,6060],[6060,6198,6197],[6197,6198,6199],[6199,6196,6197],[6200,6193,6190],[6190,6196,6200],[6200,6196,6199],[6199,6201,6200],[6200,6201,6031],[6031,6030,6200],[6200,6030,6028],[6028,6193,6200],[6204,6203,6202],[6202,6205,6204],[6204,6205,6206],[6206,6207,6204],[6204,6207,6019],[6019,6018,6204],[6204,6018,6017],[6017,6203,6204],[6209,6208,6202],[6202,6203,6209],[6209,6203,6017],[6017,6032,6209],[6209,6032,6031],[6031,6210,6209],[6209,6210,6211],[6211,6208,6209],[6213,6212,6202],[6202,6208,6213],[6213,6208,6211],[6211,6214,6213],[6213,6214,6215],[6215,6216,6213],[6213,6216,6217],[6217,6212,6213],[6218,6205,6202],[6202,6212,6218],[6218,6212,6217],[6217,6219,6218],[6218,6219,6220],[6220,6221,6218],[6206,6218,6221],[6218,6206,6205],[6224,6223,6222],[6222,6225,6224],[6224,6225,5862],[5862,5861,6224],[6224,5861,5860],[5860,6226,6224],[6224,6226,6227],[6227,6223,6224],[6229,6228,6222],[6222,6223,6229],[6229,6223,6227],[6227,6230,6229],[6229,6230,6231],[6231,6232,6229],[6229,6232,6233],[6233,6228,6229],[6235,6234,6222],[6222,6228,6235],[6235,6228,6233],[6233,6236,6235],[6235,6236,6060],[6060,6059,6235],[6235,6059,6056],[6056,6234,6235],[6237,6225,6222],[6222,6234,6237],[6237,6234,6056],[6056,6055,6237],[6237,6055,5655],[5655,5864,6237],[6237,5864,5862],[5862,6225,6237],[57,5687,56],[55,56,5687],[6240,6239,6238],[6238,6241,6240],[6240,6241,6081],[6081,6080,6240],[6240,6080,5705],[5705,5896,6240],[6240,5896,5893],[5893,6239,6240],[6243,6242,6238],[6238,6239,6243],[6243,6239,5893],[5893,5892,6243],[6243,5892,5891],[5891,6244,6243],[6243,6244,6245],[6245,6242,6243],[6247,6246,6238],[6238,6242,6247],[6247,6242,6245],[6245,6248,6247],[6247,6248,6249],[6249,6250,6247],[6247,6250,6251],[6251,6246,6247],[6252,6241,6238],[6238,6246,6252],[6252,6246,6251],[6251,6253,6252],[6252,6253,6085],[6085,6084,6252],[6252,6084,6081],[6081,6241,6252],[6256,6255,6254],[6254,6257,6256],[6256,6257,6258],[6258,6259,6256],[6256,6259,6109],[6109,6108,6256],[6256,6108,6107],[6107,6255,6256],[6261,6260,6254],[6254,6255,6261],[6261,6255,6107],[6107,6106,6261],[6261,6106,5935],[5935,6103,6261],[6261,6103,6101],[6101,6260,6261],[6263,6262,6254],[6254,6260,6263],[6263,6260,6101],[6101,6100,6263],[6263,6100,5909],[5909,6090,6263],[6263,6090,6087],[6087,6262,6263],[6264,6257,6254],[6254,6262,6264],[6264,6262,6087],[6087,6086,6264],[6264,6086,6085],[6085,6265,6264],[6264,6265,6258],[6258,6257,6264],[6109,235,236],[6109,231,235],[233,231,6109],[6268,6267,6266],[6266,6269,6268],[6268,6269,6115],[6115,6114,6268],[6268,6114,6019],[6019,6207,6268],[6268,6207,6206],[6206,6267,6268],[6271,6270,6266],[6266,6267,6271],[6221,6271,6206],[6267,6206,6271],[6271,6221,6220],[6220,6272,6271],[6271,6272,6273],[6273,6270,6271],[6275,6274,6266],[6266,6270,6275],[6275,6270,6273],[6273,6276,6275],[6275,6276,6277],[6277,6278,6275],[6275,6278,6279],[6279,6274,6275],[6280,6269,6266],[6266,6274,6280],[6280,6274,6279],[6279,6281,6280],[6280,6281,6119],[6119,6118,6280],[6280,6118,6115],[6115,6269,6280],[6284,6283,6282],[6282,6285,6284],[6284,6285,6131],[6131,6130,6284],[6284,6130,5948],[5948,6124,6284],[6284,6124,6121],[6121,6283,6284],[6287,6286,6282],[6282,6283,6287],[6287,6283,6121],[6121,6120,6287],[6287,6120,6119],[6119,6288,6287],[6287,6288,6289],[6289,6286,6287],[6291,6290,6282],[6282,6286,6291],[6291,6286,6289],[6289,6292,6291],[6291,6292,6293],[6293,6294,6291],[6291,6294,6295],[6295,6290,6291],[6296,6285,6282],[6282,6290,6296],[6296,6290,6295],[6295,6297,6296],[6296,6297,6135],[6135,6134,6296],[6296,6134,6131],[6131,6285,6296],[6300,6299,6298],[6298,6301,6300],[6300,6301,5966],[5966,5965,6300],[6300,5965,5964],[5964,6302,6300],[6300,6302,6303],[6303,6299,6300],[6305,6304,6298],[6298,6299,6305],[6305,6299,6303],[6303,6306,6305],[6305,6306,6307],[6307,6308,6305],[6305,6308,6309],[6309,6304,6305],[6311,6310,6298],[6298,6304,6311],[6311,6304,6309],[6309,6312,6311],[6311,6312,6153],[6153,6152,6311],[6311,6152,6149],[6149,6310,6311],[6313,6301,6298],[6298,6310,6313],[6313,6310,6149],[6149,6148,6313],[6313,6148,5778],[5778,5968,6313],[6313,5968,5966],[5966,6301,6313],[6316,6315,6314],[6314,6317,6316],[6316,6317,6163],[6163,6162,6316],[6316,6162,5796],[5796,5983,6316],[6316,5983,5980],[5980,6315,6316],[6319,6318,6314],[6314,6315,6319],[6319,6315,5980],[5980,5979,6319],[6319,5979,5978],[5978,6320,6319],[6319,6320,6321],[6321,6318,6319],[6323,6322,6314],[6314,6318,6323],[6323,6318,6321],[6321,6324,6323],[6323,6324,6325],[6325,6326,6323],[6323,6327,6322],[6327,6323,6326],[6328,6317,6314],[6314,6322,6328],[6328,6322,6327],[6327,6329,6328],[6328,6329,6167],[6167,6166,6328],[6328,6166,6163],[6163,6317,6328],[6332,6331,6330],[6330,6333,6332],[6332,6333,5998],[5998,5997,6332],[6332,5997,5996],[5996,6334,6332],[6332,6334,6335],[6335,6331,6332],[6337,6336,6330],[6330,6331,6337],[6337,6331,6335],[6335,6338,6337],[6337,6338,6339],[6339,6340,6337],[6337,6340,6341],[6341,6336,6337],[6343,6342,6330],[6330,6336,6343],[6343,6336,6341],[6341,6344,6343],[6343,6344,6185],[6185,6184,6343],[6343,6184,6181],[6181,6342,6343],[6345,6333,6330],[6330,6342,6345],[6345,6342,6181],[6181,6180,6345],[6345,6180,5810],[5810,6000,6345],[6345,6000,5998],[5998,6333,6345],[6348,6347,6346],[6346,6349,6348],[6348,6349,6350],[6350,6351,6348],[6348,6351,6215],[6215,6214,6348],[6348,6214,6211],[6211,6347,6348],[6353,6352,6346],[6346,6347,6353],[6353,6347,6211],[6211,6210,6353],[6353,6210,6031],[6031,6201,6353],[6353,6201,6199],[6199,6352,6353],[6355,6354,6346],[6346,6352,6355],[6355,6352,6199],[6199,6198,6355],[6355,6198,6060],[6060,6236,6355],[6355,6236,6233],[6233,6354,6355],[6356,6349,6346],[6346,6354,6356],[6356,6354,6233],[6233,6232,6356],[6356,6232,6231],[6231,6357,6356],[6356,6357,6350],[6350,6349,6356],[6360,6359,6358],[6358,6361,6360],[6360,6361,6362],[6362,6363,6360],[6360,6363,6364],[6364,6365,6360],[6360,6365,6366],[6366,6359,6360],[6368,6367,6358],[6358,6359,6368],[6368,6359,6366],[6366,6369,6368],[6368,6369,6220],[6220,6219,6368],[6368,6219,6217],[6217,6367,6368],[6371,6370,6358],[6358,6367,6371],[6371,6367,6217],[6217,6216,6371],[6371,6216,6215],[6215,6372,6371],[6371,6372,6373],[6373,6370,6371],[6374,6361,6358],[6358,6370,6374],[6374,6370,6373],[6373,6375,6374],[6374,6375,6376],[6376,6377,6374],[6374,6377,6362],[6362,6361,6374],[6380,6379,6378],[6378,6381,6380],[6380,6381,6227],[6227,6226,6380],[6380,6226,5860],[5860,6047,6380],[6380,6047,6044],[6044,6379,6380],[6383,6382,6378],[6378,6379,6383],[6383,6379,6044],[6044,6043,6383],[6383,6043,6042],[6042,6384,6383],[6383,6384,6385],[6385,6382,6383],[6387,6386,6378],[6378,6382,6387],[6387,6382,6385],[6385,6388,6387],[6387,6388,6389],[6389,6390,6387],[6387,6390,6391],[6391,6386,6387],[6392,6381,6378],[6378,6386,6392],[6392,6386,6391],[6391,6393,6392],[6392,6393,6231],[6231,6230,6392],[6392,6230,6227],[6227,6381,6392],[6394,73,74],[6394,40,41],[6394,41,73],[6395,44,43],[6395,43,42],[42,6394,6395],[6394,42,40],[6394,6396,6395],[6395,6396,6249],[6249,6397,6395],[6395,6397,6398],[6395,6398,45],[6395,45,44],[6398,46,45],[6398,39,46],[34,35,6399],[33,34,6399],[33,6399,6400],[32,33,6400],[32,6400,6073],[31,32,6073],[36,37,6401],[36,6401,6399],[35,36,6399],[38,39,6398],[37,38,6401],[6398,6401,38],[6403,6402,6399],[6399,6401,6403],[6403,6401,6398],[6398,6397,6403],[6403,6397,6249],[6249,6248,6403],[6403,6248,6245],[6245,6402,6403],[6404,6400,6399],[6399,6402,6404],[6404,6402,6245],[6245,6244,6404],[6404,6244,5891],[5891,6075,6404],[6404,6075,6073],[6073,6400,6404],[6407,6406,6405],[6405,6408,6407],[6407,6408,72],[6407,72,229],[71,72,6408],[6407,229,230],[6407,230,234],[233,6109,6407],[234,233,6407],[6109,6259,6407],[6407,6259,6258],[6258,6406,6407],[6410,6409,6405],[6405,6406,6410],[6410,6406,6258],[6258,6265,6410],[6410,6265,6085],[6085,6253,6410],[6410,6253,6251],[6251,6409,6410],[6412,6411,6405],[6405,6409,6412],[6412,6409,6251],[6251,6250,6412],[6412,6250,6249],[6249,6396,6412],[6412,6396,6394],[6394,6411,6412],[6413,6408,6405],[6405,6411,6413],[6413,6411,6394],[65,6413,6394],[74,65,6394],[65,74,75],[6413,65,63],[6413,63,66],[6413,66,67],[6413,67,68],[6408,6413,68],[6408,68,69],[6408,69,71],[6416,6415,6414],[6414,6417,6416],[6416,6417,6366],[6366,6365,6416],[6416,6365,6364],[6364,6418,6416],[6416,6418,6419],[6419,6415,6416],[6421,6420,6414],[6414,6415,6421],[6421,6415,6419],[6419,6422,6421],[6421,6422,6423],[6423,6424,6421],[6421,6424,6425],[6425,6420,6421],[6427,6426,6414],[6414,6420,6427],[6427,6420,6425],[6425,6428,6427],[6427,6428,6277],[6277,6276,6427],[6427,6276,6273],[6273,6426,6427],[6429,6417,6414],[6414,6426,6429],[6429,6426,6273],[6273,6272,6429],[6429,6272,6220],[6220,6369,6429],[6429,6369,6366],[6366,6417,6429],[6432,6431,6430],[6430,6433,6432],[6432,6433,6279],[6279,6278,6432],[6432,6278,6277],[6277,6434,6432],[6432,6434,6435],[6435,6431,6432],[6437,6436,6430],[6430,6431,6437],[6437,6431,6435],[6435,6438,6437],[6437,6438,6439],[6439,6440,6437],[6437,6440,6441],[6441,6436,6437],[6443,6442,6430],[6430,6436,6443],[6443,6436,6441],[6441,6444,6443],[6443,6444,6293],[6293,6292,6443],[6443,6292,6289],[6289,6442,6443],[6445,6433,6430],[6430,6442,6445],[6445,6442,6289],[6289,6288,6445],[6445,6288,6119],[6119,6281,6445],[6445,6281,6279],[6279,6433,6445],[6448,6447,6446],[6446,6449,6448],[6448,6449,6303],[6303,6302,6448],[6448,6302,5964],[5964,6140,6448],[6448,6140,6137],[6137,6447,6448],[6451,6450,6446],[6446,6447,6451],[6451,6447,6137],[6137,6136,6451],[6451,6136,6135],[6135,6452,6451],[6451,6452,6453],[6453,6450,6451],[6455,6454,6446],[6446,6450,6455],[6455,6450,6453],[6453,6456,6455],[6455,6456,6457],[6457,6458,6455],[6455,6458,6459],[6459,6454,6455],[6460,6449,6446],[6446,6454,6460],[6460,6454,6459],[6459,6461,6460],[6460,6461,6307],[6307,6306,6460],[6460,6306,6303],[6303,6449,6460],[6464,6463,6462],[6462,6465,6464],[6464,6465,6155],[6155,6154,6464],[6464,6154,6153],[6153,6466,6464],[6464,6466,6467],[6467,6463,6464],[6469,6468,6462],[6462,6463,6469],[6469,6463,6467],[6467,6470,6469],[6469,6470,6471],[6471,6472,6469],[6469,6472,6473],[6473,6468,6469],[6475,6474,6462],[6462,6468,6475],[6475,6468,6473],[6473,6476,6475],[6475,6476,6325],[6325,6324,6475],[6475,6324,6321],[6321,6474,6475],[6477,6465,6462],[6462,6474,6477],[6477,6474,6321],[6321,6320,6477],[6477,6320,5978],[5978,6157,6477],[6477,6157,6155],[6155,6465,6477],[6480,6479,6478],[6478,6481,6480],[6480,6481,6335],[6335,6334,6480],[6480,6334,5996],[5996,6172,6480],[6480,6172,6169],[6169,6479,6480],[6483,6482,6478],[6478,6479,6483],[6483,6479,6169],[6169,6168,6483],[6483,6168,6167],[6167,6484,6483],[6483,6484,6485],[6485,6482,6483],[6487,6486,6478],[6478,6482,6487],[6487,6482,6485],[6485,6488,6487],[6487,6488,6489],[6489,6490,6487],[6487,6490,6491],[6491,6486,6487],[6492,6481,6478],[6478,6486,6492],[6492,6486,6491],[6491,6493,6492],[6492,6493,6339],[6339,6338,6492],[6492,6338,6335],[6335,6481,6492],[6496,6495,6494],[6494,6497,6496],[6496,6497,6187],[6187,6186,6496],[6496,6186,6185],[6185,6498,6496],[6496,6498,6499],[6499,6495,6496],[6501,6500,6494],[6494,6495,6501],[6501,6495,6499],[6499,6502,6501],[6501,6502,6503],[6503,6504,6501],[6501,6504,6505],[6505,6500,6501],[6507,6506,6494],[6494,6500,6507],[6507,6500,6505],[6505,6508,6507],[6507,6508,6389],[6389,6388,6507],[6507,6388,6385],[6385,6506,6507],[6509,6497,6494],[6494,6506,6509],[6509,6506,6385],[6385,6384,6509],[6509,6384,6042],[6042,6189,6509],[6509,6189,6187],[6187,6497,6509],[6512,6511,6510],[6510,6513,6512],[6512,6513,6373],[6373,6372,6512],[6512,6372,6215],[6215,6351,6512],[6512,6351,6350],[6350,6511,6512],[6515,6514,6510],[6510,6511,6515],[6515,6511,6350],[6350,6357,6515],[6515,6357,6231],[6231,6393,6515],[6515,6393,6391],[6391,6514,6515],[6517,6516,6510],[6510,6514,6517],[6517,6514,6391],[6391,6390,6517],[6517,6390,6389],[6389,6518,6517],[6517,6518,6519],[6519,6516,6517],[6520,6513,6510],[6510,6516,6520],[6520,6516,6519],[6519,6521,6520],[6520,6521,6376],[6376,6375,6520],[6520,6375,6373],[6373,6513,6520],[6524,6523,6522],[6522,6525,6524],[6524,6525,6526],[6526,6527,6524],[6524,6364,6363],[6364,6524,6527],[6524,6363,6362],[6362,6523,6524],[6529,6528,6522],[6522,6523,6529],[6529,6523,6362],[6362,6377,6529],[6529,6377,6376],[6376,6530,6529],[6529,6530,6531],[6531,6528,6529],[6533,6532,6522],[6522,6528,6533],[6533,6528,6531],[6531,6534,6533],[6533,6534,6535],[6535,6536,6533],[6533,6536,6537],[6537,6532,6533],[6538,6525,6522],[6522,6532,6538],[6538,6532,6537],[6537,6539,6538],[6538,6539,6540],[6540,6541,6538],[6538,6541,6526],[6526,6525,6538],[6544,6543,6542],[6542,6545,6544],[6544,6545,6419],[6419,6418,6544],[6527,6544,6364],[6418,6364,6544],[6544,6527,6526],[6526,6543,6544],[6547,6546,6542],[6542,6543,6547],[6547,6543,6526],[6526,6541,6547],[6547,6541,6540],[6540,6548,6547],[6547,6548,6549],[6549,6546,6547],[6551,6550,6542],[6542,6546,6551],[6551,6546,6549],[6549,6552,6551],[6551,6552,6553],[6553,6554,6551],[6551,6554,6555],[6555,6550,6551],[6556,6545,6542],[6542,6550,6556],[6556,6550,6555],[6555,6557,6556],[6556,6557,6423],[6423,6422,6556],[6556,6422,6419],[6419,6545,6556],[6560,6559,6558],[6558,6561,6560],[6560,6561,6435],[6435,6434,6560],[6560,6434,6277],[6277,6428,6560],[6560,6428,6425],[6425,6559,6560],[6563,6562,6558],[6558,6559,6563],[6563,6559,6425],[6425,6424,6563],[6563,6424,6423],[6423,6564,6563],[6563,6564,6565],[6565,6562,6563],[6567,6566,6558],[6558,6562,6567],[6567,6562,6565],[6565,6568,6567],[6567,6568,6569],[6569,6570,6567],[6567,6570,6571],[6571,6566,6567],[6572,6561,6558],[6558,6566,6572],[6572,6566,6571],[6571,6573,6572],[6572,6573,6439],[6439,6438,6572],[6572,6438,6435],[6435,6561,6572],[6576,6575,6574],[6574,6577,6576],[6576,6577,6295],[6295,6294,6576],[6576,6294,6293],[6293,6578,6576],[6576,6578,6579],[6579,6575,6576],[6581,6580,6574],[6574,6575,6581],[6581,6575,6579],[6579,6582,6581],[6581,6582,6583],[6583,6584,6581],[6581,6584,6585],[6585,6580,6581],[6587,6586,6574],[6574,6580,6587],[6587,6580,6585],[6585,6588,6587],[6587,6588,6457],[6457,6456,6587],[6587,6456,6453],[6453,6586,6587],[6589,6577,6574],[6574,6586,6589],[6589,6586,6453],[6453,6452,6589],[6589,6452,6135],[6135,6297,6589],[6589,6297,6295],[6295,6577,6589],[6592,6591,6590],[6590,6593,6592],[6592,6593,6467],[6467,6466,6592],[6592,6466,6153],[6153,6312,6592],[6592,6312,6309],[6309,6591,6592],[6595,6594,6590],[6590,6591,6595],[6595,6591,6309],[6309,6308,6595],[6595,6308,6307],[6307,6596,6595],[6595,6596,6597],[6597,6594,6595],[6599,6598,6590],[6590,6594,6599],[6599,6594,6597],[6597,6600,6599],[6599,6600,6601],[6601,6602,6599],[6599,6602,6603],[6603,6598,6599],[6604,6593,6590],[6590,6598,6604],[6604,6598,6603],[6603,6605,6604],[6604,6605,6471],[6471,6470,6604],[6604,6470,6467],[6467,6593,6604],[6608,6607,6606],[6606,6609,6608],[6327,6326,6608],[6608,6609,6327],[6608,6326,6325],[6325,6610,6608],[6608,6610,6611],[6611,6607,6608],[6613,6612,6606],[6606,6607,6613],[6613,6607,6611],[6611,6614,6613],[6613,6614,6615],[6615,6616,6613],[6613,6616,6617],[6617,6612,6613],[6619,6618,6606],[6606,6612,6619],[6619,6612,6617],[6617,6620,6619],[6619,6620,6489],[6489,6488,6619],[6619,6488,6485],[6485,6618,6619],[6621,6609,6606],[6606,6618,6621],[6621,6618,6485],[6485,6484,6621],[6621,6484,6167],[6167,6329,6621],[6621,6329,6327],[6327,6609,6621],[6624,6623,6622],[6622,6625,6624],[6624,6625,6499],[6499,6498,6624],[6624,6498,6185],[6185,6344,6624],[6624,6344,6341],[6341,6623,6624],[6627,6626,6622],[6622,6623,6627],[6627,6623,6341],[6341,6340,6627],[6627,6340,6339],[6339,6628,6627],[6627,6628,6629],[6629,6626,6627],[6631,6630,6622],[6622,6626,6631],[6631,6626,6629],[6629,6632,6631],[6631,6632,6633],[6633,6634,6631],[6631,6634,6635],[6635,6630,6631],[6636,6625,6622],[6622,6630,6636],[6636,6630,6635],[6635,6637,6636],[6636,6637,6503],[6503,6502,6636],[6636,6502,6499],[6499,6625,6636],[6640,6639,6638],[6638,6641,6640],[6640,6641,6642],[6642,6643,6640],[6640,6643,6535],[6535,6534,6640],[6640,6534,6531],[6531,6639,6640],[6645,6644,6638],[6638,6639,6645],[6645,6639,6531],[6531,6530,6645],[6645,6530,6376],[6376,6521,6645],[6645,6521,6519],[6519,6644,6645],[6647,6646,6638],[6638,6644,6647],[6647,6644,6519],[6519,6518,6647],[6647,6518,6389],[6389,6508,6647],[6647,6508,6505],[6505,6646,6647],[6648,6641,6638],[6638,6646,6648],[6648,6646,6505],[6505,6504,6648],[6648,6504,6503],[6503,6649,6648],[6648,6649,6642],[6642,6641,6648],[6652,6651,6650],[6650,6653,6652],[6652,6653,6654],[6654,6655,6652],[6652,6655,6656],[6656,6657,6652],[6652,6657,6658],[6658,6651,6652],[6660,6659,6650],[6650,6651,6660],[6661,6660,6658],[6651,6658,6660],[6660,6661,6540],[6540,6539,6660],[6660,6539,6537],[6537,6659,6660],[6663,6662,6650],[6650,6659,6663],[6663,6659,6537],[6537,6536,6663],[6663,6536,6535],[6535,6664,6663],[6663,6664,6665],[6665,6662,6663],[6666,6653,6650],[6650,6662,6666],[6666,6662,6665],[6665,6667,6666],[6666,6667,6668],[6668,6669,6666],[6666,6669,6654],[6654,6653,6666],[6672,6671,6670],[6670,6673,6672],[6672,6673,6658],[6658,6657,6672],[6672,6657,6656],[6656,6674,6672],[6672,6674,6675],[6675,6671,6672],[6677,6676,6670],[6670,6671,6677],[6677,6671,6675],[6675,6678,6677],[6677,6678,6679],[6679,6680,6677],[6677,6680,6681],[6681,6676,6677],[6683,6682,6670],[6670,6676,6683],[6683,6676,6681],[6681,6684,6683],[6683,6684,6553],[6553,6552,6683],[6683,6552,6549],[6549,6682,6683],[6685,6673,6670],[6670,6682,6685],[6685,6682,6549],[6549,6548,6685],[6685,6548,6540],[6540,6661,6685],[6685,6658,6673],[6658,6685,6661],[6688,6687,6686],[6686,6689,6688],[6688,6689,6555],[6555,6554,6688],[6688,6554,6553],[6553,6690,6688],[6688,6690,6691],[6691,6687,6688],[6693,6692,6686],[6686,6687,6693],[6693,6687,6691],[6691,6694,6693],[6693,6694,6695],[6695,6696,6693],[6693,6696,6697],[6697,6692,6693],[6699,6698,6686],[6686,6692,6699],[6699,6692,6697],[6697,6700,6699],[6699,6700,6569],[6569,6568,6699],[6699,6568,6565],[6565,6698,6699],[6701,6689,6686],[6686,6698,6701],[6701,6698,6565],[6565,6564,6701],[6701,6564,6423],[6423,6557,6701],[6701,6557,6555],[6555,6689,6701],[6704,6703,6702],[6702,6705,6704],[6704,6705,6579],[6579,6578,6704],[6704,6578,6293],[6293,6444,6704],[6704,6444,6441],[6441,6703,6704],[6707,6706,6702],[6702,6703,6707],[6707,6703,6441],[6441,6440,6707],[6707,6440,6439],[6439,6708,6707],[6707,6708,6709],[6709,6706,6707],[6711,6710,6702],[6702,6706,6711],[6711,6706,6709],[6709,6712,6711],[6711,6712,6713],[6713,6714,6711],[6711,6714,6715],[6715,6710,6711],[6716,6705,6702],[6702,6710,6716],[6716,6710,6715],[6715,6717,6716],[6716,6717,6583],[6583,6582,6716],[6716,6582,6579],[6579,6705,6716],[6720,6719,6718],[6718,6721,6720],[6720,6721,6459],[6459,6458,6720],[6720,6458,6457],[6457,6722,6720],[6720,6722,6723],[6723,6719,6720],[6725,6724,6718],[6718,6719,6725],[6725,6719,6723],[6723,6726,6725],[6725,6728,6727],[6728,6725,6726],[6725,6727,6729],[6729,6724,6725],[6731,6730,6718],[6718,6724,6731],[6731,6724,6729],[6729,6732,6731],[6731,6732,6601],[6601,6600,6731],[6731,6600,6597],[6597,6730,6731],[6733,6721,6718],[6718,6730,6733],[6733,6730,6597],[6597,6596,6733],[6733,6596,6307],[6307,6461,6733],[6733,6461,6459],[6459,6721,6733],[6736,6735,6734],[6734,6737,6736],[6736,6737,6611],[6611,6610,6736],[6736,6610,6325],[6325,6476,6736],[6473,6736,6476],[6736,6473,6735],[6739,6738,6734],[6734,6735,6739],[6739,6735,6473],[6473,6472,6739],[6739,6472,6471],[6471,6740,6739],[6739,6740,6741],[6741,6738,6739],[6743,6742,6734],[6734,6738,6743],[6743,6738,6741],[6741,6744,6743],[6743,6744,6745],[6745,6746,6743],[6743,6746,6747],[6747,6742,6743],[6748,6737,6734],[6734,6742,6748],[6748,6742,6747],[6747,6749,6748],[6748,6749,6615],[6615,6614,6748],[6748,6614,6611],[6611,6737,6748],[6752,6751,6750],[6750,6753,6752],[6752,6753,6491],[6491,6490,6752],[6752,6490,6489],[6489,6754,6752],[6752,6754,6755],[6755,6751,6752],[6757,6756,6750],[6750,6751,6757],[6757,6751,6755],[6755,6758,6757],[6757,6758,6759],[6759,6760,6757],[6757,6760,6761],[6761,6756,6757],[6763,6762,6750],[6750,6756,6763],[6763,6756,6761],[6761,6764,6763],[6763,6764,6633],[6633,6632,6763],[6763,6632,6629],[6629,6762,6763],[6765,6753,6750],[6750,6762,6765],[6765,6762,6629],[6629,6628,6765],[6765,6628,6339],[6339,6493,6765],[6765,6493,6491],[6491,6753,6765],[6768,6767,6766],[6766,6769,6768],[6768,6769,6665],[6665,6664,6768],[6768,6664,6535],[6535,6643,6768],[6768,6643,6642],[6642,6767,6768],[6771,6770,6766],[6766,6767,6771],[6771,6767,6642],[6642,6649,6771],[6771,6649,6503],[6503,6637,6771],[6771,6637,6635],[6635,6770,6771],[6773,6772,6766],[6766,6770,6773],[6773,6770,6635],[6635,6634,6773],[6773,6634,6633],[6633,6774,6773],[6773,6774,6775],[6775,6772,6773],[6776,6769,6766],[6766,6772,6776],[6776,6772,6775],[6775,6777,6776],[6776,6777,6668],[6668,6667,6776],[6776,6667,6665],[6665,6769,6776],[6780,6779,6778],[6778,6781,6780],[6780,6781,6782],[6782,6783,6780],[6780,6783,6656],[6656,6655,6780],[6780,6655,6654],[6654,6779,6780],[6785,6784,6778],[6778,6779,6785],[6785,6779,6654],[6654,6669,6785],[6785,6669,6668],[6668,6786,6785],[6785,6786,6787],[6787,6784,6785],[6789,6788,6778],[6778,6784,6789],[6789,6784,6787],[6787,6790,6789],[6789,6790,6791],[6791,6792,6789],[6789,6792,6793],[6793,6788,6789],[6794,6781,6778],[6778,6788,6794],[6794,6788,6793],[6793,6795,6794],[6794,6795,6796],[6796,6797,6794],[6794,6797,6782],[6782,6781,6794],[6800,6799,6798],[6798,6801,6800],[6800,6801,6675],[6675,6674,6800],[6800,6674,6656],[6656,6783,6800],[6800,6783,6782],[6782,6799,6800],[6803,6802,6798],[6798,6799,6803],[6803,6799,6782],[6782,6797,6803],[6803,6797,6796],[6796,6804,6803],[6803,6804,6805],[6805,6802,6803],[6807,6806,6798],[6798,6802,6807],[6807,6802,6805],[6805,6808,6807],[6807,6808,6809],[6809,6810,6807],[6807,6810,6811],[6811,6806,6807],[6812,6801,6798],[6798,6806,6812],[6812,6806,6811],[6811,6813,6812],[6812,6813,6679],[6679,6678,6812],[6812,6678,6675],[6675,6801,6812],[6816,6815,6814],[6814,6817,6816],[6816,6817,6691],[6691,6690,6816],[6816,6690,6553],[6553,6684,6816],[6816,6684,6681],[6681,6815,6816],[6819,6818,6814],[6814,6815,6819],[6819,6815,6681],[6681,6680,6819],[6819,6680,6679],[6679,6820,6819],[6819,6820,6821],[6821,6818,6819],[6823,6822,6814],[6814,6818,6823],[6823,6818,6821],[6821,6824,6823],[6823,6824,6825],[6825,6826,6823],[6823,6826,6827],[6827,6822,6823],[6828,6817,6814],[6814,6822,6828],[6828,6822,6827],[6827,6829,6828],[6828,6829,6695],[6695,6694,6828],[6828,6694,6691],[6691,6817,6828],[6832,6831,6830],[6830,6833,6832],[6832,6833,6571],[6571,6570,6832],[6832,6570,6569],[6569,6834,6832],[6832,6834,6835],[6835,6831,6832],[6837,6836,6830],[6830,6831,6837],[6837,6831,6835],[6835,6838,6837],[6837,6838,6839],[6839,6840,6837],[6837,6840,6841],[6841,6836,6837],[6843,6842,6830],[6830,6836,6843],[6843,6836,6841],[6841,6844,6843],[6843,6844,6713],[6713,6712,6843],[6843,6712,6709],[6709,6842,6843],[6845,6833,6830],[6830,6842,6845],[6845,6842,6709],[6709,6708,6845],[6845,6708,6439],[6439,6573,6845],[6845,6573,6571],[6571,6833,6845],[6848,6847,6846],[6846,6849,6848],[6848,6849,6723],[6723,6722,6848],[6848,6722,6457],[6457,6588,6848],[6848,6588,6585],[6585,6847,6848],[6851,6850,6846],[6846,6847,6851],[6851,6847,6585],[6585,6584,6851],[6851,6584,6583],[6583,6852,6851],[6851,6852,6853],[6853,6850,6851],[6855,6854,6846],[6846,6850,6855],[6855,6850,6853],[6853,6856,6855],[6855,6856,6857],[6857,6858,6855],[6855,6858,6859],[6859,6854,6855],[6860,6849,6846],[6846,6854,6860],[6860,6854,6859],[6859,6861,6860],[6860,6861,6728],[6728,6726,6860],[6860,6726,6723],[6723,6849,6860],[6864,6863,6862],[6862,6865,6864],[6603,6602,6864],[6864,6865,6603],[6864,6602,6601],[6601,6866,6864],[6864,6866,6867],[6867,6863,6864],[6869,6868,6862],[6862,6863,6869],[6869,6863,6867],[6867,6870,6869],[6869,6870,6871],[6871,6872,6869],[6869,6872,6873],[6873,6868,6869],[6875,6874,6862],[6862,6868,6875],[6875,6868,6873],[6873,6876,6875],[6875,6876,6745],[6745,6744,6875],[6875,6744,6741],[6741,6874,6875],[6877,6865,6862],[6862,6874,6877],[6877,6874,6741],[6741,6740,6877],[6877,6740,6471],[6471,6605,6877],[6877,6605,6603],[6603,6865,6877],[6880,6879,6878],[6878,6881,6880],[6880,6881,6755],[6755,6754,6880],[6880,6754,6489],[6489,6620,6880],[6880,6620,6617],[6617,6879,6880],[6883,6882,6878],[6878,6879,6883],[6883,6879,6617],[6617,6616,6883],[6883,6616,6615],[6615,6884,6883],[6883,6884,6885],[6885,6882,6883],[6887,6886,6878],[6878,6882,6887],[6887,6882,6885],[6885,6888,6887],[6887,6888,6889],[6889,6890,6887],[6887,6890,6891],[6891,6886,6887],[6892,6881,6878],[6878,6886,6892],[6892,6886,6891],[6891,6893,6892],[6892,6893,6759],[6759,6758,6892],[6892,6758,6755],[6755,6881,6892],[6896,6895,6894],[6894,6897,6896],[6896,6897,6898],[6898,6899,6896],[6896,6899,6791],[6791,6790,6896],[6896,6790,6787],[6787,6895,6896],[6901,6900,6894],[6894,6895,6901],[6901,6895,6787],[6787,6786,6901],[6901,6786,6668],[6668,6777,6901],[6901,6777,6775],[6775,6900,6901],[6903,6902,6894],[6894,6900,6903],[6903,6900,6775],[6775,6774,6903],[6903,6774,6633],[6633,6764,6903],[6903,6764,6761],[6761,6902,6903],[6904,6897,6894],[6894,6902,6904],[6904,6902,6761],[6761,6760,6904],[6904,6760,6759],[6759,6905,6904],[6904,6905,6898],[6898,6897,6904],[6908,6907,6906],[6906,6909,6908],[6908,6909,6910],[6910,6911,6908],[6908,6911,6912],[6912,6913,6908],[6907,6908,6914],[6913,6914,6908],[6916,6915,6906],[6906,6907,6916],[6916,6907,6914],[6914,6917,6916],[6916,6917,6796],[6796,6795,6916],[6916,6795,6793],[6793,6915,6916],[6919,6918,6906],[6906,6915,6919],[6919,6915,6793],[6793,6792,6919],[6919,6792,6791],[6791,6920,6919],[6919,6920,6921],[6921,6918,6919],[6922,6909,6906],[6906,6918,6922],[6922,6918,6921],[6921,6923,6922],[6922,6923,6924],[6924,6925,6922],[6922,6925,6910],[6910,6909,6922],[6928,6927,6926],[6926,6929,6928],[6914,6913,6928],[6928,6929,6914],[6930,6928,6912],[6913,6912,6928],[6928,6930,6931],[6931,6927,6928],[6933,6932,6926],[6926,6927,6933],[6933,6927,6931],[6931,6934,6933],[6933,6934,6935],[6935,6936,6933],[6933,6936,6937],[6937,6932,6933],[6939,6938,6926],[6926,6932,6939],[6939,6932,6937],[6937,6940,6939],[6939,6940,6809],[6809,6808,6939],[6939,6808,6805],[6805,6938,6939],[6941,6929,6926],[6926,6938,6941],[6941,6938,6805],[6805,6804,6941],[6941,6804,6796],[6796,6917,6941],[6941,6917,6914],[6914,6929,6941],[6944,6943,6942],[6942,6945,6944],[6944,6945,6811],[6811,6810,6944],[6944,6810,6809],[6809,6946,6944],[6944,6946,6947],[6947,6943,6944],[6949,6948,6942],[6942,6943,6949],[6949,6943,6947],[6947,6950,6949],[6949,6950,6951],[6951,6952,6949],[6949,6952,6953],[6953,6948,6949],[6955,6954,6942],[6942,6948,6955],[6955,6948,6953],[6953,6956,6955],[6955,6956,6825],[6825,6824,6955],[6955,6824,6821],[6821,6954,6955],[6957,6945,6942],[6942,6954,6957],[6957,6954,6821],[6821,6820,6957],[6957,6820,6679],[6679,6813,6957],[6957,6813,6811],[6811,6945,6957],[6960,6959,6958],[6958,6961,6960],[6960,6961,6835],[6835,6834,6960],[6960,6834,6569],[6569,6700,6960],[6960,6700,6697],[6697,6959,6960],[6963,6962,6958],[6958,6959,6963],[6963,6959,6697],[6697,6696,6963],[6963,6696,6695],[6695,6964,6963],[6963,6964,6965],[6965,6962,6963],[6967,6966,6958],[6958,6962,6967],[6967,6962,6965],[6965,6968,6967],[6967,6968,6969],[6969,6970,6967],[6967,6970,6971],[6971,6966,6967],[6972,6961,6958],[6958,6966,6972],[6972,6966,6971],[6971,6973,6972],[6972,6973,6839],[6839,6838,6972],[6972,6838,6835],[6835,6961,6972],[6976,6975,6974],[6974,6977,6976],[6976,6977,6715],[6715,6714,6976],[6976,6714,6713],[6713,6978,6976],[6976,6978,6979],[6979,6975,6976],[6981,6980,6974],[6974,6975,6981],[6981,6975,6979],[6979,6982,6981],[6981,6982,6983],[6983,6984,6981],[6981,6984,6985],[6985,6980,6981],[6987,6986,6974],[6974,6980,6987],[6980,6985,6987],[6988,6987,6985],[6987,6988,6857],[6857,6856,6987],[6987,6856,6853],[6853,6986,6987],[6989,6977,6974],[6974,6986,6989],[6989,6986,6853],[6853,6852,6989],[6989,6852,6583],[6583,6717,6989],[6989,6717,6715],[6715,6977,6989],[6992,6991,6990],[6990,6993,6992],[6992,6993,6867],[6867,6866,6992],[6992,6866,6601],[6601,6732,6992],[6992,6732,6729],[6729,6991,6992],[6995,6994,6990],[6990,6991,6995],[6995,6991,6729],[6729,6727,6995],[6996,6995,6728],[6727,6728,6995],[6995,6996,6997],[6997,6994,6995],[6999,6998,6990],[6990,6994,6999],[6999,6994,6997],[6997,7000,6999],[6999,7000,7001],[7001,7002,6999],[6999,7002,7003],[7003,6998,6999],[7004,6993,6990],[6990,6998,7004],[7004,6998,7003],[7003,7005,7004],[7004,7005,6871],[6871,6870,7004],[7004,6870,6867],[6867,6993,7004],[7008,7007,7006],[7006,7009,7008],[7008,7009,6747],[6747,6746,7008],[7008,6746,6745],[6745,7010,7008],[7008,7010,7011],[7011,7007,7008],[7013,7012,7006],[7006,7007,7013],[7013,7007,7011],[7011,7014,7013],[7013,7014,7015],[7015,7016,7013],[7013,7016,7017],[7017,7012,7013],[7019,7018,7006],[7006,7012,7019],[7019,7012,7017],[7017,7020,7019],[7019,7020,6889],[6889,6888,7019],[7019,6888,6885],[6885,7018,7019],[7021,7009,7006],[7006,7018,7021],[7021,7018,6885],[6885,6884,7021],[7021,6884,6615],[6615,6749,7021],[7021,6749,6747],[6747,7009,7021],[7024,7023,7022],[7022,7025,7024],[7024,7025,6921],[6921,6920,7024],[7024,6920,6791],[6791,6899,7024],[7024,6899,6898],[6898,7023,7024],[7027,7026,7022],[7022,7023,7027],[7027,7023,6898],[6898,6905,7027],[7027,6905,6759],[6759,6893,7027],[7027,6893,6891],[6891,7026,7027],[7029,7028,7022],[7022,7026,7029],[7029,7026,6891],[6891,6890,7029],[7029,6890,6889],[6889,7030,7029],[7029,7030,7031],[7031,7028,7029],[7032,7025,7022],[7022,7028,7032],[7032,7028,7031],[7031,7033,7032],[7032,7033,6924],[6924,6923,7032],[7032,6923,6921],[6921,7025,7032],[7036,7035,7034],[7034,7037,7036],[7036,7037,7038],[7038,7039,7036],[7036,7039,6912],[6912,6911,7036],[7036,6911,6910],[6910,7035,7036],[7041,7040,7034],[7034,7035,7041],[7041,7035,6910],[6910,6925,7041],[7041,6925,6924],[6924,7042,7041],[7041,7042,7043],[7043,7040,7041],[7045,7044,7034],[7034,7040,7045],[7045,7040,7043],[7043,7046,7045],[7045,7046,7047],[7047,7048,7045],[7045,7048,7049],[7049,7044,7045],[7050,7037,7034],[7034,7044,7050],[7050,7044,7049],[7049,7051,7050],[7050,7051,7052],[7052,7053,7050],[7037,7050,7038],[7053,7038,7050],[7056,7055,7054],[7054,7057,7056],[7056,7057,6931],[6931,6930,7056],[7056,6930,6912],[6912,7039,7056],[7056,7039,7038],[7038,7055,7056],[7059,7058,7054],[7054,7055,7059],[7059,7055,7038],[7038,7053,7059],[7059,7053,7052],[7052,7060,7059],[7059,7060,7061],[7061,7058,7059],[7063,7062,7054],[7054,7058,7063],[7063,7058,7061],[7061,7064,7063],[7063,7064,7065],[7065,7066,7063],[7063,7066,7067],[7067,7062,7063],[7068,7057,7054],[7054,7062,7068],[7068,7062,7067],[7067,7069,7068],[7068,7069,6935],[6935,6934,7068],[7068,6934,6931],[6931,7057,7068],[7072,7071,7070],[7070,7073,7072],[7072,7073,6947],[6947,6946,7072],[7072,6946,6809],[6809,6940,7072],[7072,6940,6937],[6937,7071,7072],[7075,7074,7070],[7070,7071,7075],[7075,7071,6937],[6937,6936,7075],[7075,6936,6935],[6935,7076,7075],[7075,7076,7077],[7077,7074,7075],[7079,7078,7070],[7070,7074,7079],[7079,7074,7077],[7077,7080,7079],[7079,7080,7081],[7081,7082,7079],[7079,7082,7083],[7083,7078,7079],[7084,7073,7070],[7070,7078,7084],[7084,7078,7083],[7083,7085,7084],[7084,7085,6951],[6951,6950,7084],[7084,6950,6947],[6947,7073,7084],[7088,7087,7086],[7086,7089,7088],[7088,7089,6827],[6827,6826,7088],[7088,6826,6825],[6825,7090,7088],[7088,7090,7091],[7091,7087,7088],[7093,7092,7086],[7086,7087,7093],[7093,7087,7091],[7091,7094,7093],[7093,7094,7095],[7095,7096,7093],[7093,7096,7097],[7097,7092,7093],[7099,7098,7086],[7086,7092,7099],[7099,7092,7097],[7097,7100,7099],[7099,7100,6969],[6969,6968,7099],[7099,6968,6965],[6965,7098,7099],[7101,7089,7086],[7086,7098,7101],[7101,7098,6965],[6965,6964,7101],[7101,6964,6695],[6695,6829,7101],[7101,6829,6827],[6827,7089,7101],[7104,7103,7102],[7102,7105,7104],[7104,7105,6979],[6979,6978,7104],[7104,6978,6713],[6713,6844,7104],[7104,6844,6841],[6841,7103,7104],[7107,7106,7102],[7102,7103,7107],[7107,7103,6841],[6841,6840,7107],[7107,6840,6839],[6839,7108,7107],[7107,7108,7109],[7109,7106,7107],[7111,7110,7102],[7102,7106,7111],[7111,7106,7109],[7109,7112,7111],[7111,7112,7113],[7113,7114,7111],[7111,7114,7115],[7115,7110,7111],[7116,7105,7102],[7102,7110,7116],[7116,7110,7115],[7115,7117,7116],[7116,7117,6983],[6983,6982,7116],[7116,6982,6979],[6979,7105,7116],[7120,7119,7118],[7118,7121,7120],[7120,7121,6859],[6859,6858,7120],[7120,6858,6857],[6857,7122,7120],[7120,7122,7123],[7123,7119,7120],[7125,7124,7118],[7118,7119,7125],[7125,7119,7123],[7123,7126,7125],[7125,7126,7127],[7127,7128,7125],[7125,7128,7129],[7129,7124,7125],[7131,7130,7118],[7118,7124,7131],[7131,7124,7129],[7129,7132,7131],[7131,7132,7001],[7001,7000,7131],[7131,7000,6997],[6997,7130,7131],[7133,7121,7118],[7118,7130,7133],[7133,7130,6997],[6997,6996,7133],[7133,6996,6728],[6728,6861,7133],[7133,6861,6859],[6859,7121,7133],[7136,7135,7134],[7134,7137,7136],[7136,7137,7011],[7011,7010,7136],[7136,7010,6745],[6745,6876,7136],[7136,6876,6873],[6873,7135,7136],[7139,7138,7134],[7134,7135,7139],[7139,7135,6873],[6873,6872,7139],[7139,6872,6871],[6871,7140,7139],[7139,7140,7141],[7141,7138,7139],[7143,7142,7134],[7134,7138,7143],[7143,7138,7141],[7141,7144,7143],[7143,7144,7145],[7145,7146,7143],[7143,7146,7147],[7147,7142,7143],[7148,7137,7134],[7134,7142,7148],[7148,7142,7147],[7147,7149,7148],[7148,7149,7015],[7015,7014,7148],[7148,7014,7011],[7011,7137,7148],[7152,7151,7150],[7150,7153,7152],[7152,7153,7154],[7154,7155,7152],[7152,7155,7047],[7047,7046,7152],[7152,7046,7043],[7043,7151,7152],[7157,7156,7150],[7150,7151,7157],[7157,7151,7043],[7043,7042,7157],[7157,7042,6924],[6924,7033,7157],[7157,7033,7031],[7031,7156,7157],[7159,7158,7150],[7150,7156,7159],[7159,7156,7031],[7031,7030,7159],[7159,7030,6889],[6889,7020,7159],[7159,7020,7017],[7017,7158,7159],[7160,7153,7150],[7150,7158,7160],[7160,7158,7017],[7017,7016,7160],[7160,7016,7015],[7015,7161,7160],[7160,7161,7154],[7154,7153,7160],[7164,7163,7162],[7162,7165,7164],[7164,7165,7166],[7166,7167,7164],[7164,7167,7168],[7168,7169,7164],[7164,7169,7170],[7170,7163,7164],[7172,7171,7162],[7162,7163,7172],[7172,7163,7170],[7170,7173,7172],[7172,7173,7052],[7052,7051,7172],[7172,7051,7049],[7049,7171,7172],[7175,7174,7162],[7162,7171,7175],[7175,7171,7049],[7049,7048,7175],[7175,7048,7047],[7047,7176,7175],[7175,7176,7177],[7177,7174,7175],[7178,7165,7162],[7162,7174,7178],[7178,7174,7177],[7177,7179,7178],[7178,7179,7180],[7180,7181,7178],[7178,7181,7166],[7166,7165,7178],[7184,7183,7182],[7182,7185,7184],[7184,7185,7170],[7170,7169,7184],[7184,7169,7168],[7168,7186,7184],[7184,7186,7187],[7187,7183,7184],[7189,7188,7182],[7182,7183,7189],[7189,7183,7187],[7187,7190,7189],[7189,7190,7191],[7191,7192,7189],[7189,7192,7193],[7193,7188,7189],[7195,7194,7182],[7182,7188,7195],[7195,7188,7193],[7193,7196,7195],[7195,7196,7065],[7065,7064,7195],[7195,7064,7061],[7061,7194,7195],[7197,7185,7182],[7182,7194,7197],[7197,7194,7061],[7061,7060,7197],[7197,7060,7052],[7052,7173,7197],[7197,7173,7170],[7170,7185,7197],[7200,7199,7198],[7198,7201,7200],[7200,7201,7067],[7067,7066,7200],[7200,7066,7065],[7065,7202,7200],[7200,7202,7203],[7203,7199,7200],[7205,7204,7198],[7198,7199,7205],[7205,7199,7203],[7203,7206,7205],[7205,7206,7207],[7207,7208,7205],[7205,7208,7209],[7209,7204,7205],[7211,7210,7198],[7198,7204,7211],[7211,7204,7209],[7209,7212,7211],[7211,7212,7081],[7081,7080,7211],[7211,7080,7077],[7077,7210,7211],[7213,7201,7198],[7198,7210,7213],[7213,7210,7077],[7077,7076,7213],[7213,7076,6935],[6935,7069,7213],[7213,7069,7067],[7067,7201,7213],[7216,7215,7214],[7214,7217,7216],[7216,7217,7091],[7091,7090,7216],[7216,7090,6825],[6825,6956,7216],[7216,6956,6953],[6953,7215,7216],[7219,7218,7214],[7214,7215,7219],[7219,7215,6953],[6953,6952,7219],[7219,6952,6951],[6951,7220,7219],[7219,7220,7221],[7221,7218,7219],[7223,7222,7214],[7214,7218,7223],[7223,7218,7221],[7221,7224,7223],[7223,7224,7225],[7225,7226,7223],[7223,7226,7227],[7227,7222,7223],[7228,7217,7214],[7214,7222,7228],[7228,7222,7227],[7227,7229,7228],[7228,7229,7095],[7095,7094,7228],[7228,7094,7091],[7091,7217,7228],[7232,7231,7230],[7230,7233,7232],[7232,7233,6971],[6971,6970,7232],[7232,6970,6969],[6969,7234,7232],[7232,7234,7235],[7235,7231,7232],[7237,7236,7230],[7230,7231,7237],[7237,7231,7235],[7235,7238,7237],[7237,7238,7239],[7239,7240,7237],[7237,7240,7241],[7241,7236,7237],[7243,7242,7230],[7230,7236,7243],[7243,7236,7241],[7241,7244,7243],[7243,7244,7113],[7113,7112,7243],[7243,7112,7109],[7109,7242,7243],[7245,7233,7230],[7230,7242,7245],[7245,7242,7109],[7109,7108,7245],[7245,7108,6839],[6839,6973,7245],[7245,6973,6971],[6971,7233,7245],[7248,7247,7246],[7246,7249,7248],[7248,7249,7123],[7123,7122,7248],[7248,7122,6857],[6857,6988,7248],[6985,7247,7248],[7248,6988,6985],[7251,7250,7246],[7246,7247,7251],[7251,7247,6985],[6985,6984,7251],[7251,6984,6983],[6983,7252,7251],[7251,7252,7253],[7253,7250,7251],[7255,7254,7246],[7246,7250,7255],[7255,7250,7253],[7253,7256,7255],[7255,7256,7257],[7257,7258,7255],[7255,7258,7259],[7259,7254,7255],[7260,7249,7246],[7246,7254,7260],[7260,7254,7259],[7259,7261,7260],[7260,7261,7127],[7127,7126,7260],[7260,7126,7123],[7123,7249,7260],[7264,7263,7262],[7262,7265,7264],[7264,7265,7003],[7003,7002,7264],[7264,7002,7001],[7001,7266,7264],[7264,7266,7267],[7267,7263,7264],[7269,7268,7262],[7262,7263,7269],[7269,7263,7267],[7267,7270,7269],[7269,7270,7271],[7271,7272,7269],[7269,7272,7273],[7273,7268,7269],[7275,7274,7262],[7262,7268,7275],[7275,7268,7273],[7273,7276,7275],[7275,7276,7145],[7145,7144,7275],[7275,7144,7141],[7141,7274,7275],[7277,7265,7262],[7262,7274,7277],[7277,7274,7141],[7141,7140,7277],[7277,7140,6871],[6871,7005,7277],[7277,7005,7003],[7003,7265,7277],[7280,7279,7278],[7278,7281,7280],[7280,7281,7177],[7177,7176,7280],[7280,7176,7047],[7047,7155,7280],[7280,7155,7154],[7154,7279,7280],[7283,7282,7278],[7278,7279,7283],[7283,7279,7154],[7154,7161,7283],[7283,7161,7015],[7015,7149,7283],[7283,7149,7147],[7147,7282,7283],[7285,7284,7278],[7278,7282,7285],[7285,7282,7147],[7147,7146,7285],[7285,7146,7145],[7145,7286,7285],[7285,7286,7287],[7287,7284,7285],[7288,7281,7278],[7278,7284,7288],[7288,7284,7287],[7287,7289,7288],[7288,7289,7180],[7180,7179,7288],[7288,7179,7177],[7177,7281,7288],[7292,7291,7290],[7290,7293,7292],[7292,7293,7294],[7294,7295,7292],[7292,7295,7168],[7168,7167,7292],[7292,7167,7166],[7166,7291,7292],[7297,7296,7290],[7290,7291,7297],[7297,7291,7166],[7166,7181,7297],[7297,7181,7180],[7180,7298,7297],[7297,7298,7299],[7299,7296,7297],[7301,7300,7290],[7290,7296,7301],[7301,7296,7299],[7299,7302,7301],[7301,7302,7303],[7303,7304,7301],[7301,7304,7305],[7305,7300,7301],[7306,7293,7290],[7290,7300,7306],[7306,7300,7305],[7305,7307,7306],[7306,7307,7308],[7308,7309,7306],[7293,7306,7294],[7309,7294,7306],[7312,7311,7310],[7310,7313,7312],[7312,7313,7187],[7187,7186,7312],[7312,7186,7168],[7168,7295,7312],[7312,7295,7294],[7294,7311,7312],[7315,7314,7310],[7310,7311,7315],[7311,7294,7315],[7309,7315,7294],[7315,7309,7308],[7308,7316,7315],[7315,7316,7317],[7317,7314,7315],[7319,7318,7310],[7310,7314,7319],[7319,7314,7317],[7317,7320,7319],[7319,7320,7321],[7321,7322,7319],[7319,7322,7323],[7323,7318,7319],[7324,7313,7310],[7310,7318,7324],[7324,7318,7323],[7323,7325,7324],[7324,7325,7191],[7191,7190,7324],[7324,7190,7187],[7187,7313,7324],[7328,7327,7326],[7326,7329,7328],[7328,7329,7203],[7203,7202,7328],[7328,7202,7065],[7065,7196,7328],[7328,7196,7193],[7193,7327,7328],[7331,7330,7326],[7326,7327,7331],[7331,7327,7193],[7193,7192,7331],[7331,7192,7191],[7191,7332,7331],[7331,7332,7333],[7333,7330,7331],[7335,7334,7326],[7326,7330,7335],[7335,7330,7333],[7333,7336,7335],[7335,7336,7337],[7337,7338,7335],[7335,7338,7339],[7339,7334,7335],[7340,7329,7326],[7326,7334,7340],[7340,7334,7339],[7339,7341,7340],[7340,7341,7207],[7207,7206,7340],[7340,7206,7203],[7203,7329,7340],[7344,7343,7342],[7342,7345,7344],[7344,7345,7083],[7083,7082,7344],[7344,7082,7081],[7081,7346,7344],[7344,7346,7347],[7347,7343,7344],[7349,7348,7342],[7342,7343,7349],[7349,7343,7347],[7347,7350,7349],[7349,7350,7351],[7351,7352,7349],[7349,7352,7353],[7353,7348,7349],[7355,7354,7342],[7342,7348,7355],[7355,7348,7353],[7353,7356,7355],[7355,7356,7225],[7225,7224,7355],[7355,7224,7221],[7221,7354,7355],[7357,7345,7342],[7342,7354,7357],[7357,7354,7221],[7221,7220,7357],[7357,7220,6951],[6951,7085,7357],[7357,7085,7083],[7083,7345,7357],[7360,7359,7358],[7358,7361,7360],[7360,7361,7235],[7235,7234,7360],[7360,7234,6969],[6969,7100,7360],[7360,7100,7097],[7097,7359,7360],[7363,7362,7358],[7358,7359,7363],[7363,7359,7097],[7097,7096,7363],[7363,7096,7095],[7095,7364,7363],[7363,7364,7365],[7365,7362,7363],[7367,7366,7358],[7358,7362,7367],[7367,7362,7365],[7365,7368,7367],[7367,7368,7369],[7369,7370,7367],[7367,7370,7371],[7371,7366,7367],[7372,7361,7358],[7358,7366,7372],[7372,7366,7371],[7371,7373,7372],[7372,7373,7239],[7239,7238,7372],[7372,7238,7235],[7235,7361,7372],[7376,7375,7374],[7374,7377,7376],[7376,7377,7115],[7115,7114,7376],[7376,7114,7113],[7113,7378,7376],[7376,7378,7379],[7379,7375,7376],[7381,7380,7374],[7374,7375,7381],[7381,7375,7379],[7379,7382,7381],[7381,7382,7383],[7383,7384,7381],[7381,7384,7385],[7385,7380,7381],[7387,7386,7374],[7374,7380,7387],[7387,7380,7385],[7385,7388,7387],[7387,7388,7257],[7257,7256,7387],[7387,7256,7253],[7253,7386,7387],[7389,7377,7374],[7374,7386,7389],[7389,7386,7253],[7253,7252,7389],[7389,7252,6983],[6983,7117,7389],[7389,7117,7115],[7115,7377,7389],[7392,7391,7390],[7390,7393,7392],[7392,7393,7267],[7267,7266,7392],[7392,7266,7001],[7001,7132,7392],[7392,7132,7129],[7129,7391,7392],[7395,7394,7390],[7390,7391,7395],[7395,7391,7129],[7129,7128,7395],[7395,7128,7127],[7127,7396,7395],[7395,7396,7397],[7397,7394,7395],[7399,7398,7390],[7390,7394,7399],[7399,7394,7397],[7397,7400,7399],[7399,7400,7401],[7401,7402,7399],[7399,7402,7403],[7403,7398,7399],[7404,7393,7390],[7390,7398,7404],[7404,7398,7403],[7403,7405,7404],[7404,7405,7271],[7271,7270,7404],[7404,7270,7267],[7267,7393,7404],[7408,7407,7406],[7406,7409,7408],[7408,7409,7410],[7410,7411,7408],[7408,7411,7303],[7303,7302,7408],[7408,7302,7299],[7299,7407,7408],[7413,7412,7406],[7406,7407,7413],[7413,7407,7299],[7299,7298,7413],[7413,7298,7180],[7180,7289,7413],[7413,7289,7287],[7287,7412,7413],[7415,7414,7406],[7406,7412,7415],[7415,7412,7287],[7287,7286,7415],[7415,7286,7145],[7145,7276,7415],[7415,7276,7273],[7273,7414,7415],[7416,7409,7406],[7406,7414,7416],[7416,7414,7273],[7273,7272,7416],[7416,7272,7271],[7271,7417,7416],[7416,7417,7410],[7410,7409,7416],[7420,7419,7418],[7418,7421,7420],[7420,7421,7422],[7422,7423,7420],[7420,7423,7424],[7424,7425,7420],[7420,7425,7426],[7426,7419,7420],[7428,7427,7418],[7418,7419,7428],[7428,7419,7426],[7426,7429,7428],[7428,7429,7308],[7308,7307,7428],[7428,7307,7305],[7305,7427,7428],[7431,7430,7418],[7418,7427,7431],[7431,7427,7305],[7305,7304,7431],[7431,7304,7303],[7303,7432,7431],[7431,7432,7433],[7433,7430,7431],[7434,7421,7418],[7418,7430,7434],[7434,7430,7433],[7433,7435,7434],[7434,7435,7436],[7436,7437,7434],[7434,7437,7422],[7422,7421,7434],[7440,7439,7438],[7438,7441,7440],[7440,7441,7426],[7426,7425,7440],[7440,7425,7424],[7424,7442,7440],[7440,7442,7443],[7443,7439,7440],[7445,7444,7438],[7438,7439,7445],[7445,7439,7443],[7443,7446,7445],[7445,7446,7447],[7447,7448,7445],[7445,7448,7449],[7449,7444,7445],[7451,7450,7438],[7438,7444,7451],[7451,7444,7449],[7449,7452,7451],[7451,7452,7321],[7321,7320,7451],[7451,7320,7317],[7317,7450,7451],[7453,7441,7438],[7438,7450,7453],[7453,7450,7317],[7317,7316,7453],[7453,7316,7308],[7308,7429,7453],[7453,7429,7426],[7426,7441,7453],[7456,7455,7454],[7454,7457,7456],[7456,7457,7323],[7323,7322,7456],[7456,7322,7321],[7321,7458,7456],[7456,7458,7459],[7459,7455,7456],[7461,7460,7454],[7454,7455,7461],[7461,7455,7459],[7459,7462,7461],[7461,7462,7463],[7463,7464,7461],[7461,7464,7465],[7465,7460,7461],[7467,7466,7454],[7454,7460,7467],[7467,7460,7465],[7465,7468,7467],[7467,7468,7337],[7337,7336,7467],[7467,7336,7333],[7333,7466,7467],[7469,7457,7454],[7454,7466,7469],[7469,7466,7333],[7333,7332,7469],[7469,7332,7191],[7191,7325,7469],[7469,7325,7323],[7323,7457,7469],[7472,7471,7470],[7470,7473,7472],[7472,7473,7347],[7347,7346,7472],[7472,7346,7081],[7081,7212,7472],[7472,7212,7209],[7209,7471,7472],[7475,7474,7470],[7470,7471,7475],[7475,7471,7209],[7209,7208,7475],[7475,7208,7207],[7207,7476,7475],[7475,7476,7477],[7477,7474,7475],[7479,7478,7470],[7470,7474,7479],[7479,7474,7477],[7477,7480,7479],[7479,7480,7481],[7481,7482,7479],[7479,7482,7483],[7483,7478,7479],[7484,7473,7470],[7470,7478,7484],[7484,7478,7483],[7483,7485,7484],[7484,7485,7351],[7351,7350,7484],[7484,7350,7347],[7347,7473,7484],[7488,7487,7486],[7486,7489,7488],[7488,7489,7227],[7227,7226,7488],[7488,7226,7225],[7225,7490,7488],[7488,7490,7491],[7491,7487,7488],[7493,7492,7486],[7486,7487,7493],[7493,7487,7491],[7491,7494,7493],[7493,7494,7495],[7495,7496,7493],[7493,7496,7497],[7497,7492,7493],[7499,7498,7486],[7486,7492,7499],[7499,7492,7497],[7497,7500,7499],[7499,7500,7369],[7369,7368,7499],[7499,7368,7365],[7365,7498,7499],[7501,7489,7486],[7486,7498,7501],[7501,7498,7365],[7365,7364,7501],[7501,7364,7095],[7095,7229,7501],[7501,7229,7227],[7227,7489,7501],[7504,7503,7502],[7502,7505,7504],[7504,7505,7379],[7379,7378,7504],[7504,7378,7113],[7113,7244,7504],[7504,7244,7241],[7241,7503,7504],[7507,7506,7502],[7502,7503,7507],[7507,7503,7241],[7241,7240,7507],[7507,7240,7239],[7239,7508,7507],[7507,7508,7509],[7509,7506,7507],[7511,7510,7502],[7502,7506,7511],[7511,7506,7509],[7509,7512,7511],[7511,7512,7513],[7513,7514,7511],[7511,7514,7515],[7515,7510,7511],[7516,7505,7502],[7502,7510,7516],[7516,7510,7515],[7515,7517,7516],[7516,7517,7383],[7383,7382,7516],[7516,7382,7379],[7379,7505,7516],[7520,7519,7518],[7518,7521,7520],[7520,7521,7259],[7259,7258,7520],[7520,7258,7257],[7257,7522,7520],[7520,7522,7523],[7523,7519,7520],[7525,7524,7518],[7518,7519,7525],[7525,7519,7523],[7523,7526,7525],[7525,7526,7527],[7527,7528,7525],[7525,7528,7529],[7529,7524,7525],[7531,7530,7518],[7518,7524,7531],[7531,7524,7529],[7529,7532,7531],[7531,7532,7401],[7401,7400,7531],[7531,7400,7397],[7397,7530,7531],[7533,7521,7518],[7518,7530,7533],[7533,7530,7397],[7397,7396,7533],[7533,7396,7127],[7127,7261,7533],[7533,7261,7259],[7259,7521,7533],[7536,7535,7534],[7534,7537,7536],[7536,7537,7433],[7433,7432,7536],[7536,7432,7303],[7303,7411,7536],[7536,7411,7410],[7410,7535,7536],[7539,7538,7534],[7534,7535,7539],[7539,7535,7410],[7410,7417,7539],[7539,7417,7271],[7271,7405,7539],[7539,7405,7403],[7403,7538,7539],[7541,7540,7534],[7534,7538,7541],[7541,7538,7403],[7403,7402,7541],[7541,7402,7401],[7401,7542,7541],[7541,7542,7543],[7543,7540,7541],[7544,7537,7534],[7534,7540,7544],[7544,7540,7543],[7543,7545,7544],[7544,7545,7436],[7436,7435,7544],[7544,7435,7433],[7433,7537,7544],[7548,7547,7546],[7546,7549,7548],[7548,7549,7550],[7550,7551,7548],[7548,7551,7424],[7424,7423,7548],[7548,7423,7422],[7422,7547,7548],[7553,7552,7546],[7546,7547,7553],[7553,7547,7422],[7422,7437,7553],[7553,7437,7436],[7436,7554,7553],[7553,7554,7555],[7555,7552,7553],[7557,7556,7546],[7546,7552,7557],[7557,7552,7555],[7555,7558,7557],[7557,7558,7559],[7559,7560,7557],[7557,7560,7561],[7561,7556,7557],[7562,7549,7546],[7546,7556,7562],[7562,7556,7561],[7561,7563,7562],[7562,7563,7564],[7564,7565,7562],[7562,7565,7550],[7550,7549,7562],[7568,7567,7566],[7566,7569,7568],[7568,7569,7443],[7443,7442,7568],[7568,7442,7424],[7424,7551,7568],[7568,7551,7550],[7550,7567,7568],[7571,7570,7566],[7566,7567,7571],[7571,7567,7550],[7550,7565,7571],[7571,7565,7564],[7564,7572,7571],[7571,7572,7573],[7573,7570,7571],[7575,7574,7566],[7566,7570,7575],[7575,7570,7573],[7573,7576,7575],[7575,7576,7577],[7577,7578,7575],[7575,7578,7579],[7579,7574,7575],[7580,7569,7566],[7566,7574,7580],[7580,7574,7579],[7579,7581,7580],[7580,7581,7447],[7447,7446,7580],[7580,7446,7443],[7443,7569,7580],[7584,7583,7582],[7582,7585,7584],[7584,7585,7459],[7459,7458,7584],[7584,7458,7321],[7321,7452,7584],[7584,7452,7449],[7449,7583,7584],[7587,7586,7582],[7582,7583,7587],[7587,7583,7449],[7449,7448,7587],[7587,7448,7447],[7447,7588,7587],[7587,7588,7589],[7589,7586,7587],[7591,7590,7582],[7582,7586,7591],[7591,7586,7589],[7589,7592,7591],[7591,7592,7593],[7593,7594,7591],[7591,7594,7595],[7595,7590,7591],[7596,7585,7582],[7582,7590,7596],[7596,7590,7595],[7595,7597,7596],[7596,7597,7463],[7463,7462,7596],[7596,7462,7459],[7459,7585,7596],[7600,7599,7598],[7598,7601,7600],[7600,7601,7339],[7339,7338,7600],[7600,7338,7337],[7337,7602,7600],[7600,7602,7603],[7603,7599,7600],[7605,7604,7598],[7598,7599,7605],[7605,7599,7603],[7603,7606,7605],[7605,7606,7607],[7607,7608,7605],[7605,7608,7609],[7609,7604,7605],[7611,7610,7598],[7598,7604,7611],[7611,7604,7609],[7609,7612,7611],[7611,7612,7481],[7481,7480,7611],[7611,7480,7477],[7477,7610,7611],[7613,7601,7598],[7598,7610,7613],[7613,7610,7477],[7477,7476,7613],[7613,7476,7207],[7207,7341,7613],[7613,7341,7339],[7339,7601,7613],[7616,7615,7614],[7614,7617,7616],[7616,7617,7491],[7491,7490,7616],[7616,7490,7225],[7225,7356,7616],[7616,7356,7353],[7353,7615,7616],[7619,7618,7614],[7614,7615,7619],[7619,7615,7353],[7353,7352,7619],[7619,7352,7351],[7351,7620,7619],[7619,7620,7621],[7621,7618,7619],[7623,7622,7614],[7614,7618,7623],[7623,7618,7621],[7621,7624,7623],[7623,7624,7625],[7625,7626,7623],[7623,7627,7622],[7627,7623,7626],[7628,7617,7614],[7614,7622,7628],[7628,7622,7627],[7627,7629,7628],[7628,7629,7495],[7495,7494,7628],[7628,7494,7491],[7491,7617,7628],[7632,7631,7630],[7630,7633,7632],[7632,7633,7371],[7371,7370,7632],[7632,7370,7369],[7369,7634,7632],[7632,7634,7635],[7635,7631,7632],[7637,7636,7630],[7630,7631,7637],[7637,7631,7635],[7635,7638,7637],[7637,7638,7639],[7639,7640,7637],[7637,7640,7641],[7641,7636,7637],[7643,7642,7630],[7630,7636,7643],[7643,7636,7641],[7641,7644,7643],[7643,7644,7513],[7513,7512,7643],[7643,7512,7509],[7509,7642,7643],[7645,7633,7630],[7630,7642,7645],[7645,7642,7509],[7509,7508,7645],[7645,7508,7239],[7239,7373,7645],[7645,7373,7371],[7371,7633,7645],[7648,7647,7646],[7646,7649,7648],[7648,7649,7523],[7523,7522,7648],[7648,7522,7257],[7257,7388,7648],[7648,7388,7385],[7385,7647,7648],[7651,7650,7646],[7646,7647,7651],[7651,7647,7385],[7385,7384,7651],[7651,7384,7383],[7383,7652,7651],[7651,7652,7653],[7653,7650,7651],[7655,7654,7646],[7646,7650,7655],[7655,7650,7653],[7653,7656,7655],[7655,7656,7657],[7657,7658,7655],[7655,7658,7659],[7659,7654,7655],[7660,7649,7646],[7646,7654,7660],[7660,7654,7659],[7659,7661,7660],[7660,7661,7527],[7527,7526,7660],[7660,7526,7523],[7523,7649,7660],[7664,7663,7662],[7662,7665,7664],[7664,7665,7666],[7666,7667,7664],[7664,7667,7559],[7559,7558,7664],[7664,7558,7555],[7555,7663,7664],[7669,7668,7662],[7662,7663,7669],[7669,7663,7555],[7555,7554,7669],[7669,7554,7436],[7436,7545,7669],[7669,7545,7543],[7543,7668,7669],[7671,7670,7662],[7662,7668,7671],[7671,7668,7543],[7543,7542,7671],[7671,7542,7401],[7401,7532,7671],[7671,7532,7529],[7529,7670,7671],[7672,7665,7662],[7662,7670,7672],[7672,7670,7529],[7529,7528,7672],[7672,7528,7527],[7527,7673,7672],[7672,7673,7666],[7666,7665,7672],[7676,7675,7674],[7674,7677,7676],[7676,7677,7678],[7678,7679,7676],[7676,7679,7680],[7680,7681,7676],[7676,7681,7682],[7682,7675,7676],[7684,7683,7674],[7674,7675,7684],[7675,7682,7684],[7685,7684,7682],[7684,7685,7564],[7564,7563,7684],[7684,7563,7561],[7561,7683,7684],[7687,7686,7674],[7674,7683,7687],[7687,7683,7561],[7561,7560,7687],[7687,7560,7559],[7559,7688,7687],[7687,7688,7689],[7689,7686,7687],[7690,7677,7674],[7674,7686,7690],[7690,7686,7689],[7689,7691,7690],[7690,7691,7692],[7692,7693,7690],[7690,7693,7678],[7678,7677,7690],[7696,7695,7694],[7694,7697,7696],[7696,7697,7682],[7682,7681,7696],[7696,7681,7680],[7680,7698,7696],[7696,7698,7699],[7699,7695,7696],[7701,7700,7694],[7694,7695,7701],[7701,7695,7699],[7699,7702,7701],[7701,7702,7703],[7703,7704,7701],[7701,7704,7705],[7705,7700,7701],[7707,7706,7694],[7694,7700,7707],[7707,7700,7705],[7705,7708,7707],[7707,7708,7577],[7577,7576,7707],[7707,7576,7573],[7573,7706,7707],[7709,7697,7694],[7694,7706,7709],[7709,7706,7573],[7573,7572,7709],[7709,7572,7564],[7564,7685,7709],[7709,7682,7697],[7682,7709,7685],[7712,7711,7710],[7710,7713,7712],[7712,7713,7579],[7579,7578,7712],[7712,7578,7577],[7577,7714,7712],[7712,7714,7715],[7715,7711,7712],[7717,7716,7710],[7710,7711,7717],[7717,7711,7715],[7715,7718,7717],[7717,7718,7719],[7719,7720,7717],[7717,7720,7721],[7721,7716,7717],[7723,7722,7710],[7710,7716,7723],[7723,7716,7721],[7721,7724,7723],[7723,7724,7593],[7593,7592,7723],[7723,7592,7589],[7589,7722,7723],[7725,7713,7710],[7710,7722,7725],[7725,7722,7589],[7589,7588,7725],[7725,7588,7447],[7447,7581,7725],[7725,7581,7579],[7579,7713,7725],[7728,7727,7726],[7726,7729,7728],[7728,7729,7603],[7603,7602,7728],[7728,7602,7337],[7337,7468,7728],[7728,7468,7465],[7465,7727,7728],[7731,7730,7726],[7726,7727,7731],[7731,7727,7465],[7465,7464,7731],[7731,7464,7463],[7463,7732,7731],[7731,7732,7733],[7733,7730,7731],[7735,7734,7726],[7726,7730,7735],[7735,7730,7733],[7733,7736,7735],[7735,7736,7737],[7737,7738,7735],[7735,7738,7739],[7739,7734,7735],[7740,7729,7726],[7726,7734,7740],[7740,7734,7739],[7739,7741,7740],[7740,7741,7607],[7607,7606,7740],[7740,7606,7603],[7603,7729,7740],[7744,7743,7742],[7742,7745,7744],[7744,7745,7483],[7483,7482,7744],[7744,7482,7481],[7481,7746,7744],[7744,7746,7747],[7747,7743,7744],[7749,7748,7742],[7742,7743,7749],[7749,7743,7747],[7747,7750,7749],[7749,7750,7751],[7751,7752,7749],[7749,7752,7753],[7753,7748,7749],[7755,7754,7742],[7742,7748,7755],[7755,7748,7753],[7753,7756,7755],[7755,7756,7625],[7625,7624,7755],[7755,7624,7621],[7621,7754,7755],[7757,7745,7742],[7742,7754,7757],[7757,7754,7621],[7621,7620,7757],[7757,7620,7351],[7351,7485,7757],[7757,7485,7483],[7483,7745,7757],[7760,7759,7758],[7758,7761,7760],[7760,7761,7635],[7635,7634,7760],[7760,7634,7369],[7369,7500,7760],[7760,7500,7497],[7497,7759,7760],[7763,7762,7758],[7758,7759,7763],[7763,7759,7497],[7497,7496,7763],[7763,7496,7495],[7495,7764,7763],[7763,7764,7765],[7765,7762,7763],[7767,7766,7758],[7758,7762,7767],[7767,7762,7765],[7765,7768,7767],[7767,7768,7769],[7769,7770,7767],[7767,7770,7771],[7771,7766,7767],[7772,7761,7758],[7758,7766,7772],[7772,7766,7771],[7771,7773,7772],[7772,7773,7639],[7639,7638,7772],[7772,7638,7635],[7635,7761,7772],[7776,7775,7774],[7774,7777,7776],[7776,7777,7515],[7515,7514,7776],[7776,7514,7513],[7513,7778,7776],[7776,7778,7779],[7779,7775,7776],[7781,7780,7774],[7774,7775,7781],[7781,7775,7779],[7779,7782,7781],[7781,7782,7783],[7783,7784,7781],[7781,7784,7785],[7785,7780,7781],[7787,7786,7774],[7774,7780,7787],[7787,7780,7785],[7785,7788,7787],[7787,7788,7657],[7657,7656,7787],[7787,7656,7653],[7653,7786,7787],[7789,7777,7774],[7774,7786,7789],[7789,7786,7653],[7653,7652,7789],[7789,7652,7383],[7383,7517,7789],[7789,7517,7515],[7515,7777,7789],[7792,7791,7790],[7790,7793,7792],[7792,7793,7689],[7689,7688,7792],[7792,7688,7559],[7559,7667,7792],[7792,7667,7666],[7666,7791,7792],[7795,7794,7790],[7790,7791,7795],[7795,7791,7666],[7666,7673,7795],[7795,7673,7527],[7527,7661,7795],[7795,7661,7659],[7659,7794,7795],[7797,7796,7790],[7790,7794,7797],[7797,7794,7659],[7659,7658,7797],[7797,7658,7657],[7657,7798,7797],[7797,7798,7799],[7799,7796,7797],[7800,7793,7790],[7790,7796,7800],[7800,7796,7799],[7799,7801,7800],[7800,7801,7692],[7692,7691,7800],[7800,7691,7689],[7689,7793,7800],[7804,7803,7802],[7802,7805,7804],[7804,7805,7806],[7806,7807,7804],[7680,7804,7807],[7804,7680,7679],[7804,7679,7678],[7678,7803,7804],[7809,7808,7802],[7802,7803,7809],[7809,7803,7678],[7678,7693,7809],[7809,7693,7692],[7692,7810,7809],[7809,7810,7811],[7811,7808,7809],[7813,7812,7802],[7802,7808,7813],[7813,7808,7811],[7811,7814,7813],[7813,7814,7815],[7815,7816,7813],[7813,7816,7817],[7817,7812,7813],[7818,7805,7802],[7802,7812,7818],[7818,7812,7817],[7817,7819,7818],[7818,7819,7820],[7820,7821,7818],[7818,7821,7806],[7806,7805,7818],[7824,7823,7822],[7822,7825,7824],[7824,7825,7699],[7699,7698,7824],[7807,7824,7680],[7698,7680,7824],[7824,7807,7806],[7806,7823,7824],[7827,7826,7822],[7822,7823,7827],[7827,7823,7806],[7806,7821,7827],[7827,7821,7820],[7820,7828,7827],[7827,7828,7829],[7829,7826,7827],[7831,7830,7822],[7822,7826,7831],[7831,7826,7829],[7829,7832,7831],[7831,7832,7833],[7833,7834,7831],[7831,7834,7835],[7835,7830,7831],[7836,7825,7822],[7822,7830,7836],[7836,7830,7835],[7835,7837,7836],[7836,7837,7703],[7703,7702,7836],[7836,7702,7699],[7699,7825,7836],[7840,7839,7838],[7838,7841,7840],[7840,7841,7715],[7715,7714,7840],[7840,7714,7577],[7577,7708,7840],[7840,7708,7705],[7705,7839,7840],[7843,7842,7838],[7838,7839,7843],[7843,7839,7705],[7705,7704,7843],[7843,7704,7703],[7703,7844,7843],[7843,7844,7845],[7845,7842,7843],[7847,7846,7838],[7838,7842,7847],[7847,7842,7845],[7845,7848,7847],[7847,7848,7849],[7849,7850,7847],[7847,7850,7851],[7851,7846,7847],[7852,7841,7838],[7838,7846,7852],[7852,7846,7851],[7851,7853,7852],[7852,7853,7719],[7719,7718,7852],[7852,7718,7715],[7715,7841,7852],[7856,7855,7854],[7854,7857,7856],[7856,7857,7595],[7595,7594,7856],[7856,7594,7593],[7593,7858,7856],[7856,7858,7859],[7859,7855,7856],[7861,7860,7854],[7854,7855,7861],[7861,7855,7859],[7859,7862,7861],[7861,7862,7863],[7863,7864,7861],[7861,7864,7865],[7865,7860,7861],[7867,7866,7854],[7854,7860,7867],[7867,7860,7865],[7865,7868,7867],[7867,7868,7737],[7737,7736,7867],[7867,7736,7733],[7733,7866,7867],[7869,7857,7854],[7854,7866,7869],[7869,7866,7733],[7733,7732,7869],[7869,7732,7463],[7463,7597,7869],[7869,7597,7595],[7595,7857,7869],[7872,7871,7870],[7870,7873,7872],[7872,7873,7747],[7747,7746,7872],[7872,7746,7481],[7481,7612,7872],[7872,7612,7609],[7609,7871,7872],[7875,7874,7870],[7870,7871,7875],[7875,7871,7609],[7609,7608,7875],[7875,7608,7607],[7607,7876,7875],[7875,7876,7877],[7877,7874,7875],[7879,7878,7870],[7870,7874,7879],[7879,7874,7877],[7877,7880,7879],[7879,7880,7881],[7881,7882,7879],[7883,7879,7882],[7879,7883,7878],[7884,7873,7870],[7870,7878,7884],[7884,7878,7883],[7883,7885,7884],[7884,7885,7751],[7751,7750,7884],[7884,7750,7747],[7747,7873,7884],[7888,7887,7886],[7886,7889,7888],[7627,7626,7888],[7888,7889,7627],[7888,7626,7625],[7625,7890,7888],[7888,7890,7891],[7891,7887,7888],[7893,7892,7886],[7886,7887,7893],[7893,7887,7891],[7891,7894,7893],[7893,7894,7895],[7895,7896,7893],[7893,7896,7897],[7897,7892,7893],[7899,7898,7886],[7886,7892,7899],[7899,7892,7897],[7897,7900,7899],[7899,7900,7769],[7769,7768,7899],[7899,7768,7765],[7765,7898,7899],[7901,7889,7886],[7886,7898,7901],[7901,7898,7765],[7765,7764,7901],[7901,7764,7495],[7495,7629,7901],[7901,7629,7627],[7627,7889,7901],[7904,7903,7902],[7902,7905,7904],[7904,7905,7779],[7779,7778,7904],[7904,7778,7513],[7513,7644,7904],[7904,7644,7641],[7641,7903,7904],[7907,7906,7902],[7902,7903,7907],[7907,7903,7641],[7641,7640,7907],[7907,7640,7639],[7639,7908,7907],[7907,7908,7909],[7909,7906,7907],[7911,7910,7902],[7902,7906,7911],[7911,7906,7909],[7909,7912,7911],[7911,7912,7913],[7913,7914,7911],[7911,7914,7915],[7915,7910,7911],[7916,7905,7902],[7902,7910,7916],[7916,7910,7915],[7915,7917,7916],[7916,7917,7783],[7783,7782,7916],[7916,7782,7779],[7779,7905,7916],[7920,7919,7918],[7918,7921,7920],[7920,7921,7922],[7922,7923,7920],[7920,7923,7815],[7815,7814,7920],[7920,7814,7811],[7811,7919,7920],[7925,7924,7918],[7918,7919,7925],[7925,7919,7811],[7811,7810,7925],[7925,7810,7692],[7692,7801,7925],[7925,7801,7799],[7799,7924,7925],[7927,7926,7918],[7918,7924,7927],[7927,7924,7799],[7799,7798,7927],[7927,7798,7657],[7657,7788,7927],[7927,7788,7785],[7785,7926,7927],[7928,7921,7918],[7918,7926,7928],[7928,7926,7785],[7785,7784,7928],[7928,7784,7783],[7783,7929,7928],[7928,7929,7922],[7922,7921,7928],[7932,7931,7930],[7930,7933,7932],[7932,7933,7934],[7934,7935,7932],[7932,7935,7936],[7936,7937,7932],[7932,7937,7938],[7938,7931,7932],[7940,7939,7930],[7930,7931,7940],[7941,7940,7938],[7931,7938,7940],[7940,7941,7820],[7820,7819,7940],[7940,7819,7817],[7817,7939,7940],[7943,7942,7930],[7930,7939,7943],[7943,7939,7817],[7817,7816,7943],[7943,7816,7815],[7815,7944,7943],[7943,7944,7945],[7945,7942,7943],[7946,7933,7930],[7930,7942,7946],[7946,7942,7945],[7945,7947,7946],[7946,7947,7948],[7948,7949,7946],[7946,7949,7934],[7934,7933,7946],[7952,7951,7950],[7950,7953,7952],[7952,7953,7938],[7938,7937,7952],[7952,7937,7936],[7936,7954,7952],[7952,7954,7955],[7955,7951,7952],[7957,7956,7950],[7950,7951,7957],[7957,7951,7955],[7955,7958,7957],[7957,7958,7959],[7959,7960,7957],[7957,7960,7961],[7961,7956,7957],[7963,7962,7950],[7950,7956,7963],[7963,7956,7961],[7961,7964,7963],[7963,7964,7833],[7833,7832,7963],[7963,7832,7829],[7829,7962,7963],[7965,7953,7950],[7950,7962,7965],[7965,7962,7829],[7829,7828,7965],[7965,7828,7820],[7820,7941,7965],[7965,7941,7938],[7938,7953,7965],[7968,7967,7966],[7966,7969,7968],[7968,7969,7835],[7835,7834,7968],[7968,7834,7833],[7833,7970,7968],[7968,7970,7971],[7971,7967,7968],[7973,7972,7966],[7966,7967,7973],[7973,7967,7971],[7971,7974,7973],[7973,7974,7975],[7975,7976,7973],[7973,7976,7977],[7977,7972,7973],[7979,7978,7966],[7966,7972,7979],[7979,7972,7977],[7977,7980,7979],[7979,7980,7849],[7849,7848,7979],[7979,7848,7845],[7845,7978,7979],[7981,7969,7966],[7966,7978,7981],[7981,7978,7845],[7845,7844,7981],[7981,7844,7703],[7703,7837,7981],[7981,7837,7835],[7835,7969,7981],[7984,7983,7982],[7982,7985,7984],[7984,7985,7859],[7859,7858,7984],[7984,7858,7593],[7593,7724,7984],[7984,7724,7721],[7721,7983,7984],[7987,7986,7982],[7982,7983,7987],[7987,7983,7721],[7721,7720,7987],[7987,7720,7719],[7719,7988,7987],[7987,7988,7989],[7989,7986,7987],[7991,7990,7982],[7982,7986,7991],[7991,7986,7989],[7989,7992,7991],[7991,7992,7993],[7993,7994,7991],[7991,7994,7995],[7995,7990,7991],[7996,7985,7982],[7982,7990,7996],[7996,7990,7995],[7995,7997,7996],[7996,7997,7863],[7863,7862,7996],[7996,7862,7859],[7859,7985,7996],[8000,7999,7998],[7998,8001,8000],[8000,8001,7739],[7739,7738,8000],[8000,7738,7737],[7737,8002,8000],[8000,8002,8003],[8003,7999,8000],[8005,8004,7998],[7998,7999,8005],[8005,7999,8003],[8003,8006,8005],[8007,8005,8006],[8005,8007,8008],[8005,8008,8009],[8009,8004,8005],[8011,8010,7998],[7998,8004,8011],[8011,8004,8009],[8009,8012,8011],[8011,8012,7881],[7881,7880,8011],[8011,7880,7877],[7877,8010,8011],[8013,8001,7998],[7998,8010,8013],[8013,8010,7877],[7877,7876,8013],[8013,7876,7607],[7607,7741,8013],[8013,7741,7739],[7739,8001,8013],[8016,8015,8014],[8014,8017,8016],[8016,8017,7891],[7891,7890,8016],[8016,7890,7625],[7625,7756,8016],[8016,7753,8015],[7753,8016,7756],[8019,8018,8014],[8014,8015,8019],[8019,8015,7753],[7753,7752,8019],[8019,7752,7751],[7751,8020,8019],[8019,8020,8021],[8021,8018,8019],[8023,8022,8014],[8014,8018,8023],[8023,8018,8021],[8021,8024,8023],[8023,8024,8025],[8025,8026,8023],[8023,8026,8027],[8027,8022,8023],[8028,8017,8014],[8014,8022,8028],[8028,8022,8027],[8027,8029,8028],[8028,8029,7895],[7895,7894,8028],[8028,7894,7891],[7891,8017,8028],[8032,8031,8030],[8030,8033,8032],[8032,8033,7771],[7771,7770,8032],[8032,7770,7769],[7769,8034,8032],[8032,8034,8035],[8035,8031,8032],[8037,8036,8030],[8030,8031,8037],[8037,8031,8035],[8035,8038,8037],[8037,8038,8039],[8039,8040,8037],[8037,8040,8041],[8041,8036,8037],[8043,8042,8030],[8030,8036,8043],[8043,8036,8041],[8041,8044,8043],[8043,8044,7913],[7913,7912,8043],[8043,7912,7909],[7909,8042,8043],[8045,8033,8030],[8030,8042,8045],[8045,8042,7909],[7909,7908,8045],[8045,7908,7639],[7639,7773,8045],[8045,7773,7771],[7771,8033,8045],[8048,8047,8046],[8046,8049,8048],[8048,8049,7945],[7945,7944,8048],[8048,7944,7815],[7815,7923,8048],[8048,7923,7922],[7922,8047,8048],[8051,8050,8046],[8046,8047,8051],[8051,8047,7922],[7922,7929,8051],[8051,7929,7783],[7783,7917,8051],[8051,7917,7915],[7915,8050,8051],[8053,8052,8046],[8046,8050,8053],[8053,8050,7915],[7915,7914,8053],[8053,7914,7913],[7913,8054,8053],[8053,8054,8055],[8055,8052,8053],[8056,8049,8046],[8046,8052,8056],[8056,8052,8055],[8055,8057,8056],[8056,8057,7948],[7948,7947,8056],[8056,7947,7945],[7945,8049,8056],[8060,8059,8058],[8058,8061,8060],[8060,8061,8062],[8062,8063,8060],[8060,8063,7936],[7936,7935,8060],[8060,7935,7934],[7934,8059,8060],[8065,8064,8058],[8058,8059,8065],[8065,8059,7934],[7934,7949,8065],[8065,7949,7948],[7948,8066,8065],[8065,8066,8067],[8067,8064,8065],[8069,8068,8058],[8058,8064,8069],[8069,8064,8067],[8067,8070,8069],[8069,8070,8071],[8071,8072,8069],[8069,8072,8073],[8073,8068,8069],[8074,8061,8058],[8058,8068,8074],[8074,8068,8073],[8073,8075,8074],[8074,8075,8076],[8076,8077,8074],[8074,8077,8062],[8062,8061,8074],[8080,8079,8078],[8078,8081,8080],[8080,8081,7955],[7955,7954,8080],[8080,7954,7936],[7936,8063,8080],[8080,8063,8062],[8062,8079,8080],[8083,8082,8078],[8078,8079,8083],[8083,8079,8062],[8062,8077,8083],[8083,8077,8076],[8076,8084,8083],[8083,8084,8085],[8085,8082,8083],[8087,8086,8078],[8078,8082,8087],[8087,8082,8085],[8085,8088,8087],[8087,8088,8089],[8089,8090,8087],[8087,8090,8091],[8091,8086,8087],[8092,8081,8078],[8078,8086,8092],[8092,8086,8091],[8091,8093,8092],[8092,8093,7959],[7959,7958,8092],[8092,7958,7955],[7955,8081,8092],[8096,8095,8094],[8094,8097,8096],[8096,8097,7971],[7971,7970,8096],[8096,7970,7833],[7833,7964,8096],[8096,7964,7961],[7961,8095,8096],[8099,8098,8094],[8094,8095,8099],[8099,8095,7961],[7961,7960,8099],[8099,7960,7959],[7959,8100,8099],[8099,8100,8101],[8101,8098,8099],[8103,8102,8094],[8094,8098,8103],[8103,8098,8101],[8101,8104,8103],[8103,8104,8105],[8105,8106,8103],[8103,8106,8107],[8107,8102,8103],[8108,8097,8094],[8094,8102,8108],[8108,8102,8107],[8107,8109,8108],[8108,8109,7975],[7975,7974,8108],[8108,7974,7971],[7971,8097,8108],[8112,8111,8110],[8110,8113,8112],[8112,8113,7851],[7851,7850,8112],[8112,7850,7849],[7849,8114,8112],[8112,8114,8115],[8115,8111,8112],[8117,8116,8110],[8110,8111,8117],[8117,8111,8115],[8115,8118,8117],[8117,8118,8119],[8119,8120,8117],[8117,8120,8121],[8121,8116,8117],[8123,8122,8110],[8110,8116,8123],[8123,8116,8121],[8121,8124,8123],[8123,8124,7993],[7993,7992,8123],[8123,7992,7989],[7989,8122,8123],[8125,8113,8110],[8110,8122,8125],[8125,8122,7989],[7989,7988,8125],[8125,7988,7719],[7719,7853,8125],[8125,7853,7851],[7851,8113,8125],[8128,8127,8126],[8126,8129,8128],[8128,8129,8003],[8003,8002,8128],[8128,8002,7737],[7737,7868,8128],[8128,7868,7865],[7865,8127,8128],[8131,8130,8126],[8126,8127,8131],[8131,8127,7865],[7865,7864,8131],[8131,7864,7863],[7863,8132,8131],[8131,8132,8133],[8133,8130,8131],[8135,8134,8126],[8126,8130,8135],[8135,8130,8133],[8133,8136,8135],[8135,8136,8137],[8137,8138,8135],[8135,8138,8139],[8139,8134,8135],[8140,8129,8126],[8126,8134,8140],[8140,8134,8139],[8139,8141,8140],[8140,8141,8007],[8007,8006,8140],[8140,8006,8003],[8003,8129,8140],[8144,8143,8142],[8142,8145,8144],[7883,7882,8144],[8144,8145,7883],[8144,7882,7881],[7881,8146,8144],[8144,8146,8147],[8147,8143,8144],[8149,8148,8142],[8142,8143,8149],[8149,8143,8147],[8147,8150,8149],[8149,8150,8151],[8151,8152,8149],[8149,8152,8153],[8153,8148,8149],[8155,8154,8142],[8142,8148,8155],[8155,8148,8153],[8153,8156,8155],[8155,8156,8025],[8025,8024,8155],[8155,8024,8021],[8021,8154,8155],[8157,8145,8142],[8142,8154,8157],[8157,8154,8021],[8021,8020,8157],[8157,8020,7751],[7751,7885,8157],[8157,7885,7883],[7883,8145,8157],[8160,8159,8158],[8158,8161,8160],[8160,8161,8035],[8035,8034,8160],[8160,8034,7769],[7769,7900,8160],[8160,7900,7897],[7897,8159,8160],[8163,8162,8158],[8158,8159,8163],[8163,8159,7897],[7897,7896,8163],[8163,7896,7895],[7895,8164,8163],[8163,8164,8165],[8165,8162,8163],[8167,8166,8158],[8158,8162,8167],[8167,8162,8165],[8165,8168,8167],[8167,8168,8169],[8169,8170,8167],[8167,8170,8171],[8171,8166,8167],[8172,8161,8158],[8158,8166,8172],[8172,8166,8171],[8171,8173,8172],[8172,8173,8039],[8039,8038,8172],[8172,8038,8035],[8035,8161,8172],[8176,8175,8174],[8174,8177,8176],[8176,8177,8178],[8178,8179,8176],[8176,8179,8071],[8071,8070,8176],[8176,8070,8067],[8067,8175,8176],[8181,8180,8174],[8174,8175,8181],[8181,8175,8067],[8067,8066,8181],[8181,8066,7948],[7948,8057,8181],[8181,8057,8055],[8055,8180,8181],[8183,8182,8174],[8174,8180,8183],[8183,8180,8055],[8055,8054,8183],[8183,8054,7913],[7913,8044,8183],[8183,8044,8041],[8041,8182,8183],[8184,8177,8174],[8174,8182,8184],[8184,8182,8041],[8041,8040,8184],[8184,8040,8039],[8039,8185,8184],[8184,8185,8178],[8178,8177,8184],[8188,8187,8186],[8186,8189,8188],[8188,8189,8190],[8190,8191,8188],[8188,8191,8192],[8192,8193,8188],[8193,8194,8188],[8187,8188,8194],[8196,8195,8186],[8186,8187,8196],[8196,8187,8194],[8194,8197,8196],[8196,8197,8076],[8076,8075,8196],[8196,8075,8073],[8073,8195,8196],[8199,8198,8186],[8186,8195,8199],[8199,8195,8073],[8073,8072,8199],[8199,8072,8071],[8071,8200,8199],[8199,8200,8201],[8201,8198,8199],[8202,8189,8186],[8186,8198,8202],[8202,8198,8201],[8201,8203,8202],[8202,8203,8204],[8204,8205,8202],[8202,8205,8190],[8190,8189,8202],[8208,8207,8206],[8206,8209,8208],[8194,8193,8208],[8208,8209,8194],[8210,8208,8192],[8193,8192,8208],[8208,8210,8211],[8211,8207,8208],[8213,8212,8206],[8206,8207,8213],[8213,8207,8211],[8211,8214,8213],[8213,8214,8215],[8215,8216,8213],[8213,8216,8217],[8217,8212,8213],[8219,8218,8206],[8206,8212,8219],[8219,8212,8217],[8217,8220,8219],[8219,8220,8089],[8089,8088,8219],[8219,8088,8085],[8085,8218,8219],[8221,8209,8206],[8206,8218,8221],[8221,8218,8085],[8085,8084,8221],[8221,8084,8076],[8076,8197,8221],[8221,8197,8194],[8194,8209,8221],[8224,8223,8222],[8222,8225,8224],[8224,8225,8091],[8091,8090,8224],[8224,8090,8089],[8089,8226,8224],[8224,8226,8227],[8227,8223,8224],[8229,8228,8222],[8222,8223,8229],[8229,8223,8227],[8227,8230,8229],[8229,8230,8231],[8231,8232,8229],[8229,8232,8233],[8233,8228,8229],[8235,8234,8222],[8222,8228,8235],[8235,8228,8233],[8233,8236,8235],[8235,8236,8105],[8105,8104,8235],[8235,8104,8101],[8101,8234,8235],[8237,8225,8222],[8222,8234,8237],[8237,8234,8101],[8101,8100,8237],[8237,8100,7959],[7959,8093,8237],[8237,8093,8091],[8091,8225,8237],[8240,8239,8238],[8238,8241,8240],[8240,8241,8115],[8115,8114,8240],[8240,8114,7849],[7849,7980,8240],[8240,7980,7977],[7977,8239,8240],[8243,8242,8238],[8238,8239,8243],[8243,8239,7977],[7977,7976,8243],[8243,7976,7975],[7975,8244,8243],[8243,8244,8245],[8245,8242,8243],[8247,8246,8238],[8238,8242,8247],[8247,8242,8245],[8245,8248,8247],[8247,8248,8249],[8249,8250,8247],[8247,8250,8251],[8251,8246,8247],[8252,8241,8238],[8238,8246,8252],[8252,8246,8251],[8251,8253,8252],[8252,8253,8119],[8119,8118,8252],[8252,8118,8115],[8115,8241,8252],[8256,8255,8254],[8254,8257,8256],[8256,8257,7995],[7995,7994,8256],[8256,7994,7993],[7993,8258,8256],[8256,8258,8259],[8259,8255,8256],[8261,8260,8254],[8254,8255,8261],[8261,8255,8259],[8259,8262,8261],[8261,8262,8263],[8263,8264,8261],[8261,8264,8265],[8265,8260,8261],[8267,8266,8254],[8254,8260,8267],[8268,8267,8265],[8260,8265,8267],[8267,8268,8137],[8137,8136,8267],[8267,8136,8133],[8133,8266,8267],[8269,8257,8254],[8254,8266,8269],[8269,8266,8133],[8133,8132,8269],[8269,8132,7863],[7863,7997,8269],[8269,7997,7995],[7995,8257,8269],[8272,8271,8270],[8270,8273,8272],[8272,8273,8147],[8147,8146,8272],[8272,8146,7881],[7881,8012,8272],[8272,8012,8009],[8009,8271,8272],[8275,8274,8270],[8270,8271,8275],[8275,8271,8009],[8009,8008,8275],[8276,8275,8007],[8008,8007,8275],[8275,8276,8277],[8277,8274,8275],[8279,8278,8270],[8270,8274,8279],[8279,8274,8277],[8277,8280,8279],[8279,8280,8281],[8281,8282,8279],[8279,8282,8283],[8283,8278,8279],[8284,8273,8270],[8270,8278,8284],[8284,8278,8283],[8283,8285,8284],[8284,8285,8151],[8151,8150,8284],[8284,8150,8147],[8147,8273,8284],[8288,8287,8286],[8286,8289,8288],[8288,8289,8027],[8027,8026,8288],[8288,8026,8025],[8025,8290,8288],[8288,8290,8291],[8291,8287,8288],[8293,8292,8286],[8286,8287,8293],[8293,8287,8291],[8291,8294,8293],[8293,8294,8295],[8295,8296,8293],[8293,8296,8297],[8297,8292,8293],[8299,8298,8286],[8286,8292,8299],[8299,8292,8297],[8297,8300,8299],[8299,8300,8169],[8169,8168,8299],[8299,8168,8165],[8165,8298,8299],[8301,8289,8286],[8286,8298,8301],[8301,8298,8165],[8165,8164,8301],[8301,8164,7895],[7895,8029,8301],[8301,8029,8027],[8027,8289,8301],[8304,8303,8302],[8302,8305,8304],[8304,8305,8201],[8201,8200,8304],[8304,8200,8071],[8071,8179,8304],[8304,8179,8178],[8178,8303,8304],[8307,8306,8302],[8302,8303,8307],[8307,8303,8178],[8178,8185,8307],[8307,8185,8039],[8039,8173,8307],[8307,8173,8171],[8171,8306,8307],[8309,8308,8302],[8302,8306,8309],[8309,8306,8171],[8171,8170,8309],[8309,8170,8169],[8169,8310,8309],[8309,8310,8311],[8311,8308,8309],[8312,8305,8302],[8302,8308,8312],[8312,8308,8311],[8311,8313,8312],[8312,8313,8204],[8204,8203,8312],[8312,8203,8201],[8201,8305,8312],[8316,8315,8314],[8314,8317,8316],[8316,8317,8318],[8318,8319,8316],[8316,8319,8192],[8192,8191,8316],[8316,8191,8190],[8190,8315,8316],[8321,8320,8314],[8314,8315,8321],[8321,8315,8190],[8190,8205,8321],[8321,8205,8204],[8204,8322,8321],[8321,8322,8323],[8323,8320,8321],[8325,8324,8314],[8314,8320,8325],[8325,8320,8323],[8323,8326,8325],[8325,8326,8327],[8327,8328,8325],[8325,8328,8329],[8329,8324,8325],[8330,8317,8314],[8314,8324,8330],[8330,8324,8329],[8329,8331,8330],[8330,8331,8332],[8332,8333,8330],[8317,8330,8318],[8333,8318,8330],[8336,8335,8334],[8334,8337,8336],[8336,8337,8211],[8211,8210,8336],[8336,8210,8192],[8192,8319,8336],[8336,8319,8318],[8318,8335,8336],[8339,8338,8334],[8334,8335,8339],[8318,8333,8339],[8339,8335,8318],[8339,8333,8332],[8332,8340,8339],[8339,8340,8341],[8341,8338,8339],[8343,8342,8334],[8334,8338,8343],[8343,8338,8341],[8341,8344,8343],[8343,8344,8345],[8345,8346,8343],[8343,8346,8347],[8347,8342,8343],[8348,8337,8334],[8334,8342,8348],[8348,8342,8347],[8347,8349,8348],[8348,8349,8215],[8215,8214,8348],[8348,8214,8211],[8211,8337,8348],[8352,8351,8350],[8350,8353,8352],[8352,8353,8227],[8227,8226,8352],[8352,8226,8089],[8089,8220,8352],[8352,8220,8217],[8217,8351,8352],[8355,8354,8350],[8350,8351,8355],[8355,8351,8217],[8217,8216,8355],[8355,8216,8215],[8215,8356,8355],[8355,8356,8357],[8357,8354,8355],[8359,8358,8350],[8350,8354,8359],[8359,8354,8357],[8357,8360,8359],[8359,8360,8361],[8361,8362,8359],[8359,8362,8363],[8363,8358,8359],[8364,8353,8350],[8350,8358,8364],[8364,8358,8363],[8363,8365,8364],[8364,8365,8231],[8231,8230,8364],[8364,8230,8227],[8227,8353,8364],[8368,8367,8366],[8366,8369,8368],[8368,8369,8107],[8107,8106,8368],[8368,8106,8105],[8105,8370,8368],[8368,8370,8371],[8371,8367,8368],[8373,8372,8366],[8366,8367,8373],[8373,8367,8371],[8371,8374,8373],[8373,8374,8375],[8375,8376,8373],[8373,8376,8377],[8377,8372,8373],[8379,8378,8366],[8366,8372,8379],[8379,8372,8377],[8377,8380,8379],[8379,8380,8249],[8249,8248,8379],[8379,8248,8245],[8245,8378,8379],[8381,8369,8366],[8366,8378,8381],[8381,8378,8245],[8245,8244,8381],[8381,8244,7975],[7975,8109,8381],[8381,8109,8107],[8107,8369,8381],[8384,8383,8382],[8382,8385,8384],[8384,8385,8259],[8259,8258,8384],[8384,8258,7993],[7993,8124,8384],[8384,8124,8121],[8121,8383,8384],[8387,8386,8382],[8382,8383,8387],[8387,8383,8121],[8121,8120,8387],[8387,8120,8119],[8119,8388,8387],[8387,8388,8389],[8389,8386,8387],[8391,8390,8382],[8382,8386,8391],[8391,8386,8389],[8389,8392,8391],[8391,8392,8393],[8393,8394,8391],[8391,8394,8395],[8395,8390,8391],[8396,8385,8382],[8382,8390,8396],[8396,8390,8395],[8395,8397,8396],[8396,8397,8263],[8263,8262,8396],[8396,8262,8259],[8259,8385,8396],[8400,8399,8398],[8398,8401,8400],[8400,8401,8139],[8139,8138,8400],[8400,8138,8137],[8137,8402,8400],[8400,8402,8403],[8403,8399,8400],[8405,8404,8398],[8398,8399,8405],[8405,8399,8403],[8403,8406,8405],[8405,8406,8407],[8407,8408,8405],[8405,8408,8409],[8409,8404,8405],[8411,8410,8398],[8398,8404,8411],[8411,8404,8409],[8409,8412,8411],[8411,8412,8281],[8281,8280,8411],[8411,8280,8277],[8277,8410,8411],[8413,8401,8398],[8398,8410,8413],[8413,8410,8277],[8277,8276,8413],[8413,8276,8007],[8007,8141,8413],[8413,8141,8139],[8139,8401,8413],[8416,8415,8414],[8414,8417,8416],[8416,8417,8291],[8291,8290,8416],[8416,8290,8025],[8025,8156,8416],[8416,8156,8153],[8153,8415,8416],[8419,8418,8414],[8414,8415,8419],[8419,8415,8153],[8153,8152,8419],[8419,8152,8151],[8151,8420,8419],[8419,8420,8421],[8421,8418,8419],[8423,8422,8414],[8414,8418,8423],[8423,8418,8421],[8421,8424,8423],[8423,8424,8425],[8425,8426,8423],[8423,8426,8427],[8427,8422,8423],[8428,8417,8414],[8414,8422,8428],[8428,8422,8427],[8427,8429,8428],[8428,8429,8295],[8295,8294,8428],[8428,8294,8291],[8291,8417,8428],[8432,8431,8430],[8430,8433,8432],[8432,8433,8434],[8434,8435,8432],[8432,8435,8327],[8327,8326,8432],[8432,8326,8323],[8323,8431,8432],[8437,8436,8430],[8430,8431,8437],[8437,8431,8323],[8323,8322,8437],[8437,8322,8204],[8204,8313,8437],[8437,8313,8311],[8311,8436,8437],[8439,8438,8430],[8430,8436,8439],[8439,8436,8311],[8311,8310,8439],[8439,8310,8169],[8169,8300,8439],[8439,8300,8297],[8297,8438,8439],[8440,8433,8430],[8430,8438,8440],[8440,8438,8297],[8297,8296,8440],[8440,8296,8295],[8295,8441,8440],[8440,8441,8434],[8434,8433,8440],[8444,8443,8442],[8442,8445,8444],[8444,8445,8446],[8446,8447,8444],[8444,8447,8448],[8448,8449,8444],[8444,8449,8450],[8450,8443,8444],[8452,8451,8442],[8442,8443,8452],[8452,8443,8450],[8450,8453,8452],[8452,8453,8332],[8332,8331,8452],[8452,8331,8329],[8329,8451,8452],[8455,8454,8442],[8442,8451,8455],[8455,8451,8329],[8329,8328,8455],[8455,8328,8327],[8327,8456,8455],[8455,8456,8457],[8457,8454,8455],[8458,8445,8442],[8442,8454,8458],[8458,8454,8457],[8457,8459,8458],[8458,8459,8460],[8460,8461,8458],[8458,8461,8446],[8446,8445,8458],[8464,8463,8462],[8462,8465,8464],[8464,8465,8450],[8450,8449,8464],[8464,8449,8448],[8448,8466,8464],[8464,8466,8467],[8467,8463,8464],[8469,8468,8462],[8462,8463,8469],[8469,8463,8467],[8467,8470,8469],[8469,8470,8471],[8471,8472,8469],[8469,8472,8473],[8473,8468,8469],[8475,8474,8462],[8462,8468,8475],[8475,8468,8473],[8473,8476,8475],[8475,8476,8345],[8345,8344,8475],[8475,8344,8341],[8341,8474,8475],[8477,8465,8462],[8462,8474,8477],[8477,8474,8341],[8341,8340,8477],[8477,8340,8332],[8332,8453,8477],[8477,8453,8450],[8450,8465,8477],[8480,8479,8478],[8478,8481,8480],[8480,8481,8347],[8347,8346,8480],[8480,8346,8345],[8345,8482,8480],[8480,8482,8483],[8483,8479,8480],[8485,8484,8478],[8478,8479,8485],[8485,8479,8483],[8483,8486,8485],[8485,8486,8487],[8487,8488,8485],[8485,8488,8489],[8489,8484,8485],[8491,8490,8478],[8478,8484,8491],[8491,8484,8489],[8489,8492,8491],[8491,8492,8361],[8361,8360,8491],[8491,8360,8357],[8357,8490,8491],[8493,8481,8478],[8478,8490,8493],[8493,8490,8357],[8357,8356,8493],[8493,8356,8215],[8215,8349,8493],[8493,8349,8347],[8347,8481,8493],[8496,8495,8494],[8494,8497,8496],[8496,8497,8371],[8371,8370,8496],[8496,8370,8105],[8105,8236,8496],[8496,8236,8233],[8233,8495,8496],[8499,8498,8494],[8494,8495,8499],[8499,8495,8233],[8233,8232,8499],[8499,8232,8231],[8231,8500,8499],[8499,8500,8501],[8501,8498,8499],[8503,8502,8494],[8494,8498,8503],[8503,8498,8501],[8501,8504,8503],[8503,8504,8505],[8505,8506,8503],[8503,8506,8507],[8507,8502,8503],[8508,8497,8494],[8494,8502,8508],[8508,8502,8507],[8507,8509,8508],[8508,8509,8375],[8375,8374,8508],[8508,8374,8371],[8371,8497,8508],[8512,8511,8510],[8510,8513,8512],[8512,8513,8251],[8251,8250,8512],[8512,8250,8249],[8249,8514,8512],[8512,8514,8515],[8515,8511,8512],[8517,8516,8510],[8510,8511,8517],[8517,8511,8515],[8515,8518,8517],[8517,8518,8519],[8519,8520,8517],[8517,8520,8521],[8521,8516,8517],[8523,8522,8510],[8510,8516,8523],[8524,8523,8521],[8516,8521,8523],[8523,8524,8393],[8393,8392,8523],[8523,8392,8389],[8389,8522,8523],[8525,8513,8510],[8510,8522,8525],[8525,8522,8389],[8389,8388,8525],[8525,8388,8119],[8119,8253,8525],[8525,8253,8251],[8251,8513,8525],[8528,8527,8526],[8526,8529,8528],[8528,8529,8403],[8403,8402,8528],[8528,8402,8137],[8137,8268,8528],[8265,8527,8528],[8528,8268,8265],[8531,8530,8526],[8526,8527,8531],[8531,8527,8265],[8265,8264,8531],[8531,8264,8263],[8263,8532,8531],[8531,8532,8533],[8533,8530,8531],[8535,8534,8526],[8526,8530,8535],[8535,8530,8533],[8533,8536,8535],[8535,8536,8537],[8537,8538,8535],[8535,8538,8539],[8539,8534,8535],[8540,8529,8526],[8526,8534,8540],[8540,8534,8539],[8539,8541,8540],[8540,8541,8407],[8407,8406,8540],[8540,8406,8403],[8403,8529,8540],[8544,8543,8542],[8542,8545,8544],[8544,8545,8283],[8283,8282,8544],[8544,8282,8281],[8281,8546,8544],[8544,8546,8547],[8547,8543,8544],[8549,8548,8542],[8542,8543,8549],[8549,8543,8547],[8547,8550,8549],[8549,8550,8551],[8551,8552,8549],[8549,8552,8553],[8553,8548,8549],[8555,8554,8542],[8542,8548,8555],[8555,8548,8553],[8553,8556,8555],[8555,8556,8425],[8425,8424,8555],[8555,8424,8421],[8421,8554,8555],[8557,8545,8542],[8542,8554,8557],[8557,8554,8421],[8421,8420,8557],[8557,8420,8151],[8151,8285,8557],[8557,8285,8283],[8283,8545,8557],[8560,8559,8558],[8558,8561,8560],[8560,8561,8457],[8457,8456,8560],[8560,8456,8327],[8327,8435,8560],[8560,8435,8434],[8434,8559,8560],[8563,8562,8558],[8558,8559,8563],[8563,8559,8434],[8434,8441,8563],[8563,8441,8295],[8295,8429,8563],[8563,8429,8427],[8427,8562,8563],[8565,8564,8558],[8558,8562,8565],[8565,8562,8427],[8427,8426,8565],[8565,8426,8425],[8425,8566,8565],[8565,8566,8567],[8567,8564,8565],[8568,8561,8558],[8558,8564,8568],[8568,8564,8567],[8567,8569,8568],[8568,8569,8460],[8460,8459,8568],[8568,8459,8457],[8457,8561,8568],[8572,8571,8570],[8570,8573,8572],[8572,8573,8574],[8574,8575,8572],[8572,8575,8448],[8448,8447,8572],[8572,8447,8446],[8446,8571,8572],[8577,8576,8570],[8570,8571,8577],[8577,8571,8446],[8446,8461,8577],[8577,8461,8460],[8460,8578,8577],[8577,8578,8579],[8579,8576,8577],[8581,8580,8570],[8570,8576,8581],[8581,8576,8579],[8579,8582,8581],[8581,8582,8583],[8583,8584,8581],[8581,8584,8585],[8585,8580,8581],[8586,8573,8570],[8570,8580,8586],[8586,8580,8585],[8585,8587,8586],[8586,8587,8588],[8588,8589,8586],[8589,8574,8586],[8573,8586,8574],[8592,8591,8590],[8590,8593,8592],[8592,8593,8467],[8467,8466,8592],[8592,8466,8448],[8448,8575,8592],[8592,8575,8574],[8574,8591,8592],[8595,8594,8590],[8590,8591,8595],[8589,8595,8574],[8591,8574,8595],[8595,8589,8588],[8588,8596,8595],[8595,8596,8597],[8597,8594,8595],[8599,8598,8590],[8590,8594,8599],[8599,8594,8597],[8597,8600,8599],[8599,8600,8601],[8601,8602,8599],[8599,8602,8603],[8603,8598,8599],[8604,8593,8590],[8590,8598,8604],[8604,8598,8603],[8603,8605,8604],[8604,8605,8471],[8471,8470,8604],[8604,8470,8467],[8467,8593,8604],[8608,8607,8606],[8606,8609,8608],[8608,8609,8483],[8483,8482,8608],[8608,8482,8345],[8345,8476,8608],[8608,8476,8473],[8473,8607,8608],[8611,8610,8606],[8606,8607,8611],[8611,8607,8473],[8473,8472,8611],[8611,8472,8471],[8471,8612,8611],[8611,8612,8613],[8613,8610,8611],[8615,8614,8606],[8606,8610,8615],[8615,8610,8613],[8613,8616,8615],[8615,8616,8617],[8617,8618,8615],[8615,8618,8619],[8619,8614,8615],[8620,8609,8606],[8606,8614,8620],[8620,8614,8619],[8619,8621,8620],[8620,8621,8487],[8487,8486,8620],[8620,8486,8483],[8483,8609,8620],[8624,8623,8622],[8622,8625,8624],[8624,8625,8363],[8363,8362,8624],[8624,8362,8361],[8361,8626,8624],[8624,8626,8627],[8627,8623,8624],[8629,8628,8622],[8622,8623,8629],[8629,8623,8627],[8627,8630,8629],[8629,8630,8631],[8631,8632,8629],[8629,8632,8633],[8633,8628,8629],[8635,8634,8622],[8622,8628,8635],[8635,8628,8633],[8633,8636,8635],[8635,8636,8505],[8505,8504,8635],[8635,8504,8501],[8501,8634,8635],[8637,8625,8622],[8622,8634,8637],[8637,8634,8501],[8501,8500,8637],[8637,8500,8231],[8231,8365,8637],[8637,8365,8363],[8363,8625,8637],[8640,8639,8638],[8638,8641,8640],[8640,8641,8515],[8515,8514,8640],[8640,8514,8249],[8249,8380,8640],[8640,8380,8377],[8377,8639,8640],[8643,8642,8638],[8638,8639,8643],[8643,8639,8377],[8377,8376,8643],[8643,8376,8375],[8375,8644,8643],[8643,8644,8645],[8645,8642,8643],[8647,8646,8638],[8638,8642,8647],[8647,8642,8645],[8645,8648,8647],[8647,8648,8649],[8649,8650,8647],[8647,8650,8651],[8651,8646,8647],[8652,8641,8638],[8638,8646,8652],[8652,8646,8651],[8651,8653,8652],[8652,8653,8519],[8519,8518,8652],[8652,8518,8515],[8515,8641,8652],[8656,8655,8654],[8654,8657,8656],[8656,8657,8395],[8395,8394,8656],[8656,8394,8393],[8393,8658,8656],[8656,8658,8659],[8659,8655,8656],[8661,8660,8654],[8654,8655,8661],[8661,8655,8659],[8659,8662,8661],[8661,8662,8663],[8663,8664,8661],[8661,8664,8665],[8665,8660,8661],[8667,8666,8654],[8654,8660,8667],[8667,8660,8665],[8665,8668,8667],[8667,8668,8537],[8537,8536,8667],[8667,8536,8533],[8533,8666,8667],[8669,8657,8654],[8654,8666,8669],[8669,8666,8533],[8533,8532,8669],[8669,8532,8263],[8263,8397,8669],[8669,8397,8395],[8395,8657,8669],[8672,8671,8670],[8670,8673,8672],[8672,8673,8547],[8547,8546,8672],[8672,8546,8281],[8281,8412,8672],[8672,8412,8409],[8409,8671,8672],[8675,8674,8670],[8670,8671,8675],[8675,8671,8409],[8409,8408,8675],[8675,8408,8407],[8407,8676,8675],[8675,8676,8677],[8677,8674,8675],[8679,8678,8670],[8670,8674,8679],[8679,8674,8677],[8677,8680,8679],[8679,8680,8681],[8681,8682,8679],[8679,8682,8683],[8683,8678,8679],[8684,8673,8670],[8670,8678,8684],[8684,8678,8683],[8683,8685,8684],[8684,8685,8551],[8551,8550,8684],[8684,8550,8547],[8547,8673,8684],[8688,8687,8686],[8686,8689,8688],[8688,8689,8690],[8690,8691,8688],[8688,8691,8583],[8583,8582,8688],[8688,8582,8579],[8579,8687,8688],[8693,8692,8686],[8686,8687,8693],[8693,8687,8579],[8579,8578,8693],[8693,8578,8460],[8460,8569,8693],[8693,8569,8567],[8567,8692,8693],[8695,8694,8686],[8686,8692,8695],[8695,8692,8567],[8567,8566,8695],[8695,8566,8425],[8425,8556,8695],[8695,8556,8553],[8553,8694,8695],[8696,8689,8686],[8686,8694,8696],[8696,8694,8553],[8553,8552,8696],[8696,8552,8551],[8551,8697,8696],[8696,8697,8690],[8690,8689,8696],[8700,8699,8698],[8698,8701,8700],[8700,8701,8702],[8702,8703,8700],[8700,8703,8704],[8704,8705,8700],[8700,8705,8706],[8706,8699,8700],[8708,8707,8698],[8698,8699,8708],[8708,8699,8706],[8706,8709,8708],[8708,8709,8588],[8588,8587,8708],[8708,8587,8585],[8585,8707,8708],[8711,8710,8698],[8698,8707,8711],[8711,8707,8585],[8585,8584,8711],[8711,8584,8583],[8583,8712,8711],[8711,8712,8713],[8713,8710,8711],[8714,8701,8698],[8698,8710,8714],[8714,8710,8713],[8713,8715,8714],[8714,8715,8716],[8716,8717,8714],[8714,8717,8702],[8702,8701,8714],[8720,8719,8718],[8718,8721,8720],[8720,8721,8706],[8706,8705,8720],[8720,8705,8704],[8704,8722,8720],[8720,8722,8723],[8723,8719,8720],[8725,8724,8718],[8718,8719,8725],[8725,8719,8723],[8723,8726,8725],[8725,8726,8727],[8727,8728,8725],[8725,8728,8729],[8729,8724,8725],[8731,8730,8718],[8718,8724,8731],[8731,8724,8729],[8729,8732,8731],[8731,8732,8601],[8601,8600,8731],[8731,8600,8597],[8597,8730,8731],[8733,8721,8718],[8718,8730,8733],[8733,8730,8597],[8597,8596,8733],[8733,8596,8588],[8588,8709,8733],[8733,8709,8706],[8706,8721,8733],[8736,8735,8734],[8734,8737,8736],[8736,8737,8603],[8603,8602,8736],[8736,8602,8601],[8601,8738,8736],[8736,8738,8739],[8739,8735,8736],[8741,8740,8734],[8734,8735,8741],[8741,8735,8739],[8739,8742,8741],[8741,8742,8743],[8743,8744,8741],[8741,8744,8745],[8745,8740,8741],[8747,8746,8734],[8734,8740,8747],[8747,8740,8745],[8745,8748,8747],[8747,8748,8617],[8617,8616,8747],[8747,8616,8613],[8613,8746,8747],[8749,8737,8734],[8734,8746,8749],[8749,8746,8613],[8613,8612,8749],[8749,8612,8471],[8471,8605,8749],[8749,8605,8603],[8603,8737,8749],[8752,8751,8750],[8750,8753,8752],[8752,8753,8627],[8627,8626,8752],[8752,8626,8361],[8361,8492,8752],[8752,8492,8489],[8489,8751,8752],[8755,8754,8750],[8750,8751,8755],[8755,8751,8489],[8489,8488,8755],[8755,8488,8487],[8487,8756,8755],[8755,8756,8757],[8757,8754,8755],[8759,8758,8750],[8750,8754,8759],[8759,8754,8757],[8757,8760,8759],[8759,8760,8761],[8761,8762,8759],[8759,8762,8763],[8763,8758,8759],[8764,8753,8750],[8750,8758,8764],[8764,8758,8763],[8763,8765,8764],[8764,8765,8631],[8631,8630,8764],[8764,8630,8627],[8627,8753,8764],[8768,8767,8766],[8766,8769,8768],[8768,8769,8507],[8507,8506,8768],[8768,8506,8505],[8505,8770,8768],[8768,8770,8771],[8771,8767,8768],[8773,8772,8766],[8766,8767,8773],[8773,8767,8771],[8771,8774,8773],[8773,8774,8775],[8775,8776,8773],[8773,8776,8777],[8777,8772,8773],[8779,8778,8766],[8766,8772,8779],[8779,8772,8777],[8777,8780,8779],[8779,8780,8649],[8649,8648,8779],[8779,8648,8645],[8645,8778,8779],[8781,8769,8766],[8766,8778,8781],[8781,8778,8645],[8645,8644,8781],[8781,8644,8375],[8375,8509,8781],[8781,8509,8507],[8507,8769,8781],[8784,8783,8782],[8782,8785,8784],[8784,8785,8659],[8659,8658,8784],[8784,8658,8393],[8393,8524,8784],[8521,8783,8784],[8784,8524,8521],[8787,8786,8782],[8782,8783,8787],[8787,8783,8521],[8521,8520,8787],[8787,8520,8519],[8519,8788,8787],[8787,8788,8789],[8789,8786,8787],[8791,8790,8782],[8782,8786,8791],[8791,8786,8789],[8789,8792,8791],[8791,8792,8793],[8793,8794,8791],[8791,8794,8795],[8795,8790,8791],[8796,8785,8782],[8782,8790,8796],[8796,8790,8795],[8795,8797,8796],[8796,8797,8663],[8663,8662,8796],[8796,8662,8659],[8659,8785,8796],[8800,8799,8798],[8798,8801,8800],[8800,8801,8539],[8539,8538,8800],[8800,8538,8537],[8537,8802,8800],[8800,8802,8803],[8803,8799,8800],[8805,8804,8798],[8798,8799,8805],[8805,8799,8803],[8803,8806,8805],[8805,8806,8807],[8807,8808,8805],[8805,8808,8809],[8809,8804,8805],[8811,8810,8798],[8798,8804,8811],[8811,8804,8809],[8809,8812,8811],[8811,8812,8681],[8681,8680,8811],[8811,8680,8677],[8677,8810,8811],[8813,8801,8798],[8798,8810,8813],[8813,8810,8677],[8677,8676,8813],[8813,8676,8407],[8407,8541,8813],[8813,8541,8539],[8539,8801,8813],[8816,8815,8814],[8814,8817,8816],[8816,8817,8713],[8713,8712,8816],[8816,8712,8583],[8583,8691,8816],[8816,8691,8690],[8690,8815,8816],[8819,8818,8814],[8814,8815,8819],[8819,8815,8690],[8690,8697,8819],[8819,8697,8551],[8551,8685,8819],[8819,8685,8683],[8683,8818,8819],[8821,8820,8814],[8814,8818,8821],[8821,8818,8683],[8683,8682,8821],[8821,8682,8681],[8681,8822,8821],[8821,8822,8823],[8823,8820,8821],[8824,8817,8814],[8814,8820,8824],[8824,8820,8823],[8823,8825,8824],[8824,8825,8716],[8716,8715,8824],[8824,8715,8713],[8713,8817,8824],[8828,8827,8826],[8826,8829,8828],[8828,8829,8830],[8830,8831,8828],[8828,8831,8704],[8704,8703,8828],[8828,8703,8702],[8702,8827,8828],[8833,8832,8826],[8826,8827,8833],[8833,8827,8702],[8702,8717,8833],[8833,8717,8716],[8716,8834,8833],[8833,8834,8835],[8835,8832,8833],[8837,8836,8826],[8826,8832,8837],[8837,8832,8835],[8835,8838,8837],[8837,8838,8839],[8839,8840,8837],[8837,8840,8841],[8841,8836,8837],[8842,8829,8826],[8826,8836,8842],[8842,8836,8841],[8841,8843,8842],[8842,8843,8844],[8844,8845,8842],[8842,8830,8829],[8830,8842,8845],[8848,8847,8846],[8846,8849,8848],[8848,8849,8723],[8723,8722,8848],[8848,8722,8704],[8704,8831,8848],[8848,8831,8830],[8830,8847,8848],[8851,8850,8846],[8846,8847,8851],[8845,8851,8830],[8847,8830,8851],[8851,8845,8844],[8844,8852,8851],[8851,8852,8853],[8853,8850,8851],[8855,8854,8846],[8846,8850,8855],[8855,8850,8853],[8853,8856,8855],[8855,8856,8857],[8857,8858,8855],[8855,8858,8859],[8859,8854,8855],[8860,8849,8846],[8846,8854,8860],[8860,8854,8859],[8859,8861,8860],[8860,8861,8727],[8727,8726,8860],[8860,8726,8723],[8723,8849,8860],[8864,8863,8862],[8862,8865,8864],[8864,8865,8739],[8739,8738,8864],[8864,8738,8601],[8601,8732,8864],[8864,8732,8729],[8729,8863,8864],[8867,8866,8862],[8862,8863,8867],[8867,8863,8729],[8729,8728,8867],[8867,8728,8727],[8727,8868,8867],[8867,8868,8869],[8869,8866,8867],[8871,8870,8862],[8862,8866,8871],[8871,8866,8869],[8869,8872,8871],[8871,8872,8873],[8873,8874,8871],[8871,8874,8875],[8875,8870,8871],[8876,8865,8862],[8862,8870,8876],[8876,8870,8875],[8875,8877,8876],[8876,8877,8743],[8743,8742,8876],[8876,8742,8739],[8739,8865,8876],[8880,8879,8878],[8878,8881,8880],[8880,8881,8619],[8619,8618,8880],[8880,8618,8617],[8617,8882,8880],[8880,8882,8883],[8883,8879,8880],[8885,8884,8878],[8878,8879,8885],[8885,8879,8883],[8883,8886,8885],[8885,8886,8887],[8887,8888,8885],[8885,8888,8889],[8889,8884,8885],[8891,8890,8878],[8878,8884,8891],[8891,8884,8889],[8889,8892,8891],[8891,8892,8761],[8761,8760,8891],[8891,8760,8757],[8757,8890,8891],[8893,8881,8878],[8878,8890,8893],[8893,8890,8757],[8757,8756,8893],[8893,8756,8487],[8487,8621,8893],[8893,8621,8619],[8619,8881,8893],[8896,8895,8894],[8894,8897,8896],[8896,8897,8771],[8771,8770,8896],[8896,8770,8505],[8505,8636,8896],[8896,8636,8633],[8633,8895,8896],[8899,8898,8894],[8894,8895,8899],[8899,8895,8633],[8633,8632,8899],[8899,8632,8631],[8631,8900,8899],[8899,8900,8901],[8901,8898,8899],[8903,8902,8894],[8894,8898,8903],[8903,8898,8901],[8901,8904,8903],[8903,8904,8905],[8905,8906,8903],[8903,8907,8902],[8907,8903,8906],[8908,8897,8894],[8894,8902,8908],[8908,8902,8907],[8907,8909,8908],[8908,8909,8775],[8775,8774,8908],[8908,8774,8771],[8771,8897,8908],[8912,8911,8910],[8910,8913,8912],[8912,8913,8651],[8651,8650,8912],[8912,8650,8649],[8649,8914,8912],[8912,8914,8915],[8915,8911,8912],[8917,8916,8910],[8910,8911,8917],[8917,8911,8915],[8915,8918,8917],[8917,8918,8919],[8919,8920,8917],[8917,8920,8921],[8921,8916,8917],[8923,8922,8910],[8910,8916,8923],[8923,8916,8921],[8921,8924,8923],[8923,8924,8793],[8793,8792,8923],[8923,8792,8789],[8789,8922,8923],[8925,8913,8910],[8910,8922,8925],[8925,8922,8789],[8789,8788,8925],[8925,8788,8519],[8519,8653,8925],[8925,8653,8651],[8651,8913,8925],[8928,8927,8926],[8926,8929,8928],[8928,8929,8803],[8803,8802,8928],[8928,8802,8537],[8537,8668,8928],[8928,8668,8665],[8665,8927,8928],[8931,8930,8926],[8926,8927,8931],[8931,8927,8665],[8665,8664,8931],[8931,8664,8663],[8663,8932,8931],[8931,8932,8933],[8933,8930,8931],[8935,8934,8926],[8926,8930,8935],[8935,8930,8933],[8933,8936,8935],[8935,8936,8937],[8937,8938,8935],[8935,8938,8939],[8939,8934,8935],[8940,8929,8926],[8926,8934,8940],[8940,8934,8939],[8939,8941,8940],[8940,8941,8807],[8807,8806,8940],[8940,8806,8803],[8803,8929,8940],[8944,8943,8942],[8942,8945,8944],[8944,8945,8946],[8946,8947,8944],[8944,8947,8839],[8839,8838,8944],[8944,8838,8835],[8835,8943,8944],[8949,8948,8942],[8942,8943,8949],[8949,8943,8835],[8835,8834,8949],[8949,8834,8716],[8716,8825,8949],[8949,8825,8823],[8823,8948,8949],[8951,8950,8942],[8942,8948,8951],[8951,8948,8823],[8823,8822,8951],[8951,8822,8681],[8681,8812,8951],[8951,8812,8809],[8809,8950,8951],[8952,8945,8942],[8942,8950,8952],[8952,8950,8809],[8809,8808,8952],[8952,8808,8807],[8807,8953,8952],[8952,8953,8946],[8946,8945,8952],[8956,8955,8954],[8954,8957,8956],[8956,8957,8958],[8958,8959,8956],[8956,8959,8960],[8960,8961,8956],[8956,8961,8962],[8962,8955,8956],[8964,8963,8954],[8954,8955,8964],[8965,8964,8962],[8955,8962,8964],[8964,8965,8844],[8844,8843,8964],[8964,8843,8841],[8841,8963,8964],[8967,8966,8954],[8954,8963,8967],[8967,8963,8841],[8841,8840,8967],[8967,8840,8839],[8839,8968,8967],[8967,8968,8969],[8969,8966,8967],[8970,8957,8954],[8954,8966,8970],[8970,8966,8969],[8969,8971,8970],[8970,8971,8972],[8972,8973,8970],[8970,8973,8958],[8958,8957,8970],[8976,8975,8974],[8974,8977,8976],[8976,8977,8962],[8962,8961,8976],[8976,8961,8960],[8960,8978,8976],[8976,8978,8979],[8979,8975,8976],[8981,8980,8974],[8974,8975,8981],[8981,8975,8979],[8979,8982,8981],[8981,8982,8983],[8983,8984,8981],[8981,8984,8985],[8985,8980,8981],[8987,8986,8974],[8974,8980,8987],[8987,8980,8985],[8985,8988,8987],[8987,8988,8857],[8857,8856,8987],[8987,8856,8853],[8853,8986,8987],[8989,8977,8974],[8974,8986,8989],[8989,8986,8853],[8853,8852,8989],[8989,8852,8844],[8844,8965,8989],[8962,8989,8965],[8989,8962,8977],[8992,8991,8990],[8990,8993,8992],[8992,8993,8859],[8859,8858,8992],[8992,8858,8857],[8857,8994,8992],[8992,8994,8995],[8995,8991,8992],[8997,8996,8990],[8990,8991,8997],[8997,8991,8995],[8995,8998,8997],[8997,8998,8999],[8999,9000,8997],[8997,9000,9001],[9001,8996,8997],[9003,9002,8990],[8990,8996,9003],[9003,8996,9001],[9001,9004,9003],[9003,9004,8873],[8873,8872,9003],[9003,8872,8869],[8869,9002,9003],[9005,8993,8990],[8990,9002,9005],[9005,9002,8869],[8869,8868,9005],[9005,8868,8727],[8727,8861,9005],[9005,8861,8859],[8859,8993,9005],[9008,9007,9006],[9006,9009,9008],[9008,9009,8883],[8883,8882,9008],[9008,8882,8617],[8617,8748,9008],[9008,8748,8745],[8745,9007,9008],[9011,9010,9006],[9006,9007,9011],[9011,9007,8745],[8745,8744,9011],[9011,8744,8743],[8743,9012,9011],[9011,9012,9013],[9013,9010,9011],[9015,9014,9006],[9006,9010,9015],[9015,9010,9013],[9013,9016,9015],[9015,9016,9017],[9017,9018,9015],[9015,9018,9019],[9019,9014,9015],[9020,9009,9006],[9006,9014,9020],[9020,9014,9019],[9019,9021,9020],[9020,9021,8887],[8887,8886,9020],[9020,8886,8883],[8883,9009,9020],[9024,9023,9022],[9022,9025,9024],[9024,9025,8763],[8763,8762,9024],[9024,8762,8761],[8761,9026,9024],[9024,9026,9027],[9027,9023,9024],[9029,9028,9022],[9022,9023,9029],[9029,9023,9027],[9027,9030,9029],[9029,9030,9031],[9031,9032,9029],[9029,9032,9033],[9033,9028,9029],[9035,9034,9022],[9022,9028,9035],[9035,9028,9033],[9033,9036,9035],[9035,9036,8905],[8905,8904,9035],[9035,8904,8901],[8901,9034,9035],[9037,9025,9022],[9022,9034,9037],[9037,9034,8901],[8901,8900,9037],[9037,8900,8631],[8631,8765,9037],[9037,8765,8763],[8763,9025,9037],[9040,9039,9038],[9038,9041,9040],[9040,9041,8915],[8915,8914,9040],[9040,8914,8649],[8649,8780,9040],[9040,8780,8777],[8777,9039,9040],[9043,9042,9038],[9038,9039,9043],[9043,9039,8777],[8777,8776,9043],[9043,8776,8775],[8775,9044,9043],[9043,9044,9045],[9045,9042,9043],[9047,9046,9038],[9038,9042,9047],[9047,9042,9045],[9045,9048,9047],[9047,9048,9049],[9049,9050,9047],[9047,9050,9051],[9051,9046,9047],[9052,9041,9038],[9038,9046,9052],[9052,9046,9051],[9051,9053,9052],[9052,9053,8919],[8919,8918,9052],[9052,8918,8915],[8915,9041,9052],[9056,9055,9054],[9054,9057,9056],[9056,9057,8795],[8795,8794,9056],[9056,8794,8793],[8793,9058,9056],[9056,9058,9059],[9059,9055,9056],[9061,9060,9054],[9054,9055,9061],[9061,9055,9059],[9059,9062,9061],[9061,9062,9063],[9063,9064,9061],[9061,9064,9065],[9065,9060,9061],[9067,9066,9054],[9054,9060,9067],[9067,9060,9065],[9065,9068,9067],[9067,9068,8937],[8937,8936,9067],[9067,8936,8933],[8933,9066,9067],[9069,9057,9054],[9054,9066,9069],[9069,9066,8933],[8933,8932,9069],[9069,8932,8663],[8663,8797,9069],[9069,8797,8795],[8795,9057,9069],[9072,9071,9070],[9070,9073,9072],[9072,9073,8969],[8969,8968,9072],[9072,8968,8839],[8839,8947,9072],[9072,8947,8946],[8946,9071,9072],[9075,9074,9070],[9070,9071,9075],[9075,9071,8946],[8946,8953,9075],[9075,8953,8807],[8807,8941,9075],[9075,8941,8939],[8939,9074,9075],[9077,9076,9070],[9070,9074,9077],[9077,9074,8939],[8939,8938,9077],[9077,8938,8937],[8937,9078,9077],[9077,9078,9079],[9079,9076,9077],[9080,9073,9070],[9070,9076,9080],[9080,9076,9079],[9079,9081,9080],[9080,9081,8972],[8972,8971,9080],[9080,8971,8969],[8969,9073,9080],[9084,9083,9082],[9082,9085,9084],[9084,9085,9086],[9086,9087,9084],[9084,8960,8959],[8960,9084,9087],[9084,8959,8958],[8958,9083,9084],[9089,9088,9082],[9082,9083,9089],[9089,9083,8958],[8958,8973,9089],[9089,8973,8972],[8972,9090,9089],[9089,9090,9091],[9091,9088,9089],[9093,9092,9082],[9082,9088,9093],[9093,9088,9091],[9091,9094,9093],[9093,9094,9095],[9095,9096,9093],[9093,9096,9097],[9097,9092,9093],[9098,9085,9082],[9082,9092,9098],[9098,9092,9097],[9097,9099,9098],[9098,9099,9100],[9100,9101,9098],[9098,9101,9086],[9086,9085,9098],[9104,9103,9102],[9102,9105,9104],[9104,9105,8979],[8979,8978,9104],[9087,9104,8960],[8978,8960,9104],[9104,9087,9086],[9086,9103,9104],[9107,9106,9102],[9102,9103,9107],[9107,9103,9086],[9086,9101,9107],[9107,9101,9100],[9100,9108,9107],[9107,9108,9109],[9109,9106,9107],[9111,9110,9102],[9102,9106,9111],[9111,9106,9109],[9109,9112,9111],[9111,9112,9113],[9113,9114,9111],[9111,9114,9115],[9115,9110,9111],[9116,9105,9102],[9102,9110,9116],[9116,9110,9115],[9115,9117,9116],[9116,9117,8983],[8983,8982,9116],[9116,8982,8979],[8979,9105,9116],[9120,9119,9118],[9118,9121,9120],[9120,9121,8995],[8995,8994,9120],[9120,8994,8857],[8857,8988,9120],[9120,8988,8985],[8985,9119,9120],[9123,9122,9118],[9118,9119,9123],[9123,9119,8985],[8985,8984,9123],[9123,8984,8983],[8983,9124,9123],[9123,9124,9125],[9125,9122,9123],[9127,9126,9118],[9118,9122,9127],[9127,9122,9125],[9125,9128,9127],[9127,9128,9129],[9129,9130,9127],[9127,9130,9131],[9131,9126,9127],[9132,9121,9118],[9118,9126,9132],[9132,9126,9131],[9131,9133,9132],[9132,9133,8999],[8999,8998,9132],[9132,8998,8995],[8995,9121,9132],[9136,9135,9134],[9134,9137,9136],[9136,9137,8875],[8875,8874,9136],[9136,8874,8873],[8873,9138,9136],[9136,9138,9139],[9139,9135,9136],[9141,9140,9134],[9134,9135,9141],[9141,9135,9139],[9139,9142,9141],[9141,9142,9143],[9143,9144,9141],[9141,9144,9145],[9145,9140,9141],[9147,9146,9134],[9134,9140,9147],[9147,9140,9145],[9145,9148,9147],[9147,9148,9017],[9017,9016,9147],[9147,9016,9013],[9013,9146,9147],[9149,9137,9134],[9134,9146,9149],[9149,9146,9013],[9013,9012,9149],[9149,9012,8743],[8743,8877,9149],[9149,8877,8875],[8875,9137,9149],[9152,9151,9150],[9150,9153,9152],[9152,9153,9027],[9027,9026,9152],[9152,9026,8761],[8761,8892,9152],[9152,8892,8889],[8889,9151,9152],[9155,9154,9150],[9150,9151,9155],[9155,9151,8889],[8889,8888,9155],[9155,8888,8887],[8887,9156,9155],[9155,9156,9157],[9157,9154,9155],[9159,9158,9150],[9150,9154,9159],[9159,9154,9157],[9157,9160,9159],[9159,9160,9161],[9161,9162,9159],[9163,9159,9162],[9159,9163,9158],[9164,9153,9150],[9150,9158,9164],[9164,9158,9163],[9163,9165,9164],[9164,9165,9031],[9031,9030,9164],[9164,9030,9027],[9027,9153,9164],[9168,9167,9166],[9166,9169,9168],[8907,8906,9168],[9168,9169,8907],[9168,8906,8905],[8905,9170,9168],[9168,9170,9171],[9171,9167,9168],[9173,9172,9166],[9166,9167,9173],[9173,9167,9171],[9171,9174,9173],[9173,9174,9175],[9175,9176,9173],[9173,9176,9177],[9177,9172,9173],[9179,9178,9166],[9166,9172,9179],[9179,9172,9177],[9177,9180,9179],[9179,9180,9049],[9049,9048,9179],[9179,9048,9045],[9045,9178,9179],[9181,9169,9166],[9166,9178,9181],[9181,9178,9045],[9045,9044,9181],[9181,9044,8775],[8775,8909,9181],[9181,8909,8907],[8907,9169,9181],[9184,9183,9182],[9182,9185,9184],[9184,9185,9059],[9059,9058,9184],[9184,9058,8793],[8793,8924,9184],[9184,8924,8921],[8921,9183,9184],[9187,9186,9182],[9182,9183,9187],[9187,9183,8921],[8921,8920,9187],[9187,8920,8919],[8919,9188,9187],[9187,9188,9189],[9189,9186,9187],[9191,9190,9182],[9182,9186,9191],[9191,9186,9189],[9189,9192,9191],[9191,9192,9193],[9193,9194,9191],[9191,9194,9195],[9195,9190,9191],[9196,9185,9182],[9182,9190,9196],[9196,9190,9195],[9195,9197,9196],[9196,9197,9063],[9063,9062,9196],[9196,9062,9059],[9059,9185,9196],[9200,9199,9198],[9198,9201,9200],[9200,9201,9202],[9202,9203,9200],[9200,9203,9095],[9095,9094,9200],[9200,9094,9091],[9091,9199,9200],[9205,9204,9198],[9198,9199,9205],[9205,9199,9091],[9091,9090,9205],[9205,9090,8972],[8972,9081,9205],[9205,9081,9079],[9079,9204,9205],[9207,9206,9198],[9198,9204,9207],[9207,9204,9079],[9079,9078,9207],[9207,9078,8937],[8937,9068,9207],[9207,9068,9065],[9065,9206,9207],[9208,9201,9198],[9198,9206,9208],[9208,9206,9065],[9065,9064,9208],[9208,9064,9063],[9063,9209,9208],[9208,9209,9202],[9202,9201,9208],[9212,9211,9210],[9210,9213,9212],[9212,9213,9214],[9214,9215,9212],[9212,9215,9216],[9216,9217,9212],[9212,9217,9218],[9218,9211,9212],[9220,9219,9210],[9210,9211,9220],[9220,9211,9218],[9218,9221,9220],[9220,9221,9100],[9100,9099,9220],[9220,9099,9097],[9097,9219,9220],[9223,9222,9210],[9210,9219,9223],[9223,9219,9097],[9097,9096,9223],[9223,9096,9095],[9095,9224,9223],[9223,9224,9225],[9225,9222,9223],[9226,9213,9210],[9210,9222,9226],[9226,9222,9225],[9225,9227,9226],[9226,9227,9228],[9228,9229,9226],[9226,9229,9214],[9214,9213,9226],[9232,9231,9230],[9230,9233,9232],[9232,9233,9218],[9218,9217,9232],[9232,9217,9216],[9216,9234,9232],[9232,9234,9235],[9235,9231,9232],[9237,9236,9230],[9230,9231,9237],[9237,9231,9235],[9235,9238,9237],[9237,9238,9239],[9239,9240,9237],[9237,9240,9241],[9241,9236,9237],[9243,9242,9230],[9230,9236,9243],[9243,9236,9241],[9241,9244,9243],[9243,9244,9113],[9113,9112,9243],[9243,9112,9109],[9109,9242,9243],[9245,9233,9230],[9230,9242,9245],[9245,9242,9109],[9109,9108,9245],[9245,9108,9100],[9100,9221,9245],[9245,9221,9218],[9218,9233,9245],[9248,9247,9246],[9246,9249,9248],[9248,9249,9115],[9115,9114,9248],[9248,9114,9113],[9113,9250,9248],[9248,9250,9251],[9251,9247,9248],[9253,9252,9246],[9246,9247,9253],[9253,9247,9251],[9251,9254,9253],[9253,9254,9255],[9255,9256,9253],[9253,9256,9257],[9257,9252,9253],[9259,9258,9246],[9246,9252,9259],[9259,9252,9257],[9257,9260,9259],[9259,9260,9129],[9129,9128,9259],[9259,9128,9125],[9125,9258,9259],[9261,9249,9246],[9246,9258,9261],[9261,9258,9125],[9125,9124,9261],[9261,9124,8983],[8983,9117,9261],[9261,9117,9115],[9115,9249,9261],[9264,9263,9262],[9262,9265,9264],[9264,9265,9139],[9139,9138,9264],[9264,9138,8873],[8873,9004,9264],[9264,9004,9001],[9001,9263,9264],[9267,9266,9262],[9262,9263,9267],[9267,9263,9001],[9001,9000,9267],[9267,9000,8999],[8999,9268,9267],[9267,9268,9269],[9269,9266,9267],[9271,9270,9262],[9262,9266,9271],[9271,9266,9269],[9269,9272,9271],[9271,9272,9273],[9273,9274,9271],[9271,9274,9275],[9275,9270,9271],[9276,9265,9262],[9262,9270,9276],[9276,9270,9275],[9275,9277,9276],[9276,9277,9143],[9143,9142,9276],[9276,9142,9139],[9139,9265,9276],[9280,9279,9278],[9278,9281,9280],[9280,9281,9019],[9019,9018,9280],[9280,9018,9017],[9017,9282,9280],[9280,9282,9283],[9283,9279,9280],[9285,9284,9278],[9278,9279,9285],[9285,9279,9283],[9283,9286,9285],[9285,9288,9287],[9288,9285,9286],[9285,9287,9289],[9289,9284,9285],[9291,9290,9278],[9278,9284,9291],[9291,9284,9289],[9289,9292,9291],[9291,9292,9161],[9161,9160,9291],[9291,9160,9157],[9157,9290,9291],[9293,9281,9278],[9278,9290,9293],[9293,9290,9157],[9157,9156,9293],[9293,9156,8887],[8887,9021,9293],[9293,9021,9019],[9019,9281,9293],[9296,9295,9294],[9294,9297,9296],[9296,9297,9171],[9171,9170,9296],[9296,9170,8905],[8905,9036,9296],[9296,9033,9295],[9033,9296,9036],[9299,9298,9294],[9294,9295,9299],[9299,9295,9033],[9033,9032,9299],[9299,9032,9031],[9031,9300,9299],[9299,9300,9301],[9301,9298,9299],[9303,9302,9294],[9294,9298,9303],[9303,9298,9301],[9301,9304,9303],[9303,9304,9305],[9305,9306,9303],[9303,9306,9307],[9307,9302,9303],[9308,9297,9294],[9294,9302,9308],[9308,9302,9307],[9307,9309,9308],[9308,9309,9175],[9175,9174,9308],[9308,9174,9171],[9171,9297,9308],[9312,9311,9310],[9310,9313,9312],[9312,9313,9051],[9051,9050,9312],[9312,9050,9049],[9049,9314,9312],[9312,9314,9315],[9315,9311,9312],[9317,9316,9310],[9310,9311,9317],[9317,9311,9315],[9315,9318,9317],[9317,9318,9319],[9319,9320,9317],[9317,9320,9321],[9321,9316,9317],[9323,9322,9310],[9310,9316,9323],[9323,9316,9321],[9321,9324,9323],[9323,9324,9193],[9193,9192,9323],[9323,9192,9189],[9189,9322,9323],[9325,9313,9310],[9310,9322,9325],[9325,9322,9189],[9189,9188,9325],[9325,9188,8919],[8919,9053,9325],[9325,9053,9051],[9051,9313,9325],[9328,9327,9326],[9326,9329,9328],[9328,9329,9225],[9225,9224,9328],[9328,9224,9095],[9095,9203,9328],[9328,9203,9202],[9202,9327,9328],[9331,9330,9326],[9326,9327,9331],[9331,9327,9202],[9202,9209,9331],[9331,9209,9063],[9063,9197,9331],[9331,9197,9195],[9195,9330,9331],[9333,9332,9326],[9326,9330,9333],[9333,9330,9195],[9195,9194,9333],[9333,9194,9193],[9193,9334,9333],[9333,9334,9335],[9335,9332,9333],[9336,9329,9326],[9326,9332,9336],[9336,9332,9335],[9335,9337,9336],[9336,9337,9228],[9228,9227,9336],[9336,9227,9225],[9225,9329,9336],[9340,9339,9338],[9338,9341,9340],[9340,9341,9342],[9342,9343,9340],[9340,9343,9216],[9216,9215,9340],[9340,9215,9214],[9214,9339,9340],[9345,9344,9338],[9338,9339,9345],[9345,9339,9214],[9214,9229,9345],[9345,9229,9228],[9228,9346,9345],[9345,9346,9347],[9347,9344,9345],[9349,9348,9338],[9338,9344,9349],[9349,9344,9347],[9347,9350,9349],[9349,9350,9351],[9351,9352,9349],[9349,9352,9353],[9353,9348,9349],[9354,9341,9338],[9338,9348,9354],[9354,9348,9353],[9353,9355,9354],[9354,9355,9356],[9356,9357,9354],[9354,9357,9342],[9342,9341,9354],[9360,9359,9358],[9358,9361,9360],[9360,9361,9235],[9235,9234,9360],[9360,9234,9216],[9216,9343,9360],[9360,9343,9342],[9342,9359,9360],[9363,9362,9358],[9358,9359,9363],[9363,9359,9342],[9342,9357,9363],[9363,9357,9356],[9356,9364,9363],[9363,9364,9365],[9365,9362,9363],[9367,9366,9358],[9358,9362,9367],[9367,9362,9365],[9365,9368,9367],[9367,9368,9369],[9369,9370,9367],[9367,9370,9371],[9371,9366,9367],[9372,9361,9358],[9358,9366,9372],[9372,9366,9371],[9371,9373,9372],[9372,9373,9239],[9239,9238,9372],[9372,9238,9235],[9235,9361,9372],[9376,9375,9374],[9374,9377,9376],[9376,9377,9251],[9251,9250,9376],[9376,9250,9113],[9113,9244,9376],[9376,9244,9241],[9241,9375,9376],[9379,9378,9374],[9374,9375,9379],[9379,9375,9241],[9241,9240,9379],[9379,9240,9239],[9239,9380,9379],[9379,9380,9381],[9381,9378,9379],[9383,9382,9374],[9374,9378,9383],[9383,9378,9381],[9381,9384,9383],[9383,9384,9385],[9385,9386,9383],[9383,9386,9387],[9387,9382,9383],[9388,9377,9374],[9374,9382,9388],[9388,9382,9387],[9387,9389,9388],[9388,9389,9255],[9255,9254,9388],[9388,9254,9251],[9251,9377,9388],[9392,9391,9390],[9390,9393,9392],[9392,9393,9131],[9131,9130,9392],[9392,9130,9129],[9129,9394,9392],[9392,9394,9395],[9395,9391,9392],[9397,9396,9390],[9390,9391,9397],[9397,9391,9395],[9395,9398,9397],[9397,9398,9399],[9399,9400,9397],[9397,9400,9401],[9401,9396,9397],[9403,9402,9390],[9390,9396,9403],[9403,9396,9401],[9401,9404,9403],[9403,9404,9273],[9273,9272,9403],[9403,9272,9269],[9269,9402,9403],[9405,9393,9390],[9390,9402,9405],[9405,9402,9269],[9269,9268,9405],[9405,9268,8999],[8999,9133,9405],[9405,9133,9131],[9131,9393,9405],[9408,9407,9406],[9406,9409,9408],[9408,9409,9283],[9283,9282,9408],[9408,9282,9017],[9017,9148,9408],[9408,9148,9145],[9145,9407,9408],[9411,9410,9406],[9406,9407,9411],[9411,9407,9145],[9145,9144,9411],[9411,9144,9143],[9143,9412,9411],[9411,9412,9413],[9413,9410,9411],[9415,9414,9406],[9406,9410,9415],[9415,9410,9413],[9413,9416,9415],[9415,9416,9417],[9417,9418,9415],[9415,9418,9419],[9419,9414,9415],[9420,9409,9406],[9406,9414,9420],[9420,9414,9419],[9419,9421,9420],[9420,9421,9288],[9288,9286,9420],[9420,9286,9283],[9283,9409,9420],[9424,9423,9422],[9422,9425,9424],[9163,9162,9424],[9424,9425,9163],[9424,9162,9161],[9161,9426,9424],[9424,9426,9427],[9427,9423,9424],[9429,9428,9422],[9422,9423,9429],[9429,9423,9427],[9427,9430,9429],[9429,9430,9431],[9431,9432,9429],[9429,9432,9433],[9433,9428,9429],[9435,9434,9422],[9422,9428,9435],[9435,9428,9433],[9433,9436,9435],[9435,9436,9305],[9305,9304,9435],[9435,9304,9301],[9301,9434,9435],[9437,9425,9422],[9422,9434,9437],[9437,9434,9301],[9301,9300,9437],[9437,9300,9031],[9031,9165,9437],[9437,9165,9163],[9163,9425,9437],[9440,9439,9438],[9438,9441,9440],[9440,9441,9315],[9315,9314,9440],[9440,9314,9049],[9049,9180,9440],[9440,9180,9177],[9177,9439,9440],[9443,9442,9438],[9438,9439,9443],[9443,9439,9177],[9177,9176,9443],[9443,9176,9175],[9175,9444,9443],[9443,9444,9445],[9445,9442,9443],[9447,9446,9438],[9438,9442,9447],[9447,9442,9445],[9445,9448,9447],[9447,9448,9449],[9449,9450,9447],[9447,9450,9451],[9451,9446,9447],[9452,9441,9438],[9438,9446,9452],[9452,9446,9451],[9451,9453,9452],[9452,9453,9319],[9319,9318,9452],[9452,9318,9315],[9315,9441,9452],[9456,9455,9454],[9454,9457,9456],[9456,9457,9458],[9458,9459,9456],[9456,9459,9351],[9351,9350,9456],[9456,9350,9347],[9347,9455,9456],[9461,9460,9454],[9454,9455,9461],[9461,9455,9347],[9347,9346,9461],[9461,9346,9228],[9228,9337,9461],[9461,9337,9335],[9335,9460,9461],[9463,9462,9454],[9454,9460,9463],[9463,9460,9335],[9335,9334,9463],[9463,9334,9193],[9193,9324,9463],[9463,9324,9321],[9321,9462,9463],[9464,9457,9454],[9454,9462,9464],[9464,9462,9321],[9321,9320,9464],[9464,9320,9319],[9319,9465,9464],[9464,9465,9458],[9458,9457,9464],[9468,9467,9466],[9466,9469,9468],[9468,9469,9470],[9470,9471,9468],[9468,9471,9472],[9472,9473,9468],[9468,9473,9474],[9474,9467,9468],[9476,9475,9466],[9466,9467,9476],[9476,9467,9474],[9474,9477,9476],[9476,9477,9356],[9356,9355,9476],[9476,9355,9353],[9353,9475,9476],[9479,9478,9466],[9466,9475,9479],[9479,9475,9353],[9353,9352,9479],[9479,9352,9351],[9351,9480,9479],[9479,9480,9481],[9481,9478,9479],[9482,9469,9466],[9466,9478,9482],[9482,9478,9481],[9481,9483,9482],[9482,9483,9484],[9484,9485,9482],[9482,9485,9470],[9470,9469,9482],[9488,9487,9486],[9486,9489,9488],[9488,9489,9474],[9474,9473,9488],[9490,9488,9472],[9473,9472,9488],[9488,9490,9491],[9491,9487,9488],[9493,9492,9486],[9486,9487,9493],[9493,9487,9491],[9491,9494,9493],[9493,9494,9495],[9495,9496,9493],[9493,9496,9497],[9497,9492,9493],[9499,9498,9486],[9486,9492,9499],[9499,9492,9497],[9497,9500,9499],[9499,9500,9369],[9369,9368,9499],[9499,9368,9365],[9365,9498,9499],[9501,9489,9486],[9486,9498,9501],[9501,9498,9365],[9365,9364,9501],[9501,9364,9356],[9356,9477,9501],[9501,9477,9474],[9474,9489,9501],[9504,9503,9502],[9502,9505,9504],[9504,9505,9371],[9371,9370,9504],[9504,9370,9369],[9369,9506,9504],[9504,9506,9507],[9507,9503,9504],[9509,9508,9502],[9502,9503,9509],[9509,9503,9507],[9507,9510,9509],[9509,9510,9511],[9511,9512,9509],[9509,9512,9513],[9513,9508,9509],[9515,9514,9502],[9502,9508,9515],[9515,9508,9513],[9513,9516,9515],[9515,9516,9385],[9385,9384,9515],[9515,9384,9381],[9381,9514,9515],[9517,9505,9502],[9502,9514,9517],[9517,9514,9381],[9381,9380,9517],[9517,9380,9239],[9239,9373,9517],[9517,9373,9371],[9371,9505,9517],[9520,9519,9518],[9518,9521,9520],[9520,9521,9395],[9395,9394,9520],[9520,9394,9129],[9129,9260,9520],[9520,9260,9257],[9257,9519,9520],[9523,9522,9518],[9518,9519,9523],[9523,9519,9257],[9257,9256,9523],[9523,9256,9255],[9255,9524,9523],[9523,9524,9525],[9525,9522,9523],[9527,9526,9518],[9518,9522,9527],[9527,9522,9525],[9525,9528,9527],[9527,9528,9529],[9529,9530,9527],[9527,9530,9531],[9531,9526,9527],[9532,9521,9518],[9518,9526,9532],[9532,9526,9531],[9531,9533,9532],[9532,9533,9399],[9399,9398,9532],[9532,9398,9395],[9395,9521,9532],[9536,9535,9534],[9534,9537,9536],[9536,9537,9275],[9275,9274,9536],[9536,9274,9273],[9273,9538,9536],[9536,9538,9539],[9539,9535,9536],[9541,9540,9534],[9534,9535,9541],[9541,9535,9539],[9539,9542,9541],[9541,9542,9543],[9543,9544,9541],[9541,9544,9545],[9545,9540,9541],[9547,9546,9534],[9534,9540,9547],[9548,9547,9545],[9540,9545,9547],[9547,9548,9417],[9417,9416,9547],[9547,9416,9413],[9413,9546,9547],[9549,9537,9534],[9534,9546,9549],[9549,9546,9413],[9413,9412,9549],[9549,9412,9143],[9143,9277,9549],[9549,9277,9275],[9275,9537,9549],[9552,9551,9550],[9550,9553,9552],[9552,9553,9427],[9427,9426,9552],[9552,9426,9161],[9161,9292,9552],[9552,9292,9289],[9289,9551,9552],[9555,9554,9550],[9550,9551,9555],[9555,9551,9289],[9289,9287,9555],[9556,9555,9288],[9287,9288,9555],[9555,9556,9557],[9557,9554,9555],[9559,9558,9550],[9550,9554,9559],[9559,9554,9557],[9557,9560,9559],[9559,9560,9561],[9561,9562,9559],[9559,9562,9563],[9563,9558,9559],[9564,9553,9550],[9550,9558,9564],[9564,9558,9563],[9563,9565,9564],[9564,9565,9431],[9431,9430,9564],[9564,9430,9427],[9427,9553,9564],[9568,9567,9566],[9566,9569,9568],[9568,9569,9307],[9307,9306,9568],[9568,9306,9305],[9305,9570,9568],[9568,9570,9571],[9571,9567,9568],[9573,9572,9566],[9566,9567,9573],[9573,9567,9571],[9571,9574,9573],[9573,9574,9575],[9575,9576,9573],[9573,9576,9577],[9577,9572,9573],[9579,9578,9566],[9566,9572,9579],[9579,9572,9577],[9577,9580,9579],[9579,9580,9449],[9449,9448,9579],[9579,9448,9445],[9445,9578,9579],[9581,9569,9566],[9566,9578,9581],[9581,9578,9445],[9445,9444,9581],[9581,9444,9175],[9175,9309,9581],[9581,9309,9307],[9307,9569,9581],[9584,9583,9582],[9582,9585,9584],[9584,9585,9481],[9481,9480,9584],[9584,9480,9351],[9351,9459,9584],[9584,9459,9458],[9458,9583,9584],[9587,9586,9582],[9582,9583,9587],[9587,9583,9458],[9458,9465,9587],[9587,9465,9319],[9319,9453,9587],[9587,9453,9451],[9451,9586,9587],[9589,9588,9582],[9582,9586,9589],[9589,9586,9451],[9451,9450,9589],[9589,9450,9449],[9449,9590,9589],[9589,9590,9591],[9591,9588,9589],[9592,9585,9582],[9582,9588,9592],[9592,9588,9591],[9591,9593,9592],[9592,9593,9484],[9484,9483,9592],[9592,9483,9481],[9481,9585,9592],[9596,9595,9594],[9594,9597,9596],[9596,9597,9598],[9598,9599,9596],[9596,9599,9472],[9472,9471,9596],[9596,9471,9470],[9470,9595,9596],[9601,9600,9594],[9594,9595,9601],[9601,9595,9470],[9470,9485,9601],[9601,9485,9484],[9484,9602,9601],[9601,9602,9603],[9603,9600,9601],[9605,9604,9594],[9594,9600,9605],[9605,9600,9603],[9603,9606,9605],[9605,9606,9607],[9607,9608,9605],[9605,9608,9609],[9609,9604,9605],[9610,9597,9594],[9594,9604,9610],[9610,9604,9609],[9609,9611,9610],[9610,9611,9612],[9612,9613,9610],[9597,9610,9598],[9613,9598,9610],[9616,9615,9614],[9614,9617,9616],[9616,9617,9491],[9491,9490,9616],[9616,9490,9472],[9472,9599,9616],[9616,9599,9598],[9598,9615,9616],[9619,9618,9614],[9614,9615,9619],[9598,9613,9619],[9619,9615,9598],[9619,9613,9612],[9612,9620,9619],[9619,9620,9621],[9621,9618,9619],[9623,9622,9614],[9614,9618,9623],[9623,9618,9621],[9621,9624,9623],[9623,9624,9625],[9625,9626,9623],[9623,9626,9627],[9627,9622,9623],[9628,9617,9614],[9614,9622,9628],[9628,9622,9627],[9627,9629,9628],[9628,9629,9495],[9495,9494,9628],[9628,9494,9491],[9491,9617,9628],[9632,9631,9630],[9630,9633,9632],[9632,9633,9507],[9507,9506,9632],[9632,9506,9369],[9369,9500,9632],[9632,9500,9497],[9497,9631,9632],[9635,9634,9630],[9630,9631,9635],[9635,9631,9497],[9497,9496,9635],[9635,9496,9495],[9495,9636,9635],[9635,9636,9637],[9637,9634,9635],[9639,9638,9630],[9630,9634,9639],[9639,9634,9637],[9637,9640,9639],[9639,9640,9641],[9641,9642,9639],[9639,9642,9643],[9643,9638,9639],[9644,9633,9630],[9630,9638,9644],[9644,9638,9643],[9643,9645,9644],[9644,9645,9511],[9511,9510,9644],[9644,9510,9507],[9507,9633,9644],[9648,9647,9646],[9646,9649,9648],[9648,9649,9387],[9387,9386,9648],[9648,9386,9385],[9385,9650,9648],[9648,9650,9651],[9651,9647,9648],[9653,9652,9646],[9646,9647,9653],[9653,9647,9651],[9651,9654,9653],[9653,9654,9655],[9655,9656,9653],[9653,9656,9657],[9657,9652,9653],[9659,9658,9646],[9646,9652,9659],[9659,9652,9657],[9657,9660,9659],[9659,9660,9529],[9529,9528,9659],[9659,9528,9525],[9525,9658,9659],[9661,9649,9646],[9646,9658,9661],[9661,9658,9525],[9525,9524,9661],[9661,9524,9255],[9255,9389,9661],[9661,9389,9387],[9387,9649,9661],[9664,9663,9662],[9662,9665,9664],[9664,9665,9539],[9539,9538,9664],[9664,9538,9273],[9273,9404,9664],[9664,9404,9401],[9401,9663,9664],[9667,9666,9662],[9662,9663,9667],[9667,9663,9401],[9401,9400,9667],[9667,9400,9399],[9399,9668,9667],[9667,9668,9669],[9669,9666,9667],[9671,9670,9662],[9662,9666,9671],[9671,9666,9669],[9669,9672,9671],[9671,9672,9673],[9673,9674,9671],[9671,9674,9675],[9675,9670,9671],[9676,9665,9662],[9662,9670,9676],[9676,9670,9675],[9675,9677,9676],[9676,9677,9543],[9543,9542,9676],[9676,9542,9539],[9539,9665,9676],[9680,9679,9678],[9678,9681,9680],[9680,9681,9419],[9419,9418,9680],[9680,9418,9417],[9417,9682,9680],[9680,9682,9683],[9683,9679,9680],[9685,9684,9678],[9678,9679,9685],[9685,9679,9683],[9683,9686,9685],[9685,9686,9687],[9687,9688,9685],[9685,9688,9689],[9689,9684,9685],[9691,9690,9678],[9678,9684,9691],[9691,9684,9689],[9689,9692,9691],[9691,9692,9561],[9561,9560,9691],[9691,9560,9557],[9557,9690,9691],[9693,9681,9678],[9678,9690,9693],[9693,9690,9557],[9557,9556,9693],[9693,9556,9288],[9288,9421,9693],[9693,9421,9419],[9419,9681,9693],[9696,9695,9694],[9694,9697,9696],[9696,9697,9571],[9571,9570,9696],[9696,9570,9305],[9305,9436,9696],[9696,9436,9433],[9433,9695,9696],[9699,9698,9694],[9694,9695,9699],[9699,9695,9433],[9433,9432,9699],[9699,9432,9431],[9431,9700,9699],[9699,9700,9701],[9701,9698,9699],[9703,9702,9694],[9694,9698,9703],[9703,9698,9701],[9701,9704,9703],[9703,9704,9705],[9705,9706,9703],[9703,9706,9707],[9707,9702,9703],[9708,9697,9694],[9694,9702,9708],[9708,9702,9707],[9707,9709,9708],[9708,9709,9575],[9575,9574,9708],[9708,9574,9571],[9571,9697,9708],[9712,9711,9710],[9710,9713,9712],[9712,9713,9714],[9714,9715,9712],[9712,9715,9607],[9607,9606,9712],[9712,9606,9603],[9603,9711,9712],[9717,9716,9710],[9710,9711,9717],[9717,9711,9603],[9603,9602,9717],[9717,9602,9484],[9484,9593,9717],[9717,9593,9591],[9591,9716,9717],[9719,9718,9710],[9710,9716,9719],[9719,9716,9591],[9591,9590,9719],[9719,9590,9449],[9449,9580,9719],[9719,9580,9577],[9577,9718,9719],[9720,9713,9710],[9710,9718,9720],[9720,9718,9577],[9577,9576,9720],[9720,9576,9575],[9575,9721,9720],[9720,9721,9714],[9714,9713,9720],[9724,9723,9722],[9722,9725,9724],[9724,9725,9726],[9726,9727,9724],[9724,9727,9728],[9728,9729,9724],[9724,9729,9730],[9730,9723,9724],[9732,9731,9722],[9722,9723,9732],[9732,9723,9730],[9730,9733,9732],[9732,9733,9612],[9612,9611,9732],[9732,9611,9609],[9609,9731,9732],[9735,9734,9722],[9722,9731,9735],[9735,9731,9609],[9609,9608,9735],[9735,9608,9607],[9607,9736,9735],[9735,9736,9737],[9737,9734,9735],[9738,9725,9722],[9722,9734,9738],[9738,9734,9737],[9737,9739,9738],[9738,9739,9740],[9740,9741,9738],[9738,9741,9726],[9726,9725,9738],[9744,9743,9742],[9742,9745,9744],[9744,9745,9730],[9730,9729,9744],[9744,9729,9728],[9728,9746,9744],[9744,9746,9747],[9747,9743,9744],[9749,9748,9742],[9742,9743,9749],[9749,9743,9747],[9747,9750,9749],[9749,9750,9751],[9751,9752,9749],[9749,9752,9753],[9753,9748,9749],[9755,9754,9742],[9742,9748,9755],[9755,9748,9753],[9753,9756,9755],[9755,9756,9625],[9625,9624,9755],[9755,9624,9621],[9621,9754,9755],[9757,9745,9742],[9742,9754,9757],[9757,9754,9621],[9621,9620,9757],[9757,9620,9612],[9612,9733,9757],[9757,9733,9730],[9730,9745,9757],[9760,9759,9758],[9758,9761,9760],[9760,9761,9627],[9627,9626,9760],[9760,9626,9625],[9625,9762,9760],[9760,9762,9763],[9763,9759,9760],[9765,9764,9758],[9758,9759,9765],[9765,9759,9763],[9763,9766,9765],[9765,9766,9767],[9767,9768,9765],[9765,9768,9769],[9769,9764,9765],[9771,9770,9758],[9758,9764,9771],[9771,9764,9769],[9769,9772,9771],[9771,9772,9641],[9641,9640,9771],[9771,9640,9637],[9637,9770,9771],[9773,9761,9758],[9758,9770,9773],[9773,9770,9637],[9637,9636,9773],[9773,9636,9495],[9495,9629,9773],[9773,9629,9627],[9627,9761,9773],[9776,9775,9774],[9774,9777,9776],[9776,9777,9651],[9651,9650,9776],[9776,9650,9385],[9385,9516,9776],[9776,9516,9513],[9513,9775,9776],[9779,9778,9774],[9774,9775,9779],[9779,9775,9513],[9513,9512,9779],[9779,9512,9511],[9511,9780,9779],[9779,9780,9781],[9781,9778,9779],[9783,9782,9774],[9774,9778,9783],[9783,9778,9781],[9781,9784,9783],[9783,9784,9785],[9785,9786,9783],[9783,9786,9787],[9787,9782,9783],[9788,9777,9774],[9774,9782,9788],[9788,9782,9787],[9787,9789,9788],[9788,9789,9655],[9655,9654,9788],[9788,9654,9651],[9651,9777,9788],[9792,9791,9790],[9790,9793,9792],[9792,9793,9531],[9531,9530,9792],[9792,9530,9529],[9529,9794,9792],[9792,9794,9795],[9795,9791,9792],[9797,9796,9790],[9790,9791,9797],[9797,9791,9795],[9795,9798,9797],[9797,9798,9799],[9799,9800,9797],[9797,9800,9801],[9801,9796,9797],[9803,9802,9790],[9790,9796,9803],[9803,9796,9801],[9801,9804,9803],[9803,9804,9673],[9673,9672,9803],[9803,9672,9669],[9669,9802,9803],[9805,9793,9790],[9790,9802,9805],[9805,9802,9669],[9669,9668,9805],[9805,9668,9399],[9399,9533,9805],[9805,9533,9531],[9531,9793,9805],[9808,9807,9806],[9806,9809,9808],[9808,9809,9683],[9683,9682,9808],[9808,9682,9417],[9417,9548,9808],[9545,9807,9808],[9808,9548,9545],[9811,9810,9806],[9806,9807,9811],[9811,9807,9545],[9545,9544,9811],[9811,9544,9543],[9543,9812,9811],[9811,9812,9813],[9813,9810,9811],[9815,9814,9806],[9806,9810,9815],[9815,9810,9813],[9813,9816,9815],[9815,9816,9817],[9817,9818,9815],[9815,9818,9819],[9819,9814,9815],[9820,9809,9806],[9806,9814,9820],[9820,9814,9819],[9819,9821,9820],[9820,9821,9687],[9687,9686,9820],[9820,9686,9683],[9683,9809,9820],[9824,9823,9822],[9822,9825,9824],[9824,9825,9563],[9563,9562,9824],[9824,9562,9561],[9561,9826,9824],[9824,9826,9827],[9827,9823,9824],[9829,9828,9822],[9822,9823,9829],[9829,9823,9827],[9827,9830,9829],[9829,9830,9831],[9831,9832,9829],[9829,9832,9833],[9833,9828,9829],[9835,9834,9822],[9822,9828,9835],[9835,9828,9833],[9833,9836,9835],[9835,9836,9705],[9705,9704,9835],[9835,9704,9701],[9701,9834,9835],[9837,9825,9822],[9822,9834,9837],[9837,9834,9701],[9701,9700,9837],[9837,9700,9431],[9431,9565,9837],[9837,9565,9563],[9563,9825,9837],[9840,9839,9838],[9838,9841,9840],[9840,9841,9737],[9737,9736,9840],[9840,9736,9607],[9607,9715,9840],[9840,9715,9714],[9714,9839,9840],[9843,9842,9838],[9838,9839,9843],[9843,9839,9714],[9714,9721,9843],[9843,9721,9575],[9575,9709,9843],[9843,9709,9707],[9707,9842,9843],[9845,9844,9838],[9838,9842,9845],[9845,9842,9707],[9707,9706,9845],[9845,9706,9705],[9705,9846,9845],[9845,9846,9847],[9847,9844,9845],[9848,9841,9838],[9838,9844,9848],[9848,9844,9847],[9847,9849,9848],[9848,9849,9740],[9740,9739,9848],[9848,9739,9737],[9737,9841,9848],[9852,9851,9850],[9850,9853,9852],[9852,9853,9854],[9854,9855,9852],[9852,9855,9728],[9728,9727,9852],[9852,9727,9726],[9726,9851,9852],[9857,9856,9850],[9850,9851,9857],[9857,9851,9726],[9726,9741,9857],[9857,9741,9740],[9740,9858,9857],[9857,9858,9859],[9859,9856,9857],[9861,9860,9850],[9850,9856,9861],[9861,9856,9859],[9859,9862,9861],[9861,9862,9863],[9863,9864,9861],[9861,9864,9865],[9865,9860,9861],[9866,9853,9850],[9850,9860,9866],[9866,9860,9865],[9865,9867,9866],[9866,9867,9868],[9868,9869,9866],[9853,9866,9854],[9869,9854,9866],[9872,9871,9870],[9870,9873,9872],[9872,9873,9747],[9747,9746,9872],[9872,9746,9728],[9728,9855,9872],[9872,9855,9854],[9854,9871,9872],[9875,9874,9870],[9870,9871,9875],[9869,9875,9854],[9871,9854,9875],[9875,9869,9868],[9868,9876,9875],[9875,9876,9877],[9877,9874,9875],[9879,9878,9870],[9870,9874,9879],[9879,9874,9877],[9877,9880,9879],[9882,9879,9881],[9881,9879,9880],[9879,9882,9883],[9886,9885,9884],[9884,9885,9887],[9887,9885,9883],[9883,9885,9879],[9885,9878,9879],[9888,9873,9870],[9870,9878,9888],[9888,9878,9885],[9885,9889,9888],[9888,9889,9751],[9751,9750,9888],[9888,9750,9747],[9747,9873,9888],[9892,9891,9890],[9890,9893,9892],[9892,9893,9763],[9763,9762,9892],[9892,9762,9625],[9625,9756,9892],[9892,9756,9753],[9753,9891,9892],[9895,9894,9890],[9890,9891,9895],[9895,9891,9753],[9753,9752,9895],[9895,9752,9751],[9751,9896,9895],[9898,9895,9897],[9897,9895,9896],[9896,9899,9897],[9894,9895,9900],[9900,9895,9898],[9902,9901,9890],[9901,9902,9903],[9901,9903,9904],[9894,9905,9902],[9890,9894,9902],[9905,9894,9900],[9901,9904,9906],[9907,9893,9890],[9890,9901,9907],[9901,9906,9908],[9901,9908,9909],[9907,9901,9909],[9911,9909,9910],[9909,9911,9907],[9907,9911,9767],[9767,9766,9907],[9907,9766,9763],[9763,9893,9907],[9914,9913,9912],[9912,9915,9914],[9914,9915,9643],[9643,9642,9914],[9914,9642,9641],[9641,9916,9914],[9914,9916,9917],[9917,9913,9914],[9919,9918,9912],[9912,9913,9919],[9919,9913,9917],[9917,9920,9919],[9919,9920,9921],[9921,9922,9919],[9919,9922,9923],[9923,9918,9919],[9925,9924,9912],[9912,9918,9925],[9925,9918,9923],[9923,9926,9925],[9925,9926,9785],[9785,9784,9925],[9925,9784,9781],[9781,9924,9925],[9927,9915,9912],[9912,9924,9927],[9927,9924,9781],[9781,9780,9927],[9927,9780,9511],[9511,9645,9927],[9927,9645,9643],[9643,9915,9927],[9930,9929,9928],[9928,9931,9930],[9930,9931,9795],[9795,9794,9930],[9930,9794,9529],[9529,9660,9930],[9930,9660,9657],[9657,9929,9930],[9933,9932,9928],[9928,9929,9933],[9933,9929,9657],[9657,9656,9933],[9933,9656,9655],[9655,9934,9933],[9933,9934,9935],[9935,9932,9933],[9937,9936,9928],[9928,9932,9937],[9937,9932,9935],[9935,9938,9937],[9937,9938,9939],[9939,9940,9937],[9937,9940,9941],[9941,9936,9937],[9942,9931,9928],[9928,9936,9942],[9942,9936,9941],[9941,9943,9942],[9942,9943,9799],[9799,9798,9942],[9942,9798,9795],[9795,9931,9942],[9946,9945,9944],[9944,9947,9946],[9946,9947,9675],[9675,9674,9946],[9946,9674,9673],[9673,9948,9946],[9946,9948,9949],[9949,9945,9946],[9951,9950,9944],[9944,9945,9951],[9951,9945,9949],[9949,9952,9951],[9951,9952,9953],[9953,9954,9951],[9951,9954,9955],[9955,9950,9951],[9957,9956,9944],[9944,9950,9957],[9957,9950,9955],[9955,9958,9957],[9957,9958,9817],[9817,9816,9957],[9957,9816,9813],[9813,9956,9957],[9959,9947,9944],[9944,9956,9959],[9959,9956,9813],[9813,9812,9959],[9959,9812,9543],[9543,9677,9959],[9959,9677,9675],[9675,9947,9959],[9962,9961,9960],[9960,9963,9962],[9962,9963,9827],[9827,9826,9962],[9962,9826,9561],[9561,9692,9962],[9962,9692,9689],[9689,9961,9962],[9965,9964,9960],[9960,9961,9965],[9965,9961,9689],[9689,9688,9965],[9965,9688,9687],[9687,9966,9965],[9965,9966,9967],[9967,9964,9965],[9969,9968,9960],[9960,9964,9969],[9969,9964,9967],[9967,9970,9969],[9969,9970,9971],[9971,9972,9969],[9969,9972,9973],[9973,9968,9969],[9974,9963,9960],[9960,9968,9974],[9974,9968,9973],[9973,9975,9974],[9974,9975,9831],[9831,9830,9974],[9974,9830,9827],[9827,9963,9974],[9978,9977,9976],[9976,9979,9978],[9978,9979,9980],[9980,9981,9978],[9978,9981,9863],[9863,9862,9978],[9978,9862,9859],[9859,9977,9978],[9983,9982,9976],[9976,9977,9983],[9983,9977,9859],[9859,9858,9983],[9983,9858,9740],[9740,9849,9983],[9983,9849,9847],[9847,9982,9983],[9985,9984,9976],[9976,9982,9985],[9985,9982,9847],[9847,9846,9985],[9985,9846,9705],[9705,9836,9985],[9985,9836,9833],[9833,9984,9985],[9986,9979,9976],[9976,9984,9986],[9986,9984,9833],[9833,9832,9986],[9986,9832,9831],[9831,9987,9986],[9986,9987,9980],[9980,9979,9986],[9990,9989,9988],[9988,9991,9990],[9990,9991,9992],[9992,9993,9990],[9990,9993,9994],[9994,9995,9990],[9990,9995,9996],[9996,9989,9990],[9998,9997,9988],[9988,9989,9998],[9998,9989,9996],[9996,9999,9998],[9998,9999,9868],[9868,9867,9998],[9998,9867,9865],[9865,9997,9998],[10001,10000,9988],[9988,9997,10001],[10001,9997,9865],[9865,9864,10001],[10001,9864,9863],[9863,10002,10001],[10001,10002,10003],[10003,10000,10001],[10004,9991,9988],[9988,10000,10004],[10004,10000,10003],[10003,10005,10004],[10004,10005,10006],[10006,10007,10004],[10004,10007,9992],[9992,9991,10004],[10010,10009,10008],[10008,10011,10010],[10010,10011,9996],[9996,9995,10010],[10010,9995,9994],[9994,10012,10010],[10010,10012,10013],[10013,10009,10010],[10008,10015,10014],[10015,10008,10016],[10016,10008,10017],[10017,10008,10009],[10009,10018,10017],[10018,10009,10013],[10019,10018,10013],[10021,10020,10008],[10023,10021,10022],[10022,10021,10024],[10024,10021,10014],[10014,10021,10008],[10026,10021,10025],[10025,10021,10023],[10021,10026,10027],[10027,10028,10021],[9880,10029,9881],[10029,9880,10028],[10028,9880,10021],[10021,9880,9877],[9877,10020,10021],[10030,10011,10008],[10008,10020,10030],[10030,10020,9877],[9877,9876,10030],[10030,9876,9868],[9868,9999,10030],[10030,9999,9996],[9996,10011,10030],[10032,9885,10031],[10031,9885,10033],[10033,9885,9886],[9899,9896,10034],[9896,9751,10034],[10034,9751,10035],[10035,9751,9889],[9889,10036,10035],[10036,9889,10037],[10037,9889,10038],[10038,9889,9885],[9885,10032,10038],[10041,10040,10039],[10039,10042,10041],[10041,10042,9917],[9917,9916,10041],[10041,9916,9641],[9641,9772,10041],[10041,9772,9769],[9769,10040,10041],[10044,10043,10039],[10039,10040,10044],[10044,10040,9769],[9769,9768,10044],[10044,9768,9767],[9767,10045,10044],[10044,10045,10046],[10046,10043,10044],[10048,10047,10039],[10039,10043,10048],[10048,10043,10046],[10046,10049,10048],[10048,10049,10050],[10050,10051,10048],[10048,10051,10052],[10052,10047,10048],[10053,10042,10039],[10039,10047,10053],[10053,10047,10052],[10052,10054,10053],[10053,10054,9921],[9921,9920,10053],[10053,9920,9917],[9917,10042,10053],[10057,10056,10055],[10055,10058,10057],[10057,10058,9787],[9787,9786,10057],[10057,9786,9785],[9785,10059,10057],[10057,10059,10060],[10060,10056,10057],[10062,10061,10055],[10055,10056,10062],[10062,10056,10060],[10060,10063,10062],[10062,10063,10064],[10064,10065,10062],[10062,10065,10066],[10066,10061,10062],[10068,10067,10055],[10055,10061,10068],[10068,10061,10066],[10066,10069,10068],[10068,10069,9939],[9939,9938,10068],[10068,9938,9935],[9935,10067,10068],[10070,10058,10055],[10055,10067,10070],[10070,10067,9935],[9935,9934,10070],[10070,9934,9655],[9655,9789,10070],[10070,9789,9787],[9787,10058,10070],[10073,10072,10071],[10071,10074,10073],[10073,10074,9949],[9949,9948,10073],[10073,9948,9673],[9673,9804,10073],[10073,9804,9801],[9801,10072,10073],[10076,10075,10071],[10071,10072,10076],[10076,10072,9801],[9801,9800,10076],[10076,9800,9799],[9799,10077,10076],[10076,10077,10078],[10078,10075,10076],[10080,10079,10071],[10071,10075,10080],[10080,10075,10078],[10078,10081,10080],[10080,10081,10082],[10082,10083,10080],[10080,10083,10084],[10084,10079,10080],[10085,10074,10071],[10071,10079,10085],[10085,10079,10084],[10084,10086,10085],[10085,10086,9953],[9953,9952,10085],[10085,9952,9949],[9949,10074,10085],[10089,10088,10087],[10087,10090,10089],[10089,10090,9819],[9819,9818,10089],[10089,9818,9817],[9817,10091,10089],[10089,10091,10092],[10092,10088,10089],[10094,10093,10087],[10087,10088,10094],[10094,10088,10092],[10092,10095,10094],[10094,10095,10096],[10096,10097,10094],[10094,10097,10098],[10098,10093,10094],[10100,10099,10087],[10087,10093,10100],[10100,10093,10098],[10098,10101,10100],[10100,10101,9971],[9971,9970,10100],[10100,9970,9967],[9967,10099,10100],[10102,10090,10087],[10087,10099,10102],[10102,10099,9967],[9967,9966,10102],[10102,9966,9687],[9687,9821,10102],[10102,9821,9819],[9819,10090,10102],[10105,10104,10103],[10103,10106,10105],[10105,10106,10003],[10003,10002,10105],[10105,10002,9863],[9863,9981,10105],[10105,9981,9980],[9980,10104,10105],[10108,10107,10103],[10103,10104,10108],[10108,10104,9980],[9980,9987,10108],[10108,9987,9831],[9831,9975,10108],[10108,9975,9973],[9973,10107,10108],[10110,10109,10103],[10103,10107,10110],[10110,10107,9973],[9973,9972,10110],[10110,9972,9971],[9971,10111,10110],[10110,10111,10112],[10112,10109,10110],[10113,10106,10103],[10103,10109,10113],[10113,10109,10112],[10112,10114,10113],[10113,10114,10006],[10006,10005,10113],[10113,10005,10003],[10003,10106,10113],[10117,10116,10115],[10115,10118,10117],[10117,10118,10119],[10119,10120,10117],[10117,10120,9994],[9994,9993,10117],[10117,9993,9992],[9992,10116,10117],[10122,10121,10115],[10115,10116,10122],[10122,10116,9992],[9992,10007,10122],[10122,10007,10006],[10006,10123,10122],[10122,10123,10124],[10124,10121,10122],[10126,10125,10115],[10115,10121,10126],[10126,10121,10124],[10124,10127,10126],[10126,10127,10128],[10128,10129,10126],[10126,10129,10130],[10130,10125,10126],[10131,10118,10115],[10115,10125,10131],[10131,10125,10130],[10130,10132,10131],[10131,10132,10133],[10133,10134,10131],[10131,10134,10119],[10119,10118,10131],[10013,10135,10019],[10135,10013,10136],[10139,10138,10137],[10138,10139,10140],[10140,10139,10141],[10142,10137,10138],[10136,10013,10143],[10143,10013,10142],[10142,10013,10137],[10013,10012,10137],[10137,10012,9994],[9994,10120,10137],[10137,10120,10119],[10119,10139,10137],[10146,10145,10144],[10141,10145,10147],[10147,10145,10146],[10145,10141,10139],[10145,10139,10119],[10119,10134,10145],[10145,10134,10133],[10133,10148,10145],[10151,10150,10149],[10150,10148,10149],[10148,10150,10145],[10144,10145,10150],[10153,10152,10050],[10154,10153,10049],[10050,10049,10153],[10155,10154,10046],[10049,10046,10154],[10156,10155,10046],[10159,10158,10157],[10160,10157,10158],[10160,10156,10046],[10157,10160,10046],[10046,10045,10157],[10157,10045,9767],[9767,9911,10157],[9910,10157,9911],[10157,9910,10161],[10157,10161,10159],[10164,10163,10162],[10162,10165,10164],[10164,10165,10060],[10060,10059,10164],[10164,10059,9785],[9785,9926,10164],[10164,9926,9923],[9923,10163,10164],[10167,10166,10162],[10162,10163,10167],[10167,10163,9923],[9923,9922,10167],[10167,9922,9921],[9921,10168,10167],[10167,10168,10169],[10169,10166,10167],[10171,10170,10162],[10162,10166,10171],[10171,10166,10169],[10169,10172,10171],[10171,10172,10173],[10173,10174,10171],[10171,10175,10170],[10175,10171,10174],[10176,10165,10162],[10162,10170,10176],[10176,10170,10175],[10175,10177,10176],[10176,10177,10064],[10064,10063,10176],[10176,10063,10060],[10060,10165,10176],[10180,10179,10178],[10178,10181,10180],[10180,10181,9941],[9941,9940,10180],[10180,9940,9939],[9939,10182,10180],[10180,10182,10183],[10183,10179,10180],[10185,10184,10178],[10178,10179,10185],[10185,10179,10183],[10183,10186,10185],[10185,10186,10187],[10187,10188,10185],[10185,10188,10189],[10189,10184,10185],[10191,10190,10178],[10178,10184,10191],[10191,10184,10189],[10189,10192,10191],[10191,10192,10082],[10082,10081,10191],[10191,10081,10078],[10078,10190,10191],[10193,10181,10178],[10178,10190,10193],[10193,10190,10078],[10078,10077,10193],[10193,10077,9799],[9799,9943,10193],[10193,9943,9941],[9941,10181,10193],[10196,10195,10194],[10194,10197,10196],[10196,10197,10092],[10092,10091,10196],[10196,10091,9817],[9817,9958,10196],[10196,9958,9955],[9955,10195,10196],[10199,10198,10194],[10194,10195,10199],[10199,10195,9955],[9955,9954,10199],[10199,9954,9953],[9953,10200,10199],[10199,10200,10201],[10201,10198,10199],[10203,10202,10194],[10194,10198,10203],[10203,10198,10201],[10201,10204,10203],[10203,10204,10205],[10205,10206,10203],[10203,10206,10207],[10207,10202,10203],[10208,10197,10194],[10194,10202,10208],[10208,10202,10207],[10207,10209,10208],[10208,10209,10096],[10096,10095,10208],[10208,10095,10092],[10092,10197,10208],[10212,10211,10210],[10210,10213,10212],[10212,10213,10214],[10214,10215,10212],[10212,10215,10128],[10128,10127,10212],[10212,10127,10124],[10124,10211,10212],[10217,10216,10210],[10210,10211,10217],[10217,10211,10124],[10124,10123,10217],[10217,10123,10006],[10006,10114,10217],[10217,10114,10112],[10112,10216,10217],[10219,10218,10210],[10210,10216,10219],[10219,10216,10112],[10112,10111,10219],[10219,10111,9971],[9971,10101,10219],[10219,10101,10098],[10098,10218,10219],[10220,10213,10210],[10210,10218,10220],[10220,10218,10098],[10098,10097,10220],[10220,10097,10096],[10096,10221,10220],[10220,10221,10214],[10214,10213,10220],[10224,10223,10222],[10222,10225,10224],[10224,10225,10226],[10226,10227,10224],[10224,10227,10228],[10228,10229,10224],[10224,10229,10230],[10230,10223,10224],[10232,10231,10222],[10222,10223,10232],[10232,10223,10230],[10230,10233,10232],[10232,10233,10133],[10133,10132,10232],[10232,10132,10130],[10130,10231,10232],[10235,10234,10222],[10222,10231,10235],[10235,10231,10130],[10130,10129,10235],[10235,10129,10128],[10128,10236,10235],[10235,10236,10237],[10237,10234,10235],[10238,10225,10222],[10222,10234,10238],[10238,10234,10237],[10237,10239,10238],[10238,10239,10240],[10240,10241,10238],[10238,10241,10226],[10226,10225,10238],[10244,10243,10242],[10245,10243,10244],[10246,10243,10245],[10243,10149,10148],[10149,10243,10247],[10247,10243,10246],[10243,10148,10133],[10133,10233,10243],[10243,10233,10230],[10242,10243,10248],[10248,10243,10249],[10249,10243,10250],[10243,10230,10250],[10252,10251,10230],[10251,10250,10230],[10253,10252,10229],[10229,10252,10230],[10255,10254,10228],[10254,10253,10228],[10228,10253,10229],[10256,10255,10228],[10259,10258,10257],[10257,10260,10259],[10259,10260,10052],[10052,10051,10259],[10259,10051,10050],[10050,10261,10259],[10259,10261,10262],[10262,10258,10259],[10264,10263,10257],[10257,10258,10264],[10264,10258,10262],[10262,10265,10264],[10267,10266,10265],[10264,10265,10266],[10266,10269,10268],[10266,10268,10264],[10264,10268,10270],[10270,10263,10264],[10272,10271,10257],[10257,10263,10272],[10272,10263,10270],[10270,10273,10272],[10272,10273,10173],[10173,10172,10272],[10272,10172,10169],[10169,10271,10272],[10274,10260,10257],[10257,10271,10274],[10274,10271,10169],[10169,10168,10274],[10274,10168,9921],[9921,10054,10274],[10274,10054,10052],[10052,10260,10274],[10277,10276,10275],[10275,10278,10277],[10277,10278,10183],[10183,10182,10277],[10277,10182,9939],[9939,10069,10277],[10277,10069,10066],[10066,10276,10277],[10280,10279,10275],[10275,10276,10280],[10280,10276,10066],[10066,10065,10280],[10280,10065,10064],[10064,10281,10280],[10280,10281,10282],[10282,10279,10280],[10284,10283,10275],[10275,10279,10284],[10284,10279,10282],[10282,10285,10284],[10284,10285,10286],[10286,10287,10284],[10284,10287,10288],[10288,10283,10284],[10289,10278,10275],[10275,10283,10289],[10289,10283,10288],[10288,10290,10289],[10289,10290,10187],[10187,10186,10289],[10289,10186,10183],[10183,10278,10289],[10293,10292,10291],[10291,10294,10293],[10293,10294,10084],[10084,10083,10293],[10293,10083,10082],[10082,10295,10293],[10293,10295,10296],[10296,10292,10293],[10298,10297,10291],[10291,10292,10298],[10298,10292,10296],[10296,10299,10298],[10298,10299,10300],[10300,10301,10298],[10298,10301,10302],[10302,10297,10298],[10304,10303,10291],[10291,10297,10304],[10304,10297,10302],[10302,10305,10304],[10304,10305,10205],[10205,10204,10304],[10304,10204,10201],[10201,10303,10304],[10306,10294,10291],[10291,10303,10306],[10306,10303,10201],[10201,10200,10306],[10306,10200,9953],[9953,10086,10306],[10306,10086,10084],[10084,10294,10306],[10309,10308,10307],[10307,10310,10309],[10309,10310,10237],[10237,10236,10309],[10309,10236,10128],[10128,10215,10309],[10309,10215,10214],[10214,10308,10309],[10312,10311,10307],[10307,10308,10312],[10312,10308,10214],[10214,10221,10312],[10312,10221,10096],[10096,10209,10312],[10312,10209,10207],[10207,10311,10312],[10314,10313,10307],[10307,10311,10314],[10314,10311,10207],[10207,10206,10314],[10314,10206,10205],[10205,10315,10314],[10314,10315,10316],[10316,10313,10314],[10317,10310,10307],[10307,10313,10317],[10317,10313,10316],[10316,10318,10317],[10317,10318,10240],[10240,10239,10317],[10317,10239,10237],[10237,10310,10317],[10321,10320,10319],[10319,10322,10321],[10324,10323,10322],[10322,10323,10321],[10323,10325,10321],[10325,10326,10321],[10326,10327,10228],[10228,10321,10326],[10228,10227,10321],[10321,10227,10226],[10226,10320,10321],[10329,10328,10319],[10319,10320,10329],[10329,10320,10226],[10226,10241,10329],[10329,10241,10240],[10240,10330,10329],[10329,10330,10331],[10331,10328,10329],[10333,10332,10319],[10319,10328,10333],[10333,10328,10331],[10331,10334,10333],[10333,10334,10335],[10335,10336,10333],[10333,10336,10337],[10337,10332,10333],[10338,10322,10319],[10319,10332,10338],[10338,10332,10337],[10337,10340,10339],[10337,10339,10341],[10337,10341,10338],[10341,10342,10338],[10343,10338,10342],[10344,10338,10343],[10338,10345,10322],[10345,10324,10322],[10345,10338,10344],[10346,10256,10228],[10347,10346,10327],[10327,10346,10228],[10262,10349,10348],[10350,10262,10261],[10262,10350,10349],[10351,10350,10050],[10261,10050,10350],[10152,10351,10050],[10265,10352,10267],[10265,10353,10352],[10353,10265,10262],[10348,10354,10353],[10262,10348,10353],[10357,10356,10355],[10355,10358,10357],[10175,10174,10357],[10357,10358,10175],[10357,10174,10173],[10173,10359,10357],[10357,10359,10360],[10360,10356,10357],[10362,10361,10355],[10355,10356,10362],[10362,10356,10360],[10360,10363,10362],[10362,10363,10364],[10364,10365,10362],[10362,10365,10366],[10366,10361,10362],[10368,10367,10355],[10355,10361,10368],[10368,10361,10366],[10366,10369,10368],[10368,10369,10286],[10286,10285,10368],[10368,10285,10282],[10282,10367,10368],[10370,10358,10355],[10355,10367,10370],[10370,10367,10282],[10282,10281,10370],[10370,10281,10064],[10064,10177,10370],[10370,10177,10175],[10175,10358,10370],[10373,10372,10371],[10371,10374,10373],[10373,10374,10296],[10296,10295,10373],[10373,10295,10082],[10082,10192,10373],[10373,10192,10189],[10189,10372,10373],[10376,10375,10371],[10371,10372,10376],[10376,10372,10189],[10189,10188,10376],[10376,10188,10187],[10187,10377,10376],[10376,10377,10378],[10378,10375,10376],[10380,10379,10371],[10371,10375,10380],[10380,10375,10378],[10378,10381,10380],[10380,10381,10382],[10382,10383,10380],[10380,10383,10384],[10384,10379,10380],[10385,10374,10371],[10371,10379,10385],[10385,10379,10384],[10384,10386,10385],[10385,10386,10300],[10300,10299,10385],[10385,10299,10296],[10296,10374,10385],[10389,10388,10387],[10387,10390,10389],[10389,10390,10391],[10391,10392,10389],[10389,10392,10335],[10335,10334,10389],[10389,10334,10331],[10331,10388,10389],[10394,10393,10387],[10387,10388,10394],[10394,10388,10331],[10331,10330,10394],[10394,10330,10240],[10240,10318,10394],[10394,10318,10316],[10316,10393,10394],[10396,10395,10387],[10387,10393,10396],[10396,10393,10316],[10316,10315,10396],[10396,10315,10205],[10205,10305,10396],[10396,10305,10302],[10302,10395,10396],[10397,10390,10387],[10387,10395,10397],[10397,10395,10302],[10302,10301,10397],[10397,10301,10300],[10300,10398,10397],[10397,10398,10391],[10391,10390,10397],[10401,10400,10399],[10402,10399,10400],[10340,10337,10403],[10399,10402,10403],[10399,10403,10337],[10406,10405,10404],[10405,10406,10407],[10399,10404,10401],[10405,10401,10404],[10404,10399,10337],[10337,10336,10404],[10404,10336,10335],[10335,10408,10404],[10404,10408,10409],[10409,10406,10404],[10412,10411,10410],[10411,10412,10413],[10411,10413,10414],[10411,10414,10415],[10411,10415,10407],[10411,10407,10406],[10411,10406,10409],[10409,10416,10411],[10411,10416,10417],[10417,10418,10411],[10420,10418,10419],[10418,10420,10421],[10418,10421,10411],[10421,10410,10411],[10424,10423,10422],[10422,10425,10424],[10424,10425,10360],[10360,10359,10424],[10424,10359,10173],[10173,10273,10424],[10424,10273,10270],[10270,10423,10424],[10427,10426,10422],[10422,10423,10427],[10427,10423,10270],[10270,10268,10427],[10269,10427,10268],[10427,10269,10428],[10427,10428,10429],[10427,10429,10430],[10427,10430,10431],[10426,10431,10432],[10431,10426,10427],[10434,10433,10422],[10422,10426,10434],[10434,10436,10435],[10436,10434,10432],[10426,10432,10434],[10434,10435,10437],[10434,10437,10438],[10434,10438,10439],[10434,10439,10440],[10441,10434,10440],[10441,10433,10434],[10442,10425,10422],[10422,10433,10442],[10442,10433,10441],[10441,10443,10442],[10442,10443,10364],[10364,10363,10442],[10442,10363,10360],[10360,10425,10442],[10446,10445,10444],[10444,10447,10446],[10446,10447,10288],[10288,10287,10446],[10446,10287,10286],[10286,10448,10446],[10446,10448,10449],[10449,10445,10446],[10451,10450,10444],[10444,10445,10451],[10451,10445,10449],[10449,10452,10451],[10451,10452,10453],[10453,10454,10451],[10451,10454,10455],[10455,10450,10451],[10457,10456,10444],[10444,10450,10457],[10457,10450,10455],[10455,10458,10457],[10457,10458,10382],[10382,10381,10457],[10457,10381,10378],[10378,10456,10457],[10459,10447,10444],[10444,10456,10459],[10459,10456,10378],[10378,10377,10459],[10459,10377,10187],[10187,10290,10459],[10459,10290,10288],[10288,10447,10459],[10462,10461,10460],[10460,10463,10462],[10462,10463,10409],[10409,10408,10462],[10462,10408,10335],[10335,10392,10462],[10462,10392,10391],[10391,10461,10462],[10465,10464,10460],[10460,10461,10465],[10465,10461,10391],[10391,10398,10465],[10465,10398,10300],[10300,10386,10465],[10465,10386,10384],[10384,10464,10465],[10467,10466,10460],[10460,10464,10467],[10467,10464,10384],[10384,10383,10467],[10467,10383,10382],[10382,10468,10467],[10467,10468,10469],[10469,10466,10467],[10470,10463,10460],[10460,10466,10470],[10470,10466,10469],[10469,10471,10470],[10470,10471,10417],[10417,10416,10470],[10470,10416,10409],[10409,10463,10470],[10474,10473,10472],[10475,10474,10472],[10476,10475,10472],[10473,10477,10472],[10478,10472,10477],[10472,10478,10479],[10472,10479,10419],[10472,10419,10418],[10472,10418,10417],[10417,10480,10472],[10472,10480,10481],[10476,10481,10482],[10481,10476,10472],[10483,10482,10481],[10486,10485,10484],[10485,10486,10483],[10485,10483,10481],[10488,10487,10484],[10488,10484,10485],[10487,10488,10489],[10492,10491,10490],[10490,10493,10492],[10492,10493,10449],[10449,10448,10492],[10492,10448,10286],[10286,10369,10492],[10492,10369,10366],[10366,10491,10492],[10495,10494,10490],[10490,10491,10495],[10495,10491,10366],[10366,10365,10495],[10495,10365,10364],[10364,10496,10495],[10495,10496,10497],[10497,10494,10495],[10499,10498,10490],[10490,10494,10499],[10499,10494,10497],[10497,10500,10499],[10499,10500,10501],[10501,10502,10499],[10499,10502,10503],[10503,10498,10499],[10504,10493,10490],[10490,10498,10504],[10504,10498,10503],[10503,10505,10504],[10504,10505,10453],[10453,10452,10504],[10504,10452,10449],[10449,10493,10504],[10508,10507,10506],[10506,10509,10508],[10508,10509,10510],[10510,10511,10508],[10508,10511,10488],[10488,10485,10508],[10508,10485,10481],[10481,10507,10508],[10513,10512,10506],[10506,10507,10513],[10513,10507,10481],[10481,10480,10513],[10513,10480,10417],[10417,10471,10513],[10513,10471,10469],[10469,10512,10513],[10515,10514,10506],[10506,10512,10515],[10515,10512,10469],[10469,10468,10515],[10515,10468,10382],[10382,10458,10515],[10515,10458,10455],[10455,10514,10515],[10516,10509,10506],[10506,10514,10516],[10516,10514,10455],[10455,10454,10516],[10516,10454,10453],[10453,10517,10516],[10516,10517,10510],[10510,10509,10516],[10518,10489,10488],[10519,10518,10488],[10520,10519,10488],[10523,10522,10521],[10524,10521,10522],[10521,10524,10525],[10525,10441,10526],[10441,10525,10524],[10526,10441,10440],[10529,10528,10527],[10522,10527,10528],[10527,10522,10523],[10528,10529,10530],[10532,10531,10522],[10522,10528,10532],[10528,10530,10533],[10532,10528,10533],[10535,10533,10534],[10533,10535,10532],[10532,10535,10501],[10501,10500,10532],[10532,10500,10497],[10497,10531,10532],[10536,10524,10522],[10522,10531,10536],[10536,10531,10497],[10497,10496,10536],[10536,10496,10364],[10364,10443,10536],[10536,10443,10441],[10441,10524,10536],[10539,10538,10537],[10537,10540,10539],[10542,10541,10540],[10539,10540,10541],[10539,10544,10543],[10541,10544,10539],[10520,10539,10543],[10539,10520,10488],[10488,10511,10539],[10539,10511,10510],[10510,10538,10539],[10546,10545,10537],[10537,10538,10546],[10546,10538,10510],[10510,10517,10546],[10546,10517,10453],[10453,10505,10546],[10546,10505,10503],[10503,10545,10546],[10548,10547,10537],[10537,10545,10548],[10548,10545,10503],[10503,10502,10548],[10548,10502,10501],[10501,10549,10548],[10551,10550,10549],[10548,10549,10550],[10550,10553,10552],[10550,10552,10547],[10550,10547,10548],[10555,10554,10540],[10556,10555,10540],[10556,10540,10537],[10557,10556,10547],[10537,10547,10556],[10552,10557,10547],[10554,10542,10540],[10549,10558,10551],[10559,10558,10549],[10560,10559,10549],[10560,10549,10501],[10561,10560,10535],[10501,10535,10560],[10535,10534,10562],[10535,10562,10561],[10565,10564,10563],[10563,10566,10565],[10565,10566,10567],[10568,10565,10567],[10565,10568,10569],[10571,10570,10569],[10569,10570,10565],[10570,10572,10565],[10565,10572,10573],[10573,10564,10565],[10576,10575,10574],[10574,10577,10576],[10576,10577,10578],[10580,10579,10578],[10579,10576,10578],[10576,10579,10581],[10581,10582,10576],[10582,10583,10576],[10576,10583,10584],[10584,10575,10576],[10587,10586,10585],[10585,10588,10587],[10588,10589,10587],[10589,10590,10587],[10590,10591,10587],[10592,10587,10591],[10587,10592,10593],[10587,10593,10594],[10594,10586,10587],[10597,10596,10595],[10595,10598,10597],[10597,10598,10599],[10599,10600,10597],[10600,10601,10597],[10601,10602,10597],[10603,10597,10602],[10597,10603,10604],[10604,10596,10597],[10607,10606,10605],[10605,10608,10607],[10607,10608,10609],[10611,10610,10609],[10610,10607,10609],[10613,10612,10607],[10612,10614,10607],[10607,10610,10613],[10614,10615,10607],[10607,10615,10616],[10616,10606,10607],[10619,10618,10617],[10617,10620,10619],[10620,10621,10619],[10621,10622,10619],[10622,10623,10619],[10624,10619,10623],[10619,10624,10625],[10619,10625,10626],[10626,10618,10619],[10629,10628,10627],[10627,10630,10629],[10629,10630,10631],[10631,10632,10629],[10632,10633,10629],[10635,10629,10634],[10634,10629,10633],[10636,10629,10635],[10629,10636,10637],[10637,10628,10629],[10640,10639,10638],[10638,10641,10640],[10640,10641,10642],[10644,10640,10643],[10643,10640,10642],[10642,10645,10643],[10640,10644,10646],[10646,10647,10640],[10640,10647,10648],[10648,10639,10640],[10651,10650,10649],[10649,10652,10651],[10651,10652,10653],[10651,10655,10654],[10656,10655,10653],[10655,10651,10653],[10654,10657,10651],[10657,10658,10651],[10658,10659,10651],[10659,10660,10651],[10651,10660,10661],[10661,10650,10651],[10664,10663,10662],[10662,10665,10664],[10665,10666,10664],[10666,10667,10664],[10667,10668,10664],[10669,10664,10668],[10664,10669,10670],[10664,10670,10671],[10671,10663,10664],[10674,10673,10672],[10672,10675,10674],[10674,10675,10676],[10678,10674,10677],[10677,10674,10679],[10679,10674,10676],[10682,10681,10680],[10680,10681,10674],[10674,10678,10680],[10681,10683,10674],[10674,10683,10684],[10684,10673,10674],[10687,10686,10685],[10685,10688,10687],[10689,10687,10688],[10687,10689,10690],[10690,10691,10687],[10691,10692,10687],[10692,10691,10693],[10692,10694,10687],[10687,10694,10695],[10695,10686,10687],[10698,10697,10696],[10696,10699,10698],[10699,10700,10698],[10700,10701,10698],[10701,10702,10698],[10703,10698,10702],[10698,10703,10704],[10698,10704,10705],[10705,10697,10698],[10708,10707,10706],[10706,10709,10708],[10708,10709,10710],[10710,10711,10708],[10713,10708,10712],[10712,10708,10711],[10714,10708,10713],[10708,10714,10715],[10715,10707,10708],[10717,10716,10573],[10573,10572,10717],[10717,10572,10570],[10717,10719,10718],[10719,10717,10720],[10720,10717,10570],[10723,10722,10721],[10721,10722,10718],[10718,10722,10717],[10722,10724,10717],[10717,10724,10725],[10725,10716,10717],[10727,10726,10584],[10584,10583,10727],[10727,10583,10582],[10729,10727,10728],[10728,10727,10582],[10582,10730,10728],[10727,10729,10731],[10731,10732,10727],[10727,10732,10733],[10733,10726,10727],[10735,10734,10594],[10594,10593,10735],[10735,10593,10592],[10592,10736,10735],[10738,10735,10737],[10737,10735,10736],[10739,10735,10738],[10735,10739,10740],[10740,10734,10735],[10742,10741,10604],[10604,10603,10742],[10602,10742,10603],[10742,10602,10743],[10743,10744,10742],[10744,10567,10742],[10567,10744,10745],[10567,10566,10742],[10742,10566,10563],[10563,10741,10742],[10747,10746,10616],[10616,10615,10747],[10747,10615,10614],[10749,10748,10614],[10748,10750,10614],[10750,10747,10614],[10752,10751,10747],[10751,10578,10747],[10747,10750,10752],[10578,10577,10747],[10747,10577,10574],[10574,10746,10747],[10754,10753,10626],[10626,10625,10754],[10625,10624,10754],[10624,10755,10754],[10755,10756,10754],[10589,10754,10757],[10757,10754,10756],[10754,10589,10588],[10754,10588,10585],[10585,10753,10754],[10759,10758,10637],[10637,10636,10759],[10759,10636,10635],[10635,10760,10759],[10599,10759,10761],[10761,10759,10760],[10598,10759,10599],[10759,10598,10595],[10595,10758,10759],[10763,10762,10648],[10648,10647,10763],[10647,10646,10763],[10764,10763,10646],[10621,10763,10765],[10765,10763,10764],[10763,10621,10620],[10763,10620,10617],[10617,10762,10763],[10767,10766,10661],[10661,10660,10767],[10767,10660,10659],[10767,10769,10768],[10770,10769,10659],[10769,10767,10659],[10768,10771,10767],[10771,10609,10767],[10609,10608,10767],[10767,10608,10605],[10605,10766,10767],[10773,10772,10671],[10671,10670,10773],[10773,10670,10669],[10669,10774,10773],[10631,10773,10775],[10775,10773,10774],[10630,10773,10631],[10773,10630,10627],[10627,10772,10773],[10777,10776,10684],[10684,10683,10777],[10777,10683,10681],[10779,10777,10778],[10778,10777,10681],[10780,10642,10777],[10777,10779,10780],[10642,10641,10777],[10777,10641,10638],[10638,10776,10777],[10782,10781,10695],[10695,10694,10782],[10782,10694,10692],[10783,10782,10692],[10782,10783,10784],[10784,10785,10782],[10785,10653,10782],[10653,10652,10782],[10782,10652,10649],[10649,10781,10782],[10787,10786,10705],[10705,10704,10787],[10704,10703,10787],[10703,10788,10787],[10788,10789,10787],[10666,10787,10790],[10790,10787,10789],[10787,10666,10665],[10787,10665,10662],[10662,10786,10787],[10793,10792,10791],[10791,10794,10793],[10793,10794,10795],[10797,10793,10796],[10796,10793,10795],[10799,10676,10798],[10798,10676,10793],[10793,10797,10798],[10676,10675,10793],[10793,10675,10672],[10672,10792,10793],[10801,10800,10715],[10715,10714,10801],[10801,10714,10713],[10713,10802,10801],[10802,10803,10801],[10803,10689,10801],[10688,10801,10689],[10801,10688,10685],[10685,10800,10801],[10805,10804,10725],[10725,10724,10805],[10805,10724,10722],[10805,10807,10806],[10807,10805,10808],[10808,10805,10722],[10809,10795,10806],[10806,10795,10805],[10795,10794,10805],[10805,10794,10791],[10791,10804,10805],[10811,10810,10733],[10733,10732,10811],[10732,10731,10811],[10812,10811,10731],[10700,10811,10813],[10813,10811,10812],[10811,10700,10699],[10811,10699,10696],[10696,10810,10811],[10815,10814,10740],[10740,10739,10815],[10815,10739,10738],[10738,10816,10815],[10816,10817,10815],[10710,10815,10818],[10818,10815,10817],[10709,10815,10710],[10815,10709,10706],[10706,10814,10815],[10676,10819,10679],[10819,10676,10820],[10820,10676,10821],[10821,10676,10799],[10822,10796,10795],[10795,10809,10822],[10824,10823,10722],[10823,10808,10722],[10825,10824,10722],[10722,10723,10825],[10826,10720,10570],[10570,10571,10826],[10827,10568,10567],[10745,10828,10567],[10828,10827,10567],[10730,10582,10829],[10829,10582,10830],[10830,10582,10581],[10578,10831,10580],[10831,10578,10751],[10614,10832,10749],[10832,10614,10833],[10833,10614,10834],[10834,10614,10612],[10835,10611,10609],[10609,10771,10835],[10837,10836,10659],[10836,10770,10659],[10659,10658,10838],[10838,10837,10659],[10839,10656,10653],[10653,10785,10839],[10840,10783,10692],[10693,10841,10692],[10841,10840,10692],[10645,10642,10842],[10842,10642,10843],[10843,10642,10780],[10681,10844,10778],[10844,10681,10682],[10847,10846,10845],[10847,10848,10846],[10851,10850,10849],[10852,10851,10849],[10855,10854,10853],[10855,10856,10854],[10859,10858,10857],[10860,10859,10857],[10863,10862,10861],[10861,10864,10863],[10864,10740,10863],[10814,10863,10740],[10863,10814,10706],[10706,10865,10863],[10863,10865,10866],[10866,10862,10863],[10869,10868,10867],[10867,10870,10869],[10869,10870,10733],[10733,10810,10869],[10869,10810,10696],[10696,10871,10869],[10869,10871,10872],[10872,10868,10869],[10875,10874,10873],[10873,10876,10875],[10875,10876,10725],[10725,10804,10875],[10875,10804,10791],[10791,10877,10875],[10875,10877,10878],[10878,10874,10875],[10881,10880,10879],[10879,10882,10881],[10881,10882,10715],[10715,10800,10881],[10881,10800,10685],[10685,10883,10881],[10881,10883,10884],[10884,10880,10881],[10886,10885,10878],[10878,10877,10886],[10886,10877,10791],[10791,10792,10886],[10886,10792,10672],[10672,10887,10886],[10886,10887,10888],[10888,10885,10886],[10891,10890,10889],[10889,10892,10891],[10891,10892,10705],[10705,10786,10891],[10891,10786,10662],[10662,10893,10891],[10891,10893,10894],[10894,10890,10891],[10897,10896,10895],[10895,10898,10897],[10897,10898,10695],[10695,10781,10897],[10897,10781,10649],[10649,10899,10897],[10897,10899,10900],[10900,10896,10897],[10903,10902,10901],[10901,10904,10903],[10903,10904,10684],[10684,10776,10903],[10903,10776,10638],[10638,10905,10903],[10903,10905,10906],[10906,10902,10903],[10909,10908,10907],[10907,10910,10909],[10909,10910,10671],[10671,10772,10909],[10909,10772,10627],[10627,10911,10909],[10909,10911,10912],[10912,10908,10909],[10915,10914,10913],[10913,10916,10915],[10915,10916,10661],[10661,10766,10915],[10915,10766,10605],[10605,10917,10915],[10915,10917,10918],[10918,10914,10915],[10921,10920,10919],[10919,10922,10921],[10921,10922,10648],[10648,10762,10921],[10921,10762,10617],[10617,10923,10921],[10921,10923,10924],[10924,10920,10921],[10927,10926,10925],[10925,10928,10927],[10927,10928,10637],[10637,10758,10927],[10927,10758,10595],[10595,10929,10927],[10927,10929,10930],[10930,10926,10927],[10933,10932,10931],[10931,10934,10933],[10933,10934,10626],[10626,10753,10933],[10933,10753,10585],[10585,10935,10933],[10933,10935,10936],[10936,10932,10933],[10939,10938,10937],[10937,10940,10939],[10939,10940,10616],[10616,10746,10939],[10939,10746,10574],[10574,10941,10939],[10939,10941,10942],[10942,10938,10939],[10945,10944,10943],[10943,10946,10945],[10945,10946,10604],[10604,10741,10945],[10945,10741,10563],[10563,10947,10945],[10945,10947,10948],[10948,10944,10945],[10951,10950,10949],[10949,10952,10951],[10951,10952,10594],[10594,10734,10951],[10951,10734,10740],[10740,10864,10951],[10951,10864,10861],[10861,10950,10951],[10955,10954,10953],[10953,10956,10955],[10955,10956,10584],[10584,10726,10955],[10955,10726,10733],[10733,10870,10955],[10955,10870,10867],[10867,10954,10955],[10959,10958,10957],[10957,10960,10959],[10959,10960,10573],[10573,10716,10959],[10959,10716,10725],[10725,10876,10959],[10959,10876,10873],[10873,10958,10959],[10962,10961,10866],[10866,10865,10962],[10962,10865,10706],[10706,10707,10962],[10962,10707,10715],[10715,10882,10962],[10962,10882,10879],[10879,10961,10962],[10964,10963,10872],[10872,10871,10964],[10964,10871,10696],[10696,10697,10964],[10964,10697,10705],[10705,10892,10964],[10964,10892,10889],[10889,10963,10964],[10966,10965,10884],[10884,10883,10966],[10966,10883,10685],[10685,10686,10966],[10966,10686,10695],[10695,10898,10966],[10966,10898,10895],[10895,10965,10966],[10968,10967,10888],[10888,10887,10968],[10968,10887,10672],[10672,10673,10968],[10968,10673,10684],[10684,10904,10968],[10968,10904,10901],[10901,10967,10968],[10970,10969,10894],[10894,10893,10970],[10970,10893,10662],[10662,10663,10970],[10970,10663,10671],[10671,10910,10970],[10970,10910,10907],[10907,10969,10970],[10972,10971,10900],[10900,10899,10972],[10972,10899,10649],[10649,10650,10972],[10972,10650,10661],[10661,10916,10972],[10972,10916,10913],[10913,10971,10972],[10974,10973,10906],[10906,10905,10974],[10974,10905,10638],[10638,10639,10974],[10974,10639,10648],[10648,10922,10974],[10974,10922,10919],[10919,10973,10974],[10976,10975,10912],[10912,10911,10976],[10976,10911,10627],[10627,10628,10976],[10976,10628,10637],[10637,10928,10976],[10976,10928,10925],[10925,10975,10976],[10978,10977,10924],[10924,10923,10978],[10978,10923,10617],[10617,10618,10978],[10978,10618,10626],[10626,10934,10978],[10978,10934,10931],[10931,10977,10978],[10980,10979,10918],[10918,10917,10980],[10980,10917,10605],[10605,10606,10980],[10980,10606,10616],[10616,10940,10980],[10980,10940,10937],[10937,10979,10980],[10982,10981,10930],[10930,10929,10982],[10982,10929,10595],[10595,10596,10982],[10982,10596,10604],[10604,10946,10982],[10982,10946,10943],[10943,10981,10982],[10984,10983,10936],[10936,10935,10984],[10984,10935,10585],[10585,10586,10984],[10984,10586,10594],[10594,10952,10984],[10984,10952,10949],[10949,10983,10984],[10986,10985,10942],[10942,10941,10986],[10986,10941,10574],[10574,10575,10986],[10986,10575,10584],[10584,10956,10986],[10986,10956,10953],[10953,10985,10986],[10988,10987,10948],[10948,10947,10988],[10988,10947,10563],[10563,10564,10988],[10988,10564,10573],[10573,10960,10988],[10988,10960,10957],[10957,10987,10988],[10991,10990,10989],[10991,10989,10860],[10991,10860,10857],[10991,10857,10992],[10857,10993,10992],[10992,10993,10948],[10948,10987,10992],[10992,10987,10957],[10957,10994,10992],[10996,10995,10994],[10992,10994,10995],[10999,10998,10997],[10997,10991,10992],[10999,10997,10992],[10995,10999,10992],[11002,11001,11000],[11004,11003,11002],[11004,11002,11000],[11004,11000,11005],[11007,11005,11006],[11005,11007,11004],[11004,11007,10942],[10942,10985,11004],[11004,10985,10953],[10953,11008,11004],[11004,11008,10855],[11010,11009,11003],[10853,11010,11003],[10855,10853,11003],[11004,10855,11003],[11013,11012,11011],[11013,11011,11014],[11014,11015,11013],[11015,11014,11016],[11015,11016,11017],[11015,11017,11018],[11013,11015,10936],[10936,10983,11013],[11013,10983,10949],[10949,11019,11013],[11013,11021,11020],[11013,11020,11022],[11013,11022,11023],[11021,11013,11019],[11013,11023,11024],[11013,11024,11025],[11013,11025,11012],[11028,11027,11026],[11027,11029,11026],[11030,11026,11029],[11026,11030,11031],[11026,11031,11032],[11026,11032,10930],[10930,10981,11026],[11026,10981,10943],[10943,11033,11026],[11035,11033,11034],[11033,11035,11036],[11033,11036,11037],[11033,11037,11026],[11037,11038,11028],[11037,11028,11026],[11041,11040,11039],[11041,11039,11042],[11042,11044,11043],[11041,11042,11043],[11041,11043,10918],[10918,10979,11041],[11041,10979,10937],[10937,11045,11041],[11047,11046,11041],[11048,11047,11041],[11045,11048,11041],[11040,11041,11049],[11046,11049,11041],[11052,11051,11050],[11052,11050,11053],[11053,11054,11052],[11054,11053,11055],[11054,11055,11056],[11052,11054,10924],[10924,10977,11052],[11052,10977,10931],[10931,11057,11052],[11052,11059,11058],[11052,11058,11060],[11059,11052,11057],[11052,11060,11061],[11052,11061,11051],[11064,11063,11062],[11064,11062,11065],[11067,11065,11066],[11062,11066,11065],[10912,10975,11065],[11065,11067,10912],[11065,10975,10925],[10925,11068,11065],[11070,11069,11068],[11071,11070,11068],[11065,11068,11069],[11069,11072,11064],[11069,11064,11065],[11075,11074,11073],[11075,11073,11076],[11075,11076,10847],[10848,10847,11076],[10847,11077,11075],[11075,11077,10906],[10906,10973,11075],[11075,10973,10919],[10919,11078,11075],[11075,11080,11079],[11075,11079,11081],[11075,11081,11082],[11080,11075,11083],[11078,11085,11084],[11078,11084,11086],[11086,11088,11087],[11087,11083,11075],[11086,11087,11075],[11078,11086,11075],[11075,11082,11089],[11075,11089,11090],[11075,11090,11091],[11075,11091,11092],[11075,11092,11093],[11075,11093,11094],[11075,11094,11074],[11097,11096,11095],[11098,11095,11096],[11096,11097,11099],[11099,11101,11100],[11096,11099,11100],[11096,11100,10900],[10900,10971,11096],[11096,10971,10913],[10913,11102,11096],[11104,11103,11102],[11096,11102,11103],[11105,11098,11096],[11103,11105,11096],[11108,11107,11106],[11109,11108,11106],[11109,11106,11110],[11110,11111,11109],[11110,11113,11112],[11111,11110,11112],[11111,11112,11114],[11109,11111,10894],[10894,10969,11109],[11109,10969,10907],[10907,11115,11109],[11118,11117,11116],[11109,11118,11116],[11109,11116,11119],[11118,11109,11115],[11119,11120,11108],[11109,11119,11108],[11123,11122,11121],[11123,11121,11124],[11124,11125,11123],[11125,11124,11126],[11123,11125,10888],[10888,10967,11123],[11123,10967,10901],[10901,11127,11123],[11127,11129,11128],[11127,11128,11123],[11131,11123,11130],[11128,11130,11123],[11123,11131,11122],[11134,11133,11132],[11135,11134,11132],[11136,11135,11132],[11137,11136,11132],[11138,11137,11132],[11139,11138,11132],[11140,11139,11132],[11142,11132,11141],[11143,11141,11132],[11144,11143,11132],[11133,11144,11132],[11147,11146,11145],[11148,11147,11145],[11150,11149,11148],[11132,11142,11150],[11132,11150,11148],[11132,11148,11145],[11132,11145,10884],[10884,10965,11132],[11132,10965,10895],[10895,11151,11132],[11132,11151,10849],[11152,10849,10850],[11153,11140,11132],[11152,11153,11132],[10849,11152,11132],[11156,11155,11154],[11156,11154,11157],[11159,11157,11158],[11159,11158,11160],[11157,11159,11156],[11156,11159,10872],[10872,10963,11156],[11156,10963,10889],[10889,11161,11156],[11164,11163,11162],[11156,11164,11162],[11164,11156,11161],[11156,11162,11165],[11156,11165,11155],[11168,11167,11166],[11169,11168,11166],[11171,11170,11166],[11167,11171,11166],[11172,11166,11170],[11166,11172,10866],[10866,10961,11166],[11166,10961,10879],[10879,11173,11166],[11175,11174,11173],[11176,11175,11173],[11166,11173,11174],[11177,11169,11166],[11174,11177,11166],[11180,11179,11178],[11178,11182,11181],[11182,11178,11179],[11178,11181,10996],[11178,10996,10994],[11178,10994,10957],[10957,10958,11178],[11178,10958,10873],[10873,11183,11178],[11185,11184,11183],[11178,11183,11184],[11186,11180,11178],[11184,11186,11178],[11188,11187,10855],[11189,11188,10855],[11190,11189,10855],[10856,10855,11187],[10855,11008,11190],[11190,11008,10953],[10953,10954,11190],[11190,10954,10867],[10867,11191,11190],[11194,11193,11192],[11195,11194,11192],[11190,11195,11192],[11197,11196,11190],[11198,11197,11190],[11199,11198,11190],[11200,11199,11190],[11201,11200,11190],[11191,11201,11190],[11195,11190,11196],[11203,11202,11189],[11204,11203,11189],[11205,11204,11189],[11206,11205,11189],[11207,11206,11189],[11192,11207,11189],[11190,11192,11189],[11210,11209,11208],[11211,11210,11208],[11212,11021,11208],[11213,11212,11208],[11209,11213,11208],[11019,11208,11021],[11208,11019,10949],[10949,10950,11208],[11208,10950,10861],[10861,11214,11208],[11216,11215,11214],[11217,11216,11214],[11218,11217,11214],[11208,11214,11215],[11219,11211,11208],[11215,11219,11208],[11222,11221,11220],[11222,11220,11223],[11222,11223,11224],[11222,11224,11225],[11222,11225,11226],[11222,11226,11227],[11222,11227,11228],[11227,11230,11229],[11227,11229,11231],[11227,11231,11228],[11228,11233,11232],[11228,11232,11234],[11228,11234,11235],[11228,11235,11236],[11228,11236,11034],[11228,11034,11033],[11233,11228,11231],[11228,11033,10943],[10943,10944,11228],[11228,10944,10948],[10948,10993,11228],[11228,10993,10857],[11237,10857,10858],[10857,11237,11238],[10857,11238,11222],[10857,11222,11228],[11241,11240,11239],[11241,11239,11242],[11045,11242,11048],[11242,11045,11241],[11241,11045,10937],[10937,10938,11241],[11241,10938,10942],[10942,11007,11241],[11006,11243,11241],[11007,11006,11241],[11245,11241,11244],[11241,11245,11240],[11243,11244,11241],[11248,11247,11246],[11248,11246,11249],[11249,11057,11248],[11057,11249,11250],[11057,11250,11059],[11248,11057,10931],[10931,10932,11248],[11248,10932,10936],[10936,11015,11248],[11248,11018,11251],[11248,11251,11252],[11018,11248,11015],[11248,11252,11247],[11255,11254,11253],[11256,11255,11253],[11254,11257,11071],[11254,11071,11253],[11068,11253,11071],[11253,11068,10925],[10925,10926,11253],[11253,10926,10930],[10930,11032,11253],[11259,11258,11032],[11031,11259,11032],[11253,11032,11258],[11260,11256,11253],[11258,11260,11253],[11263,11262,11261],[11263,11261,11264],[11085,11078,11265],[11263,11264,11266],[11263,11266,11265],[11263,11265,11078],[11263,11078,10919],[10919,10920,11263],[11263,10920,10924],[10924,11054,11263],[11263,11268,11267],[11054,11056,11269],[11054,11269,11263],[11268,11263,11269],[11263,11267,11262],[11272,11271,11270],[11271,11272,11273],[11274,11104,11102],[11270,11274,11102],[11272,11270,11102],[11272,11102,10913],[10913,10914,11272],[11272,10914,10918],[10918,11043,11272],[11275,11043,11044],[11043,11275,11272],[11276,11273,11272],[11275,11276,11272],[11279,11278,11277],[11279,11277,11280],[11115,11280,11118],[11282,11281,11118],[11277,11282,11118],[11277,11118,11280],[11280,11115,10907],[10907,10908,11280],[11280,10908,10912],[10912,11067,11280],[11280,11067,11283],[11285,11284,11283],[11285,11283,11067],[11066,11285,11067],[11287,11286,11279],[11287,11279,11280],[11283,11287,11280],[11290,11289,11288],[11290,11288,11291],[11290,11291,11292],[11290,11292,11293],[11293,11127,11290],[11127,11293,11129],[11290,11127,10901],[10901,10902,11290],[11290,10902,10906],[10906,11077,11290],[11290,11077,10847],[11290,10847,10845],[11290,10845,11294],[11290,11294,11295],[11290,11295,11289],[10852,10849,11296],[11297,10852,11296],[11298,11297,11296],[11299,11298,11296],[10849,11151,11296],[11296,11151,10895],[10895,10896,11296],[11296,10896,10900],[10900,11100,11296],[11101,11300,11100],[11296,11100,11300],[11301,11299,11296],[11302,11301,11296],[11303,11302,11296],[11300,11303,11296],[11306,11305,11304],[11307,11306,11304],[11304,11161,11307],[11161,11304,11308],[11161,11308,11164],[11307,11161,10889],[10889,10890,11307],[11307,10890,10894],[10894,11111,11307],[11114,11307,11111],[11307,11114,11309],[11309,11310,11306],[11307,11309,11306],[11313,11312,11311],[11313,11311,11314],[11313,11314,11315],[11313,11315,11316],[11313,11316,10878],[10878,10885,11313],[11313,10885,10888],[10888,11125,11313],[11125,11126,11317],[11125,11317,11318],[11125,11318,11313],[11318,11319,11313],[11312,11313,11319],[11322,11321,11320],[11324,11320,11323],[11324,11176,11173],[11320,11324,11173],[11321,11323,11320],[11320,11173,10879],[10879,10880,11320],[11320,10880,10884],[10884,11145,11320],[11325,11145,11146],[11327,11326,11320],[11325,11327,11320],[11145,11325,11320],[11328,11322,11320],[11326,11328,11320],[11331,11330,11329],[11330,11331,11332],[11331,11329,11333],[11331,11333,11185],[11331,11185,11183],[11331,11183,10873],[10873,10874,11331],[11331,10874,10878],[10878,11316,11331],[11316,11334,11331],[11334,11316,11315],[11335,11332,11331],[11334,11335,11331],[11338,11337,11336],[11339,11338,11336],[11341,11340,11191],[11336,11341,11191],[11339,11336,11191],[11201,11191,11340],[11339,11191,10867],[10867,10868,11339],[11339,10868,10872],[10872,11159,11339],[11160,11342,11339],[11159,11160,11339],[11339,11344,11343],[11344,11339,11342],[11339,11343,11338],[11347,11346,11345],[11214,11345,11218],[11348,11218,11345],[11346,11348,11345],[11345,11214,10861],[10861,10862,11345],[11345,10862,10866],[10866,11172,11345],[11350,11349,11172],[11170,11350,11172],[11345,11172,11349],[11351,11347,11345],[11349,11351,11345],[11354,11353,11352],[11352,11355,11354],[11352,11035,11355],[11035,11352,11036],[11034,11355,11035],[11353,11357,11356],[11356,11352,11353],[11029,11027,11356],[11027,11028,11356],[11028,11038,11356],[11038,11352,11356],[11037,11352,11038],[11352,11037,11036],[11354,11355,11358],[11358,11359,11354],[11359,11358,11360],[11360,11361,11359],[11236,11355,11034],[11235,11355,11236],[11355,11235,11358],[11234,11358,11235],[11232,11358,11234],[11358,11232,11360],[11354,11359,11362],[11362,11363,11354],[11363,11362,11364],[11364,11365,11363],[11359,11361,11366],[11366,11362,11359],[11362,11366,11367],[11367,11364,11362],[11354,11363,11368],[11368,11353,11354],[11353,11368,11369],[11369,11357,11353],[11363,11365,11370],[11370,11368,11363],[11368,11370,11371],[11371,11369,11368],[11374,11373,11372],[11372,11375,11374],[11375,11372,11370],[11370,11365,11375],[11373,11377,11376],[11376,11372,11373],[11372,11376,11371],[11371,11370,11372],[11374,11375,11378],[11378,11379,11374],[11379,11378,11380],[11380,11381,11379],[11375,11365,11364],[11364,11378,11375],[11378,11364,11367],[11367,11380,11378],[11374,11379,11382],[11382,11383,11374],[11383,11382,11384],[11384,11385,11383],[11379,11381,11386],[11386,11382,11379],[11382,11386,11387],[11387,11384,11382],[11374,11383,11388],[11388,11373,11374],[11373,11388,11389],[11389,11377,11373],[11383,11385,11390],[11390,11388,11383],[11388,11390,11391],[11391,11389,11388],[11394,11393,11392],[11392,11395,11394],[11395,11392,11390],[11390,11385,11395],[11393,11397,11396],[11396,11392,11393],[11392,11396,11391],[11391,11390,11392],[11394,11395,11398],[11398,11399,11394],[11399,11398,11400],[11400,11401,11399],[11395,11385,11384],[11384,11398,11395],[11398,11384,11387],[11387,11400,11398],[11394,11399,11402],[11402,11403,11394],[11403,11402,11404],[11404,11405,11403],[11399,11401,11406],[11406,11402,11399],[11402,11406,11407],[11407,11404,11402],[11394,11403,11408],[11408,11393,11394],[11393,11408,11409],[11409,11397,11393],[11403,11405,11410],[11410,11408,11403],[11408,11410,11411],[11411,11409,11408],[11414,11413,11412],[11412,11415,11414],[11415,11412,11410],[11410,11405,11415],[11413,11417,11416],[11416,11412,11413],[11412,11416,11411],[11411,11410,11412],[11414,11415,11418],[11418,11419,11414],[11419,11418,11420],[11420,11421,11419],[11415,11405,11404],[11404,11418,11415],[11418,11404,11407],[11407,11420,11418],[11414,11419,11422],[11422,11423,11414],[11086,11084,11423],[11423,11422,11086],[11084,11085,11423],[11419,11421,11424],[11424,11422,11419],[11087,11088,11422],[11422,11424,11087],[11088,11086,11422],[11414,11423,11425],[11425,11413,11414],[11413,11425,11426],[11426,11417,11413],[11085,11265,11423],[11265,11266,11425],[11425,11423,11265],[11425,11264,11261],[11264,11425,11266],[11267,11268,11426],[11262,11267,11426],[11261,11262,11426],[11425,11261,11426],[11225,11224,11427],[11226,11225,11427],[11220,11428,11223],[11427,11223,11428],[11223,11427,11224],[11431,11430,11429],[11429,11432,11431],[11432,11429,11366],[11366,11361,11432],[11430,11434,11433],[11433,11429,11430],[11429,11433,11367],[11367,11366,11429],[11431,11432,11435],[11435,11436,11431],[11229,11435,11231],[11435,11229,11436],[11229,11230,11436],[11432,11361,11360],[11360,11435,11432],[11233,11360,11232],[11360,11233,11435],[11233,11231,11435],[11431,11436,11437],[11437,11438,11431],[11438,11437,11439],[11439,11440,11438],[11227,11436,11230],[11227,11226,11427],[11436,11227,11427],[11427,11437,11436],[11437,11427,11428],[11428,11439,11437],[11431,11438,11441],[11441,11430,11431],[11430,11441,11442],[11442,11434,11430],[11438,11440,11443],[11443,11441,11438],[11441,11443,11444],[11444,11442,11441],[11447,11446,11445],[11445,11448,11447],[11448,11445,11386],[11386,11381,11448],[11451,11450,11449],[11450,11451,11452],[11452,11451,11453],[11454,11453,11446],[11453,11451,11446],[11451,11445,11446],[11445,11451,11387],[11387,11386,11445],[11447,11448,11455],[11455,11456,11447],[11456,11455,11433],[11433,11434,11456],[11448,11381,11380],[11380,11455,11448],[11455,11380,11367],[11367,11433,11455],[11447,11456,11457],[11457,11458,11447],[11458,11457,11459],[11459,11460,11458],[11456,11434,11442],[11442,11457,11456],[11457,11442,11444],[11444,11459,11457],[11447,11458,11461],[11461,11446,11447],[11463,11462,11461],[11461,11462,11446],[11462,11464,11446],[11464,11465,11446],[11465,11454,11446],[11458,11460,11466],[11468,11467,11461],[11469,11458,11466],[11469,11461,11458],[11461,11469,11468],[11470,11461,11467],[11463,11461,11470],[11473,11472,11471],[11471,11474,11473],[11474,11471,11406],[11406,11401,11474],[11472,11476,11475],[11475,11471,11472],[11471,11475,11407],[11407,11406,11471],[11473,11474,11477],[11477,11478,11473],[11478,11477,11451],[11480,11478,11479],[11479,11478,11481],[11449,11482,11451],[11482,11483,11451],[11483,11481,11451],[11481,11478,11451],[11474,11401,11400],[11400,11477,11474],[11477,11400,11387],[11387,11451,11477],[11473,11478,11484],[11484,11485,11473],[11487,11484,11486],[11489,11488,11485],[11489,11485,11484],[11484,11487,11489],[11488,11490,11485],[11491,11478,11480],[11484,11478,11492],[11492,11478,11493],[11493,11478,11494],[11494,11478,11491],[11492,11495,11484],[11495,11486,11484],[11473,11485,11496],[11496,11472,11473],[11472,11496,11497],[11497,11476,11472],[11485,11490,11498],[11498,11496,11485],[11496,11498,11499],[11499,11497,11496],[11502,11501,11500],[11500,11503,11502],[11503,11500,11424],[11424,11421,11503],[11081,11079,11501],[11500,11079,11080],[11079,11500,11501],[11080,11083,11500],[11424,11083,11087],[11083,11424,11500],[11502,11503,11504],[11504,11505,11502],[11505,11504,11475],[11475,11476,11505],[11503,11421,11420],[11420,11504,11503],[11504,11420,11407],[11407,11475,11504],[11502,11505,11506],[11506,11507,11502],[11507,11506,11508],[11508,11509,11507],[11505,11476,11497],[11497,11506,11505],[11506,11497,11499],[11499,11508,11506],[11502,11507,11510],[11510,11501,11502],[11501,11510,11511],[11089,11082,11511],[11082,11501,11511],[11501,11082,11081],[11507,11509,11512],[11512,11510,11507],[11510,11512,11513],[11513,11511,11510],[11090,11089,11511],[11091,11090,11511],[11092,11091,11511],[11511,11513,11092],[11093,11092,11513],[11516,11515,11514],[11514,11517,11516],[11517,11514,11518],[11518,11519,11517],[11515,11521,11520],[11520,11514,11515],[11514,11520,11522],[11522,11518,11514],[11516,11517,11523],[11523,11524,11516],[11524,11523,11416],[11416,11417,11524],[11517,11519,11525],[11525,11523,11517],[11523,11525,11411],[11411,11416,11523],[11516,11524,11526],[11526,11527,11516],[11053,11050,11527],[11526,11053,11527],[11053,11526,11055],[11051,11061,11527],[11050,11051,11527],[11524,11417,11426],[11426,11526,11524],[11269,11426,11268],[11426,11269,11526],[11056,11055,11526],[11269,11056,11526],[11516,11527,11528],[11528,11515,11516],[11515,11528,11529],[11529,11521,11515],[11527,11060,11058],[11060,11527,11061],[11059,11250,11528],[11058,11059,11528],[11527,11058,11528],[11528,11249,11246],[11249,11528,11250],[11252,11251,11529],[11247,11252,11529],[11246,11247,11529],[11528,11246,11529],[11532,11531,11530],[11530,11533,11532],[11533,11530,11534],[11534,11535,11533],[11531,11537,11536],[11536,11530,11531],[11530,11536,11538],[11538,11534,11530],[11532,11533,11539],[11539,11540,11532],[11540,11539,11396],[11396,11397,11540],[11533,11535,11541],[11541,11539,11533],[11539,11541,11391],[11391,11396,11539],[11532,11540,11542],[11542,11543,11532],[11543,11542,11525],[11525,11519,11543],[11540,11397,11409],[11409,11542,11540],[11542,11409,11411],[11411,11525,11542],[11532,11543,11544],[11544,11531,11532],[11531,11544,11545],[11545,11537,11531],[11543,11519,11518],[11518,11544,11543],[11544,11518,11522],[11522,11545,11544],[11548,11547,11546],[11546,11549,11548],[11549,11546,11550],[11550,11551,11549],[11547,11553,11552],[11552,11546,11547],[11546,11552,11554],[11554,11550,11546],[11548,11549,11555],[11555,11556,11548],[11556,11555,11376],[11376,11377,11556],[11549,11551,11557],[11557,11555,11549],[11555,11557,11371],[11371,11376,11555],[11548,11556,11558],[11558,11559,11548],[11559,11558,11541],[11541,11535,11559],[11556,11377,11389],[11389,11558,11556],[11558,11389,11391],[11391,11541,11558],[11548,11559,11560],[11560,11547,11548],[11547,11560,11561],[11561,11553,11547],[11559,11535,11534],[11534,11560,11559],[11560,11534,11538],[11538,11561,11560],[11564,11563,11562],[11562,11565,11564],[11070,11071,11562],[11071,11257,11562],[11257,11565,11562],[11254,11565,11257],[11565,11254,11255],[11563,11567,11566],[11566,11562,11563],[11063,11064,11566],[11064,11072,11566],[11072,11562,11566],[11069,11562,11072],[11562,11069,11070],[11564,11565,11568],[11568,11569,11564],[11569,11568,11356],[11356,11357,11569],[11255,11256,11565],[11256,11260,11565],[11260,11258,11565],[11258,11568,11565],[11568,11258,11259],[11259,11031,11568],[11031,11030,11568],[11356,11030,11029],[11030,11356,11568],[11564,11569,11570],[11570,11571,11564],[11571,11570,11557],[11557,11551,11571],[11569,11357,11369],[11369,11570,11569],[11570,11369,11371],[11371,11557,11570],[11564,11571,11572],[11572,11563,11564],[11563,11572,11573],[11573,11567,11563],[11571,11551,11550],[11550,11572,11571],[11572,11550,11554],[11554,11573,11572],[10858,11574,11237],[11574,10858,11575],[10858,10860,11575],[10860,10989,11575],[10860,10858,10859],[11237,11574,11238],[11238,11221,11222],[11428,11221,11574],[11221,11238,11574],[11220,11221,11428],[10999,11576,10998],[10998,11576,10997],[11576,11577,10990],[10997,10990,10991],[10990,10997,11576],[11575,10989,11577],[10989,10990,11577],[11182,11179,11578],[10995,11576,10999],[11576,10995,11578],[10995,10996,11578],[10996,11181,11578],[11181,11182,11578],[11576,11578,11579],[11579,11577,11576],[11582,11581,11580],[11580,11583,11582],[11583,11580,11443],[11443,11440,11583],[11581,11585,11584],[11584,11580,11581],[11580,11584,11444],[11444,11443,11580],[11582,11583,11586],[11586,11587,11582],[11587,11586,11574],[11574,11575,11587],[11583,11440,11439],[11439,11586,11583],[11586,11439,11428],[11428,11574,11586],[11582,11587,11588],[11588,11589,11582],[11589,11588,11590],[11590,11591,11589],[11587,11575,11577],[11577,11588,11587],[11588,11577,11579],[11579,11590,11588],[11582,11589,11592],[11592,11581,11582],[11581,11592,11593],[11593,11585,11581],[11589,11591,11594],[11594,11592,11589],[11592,11594,11595],[11595,11593,11592],[11462,11463,11596],[11467,11468,11470],[11463,11470,11468],[11596,11463,11468],[11597,11596,11469],[11468,11469,11596],[11597,11469,11466],[11466,11460,11597],[11596,11597,11598],[11598,11599,11596],[11599,11598,11584],[11584,11585,11599],[11597,11460,11459],[11459,11598,11597],[11598,11459,11444],[11444,11584,11598],[11596,11599,11600],[11600,11601,11596],[11601,11600,11602],[11602,11603,11601],[11599,11585,11593],[11593,11600,11599],[11600,11593,11595],[11595,11602,11600],[11596,11601,11604],[11604,11605,11596],[11605,11604,11606],[11606,11607,11605],[11601,11603,11608],[11608,11604,11601],[11604,11608,11609],[11609,11606,11604],[11454,11465,11464],[11454,11464,11605],[11453,11454,11605],[11596,11605,11464],[11464,11462,11596],[11605,11607,11610],[11610,11452,11453],[11610,11453,11605],[11611,11450,11610],[11452,11610,11450],[11611,11449,11450],[11449,11611,11482],[11614,11613,11612],[11612,11615,11614],[11615,11612,11498],[11498,11490,11615],[11613,11617,11616],[11616,11612,11613],[11612,11616,11499],[11499,11498,11612],[11614,11489,11487],[11489,11614,11615],[11614,11492,11493],[11495,11492,11614],[11487,11495,11614],[11495,11487,11486],[11615,11490,11488],[11488,11489,11615],[11614,11493,11494],[11494,11618,11614],[11618,11494,11491],[11618,11491,11480],[11618,11480,11479],[11618,11479,11481],[11618,11481,11619],[11619,11620,11618],[11483,11482,11611],[11619,11483,11611],[11483,11619,11481],[11614,11618,11621],[11621,11622,11614],[11622,11621,11623],[11623,11624,11622],[11618,11620,11625],[11625,11621,11618],[11621,11625,11626],[11626,11623,11621],[11614,11622,11627],[11627,11613,11614],[11613,11627,11628],[11628,11617,11613],[11622,11624,11629],[11629,11627,11622],[11627,11629,11630],[11630,11628,11627],[11633,11632,11631],[11631,11634,11633],[11634,11631,11512],[11512,11509,11634],[11632,11636,11635],[11635,11631,11632],[11631,11635,11513],[11513,11512,11631],[11633,11634,11637],[11637,11638,11633],[11638,11637,11616],[11616,11617,11638],[11634,11509,11508],[11508,11637,11634],[11637,11508,11499],[11499,11616,11637],[11633,11638,11639],[11639,11640,11633],[11640,11639,11641],[11641,11642,11640],[11638,11617,11628],[11628,11639,11638],[11639,11628,11630],[11630,11641,11639],[11633,11640,11643],[11643,11632,11633],[11632,11643,11644],[11644,11636,11632],[11640,11642,11645],[11645,11643,11640],[11643,11645,11646],[11646,11644,11643],[11076,11073,11635],[11635,11636,10848],[10848,11636,10845],[10845,11636,11294],[10848,11076,11635],[10845,10846,10848],[11093,11513,11094],[11073,11074,11094],[11513,11635,11094],[11094,11635,11073],[11291,11288,11647],[11292,11291,11647],[11293,11292,11647],[11647,11648,11293],[11293,11648,11129],[11129,11648,11128],[11128,11648,11130],[11130,11648,11131],[11636,11644,11294],[11294,11644,11295],[11647,11295,11644],[11295,11647,11288],[11288,11289,11295],[11647,11644,11646],[11646,11648,11647],[11651,11650,11649],[11649,11652,11651],[11652,11649,11653],[11653,11654,11652],[11184,11185,11650],[11185,11333,11650],[11184,11650,11186],[11333,11329,11649],[11329,11330,11649],[11649,11650,11333],[11330,11335,11649],[11335,11330,11332],[11334,11315,11653],[11653,11649,11334],[11334,11649,11335],[11651,11652,11655],[11655,11656,11651],[11656,11655,11657],[11657,11658,11656],[11652,11654,11659],[11659,11655,11652],[11655,11659,11660],[11660,11657,11655],[11651,11656,11661],[11661,11650,11651],[11650,11661,11578],[11650,11578,11179],[11186,11179,11180],[11179,11186,11650],[11656,11658,11662],[11662,11661,11656],[11661,11662,11579],[11579,11578,11661],[11665,11664,11663],[11663,11666,11665],[11666,11663,11662],[11662,11658,11666],[11664,11591,11590],[11590,11663,11664],[11663,11590,11579],[11579,11662,11663],[11665,11666,11667],[11667,11668,11665],[11668,11667,11669],[11669,11670,11668],[11666,11658,11657],[11657,11667,11666],[11667,11657,11660],[11660,11669,11667],[11665,11668,11671],[11671,11664,11665],[11664,11671,11594],[11594,11591,11664],[11668,11670,11672],[11672,11671,11668],[11671,11672,11595],[11595,11594,11671],[11675,11674,11673],[11673,11676,11675],[11676,11673,11672],[11672,11670,11676],[11674,11603,11602],[11602,11673,11674],[11673,11602,11595],[11595,11672,11673],[11675,11676,11677],[11677,11678,11675],[11678,11677,11679],[11679,11680,11678],[11676,11670,11669],[11669,11677,11676],[11677,11669,11660],[11660,11679,11677],[11675,11678,11681],[11681,11682,11675],[11682,11681,11610],[11610,11607,11682],[11678,11680,11683],[11683,11681,11678],[11681,11683,11611],[11611,11610,11681],[11675,11682,11684],[11684,11674,11675],[11674,11684,11608],[11608,11603,11674],[11682,11607,11606],[11606,11684,11682],[11684,11606,11609],[11609,11608,11684],[11687,11686,11685],[11685,11688,11687],[11688,11685,11683],[11683,11680,11688],[11686,11620,11619],[11619,11685,11686],[11685,11619,11611],[11611,11683,11685],[11687,11688,11689],[11689,11690,11687],[11690,11689,11691],[11691,11692,11690],[11688,11680,11679],[11679,11689,11688],[11689,11679,11660],[11660,11691,11689],[11687,11690,11693],[11693,11694,11687],[11694,11693,11629],[11629,11624,11694],[11690,11692,11695],[11695,11693,11690],[11693,11695,11630],[11630,11629,11693],[11687,11694,11696],[11696,11686,11687],[11686,11696,11625],[11625,11620,11686],[11694,11624,11623],[11623,11696,11694],[11696,11623,11626],[11626,11625,11696],[11699,11698,11697],[11697,11700,11699],[11700,11697,11695],[11695,11692,11700],[11698,11642,11641],[11641,11697,11698],[11697,11641,11630],[11630,11695,11697],[11699,11700,11701],[11701,11702,11699],[11702,11701,11703],[11703,11704,11702],[11700,11692,11691],[11691,11701,11700],[11701,11691,11660],[11660,11703,11701],[11699,11702,11705],[11705,11698,11699],[11698,11705,11645],[11645,11642,11698],[11702,11704,11706],[11706,11705,11702],[11705,11706,11646],[11646,11645,11705],[11709,11708,11707],[11707,11710,11709],[11710,11707,11706],[11706,11704,11710],[11708,11131,11648],[11131,11708,11121],[11121,11122,11131],[11648,11707,11708],[11707,11648,11646],[11646,11706,11707],[11709,11710,11711],[11711,11712,11709],[11712,11711,11659],[11659,11654,11712],[11710,11704,11703],[11703,11711,11710],[11711,11703,11660],[11660,11659,11711],[11709,11712,11713],[11713,11708,11709],[11713,11317,11708],[11317,11713,11318],[11318,11713,11319],[11124,11708,11126],[11126,11708,11317],[11124,11121,11708],[11712,11654,11653],[11653,11713,11712],[11653,11314,11713],[11314,11311,11713],[11314,11653,11315],[11319,11713,11311],[11311,11312,11319],[11716,11715,11714],[11714,11717,11716],[11282,11277,11714],[11277,11278,11714],[11278,11717,11714],[11279,11717,11278],[11717,11279,11286],[11715,11719,11718],[11718,11714,11715],[11118,11281,11718],[11281,11714,11718],[11714,11281,11282],[11716,11717,11720],[11720,11721,11716],[11721,11720,11566],[11566,11567,11721],[11286,11287,11717],[11720,11283,11284],[11287,11283,11717],[11283,11720,11717],[11284,11285,11720],[11285,11066,11720],[11066,11062,11720],[11062,11566,11720],[11566,11062,11063],[11716,11721,11722],[11722,11723,11716],[11723,11722,11724],[11724,11725,11723],[11721,11567,11573],[11573,11722,11721],[11722,11573,11554],[11554,11724,11722],[11716,11723,11726],[11726,11715,11716],[11715,11726,11727],[11727,11719,11715],[11723,11725,11728],[11728,11726,11723],[11726,11728,11729],[11729,11727,11726],[11732,11731,11730],[11730,11733,11732],[11733,11730,11728],[11728,11725,11733],[11731,11735,11734],[11734,11730,11731],[11730,11734,11729],[11729,11728,11730],[11732,11733,11736],[11736,11737,11732],[11737,11736,11552],[11552,11553,11737],[11733,11725,11724],[11724,11736,11733],[11736,11724,11554],[11554,11552,11736],[11732,11737,11738],[11738,11739,11732],[11739,11738,11740],[11740,11741,11739],[11737,11553,11561],[11561,11738,11737],[11738,11561,11538],[11538,11740,11738],[11732,11739,11742],[11742,11731,11732],[11731,11742,11743],[11743,11735,11731],[11739,11741,11744],[11744,11742,11739],[11742,11744,11745],[11745,11743,11742],[11748,11747,11746],[11746,11749,11748],[11749,11746,11744],[11744,11741,11749],[11747,11751,11750],[11750,11746,11747],[11746,11750,11745],[11745,11744,11746],[11748,11749,11752],[11752,11753,11748],[11753,11752,11536],[11536,11537,11753],[11749,11741,11740],[11740,11752,11749],[11752,11740,11538],[11538,11536,11752],[11748,11753,11754],[11754,11755,11748],[11755,11754,11756],[11756,11757,11755],[11753,11537,11545],[11545,11754,11753],[11754,11545,11522],[11522,11756,11754],[11748,11755,11758],[11758,11747,11748],[11747,11758,11759],[11759,11751,11747],[11755,11757,11760],[11760,11758,11755],[11758,11760,11761],[11761,11759,11758],[11764,11763,11762],[11762,11765,11764],[11765,11762,11760],[11760,11757,11765],[11763,11767,11766],[11766,11762,11763],[11762,11766,11761],[11761,11760,11762],[11764,11765,11768],[11768,11769,11764],[11769,11768,11520],[11520,11521,11769],[11765,11757,11756],[11756,11768,11765],[11768,11756,11522],[11522,11520,11768],[11764,11769,11770],[11770,11771,11764],[11014,11770,11016],[11014,11011,11771],[11770,11014,11771],[11012,11025,11771],[11011,11012,11771],[11769,11521,11529],[11529,11770,11769],[11018,11529,11251],[11018,11017,11770],[11529,11018,11770],[11017,11016,11770],[11764,11771,11772],[11772,11763,11764],[11763,11772,11773],[11773,11767,11763],[11024,11771,11025],[11023,11022,11772],[11024,11023,11772],[11771,11024,11772],[11020,11772,11022],[11020,11021,11773],[11772,11020,11773],[11776,11775,11774],[11774,11777,11776],[11201,11340,11775],[11340,11774,11775],[11774,11340,11341],[11777,11774,11778],[11778,11779,11777],[11341,11336,11774],[11336,11337,11774],[11778,11343,11344],[11337,11338,11774],[11338,11343,11774],[11343,11778,11774],[11776,11781,11780],[11780,11775,11776],[11781,11783,11782],[11782,11780,11781],[11775,11199,11200],[11199,11775,11780],[11775,11200,11201],[11780,11197,11198],[11197,11780,11782],[11780,11198,11199],[11776,11785,11784],[11784,11781,11776],[11785,11787,11786],[11786,11784,11785],[11781,11784,11788],[11788,11783,11781],[11784,11786,11789],[11789,11788,11784],[11776,11777,11790],[11790,11785,11776],[11777,11779,11791],[11791,11790,11777],[11785,11790,11792],[11792,11787,11785],[11790,11791,11793],[11793,11792,11790],[11796,11795,11794],[11794,11797,11796],[11795,11787,11792],[11792,11794,11795],[11797,11794,11798],[11798,11799,11797],[11794,11792,11793],[11793,11798,11794],[11796,11801,11800],[11800,11795,11796],[11801,11803,11802],[11802,11800,11801],[11795,11800,11786],[11786,11787,11795],[11800,11802,11789],[11789,11786,11800],[11796,11805,11804],[11804,11801,11796],[11805,11807,11806],[11806,11804,11805],[11801,11804,11808],[11808,11803,11801],[11804,11806,11809],[11809,11808,11804],[11796,11797,11810],[11810,11805,11796],[11797,11799,11811],[11811,11810,11797],[11805,11810,11812],[11812,11807,11805],[11810,11811,11813],[11813,11812,11810],[11816,11815,11814],[11814,11817,11816],[11815,11807,11812],[11812,11814,11815],[11817,11814,11818],[11818,11819,11817],[11814,11812,11813],[11813,11818,11814],[11816,11821,11820],[11820,11815,11816],[11821,11823,11822],[11822,11820,11821],[11815,11820,11806],[11806,11807,11815],[11820,11822,11809],[11809,11806,11820],[11816,11825,11824],[11824,11821,11816],[11825,11827,11826],[11826,11824,11825],[11821,11824,11828],[11828,11823,11821],[11824,11826,11829],[11829,11828,11824],[11816,11817,11830],[11830,11825,11816],[11817,11819,11831],[11831,11830,11817],[11825,11830,11832],[11832,11827,11825],[11830,11831,11833],[11833,11832,11830],[11836,11835,11834],[11834,11837,11836],[11835,11827,11832],[11832,11834,11835],[11837,11834,11838],[11838,11839,11837],[11834,11832,11833],[11833,11838,11834],[11836,11841,11840],[11840,11835,11836],[11841,11843,11842],[11842,11840,11841],[11835,11840,11826],[11826,11827,11835],[11840,11842,11829],[11829,11826,11840],[11836,11845,11844],[11844,11841,11836],[11146,11147,11845],[11147,11148,11845],[11844,11845,11148],[11841,11844,11846],[11846,11843,11841],[11148,11149,11844],[11149,11150,11844],[11846,11844,11150],[11836,11837,11847],[11847,11845,11836],[11837,11839,11848],[11848,11847,11837],[11327,11325,11847],[11845,11847,11325],[11325,11146,11845],[11321,11848,11323],[11322,11328,11847],[11321,11322,11847],[11848,11321,11847],[11326,11327,11847],[11328,11326,11847],[11849,11206,11207],[11206,11849,11205],[11204,11849,11850],[11849,11204,11205],[11850,11203,11204],[11853,11852,11851],[11851,11854,11853],[11852,11783,11788],[11788,11851,11852],[11854,11851,11855],[11855,11856,11854],[11851,11788,11789],[11789,11855,11851],[11853,11858,11857],[11857,11852,11853],[11194,11858,11193],[11194,11195,11857],[11858,11194,11857],[11852,11857,11782],[11782,11783,11852],[11196,11857,11195],[11196,11197,11782],[11857,11196,11782],[11853,11860,11859],[11859,11858,11853],[11860,11862,11861],[11861,11859,11860],[11858,11859,11849],[11192,11193,11858],[11207,11192,11858],[11849,11207,11858],[11859,11861,11850],[11850,11849,11859],[11853,11854,11863],[11863,11860,11853],[11854,11856,11864],[11864,11863,11854],[11860,11863,11865],[11865,11862,11860],[11863,11864,11866],[11866,11865,11863],[11869,11868,11867],[11867,11870,11869],[11868,11803,11808],[11808,11867,11868],[11870,11867,11871],[11873,11872,11871],[11872,11874,11871],[11875,11870,11874],[11874,11870,11871],[11871,11876,11873],[11867,11808,11809],[11809,11871,11867],[11869,11878,11877],[11877,11868,11869],[11878,11856,11855],[11855,11877,11878],[11868,11877,11802],[11802,11803,11868],[11877,11855,11789],[11789,11802,11877],[11869,11880,11879],[11879,11878,11869],[11880,11882,11881],[11881,11879,11880],[11878,11879,11864],[11864,11856,11878],[11879,11881,11866],[11866,11864,11879],[11869,11870,11883],[11883,11880,11869],[11884,11870,11875],[11886,11883,11885],[11883,11870,11885],[11885,11870,11887],[11887,11870,11884],[11889,11888,11880],[11891,11883,11890],[11883,11891,11889],[11889,11880,11883],[11888,11882,11880],[11886,11890,11883],[11894,11893,11892],[11892,11895,11894],[11893,11823,11828],[11828,11892,11893],[11895,11892,11896],[11896,11897,11895],[11892,11828,11829],[11829,11896,11892],[11894,11899,11898],[11898,11893,11894],[11901,11900,11899],[11900,11902,11899],[11876,11871,11903],[11903,11871,11902],[11902,11871,11899],[11871,11898,11899],[11893,11898,11822],[11822,11823,11893],[11898,11871,11809],[11809,11822,11898],[11894,11905,11904],[11904,11899,11894],[11905,11907,11906],[11904,11909,11908],[11909,11905,11906],[11909,11904,11905],[11908,11910,11904],[11904,11911,11899],[11911,11912,11899],[11912,11913,11899],[11913,11914,11899],[11914,11901,11899],[11911,11904,11910],[11894,11895,11915],[11915,11905,11894],[11895,11897,11916],[11916,11915,11895],[11905,11915,11917],[11917,11907,11905],[11915,11916,11918],[11918,11917,11915],[11921,11920,11919],[11919,11922,11921],[11920,11843,11846],[11846,11919,11920],[11141,11143,11919],[11143,11922,11919],[11922,11143,11144],[11150,11142,11846],[11142,11919,11846],[11919,11142,11141],[11921,11924,11923],[11923,11920,11921],[11924,11897,11896],[11896,11923,11924],[11920,11923,11842],[11842,11843,11920],[11923,11896,11829],[11829,11842,11923],[11921,11926,11925],[11925,11924,11921],[11926,11928,11927],[11927,11925,11926],[11924,11925,11916],[11916,11897,11924],[11925,11927,11918],[11918,11916,11925],[11921,11922,11929],[11929,11926,11921],[11144,11133,11922],[11133,11134,11922],[11134,11930,11922],[11930,11929,11922],[11926,11929,11931],[11931,11928,11926],[11929,11930,11932],[11932,11931,11929],[11930,11135,11136],[11135,11930,11134],[11137,11138,11932],[11136,11137,11930],[11932,11930,11137],[11935,11934,11933],[11933,11936,11935],[11934,11938,11937],[11937,11933,11934],[11936,11933,11939],[11939,11940,11936],[11933,11937,11941],[11941,11939,11933],[11935,11943,11942],[11942,11934,11935],[11943,11839,11838],[11838,11942,11943],[11934,11942,11944],[11944,11938,11934],[11942,11838,11833],[11833,11944,11942],[11935,11946,11945],[11945,11943,11935],[11946,11169,11177],[11169,11946,11168],[11174,11175,11945],[11177,11174,11945],[11946,11177,11945],[11943,11945,11848],[11848,11839,11943],[11945,11176,11324],[11176,11945,11175],[11324,11323,11848],[11945,11324,11848],[11935,11936,11947],[11947,11946,11935],[11936,11940,11948],[11948,11947,11936],[11170,11947,11350],[11170,11171,11946],[11947,11170,11946],[11167,11168,11946],[11171,11167,11946],[11346,11948,11348],[11347,11351,11947],[11346,11347,11947],[11948,11346,11947],[11349,11350,11947],[11351,11349,11947],[11951,11950,11949],[11949,11952,11951],[11950,11954,11953],[11953,11949,11950],[11952,11949,11955],[11955,11956,11952],[11949,11953,11957],[11957,11955,11949],[11951,11959,11958],[11958,11950,11951],[11959,11819,11818],[11818,11958,11959],[11950,11958,11960],[11960,11954,11950],[11958,11818,11813],[11813,11960,11958],[11951,11962,11961],[11961,11959,11951],[11962,11938,11944],[11944,11961,11962],[11959,11961,11831],[11831,11819,11959],[11961,11944,11833],[11833,11831,11961],[11951,11952,11963],[11963,11962,11951],[11952,11956,11964],[11964,11963,11952],[11962,11963,11937],[11937,11938,11962],[11963,11964,11941],[11941,11937,11963],[11967,11966,11965],[11965,11968,11967],[11966,11970,11969],[11969,11965,11966],[11968,11965,11971],[11971,11972,11968],[11965,11969,11973],[11973,11971,11965],[11967,11975,11974],[11974,11966,11967],[11975,11799,11798],[11798,11974,11975],[11966,11974,11976],[11976,11970,11966],[11974,11798,11793],[11793,11976,11974],[11967,11978,11977],[11977,11975,11967],[11978,11954,11960],[11960,11977,11978],[11975,11977,11811],[11811,11799,11975],[11977,11960,11813],[11813,11811,11977],[11967,11968,11979],[11979,11978,11967],[11968,11972,11980],[11980,11979,11968],[11978,11979,11953],[11953,11954,11978],[11979,11980,11957],[11957,11953,11979],[11983,11982,11981],[11981,11984,11983],[11165,11162,11982],[11162,11163,11982],[11981,11164,11308],[11163,11164,11982],[11164,11981,11982],[11984,11981,11985],[11985,11986,11984],[11308,11304,11981],[11304,11305,11981],[11985,11306,11310],[11305,11306,11981],[11306,11985,11981],[11983,11988,11987],[11987,11982,11983],[11988,11779,11778],[11778,11987,11988],[11158,11157,11987],[11157,11154,11987],[11154,11982,11987],[11155,11982,11154],[11982,11155,11165],[11344,11342,11778],[11342,11987,11778],[11160,11987,11342],[11987,11160,11158],[11983,11990,11989],[11989,11988,11983],[11990,11970,11976],[11976,11989,11990],[11988,11989,11791],[11791,11779,11988],[11989,11976,11793],[11793,11791,11989],[11983,11984,11991],[11991,11990,11983],[11984,11986,11992],[11992,11991,11984],[11990,11991,11969],[11969,11970,11990],[11991,11992,11973],[11973,11969,11991],[11993,11187,11188],[11993,10856,11187],[10856,11993,11994],[10853,10856,11994],[11010,10853,11994],[10856,10853,10854],[11202,11203,11850],[11202,11188,11189],[11202,11850,11993],[11188,11202,11993],[11995,11001,11002],[11995,11000,11001],[11010,11994,11996],[11009,11010,11996],[11002,11009,11995],[11009,11002,11003],[11996,11995,11009],[11995,11005,11000],[11005,11995,11997],[11006,11005,11997],[11243,11006,11997],[11244,11243,11997],[11245,11244,11997],[11995,11996,11998],[11998,11997,11995],[12001,12000,11999],[11999,12002,12001],[12000,11862,11865],[11865,11999,12000],[12002,11999,12003],[12003,12004,12002],[11999,11865,11866],[11866,12003,11999],[12001,12006,12005],[12005,12000,12001],[12006,11994,11993],[11993,12005,12006],[12000,12005,11861],[11861,11862,12000],[12005,11993,11850],[11850,11861,12005],[12001,12008,12007],[12007,12006,12001],[12008,12010,12009],[12009,12007,12008],[12006,12007,11996],[11996,11994,12006],[12007,12009,11998],[11998,11996,12007],[12001,12002,12011],[12011,12008,12001],[12002,12004,12012],[12012,12011,12002],[12008,12011,12013],[12013,12010,12008],[12011,12012,12014],[12014,12013,12011],[11889,12016,12015],[12016,11889,11891],[11886,11891,11890],[12016,11886,11885],[11891,11886,12016],[12015,11882,11888],[11888,11889,12015],[12016,12018,12017],[12017,12015,12016],[12018,12004,12003],[12003,12017,12018],[12015,12017,11881],[11881,11882,12015],[12017,12003,11866],[11866,11881,12017],[12016,12020,12019],[12019,12018,12016],[12020,12022,12021],[12021,12019,12020],[12018,12019,12012],[12012,12004,12018],[12019,12021,12014],[12014,12012,12019],[12016,12024,12023],[12023,12020,12016],[12024,12026,12025],[12025,12023,12024],[12020,12023,12027],[12027,12022,12020],[12023,12025,12028],[12028,12027,12023],[12016,11885,11887],[11887,12024,12016],[11887,11884,11875],[12024,11887,11875],[12024,11875,11874],[11874,11872,12029],[12024,11874,12029],[12029,12026,12024],[11873,11876,12030],[11873,12029,11872],[12029,11873,12030],[12033,12032,12031],[12031,12034,12033],[12032,11907,11917],[11917,12031,12032],[12034,12031,12035],[12035,12036,12034],[12031,11917,11918],[11918,12035,12031],[12033,11911,11908],[11912,11911,12033],[11910,11908,11911],[11908,11909,12033],[12032,12033,11909],[12032,11909,11906],[11906,11907,12032],[11914,11913,12037],[11901,11914,12037],[11900,11901,12037],[12033,12037,11913],[11913,11912,12033],[12037,12039,12038],[11902,11900,12037],[12038,11902,12037],[11902,12038,11903],[12030,11903,12038],[11903,12030,11876],[12033,12041,12040],[12040,12037,12033],[12041,12043,12042],[12042,12040,12041],[12037,12040,12044],[12044,12039,12037],[12040,12042,12045],[12045,12044,12040],[12033,12034,12046],[12046,12041,12033],[12034,12036,12047],[12047,12046,12034],[12041,12046,12048],[12048,12043,12041],[12046,12047,12049],[12049,12048,12046],[12052,12051,12050],[12050,12053,12052],[12051,11928,11931],[11931,12050,12051],[12053,12050,12054],[12054,12055,12053],[12050,11931,11932],[11932,12054,12050],[12052,12057,12056],[12056,12051,12052],[12057,12036,12035],[12035,12056,12057],[12051,12056,11927],[11927,11928,12051],[12056,12035,11918],[11918,11927,12056],[12052,12059,12058],[12058,12057,12052],[12059,12061,12060],[12060,12058,12059],[12057,12058,12047],[12047,12036,12057],[12058,12060,12049],[12049,12047,12058],[12052,12053,12062],[12062,12059,12052],[12053,12055,12063],[12063,12062,12053],[12059,12062,12064],[12064,12061,12059],[12062,12063,12065],[12065,12064,12062],[12055,12054,10850],[12055,10850,10852],[12055,10852,11297],[11152,10850,12054],[10851,10852,10850],[11153,11152,12054],[11140,11153,11139],[12054,11932,11139],[12054,11139,11153],[11932,11138,11139],[11302,11303,12066],[11301,11302,12066],[12067,11097,11095],[11303,11300,12066],[12067,12066,11300],[12067,11300,11101],[12067,11101,11099],[12067,11099,11097],[11298,12066,12063],[12066,11298,11301],[11299,11301,11298],[12063,12055,11297],[12063,11297,11298],[12066,12067,12065],[12065,12063,12066],[12070,12069,12068],[12068,12071,12070],[12069,12073,12072],[12072,12068,12069],[11046,11047,12068],[11049,11046,12068],[12071,12068,11047],[12071,11242,11239],[11048,11242,12071],[11047,11048,12071],[11044,11042,12072],[12068,12072,11042],[12068,11042,11039],[11039,11049,12068],[11049,11039,11040],[12070,12075,12074],[12074,12069,12070],[12075,12077,12076],[12076,12074,12075],[12069,12074,12078],[12078,12073,12069],[12074,12076,12079],[12079,12078,12074],[12070,12071,12080],[12080,12075,12070],[11245,11239,11240],[11997,12071,11245],[11239,11245,12071],[11997,12080,12071],[12075,12080,12081],[12081,12077,12075],[12080,11997,11998],[11998,12081,12080],[12084,12083,12082],[12082,12085,12084],[12083,12077,12081],[12081,12082,12083],[12085,12082,12009],[12009,12010,12085],[12082,12081,11998],[11998,12009,12082],[12084,12087,12086],[12086,12083,12084],[12087,12089,12088],[12088,12086,12087],[12083,12086,12076],[12076,12077,12083],[12086,12088,12079],[12079,12076,12086],[12084,12085,12090],[12090,12087,12084],[12085,12010,12013],[12013,12090,12085],[12087,12090,12091],[12091,12089,12087],[12090,12013,12014],[12014,12091,12090],[12094,12093,12092],[12092,12095,12094],[12093,12089,12091],[12091,12092,12093],[12095,12092,12021],[12021,12022,12095],[12092,12091,12014],[12014,12021,12092],[12094,12097,12096],[12096,12093,12094],[12097,12099,12098],[12098,12096,12097],[12093,12096,12088],[12088,12089,12093],[12096,12098,12079],[12079,12088,12096],[12094,12101,12100],[12100,12097,12094],[12101,12026,12029],[12029,12100,12101],[12097,12100,12102],[12102,12099,12097],[12100,12029,12030],[12030,12102,12100],[12094,12095,12103],[12103,12101,12094],[12095,12022,12027],[12027,12103,12095],[12101,12103,12025],[12025,12026,12101],[12103,12027,12028],[12028,12025,12103],[12106,12105,12104],[12104,12107,12106],[12105,12099,12102],[12102,12104,12105],[12107,12104,12038],[12038,12039,12107],[12104,12102,12030],[12030,12038,12104],[12106,12109,12108],[12108,12105,12106],[12109,12111,12110],[12110,12108,12109],[12105,12108,12098],[12098,12099,12105],[12108,12110,12079],[12079,12098,12108],[12106,12113,12112],[12112,12109,12106],[12113,12043,12048],[12048,12112,12113],[12109,12112,12114],[12114,12111,12109],[12112,12048,12049],[12049,12114,12112],[12106,12107,12115],[12115,12113,12106],[12107,12039,12044],[12044,12115,12107],[12113,12115,12042],[12042,12043,12113],[12115,12044,12045],[12045,12042,12115],[12118,12117,12116],[12116,12119,12118],[12117,12111,12114],[12114,12116,12117],[12119,12116,12060],[12060,12061,12119],[12116,12114,12049],[12049,12060,12116],[12118,12121,12120],[12120,12117,12118],[12121,12123,12122],[12122,12120,12121],[12117,12120,12110],[12110,12111,12117],[12120,12122,12079],[12079,12110,12120],[12118,12119,12124],[12124,12121,12118],[12119,12061,12064],[12064,12124,12119],[12121,12124,12125],[12125,12123,12121],[12124,12064,12065],[12065,12125,12124],[12128,12127,12126],[12126,12129,12128],[12127,12123,12125],[12125,12126,12127],[12129,12126,12067],[11095,12129,12067],[12129,11095,11105],[11098,11105,11095],[12126,12125,12065],[12065,12067,12126],[12128,12131,12130],[12130,12127,12128],[12131,12073,12078],[12078,12130,12131],[12127,12130,12122],[12122,12123,12127],[12130,12078,12079],[12079,12122,12130],[12128,12129,12132],[12132,12131,12128],[12129,11103,11104],[12129,11104,11274],[11105,11103,12129],[11274,12132,12129],[12132,11274,11270],[12132,11270,11271],[12131,12132,12072],[12072,12073,12131],[12132,11271,11276],[11273,11276,11271],[11275,12072,12132],[11276,11275,12132],[12072,11275,11044],[12135,12134,12133],[12133,12136,12135],[11107,11108,12134],[11108,11120,12134],[11120,11119,12134],[11119,12133,12134],[12133,11119,11116],[12136,12133,11718],[11718,11719,12136],[11116,11117,12133],[11718,11117,11118],[11117,11718,12133],[12135,12138,12137],[12137,12134,12135],[12138,11986,11985],[11985,12137,12138],[11113,11110,12137],[11110,11106,12137],[11106,12134,12137],[12134,11106,11107],[11310,11309,11985],[11309,11114,11985],[11114,11112,11985],[11112,12137,11985],[12137,11112,11113],[12135,12140,12139],[12139,12138,12135],[12140,12142,12141],[12141,12139,12140],[12138,12139,11992],[11992,11986,12138],[12139,12141,11973],[11973,11992,12139],[12135,12136,12143],[12143,12140,12135],[12136,11719,11727],[11727,12143,12136],[12140,12143,12144],[12144,12142,12140],[12143,11727,11729],[11729,12144,12143],[12147,12146,12145],[12145,12148,12147],[12146,12142,12144],[12144,12145,12146],[12148,12145,11734],[11734,11735,12148],[12145,12144,11729],[11729,11734,12145],[12147,12150,12149],[12149,12146,12147],[12150,11972,11971],[11971,12149,12150],[12146,12149,12141],[12141,12142,12146],[12149,11971,11973],[11973,12141,12149],[12147,12152,12151],[12151,12150,12147],[12152,12154,12153],[12153,12151,12152],[12150,12151,11980],[11980,11972,12150],[12151,12153,11957],[11957,11980,12151],[12147,12148,12155],[12155,12152,12147],[12148,11735,11743],[11743,12155,12148],[12152,12155,12156],[12156,12154,12152],[12155,11743,11745],[11745,12156,12155],[12159,12158,12157],[12157,12160,12159],[12158,12154,12156],[12156,12157,12158],[12160,12157,11750],[11750,11751,12160],[12157,12156,11745],[11745,11750,12157],[12159,12162,12161],[12161,12158,12159],[12162,11956,11955],[11955,12161,12162],[12158,12161,12153],[12153,12154,12158],[12161,11955,11957],[11957,12153,12161],[12159,12164,12163],[12163,12162,12159],[12164,12166,12165],[12165,12163,12164],[12162,12163,11964],[11964,11956,12162],[12163,12165,11941],[11941,11964,12163],[12159,12160,12167],[12167,12164,12159],[12160,11751,11759],[11759,12167,12160],[12164,12167,12168],[12168,12166,12164],[12167,11759,11761],[11761,12168,12167],[12171,12170,12169],[12169,12172,12171],[12170,12166,12168],[12168,12169,12170],[12172,12169,11766],[11766,11767,12172],[12169,12168,11761],[11761,11766,12169],[12171,12174,12173],[12173,12170,12171],[12174,11940,11939],[11939,12173,12174],[12170,12173,12165],[12165,12166,12170],[12173,11939,11941],[11941,12165,12173],[12171,12176,12175],[12175,12174,12171],[12176,11211,11219],[11215,11216,12175],[11219,11215,12175],[12176,11219,12175],[12174,12175,11948],[11948,11940,12174],[11217,12175,11216],[11218,11348,11948],[11217,11218,11948],[12175,11217,11948],[12171,12172,12177],[12177,12176,12171],[12172,11767,11773],[11773,12177,12172],[11209,12177,11213],[11209,11210,12176],[12177,11209,12176],[11210,11211,12176],[11212,11773,11021],[11773,11212,12177],[11212,11213,12177],[10669,10775,10774],[12178,10666,10790],[10621,12180,12179],[10622,10621,12179],[12181,10700,10813],[12183,12182,10669],[12184,10599,10761],[12185,12184,10761],[10744,10743,10602],[10602,10601,10600],[10602,10600,12184],[10744,10602,12184],[12185,10635,10634],[12182,12185,10634],[12186,10589,10757],[10590,10589,12186],[12182,10631,10775],[12186,10757,10755],[12188,12187,10713],[12188,10713,10712],[10624,12179,12186],[10755,10624,12186],[10600,10599,12184],[10634,10632,12182],[10635,10761,10760],[10632,10631,12182],[10632,10634,10633],[10761,10635,12185],[10702,10701,10703],[10789,10788,10790],[10775,10669,12182],[10668,10667,10669],[10667,10666,12178],[10788,10703,12189],[10788,12189,12178],[10701,10700,12181],[10701,12181,12189],[10669,12178,12183],[10731,10729,10728],[10813,10812,10731],[12181,10813,10731],[12181,10731,10728],[12179,10624,10622],[12180,10765,10764],[12180,10764,10646],[12180,10646,10644],[12180,10644,10643],[10592,12186,12190],[12190,12191,10592],[10592,10737,10736],[10803,10802,12187],[10689,10803,12187],[10690,10689,12187],[10691,10690,12187],[12191,10738,10737],[12186,10592,10590],[10816,10818,10817],[12191,12188,10710],[12191,10710,10818],[12180,10621,10765],[10818,10816,12191],[10710,10712,10711],[10756,10755,10757],[10591,10590,10592],[12178,10669,10667],[12178,10790,10788],[12189,10703,10701],[10802,10713,12187],[10816,10738,12191],[10737,10592,12191],[10712,10710,12188],[10623,10622,10624],[12191,12190,12192],[12192,12193,12191],[12191,12193,12194],[12194,12188,12191],[9881,10029,12195],[12195,10029,12196],[10136,10143,10135],[10018,10019,10017],[10016,10017,12197],[10017,10019,12197],[10019,10135,12197],[10135,10143,12197],[10413,12198,10414],[12200,12199,10486],[12202,10037,12201],[10419,10479,12203],[10479,10478,12203],[10478,10477,12203],[9884,12195,9886],[9886,12195,10033],[10028,10027,10029],[10029,10027,12204],[10027,10026,12204],[10026,10025,12204],[10025,10023,12204],[10023,10022,12204],[10024,10014,12205],[10014,10015,12205],[10015,10016,12205],[10519,10520,12200],[10520,10543,12200],[10543,10544,12200],[9897,12202,9898],[9898,12202,9900],[9900,12202,9905],[9905,12202,9902],[9902,12202,9903],[10412,12198,10413],[10402,12206,10403],[10403,12206,10340],[10340,12206,10339],[10420,12198,10421],[10421,12198,10410],[10410,12198,10412],[10138,10140,10142],[10143,10142,12197],[10142,10140,12197],[12203,12207,10419],[10419,12207,10420],[12197,12205,10016],[10022,10024,12204],[10486,10484,12200],[10484,10487,12200],[10487,10489,12200],[10489,10518,12200],[10518,10519,12200],[10038,10032,10037],[10033,12201,10031],[10031,12201,10032],[10032,12201,10037],[12204,12196,10029],[9881,12195,9882],[9882,12195,9883],[9883,12195,9887],[9887,12195,9884],[12205,12204,10024],[10035,10036,10034],[10037,12202,10036],[10036,12202,10034],[10034,12202,9899],[9899,12202,9897],[10339,12206,10341],[10341,12206,10342],[10342,12206,10343],[10343,12206,10344],[10344,12206,10345],[10477,10473,12203],[10473,10474,12203],[10414,12208,10415],[10415,12208,10407],[10407,12208,10405],[10405,12208,10401],[10401,12208,10400],[10474,10475,12203],[10400,12208,12206],[12198,10420,12207],[12199,12203,10475],[12201,10033,12195],[12208,10414,12198],[12206,10402,10400],[10475,10476,12199],[10476,10482,12199],[10482,10483,12199],[10483,10486,12199],[12203,12199,12209],[12209,12210,12203],[12203,12210,12211],[12211,12207,12203],[12214,12213,12212],[12217,12216,12215],[12212,12218,12214],[12221,12220,12219],[12219,12217,12222],[12215,12224,12223],[12224,12215,12216],[12215,12222,12217],[12217,12219,12220],[12227,12226,12225],[12225,12221,12228],[12227,12212,12213],[12225,12229,12227],[12212,12227,12229],[12219,12228,12221],[12221,12225,12226],[12214,12218,12230],[12230,12231,12214],[12214,12231,12232],[12232,12233,12214],[12217,12234,12216],[12214,12235,12213],[12235,12214,12233],[12227,12236,12226],[12236,12227,12237],[12235,12237,12227],[12234,12217,12238],[12239,12238,12217],[12217,12220,12239],[12234,12240,12224],[12224,12216,12234],[12221,12239,12220],[12221,12226,12236],[12239,12221,12241],[12227,12213,12235],[12236,12241,12221],[12244,12243,12242],[12244,12242,12245],[12243,12247,12246],[12243,12244,12247],[12249,12246,12248],[12249,12248,12250],[12246,12251,12243],[12246,12249,12251],[12254,12253,12252],[12245,12255,12244],[12252,12256,12254],[12252,12245,12256],[12245,12252,12255],[12250,12257,12249],[12254,12258,12253],[12258,12254,12259],[12258,12259,12209],[12209,12260,12258],[12258,12260,12261],[12261,12262,12258],[12264,12246,12263],[12258,12265,12253],[12266,12263,12246],[12246,12264,12248],[12250,12248,12264],[12244,12255,12267],[12246,12247,12266],[12265,12268,12252],[12264,12269,12250],[12244,12266,12247],[12252,12253,12265],[12252,12267,12255],[12267,12252,12268],[12266,12244,12270],[12267,12270,12244],[12265,12258,12262],[12273,12272,12271],[12271,12274,12273],[12277,12276,12275],[12279,12278,12276],[12276,12277,12280],[12282,12281,12277],[12277,12275,12282],[12279,12273,12278],[12273,12279,12272],[12276,12280,12279],[12282,12283,12281],[12283,12282,12284],[12283,12284,12285],[12285,12286,12283],[12285,12287,12286],[12287,12285,12288],[12287,12288,12211],[12211,12210,12287],[12287,12210,12209],[12209,12259,12287],[12249,12271,12272],[12279,12243,12251],[12271,12249,12257],[12277,12245,12242],[12249,12272,12279],[12283,12256,12245],[12245,12277,12281],[12279,12251,12249],[12243,12279,12280],[12277,12242,12243],[12254,12283,12286],[12245,12281,12283],[12283,12254,12256],[12243,12280,12277],[12254,12286,12287],[12287,12259,12254],[10544,10541,12200],[10541,10542,12200],[10542,10554,12200],[10554,10555,12200],[10555,12230,12200],[12230,12289,12200],[12200,12289,12261],[12261,12260,12200],[12200,12260,12209],[12209,12199,12200],[12187,12291,12290],[10693,10691,12187],[12290,10841,10693],[12290,10693,12187],[12187,12188,12194],[12194,12292,12187],[12187,12292,12293],[12293,12291,12187],[10658,10657,12294],[10838,10658,12294],[10836,10838,12294],[10770,10836,12294],[10769,10770,12294],[12295,10769,12294],[10771,12295,10835],[10836,10837,10838],[10771,10768,10769],[12295,10771,10769],[10783,10840,10841],[12290,10783,10841],[10783,12290,10784],[10785,10784,12290],[10839,10785,12290],[10656,10839,12290],[10655,10656,12290],[10654,12294,10657],[10654,10655,12290],[12294,10654,12290],[10533,12232,10534],[10534,12232,10562],[12232,10533,10530],[10558,10559,12231],[10559,10560,12231],[10560,10561,12231],[10561,10562,12231],[10562,12232,12231],[12231,10551,10558],[10553,10550,12230],[10550,10551,12230],[10551,12231,12230],[10556,10557,12230],[10557,10552,12230],[10552,10553,12230],[12230,10555,10556],[12297,12267,12296],[12297,12298,12266],[12299,12296,12267],[12266,12300,12263],[12267,12297,12270],[12267,12268,12299],[12300,12266,12298],[12266,12270,12297],[12299,12265,12301],[12302,12301,12265],[12265,12299,12268],[12264,12303,12269],[12300,12304,12264],[12303,12264,12304],[12264,12263,12300],[12265,12262,12302],[12302,12262,12261],[12261,12289,12302],[12302,12289,12230],[12230,12218,12302],[12297,12219,12298],[12219,12297,12228],[12225,12228,12297],[12302,12212,12301],[12297,12296,12225],[12215,12300,12222],[12212,12302,12218],[12219,12222,12300],[12300,12298,12219],[12300,12215,12304],[12212,12229,12299],[12299,12301,12212],[12299,12225,12296],[12225,12299,12229],[12303,12304,12215],[12215,12223,12303],[12303,12291,12293],[12293,12269,12303],[12303,12223,12290],[12290,12291,12303],[12271,12193,12192],[12192,12274,12271],[12271,12257,12194],[12194,12193,12271],[12250,12292,12194],[12194,12257,12250],[12250,12269,12293],[12293,12292,12250],[12224,12294,12290],[12290,12223,12224],[12224,12240,12295],[12295,12294,12224],[12186,12179,12305],[12305,12306,12186],[12186,12306,12192],[12192,12190,12186],[12198,12207,12211],[12211,12307,12198],[12198,12307,12308],[12308,12208,12198],[12311,12310,12309],[12310,12311,12312],[12312,12313,12310],[12314,12310,12313],[12317,12316,12315],[12309,12316,12311],[12318,12311,12316],[12321,12320,12319],[12316,12317,12318],[12324,12323,12322],[12323,12319,12325],[12325,12322,12323],[12319,12323,12321],[12320,12313,12326],[12326,12319,12320],[12313,12320,12314],[12327,12319,12326],[12311,12329,12328],[12312,12311,12330],[12313,12330,12331],[12330,12313,12312],[12328,12330,12311],[12329,12311,12318],[12319,12327,12332],[12325,12319,12333],[12332,12333,12319],[12331,12327,12313],[12326,12313,12327],[12318,12317,12329],[12334,12329,12317],[12322,12333,12335],[12333,12322,12325],[12322,12335,12336],[12336,12337,12322],[12322,12337,12338],[12338,12324,12322],[12341,12340,12339],[12339,12343,12342],[12339,12342,12341],[12346,12345,12344],[12348,12341,12347],[12351,12350,12349],[12346,12344,12343],[12345,12346,12352],[12343,12339,12353],[12351,12349,12348],[12341,12348,12340],[12350,12351,12354],[12348,12347,12351],[12343,12353,12346],[12356,12355,12350],[12350,12354,12356],[12357,12341,12342],[12341,12357,12358],[12358,12359,12341],[12347,12341,12359],[12342,12343,12357],[12343,12361,12360],[12360,12357,12343],[12344,12345,12361],[12361,12343,12344],[12359,12351,12347],[12354,12351,12362],[12363,12362,12351],[12351,12359,12363],[12364,12361,12345],[12356,12362,12365],[12362,12356,12354],[12356,12365,12366],[12366,12367,12356],[12356,12367,12308],[12308,12355,12356],[12368,12273,12274],[12273,12368,12369],[12273,12369,12370],[12370,12278,12273],[12371,12284,12282],[12282,12373,12372],[12373,12282,12275],[12282,12372,12371],[12276,12370,12374],[12373,12275,12276],[12371,12285,12284],[12370,12276,12278],[12276,12374,12373],[12285,12371,12375],[12376,12288,12285],[12285,12375,12376],[12346,12369,12368],[12368,12352,12346],[12370,12346,12353],[12346,12370,12369],[12348,12372,12373],[12373,12340,12348],[12373,12339,12340],[12370,12353,12339],[12339,12374,12370],[12339,12373,12374],[12371,12349,12350],[12371,12348,12349],[12348,12371,12372],[12350,12375,12371],[12376,12350,12355],[12350,12376,12375],[12376,12355,12308],[12308,12307,12376],[12376,12307,12211],[12211,12288,12376],[12206,12377,12338],[10345,12206,10324],[10324,12206,10323],[10323,12206,10325],[10325,12206,12338],[12206,12208,12308],[12308,12367,12206],[12206,12367,12366],[12366,12377,12206],[12180,10643,10645],[10645,10842,12378],[12180,10645,12378],[12378,12379,12180],[12180,12379,12380],[12380,12381,12180],[12180,12381,12305],[12305,12179,12180],[10798,10797,10796],[10796,10822,12382],[10798,10796,12382],[10819,10820,10821],[12383,10677,10679],[12383,10679,10819],[12383,10819,10821],[12383,10821,10799],[12383,10799,10798],[12383,10798,12382],[12378,10680,10678],[12378,10678,12383],[10677,12383,10678],[10779,12378,10780],[12378,10779,10778],[12378,10778,10844],[12378,10844,10682],[12378,10682,10680],[10842,10843,10780],[10842,10780,12378],[10254,12337,10253],[10253,12337,10252],[10252,12337,10251],[10251,12337,12336],[10249,10250,12336],[10250,10251,12336],[10326,12338,10327],[10327,12338,10347],[12338,10326,10325],[10347,12338,10346],[10346,12338,10256],[10256,12338,10255],[10255,12338,12337],[12337,10254,10255],[12385,12384,12359],[12363,12359,12384],[12386,12359,12358],[12358,12357,12386],[12360,12361,12387],[12384,12362,12363],[12388,12386,12357],[12387,12357,12360],[12359,12386,12385],[12362,12384,12389],[12390,12387,12361],[12391,12361,12364],[12357,12387,12388],[12361,12391,12390],[12389,12392,12362],[12365,12362,12392],[12320,12384,12385],[12390,12391,12316],[12310,12386,12388],[12389,12384,12323],[12321,12323,12384],[12384,12320,12321],[12316,12387,12390],[12314,12320,12386],[12385,12386,12320],[12386,12310,12314],[12309,12310,12387],[12388,12387,12310],[12387,12316,12309],[12315,12316,12391],[12392,12323,12324],[12323,12392,12389],[12392,12324,12338],[12338,12377,12392],[12392,12377,12366],[12366,12365,12392],[12391,12364,12380],[12380,12379,12391],[12391,12379,12378],[12378,12315,12391],[12368,12274,12192],[12192,12306,12368],[12368,12306,12305],[12305,12352,12368],[12345,12352,12305],[12305,12381,12345],[12345,12381,12380],[12380,12364,12345],[12317,12315,12378],[12378,12383,12317],[12317,12383,12382],[12382,12334,12317],[12178,12189,12393],[12393,12394,12178],[12178,12394,12395],[12395,12183,12178],[12195,12196,12396],[12396,12397,12195],[12195,12397,12398],[12398,12201,12195],[12401,12400,12399],[12402,12399,12400],[12401,12404,12403],[12400,12401,12405],[12400,12406,12402],[12409,12408,12407],[12408,12409,12410],[12413,12412,12411],[12403,12405,12401],[12414,12403,12404],[12412,12415,12414],[12413,12410,12409],[12414,12411,12412],[12403,12414,12415],[12409,12416,12413],[12412,12413,12416],[12402,12234,12399],[12401,12399,12234],[12408,12410,12235],[12234,12402,12240],[12235,12233,12408],[12414,12404,12239],[12239,12241,12414],[12236,12414,12241],[12414,12236,12411],[12413,12411,12236],[12234,12238,12401],[12239,12401,12238],[12401,12239,12404],[12413,12235,12410],[12236,12237,12413],[12235,12413,12237],[12408,12233,12232],[12232,12417,12408],[12408,12417,12418],[12418,12407,12408],[12421,12420,12419],[12424,12423,12422],[12422,12423,12421],[12425,12421,12423],[12420,12421,12425],[12428,12427,12426],[12426,12427,12424],[12429,12424,12427],[12423,12424,12429],[12431,12430,12420],[12419,12420,12430],[12433,12432,12428],[12434,12428,12432],[12427,12428,12434],[12435,12430,12431],[12430,12435,12436],[12423,12437,12425],[12423,12429,12438],[12420,12425,12437],[12438,12427,12439],[12437,12423,12440],[12437,12441,12420],[12427,12438,12429],[12438,12440,12423],[12420,12442,12431],[12435,12431,12442],[12442,12420,12441],[12444,12432,12443],[12427,12434,12444],[12432,12444,12434],[12444,12439,12427],[12442,12445,12435],[12435,12445,12446],[12446,12447,12435],[12435,12447,12398],[12398,12436,12435],[12450,12449,12448],[12453,12452,12451],[12452,12453,12454],[12457,12456,12455],[12455,12456,12453],[12454,12453,12456],[12456,12457,12458],[12458,12457,12459],[12460,12459,12457],[12448,12449,12452],[12449,12450,12461],[12463,12462,12450],[12461,12450,12462],[12451,12452,12449],[12464,12462,12463],[12462,12464,12465],[12424,12456,12426],[12426,12456,12428],[12459,12428,12458],[12458,12428,12456],[12428,12459,12433],[12456,12424,12454],[12450,12430,12463],[12422,12452,12424],[12448,12421,12450],[12419,12450,12421],[12452,12421,12448],[12430,12450,12419],[12454,12424,12452],[12421,12452,12422],[12463,12430,12464],[12436,12464,12430],[12464,12436,12398],[12398,12397,12464],[12464,12397,12396],[12396,12465,12464],[12202,12466,12418],[9908,9906,12418],[9906,9904,12418],[9904,9903,12418],[9903,12202,12418],[12202,12201,12398],[12398,12447,12202],[12202,12447,12446],[12446,12466,12202],[10730,10829,12467],[10728,10730,12467],[12181,10728,12467],[12467,12468,12181],[12181,12468,12469],[12469,12470,12181],[12181,12470,12393],[12393,12189,12181],[10611,10835,12295],[10610,10611,12295],[10613,10610,12295],[10832,10833,10834],[10612,10613,12295],[10832,10834,10612],[10749,10832,10612],[10749,10612,12295],[12471,10748,10749],[12471,10749,12295],[10752,10750,12471],[12467,10752,12471],[10748,12471,10750],[10830,10581,12467],[10829,10830,12467],[10579,12467,10581],[10580,10831,10751],[12467,10579,10580],[12467,10580,10751],[12467,10751,10752],[10436,10432,12232],[10432,10431,12232],[10431,10430,12232],[10430,10429,12232],[10429,12417,12232],[10530,10529,12232],[10529,10527,12232],[10527,10523,12232],[10523,10521,12232],[10521,10525,12232],[10525,10526,12232],[10526,10440,12232],[10440,10439,12232],[10439,10438,12232],[10438,10437,12232],[10437,10435,12232],[10435,10436,12232],[12418,9909,9908],[10348,10349,10354],[10349,10350,10354],[10350,10351,10354],[10351,10152,10354],[10152,10153,10354],[10153,10154,10354],[10154,10155,10354],[10155,10156,10354],[10161,9910,10159],[9909,12418,9910],[9910,12418,10159],[10159,12418,10158],[10158,12418,10160],[10160,12418,10156],[10156,12418,10354],[10269,10266,12417],[10266,10267,12417],[10267,10352,12417],[10352,10353,12417],[10353,10354,12417],[10354,12418,12417],[12417,10428,10269],[10428,12417,10429],[12442,12441,12472],[12472,12473,12442],[12437,12440,12474],[12437,12472,12441],[12474,12475,12437],[12472,12437,12475],[12444,12476,12439],[12438,12439,12476],[12438,12474,12440],[12476,12477,12438],[12474,12438,12477],[12444,12443,12478],[12479,12442,12473],[12478,12480,12444],[12476,12444,12480],[12442,12479,12445],[12472,12409,12473],[12479,12473,12409],[12409,12472,12416],[12474,12412,12475],[12412,12416,12472],[12472,12475,12412],[12412,12474,12415],[12478,12400,12480],[12476,12480,12400],[12400,12478,12406],[12476,12403,12477],[12403,12415,12474],[12474,12477,12403],[12403,12476,12405],[12400,12405,12476],[12409,12407,12479],[12479,12407,12418],[12418,12466,12479],[12479,12466,12446],[12446,12445,12479],[12478,12443,12469],[12469,12468,12478],[12478,12468,12467],[12467,12406,12478],[12459,12460,12395],[12395,12394,12459],[12459,12394,12393],[12393,12433,12459],[12432,12433,12393],[12393,12470,12432],[12432,12470,12469],[12469,12443,12432],[12402,12406,12467],[12467,12471,12402],[12402,12471,12295],[12295,12240,12402],[12182,12183,12395],[12395,12481,12182],[12182,12481,12482],[12482,12185,12182],[12204,12205,12483],[12483,12484,12204],[12204,12484,12396],[12396,12196,12204],[12487,12486,12485],[12486,12489,12488],[12488,12485,12486],[12491,12490,12489],[12489,12486,12491],[12494,12493,12492],[12495,12489,12490],[12498,12497,12496],[12493,12494,12499],[12500,12494,12497],[12492,12497,12494],[12497,12498,12500],[12496,12501,12498],[12501,12485,12502],[12502,12498,12501],[12485,12501,12487],[12493,12499,12503],[12503,12504,12493],[12493,12504,12336],[12336,12335,12493],[12486,12330,12328],[12333,12497,12492],[12490,12329,12334],[12331,12330,12501],[12330,12486,12487],[12491,12486,12329],[12328,12329,12486],[12329,12490,12491],[12492,12493,12333],[12335,12333,12493],[12487,12501,12330],[12501,12327,12331],[12332,12327,12497],[12496,12497,12327],[12327,12501,12496],[12497,12333,12332],[12507,12506,12505],[12506,12507,12508],[12508,12507,12509],[12509,12511,12510],[12512,12509,12507],[12511,12509,12512],[12510,12511,12513],[12513,12515,12514],[12518,12517,12516],[12515,12513,12519],[12514,12515,12518],[12519,12513,12511],[12520,12518,12515],[12517,12518,12520],[12505,12506,12521],[12522,12521,12506],[12521,12522,12483],[12483,12523,12521],[12521,12523,12524],[12524,12525,12521],[12527,12526,12511],[12528,12507,12505],[12512,12507,12529],[12530,12529,12507],[12529,12511,12512],[12507,12528,12530],[12511,12529,12527],[12519,12511,12526],[12526,12515,12519],[12532,12531,12515],[12515,12526,12532],[12520,12515,12531],[12517,12531,12533],[12531,12517,12520],[12505,12521,12528],[12525,12528,12521],[12457,12534,12460],[12536,12449,12535],[12534,12457,12537],[12455,12538,12457],[12461,12539,12449],[12540,12453,12536],[12451,12536,12453],[12539,12462,12541],[12538,12453,12540],[12449,12536,12451],[12537,12457,12538],[12453,12538,12455],[12535,12449,12539],[12462,12539,12461],[12465,12542,12462],[12541,12462,12542],[12542,12465,12396],[12396,12484,12542],[12542,12484,12483],[12483,12522,12542],[12509,12539,12508],[12516,12534,12518],[12537,12518,12534],[12538,12518,12537],[12518,12538,12514],[12535,12509,12536],[12510,12536,12509],[12506,12542,12522],[12514,12538,12513],[12540,12513,12538],[12508,12539,12506],[12541,12506,12539],[12539,12509,12535],[12536,12513,12540],[12513,12536,12510],[12542,12506,12541],[10147,12503,10141],[10141,12503,10140],[10140,12503,12197],[12503,12543,12197],[12197,12543,12524],[12524,12523,12197],[12197,12523,12483],[12483,12205,12197],[12184,12545,12544],[12544,10828,10745],[12544,10745,10744],[12544,10744,12184],[12184,12185,12482],[12482,12546,12184],[12184,12546,12547],[12547,12545,12184],[12382,10807,10808],[10808,10823,10825],[10808,10825,10723],[12382,10808,10723],[10723,10721,12548],[12382,10723,12548],[12382,10809,10806],[12382,10806,10807],[10809,12382,10822],[10823,10824,10825],[10720,10826,10571],[10571,10569,12544],[10720,10571,12544],[10719,10720,12544],[10568,12544,10569],[12544,10568,10827],[12544,10827,10828],[10718,12548,10721],[12548,10718,10719],[12548,10719,12544],[12336,10248,10249],[10248,12336,10242],[10242,12336,10244],[10244,12336,10245],[10245,12336,10246],[10246,12336,10247],[10247,12336,12504],[12504,10149,10247],[10149,12504,10151],[10151,12504,12503],[10146,10144,12503],[10144,10150,12503],[10150,10151,12503],[12503,10147,10146],[12549,12529,12530],[12550,12549,12528],[12530,12528,12549],[12529,12549,12551],[12526,12553,12552],[12555,12554,12531],[12556,12531,12532],[12531,12556,12555],[12533,12531,12554],[12553,12526,12527],[12551,12553,12529],[12527,12529,12553],[12532,12526,12556],[12552,12556,12526],[12557,12528,12525],[12528,12557,12550],[12557,12525,12524],[12524,12543,12557],[12557,12543,12503],[12503,12499,12557],[12499,12494,12557],[12494,12549,12550],[12550,12557,12494],[12551,12549,12498],[12500,12498,12549],[12554,12489,12495],[12549,12494,12500],[12488,12489,12556],[12498,12553,12551],[12489,12554,12555],[12552,12553,12485],[12502,12485,12553],[12485,12556,12552],[12553,12498,12502],[12556,12485,12488],[12555,12556,12489],[12554,12545,12547],[12547,12533,12554],[12554,12495,12544],[12544,12545,12554],[12534,12481,12395],[12395,12460,12534],[12534,12516,12482],[12482,12481,12534],[12517,12546,12482],[12482,12516,12517],[12517,12533,12547],[12547,12546,12517],[12490,12548,12544],[12544,12495,12490],[12490,12334,12382],[12382,12548,12490],[12558,267,266],[12558,266,265],[12558,265,264],[259,256,254],[12559,259,254],[12561,12560,342],[335,334,12562],[337,336,335],[337,335,12562],[333,12562,334],[12564,175,12563],[94,12565,93],[12563,176,187],[12563,187,186],[12561,337,12562],[343,342,12560],[344,343,12560],[345,344,12560],[324,12566,323],[341,338,12561],[342,341,12561],[255,12567,254],[12559,257,259],[257,12559,258],[12567,255,268],[12567,268,267],[12566,324,320],[12566,320,321],[12566,321,345],[12566,345,12560],[248,12568,247],[249,247,12568],[250,249,12568],[264,250,12568],[12558,264,12568],[170,12569,168],[12570,99,12565],[95,93,12565],[186,12571,12563],[178,12564,177],[12571,184,171],[12571,171,169],[12571,169,168],[12571,168,12569],[12564,179,174],[12564,174,175],[12564,178,179],[12570,12572,103],[99,12570,98],[79,105,12572],[78,79,12572],[80,78,12572],[12573,80,12572],[80,12573,81],[96,95,12565],[99,96,12565],[12571,186,185],[12571,185,183],[12571,183,184],[267,12558,12567],[337,12561,338],[12559,254,12567],[102,103,12572],[104,102,12572],[105,104,12572],[176,12563,175],[101,98,12570],[103,101,12570],[90,91,12574],[92,90,12574],[94,92,12574],[12565,94,12574],[12574,12575,12565],[12565,12575,12576],[12576,12570,12565],[12578,12577,863],[1010,1009,12579],[1009,1008,12579],[12577,12580,785],[789,788,779],[785,784,12577],[784,781,12577],[781,779,12577],[779,788,12577],[788,857,12577],[857,863,12577],[774,775,12580],[775,795,12580],[772,774,771],[778,776,12580],[776,771,12580],[771,774,12580],[1011,12579,969],[969,12579,971],[971,12579,872],[872,12579,874],[874,12579,880],[583,582,990],[582,585,990],[990,585,976],[976,585,978],[978,585,12581],[786,785,787],[795,787,12580],[787,785,12580],[849,842,850],[841,12582,842],[842,12582,850],[853,12582,843],[843,12582,841],[848,847,770],[850,12583,844],[844,12583,845],[845,12583,847],[847,12583,770],[770,12583,766],[766,12583,765],[863,864,12578],[864,860,12578],[860,858,12578],[858,861,12578],[861,865,12578],[1140,1139,12584],[1139,1136,12584],[1136,12585,12584],[12583,850,12582],[765,12586,763],[763,12586,762],[762,12586,760],[760,12586,755],[755,12586,756],[12587,743,745],[12579,1011,1010],[12582,778,12588],[854,855,853],[778,12582,856],[856,12582,855],[855,12582,853],[745,746,12587],[746,759,12587],[759,751,12587],[751,752,12587],[752,756,12587],[756,12586,12587],[12586,765,12583],[878,12589,871],[871,12589,870],[870,12589,868],[868,12589,867],[867,12589,865],[865,12589,12578],[742,743,12585],[743,12587,12585],[12585,1142,1141],[12590,1006,1007],[1006,12590,1008],[1008,12590,12579],[980,12581,981],[981,12581,982],[12591,586,587],[586,12591,585],[585,12591,12581],[12593,12592,500],[982,12581,983],[983,12581,985],[985,12581,1007],[1007,12581,12590],[12595,603,12594],[12596,12593,573],[603,12595,602],[602,12595,601],[601,12595,599],[599,12595,596],[596,12595,595],[880,12579,879],[879,12579,12589],[12597,500,12592],[558,559,12593],[559,572,12593],[572,573,12593],[12598,12596,465],[12584,1115,1140],[1117,1114,12599],[1114,1115,12599],[1115,12584,12599],[1142,12585,1137],[1137,12585,1136],[12599,1111,1108],[482,1122,481],[481,1122,492],[1122,1112,492],[1112,1111,492],[1111,12599,492],[12600,490,491],[500,12597,498],[498,12597,497],[497,12597,494],[494,12597,493],[1108,1109,12599],[1109,1117,12599],[493,12597,496],[496,12597,505],[12594,517,12597],[517,12594,509],[509,12594,510],[510,12594,511],[511,12594,513],[513,12594,514],[514,12594,591],[591,12594,603],[505,12597,506],[506,12597,516],[516,12597,517],[595,12595,592],[592,12595,594],[594,12595,598],[598,12595,588],[588,12595,587],[587,12595,12591],[471,472,12598],[472,474,12598],[474,475,12598],[475,477,12598],[477,490,12598],[490,12600,12598],[577,560,12593],[560,558,12593],[12580,12588,778],[573,571,12596],[571,569,12596],[569,570,12596],[570,574,12596],[574,480,12596],[480,468,12596],[468,465,12596],[12581,980,978],[12589,878,879],[1141,1103,12585],[1103,1101,12585],[1101,740,12585],[740,741,12585],[741,742,12585],[465,466,12598],[466,458,12598],[458,459,12598],[459,461,12598],[461,471,12598],[491,492,12600],[492,12599,12600],[500,578,12593],[578,576,12593],[576,575,12593],[575,577,12593],[12593,12596,12601],[12601,12602,12593],[12593,12602,12603],[12603,12592,12593],[12606,12605,12604],[12609,12608,12607],[12605,12606,12610],[12613,12612,12611],[12615,12609,12614],[12607,12617,12616],[12617,12604,12605],[12607,12614,12609],[12605,12616,12617],[12617,12607,12608],[12619,12618,12613],[12612,12613,12618],[12613,12620,12619],[12612,12621,12615],[12609,12615,12621],[12615,12611,12612],[12619,12620,12622],[12622,12623,12619],[12619,12623,12624],[12624,12625,12619],[12627,12617,12626],[12606,12604,12627],[12628,12626,12617],[12627,12629,12606],[12617,12608,12628],[12617,12627,12604],[12630,12619,12625],[12630,12631,12612],[12609,12621,12632],[12619,12630,12618],[12609,12628,12608],[12612,12618,12630],[12612,12632,12621],[12632,12612,12631],[12628,12609,12633],[12632,12633,12609],[12636,12635,12634],[12638,12637,12636],[12635,12636,12639],[12642,12641,12640],[12636,12634,12638],[12640,12643,12642],[12646,12645,12644],[12635,12639,12647],[12647,12644,12648],[12644,12647,12649],[12646,12640,12645],[12647,12648,12635],[12640,12646,12643],[12644,12649,12646],[12651,12638,12650],[12638,12651,12637],[12651,12650,12601],[12601,12652,12651],[12651,12652,12653],[12653,12654,12651],[12656,12646,12655],[12636,12657,12639],[12657,12636,12658],[12659,12658,12636],[12647,12639,12657],[12647,12660,12649],[12636,12637,12659],[12660,12647,12661],[12656,12662,12642],[12657,12661,12647],[12642,12643,12656],[12646,12656,12643],[12646,12649,12660],[12660,12655,12646],[12651,12659,12637],[12659,12651,12654],[12665,12664,12663],[12665,12666,12664],[12668,12667,12666],[12666,12669,12668],[12666,12665,12669],[12663,12670,12665],[12673,12672,12671],[12671,12674,12673],[12676,12673,12675],[12676,12675,12677],[12673,12676,12672],[12671,12668,12674],[12668,12671,12667],[12677,12678,12676],[12680,12677,12679],[12677,12680,12678],[12680,12679,12603],[12603,12602,12680],[12680,12602,12601],[12601,12650,12680],[12663,12640,12641],[12640,12663,12664],[12671,12635,12648],[12671,12648,12644],[12635,12671,12672],[12644,12667,12671],[12640,12664,12666],[12666,12645,12640],[12666,12644,12645],[12644,12666,12667],[12638,12676,12678],[12676,12634,12635],[12676,12638,12634],[12680,12650,12638],[12635,12672,12676],[12638,12678,12680],[12598,12600,12622],[12622,12681,12598],[12598,12681,12653],[12653,12652,12598],[12598,12652,12601],[12601,12596,12598],[12572,12683,12682],[12682,12573,12572],[12572,12570,12576],[12576,12684,12572],[12572,12684,12685],[12685,12683,12572],[87,86,12686],[107,87,12686],[108,107,12686],[109,108,12686],[12687,109,12686],[112,12687,271],[12687,112,110],[12687,110,109],[82,81,12682],[83,82,12682],[85,83,12682],[12573,12682,81],[85,12686,86],[12686,85,12682],[12599,12584,12624],[12624,12623,12599],[12599,12623,12622],[12622,12600,12599],[12689,12688,12656],[12691,12690,12660],[12660,12689,12655],[12656,12692,12662],[12692,12656,12688],[12656,12655,12689],[12689,12660,12690],[12694,12693,12657],[12657,12691,12661],[12657,12658,12694],[12694,12659,12695],[12696,12695,12659],[12659,12694,12658],[12660,12661,12691],[12691,12657,12693],[12659,12654,12696],[12696,12654,12653],[12653,12681,12696],[12696,12681,12622],[12622,12620,12696],[12613,12696,12620],[12694,12615,12693],[12615,12694,12611],[12613,12611,12694],[12605,12689,12616],[12694,12695,12613],[12607,12616,12689],[12689,12690,12607],[12605,12610,12692],[12692,12688,12605],[12691,12607,12690],[12691,12693,12615],[12607,12691,12614],[12615,12614,12691],[12689,12605,12688],[12696,12613,12695],[12692,12683,12685],[12685,12662,12692],[12692,12610,12682],[12682,12683,12692],[12663,12575,12574],[12574,12670,12663],[12663,12641,12576],[12576,12575,12663],[12642,12684,12576],[12576,12641,12642],[12642,12662,12685],[12685,12684,12642],[12606,12686,12682],[12682,12610,12606],[12606,12629,12687],[12687,12686,12606],[12564,12563,12697],[12697,12698,12564],[12564,12698,12574],[12574,91,181],[12574,181,180],[12574,180,177],[12574,177,12564],[12597,12592,12603],[12603,12699,12597],[12597,12699,12700],[12700,12594,12597],[12703,12702,12701],[12701,12704,12703],[12707,12706,12705],[12708,12703,12704],[12705,12704,12707],[12710,12702,12709],[12711,12709,12702],[12702,12703,12711],[12714,12713,12712],[12716,12713,12715],[12717,12715,12713],[12715,12706,12716],[12713,12714,12717],[12718,12705,12706],[12704,12705,12708],[12706,12715,12718],[12719,12703,12708],[12703,12719,12720],[12720,12721,12703],[12711,12703,12721],[12723,12722,12714],[12724,12705,12718],[12717,12714,12722],[12725,12719,12705],[12708,12705,12719],[12705,12724,12725],[12718,12715,12724],[12715,12722,12726],[12726,12724,12715],[12722,12715,12717],[12721,12709,12711],[12709,12721,12727],[12709,12727,12728],[12728,12729,12709],[12709,12729,12730],[12730,12710,12709],[12733,12732,12731],[12732,12733,12734],[12737,12736,12735],[12736,12737,12738],[12736,12738,12739],[12739,12740,12736],[12732,12734,12741],[12741,12743,12742],[12743,12741,12744],[12741,12742,12732],[12746,12739,12745],[12748,12747,12733],[12743,12744,12746],[12739,12746,12740],[12746,12745,12743],[12733,12731,12748],[12732,12750,12749],[12731,12732,12751],[12749,12751,12732],[12750,12732,12742],[12752,12743,12745],[12738,12737,12753],[12739,12753,12754],[12753,12739,12738],[12755,12753,12737],[12743,12752,12756],[12742,12743,12750],[12756,12750,12743],[12751,12748,12731],[12754,12752,12739],[12745,12739,12752],[12748,12751,12757],[12748,12757,12758],[12758,12759,12748],[12748,12759,12700],[12700,12747,12748],[12760,12665,12670],[12665,12762,12761],[12665,12760,12762],[12761,12668,12669],[12668,12761,12763],[12761,12669,12665],[12764,12675,12673],[12673,12765,12764],[12766,12673,12674],[12673,12766,12765],[12766,12674,12668],[12668,12763,12766],[12764,12677,12675],[12677,12764,12767],[12677,12767,12768],[12768,12679,12677],[12761,12736,12740],[12746,12763,12761],[12736,12761,12762],[12766,12746,12744],[12741,12764,12765],[12761,12740,12746],[12760,12735,12736],[12736,12762,12760],[12733,12767,12764],[12764,12734,12733],[12764,12741,12734],[12746,12766,12763],[12741,12765,12766],[12766,12744,12741],[12768,12733,12747],[12733,12768,12767],[12768,12747,12700],[12700,12699,12768],[12768,12699,12603],[12603,12679,12768],[12595,12769,12730],[12730,12591,12595],[12595,12594,12700],[12700,12759,12595],[12595,12759,12758],[12758,12769,12595],[12571,12569,12770],[12770,12771,12571],[12571,12771,12772],[12772,12773,12571],[12571,12773,12697],[12697,12563,12571],[191,351,12774],[190,191,12774],[192,190,12774],[12775,165,166],[12775,166,194],[12775,194,193],[12775,193,192],[12775,192,12774],[12770,164,12775],[165,12775,164],[12770,170,167],[12770,167,163],[12770,163,164],[170,12770,12569],[12581,12729,12728],[12728,12590,12581],[12581,12591,12730],[12730,12729,12581],[12756,12752,12776],[12752,12778,12777],[12777,12776,12752],[12778,12752,12754],[12779,12753,12755],[12780,12751,12749],[12781,12778,12753],[12754,12753,12778],[12753,12779,12781],[12749,12750,12780],[12757,12751,12782],[12783,12782,12751],[12751,12780,12783],[12750,12776,12784],[12784,12780,12750],[12776,12750,12756],[12713,12778,12781],[12777,12778,12706],[12706,12776,12777],[12716,12706,12778],[12778,12713,12716],[12781,12779,12713],[12701,12702,12780],[12780,12704,12701],[12704,12780,12784],[12783,12780,12702],[12784,12776,12704],[12707,12704,12776],[12776,12706,12707],[12782,12702,12710],[12702,12782,12783],[12712,12713,12779],[12782,12710,12730],[12730,12769,12782],[12782,12769,12758],[12758,12757,12782],[12779,12755,12772],[12772,12771,12779],[12779,12771,12770],[12770,12712,12779],[12760,12670,12574],[12574,12698,12760],[12760,12698,12697],[12697,12735,12760],[12737,12735,12697],[12697,12773,12737],[12737,12773,12772],[12772,12755,12737],[12714,12712,12770],[12770,12775,12714],[12714,12775,12774],[12774,12723,12714],[12559,12567,12785],[12785,12786,12559],[12559,12786,12787],[260,258,12559],[261,260,12559],[12787,262,261],[12787,261,12559],[12582,12588,12788],[12788,12789,12582],[12582,12789,12790],[12790,12583,12582],[12793,12792,12791],[12792,12793,12794],[12795,12791,12792],[12792,12796,12795],[12799,12798,12797],[12802,12801,12800],[12803,12800,12801],[12801,12804,12803],[12803,12806,12805],[12799,12805,12806],[12806,12803,12804],[12802,12794,12793],[12793,12807,12802],[12801,12802,12807],[12798,12799,12808],[12806,12808,12799],[12627,12795,12629],[12795,12627,12791],[12793,12791,12627],[12793,12628,12807],[12801,12807,12628],[12627,12626,12793],[12628,12793,12626],[12801,12632,12804],[12798,12808,12630],[12806,12804,12632],[12632,12801,12633],[12632,12631,12806],[12628,12633,12801],[12806,12630,12808],[12630,12625,12798],[12630,12806,12631],[12798,12625,12624],[12624,12809,12798],[12798,12809,12810],[12810,12797,12798],[12813,12812,12811],[12816,12815,12814],[12818,12813,12817],[12821,12820,12819],[12819,12820,12816],[12822,12816,12820],[12820,12821,12823],[12823,12821,12824],[12825,12824,12821],[12812,12813,12818],[12811,12812,12815],[12817,12827,12826],[12828,12817,12813],[12815,12816,12822],[12814,12815,12812],[12827,12817,12828],[12820,12823,12829],[12815,12822,12830],[12830,12820,12831],[12829,12824,12832],[12824,12829,12823],[12829,12831,12820],[12820,12830,12822],[12813,12811,12833],[12833,12815,12834],[12833,12835,12813],[12813,12836,12828],[12827,12828,12836],[12836,12813,12835],[12830,12834,12815],[12815,12833,12811],[12836,12837,12827],[12827,12837,12838],[12838,12839,12827],[12827,12839,12790],[12790,12826,12827],[12842,12841,12840],[12845,12844,12843],[12848,12847,12846],[12849,12848,12842],[12850,12842,12848],[12841,12842,12850],[12847,12848,12849],[12851,12843,12844],[12853,12852,12847],[12854,12844,12845],[12840,12841,12854],[12855,12854,12841],[12844,12854,12855],[12846,12847,12852],[12856,12843,12851],[12843,12856,12857],[12812,12841,12814],[12844,12817,12851],[12814,12841,12816],[12850,12816,12841],[12848,12816,12850],[12852,12821,12846],[12821,12852,12825],[12816,12848,12819],[12819,12848,12821],[12846,12821,12848],[12817,12844,12818],[12818,12844,12812],[12855,12812,12844],[12841,12812,12855],[12851,12817,12856],[12826,12856,12817],[12856,12826,12790],[12790,12789,12856],[12856,12789,12788],[12788,12857,12856],[12586,12858,12810],[12810,12587,12586],[12586,12583,12790],[12790,12839,12586],[12586,12839,12838],[12838,12858,12586],[12558,12568,12859],[12859,12860,12558],[12558,12860,12861],[12861,12862,12558],[12558,12862,12785],[12785,12567,12558],[270,271,12687],[273,270,12687],[272,273,12687],[274,272,12687],[245,274,12687],[244,245,12687],[12863,244,12687],[244,12863,243],[12859,243,12863],[248,12859,12568],[12859,248,246],[12859,246,242],[12859,242,243],[12585,12809,12624],[12624,12584,12585],[12585,12587,12810],[12810,12809,12585],[12865,12833,12864],[12829,12832,12866],[12868,12830,12867],[12869,12867,12830],[12833,12834,12868],[12868,12864,12833],[12830,12868,12834],[12869,12829,12870],[12830,12831,12869],[12836,12835,12865],[12865,12871,12836],[12833,12865,12835],[12866,12870,12829],[12829,12869,12831],[12836,12872,12837],[12872,12836,12871],[12868,12867,12802],[12869,12870,12792],[12802,12800,12868],[12803,12868,12800],[12868,12803,12864],[12865,12864,12803],[12802,12869,12794],[12792,12866,12796],[12866,12792,12870],[12792,12794,12869],[12869,12802,12867],[12803,12805,12865],[12865,12799,12871],[12872,12871,12799],[12799,12865,12805],[12799,12797,12872],[12872,12797,12810],[12810,12858,12872],[12872,12858,12838],[12838,12837,12872],[12866,12832,12861],[12861,12860,12866],[12866,12860,12859],[12859,12796,12866],[12852,12853,12787],[12787,12786,12852],[12852,12786,12785],[12785,12825,12852],[12824,12825,12785],[12785,12862,12824],[12824,12862,12861],[12861,12832,12824],[12795,12796,12859],[12859,12863,12795],[12795,12863,12687],[12687,12629,12795],[12562,333,332],[12562,332,331],[331,262,12787],[12562,331,12787],[12787,12873,12562],[12562,12873,12874],[12874,12561,12562],[12580,12577,12875],[12875,12876,12580],[12580,12876,12788],[12788,12588,12580],[12879,12878,12877],[12882,12881,12880],[12884,12882,12883],[12886,12883,12885],[12883,12886,12884],[12880,12883,12882],[12881,12882,12887],[12878,12879,12888],[12890,12878,12889],[12888,12889,12878],[12885,12879,12886],[12877,12886,12879],[12887,12891,12881],[12892,12881,12891],[12894,12889,12893],[12889,12894,12890],[12894,12893,12895],[12895,12896,12894],[12894,12896,12728],[12728,12727,12894],[12882,12724,12726],[12727,12721,12894],[12725,12724,12886],[12724,12882,12884],[12891,12722,12723],[12726,12722,12882],[12887,12882,12722],[12722,12891,12887],[12721,12878,12890],[12890,12894,12721],[12877,12878,12719],[12720,12719,12878],[12719,12886,12877],[12878,12721,12720],[12886,12719,12725],[12884,12886,12724],[12899,12898,12897],[12902,12901,12900],[12898,12899,12903],[12905,12904,12899],[12907,12906,12901],[12909,12908,12902],[12910,12902,12908],[12906,12912,12911],[12904,12908,12909],[12901,12902,12910],[12903,12899,12904],[12908,12904,12905],[12900,12901,12906],[12912,12906,12907],[12914,12913,12912],[12911,12912,12913],[12913,12914,12875],[12875,12915,12913],[12913,12915,12916],[12916,12917,12913],[12898,12919,12918],[12920,12919,12904],[12903,12904,12919],[12919,12898,12903],[12906,12922,12921],[12923,12902,12900],[12904,12924,12920],[12925,12924,12902],[12909,12902,12924],[12924,12904,12909],[12900,12906,12923],[12921,12923,12906],[12917,12922,12913],[12911,12913,12922],[12922,12906,12911],[12902,12923,12925],[12927,12854,12926],[12929,12843,12928],[12854,12927,12840],[12931,12842,12930],[12840,12927,12842],[12926,12854,12929],[12845,12929,12854],[12842,12931,12849],[12930,12842,12927],[12843,12929,12845],[12933,12847,12932],[12849,12931,12847],[12847,12933,12853],[12932,12847,12931],[12857,12934,12843],[12928,12843,12934],[12934,12857,12788],[12788,12876,12934],[12934,12876,12875],[12875,12914,12934],[12926,12901,12927],[12910,12927,12901],[12927,12908,12930],[12908,12927,12910],[12899,12931,12905],[12931,12899,12932],[12930,12908,12931],[12905,12931,12908],[12929,12901,12926],[12912,12934,12914],[12928,12912,12929],[12907,12929,12912],[12901,12929,12907],[12932,12899,12933],[12897,12933,12899],[12934,12912,12928],[12578,12589,12895],[12895,12935,12578],[12578,12935,12916],[12916,12915,12578],[12578,12915,12875],[12875,12577,12578],[12560,12937,12936],[12936,12566,12560],[12560,12561,12874],[12874,12938,12560],[12560,12938,12939],[12939,12937,12560],[12774,349,348],[12774,348,347],[12774,347,329],[12774,329,328],[12774,328,12940],[12774,350,349],[350,12774,351],[322,323,12936],[325,322,12936],[327,325,12936],[12566,12936,323],[12940,327,12936],[327,12940,328],[12579,12590,12728],[12728,12896,12579],[12579,12896,12895],[12895,12589,12579],[12923,12942,12941],[12924,12944,12943],[12945,12942,12922],[12921,12922,12942],[12942,12923,12921],[12925,12923,12944],[12941,12944,12923],[12944,12924,12925],[12943,12946,12924],[12946,12919,12920],[12920,12924,12946],[12948,12947,12919],[12919,12946,12948],[12918,12919,12947],[12949,12922,12917],[12922,12949,12945],[12949,12917,12916],[12916,12935,12949],[12949,12935,12895],[12895,12893,12949],[12943,12944,12883],[12885,12883,12944],[12944,12879,12885],[12942,12889,12888],[12948,12946,12881],[12880,12881,12946],[12947,12881,12892],[12879,12944,12941],[12941,12942,12879],[12888,12879,12942],[12946,12883,12880],[12893,12889,12949],[12945,12949,12889],[12889,12942,12945],[12883,12946,12943],[12881,12947,12948],[12947,12937,12939],[12939,12918,12947],[12947,12892,12936],[12936,12937,12947],[12933,12873,12787],[12787,12853,12933],[12933,12897,12874],[12874,12873,12933],[12898,12938,12874],[12874,12897,12898],[12898,12918,12939],[12939,12938,12898],[12891,12940,12936],[12936,12892,12891],[12891,12723,12774],[12774,12940,12891]];
function DaggerHandle_fixed_points() = [
[-44.570004,-6.928000,-6.016000],[-44.570004,-6.846000,-5.938000],[-44.570004,-6.838000,-5.950000],[-44.570004,-6.826000,-5.970000],[-44.570004,-6.778000,-6.046000],[-44.570004,-6.862000,-5.916000],[-44.570004,-6.992000,-5.732000],[-44.208004,-11.380000,-0.228000],[-44.398003,-9.592000,-0.228000],[-44.402000,-9.480000,-1.106000],[-44.208004,-11.100000,-1.960000],[-44.400002,-9.454000,-1.296000],[-44.400002,-9.434000,-1.416000],[-44.400002,-9.406000,-1.586000],[-44.406002,-9.308001,-1.910000],[-44.208004,-10.370001,-3.718000],[-44.402000,-9.206000,-2.226000],[-44.402000,-9.132000,-2.420000],[-44.402000,-9.010000,-2.732000],[-44.402000,-9.000000,-2.762000],[-44.404003,-8.956000,-2.860000],[-44.416000,-8.824000,-3.078000],[-44.420002,-8.780001,-3.148000],[-44.424004,-8.726001,-3.218000],[-44.434002,-8.610001,-3.380000],[-44.440002,-8.544001,-3.466000],[-44.448002,-8.468000,-3.564000],[-44.456001,-8.372001,-3.724000],[-44.208004,-4.242000,-9.326000],[-44.208004,-6.476000,-8.128000],[-44.570004,-6.774000,-6.056000],[-44.560001,-6.706000,-6.148000],[-44.546001,-6.646000,-6.260000],[-44.542004,-6.632000,-6.288000],[-44.538002,-6.608000,-6.330000],[-44.524002,-6.538000,-6.458000],[-44.508003,-6.448000,-6.584000],[-44.496002,-6.360000,-6.704000],[-44.458004,-6.068000,-7.040000],[-44.456001,-6.042000,-7.070000],[-44.358002,-4.360000,-8.154000],[-44.356003,-4.302000,-8.180000],[-44.378002,-4.898000,-7.898000],[-44.396004,-5.178000,-7.708000],[-44.410004,-5.404000,-7.552001],[-44.450001,-5.994000,-7.120000],[-44.454002,-6.026000,-7.088000],[-44.458004,-8.348001,-3.764000],[-44.460003,-8.320001,-3.810000],[-44.460003,-8.302000,-3.846000],[-44.466003,-8.232000,-3.980000],[-44.474003,-8.130000,-4.120000],[-44.486004,-7.978000,-4.350000],[-44.494003,-7.896000,-4.474000],[-44.508003,-7.724000,-4.750000],[-44.512001,-7.658000,-4.856000],[-44.514004,-7.630001,-4.908000],[-44.520000,-7.546000,-5.052000],[-44.536003,-7.376000,-5.254000],[-44.552002,-7.194000,-5.480000],[-44.566002,-7.048000,-5.658000],[-44.208004,-9.308001,-5.532000],[-43.924004,-8.250000,-7.020000],[-44.330002,-2.422000,-8.820001],[-44.208004,-2.462000,-9.842000],[-44.332001,-2.470000,-8.806001],[-44.328003,-2.362000,-8.836000],[-44.328003,-2.330000,-8.844001],[-44.328003,-2.248000,-8.854000],[-44.322002,-1.400000,-8.952001],[-44.208004,-0.904000,-9.932000],[-44.318001,-0.964000,-9.002001],[-44.318001,-0.904000,-9.000000],[-44.344002,-3.978000,-8.328000],[-44.330002,-3.656000,-8.474000],[-44.330002,-3.650000,-8.476001],[-43.116001,-6.278000,-9.446000],[-43.116001,-8.760000,-7.344000],[-42.642002,-7.436000,-8.728001],[-42.642002,-8.910001,-7.480000],[-42.642002,-7.240000,-8.894000],[-42.642002,-6.622000,-9.418000],[-42.626003,-6.256001,-9.736000],[-42.582001,-5.032000,-10.662001],[-43.116001,-3.892000,-11.126000],[-42.576000,-4.832000,-10.806001],[-42.550003,-3.822000,-11.534000],[-42.546001,-3.728000,-11.604000],[-43.116001,-13.190001,-1.844000],[-43.116001,-13.570001,-0.228000],[-42.634003,-13.838000,-1.176000],[-42.630001,-14.064001,-0.228000],[-42.638000,-13.652000,-1.776000],[-42.642002,-13.272000,-2.310000],[-42.642002,-13.524000,-1.954000],[-42.642002,-13.220000,-2.380000],[-42.642002,-13.174001,-2.446000],[-43.116001,-12.196001,-3.534000],[-42.642002,-12.584001,-3.450000],[-42.642002,-13.120001,-2.540000],[-43.116001,-10.726001,-5.370000],[-42.642002,-11.712001,-4.540000],[-42.642002,-11.012000,-5.368000],[-42.642002,-11.336000,-4.986000],[-42.642002,-10.078000,-6.308000],[-42.642002,-9.652000,-6.736001],[-43.116001,-2.220000,-11.832001],[-42.528004,-2.894000,-11.968000],[-42.506001,-2.084000,-12.406000],[-42.504002,-1.934000,-12.426001],[-42.502003,-1.528000,-12.476001],[-43.116001,-0.904000,-11.940001],[-42.500004,-0.904000,-12.530001],[-44.360001,-9.292001,2.502000],[-44.360001,-9.296000,2.480000],[-44.208004,-10.370001,3.260000],[-44.376003,-9.018001,3.264000],[-44.382004,-9.464001,1.598000],[-44.386002,-9.490001,1.456000],[-44.362003,-9.312000,2.402000],[-44.208004,-11.100000,1.502000],[-44.392002,-9.568001,0.606000],[-44.386002,-9.546000,1.148000],[-44.398003,-9.588000,-0.040000],[-44.396004,-9.584001,0.170000],[-44.350002,-5.010000,7.624001],[-44.358002,-5.160000,7.534000],[-44.374001,-5.478000,7.346000],[-44.208004,-4.242000,8.868000],[-44.330002,-4.292000,7.920001],[-44.342003,-4.732000,7.738000],[-44.378002,-5.720000,7.202000],[-44.384003,-6.210001,6.906000],[-44.208004,-6.476000,7.670001],[-44.414001,-6.732000,6.470000],[-44.358002,-7.266000,6.016000],[-44.354004,-7.370000,5.894000],[-43.924004,-8.250000,6.564000],[-44.398003,-6.882000,6.344000],[-44.434002,-7.820000,5.378000],[-44.208004,-9.308001,5.076000],[-44.418003,-8.384001,4.588000],[-44.416000,-8.224000,4.864000],[-44.416000,-8.156000,4.980000],[-44.428001,-7.928000,5.250000],[-44.376003,-9.006001,3.296000],[-44.384003,-8.828000,3.790000],[-44.416000,-8.394000,4.566000],[-44.304001,-0.952000,8.652000],[-44.306004,-1.034000,8.644000],[-44.308002,-1.312000,8.616000],[-44.208004,-0.904000,9.474000],[-44.306004,-0.904000,8.650001],[-44.308002,-1.340000,8.612000],[-44.316002,-2.468000,8.476001],[-44.208004,-2.462000,9.386001],[-44.314003,-2.342000,8.508000],[-44.310001,-3.706000,8.160001],[-44.312000,-3.740000,8.148001],[-44.314003,-3.124000,8.308001],[-43.116001,-8.760000,6.888000],[-43.116001,-6.278000,8.990001],[-43.116001,-3.892000,10.668000],[-42.582001,-5.032000,10.206000],[-42.576000,-4.832000,10.350000],[-42.550003,-3.822000,11.076000],[-42.546001,-3.728000,11.146001],[-42.626003,-6.256001,9.280001],[-42.642002,-7.240000,8.438001],[-42.642002,-7.436000,8.272000],[-42.642002,-6.618001,8.964001],[-42.642002,-8.910001,7.022000],[-43.116001,-13.190001,1.386000],[-43.116001,-12.196001,3.076000],[-42.642002,-13.174001,1.988000],[-42.642002,-13.116000,2.086000],[-42.642002,-12.584001,2.992000],[-42.642002,-13.524000,1.494000],[-42.642002,-13.270000,1.854000],[-42.642002,-13.218000,1.926000],[-42.638000,-13.652000,1.318000],[-42.634003,-13.838000,0.718000],[-43.116001,-10.726001,4.912000],[-42.642002,-10.078000,5.850000],[-42.642002,-9.650001,6.280000],[-42.642002,-11.012000,4.912000],[-42.642002,-11.334001,4.530000],[-42.642002,-11.712001,4.082000],[-43.116001,-2.220000,11.374001],[-43.116001,-0.904000,11.484000],[-42.502003,-1.528000,12.018001],[-42.500004,-0.904000,12.072001],[-42.504002,-1.936000,11.968000],[-42.506001,-2.084000,11.948001],[-42.528004,-2.894000,11.510000],[-44.364002,7.462000,-2.946000],[-44.364002,7.468000,-2.926000],[-44.208004,8.560000,-3.718000],[-44.374001,7.298000,-3.322000],[-44.386002,7.122000,-3.722000],[-44.374001,7.654000,-2.218000],[-44.380001,7.734000,-1.916000],[-44.208004,9.290001,-1.960000],[-44.208004,9.570001,-0.228000],[-44.380001,7.872000,-1.012000],[-44.378002,7.850000,-1.260000],[-44.376003,7.818000,-1.598000],[-44.382004,7.942000,-0.228000],[-44.208004,2.432000,-9.326000],[-44.334003,2.484000,-8.358001],[-44.348003,3.012000,-8.140000],[-44.364002,3.286000,-7.966001],[-44.392002,3.794000,-7.646000],[-44.450001,4.968000,-6.716001],[-44.208004,4.666000,-8.128000],[-44.398003,4.182000,-7.402000],[-44.398003,4.160000,-7.416000],[-44.446003,5.016000,-6.674000],[-44.424004,5.234000,-6.486001],[-44.418003,5.432000,-6.254000],[-43.924004,6.440001,-7.020000],[-44.208004,7.498000,-5.532000],[-44.476002,5.740000,-5.888000],[-44.450001,5.604000,-6.050000],[-44.452003,6.240000,-5.266000],[-44.454002,6.144000,-5.416000],[-44.400002,6.898000,-4.230000],[-44.402000,6.858000,-4.292000],[-44.442001,6.358000,-5.080000],[-44.318001,-0.474000,-8.982000],[-44.318001,-0.424000,-8.982000],[-44.320004,0.660000,-8.896001],[-44.208004,0.652000,-9.842000],[-44.320004,0.580000,-8.914001],[-44.316002,0.406000,-8.950001],[-44.314003,1.408000,-8.736000],[-44.310001,1.744000,-8.666000],[-44.314003,1.922000,-8.592000],[-44.332001,2.448000,-8.374001],[-43.116001,6.950000,-7.344000],[-43.116001,4.468000,-9.446000],[-43.116001,2.082000,-11.126000],[-42.582001,3.222000,-10.662001],[-42.576000,3.024000,-10.804001],[-42.550003,2.018000,-11.530001],[-42.546001,1.918000,-11.604000],[-42.626003,4.446000,-9.736000],[-42.642002,5.434000,-8.890000],[-42.642002,4.812000,-9.418000],[-42.642002,5.626000,-8.728001],[-42.642002,7.100000,-7.480000],[-43.116001,11.760000,-0.228000],[-43.116001,11.380000,-1.844000],[-43.116001,10.386001,-3.534000],[-42.642002,11.308001,-2.542000],[-42.642002,10.774000,-3.450000],[-42.642002,11.364000,-2.446000],[-42.642002,11.462001,-2.308000],[-42.642002,11.718000,-1.946000],[-42.642002,11.412001,-2.380000],[-42.638000,11.842001,-1.776000],[-42.634003,12.028001,-1.176000],[-42.630001,12.254001,-0.228000],[-43.116001,8.916000,-5.370000],[-42.642002,7.844000,-6.734000],[-42.642002,8.268001,-6.308000],[-42.642002,9.202001,-5.368000],[-42.642002,9.526000,-4.986000],[-42.642002,9.902000,-4.540000],[-43.116001,0.412000,-11.832001],[-42.502003,-0.282000,-12.476001],[-42.500004,-0.902000,-12.530001],[-42.506001,0.274000,-12.406000],[-42.504002,0.130000,-12.424001],[-42.528004,1.084000,-11.968000],[-44.382004,7.944000,-0.212000],[-44.382004,7.928000,-0.032000],[-44.380001,7.872000,0.554000],[-44.208004,9.290001,1.502000],[-44.378002,7.836000,0.920000],[-44.376003,7.808001,1.196000],[-44.380001,7.738000,1.458000],[-44.208004,8.560000,3.260000],[-44.376003,7.694000,1.626000],[-44.362003,7.472000,2.470000],[-44.364002,7.444000,2.576000],[-44.378002,7.220000,3.092000],[-44.382004,7.144001,3.264000],[-44.386002,4.204000,6.996000],[-44.208004,4.666000,7.670001],[-44.416000,4.678000,6.586000],[-44.434002,4.948000,6.350000],[-44.376003,3.682000,7.328001],[-44.208004,2.432000,8.868000],[-44.338001,2.968000,7.768001],[-44.324001,2.480000,7.976000],[-44.340004,3.018000,7.746000],[-44.340004,3.036000,7.738000],[-44.342003,3.070000,7.718000],[-44.398003,6.888000,3.856000],[-44.444000,6.324000,4.752000],[-44.208004,7.498000,5.076000],[-44.444000,6.190000,4.968000],[-44.446003,6.154000,5.026000],[-44.446003,6.128000,5.056000],[-44.452003,6.016000,5.188000],[-44.464001,5.822001,5.416000],[-43.924004,6.440001,6.564000],[-44.398003,5.470000,5.826000],[-44.404003,5.252000,6.084000],[-44.306004,0.432000,8.580001],[-44.306004,-0.476000,8.628000],[-44.208004,0.652000,9.386001],[-44.310001,0.658000,8.528001],[-44.306004,-0.804000,8.644000],[-44.304001,1.964000,8.196000],[-44.306004,1.072000,8.436001],[-44.302002,1.772000,8.278001],[-43.116001,4.468000,8.990001],[-43.116001,6.950000,6.888000],[-42.642002,5.626000,8.272000],[-42.642002,7.100000,7.022000],[-42.626003,4.446000,9.280001],[-42.642002,4.808000,8.964001],[-42.642002,5.434000,8.434000],[-42.582001,3.222000,10.206000],[-43.116001,2.082000,10.668000],[-42.576000,3.024000,10.348001],[-42.550003,2.018000,11.074000],[-42.546001,1.918000,11.146001],[-43.116001,11.380000,1.386000],[-42.634003,12.028001,0.718000],[-42.638000,11.842001,1.318000],[-42.642002,11.718000,1.488000],[-42.642002,11.460001,1.854000],[-42.642002,11.408001,1.926000],[-42.642002,11.364000,1.988000],[-42.642002,11.306001,2.090000],[-42.642002,10.774000,2.992000],[-43.116001,10.386001,3.076000],[-43.116001,8.916000,4.912000],[-42.642002,9.902000,4.082000],[-42.642002,9.524000,4.530000],[-42.642002,9.202001,4.912000],[-42.642002,8.268001,5.850000],[-42.642002,7.842000,6.278000],[-43.116001,0.412000,11.374001],[-42.528004,1.084000,11.510000],[-42.506001,0.274000,11.948001],[-42.504002,0.130000,11.966001],[-42.502003,-0.282000,12.018001],[-42.500004,-0.902000,12.072001],[-32.402000,-9.572001,5.084000],[-31.762001,-9.600000,4.952000],[-31.644001,-8.912001,5.392000],[-32.354000,-8.930000,5.470000],[-33.020000,-9.572001,5.100000],[-33.054001,-8.958000,5.450000],[-32.588001,-10.094001,4.662000],[-32.020000,-10.196000,4.432000],[-33.004002,-9.958000,4.798000],[-32.352001,-8.174001,5.764000],[-31.606001,-8.154000,5.700000],[-32.364002,-7.358000,5.886000],[-31.610001,-7.358000,5.822001],[-33.088001,-8.196000,5.728000],[-33.106003,-7.358000,5.850000],[-30.842001,-8.136001,5.444000],[-30.916002,-8.888000,5.134000],[-30.050001,-8.124001,4.894000],[-30.166002,-8.866000,4.608000],[-30.832001,-7.358000,5.560000],[-30.020002,-7.358000,4.998000],[-31.088001,-9.592000,4.676000],[-31.398001,-10.222000,4.106000],[-30.392002,-9.566000,4.174000],[-30.752001,-10.202001,3.620000],[-32.352001,-6.544000,5.764000],[-31.918001,-6.556000,5.726000],[-32.302002,-6.492000,5.738000],[-32.354000,-6.482000,5.740000],[-33.088001,-6.524000,5.728000],[-33.032001,-6.466000,5.708000],[-33.086002,-6.464000,5.706000],[-31.608002,-6.616000,5.708000],[-31.650002,-6.610000,5.712000],[-31.750002,-6.594000,5.718000],[-31.506002,-6.668000,5.682000],[-30.836002,-7.010000,5.508000],[-30.278002,-7.114000,5.140000],[-30.034002,-6.976000,4.946000],[-30.610001,-7.238000,5.386000],[-30.570002,-7.274000,5.366000],[-30.558001,-7.270000,5.358000],[-29.126001,-9.496000,2.422000],[-29.694002,-9.544001,3.366000],[-29.106001,-9.534000,2.336000],[-29.166002,-9.168000,2.932000],[-29.194002,-9.026000,3.158000],[-29.396002,-8.852000,3.722000],[-29.148001,-8.850000,3.302000],[-29.596001,-10.152000,2.010000],[-29.106001,-9.548000,2.310000],[-29.106001,-9.540001,2.322000],[-30.118002,-10.172001,2.914000],[-29.170002,-8.616000,3.508000],[-29.092001,-8.298000,3.606000],[-29.218002,-8.116000,3.954000],[-29.042002,-8.116000,3.664000],[-29.042002,-7.948000,3.706000],[-29.102001,-7.430000,3.926000],[-29.104002,-7.420001,3.932000],[-29.160002,-7.358000,4.040000],[-29.116001,-7.358000,3.968000],[-29.398001,-10.160001,1.320000],[-29.132002,-7.328001,3.986000],[-29.168001,-7.252000,4.028000],[-29.296001,-7.068000,4.134000],[-29.582001,-6.946000,4.430000],[-29.412001,-6.850000,4.220000],[-29.610001,-6.962000,4.464000],[-29.848001,-6.958000,4.732000],[-29.998001,-6.948000,4.900000],[-29.106001,-9.548000,-2.766000],[-29.398001,-10.160001,-1.776000],[-29.596001,-10.152000,-2.468000],[-29.042002,-8.116000,-4.122000],[-29.092001,-8.298000,-4.064000],[-29.218002,-8.116000,-4.412000],[-29.396002,-8.852000,-4.178000],[-29.170002,-8.616000,-3.966000],[-29.148001,-8.850000,-3.758000],[-30.050001,-8.124001,-5.350000],[-30.166002,-8.866000,-5.066000],[-29.114002,-7.358000,-4.424000],[-29.104002,-7.420001,-4.390000],[-29.160002,-7.358000,-4.498000],[-29.042002,-7.948000,-4.164000],[-29.102001,-7.430000,-4.384000],[-30.020002,-7.358000,-5.456000],[-29.694002,-9.544001,-3.824000],[-29.194002,-9.026000,-3.614000],[-29.166002,-9.168000,-3.388000],[-29.126001,-9.496000,-2.880000],[-29.106001,-9.534000,-2.792000],[-30.118002,-10.172001,-3.370000],[-29.106001,-9.540001,-2.780000],[-30.392002,-9.566000,-4.632000],[-30.752001,-10.202001,-4.078000],[-29.168001,-7.252000,-4.486000],[-29.132002,-7.326000,-4.442000],[-29.610001,-6.962000,-4.920000],[-30.034002,-6.976000,-5.404000],[-29.582001,-6.946000,-4.888000],[-29.848001,-6.958000,-5.190000],[-29.996002,-6.948000,-5.356000],[-29.296001,-7.068000,-4.592000],[-29.412001,-6.850000,-4.678000],[-34.042000,-9.752001,-5.368000],[-34.042000,-9.368000,-5.606000],[-33.638000,-9.670000,-5.486000],[-34.042000,-9.034000,-5.806000],[-33.754002,-9.010000,-5.862000],[-33.020000,-9.572001,-5.558000],[-33.054001,-8.958000,-5.906000],[-34.042000,-10.116000,-5.046000],[-34.042000,-9.896001,-5.246000],[-33.982002,-10.386001,-4.810000],[-34.042000,-10.262000,-4.914000],[-33.412003,-10.176001,-5.084000],[-33.004002,-9.958000,-5.256000],[-34.042000,-8.540000,-5.992000],[-34.042000,-8.516001,-6.002000],[-33.824001,-8.218000,-6.150000],[-34.042000,-8.224000,-6.112000],[-34.042000,-7.600000,-6.204000],[-33.850002,-7.358000,-6.272000],[-34.042000,-7.358000,-6.238000],[-33.088001,-8.196000,-6.186000],[-33.106003,-7.358000,-6.308000],[-34.042000,-10.400001,-4.774000],[-34.042000,-6.494000,-6.112000],[-34.042000,-6.442000,-6.092000],[-33.882000,-6.424000,-6.112000],[-33.824001,-6.500000,-6.150000],[-33.818001,-6.416000,-6.120000],[-33.140003,-6.464000,-6.162000],[-33.138000,-6.464000,-6.162000],[-33.088001,-6.524000,-6.186000],[-33.086002,-6.464000,-6.164001],[-34.042000,-7.310000,-6.232000],[-34.042000,-7.116000,-6.204000],[-34.042000,-6.616000,-6.130000],[-34.042000,-11.690001,1.274000],[-34.042000,-11.702001,1.222000],[-33.892002,-11.732000,1.156000],[-34.042000,-11.652000,1.462000],[-34.042000,-11.732000,1.080000],[-34.042000,-11.796000,0.320000],[-33.272003,-11.880000,-0.228000],[-34.042000,-11.834001,-0.228000],[-33.170002,-11.536000,1.890000],[-32.498001,-11.194000,2.738000],[-33.062000,-11.058001,3.310000],[-33.708000,-11.326000,2.700000],[-34.042000,-11.530001,1.924000],[-34.042000,-11.406000,2.404000],[-32.512001,-11.586000,1.184000],[-31.884001,-11.220000,2.188000],[-34.042000,-11.100000,3.172000],[-34.042000,-11.006001,3.378000],[-34.042000,-10.950001,3.500000],[-33.568001,-10.796000,3.844000],[-34.042000,-10.672001,3.910000],[-34.042000,-10.400001,4.318000],[-33.982002,-10.386001,4.352000],[-34.042000,-11.262000,2.752000],[-34.042000,-11.176001,2.974000],[-33.004002,-10.500001,4.258000],[-32.478001,-10.682000,3.886000],[-33.412003,-10.176001,4.626000],[-31.888002,-10.756001,3.468000],[-31.274002,-10.756001,2.978000],[-31.672001,-11.446000,0.800000],[-30.786001,-11.142000,0.680000],[-30.722002,-11.000001,1.364000],[-31.224001,-11.146001,1.712000],[-31.868002,-11.564000,-0.228000],[-30.840002,-11.202001,-0.228000],[-30.668001,-10.712001,2.390000],[-30.196001,-10.680000,1.664000],[-29.990002,-10.708000,0.762000],[-29.952002,-10.738001,-0.228000],[-29.454000,-10.220000,1.242000],[-29.446001,-10.256001,1.062000],[-29.446001,-10.288000,0.896000],[-29.540001,-10.414001,0.206000],[-29.540001,-10.412001,0.226000],[-29.544001,-10.442000,-0.228000],[-31.672001,-11.446000,-1.258000],[-31.224001,-11.146001,-2.170000],[-30.722002,-11.000001,-1.820000],[-30.786001,-11.142000,-1.136000],[-32.512001,-11.586000,-1.642000],[-31.884001,-11.220000,-2.644000],[-29.990002,-10.708000,-1.218000],[-30.196001,-10.680000,-2.120000],[-29.446001,-10.256001,-1.518000],[-29.446001,-10.288000,-1.354000],[-29.454000,-10.220000,-1.698000],[-29.540001,-10.414001,-0.662000],[-29.540001,-10.412001,-0.684000],[-30.668001,-10.712001,-2.848000],[-31.274002,-10.756001,-3.436000],[-33.170002,-11.536000,-2.348000],[-33.708000,-11.326000,-3.156000],[-33.062000,-11.058001,-3.766000],[-32.498001,-11.194000,-3.196000],[-34.042000,-11.532001,-2.378000],[-34.042000,-11.406000,-2.862000],[-34.042000,-11.652000,-1.920000],[-33.892002,-11.732000,-1.614000],[-31.888002,-10.756001,-3.926000],[-32.478001,-10.682000,-4.344000],[-31.398001,-10.222000,-4.564000],[-32.020000,-10.196000,-4.890000],[-33.004002,-10.500001,-4.716000],[-33.568001,-10.796000,-4.300000],[-32.588001,-10.094001,-5.120000],[-34.042000,-11.006001,-3.836000],[-34.042000,-10.950001,-3.956000],[-34.042000,-11.100000,-3.630000],[-34.042000,-11.262000,-3.210000],[-34.042000,-11.178000,-3.428000],[-34.042000,-10.672001,-4.368000],[-34.042000,-11.702001,-1.680000],[-34.042000,-11.732000,-1.538000],[-34.042000,-11.692000,-1.728000],[-34.042000,-11.796000,-0.778000],[-33.818001,-6.414001,5.662000],[-33.882000,-6.422000,5.654000],[-33.824001,-6.500000,5.694000],[-34.042000,-6.494000,5.656000],[-34.042000,-6.440001,5.636000],[-33.850002,-7.358000,5.814000],[-34.042000,-6.618001,5.674000],[-34.042000,-7.116000,5.746000],[-34.042000,-7.310000,5.774000],[-34.042000,-7.358000,5.780000],[-33.140003,-6.462000,5.704000],[-33.130001,-6.462000,5.704000],[-34.042000,-10.262000,4.456000],[-34.042000,-8.516001,5.544000],[-33.824001,-8.218000,5.694000],[-34.042000,-8.224000,5.656000],[-34.042000,-8.538000,5.536000],[-34.042000,-9.034000,5.348000],[-33.754002,-9.010000,5.406000],[-34.042000,-7.600000,5.746000],[-34.042000,-9.368000,5.148000],[-33.638000,-9.670000,5.028000],[-34.042000,-9.752001,4.910000],[-34.042000,-9.896001,4.788000],[-34.042000,-10.112000,4.592000],[-31.610001,-7.358000,-6.280000],[-31.608002,-6.616000,-6.166000],[-31.508001,-6.668000,-6.140000],[-30.832001,-7.358000,-6.018000],[-30.836002,-7.012001,-5.966000],[-30.608002,-7.238000,-5.844000],[-30.570002,-7.274000,-5.824000],[-30.560001,-7.270000,-5.816000],[-30.278002,-7.114000,-5.596000],[-32.304001,-6.494000,-6.194000],[-32.352001,-6.544000,-6.220000],[-32.354000,-6.484000,-6.196000],[-31.920002,-6.556000,-6.184000],[-32.364002,-7.358000,-6.344000],[-31.750002,-6.594000,-6.176000],[-31.650002,-6.610000,-6.170000],[-33.034000,-6.468000,-6.166000],[-31.088001,-9.592000,-5.132000],[-31.762001,-9.600000,-5.408000],[-31.644001,-8.912001,-5.850000],[-30.916002,-8.888000,-5.592000],[-30.842001,-8.136001,-5.900000],[-31.606001,-8.154000,-6.158000],[-32.352001,-8.174001,-6.220000],[-32.354000,-8.930000,-5.928000],[-32.402000,-9.572001,-5.542000],[-32.354000,4.662000,5.746000],[-32.314003,4.670000,5.744000],[-32.352001,4.710000,5.764000],[-32.018002,4.718000,5.736000],[-32.364002,5.524000,5.886000],[-31.744001,4.780000,5.720000],[-31.666002,4.792000,5.716000],[-31.610001,5.524000,5.822001],[-31.608002,4.802000,5.712000],[-33.054001,4.644000,5.714000],[-33.088001,4.688000,5.728000],[-33.086002,4.642000,5.712000],[-33.046001,4.644000,5.714000],[-33.106003,5.524000,5.850000],[-31.468002,4.872000,5.676000],[-30.832001,5.524000,5.560000],[-30.836002,5.196000,5.510000],[-30.622002,5.408000,5.398000],[-30.566002,5.464000,5.366000],[-30.020002,5.524000,4.998000],[-30.548002,5.456000,5.354000],[-30.262001,5.296000,5.130000],[-30.034002,5.168000,4.950000],[-32.352001,6.338000,5.764000],[-31.606001,6.318000,5.700000],[-31.644001,7.076000,5.392000],[-32.354000,7.094000,5.470000],[-33.088001,6.360000,5.728000],[-33.054001,7.122000,5.450000],[-32.402000,7.736001,5.084000],[-31.762001,7.764000,4.952000],[-32.588001,8.260000,4.662000],[-32.020000,8.362000,4.432000],[-33.020000,7.736001,5.100000],[-33.004002,8.122001,4.798000],[-31.088001,7.756001,4.676000],[-30.916002,7.052001,5.134000],[-30.392002,7.730000,4.174000],[-30.166002,7.030000,4.608000],[-31.398001,8.386001,4.106000],[-30.752001,8.368000,3.620000],[-30.842001,6.300000,5.444000],[-30.050001,6.288000,4.894000],[-29.160002,5.524000,4.040000],[-29.166002,5.438000,4.030000],[-29.136002,5.498000,3.996000],[-29.124001,5.524000,3.982000],[-29.844002,5.146000,4.734000],[-29.624001,5.150000,4.484000],[-29.994001,5.136000,4.900000],[-29.292002,5.258000,4.134000],[-29.608002,5.150000,4.466000],[-29.408001,5.040000,4.222000],[-29.044001,6.280000,3.670000],[-29.094002,6.460001,3.614000],[-29.218002,6.280000,3.954000],[-29.182001,6.814000,3.504000],[-29.396002,7.016000,3.722000],[-29.164001,7.014000,3.326000],[-29.114002,5.574000,3.954000],[-29.106001,5.622000,3.926000],[-29.046001,6.142000,3.704000],[-29.216002,7.224000,3.156000],[-29.192001,7.352000,2.954000],[-29.694002,7.708000,3.366000],[-29.148001,7.698000,2.412000],[-29.150002,7.700000,2.408000],[-30.118002,8.336000,2.914000],[-29.150002,7.732000,2.348000],[-29.596001,8.316000,2.010000],[-29.150002,7.766000,2.282000],[-29.416002,8.326000,1.382000],[-29.124001,5.524000,-4.440000],[-29.136002,5.498000,-4.454000],[-29.160002,5.524000,-4.498000],[-29.166002,5.438000,-4.488000],[-29.292002,5.258000,-4.592000],[-29.408001,5.038000,-4.678000],[-29.606001,5.150000,-4.922000],[-29.624001,5.150000,-4.942000],[-30.020002,5.524000,-5.456000],[-30.034002,5.168000,-5.408000],[-29.844002,5.146000,-5.190000],[-29.992001,5.136000,-5.356000],[-29.416002,8.326000,-1.838000],[-29.150002,7.766000,-2.740000],[-29.596001,8.316000,-2.468000],[-29.192001,7.350000,-3.410000],[-29.694002,7.708000,-3.824000],[-29.148001,7.698000,-2.868000],[-29.396002,7.016000,-4.178000],[-29.216002,7.224000,-3.612000],[-29.164001,7.014000,-3.784000],[-30.392002,7.730000,-4.632000],[-30.166002,7.030000,-5.066000],[-30.118002,8.336000,-3.370000],[-29.150002,7.732000,-2.806000],[-29.150002,7.700000,-2.866000],[-30.752001,8.368000,-4.078000],[-29.218002,6.280000,-4.412000],[-29.182001,6.814000,-3.962000],[-29.094002,6.460001,-4.070000],[-29.044001,6.280000,-4.126000],[-29.106001,5.622000,-4.384000],[-29.114002,5.574000,-4.412000],[-29.046001,6.142000,-4.162000],[-30.050001,6.288000,-5.350000],[-33.874001,4.598000,-6.116000],[-33.824001,4.666000,-6.150000],[-33.818001,4.592000,-6.124000],[-34.042000,4.618000,-6.096000],[-34.042000,4.660000,-6.112000],[-34.042000,4.806000,-6.134000],[-34.042000,5.282000,-6.204000],[-33.850002,5.524000,-6.272000],[-34.042000,5.504000,-6.236000],[-34.042000,5.524000,-6.238000],[-33.128002,4.640000,-6.166000],[-33.088001,4.688000,-6.186000],[-33.086002,4.642000,-6.168000],[-33.106003,5.524000,-6.308000],[-34.042000,6.388000,-6.112000],[-34.042000,6.680000,-6.002000],[-33.824001,6.382000,-6.150000],[-33.754002,7.174000,-5.862000],[-34.042000,7.198000,-5.806000],[-34.042000,6.724000,-5.984000],[-33.088001,6.360000,-6.186000],[-33.054001,7.122000,-5.906000],[-34.042000,5.766000,-6.204000],[-34.042000,7.534000,-5.606000],[-33.638000,7.834001,-5.486000],[-34.042000,7.916000,-5.368000],[-34.042000,8.060000,-5.246000],[-33.412003,8.340000,-5.084000],[-34.042000,8.278001,-5.048000],[-34.042000,8.426001,-4.914000],[-33.982002,8.550000,-4.810000],[-33.020000,7.736001,-5.558000],[-33.004002,8.122001,-5.256000],[-34.042000,8.564000,-4.774000],[-34.042000,9.896001,1.080000],[-34.042000,9.866000,1.222000],[-33.892002,9.896001,1.156000],[-34.042000,9.856001,1.264000],[-34.042000,9.816001,1.462000],[-34.042000,9.962001,0.320000],[-33.272003,10.044001,-0.228000],[-34.042000,9.998000,-0.228000],[-34.042000,9.114000,3.500000],[-33.062000,9.222000,3.310000],[-34.042000,9.172001,3.378000],[-33.568001,8.962001,3.844000],[-33.708000,9.492001,2.700000],[-34.042000,9.266001,3.172000],[-34.042000,9.336000,2.990000],[-34.042000,9.426001,2.752000],[-34.042000,9.570001,2.404000],[-34.042000,8.564000,4.318000],[-34.042000,8.836000,3.910000],[-33.982002,8.550000,4.352000],[-33.170002,9.700001,1.890000],[-32.498001,9.358001,2.738000],[-32.512001,9.752001,1.184000],[-31.884001,9.384001,2.188000],[-34.042000,9.696000,1.924000],[-31.888002,8.922001,3.468000],[-32.478001,8.846001,3.886000],[-31.274002,8.920000,2.978000],[-33.004002,8.664001,4.258000],[-33.412003,8.340000,4.626000],[-30.668001,8.878000,2.390000],[-30.196001,8.844001,1.664000],[-30.722002,9.164001,1.364000],[-31.224001,9.310000,1.712000],[-31.672001,9.610001,0.800000],[-30.786001,9.308001,0.680000],[-31.868002,9.728001,-0.228000],[-30.840002,9.368000,-0.228000],[-29.990002,8.874001,0.762000],[-29.480001,8.440001,1.088000],[-29.478001,8.478001,0.888000],[-29.488001,8.402000,1.282000],[-29.952002,8.904000,-0.228000],[-29.570002,8.598001,0.238000],[-29.574001,8.630000,-0.228000],[-29.568001,8.598001,0.242000],[-29.990002,8.874001,-1.218000],[-30.196001,8.844001,-2.120000],[-30.722002,9.164001,-1.820000],[-30.786001,9.308001,-1.136000],[-29.488001,8.402000,-1.738000],[-29.480001,8.440001,-1.546000],[-29.478001,8.478001,-1.346000],[-29.568001,8.598001,-0.698000],[-29.570002,8.598001,-0.694000],[-31.672001,9.610001,-1.258000],[-31.224001,9.310000,-2.170000],[-32.512001,9.752001,-1.642000],[-31.884001,9.384001,-2.644000],[-30.668001,8.878000,-2.848000],[-31.274002,8.920000,-3.436000],[-31.888002,8.922001,-3.926000],[-32.478001,8.846001,-4.344000],[-33.062000,9.222000,-3.766000],[-32.498001,9.358001,-3.196000],[-31.398001,8.386001,-4.564000],[-32.020000,8.362000,-4.890000],[-33.170002,9.700001,-2.348000],[-33.708000,9.492001,-3.156000],[-33.892002,9.896001,-1.614000],[-34.042000,9.696000,-2.378000],[-34.042000,9.570001,-2.862000],[-34.042000,9.816001,-1.920000],[-34.042000,9.266001,-3.630000],[-34.042000,9.172001,-3.836000],[-33.568001,8.962001,-4.300000],[-34.042000,9.114000,-3.956000],[-34.042000,8.836000,-4.368000],[-34.042000,9.426001,-3.210000],[-34.042000,9.338000,-3.444000],[-33.004002,8.664001,-4.716000],[-32.588001,8.260000,-5.120000],[-34.042000,9.858001,-1.718000],[-34.042000,9.866000,-1.680000],[-34.042000,9.896001,-1.538000],[-34.042000,9.962001,-0.778000],[-34.042000,8.426001,4.456000],[-34.042000,7.534000,5.148000],[-33.638000,7.834001,5.028000],[-34.042000,7.916000,4.910000],[-34.042000,7.198000,5.348000],[-33.754002,7.174000,5.406000],[-34.042000,8.274000,4.594000],[-34.042000,8.060000,4.788000],[-34.042000,6.722000,5.528000],[-33.824001,6.382000,5.694000],[-34.042000,6.680000,5.544000],[-34.042000,6.388000,5.656000],[-33.850002,5.524000,5.814000],[-34.042000,5.766000,5.746000],[-34.042000,5.524000,5.780000],[-34.042000,4.616000,5.640000],[-33.874001,4.598000,5.660000],[-34.042000,4.660000,5.656000],[-33.824001,4.666000,5.694000],[-33.818001,4.590000,5.666000],[-33.128002,4.638000,5.708000],[-34.042000,5.504000,5.778000],[-34.042000,5.282000,5.746000],[-34.042000,4.808000,5.678000],[-30.842001,6.300000,-5.900000],[-31.606001,6.318000,-6.158000],[-31.644001,7.076000,-5.850000],[-30.916002,7.052001,-5.592000],[-30.832001,5.524000,-6.018000],[-31.610001,5.524000,-6.280000],[-31.088001,7.756001,-5.132000],[-31.762001,7.764000,-5.408000],[-32.402000,7.736001,-5.542000],[-32.354000,7.094000,-5.928000],[-32.352001,6.338000,-6.220000],[-32.364002,5.524000,-6.344000],[-30.836002,5.196000,-5.968000],[-31.468002,4.872000,-6.134000],[-31.608002,4.800000,-6.170000],[-30.260002,5.296000,-5.588000],[-30.622002,5.410000,-5.854000],[-30.566002,5.464000,-5.824000],[-30.550001,5.456000,-5.812000],[-32.022003,4.718000,-6.192000],[-32.316002,4.670000,-6.200000],[-32.352001,4.710000,-6.220000],[-32.354000,4.664000,-6.202000],[-33.048000,4.646000,-6.170000],[-33.064003,4.646000,-6.170000],[-31.666002,4.792000,-6.174000],[-31.744001,4.780000,-6.178000],[-26.070002,-3.658000,5.374000],[-23.476002,-3.782000,5.852000],[-23.476002,-2.384000,6.052001],[-26.182001,-2.292000,5.528000],[-26.308001,-0.904000,5.584000],[-23.686001,-0.904000,6.120000],[-20.524000,-0.904000,5.880000],[-19.914001,-2.416000,5.806000],[-19.532001,-3.808000,5.578000],[-26.070002,1.848000,5.374000],[-23.476002,1.972000,5.852000],[-24.312000,3.212000,5.518000],[-26.094002,2.702000,5.244000],[-26.080002,2.756000,5.238000],[-26.106001,2.726000,5.238000],[-26.246002,3.176000,5.144000],[-26.000002,3.180000,5.192000],[-26.114000,3.442000,5.110000],[-26.940001,4.606000,4.678000],[-26.452002,3.602000,5.006000],[-26.090002,3.438000,5.116000],[-26.030001,3.342000,5.150000],[-26.080002,3.422000,5.122000],[-25.760002,4.668000,4.760000],[-23.064001,4.540000,4.296000],[-20.824001,3.148000,5.184000],[-19.532001,1.998000,5.578000],[-15.412001,-3.884000,3.200000],[-17.218000,-2.434000,3.344000],[-18.800001,-0.904000,3.390000],[-17.794001,-0.904000,-0.228000],[-14.954000,-2.446000,-0.228000],[-11.204000,-3.986000,-0.228000],[-15.412001,2.074000,3.200000],[-16.318001,3.364000,2.954000],[-18.862001,4.698000,2.490000],[-14.754001,5.430000,-0.228000],[-11.306001,3.718000,-0.228000],[-11.204000,2.176000,-0.228000],[-28.038002,-6.144000,4.456000],[-29.170002,-6.748000,4.870000],[-28.280001,-6.482000,5.544000],[-26.750002,-5.994000,5.334000],[-26.114000,-5.252000,5.110000],[-26.090002,-5.248000,5.116000],[-26.504002,-5.432000,4.970000],[-26.504002,-5.434000,4.970000],[-26.452002,-5.410000,5.006000],[-28.378002,6.282000,3.812000],[-27.588001,6.718000,3.280000],[-28.232002,8.762000,-0.228000],[-25.534000,6.650000,2.570000],[-28.232002,-10.572001,-0.228000],[-21.042002,-9.292001,-0.228000],[-21.970001,-8.094001,1.694000],[-25.534000,-8.460000,2.570000],[-23.064001,-6.350000,4.296000],[-18.862001,-6.508000,2.490000],[-14.754001,-7.238000,-0.228000],[-21.970001,6.284000,1.694000],[-21.042002,7.482000,-0.228000],[-34.042000,2.834000,6.180000],[-31.670002,2.668000,6.490000],[-34.042000,3.188000,6.058000],[-31.298002,4.454000,5.914001],[-28.280001,4.672000,5.544000],[-27.920002,3.970000,5.922000],[-28.156002,2.344000,6.470000],[-34.042000,-4.644000,6.180000],[-32.042000,-2.692000,7.068000],[-34.042000,-4.192000,6.336000],[-31.670002,-4.478000,6.490000],[-34.042000,-3.710000,6.484000],[-34.042000,-2.758000,6.774000],[-34.042000,-2.120000,6.872000],[-34.042000,-1.630000,6.948000],[-32.228001,-0.904000,7.356000],[-34.042000,-0.904000,7.076000],[-28.534002,-0.904000,7.280000],[-28.406002,-2.530000,7.012001],[-28.156002,-4.154000,6.470000],[-31.298002,-6.264000,5.914001],[-34.042000,-4.996000,6.058000],[-27.920002,-5.780000,5.922000],[-16.318001,-5.174000,2.954000],[-20.824001,-4.958000,5.184000],[-11.306001,-5.526000,-0.228000],[-26.940001,-6.416000,4.678000],[-25.760002,-6.478000,4.760000],[-24.312000,-5.022000,5.518000],[-26.030001,-5.152000,5.150000],[-26.000002,-4.990000,5.192000],[-26.080002,-5.232000,5.122000],[-26.080002,-4.566000,5.238000],[-26.096001,-4.512000,5.244000],[-26.106001,-4.536000,5.238000],[-26.246002,-4.986000,5.144000],[-32.042000,0.882000,7.068000],[-34.042000,-0.180000,6.948000],[-34.042000,-0.902000,7.076000],[-34.042000,0.314000,6.872000],[-34.042000,0.950000,6.774000],[-34.042000,1.904000,6.482000],[-34.042000,2.382000,6.336000],[-28.406002,0.720000,7.012001],[-17.218000,0.624000,3.344000],[-19.914001,0.606000,5.806000],[-14.954000,0.636000,-0.228000],[-23.476002,0.574000,6.052001],[-26.182001,0.482000,5.528000],[-26.490002,-0.904000,6.870000],[-26.374001,0.414000,6.668000],[-26.172001,1.734000,6.248000],[-25.552002,1.292000,5.900000],[-25.744001,0.194000,6.178000],[-25.862001,-0.904000,6.304000],[-26.022001,-4.864000,5.798000],[-26.172001,-3.544000,6.248000],[-25.552002,-3.102000,5.900000],[-25.458002,-4.200000,5.568000],[-29.170002,4.938000,4.870000],[-28.038002,4.334000,4.456000],[-26.504002,3.624000,4.970000],[-26.750002,4.184000,5.334000],[-28.378002,-8.092000,3.812000],[-28.152000,-6.946000,4.152000],[-26.592001,-5.658000,4.876000],[-26.596001,-5.690000,4.844000],[-26.022001,3.054000,5.798000],[-25.458002,2.392000,5.568000],[-26.374001,-2.224000,6.668000],[-25.744001,-2.004000,6.178000],[-27.588001,-8.528001,3.280000],[-26.418001,-0.904000,5.762000],[-26.308001,0.286000,5.684000],[-26.140001,1.476000,5.500000],[-26.080002,-4.478000,5.256000],[-26.140001,-3.286000,5.500000],[-28.152000,5.136000,4.152000],[-26.596001,3.880000,4.844000],[-26.592001,3.848000,4.876000],[-26.080002,2.668000,5.256000],[-26.308001,-2.096000,5.684000],[-26.070002,-3.658000,-5.832000],[-26.182001,-2.292000,-5.986000],[-23.476002,-2.384000,-6.510000],[-23.476002,-3.782000,-6.308000],[-26.308001,-0.904000,-6.042000],[-23.686001,-0.904000,-6.576000],[-20.524000,-0.904000,-6.338000],[-19.914001,-2.416000,-6.264000],[-19.532001,-3.808000,-6.034000],[-26.096001,2.702000,-5.702000],[-26.080002,2.754000,-5.696000],[-26.070002,1.848000,-5.832000],[-26.106001,2.726000,-5.696000],[-26.246002,3.176000,-5.602000],[-25.996000,3.180000,-5.652000],[-24.312000,3.212000,-5.976000],[-23.476002,1.972000,-6.308000],[-26.940001,4.606000,-5.134000],[-25.760002,4.668000,-5.218000],[-26.118002,3.446000,-5.566000],[-26.452002,3.602000,-5.464000],[-26.092001,3.440000,-5.572000],[-26.022001,3.330000,-5.612000],[-26.080002,3.420000,-5.578000],[-23.064001,4.540000,-4.754000],[-20.824001,3.148000,-5.642000],[-19.532001,1.998000,-6.034000],[-17.218000,-2.434000,-3.802000],[-15.412001,-3.884000,-3.658000],[-18.800001,-0.904000,-3.846000],[-16.318001,3.364000,-3.412000],[-15.412001,2.074000,-3.658000],[-18.862001,4.698000,-2.946000],[-29.170002,-6.748000,-5.326000],[-28.038002,-6.144000,-4.912000],[-28.280001,-6.482000,-6.002000],[-26.750002,-5.994000,-5.792000],[-26.504002,-5.432000,-5.426000],[-26.504002,-5.434000,-5.428000],[-26.452002,-5.410000,-5.464000],[-26.118002,-5.254000,-5.566000],[-26.092001,-5.248000,-5.572000],[-27.588001,6.718000,-3.736000],[-28.378002,6.282000,-4.268000],[-25.534000,6.650000,-3.028000],[-25.534000,-8.460000,-3.028000],[-21.970001,-8.094001,-2.150000],[-23.064001,-6.350000,-4.754000],[-18.862001,-6.508000,-2.946000],[-21.970001,6.284000,-2.150000],[-34.042000,3.188000,-6.516000],[-31.298002,4.454000,-6.372000],[-34.042000,2.834000,-6.638000],[-31.670002,2.668000,-6.948000],[-28.280001,4.672000,-6.002000],[-27.920002,3.970000,-6.380000],[-28.156002,2.344000,-6.928000],[-34.042000,-3.710000,-6.940001],[-34.042000,-2.758000,-7.232000],[-32.042000,-2.692000,-7.524000],[-34.042000,-4.192000,-6.792000],[-34.042000,-4.644000,-6.638000],[-31.670002,-4.478000,-6.948000],[-34.042000,-1.630000,-7.404000],[-34.042000,-0.904000,-7.534000],[-32.228001,-0.904000,-7.812000],[-34.042000,-2.122000,-7.330000],[-28.534002,-0.904000,-7.738000],[-28.406002,-2.530000,-7.468000],[-28.156002,-4.154000,-6.928000],[-31.298002,-6.264000,-6.372000],[-34.042000,-4.996000,-6.516000],[-27.920002,-5.780000,-6.380000],[-20.824001,-4.958000,-5.642000],[-16.318001,-5.174000,-3.412000],[-26.940001,-6.416000,-5.134000],[-26.022001,-5.140000,-5.612000],[-25.996000,-4.990000,-5.652000],[-24.312000,-5.022000,-5.976000],[-26.080002,-5.230000,-5.578000],[-25.760002,-6.478000,-5.218000],[-26.080002,-4.564000,-5.696000],[-26.096001,-4.512000,-5.702000],[-26.106001,-4.536000,-5.696000],[-26.246002,-4.986000,-5.602000],[-34.042000,0.316000,-7.328001],[-34.042000,0.950000,-7.232000],[-32.042000,0.882000,-7.524000],[-34.042000,-0.180000,-7.404000],[-34.042000,-0.902000,-7.532001],[-34.042000,2.382000,-6.792000],[-34.042000,1.904000,-6.940001],[-28.406002,0.720000,-7.468000],[-19.914001,0.606000,-6.264000],[-17.218000,0.624000,-3.802000],[-26.182001,0.482000,-5.986000],[-23.476002,0.574000,-6.510000],[-26.374001,0.414000,-7.124001],[-26.490002,-0.904000,-7.328001],[-26.172001,1.734000,-6.706000],[-25.552002,1.292000,-6.358000],[-25.744001,0.194000,-6.636000],[-25.862001,-0.904000,-6.762000],[-26.022001,-4.864000,-6.256001],[-26.172001,-3.544000,-6.706000],[-25.552002,-3.102000,-6.358000],[-25.458002,-4.200000,-6.026000],[-29.170002,4.938000,-5.326000],[-28.038002,4.334000,-4.912000],[-26.750002,4.184000,-5.792000],[-26.504002,3.624000,-5.428000],[-26.504002,3.622000,-5.426000],[-28.152000,-6.946000,-4.610000],[-28.378002,-8.092000,-4.268000],[-26.592001,-5.658000,-5.332000],[-26.596001,-5.690000,-5.300000],[-26.022001,3.054000,-6.256001],[-25.458002,2.392000,-6.026000],[-26.374001,-2.224000,-7.124001],[-25.744001,-2.004000,-6.636000],[-27.588001,-8.528001,-3.736000],[-26.308001,0.286000,-6.142000],[-26.418001,-0.904000,-6.220000],[-26.140001,1.476000,-5.958000],[-26.080002,-4.478000,-5.714000],[-26.140001,-3.286000,-5.958000],[-28.152000,5.136000,-4.610000],[-26.596001,3.880000,-5.300000],[-26.592001,3.848000,-5.332000],[-26.080002,2.668000,-5.714000],[-26.308001,-2.096000,-6.142000],[-62.232002,-0.908000,-8.610001],[-62.166004,-0.918000,-8.682000],[-61.956001,-2.244000,-8.554001],[-62.024002,-2.224000,-8.482000],[-61.814003,-3.514000,-8.162001],[-61.746002,-3.546000,-8.232000],[-61.638004,-3.578000,-8.304001],[-61.848003,-2.266000,-8.630000],[-62.058002,-0.926000,-8.758000],[-62.442001,0.400000,-8.534000],[-62.374004,0.402000,-8.606000],[-62.266003,0.406000,-8.680000],[-62.476002,1.696000,-8.388000],[-62.584003,1.682000,-8.314000],[-62.652004,1.670000,-8.246000],[-62.276005,-0.900000,-8.542001],[-62.486004,0.398000,-8.468000],[-62.696003,1.656000,-8.182000],[-62.730003,1.646000,-8.126000],[-62.522003,0.396000,-8.410001],[-62.312004,-0.894000,-8.484000],[-62.068005,-2.206000,-8.416000],[-62.104004,-2.190000,-8.360001],[-61.896004,-3.460000,-8.046000],[-61.858002,-3.486000,-8.100000],[-63.070004,3.968000,-7.024000],[-63.278004,4.958000,-6.148000],[-63.212002,5.000000,-6.200000],[-63.002003,4.002000,-7.084000],[-62.896004,4.036000,-7.144001],[-63.104004,5.044000,-6.254000],[-63.314003,5.914001,-5.220000],[-63.422005,5.864000,-5.174000],[-63.488003,5.814000,-5.132000],[-63.112003,3.938000,-6.970000],[-63.322002,4.920000,-6.100000],[-63.532001,5.768000,-5.094000],[-63.566002,5.730000,-5.060000],[-63.358002,4.886000,-6.060000],[-63.150002,3.910000,-6.924000],[-62.860004,2.866000,-7.732000],[-62.904003,2.842000,-7.674000],[-62.940002,2.824000,-7.622000],[-62.794003,2.890000,-7.798000],[-62.686005,2.914000,-7.866000],[-63.244003,3.876000,-6.862000],[-63.194004,3.890000,-6.888000],[-62.984001,2.810000,-7.582000],[-63.036003,2.798000,-7.554000],[-62.826004,1.632000,-8.054001],[-62.776005,1.638000,-8.084001],[-63.454002,4.842000,-6.008000],[-63.402004,4.860000,-6.030000],[-63.612003,5.700000,-5.034000],[-63.662003,5.678000,-5.016000],[-63.298004,3.866000,-6.846000],[-63.508003,4.830000,-5.994000],[-63.716003,5.664000,-5.004000],[-63.774002,5.660000,-5.000000],[-63.564003,4.828000,-5.988000],[-63.356003,3.864000,-6.842000],[-63.090004,2.792000,-7.536000],[-63.146004,2.792000,-7.532001],[-62.938004,1.628000,-8.030001],[-62.882004,1.628000,-8.036000],[-62.408005,-0.884000,-8.410001],[-62.200005,-2.170000,-8.284000],[-62.254002,-2.162000,-8.266001],[-62.464005,-0.882000,-8.390000],[-62.520004,-0.880000,-8.384001],[-62.310001,-2.162000,-8.260000],[-62.102001,-3.418000,-7.950000],[-62.046001,-3.420000,-7.956000],[-61.990002,-3.428000,-7.974000],[-62.358002,-0.888000,-8.440001],[-62.150002,-2.178000,-8.316000],[-61.940002,-3.442000,-8.004001],[-62.618004,0.394000,-8.334001],[-62.566002,0.394000,-8.366000],[-62.672005,0.392000,-8.316000],[-62.730003,0.392000,-8.310000],[-61.658005,-0.946000,-8.908000],[-61.866001,0.412000,-8.830001],[-61.542004,0.414000,-8.894000],[-61.332005,-0.952000,-8.974000],[-60.902004,-0.958000,-9.030001],[-61.112003,0.414000,-8.952001],[-61.322002,1.748000,-8.648001],[-61.750004,1.736000,-8.594001],[-62.076004,1.724000,-8.530001],[-61.894005,-0.936000,-8.834001],[-62.102001,0.408000,-8.756001],[-62.312004,1.710000,-8.460000],[-61.448002,-2.308000,-8.776000],[-61.684002,-2.286000,-8.704000],[-61.474003,-3.610000,-8.376000],[-61.238003,-3.642000,-8.446000],[-61.122002,-2.326000,-8.840000],[-60.912003,-3.672000,-8.508000],[-60.482002,-3.696000,-8.562000],[-60.692001,-2.342000,-8.898001],[-60.818005,-6.096000,-7.232000],[-61.054005,-6.046000,-7.174000],[-61.264004,-4.876000,-7.864000],[-61.028004,-4.916000,-7.928000],[-61.430004,-4.832000,-7.796000],[-61.220001,-5.990000,-7.114000],[-60.610004,-7.148000,-6.374000],[-60.846004,-7.086000,-6.322001],[-61.010002,-7.022000,-6.268000],[-60.800003,-7.894001,-5.272000],[-60.636002,-7.966001,-5.316000],[-60.400002,-8.036000,-5.360000],[-60.492004,-6.144000,-7.288001],[-60.284004,-7.204000,-6.420000],[-60.074001,-8.096001,-5.398000],[-59.644001,-8.152000,-5.432000],[-59.854004,-7.250000,-6.460001],[-60.064003,-6.184000,-7.334000],[-60.702003,-4.956000,-7.986001],[-60.272003,-4.988000,-8.036000],[-61.396004,-5.884000,-6.992000],[-61.186005,-6.898000,-6.162000],[-61.230003,-6.842000,-6.114000],[-61.440002,-5.836000,-6.938000],[-61.476002,-5.794000,-6.892000],[-61.268002,-6.794000,-6.074000],[-61.058002,-7.640000,-5.110000],[-61.022003,-7.694000,-5.144000],[-60.978004,-7.754000,-5.184000],[-61.328003,-5.936000,-7.052001],[-61.118004,-6.960001,-6.214000],[-60.908005,-7.824000,-5.226000],[-61.606003,-4.744000,-7.664001],[-61.536003,-4.788000,-7.728000],[-61.650002,-4.706000,-7.604001],[-61.686005,-4.672000,-7.554000],[-62.628002,-0.884000,-8.410001],[-62.576004,-0.882000,-8.390000],[-62.366001,-2.162000,-8.266001],[-62.418003,-2.170000,-8.284000],[-62.210003,-3.428000,-7.974000],[-62.158005,-3.420000,-7.956000],[-62.838001,0.394000,-8.334001],[-62.784004,0.392000,-8.316000],[-62.994003,1.628000,-8.036000],[-63.046001,1.632000,-8.054001],[-62.676003,-0.888000,-8.440001],[-62.884003,0.394000,-8.366000],[-63.092003,1.638000,-8.084001],[-63.132004,1.646000,-8.126000],[-62.922005,0.396000,-8.410001],[-62.714005,-0.894000,-8.484000],[-62.466003,-2.178000,-8.316000],[-62.506004,-2.190000,-8.360001],[-62.296001,-3.460000,-8.046000],[-62.258003,-3.442000,-8.004001],[-62.496002,4.106000,-7.266000],[-62.170002,4.136000,-7.322001],[-61.960003,2.984000,-8.060000],[-62.286003,2.964000,-8.000000],[-61.532001,3.004000,-8.112000],[-61.740002,4.162000,-7.366000],[-62.706001,5.132000,-6.358000],[-62.380001,5.168000,-6.406000],[-61.950005,5.202000,-6.446000],[-62.160004,6.102000,-5.378000],[-62.590004,6.062000,-5.346000],[-62.914001,6.016000,-5.306000],[-62.732002,4.072000,-7.208000],[-62.940002,5.088000,-6.308000],[-63.150002,5.968000,-5.264000],[-62.522003,2.940000,-7.934000],[-59.710003,-0.970000,-9.108001],[-59.008003,-0.972000,-9.126000],[-58.798004,-2.368000,-8.992001],[-59.500004,-2.362000,-8.972000],[-59.290001,-3.730000,-8.634001],[-58.588001,-3.736000,-8.654000],[-57.856003,-3.740000,-8.658000],[-58.066002,-2.370000,-8.998000],[-58.276001,-0.972000,-9.132000],[-59.918003,0.418000,-9.026000],[-59.218002,0.418000,-9.046000],[-58.488003,0.418000,-9.052000],[-58.698002,1.768000,-8.746000],[-59.428001,1.766000,-8.740001],[-60.128002,1.762000,-8.722000],[-60.350002,-0.966000,-9.076000],[-60.560001,0.416000,-8.996000],[-60.770004,1.756000,-8.692000],[-60.142002,-2.354000,-8.942000],[-59.932003,-3.716000,-8.604000],[-61.572002,-5.740000,-6.832000],[-61.522003,-5.764000,-6.856000],[-61.312004,-6.758000,-6.042000],[-61.364002,-6.730000,-6.020000],[-61.154003,-7.568000,-5.066000],[-61.104004,-7.598001,-5.084000],[-61.782001,-4.628000,-7.486001],[-61.730003,-4.648000,-7.514000],[-61.628002,-5.726000,-6.816000],[-61.836002,-4.618000,-7.468000],[-61.892002,-4.614000,-7.464000],[-61.684002,-5.724000,-6.810000],[-61.418003,-6.716001,-6.008000],[-61.474003,-6.710001,-6.002000],[-61.266003,-7.544000,-5.050000],[-61.210003,-7.550000,-5.054000],[-63.906002,7.044000,-2.792000],[-63.950005,6.988000,-2.772000],[-64.160004,7.318000,-1.514000],[-64.116005,7.376000,-1.524000],[-64.326004,7.494000,-0.228000],[-64.368004,7.434000,-0.228000],[-64.403999,7.384000,-0.228000],[-64.194000,7.268000,-1.506000],[-63.986004,6.940001,-2.754000],[-63.698002,6.516000,-4.004000],[-63.740002,6.464000,-3.974000],[-63.776005,6.420000,-3.948000],[-63.840004,7.104001,-2.814000],[-63.630005,6.572001,-4.038000],[-63.522003,6.630000,-4.072000],[-63.734001,7.166000,-2.838000],[-64.048004,7.440001,-1.536000],[-63.942001,7.506001,-1.548000],[-64.152000,7.624001,-0.228000],[-64.258003,7.558001,-0.228000],[-64.080002,6.878000,-2.730000],[-63.872002,6.362000,-3.914000],[-63.926003,6.348001,-3.906000],[-64.136002,6.862000,-2.726000],[-64.190002,6.858000,-2.722000],[-63.982002,6.344000,-3.902000],[-64.030006,6.904000,-2.740000],[-63.822002,6.386000,-3.928000],[-64.290001,7.202000,-1.494000],[-64.238007,7.230000,-1.498000],[-64.448006,7.346000,-0.228000],[-64.498001,7.318000,-0.228000],[-64.344002,7.186000,-1.490000],[-64.554001,7.300000,-0.228000],[-64.610001,7.294000,-0.228000],[-64.400002,7.180000,-1.490000],[-60.548004,4.198000,-7.428000],[-60.760002,5.246000,-6.500000],[-60.058002,5.256000,-6.514000],[-59.846004,4.206000,-7.444000],[-59.116001,4.210000,-7.450000],[-59.326004,5.260000,-6.518000],[-59.536003,6.170000,-5.440000],[-60.268002,6.166000,-5.436000],[-60.968002,6.152000,-5.424000],[-61.190002,4.184000,-7.402000],[-61.400002,5.228000,-6.478000],[-61.610004,6.132000,-5.406000],[-60.338001,3.028000,-8.178000],[-60.980003,3.018000,-8.150001],[-59.636002,3.036000,-8.196000],[-58.906002,3.038000,-8.202001],[-58.870003,-6.240000,-7.394001],[-59.080002,-5.032000,-8.104000],[-58.378002,-5.044000,-8.122001],[-58.168003,-6.254000,-7.410000],[-57.648003,-5.048000,-8.128000],[-57.438004,-6.258000,-7.416000],[-59.512001,-6.218000,-7.368001],[-59.722004,-5.014000,-8.078000],[-58.660004,-7.314000,-6.514000],[-59.302002,-7.288001,-6.492000],[-59.092003,-8.192000,-5.460000],[-58.450005,-8.222000,-5.478000],[-57.958004,-7.330000,-6.528000],[-57.748001,-8.240001,-5.490000],[-57.018002,-8.246000,-5.494000],[-57.228004,-7.336000,-6.534000],[-56.850002,-0.970000,-9.108001],[-56.640003,-2.362000,-8.972000],[-57.338001,-2.368000,-8.992001],[-57.548004,-0.972000,-9.126000],[-57.128002,-3.736000,-8.654000],[-56.428001,-3.730000,-8.634001],[-56.212002,-0.966000,-9.076000],[-56.004002,-2.354000,-8.942000],[-55.794003,-3.716000,-8.604000],[-55.250004,-3.696000,-8.562000],[-55.460003,-2.342000,-8.898001],[-55.670002,-0.958000,-9.030001],[-57.060001,0.418000,-9.026000],[-56.422001,0.416000,-8.996000],[-55.880001,0.414000,-8.952001],[-56.090004,1.748000,-8.648001],[-56.632004,1.756000,-8.692000],[-57.268002,1.762000,-8.722000],[-57.758003,0.418000,-9.046000],[-57.968002,1.766000,-8.740001],[-60.736004,-8.684000,-2.782000],[-60.946003,-8.218000,-3.974000],[-60.894001,-8.250000,-3.988000],[-60.684002,-8.718000,-2.792000],[-60.640003,-8.764001,-2.806000],[-60.850002,-8.296000,-4.008000],[-60.792004,-8.664001,-2.776000],[-61.000004,-8.198000,-3.964000],[-61.058002,-8.192000,-3.962000],[-60.848003,-8.656000,-2.774000],[-60.528004,-8.962001,-1.522000],[-60.582005,-8.942000,-1.520000],[-60.640003,-8.934000,-1.518000],[-60.430004,-9.026000,-0.228000],[-60.374004,-9.032001,-0.228000],[-60.318005,-9.054001,-0.228000],[-60.476002,-8.996000,-1.526000],[-60.268002,-9.090000,-0.228000],[-60.222004,-9.140000,-0.228000],[-60.430004,-9.046000,-1.534000],[-60.560001,-8.898001,-2.844000],[-60.492004,-8.976001,-2.866000],[-60.280003,-9.264001,-1.566000],[-60.350002,-9.184000,-1.554000],[-60.140003,-9.278001,-0.228000],[-60.072002,-9.360001,-0.228000],[-59.962002,-9.446000,-0.228000],[-60.172005,-9.348001,-1.576000],[-60.382004,-9.058001,-2.890000],[-60.768002,-8.422000,-4.066000],[-60.700005,-8.496000,-4.100000],[-60.592003,-8.574000,-4.134000],[-60.604004,-8.826000,-2.824000],[-60.814003,-8.354000,-4.036000],[-60.394001,-9.110001,-1.542000],[-60.186005,-9.204000,-0.228000],[-63.332005,7.290000,-2.884000],[-63.544003,7.634000,-1.570000],[-63.218002,7.692000,-1.580000],[-63.008003,7.346000,-2.904000],[-62.580002,7.394001,-2.922000],[-62.790005,7.742001,-1.590000],[-63.000004,7.866000,-0.228000],[-63.428001,7.816000,-0.228000],[-63.754002,7.756001,-0.228000],[-63.570004,7.230000,-2.862000],[-63.778004,7.572001,-1.560000],[-63.988003,7.692000,-0.228000],[-63.124004,6.744000,-4.138000],[-63.360004,6.688000,-4.106000],[-62.800003,6.794000,-4.168000],[-62.370003,6.838000,-4.194000],[-64.744003,7.044000,2.336000],[-64.534004,7.376000,1.068000],[-64.578003,7.318000,1.058000],[-64.786003,6.988000,2.316000],[-64.822006,6.940001,2.298000],[-64.612000,7.268000,1.048000],[-64.676003,7.104001,2.358000],[-64.468002,7.440001,1.078000],[-64.360001,7.506001,1.090000],[-64.570000,7.166000,2.380000],[-64.954002,6.516000,3.548000],[-64.886002,6.572001,3.580000],[-64.780006,6.630000,3.614000],[-64.988007,5.914001,4.762000],[-65.096001,5.864000,4.718000],[-65.162003,5.814000,4.676000],[-64.996002,6.464000,3.516000],[-65.204002,5.768000,4.636000],[-65.240005,5.730000,4.602000],[-65.032005,6.420000,3.492000],[-63.464005,3.876000,-6.862000],[-63.254002,2.798000,-7.554000],[-63.302002,2.810000,-7.582000],[-63.512005,3.890000,-6.888000],[-63.550003,3.910000,-6.924000],[-63.342003,2.824000,-7.622000],[-63.410004,3.866000,-6.846000],[-63.202003,2.792000,-7.536000],[-63.672005,4.842000,-6.008000],[-63.620003,4.830000,-5.994000],[-63.828003,5.664000,-5.004000],[-63.882004,5.678000,-5.016000],[-63.720001,4.860000,-6.030000],[-63.930004,5.700000,-5.034000],[-63.968002,5.730000,-5.060000],[-63.760002,4.886000,-6.060000],[-61.792004,-5.740000,-6.832000],[-61.584003,-6.730000,-6.020000],[-61.630001,-6.758000,-6.042000],[-61.838001,-5.764000,-6.856000],[-61.878002,-5.794000,-6.892000],[-61.668003,-6.794000,-6.074000],[-61.460003,-7.640000,-5.110000],[-61.420002,-7.598001,-5.084000],[-61.374004,-7.568000,-5.066000],[-61.740002,-5.726000,-6.816000],[-61.530003,-6.716001,-6.008000],[-61.322002,-7.550000,-5.054000],[-62.000004,-4.628000,-7.486001],[-61.948002,-4.618000,-7.468000],[-62.048004,-4.648000,-7.514000],[-62.088001,-4.672000,-7.554000],[-57.688004,4.198000,-7.428000],[-58.386002,4.206000,-7.444000],[-58.596004,5.256000,-6.514000],[-57.898003,5.246000,-6.500000],[-58.108002,6.152000,-5.424000],[-58.806004,6.166000,-5.436000],[-57.478004,3.028000,-8.178000],[-58.176003,3.036000,-8.196000],[-57.052002,4.184000,-7.402000],[-56.842003,3.018000,-8.150001],[-56.300003,3.004000,-8.112000],[-56.508003,4.162000,-7.366000],[-57.262001,5.228000,-6.478000],[-56.718002,5.202000,-6.446000],[-56.928001,6.102000,-5.378000],[-57.472004,6.132000,-5.406000],[-61.388004,7.456000,-2.944000],[-60.686005,7.472000,-2.950000],[-60.478004,6.912000,-4.238000],[-61.178001,6.896000,-4.228000],[-59.746002,6.916000,-4.240000],[-59.956001,7.476000,-2.952000],[-61.598003,7.808001,-1.600000],[-60.896004,7.824000,-1.604000],[-60.166004,7.830000,-1.606000],[-60.376003,7.956000,-0.228000],[-61.106003,7.950000,-0.228000],[-61.808002,7.932000,-0.228000],[-62.030003,7.430000,-2.936000],[-62.238003,7.780000,-1.598000],[-62.448002,7.906000,-0.228000],[-61.820004,6.872000,-4.214000],[-56.010002,-6.240000,-7.394001],[-56.708004,-6.254000,-7.410000],[-56.918003,-5.044000,-8.122001],[-56.218002,-5.032000,-8.104000],[-55.800003,-7.314000,-6.514000],[-56.498001,-7.330000,-6.528000],[-56.288002,-8.240001,-5.490000],[-55.590004,-8.222000,-5.478000],[-55.374004,-6.218000,-7.368001],[-55.164001,-7.288001,-6.492000],[-54.954002,-8.192000,-5.460000],[-54.412003,-8.152000,-5.432000],[-54.622002,-7.250000,-6.460001],[-54.830002,-6.184000,-7.334000],[-55.584003,-5.014000,-8.078000],[-55.040001,-4.988000,-8.036000],[-58.030003,-9.432000,-3.000000],[-57.328003,-9.454000,-3.006000],[-57.120003,-9.756001,-1.634000],[-57.820004,-9.734000,-1.632000],[-57.612003,-9.836000,-0.228000],[-56.910004,-9.858001,-0.228000],[-56.178001,-9.864000,-0.228000],[-56.388004,-9.764001,-1.636000],[-56.598003,-9.460000,-3.008000],[-58.240002,-8.928000,-4.292000],[-57.538002,-8.948000,-4.302000],[-56.808002,-8.954000,-4.306000],[-58.672001,-9.398001,-2.990000],[-58.882004,-8.896001,-4.280000],[-59.434002,-8.850000,-4.260000],[-59.224003,-9.352000,-2.976000],[-58.464005,-9.700001,-1.628000],[-59.014004,-9.650001,-1.620000],[-58.804005,-9.752001,-0.228000],[-58.254002,-9.800000,-0.228000],[-59.980003,-9.218000,-2.936000],[-59.770004,-9.514001,-1.600000],[-60.008003,-9.432000,-1.590000],[-60.216003,-9.140000,-2.914000],[-59.798004,-9.532001,-0.228000],[-59.562004,-9.612000,-0.228000],[-59.654003,-9.290001,-2.958000],[-59.444004,-9.588000,-1.610000],[-59.234001,-9.688001,-0.228000],[-60.190002,-8.724000,-4.202000],[-59.864002,-8.792001,-4.232000],[-60.426003,-8.650001,-4.168000],[-64.172005,7.290000,2.426000],[-63.848003,7.346000,2.448000],[-63.638004,7.692000,1.124000],[-63.962002,7.634000,1.114000],[-63.208004,7.742001,1.132000],[-63.418003,7.394001,2.464000],[-64.380005,6.744000,3.682000],[-64.058006,6.794000,3.712000],[-63.628002,6.838000,3.736000],[-63.838001,6.102000,4.922000],[-64.266006,6.062000,4.890000],[-64.590004,6.016000,4.850000],[-64.408005,7.230000,2.404000],[-64.616005,6.688000,3.648000],[-64.826004,5.968000,4.808000],[-64.198006,7.572001,1.102000],[-64.300003,6.878000,-2.730000],[-64.346001,6.904000,-2.740000],[-64.556000,7.230000,-1.498000],[-64.510002,7.202000,-1.494000],[-64.718002,7.318000,-0.228000],[-64.766006,7.346000,-0.228000],[-64.804001,7.384000,-0.228000],[-64.596001,7.268000,-1.506000],[-64.388000,6.940001,-2.754000],[-64.090004,6.362000,-3.914000],[-64.138000,6.386000,-3.928000],[-64.178001,6.420000,-3.948000],[-64.248001,6.862000,-2.726000],[-64.038002,6.348001,-3.906000],[-64.456001,7.186000,-1.490000],[-64.666000,7.300000,-0.228000],[-62.780003,-0.908000,-8.610001],[-62.570004,-2.224000,-8.482000],[-62.628002,-2.244000,-8.554001],[-62.838001,-0.918000,-8.682000],[-62.936005,-0.926000,-8.758000],[-62.728004,-2.266000,-8.630000],[-62.518002,-3.578000,-8.304001],[-62.420002,-3.546000,-8.232000],[-62.360004,-3.514000,-8.162001],[-62.744003,-0.900000,-8.542001],[-62.534004,-2.206000,-8.416000],[-62.326004,-3.486000,-8.100000],[-62.988003,0.400000,-8.534000],[-62.954002,0.398000,-8.468000],[-63.162003,1.656000,-8.182000],[-63.198002,1.670000,-8.246000],[-63.048004,0.402000,-8.606000],[-63.258003,1.682000,-8.314000],[-63.356003,1.696000,-8.388000],[-63.146004,0.406000,-8.680000],[-58.528004,7.456000,-2.944000],[-58.318005,6.896000,-4.228000],[-59.016003,6.912000,-4.238000],[-59.226002,7.472000,-2.950000],[-57.890003,7.430000,-2.936000],[-57.682003,6.872000,-4.214000],[-57.138004,6.838000,-4.194000],[-57.348003,7.394001,-2.922000],[-58.738003,7.808001,-1.600000],[-58.100002,7.780000,-1.598000],[-57.558002,7.742001,-1.590000],[-57.768002,7.866000,-0.228000],[-58.310001,7.906000,-0.228000],[-58.948002,7.932000,-0.228000],[-59.436005,7.824000,-1.604000],[-59.646004,7.950000,-0.228000],[-62.228004,7.456000,2.488000],[-62.438004,6.896000,3.772000],[-61.736004,6.912000,3.780000],[-61.526005,7.472000,2.494000],[-60.796001,7.476000,2.496000],[-61.006004,6.916000,3.784000],[-61.214005,6.170000,4.982000],[-61.946003,6.166000,4.978000],[-62.648003,6.152000,4.968000],[-62.868004,7.430000,2.478000],[-63.078003,6.872000,3.758000],[-63.288002,6.132000,4.948000],[-62.018002,7.808001,1.144000],[-62.658005,7.780000,1.140000],[-61.316002,7.824000,1.148000],[-60.586002,7.830000,1.148000],[-55.170002,-9.432000,-3.000000],[-54.960003,-9.734000,-1.632000],[-55.660004,-9.756001,-1.634000],[-55.868004,-9.454000,-3.006000],[-55.448002,-9.858001,-0.228000],[-54.750004,-9.836000,-0.228000],[-54.534004,-9.398001,-2.990000],[-54.324001,-9.700001,-1.628000],[-54.116001,-9.800000,-0.228000],[-53.572002,-9.752001,-0.228000],[-53.782001,-9.650001,-1.620000],[-53.992004,-9.352000,-2.976000],[-55.380001,-8.928000,-4.292000],[-54.744003,-8.896001,-4.280000],[-54.200001,-8.850000,-4.260000],[-56.078003,-8.948000,-4.302000],[-54.096001,-6.096000,-7.232000],[-53.888004,-7.148000,-6.374000],[-54.200001,-7.204000,-6.420000],[-54.412003,-6.144000,-7.288001],[-53.990002,-8.096001,-5.398000],[-53.678001,-8.036000,-5.360000],[-53.874004,-6.046000,-7.174000],[-53.664001,-7.086000,-6.322001],[-53.454002,-7.966001,-5.316000],[-53.304001,-7.894001,-5.272000],[-53.512001,-7.022000,-6.268000],[-53.722004,-5.990000,-7.114000],[-54.306004,-4.916000,-7.928000],[-54.082001,-4.876000,-7.864000],[-53.932003,-4.832000,-7.796000],[-54.142002,-3.578000,-8.304001],[-54.292004,-3.610000,-8.376000],[-54.516003,-3.642000,-8.446000],[-54.620003,-4.956000,-7.986001],[-54.830002,-3.672000,-8.508000],[-57.192001,-9.432000,2.544000],[-57.402004,-9.734000,1.176000],[-56.700005,-9.756001,1.178000],[-56.490002,-9.454000,2.548000],[-55.758003,-9.460000,2.550000],[-55.968002,-9.764001,1.180000],[-57.832005,-9.398001,2.534000],[-58.042004,-9.700001,1.170000],[-58.594002,-9.650001,1.164000],[-58.386002,-9.352000,2.520000],[-56.982002,-8.928000,3.836000],[-57.622002,-8.896001,3.822000],[-58.176003,-8.850000,3.802000],[-57.964005,-8.152000,4.976000],[-57.414001,-8.192000,5.002000],[-56.772003,-8.222000,5.020000],[-56.280003,-8.948000,3.846000],[-56.070004,-8.240001,5.032000],[-55.340004,-8.246000,5.036000],[-55.548004,-8.954000,3.848000],[-54.936001,-0.946000,-8.908000],[-54.712002,-0.936000,-8.834001],[-54.502003,-2.286000,-8.704000],[-54.726002,-2.308000,-8.776000],[-54.350002,-2.266000,-8.630000],[-54.560001,-0.926000,-8.758000],[-55.144001,0.412000,-8.830001],[-54.920002,0.408000,-8.756001],[-54.770004,0.406000,-8.680000],[-54.980003,1.696000,-8.388000],[-55.130001,1.710000,-8.460000],[-55.354004,1.724000,-8.530001],[-55.248001,-0.952000,-8.974000],[-55.460003,0.414000,-8.894000],[-55.670002,1.736000,-8.594001],[-55.040001,-2.326000,-8.840000],[-60.956001,-8.684000,-2.782000],[-60.904003,-8.664001,-2.776000],[-60.694004,-8.942000,-1.520000],[-60.746002,-8.962001,-1.522000],[-60.538002,-9.054001,-0.228000],[-60.486004,-9.032001,-0.228000],[-61.166004,-8.218000,-3.974000],[-61.112003,-8.198000,-3.964000],[-61.004002,-8.718000,-2.792000],[-61.212002,-8.250000,-3.988000],[-61.250004,-8.296000,-4.008000],[-61.042004,-8.764001,-2.806000],[-60.794003,-8.996000,-1.526000],[-60.834003,-9.046000,-1.534000],[-60.624004,-9.140000,-0.228000],[-60.584003,-9.090000,-0.228000],[-59.722004,-8.898001,2.388000],[-59.512001,-8.422000,3.608000],[-59.558002,-8.354000,3.578000],[-59.766003,-8.826000,2.366000],[-59.804005,-8.764001,2.348000],[-59.596004,-8.296000,3.552000],[-59.386002,-7.640000,4.652000],[-59.348003,-7.694000,4.686000],[-59.304005,-7.754000,4.726000],[-59.654003,-8.976001,2.410000],[-59.444004,-8.496000,3.642000],[-59.234001,-7.824000,4.770000],[-59.124004,-7.894001,4.814000],[-59.334003,-8.574000,3.676000],[-59.544003,-9.058001,2.434000],[-59.932003,-9.184000,1.096000],[-59.862003,-9.264001,1.108000],[-59.754002,-9.348001,1.120000],[-59.976002,-9.110001,1.086000],[-60.014004,-9.046000,1.078000],[-64.916000,6.878000,2.274000],[-64.970001,6.862000,2.268000],[-65.180000,6.348001,3.448000],[-65.125999,6.362000,3.458000],[-65.334000,5.678000,4.558000],[-65.388000,5.664000,4.548000],[-65.446007,5.660000,4.544000],[-65.236000,6.344000,3.446000],[-65.028000,6.858000,2.266000],[-64.708000,7.202000,1.036000],[-64.762001,7.186000,1.034000],[-64.818001,7.180000,1.032000],[-64.866005,6.904000,2.284000],[-64.656006,7.230000,1.042000],[-65.076004,6.386000,3.472000],[-65.284004,5.700000,4.578000],[-65.580002,3.968000,6.568000],[-65.514000,4.002000,6.626000],[-65.304001,5.000000,5.744000],[-65.370003,4.958000,5.692000],[-65.198006,5.044000,5.796000],[-65.408005,4.036000,6.688000],[-65.790001,2.866000,7.276000],[-65.724007,2.890000,7.342000],[-65.618004,2.914000,7.410000],[-65.826004,1.696000,7.932000],[-65.934006,1.682000,7.858000],[-65.998001,1.670000,7.788001],[-65.622002,3.938000,6.514000],[-65.832001,2.842000,7.216001],[-66.042000,1.656000,7.724000],[-66.076004,1.646000,7.670001],[-65.866005,2.824000,7.166000],[-65.658005,3.910000,6.466000],[-65.414001,4.920000,5.644000],[-65.448006,4.886000,5.604000],[-63.616001,3.968000,-7.024000],[-63.676003,4.002000,-7.084000],[-63.886002,5.000000,-6.200000],[-63.826004,4.958000,-6.148000],[-64.034004,5.814000,-5.132000],[-64.094002,5.864000,-5.174000],[-64.194000,5.914001,-5.220000],[-63.984001,5.044000,-6.254000],[-63.774002,4.036000,-7.144001],[-63.408005,2.866000,-7.732000],[-63.466003,2.890000,-7.798000],[-63.564003,2.914000,-7.866000],[-63.580002,3.938000,-6.970000],[-63.370003,2.842000,-7.674000],[-63.790005,4.920000,-6.100000],[-63.998005,5.768000,-5.094000],[-61.942001,-5.884000,-6.992000],[-62.000004,-5.936000,-7.052001],[-62.210003,-4.788000,-7.728000],[-62.152004,-4.744000,-7.664001],[-62.308002,-4.832000,-7.796000],[-62.098003,-5.990000,-7.114000],[-61.732002,-6.898000,-6.162000],[-61.792004,-6.960001,-6.214000],[-61.890003,-7.022000,-6.268000],[-61.680004,-7.894001,-5.272000],[-61.582005,-7.824000,-5.226000],[-61.524002,-7.754000,-5.184000],[-61.908005,-5.836000,-6.938000],[-61.698002,-6.842000,-6.114000],[-61.488003,-7.694000,-5.144000],[-62.116001,-4.706000,-7.604001],[-59.366001,7.456000,2.488000],[-60.066002,7.472000,2.494000],[-60.274002,6.912000,3.780000],[-59.576004,6.896000,3.772000],[-59.786003,6.152000,4.968000],[-60.484001,6.166000,4.978000],[-59.158001,7.808001,1.144000],[-59.856003,7.824000,1.148000],[-58.730003,7.430000,2.478000],[-58.522003,7.780000,1.140000],[-57.976002,7.742001,1.132000],[-58.186005,7.394001,2.464000],[-58.940002,6.872000,3.758000],[-58.396004,6.838000,3.736000],[-58.606003,6.102000,4.922000],[-59.150002,6.132000,4.948000],[-55.774002,4.106000,-7.266000],[-55.984001,5.132000,-6.358000],[-55.758003,5.088000,-6.308000],[-55.550003,4.072000,-7.208000],[-55.398003,4.036000,-7.144001],[-55.608002,5.044000,-6.254000],[-55.816002,5.914001,-5.220000],[-55.968002,5.968000,-5.264000],[-56.194004,6.016000,-5.306000],[-56.088001,4.136000,-7.322001],[-56.298004,5.168000,-6.406000],[-56.506004,6.062000,-5.346000],[-55.564003,2.964000,-8.000000],[-55.878002,2.984000,-8.060000],[-55.340004,2.940000,-7.934000],[-55.188004,2.914000,-7.866000],[-63.066002,4.198000,6.972000],[-62.366001,4.206000,6.986001],[-62.156002,5.256000,6.056000],[-62.856003,5.246000,6.042000],[-61.424004,5.260000,6.062000],[-61.634003,4.210000,6.992000],[-63.276005,3.028000,7.722001],[-62.576004,3.036000,7.738000],[-61.844002,3.038000,7.746000],[-62.054005,1.768000,8.288000],[-62.786003,1.766000,8.284000],[-63.486004,1.762000,8.264000],[-63.708004,4.182000,6.946000],[-63.916004,3.018000,7.694000],[-64.125999,1.756000,8.234000],[-64.676003,1.748000,8.192000],[-64.468002,3.004000,7.654000],[-64.258003,4.162000,6.910000],[-63.498005,5.228000,6.020000],[-64.048004,5.202000,5.990000],[-54.330002,-9.432000,2.544000],[-55.028004,-9.454000,2.548000],[-55.238003,-9.756001,1.178000],[-54.540001,-9.734000,1.176000],[-54.122002,-8.928000,3.836000],[-54.818001,-8.948000,3.846000],[-54.608002,-8.240001,5.032000],[-53.912003,-8.222000,5.020000],[-53.696003,-9.398001,2.534000],[-53.486004,-8.896001,3.822000],[-53.276001,-8.192000,5.002000],[-52.732002,-8.152000,4.976000],[-52.942001,-8.850000,3.802000],[-53.154003,-9.352000,2.520000],[-53.906002,-9.700001,1.170000],[-53.362003,-9.650001,1.164000],[-59.142002,-9.218000,2.480000],[-58.816002,-9.290001,2.502000],[-58.606003,-8.792001,3.776000],[-58.932003,-8.724000,3.744000],[-58.722004,-8.036000,4.902000],[-58.396004,-8.096001,4.942000],[-59.352001,-9.514001,1.144000],[-59.026001,-9.588000,1.154000],[-59.378002,-9.140000,2.458000],[-59.590004,-9.432000,1.132000],[-59.170002,-8.650001,3.712000],[-58.960003,-7.966001,4.860000],[-56.352001,-6.240000,6.938000],[-55.650002,-6.254000,6.952000],[-55.440002,-5.044000,7.664001],[-56.142002,-5.032000,7.648000],[-55.932003,-3.730000,8.178000],[-55.230003,-3.736000,8.196000],[-54.500004,-3.740000,8.202001],[-54.710003,-5.048000,7.670001],[-54.920002,-6.258000,6.958000],[-56.562004,-7.314000,6.058000],[-55.860004,-7.330000,6.072001],[-55.130001,-7.336000,6.076000],[-56.994003,-6.218000,6.912000],[-57.204002,-7.288001,6.036000],[-57.756004,-7.250000,6.004000],[-57.546001,-6.184000,6.876000],[-56.784004,-5.014000,7.620000],[-57.336002,-4.988000,7.580000],[-57.126003,-3.696000,8.106000],[-56.574001,-3.716000,8.148001],[-54.410004,-0.908000,-8.610001],[-54.200001,-2.224000,-8.482000],[-54.256004,-2.244000,-8.554001],[-54.466003,-0.918000,-8.682000],[-54.048004,-3.546000,-8.232000],[-53.992004,-3.514000,-8.162001],[-54.378002,-0.900000,-8.542001],[-54.168003,-2.206000,-8.416000],[-53.960003,-3.486000,-8.100000],[-53.934002,-3.460000,-8.046000],[-54.142002,-2.190000,-8.360001],[-54.350002,-0.894000,-8.484000],[-54.620003,0.400000,-8.534000],[-54.588001,0.398000,-8.468000],[-54.560001,0.396000,-8.410001],[-54.770004,1.646000,-8.126000],[-54.796001,1.656000,-8.182000],[-54.828003,1.670000,-8.246000],[-54.676003,0.402000,-8.606000],[-54.884003,1.682000,-8.314000],[-59.902004,-8.684000,2.324000],[-59.850002,-8.718000,2.334000],[-59.640003,-8.250000,3.532000],[-59.692001,-8.218000,3.516000],[-59.482002,-7.568000,4.608000],[-59.432003,-7.598001,4.626000],[-60.110004,-8.962001,1.064000],[-60.058002,-8.996000,1.070000],[-59.956001,-8.664001,2.320000],[-60.166004,-8.942000,1.062000],[-60.222004,-8.934000,1.062000],[-60.012001,-8.656000,2.316000],[-59.746002,-8.198000,3.508000],[-59.802002,-8.192000,3.506000],[-59.594002,-7.544000,4.592000],[-59.538002,-7.550000,4.596000],[-58.884003,-5.884000,6.536000],[-58.930004,-5.836000,6.482000],[-59.140003,-6.842000,5.658000],[-59.094002,-6.898000,5.706000],[-59.176003,-6.794000,5.618000],[-58.968002,-5.794000,6.436000],[-58.676003,-4.744000,7.206000],[-58.722004,-4.706000,7.148000],[-58.758003,-4.672000,7.096000],[-58.550003,-3.460000,7.590000],[-58.512001,-3.486000,7.644001],[-58.466003,-3.514000,7.706000],[-58.816002,-5.936000,6.594000],[-58.606003,-4.788000,7.270000],[-58.398003,-3.546000,7.776000],[-58.288002,-3.578000,7.846000],[-58.498001,-4.832000,7.338000],[-58.708004,-5.990000,6.656000],[-59.026001,-6.960001,5.758000],[-58.916004,-7.022000,5.812000],[-65.010002,4.106000,6.810000],[-64.802002,5.132000,5.902000],[-65.036003,5.088000,5.850000],[-65.246002,4.072000,6.750000],[-64.686005,4.136000,6.864000],[-64.476006,5.168000,5.948000],[-65.220001,2.964000,7.542000],[-64.896004,2.984000,7.602000],[-65.106003,1.736000,8.138000],[-65.428001,1.724000,8.074000],[-65.456001,2.940000,7.478000],[-65.664001,1.710000,8.004001],[-65.136002,6.878000,2.274000],[-65.344002,6.362000,3.458000],[-65.292000,6.348001,3.448000],[-65.082001,6.862000,2.268000],[-65.500000,5.664000,4.548000],[-65.554001,5.678000,4.558000],[-65.184006,6.904000,2.284000],[-65.392006,6.386000,3.472000],[-65.602005,5.700000,4.578000],[-65.642006,5.730000,4.602000],[-65.432007,6.420000,3.492000],[-65.224007,6.940001,2.298000],[-64.926003,7.202000,1.036000],[-64.974007,7.230000,1.042000],[-65.014000,7.268000,1.048000],[-64.874001,7.186000,1.034000],[-65.290001,7.044000,2.336000],[-65.254005,6.988000,2.316000],[-65.044006,7.318000,1.058000],[-65.080002,7.376000,1.068000],[-64.872002,7.494000,-0.228000],[-64.836006,7.434000,-0.228000],[-65.500000,6.516000,3.548000],[-65.462006,6.464000,3.516000],[-65.672005,5.768000,4.636000],[-65.708000,5.814000,4.676000],[-65.350006,7.104001,2.358000],[-65.560005,6.572001,3.580000],[-65.768005,5.864000,4.718000],[-65.870003,5.914001,4.762000],[-65.660004,6.630000,3.614000],[-65.450005,7.166000,2.380000],[-65.139999,7.440001,1.078000],[-65.240005,7.506001,1.090000],[-65.032005,7.624001,-0.228000],[-64.932007,7.558001,-0.228000],[-64.452003,7.044000,-2.792000],[-64.244003,6.516000,-4.004000],[-64.302002,6.572001,-4.038000],[-64.512001,7.104001,-2.814000],[-64.612000,7.166000,-2.838000],[-64.402000,6.630000,-4.072000],[-64.417999,6.988000,-2.772000],[-64.208000,6.464000,-3.974000],[-64.662003,7.376000,-1.524000],[-64.625999,7.318000,-1.514000],[-64.722000,7.440001,-1.536000],[-64.822006,7.506001,-1.548000],[-64.156006,4.106000,-7.266000],[-64.368004,5.132000,-6.358000],[-64.139999,5.088000,-6.308000],[-63.930004,4.072000,-7.208000],[-64.348000,5.968000,-5.264000],[-64.578003,6.016000,-5.306000],[-64.476006,4.136000,-7.322001],[-64.684006,5.168000,-6.406000],[-64.894005,6.062000,-5.346000],[-65.318001,6.102000,-5.378000],[-65.108002,5.202000,-6.446000],[-64.898003,4.162000,-7.366000],[-63.948002,2.964000,-8.000000],[-64.266006,2.984000,-8.060000],[-64.688004,3.004000,-8.112000],[-64.480003,1.748000,-8.648001],[-64.056000,1.736000,-8.594001],[-63.738003,1.724000,-8.530001],[-63.720001,2.940000,-7.934000],[-63.510002,1.710000,-8.460000],[-61.104004,-8.898001,-2.844000],[-60.896004,-9.184000,-1.554000],[-60.954002,-9.264001,-1.566000],[-61.164001,-8.976001,-2.866000],[-61.260002,-9.058001,-2.890000],[-61.052002,-9.348001,-1.576000],[-60.842003,-9.446000,-0.228000],[-60.746002,-9.360001,-0.228000],[-60.688004,-9.278001,-0.228000],[-61.072002,-8.826000,-2.824000],[-60.860004,-9.110001,-1.542000],[-60.652004,-9.204000,-0.228000],[-61.316002,-8.422000,-4.066000],[-61.280003,-8.354000,-4.036000],[-61.372002,-8.496000,-4.100000],[-61.472004,-8.574000,-4.134000],[-63.320004,-0.946000,-8.908000],[-63.636002,-0.952000,-8.974000],[-63.846004,0.414000,-8.894000],[-63.530003,0.412000,-8.830001],[-64.268005,0.414000,-8.952001],[-64.058006,-0.958000,-9.030001],[-63.110004,-2.308000,-8.776000],[-63.426003,-2.326000,-8.840000],[-63.850002,-2.342000,-8.898001],[-63.640003,-3.696000,-8.562000],[-63.218002,-3.672000,-8.508000],[-62.900002,-3.642000,-8.446000],[-63.092003,-0.936000,-8.834001],[-62.882004,-2.286000,-8.704000],[-62.672005,-3.610000,-8.376000],[-63.302002,0.408000,-8.756001],[-56.612003,7.290000,-2.884000],[-56.388004,7.230000,-2.862000],[-56.178001,6.688000,-4.106000],[-56.402004,6.744000,-4.138000],[-56.026001,6.630000,-4.072000],[-56.236004,7.166000,-2.838000],[-56.822002,7.634000,-1.570000],[-56.598003,7.572001,-1.560000],[-56.446003,7.506001,-1.548000],[-56.654003,7.624001,-0.228000],[-56.806004,7.692000,-0.228000],[-57.032001,7.756001,-0.228000],[-56.928001,7.346000,-2.904000],[-57.136002,7.692000,-1.580000],[-57.346004,7.816000,-0.228000],[-56.718002,6.794000,-4.168000],[-60.206001,4.198000,6.972000],[-59.996002,5.246000,6.042000],[-60.694004,5.256000,6.056000],[-60.904003,4.206000,6.986001],[-59.570004,4.182000,6.946000],[-59.360004,5.228000,6.020000],[-58.816002,5.202000,5.990000],[-59.026001,4.162000,6.910000],[-60.416004,3.028000,7.722001],[-59.780003,3.018000,7.694000],[-59.236004,3.004000,7.654000],[-59.444004,1.748000,8.192000],[-59.990002,1.756000,8.234000],[-60.626003,1.762000,8.264000],[-61.116001,3.036000,7.738000],[-61.326004,1.766000,8.284000],[-63.906002,-0.970000,8.650001],[-64.116005,-2.362000,8.516001],[-63.414001,-2.368000,8.534000],[-63.204002,-0.972000,8.670000],[-62.474003,-0.972000,8.676001],[-62.684002,-2.370000,8.540000],[-62.894005,-3.740000,8.202001],[-63.624004,-3.736000,8.196000],[-64.326004,-3.730000,8.178000],[-64.546005,-0.966000,8.618000],[-64.758003,-2.354000,8.484000],[-64.966003,-3.716000,8.148001],[-65.516006,-3.696000,8.106000],[-65.306000,-2.342000,8.440001],[-65.096001,-0.958000,8.574000],[-63.696003,0.418000,8.570001],[-64.336006,0.416000,8.538000],[-64.886002,0.414000,8.494000],[-62.994003,0.418000,8.590000],[-62.264004,0.418000,8.596001],[-53.492004,-6.240000,6.938000],[-53.282001,-5.032000,7.648000],[-53.980003,-5.044000,7.664001],[-54.190002,-6.254000,6.952000],[-53.770004,-3.736000,8.196000],[-53.072002,-3.730000,8.178000],[-52.856003,-6.218000,6.912000],[-52.646004,-5.014000,7.620000],[-52.438004,-3.716000,8.148001],[-51.894001,-3.696000,8.106000],[-52.104004,-4.988000,7.580000],[-52.314003,-6.184000,6.876000],[-53.702003,-7.314000,6.058000],[-53.066002,-7.288001,6.036000],[-52.522003,-7.250000,6.004000],[-54.400002,-7.330000,6.072001],[-53.258003,-9.218000,-2.936000],[-53.036003,-9.140000,-2.914000],[-52.826004,-9.432000,-1.590000],[-53.048004,-9.514001,-1.600000],[-52.840004,-9.612000,-0.228000],[-52.616001,-9.532001,-0.228000],[-52.466003,-9.446000,-0.228000],[-52.676003,-9.348001,-1.576000],[-52.886002,-9.058001,-2.890000],[-53.468002,-8.724000,-4.202000],[-53.244003,-8.650001,-4.168000],[-53.094002,-8.574000,-4.134000],[-53.572002,-9.290001,-2.958000],[-53.782001,-8.792001,-4.232000],[-53.362003,-9.588000,-1.610000],[-53.154003,-9.688001,-0.228000],[-58.304005,-6.096000,6.776000],[-58.514004,-7.148000,5.918000],[-58.186005,-7.204000,5.964000],[-57.976002,-6.144000,6.830000],[-58.542004,-6.046000,6.718000],[-58.752003,-7.086000,5.864000],[-58.094002,-4.916000,7.470000],[-58.332005,-4.876000,7.406000],[-58.122002,-3.610000,7.920001],[-57.884003,-3.642000,7.988000],[-57.768002,-4.956000,7.530000],[-57.558002,-3.672000,8.052000],[-55.514004,-0.970000,8.650001],[-55.722004,-2.362000,8.516001],[-55.020004,-2.368000,8.534000],[-54.812004,-0.972000,8.670000],[-54.080002,-0.972000,8.676001],[-54.290001,-2.370000,8.540000],[-56.154003,-0.966000,8.618000],[-56.364002,-2.354000,8.484000],[-56.918003,-2.342000,8.440001],[-56.706001,-0.958000,8.574000],[-55.304001,0.418000,8.570001],[-55.944004,0.416000,8.538000],[-56.496002,0.414000,8.494000],[-56.286003,1.748000,8.192000],[-55.736004,1.756000,8.234000],[-55.092003,1.762000,8.264000],[-54.602001,0.418000,8.590000],[-54.390003,1.766000,8.284000],[-53.660004,1.768000,8.288000],[-53.870003,0.418000,8.596001],[-60.120003,-8.684000,2.324000],[-59.912003,-8.218000,3.516000],[-59.958004,-8.250000,3.532000],[-60.166004,-8.718000,2.334000],[-60.206001,-8.764001,2.348000],[-59.996002,-8.296000,3.552000],[-59.788002,-7.640000,4.652000],[-59.748001,-7.598001,4.626000],[-59.702003,-7.568000,4.608000],[-60.068005,-8.664001,2.320000],[-59.858002,-8.198000,3.508000],[-59.650002,-7.550000,4.596000],[-60.328003,-8.962001,1.064000],[-60.278004,-8.942000,1.062000],[-60.376003,-8.996000,1.070000],[-60.414001,-9.046000,1.078000],[-59.064003,-5.740000,6.374000],[-59.274002,-6.730000,5.564000],[-59.222004,-6.758000,5.586000],[-59.012001,-5.764000,6.400000],[-59.120003,-5.726000,6.358000],[-59.328003,-6.716001,5.550000],[-59.386002,-6.710001,5.546000],[-59.176003,-5.724000,6.354000],[-58.856003,-4.628000,7.030000],[-58.912003,-4.618000,7.012001],[-58.968002,-4.614000,7.006001],[-58.758003,-3.418000,7.492001],[-58.702003,-3.420000,7.498000],[-58.646004,-3.428000,7.518000],[-58.804005,-4.648000,7.056000],[-58.596004,-3.442000,7.546000],[-65.972000,3.876000,6.406000],[-65.918007,3.866000,6.390000],[-65.710007,4.830000,5.538000],[-65.762001,4.842000,5.550000],[-65.653999,4.828000,5.532000],[-65.862000,3.864000,6.386000],[-66.182007,2.798000,7.098001],[-66.128006,2.792000,7.080000],[-66.072006,2.792000,7.074000],[-66.280006,1.628000,7.572001],[-66.338005,1.628000,7.578001],[-66.389999,1.632000,7.596000],[-66.018005,3.890000,6.432000],[-66.228004,2.810000,7.124001],[-66.438004,1.638000,7.626000],[-66.478004,1.646000,7.670001],[-66.270004,2.824000,7.166000],[-66.060005,3.910000,6.466000],[-65.810005,4.860000,5.572000],[-65.850006,4.886000,5.604000],[-65.752007,3.876000,6.406000],[-65.960007,2.798000,7.098001],[-65.910004,2.810000,7.124001],[-65.702003,3.890000,6.432000],[-66.120003,1.638000,7.626000],[-66.170006,1.632000,7.596000],[-65.806000,3.866000,6.390000],[-66.016006,2.792000,7.080000],[-66.226006,1.628000,7.578001],[-65.544006,4.842000,5.550000],[-65.598000,4.830000,5.538000],[-65.492004,4.860000,5.572000],[-66.418007,-0.908000,8.152000],[-66.208000,0.400000,8.078000],[-66.250000,0.398000,8.010000],[-66.460007,-0.900000,8.086000],[-66.494003,-0.894000,8.028001],[-66.286003,0.396000,7.954000],[-66.350006,-0.918000,8.226001],[-66.142006,0.402000,8.148001],[-66.036003,0.406000,8.224000],[-66.246002,-0.926000,8.302000],[-66.625999,-2.224000,8.026000],[-66.562004,-2.244000,8.098001],[-66.456001,-2.266000,8.172000],[-66.664001,-3.578000,7.846000],[-66.770004,-3.546000,7.776000],[-66.836006,-3.514000,7.706000],[-66.670006,-2.206000,7.958000],[-66.878006,-3.486000,7.644001],[-66.912003,-3.460000,7.590000],[-66.704002,-2.190000,7.904000],[-64.996002,7.290000,-2.884000],[-64.768005,7.230000,-2.862000],[-64.558006,6.688000,-4.106000],[-64.786003,6.744000,-4.138000],[-65.204002,7.634000,-1.570000],[-64.978004,7.572001,-1.560000],[-65.186005,7.692000,-0.228000],[-65.414001,7.756001,-0.228000],[-65.314003,7.346000,-2.904000],[-65.524002,7.692000,-1.580000],[-65.734001,7.816000,-0.228000],[-66.156006,7.866000,-0.228000],[-65.948006,7.742001,-1.590000],[-65.738007,7.394001,-2.922000],[-65.104004,6.794000,-4.168000],[-65.526001,6.838000,-4.194000],[-60.268002,-8.898001,2.388000],[-60.326004,-8.976001,2.410000],[-60.536003,-9.264001,1.108000],[-60.478004,-9.184000,1.096000],[-60.634003,-9.348001,1.120000],[-60.424004,-9.058001,2.434000],[-60.060001,-8.422000,3.608000],[-60.118004,-8.496000,3.642000],[-60.214005,-8.574000,3.676000],[-60.006004,-7.894001,4.814000],[-59.908001,-7.824000,4.770000],[-59.850002,-7.754000,4.726000],[-60.234001,-8.826000,2.366000],[-60.024002,-8.354000,3.578000],[-59.816002,-7.694000,4.686000],[-60.444004,-9.110001,1.086000],[-61.642002,-9.218000,-2.936000],[-61.416004,-9.140000,-2.914000],[-61.206001,-9.432000,-1.590000],[-61.434002,-9.514001,-1.600000],[-61.224003,-9.612000,-0.228000],[-60.996002,-9.532001,-0.228000],[-61.852001,-8.724000,-4.202000],[-61.624004,-8.650001,-4.168000],[-61.834003,-7.966001,-5.316000],[-62.062004,-8.036000,-5.360000],[-61.960003,-9.290001,-2.958000],[-62.168003,-8.792001,-4.232000],[-62.378002,-8.096001,-5.398000],[-62.800003,-8.152000,-5.432000],[-62.590004,-8.850000,-4.260000],[-62.380001,-9.352000,-2.976000],[-61.750004,-9.588000,-1.610000],[-62.172005,-9.650001,-1.620000],[-61.962002,-9.752001,-0.228000],[-61.540005,-9.688001,-0.228000],[-62.482002,-6.096000,-7.232000],[-62.272003,-7.148000,-6.374000],[-62.588001,-7.204000,-6.420000],[-62.798004,-6.144000,-7.288001],[-63.220001,-6.184000,-7.334000],[-63.010002,-7.250000,-6.460001],[-62.254002,-6.046000,-7.174000],[-62.044003,-7.086000,-6.322001],[-62.690002,-4.916000,-7.928000],[-62.464005,-4.876000,-7.864000],[-63.008003,-4.956000,-7.986001],[-63.430004,-4.988000,-8.036000],[-65.242004,-0.970000,-9.108001],[-65.032005,-2.362000,-8.972000],[-65.732002,-2.368000,-8.992001],[-65.940002,-0.972000,-9.126000],[-66.672005,-0.972000,-9.132000],[-66.462006,-2.370000,-8.998000],[-66.252007,-3.740000,-8.658000],[-65.522003,-3.736000,-8.654000],[-64.822006,-3.730000,-8.634001],[-64.604004,-0.966000,-9.076000],[-64.394005,-2.354000,-8.942000],[-64.184006,-3.716000,-8.604000],[-65.452003,0.418000,-9.026000],[-64.814003,0.416000,-8.996000],[-65.024002,1.756000,-8.692000],[-65.662003,1.762000,-8.722000],[-66.150002,0.418000,-9.046000],[-66.362000,1.766000,-8.740001],[-67.090004,1.768000,-8.746000],[-66.882004,0.418000,-9.052000],[-57.450005,7.290000,2.426000],[-57.660004,6.744000,3.682000],[-57.436001,6.688000,3.648000],[-57.226002,7.230000,2.404000],[-57.074001,7.166000,2.380000],[-57.284004,6.630000,3.614000],[-57.492004,5.914001,4.762000],[-57.644001,5.968000,4.808000],[-57.870003,6.016000,4.850000],[-57.764004,7.346000,2.448000],[-57.976002,6.794000,3.712000],[-58.186005,6.062000,4.890000],[-57.242004,7.634000,1.114000],[-57.556004,7.692000,1.124000],[-57.016003,7.572001,1.102000],[-56.864002,7.506001,1.090000],[-61.046001,-0.970000,8.650001],[-61.744003,-0.972000,8.670000],[-61.954002,-2.368000,8.534000],[-61.256004,-2.362000,8.516001],[-61.464005,-3.730000,8.178000],[-62.164001,-3.736000,8.196000],[-60.836002,0.418000,8.570001],[-61.534004,0.418000,8.590000],[-60.410004,-0.966000,8.618000],[-60.200005,0.416000,8.538000],[-59.654003,0.414000,8.494000],[-59.864002,-0.958000,8.574000],[-60.618004,-2.354000,8.484000],[-60.074001,-2.342000,8.440001],[-60.284004,-3.696000,8.106000],[-60.828003,-3.716000,8.148001],[-55.248001,3.968000,-7.024000],[-55.214005,3.938000,-6.970000],[-55.004002,2.842000,-7.674000],[-55.038002,2.866000,-7.732000],[-54.978004,2.824000,-7.622000],[-55.188004,3.910000,-6.924000],[-55.456001,4.958000,-6.148000],[-55.424004,4.920000,-6.100000],[-55.396004,4.886000,-6.060000],[-55.606003,5.730000,-5.060000],[-55.632004,5.768000,-5.094000],[-55.666004,5.814000,-5.132000],[-55.304001,4.002000,-7.084000],[-55.512001,5.000000,-6.200000],[-55.722004,5.864000,-5.174000],[-55.092003,2.890000,-7.798000],[-64.746002,-6.240000,6.938000],[-64.044006,-6.254000,6.952000],[-63.834003,-5.044000,7.664001],[-64.536003,-5.032000,7.648000],[-63.104004,-5.048000,7.670001],[-63.314003,-6.258000,6.958000],[-64.954002,-7.314000,6.058000],[-64.254005,-7.330000,6.072001],[-63.524002,-7.336000,6.076000],[-63.734001,-8.246000,5.036000],[-64.464005,-8.240001,5.032000],[-65.164001,-8.222000,5.020000],[-65.386002,-6.218000,6.912000],[-65.596001,-7.288001,6.036000],[-65.804001,-8.192000,5.002000],[-66.354004,-8.152000,4.976000],[-66.144005,-7.250000,6.004000],[-65.936005,-6.184000,6.876000],[-65.176003,-5.014000,7.620000],[-65.726006,-4.988000,7.580000],[-65.848000,-0.946000,8.450001],[-65.526001,-0.952000,8.518001],[-65.316002,0.414000,8.438001],[-65.638000,0.412000,8.372001],[-66.058006,-2.308000,8.318001],[-65.734001,-2.326000,8.384001],[-65.944000,-3.672000,8.052000],[-66.268005,-3.642000,7.988000],[-66.082001,-0.936000,8.378000],[-66.294006,-2.286000,8.246000],[-66.502007,-3.610000,7.920001],[-65.874001,0.408000,8.300000],[-52.652004,-0.970000,8.650001],[-53.350002,-0.972000,8.670000],[-53.560001,-2.368000,8.534000],[-52.862003,-2.362000,8.516001],[-52.442001,0.418000,8.570001],[-53.140003,0.418000,8.590000],[-52.930004,1.766000,8.284000],[-52.232002,1.762000,8.264000],[-52.018002,-0.966000,8.618000],[-51.806004,0.416000,8.538000],[-51.596001,1.756000,8.234000],[-51.054001,1.748000,8.192000],[-51.264004,0.414000,8.494000],[-51.474003,-0.958000,8.574000],[-52.228001,-2.354000,8.484000],[-51.684002,-2.342000,8.440001],[-51.582001,-6.096000,6.776000],[-51.896004,-6.144000,6.830000],[-52.104004,-7.204000,5.964000],[-51.792004,-7.148000,5.918000],[-52.000004,-8.036000,4.902000],[-52.314003,-8.096001,4.942000],[-51.372002,-4.916000,7.470000],[-51.684002,-4.956000,7.530000],[-51.474003,-3.672000,8.052000],[-51.162003,-3.642000,7.988000],[-51.360001,-6.046000,6.718000],[-51.150002,-4.876000,7.406000],[-50.940002,-3.610000,7.920001],[-50.790001,-3.578000,7.846000],[-51.000004,-4.832000,7.338000],[-51.210003,-5.990000,6.656000],[-51.570004,-7.086000,5.864000],[-51.420002,-7.022000,5.812000],[-51.628002,-7.894001,4.814000],[-51.778004,-7.966001,4.860000],[-52.420002,-9.218000,2.480000],[-52.630001,-9.514001,1.144000],[-52.408001,-9.432000,1.132000],[-52.196003,-9.140000,2.458000],[-52.048004,-9.058001,2.434000],[-52.258003,-9.348001,1.120000],[-52.732002,-9.290001,2.502000],[-52.942001,-9.588000,1.154000],[-52.210003,-8.724000,3.744000],[-52.524002,-8.792001,3.776000],[-51.988003,-8.650001,3.712000],[-51.838001,-8.574000,3.676000],[-52.736004,-8.898001,-2.844000],[-52.528004,-9.184000,-1.554000],[-52.582001,-9.264001,-1.566000],[-52.790001,-8.976001,-2.866000],[-52.372002,-9.360001,-0.228000],[-52.318001,-9.278001,-0.228000],[-52.706001,-8.826000,-2.824000],[-52.496002,-9.110001,-1.542000],[-52.286003,-9.204000,-0.228000],[-52.260002,-9.140000,-0.228000],[-52.470001,-9.046000,-1.534000],[-52.678001,-8.764001,-2.806000],[-52.946003,-8.422000,-4.066000],[-52.914001,-8.354000,-4.036000],[-52.888004,-8.296000,-4.008000],[-53.096001,-7.640000,-5.110000],[-53.122002,-7.694000,-5.144000],[-53.154003,-7.754000,-5.184000],[-53.000004,-8.496000,-4.100000],[-53.210003,-7.824000,-5.226000],[-53.574001,-5.884000,-6.992000],[-53.542004,-5.836000,-6.938000],[-53.332001,-6.842000,-6.114000],[-53.364002,-6.898000,-6.162000],[-53.306004,-6.794000,-6.074000],[-53.516003,-5.794000,-6.892000],[-53.782001,-4.744000,-7.664001],[-53.750004,-4.706000,-7.604001],[-53.724003,-4.672000,-7.554000],[-53.628002,-5.936000,-7.052001],[-53.838001,-4.788000,-7.728000],[-53.418003,-6.960001,-6.214000],[-57.466003,-0.946000,8.450001],[-57.138004,-0.952000,8.518001],[-56.928001,0.414000,8.438001],[-57.256004,0.412000,8.372001],[-57.046001,1.724000,8.074000],[-56.718002,1.736000,8.138000],[-57.674004,-2.308000,8.318001],[-57.348003,-2.326000,8.384001],[-57.704002,-0.936000,8.378000],[-57.912003,-2.286000,8.246000],[-58.078003,-2.266000,8.172000],[-57.870003,-0.926000,8.302000],[-57.494003,0.408000,8.300000],[-57.660004,0.406000,8.224000],[-57.450005,1.696000,7.932000],[-57.284004,1.710000,8.004001],[-54.672001,4.198000,6.972000],[-53.970001,4.206000,6.986001],[-53.762001,5.256000,6.056000],[-54.464001,5.246000,6.042000],[-54.254002,6.152000,4.968000],[-53.552002,6.166000,4.978000],[-52.820004,6.170000,4.982000],[-53.030003,5.260000,6.062000],[-53.240002,4.210000,6.992000],[-54.882004,3.028000,7.722001],[-54.180004,3.036000,7.738000],[-53.450001,3.038000,7.746000],[-55.316002,4.182000,6.946000],[-55.526001,3.018000,7.694000],[-56.078003,3.004000,7.654000],[-55.868004,4.162000,6.910000],[-55.106003,5.228000,6.020000],[-55.658001,5.202000,5.990000],[-55.448002,6.102000,4.922000],[-54.896004,6.132000,4.948000],[-54.268002,-0.884000,-8.410001],[-54.314003,-0.888000,-8.440001],[-54.524002,0.394000,-8.366000],[-54.478004,0.394000,-8.334001],[-54.686001,1.632000,-8.054001],[-54.732002,1.638000,-8.084001],[-54.060001,-2.170000,-8.284000],[-54.106003,-2.178000,-8.316000],[-53.896004,-3.442000,-8.004001],[-53.850002,-3.428000,-7.974000],[-54.218002,-0.882000,-8.390000],[-54.008003,-2.162000,-8.266001],[-53.798004,-3.420000,-7.956000],[-53.744003,-3.418000,-7.950000],[-53.954002,-2.162000,-8.260000],[-54.162003,-0.880000,-8.384001],[-54.426003,0.392000,-8.316000],[-54.370003,0.392000,-8.310000],[-54.580002,1.628000,-8.030001],[-54.636002,1.628000,-8.036000],[-58.048004,-0.908000,8.152000],[-58.256004,-2.224000,8.026000],[-58.188004,-2.244000,8.098001],[-57.978004,-0.918000,8.226001],[-58.094002,-0.900000,8.086000],[-58.304005,-2.206000,7.958000],[-58.340004,-2.190000,7.904000],[-58.132004,-0.894000,8.028001],[-57.840004,0.400000,8.078000],[-57.884003,0.398000,8.010000],[-57.922001,0.396000,7.954000],[-57.714005,1.646000,7.670001],[-57.676003,1.656000,7.724000],[-57.630001,1.670000,7.788001],[-57.770004,0.402000,8.148001],[-57.560001,1.682000,7.858000],[-66.588005,-0.884000,7.952000],[-66.538002,-0.888000,7.984000],[-66.330002,0.394000,7.910000],[-66.378006,0.394000,7.878000],[-66.798004,-2.170000,7.828001],[-66.748001,-2.178000,7.860001],[-66.956001,-3.442000,7.546000],[-67.006004,-3.428000,7.518000],[-66.642006,-0.882000,7.934000],[-66.852005,-2.162000,7.810000],[-67.060005,-3.420000,7.498000],[-67.118004,-3.418000,7.492001],[-66.908005,-2.162000,7.802001],[-66.700005,-0.880000,7.926001],[-66.434006,0.392000,7.860001],[-66.490005,0.392000,7.854001],[-66.128006,3.968000,6.568000],[-65.918007,4.958000,5.692000],[-65.978004,5.000000,5.744000],[-66.188004,4.002000,6.626000],[-66.286003,4.036000,6.688000],[-66.078003,5.044000,5.796000],[-66.090004,3.938000,6.514000],[-65.880005,4.920000,5.644000],[-66.336006,2.866000,7.276000],[-66.300003,2.842000,7.216001],[-66.508003,1.656000,7.724000],[-66.546005,1.670000,7.788001],[-66.396004,2.890000,7.342000],[-66.606003,1.682000,7.858000],[-66.706001,1.696000,7.932000],[-66.496002,2.914000,7.410000],[-66.082001,4.198000,-7.428000],[-66.782005,4.206000,-7.444000],[-66.992004,5.256000,-6.514000],[-66.292000,5.246000,-6.500000],[-66.502007,6.152000,-5.424000],[-67.200005,6.166000,-5.436000],[-67.932007,6.170000,-5.440000],[-67.720001,5.260000,-6.518000],[-67.510002,4.210000,-7.450000],[-65.872002,3.028000,-8.178000],[-66.572006,3.036000,-8.196000],[-67.300003,3.038000,-8.202001],[-65.444000,4.184000,-7.402000],[-65.234001,3.018000,-8.150001],[-65.653999,5.228000,-6.478000],[-65.864006,6.132000,-5.406000],[-60.804005,-9.218000,2.480000],[-61.014004,-9.514001,1.144000],[-60.786003,-9.432000,1.132000],[-60.578003,-9.140000,2.458000],[-61.120003,-9.290001,2.502000],[-61.330002,-9.588000,1.154000],[-61.752003,-9.650001,1.164000],[-61.542004,-9.352000,2.520000],[-60.594002,-8.724000,3.744000],[-60.910004,-8.792001,3.776000],[-61.332005,-8.850000,3.802000],[-61.122002,-8.152000,4.976000],[-60.702003,-8.096001,4.942000],[-60.386002,-8.036000,4.902000],[-60.368004,-8.650001,3.712000],[-60.158005,-7.966001,4.860000],[-64.403999,-6.240000,-7.394001],[-65.102005,-6.254000,-7.410000],[-65.312004,-5.044000,-8.122001],[-64.612000,-5.032000,-8.104000],[-66.042000,-5.048000,-8.128000],[-65.832001,-6.258000,-7.416000],[-64.194000,-7.314000,-6.514000],[-64.892006,-7.330000,-6.528000],[-65.622002,-7.336000,-6.534000],[-65.412003,-8.246000,-5.494000],[-64.682007,-8.240001,-5.490000],[-63.984001,-8.222000,-5.478000],[-63.766003,-6.218000,-7.368001],[-63.556004,-7.288001,-6.492000],[-63.346004,-8.192000,-5.460000],[-63.976002,-5.014000,-8.078000],[-68.102005,-0.970000,-9.108001],[-67.402000,-0.972000,-9.126000],[-67.192001,-2.368000,-8.992001],[-67.894005,-2.362000,-8.972000],[-67.684006,-3.730000,-8.634001],[-66.982002,-3.736000,-8.654000],[-68.312004,0.418000,-9.026000],[-67.612000,0.418000,-9.046000],[-67.822006,1.766000,-8.740001],[-68.522003,1.762000,-8.722000],[-68.742004,-0.966000,-9.076000],[-68.952003,0.416000,-8.996000],[-69.162003,1.756000,-8.692000],[-69.712006,1.748000,-8.648001],[-69.502007,0.414000,-8.952001],[-69.290001,-0.958000,-9.030001],[-68.532005,-2.354000,-8.942000],[-69.082001,-2.342000,-8.898001],[-68.872002,-3.696000,-8.562000],[-68.324005,-3.716000,-8.604000],[-56.084003,7.044000,-2.792000],[-56.294003,7.376000,-1.524000],[-56.260002,7.318000,-1.514000],[-56.052002,6.988000,-2.772000],[-56.024002,6.940001,-2.754000],[-56.232002,7.268000,-1.506000],[-56.442001,7.384000,-0.228000],[-56.470001,7.434000,-0.228000],[-56.504002,7.494000,-0.228000],[-56.140003,7.104001,-2.814000],[-56.350002,7.440001,-1.536000],[-56.558002,7.558001,-0.228000],[-55.876003,6.516000,-4.004000],[-55.930004,6.572001,-4.038000],[-55.842003,6.464000,-3.974000],[-55.816002,6.420000,-3.948000],[-58.290001,4.106000,6.810000],[-58.064003,4.072000,6.750000],[-57.854004,5.088000,5.850000],[-58.080002,5.132000,5.902000],[-57.702003,5.044000,5.796000],[-57.910004,4.036000,6.688000],[-58.498001,2.964000,7.542000],[-58.274002,2.940000,7.478000],[-58.120003,2.914000,7.410000],[-58.330002,1.696000,7.932000],[-58.482002,1.710000,8.004001],[-58.708004,1.724000,8.074000],[-58.604004,4.136000,6.864000],[-58.814003,2.984000,7.602000],[-59.022003,1.736000,8.138000],[-58.394001,5.168000,5.948000],[-56.920002,7.044000,2.336000],[-56.978004,7.104001,2.358000],[-57.186001,6.572001,3.580000],[-57.130001,6.516000,3.548000],[-57.340004,5.814000,4.676000],[-57.396004,5.864000,4.718000],[-56.712002,7.376000,1.068000],[-56.768002,7.440001,1.078000],[-56.888004,6.988000,2.316000],[-56.678001,7.318000,1.058000],[-56.652004,7.268000,1.048000],[-56.860004,6.940001,2.298000],[-57.096004,6.464000,3.516000],[-57.070004,6.420000,3.492000],[-57.278004,5.730000,4.602000],[-57.306004,5.768000,4.636000],[-59.128002,-0.946000,8.450001],[-58.918003,0.412000,8.372001],[-59.234001,0.414000,8.438001],[-59.444004,-0.952000,8.518001],[-58.900002,-0.936000,8.378000],[-58.692001,0.408000,8.300000],[-58.538002,0.406000,8.224000],[-58.748001,-0.926000,8.302000],[-59.338001,-2.308000,8.318001],[-59.112003,-2.286000,8.246000],[-58.958004,-2.266000,8.172000],[-59.168003,-3.578000,7.846000],[-59.322002,-3.610000,7.920001],[-59.546001,-3.642000,7.988000],[-59.652004,-2.326000,8.384001],[-59.862003,-3.672000,8.052000],[-61.884003,-6.240000,6.938000],[-61.674004,-5.032000,7.648000],[-62.374004,-5.044000,7.664001],[-62.584003,-6.254000,6.952000],[-61.248001,-6.218000,6.912000],[-61.038002,-5.014000,7.620000],[-60.494003,-4.988000,7.580000],[-60.704002,-6.184000,6.876000],[-62.096004,-7.314000,6.058000],[-61.458004,-7.288001,6.036000],[-60.912003,-7.250000,6.004000],[-61.668003,-8.192000,5.002000],[-62.306004,-8.222000,5.020000],[-62.794003,-7.330000,6.072001],[-63.004002,-8.240001,5.032000],[-55.104004,3.876000,-6.862000],[-54.896004,2.798000,-7.554000],[-54.940002,2.810000,-7.582000],[-55.150002,3.890000,-6.888000],[-55.052002,3.866000,-6.846000],[-54.844002,2.792000,-7.536000],[-54.788002,2.792000,-7.532001],[-54.998001,3.864000,-6.842000],[-55.314003,4.842000,-6.008000],[-55.262001,4.830000,-5.994000],[-55.206001,4.828000,-5.988000],[-55.414001,5.660000,-5.000000],[-55.470001,5.664000,-5.004000],[-55.522003,5.678000,-5.016000],[-55.360004,4.860000,-6.030000],[-55.568001,5.700000,-5.034000],[-65.584000,-9.432000,2.544000],[-65.794006,-9.734000,1.176000],[-65.094002,-9.756001,1.178000],[-64.884003,-9.454000,2.548000],[-64.153999,-9.460000,2.550000],[-64.364006,-9.764001,1.180000],[-64.574005,-9.864000,-0.228000],[-65.304001,-9.858001,-0.228000],[-66.004005,-9.836000,-0.228000],[-66.226006,-9.398001,2.534000],[-66.436005,-9.700001,1.170000],[-66.644005,-9.800000,-0.228000],[-67.194000,-9.752001,-0.228000],[-66.984001,-9.650001,1.164000],[-66.774002,-9.352000,2.520000],[-65.374001,-8.928000,3.836000],[-66.016006,-8.896001,3.822000],[-66.564003,-8.850000,3.802000],[-64.674004,-8.948000,3.846000],[-63.944004,-8.954000,3.848000],[-66.686005,-6.096000,6.776000],[-66.896004,-7.148000,5.918000],[-66.574005,-7.204000,5.964000],[-66.364006,-6.144000,6.830000],[-66.784004,-8.096001,4.942000],[-67.106003,-8.036000,4.902000],[-66.920006,-6.046000,6.718000],[-67.130005,-7.086000,5.864000],[-67.340004,-7.966001,4.860000],[-67.502007,-7.894001,4.814000],[-67.292000,-7.022000,5.812000],[-67.084000,-5.990000,6.656000],[-66.476006,-4.916000,7.470000],[-66.712006,-4.876000,7.406000],[-66.874001,-4.832000,7.338000],[-66.153999,-4.956000,7.530000],[-51.814003,4.198000,6.972000],[-51.604004,5.246000,6.042000],[-52.302002,5.256000,6.056000],[-52.510002,4.206000,6.986001],[-52.092003,6.166000,4.978000],[-51.394001,6.152000,4.968000],[-51.178001,4.182000,6.946000],[-50.968002,5.228000,6.020000],[-50.758003,6.132000,4.948000],[-50.216003,6.102000,4.922000],[-50.426003,5.202000,5.990000],[-50.636002,4.162000,6.910000],[-52.024002,3.028000,7.722001],[-51.388004,3.018000,7.694000],[-50.846001,3.004000,7.654000],[-52.720001,3.036000,7.738000],[-50.744003,-0.946000,8.450001],[-50.534004,0.412000,8.372001],[-50.846001,0.414000,8.438001],[-51.056004,-0.952000,8.518001],[-50.638004,1.736000,8.138000],[-50.326004,1.724000,8.074000],[-50.522003,-0.936000,8.378000],[-50.312004,0.408000,8.300000],[-50.102001,1.710000,8.004001],[-49.954002,1.696000,7.932000],[-50.162003,0.406000,8.224000],[-50.372002,-0.926000,8.302000],[-50.952003,-2.308000,8.318001],[-50.732002,-2.286000,8.246000],[-50.582001,-2.266000,8.172000],[-51.266003,-2.326000,8.384001],[-51.900002,-8.898001,2.388000],[-51.954002,-8.976001,2.410000],[-52.162003,-9.264001,1.108000],[-52.108002,-9.184000,1.096000],[-51.690002,-8.422000,3.608000],[-51.744003,-8.496000,3.642000],[-51.536003,-7.824000,4.770000],[-51.482002,-7.754000,4.726000],[-51.868004,-8.826000,2.366000],[-51.658001,-8.354000,3.578000],[-51.450001,-7.694000,4.686000],[-51.424004,-7.640000,4.652000],[-51.634003,-8.296000,3.552000],[-51.842003,-8.764001,2.348000],[-52.078003,-9.110001,1.086000],[-52.052002,-9.046000,1.078000],[-53.432003,-5.740000,-6.832000],[-53.224003,-6.730000,-6.020000],[-53.268002,-6.758000,-6.042000],[-53.478001,-5.764000,-6.856000],[-53.060001,-7.598001,-5.084000],[-53.014004,-7.568000,-5.066000],[-53.380001,-5.726000,-6.816000],[-53.172001,-6.716001,-6.008000],[-52.964001,-7.550000,-5.054000],[-52.908001,-7.544000,-5.050000],[-53.116001,-6.710001,-6.002000],[-53.326004,-5.724000,-6.810000],[-53.642002,-4.628000,-7.486001],[-53.590004,-4.618000,-7.468000],[-53.534004,-4.614000,-7.464000],[-53.686001,-4.648000,-7.514000],[-56.626003,4.106000,6.810000],[-56.836002,2.964000,7.542000],[-56.510002,2.984000,7.602000],[-56.300003,4.136000,6.864000],[-56.866001,4.072000,6.750000],[-57.074001,2.940000,7.478000],[-57.240002,2.914000,7.410000],[-57.032001,4.036000,6.688000],[-56.416004,5.132000,5.902000],[-56.656002,5.088000,5.850000],[-56.822002,5.044000,5.796000],[-56.612003,5.914001,4.762000],[-56.446003,5.968000,4.808000],[-56.208004,6.016000,4.850000],[-56.090004,5.168000,5.948000],[-55.880001,6.062000,4.890000],[-53.834003,7.456000,2.488000],[-54.044003,6.896000,3.772000],[-53.342003,6.912000,3.780000],[-53.132004,7.472000,2.494000],[-52.400002,7.476000,2.496000],[-52.610001,6.916000,3.784000],[-54.476002,7.430000,2.478000],[-54.686001,6.872000,3.758000],[-55.238003,6.838000,3.736000],[-55.028004,7.394001,2.464000],[-53.624004,7.808001,1.144000],[-54.266003,7.780000,1.140000],[-54.818001,7.742001,1.132000],[-54.610004,7.866000,-0.228000],[-54.056004,7.906000,-0.228000],[-53.414001,7.932000,-0.228000],[-52.922001,7.824000,1.148000],[-52.712002,7.950000,-0.228000],[-51.980003,7.956000,-0.228000],[-52.190002,7.830000,1.148000],[-59.432003,-5.884000,6.536000],[-59.640003,-6.898000,5.706000],[-59.606003,-6.842000,5.658000],[-59.398003,-5.836000,6.482000],[-59.368004,-5.794000,6.436000],[-59.578003,-6.794000,5.618000],[-59.490002,-5.936000,6.594000],[-59.698002,-6.960001,5.758000],[-59.796001,-7.022000,5.812000],[-59.586002,-5.990000,6.656000],[-59.224003,-4.744000,7.206000],[-59.280003,-4.788000,7.270000],[-59.376003,-4.832000,7.338000],[-59.070004,-3.546000,7.776000],[-59.012001,-3.514000,7.706000],[-59.188004,-4.706000,7.148000],[-58.978004,-3.486000,7.644001],[-58.952003,-3.460000,7.590000],[-59.160004,-4.672000,7.096000],[-59.284004,-5.740000,6.374000],[-59.232002,-5.726000,6.358000],[-59.022003,-4.618000,7.012001],[-59.074001,-4.628000,7.030000],[-58.866001,-3.428000,7.518000],[-58.814003,-3.420000,7.498000],[-59.494003,-6.730000,5.564000],[-59.440002,-6.716001,5.550000],[-59.332005,-5.764000,6.400000],[-59.540005,-6.758000,5.586000],[-59.122002,-4.648000,7.056000],[-58.912003,-3.442000,7.546000],[-58.230003,-0.884000,7.952000],[-58.284004,-0.882000,7.934000],[-58.494003,-2.162000,7.810000],[-58.438004,-2.170000,7.828001],[-58.550003,-2.162000,7.802001],[-58.342003,-0.880000,7.926001],[-58.020004,0.394000,7.878000],[-58.076004,0.392000,7.860001],[-58.132004,0.392000,7.854001],[-57.922001,1.628000,7.572001],[-57.866001,1.628000,7.578001],[-57.810001,1.632000,7.596000],[-58.178001,-0.888000,7.984000],[-57.968002,0.394000,7.910000],[-57.758003,1.638000,7.626000],[-58.386002,-2.178000,7.860001],[-66.808006,-0.884000,7.952000],[-66.598000,0.394000,7.878000],[-66.646004,0.394000,7.910000],[-66.856003,-0.888000,7.984000],[-66.896004,-0.894000,8.028001],[-66.686005,0.396000,7.954000],[-66.754005,-0.882000,7.934000],[-66.546005,0.392000,7.860001],[-67.016006,-2.170000,7.828001],[-66.964005,-2.162000,7.810000],[-67.172005,-3.420000,7.498000],[-67.226006,-3.428000,7.518000],[-67.064003,-2.178000,7.860001],[-67.274002,-3.442000,7.546000],[-67.314003,-3.460000,7.590000],[-67.104004,-2.190000,7.904000],[-67.254005,-5.884000,6.536000],[-67.188004,-5.936000,6.594000],[-66.978004,-4.788000,7.270000],[-67.046005,-4.744000,7.206000],[-67.464005,-6.898000,5.706000],[-67.398003,-6.960001,5.758000],[-67.608002,-7.824000,4.770000],[-67.674004,-7.754000,4.726000],[-67.296005,-5.836000,6.482000],[-67.506004,-6.842000,5.658000],[-67.714005,-7.694000,4.686000],[-67.748001,-7.640000,4.652000],[-67.540001,-6.794000,5.618000],[-67.330002,-5.794000,6.436000],[-67.086006,-4.706000,7.148000],[-67.122002,-4.672000,7.096000],[-66.672005,4.106000,6.810000],[-66.444000,4.072000,6.750000],[-66.234001,5.088000,5.850000],[-66.462006,5.132000,5.902000],[-66.252007,6.016000,4.850000],[-66.026001,5.968000,4.808000],[-66.882004,2.964000,7.542000],[-66.652000,2.940000,7.478000],[-66.862000,1.710000,8.004001],[-67.092003,1.724000,8.074000],[-66.992004,4.136000,6.864000],[-67.200005,2.984000,7.602000],[-67.410004,1.736000,8.138000],[-67.834000,1.748000,8.192000],[-67.625999,3.004000,7.654000],[-67.416000,4.162000,6.910000],[-66.782005,5.168000,5.948000],[-67.206001,5.202000,5.990000],[-66.996002,6.102000,4.922000],[-66.572006,6.062000,4.890000],[-65.834000,7.290000,2.426000],[-65.625999,7.634000,1.114000],[-65.942001,7.692000,1.124000],[-66.152000,7.346000,2.448000],[-66.576004,7.394001,2.464000],[-66.366005,7.742001,1.132000],[-65.606003,7.230000,2.404000],[-65.396004,7.572001,1.102000],[-66.044006,6.744000,3.682000],[-65.816002,6.688000,3.648000],[-66.362000,6.794000,3.712000],[-66.786003,6.838000,3.736000],[-66.920006,7.456000,-2.944000],[-66.710007,6.896000,-4.228000],[-67.410004,6.912000,-4.238000],[-67.620003,7.472000,-2.950000],[-68.350006,7.476000,-2.952000],[-68.142006,6.916000,-4.240000],[-66.284004,7.430000,-2.936000],[-66.072006,6.872000,-4.214000],[-67.130005,7.808001,-1.600000],[-66.494003,7.780000,-1.598000],[-66.704002,7.906000,-0.228000],[-67.342003,7.932000,-0.228000],[-67.830002,7.824000,-1.604000],[-68.040001,7.950000,-0.228000],[-68.770004,7.956000,-0.228000],[-68.560005,7.830000,-1.606000],[-68.942001,4.198000,-7.428000],[-69.152000,5.246000,-6.500000],[-68.452003,5.256000,-6.514000],[-68.242004,4.206000,-7.444000],[-68.660004,6.166000,-5.436000],[-69.362000,6.152000,-5.424000],[-69.582001,4.184000,-7.402000],[-69.792000,5.228000,-6.478000],[-70.002007,6.132000,-5.406000],[-70.550003,6.102000,-5.378000],[-70.340004,5.202000,-6.446000],[-70.130005,4.162000,-7.366000],[-68.732002,3.028000,-8.178000],[-69.372002,3.018000,-8.150001],[-69.920006,3.004000,-8.112000],[-68.032005,3.036000,-8.196000],[-63.564003,-9.432000,-3.000000],[-63.354004,-9.734000,-1.632000],[-64.052002,-9.756001,-1.634000],[-64.262001,-9.454000,-3.006000],[-64.992004,-9.460000,-3.008000],[-64.782005,-9.764001,-1.636000],[-63.842003,-9.858001,-0.228000],[-63.144005,-9.836000,-0.228000],[-62.926003,-9.398001,-2.990000],[-62.716003,-9.700001,-1.628000],[-62.506004,-9.800000,-0.228000],[-63.774002,-8.928000,-4.292000],[-63.136002,-8.896001,-4.280000],[-64.472000,-8.948000,-4.302000],[-65.202003,-8.954000,-4.306000],[-67.264000,-6.240000,-7.394001],[-67.474007,-5.032000,-8.104000],[-66.772003,-5.044000,-8.122001],[-66.562004,-6.254000,-7.410000],[-67.904007,-6.218000,-7.368001],[-68.114006,-5.014000,-8.078000],[-68.662003,-4.988000,-8.036000],[-68.452003,-6.184000,-7.334000],[-67.052002,-7.314000,-6.514000],[-67.694000,-7.288001,-6.492000],[-68.242004,-7.250000,-6.460001],[-68.032005,-8.152000,-5.432000],[-67.484001,-8.192000,-5.460000],[-66.844002,-8.222000,-5.478000],[-66.352005,-7.330000,-6.528000],[-66.144005,-8.240001,-5.490000],[-70.040001,-0.946000,-8.908000],[-70.250000,0.412000,-8.830001],[-69.928001,0.414000,-8.894000],[-69.718002,-0.952000,-8.974000],[-70.138000,1.736000,-8.594001],[-70.460007,1.724000,-8.530001],[-70.274002,-0.936000,-8.834001],[-70.482002,0.408000,-8.756001],[-70.692001,1.710000,-8.460000],[-70.852005,1.696000,-8.388000],[-70.644005,0.406000,-8.680000],[-70.434006,-0.926000,-8.758000],[-69.830002,-2.308000,-8.776000],[-70.064003,-2.286000,-8.704000],[-70.224007,-2.266000,-8.630000],[-70.014000,-3.578000,-8.304001],[-69.854004,-3.610000,-8.376000],[-69.620003,-3.642000,-8.446000],[-69.508003,-2.326000,-8.840000],[-69.300003,-3.672000,-8.508000],[-55.940002,6.878000,-2.730000],[-55.986004,6.904000,-2.740000],[-56.194004,7.230000,-1.498000],[-56.150002,7.202000,-1.494000],[-56.358002,7.318000,-0.228000],[-56.404003,7.346000,-0.228000],[-55.732002,6.362000,-3.914000],[-55.778004,6.386000,-3.928000],[-55.888004,6.862000,-2.726000],[-55.680004,6.348001,-3.906000],[-55.624004,6.344000,-3.902000],[-55.832005,6.858000,-2.722000],[-56.098003,7.186000,-1.490000],[-56.042004,7.180000,-1.490000],[-56.252003,7.294000,-0.228000],[-56.306004,7.300000,-0.228000],[-57.758003,3.968000,6.568000],[-57.548004,4.958000,5.692000],[-57.606003,5.000000,5.744000],[-57.816002,4.002000,6.626000],[-57.724003,3.938000,6.514000],[-57.514004,4.920000,5.644000],[-57.486004,4.886000,5.604000],[-57.698002,3.910000,6.466000],[-57.968002,2.866000,7.276000],[-57.934002,2.842000,7.216001],[-57.906002,2.824000,7.166000],[-58.114002,1.646000,7.670001],[-58.142002,1.656000,7.724000],[-58.176003,1.670000,7.788001],[-58.024002,2.890000,7.342000],[-58.232002,1.682000,7.858000],[-59.966003,-6.096000,6.776000],[-60.280003,-6.144000,6.830000],[-60.492004,-7.204000,5.964000],[-60.176003,-7.148000,5.918000],[-59.756004,-4.916000,7.470000],[-60.072002,-4.956000,7.530000],[-59.740002,-6.046000,6.718000],[-59.530003,-4.876000,7.406000],[-59.948002,-7.086000,5.864000],[-62.724003,-9.432000,2.544000],[-63.424004,-9.454000,2.548000],[-63.634003,-9.756001,1.178000],[-62.934002,-9.734000,1.176000],[-62.514004,-8.928000,3.836000],[-63.214005,-8.948000,3.846000],[-62.088001,-9.398001,2.534000],[-61.878002,-8.896001,3.822000],[-62.296001,-9.700001,1.170000],[-66.424004,-9.432000,-3.000000],[-65.724007,-9.454000,-3.006000],[-65.514000,-9.756001,-1.634000],[-66.214005,-9.734000,-1.632000],[-66.634003,-8.928000,-4.292000],[-65.934006,-8.948000,-4.302000],[-67.064003,-9.398001,-2.990000],[-67.274002,-8.896001,-4.280000],[-67.822006,-8.850000,-4.260000],[-67.614006,-9.352000,-2.976000],[-66.854004,-9.700001,-1.628000],[-67.404007,-9.650001,-1.620000],[-67.524002,-9.218000,2.480000],[-67.202003,-9.290001,2.502000],[-66.992004,-8.792001,3.776000],[-67.316002,-8.724000,3.744000],[-67.734001,-9.514001,1.144000],[-67.412003,-9.588000,1.154000],[-67.622002,-9.688001,-0.228000],[-67.944000,-9.612000,-0.228000],[-67.758003,-9.140000,2.458000],[-67.968002,-9.432000,1.132000],[-68.178001,-9.532001,-0.228000],[-68.340004,-9.446000,-0.228000],[-68.130005,-9.348001,1.120000],[-67.920006,-9.058001,2.434000],[-67.550003,-8.650001,3.712000],[-67.710007,-8.574000,3.676000],[-50.974003,7.456000,2.488000],[-51.672001,7.472000,2.494000],[-51.882004,6.912000,3.780000],[-51.184002,6.896000,3.772000],[-50.764004,7.808001,1.144000],[-51.462002,7.824000,1.148000],[-51.250004,7.950000,-0.228000],[-50.554001,7.932000,-0.228000],[-50.338001,7.430000,2.478000],[-50.128002,7.780000,1.140000],[-49.918003,7.906000,-0.228000],[-49.378002,7.866000,-0.228000],[-49.586002,7.742001,1.132000],[-49.796001,7.394001,2.464000],[-50.548004,6.872000,3.758000],[-50.006001,6.838000,3.736000],[-49.904003,4.106000,6.810000],[-50.216003,4.136000,6.864000],[-50.426003,2.984000,7.602000],[-50.114002,2.964000,7.542000],[-49.696003,5.132000,5.902000],[-50.008003,5.168000,5.948000],[-49.798004,6.062000,4.890000],[-49.486004,6.016000,4.850000],[-49.684002,4.072000,6.750000],[-49.474003,5.088000,5.850000],[-49.264004,5.968000,4.808000],[-49.116001,5.914001,4.762000],[-49.324001,5.044000,5.796000],[-49.534004,4.036000,6.688000],[-49.894001,2.940000,7.478000],[-49.744003,2.914000,7.410000],[-51.062004,-5.884000,6.536000],[-50.854004,-4.744000,7.206000],[-50.908001,-4.788000,7.270000],[-51.116001,-5.936000,6.594000],[-50.698002,-3.546000,7.776000],[-50.644001,-3.514000,7.706000],[-51.030003,-5.836000,6.482000],[-50.822002,-4.706000,7.148000],[-50.614002,-3.486000,7.644001],[-50.588001,-3.460000,7.590000],[-50.796001,-4.672000,7.096000],[-51.006001,-5.794000,6.436000],[-51.272003,-6.898000,5.706000],[-51.240002,-6.842000,5.658000],[-51.216003,-6.794000,5.618000],[-51.326004,-6.960001,5.758000],[-52.598003,-8.684000,-2.782000],[-52.642002,-8.718000,-2.792000],[-52.852001,-8.250000,-3.988000],[-52.806004,-8.218000,-3.974000],[-52.388004,-8.962001,-1.522000],[-52.434002,-8.996000,-1.526000],[-52.224003,-9.090000,-0.228000],[-52.178001,-9.054001,-0.228000],[-52.546001,-8.664001,-2.776000],[-52.336002,-8.942000,-1.520000],[-52.128002,-9.032001,-0.228000],[-52.072002,-9.026000,-0.228000],[-52.282001,-8.934000,-1.518000],[-52.490002,-8.656000,-2.774000],[-52.754002,-8.198000,-3.964000],[-52.698002,-8.192000,-3.962000],[-55.788002,7.290000,2.426000],[-55.460003,7.346000,2.448000],[-55.252003,7.692000,1.124000],[-55.578003,7.634000,1.114000],[-55.368004,7.756001,-0.228000],[-55.042004,7.816000,-0.228000],[-55.998001,6.744000,3.682000],[-55.670002,6.794000,3.712000],[-56.028004,7.230000,2.404000],[-56.236004,6.688000,3.648000],[-56.404003,6.630000,3.614000],[-56.194004,7.166000,2.380000],[-55.818001,7.572001,1.102000],[-55.984001,7.506001,1.090000],[-55.774002,7.624001,-0.228000],[-55.608002,7.692000,-0.228000],[-52.994003,7.456000,-2.944000],[-52.292004,7.472000,-2.950000],[-52.082001,6.912000,-4.238000],[-52.784004,6.896000,-4.228000],[-52.574001,6.152000,-5.424000],[-51.872002,6.166000,-5.436000],[-51.142002,6.170000,-5.440000],[-51.352001,6.916000,-4.240000],[-51.562004,7.476000,-2.952000],[-53.204002,7.808001,-1.600000],[-52.502003,7.824000,-1.604000],[-51.772003,7.830000,-1.606000],[-53.638004,7.430000,-2.936000],[-53.848003,7.780000,-1.598000],[-54.400002,7.742001,-1.590000],[-54.190002,7.394001,-2.922000],[-53.428001,6.872000,-4.214000],[-53.980003,6.838000,-4.194000],[-53.770004,6.102000,-5.378000],[-53.218002,6.132000,-5.406000],[-54.048004,-0.884000,-8.410001],[-53.840004,-2.170000,-8.284000],[-53.896004,-2.162000,-8.266001],[-54.106003,-0.882000,-8.390000],[-53.686001,-3.420000,-7.956000],[-53.632004,-3.428000,-7.974000],[-53.998001,-0.888000,-8.440001],[-53.788002,-2.178000,-8.316000],[-53.578003,-3.442000,-8.004001],[-53.532001,-3.460000,-8.046000],[-53.740002,-2.190000,-8.360001],[-53.950001,-0.894000,-8.484000],[-54.258003,0.394000,-8.334001],[-54.206001,0.394000,-8.366000],[-54.158001,0.396000,-8.410001],[-54.368004,1.646000,-8.126000],[-54.414001,1.638000,-8.084001],[-54.468002,1.632000,-8.054001],[-54.314003,0.392000,-8.316000],[-54.524002,1.628000,-8.036000],[-58.448002,-0.884000,7.952000],[-58.656002,-2.170000,7.828001],[-58.606003,-2.162000,7.810000],[-58.396004,-0.882000,7.934000],[-58.494003,-0.888000,7.984000],[-58.704002,-2.178000,7.860001],[-58.742004,-2.190000,7.904000],[-58.532001,-0.894000,8.028001],[-58.240002,0.394000,7.878000],[-58.286003,0.394000,7.910000],[-58.324001,0.396000,7.954000],[-58.076004,1.638000,7.626000],[-58.030003,1.632000,7.596000],[-58.188004,0.392000,7.860001],[-57.978004,1.628000,7.578001],[-57.212002,3.968000,6.568000],[-57.256004,3.938000,6.514000],[-57.466003,2.842000,7.216001],[-57.420002,2.866000,7.276000],[-57.504002,2.824000,7.166000],[-57.294003,3.910000,6.466000],[-57.002003,4.958000,5.692000],[-57.048004,4.920000,5.644000],[-57.086002,4.886000,5.604000],[-56.876003,5.730000,4.602000],[-56.840004,5.768000,4.636000],[-56.792004,5.814000,4.676000],[-57.140003,4.002000,6.626000],[-56.932003,5.000000,5.744000],[-56.724003,5.864000,4.718000],[-57.352001,2.890000,7.342000],[-66.964005,-0.908000,8.152000],[-66.928001,-0.900000,8.086000],[-66.718002,0.398000,8.010000],[-66.754005,0.400000,8.078000],[-67.174004,-2.224000,8.026000],[-67.136002,-2.206000,7.958000],[-67.344002,-3.486000,7.644001],[-67.382004,-3.514000,7.706000],[-67.024002,-0.918000,8.226001],[-67.234001,-2.244000,8.098001],[-67.442001,-3.546000,7.776000],[-67.544006,-3.578000,7.846000],[-67.334000,-2.266000,8.172000],[-67.124001,-0.926000,8.302000],[-66.816002,0.402000,8.148001],[-66.916000,0.406000,8.224000],[-67.424004,-5.740000,6.374000],[-67.216003,-4.628000,7.030000],[-67.270004,-4.618000,7.012001],[-67.478004,-5.726000,6.358000],[-67.534004,-5.724000,6.354000],[-67.326004,-4.614000,7.006001],[-67.374001,-5.764000,6.400000],[-67.164001,-4.648000,7.056000],[-67.632004,-6.730000,5.564000],[-67.582001,-6.758000,5.586000],[-67.792000,-7.598001,4.626000],[-67.842003,-7.568000,4.608000],[-67.686005,-6.716001,5.550000],[-67.896004,-7.550000,4.596000],[-67.952003,-7.544000,4.592000],[-67.744003,-6.710001,5.546000],[-67.760002,7.456000,2.488000],[-68.460007,7.472000,2.494000],[-68.670006,6.912000,3.780000],[-67.970001,6.896000,3.772000],[-68.180000,6.152000,4.968000],[-68.880005,6.166000,4.978000],[-69.610001,6.170000,4.982000],[-69.400002,6.916000,3.784000],[-69.190002,7.476000,2.496000],[-67.552002,7.808001,1.144000],[-68.250000,7.824000,1.148000],[-68.980003,7.830000,1.148000],[-67.122002,7.430000,2.478000],[-66.912003,7.780000,1.140000],[-67.332001,6.872000,3.758000],[-67.542000,6.132000,4.948000],[-69.782005,7.456000,-2.944000],[-69.080002,7.472000,-2.950000],[-68.870003,6.912000,-4.238000],[-69.572006,6.896000,-4.228000],[-69.992004,7.808001,-1.600000],[-69.290001,7.824000,-1.604000],[-69.502007,7.950000,-0.228000],[-70.200005,7.932000,-0.228000],[-70.420006,7.430000,-2.936000],[-70.630005,7.780000,-1.598000],[-70.840004,7.906000,-0.228000],[-71.390007,7.866000,-0.228000],[-71.180000,7.742001,-1.590000],[-70.970001,7.394001,-2.922000],[-70.210007,6.872000,-4.214000],[-70.760002,6.838000,-4.194000],[-70.878006,4.106000,-7.266000],[-70.558006,4.136000,-7.322001],[-70.348000,2.984000,-8.060000],[-70.670006,2.964000,-8.000000],[-71.088005,5.132000,-6.358000],[-70.766006,5.168000,-6.406000],[-70.976006,6.062000,-5.346000],[-71.298004,6.016000,-5.306000],[-71.112007,4.072000,-7.208000],[-71.322006,5.088000,-6.308000],[-71.530006,5.968000,-5.264000],[-71.690002,5.914001,-5.220000],[-71.482002,5.044000,-6.254000],[-71.272003,4.036000,-7.144001],[-70.902000,2.940000,-7.934000],[-71.062004,2.914000,-7.866000],[-69.202003,-6.096000,-7.232000],[-68.880005,-6.144000,-7.288001],[-68.670006,-7.204000,-6.420000],[-68.992004,-7.148000,-6.374000],[-68.782005,-8.036000,-5.360000],[-68.460007,-8.096001,-5.398000],[-69.412003,-4.916000,-7.928000],[-69.090004,-4.956000,-7.986001],[-69.436005,-6.046000,-7.174000],[-69.644005,-4.876000,-7.864000],[-69.806000,-4.832000,-7.796000],[-69.596001,-5.990000,-7.114000],[-69.226006,-7.086000,-6.322001],[-69.386002,-7.022000,-6.268000],[-69.178001,-7.894001,-5.272000],[-69.016006,-7.966001,-5.316000],[-56.776001,6.878000,2.274000],[-56.568001,7.202000,1.036000],[-56.614002,7.230000,1.042000],[-56.822002,6.904000,2.284000],[-56.724003,6.862000,2.268000],[-56.516003,7.186000,1.034000],[-56.460003,7.180000,1.032000],[-56.670002,6.858000,2.266000],[-56.984001,6.362000,3.458000],[-56.934002,6.348001,3.448000],[-56.878002,6.344000,3.446000],[-57.086002,5.660000,4.544000],[-57.142002,5.664000,4.548000],[-57.194004,5.678000,4.558000],[-57.032001,6.386000,3.472000],[-57.240002,5.700000,4.578000],[-58.596004,-0.908000,8.152000],[-58.652004,-0.918000,8.226001],[-58.860004,-2.244000,8.098001],[-58.804005,-2.224000,8.026000],[-58.386002,0.400000,8.078000],[-58.444004,0.402000,8.148001],[-58.562004,-0.900000,8.086000],[-58.352001,0.398000,8.010000],[-58.770004,-2.206000,7.958000],[-54.886002,3.876000,-6.862000],[-54.940002,3.866000,-6.846000],[-55.150002,4.830000,-5.994000],[-55.094002,4.842000,-6.008000],[-55.304001,5.678000,-5.016000],[-55.358002,5.664000,-5.004000],[-54.676003,2.798000,-7.554000],[-54.732002,2.792000,-7.536000],[-54.832001,3.890000,-6.888000],[-54.624004,2.810000,-7.582000],[-54.578003,2.824000,-7.622000],[-54.786003,3.910000,-6.924000],[-55.042004,4.860000,-6.030000],[-54.994003,4.886000,-6.060000],[-55.204002,5.730000,-5.060000],[-55.250004,5.700000,-5.034000],[-68.364006,-9.218000,-2.936000],[-68.572006,-8.724000,-4.202000],[-68.250000,-8.792001,-4.232000],[-68.042000,-9.290001,-2.958000],[-68.598000,-9.140000,-2.914000],[-68.806000,-8.650001,-4.168000],[-68.968002,-8.574000,-4.134000],[-68.758003,-9.058001,-2.890000],[-68.154007,-9.514001,-1.600000],[-68.388000,-9.432000,-1.590000],[-68.548004,-9.348001,-1.576000],[-67.832001,-9.588000,-1.610000],[-50.134003,7.456000,-2.944000],[-49.924004,6.896000,-4.228000],[-50.622002,6.912000,-4.238000],[-50.832001,7.472000,-2.950000],[-50.412003,6.166000,-5.436000],[-49.714001,6.152000,-5.424000],[-49.500004,7.430000,-2.936000],[-49.290001,6.872000,-4.214000],[-49.080002,6.132000,-5.406000],[-48.538002,6.102000,-5.378000],[-48.748001,6.838000,-4.194000],[-48.958004,7.394001,-2.922000],[-50.344002,7.808001,-1.600000],[-49.710003,7.780000,-1.598000],[-49.168003,7.742001,-1.590000],[-51.042004,7.824000,-1.604000],[-49.068001,7.290000,2.426000],[-48.856003,7.634000,1.114000],[-49.168003,7.692000,1.124000],[-49.380001,7.346000,2.448000],[-48.958004,7.816000,-0.228000],[-48.648003,7.756001,-0.228000],[-48.846001,7.230000,2.404000],[-48.636002,7.572001,1.102000],[-48.426003,7.692000,-0.228000],[-48.278004,7.624001,-0.228000],[-48.488003,7.506001,1.090000],[-48.698002,7.166000,2.380000],[-49.278004,6.744000,3.682000],[-49.054001,6.688000,3.648000],[-48.906002,6.630000,3.614000],[-49.588001,6.794000,3.712000],[-50.226002,-0.908000,8.152000],[-50.280003,-0.918000,8.226001],[-50.488003,-2.244000,8.098001],[-50.434002,-2.224000,8.026000],[-50.016003,0.400000,8.078000],[-50.070004,0.402000,8.148001],[-49.860001,1.682000,7.858000],[-49.806004,1.670000,7.788001],[-50.194004,-0.900000,8.086000],[-49.986004,0.398000,8.010000],[-49.776001,1.656000,7.724000],[-49.752003,1.646000,7.670001],[-49.960003,0.396000,7.954000],[-50.170002,-0.894000,8.028001],[-50.404003,-2.206000,7.958000],[-50.380001,-2.190000,7.904000],[-51.760002,-8.684000,2.324000],[-51.552002,-8.218000,3.516000],[-51.596001,-8.250000,3.532000],[-51.806004,-8.718000,2.334000],[-51.388004,-7.598001,4.626000],[-51.342003,-7.568000,4.608000],[-51.708004,-8.664001,2.320000],[-51.500004,-8.198000,3.508000],[-51.292004,-7.550000,4.596000],[-51.236004,-7.544000,4.592000],[-51.444004,-8.192000,3.506000],[-51.654003,-8.656000,2.316000],[-51.970001,-8.962001,1.064000],[-51.918003,-8.942000,1.062000],[-51.864002,-8.934000,1.062000],[-52.014004,-8.996000,1.070000],[-53.214001,-5.740000,-6.832000],[-53.268002,-5.726000,-6.816000],[-53.478001,-4.618000,-7.468000],[-53.422001,-4.628000,-7.486001],[-53.004002,-6.730000,-6.020000],[-53.060001,-6.716001,-6.008000],[-52.852001,-7.550000,-5.054000],[-52.796001,-7.568000,-5.066000],[-53.160004,-5.764000,-6.856000],[-52.952003,-6.758000,-6.042000],[-52.742004,-7.598001,-5.084000],[-52.696003,-7.640000,-5.110000],[-52.904003,-6.794000,-6.074000],[-53.114002,-5.794000,-6.892000],[-53.370003,-4.648000,-7.514000],[-53.322002,-4.672000,-7.554000],[-54.950001,7.290000,-2.884000],[-55.160004,7.634000,-1.570000],[-54.832001,7.692000,-1.580000],[-54.622002,7.346000,-2.904000],[-55.188004,7.230000,-2.862000],[-55.398003,7.572001,-1.560000],[-55.566002,7.506001,-1.548000],[-55.356003,7.166000,-2.838000],[-54.740002,6.744000,-4.138000],[-54.980003,6.688000,-4.106000],[-55.148003,6.630000,-4.072000],[-54.936001,5.914001,-5.220000],[-54.770004,5.968000,-5.264000],[-54.530003,6.016000,-5.306000],[-54.412003,6.794000,-4.168000],[-54.202003,6.062000,-5.346000],[-52.156002,4.198000,-7.428000],[-52.366001,5.246000,-6.500000],[-51.662003,5.256000,-6.514000],[-51.454002,4.206000,-7.444000],[-50.722004,4.210000,-7.450000],[-50.932003,5.260000,-6.518000],[-52.798004,4.184000,-7.402000],[-53.008003,5.228000,-6.478000],[-53.560001,5.202000,-6.446000],[-53.350002,4.162000,-7.366000],[-51.946003,3.028000,-8.178000],[-52.588001,3.018000,-8.150001],[-53.142002,3.004000,-8.112000],[-52.932003,1.748000,-8.648001],[-52.378002,1.756000,-8.692000],[-51.736004,1.762000,-8.722000],[-51.244003,3.036000,-8.196000],[-51.034004,1.766000,-8.740001],[-50.302002,1.768000,-8.746000],[-50.512001,3.038000,-8.202001],[-57.392002,3.876000,6.406000],[-57.602001,2.798000,7.098001],[-57.550003,2.810000,7.124001],[-57.342003,3.890000,6.432000],[-57.448002,3.866000,6.390000],[-57.656002,2.792000,7.080000],[-57.714005,2.792000,7.074000],[-57.504002,3.864000,6.386000],[-57.184002,4.842000,5.550000],[-57.240002,4.830000,5.538000],[-57.296001,4.828000,5.532000],[-57.030003,5.664000,4.548000],[-56.974003,5.678000,4.558000],[-57.132004,4.860000,5.572000],[-56.924004,5.700000,4.578000],[-67.642006,-5.740000,6.374000],[-67.590004,-5.726000,6.358000],[-67.382004,-4.618000,7.012001],[-67.434006,-4.628000,7.030000],[-67.854004,-6.730000,5.564000],[-67.798004,-6.716001,5.550000],[-68.008003,-7.550000,4.596000],[-68.062004,-7.568000,4.608000],[-67.692001,-5.764000,6.400000],[-67.900002,-6.758000,5.586000],[-68.110001,-7.598001,4.626000],[-68.150002,-7.640000,4.652000],[-67.942001,-6.794000,5.618000],[-67.732002,-5.794000,6.436000],[-67.482002,-4.648000,7.056000],[-67.524002,-4.672000,7.096000],[-68.090004,-8.898001,2.388000],[-67.882004,-8.422000,3.608000],[-67.924004,-8.354000,3.578000],[-68.132004,-8.826000,2.366000],[-68.168007,-8.764001,2.348000],[-67.958000,-8.296000,3.552000],[-68.026001,-8.976001,2.410000],[-67.816002,-8.496000,3.642000],[-68.300003,-9.184000,1.096000],[-68.236000,-9.264001,1.108000],[-68.444000,-9.360001,-0.228000],[-68.510002,-9.278001,-0.228000],[-68.342003,-9.110001,1.086000],[-68.552002,-9.204000,-0.228000],[-68.586006,-9.140000,-0.228000],[-68.375999,-9.046000,1.078000],[-67.510002,-0.946000,8.450001],[-67.300003,0.412000,8.372001],[-67.620003,0.414000,8.438001],[-67.830002,-0.952000,8.518001],[-68.254005,-0.958000,8.574000],[-68.044006,0.414000,8.494000],[-67.282005,-0.936000,8.378000],[-67.072006,0.408000,8.300000],[-67.720001,-2.308000,8.318001],[-67.490005,-2.286000,8.246000],[-67.700005,-3.610000,7.920001],[-67.930000,-3.642000,7.988000],[-68.040001,-2.326000,8.384001],[-68.250000,-3.672000,8.052000],[-68.674004,-3.696000,8.106000],[-68.464005,-2.342000,8.440001],[-68.600006,4.198000,6.972000],[-68.390007,5.246000,6.042000],[-69.090004,5.256000,6.056000],[-69.300003,4.206000,6.986001],[-70.030006,4.210000,6.992000],[-69.820000,5.260000,6.062000],[-67.962006,4.182000,6.946000],[-67.752007,5.228000,6.020000],[-68.810005,3.028000,7.722001],[-68.172005,3.018000,7.694000],[-68.382004,1.756000,8.234000],[-69.020004,1.762000,8.264000],[-69.508003,3.036000,7.738000],[-69.718002,1.766000,8.284000],[-70.450005,1.768000,8.288000],[-70.240005,3.038000,7.746000],[-70.620003,7.456000,2.488000],[-70.830002,6.896000,3.772000],[-70.130005,6.912000,3.780000],[-69.920006,7.472000,2.494000],[-70.340004,6.166000,4.978000],[-71.040001,6.152000,4.968000],[-71.260002,7.430000,2.478000],[-71.470001,6.872000,3.758000],[-71.680000,6.132000,4.948000],[-72.228004,6.102000,4.922000],[-72.018005,6.838000,3.736000],[-71.808006,7.394001,2.464000],[-70.410004,7.808001,1.144000],[-71.050003,7.780000,1.140000],[-71.598007,7.742001,1.132000],[-69.712006,7.824000,1.148000],[-71.718002,7.290000,-2.884000],[-71.926003,7.634000,-1.570000],[-71.606003,7.692000,-1.580000],[-71.396004,7.346000,-2.904000],[-71.816002,7.816000,-0.228000],[-72.136002,7.756001,-0.228000],[-71.950005,7.230000,-2.862000],[-72.160004,7.572001,-1.560000],[-72.368004,7.692000,-0.228000],[-72.528000,7.624001,-0.228000],[-72.318001,7.506001,-1.548000],[-72.108002,7.166000,-2.838000],[-71.508003,6.744000,-4.138000],[-71.740005,6.688000,-4.106000],[-71.900002,6.630000,-4.072000],[-71.186005,6.794000,-4.168000],[-70.602005,-0.908000,-8.610001],[-70.538002,-0.918000,-8.682000],[-70.328003,-2.244000,-8.554001],[-70.392006,-2.224000,-8.482000],[-70.182007,-3.514000,-8.162001],[-70.118004,-3.546000,-8.232000],[-70.810005,0.400000,-8.534000],[-70.746002,0.402000,-8.606000],[-70.956001,1.682000,-8.314000],[-71.020004,1.670000,-8.246000],[-70.642006,-0.900000,-8.542001],[-70.852005,0.398000,-8.468000],[-71.060005,1.656000,-8.182000],[-71.094002,1.646000,-8.126000],[-70.884003,0.396000,-8.410001],[-70.676003,-0.894000,-8.484000],[-70.434006,-2.206000,-8.416000],[-70.468002,-2.190000,-8.360001],[-70.258003,-3.460000,-8.046000],[-70.224007,-3.486000,-8.100000],[-55.720001,6.878000,-2.730000],[-55.512001,6.362000,-3.914000],[-55.568001,6.348001,-3.906000],[-55.776001,6.862000,-2.726000],[-55.670002,6.904000,-2.740000],[-55.460003,6.386000,-3.928000],[-55.414001,6.420000,-3.948000],[-55.622002,6.940001,-2.754000],[-55.930004,7.202000,-1.494000],[-55.878002,7.230000,-1.498000],[-55.832005,7.268000,-1.506000],[-56.040001,7.384000,-0.228000],[-56.086002,7.346000,-0.228000],[-56.140003,7.318000,-0.228000],[-55.986004,7.186000,-1.490000],[-56.194004,7.300000,-0.228000],[-57.612003,3.876000,6.406000],[-57.658001,3.890000,6.432000],[-57.866001,2.810000,7.124001],[-57.822002,2.798000,7.098001],[-57.404003,4.842000,5.550000],[-57.450005,4.860000,5.572000],[-57.560001,3.866000,6.390000],[-57.352001,4.830000,5.538000],[-57.768002,2.792000,7.080000],[-49.294003,4.198000,-7.428000],[-49.992001,4.206000,-7.444000],[-50.202003,5.256000,-6.514000],[-49.504002,5.246000,-6.500000],[-49.084003,3.028000,-8.178000],[-49.782001,3.036000,-8.196000],[-49.572002,1.766000,-8.740001],[-48.876003,1.762000,-8.722000],[-48.660004,4.184000,-7.402000],[-48.450001,3.018000,-8.150001],[-48.240002,1.756000,-8.692000],[-47.700001,1.748000,-8.648001],[-47.910004,3.004000,-8.112000],[-48.118004,4.162000,-7.366000],[-48.870003,5.228000,-6.478000],[-48.328003,5.202000,-6.446000],[-48.230003,7.290000,-2.884000],[-48.540001,7.346000,-2.904000],[-48.750004,7.692000,-1.580000],[-48.438004,7.634000,-1.570000],[-48.020000,6.744000,-4.138000],[-48.330002,6.794000,-4.168000],[-48.120003,6.062000,-5.346000],[-47.808002,6.016000,-5.306000],[-48.008003,7.230000,-2.862000],[-47.798004,6.688000,-4.106000],[-47.588001,5.968000,-5.264000],[-47.440002,5.914001,-5.220000],[-47.650002,6.630000,-4.072000],[-47.860001,7.166000,-2.838000],[-48.216003,7.572001,-1.560000],[-48.068001,7.506001,-1.548000],[-49.390003,3.968000,6.568000],[-49.178001,4.958000,5.692000],[-49.234001,5.000000,5.744000],[-49.442001,4.002000,6.626000],[-49.022003,5.864000,4.718000],[-48.970001,5.814000,4.676000],[-49.358002,3.938000,6.514000],[-49.148003,4.920000,5.644000],[-48.940002,5.768000,4.636000],[-48.914001,5.730000,4.602000],[-49.124001,4.886000,5.604000],[-49.334003,3.910000,6.466000],[-49.598003,2.866000,7.276000],[-49.568001,2.842000,7.216001],[-49.542004,2.824000,7.166000],[-49.650002,2.890000,7.342000],[-50.926003,-5.740000,6.374000],[-50.970001,-5.764000,6.400000],[-51.180004,-6.758000,5.586000],[-51.134003,-6.730000,5.564000],[-50.716003,-4.628000,7.030000],[-50.760002,-4.648000,7.056000],[-50.552002,-3.442000,7.546000],[-50.506001,-3.428000,7.518000],[-50.874001,-5.726000,6.358000],[-50.664001,-4.618000,7.012001],[-50.456001,-3.420000,7.498000],[-50.400002,-3.418000,7.492001],[-50.610001,-4.614000,7.006001],[-50.818001,-5.724000,6.354000],[-51.082001,-6.716001,5.550000],[-51.028004,-6.710001,5.546000],[-52.376003,-8.684000,-2.782000],[-52.168003,-8.962001,-1.522000],[-52.224003,-8.942000,-1.520000],[-52.434002,-8.664001,-2.776000],[-52.016003,-9.032001,-0.228000],[-51.960003,-9.054001,-0.228000],[-52.324001,-8.718000,-2.792000],[-52.116001,-8.996000,-1.526000],[-51.906002,-9.090000,-0.228000],[-51.858002,-9.140000,-0.228000],[-52.068001,-9.046000,-1.534000],[-52.278004,-8.764001,-2.806000],[-52.586002,-8.218000,-3.974000],[-52.532001,-8.250000,-3.988000],[-52.486004,-8.296000,-4.008000],[-52.642002,-8.198000,-3.964000],[-56.374004,7.044000,2.336000],[-56.584003,6.516000,3.548000],[-56.514004,6.572001,3.580000],[-56.304001,7.104001,2.358000],[-56.420002,6.988000,2.316000],[-56.630001,6.464000,3.516000],[-56.668003,6.420000,3.492000],[-56.460003,6.940001,2.298000],[-56.164001,7.376000,1.068000],[-56.212002,7.318000,1.058000],[-56.250004,7.268000,1.048000],[-56.002003,7.434000,-0.228000],[-55.956001,7.494000,-0.228000],[-56.094002,7.440001,1.078000],[-55.886002,7.558001,-0.228000],[-54.112003,4.106000,-7.266000],[-53.784004,4.136000,-7.322001],[-53.574001,2.984000,-8.060000],[-53.902004,2.964000,-8.000000],[-53.692001,1.724000,-8.530001],[-53.364002,1.736000,-8.594001],[-54.320004,5.132000,-6.358000],[-53.994003,5.168000,-6.406000],[-54.350002,4.072000,-7.208000],[-54.560001,5.088000,-6.308000],[-54.728004,5.044000,-6.254000],[-54.518002,4.036000,-7.144001],[-54.142002,2.940000,-7.934000],[-54.310001,2.914000,-7.866000],[-54.100002,1.696000,-8.388000],[-53.932003,1.710000,-8.460000],[-51.316002,-0.970000,-9.108001],[-50.614002,-0.972000,-9.126000],[-50.404003,-2.368000,-8.992001],[-51.106003,-2.362000,-8.972000],[-50.896004,-3.730000,-8.634001],[-50.194004,-3.736000,-8.654000],[-49.464001,-3.740000,-8.658000],[-49.672001,-2.370000,-8.998000],[-49.882004,-0.972000,-9.132000],[-51.526001,0.418000,-9.026000],[-50.824001,0.418000,-9.046000],[-50.092003,0.418000,-9.052000],[-51.960003,-0.966000,-9.076000],[-52.170002,0.416000,-8.996000],[-52.722004,0.414000,-8.952001],[-52.512001,-0.958000,-9.030001],[-51.750004,-2.354000,-8.942000],[-52.302002,-2.342000,-8.898001],[-52.092003,-3.696000,-8.562000],[-51.540001,-3.716000,-8.604000],[-53.864002,-0.908000,-8.610001],[-53.910004,-0.900000,-8.542001],[-54.120003,0.398000,-8.468000],[-54.072002,0.400000,-8.534000],[-54.282001,1.670000,-8.246000],[-54.330002,1.656000,-8.182000],[-53.656002,-2.224000,-8.482000],[-53.702003,-2.206000,-8.416000],[-53.492004,-3.486000,-8.100000],[-53.444004,-3.514000,-8.162001],[-53.792004,-0.918000,-8.682000],[-53.584003,-2.244000,-8.554001],[-53.374004,-3.546000,-8.232000],[-53.262001,-3.578000,-8.304001],[-53.472004,-2.266000,-8.630000],[-53.682003,-0.926000,-8.758000],[-54.002003,0.402000,-8.606000],[-53.890003,0.406000,-8.680000],[-54.212002,1.682000,-8.314000],[-67.802002,-5.884000,6.536000],[-67.592003,-4.744000,7.206000],[-67.652000,-4.788000,7.270000],[-67.862000,-5.936000,6.594000],[-67.962006,-5.990000,6.656000],[-67.754005,-4.832000,7.338000],[-67.764000,-5.836000,6.482000],[-67.554001,-4.706000,7.148000],[-68.010002,-6.898000,5.706000],[-67.972000,-6.842000,5.658000],[-68.182007,-7.694000,4.686000],[-68.220001,-7.754000,4.726000],[-68.070000,-6.960001,5.758000],[-68.280006,-7.824000,4.770000],[-68.382004,-7.894001,4.814000],[-68.172005,-7.022000,5.812000],[-68.260002,-8.684000,2.324000],[-68.210007,-8.718000,2.334000],[-68.002007,-8.250000,3.532000],[-68.050003,-8.218000,3.516000],[-68.470001,-8.962001,1.064000],[-68.420006,-8.996000,1.070000],[-68.628006,-9.090000,-0.228000],[-68.678001,-9.054001,-0.228000],[-68.314003,-8.664001,2.320000],[-68.524002,-8.942000,1.062000],[-68.732002,-9.032001,-0.228000],[-68.788002,-9.026000,-0.228000],[-68.578003,-8.934000,1.062000],[-68.370003,-8.656000,2.316000],[-68.106003,-8.198000,3.508000],[-68.162003,-8.192000,3.506000],[-69.440002,-0.970000,8.650001],[-70.138000,-0.972000,8.670000],[-70.348000,-2.368000,8.534000],[-69.648003,-2.362000,8.516001],[-69.858002,-3.730000,8.178000],[-70.558006,-3.736000,8.196000],[-71.288002,-3.740000,8.202001],[-71.078003,-2.370000,8.540000],[-70.868004,-0.972000,8.676001],[-69.230003,0.418000,8.570001],[-69.928001,0.418000,8.590000],[-70.658005,0.418000,8.596001],[-68.800003,-0.966000,8.618000],[-68.590004,0.416000,8.538000],[-69.010002,-2.354000,8.484000],[-69.220001,-3.716000,8.148001],[-71.460007,4.198000,6.972000],[-70.760002,4.206000,6.986001],[-70.550003,5.256000,6.056000],[-71.250000,5.246000,6.042000],[-71.670006,3.028000,7.722001],[-70.970001,3.036000,7.738000],[-71.180000,1.766000,8.284000],[-71.880005,1.762000,8.264000],[-72.098007,4.182000,6.946000],[-72.308006,3.018000,7.694000],[-72.520004,1.756000,8.234000],[-73.066002,1.748000,8.192000],[-72.858002,3.004000,7.654000],[-72.648003,4.162000,6.910000],[-71.890007,5.228000,6.020000],[-72.438004,5.202000,5.990000],[-72.556000,7.290000,2.426000],[-72.234001,7.346000,2.448000],[-72.024002,7.692000,1.124000],[-72.346001,7.634000,1.114000],[-72.766006,6.744000,3.682000],[-72.444000,6.794000,3.712000],[-72.654007,6.062000,4.890000],[-72.974007,6.016000,4.850000],[-72.786003,7.230000,2.404000],[-72.998001,6.688000,3.648000],[-73.206001,5.968000,4.808000],[-73.366005,5.914001,4.762000],[-73.156006,6.630000,3.614000],[-72.946007,7.166000,2.380000],[-72.578003,7.572001,1.102000],[-72.736000,7.506001,1.090000],[-71.438004,3.968000,-7.024000],[-71.648003,4.958000,-6.148000],[-71.584000,5.000000,-6.200000],[-71.376007,4.002000,-7.084000],[-71.794006,5.864000,-5.174000],[-71.858002,5.814000,-5.132000],[-71.478004,3.938000,-6.970000],[-71.688004,4.920000,-6.100000],[-71.898003,5.768000,-5.094000],[-71.930000,5.730000,-5.060000],[-71.722000,4.886000,-6.060000],[-71.512001,3.910000,-6.924000],[-71.230003,2.866000,-7.732000],[-71.270004,2.842000,-7.674000],[-71.304001,2.824000,-7.622000],[-71.166000,2.890000,-7.798000],[-69.766006,-5.884000,-6.992000],[-69.974007,-4.744000,-7.664001],[-69.910004,-4.788000,-7.728000],[-69.700005,-5.936000,-7.052001],[-69.806000,-5.836000,-6.938000],[-70.016006,-4.706000,-7.604001],[-70.048004,-4.672000,-7.554000],[-69.840004,-5.794000,-6.892000],[-69.556000,-6.898000,-6.162000],[-69.596001,-6.842000,-6.114000],[-69.630005,-6.794000,-6.074000],[-69.422005,-7.640000,-5.110000],[-69.388000,-7.694000,-5.144000],[-69.346001,-7.754000,-5.184000],[-69.490005,-6.960001,-6.214000],[-69.282005,-7.824000,-5.226000],[-56.558002,6.878000,2.274000],[-56.612003,6.862000,2.268000],[-56.822002,6.348001,3.448000],[-56.766003,6.362000,3.458000],[-56.348003,7.202000,1.036000],[-56.404003,7.186000,1.034000],[-56.504002,6.904000,2.284000],[-56.296001,7.230000,1.042000],[-56.714005,6.386000,3.472000],[-54.700001,3.968000,-7.024000],[-54.492004,2.866000,-7.732000],[-54.538002,2.842000,-7.674000],[-54.746002,3.938000,-6.970000],[-54.630001,4.002000,-7.084000],[-54.420002,2.890000,-7.798000],[-54.910004,4.958000,-6.148000],[-54.838001,5.000000,-6.200000],[-55.048004,5.864000,-5.174000],[-55.120003,5.814000,-5.132000],[-54.958004,4.920000,-6.100000],[-55.166004,5.768000,-5.094000],[-68.928001,-8.898001,-2.844000],[-68.864006,-8.976001,-2.866000],[-68.654007,-9.264001,-1.566000],[-68.718002,-9.184000,-1.554000],[-69.138000,-8.422000,-4.066000],[-69.072006,-8.496000,-4.100000],[-68.968002,-8.826000,-2.824000],[-69.178001,-8.354000,-4.036000],[-69.212006,-8.296000,-4.008000],[-69.002007,-8.764001,-2.806000],[-68.760002,-9.110001,-1.542000],[-68.794006,-9.046000,-1.534000],[-48.456001,-0.970000,-9.108001],[-48.246002,-2.362000,-8.972000],[-48.942001,-2.368000,-8.992001],[-49.152000,-0.972000,-9.126000],[-48.734001,-3.736000,-8.654000],[-48.036003,-3.730000,-8.634001],[-47.822002,-0.966000,-9.076000],[-47.612003,-2.354000,-8.942000],[-47.402000,-3.716000,-8.604000],[-46.860001,-3.696000,-8.562000],[-47.070004,-2.342000,-8.898001],[-47.280003,-0.958000,-9.030001],[-48.666004,0.418000,-9.026000],[-48.030003,0.416000,-8.996000],[-47.490002,0.414000,-8.952001],[-49.362003,0.418000,-9.046000],[-47.390003,4.106000,-7.266000],[-47.182003,2.964000,-8.000000],[-47.492001,2.984000,-8.060000],[-47.700001,4.136000,-7.322001],[-47.282001,1.736000,-8.594001],[-46.972004,1.724000,-8.530001],[-47.170002,4.072000,-7.208000],[-46.960003,2.940000,-7.934000],[-46.750004,1.710000,-8.460000],[-46.602001,1.696000,-8.388000],[-46.812004,2.914000,-7.866000],[-47.022003,4.036000,-7.144001],[-47.600002,5.132000,-6.358000],[-47.378002,5.088000,-6.308000],[-47.232002,5.044000,-6.254000],[-47.910004,5.168000,-6.406000],[-48.552002,7.044000,2.336000],[-48.606003,7.104001,2.358000],[-48.814003,6.572001,3.580000],[-48.762001,6.516000,3.548000],[-48.342003,7.376000,1.068000],[-48.396004,7.440001,1.078000],[-48.186001,7.558001,-0.228000],[-48.134003,7.494000,-0.228000],[-48.522003,6.988000,2.316000],[-48.312004,7.318000,1.058000],[-48.104004,7.434000,-0.228000],[-48.080002,7.384000,-0.228000],[-48.288002,7.268000,1.048000],[-48.498001,6.940001,2.298000],[-48.732002,6.464000,3.516000],[-48.706001,6.420000,3.492000],[-50.088001,-0.884000,7.952000],[-49.880001,0.394000,7.878000],[-49.924004,0.394000,7.910000],[-50.134003,-0.888000,7.984000],[-49.716003,1.638000,7.626000],[-49.670002,1.632000,7.596000],[-50.038002,-0.882000,7.934000],[-49.828003,0.392000,7.860001],[-49.620003,1.628000,7.578001],[-49.566002,1.628000,7.572001],[-49.774002,0.392000,7.854001],[-49.982002,-0.880000,7.926001],[-50.298004,-2.170000,7.828001],[-50.248001,-2.162000,7.810000],[-50.192001,-2.162000,7.802001],[-50.342003,-2.178000,7.860001],[-51.542004,-8.684000,2.324000],[-51.596001,-8.664001,2.320000],[-51.806004,-8.942000,1.062000],[-51.750004,-8.962001,1.064000],[-51.332001,-8.218000,3.516000],[-51.388004,-8.198000,3.508000],[-51.180004,-7.550000,4.596000],[-51.124001,-7.568000,4.608000],[-51.488003,-8.718000,2.334000],[-51.280003,-8.250000,3.532000],[-51.070004,-7.598001,4.626000],[-51.024002,-7.640000,4.652000],[-51.232002,-8.296000,3.552000],[-51.440002,-8.764001,2.348000],[-51.698002,-8.996000,1.070000],[-51.650002,-9.046000,1.078000],[-53.028004,-5.884000,-6.992000],[-52.818001,-6.898000,-6.162000],[-52.864002,-6.842000,-6.114000],[-53.074001,-5.836000,-6.938000],[-52.656002,-7.694000,-5.144000],[-52.608002,-7.754000,-5.184000],[-52.956001,-5.936000,-7.052001],[-52.746002,-6.960001,-6.214000],[-52.536003,-7.824000,-5.226000],[-52.424004,-7.894001,-5.272000],[-52.634003,-7.022000,-6.268000],[-52.844002,-5.990000,-7.114000],[-53.236004,-4.744000,-7.664001],[-53.164001,-4.788000,-7.728000],[-53.052002,-4.832000,-7.796000],[-53.284004,-4.706000,-7.604001],[-55.538002,7.044000,-2.792000],[-55.466003,7.104001,-2.814000],[-55.258003,6.572001,-4.038000],[-55.328003,6.516000,-4.004000],[-55.748001,7.376000,-1.524000],[-55.676003,7.440001,-1.536000],[-55.584003,6.988000,-2.772000],[-55.794003,7.318000,-1.514000],[-55.374004,6.464000,-3.974000],[-53.272003,-0.946000,-8.908000],[-53.482002,0.412000,-8.830001],[-53.154003,0.414000,-8.894000],[-52.944004,-0.952000,-8.974000],[-53.512001,-0.936000,-8.834001],[-53.722004,0.408000,-8.756001],[-53.064003,-2.308000,-8.776000],[-53.304001,-2.286000,-8.704000],[-53.094002,-3.610000,-8.376000],[-52.854004,-3.642000,-8.446000],[-52.736004,-2.326000,-8.840000],[-52.526001,-3.672000,-8.508000],[-50.476002,-6.240000,-7.394001],[-50.686001,-5.032000,-8.104000],[-49.984001,-5.044000,-8.122001],[-49.774002,-6.254000,-7.410000],[-49.254002,-5.048000,-8.128000],[-49.044003,-6.258000,-7.416000],[-51.120003,-6.218000,-7.368001],[-51.330002,-5.014000,-8.078000],[-51.882004,-4.988000,-8.036000],[-51.674004,-6.184000,-7.334000],[-50.268002,-7.314000,-6.514000],[-50.910004,-7.288001,-6.492000],[-51.464001,-7.250000,-6.460001],[-51.254002,-8.152000,-5.432000],[-50.700001,-8.192000,-5.460000],[-50.058002,-8.222000,-5.478000],[-49.564003,-7.330000,-6.528000],[-49.354004,-8.240001,-5.490000],[-48.622002,-8.246000,-5.494000],[-48.834003,-7.336000,-6.534000],[-68.348000,-6.096000,6.776000],[-68.120003,-6.046000,6.718000],[-67.910004,-4.876000,7.406000],[-68.140007,-4.916000,7.470000],[-68.558006,-7.148000,5.918000],[-68.328003,-7.086000,5.864000],[-68.538002,-7.966001,4.860000],[-68.768005,-8.036000,4.902000],[-68.668007,-6.144000,6.830000],[-68.878006,-7.204000,5.964000],[-69.088005,-8.096001,4.942000],[-69.512001,-8.152000,4.976000],[-69.302002,-7.250000,6.004000],[-69.094002,-6.184000,6.876000],[-68.458000,-4.956000,7.530000],[-68.884003,-4.988000,7.580000],[-68.480003,-8.684000,2.324000],[-68.270004,-8.218000,3.516000],[-68.318001,-8.250000,3.532000],[-68.528000,-8.718000,2.334000],[-68.568001,-8.764001,2.348000],[-68.360001,-8.296000,3.552000],[-68.426003,-8.664001,2.320000],[-68.218002,-8.198000,3.508000],[-68.688004,-8.962001,1.064000],[-68.636002,-8.942000,1.062000],[-68.844002,-9.032001,-0.228000],[-68.898003,-9.054001,-0.228000],[-68.736000,-8.996000,1.070000],[-68.946007,-9.090000,-0.228000],[-68.986000,-9.140000,-0.228000],[-68.778000,-9.046000,1.078000],[-70.278000,-6.240000,6.938000],[-70.068001,-5.032000,7.648000],[-70.768005,-5.044000,7.664001],[-70.978004,-6.254000,6.952000],[-71.708000,-6.258000,6.958000],[-71.498001,-5.048000,7.670001],[-69.640007,-6.218000,6.912000],[-69.430000,-5.014000,7.620000],[-70.488007,-7.314000,6.058000],[-69.850006,-7.288001,6.036000],[-70.060005,-8.192000,5.002000],[-70.698006,-8.222000,5.020000],[-71.188004,-7.330000,6.072001],[-71.398003,-8.240001,5.032000],[-72.128006,-8.246000,5.036000],[-71.918007,-7.336000,6.076000],[-72.298004,-0.970000,8.650001],[-72.508003,-2.362000,8.516001],[-71.810005,-2.368000,8.534000],[-71.600006,-0.972000,8.670000],[-72.018005,-3.736000,8.196000],[-72.720001,-3.730000,8.178000],[-72.938004,-0.966000,8.618000],[-73.148003,-2.354000,8.484000],[-73.358002,-3.716000,8.148001],[-73.906006,-3.696000,8.106000],[-73.696007,-2.342000,8.440001],[-73.486000,-0.958000,8.574000],[-72.090004,0.418000,8.570001],[-72.730003,0.416000,8.538000],[-73.276001,0.414000,8.494000],[-71.390007,0.418000,8.590000],[-73.394005,4.106000,6.810000],[-73.604004,2.964000,7.542000],[-73.282005,2.984000,7.602000],[-73.074005,4.136000,6.864000],[-73.492004,1.736000,8.138000],[-73.814003,1.724000,8.074000],[-73.624001,4.072000,6.750000],[-73.834007,2.940000,7.478000],[-74.044006,1.710000,8.004001],[-74.204002,1.696000,7.932000],[-73.994003,2.914000,7.410000],[-73.784004,4.036000,6.688000],[-73.184006,5.132000,5.902000],[-73.416000,5.088000,5.850000],[-73.574005,5.044000,5.796000],[-72.864006,5.168000,5.948000],[-72.276001,7.044000,-2.792000],[-72.212006,7.104001,-2.814000],[-72.004005,6.572001,-4.038000],[-72.066002,6.516000,-4.004000],[-72.486000,7.376000,-1.524000],[-72.422005,7.440001,-1.536000],[-72.630005,7.558001,-0.228000],[-72.694000,7.494000,-0.228000],[-72.316002,6.988000,-2.772000],[-72.526001,7.318000,-1.514000],[-72.734001,7.434000,-0.228000],[-72.766006,7.384000,-0.228000],[-72.558006,7.268000,-1.506000],[-72.348007,6.940001,-2.754000],[-72.106003,6.464000,-3.974000],[-72.140007,6.420000,-3.948000],[-70.768005,-0.884000,-8.410001],[-70.976006,0.394000,-8.334001],[-70.928001,0.394000,-8.366000],[-70.718002,-0.888000,-8.440001],[-71.136002,1.638000,-8.084001],[-71.186005,1.632000,-8.054001],[-70.822006,-0.882000,-8.390000],[-71.030006,0.392000,-8.316000],[-71.240005,1.628000,-8.036000],[-71.296005,1.628000,-8.030001],[-71.088005,0.392000,-8.310000],[-70.878006,-0.880000,-8.384001],[-70.560005,-2.170000,-8.284000],[-70.614006,-2.162000,-8.266001],[-70.668007,-2.162000,-8.260000],[-70.460007,-3.418000,-7.950000],[-70.404007,-3.420000,-7.956000],[-70.350006,-3.428000,-7.974000],[-70.510002,-2.178000,-8.316000],[-70.300003,-3.442000,-8.004001],[-47.616001,-6.240000,-7.394001],[-48.314003,-6.254000,-7.410000],[-48.524002,-5.044000,-8.122001],[-47.826004,-5.032000,-8.104000],[-47.406002,-7.314000,-6.514000],[-48.104004,-7.330000,-6.528000],[-47.894001,-8.240001,-5.490000],[-47.196003,-8.222000,-5.478000],[-46.982002,-6.218000,-7.368001],[-46.772003,-7.288001,-6.492000],[-46.562004,-8.192000,-5.460000],[-46.022003,-8.152000,-5.432000],[-46.232002,-7.250000,-6.460001],[-46.442001,-6.184000,-7.334000],[-47.192001,-5.014000,-8.078000],[-46.650002,-4.988000,-8.036000],[-46.552002,-0.946000,-8.908000],[-46.862003,-0.952000,-8.974000],[-47.072002,0.414000,-8.894000],[-46.762001,0.412000,-8.830001],[-46.342003,-2.308000,-8.776000],[-46.652000,-2.326000,-8.840000],[-46.442001,-3.672000,-8.508000],[-46.134003,-3.642000,-8.446000],[-46.330002,-0.936000,-8.834001],[-46.122002,-2.286000,-8.704000],[-45.912003,-3.610000,-8.376000],[-45.764004,-3.578000,-8.304001],[-45.974003,-2.266000,-8.630000],[-46.184002,-0.926000,-8.758000],[-46.540001,0.408000,-8.756001],[-46.394001,0.406000,-8.680000],[-47.714001,7.044000,-2.792000],[-47.506001,6.516000,-4.004000],[-47.558002,6.572001,-4.038000],[-47.768002,7.104001,-2.814000],[-47.348003,5.864000,-5.174000],[-47.296001,5.814000,-5.132000],[-47.684002,6.988000,-2.772000],[-47.476002,6.464000,-3.974000],[-47.266003,5.768000,-5.094000],[-47.242001,5.730000,-5.060000],[-47.452003,6.420000,-3.948000],[-47.660004,6.940001,-2.754000],[-47.924004,7.376000,-1.524000],[-47.894001,7.318000,-1.514000],[-47.870003,7.268000,-1.506000],[-47.976002,7.440001,-1.536000],[-49.254002,3.876000,6.406000],[-49.298004,3.890000,6.432000],[-49.506001,2.810000,7.124001],[-49.462002,2.798000,7.098001],[-49.044003,4.842000,5.550000],[-49.088001,4.860000,5.572000],[-48.880001,5.700000,4.578000],[-48.836002,5.678000,4.558000],[-49.202003,3.866000,6.390000],[-48.992001,4.830000,5.538000],[-48.784004,5.664000,4.548000],[-48.728001,5.660000,4.544000],[-48.938004,4.828000,5.532000],[-49.146004,3.864000,6.386000],[-49.410004,2.792000,7.080000],[-49.356003,2.792000,7.074000],[-50.704002,-5.740000,6.374000],[-50.496002,-4.628000,7.030000],[-50.552002,-4.618000,7.012001],[-50.762001,-5.726000,6.358000],[-50.344002,-3.420000,7.498000],[-50.288002,-3.428000,7.518000],[-50.652004,-5.764000,6.400000],[-50.444004,-4.648000,7.056000],[-50.234001,-3.442000,7.546000],[-50.186001,-3.460000,7.590000],[-50.396004,-4.672000,7.096000],[-50.604004,-5.794000,6.436000],[-50.914001,-6.730000,5.564000],[-50.860001,-6.758000,5.586000],[-50.814003,-6.794000,5.618000],[-50.970001,-6.716001,5.550000],[-52.190002,-8.898001,-2.844000],[-52.238003,-8.826000,-2.824000],[-52.448002,-8.354000,-4.036000],[-52.400002,-8.422000,-4.066000],[-51.980003,-9.184000,-1.554000],[-52.028004,-9.110001,-1.542000],[-51.820004,-9.204000,-0.228000],[-51.772003,-9.278001,-0.228000],[-52.118004,-8.976001,-2.866000],[-51.908001,-9.264001,-1.566000],[-51.698002,-9.360001,-0.228000],[-51.586002,-9.446000,-0.228000],[-51.796001,-9.348001,-1.576000],[-52.006004,-9.058001,-2.890000],[-52.326004,-8.496000,-4.100000],[-52.214001,-8.574000,-4.134000],[-52.434002,-6.096000,-7.232000],[-52.106003,-6.144000,-7.288001],[-51.896004,-7.204000,-6.420000],[-52.224003,-7.148000,-6.374000],[-52.016003,-8.036000,-5.360000],[-51.686001,-8.096001,-5.398000],[-52.644001,-4.916000,-7.928000],[-52.316002,-4.956000,-7.986001],[-52.676003,-6.046000,-7.174000],[-52.886002,-4.876000,-7.864000],[-52.466003,-7.086000,-6.322001],[-52.256004,-7.966001,-5.316000],[-49.636002,-9.432000,-3.000000],[-48.934002,-9.454000,-3.006000],[-48.724003,-9.756001,-1.634000],[-49.428001,-9.734000,-1.632000],[-49.218002,-9.836000,-0.228000],[-48.514004,-9.858001,-0.228000],[-47.784000,-9.864000,-0.228000],[-47.994003,-9.764001,-1.636000],[-48.204002,-9.460000,-3.008000],[-49.846001,-8.928000,-4.292000],[-49.146004,-8.948000,-4.302000],[-48.412003,-8.954000,-4.306000],[-50.282001,-9.398001,-2.990000],[-50.490002,-8.896001,-4.280000],[-51.044003,-8.850000,-4.260000],[-50.834003,-9.352000,-2.976000],[-50.070004,-9.700001,-1.628000],[-50.624001,-9.650001,-1.620000],[-50.414001,-9.752001,-0.228000],[-49.860001,-9.800000,-0.228000],[-68.638000,-8.898001,2.388000],[-68.600006,-8.826000,2.366000],[-68.390007,-8.354000,3.578000],[-68.428001,-8.422000,3.608000],[-68.846001,-9.184000,1.096000],[-68.810005,-9.110001,1.086000],[-69.018005,-9.204000,-0.228000],[-69.056000,-9.278001,-0.228000],[-68.700005,-8.976001,2.410000],[-68.908005,-9.264001,1.108000],[-69.118004,-9.360001,-0.228000],[-69.220001,-9.446000,-0.228000],[-69.010002,-9.348001,1.120000],[-68.800003,-9.058001,2.434000],[-68.490005,-8.496000,3.642000],[-68.590004,-8.574000,3.676000],[-69.096001,-8.684000,-2.782000],[-68.888000,-8.962001,-1.522000],[-68.942001,-8.942000,-1.520000],[-69.150002,-8.664001,-2.776000],[-69.206001,-8.656000,-2.774000],[-68.998001,-8.934000,-1.518000],[-69.046005,-8.718000,-2.792000],[-68.836006,-8.996000,-1.526000],[-69.304001,-8.218000,-3.974000],[-69.256004,-8.250000,-3.988000],[-69.464005,-7.598001,-5.084000],[-69.514000,-7.568000,-5.066000],[-69.358002,-8.198000,-3.964000],[-69.568001,-7.550000,-5.054000],[-69.624001,-7.544000,-5.050000],[-69.416000,-8.192000,-3.962000],[-73.140007,-6.240000,6.938000],[-72.438004,-6.254000,6.952000],[-72.228004,-5.044000,7.664001],[-72.930000,-5.032000,7.648000],[-73.348007,-7.314000,6.058000],[-72.648003,-7.330000,6.072001],[-72.858002,-8.240001,5.032000],[-73.558006,-8.222000,5.020000],[-73.778000,-6.218000,6.912000],[-73.988007,-7.288001,6.036000],[-74.198006,-8.192000,5.002000],[-74.744003,-8.152000,4.976000],[-74.534004,-7.250000,6.004000],[-74.326004,-6.184000,6.876000],[-73.568001,-5.014000,7.620000],[-74.116005,-4.988000,7.580000],[-71.118004,-9.432000,2.544000],[-71.818001,-9.454000,2.548000],[-72.028000,-9.756001,1.178000],[-71.328003,-9.734000,1.176000],[-71.538002,-9.836000,-0.228000],[-72.238007,-9.858001,-0.228000],[-72.966003,-9.864000,-0.228000],[-72.758003,-9.764001,1.180000],[-72.548004,-9.460000,2.550000],[-70.908005,-8.928000,3.836000],[-71.606003,-8.948000,3.846000],[-72.338005,-8.954000,3.848000],[-70.478004,-9.398001,2.534000],[-70.270004,-8.896001,3.822000],[-69.722000,-8.850000,3.802000],[-69.932007,-9.352000,2.520000],[-70.688004,-9.700001,1.170000],[-70.142006,-9.650001,1.164000],[-70.352005,-9.752001,-0.228000],[-70.898003,-9.800000,-0.228000],[-74.232002,-0.946000,8.450001],[-73.912003,-0.952000,8.518001],[-73.702003,0.414000,8.438001],[-74.022003,0.412000,8.372001],[-74.442001,-2.308000,8.318001],[-74.122002,-2.326000,8.384001],[-74.332001,-3.672000,8.052000],[-74.652000,-3.642000,7.988000],[-74.462006,-0.936000,8.378000],[-74.672005,-2.286000,8.246000],[-74.882004,-3.610000,7.920001],[-75.040001,-3.578000,7.846000],[-74.832001,-2.266000,8.172000],[-74.622002,-0.926000,8.302000],[-74.254005,0.408000,8.300000],[-74.412003,0.406000,8.224000],[-73.112007,7.044000,2.336000],[-73.322006,6.516000,3.548000],[-73.258003,6.572001,3.580000],[-73.050003,7.104001,2.358000],[-73.468002,5.864000,4.718000],[-73.530006,5.814000,4.676000],[-73.152000,6.988000,2.316000],[-73.362007,6.464000,3.516000],[-73.570000,5.768000,4.636000],[-73.604004,5.730000,4.602000],[-73.394005,6.420000,3.492000],[-73.184006,6.940001,2.298000],[-72.904007,7.376000,1.068000],[-72.942001,7.318000,1.058000],[-72.976006,7.268000,1.048000],[-72.840004,7.440001,1.078000],[-71.604004,3.876000,-6.862000],[-71.554001,3.890000,-6.888000],[-71.346001,2.810000,-7.582000],[-71.394005,2.798000,-7.554000],[-71.814003,4.842000,-6.008000],[-71.764000,4.860000,-6.030000],[-71.974007,5.700000,-5.034000],[-72.022003,5.678000,-5.016000],[-71.658005,3.866000,-6.846000],[-71.866005,4.830000,-5.994000],[-72.076004,5.664000,-5.004000],[-72.132004,5.660000,-5.000000],[-71.922005,4.828000,-5.988000],[-71.714005,3.864000,-6.842000],[-71.448006,2.792000,-7.536000],[-71.506004,2.792000,-7.532001],[-69.932007,-5.740000,-6.832000],[-69.882004,-5.764000,-6.856000],[-69.674004,-6.758000,-6.042000],[-69.722000,-6.730000,-6.020000],[-70.142006,-4.628000,-7.486001],[-70.092003,-4.648000,-7.514000],[-69.986000,-5.726000,-6.816000],[-70.196007,-4.618000,-7.468000],[-70.250000,-4.614000,-7.464000],[-70.042000,-5.724000,-6.810000],[-69.776001,-6.716001,-6.008000],[-69.834000,-6.710001,-6.002000],[-46.778004,-9.432000,-3.000000],[-46.568001,-9.734000,-1.632000],[-47.264004,-9.756001,-1.634000],[-47.474003,-9.454000,-3.006000],[-47.054001,-9.858001,-0.228000],[-46.358002,-9.836000,-0.228000],[-46.144001,-9.398001,-2.990000],[-45.934002,-9.700001,-1.628000],[-45.724003,-9.800000,-0.228000],[-45.182003,-9.752001,-0.228000],[-45.392002,-9.650001,-1.620000],[-45.602001,-9.352000,-2.976000],[-46.986004,-8.928000,-4.292000],[-46.352001,-8.896001,-4.280000],[-45.812000,-8.850000,-4.260000],[-47.684002,-8.948000,-4.302000],[-45.714001,-6.096000,-7.232000],[-45.504002,-7.148000,-6.374000],[-45.814003,-7.204000,-6.420000],[-46.024002,-6.144000,-7.288001],[-45.604004,-8.096001,-5.398000],[-45.294003,-8.036000,-5.360000],[-45.492001,-6.046000,-7.174000],[-45.284000,-7.086000,-6.322001],[-45.074001,-7.966001,-5.316000],[-44.928001,-7.894001,-5.272000],[-45.136002,-7.022000,-6.268000],[-45.348003,-5.990000,-7.114000],[-45.924004,-4.916000,-7.928000],[-45.704002,-4.876000,-7.864000],[-45.556004,-4.832000,-7.796000],[-46.234001,-4.956000,-7.986001],[-46.878002,3.968000,-7.024000],[-46.930004,4.002000,-7.084000],[-47.140003,5.000000,-6.200000],[-47.086002,4.958000,-6.148000],[-46.670002,2.866000,-7.732000],[-46.720001,2.890000,-7.798000],[-46.512001,1.682000,-8.314000],[-46.460003,1.670000,-8.246000],[-46.848003,3.938000,-6.970000],[-46.640003,2.842000,-7.674000],[-46.430000,1.656000,-8.182000],[-46.406002,1.646000,-8.126000],[-46.616001,2.824000,-7.622000],[-46.824001,3.910000,-6.924000],[-47.058002,4.920000,-6.100000],[-47.034000,4.886000,-6.060000],[-48.416004,6.878000,2.274000],[-48.208004,7.202000,1.036000],[-48.252003,7.230000,1.042000],[-48.462002,6.904000,2.284000],[-48.042004,7.346000,-0.228000],[-47.998001,7.318000,-0.228000],[-48.366001,6.862000,2.268000],[-48.158001,7.186000,1.034000],[-47.948002,7.300000,-0.228000],[-47.894001,7.294000,-0.228000],[-48.102001,7.180000,1.032000],[-48.310001,6.858000,2.266000],[-48.626003,6.362000,3.458000],[-48.576004,6.348001,3.448000],[-48.520000,6.344000,3.446000],[-48.670002,6.386000,3.472000],[-49.870003,-0.884000,7.952000],[-49.926003,-0.882000,7.934000],[-50.136002,-2.162000,7.810000],[-50.078003,-2.170000,7.828001],[-49.660004,0.394000,7.878000],[-49.716003,0.392000,7.860001],[-49.508003,1.628000,7.578001],[-49.452003,1.632000,7.596000],[-49.816002,-0.888000,7.984000],[-49.606003,0.394000,7.910000],[-49.398003,1.638000,7.626000],[-49.350002,1.646000,7.670001],[-49.558002,0.396000,7.954000],[-49.768002,-0.894000,8.028001],[-50.026001,-2.178000,7.860001],[-49.978001,-2.190000,7.904000],[-51.352001,-8.898001,2.388000],[-51.144001,-8.422000,3.608000],[-51.192001,-8.354000,3.578000],[-51.400002,-8.826000,2.366000],[-50.982002,-7.694000,4.686000],[-50.934002,-7.754000,4.726000],[-51.282001,-8.976001,2.410000],[-51.072002,-8.496000,3.642000],[-50.862003,-7.824000,4.770000],[-50.748001,-7.894001,4.814000],[-50.960003,-8.574000,3.676000],[-51.168003,-9.058001,2.434000],[-51.562004,-9.184000,1.096000],[-51.490002,-9.264001,1.108000],[-51.378002,-9.348001,1.120000],[-51.610001,-9.110001,1.086000],[-51.596001,-9.218000,-2.936000],[-51.806004,-8.724000,-4.202000],[-51.478001,-8.792001,-4.232000],[-51.268002,-9.290001,-2.958000],[-51.838001,-9.140000,-2.914000],[-52.048004,-8.650001,-4.168000],[-51.386002,-9.514001,-1.600000],[-51.628002,-9.432000,-1.590000],[-51.418003,-9.532001,-0.228000],[-51.176003,-9.612000,-0.228000],[-51.058002,-9.588000,-1.610000],[-50.848003,-9.688001,-0.228000],[-48.798004,-9.432000,2.544000],[-49.008003,-9.734000,1.176000],[-48.304001,-9.756001,1.178000],[-48.096001,-9.454000,2.548000],[-47.364002,-9.460000,2.550000],[-47.574001,-9.764001,1.180000],[-49.442001,-9.398001,2.534000],[-49.650002,-9.700001,1.170000],[-50.206001,-9.650001,1.164000],[-49.996002,-9.352000,2.520000],[-48.588001,-8.928000,3.836000],[-49.232002,-8.896001,3.822000],[-49.786003,-8.850000,3.802000],[-49.576004,-8.152000,4.976000],[-49.022003,-8.192000,5.002000],[-48.378002,-8.222000,5.020000],[-47.886002,-8.948000,3.846000],[-47.676003,-8.240001,5.032000],[-46.944004,-8.246000,5.036000],[-47.154003,-8.954000,3.848000],[-69.188004,-9.218000,2.480000],[-68.978004,-8.724000,3.744000],[-69.298004,-8.792001,3.776000],[-69.508003,-9.290001,2.502000],[-68.958000,-9.140000,2.458000],[-68.748001,-8.650001,3.712000],[-69.398003,-9.514001,1.144000],[-69.168007,-9.432000,1.132000],[-69.376007,-9.532001,-0.228000],[-69.606003,-9.612000,-0.228000],[-69.716003,-9.588000,1.154000],[-69.926003,-9.688001,-0.228000],[-69.314003,-8.684000,-2.782000],[-69.262001,-8.664001,-2.776000],[-69.054001,-8.942000,-1.520000],[-69.106003,-8.962001,-1.522000],[-69.524002,-8.218000,-3.974000],[-69.470001,-8.198000,-3.964000],[-69.680000,-7.550000,-5.054000],[-69.734001,-7.568000,-5.066000],[-69.364006,-8.718000,-2.792000],[-69.572006,-8.250000,-3.988000],[-69.782005,-7.598001,-5.084000],[-69.824005,-7.640000,-5.110000],[-69.614006,-8.296000,-4.008000],[-69.406006,-8.764001,-2.806000],[-69.156006,-8.996000,-1.526000],[-69.196007,-9.046000,-1.534000],[-73.978004,-9.432000,2.544000],[-74.188004,-9.734000,1.176000],[-73.488007,-9.756001,1.178000],[-73.278000,-9.454000,2.548000],[-73.698006,-9.858001,-0.228000],[-74.398003,-9.836000,-0.228000],[-74.618004,-9.398001,2.534000],[-74.826004,-9.700001,1.170000],[-75.036003,-9.800000,-0.228000],[-75.584007,-9.752001,-0.228000],[-75.374001,-9.650001,1.164000],[-75.164001,-9.352000,2.520000],[-73.768005,-8.928000,3.836000],[-74.408005,-8.896001,3.822000],[-74.954002,-8.850000,3.802000],[-73.068001,-8.948000,3.846000],[-75.070007,-6.096000,6.776000],[-75.280006,-7.148000,5.918000],[-74.960007,-7.204000,5.964000],[-74.750000,-6.144000,6.830000],[-75.170006,-8.096001,4.942000],[-75.490005,-8.036000,4.902000],[-75.302002,-6.046000,6.718000],[-75.510002,-7.086000,5.864000],[-75.720001,-7.966001,4.860000],[-75.878006,-7.894001,4.814000],[-75.670006,-7.022000,5.812000],[-75.460007,-5.990000,6.656000],[-74.862007,-4.916000,7.470000],[-75.092003,-4.876000,7.406000],[-75.250000,-4.832000,7.338000],[-74.540001,-4.956000,7.530000],[-71.956001,-9.432000,-3.000000],[-71.746002,-9.734000,-1.632000],[-72.448006,-9.756001,-1.634000],[-72.658005,-9.454000,-3.006000],[-73.388000,-9.460000,-3.008000],[-73.176003,-9.764001,-1.636000],[-71.318001,-9.398001,-2.990000],[-71.108002,-9.700001,-1.628000],[-70.562004,-9.650001,-1.620000],[-70.770004,-9.352000,-2.976000],[-72.166000,-8.928000,-4.292000],[-71.528000,-8.896001,-4.280000],[-70.980003,-8.850000,-4.260000],[-71.190002,-8.152000,-5.432000],[-71.738007,-8.192000,-5.460000],[-72.376007,-8.222000,-5.478000],[-72.866005,-8.948000,-4.302000],[-73.076004,-8.240001,-5.490000],[-73.808006,-8.246000,-5.494000],[-73.598007,-8.954000,-4.306000],[-73.950005,3.968000,6.568000],[-73.886002,4.002000,6.626000],[-73.678001,5.000000,5.744000],[-73.740005,4.958000,5.692000],[-74.158005,2.866000,7.276000],[-74.096001,2.890000,7.342000],[-74.306000,1.682000,7.858000],[-74.368004,1.670000,7.788001],[-73.988007,3.938000,6.514000],[-74.198006,2.842000,7.216001],[-74.408005,1.656000,7.724000],[-74.438004,1.646000,7.670001],[-74.230003,2.824000,7.166000],[-74.022003,3.910000,6.466000],[-73.780006,4.920000,5.644000],[-73.812004,4.886000,5.604000],[-72.440002,6.878000,-2.730000],[-72.648003,7.202000,-1.494000],[-72.600006,7.230000,-1.498000],[-72.390007,6.904000,-2.740000],[-72.808006,7.346000,-0.228000],[-72.858002,7.318000,-0.228000],[-72.494003,6.862000,-2.726000],[-72.702003,7.186000,-1.490000],[-72.912003,7.300000,-0.228000],[-72.758003,7.180000,-1.490000],[-72.966003,7.294000,-0.228000],[-72.550003,6.858000,-2.722000],[-72.230003,6.362000,-3.914000],[-72.286003,6.348001,-3.906000],[-72.340004,6.344000,-3.902000],[-72.182007,6.386000,-3.928000],[-70.986000,-0.884000,-8.410001],[-70.934006,-0.882000,-8.390000],[-70.726006,-2.162000,-8.266001],[-70.778000,-2.170000,-8.284000],[-70.570000,-3.428000,-7.974000],[-70.516006,-3.420000,-7.956000],[-71.196007,0.394000,-8.334001],[-71.142006,0.392000,-8.316000],[-71.352005,1.628000,-8.036000],[-71.406006,1.632000,-8.054001],[-71.036003,-0.888000,-8.440001],[-71.244003,0.394000,-8.366000],[-71.454002,1.638000,-8.084001],[-71.494003,1.646000,-8.126000],[-71.286003,0.396000,-8.410001],[-71.078003,-0.894000,-8.484000],[-70.826004,-2.178000,-8.316000],[-70.868004,-2.190000,-8.360001],[-70.660004,-3.460000,-8.046000],[-70.618004,-3.442000,-8.004001],[-45.938004,-9.432000,2.544000],[-46.636002,-9.454000,2.548000],[-46.844002,-9.756001,1.178000],[-46.148003,-9.734000,1.176000],[-45.728001,-8.928000,3.836000],[-46.426003,-8.948000,3.846000],[-46.216003,-8.240001,5.032000],[-45.518002,-8.222000,5.020000],[-45.304001,-9.398001,2.534000],[-45.094002,-8.896001,3.822000],[-44.884003,-8.192000,5.002000],[-44.554001,-8.850000,3.802000],[-44.764004,-9.352000,2.520000],[-45.514004,-9.700001,1.170000],[-44.972004,-9.650001,1.164000],[-44.876003,-9.218000,-2.936000],[-45.184002,-9.290001,-2.958000],[-45.394001,-8.792001,-4.232000],[-45.086002,-8.724000,-4.202000],[-44.666000,-9.514001,-1.600000],[-44.976002,-9.588000,-1.610000],[-44.766003,-9.688001,-0.228000],[-44.456001,-9.612000,-0.228000],[-44.656002,-9.140000,-2.914000],[-44.446003,-9.432000,-1.590000],[-44.510002,-9.058001,-2.890000],[-44.866001,-8.650001,-4.168000],[-44.718002,-8.574000,-4.134000],[-46.042004,-0.908000,-8.610001],[-45.832001,-2.224000,-8.482000],[-45.884003,-2.244000,-8.554001],[-46.094002,-0.918000,-8.682000],[-45.674004,-3.546000,-8.232000],[-45.622002,-3.514000,-8.162001],[-46.012001,-0.900000,-8.542001],[-45.802002,-2.206000,-8.416000],[-45.594002,-3.486000,-8.100000],[-45.570004,-3.460000,-8.046000],[-45.778004,-2.190000,-8.360001],[-45.988003,-0.894000,-8.484000],[-46.250004,0.400000,-8.534000],[-46.222004,0.398000,-8.468000],[-46.198002,0.396000,-8.410001],[-46.302002,0.402000,-8.606000],[-47.582001,6.878000,-2.730000],[-47.626003,6.904000,-2.740000],[-47.834003,7.230000,-1.498000],[-47.790001,7.202000,-1.494000],[-47.372002,6.362000,-3.914000],[-47.416000,6.386000,-3.928000],[-47.208004,5.700000,-5.034000],[-47.164001,5.678000,-5.016000],[-47.530003,6.862000,-2.726000],[-47.320004,6.348001,-3.906000],[-47.112003,5.664000,-5.004000],[-47.056004,5.660000,-5.000000],[-47.266003,6.344000,-3.902000],[-47.476002,6.858000,-2.722000],[-47.738003,7.186000,-1.490000],[-47.684002,7.180000,-1.490000],[-49.034004,3.876000,6.406000],[-48.824001,4.842000,5.550000],[-48.880001,4.830000,5.538000],[-49.090004,3.866000,6.390000],[-48.672001,5.664000,4.548000],[-48.616001,5.678000,4.558000],[-48.980003,3.890000,6.432000],[-48.772003,4.860000,5.572000],[-48.562004,5.700000,4.578000],[-48.514004,5.730000,4.602000],[-48.722004,4.886000,5.604000],[-48.932003,3.910000,6.466000],[-49.242001,2.798000,7.098001],[-49.190002,2.810000,7.124001],[-49.142002,2.824000,7.166000],[-49.298004,2.792000,7.080000],[-50.516003,-5.884000,6.536000],[-50.564003,-5.836000,6.482000],[-50.774002,-6.842000,5.658000],[-50.726002,-6.898000,5.706000],[-50.306004,-4.744000,7.206000],[-50.356003,-4.706000,7.148000],[-50.146004,-3.486000,7.644001],[-50.098003,-3.514000,7.706000],[-50.444004,-5.936000,6.594000],[-50.234001,-4.788000,7.270000],[-50.024002,-3.546000,7.776000],[-49.912003,-3.578000,7.846000],[-50.122002,-4.832000,7.338000],[-50.330002,-5.990000,6.656000],[-50.652004,-6.960001,5.758000],[-50.540001,-7.022000,5.812000],[-50.758003,-9.218000,2.480000],[-50.428001,-9.290001,2.502000],[-50.220001,-8.792001,3.776000],[-50.548004,-8.724000,3.744000],[-50.338001,-8.036000,4.902000],[-50.010002,-8.096001,4.942000],[-50.968002,-9.514001,1.144000],[-50.638004,-9.588000,1.154000],[-51.000004,-9.140000,2.458000],[-51.208004,-9.432000,1.132000],[-50.790001,-8.650001,3.712000],[-50.580002,-7.966001,4.860000],[-47.958004,-6.240000,6.938000],[-47.256001,-6.254000,6.952000],[-47.046001,-5.044000,7.664001],[-47.748001,-5.032000,7.648000],[-47.538002,-3.730000,8.178000],[-46.836002,-3.736000,8.196000],[-46.104004,-3.740000,8.202001],[-46.314003,-5.048000,7.670001],[-46.524002,-6.258000,6.958000],[-48.168003,-7.314000,6.058000],[-47.466003,-7.330000,6.072001],[-46.734001,-7.336000,6.076000],[-48.602001,-6.218000,6.912000],[-48.812004,-7.288001,6.036000],[-49.366001,-7.250000,6.004000],[-49.156002,-6.184000,6.876000],[-48.392002,-5.014000,7.620000],[-48.946003,-4.988000,7.580000],[-48.736004,-3.696000,8.106000],[-48.182003,-3.716000,8.148001],[-69.474007,-8.898001,-2.844000],[-69.266006,-9.184000,-1.554000],[-69.328003,-9.264001,-1.566000],[-69.536003,-8.976001,-2.866000],[-69.638000,-9.058001,-2.890000],[-69.428001,-9.348001,-1.576000],[-69.436005,-8.826000,-2.824000],[-69.226006,-9.110001,-1.542000],[-69.684006,-8.422000,-4.066000],[-69.646004,-8.354000,-4.036000],[-69.854004,-7.694000,-5.144000],[-69.894005,-7.754000,-5.184000],[-69.746002,-8.496000,-4.100000],[-69.956001,-7.824000,-5.226000],[-70.058006,-7.894001,-5.272000],[-69.846001,-8.574000,-4.134000],[-74.818001,-9.432000,-3.000000],[-74.118004,-9.454000,-3.006000],[-73.908005,-9.756001,-1.634000],[-74.608002,-9.734000,-1.632000],[-75.028000,-8.928000,-4.292000],[-74.326004,-8.948000,-4.302000],[-74.536003,-8.240001,-5.490000],[-75.236000,-8.222000,-5.478000],[-75.456001,-9.398001,-2.990000],[-75.666000,-8.896001,-4.280000],[-75.876007,-8.192000,-5.460000],[-76.422005,-8.152000,-5.432000],[-76.212006,-8.850000,-4.260000],[-76.002007,-9.352000,-2.976000],[-75.246002,-9.700001,-1.628000],[-75.794006,-9.650001,-1.620000],[-75.910004,-9.218000,2.480000],[-75.590004,-9.290001,2.502000],[-75.380005,-8.792001,3.776000],[-75.700005,-8.724000,3.744000],[-76.118004,-9.514001,1.144000],[-75.798004,-9.588000,1.154000],[-76.008003,-9.688001,-0.228000],[-76.328003,-9.612000,-0.228000],[-76.140007,-9.140000,2.458000],[-76.348007,-9.432000,1.132000],[-76.558006,-9.532001,-0.228000],[-76.716003,-9.446000,-0.228000],[-76.506004,-9.348001,1.120000],[-76.296005,-9.058001,2.434000],[-75.930000,-8.650001,3.712000],[-76.088005,-8.574000,3.676000],[-70.026001,-9.218000,-2.936000],[-70.346001,-9.290001,-2.958000],[-70.556000,-8.792001,-4.232000],[-70.236000,-8.724000,-4.202000],[-70.446007,-8.036000,-5.360000],[-70.766006,-8.096001,-5.398000],[-69.816002,-9.514001,-1.600000],[-70.136002,-9.588000,-1.610000],[-69.796005,-9.140000,-2.914000],[-69.586006,-9.432000,-1.590000],[-70.006004,-8.650001,-4.168000],[-70.214005,-7.966001,-5.316000],[-72.796005,-6.240000,-7.394001],[-73.496002,-6.254000,-7.410000],[-73.706001,-5.044000,-8.122001],[-73.006004,-5.032000,-8.104000],[-73.216003,-3.730000,-8.634001],[-73.916000,-3.736000,-8.654000],[-74.646004,-3.740000,-8.658000],[-74.436005,-5.048000,-8.128000],[-74.226006,-6.258000,-7.416000],[-72.586006,-7.314000,-6.514000],[-73.286003,-7.330000,-6.528000],[-74.018005,-7.336000,-6.534000],[-72.156006,-6.218000,-7.368001],[-71.948006,-7.288001,-6.492000],[-71.400002,-7.250000,-6.460001],[-71.610001,-6.184000,-7.334000],[-72.366005,-5.014000,-8.078000],[-71.820000,-4.988000,-8.036000],[-72.030006,-3.696000,-8.562000],[-72.576004,-3.716000,-8.604000],[-74.786003,-0.908000,8.152000],[-74.996002,-2.224000,8.026000],[-74.934006,-2.244000,8.098001],[-74.724007,-0.918000,8.226001],[-75.144005,-3.546000,7.776000],[-75.204002,-3.514000,7.706000],[-74.824005,-0.900000,8.086000],[-75.036003,-2.206000,7.958000],[-75.244003,-3.486000,7.644001],[-75.276001,-3.460000,7.590000],[-75.066002,-2.190000,7.904000],[-74.858002,-0.894000,8.028001],[-74.578003,0.400000,8.078000],[-74.616005,0.398000,8.010000],[-74.648003,0.396000,7.954000],[-74.514000,0.402000,8.148001],[-73.276001,6.878000,2.274000],[-73.228004,6.904000,2.284000],[-73.018005,7.230000,1.042000],[-73.066002,7.202000,1.036000],[-73.486000,6.362000,3.458000],[-73.436005,6.386000,3.472000],[-73.644005,5.700000,4.578000],[-73.694000,5.678000,4.558000],[-73.330002,6.862000,2.268000],[-73.538002,6.348001,3.448000],[-73.746002,5.664000,4.548000],[-73.804001,5.660000,4.544000],[-73.594002,6.344000,3.446000],[-73.386002,6.858000,2.266000],[-73.120003,7.186000,1.034000],[-73.176003,7.180000,1.032000],[-71.824005,3.876000,-6.862000],[-72.032005,4.842000,-6.008000],[-71.978004,4.830000,-5.994000],[-71.770004,3.866000,-6.846000],[-72.188004,5.664000,-5.004000],[-72.240005,5.678000,-5.016000],[-71.872002,3.890000,-6.888000],[-72.082001,4.860000,-6.030000],[-72.290001,5.700000,-5.034000],[-72.332001,5.730000,-5.060000],[-72.122002,4.886000,-6.060000],[-71.914001,3.910000,-6.924000],[-71.614006,2.798000,-7.554000],[-71.664001,2.810000,-7.582000],[-71.706001,2.824000,-7.622000],[-71.560005,2.792000,-7.536000],[-70.152000,-5.740000,-6.832000],[-70.360001,-4.628000,-7.486001],[-70.308006,-4.618000,-7.468000],[-70.098000,-5.726000,-6.816000],[-70.200005,-5.764000,-6.856000],[-70.410004,-4.648000,-7.514000],[-70.450005,-4.672000,-7.554000],[-70.240005,-5.794000,-6.892000],[-69.942001,-6.730000,-6.020000],[-69.990005,-6.758000,-6.042000],[-70.032005,-6.794000,-6.074000],[-69.888000,-6.716001,-6.008000],[-45.098003,-6.238000,6.938000],[-44.888000,-5.032000,7.648000],[-45.584003,-5.044000,7.664001],[-45.794003,-6.254000,6.952000],[-45.376003,-3.736000,8.196000],[-44.676003,-3.724000,8.178000],[-44.464001,-6.214000,6.912000],[-45.308002,-7.314000,6.058000],[-44.674004,-7.288001,6.036000],[-46.004002,-7.330000,6.072001],[-44.556004,-9.588000,1.154000],[-45.204002,-5.884000,-6.992000],[-45.256001,-5.936000,-7.052001],[-45.466003,-4.788000,-7.728000],[-45.414001,-4.744000,-7.664001],[-44.994003,-6.898000,-6.162000],[-45.046001,-6.960001,-6.214000],[-44.838001,-7.824000,-5.226000],[-44.786003,-7.754000,-5.184000],[-45.174004,-5.836000,-6.938000],[-44.966003,-6.842000,-6.114000],[-44.758003,-7.694000,-5.144000],[-44.734001,-7.640000,-5.110000],[-44.944000,-6.794000,-6.074000],[-45.152000,-5.794000,-6.892000],[-45.384003,-4.706000,-7.604001],[-45.360001,-4.672000,-7.554000],[-46.744003,3.876000,-6.862000],[-46.536003,2.798000,-7.554000],[-46.580002,2.810000,-7.582000],[-46.788002,3.890000,-6.888000],[-46.372002,1.638000,-8.084001],[-46.328003,1.632000,-8.054001],[-46.694004,3.866000,-6.846000],[-46.486004,2.792000,-7.536000],[-46.276001,1.628000,-8.036000],[-46.222004,1.628000,-8.030001],[-46.430000,2.792000,-7.532001],[-46.640003,3.864000,-6.842000],[-46.954002,4.842000,-6.008000],[-46.904003,4.830000,-5.994000],[-46.848003,4.828000,-5.988000],[-46.998001,4.860000,-6.030000],[-48.198002,6.878000,2.274000],[-48.254002,6.862000,2.268000],[-48.464001,6.348001,3.448000],[-48.406002,6.362000,3.458000],[-47.988003,7.202000,1.036000],[-48.046001,7.186000,1.034000],[-47.836002,7.300000,-0.228000],[-47.780003,7.318000,-0.228000],[-48.144001,6.904000,2.284000],[-47.934002,7.230000,1.042000],[-47.726002,7.346000,-0.228000],[-47.676003,7.384000,-0.228000],[-47.886002,7.268000,1.048000],[-48.096001,6.940001,2.298000],[-48.352001,6.386000,3.472000],[-48.304001,6.420000,3.492000],[-49.680004,-0.908000,8.152000],[-49.470001,0.400000,8.078000],[-49.518002,0.398000,8.010000],[-49.728001,-0.900000,8.086000],[-49.310001,1.656000,7.724000],[-49.260002,1.670000,7.788001],[-49.606003,-0.918000,8.226001],[-49.396004,0.402000,8.148001],[-49.188004,1.682000,7.858000],[-49.074001,1.696000,7.932000],[-49.284004,0.406000,8.224000],[-49.492001,-0.926000,8.302000],[-49.888000,-2.224000,8.026000],[-49.816002,-2.244000,8.098001],[-49.702003,-2.266000,8.172000],[-49.938004,-2.206000,7.958000],[-49.920002,-6.096000,6.776000],[-50.128002,-7.148000,5.918000],[-49.800003,-7.204000,5.964000],[-49.590004,-6.144000,6.830000],[-50.162003,-6.046000,6.718000],[-50.370003,-7.086000,5.864000],[-49.710003,-4.916000,7.470000],[-49.952003,-4.876000,7.406000],[-49.742001,-3.610000,7.920001],[-49.502003,-3.642000,7.988000],[-49.380001,-4.956000,7.530000],[-49.170002,-3.672000,8.052000],[-47.120003,-0.970000,8.650001],[-47.330002,-2.362000,8.516001],[-46.626003,-2.368000,8.534000],[-46.416000,-0.972000,8.670000],[-45.686001,-0.972000,8.676001],[-45.896004,-2.370000,8.540000],[-47.762001,-0.966000,8.618000],[-47.972004,-2.354000,8.484000],[-48.528004,-2.342000,8.440001],[-48.318001,-0.958000,8.574000],[-46.910004,0.418000,8.570001],[-47.554001,0.416000,8.538000],[-48.108002,0.414000,8.494000],[-47.898003,1.748000,8.192000],[-47.344002,1.756000,8.234000],[-46.700001,1.762000,8.264000],[-46.206001,0.418000,8.590000],[-45.996002,1.766000,8.284000],[-45.266003,1.768000,8.288000],[-45.476002,0.418000,8.596001],[-75.656006,-6.240000,-7.394001],[-75.866005,-5.032000,-8.104000],[-75.168007,-5.044000,-8.122001],[-74.958000,-6.254000,-7.410000],[-75.378006,-3.736000,-8.654000],[-76.076004,-3.730000,-8.634001],[-76.296005,-6.218000,-7.368001],[-76.504005,-5.014000,-8.078000],[-76.714005,-3.716000,-8.604000],[-77.262001,-3.696000,-8.562000],[-77.052002,-4.988000,-8.036000],[-76.842003,-6.184000,-7.334000],[-75.446007,-7.314000,-6.514000],[-76.086006,-7.288001,-6.492000],[-76.632004,-7.250000,-6.460001],[-74.746002,-7.330000,-6.528000],[-76.748001,-9.218000,-2.936000],[-76.958000,-8.724000,-4.202000],[-76.638000,-8.792001,-4.232000],[-76.428001,-9.290001,-2.958000],[-76.848007,-8.096001,-5.398000],[-77.166000,-8.036000,-5.360000],[-76.978004,-9.140000,-2.914000],[-77.186005,-8.650001,-4.168000],[-77.396004,-7.966001,-5.316000],[-77.554001,-7.894001,-5.272000],[-77.344002,-8.574000,-4.134000],[-77.134003,-9.058001,-2.890000],[-76.538002,-9.514001,-1.600000],[-76.768005,-9.432000,-1.590000],[-76.926003,-9.348001,-1.576000],[-76.218002,-9.588000,-1.610000],[-75.624001,-5.884000,6.536000],[-75.560005,-5.936000,6.594000],[-75.352005,-4.788000,7.270000],[-75.414001,-4.744000,7.206000],[-75.832001,-6.898000,5.706000],[-75.770004,-6.960001,5.758000],[-75.980003,-7.824000,4.770000],[-76.042000,-7.754000,4.726000],[-75.662003,-5.836000,6.482000],[-75.872002,-6.842000,5.658000],[-76.080002,-7.694000,4.686000],[-76.112007,-7.640000,4.652000],[-75.904007,-6.794000,5.618000],[-75.694000,-5.794000,6.436000],[-75.452003,-4.706000,7.148000],[-75.484001,-4.672000,7.096000],[-70.864006,-6.096000,-7.232000],[-70.654007,-7.148000,-6.374000],[-70.974007,-7.204000,-6.420000],[-71.184006,-6.144000,-7.288001],[-70.634003,-6.046000,-7.174000],[-70.424004,-7.086000,-6.322001],[-70.266006,-7.022000,-6.268000],[-70.476006,-5.990000,-7.114000],[-71.074005,-4.916000,-7.928000],[-70.844002,-4.876000,-7.864000],[-70.684006,-4.832000,-7.796000],[-70.894005,-3.578000,-8.304001],[-71.052002,-3.610000,-8.376000],[-71.284004,-3.642000,-8.446000],[-71.394005,-4.956000,-7.986001],[-71.604004,-3.672000,-8.508000],[-73.636002,-0.970000,-9.108001],[-73.426003,-2.362000,-8.972000],[-74.126007,-2.368000,-8.992001],[-74.336006,-0.972000,-9.126000],[-75.066002,-0.972000,-9.132000],[-74.856003,-2.370000,-8.998000],[-72.998001,-0.966000,-9.076000],[-72.786003,-2.354000,-8.942000],[-72.238007,-2.342000,-8.898001],[-72.448006,-0.958000,-9.030001],[-73.844002,0.418000,-9.026000],[-73.206001,0.416000,-8.996000],[-72.658005,0.414000,-8.952001],[-72.868004,1.748000,-8.648001],[-73.416000,1.756000,-8.692000],[-74.056000,1.762000,-8.722000],[-74.546005,0.418000,-9.046000],[-74.756004,1.766000,-8.740001],[-75.486000,1.768000,-8.746000],[-75.276001,0.418000,-9.052000],[-74.112007,3.876000,6.406000],[-74.320007,2.798000,7.098001],[-74.272003,2.810000,7.124001],[-74.062004,3.890000,6.432000],[-74.482002,1.638000,7.626000],[-74.530006,1.632000,7.596000],[-74.166000,3.866000,6.390000],[-74.374001,2.792000,7.080000],[-74.584007,1.628000,7.578001],[-74.638000,1.628000,7.572001],[-74.430000,2.792000,7.074000],[-74.222000,3.864000,6.386000],[-73.902000,4.842000,5.550000],[-73.956001,4.830000,5.538000],[-74.012001,4.828000,5.532000],[-73.854004,4.860000,5.572000],[-72.658005,6.878000,-2.730000],[-72.606003,6.862000,-2.726000],[-72.396004,6.348001,-3.906000],[-72.450005,6.362000,-3.914000],[-72.868004,7.202000,-1.494000],[-72.814003,7.186000,-1.490000],[-73.024002,7.300000,-0.228000],[-73.078003,7.318000,-0.228000],[-72.708000,6.904000,-2.740000],[-72.916000,7.230000,-1.498000],[-73.126007,7.346000,-0.228000],[-73.168007,7.384000,-0.228000],[-72.960007,7.268000,-1.506000],[-72.750000,6.940001,-2.754000],[-72.498001,6.386000,-3.928000],[-72.540001,6.420000,-3.948000],[-71.150002,-0.908000,-8.610001],[-71.358002,0.400000,-8.534000],[-71.318001,0.398000,-8.468000],[-71.110001,-0.900000,-8.542001],[-71.528000,1.656000,-8.182000],[-71.566002,1.670000,-8.246000],[-71.210007,-0.918000,-8.682000],[-71.420006,0.402000,-8.606000],[-71.630005,1.682000,-8.314000],[-71.732002,1.696000,-8.388000],[-71.522003,0.406000,-8.680000],[-71.312004,-0.926000,-8.758000],[-70.938004,-2.224000,-8.482000],[-71.002007,-2.244000,-8.554001],[-71.104004,-2.266000,-8.630000],[-70.792000,-3.546000,-8.232000],[-70.730003,-3.514000,-8.162001],[-70.900002,-2.206000,-8.416000],[-70.692001,-3.486000,-8.100000],[-45.166000,-2.368000,8.534000],[-44.956001,-0.972000,8.670000],[-44.466003,-2.352000,8.514000],[-44.746002,0.418000,8.590000],[-44.536003,1.766000,8.284000],[-44.418003,-8.976001,-2.866000],[-44.578003,-8.422000,-4.066000],[-44.548000,-8.354000,-4.036000],[-44.524002,-8.296000,-4.008000],[-44.628002,-8.496000,-4.100000],[-45.910004,-0.884000,-8.410001],[-45.954002,-0.888000,-8.440001],[-46.162003,0.394000,-8.366000],[-46.118004,0.394000,-8.334001],[-45.700001,-2.170000,-8.284000],[-45.744003,-2.178000,-8.316000],[-45.534000,-3.442000,-8.004001],[-45.492001,-3.428000,-7.974000],[-45.860001,-0.882000,-8.390000],[-45.648003,-2.162000,-8.266001],[-45.440002,-3.420000,-7.956000],[-45.386002,-3.418000,-7.950000],[-45.594002,-2.162000,-8.260000],[-45.804001,-0.880000,-8.384001],[-46.068001,0.392000,-8.316000],[-46.012001,0.392000,-8.310000],[-47.362003,6.878000,-2.730000],[-47.152000,6.362000,-3.914000],[-47.208004,6.348001,-3.906000],[-47.418003,6.862000,-2.726000],[-47.000004,5.664000,-5.004000],[-46.944004,5.678000,-5.016000],[-47.308002,6.904000,-2.740000],[-47.100002,6.386000,-3.928000],[-46.890003,5.700000,-5.034000],[-46.842003,5.730000,-5.060000],[-47.050003,6.420000,-3.948000],[-47.260002,6.940001,-2.754000],[-47.572002,7.202000,-1.494000],[-47.518002,7.230000,-1.498000],[-47.468002,7.268000,-1.506000],[-47.626003,7.186000,-1.490000],[-48.842003,3.968000,6.568000],[-48.890003,3.938000,6.514000],[-49.100002,2.842000,7.216001],[-49.052002,2.866000,7.276000],[-48.632004,4.958000,5.692000],[-48.682003,4.920000,5.644000],[-48.474003,5.768000,4.636000],[-48.424004,5.814000,4.676000],[-48.768002,4.002000,6.626000],[-48.560001,5.000000,5.744000],[-48.350002,5.864000,4.718000],[-48.236004,5.914001,4.762000],[-48.446003,5.044000,5.796000],[-48.656002,4.036000,6.688000],[-48.978001,2.890000,7.342000],[-48.864002,2.914000,7.410000],[-49.080002,-0.946000,8.450001],[-48.752003,-0.952000,8.518001],[-48.542004,0.414000,8.438001],[-48.872002,0.412000,8.372001],[-48.662003,1.724000,8.074000],[-48.332001,1.736000,8.138000],[-49.290001,-2.308000,8.318001],[-48.962002,-2.326000,8.384001],[-49.324001,-0.936000,8.378000],[-49.532001,-2.286000,8.246000],[-49.114002,0.408000,8.300000],[-48.904003,1.710000,8.004001],[-46.280003,4.198000,6.972000],[-45.578003,4.206000,6.988000],[-45.366001,5.254000,6.064000],[-46.070004,5.246000,6.046000],[-45.860001,6.152000,4.972000],[-45.154003,6.158000,4.996000],[-44.634003,5.254000,6.080000],[-44.846001,4.208000,6.996000],[-46.490002,3.028000,7.722001],[-45.788002,3.036000,7.738000],[-45.056004,3.038000,7.746000],[-46.924004,4.182000,6.946000],[-47.134003,3.018000,7.694000],[-47.688004,3.004000,7.654000],[-47.478001,4.162000,6.910000],[-46.714001,5.228000,6.020000],[-47.268002,5.202000,5.990000],[-47.060001,6.102000,4.922000],[-46.504002,6.132000,4.948000],[-70.312004,-5.884000,-6.992000],[-70.274002,-5.836000,-6.938000],[-70.064003,-6.842000,-6.114000],[-70.102005,-6.898000,-6.162000],[-70.522003,-4.744000,-7.664001],[-70.482002,-4.706000,-7.604001],[-70.374001,-5.936000,-7.052001],[-70.582001,-4.788000,-7.728000],[-70.164001,-6.960001,-6.214000],[-76.496002,-0.970000,-9.108001],[-75.796005,-0.972000,-9.126000],[-75.586006,-2.368000,-8.992001],[-76.286003,-2.362000,-8.972000],[-76.706001,0.418000,-9.026000],[-76.006004,0.418000,-9.046000],[-76.216003,1.766000,-8.740001],[-76.916000,1.762000,-8.722000],[-77.134003,-0.966000,-9.076000],[-77.344002,0.416000,-8.996000],[-77.554001,1.756000,-8.692000],[-78.100006,1.748000,-8.648001],[-77.890007,0.414000,-8.952001],[-77.680000,-0.958000,-9.030001],[-76.924004,-2.354000,-8.942000],[-77.470001,-2.342000,-8.898001],[-77.586006,-6.096000,-7.232000],[-77.266006,-6.144000,-7.288001],[-77.056007,-7.204000,-6.420000],[-77.376007,-7.148000,-6.374000],[-77.796005,-4.916000,-7.928000],[-77.476006,-4.956000,-7.986001],[-77.686005,-3.672000,-8.508000],[-78.006004,-3.642000,-8.446000],[-77.816002,-6.046000,-7.174000],[-78.026001,-4.876000,-7.864000],[-78.234001,-3.610000,-8.376000],[-78.392006,-3.578000,-8.304001],[-78.182007,-4.832000,-7.796000],[-77.972000,-5.990000,-7.114000],[-77.606003,-7.086000,-6.322001],[-77.762001,-7.022000,-6.268000],[-76.460007,-8.898001,2.388000],[-76.670006,-9.184000,1.096000],[-76.608002,-9.264001,1.108000],[-76.398003,-8.976001,2.410000],[-76.818001,-9.360001,-0.228000],[-76.878006,-9.278001,-0.228000],[-76.498001,-8.826000,2.366000],[-76.708000,-9.110001,1.086000],[-76.918007,-9.204000,-0.228000],[-76.948006,-9.140000,-0.228000],[-76.740005,-9.046000,1.078000],[-76.530006,-8.764001,2.348000],[-76.252007,-8.422000,3.608000],[-76.290001,-8.354000,3.578000],[-76.320007,-8.296000,3.552000],[-76.188004,-8.496000,3.642000],[-71.702003,-0.946000,-8.908000],[-72.024002,-0.952000,-8.974000],[-72.232002,0.414000,-8.894000],[-71.912003,0.412000,-8.830001],[-72.122002,1.724000,-8.530001],[-72.442001,1.736000,-8.594001],[-71.494003,-2.308000,-8.776000],[-71.814003,-2.326000,-8.840000],[-71.472000,-0.936000,-8.834001],[-71.262001,-2.286000,-8.704000],[-71.682007,0.408000,-8.756001],[-71.890007,1.710000,-8.460000],[-74.476006,4.198000,-7.428000],[-75.174004,4.206000,-7.444000],[-75.384003,5.256000,-6.514000],[-74.686005,5.246000,-6.500000],[-74.894005,6.152000,-5.424000],[-75.594002,6.166000,-5.436000],[-76.326004,6.170000,-5.440000],[-76.116005,5.260000,-6.518000],[-75.906006,4.210000,-7.450000],[-74.266006,3.028000,-8.178000],[-74.966003,3.036000,-8.196000],[-75.696007,3.038000,-8.202001],[-73.836006,4.184000,-7.402000],[-73.626007,3.018000,-8.150001],[-73.078003,3.004000,-8.112000],[-73.288002,4.162000,-7.366000],[-74.044006,5.228000,-6.478000],[-73.498001,5.202000,-6.446000],[-73.706001,6.102000,-5.378000],[-74.256004,6.132000,-5.406000],[-74.946007,-0.884000,7.952000],[-74.900002,-0.888000,7.984000],[-74.690002,0.394000,7.910000],[-74.738007,0.394000,7.878000],[-75.158005,-2.170000,7.828001],[-75.108002,-2.178000,7.860001],[-75.316002,-3.442000,7.546000],[-75.366005,-3.428000,7.518000],[-75.002007,-0.882000,7.934000],[-75.210007,-2.162000,7.810000],[-75.418007,-3.420000,7.498000],[-75.476006,-3.418000,7.492001],[-75.266006,-2.162000,7.802001],[-75.056000,-0.880000,7.926001],[-74.792000,0.392000,7.860001],[-74.848007,0.392000,7.854001],[-73.496002,6.878000,2.274000],[-73.704002,6.362000,3.458000],[-73.650002,6.348001,3.448000],[-73.442001,6.862000,2.268000],[-73.858002,5.664000,4.548000],[-73.912003,5.678000,4.558000],[-73.544006,6.904000,2.284000],[-73.754005,6.386000,3.472000],[-73.962006,5.700000,4.578000],[-74.004005,5.730000,4.602000],[-73.796005,6.420000,3.492000],[-73.586006,6.940001,2.298000],[-73.286003,7.202000,1.036000],[-73.336006,7.230000,1.042000],[-73.376007,7.268000,1.048000],[-73.232002,7.186000,1.034000],[-71.986000,3.968000,-7.024000],[-71.946007,3.938000,-6.970000],[-71.736000,2.842000,-7.674000],[-71.776001,2.866000,-7.732000],[-72.194000,4.958000,-6.148000],[-72.156006,4.920000,-6.100000],[-72.364006,5.768000,-5.094000],[-72.404007,5.814000,-5.132000],[-72.048004,4.002000,-7.084000],[-72.258003,5.000000,-6.200000],[-72.466003,5.864000,-5.174000],[-72.570000,5.914001,-5.220000],[-72.360001,5.044000,-6.254000],[-72.150002,4.036000,-7.144001],[-71.838005,2.890000,-7.798000],[-71.942001,2.914000,-7.866000],[-45.072002,-5.740000,-6.832000],[-44.864002,-6.730000,-6.020000],[-44.908001,-6.758000,-6.042000],[-45.116001,-5.764000,-6.856000],[-44.700001,-7.598001,-5.084000],[-44.656002,-7.568000,-5.066000],[-45.022003,-5.726000,-6.816000],[-44.814003,-6.716001,-6.008000],[-44.604004,-7.550000,-5.054000],[-44.550003,-7.544000,-5.050000],[-44.758003,-6.710001,-6.002000],[-44.968002,-5.724000,-6.810000],[-45.282001,-4.628000,-7.486001],[-45.232002,-4.618000,-7.468000],[-45.178001,-4.614000,-7.464000],[-45.326004,-4.648000,-7.514000],[-46.526001,3.876000,-6.862000],[-46.582001,3.866000,-6.846000],[-46.792004,4.830000,-5.994000],[-46.734001,4.842000,-6.008000],[-46.316002,2.798000,-7.554000],[-46.374001,2.792000,-7.536000],[-46.164001,1.628000,-8.036000],[-46.108002,1.632000,-8.054001],[-46.472004,3.890000,-6.888000],[-46.262001,2.810000,-7.582000],[-46.054001,1.638000,-8.084001],[-46.004002,1.646000,-8.126000],[-46.214001,2.824000,-7.622000],[-46.422001,3.910000,-6.924000],[-46.680004,4.860000,-6.030000],[-46.632004,4.886000,-6.060000],[-48.006001,7.044000,2.336000],[-47.796001,7.376000,1.068000],[-47.846001,7.318000,1.058000],[-48.054001,6.988000,2.316000],[-47.636002,7.434000,-0.228000],[-47.586002,7.494000,-0.228000],[-47.932003,7.104001,2.358000],[-47.722004,7.440001,1.078000],[-47.514004,7.558001,-0.228000],[-47.398003,7.624001,-0.228000],[-47.608002,7.506001,1.090000],[-47.818001,7.166000,2.380000],[-48.214001,6.516000,3.548000],[-48.142002,6.572001,3.580000],[-48.026001,6.630000,3.614000],[-48.264004,6.464000,3.516000],[-48.244003,4.106000,6.810000],[-48.454002,2.964000,7.542000],[-48.122002,2.984000,7.602000],[-47.912003,4.136000,6.864000],[-48.484001,4.072000,6.750000],[-48.694004,2.940000,7.478000],[-48.032001,5.132000,5.902000],[-48.276001,5.088000,5.850000],[-48.066002,5.968000,4.808000],[-47.824001,6.016000,4.850000],[-47.704002,5.168000,5.948000],[-47.494003,6.062000,4.890000],[-45.440002,7.450000,2.500000],[-45.648003,6.894001,3.780000],[-44.942001,6.898000,3.816000],[-44.736004,7.454000,2.540000],[-46.084003,7.430000,2.478000],[-46.294003,6.872000,3.758000],[-46.850002,6.838000,3.736000],[-46.640003,7.394001,2.464000],[-45.236004,7.804000,1.152000],[-45.876003,7.780000,1.140000],[-46.430000,7.742001,1.132000],[-46.220001,7.866000,-0.228000],[-45.666000,7.906000,-0.228000],[-45.030003,7.932000,-0.224000],[-44.544003,7.812000,1.184000],[-77.334007,4.198000,-7.428000],[-77.544006,5.246000,-6.500000],[-76.846001,5.256000,-6.514000],[-76.636002,4.206000,-7.444000],[-77.056007,6.166000,-5.436000],[-77.754005,6.152000,-5.424000],[-77.974007,4.184000,-7.402000],[-78.184006,5.228000,-6.478000],[-78.392006,6.132000,-5.406000],[-78.940002,6.102000,-5.378000],[-78.730003,5.202000,-6.446000],[-78.520004,4.162000,-7.366000],[-77.126007,3.028000,-8.178000],[-77.764000,3.018000,-8.150001],[-78.310005,3.004000,-8.112000],[-76.426003,3.036000,-8.196000],[-78.424004,-0.946000,-8.908000],[-78.632004,0.412000,-8.830001],[-78.314003,0.414000,-8.894000],[-78.106003,-0.952000,-8.974000],[-78.524002,1.736000,-8.594001],[-78.844002,1.724000,-8.530001],[-78.654007,-0.936000,-8.834001],[-78.864006,0.408000,-8.756001],[-79.072006,1.710000,-8.460000],[-79.230003,1.696000,-8.388000],[-79.020004,0.406000,-8.680000],[-78.810005,-0.926000,-8.758000],[-78.214005,-2.308000,-8.776000],[-78.444000,-2.286000,-8.704000],[-78.600006,-2.266000,-8.630000],[-77.896004,-2.326000,-8.840000],[-77.296005,-8.898001,-2.844000],[-77.236000,-8.976001,-2.866000],[-77.026001,-9.264001,-1.566000],[-77.088005,-9.184000,-1.554000],[-77.506004,-8.422000,-4.066000],[-77.446007,-8.496000,-4.100000],[-77.654007,-7.824000,-5.226000],[-77.716003,-7.754000,-5.184000],[-77.334007,-8.826000,-2.824000],[-77.544006,-8.354000,-4.036000],[-77.754005,-7.694000,-5.144000],[-77.786003,-7.640000,-5.110000],[-77.574005,-8.296000,-4.008000],[-77.366005,-8.764001,-2.806000],[-77.126007,-9.110001,-1.542000],[-77.158005,-9.046000,-1.534000],[-75.784004,-5.740000,6.374000],[-75.992004,-6.730000,5.564000],[-75.944000,-6.758000,5.586000],[-75.734001,-5.764000,6.400000],[-76.154007,-7.598001,4.626000],[-76.202003,-7.568000,4.608000],[-75.836006,-5.726000,6.358000],[-76.046005,-6.716001,5.550000],[-76.256004,-7.550000,4.596000],[-76.310005,-7.544000,4.592000],[-76.102005,-6.710001,5.546000],[-75.894005,-5.724000,6.354000],[-75.574005,-4.628000,7.030000],[-75.628006,-4.618000,7.012001],[-75.684006,-4.614000,7.006001],[-75.526001,-4.648000,7.056000],[-72.542000,4.106000,-7.266000],[-72.332001,2.964000,-8.000000],[-72.652000,2.984000,-8.060000],[-72.862007,4.136000,-7.322001],[-72.310005,4.072000,-7.208000],[-72.100006,2.940000,-7.934000],[-72.750000,5.132000,-6.358000],[-72.520004,5.088000,-6.308000],[-72.730003,5.968000,-5.264000],[-72.960007,6.016000,-5.306000],[-73.072006,5.168000,-6.406000],[-73.282005,6.062000,-5.346000],[-75.314003,7.456000,-2.944000],[-75.104004,6.896000,-4.228000],[-75.804001,6.912000,-4.238000],[-76.016006,7.472000,-2.950000],[-76.744003,7.476000,-2.952000],[-76.534004,6.916000,-4.240000],[-74.676003,7.430000,-2.936000],[-74.466003,6.872000,-4.214000],[-73.916000,6.838000,-4.194000],[-74.126007,7.394001,-2.922000],[-75.524002,7.808001,-1.600000],[-74.884003,7.780000,-1.598000],[-74.336006,7.742001,-1.590000],[-74.546005,7.866000,-0.228000],[-75.094002,7.906000,-0.228000],[-75.734001,7.932000,-0.228000],[-76.224007,7.824000,-1.604000],[-76.434006,7.950000,-0.228000],[-77.164001,7.956000,-0.228000],[-76.954002,7.830000,-1.606000],[-74.330002,3.876000,6.406000],[-74.278000,3.866000,6.390000],[-74.068001,4.830000,5.538000],[-74.122002,4.842000,5.550000],[-74.540001,2.798000,7.098001],[-74.486000,2.792000,7.080000],[-74.696007,1.628000,7.578001],[-74.750000,1.632000,7.596000],[-74.380005,3.890000,6.432000],[-74.590004,2.810000,7.124001],[-74.798004,1.638000,7.626000],[-74.842003,1.646000,7.670001],[-74.632004,2.824000,7.166000],[-74.422005,3.910000,6.466000],[-74.170006,4.860000,5.572000],[-74.214005,4.886000,5.604000],[-72.822006,7.044000,-2.792000],[-73.032005,7.376000,-1.524000],[-72.992004,7.318000,-1.514000],[-72.784004,6.988000,-2.772000],[-73.200005,7.434000,-0.228000],[-73.242004,7.494000,-0.228000],[-72.886002,7.104001,-2.814000],[-73.096001,7.440001,-1.536000],[-73.304001,7.558001,-0.228000],[-73.408005,7.624001,-0.228000],[-73.198006,7.506001,-1.548000],[-72.988007,7.166000,-2.838000],[-72.614006,6.516000,-4.004000],[-72.676003,6.572001,-4.038000],[-72.780006,6.630000,-4.072000],[-72.574005,6.464000,-3.974000],[-44.490002,-8.250000,-3.988000],[-45.690002,-0.884000,-8.410001],[-45.480003,-2.170000,-8.284000],[-45.538002,-2.162000,-8.266001],[-45.746002,-0.882000,-8.390000],[-45.328003,-3.420000,-7.956000],[-45.272003,-3.428000,-7.974000],[-45.636002,-0.888000,-8.440001],[-45.426003,-2.178000,-8.316000],[-45.218002,-3.442000,-8.004001],[-45.168003,-3.460000,-8.046000],[-45.378002,-2.190000,-8.360001],[-45.586002,-0.894000,-8.484000],[-45.900002,0.394000,-8.334001],[-45.846001,0.394000,-8.366000],[-45.796001,0.396000,-8.410001],[-45.956001,0.392000,-8.316000],[-47.168003,7.044000,-2.792000],[-47.218002,6.988000,-2.772000],[-47.428001,7.318000,-1.514000],[-47.378002,7.376000,-1.524000],[-46.958004,6.516000,-4.004000],[-47.008003,6.464000,-3.974000],[-46.800003,5.768000,-5.094000],[-46.750004,5.814000,-5.132000],[-47.094002,7.104001,-2.814000],[-46.884003,6.572001,-4.038000],[-46.676003,5.864000,-5.174000],[-46.562004,5.914001,-5.220000],[-46.770000,6.630000,-4.072000],[-46.980003,7.166000,-2.838000],[-47.304001,7.440001,-1.536000],[-47.188004,7.506001,-1.548000],[-47.406002,7.290000,2.426000],[-47.074001,7.346000,2.448000],[-46.864002,7.692000,1.124000],[-47.196003,7.634000,1.114000],[-46.984001,7.756001,-0.228000],[-46.654003,7.816000,-0.228000],[-47.614002,6.744000,3.682000],[-47.284000,6.794000,3.712000],[-47.646004,7.230000,2.404000],[-47.856003,6.688000,3.648000],[-47.438004,7.572001,1.102000],[-47.228001,7.692000,-0.228000],[-44.620003,7.456000,-2.944000],[-44.414001,6.898000,-4.228000],[-44.824001,7.808001,-1.600000],[-45.246002,7.430000,-2.936000],[-45.456001,7.780000,-1.598000],[-46.010002,7.742001,-1.590000],[-45.800003,7.394001,-2.922000],[-45.036003,6.872000,-4.214000],[-45.592003,6.838000,-4.194000],[-45.382004,6.102000,-5.378000],[-44.826004,6.132000,-5.406000],[-78.176003,7.456000,-2.944000],[-77.476006,7.472000,-2.950000],[-77.266006,6.912000,-4.238000],[-77.964005,6.896000,-4.228000],[-78.384003,7.808001,-1.600000],[-77.684006,7.824000,-1.604000],[-77.894005,7.950000,-0.228000],[-78.594002,7.932000,-0.228000],[-78.812004,7.430000,-2.936000],[-79.022003,7.780000,-1.598000],[-79.232002,7.906000,-0.228000],[-79.778008,7.866000,-0.228000],[-79.568001,7.742001,-1.590000],[-79.358002,7.394001,-2.922000],[-78.602005,6.872000,-4.214000],[-79.148003,6.838000,-4.194000],[-79.262001,4.106000,-7.266000],[-78.944000,4.136000,-7.322001],[-78.734001,2.984000,-8.060000],[-79.054001,2.964000,-8.000000],[-79.472000,5.132000,-6.358000],[-79.154007,5.168000,-6.406000],[-79.364006,6.062000,-5.346000],[-79.680000,6.016000,-5.306000],[-79.490005,4.072000,-7.208000],[-79.702003,5.088000,-6.308000],[-79.910004,5.968000,-5.264000],[-80.066002,5.914001,-5.220000],[-79.858002,5.044000,-6.254000],[-79.648003,4.036000,-7.144001],[-79.282005,2.940000,-7.934000],[-79.438004,2.914000,-7.866000],[-78.134003,-5.884000,-6.992000],[-78.344002,-4.744000,-7.664001],[-78.282005,-4.788000,-7.728000],[-78.074005,-5.936000,-7.052001],[-78.492004,-3.546000,-8.232000],[-78.552002,-3.514000,-8.162001],[-78.172005,-5.836000,-6.938000],[-78.382004,-4.706000,-7.604001],[-78.590004,-3.486000,-8.100000],[-78.620003,-3.460000,-8.046000],[-78.412003,-4.672000,-7.554000],[-78.202003,-5.794000,-6.892000],[-77.924004,-6.898000,-6.162000],[-77.962006,-6.842000,-6.114000],[-77.994003,-6.794000,-6.074000],[-77.864006,-6.960001,-6.214000],[-76.618004,-8.684000,2.324000],[-76.572006,-8.718000,2.334000],[-76.362007,-8.250000,3.532000],[-76.410004,-8.218000,3.516000],[-76.828003,-8.962001,1.064000],[-76.780006,-8.996000,1.070000],[-76.988007,-9.090000,-0.228000],[-77.038002,-9.054001,-0.228000],[-76.672005,-8.664001,2.320000],[-76.882004,-8.942000,1.062000],[-77.090004,-9.032001,-0.228000],[-77.146004,-9.026000,-0.228000],[-76.938004,-8.934000,1.062000],[-76.728004,-8.656000,2.316000],[-76.464005,-8.198000,3.508000],[-76.520004,-8.192000,3.506000],[-73.380005,7.290000,-2.884000],[-73.700005,7.346000,-2.904000],[-73.910004,7.692000,-1.580000],[-73.590004,7.634000,-1.570000],[-73.798004,7.756001,-0.228000],[-74.120003,7.816000,-0.228000],[-73.170006,6.744000,-4.138000],[-73.490005,6.794000,-4.168000],[-73.148003,7.230000,-2.862000],[-72.938004,6.688000,-4.106000],[-73.356003,7.572001,-1.560000],[-73.566002,7.692000,-0.228000],[-76.154007,7.456000,2.488000],[-76.854004,7.472000,2.494000],[-77.064003,6.912000,3.780000],[-76.364006,6.896000,3.772000],[-76.574005,6.152000,4.968000],[-77.274002,6.166000,4.978000],[-78.004005,6.170000,4.982000],[-77.794006,6.916000,3.784000],[-77.586006,7.476000,2.496000],[-75.944000,7.808001,1.144000],[-76.644005,7.824000,1.148000],[-77.374001,7.830000,1.148000],[-75.514000,7.430000,2.478000],[-75.304001,7.780000,1.140000],[-74.756004,7.742001,1.132000],[-74.966003,7.394001,2.464000],[-75.724007,6.872000,3.758000],[-75.176003,6.838000,3.736000],[-75.384003,6.102000,4.922000],[-75.934006,6.132000,4.948000],[-75.168007,-0.884000,7.952000],[-75.376007,-2.170000,7.828001],[-75.322006,-2.162000,7.810000],[-75.114006,-0.882000,7.934000],[-75.530006,-3.420000,7.498000],[-75.584007,-3.428000,7.518000],[-75.216003,-0.888000,7.984000],[-75.426003,-2.178000,7.860001],[-75.634003,-3.442000,7.546000],[-75.676003,-3.460000,7.590000],[-75.468002,-2.190000,7.904000],[-75.258003,-0.894000,8.028001],[-74.958000,0.394000,7.878000],[-75.008003,0.394000,7.910000],[-75.050003,0.396000,7.954000],[-74.904007,0.392000,7.860001],[-73.658005,7.044000,2.336000],[-73.620003,6.988000,2.316000],[-73.410004,7.318000,1.058000],[-73.450005,7.376000,1.068000],[-73.868004,6.516000,3.548000],[-73.828003,6.464000,3.516000],[-74.038002,5.768000,4.636000],[-74.078003,5.814000,4.676000],[-73.722000,7.104001,2.358000],[-73.932007,6.572001,3.580000],[-74.142006,5.864000,4.718000],[-74.246002,5.914001,4.762000],[-74.034004,6.630000,3.614000],[-73.826004,7.166000,2.380000],[-73.512001,7.440001,1.078000],[-73.616005,7.506001,1.090000],[-44.854004,-5.740000,-6.832000],[-44.910004,-5.726000,-6.816000],[-45.120003,-4.618000,-7.468000],[-45.062000,-4.628000,-7.486001],[-44.646004,-6.730000,-6.020000],[-44.702003,-6.716001,-6.008000],[-44.800003,-5.764000,-6.856000],[-44.590004,-6.758000,-6.042000],[-44.750004,-5.794000,-6.892000],[-45.008003,-4.648000,-7.514000],[-44.960003,-4.672000,-7.554000],[-46.330002,3.968000,-7.024000],[-46.122002,2.866000,-7.732000],[-46.172001,2.842000,-7.674000],[-46.382004,3.938000,-6.970000],[-45.964001,1.656000,-8.182000],[-45.914001,1.670000,-8.246000],[-46.256001,4.002000,-7.084000],[-46.048000,2.890000,-7.798000],[-45.838001,1.682000,-8.314000],[-45.724003,1.696000,-8.388000],[-45.934002,2.914000,-7.866000],[-46.142002,4.036000,-7.144001],[-46.540001,4.958000,-6.148000],[-46.466003,5.000000,-6.200000],[-46.350002,5.044000,-6.254000],[-46.592003,4.920000,-6.100000],[-46.566002,7.290000,-2.884000],[-46.776001,7.634000,-1.570000],[-46.446003,7.692000,-1.580000],[-46.236004,7.346000,-2.904000],[-46.808002,7.230000,-2.862000],[-47.018002,7.572001,-1.560000],[-46.358002,6.744000,-4.138000],[-46.600002,6.688000,-4.106000],[-46.390003,5.968000,-5.264000],[-46.148003,6.016000,-5.306000],[-46.026001,6.794000,-4.168000],[-45.816002,6.062000,-5.346000],[-44.402000,4.182000,-7.402000],[-44.616001,5.228000,-6.478000],[-45.170002,5.202000,-6.446000],[-44.960003,4.162000,-7.366000],[-44.744003,3.002000,-8.112000],[-44.520000,1.744000,-8.650001],[-79.014000,7.456000,2.488000],[-79.224007,6.896000,3.772000],[-78.524002,6.912000,3.780000],[-78.314003,7.472000,2.494000],[-78.734001,6.166000,4.978000],[-79.434006,6.152000,4.968000],[-79.652000,7.430000,2.478000],[-79.862007,6.872000,3.758000],[-80.070007,6.132000,4.948000],[-80.616005,6.102000,4.922000],[-80.408005,6.838000,3.736000],[-80.198006,7.394001,2.464000],[-78.804001,7.808001,1.144000],[-79.442001,7.780000,1.140000],[-79.988007,7.742001,1.132000],[-78.104004,7.824000,1.148000],[-80.102005,7.290000,-2.884000],[-80.310005,7.634000,-1.570000],[-79.992004,7.692000,-1.580000],[-79.782005,7.346000,-2.904000],[-80.202003,7.816000,-0.228000],[-80.520004,7.756001,-0.228000],[-80.328003,7.230000,-2.862000],[-80.538002,7.572001,-1.560000],[-80.748001,7.692000,-0.228000],[-80.904007,7.624001,-0.228000],[-80.694000,7.506001,-1.548000],[-80.484001,7.166000,-2.838000],[-79.892006,6.744000,-4.138000],[-80.120003,6.688000,-4.106000],[-80.276001,6.630000,-4.072000],[-79.572006,6.794000,-4.168000],[-78.972000,-0.908000,-8.610001],[-78.910004,-0.918000,-8.682000],[-78.700005,-2.244000,-8.554001],[-78.762001,-2.224000,-8.482000],[-79.180000,0.400000,-8.534000],[-79.120003,0.402000,-8.606000],[-79.328003,1.682000,-8.314000],[-79.390007,1.670000,-8.246000],[-79.008003,-0.900000,-8.542001],[-79.218002,0.398000,-8.468000],[-79.426003,1.656000,-8.182000],[-79.456001,1.646000,-8.126000],[-79.248001,0.396000,-8.410001],[-79.040001,-0.894000,-8.484000],[-78.800003,-2.206000,-8.416000],[-78.830002,-2.190000,-8.360001],[-77.456001,-8.684000,-2.782000],[-77.664001,-8.218000,-3.974000],[-77.616005,-8.250000,-3.988000],[-77.408005,-8.718000,-2.792000],[-77.826004,-7.598001,-5.084000],[-77.874001,-7.568000,-5.066000],[-77.508003,-8.664001,-2.776000],[-77.718002,-8.198000,-3.964000],[-77.926003,-7.550000,-5.054000],[-77.982002,-7.544000,-5.050000],[-77.774002,-8.192000,-3.962000],[-77.564003,-8.656000,-2.774000],[-77.246002,-8.962001,-1.522000],[-77.300003,-8.942000,-1.520000],[-77.356003,-8.934000,-1.518000],[-77.198006,-8.996000,-1.526000],[-76.002007,-5.740000,6.374000],[-75.948006,-5.726000,6.358000],[-75.740005,-4.618000,7.012001],[-75.794006,-4.628000,7.030000],[-76.212006,-6.730000,5.564000],[-76.158005,-6.716001,5.550000],[-76.368004,-7.550000,4.596000],[-76.422005,-7.568000,4.608000],[-76.052002,-5.764000,6.400000],[-76.262001,-6.758000,5.586000],[-76.470001,-7.598001,4.626000],[-76.514000,-7.640000,4.652000],[-76.304001,-6.794000,5.618000],[-76.096001,-5.794000,6.436000],[-75.844002,-4.648000,7.056000],[-75.886002,-4.672000,7.096000],[-74.218002,7.290000,2.426000],[-74.008003,7.634000,1.114000],[-74.330002,7.692000,1.124000],[-74.540001,7.346000,2.448000],[-73.986000,7.230000,2.404000],[-73.776001,7.572001,1.102000],[-74.428001,6.744000,3.682000],[-74.194000,6.688000,3.648000],[-74.404007,5.968000,4.808000],[-74.638000,6.016000,4.850000],[-74.748001,6.794000,3.712000],[-74.958000,6.062000,4.890000],[-76.992004,4.198000,6.972000],[-76.784004,5.246000,6.042000],[-77.484001,5.256000,6.056000],[-77.694000,4.206000,6.986001],[-78.424004,4.210000,6.992000],[-78.214005,5.260000,6.062000],[-76.354004,4.182000,6.946000],[-76.144005,5.228000,6.020000],[-75.594002,5.202000,5.990000],[-75.804001,4.162000,6.910000],[-77.202003,3.028000,7.722001],[-76.564003,3.018000,7.694000],[-76.014000,3.004000,7.654000],[-76.224007,1.748000,8.192000],[-76.772003,1.756000,8.234000],[-77.412003,1.762000,8.264000],[-77.904007,3.036000,7.738000],[-78.114006,1.766000,8.284000],[-78.844002,1.768000,8.288000],[-78.634003,3.038000,7.746000],[-74.496002,3.968000,6.568000],[-74.706001,2.866000,7.276000],[-74.666000,2.842000,7.216001],[-74.456001,3.938000,6.514000],[-74.874001,1.656000,7.724000],[-74.914001,1.670000,7.788001],[-74.560005,4.002000,6.626000],[-74.770004,2.890000,7.342000],[-74.978004,1.682000,7.858000],[-75.082001,1.696000,7.932000],[-74.872002,2.914000,7.410000],[-74.664001,4.036000,6.688000],[-74.286003,4.958000,5.692000],[-74.350006,5.000000,5.744000],[-74.454002,5.044000,5.796000],[-74.246002,4.920000,5.644000],[-45.494003,-0.908000,-8.610001],[-45.544003,-0.900000,-8.542001],[-45.754002,0.398000,-8.468000],[-45.704002,0.400000,-8.534000],[-45.286003,-2.224000,-8.482000],[-45.336002,-2.206000,-8.416000],[-45.126003,-3.486000,-8.100000],[-45.076004,-3.514000,-8.162001],[-45.420002,-0.918000,-8.682000],[-45.210003,-2.244000,-8.554001],[-45.002003,-3.546000,-8.232000],[-44.886002,-3.578000,-8.304001],[-45.096001,-2.266000,-8.630000],[-45.304001,-0.926000,-8.758000],[-45.628002,0.402000,-8.606000],[-45.514004,0.406000,-8.680000],[-45.728001,4.106000,-7.266000],[-45.396004,4.136000,-7.322001],[-45.184002,2.984000,-8.060000],[-45.516003,2.964000,-8.000000],[-45.306004,1.724000,-8.530001],[-44.968002,1.736000,-8.594001],[-45.938004,5.132000,-6.358000],[-45.606003,5.168000,-6.406000],[-45.972004,4.072000,-7.208000],[-46.182003,5.088000,-6.308000],[-45.762001,2.940000,-7.934000],[-45.552002,1.710000,-8.460000],[-79.854004,4.198000,6.972000],[-79.154007,4.206000,6.986001],[-78.944000,5.256000,6.056000],[-79.644005,5.246000,6.042000],[-80.064003,3.028000,7.722001],[-79.364006,3.036000,7.738000],[-79.574005,1.766000,8.284000],[-80.274002,1.762000,8.264000],[-80.492004,4.182000,6.946000],[-80.702003,3.018000,7.694000],[-80.910004,1.756000,8.234000],[-81.456001,1.748000,8.192000],[-81.248001,3.004000,7.654000],[-81.038002,4.162000,6.910000],[-80.280006,5.228000,6.020000],[-80.826004,5.202000,5.990000],[-80.938004,7.290000,2.426000],[-80.622002,7.346000,2.448000],[-80.412003,7.692000,1.124000],[-80.728004,7.634000,1.114000],[-81.150002,6.744000,3.682000],[-80.830002,6.794000,3.712000],[-81.040001,6.062000,4.890000],[-81.358002,6.016000,4.850000],[-81.168007,7.230000,2.404000],[-81.376007,6.688000,3.648000],[-81.586006,5.968000,4.808000],[-81.742004,5.914001,4.762000],[-81.532005,6.630000,3.614000],[-81.322006,7.166000,2.380000],[-80.958000,7.572001,1.102000],[-81.114006,7.506001,1.090000],[-79.808006,3.968000,-7.024000],[-80.016006,4.958000,-6.148000],[-79.956001,5.000000,-6.200000],[-79.748001,4.002000,-7.084000],[-80.166000,5.864000,-5.174000],[-80.226006,5.814000,-5.132000],[-79.844002,3.938000,-6.970000],[-80.054001,4.920000,-6.100000],[-80.264008,5.768000,-5.094000],[-80.294006,5.730000,-5.060000],[-80.084007,4.886000,-6.060000],[-79.876007,3.910000,-6.924000],[-79.600006,2.866000,-7.732000],[-79.636002,2.842000,-7.674000],[-79.666000,2.824000,-7.622000],[-79.538002,2.890000,-7.798000],[-78.290001,-5.740000,-6.832000],[-78.242004,-5.764000,-6.856000],[-78.034004,-6.758000,-6.042000],[-78.082001,-6.730000,-6.020000],[-78.500000,-4.628000,-7.486001],[-78.452003,-4.648000,-7.514000],[-78.662003,-3.442000,-8.004001],[-78.710007,-3.428000,-7.974000],[-78.344002,-5.726000,-6.816000],[-78.554001,-4.618000,-7.468000],[-78.762001,-3.420000,-7.956000],[-78.818001,-3.418000,-7.950000],[-78.610001,-4.614000,-7.464000],[-78.400002,-5.724000,-6.810000],[-78.136002,-6.716001,-6.008000],[-78.192001,-6.710001,-6.002000],[-76.840004,-8.684000,2.324000],[-77.048004,-8.962001,1.064000],[-76.994003,-8.942000,1.062000],[-76.784004,-8.664001,2.320000],[-77.202003,-9.032001,-0.228000],[-77.256004,-9.054001,-0.228000],[-76.888000,-8.718000,2.334000],[-77.098007,-8.996000,1.070000],[-77.308006,-9.090000,-0.228000],[-77.350006,-9.140000,-0.228000],[-77.140007,-9.046000,1.078000],[-76.932007,-8.764001,2.348000],[-76.630005,-8.218000,3.516000],[-76.680000,-8.250000,3.532000],[-76.722000,-8.296000,3.552000],[-76.576004,-8.198000,3.508000],[-75.056000,4.106000,6.810000],[-75.378006,4.136000,6.864000],[-75.588005,2.984000,7.602000],[-75.266006,2.964000,7.542000],[-75.476006,1.724000,8.074000],[-75.798004,1.736000,8.138000],[-74.846001,5.132000,5.902000],[-75.168007,5.168000,5.948000],[-74.824005,4.072000,6.750000],[-74.614006,5.088000,5.850000],[-75.032005,2.940000,7.478000],[-75.242004,1.710000,8.004001],[-77.832001,-0.970000,8.650001],[-78.532005,-0.972000,8.670000],[-78.742004,-2.368000,8.534000],[-78.042007,-2.362000,8.516001],[-78.252007,-3.730000,8.178000],[-78.952003,-3.736000,8.196000],[-79.684006,-3.740000,8.202001],[-79.474007,-2.370000,8.540000],[-79.264008,-0.972000,8.676001],[-77.622002,0.418000,8.570001],[-78.324005,0.418000,8.590000],[-79.054001,0.418000,8.596001],[-77.192001,-0.966000,8.618000],[-76.982002,0.416000,8.538000],[-76.434006,0.414000,8.494000],[-76.644005,-0.958000,8.574000],[-77.402000,-2.354000,8.484000],[-76.852005,-2.342000,8.440001],[-77.062004,-3.696000,8.106000],[-77.612007,-3.716000,8.148001],[-75.334007,-0.908000,8.152000],[-75.292000,-0.900000,8.086000],[-75.082001,0.398000,8.010000],[-75.124001,0.400000,8.078000],[-75.542000,-2.224000,8.026000],[-75.502007,-2.206000,7.958000],[-75.710007,-3.486000,7.644001],[-75.752007,-3.514000,7.706000],[-75.398003,-0.918000,8.226001],[-75.606003,-2.244000,8.098001],[-75.816002,-3.546000,7.776000],[-75.920006,-3.578000,7.846000],[-75.710007,-2.266000,8.172000],[-75.502007,-0.926000,8.302000],[-75.188004,0.402000,8.148001],[-75.292000,0.406000,8.224000],[-44.474003,-3.642000,-8.446000],[-44.504002,-4.876000,-7.864000],[-44.714001,-3.610000,-8.376000],[-44.676003,-4.832000,-7.796000],[-44.466003,-5.990000,-7.114000],[-44.658001,-5.884000,-6.992000],[-44.708004,-5.836000,-6.938000],[-44.582001,-5.936000,-7.052001],[-44.866001,-4.744000,-7.664001],[-44.792004,-4.788000,-7.728000],[-44.918003,-4.706000,-7.604001],[-44.884003,-0.946000,-8.908000],[-45.094002,0.410000,-8.830001],[-44.750004,0.410000,-8.896001],[-44.538002,-0.958000,-8.974000],[-45.134003,-0.936000,-8.834001],[-45.342003,0.408000,-8.756001],[-44.680000,-2.308000,-8.776000],[-44.924004,-2.286000,-8.704000],[-44.344002,-2.328000,-8.842000],[-80.692001,-0.970000,8.650001],[-80.902000,-2.362000,8.516001],[-80.202003,-2.368000,8.534000],[-79.992004,-0.972000,8.670000],[-80.414001,-3.736000,8.196000],[-81.112007,-3.730000,8.178000],[-81.330002,-0.966000,8.618000],[-81.540001,-2.354000,8.484000],[-81.750008,-3.716000,8.148001],[-82.296005,-3.696000,8.106000],[-82.084007,-2.342000,8.440001],[-81.876007,-0.958000,8.574000],[-80.482002,0.418000,8.570001],[-81.120003,0.416000,8.538000],[-81.666000,0.414000,8.494000],[-79.784004,0.418000,8.590000],[-81.776001,4.106000,6.810000],[-81.986008,2.964000,7.542000],[-81.670006,2.984000,7.602000],[-81.460007,4.136000,6.864000],[-81.880005,1.736000,8.138000],[-82.196007,1.724000,8.074000],[-82.006004,4.072000,6.750000],[-82.214005,2.940000,7.478000],[-82.424004,1.710000,8.004001],[-82.580002,1.696000,7.932000],[-82.370003,2.914000,7.410000],[-82.160004,4.036000,6.688000],[-81.568001,5.132000,5.902000],[-81.796005,5.088000,5.850000],[-81.952003,5.044000,5.796000],[-81.250008,5.168000,5.948000],[-80.644005,7.044000,-2.792000],[-80.586006,7.104001,-2.814000],[-80.376007,6.572001,-4.038000],[-80.436005,6.516000,-4.004000],[-80.854004,7.376000,-1.524000],[-80.794006,7.440001,-1.536000],[-81.004005,7.558001,-0.228000],[-81.064003,7.494000,-0.228000],[-80.682007,6.988000,-2.772000],[-80.892006,7.318000,-1.514000],[-81.100006,7.434000,-0.228000],[-81.130005,7.384000,-0.228000],[-80.922005,7.268000,-1.506000],[-80.712006,6.940001,-2.754000],[-80.472000,6.464000,-3.974000],[-80.502007,6.420000,-3.948000],[-79.128006,-0.884000,-8.410001],[-79.336006,0.394000,-8.334001],[-79.288002,0.394000,-8.366000],[-79.080002,-0.888000,-8.440001],[-79.498001,1.638000,-8.084001],[-79.546005,1.632000,-8.054001],[-79.180000,-0.882000,-8.390000],[-79.390007,0.392000,-8.316000],[-79.598007,1.628000,-8.036000],[-79.654007,1.628000,-8.030001],[-79.444000,0.392000,-8.310000],[-79.236000,-0.880000,-8.384001],[-78.918007,-2.170000,-8.284000],[-78.972000,-2.162000,-8.266001],[-79.026001,-2.162000,-8.260000],[-78.870003,-2.178000,-8.316000],[-77.674004,-8.684000,-2.782000],[-77.620003,-8.664001,-2.776000],[-77.412003,-8.942000,-1.520000],[-77.466003,-8.962001,-1.522000],[-77.884003,-8.218000,-3.974000],[-77.830002,-8.198000,-3.964000],[-78.038002,-7.550000,-5.054000],[-78.094002,-7.568000,-5.066000],[-77.724007,-8.718000,-2.792000],[-77.934006,-8.250000,-3.988000],[-78.142006,-7.598001,-5.084000],[-78.186005,-7.640000,-5.110000],[-77.978004,-8.296000,-4.008000],[-77.768005,-8.764001,-2.806000],[-77.516006,-8.996000,-1.526000],[-77.558006,-9.046000,-1.534000],[-76.170006,-5.884000,6.536000],[-76.378006,-6.898000,5.706000],[-76.338005,-6.842000,5.658000],[-76.130005,-5.836000,6.482000],[-76.548004,-7.694000,4.686000],[-76.588005,-7.754000,4.726000],[-76.234001,-5.936000,6.594000],[-76.444000,-6.960001,5.758000],[-76.652000,-7.824000,4.770000],[-76.758003,-7.894001,4.814000],[-76.548004,-7.022000,5.812000],[-76.338005,-5.990000,6.656000],[-75.960007,-4.744000,7.206000],[-76.026001,-4.788000,7.270000],[-76.130005,-4.832000,7.338000],[-75.920006,-4.706000,7.148000],[-75.894005,-0.946000,8.450001],[-75.686005,0.412000,8.372001],[-76.006004,0.414000,8.438001],[-76.216003,-0.952000,8.518001],[-75.662003,-0.936000,8.378000],[-75.452003,0.408000,8.300000],[-76.104004,-2.308000,8.318001],[-75.872002,-2.286000,8.246000],[-76.080002,-3.610000,7.920001],[-76.314003,-3.642000,7.988000],[-76.426003,-2.326000,8.384001],[-76.636002,-3.672000,8.052000],[-78.672005,-6.240000,6.938000],[-78.462006,-5.032000,7.648000],[-79.162003,-5.044000,7.664001],[-79.372002,-6.254000,6.952000],[-80.102005,-6.258000,6.958000],[-79.894005,-5.048000,7.670001],[-78.032005,-6.218000,6.912000],[-77.822006,-5.014000,7.620000],[-77.274002,-4.988000,7.580000],[-77.484001,-6.184000,6.876000],[-78.882004,-7.314000,6.058000],[-78.242004,-7.288001,6.036000],[-77.692001,-7.250000,6.004000],[-77.902000,-8.152000,4.976000],[-78.450005,-8.192000,5.002000],[-79.090004,-8.222000,5.020000],[-79.582001,-7.330000,6.072001],[-79.792007,-8.240001,5.032000],[-80.522003,-8.246000,5.036000],[-80.312004,-7.336000,6.076000],[-81.532005,-6.240000,6.938000],[-80.834007,-6.254000,6.952000],[-80.624001,-5.044000,7.664001],[-81.322006,-5.032000,7.648000],[-81.742004,-7.314000,6.058000],[-81.044006,-7.330000,6.072001],[-81.252007,-8.240001,5.032000],[-81.952003,-8.222000,5.020000],[-82.170006,-6.218000,6.912000],[-82.380005,-7.288001,6.036000],[-82.590004,-8.192000,5.002000],[-83.134003,-8.152000,4.976000],[-82.924004,-7.250000,6.004000],[-82.716003,-6.184000,6.876000],[-81.960007,-5.014000,7.620000],[-82.506004,-4.988000,7.580000],[-82.616005,-0.946000,8.450001],[-82.298004,-0.952000,8.518001],[-82.088005,0.414000,8.438001],[-82.406006,0.412000,8.372001],[-82.826004,-2.308000,8.318001],[-82.508003,-2.326000,8.384001],[-82.718002,-3.672000,8.052000],[-83.034004,-3.642000,7.988000],[-82.844002,-0.936000,8.378000],[-83.052002,-2.286000,8.246000],[-83.262001,-3.610000,7.920001],[-83.418007,-3.578000,7.846000],[-83.208000,-2.266000,8.172000],[-82.998001,-0.926000,8.302000],[-82.634003,0.408000,8.300000],[-82.788002,0.406000,8.224000],[-81.482002,7.044000,2.336000],[-81.692001,6.516000,3.548000],[-81.630005,6.572001,3.580000],[-81.422005,7.104001,2.358000],[-81.840004,5.864000,4.718000],[-81.900002,5.814000,4.676000],[-81.518005,6.988000,2.316000],[-81.728004,6.464000,3.516000],[-81.936005,5.768000,4.636000],[-81.966003,5.730000,4.602000],[-81.756004,6.420000,3.492000],[-81.548004,6.940001,2.298000],[-81.272003,7.376000,1.068000],[-81.308006,7.318000,1.058000],[-81.338005,7.268000,1.048000],[-81.214005,7.440001,1.078000],[-79.962006,3.876000,-6.862000],[-79.914001,3.890000,-6.888000],[-79.706001,2.810000,-7.582000],[-79.754005,2.798000,-7.554000],[-80.172005,4.842000,-6.008000],[-80.124001,4.860000,-6.030000],[-80.334007,5.700000,-5.034000],[-80.382004,5.678000,-5.016000],[-80.016006,3.866000,-6.846000],[-80.226006,4.830000,-5.994000],[-80.434006,5.664000,-5.004000],[-80.490005,5.660000,-5.000000],[-80.280006,4.828000,-5.988000],[-80.072006,3.864000,-6.842000],[-79.806007,2.792000,-7.536000],[-79.864006,2.792000,-7.532001],[-78.510002,-5.740000,-6.832000],[-78.720001,-4.628000,-7.486001],[-78.666000,-4.618000,-7.468000],[-78.456001,-5.726000,-6.816000],[-78.874001,-3.420000,-7.956000],[-78.928001,-3.428000,-7.974000],[-78.562004,-5.764000,-6.856000],[-78.770004,-4.648000,-7.514000],[-78.978004,-3.442000,-8.004001],[-79.022003,-3.460000,-8.046000],[-78.812004,-4.672000,-7.554000],[-78.604004,-5.794000,-6.892000],[-78.302002,-6.730000,-6.020000],[-78.352005,-6.758000,-6.042000],[-78.396004,-6.794000,-6.074000],[-78.248001,-6.716001,-6.008000],[-77.006004,-8.898001,2.388000],[-76.966003,-8.826000,2.366000],[-76.756004,-8.354000,3.578000],[-76.798004,-8.422000,3.608000],[-77.216003,-9.184000,1.096000],[-77.174004,-9.110001,1.086000],[-77.384003,-9.204000,-0.228000],[-77.426003,-9.278001,-0.228000],[-77.072006,-8.976001,2.410000],[-77.280006,-9.264001,1.108000],[-77.490005,-9.360001,-0.228000],[-77.596001,-9.446000,-0.228000],[-77.386002,-9.348001,1.120000],[-77.176003,-9.058001,2.434000],[-76.862007,-8.496000,3.642000],[-76.968002,-8.574000,3.676000],[-76.734001,-6.096000,6.776000],[-77.056007,-6.144000,6.830000],[-77.264000,-7.204000,5.964000],[-76.942001,-7.148000,5.918000],[-77.152000,-8.036000,4.902000],[-77.474007,-8.096001,4.942000],[-76.524002,-4.916000,7.470000],[-76.846001,-4.956000,7.530000],[-76.500000,-6.046000,6.718000],[-76.290001,-4.876000,7.406000],[-76.710007,-7.086000,5.864000],[-76.918007,-7.966001,4.860000],[-79.512001,-9.432000,2.544000],[-80.212006,-9.454000,2.548000],[-80.422005,-9.756001,1.178000],[-79.722000,-9.734000,1.176000],[-79.930000,-9.836000,-0.228000],[-80.632004,-9.858001,-0.228000],[-81.362007,-9.864000,-0.228000],[-81.152000,-9.764001,1.180000],[-80.942001,-9.460000,2.550000],[-79.300003,-8.928000,3.836000],[-80.002007,-8.948000,3.846000],[-80.732002,-8.954000,3.848000],[-78.870003,-9.398001,2.534000],[-78.660004,-8.896001,3.822000],[-78.112007,-8.850000,3.802000],[-78.320007,-9.352000,2.520000],[-79.080002,-9.700001,1.170000],[-78.532005,-9.650001,1.164000],[-78.742004,-9.752001,-0.228000],[-79.290001,-9.800000,-0.228000],[-82.372002,-9.432000,2.544000],[-82.580002,-9.734000,1.176000],[-81.882004,-9.756001,1.178000],[-81.672005,-9.454000,2.548000],[-82.092003,-9.858001,-0.228000],[-82.790001,-9.836000,-0.228000],[-83.008003,-9.398001,2.534000],[-83.218002,-9.700001,1.170000],[-83.428001,-9.800000,-0.228000],[-83.974007,-9.752001,-0.228000],[-83.764008,-9.650001,1.164000],[-83.554001,-9.352000,2.520000],[-82.162003,-8.928000,3.836000],[-82.798004,-8.896001,3.822000],[-83.344002,-8.850000,3.802000],[-81.462006,-8.948000,3.846000],[-83.454002,-6.096000,6.776000],[-83.664001,-7.148000,5.918000],[-83.346001,-7.204000,5.964000],[-83.138000,-6.144000,6.830000],[-83.556007,-8.096001,4.942000],[-83.874001,-8.036000,4.902000],[-83.682007,-6.046000,6.718000],[-83.890007,-7.086000,5.864000],[-84.100006,-7.966001,4.860000],[-84.256004,-7.894001,4.814000],[-84.044006,-7.022000,5.812000],[-83.836006,-5.990000,6.656000],[-83.244003,-4.916000,7.470000],[-83.472008,-4.876000,7.406000],[-83.626007,-4.832000,7.338000],[-82.928001,-4.956000,7.530000],[-82.318001,3.968000,6.568000],[-82.260002,4.002000,6.626000],[-82.050003,5.000000,5.744000],[-82.108002,4.958000,5.692000],[-82.528008,2.866000,7.276000],[-82.468002,2.890000,7.342000],[-82.678001,1.682000,7.858000],[-82.736008,1.670000,7.788001],[-82.354004,3.938000,6.514000],[-82.564003,2.842000,7.216001],[-82.774002,1.656000,7.724000],[-82.802002,1.646000,7.670001],[-82.594002,2.824000,7.166000],[-82.384003,3.910000,6.466000],[-82.146004,4.920000,5.644000],[-82.176003,4.886000,5.604000],[-80.800003,6.878000,-2.730000],[-81.008003,7.202000,-1.494000],[-80.960007,7.230000,-1.498000],[-80.752007,6.904000,-2.740000],[-81.170006,7.346000,-0.228000],[-81.216003,7.318000,-0.228000],[-80.852005,6.862000,-2.726000],[-81.060005,7.186000,-1.490000],[-81.270004,7.300000,-0.228000],[-81.116005,7.180000,-1.490000],[-81.326004,7.294000,-0.228000],[-80.908005,6.858000,-2.722000],[-80.590004,6.362000,-3.914000],[-80.644005,6.348001,-3.906000],[-80.698006,6.344000,-3.902000],[-80.542007,6.386000,-3.928000],[-79.346001,-0.884000,-8.410001],[-79.292007,-0.882000,-8.390000],[-79.084007,-2.162000,-8.266001],[-79.138000,-2.170000,-8.284000],[-79.556007,0.394000,-8.334001],[-79.502007,0.392000,-8.316000],[-79.710007,1.628000,-8.036000],[-79.766006,1.632000,-8.054001],[-79.396004,-0.888000,-8.440001],[-79.606003,0.394000,-8.366000],[-79.816002,1.638000,-8.084001],[-79.858002,1.646000,-8.126000],[-79.650002,0.396000,-8.410001],[-79.440002,-0.894000,-8.484000],[-79.188004,-2.178000,-8.316000],[-79.232002,-2.190000,-8.360001],[-77.844002,-8.898001,-2.844000],[-78.054001,-8.422000,-4.066000],[-78.012001,-8.354000,-4.036000],[-77.802002,-8.826000,-2.824000],[-78.220001,-7.694000,-5.144000],[-78.262001,-7.754000,-5.184000],[-77.910004,-8.976001,-2.866000],[-78.118004,-8.496000,-4.100000],[-78.328003,-7.824000,-5.226000],[-78.432007,-7.894001,-5.272000],[-78.224007,-8.574000,-4.134000],[-78.014000,-9.058001,-2.890000],[-77.634003,-9.184000,-1.554000],[-77.700005,-9.264001,-1.566000],[-77.806007,-9.348001,-1.576000],[-77.592003,-9.110001,-1.542000],[-77.572006,-9.218000,2.480000],[-77.362007,-8.724000,3.744000],[-77.684006,-8.792001,3.776000],[-77.894005,-9.290001,2.502000],[-77.338005,-9.140000,2.458000],[-77.128006,-8.650001,3.712000],[-77.782005,-9.514001,1.144000],[-77.548004,-9.432000,1.132000],[-77.756004,-9.532001,-0.228000],[-77.990005,-9.612000,-0.228000],[-78.104004,-9.588000,1.154000],[-78.314003,-9.688001,-0.228000],[-80.350006,-9.432000,-3.000000],[-80.140007,-9.734000,-1.632000],[-80.840004,-9.756001,-1.634000],[-81.050003,-9.454000,-3.006000],[-81.782005,-9.460000,-3.008000],[-81.572006,-9.764001,-1.636000],[-79.710007,-9.398001,-2.990000],[-79.500000,-9.700001,-1.628000],[-78.952003,-9.650001,-1.620000],[-79.160004,-9.352000,-2.976000],[-80.560005,-8.928000,-4.292000],[-79.920006,-8.896001,-4.280000],[-79.370003,-8.850000,-4.260000],[-79.580002,-8.152000,-5.432000],[-80.130005,-8.192000,-5.460000],[-80.770004,-8.222000,-5.478000],[-81.260002,-8.948000,-4.302000],[-81.472000,-8.240001,-5.490000],[-82.202003,-8.246000,-5.494000],[-81.992004,-8.954000,-4.306000],[-83.210007,-9.432000,-3.000000],[-82.512001,-9.454000,-3.006000],[-82.302002,-9.756001,-1.634000],[-83.000008,-9.734000,-1.632000],[-83.422005,-8.928000,-4.292000],[-82.722000,-8.948000,-4.302000],[-82.932007,-8.240001,-5.490000],[-83.630005,-8.222000,-5.478000],[-83.848007,-9.398001,-2.990000],[-84.058006,-8.896001,-4.280000],[-84.268005,-8.192000,-5.460000],[-84.812004,-8.152000,-5.432000],[-84.602005,-8.850000,-4.260000],[-84.392006,-9.352000,-2.976000],[-83.638000,-9.700001,-1.628000],[-84.184006,-9.650001,-1.620000],[-84.292007,-9.218000,2.480000],[-83.976006,-9.290001,2.502000],[-83.766006,-8.792001,3.776000],[-84.082001,-8.724000,3.744000],[-84.502007,-9.514001,1.144000],[-84.186005,-9.588000,1.154000],[-84.396004,-9.688001,-0.228000],[-84.712006,-9.612000,-0.228000],[-84.520004,-9.140000,2.458000],[-84.730003,-9.432000,1.132000],[-84.938004,-9.532001,-0.228000],[-85.092003,-9.446000,-0.228000],[-84.882004,-9.348001,1.120000],[-84.674004,-9.058001,2.434000],[-84.310005,-8.650001,3.712000],[-84.464005,-8.574000,3.676000],[-83.156006,-0.908000,8.152000],[-83.364006,-2.224000,8.026000],[-83.306007,-2.244000,8.098001],[-83.096001,-0.918000,8.226001],[-83.516006,-3.546000,7.776000],[-83.574005,-3.514000,7.706000],[-83.190002,-0.900000,8.086000],[-83.400002,-2.206000,7.958000],[-83.610001,-3.486000,7.644001],[-83.638000,-3.460000,7.590000],[-83.430000,-2.190000,7.904000],[-83.220001,-0.894000,8.028001],[-82.946007,0.400000,8.078000],[-82.982002,0.398000,8.010000],[-83.010002,0.396000,7.954000],[-82.888000,0.402000,8.148001],[-81.634003,6.878000,2.274000],[-81.588005,6.904000,2.284000],[-81.380005,7.230000,1.042000],[-81.426003,7.202000,1.036000],[-81.844002,6.362000,3.458000],[-81.796005,6.386000,3.472000],[-82.006004,5.700000,4.578000],[-82.054001,5.678000,4.558000],[-81.688004,6.862000,2.268000],[-81.896004,6.348001,3.448000],[-82.106003,5.664000,4.548000],[-82.162003,5.660000,4.544000],[-81.952003,6.344000,3.446000],[-81.744003,6.858000,2.266000],[-81.478004,7.186000,1.034000],[-81.534004,7.180000,1.032000],[-80.182007,3.876000,-6.862000],[-80.392006,4.842000,-6.008000],[-80.338005,4.830000,-5.994000],[-80.128006,3.866000,-6.846000],[-80.546005,5.664000,-5.004000],[-80.600006,5.678000,-5.016000],[-80.234001,3.890000,-6.888000],[-80.442001,4.860000,-6.030000],[-80.650002,5.700000,-5.034000],[-80.694000,5.730000,-5.060000],[-80.486000,4.886000,-6.060000],[-80.278008,3.910000,-6.924000],[-79.974007,2.798000,-7.554000],[-80.024002,2.810000,-7.582000],[-80.068001,2.824000,-7.622000],[-79.918007,2.792000,-7.536000],[-78.680000,-5.884000,-6.992000],[-78.640007,-5.836000,-6.938000],[-78.430000,-6.842000,-6.114000],[-78.472000,-6.898000,-6.162000],[-78.890007,-4.744000,-7.664001],[-78.848007,-4.706000,-7.604001],[-79.056007,-3.486000,-8.100000],[-79.100006,-3.514000,-8.162001],[-78.746002,-5.936000,-7.052001],[-78.956001,-4.788000,-7.728000],[-79.166000,-3.546000,-8.232000],[-79.270004,-3.578000,-8.304001],[-79.060005,-4.832000,-7.796000],[-78.852005,-5.990000,-7.114000],[-78.538002,-6.960001,-6.214000],[-78.644005,-7.022000,-6.268000],[-78.410004,-9.218000,-2.936000],[-78.732002,-9.290001,-2.958000],[-78.942001,-8.792001,-4.232000],[-78.620003,-8.724000,-4.202000],[-78.830002,-8.036000,-5.360000],[-79.152000,-8.096001,-5.398000],[-78.200005,-9.514001,-1.600000],[-78.522003,-9.588000,-1.610000],[-78.176003,-9.140000,-2.914000],[-77.966003,-9.432000,-1.590000],[-78.386002,-8.650001,-4.168000],[-78.596001,-7.966001,-5.316000],[-81.190002,-6.240000,-7.394001],[-81.890007,-6.254000,-7.410000],[-82.100006,-5.044000,-8.122001],[-81.400002,-5.032000,-8.104000],[-81.610001,-3.730000,-8.634001],[-82.310005,-3.736000,-8.654000],[-83.042007,-3.740000,-8.658000],[-82.830002,-5.048000,-8.128000],[-82.620003,-6.258000,-7.416000],[-80.980003,-7.314000,-6.514000],[-81.682007,-7.330000,-6.528000],[-82.410004,-7.336000,-6.534000],[-80.548004,-6.218000,-7.368001],[-80.338005,-7.288001,-6.492000],[-79.790001,-7.250000,-6.460001],[-80.000000,-6.184000,-7.334000],[-80.760002,-5.014000,-8.078000],[-80.210007,-4.988000,-8.036000],[-80.420006,-3.696000,-8.562000],[-80.970001,-3.716000,-8.604000],[-84.050003,-6.240000,-7.394001],[-84.260002,-5.032000,-8.104000],[-83.560005,-5.044000,-8.122001],[-83.350006,-6.254000,-7.410000],[-83.770004,-3.736000,-8.654000],[-84.470001,-3.730000,-8.634001],[-84.686005,-6.218000,-7.368001],[-84.896004,-5.014000,-8.078000],[-85.106003,-3.716000,-8.604000],[-85.652000,-3.696000,-8.562000],[-85.442001,-4.988000,-8.036000],[-85.232002,-6.184000,-7.334000],[-83.840004,-7.314000,-6.514000],[-84.476006,-7.288001,-6.492000],[-85.022003,-7.250000,-6.460001],[-83.142006,-7.330000,-6.528000],[-85.130005,-9.218000,-2.936000],[-85.340004,-8.724000,-4.202000],[-85.024002,-8.792001,-4.232000],[-84.814003,-9.290001,-2.958000],[-85.234001,-8.096001,-5.398000],[-85.550003,-8.036000,-5.360000],[-85.358002,-9.140000,-2.914000],[-85.568001,-8.650001,-4.168000],[-85.776001,-7.966001,-5.316000],[-85.930000,-7.894001,-5.272000],[-85.720001,-8.574000,-4.134000],[-85.510002,-9.058001,-2.890000],[-84.922005,-9.514001,-1.600000],[-85.148003,-9.432000,-1.590000],[-85.302002,-9.348001,-1.576000],[-84.604004,-9.588000,-1.610000],[-83.992004,-5.884000,6.536000],[-83.934006,-5.936000,6.594000],[-83.724007,-4.788000,7.270000],[-83.784004,-4.744000,7.206000],[-84.202003,-6.898000,5.706000],[-84.144005,-6.960001,5.758000],[-84.352005,-7.824000,4.770000],[-84.412003,-7.754000,4.726000],[-84.028008,-5.836000,6.482000],[-84.238007,-6.842000,5.658000],[-84.446007,-7.694000,4.686000],[-84.476006,-7.640000,4.652000],[-84.266006,-6.794000,5.618000],[-84.056007,-5.794000,6.436000],[-83.818001,-4.706000,7.148000],[-83.848007,-4.672000,7.096000],[-82.472000,3.876000,6.406000],[-82.680000,2.798000,7.098001],[-82.632004,2.810000,7.124001],[-82.424004,3.890000,6.432000],[-82.842003,1.638000,7.626000],[-82.888000,1.632000,7.596000],[-82.524002,3.866000,6.390000],[-82.732002,2.792000,7.080000],[-82.942001,1.628000,7.578001],[-82.998001,1.628000,7.572001],[-82.788002,2.792000,7.074000],[-82.580002,3.864000,6.386000],[-82.262001,4.842000,5.550000],[-82.316002,4.830000,5.538000],[-82.370003,4.828000,5.532000],[-82.214005,4.860000,5.572000],[-81.018005,6.878000,-2.730000],[-80.964005,6.862000,-2.726000],[-80.756004,6.348001,-3.906000],[-80.810005,6.362000,-3.914000],[-81.228004,7.202000,-1.494000],[-81.172005,7.186000,-1.490000],[-81.382004,7.300000,-0.228000],[-81.438004,7.318000,-0.228000],[-81.068001,6.904000,-2.740000],[-81.278008,7.230000,-1.498000],[-81.488007,7.346000,-0.228000],[-81.532005,7.384000,-0.228000],[-81.322006,7.268000,-1.506000],[-81.112007,6.940001,-2.754000],[-80.860001,6.386000,-3.928000],[-80.904007,6.420000,-3.948000],[-79.518005,-0.908000,-8.610001],[-79.726006,0.400000,-8.534000],[-79.684006,0.398000,-8.468000],[-79.476006,-0.900000,-8.542001],[-79.894005,1.656000,-8.182000],[-79.936005,1.670000,-8.246000],[-79.584007,-0.918000,-8.682000],[-79.792007,0.402000,-8.606000],[-80.002007,1.682000,-8.314000],[-80.108002,1.696000,-8.388000],[-79.898003,0.406000,-8.680000],[-79.690002,-0.926000,-8.758000],[-79.308006,-2.224000,-8.482000],[-79.374001,-2.244000,-8.554001],[-79.480003,-2.266000,-8.630000],[-79.266006,-2.206000,-8.416000],[-79.248001,-6.096000,-7.232000],[-79.038002,-7.148000,-6.374000],[-79.362007,-7.204000,-6.420000],[-79.572006,-6.144000,-7.288001],[-79.014000,-6.046000,-7.174000],[-78.804001,-7.086000,-6.322001],[-79.456001,-4.916000,-7.928000],[-79.222000,-4.876000,-7.864000],[-79.434006,-3.610000,-8.376000],[-79.668007,-3.642000,-8.446000],[-79.780006,-4.956000,-7.986001],[-79.990005,-3.672000,-8.508000],[-82.028008,-0.970000,-9.108001],[-81.820007,-2.362000,-8.972000],[-82.520004,-2.368000,-8.992001],[-82.730003,-0.972000,-9.126000],[-83.462006,-0.972000,-9.132000],[-83.252007,-2.370000,-8.998000],[-81.388000,-0.966000,-9.076000],[-81.178001,-2.354000,-8.942000],[-80.628006,-2.342000,-8.898001],[-80.838005,-0.958000,-9.030001],[-82.238007,0.418000,-9.026000],[-81.598007,0.416000,-8.996000],[-81.048004,0.414000,-8.952001],[-81.258003,1.748000,-8.648001],[-81.808006,1.756000,-8.692000],[-82.448006,1.762000,-8.722000],[-82.940002,0.418000,-9.046000],[-83.150002,1.766000,-8.740001],[-83.880005,1.768000,-8.746000],[-83.670006,0.418000,-9.052000],[-84.890007,-0.970000,-9.108001],[-84.190002,-0.972000,-9.126000],[-83.980003,-2.368000,-8.992001],[-84.680000,-2.362000,-8.972000],[-85.100006,0.418000,-9.026000],[-84.402000,0.418000,-9.046000],[-84.610001,1.766000,-8.740001],[-85.310005,1.762000,-8.722000],[-85.526001,-0.966000,-9.076000],[-85.736008,0.416000,-8.996000],[-85.946007,1.756000,-8.692000],[-86.490005,1.748000,-8.648001],[-86.280006,0.414000,-8.952001],[-86.070007,-0.958000,-9.030001],[-85.316002,-2.354000,-8.942000],[-85.860001,-2.342000,-8.898001],[-85.970001,-6.096000,-7.232000],[-85.654007,-6.144000,-7.288001],[-85.444000,-7.204000,-6.420000],[-85.760002,-7.148000,-6.374000],[-86.178001,-4.916000,-7.928000],[-85.862007,-4.956000,-7.986001],[-86.072006,-3.672000,-8.508000],[-86.388000,-3.642000,-8.446000],[-86.194008,-6.046000,-7.174000],[-86.406006,-4.876000,-7.864000],[-86.614006,-3.610000,-8.376000],[-86.768005,-3.578000,-8.304001],[-86.558006,-4.832000,-7.796000],[-86.348007,-5.990000,-7.114000],[-85.986008,-7.086000,-6.322001],[-86.140007,-7.022000,-6.268000],[-84.828003,-8.898001,2.388000],[-85.038002,-9.184000,1.096000],[-84.980003,-9.264001,1.108000],[-84.770004,-8.976001,2.410000],[-85.190002,-9.360001,-0.228000],[-85.248001,-9.278001,-0.228000],[-84.864006,-8.826000,2.366000],[-85.074005,-9.110001,1.086000],[-85.282005,-9.204000,-0.228000],[-85.312004,-9.140000,-0.228000],[-85.102005,-9.046000,1.078000],[-84.892006,-8.764001,2.348000],[-84.620003,-8.422000,3.608000],[-84.656006,-8.354000,3.578000],[-84.684006,-8.296000,3.552000],[-84.562004,-8.496000,3.642000],[-83.306007,-0.884000,7.952000],[-83.260002,-0.888000,7.984000],[-83.052002,0.394000,7.910000],[-83.098007,0.394000,7.878000],[-83.516006,-2.170000,7.828001],[-83.468002,-2.178000,7.860001],[-83.678001,-3.442000,7.546000],[-83.726006,-3.428000,7.518000],[-83.360001,-0.882000,7.934000],[-83.568001,-2.162000,7.810000],[-83.778008,-3.420000,7.498000],[-83.834007,-3.418000,7.492001],[-83.624001,-2.162000,7.802001],[-83.414001,-0.880000,7.926001],[-83.150002,0.392000,7.860001],[-83.206001,0.392000,7.854001],[-81.854004,6.878000,2.274000],[-82.064003,6.362000,3.458000],[-82.008003,6.348001,3.448000],[-81.800003,6.862000,2.268000],[-82.218002,5.664000,4.548000],[-82.272003,5.678000,4.558000],[-81.906006,6.904000,2.284000],[-82.114006,6.386000,3.472000],[-82.322006,5.700000,4.578000],[-82.368004,5.730000,4.602000],[-82.158005,6.420000,3.492000],[-81.950005,6.940001,2.298000],[-81.646004,7.202000,1.036000],[-81.696007,7.230000,1.042000],[-81.740005,7.268000,1.048000],[-81.590004,7.186000,1.034000],[-80.354004,3.968000,-7.024000],[-80.312004,3.938000,-6.970000],[-80.102005,2.842000,-7.674000],[-80.146004,2.866000,-7.732000],[-80.564003,4.958000,-6.148000],[-80.522003,4.920000,-6.100000],[-80.730003,5.768000,-5.094000],[-80.772003,5.814000,-5.132000],[-80.420006,4.002000,-7.084000],[-80.630005,5.000000,-6.200000],[-80.840004,5.864000,-5.174000],[-80.946007,5.914001,-5.220000],[-80.736000,5.044000,-6.254000],[-80.528008,4.036000,-7.144001],[-80.212006,2.890000,-7.798000],[-80.318001,2.914000,-7.866000],[-80.086006,-0.946000,-8.908000],[-80.410004,-0.952000,-8.974000],[-80.620003,0.414000,-8.894000],[-80.296005,0.412000,-8.830001],[-80.504005,1.724000,-8.530001],[-80.830002,1.736000,-8.594001],[-79.878006,-2.308000,-8.776000],[-80.200005,-2.326000,-8.840000],[-79.852005,-0.936000,-8.834001],[-79.642006,-2.286000,-8.704000],[-80.060005,0.408000,-8.756001],[-80.270004,1.710000,-8.460000],[-82.868004,4.198000,-7.428000],[-83.570007,4.206000,-7.444000],[-83.780006,5.256000,-6.514000],[-83.078003,5.246000,-6.500000],[-83.288002,6.152000,-5.424000],[-83.990005,6.166000,-5.436000],[-84.720001,6.170000,-5.440000],[-84.510002,5.260000,-6.518000],[-84.300003,4.210000,-7.450000],[-82.658005,3.028000,-8.178000],[-83.360001,3.036000,-8.196000],[-84.090004,3.038000,-8.202001],[-82.228004,4.184000,-7.402000],[-82.018005,3.018000,-8.150001],[-81.468002,3.004000,-8.112000],[-81.678001,4.162000,-7.366000],[-82.438004,5.228000,-6.478000],[-81.888000,5.202000,-6.446000],[-82.096001,6.102000,-5.378000],[-82.648003,6.132000,-5.406000],[-85.728004,4.198000,-7.428000],[-85.938004,5.246000,-6.500000],[-85.240005,5.256000,-6.514000],[-85.030006,4.206000,-7.444000],[-85.450005,6.166000,-5.436000],[-86.148003,6.152000,-5.424000],[-86.364006,4.184000,-7.402000],[-86.574005,5.228000,-6.478000],[-86.784004,6.132000,-5.406000],[-87.328003,6.102000,-5.378000],[-87.120003,5.202000,-6.446000],[-86.910004,4.162000,-7.366000],[-85.518005,3.028000,-8.178000],[-86.156006,3.018000,-8.150001],[-86.700005,3.004000,-8.112000],[-84.820007,3.036000,-8.196000],[-86.808006,-0.946000,-8.908000],[-87.018005,0.412000,-8.830001],[-86.702003,0.414000,-8.894000],[-86.492004,-0.952000,-8.974000],[-86.912003,1.736000,-8.594001],[-87.226006,1.724000,-8.530001],[-87.032005,-0.936000,-8.834001],[-87.242004,0.408000,-8.756001],[-87.452003,1.710000,-8.460000],[-87.606003,1.696000,-8.388000],[-87.396004,0.406000,-8.680000],[-87.186005,-0.926000,-8.758000],[-86.598007,-2.308000,-8.776000],[-86.824005,-2.286000,-8.704000],[-86.978004,-2.266000,-8.630000],[-86.284004,-2.326000,-8.840000],[-85.666000,-8.898001,-2.844000],[-85.608002,-8.976001,-2.866000],[-85.398003,-9.264001,-1.566000],[-85.456001,-9.184000,-1.554000],[-85.876007,-8.422000,-4.066000],[-85.818001,-8.496000,-4.100000],[-86.028008,-7.824000,-5.226000],[-86.084007,-7.754000,-5.184000],[-85.700005,-8.826000,-2.824000],[-85.910004,-8.354000,-4.036000],[-86.120003,-7.694000,-5.144000],[-86.148003,-7.640000,-5.110000],[-85.938004,-8.296000,-4.008000],[-85.730003,-8.764001,-2.806000],[-85.492004,-9.110001,-1.542000],[-85.520004,-9.046000,-1.534000],[-84.144005,-5.740000,6.374000],[-84.352005,-6.730000,5.564000],[-84.306007,-6.758000,5.586000],[-84.096001,-5.764000,6.400000],[-84.514008,-7.598001,4.626000],[-84.560005,-7.568000,4.608000],[-84.196007,-5.726000,6.358000],[-84.404007,-6.716001,5.550000],[-84.614006,-7.550000,4.596000],[-84.668007,-7.544000,4.592000],[-84.460007,-6.710001,5.546000],[-84.252007,-5.724000,6.354000],[-83.934006,-4.628000,7.030000],[-83.986008,-4.618000,7.012001],[-84.042007,-4.614000,7.006001],[-83.886002,-4.648000,7.056000],[-82.690002,3.876000,6.406000],[-82.636002,3.866000,6.390000],[-82.428001,4.830000,5.538000],[-82.482002,4.842000,5.550000],[-82.898003,2.798000,7.098001],[-82.844002,2.792000,7.080000],[-83.054001,1.628000,7.578001],[-83.108002,1.632000,7.596000],[-82.742004,3.890000,6.432000],[-82.950005,2.810000,7.124001],[-83.160004,1.638000,7.626000],[-83.204002,1.646000,7.670001],[-82.994003,2.824000,7.166000],[-82.786003,3.910000,6.466000],[-82.532005,4.860000,5.572000],[-82.576004,4.886000,5.604000],[-81.192001,7.044000,-2.792000],[-81.400002,7.376000,-1.524000],[-81.358002,7.318000,-1.514000],[-81.150002,6.988000,-2.772000],[-81.566002,7.434000,-0.228000],[-81.610001,7.494000,-0.228000],[-81.258003,7.104001,-2.814000],[-81.468002,7.440001,-1.536000],[-81.676003,7.558001,-0.228000],[-81.784004,7.624001,-0.228000],[-81.574005,7.506001,-1.548000],[-81.364006,7.166000,-2.838000],[-80.982002,6.516000,-4.004000],[-81.048004,6.572001,-4.038000],[-81.156006,6.630000,-4.072000],[-80.938004,6.464000,-3.974000],[-80.926003,4.106000,-7.266000],[-80.716003,2.964000,-8.000000],[-81.038002,2.984000,-8.060000],[-81.248001,4.136000,-7.322001],[-80.690002,4.072000,-7.208000],[-80.480003,2.940000,-7.934000],[-81.134003,5.132000,-6.358000],[-80.898003,5.088000,-6.308000],[-81.108002,5.968000,-5.264000],[-81.344002,6.016000,-5.306000],[-81.458000,5.168000,-6.406000],[-81.668007,6.062000,-5.346000],[-83.708000,7.456000,-2.944000],[-83.498001,6.896000,-4.228000],[-84.198006,6.912000,-4.238000],[-84.408005,7.472000,-2.950000],[-85.140007,7.476000,-2.952000],[-84.930000,6.916000,-4.240000],[-83.066002,7.430000,-2.936000],[-82.858002,6.872000,-4.214000],[-82.306007,6.838000,-4.194000],[-82.516006,7.394001,-2.922000],[-83.918007,7.808001,-1.600000],[-83.276001,7.780000,-1.598000],[-82.726006,7.742001,-1.590000],[-82.936005,7.866000,-0.228000],[-83.486008,7.906000,-0.228000],[-84.126007,7.932000,-0.228000],[-84.618004,7.824000,-1.604000],[-84.828003,7.950000,-0.228000],[-85.560005,7.956000,-0.228000],[-85.350006,7.830000,-1.606000],[-86.568001,7.456000,-2.944000],[-85.870003,7.472000,-2.950000],[-85.660004,6.912000,-4.238000],[-86.358002,6.896000,-4.228000],[-86.778008,7.808001,-1.600000],[-86.080002,7.824000,-1.604000],[-86.290001,7.950000,-0.228000],[-86.988007,7.932000,-0.228000],[-87.204002,7.430000,-2.936000],[-87.414001,7.780000,-1.598000],[-87.624001,7.906000,-0.228000],[-88.168007,7.866000,-0.228000],[-87.958008,7.742001,-1.590000],[-87.748001,7.394001,-2.922000],[-86.996002,6.872000,-4.214000],[-87.538002,6.838000,-4.194000],[-87.646004,4.106000,-7.266000],[-87.330002,4.136000,-7.322001],[-87.120003,2.984000,-8.060000],[-87.436005,2.964000,-8.000000],[-87.856003,5.132000,-6.358000],[-87.542007,5.168000,-6.406000],[-87.750008,6.062000,-5.346000],[-88.066002,6.016000,-5.306000],[-87.872002,4.072000,-7.208000],[-88.080002,5.088000,-6.308000],[-88.290001,5.968000,-5.264000],[-88.444008,5.914001,-5.220000],[-88.232002,5.044000,-6.254000],[-88.024002,4.036000,-7.144001],[-87.662003,2.940000,-7.934000],[-87.814003,2.914000,-7.866000],[-86.504005,-5.884000,-6.992000],[-86.712006,-4.744000,-7.664001],[-86.656006,-4.788000,-7.728000],[-86.446007,-5.936000,-7.052001],[-86.864006,-3.546000,-8.232000],[-86.922005,-3.514000,-8.162001],[-86.538002,-5.836000,-6.938000],[-86.748001,-4.706000,-7.604001],[-86.956001,-3.486000,-8.100000],[-86.984001,-3.460000,-8.046000],[-86.774002,-4.672000,-7.554000],[-86.566002,-5.794000,-6.892000],[-86.294006,-6.898000,-6.162000],[-86.328003,-6.842000,-6.114000],[-86.358002,-6.794000,-6.074000],[-86.236008,-6.960001,-6.214000],[-84.978004,-8.684000,2.324000],[-84.932007,-8.718000,2.334000],[-84.724007,-8.250000,3.532000],[-84.770004,-8.218000,3.516000],[-85.188004,-8.962001,1.064000],[-85.140007,-8.996000,1.070000],[-85.350006,-9.090000,-0.228000],[-85.398003,-9.054001,-0.228000],[-85.032005,-8.664001,2.320000],[-85.240005,-8.942000,1.062000],[-85.448006,-9.032001,-0.228000],[-85.504005,-9.026000,-0.228000],[-85.296005,-8.934000,1.062000],[-85.086006,-8.656000,2.316000],[-84.822006,-8.198000,3.508000],[-84.878006,-8.192000,3.506000],[-83.526001,-0.884000,7.952000],[-83.736008,-2.170000,7.828001],[-83.680000,-2.162000,7.810000],[-83.472008,-0.882000,7.934000],[-83.888000,-3.420000,7.498000],[-83.944000,-3.428000,7.518000],[-83.576004,-0.888000,7.984000],[-83.786003,-2.178000,7.860001],[-83.996002,-3.442000,7.546000],[-84.040001,-3.460000,7.590000],[-83.832001,-2.190000,7.904000],[-83.622002,-0.894000,8.028001],[-83.318001,0.394000,7.878000],[-83.368004,0.394000,7.910000],[-83.414001,0.396000,7.954000],[-83.262001,0.392000,7.860001],[-82.028008,7.044000,2.336000],[-81.986008,6.988000,2.316000],[-81.776001,7.318000,1.058000],[-81.820007,7.376000,1.068000],[-82.238007,6.516000,3.548000],[-82.194000,6.464000,3.516000],[-82.404007,5.768000,4.636000],[-82.448006,5.814000,4.676000],[-82.096001,7.104001,2.358000],[-82.306007,6.572001,3.580000],[-82.514008,5.864000,4.718000],[-82.620003,5.914001,4.762000],[-82.412003,6.630000,3.614000],[-82.202003,7.166000,2.380000],[-81.886002,7.440001,1.078000],[-81.994003,7.506001,1.090000],[-81.762001,7.290000,-2.884000],[-82.088005,7.346000,-2.904000],[-82.296005,7.692000,-1.580000],[-81.974007,7.634000,-1.570000],[-82.182007,7.756001,-0.228000],[-82.506004,7.816000,-0.228000],[-81.554001,6.744000,-4.138000],[-81.878006,6.794000,-4.168000],[-81.528008,7.230000,-2.862000],[-81.318001,6.688000,-4.106000],[-81.738007,7.572001,-1.560000],[-81.946007,7.692000,-0.228000],[-84.546005,7.456000,2.488000],[-85.248001,7.472000,2.494000],[-85.458008,6.912000,3.780000],[-84.758003,6.896000,3.772000],[-84.968002,6.152000,4.968000],[-85.668007,6.166000,4.978000],[-86.398003,6.170000,4.982000],[-86.188004,6.916000,3.784000],[-85.978004,7.476000,2.496000],[-84.336006,7.808001,1.144000],[-85.038002,7.824000,1.148000],[-85.770004,7.830000,1.148000],[-83.906006,7.430000,2.478000],[-83.696007,7.780000,1.140000],[-83.146004,7.742001,1.132000],[-83.356003,7.394001,2.464000],[-84.116005,6.872000,3.758000],[-83.564003,6.838000,3.736000],[-83.774002,6.102000,4.922000],[-84.326004,6.132000,4.948000],[-87.408005,7.456000,2.488000],[-87.616005,6.896000,3.772000],[-86.918007,6.912000,3.780000],[-86.710007,7.472000,2.494000],[-87.128006,6.166000,4.978000],[-87.826004,6.152000,4.968000],[-88.044006,7.430000,2.478000],[-88.254005,6.872000,3.758000],[-88.464005,6.132000,4.948000],[-89.006004,6.102000,4.922000],[-88.798004,6.838000,3.736000],[-88.588005,7.394001,2.464000],[-87.198006,7.808001,1.144000],[-87.834007,7.780000,1.140000],[-88.378006,7.742001,1.132000],[-86.500008,7.824000,1.148000],[-88.484001,7.290000,-2.884000],[-88.694008,7.634000,-1.570000],[-88.378006,7.692000,-1.580000],[-88.170006,7.346000,-2.904000],[-88.588005,7.816000,-0.228000],[-88.904007,7.756001,-0.228000],[-88.710007,7.230000,-2.862000],[-88.918007,7.572001,-1.560000],[-89.128006,7.692000,-0.228000],[-89.280006,7.624001,-0.228000],[-89.070007,7.506001,-1.548000],[-88.862007,7.166000,-2.838000],[-88.274002,6.744000,-4.138000],[-88.500008,6.688000,-4.106000],[-88.652000,6.630000,-4.072000],[-87.960007,6.794000,-4.168000],[-87.340004,-0.908000,-8.610001],[-87.284004,-0.918000,-8.682000],[-87.074005,-2.244000,-8.554001],[-87.130005,-2.224000,-8.482000],[-87.550003,0.400000,-8.534000],[-87.492004,0.402000,-8.606000],[-87.702003,1.682000,-8.314000],[-87.758003,1.670000,-8.246000],[-87.374001,-0.900000,-8.542001],[-87.584007,0.398000,-8.468000],[-87.792007,1.656000,-8.182000],[-87.820007,1.646000,-8.126000],[-87.612007,0.396000,-8.410001],[-87.402000,-0.894000,-8.484000],[-87.164001,-2.206000,-8.416000],[-87.192001,-2.190000,-8.360001],[-85.816002,-8.684000,-2.782000],[-86.024002,-8.218000,-3.974000],[-85.978004,-8.250000,-3.988000],[-85.768005,-8.718000,-2.792000],[-86.186005,-7.598001,-5.084000],[-86.232002,-7.568000,-5.066000],[-85.866005,-8.664001,-2.776000],[-86.076004,-8.198000,-3.964000],[-86.286003,-7.550000,-5.054000],[-86.340004,-7.544000,-5.050000],[-86.132004,-8.192000,-3.962000],[-85.924004,-8.656000,-2.774000],[-85.606003,-8.962001,-1.522000],[-85.658005,-8.942000,-1.520000],[-85.714005,-8.934000,-1.518000],[-85.560005,-8.996000,-1.526000],[-84.362007,-5.740000,6.374000],[-84.308006,-5.726000,6.358000],[-84.098007,-4.618000,7.012001],[-84.154007,-4.628000,7.030000],[-84.570007,-6.730000,5.564000],[-84.516006,-6.716001,5.550000],[-84.726006,-7.550000,4.596000],[-84.780006,-7.568000,4.608000],[-84.414001,-5.764000,6.400000],[-84.622002,-6.758000,5.586000],[-84.832001,-7.598001,4.626000],[-84.876007,-7.640000,4.652000],[-84.668007,-6.794000,5.618000],[-84.458008,-5.794000,6.436000],[-84.204002,-4.648000,7.056000],[-84.248001,-4.672000,7.096000],[-82.864006,3.968000,6.568000],[-83.076004,2.866000,7.276000],[-83.032005,2.842000,7.216001],[-82.822006,3.938000,6.514000],[-83.240005,1.656000,7.724000],[-83.284004,1.670000,7.788001],[-82.932007,4.002000,6.626000],[-83.142006,2.890000,7.342000],[-83.352005,1.682000,7.858000],[-83.458000,1.696000,7.932000],[-83.250008,2.914000,7.410000],[-83.040001,4.036000,6.688000],[-82.656006,4.958000,5.692000],[-82.722000,5.000000,5.744000],[-82.830002,5.044000,5.796000],[-82.612007,4.920000,5.644000],[-82.602005,7.290000,2.426000],[-82.392006,7.634000,1.114000],[-82.716003,7.692000,1.124000],[-82.926003,7.346000,2.448000],[-82.366005,7.230000,2.404000],[-82.156006,7.572001,1.102000],[-82.810005,6.744000,3.682000],[-82.576004,6.688000,3.648000],[-82.784004,5.968000,4.808000],[-83.020004,6.016000,4.850000],[-83.136002,6.794000,3.712000],[-83.346001,6.062000,4.890000],[-85.386002,4.198000,6.972000],[-85.176003,5.246000,6.042000],[-85.878006,5.256000,6.056000],[-86.088005,4.206000,6.986001],[-86.818001,4.210000,6.992000],[-86.608002,5.260000,6.062000],[-84.744003,4.182000,6.946000],[-84.536003,5.228000,6.020000],[-83.984001,5.202000,5.990000],[-84.194000,4.162000,6.910000],[-85.596001,3.028000,7.722001],[-84.954002,3.018000,7.694000],[-84.404007,3.004000,7.654000],[-84.614006,1.748000,8.192000],[-85.164001,1.756000,8.234000],[-85.806007,1.762000,8.264000],[-86.298004,3.036000,7.738000],[-86.506004,1.766000,8.284000],[-87.238007,1.768000,8.288000],[-87.028008,3.038000,7.746000],[-88.246002,4.198000,6.972000],[-87.548004,4.206000,6.986001],[-87.338005,5.256000,6.056000],[-88.036003,5.246000,6.042000],[-88.456001,3.028000,7.722001],[-87.758003,3.036000,7.738000],[-87.968002,1.766000,8.284000],[-88.666008,1.762000,8.264000],[-88.884003,4.182000,6.946000],[-89.092003,3.018000,7.694000],[-89.302002,1.756000,8.234000],[-89.846001,1.748000,8.192000],[-89.636002,3.004000,7.654000],[-89.426003,4.162000,6.910000],[-88.674004,5.228000,6.020000],[-89.216003,5.202000,5.990000],[-89.322006,7.290000,2.426000],[-89.008003,7.346000,2.448000],[-88.800003,7.692000,1.124000],[-89.114006,7.634000,1.114000],[-89.532005,6.744000,3.682000],[-89.218002,6.794000,3.712000],[-89.428001,6.062000,4.890000],[-89.742004,6.016000,4.850000],[-89.548004,7.230000,2.404000],[-89.756004,6.688000,3.648000],[-89.966003,5.968000,4.808000],[-90.118004,5.914001,4.762000],[-89.908005,6.630000,3.614000],[-89.700005,7.166000,2.380000],[-89.338005,7.572001,1.102000],[-89.490005,7.506001,1.090000],[-88.178001,3.968000,-7.024000],[-88.386002,4.958000,-6.148000],[-88.330002,5.000000,-6.200000],[-88.120003,4.002000,-7.084000],[-88.538002,5.864000,-5.174000],[-88.596001,5.814000,-5.132000],[-88.210007,3.938000,-6.970000],[-88.420006,4.920000,-6.100000],[-88.630005,5.768000,-5.094000],[-88.656006,5.730000,-5.060000],[-88.448006,4.886000,-6.060000],[-88.238007,3.910000,-6.924000],[-87.968002,2.866000,-7.732000],[-88.002007,2.842000,-7.674000],[-88.030006,2.824000,-7.622000],[-87.910004,2.890000,-7.798000],[-86.650002,-5.740000,-6.832000],[-86.604004,-5.764000,-6.856000],[-86.394005,-6.758000,-6.042000],[-86.442001,-6.730000,-6.020000],[-86.860001,-4.628000,-7.486001],[-86.814003,-4.648000,-7.514000],[-87.022003,-3.442000,-8.004001],[-87.070007,-3.428000,-7.974000],[-86.704002,-5.726000,-6.816000],[-86.912003,-4.618000,-7.468000],[-87.120003,-3.420000,-7.956000],[-87.176003,-3.418000,-7.950000],[-86.968002,-4.614000,-7.464000],[-86.758003,-5.724000,-6.810000],[-86.494003,-6.716001,-6.008000],[-86.550003,-6.710001,-6.002000],[-85.198006,-8.684000,2.324000],[-85.408005,-8.962001,1.064000],[-85.352005,-8.942000,1.062000],[-85.144005,-8.664001,2.320000],[-85.560005,-9.032001,-0.228000],[-85.616005,-9.054001,-0.228000],[-85.248001,-8.718000,2.334000],[-85.458008,-8.996000,1.070000],[-85.668007,-9.090000,-0.228000],[-85.714005,-9.140000,-0.228000],[-85.504005,-9.046000,1.078000],[-85.294006,-8.764001,2.348000],[-84.990005,-8.218000,3.516000],[-85.040001,-8.250000,3.532000],[-85.086006,-8.296000,3.552000],[-84.934006,-8.198000,3.508000],[-83.702003,-0.908000,8.152000],[-83.658005,-0.900000,8.086000],[-83.448006,0.398000,8.010000],[-83.492004,0.400000,8.078000],[-83.912003,-2.224000,8.026000],[-83.868004,-2.206000,7.958000],[-84.076004,-3.486000,7.644001],[-84.120003,-3.514000,7.706000],[-83.770004,-0.918000,8.226001],[-83.980003,-2.244000,8.098001],[-84.188004,-3.546000,7.776000],[-84.296005,-3.578000,7.846000],[-84.086006,-2.266000,8.172000],[-83.878006,-0.926000,8.302000],[-83.560005,0.402000,8.148001],[-83.668007,0.406000,8.224000],[-83.440002,4.106000,6.810000],[-83.764008,4.136000,6.864000],[-83.974007,2.984000,7.602000],[-83.650002,2.964000,7.542000],[-83.858002,1.724000,8.074000],[-84.184006,1.736000,8.138000],[-83.230003,5.132000,5.902000],[-83.554001,5.168000,5.948000],[-83.204002,4.072000,6.750000],[-82.994003,5.088000,5.850000],[-83.414001,2.940000,7.478000],[-83.622002,1.710000,8.004001],[-86.226006,-0.970000,8.650001],[-86.928001,-0.972000,8.670000],[-87.138000,-2.368000,8.534000],[-86.436005,-2.362000,8.516001],[-86.646004,-3.730000,8.178000],[-87.348007,-3.736000,8.196000],[-88.078003,-3.740000,8.202001],[-87.868004,-2.370000,8.540000],[-87.658005,-0.972000,8.676001],[-86.016006,0.418000,8.570001],[-86.718002,0.418000,8.590000],[-87.448006,0.418000,8.596001],[-85.584007,-0.966000,8.618000],[-85.374001,0.416000,8.538000],[-84.824005,0.414000,8.494000],[-85.034004,-0.958000,8.574000],[-85.794006,-2.354000,8.484000],[-85.242004,-2.342000,8.440001],[-85.452003,-3.696000,8.106000],[-86.004005,-3.716000,8.148001],[-89.086006,-0.970000,8.650001],[-89.296005,-2.362000,8.516001],[-88.598007,-2.368000,8.534000],[-88.388000,-0.972000,8.670000],[-88.808006,-3.736000,8.196000],[-89.506004,-3.730000,8.178000],[-89.722008,-0.966000,8.618000],[-89.932007,-2.354000,8.484000],[-90.142006,-3.716000,8.148001],[-90.684006,-3.696000,8.106000],[-90.474007,-2.342000,8.440001],[-90.266006,-0.958000,8.574000],[-88.876007,0.418000,8.570001],[-89.512001,0.416000,8.538000],[-90.056007,0.414000,8.494000],[-88.178001,0.418000,8.590000],[-90.162003,4.106000,6.810000],[-90.370003,2.964000,7.542000],[-90.058006,2.984000,7.602000],[-89.846001,4.136000,6.864000],[-90.266006,1.736000,8.138000],[-90.580002,1.724000,8.074000],[-90.386002,4.072000,6.750000],[-90.596001,2.940000,7.478000],[-90.804001,1.710000,8.004001],[-90.956001,1.696000,7.932000],[-90.746002,2.914000,7.410000],[-90.536003,4.036000,6.688000],[-89.952003,5.132000,5.902000],[-90.176003,5.088000,5.850000],[-90.328003,5.044000,5.796000],[-89.636002,5.168000,5.948000],[-89.014008,7.044000,-2.792000],[-88.958008,7.104001,-2.814000],[-88.748001,6.572001,-4.038000],[-88.804001,6.516000,-4.004000],[-89.222008,7.376000,-1.524000],[-89.166008,7.440001,-1.536000],[-89.376007,7.558001,-0.228000],[-89.432007,7.494000,-0.228000],[-89.046005,6.988000,-2.772000],[-89.256004,7.318000,-1.514000],[-89.466003,7.434000,-0.228000],[-89.494003,7.384000,-0.228000],[-89.284004,7.268000,-1.506000],[-89.074005,6.940001,-2.754000],[-88.838005,6.464000,-3.974000],[-88.866005,6.420000,-3.948000],[-87.486008,-0.884000,-8.410001],[-87.696007,0.394000,-8.334001],[-87.650002,0.394000,-8.366000],[-87.440002,-0.888000,-8.440001],[-87.858002,1.638000,-8.084001],[-87.904007,1.632000,-8.054001],[-87.538002,-0.882000,-8.390000],[-87.748001,0.392000,-8.316000],[-87.956001,1.628000,-8.036000],[-88.012001,1.628000,-8.030001],[-87.802002,0.392000,-8.310000],[-87.594002,-0.880000,-8.384001],[-87.278008,-2.170000,-8.284000],[-87.330002,-2.162000,-8.266001],[-87.386002,-2.162000,-8.260000],[-87.232002,-2.178000,-8.316000],[-86.034004,-8.684000,-2.782000],[-85.978004,-8.664001,-2.776000],[-85.770004,-8.942000,-1.520000],[-85.826004,-8.962001,-1.522000],[-86.242004,-8.218000,-3.974000],[-86.188004,-8.198000,-3.964000],[-86.398003,-7.550000,-5.054000],[-86.452003,-7.568000,-5.066000],[-86.086006,-8.718000,-2.792000],[-86.294006,-8.250000,-3.988000],[-86.504005,-7.598001,-5.084000],[-86.550003,-7.640000,-5.110000],[-86.340004,-8.296000,-4.008000],[-86.130005,-8.764001,-2.806000],[-85.876007,-8.996000,-1.526000],[-85.922005,-9.046000,-1.534000],[-84.540001,-5.884000,6.536000],[-84.748001,-6.898000,5.706000],[-84.704002,-6.842000,5.658000],[-84.496002,-5.836000,6.482000],[-84.914001,-7.694000,4.686000],[-84.958008,-7.754000,4.726000],[-84.608002,-5.936000,6.594000],[-84.816002,-6.960001,5.758000],[-85.026001,-7.824000,4.770000],[-85.134003,-7.894001,4.814000],[-84.924004,-7.022000,5.812000],[-84.716003,-5.990000,6.656000],[-84.330002,-4.744000,7.206000],[-84.398003,-4.788000,7.270000],[-84.506004,-4.832000,7.338000],[-84.286003,-4.706000,7.148000],[-84.278008,-0.946000,8.450001],[-84.068001,0.412000,8.372001],[-84.394005,0.414000,8.438001],[-84.604004,-0.952000,8.518001],[-84.042007,-0.936000,8.378000],[-83.832001,0.408000,8.300000],[-84.488007,-2.308000,8.318001],[-84.252007,-2.286000,8.246000],[-84.460007,-3.610000,7.920001],[-84.698006,-3.642000,7.988000],[-84.812004,-2.326000,8.384001],[-85.022003,-3.672000,8.052000],[-87.066002,-6.240000,6.938000],[-86.856003,-5.032000,7.648000],[-87.556007,-5.044000,7.664001],[-87.766006,-6.254000,6.952000],[-88.498001,-6.258000,6.958000],[-88.288002,-5.048000,7.670001],[-86.424004,-6.218000,6.912000],[-86.214005,-5.014000,7.620000],[-85.662003,-4.988000,7.580000],[-85.872002,-6.184000,6.876000],[-87.274002,-7.314000,6.058000],[-86.632004,-7.288001,6.036000],[-86.082001,-7.250000,6.004000],[-86.292007,-8.152000,4.976000],[-86.842003,-8.192000,5.002000],[-87.484001,-8.222000,5.020000],[-87.976006,-7.330000,6.072001],[-88.186005,-8.240001,5.032000],[-88.918007,-8.246000,5.036000],[-88.708008,-7.336000,6.076000],[-89.924004,-6.240000,6.938000],[-89.226006,-6.254000,6.952000],[-89.016006,-5.044000,7.664001],[-89.714005,-5.032000,7.648000],[-90.136002,-7.314000,6.058000],[-89.436005,-7.330000,6.072001],[-89.646004,-8.240001,5.032000],[-90.346001,-8.222000,5.020000],[-90.562004,-6.218000,6.912000],[-90.770004,-7.288001,6.036000],[-90.980003,-8.192000,5.002000],[-91.524002,-8.152000,4.976000],[-91.314003,-7.250000,6.004000],[-91.104004,-6.184000,6.876000],[-90.352005,-5.014000,7.620000],[-90.894005,-4.988000,7.580000],[-91.000008,-0.946000,8.450001],[-90.686005,-0.952000,8.518001],[-90.476006,0.414000,8.438001],[-90.790001,0.412000,8.372001],[-91.210007,-2.308000,8.318001],[-90.894005,-2.326000,8.384001],[-91.104004,-3.672000,8.052000],[-91.418007,-3.642000,7.988000],[-91.224007,-0.936000,8.378000],[-91.434006,-2.286000,8.246000],[-91.642006,-3.610000,7.920001],[-91.794006,-3.578000,7.846000],[-91.584007,-2.266000,8.172000],[-91.374001,-0.926000,8.302000],[-91.014008,0.408000,8.300000],[-91.166008,0.406000,8.224000],[-89.850006,7.044000,2.336000],[-90.060005,6.516000,3.548000],[-90.004005,6.572001,3.580000],[-89.796005,7.104001,2.358000],[-90.214005,5.864000,4.718000],[-90.270004,5.814000,4.676000],[-89.884003,6.988000,2.316000],[-90.094002,6.464000,3.516000],[-90.302002,5.768000,4.636000],[-90.328003,5.730000,4.602000],[-90.120003,6.420000,3.492000],[-89.912003,6.940001,2.298000],[-89.642006,7.376000,1.068000],[-89.674004,7.318000,1.058000],[-89.702003,7.268000,1.048000],[-89.586006,7.440001,1.078000],[-88.322006,3.876000,-6.862000],[-88.276001,3.890000,-6.888000],[-88.066002,2.810000,-7.582000],[-88.114006,2.798000,-7.554000],[-88.532005,4.842000,-6.008000],[-88.486008,4.860000,-6.030000],[-88.694008,5.700000,-5.034000],[-88.742004,5.678000,-5.016000],[-88.376007,3.866000,-6.846000],[-88.584007,4.830000,-5.994000],[-88.792007,5.664000,-5.004000],[-88.848007,5.660000,-5.000000],[-88.640007,4.828000,-5.988000],[-88.430008,3.864000,-6.842000],[-88.164001,2.792000,-7.536000],[-88.222008,2.792000,-7.532001],[-86.870003,-5.740000,-6.832000],[-87.080002,-4.628000,-7.486001],[-87.024002,-4.618000,-7.468000],[-86.816002,-5.726000,-6.816000],[-87.232002,-3.420000,-7.956000],[-87.288002,-3.428000,-7.974000],[-86.922005,-5.764000,-6.856000],[-87.130005,-4.648000,-7.514000],[-87.340004,-3.442000,-8.004001],[-87.386002,-3.460000,-8.046000],[-87.176003,-4.672000,-7.554000],[-86.968002,-5.794000,-6.892000],[-86.662003,-6.730000,-6.020000],[-86.714005,-6.758000,-6.042000],[-86.758003,-6.794000,-6.074000],[-86.606003,-6.716001,-6.008000],[-85.376007,-8.898001,2.388000],[-85.332001,-8.826000,2.366000],[-85.122002,-8.354000,3.578000],[-85.168007,-8.422000,3.608000],[-85.584007,-9.184000,1.096000],[-85.540001,-9.110001,1.086000],[-85.750008,-9.204000,-0.228000],[-85.794006,-9.278001,-0.228000],[-85.444000,-8.976001,2.410000],[-85.654007,-9.264001,1.108000],[-85.862007,-9.360001,-0.228000],[-85.972008,-9.446000,-0.228000],[-85.762001,-9.348001,1.120000],[-85.554001,-9.058001,2.434000],[-85.236008,-8.496000,3.642000],[-85.344002,-8.574000,3.676000],[-85.116005,-6.096000,6.776000],[-85.442001,-6.144000,6.830000],[-85.652000,-7.204000,5.964000],[-85.326004,-7.148000,5.918000],[-85.536003,-8.036000,4.902000],[-85.862007,-8.096001,4.942000],[-84.906006,-4.916000,7.470000],[-85.232002,-4.956000,7.530000],[-84.880005,-6.046000,6.718000],[-84.670006,-4.876000,7.406000],[-85.090004,-7.086000,5.864000],[-85.300003,-7.966001,4.860000],[-87.904007,-9.432000,2.544000],[-88.606003,-9.454000,2.548000],[-88.816002,-9.756001,1.178000],[-88.114006,-9.734000,1.176000],[-88.324005,-9.836000,-0.228000],[-89.026001,-9.858001,-0.228000],[-89.756004,-9.864000,-0.228000],[-89.546005,-9.764001,1.180000],[-89.336006,-9.460000,2.550000],[-87.694008,-8.928000,3.836000],[-88.396004,-8.948000,3.846000],[-89.128006,-8.954000,3.848000],[-87.264008,-9.398001,2.534000],[-87.052002,-8.896001,3.822000],[-86.502007,-8.850000,3.802000],[-86.710007,-9.352000,2.520000],[-87.472008,-9.700001,1.170000],[-86.920006,-9.650001,1.164000],[-87.130005,-9.752001,-0.228000],[-87.682007,-9.800000,-0.228000],[-90.764008,-9.432000,2.544000],[-90.974007,-9.734000,1.176000],[-90.276001,-9.756001,1.178000],[-90.068001,-9.454000,2.548000],[-90.486008,-9.858001,-0.228000],[-91.184006,-9.836000,-0.228000],[-91.400002,-9.398001,2.534000],[-91.610001,-9.700001,1.170000],[-91.820007,-9.800000,-0.228000],[-92.364006,-9.752001,-0.228000],[-92.152008,-9.650001,1.164000],[-91.942001,-9.352000,2.520000],[-90.556007,-8.928000,3.836000],[-91.190002,-8.896001,3.822000],[-91.734001,-8.850000,3.802000],[-89.858002,-8.948000,3.846000],[-91.838005,-6.096000,6.776000],[-92.048004,-7.148000,5.918000],[-91.734001,-7.204000,5.964000],[-91.524002,-6.144000,6.830000],[-91.944008,-8.096001,4.942000],[-92.258003,-8.036000,4.902000],[-92.062004,-6.046000,6.718000],[-92.272003,-7.086000,5.864000],[-92.480003,-7.966001,4.860000],[-92.630005,-7.894001,4.814000],[-92.422005,-7.022000,5.812000],[-92.212006,-5.990000,6.656000],[-91.628006,-4.916000,7.470000],[-91.852005,-4.876000,7.406000],[-92.004005,-4.832000,7.338000],[-91.316002,-4.956000,7.530000],[-90.688004,3.968000,6.568000],[-90.632004,4.002000,6.626000],[-90.424004,5.000000,5.744000],[-90.478004,4.958000,5.692000],[-90.898003,2.866000,7.276000],[-90.840004,2.890000,7.342000],[-91.050003,1.682000,7.858000],[-91.106003,1.670000,7.788001],[-90.720001,3.938000,6.514000],[-90.930008,2.842000,7.216001],[-91.138008,1.656000,7.724000],[-91.166008,1.646000,7.670001],[-90.956001,2.824000,7.166000],[-90.748001,3.910000,6.466000],[-90.512001,4.920000,5.644000],[-90.538002,4.886000,5.604000],[-89.158005,6.878000,-2.730000],[-89.368004,7.202000,-1.494000],[-89.322006,7.230000,-1.498000],[-89.112007,6.904000,-2.740000],[-89.532005,7.346000,-0.228000],[-89.576004,7.318000,-0.228000],[-89.210007,6.862000,-2.726000],[-89.420006,7.186000,-1.490000],[-89.628006,7.300000,-0.228000],[-89.684006,7.294000,-0.228000],[-89.474007,7.180000,-1.490000],[-89.266006,6.858000,-2.722000],[-88.950005,6.362000,-3.914000],[-89.002007,6.348001,-3.906000],[-89.056007,6.344000,-3.902000],[-88.904007,6.386000,-3.928000],[-87.706001,-0.884000,-8.410001],[-87.650002,-0.882000,-8.390000],[-87.442001,-2.162000,-8.266001],[-87.496002,-2.170000,-8.284000],[-87.914001,0.394000,-8.334001],[-87.860001,0.392000,-8.316000],[-88.068001,1.628000,-8.036000],[-88.124001,1.632000,-8.054001],[-87.758003,-0.888000,-8.440001],[-87.966003,0.394000,-8.366000],[-88.176003,1.638000,-8.084001],[-88.222008,1.646000,-8.126000],[-88.012001,0.396000,-8.410001],[-87.804001,-0.894000,-8.484000],[-87.548004,-2.178000,-8.316000],[-87.596001,-2.190000,-8.360001],[-86.212006,-8.898001,-2.844000],[-86.422005,-8.422000,-4.066000],[-86.378006,-8.354000,-4.036000],[-86.168007,-8.826000,-2.824000],[-86.586006,-7.694000,-5.144000],[-86.632004,-7.754000,-5.184000],[-86.282005,-8.976001,-2.866000],[-86.490005,-8.496000,-4.100000],[-86.700005,-7.824000,-5.226000],[-86.808006,-7.894001,-5.272000],[-86.600006,-8.574000,-4.134000],[-86.392006,-9.058001,-2.890000],[-86.004005,-9.184000,-1.554000],[-86.072006,-9.264001,-1.566000],[-86.182007,-9.348001,-1.576000],[-85.958008,-9.110001,-1.542000],[-85.954002,-9.218000,2.480000],[-85.746002,-8.724000,3.744000],[-86.070007,-8.792001,3.776000],[-86.280006,-9.290001,2.502000],[-85.718002,-9.140000,2.458000],[-85.508003,-8.650001,3.712000],[-86.164001,-9.514001,1.144000],[-85.926003,-9.432000,1.132000],[-86.138000,-9.532001,-0.228000],[-86.374001,-9.612000,-0.228000],[-86.490005,-9.588000,1.154000],[-86.700005,-9.688001,-0.228000],[-88.744003,-9.432000,-3.000000],[-88.534004,-9.734000,-1.632000],[-89.236008,-9.756001,-1.634000],[-89.446007,-9.454000,-3.006000],[-90.176003,-9.460000,-3.008000],[-89.966003,-9.764001,-1.636000],[-88.102005,-9.398001,-2.990000],[-87.892006,-9.700001,-1.628000],[-87.340004,-9.650001,-1.620000],[-87.550003,-9.352000,-2.976000],[-88.954002,-8.928000,-4.292000],[-88.310005,-8.896001,-4.280000],[-87.760002,-8.850000,-4.260000],[-87.970001,-8.152000,-5.432000],[-88.522003,-8.192000,-5.460000],[-89.164001,-8.222000,-5.478000],[-89.656006,-8.948000,-4.302000],[-89.864006,-8.240001,-5.490000],[-90.596001,-8.246000,-5.494000],[-90.386002,-8.954000,-4.306000],[-91.604004,-9.432000,-3.000000],[-90.906006,-9.454000,-3.006000],[-90.696007,-9.756001,-1.634000],[-91.394005,-9.734000,-1.632000],[-91.814003,-8.928000,-4.292000],[-91.116005,-8.948000,-4.302000],[-91.326004,-8.240001,-5.490000],[-92.024002,-8.222000,-5.478000],[-92.240005,-9.398001,-2.990000],[-92.450005,-8.896001,-4.280000],[-92.658005,-8.192000,-5.460000],[-93.202003,-8.152000,-5.432000],[-92.992004,-8.850000,-4.260000],[-92.782005,-9.352000,-2.976000],[-92.030006,-9.700001,-1.628000],[-92.574005,-9.650001,-1.620000],[-92.676003,-9.218000,2.480000],[-92.364006,-9.290001,2.502000],[-92.152008,-8.792001,3.776000],[-92.466003,-8.724000,3.744000],[-92.886002,-9.514001,1.144000],[-92.574005,-9.588000,1.154000],[-92.782005,-9.688001,-0.228000],[-93.096001,-9.612000,-0.228000],[-92.898003,-9.140000,2.458000],[-93.110001,-9.432000,1.132000],[-93.318001,-9.532001,-0.228000],[-93.468002,-9.446000,-0.228000],[-93.258003,-9.348001,1.120000],[-93.050003,-9.058001,2.434000],[-92.690002,-8.650001,3.712000],[-92.840004,-8.574000,3.676000],[-91.526001,-0.908000,8.152000],[-91.734001,-2.224000,8.026000],[-91.678001,-2.244000,8.098001],[-91.470001,-0.918000,8.226001],[-91.888008,-3.546000,7.776000],[-91.942001,-3.514000,7.706000],[-91.556007,-0.900000,8.086000],[-91.766006,-2.206000,7.958000],[-91.976006,-3.486000,7.644001],[-92.002007,-3.460000,7.590000],[-91.794006,-2.190000,7.904000],[-91.584007,-0.894000,8.028001],[-91.316002,0.400000,8.078000],[-91.348007,0.398000,8.010000],[-91.374001,0.396000,7.954000],[-91.260002,0.402000,8.148001],[-89.994003,6.878000,2.274000],[-89.948006,6.904000,2.284000],[-89.740005,7.230000,1.042000],[-89.786003,7.202000,1.036000],[-90.202003,6.362000,3.458000],[-90.158005,6.386000,3.472000],[-90.366005,5.700000,4.578000],[-90.414001,5.678000,4.558000],[-90.046005,6.862000,2.268000],[-90.256004,6.348001,3.448000],[-90.464005,5.664000,4.548000],[-90.520004,5.660000,4.544000],[-90.312004,6.344000,3.446000],[-90.102005,6.858000,2.266000],[-89.836006,7.186000,1.034000],[-89.892006,7.180000,1.032000],[-88.542007,3.876000,-6.862000],[-88.752007,4.842000,-6.008000],[-88.696007,4.830000,-5.994000],[-88.488007,3.866000,-6.846000],[-88.904007,5.664000,-5.004000],[-88.960007,5.678000,-5.016000],[-88.594002,3.890000,-6.888000],[-88.802002,4.860000,-6.030000],[-89.012001,5.700000,-5.034000],[-89.058006,5.730000,-5.060000],[-88.850006,4.886000,-6.060000],[-88.640007,3.910000,-6.924000],[-88.334007,2.798000,-7.554000],[-88.386002,2.810000,-7.582000],[-88.430008,2.824000,-7.622000],[-88.278008,2.792000,-7.536000],[-87.050003,-5.884000,-6.992000],[-87.006004,-5.836000,-6.938000],[-86.796005,-6.842000,-6.114000],[-86.840004,-6.898000,-6.162000],[-87.260002,-4.744000,-7.664001],[-87.214005,-4.706000,-7.604001],[-87.422005,-3.486000,-8.100000],[-87.468002,-3.514000,-8.162001],[-87.118004,-5.936000,-7.052001],[-87.328003,-4.788000,-7.728000],[-87.538002,-3.546000,-8.232000],[-87.646004,-3.578000,-8.304001],[-87.438004,-4.832000,-7.796000],[-87.228004,-5.990000,-7.114000],[-86.910004,-6.960001,-6.214000],[-87.018005,-7.022000,-6.268000],[-86.794006,-9.218000,-2.936000],[-87.120003,-9.290001,-2.958000],[-87.328003,-8.792001,-4.232000],[-87.002007,-8.724000,-4.202000],[-87.212006,-8.036000,-5.360000],[-87.538002,-8.096001,-5.398000],[-86.584007,-9.514001,-1.600000],[-86.910004,-9.588000,-1.610000],[-86.556007,-9.140000,-2.914000],[-86.346001,-9.432000,-1.590000],[-86.764008,-8.650001,-4.168000],[-86.974007,-7.966001,-5.316000],[-89.582001,-6.240000,-7.394001],[-90.284004,-6.254000,-7.410000],[-90.494003,-5.044000,-8.122001],[-89.792007,-5.032000,-8.104000],[-90.002007,-3.730000,-8.634001],[-90.704002,-3.736000,-8.654000],[-91.436005,-3.740000,-8.658000],[-91.226006,-5.048000,-8.128000],[-91.016006,-6.258000,-7.416000],[-89.372002,-7.314000,-6.514000],[-90.074005,-7.330000,-6.528000],[-90.806007,-7.336000,-6.534000],[-88.942001,-6.218000,-7.368001],[-88.732002,-7.288001,-6.492000],[-88.178001,-7.250000,-6.460001],[-88.388000,-6.184000,-7.334000],[-89.152000,-5.014000,-8.078000],[-88.600006,-4.988000,-8.036000],[-88.810005,-3.696000,-8.562000],[-89.360001,-3.716000,-8.604000],[-92.444008,-6.240000,-7.394001],[-92.654007,-5.032000,-8.104000],[-91.956001,-5.044000,-8.122001],[-91.746002,-6.254000,-7.410000],[-92.166008,-3.736000,-8.654000],[-92.862007,-3.730000,-8.634001],[-93.078003,-6.218000,-7.368001],[-93.288002,-5.014000,-8.078000],[-93.498001,-3.716000,-8.604000],[-94.042007,-3.696000,-8.562000],[-93.832001,-4.988000,-8.036000],[-93.622002,-6.184000,-7.334000],[-92.234001,-7.314000,-6.514000],[-92.868004,-7.288001,-6.492000],[-93.410004,-7.250000,-6.460001],[-91.536003,-7.330000,-6.528000],[-93.514008,-9.218000,-2.936000],[-93.724007,-8.724000,-4.202000],[-93.410004,-8.792001,-4.232000],[-93.202003,-9.290001,-2.958000],[-93.622002,-8.096001,-5.398000],[-93.934006,-8.036000,-5.360000],[-93.738007,-9.140000,-2.914000],[-93.946007,-8.650001,-4.168000],[-94.156006,-7.966001,-5.316000],[-94.306007,-7.894001,-5.272000],[-94.096001,-8.574000,-4.134000],[-93.888008,-9.058001,-2.890000],[-93.306007,-9.514001,-1.600000],[-93.528008,-9.432000,-1.590000],[-93.678001,-9.348001,-1.576000],[-92.992004,-9.588000,-1.610000],[-92.362007,-5.884000,6.536000],[-92.306007,-5.936000,6.594000],[-92.098007,-4.788000,7.270000],[-92.152008,-4.744000,7.206000],[-92.570007,-6.898000,5.706000],[-92.516006,-6.960001,5.758000],[-92.726006,-7.824000,4.770000],[-92.780006,-7.754000,4.726000],[-92.394005,-5.836000,6.482000],[-92.604004,-6.842000,5.658000],[-92.812004,-7.694000,4.686000],[-92.838005,-7.640000,4.652000],[-92.628006,-6.794000,5.618000],[-92.420006,-5.794000,6.436000],[-92.184006,-4.706000,7.148000],[-92.210007,-4.672000,7.096000],[-90.830002,3.876000,6.406000],[-91.040001,2.798000,7.098001],[-90.994003,2.810000,7.124001],[-90.784004,3.890000,6.432000],[-91.204002,1.638000,7.626000],[-91.248001,1.632000,7.596000],[-90.882004,3.866000,6.390000],[-91.092003,2.792000,7.080000],[-91.300003,1.628000,7.578001],[-91.356003,1.628000,7.572001],[-91.146004,2.792000,7.074000],[-90.938004,3.864000,6.386000],[-90.622002,4.842000,5.550000],[-90.674004,4.830000,5.538000],[-90.728004,4.828000,5.532000],[-90.576004,4.860000,5.572000],[-89.378006,6.878000,-2.730000],[-89.322006,6.862000,-2.726000],[-89.114006,6.348001,-3.906000],[-89.168007,6.362000,-3.914000],[-89.586006,7.202000,-1.494000],[-89.532005,7.186000,-1.490000],[-89.740005,7.300000,-0.228000],[-89.796005,7.318000,-0.228000],[-89.430008,6.904000,-2.740000],[-89.640007,7.230000,-1.498000],[-89.848007,7.346000,-0.228000],[-89.894005,7.384000,-0.228000],[-89.684006,7.268000,-1.506000],[-89.476006,6.940001,-2.754000],[-89.220001,6.386000,-3.928000],[-89.268005,6.420000,-3.948000],[-87.886002,-0.908000,-8.610001],[-88.096001,0.400000,-8.534000],[-88.050003,0.398000,-8.468000],[-87.842003,-0.900000,-8.542001],[-88.260002,1.656000,-8.182000],[-88.304001,1.670000,-8.246000],[-87.956001,-0.918000,-8.682000],[-88.164001,0.402000,-8.606000],[-88.376007,1.682000,-8.314000],[-88.484001,1.696000,-8.388000],[-88.276001,0.406000,-8.680000],[-88.066002,-0.926000,-8.758000],[-87.676003,-2.224000,-8.482000],[-87.748001,-2.244000,-8.554001],[-87.856003,-2.266000,-8.630000],[-87.632004,-2.206000,-8.416000],[-87.632004,-6.096000,-7.232000],[-87.422005,-7.148000,-6.374000],[-87.748001,-7.204000,-6.420000],[-87.958008,-6.144000,-7.288001],[-87.394005,-6.046000,-7.174000],[-87.184006,-7.086000,-6.322001],[-87.842003,-4.916000,-7.928000],[-87.602005,-4.876000,-7.864000],[-87.812004,-3.610000,-8.376000],[-88.050003,-3.642000,-8.446000],[-88.168007,-4.956000,-7.986001],[-88.378006,-3.672000,-8.508000],[-90.422005,-0.970000,-9.108001],[-90.214005,-2.362000,-8.972000],[-90.914001,-2.368000,-8.992001],[-91.124001,-0.972000,-9.126000],[-91.854004,-0.972000,-9.132000],[-91.646004,-2.370000,-8.998000],[-89.780006,-0.966000,-9.076000],[-89.570007,-2.354000,-8.942000],[-89.018005,-2.342000,-8.898001],[-89.228004,-0.958000,-9.030001],[-90.632004,0.418000,-9.026000],[-89.990005,0.416000,-8.996000],[-89.438004,0.414000,-8.952001],[-89.646004,1.748000,-8.648001],[-90.200005,1.756000,-8.692000],[-90.842003,1.762000,-8.722000],[-91.334007,0.418000,-9.046000],[-91.544006,1.766000,-8.740001],[-92.274002,1.768000,-8.746000],[-92.064003,0.418000,-9.052000],[-93.282005,-0.970000,-9.108001],[-92.584007,-0.972000,-9.126000],[-92.376007,-2.368000,-8.992001],[-93.072006,-2.362000,-8.972000],[-93.492004,0.418000,-9.026000],[-92.794006,0.418000,-9.046000],[-93.004005,1.766000,-8.740001],[-93.702003,1.762000,-8.722000],[-93.918007,-0.966000,-9.076000],[-94.128006,0.416000,-8.996000],[-94.336006,1.756000,-8.692000],[-94.880005,1.748000,-8.648001],[-94.670006,0.414000,-8.952001],[-94.460007,-0.958000,-9.030001],[-93.708008,-2.354000,-8.942000],[-94.250008,-2.342000,-8.898001],[-94.354004,-6.096000,-7.232000],[-94.040001,-6.144000,-7.288001],[-93.832001,-7.204000,-6.420000],[-94.144005,-7.148000,-6.374000],[-94.562004,-4.916000,-7.928000],[-94.250008,-4.956000,-7.986001],[-94.460007,-3.672000,-8.508000],[-94.772003,-3.642000,-8.446000],[-94.576004,-6.046000,-7.174000],[-94.784004,-4.876000,-7.864000],[-94.994003,-3.610000,-8.376000],[-95.144005,-3.578000,-8.304001],[-94.934006,-4.832000,-7.796000],[-94.726006,-5.990000,-7.114000],[-94.366005,-7.086000,-6.322001],[-94.516006,-7.022000,-6.268000],[-93.198006,-8.898001,2.388000],[-93.408005,-9.184000,1.096000],[-93.354004,-9.264001,1.108000],[-93.144005,-8.976001,2.410000],[-93.562004,-9.360001,-0.228000],[-93.618004,-9.278001,-0.228000],[-93.230003,-8.826000,2.366000],[-93.440002,-9.110001,1.086000],[-93.648003,-9.204000,-0.228000],[-93.674004,-9.140000,-0.228000],[-93.466003,-9.046000,1.078000],[-93.256004,-8.764001,2.348000],[-92.990005,-8.422000,3.608000],[-93.020004,-8.354000,3.578000],[-93.048004,-8.296000,3.552000],[-92.934006,-8.496000,3.642000],[-91.666008,-0.884000,7.952000],[-91.620003,-0.888000,7.984000],[-91.412003,0.394000,7.910000],[-91.458008,0.394000,7.878000],[-91.874001,-2.170000,7.828001],[-91.830002,-2.178000,7.860001],[-92.038002,-3.442000,7.546000],[-92.084007,-3.428000,7.518000],[-91.718002,-0.882000,7.934000],[-91.926003,-2.162000,7.810000],[-92.136002,-3.420000,7.498000],[-92.190002,-3.418000,7.492001],[-91.982002,-2.162000,7.802001],[-91.772003,-0.880000,7.926001],[-91.508003,0.392000,7.860001],[-91.564003,0.392000,7.854001],[-90.214005,6.878000,2.274000],[-90.424004,6.362000,3.458000],[-90.368004,6.348001,3.448000],[-90.158005,6.862000,2.268000],[-90.576004,5.664000,4.548000],[-90.632004,5.678000,4.558000],[-90.266006,6.904000,2.284000],[-90.474007,6.386000,3.472000],[-90.684006,5.700000,4.578000],[-90.730003,5.730000,4.602000],[-90.522003,6.420000,3.492000],[-90.312004,6.940001,2.298000],[-90.006004,7.202000,1.036000],[-90.058006,7.230000,1.042000],[-90.104004,7.268000,1.048000],[-89.948006,7.186000,1.034000],[-88.724007,3.968000,-7.024000],[-88.678001,3.938000,-6.970000],[-88.468002,2.842000,-7.674000],[-88.514008,2.866000,-7.732000],[-88.932007,4.958000,-6.148000],[-88.888000,4.920000,-6.100000],[-89.096001,5.768000,-5.094000],[-89.142006,5.814000,-5.132000],[-88.794006,4.002000,-7.084000],[-89.002007,5.000000,-6.200000],[-89.212006,5.864000,-5.174000],[-89.322006,5.914001,-5.220000],[-89.112007,5.044000,-6.254000],[-88.904007,4.036000,-7.144001],[-88.584007,2.890000,-7.798000],[-88.694008,2.914000,-7.866000],[-88.470001,-0.946000,-8.908000],[-88.796005,-0.952000,-8.974000],[-89.006004,0.414000,-8.894000],[-88.680008,0.412000,-8.830001],[-88.890007,1.724000,-8.530001],[-89.216003,1.736000,-8.594001],[-88.260002,-2.308000,-8.776000],[-88.586006,-2.326000,-8.840000],[-88.232002,-0.936000,-8.834001],[-88.022003,-2.286000,-8.704000],[-88.442001,0.408000,-8.756001],[-88.650002,1.710000,-8.460000],[-91.262001,4.198000,-7.428000],[-91.964005,4.206000,-7.444000],[-92.174004,5.256000,-6.514000],[-91.472008,5.246000,-6.500000],[-91.682007,6.152000,-5.424000],[-92.384003,6.166000,-5.436000],[-93.114006,6.170000,-5.440000],[-92.904007,5.260000,-6.518000],[-92.696007,4.210000,-7.450000],[-91.052002,3.028000,-8.178000],[-91.754005,3.036000,-8.196000],[-92.486008,3.038000,-8.202001],[-90.620003,4.184000,-7.402000],[-90.410004,3.018000,-8.150001],[-89.858002,3.004000,-8.112000],[-90.068001,4.162000,-7.366000],[-90.830002,5.228000,-6.478000],[-90.278008,5.202000,-6.446000],[-90.486008,6.102000,-5.378000],[-91.038002,6.132000,-5.406000],[-94.122002,4.198000,-7.428000],[-94.332001,5.246000,-6.500000],[-93.634003,5.256000,-6.514000],[-93.424004,4.206000,-7.444000],[-93.844002,6.166000,-5.436000],[-94.542007,6.152000,-5.424000],[-94.758003,4.184000,-7.402000],[-94.968002,5.228000,-6.478000],[-95.178001,6.132000,-5.406000],[-95.718002,6.102000,-5.378000],[-95.510002,5.202000,-6.446000],[-95.300003,4.162000,-7.366000],[-93.912003,3.028000,-8.178000],[-94.546005,3.018000,-8.150001],[-95.090004,3.004000,-8.112000],[-93.214005,3.036000,-8.196000],[-95.192001,-0.946000,-8.908000],[-95.402008,0.412000,-8.830001],[-95.090004,0.414000,-8.894000],[-94.880005,-0.952000,-8.974000],[-95.298004,1.736000,-8.594001],[-95.610008,1.724000,-8.530001],[-95.414001,-0.936000,-8.834001],[-95.622002,0.408000,-8.756001],[-95.832008,1.710000,-8.460000],[-95.982002,1.696000,-8.388000],[-95.772003,0.406000,-8.680000],[-95.562004,-0.926000,-8.758000],[-94.980003,-2.308000,-8.776000],[-95.204002,-2.286000,-8.704000],[-95.354004,-2.266000,-8.630000],[-94.668007,-2.326000,-8.840000],[-94.034004,-8.898001,-2.844000],[-93.980003,-8.976001,-2.866000],[-93.772003,-9.264001,-1.566000],[-93.826004,-9.184000,-1.554000],[-94.246002,-8.422000,-4.066000],[-94.190002,-8.496000,-4.100000],[-94.400002,-7.824000,-5.226000],[-94.454002,-7.754000,-5.184000],[-94.066002,-8.826000,-2.824000],[-94.276001,-8.354000,-4.036000],[-94.486008,-7.694000,-5.144000],[-94.510002,-7.640000,-5.110000],[-94.302002,-8.296000,-4.008000],[-94.092003,-8.764001,-2.806000],[-93.858002,-9.110001,-1.542000],[-93.884003,-9.046000,-1.534000],[-92.502007,-5.740000,6.374000],[-92.712006,-6.730000,5.564000],[-92.666008,-6.758000,5.586000],[-92.458008,-5.764000,6.400000],[-92.876007,-7.598001,4.626000],[-92.920006,-7.568000,4.608000],[-92.554001,-5.726000,6.358000],[-92.764008,-6.716001,5.550000],[-92.972008,-7.550000,4.596000],[-93.028008,-7.544000,4.592000],[-92.818001,-6.710001,5.546000],[-92.610001,-5.724000,6.354000],[-92.294006,-4.628000,7.030000],[-92.346001,-4.618000,7.012001],[-92.400002,-4.614000,7.006001],[-92.248001,-4.648000,7.056000],[-91.050003,3.876000,6.406000],[-90.994003,3.866000,6.390000],[-90.786003,4.830000,5.538000],[-90.840004,4.842000,5.550000],[-91.258003,2.798000,7.098001],[-91.204002,2.792000,7.080000],[-91.412003,1.628000,7.578001],[-91.468002,1.632000,7.596000],[-91.102005,3.890000,6.432000],[-91.312004,2.810000,7.124001],[-91.520004,1.638000,7.626000],[-91.566002,1.646000,7.670001],[-91.358002,2.824000,7.166000],[-91.150002,3.910000,6.466000],[-90.894005,4.860000,5.572000],[-90.940002,4.886000,5.604000],[-89.560005,7.044000,-2.792000],[-89.770004,7.376000,-1.524000],[-89.724007,7.318000,-1.514000],[-89.514008,6.988000,-2.772000],[-89.932007,7.434000,-0.228000],[-89.980003,7.494000,-0.228000],[-89.630005,7.104001,-2.814000],[-89.840004,7.440001,-1.536000],[-90.050003,7.558001,-0.228000],[-90.160004,7.624001,-0.228000],[-89.950005,7.506001,-1.548000],[-89.742004,7.166000,-2.838000],[-89.352005,6.516000,-4.004000],[-89.422005,6.572001,-4.038000],[-89.532005,6.630000,-4.072000],[-89.304001,6.464000,-3.974000],[-89.308006,4.106000,-7.266000],[-89.098007,2.964000,-8.000000],[-89.426003,2.984000,-8.060000],[-89.636002,4.136000,-7.322001],[-89.070007,4.072000,-7.208000],[-88.860001,2.940000,-7.934000],[-89.518005,5.132000,-6.358000],[-89.280006,5.088000,-6.308000],[-89.488007,5.968000,-5.264000],[-89.728004,6.016000,-5.306000],[-89.844002,5.168000,-6.406000],[-90.054001,6.062000,-5.346000],[-92.102005,7.456000,-2.944000],[-91.892006,6.896000,-4.228000],[-92.594002,6.912000,-4.238000],[-92.804001,7.472000,-2.950000],[-93.534004,7.476000,-2.952000],[-93.324005,6.916000,-4.240000],[-91.458008,7.430000,-2.936000],[-91.248001,6.872000,-4.214000],[-90.696007,6.838000,-4.194000],[-90.906006,7.394001,-2.922000],[-92.310005,7.808001,-1.600000],[-91.668007,7.780000,-1.598000],[-91.116005,7.742001,-1.590000],[-91.326004,7.866000,-0.228000],[-91.878006,7.906000,-0.228000],[-92.520004,7.932000,-0.228000],[-93.014008,7.824000,-1.604000],[-93.222008,7.950000,-0.228000],[-93.954002,7.956000,-0.228000],[-93.744003,7.830000,-1.606000],[-94.960007,7.456000,-2.944000],[-94.264008,7.472000,-2.950000],[-94.054001,6.912000,-4.238000],[-94.752007,6.896000,-4.228000],[-95.170006,7.808001,-1.600000],[-94.474007,7.824000,-1.604000],[-94.682007,7.950000,-0.228000],[-95.380005,7.932000,-0.228000],[-95.596008,7.430000,-2.936000],[-95.806007,7.780000,-1.598000],[-96.016006,7.906000,-0.228000],[-96.558006,7.866000,-0.228000],[-96.348007,7.742001,-1.590000],[-96.138008,7.394001,-2.922000],[-95.386002,6.872000,-4.214000],[-95.928001,6.838000,-4.194000],[-96.030006,4.106000,-7.266000],[-95.718002,4.136000,-7.322001],[-95.508003,2.984000,-8.060000],[-95.820007,2.964000,-8.000000],[-96.238007,5.132000,-6.358000],[-95.926003,5.168000,-6.406000],[-96.138008,6.062000,-5.346000],[-96.450005,6.016000,-5.306000],[-96.252007,4.072000,-7.208000],[-96.460007,5.088000,-6.308000],[-96.670006,5.968000,-5.264000],[-96.818001,5.914001,-5.220000],[-96.610008,5.044000,-6.254000],[-96.400002,4.036000,-7.144001],[-96.042007,2.940000,-7.934000],[-96.192001,2.914000,-7.866000],[-94.872002,-5.884000,-6.992000],[-95.082001,-4.744000,-7.664001],[-95.028008,-4.788000,-7.728000],[-94.818001,-5.936000,-7.052001],[-95.238007,-3.546000,-8.232000],[-95.290001,-3.514000,-8.162001],[-94.902008,-5.836000,-6.938000],[-95.114006,-4.706000,-7.604001],[-95.322006,-3.486000,-8.100000],[-95.348007,-3.460000,-8.046000],[-95.138008,-4.672000,-7.554000],[-94.930008,-5.794000,-6.892000],[-94.662003,-6.898000,-6.162000],[-94.694008,-6.842000,-6.114000],[-94.720001,-6.794000,-6.074000],[-94.608002,-6.960001,-6.214000],[-93.338005,-8.684000,2.324000],[-93.292007,-8.718000,2.334000],[-93.084007,-8.250000,3.532000],[-93.130005,-8.218000,3.516000],[-93.546005,-8.962001,1.064000],[-93.502007,-8.996000,1.070000],[-93.712006,-9.090000,-0.228000],[-93.756004,-9.054001,-0.228000],[-93.390007,-8.664001,2.320000],[-93.598007,-8.942000,1.062000],[-93.808006,-9.032001,-0.228000],[-93.862007,-9.026000,-0.228000],[-93.654007,-8.934000,1.062000],[-93.444008,-8.656000,2.316000],[-93.180008,-8.198000,3.508000],[-93.236008,-8.192000,3.506000],[-91.886002,-0.884000,7.952000],[-92.096001,-2.170000,7.828001],[-92.038002,-2.162000,7.810000],[-91.830002,-0.882000,7.934000],[-92.248001,-3.420000,7.498000],[-92.304001,-3.428000,7.518000],[-91.938004,-0.888000,7.984000],[-92.148003,-2.178000,7.860001],[-92.356003,-3.442000,7.546000],[-92.404007,-3.460000,7.590000],[-92.194008,-2.190000,7.904000],[-91.986008,-0.894000,8.028001],[-91.676003,0.394000,7.878000],[-91.728004,0.394000,7.910000],[-91.776001,0.396000,7.954000],[-91.620003,0.392000,7.860001],[-90.398003,7.044000,2.336000],[-90.352005,6.988000,2.316000],[-90.142006,7.318000,1.058000],[-90.188004,7.376000,1.068000],[-90.606003,6.516000,3.548000],[-90.560005,6.464000,3.516000],[-90.770004,5.768000,4.636000],[-90.816002,5.814000,4.676000],[-90.468002,7.104001,2.358000],[-90.678001,6.572001,3.580000],[-90.886002,5.864000,4.718000],[-90.998001,5.914001,4.762000],[-90.788002,6.630000,3.614000],[-90.580002,7.166000,2.380000],[-90.258003,7.440001,1.078000],[-90.370003,7.506001,1.090000],[-90.146004,7.290000,-2.884000],[-90.474007,7.346000,-2.904000],[-90.684006,7.692000,-1.580000],[-90.356003,7.634000,-1.570000],[-90.566002,7.756001,-0.228000],[-90.894005,7.816000,-0.228000],[-89.938004,6.744000,-4.138000],[-90.264008,6.794000,-4.168000],[-89.908005,7.230000,-2.862000],[-89.698006,6.688000,-4.106000],[-90.118004,7.572001,-1.560000],[-90.326004,7.692000,-0.228000],[-92.940002,7.456000,2.488000],[-93.642006,7.472000,2.494000],[-93.852005,6.912000,3.780000],[-93.150002,6.896000,3.772000],[-93.360008,6.152000,4.968000],[-94.062004,6.166000,4.978000],[-94.794006,6.170000,4.982000],[-94.584007,6.916000,3.784000],[-94.374008,7.476000,2.496000],[-92.730003,7.808001,1.144000],[-93.432007,7.824000,1.148000],[-94.164001,7.830000,1.148000],[-92.298004,7.430000,2.478000],[-92.088005,7.780000,1.140000],[-91.536003,7.742001,1.132000],[-91.746002,7.394001,2.464000],[-92.508003,6.872000,3.758000],[-91.954002,6.838000,3.736000],[-92.164001,6.102000,4.922000],[-92.718002,6.132000,4.948000],[-95.802002,7.456000,2.488000],[-96.010002,6.896000,3.772000],[-95.314003,6.912000,3.780000],[-95.102005,7.472000,2.494000],[-95.524002,6.166000,4.978000],[-96.220001,6.152000,4.968000],[-96.436005,7.430000,2.478000],[-96.646004,6.872000,3.758000],[-96.856003,6.132000,4.948000],[-97.396004,6.102000,4.922000],[-97.186005,6.838000,3.736000],[-96.978004,7.394001,2.464000],[-95.592003,7.808001,1.144000],[-96.226006,7.780000,1.140000],[-96.768005,7.742001,1.132000],[-94.892006,7.824000,1.148000],[-96.868004,7.290000,-2.884000],[-97.078003,7.634000,-1.570000],[-96.766006,7.692000,-1.580000],[-96.556007,7.346000,-2.904000],[-96.976006,7.816000,-0.228000],[-97.286003,7.756001,-0.228000],[-97.090004,7.230000,-2.862000],[-97.300003,7.572001,-1.560000],[-97.508003,7.692000,-0.228000],[-97.656006,7.624001,-0.228000],[-97.448006,7.506001,-1.548000],[-97.238007,7.166000,-2.838000],[-96.658005,6.744000,-4.138000],[-96.880005,6.688000,-4.106000],[-97.030006,6.630000,-4.072000],[-96.348007,6.794000,-4.168000],[-95.710007,-0.908000,-8.610001],[-95.656006,-0.918000,-8.682000],[-95.446007,-2.244000,-8.554001],[-95.500008,-2.224000,-8.482000],[-95.918007,0.400000,-8.534000],[-95.866005,0.402000,-8.606000],[-96.074005,1.682000,-8.314000],[-96.126007,1.670000,-8.246000],[-95.740005,-0.900000,-8.542001],[-95.950005,0.398000,-8.468000],[-96.158005,1.656000,-8.182000],[-96.184006,1.646000,-8.126000],[-95.974007,0.396000,-8.410001],[-95.764008,-0.894000,-8.484000],[-95.530006,-2.206000,-8.416000],[-95.556007,-2.190000,-8.360001],[-94.174004,-8.684000,-2.782000],[-94.384003,-8.218000,-3.974000],[-94.338005,-8.250000,-3.988000],[-94.130005,-8.718000,-2.792000],[-94.546005,-7.598001,-5.084000],[-94.592003,-7.568000,-5.066000],[-94.226006,-8.664001,-2.776000],[-94.434006,-8.198000,-3.964000],[-94.644005,-7.550000,-5.054000],[-94.700005,-7.544000,-5.050000],[-94.490005,-8.192000,-3.962000],[-94.280006,-8.656000,-2.774000],[-93.966003,-8.962001,-1.522000],[-94.016006,-8.942000,-1.520000],[-94.072006,-8.934000,-1.518000],[-93.920006,-8.996000,-1.526000],[-92.722008,-5.740000,6.374000],[-92.666008,-5.726000,6.358000],[-92.458008,-4.618000,7.012001],[-92.512001,-4.628000,7.030000],[-92.930008,-6.730000,5.564000],[-92.876007,-6.716001,5.550000],[-93.084007,-7.550000,4.596000],[-93.140007,-7.568000,4.608000],[-92.774002,-5.764000,6.400000],[-92.984001,-6.758000,5.586000],[-93.192001,-7.598001,4.626000],[-93.240005,-7.640000,4.652000],[-93.032005,-6.794000,5.618000],[-92.820007,-5.794000,6.436000],[-92.566002,-4.648000,7.056000],[-92.612007,-4.672000,7.096000],[-91.234001,3.968000,6.568000],[-91.444008,2.866000,7.276000],[-91.396004,2.842000,7.216001],[-91.188004,3.938000,6.514000],[-91.606003,1.656000,7.724000],[-91.652008,1.670000,7.788001],[-91.306007,4.002000,6.626000],[-91.516006,2.890000,7.342000],[-91.724007,1.682000,7.858000],[-91.834007,1.696000,7.932000],[-91.626007,2.914000,7.410000],[-91.416008,4.036000,6.688000],[-91.024002,4.958000,5.692000],[-91.096001,5.000000,5.744000],[-91.206001,5.044000,5.796000],[-90.978004,4.920000,5.644000],[-90.986008,7.290000,2.426000],[-90.776001,7.634000,1.114000],[-91.102005,7.692000,1.124000],[-91.312004,7.346000,2.448000],[-90.746002,7.230000,2.404000],[-90.536003,7.572001,1.102000],[-91.194008,6.744000,3.682000],[-90.956001,6.688000,3.648000],[-91.164001,5.968000,4.808000],[-91.404007,6.016000,4.850000],[-91.522003,6.794000,3.712000],[-91.732002,6.062000,4.890000],[-93.780006,4.198000,6.972000],[-93.570007,5.246000,6.042000],[-94.272003,5.256000,6.056000],[-94.482002,4.206000,6.986001],[-95.212006,4.210000,6.992000],[-95.004005,5.260000,6.062000],[-93.136002,4.182000,6.946000],[-92.926003,5.228000,6.020000],[-92.374008,5.202000,5.990000],[-92.584007,4.162000,6.910000],[-93.990005,3.028000,7.722001],[-93.346001,3.018000,7.694000],[-92.794006,3.004000,7.654000],[-93.004005,1.748000,8.192000],[-93.556007,1.756000,8.234000],[-94.200005,1.762000,8.264000],[-94.692001,3.036000,7.738000],[-94.902008,1.766000,8.284000],[-95.632004,1.768000,8.288000],[-95.422005,3.038000,7.746000],[-96.640007,4.198000,6.972000],[-95.942001,4.206000,6.986001],[-95.734001,5.256000,6.056000],[-96.430008,5.246000,6.042000],[-96.850006,3.028000,7.722001],[-96.152008,3.036000,7.738000],[-96.362007,1.766000,8.284000],[-97.060005,1.762000,8.264000],[-97.274002,4.182000,6.946000],[-97.484001,3.018000,7.694000],[-97.694008,1.756000,8.234000],[-98.236008,1.748000,8.192000],[-98.026001,3.004000,7.654000],[-97.816002,4.162000,6.910000],[-97.064003,5.228000,6.020000],[-97.606003,5.202000,5.990000],[-97.706001,7.290000,2.426000],[-97.396004,7.346000,2.448000],[-97.184006,7.692000,1.124000],[-97.496002,7.634000,1.114000],[-97.916008,6.744000,3.682000],[-97.606003,6.794000,3.712000],[-97.814003,6.062000,4.890000],[-98.126007,6.016000,4.850000],[-97.928001,7.230000,2.404000],[-98.138008,6.688000,3.648000],[-98.346008,5.968000,4.808000],[-98.494003,5.914001,4.762000],[-98.284004,6.630000,3.614000],[-98.076004,7.166000,2.380000],[-97.718002,7.572001,1.102000],[-97.866005,7.506001,1.090000],[-96.546005,3.968000,-7.024000],[-96.754005,4.958000,-6.148000],[-96.702003,5.000000,-6.200000],[-96.494003,4.002000,-7.084000],[-96.912003,5.864000,-5.174000],[-96.964005,5.814000,-5.132000],[-96.576004,3.938000,-6.970000],[-96.786003,4.920000,-6.100000],[-96.996002,5.768000,-5.094000],[-97.020004,5.730000,-5.060000],[-96.810005,4.886000,-6.060000],[-96.602005,3.910000,-6.924000],[-96.338005,2.866000,-7.732000],[-96.368004,2.842000,-7.674000],[-96.392006,2.824000,-7.622000],[-96.282005,2.890000,-7.798000],[-95.010002,-5.740000,-6.832000],[-94.964005,-5.764000,-6.856000],[-94.756004,-6.758000,-6.042000],[-94.802002,-6.730000,-6.020000],[-95.218002,-4.628000,-7.486001],[-95.174004,-4.648000,-7.514000],[-95.384003,-3.442000,-8.004001],[-95.428001,-3.428000,-7.974000],[-95.062004,-5.726000,-6.816000],[-95.270004,-4.618000,-7.468000],[-95.480003,-3.420000,-7.956000],[-95.534004,-3.418000,-7.950000],[-95.326004,-4.614000,-7.464000],[-95.116005,-5.724000,-6.810000],[-94.852005,-6.716001,-6.008000],[-94.908005,-6.710001,-6.002000],[-93.558006,-8.684000,2.324000],[-93.766006,-8.962001,1.064000],[-93.710007,-8.942000,1.062000],[-93.502007,-8.664001,2.320000],[-93.920006,-9.032001,-0.228000],[-93.976006,-9.054001,-0.228000],[-93.610008,-8.718000,2.334000],[-93.820007,-8.996000,1.070000],[-94.028008,-9.090000,-0.228000],[-94.076004,-9.140000,-0.228000],[-93.866005,-9.046000,1.078000],[-93.658005,-8.764001,2.348000],[-93.348007,-8.218000,3.516000],[-93.400002,-8.250000,3.532000],[-93.448006,-8.296000,3.552000],[-93.292007,-8.198000,3.508000],[-92.072006,-0.908000,8.152000],[-92.024002,-0.900000,8.086000],[-91.814003,0.398000,8.010000],[-91.862007,0.400000,8.078000],[-92.280006,-2.224000,8.026000],[-92.234001,-2.206000,7.958000],[-92.442001,-3.486000,7.644001],[-92.490005,-3.514000,7.706000],[-92.142006,-0.918000,8.226001],[-92.352005,-2.244000,8.098001],[-92.562004,-3.546000,7.776000],[-92.672005,-3.578000,7.846000],[-92.464005,-2.266000,8.172000],[-92.254005,-0.926000,8.302000],[-91.932007,0.402000,8.148001],[-92.044006,0.406000,8.224000],[-91.824005,4.106000,6.810000],[-92.152008,4.136000,6.864000],[-92.360001,2.984000,7.602000],[-92.034004,2.964000,7.542000],[-92.242004,1.724000,8.074000],[-92.570007,1.736000,8.138000],[-91.614006,5.132000,5.902000],[-91.942001,5.168000,5.948000],[-91.584007,4.072000,6.750000],[-91.374001,5.088000,5.850000],[-91.794006,2.940000,7.478000],[-92.004005,1.710000,8.004001],[-94.618004,-0.970000,8.650001],[-95.322006,-0.972000,8.670000],[-95.530006,-2.368000,8.534000],[-94.828003,-2.362000,8.516001],[-95.038002,-3.730000,8.178000],[-95.740005,-3.736000,8.196000],[-96.472008,-3.740000,8.202001],[-96.262001,-2.370000,8.540000],[-96.052002,-0.972000,8.676001],[-94.408005,0.418000,8.570001],[-95.112007,0.418000,8.590000],[-95.842003,0.418000,8.596001],[-93.976006,-0.966000,8.618000],[-93.766006,0.416000,8.538000],[-93.214005,0.414000,8.494000],[-93.422005,-0.958000,8.574000],[-94.186005,-2.354000,8.484000],[-93.632004,-2.342000,8.440001],[-93.842003,-3.696000,8.106000],[-94.396004,-3.716000,8.148001],[-97.480003,-0.970000,8.650001],[-97.690002,-2.362000,8.516001],[-96.992004,-2.368000,8.534000],[-96.782005,-0.972000,8.670000],[-97.202003,-3.736000,8.196000],[-97.898003,-3.730000,8.178000],[-98.114006,-0.966000,8.618000],[-98.324005,-2.354000,8.484000],[-98.534004,-3.716000,8.148001],[-99.074005,-3.696000,8.106000],[-98.864006,-2.342000,8.440001],[-98.654007,-0.958000,8.574000],[-97.270004,0.418000,8.570001],[-97.904007,0.416000,8.538000],[-98.446007,0.414000,8.494000],[-96.572006,0.418000,8.590000],[-98.544006,4.106000,6.810000],[-98.754005,2.964000,7.542000],[-98.444008,2.984000,7.602000],[-98.234001,4.136000,6.864000],[-98.654007,1.736000,8.138000],[-98.964005,1.724000,8.074000],[-98.766006,4.072000,6.750000],[-98.976006,2.940000,7.478000],[-99.184006,1.710000,8.004001],[-99.332008,1.696000,7.932000],[-99.122002,2.914000,7.410000],[-98.914001,4.036000,6.688000],[-98.334007,5.132000,5.902000],[-98.556007,5.088000,5.850000],[-98.704002,5.044000,5.796000],[-98.024002,5.168000,5.948000],[-97.382004,7.044000,-2.792000],[-97.330002,7.104001,-2.814000],[-97.120003,6.572001,-4.038000],[-97.174004,6.516000,-4.004000],[-97.592003,7.376000,-1.524000],[-97.540001,7.440001,-1.536000],[-97.748001,7.558001,-0.228000],[-97.802002,7.494000,-0.228000],[-97.412003,6.988000,-2.772000],[-97.622002,7.318000,-1.514000],[-97.832008,7.434000,-0.228000],[-97.856003,7.384000,-0.228000],[-97.646004,7.268000,-1.506000],[-97.438004,6.940001,-2.754000],[-97.204002,6.464000,-3.974000],[-97.230003,6.420000,-3.948000],[-95.846008,-0.884000,-8.410001],[-96.056007,0.394000,-8.334001],[-96.010002,0.394000,-8.366000],[-95.802002,-0.888000,-8.440001],[-96.218002,1.638000,-8.084001],[-96.264008,1.632000,-8.054001],[-95.896004,-0.882000,-8.390000],[-96.106003,0.392000,-8.316000],[-96.316002,1.628000,-8.036000],[-96.370003,1.628000,-8.030001],[-96.160004,0.392000,-8.310000],[-95.952003,-0.880000,-8.384001],[-95.638008,-2.170000,-8.284000],[-95.688004,-2.162000,-8.266001],[-95.744003,-2.162000,-8.260000],[-95.592003,-2.178000,-8.316000],[-94.394005,-8.684000,-2.782000],[-94.338005,-8.664001,-2.776000],[-94.128006,-8.942000,-1.520000],[-94.184006,-8.962001,-1.522000],[-94.602005,-8.218000,-3.974000],[-94.546005,-8.198000,-3.964000],[-94.756004,-7.550000,-5.054000],[-94.812004,-7.568000,-5.066000],[-94.446007,-8.718000,-2.792000],[-94.656006,-8.250000,-3.988000],[-94.864006,-7.598001,-5.084000],[-94.912003,-7.640000,-5.110000],[-94.702003,-8.296000,-4.008000],[-94.494003,-8.764001,-2.806000],[-94.238007,-8.996000,-1.526000],[-94.286003,-9.046000,-1.534000],[-92.908005,-5.884000,6.536000],[-93.118004,-6.898000,5.706000],[-93.070007,-6.842000,5.658000],[-92.862007,-5.836000,6.482000],[-93.278008,-7.694000,4.686000],[-93.326004,-7.754000,4.726000],[-92.980003,-5.936000,6.594000],[-93.190002,-6.960001,5.758000],[-93.398003,-7.824000,4.770000],[-93.510002,-7.894001,4.814000],[-93.302002,-7.022000,5.812000],[-93.092003,-5.990000,6.656000],[-92.698006,-4.744000,7.206000],[-92.770004,-4.788000,7.270000],[-92.882004,-4.832000,7.338000],[-92.652008,-4.706000,7.148000],[-92.662003,-0.946000,8.450001],[-92.452003,0.412000,8.372001],[-92.780006,0.414000,8.438001],[-92.990005,-0.952000,8.518001],[-92.422005,-0.936000,8.378000],[-92.212006,0.408000,8.300000],[-92.872002,-2.308000,8.318001],[-92.630005,-2.286000,8.246000],[-92.842003,-3.610000,7.920001],[-93.082001,-3.642000,7.988000],[-93.200005,-2.326000,8.384001],[-93.410004,-3.672000,8.052000],[-95.458008,-6.240000,6.938000],[-95.248001,-5.032000,7.648000],[-95.950005,-5.044000,7.664001],[-96.160004,-6.254000,6.952000],[-96.892006,-6.258000,6.958000],[-96.682007,-5.048000,7.670001],[-94.814003,-6.218000,6.912000],[-94.604004,-5.014000,7.620000],[-94.052002,-4.988000,7.580000],[-94.262001,-6.184000,6.876000],[-95.668007,-7.314000,6.058000],[-95.024002,-7.288001,6.036000],[-94.472008,-7.250000,6.004000],[-94.682007,-8.152000,4.976000],[-95.236008,-8.192000,5.002000],[-95.878006,-8.222000,5.020000],[-96.372002,-7.330000,6.072001],[-96.580002,-8.240001,5.032000],[-97.312004,-8.246000,5.036000],[-97.102005,-7.336000,6.076000],[-98.318008,-6.240000,6.938000],[-97.622002,-6.254000,6.952000],[-97.412003,-5.044000,7.664001],[-98.108002,-5.032000,7.648000],[-98.528008,-7.314000,6.058000],[-97.832008,-7.330000,6.072001],[-98.042007,-8.240001,5.032000],[-98.738007,-8.222000,5.020000],[-98.952003,-6.218000,6.912000],[-99.162003,-7.288001,6.036000],[-99.372002,-8.192000,5.002000],[-99.914001,-8.152000,4.976000],[-99.704002,-7.250000,6.004000],[-99.494003,-6.184000,6.876000],[-98.744003,-5.014000,7.620000],[-99.284004,-4.988000,7.580000],[-99.382004,-0.946000,8.450001],[-99.072006,-0.952000,8.518001],[-98.864006,0.414000,8.438001],[-99.174004,0.412000,8.372001],[-99.592003,-2.308000,8.318001],[-99.282005,-2.326000,8.384001],[-99.492004,-3.672000,8.052000],[-99.802002,-3.642000,7.988000],[-99.602005,-0.936000,8.378000],[-99.814003,-2.286000,8.246000],[-100.022003,-3.610000,7.920001],[-100.170006,-3.578000,7.846000],[-99.960007,-2.266000,8.172000],[-99.752007,-0.926000,8.302000],[-99.394005,0.408000,8.300000],[-99.542007,0.406000,8.224000],[-98.220001,7.044000,2.336000],[-98.430008,6.516000,3.548000],[-98.376007,6.572001,3.580000],[-98.168007,7.104001,2.358000],[-98.586006,5.864000,4.718000],[-98.638008,5.814000,4.676000],[-98.250008,6.988000,2.316000],[-98.460007,6.464000,3.516000],[-98.668007,5.768000,4.636000],[-98.692001,5.730000,4.602000],[-98.484001,6.420000,3.492000],[-98.274002,6.940001,2.298000],[-98.010002,7.376000,1.068000],[-98.040001,7.318000,1.058000],[-98.066002,7.268000,1.048000],[-97.958008,7.440001,1.078000],[-96.682007,3.876000,-6.862000],[-96.638008,3.890000,-6.888000],[-96.428001,2.810000,-7.582000],[-96.472008,2.798000,-7.554000],[-96.890007,4.842000,-6.008000],[-96.846008,4.860000,-6.030000],[-97.056007,5.700000,-5.034000],[-97.100006,5.678000,-5.016000],[-96.734001,3.866000,-6.846000],[-96.942001,4.830000,-5.994000],[-97.152008,5.664000,-5.004000],[-97.206001,5.660000,-5.000000],[-96.998001,4.828000,-5.988000],[-96.788002,3.864000,-6.842000],[-96.524002,2.792000,-7.536000],[-96.578003,2.792000,-7.532001],[-95.230003,-5.740000,-6.832000],[-95.438004,-4.628000,-7.486001],[-95.382004,-4.618000,-7.468000],[-95.174004,-5.726000,-6.816000],[-95.592003,-3.420000,-7.956000],[-95.648003,-3.428000,-7.974000],[-95.282005,-5.764000,-6.856000],[-95.492004,-4.648000,-7.514000],[-95.700005,-3.442000,-8.004001],[-95.748001,-3.460000,-8.046000],[-95.540001,-4.672000,-7.554000],[-95.330002,-5.794000,-6.892000],[-95.020004,-6.730000,-6.020000],[-95.074005,-6.758000,-6.042000],[-95.122002,-6.794000,-6.074000],[-94.964005,-6.716001,-6.008000],[-93.746002,-8.898001,2.388000],[-93.698006,-8.826000,2.366000],[-93.488007,-8.354000,3.578000],[-93.536003,-8.422000,3.608000],[-93.954002,-9.184000,1.096000],[-93.906006,-9.110001,1.086000],[-94.116005,-9.204000,-0.228000],[-94.164001,-9.278001,-0.228000],[-93.818001,-8.976001,2.410000],[-94.026001,-9.264001,1.108000],[-94.236008,-9.360001,-0.228000],[-94.348007,-9.446000,-0.228000],[-94.138008,-9.348001,1.120000],[-93.930008,-9.058001,2.434000],[-93.608002,-8.496000,3.642000],[-93.720001,-8.574000,3.676000],[-93.500008,-6.096000,6.776000],[-93.828003,-6.144000,6.830000],[-94.038002,-7.204000,5.964000],[-93.710007,-7.148000,5.918000],[-93.920006,-8.036000,4.902000],[-94.248001,-8.096001,4.942000],[-93.290001,-4.916000,7.470000],[-93.618004,-4.956000,7.530000],[-93.260002,-6.046000,6.718000],[-93.050003,-4.876000,7.406000],[-93.468002,-7.086000,5.864000],[-93.678001,-7.966001,4.860000],[-96.298004,-9.432000,2.544000],[-97.000008,-9.454000,2.548000],[-97.210007,-9.756001,1.178000],[-96.506004,-9.734000,1.176000],[-96.718002,-9.836000,-0.228000],[-97.420006,-9.858001,-0.228000],[-98.152008,-9.864000,-0.228000],[-97.942001,-9.764001,1.180000],[-97.730003,-9.460000,2.550000],[-96.088005,-8.928000,3.836000],[-96.790001,-8.948000,3.846000],[-97.522003,-8.954000,3.848000],[-95.654007,-9.398001,2.534000],[-95.444008,-8.896001,3.822000],[-94.890007,-8.850000,3.802000],[-95.100006,-9.352000,2.520000],[-95.864006,-9.700001,1.170000],[-95.310005,-9.650001,1.164000],[-95.520004,-9.752001,-0.228000],[-96.074005,-9.800000,-0.228000],[-99.158005,-9.432000,2.544000],[-99.368004,-9.734000,1.176000],[-98.670006,-9.756001,1.178000],[-98.460007,-9.454000,2.548000],[-98.880005,-9.858001,-0.228000],[-99.578003,-9.836000,-0.228000],[-99.792007,-9.398001,2.534000],[-100.002007,-9.700001,1.170000],[-100.212006,-9.800000,-0.228000],[-100.752007,-9.752001,-0.228000],[-100.542007,-9.650001,1.164000],[-100.332008,-9.352000,2.520000],[-98.948006,-8.928000,3.836000],[-99.582008,-8.896001,3.822000],[-100.124008,-8.850000,3.802000],[-98.250008,-8.948000,3.846000],[-100.222008,-6.096000,6.776000],[-100.430008,-7.148000,5.918000],[-100.122002,-7.204000,5.964000],[-99.912003,-6.144000,6.830000],[-100.330002,-8.096001,4.942000],[-100.640007,-8.036000,4.902000],[-100.442001,-6.046000,6.718000],[-100.650002,-7.086000,5.864000],[-100.860008,-7.966001,4.860000],[-101.006004,-7.894001,4.814000],[-100.798004,-7.022000,5.812000],[-100.588005,-5.990000,6.656000],[-100.012001,-4.916000,7.470000],[-100.232002,-4.876000,7.406000],[-100.380005,-4.832000,7.338000],[-99.702003,-4.956000,7.530000],[-99.056007,3.968000,6.568000],[-99.004005,4.002000,6.626000],[-98.796005,5.000000,5.744000],[-98.848007,4.958000,5.692000],[-99.266006,2.866000,7.276000],[-99.214005,2.890000,7.342000],[-99.424004,1.682000,7.858000],[-99.476006,1.670000,7.788001],[-99.086006,3.938000,6.514000],[-99.296005,2.842000,7.216001],[-99.504005,1.656000,7.724000],[-99.528008,1.646000,7.670001],[-99.320007,2.824000,7.166000],[-99.112007,3.910000,6.466000],[-98.878006,4.920000,5.644000],[-98.900002,4.886000,5.604000],[-97.518005,6.878000,-2.730000],[-97.728004,7.202000,-1.494000],[-97.682007,7.230000,-1.498000],[-97.474007,6.904000,-2.740000],[-97.892006,7.346000,-0.228000],[-97.936005,7.318000,-0.228000],[-97.568008,6.862000,-2.726000],[-97.778008,7.186000,-1.490000],[-97.986008,7.300000,-0.228000],[-97.832008,7.180000,-1.490000],[-98.042007,7.294000,-0.228000],[-97.624008,6.858000,-2.722000],[-97.310005,6.362000,-3.914000],[-97.360008,6.348001,-3.906000],[-97.416008,6.344000,-3.902000],[-97.264008,6.386000,-3.928000],[-96.066002,-0.884000,-8.410001],[-96.008003,-0.882000,-8.390000],[-95.800003,-2.162000,-8.266001],[-95.856003,-2.170000,-8.284000],[-96.274002,0.394000,-8.334001],[-96.218002,0.392000,-8.316000],[-96.428001,1.628000,-8.036000],[-96.484001,1.632000,-8.054001],[-96.118004,-0.888000,-8.440001],[-96.328003,0.394000,-8.366000],[-96.538002,1.638000,-8.084001],[-96.584007,1.646000,-8.126000],[-96.376007,0.396000,-8.410001],[-96.168007,-0.894000,-8.484000],[-95.910004,-2.178000,-8.316000],[-95.958008,-2.190000,-8.360001],[-94.582001,-8.898001,-2.844000],[-94.790001,-8.422000,-4.066000],[-94.744003,-8.354000,-4.036000],[-94.534004,-8.826000,-2.824000],[-94.952003,-7.694000,-5.144000],[-95.000008,-7.754000,-5.184000],[-94.654007,-8.976001,-2.866000],[-94.864006,-8.496000,-4.100000],[-95.072006,-7.824000,-5.226000],[-95.186005,-7.894001,-5.272000],[-94.976006,-8.574000,-4.134000],[-94.768005,-9.058001,-2.890000],[-94.374008,-9.184000,-1.554000],[-94.446007,-9.264001,-1.566000],[-94.556007,-9.348001,-1.576000],[-94.324005,-9.110001,-1.542000],[-94.338005,-9.218000,2.480000],[-94.130005,-8.724000,3.744000],[-94.458008,-8.792001,3.776000],[-94.668007,-9.290001,2.502000],[-94.098007,-9.140000,2.458000],[-93.888008,-8.650001,3.712000],[-94.548004,-9.514001,1.144000],[-94.306007,-9.432000,1.132000],[-94.516006,-9.532001,-0.228000],[-94.758003,-9.612000,-0.228000],[-94.876007,-9.588000,1.154000],[-95.086006,-9.688001,-0.228000],[-97.138008,-9.432000,-3.000000],[-96.928001,-9.734000,-1.632000],[-97.630005,-9.756001,-1.634000],[-97.840004,-9.454000,-3.006000],[-98.572006,-9.460000,-3.008000],[-98.362007,-9.764001,-1.636000],[-96.494003,-9.398001,-2.990000],[-96.284004,-9.700001,-1.628000],[-95.730003,-9.650001,-1.620000],[-95.940002,-9.352000,-2.976000],[-97.348007,-8.928000,-4.292000],[-96.704002,-8.896001,-4.280000],[-96.150002,-8.850000,-4.260000],[-96.360008,-8.152000,-5.432000],[-96.914001,-8.192000,-5.460000],[-97.556007,-8.222000,-5.478000],[-98.050003,-8.948000,-4.302000],[-98.260002,-8.240001,-5.490000],[-98.990005,-8.246000,-5.494000],[-98.780006,-8.954000,-4.306000],[-99.996002,-9.432000,-3.000000],[-99.300003,-9.454000,-3.006000],[-99.090004,-9.756001,-1.634000],[-99.788002,-9.734000,-1.632000],[-100.206001,-8.928000,-4.292000],[-99.510002,-8.948000,-4.302000],[-99.720001,-8.240001,-5.490000],[-100.416008,-8.222000,-5.478000],[-100.630005,-9.398001,-2.990000],[-100.840004,-8.896001,-4.280000],[-101.050003,-8.192000,-5.460000],[-101.592003,-8.152000,-5.432000],[-101.382004,-8.850000,-4.260000],[-101.172005,-9.352000,-2.976000],[-100.422005,-9.700001,-1.628000],[-100.962006,-9.650001,-1.620000],[-101.060005,-9.218000,2.480000],[-100.750008,-9.290001,2.502000],[-100.540009,-8.792001,3.776000],[-100.850006,-8.724000,3.744000],[-101.270004,-9.514001,1.144000],[-100.960007,-9.588000,1.154000],[-101.170006,-9.688001,-0.228000],[-101.478004,-9.612000,-0.228000],[-101.280006,-9.140000,2.458000],[-101.488007,-9.432000,1.132000],[-101.698006,-9.532001,-0.228000],[-101.844002,-9.446000,-0.228000],[-101.636002,-9.348001,1.120000],[-101.426003,-9.058001,2.434000],[-101.070007,-8.650001,3.712000],[-101.216003,-8.574000,3.676000],[-99.894005,-0.908000,8.152000],[-100.102005,-2.224000,8.026000],[-100.050003,-2.244000,8.098001],[-99.842003,-0.918000,8.226001],[-100.260002,-3.546000,7.776000],[-100.312004,-3.514000,7.706000],[-99.922005,-0.900000,8.086000],[-100.132004,-2.206000,7.958000],[-100.342003,-3.486000,7.644001],[-100.366005,-3.460000,7.590000],[-100.156006,-2.190000,7.904000],[-99.946007,-0.894000,8.028001],[-99.684006,0.400000,8.078000],[-99.714005,0.398000,8.010000],[-99.738007,0.396000,7.954000],[-99.634003,0.402000,8.148001],[-98.354004,6.878000,2.274000],[-98.310005,6.904000,2.284000],[-98.100006,7.230000,1.042000],[-98.144005,7.202000,1.036000],[-98.562004,6.362000,3.458000],[-98.518005,6.386000,3.472000],[-98.728004,5.700000,4.578000],[-98.772003,5.678000,4.558000],[-98.406006,6.862000,2.268000],[-98.614006,6.348001,3.448000],[-98.822006,5.664000,4.548000],[-98.878006,5.660000,4.544000],[-98.668007,6.344000,3.446000],[-98.460007,6.858000,2.266000],[-98.196007,7.186000,1.034000],[-98.250008,7.180000,1.032000],[-96.902008,3.876000,-6.862000],[-97.110008,4.842000,-6.008000],[-97.054001,4.830000,-5.994000],[-96.846008,3.866000,-6.846000],[-97.262001,5.664000,-5.004000],[-97.320007,5.678000,-5.016000],[-96.954002,3.890000,-6.888000],[-97.164001,4.860000,-6.030000],[-97.372002,5.700000,-5.034000],[-97.422005,5.730000,-5.060000],[-97.212006,4.886000,-6.060000],[-97.002007,3.910000,-6.924000],[-96.692001,2.798000,-7.554000],[-96.746002,2.810000,-7.582000],[-96.794006,2.824000,-7.622000],[-96.636002,2.792000,-7.536000],[-95.418007,-5.884000,-6.992000],[-95.370003,-5.836000,-6.938000],[-95.160004,-6.842000,-6.114000],[-95.210007,-6.898000,-6.162000],[-95.628006,-4.744000,-7.664001],[-95.580002,-4.706000,-7.604001],[-95.788002,-3.486000,-8.100000],[-95.838005,-3.514000,-8.162001],[-95.492004,-5.936000,-7.052001],[-95.700005,-4.788000,-7.728000],[-95.910004,-3.546000,-8.232000],[-96.024002,-3.578000,-8.304001],[-95.814003,-4.832000,-7.796000],[-95.604004,-5.990000,-7.114000],[-95.282005,-6.960001,-6.214000],[-95.394005,-7.022000,-6.268000],[-95.178001,-9.218000,-2.936000],[-95.506004,-9.290001,-2.958000],[-95.716003,-8.792001,-4.232000],[-95.386002,-8.724000,-4.202000],[-95.596008,-8.036000,-5.360000],[-95.926003,-8.096001,-5.398000],[-94.968002,-9.514001,-1.600000],[-95.296005,-9.588000,-1.610000],[-94.936005,-9.140000,-2.914000],[-94.726006,-9.432000,-1.590000],[-95.146004,-8.650001,-4.168000],[-95.354004,-7.966001,-5.316000],[-97.976006,-6.240000,-7.394001],[-98.680008,-6.254000,-7.410000],[-98.888008,-5.044000,-8.122001],[-98.186005,-5.032000,-8.104000],[-98.396004,-3.730000,-8.634001],[-99.098007,-3.736000,-8.654000],[-99.830002,-3.740000,-8.658000],[-99.620003,-5.048000,-8.128000],[-99.410004,-6.258000,-7.416000],[-97.766006,-7.314000,-6.514000],[-98.470001,-7.330000,-6.528000],[-99.200005,-7.336000,-6.534000],[-97.332008,-6.218000,-7.368001],[-97.124008,-7.288001,-6.492000],[-96.568001,-7.250000,-6.460001],[-96.778008,-6.184000,-7.334000],[-97.542007,-5.014000,-8.078000],[-96.988007,-4.988000,-8.036000],[-97.198006,-3.696000,-8.562000],[-97.752007,-3.716000,-8.604000],[-100.838005,-6.240000,-7.394001],[-101.046005,-5.032000,-8.104000],[-100.348007,-5.044000,-8.122001],[-100.140007,-6.254000,-7.410000],[-100.560005,-3.736000,-8.654000],[-101.256004,-3.730000,-8.634001],[-101.472008,-6.218000,-7.368001],[-101.680008,-5.014000,-8.078000],[-101.890007,-3.716000,-8.604000],[-102.430008,-3.696000,-8.562000],[-102.220001,-4.988000,-8.036000],[-102.010002,-6.184000,-7.334000],[-100.626007,-7.314000,-6.514000],[-101.260002,-7.288001,-6.492000],[-101.800003,-7.250000,-6.460001],[-99.930008,-7.330000,-6.528000],[-101.898003,-9.218000,-2.936000],[-102.108002,-8.724000,-4.202000],[-101.798004,-8.792001,-4.232000],[-101.588005,-9.290001,-2.958000],[-102.008003,-8.096001,-5.398000],[-102.318008,-8.036000,-5.360000],[-102.118004,-9.140000,-2.914000],[-102.326004,-8.650001,-4.168000],[-102.536003,-7.966001,-5.316000],[-102.682007,-7.894001,-5.272000],[-102.474007,-8.574000,-4.134000],[-102.264008,-9.058001,-2.890000],[-101.688004,-9.514001,-1.600000],[-101.908005,-9.432000,-1.590000],[-102.054008,-9.348001,-1.576000],[-101.380005,-9.588000,-1.610000],[-100.730003,-5.884000,6.536000],[-100.680008,-5.936000,6.594000],[-100.470001,-4.788000,7.270000],[-100.522003,-4.744000,7.206000],[-100.940002,-6.898000,5.706000],[-100.888008,-6.960001,5.758000],[-101.098007,-7.824000,4.770000],[-101.150002,-7.754000,4.726000],[-100.760002,-5.836000,6.482000],[-100.970001,-6.842000,5.658000],[-101.178001,-7.694000,4.686000],[-101.200005,-7.640000,4.652000],[-100.992004,-6.794000,5.618000],[-100.782005,-5.794000,6.436000],[-100.550003,-4.706000,7.148000],[-100.574005,-4.672000,7.096000],[-99.190002,3.876000,6.406000],[-99.400002,2.798000,7.098001],[-99.356003,2.810000,7.124001],[-99.146004,3.890000,6.432000],[-99.564003,1.638000,7.626000],[-99.608002,1.632000,7.596000],[-99.240005,3.866000,6.390000],[-99.450005,2.792000,7.080000],[-99.658005,1.628000,7.578001],[-99.714005,1.628000,7.572001],[-99.504005,2.792000,7.074000],[-99.296005,3.864000,6.386000],[-98.982002,4.842000,5.550000],[-99.032005,4.830000,5.538000],[-99.088005,4.828000,5.532000],[-98.936005,4.860000,5.572000],[-97.738007,6.878000,-2.730000],[-97.680008,6.862000,-2.726000],[-97.472008,6.348001,-3.906000],[-97.528008,6.362000,-3.914000],[-97.946007,7.202000,-1.494000],[-97.890007,7.186000,-1.490000],[-98.098007,7.300000,-0.228000],[-98.154007,7.318000,-0.228000],[-97.792007,6.904000,-2.740000],[-98.000008,7.230000,-1.498000],[-98.210007,7.346000,-0.228000],[-98.258003,7.384000,-0.228000],[-98.048004,7.268000,-1.506000],[-97.840004,6.940001,-2.754000],[-97.582008,6.386000,-3.928000],[-97.630005,6.420000,-3.948000],[-96.256004,-0.908000,-8.610001],[-96.466003,0.400000,-8.534000],[-96.416008,0.398000,-8.468000],[-96.208008,-0.900000,-8.542001],[-96.626007,1.656000,-8.182000],[-96.674004,1.670000,-8.246000],[-96.328003,-0.918000,-8.682000],[-96.538002,0.402000,-8.606000],[-96.748001,1.682000,-8.314000],[-96.860008,1.696000,-8.388000],[-96.652008,0.406000,-8.680000],[-96.442001,-0.926000,-8.758000],[-96.046005,-2.224000,-8.482000],[-96.120003,-2.244000,-8.554001],[-96.232002,-2.266000,-8.630000],[-95.998001,-2.206000,-8.416000],[-96.016006,-6.096000,-7.232000],[-95.806007,-7.148000,-6.374000],[-96.134003,-7.204000,-6.420000],[-96.344002,-6.144000,-7.288001],[-95.774002,-6.046000,-7.174000],[-95.564003,-7.086000,-6.322001],[-96.226006,-4.916000,-7.928000],[-95.984001,-4.876000,-7.864000],[-96.192001,-3.610000,-8.376000],[-96.434006,-3.642000,-8.446000],[-96.554001,-4.956000,-7.986001],[-96.764008,-3.672000,-8.508000],[-98.816002,-0.970000,-9.108001],[-98.606003,-2.362000,-8.972000],[-99.308006,-2.368000,-8.992001],[-99.518005,-0.972000,-9.126000],[-100.250008,-0.972000,-9.132000],[-100.040009,-2.370000,-8.998000],[-98.172005,-0.966000,-9.076000],[-97.962006,-2.354000,-8.942000],[-97.408005,-2.342000,-8.898001],[-97.618004,-0.958000,-9.030001],[-99.026001,0.418000,-9.026000],[-98.382004,0.416000,-8.996000],[-97.828003,0.414000,-8.952001],[-98.036003,1.748000,-8.648001],[-98.592003,1.756000,-8.692000],[-99.236008,1.762000,-8.722000],[-99.728004,0.418000,-9.046000],[-99.938004,1.766000,-8.740001],[-100.670006,1.768000,-8.746000],[-100.460007,0.418000,-9.052000],[-101.676003,-0.970000,-9.108001],[-100.980003,-0.972000,-9.126000],[-100.770004,-2.368000,-8.992001],[-101.466003,-2.362000,-8.972000],[-101.886002,0.418000,-9.026000],[-101.190002,0.418000,-9.046000],[-101.400002,1.766000,-8.740001],[-102.096008,1.762000,-8.722000],[-102.310005,-0.966000,-9.076000],[-102.518005,0.416000,-8.996000],[-102.730003,1.756000,-8.692000],[-103.268005,1.748000,-8.648001],[-103.060005,0.414000,-8.952001],[-102.850006,-0.958000,-9.030001],[-102.100006,-2.354000,-8.942000],[-102.640007,-2.342000,-8.898001],[-102.736008,-6.096000,-7.232000],[-102.428001,-6.144000,-7.288001],[-102.218002,-7.204000,-6.420000],[-102.526009,-7.148000,-6.374000],[-102.946007,-4.916000,-7.928000],[-102.638008,-4.956000,-7.986001],[-102.846008,-3.672000,-8.508000],[-103.156006,-3.642000,-8.446000],[-102.956001,-6.046000,-7.174000],[-103.166008,-4.876000,-7.864000],[-103.374008,-3.610000,-8.376000],[-103.520004,-3.578000,-8.304001],[-103.310005,-4.832000,-7.796000],[-103.102005,-5.990000,-7.114000],[-102.746002,-7.086000,-6.322001],[-102.892006,-7.022000,-6.268000],[-101.568008,-8.898001,2.388000],[-101.776009,-9.184000,1.096000],[-101.726006,-9.264001,1.108000],[-101.516006,-8.976001,2.410000],[-101.936005,-9.360001,-0.228000],[-101.986008,-9.278001,-0.228000],[-101.596008,-8.826000,2.366000],[-101.806007,-9.110001,1.086000],[-102.014008,-9.204000,-0.228000],[-102.038002,-9.140000,-0.228000],[-101.828003,-9.046000,1.078000],[-101.620003,-8.764001,2.348000],[-101.358002,-8.422000,3.608000],[-101.386002,-8.354000,3.578000],[-101.410004,-8.296000,3.552000],[-101.308006,-8.496000,3.642000],[-100.026001,-0.884000,7.952000],[-99.982002,-0.888000,7.984000],[-99.772003,0.394000,7.910000],[-99.816002,0.394000,7.878000],[-100.234001,-2.170000,7.828001],[-100.190002,-2.178000,7.860001],[-100.400002,-3.442000,7.546000],[-100.444008,-3.428000,7.518000],[-100.076004,-0.882000,7.934000],[-100.284004,-2.162000,7.810000],[-100.494003,-3.420000,7.498000],[-100.548004,-3.418000,7.492001],[-100.340004,-2.162000,7.802001],[-100.132004,-0.880000,7.926001],[-99.868004,0.392000,7.860001],[-99.922005,0.392000,7.854001],[-98.574005,6.878000,2.274000],[-98.782005,6.362000,3.458000],[-98.726006,6.348001,3.448000],[-98.518005,6.862000,2.268000],[-98.934006,5.664000,4.548000],[-98.992004,5.678000,4.558000],[-98.626007,6.904000,2.284000],[-98.836006,6.386000,3.472000],[-99.046005,5.700000,4.578000],[-99.094002,5.730000,4.602000],[-98.884003,6.420000,3.492000],[-98.676003,6.940001,2.298000],[-98.364006,7.202000,1.036000],[-98.418007,7.230000,1.042000],[-98.466003,7.268000,1.048000],[-98.308006,7.186000,1.034000],[-97.094002,3.968000,-7.024000],[-97.044006,3.938000,-6.970000],[-96.834007,2.842000,-7.674000],[-96.884003,2.866000,-7.732000],[-97.302002,4.958000,-6.148000],[-97.252007,4.920000,-6.100000],[-97.462006,5.768000,-5.094000],[-97.510002,5.814000,-5.132000],[-97.166008,4.002000,-7.084000],[-97.374008,5.000000,-6.200000],[-97.586006,5.864000,-5.174000],[-97.698006,5.914001,-5.220000],[-97.490005,5.044000,-6.254000],[-97.280006,4.036000,-7.144001],[-96.958008,2.890000,-7.798000],[-97.070007,2.914000,-7.866000],[-96.854004,-0.946000,-8.908000],[-97.184006,-0.952000,-8.974000],[-97.392006,0.414000,-8.894000],[-97.062004,0.412000,-8.830001],[-97.274002,1.724000,-8.530001],[-97.602005,1.736000,-8.594001],[-96.644005,-2.308000,-8.776000],[-96.974007,-2.326000,-8.840000],[-96.612007,-0.936000,-8.834001],[-96.402008,-2.286000,-8.704000],[-96.822006,0.408000,-8.756001],[-97.030006,1.710000,-8.460000],[-99.654007,4.198000,-7.428000],[-100.358002,4.206000,-7.444000],[-100.568008,5.256000,-6.514000],[-99.864006,5.246000,-6.500000],[-100.074005,6.152000,-5.424000],[-100.778008,6.166000,-5.436000],[-101.508003,6.170000,-5.440000],[-101.298004,5.260000,-6.518000],[-101.088005,4.210000,-7.450000],[-99.446007,3.028000,-8.178000],[-100.148003,3.036000,-8.196000],[-100.880005,3.038000,-8.202001],[-99.010002,4.184000,-7.402000],[-98.802002,3.018000,-8.150001],[-98.246002,3.004000,-8.112000],[-98.456001,4.162000,-7.366000],[-99.220001,5.228000,-6.478000],[-98.666008,5.202000,-6.446000],[-98.876007,6.102000,-5.378000],[-99.430008,6.132000,-5.406000],[-102.516006,4.198000,-7.428000],[-102.726006,5.246000,-6.500000],[-102.028008,5.256000,-6.514000],[-101.818008,4.206000,-7.444000],[-102.238007,6.166000,-5.436000],[-102.936005,6.152000,-5.424000],[-103.150002,4.184000,-7.402000],[-103.358002,5.228000,-6.478000],[-103.568008,6.132000,-5.406000],[-104.108002,6.102000,-5.378000],[-103.900002,5.202000,-6.446000],[-103.688004,4.162000,-7.366000],[-102.306007,3.028000,-8.178000],[-102.940002,3.018000,-8.150001],[-103.478004,3.004000,-8.112000],[-101.608002,3.036000,-8.196000],[-103.574005,-0.946000,-8.908000],[-103.784004,0.412000,-8.830001],[-103.476006,0.414000,-8.894000],[-103.266006,-0.952000,-8.974000],[-103.686005,1.736000,-8.594001],[-103.994003,1.724000,-8.530001],[-103.794006,-0.936000,-8.834001],[-104.004005,0.408000,-8.756001],[-104.212006,1.710000,-8.460000],[-104.358002,1.696000,-8.388000],[-104.148003,0.406000,-8.680000],[-103.940002,-0.926000,-8.758000],[-103.366005,-2.308000,-8.776000],[-103.584007,-2.286000,-8.704000],[-103.730003,-2.266000,-8.630000],[-103.056007,-2.326000,-8.840000],[-102.404007,-8.898001,-2.844000],[-102.354004,-8.976001,-2.866000],[-102.144005,-9.264001,-1.566000],[-102.196007,-9.184000,-1.554000],[-102.614006,-8.422000,-4.066000],[-102.564003,-8.496000,-4.100000],[-102.772003,-7.824000,-5.226000],[-102.824005,-7.754000,-5.184000],[-102.432007,-8.826000,-2.824000],[-102.642006,-8.354000,-4.036000],[-102.852005,-7.694000,-5.144000],[-102.874008,-7.640000,-5.110000],[-102.664001,-8.296000,-4.008000],[-102.456001,-8.764001,-2.806000],[-102.224007,-9.110001,-1.542000],[-102.246002,-9.046000,-1.534000],[-100.862007,-5.740000,6.374000],[-101.072006,-6.730000,5.564000],[-101.026009,-6.758000,5.586000],[-100.818008,-5.764000,6.400000],[-101.236008,-7.598001,4.626000],[-101.280006,-7.568000,4.608000],[-100.912003,-5.726000,6.358000],[-101.122002,-6.716001,5.550000],[-101.330002,-7.550000,4.596000],[-101.386002,-7.544000,4.592000],[-101.176003,-6.710001,5.546000],[-100.968002,-5.724000,6.354000],[-100.652008,-4.628000,7.030000],[-100.704002,-4.618000,7.012001],[-100.758003,-4.614000,7.006001],[-100.610008,-4.648000,7.056000],[-99.410004,3.876000,6.406000],[-99.352005,3.866000,6.390000],[-99.144005,4.830000,5.538000],[-99.200005,4.842000,5.550000],[-99.618004,2.798000,7.098001],[-99.562004,2.792000,7.080000],[-99.770004,1.628000,7.578001],[-99.826004,1.632000,7.596000],[-99.464005,3.890000,6.432000],[-99.672005,2.810000,7.124001],[-99.880005,1.638000,7.626000],[-99.930008,1.646000,7.670001],[-99.722008,2.824000,7.166000],[-99.512001,3.910000,6.466000],[-99.254005,4.860000,5.572000],[-99.302002,4.886000,5.604000],[-97.930008,7.044000,-2.792000],[-98.138008,7.376000,-1.524000],[-98.090004,7.318000,-1.514000],[-97.880005,6.988000,-2.772000],[-98.298004,7.434000,-0.228000],[-98.348007,7.494000,-0.228000],[-98.004005,7.104001,-2.814000],[-98.212006,7.440001,-1.536000],[-98.422005,7.558001,-0.228000],[-98.536003,7.624001,-0.228000],[-98.328003,7.506001,-1.548000],[-98.118004,7.166000,-2.838000],[-97.720001,6.516000,-4.004000],[-97.794006,6.572001,-4.038000],[-97.908005,6.630000,-4.072000],[-97.670006,6.464000,-3.974000],[-97.692001,4.106000,-7.266000],[-97.482002,2.964000,-8.000000],[-97.812004,2.984000,-8.060000],[-98.022003,4.136000,-7.322001],[-97.450005,4.072000,-7.208000],[-97.240005,2.940000,-7.934000],[-97.902008,5.132000,-6.358000],[-97.660004,5.088000,-6.308000],[-97.870003,5.968000,-5.264000],[-98.110008,6.016000,-5.306000],[-98.232002,5.168000,-6.406000],[-98.442001,6.062000,-5.346000],[-100.494003,7.456000,-2.944000],[-100.284004,6.896000,-4.228000],[-100.988007,6.912000,-4.238000],[-101.196007,7.472000,-2.950000],[-101.928001,7.476000,-2.952000],[-101.718002,6.916000,-4.240000],[-99.850006,7.430000,-2.936000],[-99.640007,6.872000,-4.214000],[-99.086006,6.838000,-4.194000],[-99.296005,7.394001,-2.922000],[-100.704002,7.808001,-1.600000],[-100.060005,7.780000,-1.598000],[-99.504005,7.742001,-1.590000],[-99.714005,7.866000,-0.228000],[-100.270004,7.906000,-0.228000],[-100.914001,7.932000,-0.228000],[-101.406006,7.824000,-1.604000],[-101.618004,7.950000,-0.228000],[-102.348007,7.956000,-0.228000],[-102.140007,7.830000,-1.606000],[-103.354004,7.456000,-2.946000],[-102.658005,7.472000,-2.950000],[-102.448006,6.912000,-4.238000],[-103.144005,6.896000,-4.228000],[-103.564003,7.808001,-1.604000],[-102.868004,7.824000,-1.604000],[-103.078003,7.950000,-0.228000],[-103.774002,7.934000,-0.232000],[-103.988007,7.430000,-2.936000],[-104.196007,7.784000,-1.604000],[-104.402008,7.912000,-0.244000],[-104.646004,7.898000,-0.256000],[-104.646004,7.844000,-0.792000],[-104.646004,7.754000,-1.606000],[-104.646004,7.656000,-1.962000],[-104.526009,7.394001,-2.926000],[-104.646004,7.598001,-2.164000],[-104.646004,7.724000,-1.716000],[-103.778008,6.872000,-4.214000],[-104.318008,6.838000,-4.194000],[-104.414001,4.106000,-7.266000],[-104.104004,4.136000,-7.322001],[-103.896004,2.984000,-8.060000],[-104.204002,2.964000,-8.000000],[-104.622002,5.132000,-6.358000],[-104.314003,5.168000,-6.406000],[-104.524002,6.062000,-5.346000],[-104.646004,5.914001,-5.478000],[-104.646004,5.710000,-5.704000],[-104.646004,6.044000,-5.330000],[-104.646004,5.226000,-6.246000],[-104.632004,4.072000,-7.208000],[-104.646004,4.638000,-6.748000],[-104.646004,4.484000,-6.870000],[-104.654007,4.184000,-7.108000],[-104.646004,5.126000,-6.354000],[-104.658005,4.066000,-7.196001],[-104.422005,2.940000,-7.934000],[-104.664001,3.768000,-7.354001],[-104.664001,3.690000,-7.394001],[-104.670006,3.462000,-7.514000],[-104.568008,2.914000,-7.866000],[-103.242004,-5.884000,-6.992000],[-103.452003,-4.744000,-7.664001],[-103.400002,-4.788000,-7.728000],[-103.190002,-5.936000,-7.052001],[-103.610008,-3.546000,-8.232000],[-103.660004,-3.514000,-8.162001],[-103.268005,-5.836000,-6.938000],[-103.478004,-4.706000,-7.604001],[-103.688004,-3.486000,-8.100000],[-103.710007,-3.460000,-8.046000],[-103.502007,-4.672000,-7.554000],[-103.292007,-5.794000,-6.892000],[-103.032005,-6.898000,-6.162000],[-103.060005,-6.842000,-6.114000],[-103.082008,-6.794000,-6.074000],[-102.982002,-6.960001,-6.214000],[-101.698006,-8.684000,2.324000],[-101.654007,-8.718000,2.334000],[-101.444008,-8.250000,3.532000],[-101.488007,-8.218000,3.516000],[-101.906006,-8.962001,1.064000],[-101.864006,-8.996000,1.070000],[-102.072006,-9.090000,-0.228000],[-102.116005,-9.054001,-0.228000],[-101.748001,-8.664001,2.320000],[-101.956001,-8.942000,1.062000],[-102.166008,-9.032001,-0.228000],[-102.220001,-9.026000,-0.228000],[-102.012001,-8.934000,1.062000],[-101.804008,-8.656000,2.316000],[-101.540009,-8.198000,3.508000],[-101.594002,-8.192000,3.506000],[-100.244003,-0.884000,7.952000],[-100.454002,-2.170000,7.828001],[-100.398003,-2.162000,7.810000],[-100.188004,-0.882000,7.934000],[-100.606003,-3.420000,7.498000],[-100.664001,-3.428000,7.518000],[-100.298004,-0.888000,7.984000],[-100.508003,-2.178000,7.860001],[-100.718002,-3.442000,7.546000],[-100.766006,-3.460000,7.590000],[-100.558006,-2.190000,7.904000],[-100.348007,-0.894000,8.028001],[-100.036003,0.394000,7.878000],[-100.090004,0.394000,7.910000],[-100.138008,0.396000,7.954000],[-99.980003,0.392000,7.860001],[-98.766006,7.044000,2.336000],[-98.718002,6.988000,2.316000],[-98.508003,7.318000,1.058000],[-98.558006,7.376000,1.068000],[-98.976006,6.516000,3.548000],[-98.926003,6.464000,3.516000],[-99.134003,5.768000,4.636000],[-99.186005,5.814000,4.676000],[-98.840004,7.104001,2.358000],[-99.050003,6.572001,3.580000],[-99.260002,5.864000,4.718000],[-99.374008,5.914001,4.762000],[-99.166008,6.630000,3.614000],[-98.956001,7.166000,2.380000],[-98.632004,7.440001,1.078000],[-98.746002,7.506001,1.090000],[-98.530006,7.290000,-2.884000],[-98.860008,7.346000,-2.904000],[-99.070007,7.692000,-1.580000],[-98.740005,7.634000,-1.570000],[-98.950005,7.756001,-0.228000],[-99.280006,7.816000,-0.228000],[-98.320007,6.744000,-4.138000],[-98.652008,6.794000,-4.168000],[-98.288002,7.230000,-2.862000],[-98.078003,6.688000,-4.106000],[-98.498001,7.572001,-1.560000],[-98.708008,7.692000,-0.228000],[-101.334007,7.456000,2.488000],[-102.038002,7.472000,2.492000],[-102.248001,6.916000,3.776000],[-101.544006,6.898000,3.770000],[-101.754005,6.156000,4.964000],[-102.460007,6.178000,4.968000],[-103.198006,6.200000,4.958000],[-102.982002,6.928000,3.774000],[-102.770004,7.480000,2.492000],[-101.124008,7.808001,1.144000],[-101.828003,7.824000,1.148000],[-102.558006,7.830000,1.148000],[-100.690002,7.430000,2.478000],[-100.480003,7.780000,1.140000],[-99.924004,7.742001,1.132000],[-100.136002,7.394001,2.464000],[-100.898003,6.872000,3.758000],[-100.344002,6.838000,3.736000],[-100.554008,6.102000,4.922000],[-101.108002,6.132000,4.948000],[-104.194008,7.472000,2.470000],[-104.412003,6.952000,3.736000],[-103.714005,6.936000,3.760000],[-103.498009,7.478000,2.490000],[-103.936005,6.224000,4.930000],[-104.632004,6.284000,4.880000],[-104.646004,7.474000,2.440000],[-104.646004,7.216001,3.126000],[-104.646004,7.054000,3.512000],[-104.646004,6.968000,3.720000],[-104.646004,6.308000,4.838000],[-104.646004,6.288000,4.878000],[-103.980003,7.812000,1.136000],[-104.608002,7.794000,1.106000],[-104.646004,7.698000,1.506000],[-104.646004,7.736001,1.346000],[-104.646004,7.612000,1.864000],[-104.646004,7.754000,1.270000],[-104.646004,7.778000,1.172000],[-104.646004,7.792000,1.102000],[-104.646004,7.804000,0.948000],[-104.646004,7.896000,-0.228000],[-103.288002,7.824000,1.148000],[-104.646004,7.454000,-2.674000],[-104.646004,7.382000,-2.922000],[-104.646004,7.546000,-2.350000],[-104.646004,6.486001,-4.664000],[-104.646004,6.696000,-4.338000],[-104.646004,6.804000,-4.174000],[-104.646004,6.898000,-3.968000],[-104.646004,7.050000,-3.638000],[-104.078003,-0.908000,-8.610001],[-104.028008,-0.918000,-8.682000],[-103.818008,-2.244000,-8.554001],[-103.868004,-2.224000,-8.482000],[-104.288002,0.400000,-8.534000],[-104.238007,0.402000,-8.606000],[-104.446007,1.682000,-8.314000],[-104.496002,1.670000,-8.246000],[-104.106003,-0.900000,-8.542001],[-104.316002,0.398000,-8.468000],[-104.524002,1.656000,-8.182000],[-104.546005,1.646000,-8.126000],[-104.336006,0.396000,-8.410001],[-104.128006,-0.894000,-8.484000],[-103.896004,-2.206000,-8.416000],[-103.920006,-2.190000,-8.360001],[-102.534004,-8.684000,-2.782000],[-102.742004,-8.218000,-3.974000],[-102.698006,-8.250000,-3.988000],[-102.490005,-8.718000,-2.792000],[-102.908005,-7.598001,-5.084000],[-102.952003,-7.568000,-5.066000],[-102.584007,-8.664001,-2.776000],[-102.794006,-8.198000,-3.964000],[-103.002007,-7.550000,-5.054000],[-103.056007,-7.544000,-5.050000],[-102.848007,-8.192000,-3.962000],[-102.638008,-8.656000,-2.774000],[-102.324005,-8.962001,-1.522000],[-102.376007,-8.942000,-1.520000],[-102.430008,-8.934000,-1.518000],[-102.282005,-8.996000,-1.526000],[-101.082008,-5.740000,6.374000],[-101.024002,-5.726000,6.358000],[-100.816002,-4.618000,7.012001],[-100.872002,-4.628000,7.030000],[-101.290009,-6.730000,5.564000],[-101.234001,-6.716001,5.550000],[-101.442001,-7.550000,4.596000],[-101.498001,-7.568000,4.608000],[-101.136002,-5.764000,6.400000],[-101.344002,-6.758000,5.586000],[-101.552002,-7.598001,4.626000],[-101.604004,-7.640000,4.652000],[-101.394005,-6.794000,5.618000],[-101.184006,-5.794000,6.436000],[-100.926003,-4.648000,7.056000],[-100.976006,-4.672000,7.096000],[-99.602005,3.968000,6.568000],[-99.814003,2.866000,7.276000],[-99.762001,2.842000,7.216001],[-99.554008,3.938000,6.514000],[-99.972008,1.656000,7.724000],[-100.022003,1.670000,7.788001],[-99.678001,4.002000,6.626000],[-99.888008,2.890000,7.342000],[-100.096008,1.682000,7.858000],[-100.212006,1.696000,7.932000],[-100.002007,2.914000,7.410000],[-99.792007,4.036000,6.688000],[-99.394005,4.958000,5.692000],[-99.468002,5.000000,5.744000],[-99.582008,5.044000,5.796000],[-99.344002,4.920000,5.644000],[-99.368004,7.290000,2.426000],[-99.158005,7.634000,1.114000],[-99.490005,7.692000,1.124000],[-99.700005,7.346000,2.448000],[-99.126007,7.230000,2.404000],[-98.916008,7.572001,1.102000],[-99.578003,6.744000,3.682000],[-99.334007,6.688000,3.648000],[-99.546005,5.968000,4.808000],[-99.788002,6.016000,4.850000],[-99.910004,6.794000,3.712000],[-100.118004,6.062000,4.890000],[-102.174004,4.206000,6.966001],[-101.966003,5.252000,6.040000],[-102.674004,5.280000,6.038000],[-102.882004,4.236000,6.962000],[-103.620003,4.286000,6.932000],[-103.416008,5.320000,6.014000],[-101.528008,4.182000,6.946000],[-101.318008,5.228000,6.020000],[-100.764008,5.202000,5.990000],[-100.972008,4.162000,6.910000],[-102.380005,3.036000,7.718000],[-101.738007,3.018000,7.694000],[-101.182007,3.004000,7.654000],[-101.394005,1.748000,8.192000],[-101.948006,1.756000,8.234000],[-102.584007,1.764000,8.264000],[-103.074005,3.060000,7.722001],[-103.262009,1.778000,8.274000],[-103.940002,1.796000,8.268001],[-103.788002,3.096000,7.700000],[-104.646004,6.276000,4.892000],[-104.646004,6.236000,4.940000],[-104.164001,5.376000,5.962000],[-104.646004,4.938000,6.296000],[-104.360008,4.360000,6.866000],[-104.646004,4.880000,6.348001],[-104.662003,4.416000,6.772000],[-104.646004,5.470000,5.882000],[-104.646004,6.074000,5.140000],[-104.694008,3.150000,7.572001],[-104.486008,3.154000,7.648000],[-104.684006,3.572000,7.332000],[-104.678001,3.764000,7.204000],[-104.584007,1.824000,8.244000],[-104.714005,1.828000,8.196000],[-104.702003,2.714000,7.782001],[-104.706001,2.404000,7.926001],[-104.678001,2.386000,-7.810000],[-104.678001,2.492000,-7.806000],[-104.678001,2.534000,-7.806000],[-104.678001,2.574000,-7.804000],[-104.680008,2.716000,-7.796000],[-104.656006,2.890000,-7.798000],[-104.678001,2.978000,-7.734000],[-104.678001,3.002000,-7.726000],[-104.678001,2.878000,-7.768001],[-104.676003,3.076000,-7.692000],[-103.370003,-5.740000,-6.832000],[-103.326004,-5.764000,-6.856000],[-103.116005,-6.758000,-6.042000],[-103.160004,-6.730000,-6.020000],[-103.578003,-4.628000,-7.486001],[-103.536003,-4.648000,-7.514000],[-103.744003,-3.442000,-8.004001],[-103.788002,-3.428000,-7.974000],[-103.420006,-5.726000,-6.816000],[-103.628006,-4.618000,-7.468000],[-103.838005,-3.420000,-7.956000],[-103.892006,-3.418000,-7.950000],[-103.684006,-4.614000,-7.464000],[-103.476006,-5.724000,-6.810000],[-103.210007,-6.716001,-6.008000],[-103.266006,-6.710001,-6.002000],[-101.916008,-8.684000,2.324000],[-102.126007,-8.962001,1.064000],[-102.068008,-8.942000,1.062000],[-101.860008,-8.664001,2.320000],[-102.278008,-9.032001,-0.228000],[-102.336006,-9.054001,-0.228000],[-101.972008,-8.718000,2.334000],[-102.180008,-8.996000,1.070000],[-102.390007,-9.090000,-0.228000],[-102.438004,-9.140000,-0.228000],[-102.230003,-9.046000,1.078000],[-102.020004,-8.764001,2.348000],[-101.708008,-8.218000,3.516000],[-101.762001,-8.250000,3.532000],[-101.812004,-8.296000,3.552000],[-101.650002,-8.198000,3.508000],[-100.440002,-0.908000,8.152000],[-100.390007,-0.900000,8.086000],[-100.180008,0.398000,8.010000],[-100.230003,0.400000,8.078000],[-100.650002,-2.224000,8.026000],[-100.600006,-2.206000,7.958000],[-100.808006,-3.486000,7.644001],[-100.858002,-3.514000,7.706000],[-100.514008,-0.918000,8.226001],[-100.726006,-2.244000,8.098001],[-100.934006,-3.546000,7.776000],[-101.050003,-3.578000,7.846000],[-100.840004,-2.266000,8.172000],[-100.630005,-0.926000,8.302000],[-100.306007,0.402000,8.148001],[-100.420006,0.406000,8.224000],[-100.206001,4.106000,6.810000],[-100.538002,4.136000,6.864000],[-100.748001,2.984000,7.602000],[-100.416008,2.964000,7.542000],[-100.626007,1.724000,8.074000],[-100.958008,1.736000,8.138000],[-99.998001,5.132000,5.902000],[-100.328003,5.168000,5.948000],[-99.964005,4.072000,6.750000],[-99.754005,5.088000,5.850000],[-100.172005,2.940000,7.478000],[-100.382004,1.710000,8.004001],[-102.994003,-0.970000,8.650001],[-103.646004,-0.970000,8.670000],[-103.842003,-2.370000,8.538000],[-103.200005,-2.362000,8.516001],[-103.408005,-3.730000,8.180000],[-104.038002,-3.740000,8.200001],[-104.626007,-3.744000,8.210000],[-104.448006,-2.372000,8.548000],[-104.276009,-0.970000,8.680000],[-102.790009,0.418000,8.570001],[-103.452003,0.422000,8.588000],[-104.104004,0.430000,8.590000],[-102.368004,-0.966000,8.618000],[-102.158005,0.416000,8.538000],[-101.604004,0.414000,8.494000],[-101.812004,-0.958000,8.574000],[-102.576004,-2.354000,8.484000],[-102.022003,-2.342000,8.440001],[-102.232002,-3.696000,8.106000],[-102.786003,-3.716000,8.148001],[-104.724007,0.182000,8.598001],[-104.700005,0.440000,8.580001],[-104.724007,0.390000,8.574000],[-104.724007,0.442000,8.570001],[-104.722008,0.514000,8.552000],[-104.714005,1.264000,8.350000],[-104.724007,-0.074000,8.616000],[-104.726006,-0.904000,8.674001],[-104.726006,-0.970000,8.678000],[-104.724007,-1.742000,8.608001],[-104.724007,-1.876000,8.596001],[-104.722008,-2.374000,8.548000],[-104.716003,-3.074000,8.374001],[-104.716003,-3.388000,8.298000],[-104.716003,-3.744000,8.210000],[-104.206001,-0.884000,-8.410001],[-104.414001,0.394000,-8.334001],[-104.370003,0.394000,-8.366000],[-104.162003,-0.888000,-8.440001],[-104.580002,1.638000,-8.084001],[-104.624008,1.632000,-8.054001],[-104.256004,-0.882000,-8.390000],[-104.466003,0.392000,-8.316000],[-104.674004,1.628000,-8.036000],[-104.684006,1.418000,-8.078000],[-104.684006,1.628000,-8.034000],[-104.520004,0.392000,-8.310000],[-104.684006,1.362000,-8.090000],[-104.310005,-0.880000,-8.384001],[-103.996002,-2.170000,-8.284000],[-104.046005,-2.162000,-8.266001],[-104.102005,-2.162000,-8.260000],[-103.954002,-2.178000,-8.316000],[-102.752007,-8.684000,-2.782000],[-102.696007,-8.664001,-2.776000],[-102.488007,-8.942000,-1.520000],[-102.544006,-8.962001,-1.522000],[-102.962006,-8.218000,-3.974000],[-102.906006,-8.198000,-3.964000],[-103.114006,-7.550000,-5.054000],[-103.170006,-7.568000,-5.066000],[-102.808006,-8.718000,-2.792000],[-103.016006,-8.250000,-3.988000],[-103.226006,-7.598001,-5.084000],[-103.276009,-7.640000,-5.110000],[-103.066002,-8.296000,-4.008000],[-102.858002,-8.764001,-2.806000],[-102.598007,-8.996000,-1.526000],[-102.648003,-9.046000,-1.534000],[-101.278008,-5.884000,6.536000],[-101.486008,-6.898000,5.706000],[-101.436005,-6.842000,5.658000],[-101.228004,-5.836000,6.482000],[-101.644005,-7.694000,4.686000],[-101.696007,-7.754000,4.726000],[-101.352005,-5.936000,6.594000],[-101.562004,-6.960001,5.758000],[-101.770004,-7.824000,4.770000],[-101.886002,-7.894001,4.814000],[-101.678001,-7.022000,5.812000],[-101.468002,-5.990000,6.656000],[-101.068008,-4.744000,7.206000],[-101.142006,-4.788000,7.270000],[-101.258003,-4.832000,7.338000],[-101.016006,-4.706000,7.148000],[-101.046005,-0.946000,8.450001],[-100.836006,0.412000,8.372001],[-101.168007,0.414000,8.438001],[-101.376007,-0.952000,8.518001],[-100.802002,-0.936000,8.378000],[-100.592003,0.408000,8.300000],[-101.254005,-2.308000,8.318001],[-101.012001,-2.286000,8.246000],[-101.220001,-3.610000,7.920001],[-101.464005,-3.642000,7.988000],[-101.586006,-2.326000,8.384001],[-101.796005,-3.672000,8.052000],[-103.828003,-6.242000,6.938000],[-103.614006,-5.034000,7.648000],[-104.236008,-5.046000,7.668000],[-104.436005,-6.254000,6.968000],[-104.684006,-5.776000,7.262001],[-104.672005,-6.256001,6.980000],[-104.688004,-5.570000,7.380000],[-104.700005,-5.052000,7.676001],[-104.710007,-4.358000,7.960001],[-103.212006,-6.218000,6.910000],[-102.998001,-5.014000,7.620000],[-102.442001,-4.988000,7.580000],[-102.654007,-6.186000,6.874001],[-104.052002,-7.316000,6.060000],[-103.436005,-7.292000,6.026000],[-102.872002,-7.252000,5.998000],[-103.096008,-8.156000,4.962000],[-103.676003,-8.202001,4.974000],[-104.294006,-8.226001,5.022000],[-104.642006,-7.322001,6.122000],[-104.646004,-8.066000,5.276000],[-104.646004,-8.218000,5.104000],[-104.646004,-7.332000,6.110000],[-104.646004,-7.326000,6.120000],[-104.646004,-7.322001,6.122000],[-104.646004,-7.314000,6.128000],[-104.646004,-7.130000,6.276000],[-104.714005,-3.924000,8.136001],[-104.710007,-4.282000,7.992001],[-104.680008,1.952000,-7.918000],[-104.680008,2.032000,-7.894001],[-104.678001,2.188000,-7.850000],[-104.678001,2.278000,-7.832000],[-104.682007,1.678000,-8.014000],[-104.682007,1.890000,-7.938000],[-104.682007,1.918000,-7.930000],[-103.588005,-5.740000,-6.832000],[-103.798004,-4.628000,-7.486001],[-103.740005,-4.618000,-7.468000],[-103.532005,-5.726000,-6.816000],[-103.950005,-3.420000,-7.956000],[-104.008003,-3.428000,-7.974000],[-103.644005,-5.764000,-6.856000],[-103.852005,-4.648000,-7.514000],[-104.062004,-3.442000,-8.004001],[-104.112007,-3.460000,-8.046000],[-103.902008,-4.672000,-7.554000],[-103.694008,-5.794000,-6.892000],[-103.380005,-6.730000,-6.020000],[-103.434006,-6.758000,-6.042000],[-103.484001,-6.794000,-6.074000],[-103.322006,-6.716001,-6.008000],[-102.114006,-8.898001,2.388000],[-102.064003,-8.826000,2.366000],[-101.854004,-8.354000,3.578000],[-101.906006,-8.422000,3.608000],[-102.324005,-9.184000,1.096000],[-102.272003,-9.110001,1.086000],[-102.482002,-9.204000,-0.228000],[-102.532005,-9.278001,-0.228000],[-102.190002,-8.976001,2.410000],[-102.400002,-9.264001,1.108000],[-102.608002,-9.360001,-0.228000],[-102.724007,-9.446000,-0.228000],[-102.516006,-9.348001,1.120000],[-102.306007,-9.058001,2.434000],[-101.980003,-8.496000,3.642000],[-102.096008,-8.574000,3.676000],[-101.884003,-6.096000,6.776000],[-102.218002,-6.144000,6.830000],[-102.430008,-7.204000,5.962000],[-102.094002,-7.148000,5.916000],[-102.306007,-8.036000,4.900000],[-102.644005,-8.100000,4.936000],[-101.674004,-4.916000,7.470000],[-102.006004,-4.956000,7.530000],[-101.640007,-6.046000,6.718000],[-101.430008,-4.876000,7.406000],[-101.850006,-7.086000,5.864000],[-102.058006,-7.966001,4.860000],[-104.560005,-8.934000,3.840000],[-104.646004,-9.016001,3.512000],[-104.646004,-9.024000,3.482000],[-104.646004,-8.926001,3.880000],[-104.646004,-8.518001,4.608000],[-103.934006,-8.916000,3.768000],[-104.646004,-9.196000,2.764000],[-104.160004,-9.422001,2.462000],[-104.646004,-9.338000,2.426000],[-103.330002,-8.860001,3.774000],[-103.548004,-9.364000,2.484000],[-104.646004,-9.584001,1.032000],[-104.302002,-9.718000,1.116000],[-104.646004,-9.552000,1.266000],[-104.646004,-9.520000,1.506000],[-104.646004,-9.476001,1.840000],[-104.646004,-9.474000,1.860000],[-103.722008,-9.660001,1.136000],[-103.880005,-9.754001,-0.240000],[-104.406006,-9.806001,-0.254000],[-104.646004,-9.718000,-0.284000],[-104.646004,-9.714001,-0.228000],[-104.646004,-9.660001,0.338000],[-104.424004,-0.884000,-8.410001],[-104.368004,-0.882000,-8.390000],[-104.158005,-2.162000,-8.266001],[-104.216003,-2.170000,-8.284000],[-104.634003,0.394000,-8.334001],[-104.578003,0.392000,-8.316000],[-104.684006,1.262000,-8.114000],[-104.684006,1.244000,-8.118000],[-104.686005,1.034000,-8.170000],[-104.686005,0.906000,-8.208000],[-104.690002,0.722000,-8.260000],[-104.480003,-0.888000,-8.440001],[-104.690002,0.394000,-8.366000],[-104.694008,0.426000,-8.358001],[-104.692001,0.446000,-8.352000],[-104.694008,0.418000,-8.362000],[-104.694008,0.414000,-8.362000],[-104.694008,0.394000,-8.370001],[-104.696007,0.126000,-8.426001],[-104.530006,-0.894000,-8.484000],[-104.270004,-2.178000,-8.316000],[-104.320007,-2.190000,-8.360001],[-102.950005,-8.898001,-2.844000],[-103.160004,-8.422000,-4.066000],[-103.110008,-8.354000,-4.036000],[-102.900002,-8.826000,-2.824000],[-103.318008,-7.694000,-5.144000],[-103.370003,-7.754000,-5.184000],[-103.028008,-8.976001,-2.866000],[-103.236008,-8.496000,-4.100000],[-103.446007,-7.824000,-5.226000],[-103.562004,-7.894001,-5.272000],[-103.354004,-8.574000,-4.134000],[-103.142006,-9.058001,-2.890000],[-102.742004,-9.184000,-1.554000],[-102.818008,-9.264001,-1.566000],[-102.934006,-9.348001,-1.576000],[-102.690002,-9.110001,-1.542000],[-102.728004,-9.220000,2.476000],[-102.518005,-8.726001,3.742000],[-102.864006,-8.796000,3.764000],[-103.078003,-9.294001,2.486000],[-102.478004,-9.140000,2.458000],[-102.268005,-8.650001,3.712000],[-102.934006,-9.514001,1.142000],[-102.688004,-9.432000,1.132000],[-102.896004,-9.532001,-0.228000],[-103.138008,-9.612000,-0.230000],[-103.272003,-9.592000,1.144000],[-103.462006,-9.688001,-0.234000],[-104.526009,-9.698001,-1.636000],[-104.646004,-9.576000,-1.898000],[-104.646004,-9.566000,-1.966000],[-104.646004,-9.514001,-2.282000],[-104.646004,-9.426001,-2.836000],[-104.646004,-9.612000,-1.748000],[-104.646004,-9.638000,-1.636000],[-104.646004,-9.674001,-1.256000],[-104.044006,-9.650001,-1.624000],[-104.216003,-9.348001,-2.974000],[-104.646004,-9.390000,-2.988000],[-104.646004,-9.010000,-3.928000],[-104.646004,-8.872001,-4.266000],[-104.390007,-8.846001,-4.256000],[-104.646004,-8.992001,-3.970000],[-104.646004,-8.392000,-5.044000],[-104.568008,-8.146001,-5.428000],[-104.646004,-8.154000,-5.432000],[-103.788002,-5.884000,-6.992000],[-103.736008,-5.836000,-6.938000],[-103.526009,-6.842000,-6.114000],[-103.578003,-6.898000,-6.162000],[-103.998009,-4.744000,-7.664001],[-103.946007,-4.706000,-7.604001],[-104.154007,-3.486000,-8.100000],[-104.206001,-3.514000,-8.162001],[-103.864006,-5.936000,-7.052001],[-104.074005,-4.788000,-7.728000],[-104.282005,-3.546000,-8.232000],[-104.400002,-3.578000,-8.304001],[-104.190002,-4.832000,-7.796000],[-103.980003,-5.990000,-7.114000],[-103.654007,-6.960001,-6.214000],[-103.772003,-7.022000,-6.268000],[-103.550003,-9.218000,-2.936000],[-103.848007,-9.288000,-2.958000],[-104.044006,-8.792001,-4.232000],[-103.756004,-8.724000,-4.202000],[-103.962006,-8.034000,-5.358000],[-104.240005,-8.096001,-5.398000],[-103.344002,-9.514001,-1.600000],[-103.654007,-9.588000,-1.614000],[-103.316002,-9.140000,-2.914000],[-103.106003,-9.432000,-1.590000],[-103.526009,-8.650001,-4.168000],[-103.734001,-7.966001,-5.316000],[-104.646004,-8.018001,-5.584000],[-104.646004,-7.956000,-5.652000],[-104.646004,-7.756001,-5.872000],[-104.700005,-0.282000,-8.542001],[-104.624008,-0.904000,-8.610001],[-104.702003,-0.424000,-8.582001],[-104.574005,-0.900000,-8.542001],[-104.698006,-0.122000,-8.498000],[-104.698006,-0.034000,-8.472000],[-104.702003,-0.544000,-8.612000],[-104.702003,-0.904000,-8.684000],[-104.706001,-0.886000,-8.684000],[-104.706001,-0.904000,-8.686001],[-104.416008,-2.224000,-8.482000],[-104.492004,-2.244000,-8.554001],[-104.706001,-1.374000,-8.692000],[-104.708008,-1.638000,-8.694000],[-104.608002,-2.266000,-8.630000],[-104.364006,-2.206000,-8.416000],[-104.374008,-6.096000,-7.232000],[-104.168007,-7.148000,-6.372000],[-104.436005,-7.202000,-6.418000],[-104.634003,-6.142000,-7.284000],[-104.646004,-6.760000,-6.810000],[-104.664001,-6.146000,-7.288001],[-104.646004,-7.230000,-6.444000],[-104.646004,-6.786000,-6.790000],[-104.154007,-6.046000,-7.174000],[-103.944008,-7.086000,-6.322001],[-104.580002,-4.916000,-7.926001],[-104.364006,-4.876000,-7.864000],[-104.574005,-3.610000,-8.376000],[-104.700005,-3.892000,-8.326000],[-104.702003,-3.630000,-8.418000],[-104.698006,-4.190000,-8.222000],[-104.700005,-4.080000,-8.260000],[-104.668007,-5.930000,-7.410000],[-104.676003,-5.574000,-7.604001],[-104.680008,-5.328000,-7.738000],[-104.690002,-4.934000,-7.950000],[-104.702003,-3.066000,-8.526000],[-104.704002,-2.780000,-8.582001],[-104.706001,-2.544000,-8.624001],[-104.708008,-2.278000,-8.672001],[-104.708008,-2.020000,-8.680000],[-111.010002,3.910000,6.976000],[-111.010002,3.180000,7.412000],[-110.290009,3.472000,7.960001],[-110.290009,4.254000,7.492001],[-109.852005,3.866000,6.914001],[-109.836006,3.734000,6.848001],[-109.850006,2.796000,6.696000],[-109.852005,2.382000,7.708000],[-109.818008,2.424000,7.380000],[-110.290009,2.650000,8.350000],[-111.010002,2.412000,7.776000],[-111.010002,2.412000,-8.234000],[-111.010002,3.180000,-7.870000],[-110.290009,3.472000,-8.418000],[-110.290009,2.650000,-8.806001],[-109.852005,2.382000,-8.164001],[-109.850006,2.796000,-7.154000],[-109.818008,2.424000,-7.836000],[-109.836006,3.734000,-7.304000],[-109.852005,3.866000,-7.370000],[-110.290009,4.254000,-7.948000],[-111.010002,3.910000,-7.432000],[-111.010002,-9.402000,1.462000],[-111.010002,-9.528001,0.620000],[-110.290009,-10.146001,0.682000],[-110.290009,-10.012000,1.584000],[-109.852005,-9.330001,1.448000],[-109.852005,-9.082001,1.076000],[-109.852005,-8.728001,0.542000],[-109.852005,-9.494000,-0.228000],[-110.290009,-10.190001,-0.228000],[-111.010002,-9.570001,-0.228000],[-111.010002,6.300000,4.584000],[-111.010002,5.792000,5.268000],[-110.290009,6.272000,5.662000],[-110.290009,6.816000,4.930000],[-109.852005,6.236000,4.544000],[-109.852005,5.478000,4.696000],[-109.852005,5.172000,4.758000],[-109.852005,5.168000,5.846000],[-110.290009,5.660000,6.338000],[-111.010002,5.222000,5.898000],[-111.010002,-0.904000,-8.894000],[-111.010002,-0.056000,-8.852000],[-110.290009,0.004000,-9.470000],[-110.290009,-0.904000,-9.514001],[-109.852005,-0.904000,-8.818001],[-109.824005,-0.144000,-7.958000],[-109.804008,-0.674000,-8.416000],[-109.806007,0.480000,-8.320001],[-109.806007,0.472000,-8.316000],[-109.852005,0.770000,-8.654000],[-110.290009,0.906000,-9.336000],[-111.010002,0.786000,-8.728001],[-111.010002,-8.110001,4.584000],[-111.010002,-8.546000,3.856000],[-110.290009,-9.094001,4.148000],[-110.290009,-8.626000,4.930000],[-109.852005,-8.046000,4.544000],[-109.852005,-7.842000,3.502000],[-109.852005,-7.838000,3.478000],[-109.852005,-8.840000,3.058000],[-110.290009,-9.484000,3.324000],[-111.010002,-8.910001,3.086000],[-111.010002,7.594000,1.462000],[-111.010002,7.386000,2.286000],[-110.290009,7.980000,2.466000],[-110.290009,8.202001,1.584000],[-109.852005,7.520000,1.448000],[-109.852005,7.444000,1.498000],[-109.852005,6.618001,2.052000],[-109.852005,6.702000,2.256000],[-109.852005,7.030000,3.058000],[-110.290009,7.674000,3.324000],[-111.010002,7.100000,3.086000],[-111.010002,-5.720000,6.976000],[-111.010002,-6.402000,6.470000],[-110.290009,-6.794000,6.948000],[-110.290009,-6.064000,7.492001],[-109.852005,-5.676000,6.914001],[-109.852005,-5.760000,6.500000],[-109.852005,-5.892000,5.848000],[-109.838005,-5.668000,6.786000],[-109.852005,-6.978000,5.846000],[-110.290009,-7.470000,6.338000],[-111.010002,-7.032001,5.898000],[-111.010002,-4.220000,-8.234000],[-111.010002,-3.420000,-8.520000],[-110.290009,-3.600000,-9.114000],[-110.290009,-4.458000,-8.806001],[-109.852005,-4.192000,-8.164001],[-109.832008,-3.168000,-7.690001],[-109.820007,-3.646000,-7.852000],[-109.814003,-3.906000,-7.942000],[-109.826004,-3.046000,-7.844000],[-109.808006,-2.714000,-8.254001],[-109.852005,-2.580000,-8.654000],[-110.290009,-2.716000,-9.336000],[-111.010002,-2.596000,-8.728001],[-111.010002,7.594000,-1.920000],[-111.010002,7.718000,-1.078000],[-110.290009,8.336000,-1.140000],[-110.290009,8.202001,-2.040000],[-109.852005,7.520000,-1.904000],[-109.852005,7.274000,-1.534000],[-109.852005,6.918000,-1.000000],[-109.852005,7.684000,-0.228000],[-110.290009,8.380000,-0.228000],[-111.010002,7.760000,-0.228000],[-111.010002,-2.596000,8.270000],[-111.010002,-3.420000,8.064000],[-110.290009,-3.600000,8.658000],[-110.290009,-2.716000,8.878000],[-109.852005,-2.580000,8.196000],[-109.826004,-3.046000,7.386000],[-109.832008,-3.168000,7.232000],[-109.808006,-2.714000,7.798000],[-109.820007,-3.646000,7.396000],[-109.852005,-4.192000,7.708000],[-109.814003,-3.906000,7.486001],[-110.290009,-4.458000,8.350000],[-111.010002,-4.220000,7.776000],[-111.010002,-7.032001,-6.356000],[-111.010002,-6.402000,-6.926000],[-110.290009,-6.794000,-7.406000],[-110.290009,-7.470000,-6.794000],[-109.852005,-6.978000,-6.302001],[-109.852005,-5.892000,-6.306000],[-109.852005,-5.760000,-6.958000],[-109.852005,-5.676000,-7.370000],[-109.838005,-5.668000,-7.242001],[-110.290009,-6.064000,-7.948000],[-111.010002,-5.720000,-7.432000],[-111.010002,6.300000,-5.042000],[-111.010002,6.736001,-4.314000],[-110.290009,7.284000,-4.606000],[-110.290009,6.816000,-5.388000],[-109.852005,6.236000,-5.002000],[-109.852005,6.034000,-3.960000],[-109.852005,6.028000,-3.934000],[-109.852005,7.030000,-3.516000],[-110.290009,7.674000,-3.782000],[-111.010002,7.100000,-3.544000],[-111.010002,-8.910001,-3.544000],[-111.010002,-8.546000,-4.314000],[-110.290009,-9.094001,-4.606000],[-110.290009,-9.484000,-3.782000],[-109.852005,-8.840000,-3.516000],[-109.852005,-7.838000,-3.934000],[-109.852005,-7.842000,-3.960000],[-109.852005,-8.046000,-5.002000],[-110.290009,-8.626000,-5.388000],[-111.010002,-8.110001,-5.042000],[-111.010002,1.610000,8.064000],[-110.290009,1.792000,8.658000],[-109.832008,1.358000,7.232000],[-109.820007,1.836000,7.396000],[-109.814003,2.096000,7.486001],[-109.826004,1.238000,7.386000],[-109.852005,0.770000,8.196000],[-109.808006,0.904000,7.798000],[-110.290009,0.906000,8.878000],[-111.010002,0.786000,8.270000],[-111.010002,4.592000,-6.926000],[-110.290009,4.986000,-7.406000],[-109.852005,3.950000,-6.958000],[-109.852005,4.082000,-6.306000],[-109.838005,3.858000,-7.242001],[-109.852005,5.168000,-6.302001],[-110.290009,5.660000,-6.794000],[-111.010002,5.222000,-6.356000],[-111.010002,-9.528001,-1.078000],[-110.290009,-10.146001,-1.140000],[-109.852005,-8.728001,-1.000000],[-109.852005,-9.084001,-1.534000],[-109.852005,-9.330001,-1.904000],[-110.290009,-10.012000,-2.040000],[-111.010002,-9.402000,-1.920000],[-111.010002,4.592000,6.470000],[-110.290009,4.986000,6.948000],[-109.852005,4.082000,5.848000],[-109.852005,3.950000,6.500000],[-109.838005,3.858000,6.786000],[-111.010002,1.610000,-8.520000],[-110.290009,1.792000,-9.114000],[-109.826004,1.238000,-7.844000],[-109.808006,0.904000,-8.254001],[-109.832008,1.358000,-7.690001],[-109.814003,2.096000,-7.942000],[-109.820007,1.836000,-7.852000],[-111.010002,-9.196000,2.286000],[-110.290009,-9.790001,2.466000],[-109.852005,-8.512000,2.256000],[-109.852005,-8.428000,2.052000],[-109.852005,-9.254001,1.498000],[-111.010002,6.736001,3.856000],[-110.290009,7.284000,4.148000],[-109.852005,6.028000,3.478000],[-109.852005,6.034000,3.502000],[-111.010002,-7.602000,5.268000],[-110.290009,-8.082001,5.662000],[-109.852005,-6.982000,4.758000],[-109.852005,-7.288001,4.696000],[-111.010002,-1.754000,-8.852000],[-110.290009,-1.814000,-9.470000],[-109.824005,-1.666000,-7.958000],[-109.806007,-2.282000,-8.316000],[-109.806007,-2.290000,-8.320001],[-109.804008,-1.136000,-8.416000],[-111.010002,7.718000,0.620000],[-110.290009,8.336000,0.682000],[-109.852005,6.918000,0.542000],[-109.852005,7.272000,1.076000],[-111.010002,-4.990000,7.412000],[-110.290009,-5.282000,7.960001],[-109.818008,-4.234000,7.380000],[-109.850006,-4.606000,6.696000],[-109.836006,-5.544000,6.848001],[-111.010002,-4.990000,-7.870000],[-110.290009,-5.282000,-8.418000],[-109.836006,-5.544000,-7.304000],[-109.850006,-4.606000,-7.154000],[-109.818008,-4.234000,-7.836000],[-111.010002,7.386000,-2.744000],[-110.290009,7.980000,-2.924000],[-109.852005,6.702000,-2.714000],[-109.852005,6.618001,-2.510000],[-109.852005,7.442000,-1.956000],[-111.010002,-0.904000,8.436001],[-111.010002,-1.754000,8.394000],[-110.290009,-1.814000,9.012000],[-110.290009,-0.904000,9.058001],[-109.852005,-0.904000,8.360001],[-109.804008,-1.136000,7.958000],[-109.824005,-1.666000,7.502000],[-109.806007,-2.282000,7.858000],[-109.806007,-2.290000,7.862000],[-111.010002,-7.602000,-5.726000],[-110.290009,-8.082001,-6.120000],[-109.852005,-7.290000,-5.154000],[-109.852005,-6.982000,-5.216000],[-111.010002,-0.056000,8.394000],[-110.290009,0.004000,9.012000],[-109.824005,-0.144000,7.502000],[-109.806007,0.472000,7.858000],[-109.806007,0.480000,7.862000],[-109.804008,-0.674000,7.958000],[-111.010002,5.792000,-5.726000],[-110.290009,6.272000,-6.120000],[-109.852005,5.172000,-5.216000],[-109.852005,5.480000,-5.154000],[-111.010002,-9.196000,-2.744000],[-110.290009,-9.790001,-2.924000],[-109.852005,-9.252001,-1.956000],[-109.852005,-8.428000,-2.510000],[-109.852005,-8.510000,-2.714000],[-109.820007,-2.500000,7.556000],[-109.822006,-2.440000,7.488000],[-109.808006,-2.304000,7.828001],[-109.820007,-0.904000,7.588000],[-109.808006,0.494000,7.828001],[-109.822006,0.630000,7.488000],[-109.820007,0.690000,7.556000],[-109.828003,2.164000,7.180000],[-109.842003,3.738000,6.722000],[-109.842003,3.772000,6.740000],[-109.842003,3.772000,-7.196001],[-109.842003,3.740000,-7.178000],[-109.828003,2.164000,-7.638000],[-109.820007,0.690000,-8.014000],[-109.822006,0.630000,-7.944000],[-109.808006,0.496000,-8.284000],[-109.820007,-0.904000,-8.046000],[-109.808006,-2.304000,-8.284000],[-109.822006,-2.440000,-7.944000],[-109.820007,-2.500000,-8.014000],[-109.828003,-3.974000,-7.638000],[-109.842003,-5.548000,-7.178000],[-109.842003,-5.582000,-7.196001],[-109.842003,-5.582000,6.740000],[-109.842003,-5.548000,6.722000],[-109.828003,-3.974000,7.180000],[-112.440002,-4.514000,5.176000],[-112.440002,-4.516000,5.174000],[-112.440002,-4.518000,5.178000],[-112.440002,-4.518000,5.174000],[-112.440002,-4.518000,-5.636000],[-112.440002,-4.518000,-5.630000],[-112.440002,-4.516000,-5.632000],[-112.440002,-4.514000,-5.632000],[-112.440002,2.704000,-5.632000],[-112.440002,2.706000,-5.632000],[-112.440002,2.708000,-5.636000],[-112.440002,2.708000,-5.630000],[-112.440002,2.708000,5.178000],[-112.440002,2.708000,5.174000],[-112.440002,2.706000,5.174000],[-112.440002,2.704000,5.176000],[-112.044006,-8.938001,-1.828000],[-112.044006,-8.744000,-2.606000],[-111.600006,-8.954000,-2.670000],[-111.600006,-9.154000,-1.870000],[-111.600006,-8.676001,-3.448000],[-112.044006,-8.474000,-3.364000],[-112.044006,4.888000,-6.022000],[-112.044006,5.426000,-5.426000],[-111.600006,5.598000,-5.564000],[-111.600006,5.044000,-6.176000],[-111.600006,6.090000,-4.902000],[-112.044006,5.906000,-4.780000],[-112.044006,0.692000,7.806000],[-112.044006,-0.102000,7.924000],[-111.600006,-0.080000,8.142000],[-111.600006,0.736000,8.022000],[-111.600006,-0.904000,8.182000],[-112.044006,-0.904000,7.962000],[-112.044006,-7.716001,-4.780000],[-112.044006,-7.236001,-5.426000],[-111.600006,-7.408000,-5.564000],[-111.600006,-7.900001,-4.902000],[-111.600006,-6.852000,-6.176000],[-112.044006,-6.696000,-6.022000],[-112.044006,-1.708000,7.924000],[-111.600006,-1.728000,8.142000],[-111.600006,-2.546000,8.022000],[-112.044006,-2.502000,7.806000],[-112.044006,6.664001,-3.364000],[-112.044006,6.934000,-2.606000],[-111.600006,7.146000,-2.670000],[-111.600006,6.868001,-3.448000],[-111.600006,7.346000,-1.870000],[-112.044006,7.128000,-1.828000],[-112.044006,-5.456000,-7.040000],[-112.044006,-4.766000,-7.454000],[-111.600006,-4.870000,-7.646000],[-111.600006,-5.578000,-7.222000],[-111.600006,-4.124000,-8.000000],[-112.044006,-4.040000,-7.796000],[-112.044006,-4.040000,7.340000],[-112.044006,-4.766000,6.996000],[-111.600006,-4.870000,7.190001],[-111.600006,-4.124000,7.542000],[-111.600006,-5.578000,6.766000],[-112.044006,-5.456000,6.582000],[-112.044006,7.286000,-0.228000],[-112.044006,7.248000,0.574000],[-111.600006,7.466001,0.596000],[-111.600006,7.508000,-0.228000],[-111.600006,7.346000,1.412000],[-112.044006,7.128000,1.370000],[-112.044006,-2.502000,-8.264000],[-112.044006,-1.708000,-8.380000],[-111.600006,-1.728000,-8.600000],[-111.600006,-2.546000,-8.478001],[-111.600006,-0.904000,-8.640000],[-112.044006,-0.904000,-8.420000],[-112.044006,-6.696000,5.564000],[-112.044006,-7.236001,4.968000],[-111.600006,-7.408000,5.108000],[-111.600006,-6.852000,5.720000],[-111.600006,-7.900001,4.446000],[-112.044006,-7.716001,4.322000],[-112.044006,6.664001,2.906000],[-112.044006,6.320000,3.632000],[-111.600006,6.514000,3.736000],[-111.600006,6.868001,2.990000],[-111.600006,6.090000,4.446000],[-112.044006,5.906000,4.322000],[-112.044006,-8.474000,2.906000],[-112.044006,-8.744000,2.150000],[-111.600006,-8.954000,2.214000],[-111.600006,-8.676001,2.990000],[-111.600006,-9.154000,1.412000],[-112.044006,-8.938001,1.370000],[-112.044006,0.692000,-8.264000],[-112.044006,1.472000,-8.068001],[-111.600006,1.536000,-8.278001],[-111.600006,0.736000,-8.478001],[-111.600006,2.314000,-8.000000],[-112.044006,2.230000,-7.796000],[-112.044006,4.888000,5.564000],[-112.044006,4.292000,6.104000],[-111.600006,4.432000,6.274000],[-111.600006,5.044000,5.720000],[-111.600006,3.768000,6.766000],[-112.044006,3.646000,6.582000],[-112.044006,-9.098001,-0.228000],[-112.044006,-9.056001,-1.032000],[-111.600006,-9.276000,-1.054000],[-111.600006,-9.318001,-0.228000],[-112.044006,3.646000,-7.040000],[-112.044006,4.292000,-6.562000],[-111.600006,4.432000,-6.732000],[-111.600006,3.768000,-7.222000],[-112.044006,2.230000,7.340000],[-112.044006,1.472000,7.610000],[-111.600006,1.536000,7.820000],[-111.600006,2.314000,7.542000],[-112.044006,-8.130000,-4.090000],[-111.600006,-8.324000,-4.194000],[-112.044006,6.320000,-4.090000],[-111.600006,6.514000,-4.194000],[-112.044006,-6.102000,-6.562000],[-111.600006,-6.242000,-6.732000],[-112.044006,-3.282000,7.610000],[-111.600006,-3.346000,7.820000],[-112.044006,7.248000,-1.032000],[-111.600006,7.466001,-1.054000],[-112.044006,-3.282000,-8.068001],[-111.600006,-3.346000,-8.278001],[-112.044006,-6.102000,6.104000],[-111.600006,-6.242000,6.274000],[-112.044006,6.934000,2.150000],[-111.600006,7.146000,2.214000],[-112.044006,-8.130000,3.632000],[-111.600006,-8.324000,3.736000],[-112.044006,-0.102000,-8.380000],[-111.600006,-0.080000,-8.600000],[-112.044006,5.426000,4.968000],[-111.600006,5.598000,5.108000],[-112.044006,-9.056001,0.574000],[-111.600006,-9.276000,0.596000],[-112.044006,2.956000,-7.454000],[-111.600006,3.060000,-7.646000],[-112.044006,2.956000,6.996000],[-111.600006,3.060000,7.190001],[-112.438004,2.690000,5.186000],[-112.426003,2.508000,5.310000],[-112.404007,2.178000,5.538000],[-112.326004,2.710000,6.534000],[-112.326004,3.356000,6.148000],[-112.326004,2.030000,6.856000],[-112.432007,1.662000,5.830000],[-112.432007,1.614000,5.854000],[-112.404007,2.160000,5.552000],[-112.410004,2.072000,5.602000],[-112.412003,2.034000,5.626000],[-112.412003,2.034000,-6.084000],[-112.410004,2.072000,-6.060000],[-112.404007,2.160000,-6.008000],[-112.404007,2.178000,-5.996000],[-112.326004,2.710000,-6.992000],[-112.432007,1.662000,-6.288000],[-112.432007,1.614000,-6.312000],[-112.326004,2.030000,-7.314000],[-112.326004,3.356000,-6.606000],[-112.426003,2.508000,-5.766000],[-112.438004,2.690000,-5.642000],[-112.370003,-7.970000,0.584000],[-112.364006,-7.994000,0.470000],[-112.326004,-8.538000,0.522000],[-112.380005,-7.934000,0.772000],[-112.326004,-8.426001,1.268000],[-112.382004,-7.904000,0.912000],[-112.384003,-7.866000,1.070000],[-112.384003,-7.846000,1.152000],[-112.326004,-8.574000,-0.228000],[-112.372002,-8.086000,0.028000],[-112.370003,-8.128000,-0.228000],[-112.374008,-8.070001,0.102000],[-112.376007,-8.052000,0.200000],[-112.368004,-8.016001,0.378000],[-112.364006,-7.994000,0.468000],[-112.326004,5.022000,4.636000],[-112.346008,4.934000,4.424000],[-112.340004,4.874000,4.514000],[-112.346008,4.980000,4.354000],[-112.354004,5.102000,4.064000],[-112.360008,5.194000,3.846000],[-112.326004,5.472000,4.032000],[-112.326004,4.518000,5.194000],[-112.342003,4.412000,5.088000],[-112.340004,4.608000,4.890000],[-112.340004,4.690000,4.808000],[-112.344002,4.824000,4.596000],[-112.340004,4.868000,4.526000],[-112.396004,-0.322000,-6.920001],[-112.392006,-0.248000,-6.910000],[-112.326004,-0.154000,-7.860001],[-112.416008,-0.744000,-6.972000],[-112.326004,-0.904000,-7.898000],[-112.416008,-0.904000,-6.986001],[-112.326004,0.590000,-7.750000],[-112.420006,0.270000,-6.832000],[-112.420006,0.386000,-6.800000],[-112.420006,0.402000,-6.796000],[-112.402008,-0.012000,-6.896000],[-112.362007,-7.228000,3.302000],[-112.358002,-7.270000,3.174000],[-112.326004,-7.668000,3.386000],[-112.366005,-7.202000,3.386000],[-112.326004,-7.282001,4.032000],[-112.360008,-7.088000,3.706000],[-112.356003,-7.022000,3.858000],[-112.326004,-7.990000,2.706000],[-112.378006,-7.438000,2.652000],[-112.380005,-7.486001,2.498000],[-112.372002,-7.358000,2.924000],[-112.372002,-7.350000,2.952000],[-112.390007,5.898000,1.464000],[-112.390007,5.898000,1.470000],[-112.372002,5.804000,1.806000],[-112.326004,6.434000,1.998000],[-112.390007,5.982000,1.142000],[-112.326004,6.616000,1.268000],[-112.326004,6.180000,2.706000],[-112.386002,5.728000,2.136000],[-112.386002,5.718000,2.178000],[-112.384003,5.634000,2.480000],[-112.378006,5.772000,1.940000],[-112.412003,-4.954000,4.846000],[-112.406006,-5.034000,4.802000],[-112.326004,-5.770000,5.700000],[-112.426003,-4.736000,5.010000],[-112.326004,-5.166000,6.148000],[-112.326004,-6.328000,5.194000],[-112.380005,-5.676000,5.028000],[-112.380005,-5.680000,5.036000],[-112.400002,-5.604000,4.842000],[-112.400002,-5.594000,4.826000],[-112.364006,-5.780000,5.176000],[-112.348007,-6.010000,5.192000],[-112.342003,-6.222000,5.088000],[-112.348007,-5.976000,5.208000],[-112.362007,-5.788000,5.184000],[-112.362007,-5.800000,5.186000],[-112.404007,-5.568000,4.782000],[-112.412003,-5.504000,4.694000],[-112.412003,-5.502000,4.690000],[-112.416008,-5.324000,4.668000],[-112.416008,-5.300000,4.664000],[-112.414009,-5.238000,4.696000],[-112.400002,-2.904000,-6.562000],[-112.326004,-3.132000,-7.568000],[-112.428009,-3.330000,-6.358000],[-112.396004,-2.834000,-6.590000],[-112.432007,-3.374000,-6.338000],[-112.326004,-3.840000,-7.314000],[-112.432007,-3.424000,-6.312000],[-112.326004,-2.400000,-7.750000],[-112.422005,-2.330000,-6.764000],[-112.420006,-2.210000,-6.796000],[-112.400002,-2.756000,-6.628000],[-112.374008,6.114000,-1.042000],[-112.366005,6.140000,-0.926000],[-112.366005,6.140000,-0.922000],[-112.326004,6.728000,-0.980000],[-112.386002,6.068000,-1.252000],[-112.326004,6.616000,-1.726000],[-112.388008,6.000000,-1.526000],[-112.388008,6.038000,-1.370000],[-112.390007,5.982000,-1.598000],[-112.326004,6.764000,-0.228000],[-112.376007,6.238000,-0.560000],[-112.374008,6.254000,-0.486000],[-112.370003,6.318000,-0.228000],[-112.378006,6.218000,-0.640000],[-112.370003,6.164001,-0.836000],[-112.400002,-2.756000,6.170000],[-112.396004,-2.834000,6.134000],[-112.326004,-3.132000,7.110000],[-112.422005,-2.330000,6.306000],[-112.326004,-2.400000,7.294000],[-112.420006,-2.210000,6.340000],[-112.326004,-3.840000,6.856000],[-112.432007,-3.374000,5.880000],[-112.432007,-3.424000,5.854000],[-112.428009,-3.330000,5.900000],[-112.400002,-2.904000,6.104000],[-112.326004,-5.770000,-6.158000],[-112.400002,-5.594000,-5.282000],[-112.404007,-5.568000,-5.238000],[-112.412003,-5.504000,-5.152000],[-112.412003,-5.502000,-5.148000],[-112.416008,-5.324000,-5.124000],[-112.416008,-5.300000,-5.120000],[-112.414009,-5.238000,-5.154000],[-112.406006,-5.032000,-5.258000],[-112.380005,-5.680000,-5.494000],[-112.364006,-5.780000,-5.634000],[-112.380005,-5.676000,-5.486000],[-112.400002,-5.604000,-5.300000],[-112.326004,-6.328000,-5.652000],[-112.342003,-6.222000,-5.546000],[-112.348007,-6.010000,-5.650000],[-112.348007,-5.976000,-5.666000],[-112.362007,-5.800000,-5.644000],[-112.362007,-5.788000,-5.642000],[-112.326004,-5.166000,-6.606000],[-112.426003,-4.736000,-5.466000],[-112.412003,-4.954000,-5.304000],[-112.366005,5.384000,-3.758000],[-112.360008,5.428000,-3.614000],[-112.326004,5.858000,-3.844000],[-112.368004,5.358000,-3.842000],[-112.362007,5.252000,-4.164000],[-112.326004,5.472000,-4.490000],[-112.358002,5.194000,-4.304000],[-112.326004,6.180000,-3.164000],[-112.378006,5.520000,-3.340000],[-112.382004,5.584000,-3.112000],[-112.384003,5.634000,-2.936000],[-112.372002,5.498000,-3.410000],[-112.326004,-7.668000,-3.844000],[-112.372002,-7.358000,-3.382000],[-112.372002,-7.350000,-3.410000],[-112.358002,-7.270000,-3.630000],[-112.380005,-7.486001,-2.954000],[-112.378006,-7.438000,-3.110000],[-112.326004,-7.990000,-3.164000],[-112.326004,-7.282001,-4.490000],[-112.366005,-7.202000,-3.842000],[-112.360008,-7.088000,-4.164000],[-112.356003,-7.022000,-4.316000],[-112.362007,-7.228000,-3.760000],[-112.326004,1.322000,7.110000],[-112.400002,1.094000,6.104000],[-112.396004,1.024000,6.134000],[-112.432007,1.564000,5.880000],[-112.428009,1.522000,5.900000],[-112.326004,0.590000,7.294000],[-112.422005,0.520000,6.306000],[-112.420006,0.402000,6.340000],[-112.400002,0.946000,6.170000],[-112.426003,2.928000,-5.466000],[-112.412003,3.144000,-5.304000],[-112.406006,3.222000,-5.258000],[-112.326004,3.960000,-6.158000],[-112.326004,4.518000,-5.652000],[-112.400002,3.784000,-5.282000],[-112.400002,3.794000,-5.300000],[-112.380005,3.866000,-5.486000],[-112.380005,3.870000,-5.494000],[-112.364006,3.970000,-5.634000],[-112.362007,3.978000,-5.642000],[-112.362007,3.990000,-5.644000],[-112.348007,4.166000,-5.666000],[-112.348007,4.200000,-5.650000],[-112.342003,4.412000,-5.546000],[-112.414009,3.428000,-5.154000],[-112.416008,3.490000,-5.120000],[-112.416008,3.514000,-5.124000],[-112.412003,3.692000,-5.148000],[-112.412003,3.694000,-5.152000],[-112.404007,3.758000,-5.238000],[-112.326004,-8.538000,-0.980000],[-112.376007,-8.052000,-0.658000],[-112.368004,-8.016001,-0.836000],[-112.364006,-7.994000,-0.926000],[-112.372002,-8.086000,-0.486000],[-112.374008,-8.070001,-0.560000],[-112.326004,-8.426001,-1.726000],[-112.380005,-7.934000,-1.228000],[-112.382004,-7.904000,-1.370000],[-112.384003,-7.866000,-1.528000],[-112.384003,-7.846000,-1.610000],[-112.370003,-7.970000,-1.042000],[-112.416008,3.490000,4.664000],[-112.414009,3.428000,4.696000],[-112.406006,3.224000,4.802000],[-112.416008,3.514000,4.668000],[-112.412003,3.692000,4.690000],[-112.412003,3.694000,4.694000],[-112.404007,3.758000,4.782000],[-112.400002,3.784000,4.826000],[-112.326004,3.960000,5.700000],[-112.380005,3.866000,5.028000],[-112.400002,3.794000,4.842000],[-112.380005,3.870000,5.036000],[-112.362007,3.978000,5.184000],[-112.364006,3.970000,5.176000],[-112.362007,3.990000,5.186000],[-112.348007,4.166000,5.208000],[-112.348007,4.200000,5.192000],[-112.426003,2.928000,5.010000],[-112.412003,3.144000,4.846000],[-112.400002,0.946000,-6.628000],[-112.396004,1.024000,-6.590000],[-112.326004,1.322000,-7.568000],[-112.422005,0.520000,-6.764000],[-112.432007,1.564000,-6.338000],[-112.428009,1.522000,-6.358000],[-112.400002,1.094000,-6.562000],[-112.372002,-7.640000,1.938000],[-112.368004,-7.668000,1.822000],[-112.326004,-8.244000,1.998000],[-112.382004,-7.596000,2.126000],[-112.382004,-7.582000,2.178000],[-112.384003,-7.768001,1.470000],[-112.384003,-7.758000,1.512000],[-112.326004,5.858000,3.386000],[-112.378006,5.520000,2.882000],[-112.372002,5.500000,2.952000],[-112.360008,5.428000,3.156000],[-112.382004,5.584000,2.654000],[-112.368004,5.358000,3.386000],[-112.362007,5.252000,3.706000],[-112.366005,5.384000,3.300000],[-112.340004,-6.684000,4.526000],[-112.340004,-6.690001,4.518000],[-112.326004,-6.832000,4.636000],[-112.342003,-6.640000,4.598000],[-112.340004,-6.422000,4.890000],[-112.338005,-6.506001,4.808000],[-112.344002,-6.748000,4.434000],[-112.346008,-6.800000,4.354000],[-112.352005,-6.932000,4.066000],[-112.420006,-2.080000,-6.832000],[-112.402008,-1.796000,-6.896000],[-112.326004,-1.658000,-7.860001],[-112.392006,-1.564000,-6.910000],[-112.420006,-2.196000,-6.800000],[-112.416008,-1.064000,-6.972000],[-112.396004,-1.488000,-6.920001],[-112.378006,6.218000,0.184000],[-112.370003,6.164001,0.378000],[-112.366005,6.140000,0.466000],[-112.326004,6.728000,0.522000],[-112.374008,6.254000,0.028000],[-112.376007,6.238000,0.102000],[-112.386002,6.068000,0.794000],[-112.388008,6.038000,0.912000],[-112.388008,6.000000,1.068000],[-112.366005,6.140000,0.468000],[-112.374008,6.114000,0.584000],[-112.404007,-3.970000,5.552000],[-112.404007,-3.988000,5.538000],[-112.326004,-4.520000,6.534000],[-112.410004,-3.882000,5.602000],[-112.412003,-3.842000,5.626000],[-112.432007,-3.472000,5.830000],[-112.438004,-4.500000,5.186000],[-112.426003,-4.318000,5.310000],[-112.326004,-4.520000,-6.992000],[-112.438004,-4.500000,-5.642000],[-112.426003,-4.318000,-5.766000],[-112.404007,-3.988000,-5.996000],[-112.432007,-3.470000,-6.288000],[-112.404007,-3.970000,-6.008000],[-112.410004,-3.882000,-6.060000],[-112.412003,-3.842000,-6.084000],[-112.386002,5.728000,-2.594000],[-112.378006,5.772000,-2.396000],[-112.372002,5.804000,-2.264000],[-112.326004,6.434000,-2.456000],[-112.386002,5.718000,-2.636000],[-112.390007,5.898000,-1.922000],[-112.390007,5.898000,-1.926000],[-112.396004,-1.488000,6.462000],[-112.392006,-1.564000,6.452000],[-112.326004,-1.658000,7.402000],[-112.416008,-1.066000,6.514000],[-112.414009,-0.904000,6.528000],[-112.326004,-0.904000,7.440001],[-112.420006,-2.196000,6.344000],[-112.420006,-2.080000,6.374000],[-112.402008,-1.796000,6.438000],[-112.326004,-6.832000,-5.094000],[-112.344002,-6.748000,-4.890000],[-112.340004,-6.688000,-4.976000],[-112.346008,-6.800000,-4.810000],[-112.352005,-6.932000,-4.522000],[-112.340004,-6.422000,-5.348000],[-112.342003,-6.640000,-5.056000],[-112.338005,-6.506001,-5.266000],[-112.340004,-6.684000,-4.982000],[-112.420006,0.270000,6.374000],[-112.402008,-0.012000,6.438000],[-112.326004,-0.154000,7.402000],[-112.392006,-0.248000,6.452000],[-112.420006,0.386000,6.344000],[-112.416008,-0.744000,6.514000],[-112.396004,-0.322000,6.462000],[-112.344002,4.824000,-5.054000],[-112.340004,4.868000,-4.982000],[-112.340004,4.874000,-4.972000],[-112.326004,5.022000,-5.094000],[-112.340004,4.608000,-5.348000],[-112.340004,4.692000,-5.266000],[-112.354004,5.102000,-4.522000],[-112.346008,4.934000,-4.880000],[-112.346008,4.980000,-4.810000],[-112.326004,-8.244000,-2.456000],[-112.384003,-7.758000,-1.970000],[-112.368004,-7.668000,-2.280000],[-112.384003,-7.768001,-1.926000],[-112.382004,-7.596000,-2.582000],[-112.382004,-7.582000,-2.636000],[-112.372002,-7.640000,-2.394000],[-113.242004,5.104000,4.808000],[-114.706009,5.304000,4.808000],[-114.740005,5.056000,5.094000],[-113.336006,4.864000,5.088000],[-113.142006,5.348000,4.354000],[-114.666008,5.556000,4.350000],[-113.420006,4.650000,5.208000],[-114.770004,4.834000,5.218000],[-113.486008,4.480000,5.184000],[-114.792007,4.660000,5.198000],[-116.198006,4.650000,5.244000],[-116.256004,4.866000,5.106000],[-117.660004,4.096000,5.298000],[-117.852005,4.290000,5.136000],[-116.150009,4.480000,5.232000],[-117.500008,3.942000,5.304000],[-116.314003,5.106000,4.810000],[-116.364006,5.350000,4.340000],[-118.054008,4.508000,4.812000],[-118.240005,4.726000,4.322000],[-119.914009,3.508000,4.816000],[-121.610008,2.210000,4.820000],[-120.978004,2.082000,5.236000],[-119.502007,3.330000,5.182000],[-120.298004,3.688000,4.292000],[-122.200005,2.336000,4.258000],[-119.112007,3.172000,5.388000],[-120.378006,1.970000,5.486000],[-118.790009,3.046000,5.422000],[-119.886009,1.880000,5.554000],[-121.280006,0.582000,5.566000],[-122.048004,0.644000,5.278000],[-121.640007,-0.898000,5.602000],[-122.482002,-0.894000,5.296000],[-120.650009,0.534000,5.662000],[-120.950005,-0.902000,5.708000],[-122.858009,0.710000,4.824000],[-123.610008,0.774000,4.230000],[-123.368004,-0.894000,4.826000],[-124.190002,-0.898000,4.218000],[-122.858009,-2.502000,4.824000],[-121.610008,-4.010000,4.820000],[-120.978004,-3.880000,5.236000],[-122.048004,-2.434000,5.278000],[-123.610008,-2.576000,4.230000],[-122.200005,-4.152000,4.258000],[-121.280006,-2.380000,5.566000],[-120.378006,-3.770000,5.486000],[-120.650009,-2.338000,5.662000],[-119.886009,-3.686000,5.554000],[-119.112007,-4.974000,5.388000],[-119.502007,-5.134000,5.182000],[-117.660004,-5.902000,5.298000],[-117.852005,-6.098001,5.136000],[-118.790009,-4.852000,5.422000],[-117.500008,-5.750000,5.304000],[-119.914009,-5.320000,4.816000],[-120.298004,-5.518000,4.292000],[-118.054008,-6.326000,4.812000],[-118.240005,-6.568000,4.322000],[-116.314003,-6.926000,4.810000],[-114.706009,-7.124001,4.808000],[-114.740005,-6.870000,5.094000],[-116.256004,-6.676000,5.106000],[-116.364006,-7.192000,4.340000],[-114.666008,-7.392000,4.350000],[-116.198006,-6.460001,5.244000],[-114.770004,-6.644001,5.218000],[-116.150009,-6.290000,5.232000],[-114.792007,-6.470000,5.198000],[-113.420006,-6.460001,5.208000],[-113.336006,-6.676000,5.088000],[-113.486008,-6.290000,5.184000],[-113.242004,-6.920001,4.808000],[-113.142006,-7.174000,4.354000],[-112.442009,3.716000,4.690000],[-112.548004,3.604000,4.664000],[-116.116005,4.378000,5.086000],[-116.102005,4.308000,4.888000],[-114.814003,4.480000,4.854000],[-114.804008,4.554000,5.048000],[-117.400009,3.852000,5.162000],[-117.346008,3.784000,4.958000],[-113.522003,4.378000,5.036000],[-113.552002,4.308000,4.842000],[-113.596008,4.230000,4.690000],[-114.838005,4.398000,4.700000],[-113.674004,4.104000,4.664000],[-114.890007,4.268000,4.670000],[-116.106003,4.224000,4.728000],[-117.330002,3.704000,4.784000],[-116.134003,4.094000,4.690000],[-117.340004,3.574000,4.730000],[-120.260002,0.506000,5.538000],[-120.058006,0.482000,5.296000],[-119.418007,1.782000,5.198000],[-119.580009,1.826000,5.426000],[-120.418007,-0.904000,5.472000],[-120.396004,-0.806000,5.464000],[-120.522003,-0.904000,5.588000],[-120.254005,-0.186000,5.408000],[-120.124008,0.168000,5.320000],[-120.106003,0.200000,5.306000],[-118.590004,2.972000,5.286000],[-118.484009,2.912000,5.072000],[-118.446007,2.838000,4.876000],[-119.366005,1.720000,4.974000],[-118.454002,2.712000,4.794000],[-119.378006,1.612000,4.852000],[-119.996002,0.446000,5.042000],[-120.014008,0.416000,5.084000],[-119.998009,0.440000,5.042000],[-120.080009,0.264000,5.240000],[-120.088005,0.246000,5.258000],[-120.030006,0.386000,4.872000],[-120.004005,0.432000,5.000000],[-120.004005,0.434000,4.944000],[-119.932007,0.580000,4.902000],[-119.998009,0.440000,5.040000],[-118.590004,-4.780000,5.286000],[-118.484009,-4.722000,5.072000],[-119.418007,-3.590000,5.198000],[-119.580009,-3.634000,5.426000],[-117.400009,-5.660000,5.162000],[-117.346008,-5.594000,4.958000],[-120.260002,-2.312000,5.538000],[-120.058006,-2.290000,5.296000],[-120.124008,-1.978000,5.320000],[-120.106003,-2.010000,5.306000],[-120.254005,-1.624000,5.408000],[-120.420006,-0.904000,5.472000],[-120.396004,-1.004000,5.464000],[-119.996002,-2.256000,5.042000],[-119.366005,-3.530000,4.974000],[-120.004005,-2.242000,5.000000],[-120.004005,-2.244000,4.944000],[-120.030006,-2.196000,4.872000],[-119.932007,-2.390000,4.902000],[-119.378006,-3.422000,4.852000],[-120.088005,-2.056000,5.258000],[-119.998009,-2.250000,5.042000],[-120.014008,-2.224000,5.084000],[-120.080009,-2.074000,5.240000],[-119.998009,-2.248000,5.040000],[-118.446007,-4.648000,4.876000],[-117.330002,-5.514000,4.784000],[-118.454002,-4.522000,4.794000],[-117.340004,-5.384000,4.730000],[-113.522003,-6.188000,5.036000],[-113.552002,-6.118001,4.842000],[-114.814003,-6.292000,4.854000],[-114.804008,-6.364000,5.048000],[-116.116005,-6.188000,5.086000],[-116.102005,-6.116000,4.888000],[-116.106003,-6.034000,4.728000],[-114.838005,-6.208000,4.700000],[-116.134003,-5.902000,4.690000],[-114.890007,-6.078000,4.670000],[-113.596008,-6.038000,4.690000],[-112.442009,-5.526000,4.690000],[-113.674004,-5.914001,4.664000],[-112.548004,-5.414000,4.664000],[-116.446007,-7.906000,2.164000],[-114.558006,-8.104000,2.174000],[-114.592003,-7.894001,2.946000],[-116.428009,-7.694000,2.934000],[-118.592003,-7.232000,2.140000],[-118.504005,-7.036000,2.906000],[-116.458008,-8.070001,1.458000],[-114.530006,-8.270000,1.468000],[-118.656006,-7.384000,1.444000],[-116.402008,-7.452000,3.688000],[-114.628006,-7.652000,3.702000],[-118.388008,-6.808000,3.660000],[-113.052002,-7.418000,3.706000],[-112.970009,-7.642000,2.952000],[-112.898003,-7.838000,2.178000],[-112.838005,-7.996000,1.470000],[-125.018005,-2.798000,2.026000],[-123.304008,-4.554000,2.060000],[-123.028008,-4.434000,2.810000],[-124.668007,-2.730000,2.768000],[-125.730003,-0.932000,2.010000],[-125.348007,-0.922000,2.750000],[-125.276009,-2.848000,1.362000],[-123.510002,-4.644000,1.386000],[-126.014008,-0.938000,1.352000],[-124.204002,-2.654000,3.524000],[-122.666008,-4.296000,3.564000],[-124.844009,-0.908000,3.506000],[-120.602005,-5.718000,3.614000],[-120.840004,-5.908000,2.860000],[-121.020004,-6.072001,2.102000],[-121.154007,-6.198000,1.416000],[-121.020004,4.132000,2.102000],[-123.304008,2.642000,2.060000],[-123.028008,2.554000,2.810000],[-120.840004,4.002000,2.860000],[-118.592003,5.274000,2.140000],[-118.504005,5.114000,2.906000],[-121.154007,4.240000,1.416000],[-123.510002,2.718000,1.386000],[-118.656006,5.410000,1.444000],[-120.602005,3.852000,3.614000],[-122.666008,2.450000,3.564000],[-118.388008,4.930000,3.660000],[-124.204002,0.828000,3.524000],[-124.668007,0.876000,2.768000],[-125.018005,0.918000,2.026000],[-125.276009,0.954000,1.362000],[-112.898003,5.958000,2.178000],[-114.558006,6.188000,2.174000],[-114.592003,6.002000,2.946000],[-112.970009,5.780000,2.952000],[-112.838005,6.110000,1.470000],[-114.530006,6.344000,1.468000],[-113.052002,5.574000,3.706000],[-114.628006,5.790000,3.702000],[-116.402008,5.576000,3.688000],[-116.428009,5.780000,2.934000],[-116.446007,5.958000,2.164000],[-116.458008,6.110000,1.458000],[-112.730003,3.416000,4.846000],[-112.976006,3.148000,5.186000],[-112.468002,2.110000,5.626000],[-113.280006,2.790000,5.632000],[-112.896004,1.748000,6.118001],[-113.628006,2.336000,6.136000],[-116.184006,3.874000,4.862000],[-116.226006,3.576000,5.192000],[-115.090004,3.748000,5.184000],[-114.978004,4.052000,4.850000],[-117.368004,3.362000,4.884000],[-117.354004,3.084000,5.202000],[-113.810005,3.898000,4.846000],[-113.990005,3.602000,5.184000],[-114.204002,3.216000,5.626000],[-115.202003,3.362000,5.620000],[-114.442009,2.732000,6.118001],[-115.310005,2.884000,6.100000],[-116.228004,3.206000,5.628000],[-117.240005,2.768000,5.636000],[-116.206009,2.740000,6.108000],[-117.094002,2.358000,6.110000],[-119.474007,1.190000,5.212000],[-119.422005,1.436000,4.938000],[-118.478004,2.504000,4.922000],[-118.422005,2.270000,5.216000],[-118.192009,2.068000,5.630000],[-118.970009,1.364000,5.620000],[-117.938004,1.788000,6.070000],[-118.674004,1.252000,5.970000],[-119.460007,0.916000,5.614000],[-119.836006,0.564000,5.422000],[-119.578003,0.700000,5.692000],[-119.826004,0.282000,5.662000],[-119.242004,0.960000,5.796000],[-119.326004,0.764000,5.820000],[-120.194008,-0.278000,5.562000],[-120.408005,-0.904000,5.494000],[-118.478004,-4.314000,4.922000],[-118.422005,-4.080000,5.216000],[-119.474007,-3.000000,5.212000],[-119.422005,-3.244000,4.938000],[-117.368004,-5.170000,4.884000],[-117.354004,-4.894000,5.202000],[-119.836006,-2.374000,5.422000],[-120.194008,-1.532000,5.562000],[-119.826004,-2.092000,5.662000],[-119.460007,-2.726000,5.614000],[-118.970009,-3.174000,5.620000],[-119.242004,-2.770000,5.796000],[-118.674004,-3.062000,5.970000],[-119.578003,-2.510000,5.692000],[-119.326004,-2.572000,5.820000],[-118.192009,-3.878000,5.630000],[-117.240005,-4.578000,5.636000],[-117.938004,-3.598000,6.070000],[-117.094002,-4.166000,6.110000],[-113.810005,-5.706000,4.846000],[-113.990005,-5.412000,5.184000],[-115.090004,-5.558000,5.184000],[-114.978004,-5.862000,4.850000],[-112.730003,-5.226000,4.846000],[-112.976006,-4.958000,5.186000],[-116.184006,-5.684000,4.862000],[-116.226006,-5.386000,5.192000],[-116.228004,-5.016000,5.628000],[-115.202003,-5.172000,5.620000],[-116.206009,-4.550000,6.108000],[-115.310005,-4.694000,6.100000],[-114.204002,-5.024000,5.626000],[-113.280006,-4.600000,5.632000],[-114.442009,-4.542000,6.118001],[-113.628006,-4.146000,6.136000],[-112.468002,-3.920000,5.626000],[-112.896004,-3.558000,6.118001],[-112.624008,-0.062000,6.608000],[-112.866005,0.702000,6.574000],[-113.332008,0.442000,6.890000],[-113.356003,-0.132000,7.032001],[-112.570007,-0.904000,6.642000],[-113.384003,-0.904000,7.096000],[-114.198006,-0.040000,7.328001],[-113.822006,0.728000,7.032001],[-115.002007,0.260000,7.436000],[-114.462006,1.094000,7.094000],[-114.364006,-0.904000,7.444000],[-115.770004,-0.904000,7.654000],[-113.366005,1.306000,6.608000],[-114.014008,1.778000,6.642000],[-114.692009,2.148000,6.608000],[-115.412003,2.310000,6.564000],[-115.496002,1.788000,6.868001],[-115.054008,1.500000,7.024000],[-115.622009,0.818000,7.296000],[-116.026009,1.494000,6.982000],[-116.444008,0.246000,7.320000],[-116.804008,1.078000,6.962000],[-116.180008,2.152000,6.574000],[-116.984009,1.788000,6.556000],[-117.816002,1.322000,6.436000],[-118.596008,0.910000,6.226000],[-118.640007,0.398000,6.398000],[-117.728004,0.694000,6.742000],[-117.566002,-0.070000,6.996000],[-118.718002,-0.226000,6.496000],[-117.466003,-0.904000,7.110000],[-118.766006,-0.904000,6.524000],[-119.628006,-0.308000,5.996000],[-119.382004,0.242000,6.014000],[-119.774002,-0.904000,5.964000],[-119.236008,0.700000,5.938000],[-119.628006,-1.502000,5.996000],[-119.382004,-2.054000,6.014000],[-118.640007,-2.206000,6.398000],[-118.718002,-1.584000,6.496000],[-117.566002,-1.738000,6.996000],[-117.728004,-2.504000,6.742000],[-116.444008,-2.056000,7.320000],[-116.804008,-2.888000,6.962000],[-117.816002,-3.132000,6.436000],[-118.596008,-2.720000,6.226000],[-116.984009,-3.598000,6.556000],[-119.236008,-2.510000,5.938000],[-116.180008,-3.962000,6.574000],[-115.412003,-4.120000,6.564000],[-115.496002,-3.598000,6.868001],[-116.026009,-3.304000,6.982000],[-115.622009,-2.628000,7.296000],[-115.054008,-3.308000,7.024000],[-115.002007,-2.070000,7.436000],[-114.462006,-2.904000,7.094000],[-114.692009,-3.958000,6.608000],[-114.014008,-3.588000,6.642000],[-113.366005,-3.116000,6.608000],[-112.866005,-2.512000,6.574000],[-113.332008,-2.252000,6.890000],[-113.822006,-2.538000,7.032001],[-114.198006,-1.770000,7.328001],[-113.356003,-1.678000,7.032001],[-112.624008,-1.748000,6.608000],[-112.722008,6.402000,0.102000],[-114.472008,6.646000,0.102000],[-114.488007,6.564000,0.468000],[-112.752007,6.324000,0.468000],[-112.694008,6.472000,-0.228000],[-114.458008,6.718000,-0.228000],[-112.790009,6.230000,0.912000],[-114.506004,6.468000,0.912000],[-116.466003,6.230000,0.906000],[-116.470009,6.324000,0.464000],[-118.704002,5.516000,0.896000],[-118.738007,5.600000,0.458000],[-116.474007,6.402000,0.098000],[-116.476006,6.472000,-0.228000],[-118.764008,5.670000,0.096000],[-118.786003,5.734000,-0.228000],[-121.380005,4.454000,0.092000],[-123.854004,2.870000,0.084000],[-123.770004,2.828000,0.434000],[-121.326004,4.396000,0.448000],[-121.428009,4.504000,-0.228000],[-123.922005,2.906000,-0.228000],[-121.254005,4.328000,0.876000],[-123.660004,2.778000,0.858000],[-125.468002,0.984000,0.842000],[-125.608009,1.012000,0.424000],[-126.222008,-0.938000,0.834000],[-126.374008,-0.930000,0.420000],[-125.714005,1.038000,0.080000],[-125.802010,1.062000,-0.228000],[-126.490005,-0.918000,0.078000],[-126.584007,-0.904000,-0.228000],[-125.714005,-2.882000,0.080000],[-123.854004,-4.722000,0.084000],[-123.770004,-4.720000,0.434000],[-125.608009,-2.884000,0.424000],[-125.802010,-2.872000,-0.228000],[-123.922005,-4.716000,-0.228000],[-125.468002,-2.874000,0.842000],[-123.660004,-4.696000,0.858000],[-121.254005,-6.272000,0.876000],[-121.326004,-6.310000,0.448000],[-118.704002,-7.476000,0.896000],[-118.738007,-7.524000,0.458000],[-121.380005,-6.318000,0.092000],[-121.428009,-6.314000,-0.228000],[-118.764008,-7.542000,0.096000],[-118.786003,-7.544000,-0.228000],[-116.474007,-8.266001,0.098000],[-114.472008,-8.498000,0.102000],[-114.488007,-8.454000,0.468000],[-116.470009,-8.236000,0.464000],[-116.476006,-8.282001,-0.228000],[-114.458008,-8.528001,-0.228000],[-116.466003,-8.176001,0.906000],[-114.506004,-8.382000,0.912000],[-112.790009,-8.108001,0.912000],[-112.752007,-8.186001,0.468000],[-112.722008,-8.240001,0.102000],[-112.694008,-8.282001,-0.228000],[-113.242004,5.104000,-5.266000],[-113.336006,4.864000,-5.546000],[-114.740005,5.056000,-5.550000],[-114.706009,5.304000,-5.266000],[-113.142006,5.348000,-4.810000],[-114.666008,5.556000,-4.808000],[-113.420006,4.650000,-5.666000],[-114.770004,4.834000,-5.674000],[-113.486008,4.480000,-5.642000],[-114.792007,4.660000,-5.654000],[-116.198006,4.650000,-5.702000],[-116.256004,4.866000,-5.564000],[-117.660004,4.096000,-5.754000],[-117.852005,4.290000,-5.592000],[-116.150009,4.480000,-5.690000],[-117.500008,3.942000,-5.762000],[-116.314003,5.106000,-5.268000],[-116.364006,5.350000,-4.798000],[-118.054008,4.508000,-5.270000],[-118.240005,4.726000,-4.780000],[-119.914009,3.508000,-5.274000],[-119.502007,3.330000,-5.640000],[-120.978004,2.082000,-5.694000],[-121.610008,2.210000,-5.278000],[-120.298004,3.688000,-4.750000],[-122.200005,2.336000,-4.716000],[-119.112007,3.172000,-5.844000],[-120.378006,1.970000,-5.942000],[-118.790009,3.046000,-5.880000],[-119.886009,1.880000,-6.012000],[-121.280006,0.582000,-6.022000],[-122.048004,0.644000,-5.736000],[-121.640007,-0.898000,-6.060000],[-122.482002,-0.894000,-5.754000],[-120.650009,0.534000,-6.118001],[-120.950005,-0.902000,-6.166000],[-122.858009,0.710000,-5.282000],[-123.610008,0.774000,-4.688000],[-123.368004,-0.894000,-5.284000],[-124.190002,-0.898000,-4.676000],[-122.858009,-2.502000,-5.282000],[-122.048004,-2.434000,-5.736000],[-120.978004,-3.880000,-5.694000],[-121.610008,-4.010000,-5.278000],[-123.610008,-2.576000,-4.688000],[-122.200005,-4.152000,-4.716000],[-121.280006,-2.380000,-6.022000],[-120.378006,-3.770000,-5.942000],[-120.650009,-2.338000,-6.118001],[-119.886009,-3.686000,-6.012000],[-119.112007,-4.974000,-5.844000],[-119.502007,-5.134000,-5.640000],[-117.660004,-5.902000,-5.754000],[-117.852005,-6.098001,-5.592000],[-118.790009,-4.852000,-5.880000],[-117.500008,-5.750000,-5.762000],[-119.914009,-5.320000,-5.274000],[-120.298004,-5.518000,-4.750000],[-118.054008,-6.326000,-5.270000],[-118.240005,-6.568000,-4.780000],[-116.314003,-6.926000,-5.268000],[-116.256004,-6.676000,-5.564000],[-114.740005,-6.870000,-5.550000],[-114.706009,-7.124001,-5.266000],[-116.364006,-7.192000,-4.798000],[-114.666008,-7.392000,-4.808000],[-116.198006,-6.460001,-5.702000],[-114.770004,-6.644001,-5.674000],[-116.150009,-6.290000,-5.690000],[-114.792007,-6.470000,-5.654000],[-113.420006,-6.460001,-5.666000],[-113.336006,-6.676000,-5.546000],[-113.486008,-6.290000,-5.642000],[-113.242004,-6.920001,-5.266000],[-113.142006,-7.174000,-4.810000],[-112.442009,3.716000,-5.148000],[-112.548004,3.604000,-5.120000],[-116.116005,4.378000,-5.544000],[-114.804008,4.554000,-5.506000],[-114.814003,4.480000,-5.310000],[-116.102005,4.308000,-5.346000],[-117.400009,3.852000,-5.618000],[-117.346008,3.784000,-5.416000],[-113.522003,4.378000,-5.494000],[-113.552002,4.308000,-5.300000],[-113.596008,4.230000,-5.148000],[-114.838005,4.398000,-5.158000],[-113.674004,4.104000,-5.120000],[-114.890007,4.268000,-5.128000],[-116.106003,4.224000,-5.184000],[-117.330002,3.704000,-5.240000],[-116.134003,4.094000,-5.148000],[-117.340004,3.574000,-5.186000],[-120.260002,0.506000,-5.996000],[-119.580009,1.826000,-5.882000],[-119.418007,1.782000,-5.656000],[-120.058006,0.482000,-5.754000],[-120.522003,-0.904000,-6.046000],[-120.254005,-0.186000,-5.864000],[-120.396004,-0.804000,-5.922000],[-120.124008,0.170000,-5.778000],[-120.106003,0.200000,-5.764000],[-120.420006,-0.904000,-5.930000],[-118.590004,2.972000,-5.744000],[-118.484009,2.912000,-5.530000],[-118.446007,2.838000,-5.334000],[-119.366005,1.720000,-5.430000],[-118.454002,2.712000,-5.252000],[-119.378006,1.612000,-5.310000],[-119.996002,0.446000,-5.498000],[-120.088005,0.246000,-5.716000],[-120.014008,0.414000,-5.542000],[-119.998009,0.440000,-5.498000],[-120.080009,0.264000,-5.698000],[-120.030006,0.386000,-5.330000],[-119.932007,0.580000,-5.360000],[-120.004005,0.432000,-5.458000],[-120.004005,0.434000,-5.402000],[-118.590004,-4.780000,-5.744000],[-119.580009,-3.634000,-5.882000],[-119.418007,-3.590000,-5.656000],[-118.484009,-4.722000,-5.530000],[-117.400009,-5.660000,-5.618000],[-117.346008,-5.594000,-5.416000],[-120.260002,-2.312000,-5.996000],[-120.058006,-2.290000,-5.754000],[-120.124008,-1.980000,-5.778000],[-120.106003,-2.010000,-5.764000],[-120.254005,-1.624000,-5.866000],[-120.396004,-1.004000,-5.922000],[-119.996002,-2.256000,-5.498000],[-119.366005,-3.530000,-5.430000],[-120.030006,-2.196000,-5.330000],[-119.378006,-3.422000,-5.310000],[-120.004005,-2.244000,-5.402000],[-119.932007,-2.390000,-5.360000],[-120.004005,-2.242000,-5.458000],[-119.998009,-2.250000,-5.498000],[-120.014008,-2.224000,-5.542000],[-120.080009,-2.074000,-5.698000],[-120.088005,-2.056000,-5.716000],[-118.446007,-4.648000,-5.334000],[-117.330002,-5.514000,-5.240000],[-118.454002,-4.522000,-5.252000],[-117.340004,-5.384000,-5.186000],[-113.522003,-6.188000,-5.494000],[-114.804008,-6.364000,-5.506000],[-114.814003,-6.292000,-5.310000],[-113.552002,-6.118001,-5.300000],[-116.116005,-6.188000,-5.544000],[-116.102005,-6.116000,-5.346000],[-116.106003,-6.034000,-5.184000],[-114.838005,-6.208000,-5.158000],[-116.134003,-5.902000,-5.148000],[-114.890007,-6.078000,-5.128000],[-113.596008,-6.038000,-5.148000],[-112.442009,-5.526000,-5.148000],[-113.674004,-5.914001,-5.120000],[-112.548004,-5.414000,-5.120000],[-116.446007,-7.906000,-2.620000],[-116.428009,-7.694000,-3.390000],[-114.592003,-7.894001,-3.404000],[-114.558006,-8.104000,-2.632000],[-118.592003,-7.232000,-2.598000],[-118.504005,-7.036000,-3.364000],[-116.458008,-8.070001,-1.916000],[-114.530006,-8.270000,-1.924000],[-118.656006,-7.384000,-1.900000],[-116.402008,-7.452000,-4.144000],[-114.628006,-7.652000,-4.158000],[-118.388008,-6.808000,-4.118000],[-113.052002,-7.418000,-4.164000],[-112.970009,-7.642000,-3.410000],[-112.898003,-7.838000,-2.636000],[-112.838005,-7.996000,-1.926000],[-125.018005,-2.798000,-2.484000],[-124.668007,-2.730000,-3.224000],[-123.028008,-4.434000,-3.266000],[-123.304008,-4.554000,-2.518000],[-125.730003,-0.932000,-2.468000],[-125.348007,-0.922000,-3.208000],[-125.276009,-2.848000,-1.820000],[-123.510002,-4.644000,-1.844000],[-126.014008,-0.938000,-1.810000],[-124.204002,-2.654000,-3.980000],[-122.666008,-4.296000,-4.022000],[-124.844009,-0.908000,-3.964000],[-120.602005,-5.718000,-4.072000],[-120.840004,-5.908000,-3.316000],[-121.020004,-6.072001,-2.560000],[-121.154007,-6.198000,-1.874000],[-121.020004,4.132000,-2.560000],[-120.840004,4.002000,-3.316000],[-123.028008,2.554000,-3.266000],[-123.304008,2.642000,-2.518000],[-118.592003,5.274000,-2.598000],[-118.504005,5.114000,-3.364000],[-121.154007,4.240000,-1.874000],[-123.510002,2.718000,-1.844000],[-118.656006,5.410000,-1.900000],[-120.602005,3.852000,-4.072000],[-122.666008,2.450000,-4.022000],[-118.388008,4.930000,-4.118000],[-124.204002,0.828000,-3.980000],[-124.668007,0.876000,-3.224000],[-125.018005,0.918000,-2.484000],[-125.276009,0.954000,-1.820000],[-112.898003,5.958000,-2.636000],[-112.970009,5.780000,-3.410000],[-114.592003,6.002000,-3.404000],[-114.558006,6.188000,-2.632000],[-112.838005,6.110000,-1.926000],[-114.530006,6.344000,-1.924000],[-113.052002,5.574000,-4.164000],[-114.628006,5.790000,-4.158000],[-116.402008,5.576000,-4.144000],[-116.428009,5.780000,-3.390000],[-116.446007,5.958000,-2.620000],[-116.458008,6.110000,-1.916000],[-112.730003,3.416000,-5.304000],[-112.976006,3.148000,-5.644000],[-112.468002,2.110000,-6.084000],[-113.280006,2.790000,-6.090000],[-112.896004,1.748000,-6.576000],[-113.628006,2.336000,-6.592000],[-116.184006,3.874000,-5.318000],[-114.978004,4.052000,-5.306000],[-115.090004,3.748000,-5.642000],[-116.226006,3.576000,-5.648000],[-117.368004,3.362000,-5.340000],[-117.354004,3.084000,-5.660000],[-113.810005,3.898000,-5.304000],[-113.990005,3.602000,-5.642000],[-114.204002,3.216000,-6.084000],[-115.202003,3.362000,-6.078000],[-114.442009,2.732000,-6.576000],[-115.310005,2.884000,-6.558000],[-116.228004,3.206000,-6.084000],[-117.240005,2.768000,-6.094000],[-116.206009,2.740000,-6.566000],[-117.094002,2.358000,-6.568000],[-119.422005,1.436000,-5.394000],[-119.474007,1.190000,-5.670000],[-118.478004,2.504000,-5.378000],[-118.422005,2.270000,-5.674000],[-118.192009,2.068000,-6.088000],[-118.970009,1.364000,-6.078000],[-117.938004,1.788000,-6.528000],[-118.674004,1.252000,-6.428000],[-119.460007,0.916000,-6.072001],[-119.836006,0.564000,-5.880000],[-119.578003,0.700000,-6.150000],[-119.826004,0.282000,-6.120000],[-119.242004,0.960000,-6.252000],[-119.326004,0.764000,-6.278000],[-120.194008,-0.278000,-6.018000],[-120.408005,-0.904000,-5.952000],[-118.478004,-4.314000,-5.378000],[-119.422005,-3.244000,-5.394000],[-119.474007,-3.000000,-5.670000],[-118.422005,-4.080000,-5.674000],[-117.368004,-5.170000,-5.340000],[-117.354004,-4.894000,-5.660000],[-119.836006,-2.374000,-5.880000],[-120.194008,-1.532000,-6.018000],[-119.826004,-2.092000,-6.120000],[-119.460007,-2.726000,-6.072001],[-118.970009,-3.174000,-6.078000],[-119.242004,-2.770000,-6.252000],[-118.674004,-3.062000,-6.428000],[-119.578003,-2.510000,-6.150000],[-119.326004,-2.572000,-6.278000],[-118.192009,-3.878000,-6.088000],[-117.240005,-4.578000,-6.094000],[-117.938004,-3.598000,-6.528000],[-117.094002,-4.166000,-6.568000],[-113.810005,-5.706000,-5.304000],[-114.978004,-5.862000,-5.306000],[-115.090004,-5.558000,-5.642000],[-113.990005,-5.412000,-5.642000],[-112.730003,-5.226000,-5.304000],[-112.976006,-4.958000,-5.644000],[-116.184006,-5.684000,-5.318000],[-116.226006,-5.386000,-5.648000],[-116.228004,-5.016000,-6.084000],[-115.202003,-5.172000,-6.078000],[-116.206009,-4.550000,-6.566000],[-115.310005,-4.694000,-6.558000],[-114.204002,-5.024000,-6.084000],[-113.280006,-4.600000,-6.090000],[-114.442009,-4.542000,-6.576000],[-113.628006,-4.146000,-6.592000],[-112.468002,-3.920000,-6.084000],[-112.896004,-3.558000,-6.576000],[-112.624008,-0.062000,-7.066000],[-113.356003,-0.132000,-7.490000],[-113.332008,0.442000,-7.348001],[-112.866005,0.702000,-7.032001],[-112.570007,-0.904000,-7.098001],[-113.384003,-0.904000,-7.554000],[-114.198006,-0.040000,-7.786000],[-113.822006,0.728000,-7.490000],[-115.002007,0.260000,-7.894001],[-114.462006,1.094000,-7.552001],[-114.364006,-0.904000,-7.902000],[-115.770004,-0.904000,-8.112000],[-113.366005,1.306000,-7.066000],[-114.014008,1.778000,-7.098001],[-114.692009,2.148000,-7.066000],[-115.054008,1.500000,-7.480000],[-115.496002,1.788000,-7.324000],[-115.412003,2.310000,-7.022000],[-115.622009,0.818000,-7.752000],[-116.026009,1.494000,-7.440001],[-116.444008,0.246000,-7.778000],[-116.804008,1.078000,-7.420001],[-116.180008,2.152000,-7.030000],[-116.984009,1.788000,-7.012001],[-117.816002,1.322000,-6.894001],[-117.728004,0.694000,-7.200000],[-118.640007,0.398000,-6.856000],[-118.596008,0.910000,-6.684000],[-117.566002,-0.070000,-7.454000],[-118.718002,-0.226000,-6.952000],[-117.466003,-0.904000,-7.566000],[-118.766006,-0.904000,-6.982000],[-119.628006,-0.308000,-6.454000],[-119.382004,0.242000,-6.472000],[-119.774002,-0.904000,-6.422000],[-119.236008,0.700000,-6.396000],[-119.628006,-1.502000,-6.454000],[-118.718002,-1.584000,-6.952000],[-118.640007,-2.206000,-6.856000],[-119.382004,-2.054000,-6.472000],[-117.566002,-1.738000,-7.454000],[-117.728004,-2.504000,-7.200000],[-116.444008,-2.056000,-7.778000],[-116.804008,-2.888000,-7.420001],[-117.816002,-3.132000,-6.894001],[-118.596008,-2.720000,-6.684000],[-116.984009,-3.598000,-7.012001],[-119.236008,-2.510000,-6.396000],[-116.180008,-3.962000,-7.030000],[-116.026009,-3.304000,-7.440001],[-115.496002,-3.598000,-7.324000],[-115.412003,-4.120000,-7.022000],[-115.622009,-2.628000,-7.752000],[-115.054008,-3.308000,-7.480000],[-115.002007,-2.070000,-7.894001],[-114.462006,-2.904000,-7.552001],[-114.692009,-3.958000,-7.066000],[-114.014008,-3.588000,-7.098001],[-113.366005,-3.116000,-7.066000],[-113.822006,-2.538000,-7.490000],[-113.332008,-2.252000,-7.348001],[-112.866005,-2.512000,-7.032001],[-114.198006,-1.770000,-7.786000],[-113.356003,-1.678000,-7.490000],[-112.624008,-1.748000,-7.066000],[-112.722008,6.402000,-0.560000],[-112.752007,6.324000,-0.926000],[-114.488007,6.564000,-0.926000],[-114.472008,6.646000,-0.558000],[-112.790009,6.230000,-1.370000],[-114.506004,6.468000,-1.368000],[-116.466003,6.230000,-1.364000],[-116.470009,6.324000,-0.922000],[-118.704002,5.516000,-1.352000],[-118.738007,5.600000,-0.916000],[-116.474007,6.402000,-0.556000],[-118.764008,5.670000,-0.554000],[-121.380005,4.454000,-0.548000],[-121.326004,4.396000,-0.906000],[-123.770004,2.828000,-0.892000],[-123.854004,2.870000,-0.542000],[-121.254005,4.328000,-1.334000],[-123.660004,2.778000,-1.314000],[-125.468002,0.984000,-1.298000],[-125.608009,1.012000,-0.882000],[-126.222008,-0.938000,-1.292000],[-126.374008,-0.930000,-0.878000],[-125.714005,1.038000,-0.538000],[-126.490005,-0.918000,-0.536000],[-125.714005,-2.882000,-0.538000],[-125.608009,-2.884000,-0.882000],[-123.770004,-4.720000,-0.892000],[-123.854004,-4.722000,-0.542000],[-125.468002,-2.874000,-1.298000],[-123.660004,-4.696000,-1.314000],[-121.254005,-6.272000,-1.334000],[-121.326004,-6.310000,-0.906000],[-118.704002,-7.476000,-1.352000],[-118.738007,-7.524000,-0.916000],[-121.380005,-6.318000,-0.548000],[-118.764008,-7.542000,-0.554000],[-116.474007,-8.266001,-0.556000],[-116.470009,-8.236000,-0.922000],[-114.488007,-8.454000,-0.926000],[-114.472008,-8.498000,-0.558000],[-116.466003,-8.176001,-1.364000],[-114.506004,-8.382000,-1.368000],[-112.790009,-8.108001,-1.370000],[-112.752007,-8.186001,-0.926000],[-112.722008,-8.240001,-0.560000],[-109.852005,8.390000,-1.986000],[-109.852005,-9.688001,3.518000],[-109.852005,-8.998000,5.972000],[-109.852005,7.188000,-6.430000],[-109.852005,8.390000,1.528000],[-109.852005,8.604000,-0.228000],[-109.852005,7.188000,5.972000],[-109.852005,7.878000,3.518000],[-109.852005,-10.200001,1.528000],[-109.852005,-8.998000,-6.430000],[-109.852005,-9.688001,-3.976000],[-109.852005,7.878000,-3.976000],[-109.852005,-10.412001,-0.228000],[-109.852005,-10.200001,-1.986000],[-109.722008,-14.448001,-0.228000],[-109.722008,-14.100000,-2.142000],[-109.722008,-13.196001,-4.040000],[-104.646004,8.390000,-1.986000],[-104.646004,8.604000,-0.228000],[-104.646004,7.188000,5.972000],[-104.646004,-10.200001,1.528000],[-104.646004,-9.688001,-3.976000],[-104.646004,-8.998000,-6.430000],[-104.646004,7.878000,-3.976000],[-104.646004,7.188000,-6.430000],[-104.646004,-10.200001,-1.986000],[-104.646004,8.390000,1.528000],[-104.646004,7.878000,3.518000],[-104.646004,-8.998000,5.972000],[-104.646004,-10.412001,-0.228000],[-104.646004,-9.688001,3.518000],[-104.776009,-13.196001,-4.040000],[-104.776009,-14.100000,-2.142000],[-104.776009,-14.448001,-0.228000],[-105.686005,-5.526000,-10.506001],[-105.686005,-3.140000,-11.092001],[-105.166008,-3.140000,-11.092001],[-108.810005,-5.526000,-10.506001],[-108.810005,-3.140000,-11.092001],[-108.290009,-3.140000,-11.092001],[-105.166008,-5.526000,-10.506001],[-107.768005,-5.526000,-10.506001],[-107.768005,-3.140000,-11.092001],[-107.250008,-3.140000,-11.092001],[-108.290009,-5.526000,-10.506001],[-109.332008,-5.526000,-10.506001],[-109.332008,-3.140000,-11.092001],[-106.728004,-5.526000,-10.506001],[-106.728004,-3.140000,-11.092001],[-106.208008,-3.140000,-11.092001],[-107.250008,-5.526000,-10.506001],[-106.208008,-5.526000,-10.506001],[-104.776009,-5.540000,-9.626000],[-104.776009,-3.112000,-10.138000],[-104.776009,-0.904000,-10.226001],[-105.166008,-0.904000,-11.182000],[-108.810005,-0.904000,-11.182000],[-105.686005,-0.904000,-11.182000],[-106.728004,-0.904000,-11.182000],[-106.208008,-0.904000,-11.182000],[-108.290009,-0.904000,-11.182000],[-107.768005,-0.904000,-11.182000],[-109.332008,-0.904000,-11.182000],[-107.250008,-0.904000,-11.182000],[-107.250008,-14.366001,-4.062000],[-107.768005,-14.366001,-4.062000],[-107.250008,-12.840000,-5.740000],[-106.728004,-14.366001,-4.062000],[-108.290009,-12.840000,-5.740000],[-107.768005,-12.840000,-5.740000],[-108.810005,-12.840000,-5.740000],[-108.810005,-14.366001,-4.062000],[-109.332008,-12.840000,-5.740000],[-108.290009,-14.366001,-4.062000],[-106.208008,-12.840000,-5.740000],[-105.686005,-12.840000,-5.740000],[-105.686005,-14.366001,-4.062000],[-106.728004,-12.840000,-5.740000],[-106.208008,-14.366001,-4.062000],[-109.332008,-14.366001,-4.062000],[-105.166008,-12.840000,-5.740000],[-105.166008,-14.366001,-4.062000],[-104.776009,-11.878000,-5.914001],[-104.876007,-10.478001,-7.294000],[-105.166008,-10.798000,-7.376000],[-108.290009,-10.798000,-7.376000],[-108.810005,-10.798000,-7.376000],[-105.686005,-10.798000,-7.376000],[-107.768005,-10.798000,-7.376000],[-106.728004,-10.798000,-7.376000],[-106.208008,-10.798000,-7.376000],[-109.332008,-10.798000,-7.376000],[-107.250008,-10.798000,-7.376000],[-109.332008,-15.400001,-2.194000],[-108.810005,-15.400001,-2.194000],[-108.810005,-15.794001,-0.228000],[-109.332008,-15.794001,-0.228000],[-107.250008,-15.794001,-0.228000],[-107.768005,-15.794001,-0.228000],[-107.250008,-15.400001,-2.194000],[-108.290009,-15.794001,-0.228000],[-108.290009,-15.400001,-2.194000],[-107.768005,-15.400001,-2.194000],[-106.728004,-15.400001,-2.194000],[-106.728004,-15.794001,-0.228000],[-106.208008,-15.400001,-2.194000],[-106.208008,-15.794001,-0.228000],[-105.686005,-15.794001,-0.228000],[-105.686005,-15.400001,-2.194000],[-105.166008,-15.400001,-2.194000],[-105.166008,-15.794001,-0.228000],[-104.776009,-8.414001,-8.444000],[-109.722008,-5.540000,-9.626000],[-109.722008,-8.414001,-8.444000],[-109.722008,-11.878000,-5.914001],[-109.620003,-10.478001,-7.294000],[-109.722008,-3.112000,-10.138000],[-109.722008,-0.904000,-10.226001],[-106.728004,-8.220000,-9.116000],[-107.250008,-8.220000,-9.116000],[-107.768005,-8.220000,-9.116000],[-106.208008,-8.220000,-9.116000],[-108.290009,-8.220000,-9.116000],[-105.686005,-8.220000,-9.116000],[-105.166008,-8.220000,-9.116000],[-109.332008,-8.220000,-9.116000],[-108.810005,-8.220000,-9.116000],[-109.722008,-13.196001,3.584000],[-109.722008,-14.100000,1.684000],[-104.776009,-14.100000,1.684000],[-104.776009,-13.196001,3.584000],[-108.290009,-5.526000,10.050000],[-107.768005,-5.526000,10.050000],[-108.290009,-3.140000,10.634001],[-107.768005,-3.140000,10.634001],[-107.250008,-3.140000,10.634001],[-107.250008,-5.526000,10.050000],[-109.332008,-5.526000,10.050000],[-108.810005,-5.526000,10.050000],[-109.332008,-3.140000,10.634001],[-108.810005,-3.140000,10.634001],[-106.208008,-3.140000,10.634001],[-106.728004,-5.526000,10.050000],[-106.208008,-5.526000,10.050000],[-105.166008,-3.140000,10.634001],[-105.686005,-5.526000,10.050000],[-105.166008,-5.526000,10.050000],[-105.686005,-3.140000,10.634001],[-106.728004,-3.140000,10.634001],[-106.728004,-0.904000,10.726001],[-108.290009,-0.904000,10.726001],[-108.810005,-0.904000,10.726001],[-107.768005,-0.904000,10.726001],[-107.250008,-0.904000,10.726001],[-106.208008,-0.904000,10.726001],[-105.686005,-0.904000,10.726001],[-109.332008,-0.904000,10.726001],[-105.166008,-0.904000,10.726001],[-104.776009,-0.904000,9.768001],[-104.776009,-3.112000,9.682000],[-104.776009,-5.540000,9.170000],[-107.768005,-14.366001,3.604000],[-107.250008,-14.366001,3.604000],[-107.250008,-12.840000,5.284000],[-107.768005,-12.840000,5.284000],[-108.290009,-12.840000,5.284000],[-108.810005,-12.840000,5.284000],[-109.332008,-12.840000,5.284000],[-108.810005,-14.366001,3.604000],[-106.728004,-12.840000,5.284000],[-106.728004,-14.366001,3.604000],[-106.208008,-14.366001,3.604000],[-105.686005,-14.366001,3.604000],[-106.208008,-12.840000,5.284000],[-109.332008,-14.366001,3.604000],[-108.290009,-14.366001,3.604000],[-105.686005,-12.840000,5.284000],[-105.166008,-14.366001,3.604000],[-105.166008,-12.840000,5.284000],[-107.768005,-10.798000,6.918000],[-107.250008,-10.798000,6.918000],[-106.728004,-10.798000,6.918000],[-108.290009,-10.798000,6.918000],[-108.810005,-10.798000,6.918000],[-105.686005,-10.798000,6.918000],[-106.208008,-10.798000,6.918000],[-109.332008,-10.798000,6.918000],[-105.166008,-10.798000,6.918000],[-104.876007,-10.478001,6.836000],[-104.776009,-11.878000,5.456000],[-109.332008,-15.400001,1.736000],[-108.810005,-15.400001,1.736000],[-108.290009,-15.400001,1.736000],[-106.208008,-15.400001,1.736000],[-106.728004,-15.400001,1.736000],[-107.250008,-15.400001,1.736000],[-107.768005,-15.400001,1.736000],[-105.686005,-15.400001,1.736000],[-105.166008,-15.400001,1.736000],[-104.776009,-8.414001,7.988000],[-109.722008,-5.540000,9.170000],[-109.722008,-8.414001,7.988000],[-109.620003,-10.478001,6.836000],[-109.722008,-11.878000,5.456000],[-109.722008,-0.904000,9.768001],[-109.722008,-3.112000,9.682000],[-106.208008,-8.220000,8.660001],[-106.728004,-8.220000,8.660001],[-107.250008,-8.220000,8.660001],[-108.290009,-8.220000,8.660001],[-107.768005,-8.220000,8.660001],[-105.686005,-8.220000,8.660001],[-108.810005,-8.220000,8.660001],[-109.332008,-8.220000,8.660001],[-105.166008,-8.220000,8.660001],[-109.722008,11.386001,-4.040000],[-109.722008,12.290001,-2.142000],[-109.722008,12.638000,-0.228000],[-104.776009,12.638000,-0.228000],[-104.776009,12.290001,-2.142000],[-104.776009,11.386001,-4.040000],[-108.810005,1.330000,-11.092001],[-108.810005,3.718000,-10.506001],[-108.290009,1.330000,-11.092001],[-109.332008,1.330000,-11.092001],[-107.768005,3.718000,-10.506001],[-107.768005,1.330000,-11.092001],[-108.290009,3.718000,-10.506001],[-109.332008,3.718000,-10.506001],[-105.166008,3.718000,-10.506001],[-105.166008,1.330000,-11.092001],[-105.686005,3.718000,-10.506001],[-105.686005,1.330000,-11.092001],[-106.728004,1.330000,-11.092001],[-106.728004,3.718000,-10.506001],[-106.208008,1.330000,-11.092001],[-107.250008,1.330000,-11.092001],[-107.250008,3.718000,-10.506001],[-106.208008,3.718000,-10.506001],[-104.776009,1.302000,-10.138000],[-104.776009,3.730000,-9.626000],[-106.208008,12.556001,-4.062000],[-106.208008,11.030001,-5.740000],[-106.728004,12.556001,-4.062000],[-107.250008,12.556001,-4.062000],[-107.250008,11.030001,-5.740000],[-107.768005,12.556001,-4.062000],[-106.728004,11.030001,-5.740000],[-108.290009,12.556001,-4.062000],[-108.290009,11.030001,-5.740000],[-108.810005,12.556001,-4.062000],[-107.768005,11.030001,-5.740000],[-105.686005,12.556001,-4.062000],[-105.686005,11.030001,-5.740000],[-109.332008,11.030001,-5.740000],[-109.332008,12.556001,-4.062000],[-108.810005,11.030001,-5.740000],[-105.166008,11.030001,-5.740000],[-105.166008,12.556001,-4.062000],[-106.728004,8.988001,-7.376000],[-107.768005,8.988001,-7.376000],[-108.290009,8.988001,-7.376000],[-107.250008,8.988001,-7.376000],[-106.208008,8.988001,-7.376000],[-105.686005,8.988001,-7.376000],[-109.332008,8.988001,-7.376000],[-108.810005,8.988001,-7.376000],[-105.166008,8.988001,-7.376000],[-104.876007,8.668000,-7.294000],[-104.776009,10.068001,-5.914001],[-106.728004,13.590001,-2.194000],[-106.728004,13.984000,-0.228000],[-106.208008,13.590001,-2.194000],[-107.250008,13.984000,-0.228000],[-107.250008,13.590001,-2.194000],[-107.768005,13.984000,-0.228000],[-107.768005,13.590001,-2.194000],[-108.290009,13.984000,-0.228000],[-108.290009,13.590001,-2.194000],[-108.810005,13.984000,-0.228000],[-108.810005,13.590001,-2.194000],[-109.332008,13.590001,-2.194000],[-109.332008,13.984000,-0.228000],[-106.208008,13.984000,-0.228000],[-105.686005,13.984000,-0.228000],[-105.686005,13.590001,-2.194000],[-105.166008,13.590001,-2.194000],[-105.166008,13.984000,-0.228000],[-104.776009,6.604000,-8.444000],[-109.722008,3.730000,-9.626000],[-109.722008,6.604000,-8.444000],[-109.620003,8.668000,-7.294000],[-109.722008,10.068001,-5.914001],[-109.722008,1.302000,-10.138000],[-106.208008,6.410000,-9.116000],[-105.686005,6.410000,-9.116000],[-107.250008,6.410000,-9.116000],[-106.728004,6.410000,-9.116000],[-108.290009,6.410000,-9.116000],[-107.768005,6.410000,-9.116000],[-109.332008,6.410000,-9.116000],[-105.166008,6.410000,-9.116000],[-108.810005,6.410000,-9.116000],[-109.722008,12.290001,1.684000],[-109.722008,11.386001,3.584000],[-104.776009,11.386001,3.584000],[-104.776009,12.290001,1.684000],[-107.768005,3.718000,10.050000],[-108.290009,1.330000,10.634001],[-107.768005,1.330000,10.634001],[-108.290009,3.718000,10.050000],[-108.810005,3.718000,10.050000],[-109.332008,1.330000,10.634001],[-108.810005,1.330000,10.634001],[-105.686005,1.330000,10.634001],[-105.166008,1.330000,10.634001],[-105.686005,3.718000,10.050000],[-109.332008,3.718000,10.050000],[-106.728004,1.330000,10.634001],[-106.208008,1.330000,10.634001],[-106.728004,3.718000,10.050000],[-105.166008,3.718000,10.050000],[-106.208008,3.718000,10.050000],[-107.250008,1.330000,10.634001],[-107.250008,3.718000,10.050000],[-104.776009,3.730000,9.170000],[-104.776009,1.302000,9.682000],[-105.686005,11.030001,5.284000],[-105.686005,12.556001,3.604000],[-106.208008,11.030001,5.284000],[-106.208008,12.556001,3.604000],[-106.728004,12.556001,3.604000],[-107.250008,12.556001,3.604000],[-107.250008,11.030001,5.284000],[-106.728004,11.030001,5.284000],[-107.768005,12.556001,3.604000],[-108.290009,12.556001,3.604000],[-108.290009,11.030001,5.284000],[-109.332008,12.556001,3.604000],[-109.332008,11.030001,5.284000],[-108.810005,12.556001,3.604000],[-107.768005,11.030001,5.284000],[-108.810005,11.030001,5.284000],[-105.166008,11.030001,5.284000],[-105.166008,12.556001,3.604000],[-104.776009,10.068001,5.456000],[-104.876007,8.668000,6.836000],[-105.166008,8.988001,6.918000],[-107.768005,8.988001,6.918000],[-107.250008,8.988001,6.918000],[-105.686005,8.988001,6.918000],[-106.728004,8.988001,6.918000],[-106.208008,8.988001,6.918000],[-108.810005,8.988001,6.918000],[-108.290009,8.988001,6.918000],[-109.332008,8.988001,6.918000],[-109.332008,13.590001,1.736000],[-106.728004,13.590001,1.736000],[-107.250008,13.590001,1.736000],[-108.810005,13.590001,1.736000],[-108.290009,13.590001,1.736000],[-106.208008,13.590001,1.736000],[-107.768005,13.590001,1.736000],[-105.686005,13.590001,1.736000],[-105.166008,13.590001,1.736000],[-104.776009,6.604000,7.988000],[-109.722008,3.730000,9.170000],[-109.722008,6.604000,7.988000],[-109.722008,10.068001,5.456000],[-109.620003,8.668000,6.836000],[-109.722008,1.302000,9.682000],[-106.208008,6.410000,8.660001],[-105.686005,6.410000,8.660001],[-106.728004,6.410000,8.660001],[-107.768005,6.410000,8.660001],[-107.250008,6.410000,8.660001],[-109.332008,6.410000,8.660001],[-108.810005,6.410000,8.660001],[-108.290009,6.410000,8.660001],[-105.166008,6.410000,8.660001],[-42.642002,10.034000,-8.202001],[-42.642002,11.660001,-2.380000],[-42.642002,10.034000,7.746000],[-42.642002,10.968000,4.458000],[-42.642002,11.660001,1.926000],[-42.642002,-12.772000,4.458000],[-42.642002,-13.466001,1.926000],[-42.642002,-13.466001,-2.380000],[-42.642002,5.422000,8.872001],[-42.642002,10.968000,-4.914000],[-42.642002,5.422000,-9.326000],[-42.642002,-7.228000,8.872001],[-42.642002,-12.772000,-4.914000],[-42.642002,-11.840000,7.746000],[-42.642002,-11.840000,-8.202001],[-42.642002,-7.228000,-9.326000],[-42.428001,-19.206001,-0.228000],[-42.428001,-18.736000,-2.410000],[-42.428001,-17.514000,-4.682000],[-34.042000,10.968000,4.458000],[-34.042000,10.034000,7.746000],[-34.042000,1.970000,9.390000],[-34.042000,11.660001,1.926000],[-34.042000,-3.776000,9.390000],[-34.042000,11.660001,-2.380000],[-34.042000,10.968000,-4.914000],[-34.042000,-0.902000,-9.954000],[-34.042000,1.970000,-9.846001],[-34.042000,10.034000,-8.202001],[-34.042000,5.422000,-9.326000],[-34.042000,11.948001,-0.228000],[-34.042000,5.422000,8.872001],[-34.042000,-0.902000,9.498000],[-34.042000,-7.228000,8.872001],[-34.042000,-13.754001,-0.228000],[-34.042000,-13.466001,-2.380000],[-34.042000,-12.772000,4.458000],[-34.042000,-11.840000,7.746000],[-34.042000,-12.772000,-4.914000],[-34.042000,-13.466001,1.926000],[-34.042000,-11.840000,-8.202001],[-34.042000,-3.776000,-9.846001],[-34.042000,-7.228000,-9.326000],[-34.256001,-17.514000,-4.682000],[-34.256001,-18.736000,-2.410000],[-34.256001,-19.206001,-0.228000],[-40.922001,-3.922000,-15.050001],[-40.922001,-7.148000,-14.130001],[-41.784000,-3.922000,-15.050001],[-39.202003,-7.148000,-14.130001],[-39.202003,-3.922000,-15.050001],[-38.342003,-3.922000,-15.050001],[-41.784000,-7.148000,-14.130001],[-36.622002,-7.148000,-14.130001],[-36.622002,-3.922000,-15.050001],[-35.762001,-7.148000,-14.130001],[-38.342003,-7.148000,-14.130001],[-37.482002,-7.148000,-14.130001],[-40.062000,-7.148000,-14.130001],[-40.062000,-3.922000,-15.050001],[-35.762001,-3.922000,-15.050001],[-34.902000,-3.922000,-15.050001],[-34.902000,-7.148000,-14.130001],[-37.482002,-3.922000,-15.050001],[-34.256001,-7.168000,-12.930000],[-34.256001,-3.886000,-13.750001],[-34.256001,-0.902000,-13.870001],[-34.902000,-0.902000,-15.174001],[-40.062000,-0.902000,-15.174001],[-40.922001,-0.902000,-15.174001],[-39.202003,-0.902000,-15.174001],[-41.784000,-0.902000,-15.174001],[-35.762001,-0.902000,-15.174001],[-36.622002,-0.902000,-15.174001],[-37.482002,-0.902000,-15.174001],[-38.342003,-0.902000,-15.174001],[-36.622002,-19.096001,-4.604000],[-37.482002,-19.096001,-4.604000],[-36.622002,-17.032001,-6.772000],[-35.762001,-17.032001,-6.772000],[-35.762001,-19.096001,-4.604000],[-37.482002,-17.032001,-6.772000],[-40.922001,-19.096001,-4.604000],[-41.784000,-19.096001,-4.604000],[-41.784000,-17.032001,-6.772000],[-40.922001,-17.032001,-6.772000],[-39.202003,-19.096001,-4.604000],[-40.062000,-19.096001,-4.604000],[-40.062000,-17.032001,-6.772000],[-38.342003,-17.032001,-6.772000],[-38.342003,-19.096001,-4.604000],[-39.202003,-17.032001,-6.772000],[-34.902000,-19.096001,-4.604000],[-34.902000,-17.032001,-6.772000],[-34.256001,-15.734001,-7.130000],[-34.424000,-13.842001,-9.110001],[-34.902000,-14.274001,-9.126000],[-40.062000,-14.274001,-9.126000],[-40.922001,-14.274001,-9.126000],[-37.482002,-14.274001,-9.126000],[-36.622002,-14.274001,-9.126000],[-35.762001,-14.274001,-9.126000],[-39.202003,-14.274001,-9.126000],[-38.342003,-14.274001,-9.126000],[-41.784000,-14.274001,-9.126000],[-41.784000,-20.492001,-2.420000],[-40.922001,-20.492001,-2.420000],[-40.922001,-21.024000,-0.228000],[-40.062000,-20.492001,-2.420000],[-39.202003,-20.492001,-2.420000],[-39.202003,-21.024000,-0.228000],[-40.062000,-21.024000,-0.228000],[-41.784000,-21.024000,-0.228000],[-38.342003,-20.492001,-2.420000],[-37.482002,-20.492001,-2.420000],[-37.482002,-21.024000,-0.228000],[-38.342003,-21.024000,-0.228000],[-36.622002,-21.024000,-0.228000],[-36.622002,-20.492001,-2.420000],[-35.762001,-21.024000,-0.228000],[-35.762001,-20.492001,-2.420000],[-34.902000,-21.024000,-0.228000],[-34.902000,-20.492001,-2.420000],[-34.256001,-11.052001,-10.950001],[-42.428001,-7.168000,-12.930000],[-42.428001,-11.052001,-10.950001],[-42.428001,-15.734001,-7.130000],[-42.260002,-13.842001,-9.110001],[-42.428001,-3.886000,-13.750001],[-42.428001,-0.902000,-13.870001],[-40.922001,-10.790001,-11.868001],[-40.062000,-10.790001,-11.868001],[-39.202003,-10.790001,-11.868001],[-38.342003,-10.790001,-11.868001],[-41.784000,-10.790001,-11.868001],[-37.482002,-10.790001,-11.868001],[-36.622002,-10.790001,-11.868001],[-35.762001,-10.790001,-11.868001],[-34.902000,-10.790001,-11.868001],[-42.428001,-17.514000,4.226000],[-42.428001,-18.736000,1.956000],[-34.256001,-18.736000,1.956000],[-34.256001,-17.514000,4.226000],[-36.622002,-7.148000,13.676001],[-35.762001,-7.148000,13.676001],[-36.622002,-3.922000,14.596001],[-37.482002,-7.148000,13.676001],[-38.342003,-3.922000,14.596001],[-39.202003,-7.148000,13.676001],[-38.342003,-7.148000,13.676001],[-37.482002,-3.922000,14.596001],[-34.902000,-3.922000,14.596001],[-34.902000,-7.148000,13.676001],[-35.762001,-3.922000,14.596001],[-41.784000,-7.148000,13.676001],[-40.922001,-7.148000,13.676001],[-41.784000,-3.922000,14.596001],[-40.062000,-3.922000,14.596001],[-40.062000,-7.148000,13.676001],[-40.922001,-3.922000,14.596001],[-39.202003,-3.922000,14.596001],[-37.482002,-0.902000,14.720000],[-36.622002,-0.902000,14.720000],[-35.762001,-0.902000,14.720000],[-40.922001,-0.902000,14.720000],[-41.784000,-0.902000,14.720000],[-39.202003,-0.902000,14.720000],[-38.342003,-0.902000,14.720000],[-40.062000,-0.902000,14.720000],[-34.902000,-0.902000,14.720000],[-34.256001,-0.902000,13.414001],[-34.256001,-3.886000,13.294001],[-34.256001,-7.168000,12.476001],[-35.762001,-17.032001,6.318000],[-36.622002,-17.032001,6.318000],[-35.762001,-19.096001,4.150000],[-36.622002,-19.096001,4.150000],[-41.784000,-19.096001,4.150000],[-40.922001,-19.096001,4.150000],[-41.784000,-17.032001,6.318000],[-40.922001,-17.032001,6.318000],[-40.062000,-17.032001,6.318000],[-40.062000,-19.096001,4.150000],[-37.482002,-19.096001,4.150000],[-37.482002,-17.032001,6.318000],[-38.342003,-17.032001,6.318000],[-38.342003,-19.096001,4.150000],[-39.202003,-17.032001,6.318000],[-39.202003,-19.096001,4.150000],[-34.902000,-19.096001,4.150000],[-34.902000,-17.032001,6.318000],[-36.622002,-14.274001,8.670000],[-37.482002,-14.274001,8.670000],[-35.762001,-14.274001,8.670000],[-39.202003,-14.274001,8.670000],[-40.922001,-14.274001,8.670000],[-40.062000,-14.274001,8.670000],[-41.784000,-14.274001,8.670000],[-38.342003,-14.274001,8.670000],[-34.902000,-14.274001,8.670000],[-34.424000,-13.842001,8.654000],[-34.256001,-15.734001,6.674000],[-41.784000,-20.492001,1.966000],[-40.062000,-20.492001,1.966000],[-40.922001,-20.492001,1.966000],[-39.202003,-20.492001,1.966000],[-36.622002,-20.492001,1.966000],[-37.482002,-20.492001,1.966000],[-38.342003,-20.492001,1.966000],[-35.762001,-20.492001,1.966000],[-34.902000,-20.492001,1.966000],[-34.256001,-11.052001,10.496000],[-42.428001,-7.168000,12.476001],[-42.428001,-11.052001,10.496000],[-42.260002,-13.842001,8.654000],[-42.428001,-15.734001,6.674000],[-42.428001,-0.902000,13.414001],[-42.428001,-3.886000,13.294001],[-38.342003,-10.790001,11.412001],[-39.202003,-10.790001,11.412001],[-40.062000,-10.790001,11.412001],[-41.784000,-10.790001,11.412001],[-36.622002,-10.790001,11.412001],[-40.922001,-10.790001,11.412001],[-34.902000,-10.790001,11.412001],[-35.762001,-10.790001,11.412001],[-37.482002,-10.790001,11.412001],[-42.428001,15.708001,-4.682000],[-42.428001,16.930000,-2.410000],[-42.428001,17.400002,-0.228000],[-34.256001,17.400002,-0.228000],[-34.256001,16.930000,-2.410000],[-34.256001,15.708001,-4.682000],[-40.922001,2.116000,-15.050001],[-40.922001,5.344000,-14.130001],[-40.062000,2.116000,-15.050001],[-40.062000,5.344000,-14.130001],[-41.784000,2.116000,-15.050001],[-41.784000,5.344000,-14.130001],[-34.902000,5.344000,-14.130001],[-34.902000,2.116000,-15.050001],[-35.762001,5.344000,-14.130001],[-38.342003,5.344000,-14.130001],[-38.342003,2.116000,-15.050001],[-39.202003,5.344000,-14.130001],[-37.482002,5.344000,-14.130001],[-37.482002,2.116000,-15.050001],[-36.622002,5.344000,-14.130001],[-36.622002,2.116000,-15.050001],[-39.202003,2.116000,-15.050001],[-35.762001,2.116000,-15.050001],[-34.256001,2.080000,-13.750001],[-34.256001,5.362000,-12.930000],[-37.482002,15.226001,-6.772000],[-37.482002,17.290001,-4.604000],[-36.622002,15.226001,-6.772000],[-38.342003,17.290001,-4.604000],[-38.342003,15.226001,-6.772000],[-39.202003,17.290001,-4.604000],[-35.762001,17.290001,-4.604000],[-36.622002,17.290001,-4.604000],[-40.062000,17.290001,-4.604000],[-40.062000,15.226001,-6.772000],[-40.922001,17.290001,-4.604000],[-39.202003,15.226001,-6.772000],[-40.922001,15.226001,-6.772000],[-41.784000,15.226001,-6.772000],[-41.784000,17.290001,-4.604000],[-34.902000,17.290001,-4.604000],[-34.902000,15.226001,-6.772000],[-35.762001,15.226001,-6.772000],[-40.922001,12.468000,-9.126000],[-39.202003,12.468000,-9.126000],[-40.062000,12.468000,-9.126000],[-41.784000,12.468000,-9.126000],[-37.482002,12.468000,-9.126000],[-38.342003,12.468000,-9.126000],[-36.622002,12.468000,-9.126000],[-35.762001,12.468000,-9.126000],[-34.902000,12.468000,-9.126000],[-34.424000,12.036000,-9.110001],[-34.256001,13.928000,-7.130000],[-38.342003,19.218000,-0.228000],[-38.342003,18.686001,-2.420000],[-39.202003,19.218000,-0.228000],[-35.762001,19.218000,-0.228000],[-36.622002,18.686001,-2.420000],[-36.622002,19.218000,-0.228000],[-40.922001,18.686001,-2.420000],[-40.922001,19.218000,-0.228000],[-40.062000,18.686001,-2.420000],[-40.062000,19.218000,-0.228000],[-39.202003,18.686001,-2.420000],[-35.762001,18.686001,-2.420000],[-41.784000,18.686001,-2.420000],[-41.784000,19.218000,-0.228000],[-37.482002,19.218000,-0.228000],[-37.482002,18.686001,-2.420000],[-34.902000,18.686001,-2.420000],[-34.902000,19.218000,-0.228000],[-34.256001,9.246000,-10.950001],[-42.428001,5.362000,-12.930000],[-42.428001,9.246000,-10.950001],[-42.260002,12.036000,-9.110001],[-42.428001,13.928000,-7.130000],[-42.428001,2.080000,-13.750001],[-37.482002,8.984000,-11.868001],[-36.622002,8.984000,-11.868001],[-41.784000,8.984000,-11.868001],[-39.202003,8.984000,-11.868001],[-38.342003,8.984000,-11.868001],[-40.062000,8.984000,-11.868001],[-40.922001,8.984000,-11.868001],[-35.762001,8.984000,-11.868001],[-34.902000,8.984000,-11.868001],[-42.428001,16.930000,1.956000],[-42.428001,15.708001,4.226000],[-34.256001,15.708001,4.226000],[-34.256001,16.930000,1.956000],[-37.482002,2.116000,14.596001],[-36.622002,2.116000,14.596001],[-37.482002,5.344000,13.676001],[-40.062000,5.344000,13.676001],[-40.922001,5.344000,13.676001],[-40.062000,2.116000,14.596001],[-39.202003,5.344000,13.676001],[-39.202003,2.116000,14.596001],[-38.342003,5.344000,13.676001],[-38.342003,2.116000,14.596001],[-40.922001,2.116000,14.596001],[-36.622002,5.344000,13.676001],[-35.762001,5.344000,13.676001],[-35.762001,2.116000,14.596001],[-41.784000,2.116000,14.596001],[-41.784000,5.344000,13.676001],[-34.902000,5.344000,13.676001],[-34.902000,2.116000,14.596001],[-34.256001,5.362000,12.476001],[-34.256001,2.080000,13.294001],[-41.784000,17.290001,4.150000],[-41.784000,15.226001,6.318000],[-40.922001,17.290001,4.150000],[-37.482002,15.226001,6.318000],[-37.482002,17.290001,4.150000],[-38.342003,15.226001,6.318000],[-40.922001,15.226001,6.318000],[-40.062000,15.226001,6.318000],[-40.062000,17.290001,4.150000],[-36.622002,15.226001,6.318000],[-36.622002,17.290001,4.150000],[-39.202003,17.290001,4.150000],[-39.202003,15.226001,6.318000],[-38.342003,17.290001,4.150000],[-35.762001,15.226001,6.318000],[-35.762001,17.290001,4.150000],[-34.902000,15.226001,6.318000],[-34.902000,17.290001,4.150000],[-34.256001,13.928000,6.674000],[-34.424000,12.036000,8.654000],[-34.902000,12.468000,8.670000],[-41.784000,12.468000,8.670000],[-40.922001,12.468000,8.670000],[-40.062000,12.468000,8.670000],[-36.622002,12.468000,8.670000],[-35.762001,12.468000,8.670000],[-37.482002,12.468000,8.670000],[-39.202003,12.468000,8.670000],[-38.342003,12.468000,8.670000],[-37.482002,18.686001,1.966000],[-38.342003,18.686001,1.966000],[-35.762001,18.686001,1.966000],[-36.622002,18.686001,1.966000],[-39.202003,18.686001,1.966000],[-40.062000,18.686001,1.966000],[-40.922001,18.686001,1.966000],[-41.784000,18.686001,1.966000],[-34.902000,18.686001,1.966000],[-34.256001,9.246000,10.496000],[-42.428001,5.362000,12.476001],[-42.428001,9.246000,10.496000],[-42.428001,13.928000,6.674000],[-42.260002,12.036000,8.654000],[-42.428001,2.080000,13.294001],[-37.482002,8.984000,11.412001],[-36.622002,8.984000,11.412001],[-39.202003,8.984000,11.412001],[-38.342003,8.984000,11.412001],[-35.762001,8.984000,11.412001],[-40.062000,8.984000,11.412001],[-41.784000,8.984000,11.412001],[-40.922001,8.984000,11.412001],[-34.902000,8.984000,11.412001]];module DaggerHandle_fixed() {
    multmatrix(DaggerHandle_fixed_multmatrix()) polyhedron(triangles = DaggerHandle_fixed_triangles(), points = DaggerHandle_fixed_points(), convexity=10);
};


function DaggerDesign3_dimX() = 165.83;
function DaggerDesign3_dimY() = 22.18;
function DaggerDesign3_dimZ() = 2.36;
function DaggerDesign3_multmatrix() = [[27.866383,-0.000000,0.552722,39.342690],[0.000000,26.968990,0.000000,-0.813489],[-0.590597,0.000000,26.079309,2.696854],[0.000000,0.000000,0.000000,1.000000]];

function DaggerDesign3_triangles() = [
[2,1,0],[0,3,2],[4,0,1],[1,5,4],[1,2,6],[6,7,1],[8,2,3],[5,1,7],[7,9,5],[7,6,10],[10,11,7],[3,12,8],[9,7,11],[11,13,9],[15,14,11],[11,10,15],[8,12,16],[16,17,8],[3,18,12],[14,19,13],[13,11,14],[14,15,20],[20,21,14],[22,15,10],[10,23,22],[17,16,24],[24,25,17],[3,26,18],[13,19,27],[27,28,13],[19,14,21],[21,27,19],[29,25,24],[26,3,30],[30,31,26],[32,29,24],[24,33,32],[30,34,31],[32,33,35],[35,36,32],[36,35,37],[37,38,36],[39,38,37],[37,40,39],[41,39,40],[41,40,42],[42,43,41],[43,42,44],[44,45,43],[48,47,46],[46,49,48],[49,46,50],[50,51,49],[47,53,52],[52,46,47],[54,47,48],[48,55,54],[51,50,56],[56,57,51],[46,52,58],[58,50,46],[52,53,59],[59,60,52],[61,53,47],[47,54,61],[62,54,55],[55,63,62],[57,56,64],[64,65,57],[50,58,64],[64,56,50],[58,52,60],[60,66,58],[60,59,67],[67,68,60],[59,53,69],[69,70,59],[71,61,54],[54,62,71],[72,62,63],[63,73,72],[65,74,57],[66,60,68],[68,75,66],[58,66,75],[75,76,58],[67,59,70],[70,77,67],[70,69,78],[78,79,70],[80,71,62],[62,72,80],[81,72,73],[73,82,81],[74,65,83],[83,84,74],[76,85,58],[77,70,79],[79,86,77],[79,78,87],[87,88,79],[89,80,72],[72,81,89],[84,83,90],[90,91,84],[92,85,76],[86,79,88],[88,93,86],[88,87,94],[94,95,88],[91,90,96],[96,97,91],[92,76,98],[93,88,95],[95,99,93],[101,100,97],[97,96,101],[92,98,102],[102,103,92],[103,102,104],[104,105,103],[105,104,106],[106,107,105],[108,107,106],[106,109,108],[112,111,110],[110,113,112],[111,115,114],[114,110,111],[117,116,111],[111,112,117],[115,119,118],[118,114,115],[116,119,115],[115,111,116],[121,120,116],[116,117,121],[119,123,122],[122,118,119],[120,123,119],[119,116,120],[125,124,120],[120,121,125],[123,127,126],[126,122,123],[124,127,123],[123,120,124],[128,124,125],[125,129,128],[130,126,127],[127,131,130],[131,127,124],[124,128,131],[132,128,129],[129,133,132],[134,130,131],[131,135,134],[135,131,128],[128,132,135],[137,136,132],[132,133,137],[136,134,135],[135,132,136],[137,133,138],[137,138,139],[139,140,137],[141,138,133],[133,142,141],[140,139,143],[143,144,140],[145,141,142],[142,146,145],[149,148,147],[147,150,149],[143,152,151],[153,149,150],[150,154,153],[157,156,155],[155,158,157],[153,154,159],[159,160,153],[161,158,155],[155,162,161],[165,164,163],[163,166,165],[169,168,167],[167,170,169],[168,172,171],[171,167,168],[174,173,168],[168,169,174],[173,175,172],[172,168,173],[177,176,173],[173,174,177],[176,178,175],[175,173,176],[180,179,176],[176,177,180],[179,181,178],[178,176,179],[183,182,179],[179,180,183],[182,184,181],[181,179,182],[187,186,185],[185,188,187],[188,185,189],[189,190,188],[192,191,186],[186,187,192],[190,189,193],[193,194,190],[196,195,191],[191,192,196],[194,193,197],[197,198,194],[200,199,195],[195,196,200],[198,197,201],[201,202,198],[201,204,203],[203,202,201],[207,206,205],[205,208,207],[208,205,209],[209,210,208],[211,207,208],[208,212,211],[210,209,213],[213,214,210],[212,216,215],[215,211,212],[214,213,217],[217,218,214],[220,219,216],[216,212,220],[218,217,221],[221,222,218],[224,223,219],[219,220,224],[222,221,225],[225,226,222],[224,228,227],[227,223,224],[225,230,229],[229,226,225],[227,228,231],[231,232,227],[230,234,233],[233,229,230],[234,236,235],[235,233,234],[236,238,237],[237,235,236],[237,238,239],[239,240,237],[240,239,241],[241,242,240],[242,241,243],[243,244,242],[244,243,245],[245,246,244],[247,246,245],[245,248,247],[247,248,249],[249,248,250],[250,251,249],[254,253,252],[252,255,254],[258,257,256],[256,259,258],[262,261,260],[260,263,262],[260,261,264],[264,265,260],[265,264,266],[266,267,265],[267,266,268],[268,269,267],[268,271,270],[270,269,268],[274,273,272],[276,275,272],[272,273,276],[272,275,277],[277,278,272],[275,276,279],[280,278,277],[277,281,280],[275,279,282],[282,283,275],[284,280,281],[281,285,284],[283,282,286],[286,287,283],[280,284,288],[288,289,280],[290,284,285],[285,291,290],[287,286,292],[292,293,287],[294,289,288],[288,295,294],[288,284,290],[296,280,289],[297,290,291],[291,298,297],[293,292,299],[299,300,293],[302,301,294],[294,295,302],[304,303,296],[296,289,304],[305,297,298],[298,306,305],[300,299,307],[307,308,300],[306,310,309],[309,305,306],[308,307,311],[311,312,308],[313,310,306],[306,314,313],[312,311,315],[315,316,312],[319,318,317],[321,320,313],[313,314,321],[316,315,322],[322,323,316],[317,318,324],[326,325,320],[320,321,326],[323,322,327],[327,328,323],[318,329,324],[331,330,325],[325,326,331],[328,327,332],[332,333,328],[329,335,334],[334,324,329],[337,336,330],[330,331,337],[333,332,338],[338,339,333],[334,335,340],[342,341,336],[336,337,342],[339,338,343],[343,344,339],[346,345,341],[341,342,346],[344,343,347],[349,348,345],[345,346,349],[347,343,350],[352,351,348],[348,349,352],[347,350,353],[354,351,352],[352,355,354],[353,350,356],[357,354,355],[356,358,353],[361,360,359],[359,362,361],[363,354,357],[353,358,364],[360,365,359],[366,363,357],[358,367,364],[359,365,368],[368,369,359],[370,363,366],[366,371,370],[367,370,371],[371,364,367],[368,365,372],[372,374,373],[373,368,372],[374,376,375],[375,373,374],[375,376,377],[377,378,375],[377,380,379],[379,378,377],[380,382,381],[381,379,380],[381,382,383],[383,384,381],[384,383,385],[385,386,384],[386,385,387],[387,388,386],[388,387,389],[389,390,388],[389,392,391],[391,390,389],[392,394,393],[393,391,392],[394,396,395],[395,393,394],[396,398,397],[397,395,396],[398,400,399],[399,397,398],[399,400,401],[401,402,399],[402,401,403],[403,404,402],[404,403,405],[405,406,404],[405,408,407],[407,406,405],[408,409,407],[411,410,407],[407,409,411],[410,411,412],[412,413,410],[409,415,414],[414,411,409],[416,410,413],[413,418,417],[417,416,413],[420,419,417],[417,418,420],[423,422,421],[421,424,423],[420,425,419],[421,427,426],[426,424,421],[425,429,428],[428,419,425],[427,431,430],[430,426,427],[432,428,429],[429,433,432],[431,435,434],[434,430,431],[435,437,436],[436,434,435],[437,439,438],[438,436,437],[439,441,440],[440,438,439],[152,443,442],[442,444,152],[444,442,445],[445,446,444],[448,447,443],[443,152,448],[152,444,449],[449,151,152],[446,445,450],[450,451,446],[444,446,452],[452,449,444],[148,144,143],[143,147,148],[451,450,453],[453,454,451],[446,451,455],[455,456,446],[452,446,456],[454,453,457],[457,458,454],[451,454,459],[459,455,451],[458,457,460],[460,461,458],[454,458,462],[462,459,454],[465,464,463],[463,466,465],[469,468,467],[467,470,469],[473,472,471],[471,474,473],[477,476,475],[475,478,477],[481,480,479],[479,482,481],[485,484,483],[483,486,485],[489,488,487],[487,490,489],[493,492,491],[491,494,493],[497,496,495],[495,498,497],[501,500,499],[499,502,501],[505,504,503],[503,506,505],[509,508,507],[507,510,509],[513,512,511],[511,514,513],[517,516,515],[515,518,517],[521,520,519],[519,522,521],[525,524,523],[523,526,525],[529,528,527],[527,530,529],[533,532,531],[531,534,533],[537,536,535],[535,538,537],[541,540,539],[539,542,541],[545,544,543],[543,546,545],[549,548,547],[547,550,549],[553,552,551],[551,554,553],[557,556,555],[555,558,557],[29,22,23],[23,25,29],[13,28,423],[415,559,28],[28,414,415],[28,559,422],[422,423,28],[204,560,34],[34,203,204],[34,560,561],[561,31,34],[31,561,206],[206,207,31],[249,251,562],[251,563,562],[251,250,563],[564,161,162],[162,565,564],[562,564,565],[565,566,562],[562,563,564],[563,250,567],[567,564,563],[564,567,568],[568,161,564],[158,569,253],[253,254,158],[161,568,569],[569,158,161],[457,571,570],[570,460,457],[453,572,571],[571,457,453],[450,573,572],[572,453,450],[576,575,574],[574,447,576],[445,577,573],[573,450,445],[447,574,578],[578,443,447],[442,579,577],[577,445,442],[443,578,579],[579,442,443],[145,576,447],[447,448,145],[145,146,580],[580,576,145],[576,580,156],[156,157,576],[255,252,581],[581,582,255],[582,581,583],[583,584,582],[584,583,585],[585,586,584],[586,585,258],[258,259,586],[257,588,587],[587,256,257],[588,262,263],[263,587,588],[255,582,589],[589,590,255],[589,582,584],[584,591,589],[591,584,586],[586,592,591],[592,586,259],[259,593,592],[593,259,256],[256,594,593],[594,256,587],[587,595,594],[596,100,101],[101,597,596],[461,460,570],[570,598,461],[458,461,597],[597,462,458],[461,598,596],[596,597,461],[598,108,109],[109,596,598],[166,163,599],[599,600,166],[601,170,167],[601,167,171],[171,602,601],[335,603,601],[601,340,335],[174,605,604],[604,177,174],[180,607,606],[606,183,180],[177,604,607],[607,180,177],[608,605,174],[174,169,608],[609,608,169],[169,170,609],[603,609,170],[170,601,603],[160,159,610],[610,611,160],[610,159,612],[599,614,361],[361,362,599],[183,606,615],[615,154,183],[616,614,599],[599,163,616],[613,616,163],[163,164,613],[611,610,164],[164,165,611],[154,615,612],[612,159,154],[617,273,274],[274,618,617],[271,620,619],[619,270,271],[618,303,304],[304,619,618],[620,617,618],[618,619,620],[309,621,302],[302,305,309],[622,319,317],[317,301,622],[621,622,301],[301,302,621],[610,613,164],[624,625,623],[626,623,625],[623,627,624],[628,624,627],[625,624,629],[630,629,624],[625,631,626],[624,628,630],[632,630,628],[629,630,633],[634,633,630],[635,626,631],[630,632,634],[636,634,632],[637,638,634],[633,634,638],[635,631,639],[640,639,631],[641,626,635],[642,637,636],[634,636,637],[638,637,643],[644,643,637],[638,645,633],[646,633,645],[639,640,647],[648,647,640],[649,626,641],[642,636,650],[651,650,636],[637,642,644],[650,644,642],[648,652,647],[626,649,653],[654,653,649],[652,655,647],[656,647,655],[657,653,654],[656,655,658],[659,658,655],[658,659,660],[661,660,659],[661,662,660],[663,660,662],[662,664,663],[663,664,665],[666,665,664],[665,666,667],[668,667,666],[670,671,669],[672,669,671],[669,672,673],[674,673,672],[676,670,675],[669,675,670],[670,677,671],[678,671,677],[673,674,679],[680,679,674],[675,669,681],[673,681,669],[676,675,682],[683,682,675],[676,684,670],[677,670,684],[677,685,678],[686,678,685],[679,680,687],[688,687,680],[681,673,687],[679,687,673],[675,681,683],[689,683,681],[682,683,690],[691,690,683],[676,682,692],[693,692,682],[684,694,677],[685,677,694],[685,695,686],[696,686,695],[697,688,680],[683,689,691],[698,691,689],[689,681,698],[699,698,681],[682,690,693],[700,693,690],[692,693,701],[702,701,693],[694,703,685],[695,685,703],[695,704,696],[705,696,704],[688,697,706],[707,706,697],[708,699,681],[693,700,702],[709,702,700],[701,702,710],[711,710,702],[703,712,695],[704,695,712],[706,707,713],[714,713,707],[708,715,699],[702,709,711],[716,711,709],[710,711,717],[718,717,711],[713,714,719],[720,719,714],[699,715,721],[711,716,718],[722,718,716],[723,724,720],[719,720,724],[721,715,725],[726,725,715],[725,726,727],[728,727,726],[727,728,729],[730,729,728],[730,731,729],[732,729,731],[734,735,733],[736,733,735],[738,734,737],[733,737,734],[739,740,734],[735,734,740],[742,738,741],[737,741,738],[742,739,738],[734,738,739],[743,744,739],[740,739,744],[746,742,745],[741,745,742],[746,743,742],[739,742,743],[747,748,743],[744,743,748],[750,746,749],[745,749,746],[750,747,746],[743,746,747],[747,751,748],[752,748,751],[749,753,750],[754,750,753],[750,754,747],[751,747,754],[751,755,752],[756,752,755],[753,757,754],[758,754,757],[754,758,751],[755,751,758],[759,760,755],[756,755,760],[757,759,758],[755,758,759],[756,760,761],[761,760,762],[763,762,760],[761,764,756],[765,756,764],[762,763,766],[767,766,763],[764,768,765],[769,765,768],[771,772,770],[773,770,772],[775,766,774],[774,770,147],[151,774,147],[772,776,773],[777,773,776],[779,780,778],[781,778,780],[777,776,782],[783,782,776],[781,784,778],[785,778,784],[787,788,786],[789,786,788],[791,792,790],[793,790,792],[795,791,794],[790,794,791],[796,797,791],[792,791,797],[798,796,795],[791,795,796],[799,800,796],[797,796,800],[801,799,798],[796,798,799],[802,803,799],[800,799,803],[804,802,801],[799,801,802],[805,806,802],[803,802,806],[807,805,804],[802,804,805],[809,810,808],[811,808,810],[808,811,812],[813,812,811],[814,815,809],[810,809,815],[812,813,816],[817,816,813],[818,819,814],[815,814,819],[816,817,820],[821,820,817],[822,823,818],[819,818,823],[820,821,824],[825,824,821],[827,824,826],[825,826,824],[829,830,828],[831,828,830],[828,831,832],[833,832,831],[830,834,831],[835,831,834],[832,833,836],[837,836,833],[839,835,838],[834,838,835],[836,837,840],[841,840,837],[842,843,839],[835,839,843],[840,841,844],[845,844,841],[846,847,842],[843,842,847],[844,845,848],[849,848,845],[851,847,850],[846,850,847],[853,848,852],[849,852,848],[851,850,854],[855,854,850],[857,853,856],[852,856,853],[859,857,858],[856,858,857],[861,859,860],[858,860,859],[861,860,862],[863,862,860],[862,863,864],[865,864,863],[864,865,866],[867,866,865],[866,867,868],[869,868,867],[869,870,868],[871,868,870],[871,870,872],[871,872,873],[874,873,872],[876,877,875],[878,875,877],[880,881,879],[882,879,881],[884,885,883],[886,883,885],[884,883,887],[888,887,883],[887,888,889],[890,889,888],[889,890,891],[892,891,890],[894,891,893],[892,893,891],[896,897,895],[898,899,895],[896,895,899],[898,895,900],[901,900,895],[899,898,902],[901,903,900],[904,900,903],[902,898,905],[906,905,898],[903,907,904],[908,904,907],[905,906,909],[910,909,906],[907,903,911],[912,911,903],[907,913,908],[914,908,913],[909,910,915],[916,915,910],[912,917,911],[918,911,917],[907,911,913],[903,919,912],[913,920,914],[921,914,920],[915,916,922],[923,922,916],[924,925,917],[918,917,925],[926,927,919],[912,919,927],[920,928,921],[929,921,928],[922,923,930],[931,930,923],[933,929,932],[928,932,929],[930,931,934],[935,934,931],[933,936,929],[937,929,936],[934,935,938],[939,938,935],[941,942,940],[943,944,936],[937,936,944],[938,939,945],[946,945,939],[941,940,947],[948,949,943],[944,943,949],[945,946,950],[951,950,946],[952,941,947],[953,954,948],[949,948,954],[950,951,955],[956,955,951],[958,952,957],[947,957,952],[959,960,953],[954,953,960],[955,956,961],[962,961,956],[958,957,963],[964,965,959],[960,959,965],[961,962,966],[967,966,962],[968,969,964],[965,964,969],[966,967,970],[971,972,968],[969,968,972],[966,970,973],[974,975,971],[972,971,975],[973,970,976],[974,977,975],[978,975,977],[973,976,979],[977,980,978],[981,979,976],[983,984,982],[985,982,984],[977,986,980],[981,976,987],[988,983,982],[986,989,980],[990,981,987],[988,982,991],[992,991,982],[986,993,989],[994,989,993],[993,990,994],[987,994,990],[988,991,995],[997,995,996],[991,996,995],[999,997,998],[996,998,997],[999,998,1000],[1001,1000,998],[1003,1000,1002],[1001,1002,1000],[1005,1003,1004],[1002,1004,1003],[1005,1004,1006],[1007,1006,1004],[1006,1007,1008],[1009,1008,1007],[1008,1009,1010],[1011,1010,1009],[1010,1011,1012],[1013,1012,1011],[1015,1012,1014],[1013,1014,1012],[1017,1015,1016],[1014,1016,1015],[1019,1017,1018],[1016,1018,1017],[1021,1019,1020],[1018,1020,1019],[1023,1021,1022],[1020,1022,1021],[1023,1022,1024],[1025,1024,1022],[1024,1025,1026],[1027,1026,1025],[1026,1027,1028],[1029,1028,1027],[1031,1028,1030],[1029,1030,1028],[1032,1031,1030],[1033,1034,1030],[1032,1030,1034],[1034,1033,1035],[1036,1035,1033],[1038,1032,1037],[1034,1037,1032],[1033,1039,1036],[1041,1036,1040],[1039,1040,1036],[1042,1043,1040],[1041,1040,1043],[1045,1046,1044],[1047,1044,1046],[1048,1043,1042],[1050,1044,1049],[1047,1049,1044],[1052,1048,1051],[1042,1051,1048],[1054,1050,1053],[1049,1053,1050],[1051,1055,1052],[1056,1052,1055],[1058,1054,1057],[1053,1057,1054],[1060,1058,1059],[1057,1059,1058],[1062,1060,1061],[1059,1061,1060],[1064,1062,1063],[1061,1063,1062],[1066,775,1065],[1067,1065,775],[1065,1067,1068],[1069,1068,1067],[1070,1071,1066],[775,1066,1071],[1067,775,1072],[774,1072,775],[1068,1069,1073],[1074,1073,1069],[1069,1067,1075],[1072,1075,1067],[767,771,766],[770,766,771],[1073,1074,1076],[1077,1076,1074],[1074,1069,1078],[1079,1078,1069],[1069,1075,1079],[1076,1077,1080],[1081,1080,1077],[1077,1074,1082],[1078,1082,1074],[1080,1081,1083],[1084,1083,1081],[1081,1077,1085],[1082,1085,1077],[1087,1088,1086],[1089,1086,1088],[1091,1092,1090],[1093,1090,1092],[1095,1096,1094],[1097,1094,1096],[1099,1100,1098],[1101,1098,1100],[1103,1104,1102],[1105,1102,1104],[1107,1108,1106],[1109,1106,1108],[1111,1112,1110],[1113,1110,1112],[1115,1116,1114],[1117,1114,1116],[1119,1120,1118],[1121,1118,1120],[1123,1124,1122],[1125,1122,1124],[1127,1128,1126],[1129,1126,1128],[1131,1132,1130],[1133,1130,1132],[1135,1136,1134],[1137,1134,1136],[1139,1140,1138],[1141,1138,1140],[1143,1144,1142],[1145,1142,1144],[1147,1148,1146],[1149,1146,1148],[1151,1152,1150],[1153,1150,1152],[1155,1156,1154],[1157,1154,1156],[1159,1160,1158],[1161,1158,1160],[1163,1164,1162],[1165,1162,1164],[1167,1168,1166],[1169,1166,1168],[1171,1172,1170],[1173,1170,1172],[1175,1176,1174],[1177,1174,1176],[1179,1180,1178],[1181,1178,1180],[645,652,646],[648,646,652],[651,636,1046],[1182,1038,651],[1037,651,1038],[1182,651,1045],[1046,1045,651],[1183,827,657],[826,657,827],[1183,657,1184],[654,1184,657],[1184,654,829],[830,829,654],[874,872,1185],[1186,874,1185],[873,874,1186],[784,1187,785],[1188,785,1187],[1187,1185,1188],[1189,1188,1185],[1186,1185,1187],[873,1186,1190],[1187,1190,1186],[1190,1187,1191],[784,1191,1187],[1192,781,876],[877,876,781],[1191,784,1192],[781,1192,784],[1194,1080,1193],[1083,1193,1080],[1195,1076,1194],[1080,1194,1076],[1196,1073,1195],[1076,1195,1073],[1198,1199,1197],[1070,1197,1199],[1200,1068,1196],[1073,1196,1068],[1197,1070,1201],[1066,1201,1070],[1202,1065,1200],[1068,1200,1065],[1201,1066,1202],[1065,1202,1066],[1199,768,1070],[1071,1070,768],[769,768,1203],[1199,1203,768],[1203,1199,779],[780,779,1199],[875,878,1204],[1205,1204,878],[1204,1205,1206],[1207,1206,1205],[1206,1207,1208],[1209,1208,1207],[1208,1209,881],[882,881,1209],[1211,880,1210],[879,1210,880],[885,1211,886],[1210,886,1211],[1205,878,1212],[1213,1212,878],[1205,1212,1207],[1214,1207,1212],[1207,1214,1209],[1215,1209,1214],[1209,1215,882],[1216,882,1215],[882,1216,879],[1217,879,1216],[879,1217,1210],[1218,1210,1217],[723,1219,724],[1220,724,1219],[1083,1084,1193],[1221,1193,1084],[1084,1081,1220],[1085,1220,1081],[1221,1084,1219],[1220,1219,1084],[731,1221,732],[1219,732,1221],[786,789,1222],[1223,1222,789],[793,1224,790],[790,1224,794],[1225,794,1224],[1226,958,1224],[963,1224,958],[1228,797,1227],[800,1227,797],[1230,803,1229],[806,1229,803],[1227,800,1230],[803,1230,800],[1228,1231,797],[792,797,1231],[1231,1232,792],[793,792,1232],[1232,1226,793],[1224,793,1226],[782,783,1233],[1234,1233,783],[782,1233,1235],[1237,1222,984],[985,984,1222],[1229,806,1238],[777,1238,806],[1237,1239,1222],[786,1222,1239],[1239,1236,786],[787,786,1236],[1233,1234,787],[788,787,1234],[1238,777,1235],[782,1235,777],[896,1240,897],[1241,897,1240],[1243,894,1242],[893,1242,894],[926,1241,927],[1242,927,1241],[1240,1243,1241],[1242,1241,1243],[1244,932,925],[928,925,932],[942,1245,940],[924,940,1245],[1245,1244,924],[925,924,1244],[1236,1233,787],[721,725,102],[98,721,102],[1015,1017,394],[392,1015,394],[930,934,311],[307,930,311],[980,989,366],[357,980,366],[668,666,43],[45,668,43],[1110,1113,490],[487,1110,490],[834,830,207],[211,834,207],[918,925,302],[295,918,302],[697,680,57],[74,697,57],[706,713,90],[83,706,90],[1148,1147,524],[525,1148,524],[883,886,263],[260,883,263],[908,914,291],[285,908,291],[1003,1005,382],[380,1003,382],[765,769,146],[142,765,146],[676,692,69],[53,676,69],[966,973,350],[343,966,350],[640,631,8],[17,640,8],[732,1219,596],[109,732,596],[1046,636,13],[423,1046,13],[1044,1050,427],[421,1044,427],[1099,1098,475],[476,1099,475],[1096,1095,472],[473,1096,472],[691,698,75],[68,691,75],[998,996,373],[375,998,373],[1061,1059,436],[438,1061,436],[1195,1194,571],[572,1195,571],[932,1244,621],[309,932,621],[1213,878,255],[590,1213,255],[1203,779,156],[580,1203,156],[1217,1216,593],[594,1217,593],[1075,1072,449],[452,1075,449],[992,982,359],[369,992,359],[1005,1006,383],[382,1005,383],[818,814,191],[195,818,191],[1116,1115,492],[493,1116,492],[756,765,142],[133,756,142],[900,904,281],[277,900,281],[151,147,143],[917,912,289],[294,917,289],[953,948,325],[330,953,325],[805,807,184],[182,805,184],[1241,926,303],[618,1241,303],[1125,1124,501],[502,1125,501],[911,918,295],[288,911,295],[959,953,330],[336,959,330],[912,927,304],[289,912,304],[1233,1236,613],[610,1233,613],[896,899,276],[273,896,276],[842,839,216],[219,842,216],[955,961,338],[332,955,338],[795,794,171],[172,795,171],[906,898,275],[283,906,275],[1177,1176,553],[554,1177,553],[989,994,371],[366,989,371],[749,745,122],[126,749,122],[1179,1178,555],[556,1179,555],[1043,1048,425],[420,1043,425],[660,663,40],[37,660,40],[666,664,41],[43,666,41],[735,740,117],[112,735,117],[956,951,328],[333,956,328],[854,855,232],[231,854,232],[1092,1091,468],[469,1092,468],[757,753,130],[134,757,130],[924,917,294],[301,924,294],[710,717,94],[87,710,94],[1047,1046,423],[424,1047,423],[810,815,192],[187,810,192],[661,659,36],[38,661,36],[1193,1221,598],[570,1193,598],[916,910,287],[293,916,287],[833,831,208],[210,833,208],[1007,1004,381],[384,1007,381],[667,668,45],[44,667,45],[680,674,51],[57,680,51],[1089,1088,465],[466,1089,465],[866,868,245],[243,866,245],[760,759,136],[137,760,136],[1232,1231,608],[609,1232,608],[1180,1179,556],[557,1180,556],[819,823,200],[196,819,200],[690,691,68],[67,690,68],[855,850,227],[232,855,227],[794,1225,602],[171,794,602],[952,958,335],[329,952,335],[1206,1208,585],[583,1206,585],[1087,1086,463],[464,1087,463],[821,817,194],[198,821,194],[1107,1106,483],[484,1107,483],[925,928,305],[302,925,305],[1059,1057,434],[436,1059,434],[942,941,318],[319,942,318],[658,660,37],[35,658,37],[984,983,360],[361,984,360],[983,988,365],[360,983,365],[707,697,74],[84,707,74],[822,818,195],[199,822,195],[816,820,197],[193,816,197],[1130,1133,510],[507,1130,510],[1145,1144,521],[522,1145,521],[996,991,368],[373,996,368],[628,627,4],[5,628,4],[895,897,274],[272,895,274],[825,821,198],[202,825,198],[1142,1145,522],[519,1142,522],[1017,1019,396],[394,1017,396],[814,809,186],[191,814,186],[1244,1245,622],[621,1244,622],[631,625,2],[8,631,2],[839,838,215],[216,839,215],[1101,1100,477],[478,1101,477],[1124,1123,500],[501,1124,500],[811,810,187],[188,811,187],[807,804,181],[184,807,181],[801,798,175],[178,801,175],[1184,829,206],[561,1184,206],[1176,1175,552],[553,1176,552],[1095,1094,471],[472,1095,471],[809,808,185],[186,809,185],[1057,1053,430],[434,1057,430],[964,959,336],[341,964,336],[723,720,97],[100,723,97],[1219,723,100],[596,1219,100],[713,719,96],[90,713,96],[1170,1173,550],[547,1170,550],[773,777,154],[150,773,154],[1134,1137,514],[511,1134,514],[915,922,299],[292,915,299],[1235,1233,610],[612,1235,610],[1035,1036,413],[412,1035,413],[960,965,342],[337,960,342],[1161,1160,537],[538,1161,537],[987,976,353],[364,987,353],[1122,1125,502],[499,1122,502],[1181,1180,557],[558,1181,557],[684,676,53],[61,684,53],[1164,1163,540],[541,1164,540],[1004,1002,379],[381,1004,379],[849,845,222],[226,849,222],[1194,1193,570],[571,1194,570],[1129,1128,505],[506,1129,505],[836,840,217],[213,836,217],[846,842,219],[223,846,219],[1137,1136,513],[514,1137,513],[1220,1085,462],[597,1220,462],[909,915,292],[286,909,292],[771,767,144],[148,771,144],[1040,1039,416],[417,1040,416],[961,966,343],[338,961,343],[1140,1139,516],[517,1140,516],[945,950,327],[322,945,327],[654,649,26],[31,654,26],[627,623,0],[4,627,0],[748,752,129],[125,748,129],[1239,1237,614],[616,1239,614],[1001,998,375],[378,1001,375],[1053,1049,426],[430,1053,426],[761,762,139],[138,761,139],[1120,1119,496],[497,1120,496],[859,861,238],[236,859,238],[1238,1235,612],[615,1238,612],[1036,1041,418],[413,1036,418],[1118,1121,498],[495,1118,498],[780,1199,576],[157,780,576],[1168,1167,544],[545,1168,544],[625,629,6],[2,625,6],[893,892,269],[270,893,269],[638,643,20],[15,638,20],[1190,1191,568],[567,1190,568],[636,632,9],[13,636,9],[993,986,363],[370,993,363],[856,852,229],[233,856,229],[672,671,48],[49,672,48],[933,932,309],[310,933,309],[954,960,337],[331,954,337],[1002,1001,378],[379,1002,378],[971,968,345],[348,971,345],[1227,1230,607],[604,1227,607],[1188,1189,566],[565,1188,566],[946,939,316],[323,946,316],[1115,1114,491],[492,1115,491],[1121,1120,497],[498,1121,497],[641,635,12],[18,641,12],[716,709,86],[93,716,86],[1090,1093,470],[467,1090,470],[662,661,38],[39,662,38],[995,997,374],[372,995,374],[902,905,282],[279,902,282],[817,813,190],[194,817,190],[724,1220,597],[101,724,597],[926,919,296],[303,926,296],[1055,1051,428],[432,1055,428],[1224,963,340],[601,1224,340],[1038,1182,559],[415,1038,559],[806,805,182],[183,806,182],[731,730,107],[108,731,107],[1128,1127,504],[505,1128,504],[686,696,73],[63,686,73],[977,974,351],[354,977,351],[844,848,225],[221,844,225],[1049,1047,424],[426,1049,424],[714,707,84],[91,714,84],[905,909,286],[282,905,286],[788,1234,611],[165,788,611],[950,955,332],[327,950,332],[1157,1156,533],[534,1157,533],[1174,1177,554],[551,1174,554],[1234,783,160],[611,1234,160],[920,913,290],[297,920,290],[1109,1108,485],[486,1109,485],[777,806,183],[154,777,183],[759,757,134],[136,759,134],[741,737,114],[118,741,114],[937,944,321],[314,937,321],[698,699,76],[75,698,76],[876,875,252],[253,876,252],[699,721,98],[76,699,98],[941,952,329],[318,941,329],[1085,1082,459],[462,1085,459],[775,1071,448],[152,775,448],[1026,1028,405],[403,1026,405],[830,654,31],[207,830,31],[877,781,158],[254,877,158],[720,714,91],[97,720,91],[860,858,235],[237,860,235],[991,992,369],[368,991,369],[928,920,297],[305,928,297],[725,727,104],[102,725,104],[835,843,220],[212,835,220],[1226,1232,609],[603,1226,609],[1020,1018,395],[397,1020,395],[1153,1152,529],[530,1153,529],[1185,872,249],[562,1185,249],[1051,1042,419],[428,1051,419],[656,658,35],[33,656,35],[663,665,42],[40,663,42],[1054,1058,435],[431,1054,435],[867,865,242],[244,867,242],[944,949,326],[321,944,326],[1119,1118,495],[496,1119,495],[1242,893,270],[619,1242,270],[733,736,113],[110,733,113],[1078,1079,456],[455,1078,456],[1166,1169,546],[543,1166,546],[931,923,300],[308,931,300],[927,1242,619],[304,927,619],[718,722,99],[95,718,99],[1097,1096,473],[474,1097,473],[936,933,310],[313,936,310],[1098,1101,478],[475,1098,478],[712,703,80],[89,712,80],[776,772,149],[153,776,149],[729,732,109],[106,729,109],[1178,1181,558],[555,1178,558],[1010,1012,389],[387,1010,389],[664,662,39],[41,664,39],[648,640,17],[25,648,17],[1133,1132,509],[510,1133,509],[899,902,279],[276,899,279],[1212,1213,590],[589,1212,590],[969,972,349],[346,969,349],[1165,1164,541],[542,1165,541],[687,688,65],[64,687,65],[853,857,234],[230,853,234],[832,836,213],[209,832,213],[951,946,323],[328,951,323],[962,956,333],[339,962,333],[1052,1056,433],[429,1052,433],[978,980,357],[355,978,357],[1100,1099,476],[477,1100,476],[1071,768,145],[448,1071,145],[889,891,268],[266,889,268],[1215,1214,591],[592,1215,591],[972,975,352],[349,972,352],[701,710,87],[78,701,87],[766,775,152],[143,766,152],[865,863,240],[242,865,240],[1197,1201,578],[574,1197,578],[812,816,193],[189,812,193],[705,704,81],[82,705,81],[1056,1055,432],[433,1056,432],[632,628,5],[9,632,5],[831,835,212],[208,831,212],[826,825,202],[203,826,202],[965,969,346],[342,965,346],[939,935,312],[316,939,312],[1006,1008,385],[383,1006,385],[653,657,34],[30,653,34],[655,652,29],[32,655,29],[789,788,165],[166,789,165],[647,656,33],[24,647,33],[985,1222,599],[362,985,599],[740,744,121],[117,740,121],[1240,896,273],[617,1240,273],[1032,1038,415],[409,1032,415],[1216,1215,592],[593,1216,592],[1050,1054,431],[427,1050,431],[772,771,148],[149,772,148],[1154,1157,534],[531,1154,534],[824,827,204],[201,824,204],[1198,1197,574],[575,1198,574],[898,900,277],[275,898,277],[1210,1218,595],[587,1210,595],[888,883,260],[265,888,260],[935,931,308],[312,935,308],[1229,1238,615],[606,1229,615],[1146,1149,526],[523,1146,526],[847,851,228],[224,847,228],[1204,1206,583],[581,1204,583],[1058,1060,437],[435,1058,437],[968,964,341],[345,968,341],[967,962,339],[344,967,339],[779,778,155],[156,779,155],[1172,1171,548],[549,1172,548],[852,849,226],[229,852,226],[671,678,55],[48,671,55],[639,647,24],[16,639,24],[1123,1122,499],[500,1123,499],[988,995,372],[365,988,372],[763,760,137],[140,763,137],[910,906,283],[287,910,283],[1127,1126,503],[504,1127,503],[1230,1229,606],[607,1230,606],[1063,1061,438],[440,1063,438],[813,811,188],[190,813,188],[1042,1040,417],[419,1042,417],[982,985,362],[359,982,362],[719,724,101],[96,719,101],[678,686,63],[55,678,63],[1183,1184,561],[560,1183,561],[645,638,15],[22,645,15],[922,930,307],[299,922,307],[1030,1029,406],[407,1030,406],[665,667,44],[42,665,44],[923,916,293],[300,923,293],[709,700,77],[86,709,77],[1034,1035,412],[411,1034,412],[857,859,236],[234,857,236],[1214,1212,589],[591,1214,589],[1236,1239,616],[613,1236,616],[1191,1192,569],[568,1191,569],[1200,1196,573],[577,1200,573],[1192,876,253],[569,1192,253],[975,978,355],[352,975,355],[1037,1034,411],[414,1037,411],[688,706,83],[65,688,83],[1072,774,151],[449,1072,151],[864,866,243],[241,864,243],[1189,1185,562],[566,1189,562],[778,785,162],[155,778,162],[1011,1009,386],[388,1011,386],[657,826,203],[34,657,203],[1138,1141,518],[515,1138,518],[886,1210,587],[263,886,587],[644,650,27],[21,644,27],[1088,1087,464],[465,1088,464],[1223,789,166],[600,1223,166],[1175,1174,551],[552,1175,551],[1000,1003,380],[377,1000,380],[1225,1224,601],[602,1225,601],[1108,1107,484],[485,1108,484],[848,853,230],[225,848,230],[891,894,271],[268,891,271],[958,1226,603],[335,958,603],[1079,1075,452],[456,1079,452],[1132,1131,508],[509,1132,508],[744,748,125],[121,744,125],[717,718,95],[94,717,95],[1173,1172,549],[550,1173,549],[901,895,272],[278,901,272],[881,880,257],[258,881,257],[752,756,133],[129,752,133],[1039,1033,410],[416,1039,410],[715,708,85],[92,715,85],[1201,1202,579],[578,1201,579],[770,773,150],[147,770,150],[1158,1161,538],[535,1158,538],[820,824,201],[197,820,201],[726,715,92],[103,726,92],[1159,1158,535],[536,1159,535],[827,1183,560],[204,827,560],[997,999,376],[374,997,376],[1031,1032,409],[408,1031,409],[1104,1103,480],[481,1104,480],[736,735,112],[113,736,112],[1237,984,361],[614,1237,361],[1016,1014,391],[393,1016,391],[1082,1078,455],[459,1082,455],[878,877,254],[255,878,254],[999,1000,377],[376,999,377],[1114,1117,494],[491,1114,494],[1126,1129,506],[503,1126,506],[629,633,10],[6,629,10],[981,990,367],[358,981,367],[745,741,118],[122,745,118],[764,761,138],[141,764,138],[894,1243,620],[271,894,620],[892,890,267],[269,892,267],[914,921,298],[291,914,298],[970,967,344],[347,970,344],[948,943,320],[325,948,320],[1029,1027,404],[406,1029,404],[823,822,199],[200,823,199],[1018,1016,393],[395,1018,393],[650,651,28],[27,650,28],[708,681,58],[85,708,58],[785,1188,565],[162,785,565],[704,712,89],[81,704,89],[1228,1227,604],[605,1228,604],[1243,1240,617],[620,1243,617],[940,924,301],[317,940,301],[1009,1007,384],[386,1009,384],[858,856,233],[235,858,233],[897,1241,618],[274,897,618],[722,716,93],[99,722,93],[1041,1043,420],[418,1041,420],[863,860,237],[240,863,237],[762,766,143],[139,762,143],[1182,1045,422],[559,1182,422],[1218,1217,594],[595,1218,594],[957,947,324],[334,957,324],[769,1203,580],[146,769,580],[1019,1021,398],[396,1019,398],[1091,1090,467],[468,1091,467],[1141,1140,517],[518,1141,517],[904,908,285],[281,904,285],[1152,1151,528],[529,1152,528],[1062,1064,441],[439,1062,441],[990,993,370],[367,990,370],[703,694,71],[80,703,71],[768,764,141],[145,768,141],[875,1204,581],[252,875,581],[829,828,205],[206,829,205],[753,749,126],[130,753,126],[737,733,110],[114,737,110],[1060,1062,439],[437,1060,439],[841,837,214],[218,841,214],[1131,1130,507],[508,1131,507],[913,911,288],[290,913,288],[1143,1142,519],[520,1143,519],[1144,1143,520],[521,1144,520],[1136,1135,512],[513,1136,512],[921,929,306],[298,921,306],[1106,1109,486],[483,1106,486],[973,979,356],[350,973,356],[1231,1228,605],[608,1231,605],[1111,1110,487],[488,1111,487],[1202,1200,577],[579,1202,577],[1014,1013,390],[391,1014,390],[1025,1022,399],[402,1025,399],[1028,1031,408],[405,1028,408],[798,795,172],[175,798,172],[869,867,244],[246,869,244],[1160,1159,536],[537,1160,536],[947,940,317],[324,947,317],[1162,1165,542],[539,1162,542],[1155,1154,531],[532,1155,531],[929,937,314],[306,929,314],[649,641,18],[26,649,18],[1149,1148,525],[526,1149,525],[1139,1138,515],[516,1139,515],[837,833,210],[214,837,210],[767,763,140],[144,767,140],[843,847,224],[220,843,224],[840,844,221],[217,840,221],[949,954,331],[326,949,331],[633,646,23],[10,633,23],[1022,1020,397],[399,1022,397],[884,887,264],[261,884,264],[986,977,354],[363,986,354],[730,728,105],[107,730,105],[828,832,209],[205,828,209],[696,705,82],[73,696,82],[1171,1170,547],[548,1171,547],[1211,885,262],[588,1211,262],[1112,1111,488],[489,1112,488],[938,945,322],[315,938,322],[728,726,103],[105,728,103],[1094,1097,474],[471,1094,474],[652,645,22],[29,652,22],[781,780,157],[158,781,157],[976,970,347],[353,976,347],[1113,1112,489],[490,1113,489],[974,971,348],[351,974,348],[903,901,278],[280,903,278],[651,1037,414],[28,651,414],[1135,1134,511],[512,1135,511],[1147,1146,523],[524,1147,523],[1245,942,319],[622,1245,319],[1169,1168,545],[546,1169,545],[681,687,64],[58,681,64],[1064,1063,440],[441,1064,440],[890,888,265],[267,890,265],[646,648,25],[23,646,25],[1008,1010,387],[385,1008,387],[1023,1024,401],[400,1023,401],[1221,731,108],[598,1221,108],[1033,1030,407],[410,1033,407],[1012,1015,392],[389,1012,392],[887,889,266],[264,887,266],[872,870,247],[249,872,247],[1045,1044,421],[422,1045,421],[1167,1166,543],[544,1167,543],[871,873,250],[248,871,250],[1163,1162,539],[540,1163,539],[694,684,61],[71,694,61],[692,701,78],[69,692,78],[635,639,16],[12,635,16],[1196,1195,572],[573,1196,572],[979,981,358],[356,979,358],[1048,1052,429],[425,1048,429],[934,938,315],[311,934,315],[1102,1105,482],[479,1102,482],[1105,1104,481],[482,1105,481],[727,729,106],[104,727,106],[838,834,211],[215,838,211],[1150,1153,530],[527,1150,530],[873,1190,567],[250,873,567],[1021,1023,400],[398,1021,400],[880,1211,588],[257,880,588],[1208,881,258],[585,1208,258],[994,987,364],[371,994,364],[850,846,223],[227,850,223],[845,841,218],[222,845,218],[870,869,246],[247,870,246],[1222,1223,600],[599,1222,600],[1117,1116,493],[494,1117,493],[1156,1155,532],[533,1156,532],[700,690,67],[77,700,67],[1024,1026,403],[401,1024,403],[1013,1011,388],[390,1013,388],[1151,1150,527],[528,1151,527],[815,819,196],[192,815,196],[1093,1092,469],[470,1093,469],[943,936,313],[320,943,313],[862,864,241],[239,862,241],[885,884,261],[262,885,261],[626,653,30],[3,626,30],[783,776,153],[160,783,153],[1103,1102,479],[480,1103,479],[808,812,189],[185,808,189],[1027,1025,402],[404,1027,402],[674,672,49],[51,674,49],[851,854,231],[228,851,231],[623,626,3],[0,623,3],[861,862,239],[238,861,239],[868,871,248],[245,868,248],[963,957,334],[340,963,334],[919,903,280],[296,919,280],[1199,1198,575],[576,1199,575],[643,644,21],[20,643,21],[659,655,32],[36,659,32],[1086,1089,466],[463,1086,466],[804,801,178],[181,804,178],[770,774,766]];
function DaggerDesign3_points() = [
[-2.165866,-0.092521,-0.022556],[-2.171976,0.034030,-0.022573],[-2.089305,0.019587,-0.022349],[-2.087535,-0.106606,-0.022345],[-2.244193,-0.078436,-0.022768],[-2.254647,0.048473,-0.022796],[-2.055380,0.053975,-0.022258],[-2.095869,0.101971,-0.022367],[-2.004154,-0.039927,-0.022119],[-2.131086,0.132636,-0.022462],[-2.012015,0.085068,-0.022141],[-2.062710,0.120967,-0.022278],[-1.943059,-0.056625,-0.021954],[-2.113405,0.156867,-0.022414],[-1.988674,0.123831,-0.022078],[-1.947094,0.112819,-0.021965],[-1.907578,-0.013562,-0.021859],[-1.944119,-0.013843,-0.021957],[-1.894271,-0.084656,-0.021823],[-2.030253,0.134843,-0.022190],[-1.903791,0.138965,-0.021848],[-1.969006,0.170869,-0.022025],[-1.898322,0.076159,-0.021834],[-1.945481,0.068467,-0.021961],[-1.828835,0.007619,-0.021646],[-1.893077,0.024571,-0.021820],[-1.982980,-0.127993,-0.022062],[-2.034220,0.218811,-0.022201],[-2.143514,0.284299,-0.022496],[-1.828413,0.052157,-0.021645],[-2.123276,-0.164918,-0.022441],[-2.062722,-0.203021,-0.022278],[-1.796802,0.052363,-0.021560],[-1.797180,0.012391,-0.021561],[-2.140903,-0.196936,-0.022489],[-1.749612,0.000267,-0.021432],[-1.749079,0.056803,-0.021431],[-1.702156,-0.023093,-0.021304],[-1.701241,0.072478,-0.021302],[-1.653223,0.072056,-0.021172],[-1.654115,-0.021903,-0.021174],[-1.606117,0.065264,-0.021045],[-1.606910,-0.017934,-0.021047],[-1.559190,0.040141,-0.020918],[-1.559530,0.004365,-0.020919],[-1.518515,0.018513,-0.020808],[1.792634,-0.003917,-0.011868],[1.764053,-0.005149,-0.011945],[1.755662,0.003101,-0.011968],[1.790125,0.004057,-0.011875],[1.861491,0.001170,-0.011682],[1.853299,0.009698,-0.011704],[1.795148,-0.011891,-0.011861],[1.772439,-0.013400,-0.011923],[1.737622,0.009361,-0.012017],[1.736570,0.020777,-0.012020],[1.913170,0.036554,-0.011543],[1.888639,0.044980,-0.011609],[1.869691,-0.007358,-0.011660],[1.763984,-0.023823,-0.011946],[1.792245,-0.019959,-0.011869],[1.738671,-0.002056,-0.012014],[1.716310,0.012831,-0.012074],[1.726474,0.026804,-0.012047],[1.937702,0.028128,-0.011477],[1.888452,0.100222,-0.011609],[1.860648,-0.015982,-0.011685],[1.755529,-0.034245,-0.011968],[1.789347,-0.028026,-0.011877],[1.727900,-0.017165,-0.012043],[1.727278,-0.031618,-0.012045],[1.706145,-0.001142,-0.012102],[1.688331,0.033949,-0.012150],[1.704345,0.060113,-0.012107],[1.857284,0.062698,-0.011694],[1.851609,-0.024606,-0.011709],[1.904169,-0.047177,-0.011567],[1.726657,-0.046070,-0.012046],[1.684383,-0.025643,-0.012160],[1.695733,-0.041109,-0.012130],[1.671847,0.003300,-0.012194],[1.633883,0.037643,-0.012297],[1.677453,0.058772,-0.012179],[1.854923,0.093888,-0.011700],[1.835320,0.068376,-0.011753],[1.940194,-0.031421,-0.011470],[1.707080,-0.056575,-0.012099],[1.655889,-0.038349,-0.012237],[1.672282,-0.066363,-0.012193],[1.637548,0.007742,-0.012287],[1.753316,0.086853,-0.011974],[1.750666,0.073209,-0.011982],[1.881812,-0.121347,-0.011627],[1.688666,-0.094376,-0.012149],[1.625938,-0.051704,-0.012318],[1.623925,-0.072533,-0.012324],[1.612326,0.069140,-0.012355],[1.633273,0.054068,-0.012298],[1.843684,-0.079130,-0.011730],[1.656409,-0.094188,-0.012236],[1.595396,0.021064,-0.012401],[1.559286,0.022977,-0.012498],[1.829210,-0.088189,-0.011769],[1.852532,-0.115557,-0.011706],[1.760410,-0.095819,-0.011955],[1.772866,-0.119019,-0.011922],[1.671088,-0.102232,-0.012196],[1.668868,-0.127047,-0.012202],[1.610900,-0.106079,-0.012359],[1.630256,-0.086781,-0.012307],[0.609310,0.033409,-0.015063],[0.642201,0.017254,-0.014974],[0.643749,0.008314,-0.014970],[0.595724,0.028917,-0.015100],[0.622891,0.037902,-0.015026],[0.640656,0.026195,-0.014979],[0.677205,0.009741,-0.014880],[0.680524,-0.009440,-0.014871],[0.682888,0.066939,-0.014864],[0.673887,0.028922,-0.014889],[0.713022,0.015399,-0.014783],[0.715814,-0.000734,-0.014776],[0.718148,0.061543,-0.014769],[0.710230,0.031531,-0.014791],[0.750151,0.023464,-0.014683],[0.751646,0.014825,-0.014679],[0.753888,0.042522,-0.014673],[0.748656,0.032103,-0.014687],[0.803306,0.012031,-0.014539],[0.809797,0.007305,-0.014522],[0.781262,0.031583,-0.014599],[0.800880,0.018956,-0.014546],[0.903509,-0.006883,-0.014269],[0.955131,-0.019878,-0.014129],[0.834633,0.019034,-0.014455],[0.851892,0.006113,-0.014408],[0.964937,0.004437,-0.014103],[0.997328,0.010670,-0.014016],[0.991661,-0.006398,-0.014031],[1.032752,0.000707,-0.013920],[1.036856,0.018867,-0.013909],[1.019030,-0.037579,-0.013957],[0.984548,-0.038430,-0.014050],[1.105248,0.009494,-0.013724],[1.063947,0.039165,-0.013836],[1.059770,-0.089871,-0.013847],[0.999392,-0.078782,-0.014010],[1.115023,0.041790,-0.013698],[1.065575,0.050029,-0.013831],[1.066567,0.056642,-0.013829],[1.120973,0.061448,-0.013682],[1.132395,0.032804,-0.013651],[1.129890,-0.052046,-0.013658],[1.041956,0.087422,-0.013895],[1.105528,0.119662,-0.013723],[0.956554,-0.108906,-0.014126],[0.987828,-0.096974,-0.014041],[1.024862,-0.134883,-0.013941],[0.971048,-0.147454,-0.014086],[1.028686,0.143038,-0.013931],[1.005090,0.120429,-0.013995],[0.834713,-0.150011,-0.014455],[0.839027,-0.133416,-0.014443],[0.836288,0.170761,-0.014450],[0.930428,0.156683,-0.014196],[0.941366,0.131348,-0.014167],[0.873725,0.134597,-0.014349],[1.394711,0.055210,-0.012943],[1.346571,0.055452,-0.013073],[1.343642,0.069269,-0.013080],[1.391774,0.069539,-0.012951],[1.387246,0.027122,-0.012963],[1.350362,0.031060,-0.013062],[1.298428,0.055693,-0.013203],[1.297240,0.067091,-0.013206],[1.316479,0.023713,-0.013154],[1.255784,0.059853,-0.013318],[1.251454,0.078991,-0.013329],[1.275582,0.027055,-0.013264],[1.213144,0.064012,-0.013433],[1.212039,0.090194,-0.013436],[1.238686,0.020033,-0.013364],[1.159604,0.069235,-0.013577],[1.169460,0.103247,-0.013551],[1.184696,0.033985,-0.013510],[-2.347482,-0.338863,-0.023046],[-2.393059,-0.285219,-0.023169],[-2.392090,-0.198944,-0.023167],[-2.371971,-0.216390,-0.023113],[-2.334949,-0.318245,-0.023013],[-2.355640,-0.230554,-0.023068],[-2.434463,-0.258784,-0.023281],[-2.429020,-0.180444,-0.023267],[-2.330235,-0.322406,-0.023000],[-2.347379,-0.237718,-0.023046],[-2.470280,-0.236323,-0.023378],[-2.451565,-0.169150,-0.023327],[-2.309389,-0.337222,-0.022944],[-2.319187,-0.262163,-0.022970],[-2.610435,-0.201940,-0.023756],[-2.622891,-0.083321,-0.023790],[-2.250196,-0.404286,-0.022784],[-2.264597,-0.334026,-0.022823],[-2.204661,-0.241412,-0.022661],[-2.189711,-0.302658,-0.022620],[-1.870783,-0.288701,-0.021759],[-1.953078,-0.235106,-0.021982],[-1.957652,-0.209807,-0.021994],[-1.854477,-0.223315,-0.021715],[-1.704539,-0.284953,-0.021310],[-1.712293,-0.242055,-0.021331],[-1.918062,-0.182336,-0.021887],[-1.847913,-0.207526,-0.021698],[-1.676103,-0.282273,-0.021234],[-1.681003,-0.255178,-0.021247],[-1.899786,-0.154093,-0.021838],[-1.863195,-0.130844,-0.021739],[-1.581220,-0.297994,-0.020978],[-1.585793,-0.272695,-0.020990],[-1.822905,-0.120209,-0.021630],[-1.823042,-0.196732,-0.021630],[-1.456306,-0.319834,-0.020640],[-1.460882,-0.294536,-0.020653],[-1.793435,-0.107442,-0.021550],[-1.774346,-0.186215,-0.021499],[-1.375370,-0.339513,-0.020422],[-1.379947,-0.314214,-0.020434],[-1.751371,-0.110669,-0.021437],[-1.736843,-0.179335,-0.021398],[-1.303027,-0.280229,-0.020226],[-1.298454,-0.305527,-0.020214],[-1.704898,-0.152636,-0.021311],[-1.710188,-0.110040,-0.021326],[-1.058496,-0.233381,-0.019566],[-1.053920,-0.258680,-0.019554],[-0.840491,-0.191762,-0.018978],[-0.835918,-0.217060,-0.018965],[-0.765681,-0.153150,-0.018776],[-0.761108,-0.178448,-0.018763],[-0.447896,-0.218913,-0.017918],[-0.452469,-0.193614,-0.017930],[-0.095446,-0.273152,-0.016966],[-0.100023,-0.247854,-0.016978],[0.314473,-0.222362,-0.015859],[0.304782,-0.192093,-0.015885],[0.549282,-0.211305,-0.015225],[0.534472,-0.176064,-0.015265],[0.562619,-0.126662,-0.015189],[0.558626,-0.208726,-0.015200],[0.567051,-0.165466,-0.015177],[0.632056,-0.195111,-0.015002],[0.599554,-0.180288,-0.015089],[1.154004,-0.238164,-0.013592],[1.064518,-0.223911,-0.013834],[1.055503,-0.177459,-0.013858],[1.146301,-0.192562,-0.013613],[1.400185,-0.222989,-0.012928],[1.404671,-0.265707,-0.012916],[1.366994,-0.272088,-0.013017],[1.362418,-0.228511,-0.013030],[1.579534,-0.169590,-0.012444],[1.559847,-0.239423,-0.012497],[1.505257,-0.248669,-0.012644],[1.501013,-0.208247,-0.012656],[1.680493,-0.218988,-0.012171],[1.654138,-0.178383,-0.012242],[1.812650,-0.180706,-0.011814],[1.797600,-0.164883,-0.011855],[1.904684,-0.176235,-0.011566],[1.869951,-0.148432,-0.011659],[1.911214,-0.137279,-0.011548],[1.926405,-0.154501,-0.011507],[2.042600,-0.089098,-0.011193],[2.030727,-0.127968,-0.011225],[2.026154,-0.084390,-0.011238],[2.076853,-0.091352,-0.011101],[2.047177,-0.132676,-0.011181],[2.075037,-0.046930,-0.011106],[2.053985,-0.045055,-0.011163],[2.081426,-0.134929,-0.011088],[2.057169,-0.016366,-0.011154],[2.074286,-0.017982,-0.011108],[2.133906,-0.128834,-0.010947],[2.130084,-0.092940,-0.010957],[2.060354,0.012322,-0.011145],[2.073539,0.010967,-0.011110],[2.252004,-0.121670,-0.010628],[2.261924,-0.102609,-0.010601],[2.004377,0.035325,-0.011296],[1.991356,0.003955,-0.011332],[2.057276,0.041358,-0.011154],[2.073268,0.039568,-0.011110],[2.388086,-0.133899,-0.010260],[2.430120,-0.110558,-0.010147],[1.933422,0.041615,-0.011488],[1.965974,0.054035,-0.011400],[2.002802,-0.027148,-0.011301],[2.054199,0.070393,-0.011162],[2.073001,0.068170,-0.011111],[2.482458,-0.137139,-0.010006],[2.486985,-0.103020,-0.009993],[1.941908,0.112798,-0.011465],[1.990108,0.112161,-0.011335],[1.967954,-0.056534,-0.011395],[1.938071,-0.042206,-0.011476],[2.048649,0.111968,-0.011177],[2.072566,0.108240,-0.011112],[2.499045,-0.137912,-0.009961],[2.499007,-0.112247,-0.009961],[2.048649,0.147784,-0.011177],[2.072566,0.144057,-0.011112],[2.662913,-0.138682,-0.009518],[2.579061,-0.117598,-0.009745],[2.175882,0.145042,-0.010833],[2.167987,0.093979,-0.010855],[2.756812,-0.147961,-0.009265],[2.614397,-0.113258,-0.009649],[1.864435,0.112138,-0.011674],[1.705899,0.115980,-0.012102],[1.927320,0.133312,-0.011505],[2.212348,0.119641,-0.010735],[2.228156,0.084017,-0.010692],[2.717393,-0.119351,-0.009371],[2.755673,-0.090610,-0.009268],[1.631014,0.090520,-0.012305],[2.311128,0.099245,-0.010468],[2.303847,0.060048,-0.010488],[2.815606,-0.110553,-0.009106],[2.785262,-0.096287,-0.009188],[1.695928,0.124596,-0.012129],[2.361675,0.083320,-0.010332],[2.343219,0.061732,-0.010382],[2.944727,-0.089207,-0.008758],[2.896949,-0.067962,-0.008887],[1.553759,0.056313,-0.012513],[1.533183,0.116856,-0.012569],[2.426393,0.072169,-0.010157],[2.418315,0.040557,-0.010179],[3.012211,-0.067238,-0.008575],[3.018108,-0.042853,-0.008559],[1.511516,0.072154,-0.012627],[2.456203,0.067033,-0.010077],[2.436172,0.050746,-0.010131],[3.153286,-0.053551,-0.008194],[3.106206,-0.037533,-0.008322],[2.527253,0.044289,-0.009885],[2.522257,0.035322,-0.009898],[3.162019,-0.035516,-0.008171],[2.728899,0.037249,-0.009340],[2.627972,0.015476,-0.009613],[3.273958,-0.047788,-0.007869],[2.753591,0.018401,-0.009274],[2.661740,0.010779,-0.009522],[3.217829,-0.033499,-0.008020],[2.833044,0.024357,-0.009059],[2.806075,0.006446,-0.009132],[3.326367,-0.036619,-0.007727],[2.980067,0.008406,-0.008662],[3.191382,-0.011388,-0.008092],[0.585008,0.192385,-0.015129],[0.615569,0.224180,-0.015046],[0.720402,0.245106,-0.014763],[0.712927,0.205004,-0.014783],[3.040720,0.034746,-0.008498],[3.124295,-0.021238,-0.008273],[0.542151,0.222419,-0.015244],[3.046754,0.004083,-0.008482],[3.110832,0.012578,-0.008309],[0.526342,0.184415,-0.015287],[0.597392,0.152976,-0.015095],[3.056884,0.029635,-0.008455],[3.059999,-0.008564,-0.008446],[0.526342,0.220231,-0.015287],[0.410665,0.172599,-0.015599],[0.410665,0.206584,-0.015599],[0.318653,0.172820,-0.015848],[0.318653,0.204973,-0.015848],[0.272409,0.210672,-0.015973],[0.272409,0.184664,-0.015973],[-0.041175,0.154526,-0.016819],[-0.041175,0.183602,-0.016819],[-0.107411,0.148418,-0.016998],[-0.107411,0.176906,-0.016998],[-0.160062,0.195233,-0.017140],[-0.160062,0.166746,-0.017140],[-0.556231,0.302455,-0.018210],[-0.556231,0.273967,-0.018210],[-0.682712,0.337157,-0.018552],[-0.682712,0.308670,-0.018552],[-0.752820,0.365648,-0.018741],[-0.752820,0.337160,-0.018741],[-0.787729,0.323255,-0.018835],[-0.787729,0.351742,-0.018835],[-0.910634,0.299177,-0.019167],[-0.910634,0.327665,-0.019167],[-1.060880,0.290633,-0.019573],[-1.060880,0.319121,-0.019573],[-1.259111,0.279895,-0.020108],[-1.259111,0.308383,-0.020108],[-1.349552,0.255170,-0.020352],[-1.349552,0.283658,-0.020352],[-1.430352,0.310139,-0.020570],[-1.430352,0.279620,-0.020570],[-1.549400,0.322181,-0.020892],[-1.549400,0.295451,-0.020892],[-1.668444,0.341667,-0.021213],[-1.668444,0.303838,-0.021213],[-1.858169,0.308222,-0.021725],[-1.821765,0.368996,-0.021627],[-1.956751,0.343324,-0.021991],[-1.868138,0.293358,-0.021752],[-1.967369,0.303299,-0.022020],[-1.954532,0.270407,-0.021985],[-1.925050,0.239181,-0.021906],[-2.048354,0.304224,-0.022239],[-2.037809,0.335587,-0.022210],[-1.861460,0.280159,-0.021734],[-1.848645,0.263878,-0.021700],[-1.894710,0.216425,-0.021824],[-1.830022,0.253577,-0.021649],[-1.870179,0.187688,-0.021758],[-2.288156,0.418141,-0.022886],[-2.213105,0.352779,-0.022684],[-2.222060,0.285685,-0.022708],[-2.279724,0.318381,-0.022863],[-1.837615,0.166547,-0.021670],[-2.291329,0.296112,-0.022895],[-2.304537,0.379738,-0.022930],[-1.773602,0.253567,-0.021497],[-1.789598,0.166419,-0.021540],[-2.300822,0.277893,-0.022920],[-2.316727,0.370827,-0.022963],[-1.732637,0.232543,-0.021386],[-1.713239,0.180553,-0.021334],[-2.321918,0.237406,-0.022977],[-2.321918,0.335017,-0.022977],[-2.363569,0.202648,-0.023090],[-2.373154,0.268647,-0.023116],[-2.405218,0.167891,-0.023202],[-2.414802,0.236369,-0.023228],[-2.609557,0.046074,-0.023754],[-2.609557,0.158564,-0.023754],[1.169038,-0.080252,-0.013552],[1.143564,-0.083210,-0.013621],[1.161519,-0.063367,-0.013572],[1.195741,-0.083253,-0.013480],[1.192930,-0.069961,-0.013487],[1.095814,-0.099123,-0.013750],[1.081090,-0.079992,-0.013789],[1.164532,-0.003769,-0.013564],[1.300344,-0.081716,-0.013197],[1.300369,-0.072258,-0.013197],[1.195066,-0.023701,-0.013482],[1.353272,-0.084402,-0.013054],[1.354813,-0.072971,-0.013050],[1.305106,-0.055658,-0.013185],[1.209914,-0.048312,-0.013442],[1.406175,-0.088900,-0.012912],[1.409497,-0.073519,-0.012903],[1.355046,-0.052019,-0.013050],[1.421389,-0.088187,-0.012871],[1.424783,-0.073811,-0.012861],[1.405271,-0.044590,-0.012914],[2.411519,-0.098073,-0.010197],[2.333367,-0.028255,-0.010408],[2.268286,0.063041,-0.010584],[2.316342,0.026464,-0.010454],[2.357327,-0.099373,-0.010344],[2.272020,-0.023163,-0.010574],[2.200986,0.076490,-0.010766],[2.253438,0.036565,-0.010624],[2.309713,-0.094855,-0.010472],[2.219361,-0.014138,-0.010716],[2.144120,0.091411,-0.010919],[2.199677,0.049124,-0.010769],[2.248969,-0.092425,-0.010636],[2.158617,-0.011708,-0.010880],[2.083375,0.093841,-0.011083],[2.138933,0.051554,-0.010933],[2.193987,-0.082054,-0.010785],[2.138445,-0.032437,-0.010935],[2.092196,0.032443,-0.011059],[2.126343,0.006450,-0.010967],[2.151393,-0.080089,-0.010900],[2.120168,-0.052197,-0.010984],[2.094172,-0.015724,-0.011054],[2.118643,-0.030337,-0.010988],[2.116709,-0.078567,-0.010993],[2.100877,-0.065931,-0.011036],[2.091362,-0.050056,-0.011062],[2.104199,-0.056810,-0.011027],[2.512260,-0.105351,-0.009925],[2.441943,-0.040846,-0.010115],[2.383387,0.041296,-0.010273],[2.426622,0.008387,-0.010156],[2.564565,-0.100977,-0.009784],[2.494247,-0.050619,-0.009974],[2.435696,0.028258,-0.010132],[2.478930,-0.003343,-0.010015],[2.610965,-0.098781,-0.009659],[2.540643,-0.045048,-0.009849],[2.482095,0.030789,-0.010007],[2.525331,-0.000812,-0.009890],[2.643494,-0.085976,-0.009571],[2.583707,-0.040289,-0.009732],[2.533924,0.024464,-0.009867],[2.570686,-0.005419,-0.009767],[2.683357,-0.078328,-0.009463],[2.626099,-0.037032,-0.009618],[2.594874,0.005046,-0.009702],[2.631636,-0.018263,-0.009603],[2.808897,-0.072969,-0.009124],[2.763687,-0.035378,-0.009246],[2.739030,0.002925,-0.009313],[2.768058,-0.018293,-0.009235],[2.847068,-0.062088,-0.009021],[2.809641,-0.030972,-0.009122],[2.789229,0.000734,-0.009177],[2.814943,-0.016829,-0.009108],[2.881855,-0.053292,-0.008927],[2.853178,-0.029447,-0.009005],[2.837532,-0.005152,-0.009047],[2.857635,-0.018610,-0.008993],[2.910318,-0.048209,-0.008850],[2.885961,-0.027958,-0.008916],[2.872679,-0.007323,-0.008952],[2.889753,-0.018753,-0.008906],[2.935619,-0.044999,-0.008782],[2.915570,-0.028741,-0.008836],[2.907148,-0.014074,-0.008859],[2.921688,-0.023660,-0.008820],[2.963229,-0.041498,-0.008708],[2.943179,-0.025240,-0.008762],[2.940662,-0.013104,-0.008769],[2.949296,-0.020159,-0.008745],[2.986364,-0.035023,-0.008645],[2.969709,-0.022456,-0.008690],[2.964685,-0.011479,-0.008704],[2.975830,-0.017374,-0.008674],[2.722851,-0.082240,-0.009357],[2.672320,-0.038230,-0.009493],[2.644760,-0.001095,-0.009567],[2.677206,-0.021665,-0.009480],[2.760899,-0.075565,-0.009254],[2.714022,-0.036593,-0.009380],[2.688457,-0.000629,-0.009450],[2.718557,-0.018880,-0.009368],[3.010605,-0.030227,-0.008580],[2.997333,-0.020213,-0.008616],[2.993332,-0.011467,-0.008626],[3.002215,-0.016164,-0.008602],[3.023973,-0.013409,-0.008544],[3.031010,-0.017134,-0.008525],[3.037666,-0.028284,-0.008507],[3.027147,-0.020344,-0.008535],[2.456580,-0.097758,-0.010076],[2.386263,-0.033253,-0.010265],[2.327711,0.048889,-0.010424],[2.370946,0.015980,-0.010307],[-2.146483,0.335951,-0.022504],[-2.101609,-0.254537,-0.022383],[-2.039447,-0.246405,-0.022215],[0.680811,-0.156453,-0.014870],[0.679309,-0.173970,-0.014874],[0.725005,-0.155112,-0.014751],[0.748081,-0.136426,-0.014688],[0.708060,-0.137751,-0.014797],[0.779827,-0.185181,-0.014603],[0.871043,-0.185501,-0.014356],[0.985681,-0.185904,-0.014047],[1.417994,-0.102563,-0.012880],[1.402853,-0.104280,-0.012921],[1.351731,-0.095832,-0.013059],[1.300319,-0.091174,-0.013197],[1.110538,-0.118255,-0.013710],[1.071208,-0.131718,-0.013816],[1.042305,-0.113037,-0.013894],[1.198552,-0.096544,-0.013472],[1.157240,-0.114373,-0.013584],[1.176557,-0.097138,-0.013532],[0.993610,-0.087878,-0.014026],[1.235248,-0.251104,-0.013373],[1.228738,-0.206275,-0.013391],[1.280009,-0.258233,-0.013252],[1.274156,-0.213829,-0.013268],[1.326222,-0.265594,-0.013127],[1.321047,-0.221629,-0.013141],[1.456281,-0.214787,-0.012776],[1.460633,-0.256228,-0.012765],[1.229739,-0.165035,-0.013388],[1.159311,-0.180233,-0.013578],[1.269419,-0.173700,-0.013281],[1.307089,-0.167138,-0.013179],[1.347189,-0.173046,-0.013071],[1.385400,-0.172012,-0.012968],[1.449761,-0.189154,-0.012794],[1.528002,-0.038096,-0.012583],[1.420735,-0.045063,-0.012872],[1.562570,-0.082224,-0.012489],[0.760787,0.184536,-0.014654],[0.818606,0.150372,-0.014498],[1.479598,0.072526,-0.012713],[1.450508,0.045851,-0.012792],[1.498206,0.114757,-0.012663],[1.254595,0.116696,-0.013321],[1.296281,0.102642,-0.013208],[1.175514,0.143357,-0.013534],[1.217269,0.129280,-0.013422],[1.347068,0.105689,-0.013071],[1.399944,0.108862,-0.012928],[0.988526,0.147333,-0.014039],[0.982859,0.124238,-0.014055],[1.044793,0.177988,-0.013887],[0.941165,0.182491,-0.014167],[0.769999,0.221725,-0.014629],[1.116105,0.163387,-0.013695],[0.846126,0.208658,-0.014424],[1.995069,-0.141630,-0.011322],[1.990771,-0.100671,-0.011333],[1.949393,-0.119844,-0.011445],[1.952765,-0.157838,-0.011436],[2.030846,0.146716,-0.011225],[2.016777,0.145872,-0.011263],[-2.166041,-0.092522,0.051778],[-2.172151,0.034029,0.051761],[-2.089480,0.019586,0.051985],[-2.087710,-0.106607,0.051989],[-2.244368,-0.078437,0.051566],[-2.254822,0.048472,0.051538],[-2.055555,0.053974,0.052076],[-2.096044,0.101970,0.051967],[-2.004330,-0.039928,0.052214],[-2.131262,0.132635,0.051872],[-2.012191,0.085067,0.052193],[-2.062886,0.120967,0.052056],[-1.943235,-0.056626,0.052379],[-2.113581,0.156866,0.051919],[-1.988850,0.123830,0.052256],[-1.947270,0.112818,0.052368],[-1.907754,-0.013563,0.052475],[-1.944295,-0.013844,0.052377],[-1.894446,-0.084656,0.052511],[-2.030429,0.134842,0.052144],[-1.903967,0.138964,0.052485],[-1.969181,0.170868,0.052309],[-1.898497,0.076159,0.052500],[-1.945657,0.068467,0.052373],[-1.829011,0.007619,0.052688],[-1.893253,0.024570,0.052514],[-1.983155,-0.127994,0.052272],[-2.034395,0.218811,0.052133],[-2.143690,0.284298,0.051838],[-1.828588,0.052157,0.052689],[-2.123451,-0.164918,0.051893],[-2.062897,-0.203022,0.052056],[-1.796978,0.052362,0.052774],[-1.797355,0.012391,0.052773],[-2.141079,-0.196937,0.051845],[-1.749788,0.000267,0.052902],[-1.749254,0.056802,0.052903],[-1.702331,-0.023093,0.053030],[-1.701416,0.072477,0.053032],[-1.653398,0.072055,0.053162],[-1.654291,-0.021903,0.053160],[-1.606293,0.065264,0.053289],[-1.607086,-0.017935,0.053287],[-1.559366,0.040141,0.053416],[-1.559705,0.004365,0.053415],[-1.518690,0.018513,0.053526],[1.792458,-0.003918,0.062466],[1.763877,-0.005150,0.062388],[1.755486,0.003101,0.062366],[1.789949,0.004056,0.062459],[1.861315,0.001169,0.062652],[1.853123,0.009697,0.062629],[1.794972,-0.011892,0.062472],[1.772264,-0.013401,0.062411],[1.737447,0.009360,0.062317],[1.736394,0.020777,0.062314],[1.912994,0.036553,0.062791],[1.888463,0.044979,0.062725],[1.869515,-0.007359,0.062674],[1.763808,-0.023823,0.062388],[1.792069,-0.019959,0.062465],[1.738495,-0.002056,0.062320],[1.716134,0.012830,0.062260],[1.726298,0.026804,0.062287],[1.937526,0.028127,0.062857],[1.888277,0.100222,0.062724],[1.860472,-0.015983,0.062649],[1.755353,-0.034246,0.062365],[1.789171,-0.028027,0.062457],[1.727725,-0.017166,0.062291],[1.727103,-0.031619,0.062289],[1.705970,-0.001143,0.062232],[1.688155,0.033949,0.062184],[1.704169,0.060112,0.062227],[1.857109,0.062697,0.062640],[1.851433,-0.024606,0.062625],[1.903994,-0.047178,0.062767],[1.726481,-0.046071,0.062288],[1.684208,-0.025643,0.062173],[1.695558,-0.041110,0.062204],[1.671671,0.003299,0.062140],[1.633707,0.037642,0.062037],[1.677277,0.058771,0.062155],[1.854748,0.093887,0.062634],[1.835145,0.068376,0.062581],[1.940019,-0.031421,0.062864],[1.706904,-0.056576,0.062235],[1.655713,-0.038350,0.062096],[1.672106,-0.066363,0.062141],[1.637372,0.007741,0.062047],[1.753140,0.086852,0.062359],[1.750490,0.073208,0.062352],[1.881636,-0.121347,0.062706],[1.688491,-0.094377,0.062185],[1.625763,-0.051704,0.062016],[1.623749,-0.072534,0.062010],[1.612151,0.069139,0.061979],[1.633097,0.054067,0.062035],[1.843508,-0.079131,0.062603],[1.656234,-0.094188,0.062098],[1.595220,0.021064,0.061933],[1.559110,0.022977,0.061836],[1.829035,-0.088190,0.062564],[1.852356,-0.115557,0.062627],[1.760235,-0.095819,0.062379],[1.772691,-0.119019,0.062412],[1.670912,-0.102233,0.062137],[1.668692,-0.127048,0.062131],[1.610724,-0.106079,0.061975],[1.630080,-0.086782,0.062027],[0.609134,0.033409,0.059271],[0.642025,0.017254,0.059360],[0.643574,0.008313,0.059364],[0.595549,0.028917,0.059234],[0.622715,0.037901,0.059307],[0.640481,0.026194,0.059355],[0.677030,0.009741,0.059454],[0.680348,-0.009440,0.059463],[0.682712,0.066939,0.059469],[0.673712,0.028922,0.059445],[0.712846,0.015398,0.059551],[0.715638,-0.000734,0.059558],[0.717972,0.061542,0.059565],[0.710055,0.031530,0.059543],[0.749975,0.023463,0.059651],[0.751470,0.014824,0.059655],[0.753713,0.042522,0.059661],[0.748480,0.032103,0.059647],[0.803130,0.012031,0.059794],[0.809621,0.007304,0.059812],[0.781086,0.031583,0.059735],[0.800704,0.018955,0.059788],[0.903334,-0.006884,0.060065],[0.954955,-0.019879,0.060204],[0.834458,0.019034,0.059879],[0.851716,0.006112,0.059926],[0.964761,0.004436,0.060231],[0.997153,0.010669,0.060318],[0.991485,-0.006398,0.060303],[1.032577,0.000706,0.060414],[1.036681,0.018867,0.060425],[1.018854,-0.037580,0.060377],[0.984372,-0.038430,0.060284],[1.105072,0.009493,0.060610],[1.063771,0.039165,0.060498],[1.059595,-0.089872,0.060487],[0.999216,-0.078783,0.060324],[1.114847,0.041789,0.060636],[1.065400,0.050029,0.060503],[1.066391,0.056641,0.060505],[1.120797,0.061448,0.060652],[1.132219,0.032804,0.060683],[1.129714,-0.052047,0.060676],[1.041780,0.087421,0.060439],[1.105353,0.119662,0.060610],[0.956378,-0.108906,0.060208],[0.987652,-0.096975,0.060293],[1.024686,-0.134884,0.060393],[0.970872,-0.147455,0.060247],[1.028511,0.143037,0.060403],[1.004914,0.120428,0.060339],[0.834537,-0.150012,0.059879],[0.838852,-0.133417,0.059891],[0.836113,0.170760,0.059884],[0.930253,0.156682,0.060138],[0.941191,0.131348,0.060167],[0.873549,0.134596,0.059985],[1.394535,0.055209,0.061391],[1.346395,0.055451,0.061261],[1.343467,0.069268,0.061253],[1.391598,0.069538,0.061383],[1.387071,0.027121,0.061371],[1.350187,0.031060,0.061272],[1.298252,0.055693,0.061131],[1.297065,0.067090,0.061128],[1.316304,0.023712,0.061180],[1.255608,0.059852,0.061016],[1.251279,0.078990,0.061004],[1.275406,0.027055,0.061070],[1.212969,0.064012,0.060901],[1.211863,0.090194,0.060898],[1.238510,0.020032,0.060970],[1.159429,0.069234,0.060756],[1.169284,0.103246,0.060783],[1.184520,0.033985,0.060824],[-2.347657,-0.338864,0.051287],[-2.393234,-0.285219,0.051164],[-2.392265,-0.198945,0.051167],[-2.372147,-0.216390,0.051221],[-2.335125,-0.318246,0.051321],[-2.355815,-0.230554,0.051265],[-2.434639,-0.258785,0.051053],[-2.429196,-0.180445,0.051067],[-2.330411,-0.322407,0.051334],[-2.347554,-0.237718,0.051288],[-2.470455,-0.236323,0.050956],[-2.451740,-0.169151,0.051006],[-2.309564,-0.337222,0.051390],[-2.319362,-0.262164,0.051364],[-2.610610,-0.201940,0.050577],[-2.623066,-0.083321,0.050544],[-2.250371,-0.404286,0.051550],[-2.264773,-0.334026,0.051511],[-2.204836,-0.241413,0.051673],[-2.189886,-0.302658,0.051713],[-1.870958,-0.288702,0.052575],[-1.953254,-0.235106,0.052352],[-1.957827,-0.209808,0.052340],[-1.854653,-0.223315,0.052619],[-1.704715,-0.284954,0.053023],[-1.712469,-0.242056,0.053002],[-1.918238,-0.182337,0.052447],[-1.848088,-0.207526,0.052636],[-1.676278,-0.282274,0.053100],[-1.681179,-0.255179,0.053087],[-1.899962,-0.154093,0.052496],[-1.863371,-0.130844,0.052595],[-1.581396,-0.297994,0.053356],[-1.585968,-0.272696,0.053344],[-1.823081,-0.120210,0.052704],[-1.823218,-0.196732,0.052703],[-1.456481,-0.319835,0.053694],[-1.461058,-0.294536,0.053681],[-1.793610,-0.107443,0.052783],[-1.774521,-0.186215,0.052835],[-1.375546,-0.339513,0.053912],[-1.380122,-0.314215,0.053900],[-1.751546,-0.110670,0.052897],[-1.737019,-0.179335,0.052936],[-1.303203,-0.280230,0.054107],[-1.298630,-0.305528,0.054120],[-1.705073,-0.152636,0.053022],[-1.710364,-0.110041,0.053008],[-1.058672,-0.233382,0.054768],[-1.054095,-0.258680,0.054780],[-0.840667,-0.191762,0.055356],[-0.836094,-0.217061,0.055369],[-0.765856,-0.153150,0.055558],[-0.761284,-0.178449,0.055571],[-0.448071,-0.218913,0.056416],[-0.452644,-0.193615,0.056404],[-0.095622,-0.273153,0.057368],[-0.100198,-0.247855,0.057356],[0.314297,-0.222363,0.058475],[0.304606,-0.192093,0.058448],[0.549106,-0.211306,0.059109],[0.534297,-0.176065,0.059069],[0.562444,-0.126662,0.059145],[0.558450,-0.208727,0.059134],[0.566876,-0.165466,0.059157],[0.631880,-0.195112,0.059332],[0.599378,-0.180289,0.059244],[1.153828,-0.238165,0.060741],[1.064343,-0.223912,0.060500],[1.055327,-0.177460,0.060475],[1.146125,-0.192563,0.060721],[1.400009,-0.222990,0.061406],[1.404495,-0.265707,0.061418],[1.366819,-0.272089,0.061316],[1.362242,-0.228511,0.061304],[1.579359,-0.169591,0.061890],[1.559671,-0.239423,0.061837],[1.505082,-0.248670,0.061690],[1.500837,-0.208248,0.061678],[1.680317,-0.218988,0.062163],[1.653963,-0.178384,0.062092],[1.812475,-0.180706,0.062520],[1.797424,-0.164884,0.062479],[1.904509,-0.176235,0.062768],[1.869775,-0.148433,0.062674],[1.911038,-0.137279,0.062786],[1.926229,-0.154501,0.062827],[2.042424,-0.089099,0.063141],[2.030552,-0.127968,0.063108],[2.025979,-0.084391,0.063096],[2.076677,-0.091352,0.063233],[2.047001,-0.132676,0.063153],[2.074862,-0.046931,0.063228],[2.053809,-0.045056,0.063171],[2.081250,-0.134930,0.063245],[2.056994,-0.016367,0.063180],[2.074111,-0.017983,0.063226],[2.133730,-0.128835,0.063387],[2.129909,-0.092941,0.063377],[2.060179,0.012322,0.063188],[2.073363,0.010966,0.063224],[2.251829,-0.121671,0.063706],[2.261749,-0.102610,0.063733],[2.004201,0.035324,0.063037],[1.991180,0.003955,0.063002],[2.057101,0.041357,0.063180],[2.073092,0.039568,0.063223],[2.387911,-0.133900,0.064073],[2.429944,-0.110559,0.064187],[1.933246,0.041615,0.062846],[1.965799,0.054035,0.062934],[2.002626,-0.027149,0.063033],[2.054023,0.070392,0.063172],[2.072825,0.068169,0.063223],[2.482282,-0.137139,0.064328],[2.486810,-0.103021,0.064340],[1.941733,0.112798,0.062869],[1.989932,0.112160,0.062999],[1.967778,-0.056535,0.062939],[1.937895,-0.042207,0.062858],[2.048474,0.111967,0.063157],[2.072391,0.108240,0.063221],[2.498870,-0.137913,0.064373],[2.498832,-0.112247,0.064373],[2.048474,0.147784,0.063157],[2.072391,0.144056,0.063221],[2.662737,-0.138683,0.064815],[2.578886,-0.117598,0.064589],[2.175707,0.145041,0.063500],[2.167812,0.093978,0.063479],[2.756637,-0.147962,0.065069],[2.614222,-0.113258,0.064684],[1.864260,0.112137,0.062660],[1.705723,0.115980,0.062231],[1.927144,0.133312,0.062829],[2.212172,0.119640,0.063599],[2.227980,0.084017,0.063642],[2.717218,-0.119352,0.064962],[2.755498,-0.090610,0.065066],[1.630839,0.090519,0.062029],[2.310953,0.099244,0.063866],[2.303672,0.060047,0.063846],[2.815431,-0.110554,0.065228],[2.785087,-0.096287,0.065146],[1.695752,0.124596,0.062205],[2.361499,0.083319,0.064002],[2.343043,0.061731,0.063952],[2.944552,-0.089207,0.065576],[2.896774,-0.067963,0.065447],[1.553584,0.056312,0.061821],[1.533008,0.116855,0.061765],[2.426218,0.072168,0.064177],[2.418139,0.040556,0.064155],[3.012036,-0.067238,0.065758],[3.017932,-0.042854,0.065774],[1.511341,0.072153,0.061707],[2.456028,0.067032,0.064257],[2.435997,0.050746,0.064203],[3.153110,-0.053551,0.066139],[3.106030,-0.037534,0.066012],[2.527077,0.044289,0.064449],[2.522081,0.035322,0.064436],[3.161843,-0.035517,0.066163],[2.728724,0.037249,0.064994],[2.627796,0.015475,0.064721],[3.273782,-0.047789,0.066465],[2.753415,0.018401,0.065060],[2.661564,0.010778,0.064812],[3.217653,-0.033499,0.066314],[2.832868,0.024356,0.065275],[2.805900,0.006445,0.065202],[3.326191,-0.036620,0.066607],[2.979891,0.008405,0.065672],[3.191207,-0.011388,0.066242],[0.584832,0.192384,0.059205],[0.615394,0.224179,0.059288],[0.720226,0.245106,0.059571],[0.712751,0.205003,0.059550],[3.040545,0.034745,0.065835],[3.124120,-0.021239,0.066061],[0.541975,0.222418,0.059089],[3.046579,0.004083,0.065852],[3.110657,0.012577,0.066025],[0.526166,0.184414,0.059047],[0.597216,0.152976,0.059239],[3.056709,0.029634,0.065879],[3.059824,-0.008565,0.065887],[0.526166,0.220231,0.059047],[0.410490,0.172598,0.058734],[0.410490,0.206583,0.058734],[0.318478,0.172820,0.058486],[0.318478,0.204972,0.058486],[0.272233,0.210671,0.058361],[0.272233,0.184664,0.058361],[-0.041350,0.154526,0.057514],[-0.041350,0.183602,0.057514],[-0.107587,0.148418,0.057336],[-0.107587,0.176905,0.057336],[-0.160238,0.195233,0.057193],[-0.160238,0.166745,0.057193],[-0.556406,0.302454,0.056124],[-0.556406,0.273966,0.056124],[-0.682887,0.337157,0.055782],[-0.682887,0.308669,0.055782],[-0.752995,0.365647,0.055593],[-0.752995,0.337159,0.055593],[-0.787904,0.323254,0.055499],[-0.787904,0.351742,0.055499],[-0.910809,0.299176,0.055167],[-0.910809,0.327664,0.055167],[-1.061056,0.290633,0.054761],[-1.061056,0.319120,0.054761],[-1.259287,0.279895,0.054226],[-1.259287,0.308383,0.054226],[-1.349727,0.255169,0.053982],[-1.349727,0.283657,0.053982],[-1.430527,0.310139,0.053764],[-1.430527,0.279620,0.053764],[-1.549576,0.322181,0.053442],[-1.549576,0.295450,0.053442],[-1.668620,0.341666,0.053121],[-1.668620,0.303838,0.053121],[-1.858344,0.308221,0.052609],[-1.821941,0.368995,0.052707],[-1.956927,0.343323,0.052342],[-1.868314,0.293358,0.052582],[-1.967545,0.303298,0.052314],[-1.954707,0.270407,0.052348],[-1.925225,0.239180,0.052428],[-2.048530,0.304224,0.052095],[-2.037984,0.335586,0.052124],[-1.861636,0.280159,0.052600],[-1.848821,0.263877,0.052634],[-1.894885,0.216424,0.052510],[-1.830197,0.253576,0.052685],[-1.870355,0.187688,0.052576],[-2.288332,0.418140,0.051448],[-2.213281,0.352778,0.051650],[-2.222236,0.285685,0.051626],[-2.279899,0.318380,0.051470],[-1.837791,0.166546,0.052664],[-2.291505,0.296112,0.051439],[-2.304713,0.379738,0.051403],[-1.773778,0.253566,0.052837],[-1.789773,0.166418,0.052794],[-2.300998,0.277892,0.051413],[-2.316902,0.370827,0.051370],[-1.732812,0.232542,0.052948],[-1.713415,0.180553,0.053000],[-2.322093,0.237405,0.051356],[-2.322093,0.335016,0.051356],[-2.363745,0.202648,0.051244],[-2.373329,0.268646,0.051218],[-2.405393,0.167890,0.051132],[-2.414978,0.236369,0.051106],[-2.609733,0.046073,0.050580],[-2.609733,0.158563,0.050580],[1.168862,-0.080253,0.060782],[1.143389,-0.083210,0.060713],[1.161343,-0.063368,0.060762],[1.195566,-0.083253,0.060854],[1.192755,-0.069962,0.060846],[1.095639,-0.099124,0.060584],[1.080915,-0.079993,0.060544],[1.164356,-0.003770,0.060770],[1.300169,-0.081717,0.061136],[1.300193,-0.072258,0.061137],[1.194890,-0.023701,0.060852],[1.353096,-0.084402,0.061279],[1.354637,-0.072972,0.061284],[1.304930,-0.055658,0.061149],[1.209738,-0.048313,0.060892],[1.406000,-0.088900,0.061422],[1.409322,-0.073520,0.061431],[1.354870,-0.052019,0.061284],[1.421213,-0.088188,0.061463],[1.424608,-0.073812,0.061472],[1.405096,-0.044591,0.061420],[2.411344,-0.098074,0.064137],[2.333191,-0.028256,0.063926],[2.268111,0.063040,0.063750],[2.316166,0.026464,0.063880],[2.357151,-0.099373,0.063990],[2.271844,-0.023164,0.063760],[2.200810,0.076490,0.063568],[2.253263,0.036564,0.063710],[2.309537,-0.094856,0.063862],[2.219186,-0.014138,0.063618],[2.143944,0.091410,0.063415],[2.199502,0.049123,0.063565],[2.248793,-0.092426,0.063698],[2.158441,-0.011708,0.063454],[2.083200,0.093840,0.063251],[2.138757,0.051553,0.063401],[2.193811,-0.082055,0.063549],[2.138269,-0.032438,0.063399],[2.092021,0.032443,0.063274],[2.126167,0.006449,0.063367],[2.151217,-0.080090,0.063434],[2.119992,-0.052197,0.063350],[2.093997,-0.015725,0.063280],[2.118467,-0.030337,0.063346],[2.116533,-0.078568,0.063341],[2.100701,-0.065931,0.063298],[2.091186,-0.050056,0.063272],[2.104024,-0.056810,0.063307],[2.512085,-0.105352,0.064409],[2.441767,-0.040847,0.064219],[2.383212,0.041296,0.064061],[2.426447,0.008386,0.064177],[2.564389,-0.100977,0.064550],[2.494072,-0.050620,0.064360],[2.435520,0.028257,0.064202],[2.478755,-0.003344,0.064319],[2.610790,-0.098782,0.064675],[2.540468,-0.045049,0.064485],[2.481920,0.030788,0.064327],[2.525155,-0.000813,0.064444],[2.643318,-0.085977,0.064763],[2.583531,-0.040290,0.064602],[2.533748,0.024463,0.064467],[2.570511,-0.005420,0.064566],[2.683182,-0.078328,0.064871],[2.625923,-0.037033,0.064716],[2.594698,0.005045,0.064632],[2.631460,-0.018263,0.064731],[2.808722,-0.072969,0.065210],[2.763512,-0.035379,0.065087],[2.738854,0.002924,0.065021],[2.767882,-0.018293,0.065099],[2.846892,-0.062089,0.065313],[2.809465,-0.030972,0.065212],[2.789054,0.000734,0.065156],[2.814768,-0.016830,0.065226],[2.881679,-0.053292,0.065407],[2.853002,-0.029448,0.065329],[2.837356,-0.005152,0.065287],[2.857460,-0.018611,0.065341],[2.910142,-0.048210,0.065483],[2.885786,-0.027959,0.065418],[2.872503,-0.007323,0.065382],[2.889577,-0.018754,0.065428],[2.935443,-0.045000,0.065552],[2.915394,-0.028742,0.065498],[2.906972,-0.014075,0.065475],[2.921512,-0.023661,0.065514],[2.963053,-0.041498,0.065626],[2.943003,-0.025241,0.065572],[2.940486,-0.013105,0.065565],[2.949121,-0.020159,0.065589],[2.986188,-0.035023,0.065689],[2.969533,-0.022456,0.065644],[2.964509,-0.011480,0.065630],[2.975654,-0.017375,0.065660],[2.722676,-0.082241,0.064977],[2.672144,-0.038231,0.064841],[2.644585,-0.001096,0.064766],[2.677031,-0.021666,0.064854],[2.760723,-0.075565,0.065080],[2.713846,-0.036594,0.064953],[2.688281,-0.000630,0.064884],[2.718381,-0.018881,0.064966],[3.010430,-0.030227,0.065754],[2.997158,-0.020214,0.065718],[2.993157,-0.011468,0.065707],[3.002039,-0.016165,0.065731],[3.023798,-0.013410,0.065790],[3.030834,-0.017135,0.065809],[3.037490,-0.028285,0.065827],[3.026971,-0.020345,0.065799],[2.456405,-0.097759,0.064258],[2.386088,-0.033254,0.064068],[2.327536,0.048888,0.063910],[2.370771,0.015979,0.064027],[-2.146659,0.335950,0.051830],[-2.101784,-0.254538,0.051951],[-2.039622,-0.246405,0.052119],[0.680635,-0.156454,0.059464],[0.679133,-0.173970,0.059460],[0.724830,-0.155113,0.059583],[0.747906,-0.136427,0.059645],[0.707884,-0.137752,0.059537],[0.779652,-0.185181,0.059731],[0.870868,-0.185502,0.059977],[0.985505,-0.185905,0.060287],[1.417819,-0.102564,0.061454],[1.402678,-0.104280,0.061413],[1.351556,-0.095833,0.061275],[1.300144,-0.091175,0.061136],[1.110362,-0.118255,0.060624],[1.071033,-0.131719,0.060518],[1.042130,-0.113037,0.060440],[1.198377,-0.096544,0.060862],[1.157064,-0.114374,0.060750],[1.176381,-0.097138,0.060802],[0.993435,-0.087879,0.060308],[1.235073,-0.251105,0.060961],[1.228562,-0.206275,0.060943],[1.279833,-0.258234,0.061082],[1.273980,-0.213830,0.061066],[1.326046,-0.265595,0.061206],[1.320871,-0.221630,0.061192],[1.456106,-0.214788,0.061558],[1.460458,-0.256228,0.061569],[1.229563,-0.165036,0.060946],[1.159135,-0.180234,0.060756],[1.269243,-0.173701,0.061053],[1.306913,-0.167139,0.061155],[1.347013,-0.173047,0.061263],[1.385225,-0.172012,0.061366],[1.449585,-0.189154,0.061540],[1.527826,-0.038096,0.061751],[1.420559,-0.045064,0.061462],[1.562395,-0.082224,0.061844],[0.760611,0.184535,0.059680],[0.818430,0.150371,0.059836],[1.479422,0.072525,0.061620],[1.450333,0.045850,0.061542],[1.498031,0.114757,0.061671],[1.254419,0.116695,0.061013],[1.296105,0.102641,0.061126],[1.175338,0.143357,0.060799],[1.217093,0.129279,0.060912],[1.346893,0.105688,0.061263],[1.399769,0.108861,0.061405],[0.988351,0.147333,0.060295],[0.982683,0.124237,0.060279],[1.044617,0.177987,0.060446],[0.940989,0.182491,0.060167],[0.769823,0.221725,0.059705],[1.115929,0.163386,0.060639],[0.845951,0.208657,0.059910],[1.994893,-0.141631,0.063012],[1.990595,-0.100672,0.063001],[1.949218,-0.119845,0.062889],[1.952589,-0.157839,0.062898],[2.030671,0.146716,0.063109],[2.016601,0.145871,0.063071]];module DaggerDesign3() {
    multmatrix(DaggerDesign3_multmatrix()) polyhedron(triangles = DaggerDesign3_triangles(), points = DaggerDesign3_points(), convexity=10);
};



function Cube_001_dimX() = 174.14;
function Cube_001_dimY() = 29.05;
function Cube_001_dimZ() = 9.13;
function Cube_001_multmatrix() = [[-27.680418,-0.000001,0.000000,35.990913],[-0.000001,27.680418,0.000000,-0.986976],[0.000000,0.000000,27.680418,0.000003],[0.000000,0.000000,0.000000,1.000000]];

function Cube_001_triangles() = [
[2,49,48],[3,2,48],[4,121,120],[5,4,120],[6,113,112],[7,6,112],[8,124,126],[9,8,126],[10,60,62],[11,10,62],[12,68,70],[13,12,70],[14,76,78],[15,14,78],[16,84,86],[17,16,86],[18,92,94],[19,18,94],[20,108,110],[21,20,110],[23,104,106],[22,23,106],[0,25,24],[1,0,24],[7,27,119],[116,7,119],[22,29,103],[101,22,103],[6,31,115],[113,6,115],[13,33,75],[72,13,75],[19,34,99],[96,19,99],[12,36,71],[68,12,71],[18,38,95],[92,18,95],[3,40,123],[120,3,123],[2,51,49],[9,26,59],[56,9,59],[8,43,127],[124,8,127],[15,32,83],[80,15,83],[23,45,107],[104,23,107],[14,46,79],[76,14,79],[20,47,111],[108,20,111],[5,39,114],[112,5,114],[21,28,47],[20,21,47],[4,30,122],[121,4,122],[11,42,66],[64,11,66],[17,44,90],[88,17,90],[10,35,63],[60,10,63],[16,37,87],[84,16,87],[1,24,55],[52,1,55],[24,157,234],[55,24,234],[37,172,282],[87,37,282],[35,166,246],[63,35,246],[44,173,288],[90,44,288],[42,167,252],[66,42,252],[30,160,337],[122,30,337],[28,177,176],[47,28,176],[39,161,324],[114,39,324],[47,176,318],[111,47,318],[46,170,270],[79,46,270],[45,179,312],[107,45,312],[32,171,276],[83,32,276],[43,164,342],[127,43,342],[26,165,240],[59,26,240],[41,158,229],[51,41,229],[40,159,336],[123,40,336],[38,174,294],[95,38,294],[36,168,258],[71,36,258],[34,175,300],[99,34,300],[33,169,264],[75,33,264],[31,162,325],[115,31,325],[29,178,307],[103,29,307],[27,163,330],[119,27,330],[25,156,157],[24,25,157],[51,229,237],[53,51,237],[50,228,159],[40,50,159],[3,48,50],[49,51,53],[54,49,53],[49,54,52],[48,49,52],[2,41,51],[3,50,40],[54,0,1],[52,54,1],[54,53,25],[0,54,25],[53,237,156],[25,53,156],[55,234,228],[50,55,228],[52,55,50],[48,52,50],[59,240,348],[131,59,348],[58,241,164],[43,58,164],[57,58,43],[8,57,43],[56,59,131],[128,56,131],[57,8,9],[56,57,9],[62,61,42],[11,62,42],[61,249,167],[42,61,167],[63,246,351],[129,63,351],[60,63,129],[130,60,129],[60,130,128],[62,60,128],[67,253,166],[35,67,166],[66,252,355],[138,66,355],[64,66,138],[133,64,138],[65,67,35],[10,65,35],[65,10,11],[64,65,11],[70,69,33],[13,70,33],[69,261,169],[33,69,169],[71,258,361],[134,71,361],[68,71,134],[137,68,134],[68,137,132],[70,68,132],[75,264,366],[143,75,366],[74,265,168],[36,74,168],[73,74,36],[12,73,36],[72,75,143],[140,72,143],[73,12,13],[72,73,13],[78,77,32],[15,78,32],[77,273,171],[32,77,171],[79,270,369],[141,79,369],[76,79,141],[142,76,141],[76,142,140],[78,76,140],[83,276,373],[150,83,373],[82,277,170],[46,82,170],[81,82,46],[14,81,46],[80,83,150],[145,80,150],[81,14,15],[80,81,15],[86,85,44],[17,86,44],[85,285,173],[44,85,173],[87,282,379],[146,87,379],[84,87,146],[149,84,146],[84,149,144],[86,84,144],[91,289,172],[37,91,172],[90,288,384],[155,90,384],[88,90,155],[152,88,155],[89,91,37],[16,89,37],[89,16,17],[88,89,17],[94,93,34],[19,94,34],[93,297,175],[34,93,175],[95,294,387],[153,95,387],[92,95,153],[154,92,153],[92,154,152],[94,92,152],[99,300,315],[105,99,315],[98,301,174],[38,98,174],[97,98,38],[18,97,38],[96,99,105],[106,96,105],[97,18,19],[96,97,19],[103,307,321],[109,103,321],[102,306,179],[45,102,179],[100,102,45],[23,100,45],[101,103,109],[110,101,109],[100,23,22],[101,100,22],[106,105,29],[22,106,29],[105,315,178],[29,105,178],[107,312,301],[98,107,301],[104,107,98],[97,104,98],[104,97,96],[106,104,96],[110,109,28],[21,110,28],[109,321,177],[28,109,177],[111,318,306],[102,111,306],[108,111,102],[100,108,102],[108,100,101],[110,108,101],[115,325,160],[30,115,160],[114,324,163],[27,114,163],[112,114,27],[7,112,27],[113,115,30],[4,113,30],[113,4,5],[112,113,5],[119,330,345],[125,119,345],[118,331,162],[31,118,162],[117,118,31],[6,117,31],[116,119,125],[126,116,125],[117,6,7],[116,117,7],[123,336,161],[39,123,161],[122,337,158],[41,122,158],[121,122,41],[2,121,41],[120,123,39],[5,120,39],[121,2,3],[120,121,3],[126,125,26],[9,126,26],[125,345,165],[26,125,165],[127,342,331],[118,127,331],[124,127,118],[117,124,118],[124,117,116],[126,124,116],[130,57,56],[128,130,56],[130,129,58],[57,130,58],[129,351,241],[58,129,241],[128,131,61],[62,128,61],[131,348,249],[61,131,249],[136,65,64],[133,136,64],[137,136,133],[132,137,133],[136,135,67],[65,136,67],[137,134,135],[136,137,135],[135,360,253],[67,135,253],[134,361,360],[135,134,360],[132,139,69],[70,132,69],[133,138,139],[132,133,139],[139,354,261],[69,139,261],[138,355,354],[139,138,354],[142,73,72],[140,142,72],[142,141,74],[73,142,74],[141,369,265],[74,141,265],[140,143,77],[78,140,77],[143,366,273],[77,143,273],[148,81,80],[145,148,80],[149,148,145],[144,149,145],[148,147,82],[81,148,82],[149,146,147],[148,149,147],[147,378,277],[82,147,277],[146,379,378],[147,146,378],[144,151,85],[86,144,85],[145,150,151],[144,145,151],[151,372,285],[85,151,285],[150,373,372],[151,150,372],[154,89,88],[152,154,88],[154,153,91],[89,154,91],[153,387,289],[91,153,289],[152,155,93],[94,152,93],[155,384,297],[93,155,297],[158,229,228],[159,158,228],[160,337,336],[161,160,336],[162,325,324],[163,162,324],[164,342,345],[165,164,345],[166,246,249],[167,166,249],[168,258,261],[169,168,261],[170,270,273],[171,170,273],[172,282,285],[173,172,285],[174,294,297],[175,174,297],[176,318,321],[177,176,321],[179,312,315],[178,179,315],[182,183,230],[231,182,230],[184,185,338],[339,184,338],[186,187,326],[327,186,326],[188,189,346],[343,188,346],[190,191,250],[247,190,250],[192,193,262],[259,192,262],[194,195,274],[271,194,274],[196,197,286],[283,196,286],[198,199,298],[295,198,298],[200,201,322],[319,200,322],[203,202,316],[313,203,316],[180,181,204],[205,180,204],[187,332,335],[207,187,335],[202,309,311],[209,202,311],[186,327,329],[211,186,329],[193,266,269],[213,193,269],[199,302,305],[214,199,305],[192,259,263],[216,192,263],[198,295,299],[218,198,299],[183,338,341],[220,183,341],[233,182,231],[189,242,245],[206,189,245],[188,343,347],[223,188,347],[195,278,281],[212,195,281],[203,313,317],[225,203,317],[194,271,275],[226,194,275],[200,319,323],[227,200,323],[185,326,328],[219,185,328],[201,200,227],[208,201,227],[184,339,340],[210,184,340],[191,254,256],[222,191,256],[197,290,292],[224,197,292],[190,247,251],[215,190,251],[196,283,287],[217,196,287],[181,235,239],[204,181,239],[204,239,234],[157,204,234],[217,287,282],[172,217,282],[215,251,246],[166,215,246],[224,292,288],[173,224,288],[222,256,252],[167,222,252],[210,340,337],[160,210,337],[208,227,176],[177,208,176],[219,328,324],[161,219,324],[227,323,318],[176,227,318],[226,275,270],[170,226,270],[225,317,312],[179,225,312],[212,281,276],[171,212,276],[223,347,342],[164,223,342],[206,245,240],[165,206,240],[221,233,229],[158,221,229],[220,341,336],[159,220,336],[218,299,294],[174,218,294],[216,263,258],[168,216,258],[214,305,300],[175,214,300],[213,269,264],[169,213,264],[211,329,325],[162,211,325],[209,311,307],[178,209,307],[207,335,330],[163,207,330],[205,204,157],[156,205,157],[233,236,237],[229,233,237],[232,220,159],[228,232,159],[230,183,232],[231,238,236],[233,231,236],[231,230,235],[238,231,235],[229,237,234],[228,229,234],[221,182,233],[232,183,220],[237,156,157],[234,237,157],[238,235,181],[180,238,181],[238,180,205],[236,238,205],[236,205,156],[237,236,156],[239,232,228],[234,239,228],[235,230,232],[239,235,232],[245,353,348],[240,245,348],[244,223,164],[241,244,164],[243,188,223],[244,243,223],[242,349,353],[245,242,353],[243,242,189],[188,243,189],[241,164,165],[240,241,165],[250,191,222],[248,250,222],[248,222,167],[249,248,167],[251,350,351],[246,251,351],[247,352,350],[251,247,350],[247,250,349],[352,247,349],[246,351,348],[249,246,348],[257,215,166],[253,257,166],[256,364,355],[252,256,355],[254,357,364],[256,254,364],[255,190,215],[257,255,215],[255,254,191],[190,255,191],[253,166,167],[252,253,167],[262,193,213],[260,262,213],[260,213,169],[261,260,169],[263,358,361],[258,263,361],[259,363,358],[263,259,358],[259,262,356],[363,259,356],[258,361,354],[261,258,354],[269,371,366],[264,269,366],[268,216,168],[265,268,168],[267,192,216],[268,267,216],[266,367,371],[269,266,371],[267,266,193],[192,267,193],[265,168,169],[264,265,169],[274,195,212],[272,274,212],[272,212,171],[273,272,171],[275,368,369],[270,275,369],[271,370,368],[275,271,368],[271,274,367],[370,271,367],[270,369,366],[273,270,366],[281,382,373],[276,281,373],[280,226,170],[277,280,170],[279,194,226],[280,279,226],[278,375,382],[281,278,382],[279,278,195],[194,279,195],[277,170,171],[276,277,171],[286,197,224],[284,286,224],[284,224,173],[285,284,173],[287,376,379],[282,287,379],[283,381,376],[287,283,376],[283,286,374],[381,283,374],[282,379,372],[285,282,372],[293,217,172],[289,293,172],[292,389,384],[288,292,384],[290,385,389],[292,290,389],[291,196,217],[293,291,217],[291,290,197],[196,291,197],[289,172,173],[288,289,173],[298,199,214],[296,298,214],[296,214,175],[297,296,175],[299,386,387],[294,299,387],[295,388,386],[299,295,386],[295,298,385],[388,295,385],[294,387,384],[297,294,384],[305,314,315],[300,305,315],[304,218,174],[301,304,174],[303,198,218],[304,303,218],[302,316,314],[305,302,314],[303,302,199],[198,303,199],[301,174,175],[300,301,175],[311,320,321],[307,311,321],[310,225,179],[306,310,179],[308,203,225],[310,308,225],[309,322,320],[311,309,320],[308,309,202],[203,308,202],[306,179,178],[307,306,178],[316,202,209],[314,316,209],[314,209,178],[315,314,178],[317,304,301],[312,317,301],[313,303,304],[317,313,304],[313,316,302],[303,313,302],[312,301,300],[315,312,300],[322,201,208],[320,322,208],[320,208,177],[321,320,177],[323,310,306],[318,323,306],[319,308,310],[323,319,310],[319,322,309],[308,319,309],[318,306,307],[321,318,307],[329,210,160],[325,329,160],[328,207,163],[324,328,163],[326,187,207],[328,326,207],[327,184,210],[329,327,210],[327,326,185],[184,327,185],[325,160,161],[324,325,161],[335,344,345],[330,335,345],[334,211,162],[331,334,162],[333,186,211],[334,333,211],[332,346,344],[335,332,344],[333,332,187],[186,333,187],[331,162,163],[330,331,163],[341,219,161],[336,341,161],[340,221,158],[337,340,158],[339,182,221],[340,339,221],[338,185,219],[341,338,219],[339,338,183],[182,339,183],[337,158,159],[336,337,159],[346,189,206],[344,346,206],[344,206,165],[345,344,165],[347,334,331],[342,347,331],[343,333,334],[347,343,334],[343,346,332],[333,343,332],[342,331,330],[345,342,330],[351,241,240],[348,351,240],[352,349,242],[243,352,242],[352,243,244],[350,352,244],[350,244,241],[351,350,241],[349,250,248],[353,349,248],[353,248,249],[348,353,249],[360,253,252],[355,360,252],[361,360,355],[354,361,355],[362,357,254],[255,362,254],[363,356,357],[362,363,357],[362,255,257],[359,362,257],[363,362,359],[358,363,359],[359,257,253],[360,359,253],[358,359,360],[361,358,360],[356,262,260],[365,356,260],[357,356,365],[364,357,365],[365,260,261],[354,365,261],[364,365,354],[355,364,354],[369,265,264],[366,369,264],[370,367,266],[267,370,266],[370,267,268],[368,370,268],[368,268,265],[369,368,265],[367,274,272],[371,367,272],[371,272,273],[366,371,273],[378,277,276],[373,378,276],[379,378,373],[372,379,373],[380,375,278],[279,380,278],[381,374,375],[380,381,375],[380,279,280],[377,380,280],[381,380,377],[376,381,377],[377,280,277],[378,377,277],[376,377,378],[379,376,378],[374,286,284],[383,374,284],[375,374,383],[382,375,383],[383,284,285],[372,383,285],[382,383,372],[373,382,372],[387,289,288],[384,387,288],[388,385,290],[291,388,290],[388,291,293],[386,388,293],[386,293,289],[387,386,289],[385,298,296],[389,385,296],[389,296,297],[384,389,297]];
function Cube_001_points() = [
[2.577426,0.482544,0.164966],[2.577426,-0.491576,0.164966],[2.019307,0.411303,0.159295],[1.972861,-0.345971,0.159295],[1.706663,0.416048,0.150822],[1.718574,-0.329308,0.150822],[1.241112,0.344127,0.143129],[1.248265,-0.385216,0.143129],[0.633871,0.404860,0.133096],[0.719308,-0.244664,0.133096],[-0.027347,0.234028,0.122171],[-0.027347,-0.313170,0.122171],[-0.857243,0.283247,0.108458],[-0.857243,-0.200437,0.108458],[-1.572438,0.138712,0.096641],[-1.572438,-0.312327,0.096641],[-2.321368,0.179618,0.084266],[-2.321368,-0.150548,0.084266],[-2.901621,0.040885,0.074679],[-2.901621,-0.159332,0.074679],[-3.556249,-0.014398,0.049729],[-3.527244,-0.051881,0.049986],[-3.138356,-0.084205,0.069216],[-3.153976,0.079499,0.069216],[2.577426,-0.520293,0.060629],[2.577426,0.503350,0.060629],[0.719777,-0.314533,0.057412],[1.248816,-0.457780,0.057412],[-3.594383,-0.057913,0.038195],[-3.130590,-0.144917,0.057412],[1.707278,0.476813,0.057412],[1.241663,0.401701,0.057412],[-1.572271,-0.385957,0.057412],[-0.856978,-0.269101,0.057412],[-2.901635,-0.227088,0.057412],[-0.026969,0.286716,0.057412],[-0.856978,0.338120,0.057412],[-2.321303,0.229892,0.057412],[-2.901635,0.087064,0.057412],[1.719189,-0.405662,0.057412],[1.949680,-0.447366,0.057412],[1.936538,0.491449,0.057412],[-0.026969,-0.386837,0.057412],[0.634339,0.465129,0.057412],[-2.321303,-0.217609,0.057412],[-3.160067,0.125861,0.057412],[-1.572271,0.187171,0.057412],[-3.627016,0.007577,0.038195],[2.130036,-0.464670,0.160076],[2.127056,0.487158,0.160076],[2.084300,-0.493314,0.058030],[2.053153,0.508658,0.058030],[2.351661,-0.453441,0.162521],[2.313575,0.479667,0.059329],[2.348681,0.459610,0.162521],[2.327658,-0.480635,0.059329],[0.607485,-0.243916,0.131248],[0.522047,0.359290,0.131248],[0.522501,0.415232,0.057412],[0.607938,-0.310787,0.057412],[0.060288,0.235059,0.123619],[0.004894,-0.370045,0.057412],[0.004504,-0.302193,0.123619],[0.060678,0.284798,0.057412],[-0.080121,-0.290965,0.121299],[-0.080121,0.220475,0.121299],[-0.079750,-0.360030,0.057412],[-0.079750,0.270217,0.057412],[-0.793745,0.270620,0.109507],[-0.793471,-0.267847,0.057412],[-0.793745,-0.201154,0.109507],[-0.793471,0.323485,0.057412],[-0.969913,-0.207081,0.106596],[-0.969913,0.248120,0.106596],[-0.969664,0.299355,0.057412],[-0.969664,-0.273140,0.057412],[-1.488413,0.145829,0.098029],[-1.488234,-0.360570,0.057412],[-1.488413,-0.290460,0.098029],[-1.488234,0.193017,0.057412],[-1.642615,-0.287582,0.095481],[-1.642615,0.140081,0.095481],[-1.642457,0.186148,0.057412],[-1.642457,-0.356750,0.057412],[-2.283183,0.166740,0.084897],[-2.283113,-0.225539,0.057412],[-2.283183,-0.162160,0.084897],[-2.283113,0.213947,0.057412],[-2.358586,-0.155922,0.081154],[-2.358586,0.145048,0.081154],[-2.358530,-0.219021,0.056481],[-2.358530,0.192074,0.056481],[-2.874832,0.061112,0.074998],[-2.874842,-0.221239,0.057366],[-2.874832,-0.158211,0.074998],[-2.820685,0.087166,0.057366],[-2.940303,-0.143393,0.072153],[-2.942739,0.042262,0.072153],[-2.943700,0.086425,0.056503],[-2.939103,-0.207051,0.056503],[-3.235336,0.053262,0.062740],[-3.216200,-0.071536,0.062791],[-3.248783,0.090520,0.055048],[-3.217072,-0.116493,0.055048],[-3.095559,0.062718,0.070028],[-3.077635,-0.153400,0.057161],[-3.083585,-0.095912,0.070028],[-3.100232,0.105468,0.057161],[-3.316961,0.032119,0.060832],[-3.304987,-0.094607,0.051121],[-3.295525,-0.062201,0.060931],[-3.336913,0.062547,0.051121],[1.342646,-0.361630,0.144673],[1.334538,0.345204,0.144673],[1.343210,-0.432379,0.057412],[1.335103,0.401374,0.057412],[1.043654,-0.312812,0.139788],[1.038883,0.342770,0.139788],[1.039407,0.397761,0.057412],[1.044178,-0.380213,0.057412],[1.845718,-0.317235,0.155058],[1.862985,0.391273,0.155058],[1.821908,0.457715,0.057412],[1.834435,-0.401046,0.057412],[0.878529,0.355587,0.137138],[0.881912,-0.334238,0.057412],[0.881411,-0.268249,0.137138],[0.879030,0.410674,0.057412],[0.291167,-0.237473,0.127433],[0.291589,0.367958,0.057412],[0.291167,0.318553,0.127433],[0.291589,-0.300454,0.057412],[-0.555870,-0.230785,0.113438],[-0.317996,-0.258692,0.117368],[-0.555564,0.298325,0.057412],[-0.317657,0.281774,0.057412],[-0.317996,0.234434,0.117368],[-0.555870,0.250016,0.113438],[-0.317657,-0.322337,0.057412],[-0.555564,-0.293693,0.057412],[-1.192141,-0.250325,0.102925],[-1.153663,0.246582,0.057412],[-1.153882,0.201079,0.102925],[-1.191922,-0.312645,0.057412],[-2.062048,-0.179281,0.085400],[-1.863741,-0.218110,0.088677],[-2.061956,0.200248,0.056597],[-1.863621,0.191642,0.056597],[-1.863741,0.148504,0.088677],[-2.062048,0.156757,0.085400],[-1.863621,-0.280557,0.056597],[-2.061956,-0.239936,0.056597],[-2.700828,-0.149557,0.074067],[-2.700817,0.102017,0.055622],[-2.700828,0.061034,0.074067],[-2.700817,-0.207690,0.055622],[2.577426,0.515906,0.000000],[2.577426,-0.533661,0.000000],[1.901918,0.507723,0.000000],[1.949681,-0.484338,0.000000],[1.675406,0.499694,0.000000],[1.719189,-0.441137,0.000000],[1.209791,0.427774,0.000000],[1.248816,-0.497045,0.000000],[0.602467,0.488506,0.000000],[0.719777,-0.356493,0.000000],[-0.058842,0.317674,0.000000],[-0.026969,-0.424999,0.000000],[-0.888851,0.366893,0.000000],[-0.856978,-0.312266,0.000000],[-1.604144,0.222358,0.000000],[-1.572271,-0.424156,0.000000],[-2.353176,0.263264,0.000000],[-2.321304,-0.262377,0.000000],[-2.933508,0.124531,0.000000],[-2.901635,-0.271161,0.000000],[-3.713584,0.003509,0.000000],[-3.630930,-0.064389,0.000000],[-3.124026,-0.195648,0.000000],[-3.196727,0.162849,0.000000],[2.577426,0.482544,-0.164966],[2.577426,-0.491576,-0.164966],[2.019307,0.411303,-0.159295],[1.972861,-0.345971,-0.159295],[1.706663,0.416048,-0.150822],[1.718574,-0.329308,-0.150822],[1.241112,0.344127,-0.143129],[1.248265,-0.385216,-0.143129],[0.633871,0.404860,-0.133096],[0.719308,-0.244664,-0.133096],[-0.027347,0.234028,-0.122171],[-0.027347,-0.313170,-0.122171],[-0.857243,0.283247,-0.108458],[-0.857243,-0.200437,-0.108458],[-1.572438,0.138712,-0.096641],[-1.572438,-0.312327,-0.096641],[-2.321368,0.179618,-0.084266],[-2.321368,-0.150548,-0.084266],[-2.901621,0.040885,-0.074679],[-2.901621,-0.159332,-0.074679],[-3.556249,-0.014398,-0.049729],[-3.527244,-0.051881,-0.049986],[-3.138356,-0.084205,-0.069216],[-3.153976,0.079499,-0.069216],[2.577426,-0.520293,-0.060629],[2.577426,0.503350,-0.060629],[0.719777,-0.314533,-0.057412],[1.248816,-0.457780,-0.057412],[-3.594383,-0.057913,-0.038195],[-3.130590,-0.144917,-0.057412],[1.707278,0.476813,-0.057412],[1.241663,0.401701,-0.057412],[-1.572271,-0.385957,-0.057412],[-0.856978,-0.269101,-0.057412],[-2.901635,-0.227088,-0.057412],[-0.026969,0.286716,-0.057412],[-0.856978,0.338120,-0.057412],[-2.321303,0.229892,-0.057412],[-2.901635,0.087064,-0.057412],[1.719189,-0.405662,-0.057412],[1.949680,-0.447366,-0.057412],[1.936538,0.491449,-0.057412],[-0.026969,-0.386837,-0.057412],[0.634339,0.465129,-0.057412],[-2.321303,-0.217609,-0.057412],[-3.160067,0.125861,-0.057412],[-1.572271,0.187171,-0.057412],[-3.627016,0.007577,-0.038195],[2.127746,-0.506174,0.000000],[2.015552,0.515823,0.000000],[2.130036,-0.464670,-0.160076],[2.127056,0.487158,-0.160076],[2.084300,-0.493314,-0.058030],[2.053153,0.508658,-0.058030],[2.349381,-0.493069,0.000000],[2.351661,-0.453441,-0.162521],[2.313575,0.479667,-0.059329],[2.277348,0.489016,0.000000],[2.348681,0.459610,-0.162521],[2.327658,-0.480635,-0.059329],[0.607938,-0.349972,0.000000],[0.490628,0.438618,0.000000],[0.607485,-0.243916,-0.131248],[0.522047,0.359290,-0.131248],[0.522501,0.415232,-0.057412],[0.607938,-0.310787,-0.057412],[0.028805,0.312609,0.000000],[0.060288,0.235059,-0.123619],[0.004894,-0.370045,-0.057412],[0.004894,-0.405872,0.000000],[0.004504,-0.302193,-0.123619],[0.060678,0.284798,-0.057412],[-0.079750,-0.396263,0.000000],[-0.111623,0.299236,0.000000],[-0.080121,-0.290965,-0.121299],[-0.080121,0.220475,-0.121299],[-0.079750,-0.360030,-0.057412],[-0.079750,0.270217,-0.057412],[-0.825344,0.351438,0.000000],[-0.793745,0.270620,-0.109507],[-0.793471,-0.267847,-0.057412],[-0.793471,-0.309202,0.000000],[-0.793745,-0.201154,-0.109507],[-0.793471,0.323485,-0.057412],[-0.969664,-0.313455,0.000000],[-1.001537,0.327686,0.000000],[-0.969913,-0.207081,-0.106596],[-0.969913,0.248120,-0.106596],[-0.969664,0.299355,-0.057412],[-0.969664,-0.273140,-0.057412],[-1.520107,0.226086,0.000000],[-1.488413,0.145829,-0.098029],[-1.488234,-0.360570,-0.057412],[-1.488234,-0.397757,0.000000],[-1.488413,-0.290460,-0.098029],[-1.488234,0.193017,-0.057412],[-1.642457,-0.393520,0.000000],[-1.674330,0.219321,0.000000],[-1.642615,-0.287582,-0.095481],[-1.642615,0.140081,-0.095481],[-1.642457,0.186148,-0.057412],[-1.642457,-0.356750,-0.057412],[-2.314986,0.245421,0.000000],[-2.283183,0.166740,-0.084897],[-2.283113,-0.225539,-0.057412],[-2.283113,-0.267350,0.000000],[-2.283183,-0.162160,-0.084897],[-2.283113,0.213947,-0.057412],[-2.358530,-0.261075,0.000000],[-2.390402,0.223701,0.000000],[-2.358586,-0.155922,-0.081154],[-2.358586,0.145048,-0.081154],[-2.358530,-0.219021,-0.056481],[-2.358530,0.192074,-0.056481],[-2.780074,0.121868,0.000000],[-2.874832,0.061112,-0.074998],[-2.874842,-0.221239,-0.057366],[-2.874842,-0.262283,0.000000],[-2.874832,-0.158211,-0.074998],[-2.820685,0.087166,-0.057366],[-2.938079,-0.250210,0.000000],[-2.976320,0.122158,0.000000],[-2.940303,-0.143393,-0.072153],[-2.942739,0.042262,-0.072153],[-2.943700,0.086425,-0.056503],[-2.939103,-0.207051,-0.056503],[-3.292604,0.119961,0.000000],[-3.218735,-0.154301,0.000000],[-3.235336,0.053262,-0.062740],[-3.216200,-0.071536,-0.062791],[-3.248783,0.090520,-0.055048],[-3.217072,-0.116493,-0.055048],[-3.135774,0.139703,0.000000],[-3.095559,0.062718,-0.070028],[-3.077635,-0.153400,-0.057161],[-3.072603,-0.198845,0.000000],[-3.083585,-0.095912,-0.070028],[-3.100232,0.105468,-0.057161],[-3.387139,0.086273,0.000000],[-3.316961,0.032119,-0.060832],[-3.304987,-0.094607,-0.051121],[-3.314778,-0.122155,0.000000],[-3.295525,-0.062201,-0.060931],[-3.336913,0.062547,-0.051121],[1.343211,-0.469532,0.000000],[1.303230,0.425913,0.000000],[1.342646,-0.361630,-0.144673],[1.334538,0.345204,-0.144673],[1.343210,-0.432379,-0.057412],[1.335103,0.401374,-0.057412],[1.044178,-0.417985,0.000000],[1.007534,0.421437,0.000000],[1.043654,-0.312812,-0.139788],[1.038883,0.342770,-0.139788],[1.039407,0.397761,-0.057412],[1.044178,-0.380213,-0.057412],[1.834435,-0.435206,0.000000],[1.788662,0.476177,0.000000],[1.845718,-0.317235,-0.155058],[1.862985,0.391273,-0.155058],[1.821908,0.457715,-0.057412],[1.834435,-0.401046,-0.057412],[0.847158,0.433409,0.000000],[0.878529,0.355587,-0.137138],[0.881912,-0.334238,-0.057412],[0.881912,-0.372291,0.000000],[0.881411,-0.268249,-0.137138],[0.879030,0.410674,-0.057412],[0.291589,-0.335522,0.000000],[0.291167,-0.237473,-0.127433],[0.291589,0.367958,-0.057412],[0.259716,0.391892,0.000000],[0.291167,0.318553,-0.127433],[0.291589,-0.300454,-0.057412],[-0.555564,-0.330652,0.000000],[-0.317657,-0.357704,0.000000],[-0.555870,-0.230785,-0.113438],[-0.317996,-0.258692,-0.117368],[-0.555564,0.298325,-0.057412],[-0.317657,0.281774,-0.057412],[-0.349530,0.308494,0.000000],[-0.587437,0.324714,0.000000],[-0.317996,0.234434,-0.117368],[-0.555870,0.250016,-0.113438],[-0.317657,-0.322337,-0.057412],[-0.555564,-0.293693,-0.057412],[-1.191922,-0.348472,0.000000],[-1.192141,-0.250325,-0.102925],[-1.153663,0.246582,-0.057412],[-1.185535,0.274492,0.000000],[-1.153882,0.201079,-0.102925],[-1.191922,-0.312645,-0.057412],[-2.061956,-0.277208,0.000000],[-1.863621,-0.316268,0.000000],[-2.062048,-0.179281,-0.085400],[-1.863741,-0.218110,-0.088677],[-2.061956,0.200248,-0.056597],[-1.863621,0.191642,-0.056597],[-1.895494,0.221924,0.000000],[-2.093829,0.230005,0.000000],[-1.863741,0.148504,-0.088677],[-2.062048,0.156757,-0.085400],[-1.863621,-0.280557,-0.056597],[-2.061956,-0.239936,-0.056597],[-2.700817,-0.245846,0.000000],[-2.700828,-0.149557,-0.074067],[-2.700817,0.102017,-0.055622],[-2.732690,0.133057,0.000000],[-2.700828,0.061034,-0.074067],[-2.700817,-0.207690,-0.055622]];module Cube_001() {
    multmatrix(Cube_001_multmatrix()) polyhedron(triangles = Cube_001_triangles(), points = Cube_001_points(), convexity=10);
};


function DaggerDesign3_001_dimX() = 165.83;
function DaggerDesign3_001_dimY() = 22.18;
function DaggerDesign3_001_dimZ() = 5.03;
function DaggerDesign3_001_multmatrix() = [[1.000000,0.000000,0.000000,0.000004],[0.000000,1.000000,0.000000,0.000000],[0.000000,0.000000,1.000000,0.000000],[0.000000,0.000000,0.000000,1.000000]];

function DaggerDesign3_001_triangles() = [
[1,2,0],[3,0,2],[0,4,1],[5,1,4],[2,1,6],[7,6,1],[2,8,3],[1,5,7],[9,7,5],[6,7,10],[11,10,7],[12,3,8],[7,9,11],[13,11,9],[14,15,11],[10,11,15],[12,8,16],[17,16,8],[18,3,12],[19,14,13],[11,13,14],[15,14,20],[21,20,14],[15,22,10],[23,10,22],[16,17,24],[25,24,17],[26,3,18],[19,13,27],[28,27,13],[14,19,21],[27,21,19],[25,29,24],[3,26,30],[31,30,26],[29,32,24],[33,24,32],[34,30,31],[33,32,35],[36,35,32],[35,36,37],[38,37,36],[38,39,37],[40,37,39],[39,41,40],[40,41,42],[43,42,41],[42,43,44],[45,44,43],[47,48,46],[49,46,48],[46,49,50],[51,50,49],[53,47,52],[46,52,47],[47,54,48],[55,48,54],[50,51,56],[57,56,51],[52,46,58],[50,58,46],[53,52,59],[60,59,52],[53,61,47],[54,47,61],[54,62,55],[63,55,62],[56,57,64],[65,64,57],[58,50,64],[56,64,50],[52,58,60],[66,60,58],[59,60,67],[68,67,60],[53,59,69],[70,69,59],[61,71,54],[62,54,71],[62,72,63],[73,63,72],[74,65,57],[60,66,68],[75,68,66],[66,58,75],[76,75,58],[59,67,70],[77,70,67],[69,70,78],[79,78,70],[71,80,62],[72,62,80],[72,81,73],[82,73,81],[65,74,83],[84,83,74],[85,76,58],[70,77,79],[86,79,77],[78,79,87],[88,87,79],[80,89,72],[81,72,89],[83,84,90],[91,90,84],[85,92,76],[79,86,88],[93,88,86],[87,88,94],[95,94,88],[90,91,96],[97,96,91],[76,92,98],[88,93,95],[99,95,93],[100,101,97],[96,97,101],[98,92,102],[103,102,92],[102,103,104],[105,104,103],[104,105,106],[107,106,105],[107,108,106],[109,106,108],[111,112,110],[113,110,112],[115,111,114],[110,114,111],[116,117,111],[112,111,117],[119,115,118],[114,118,115],[119,116,115],[111,115,116],[120,121,116],[117,116,121],[123,119,122],[118,122,119],[123,120,119],[116,119,120],[124,125,120],[121,120,125],[127,123,126],[122,126,123],[127,124,123],[120,123,124],[124,128,125],[129,125,128],[126,130,127],[131,127,130],[127,131,124],[128,124,131],[128,132,129],[133,129,132],[130,134,131],[135,131,134],[131,135,128],[132,128,135],[136,137,132],[133,132,137],[134,136,135],[132,135,136],[133,137,138],[138,137,139],[140,139,137],[138,141,133],[142,133,141],[139,140,143],[144,143,140],[141,145,142],[146,142,145],[148,149,147],[150,147,149],[152,143,151],[149,153,150],[154,150,153],[156,157,155],[158,155,157],[154,153,159],[160,159,153],[158,161,155],[162,155,161],[164,165,163],[166,163,165],[168,169,167],[170,167,169],[172,168,171],[167,171,168],[173,174,168],[169,168,174],[175,173,172],[168,172,173],[176,177,173],[174,173,177],[178,176,175],[173,175,176],[179,180,176],[177,176,180],[181,179,178],[176,178,179],[182,183,179],[180,179,183],[184,182,181],[179,181,182],[186,187,185],[188,185,187],[185,188,189],[190,189,188],[191,192,186],[187,186,192],[189,190,193],[194,193,190],[195,196,191],[192,191,196],[193,194,197],[198,197,194],[199,200,195],[196,195,200],[197,198,201],[202,201,198],[204,201,203],[202,203,201],[206,207,205],[208,205,207],[205,208,209],[210,209,208],[207,211,208],[212,208,211],[209,210,213],[214,213,210],[216,212,215],[211,215,212],[213,214,217],[218,217,214],[219,220,216],[212,216,220],[217,218,221],[222,221,218],[223,224,219],[220,219,224],[221,222,225],[226,225,222],[228,224,227],[223,227,224],[230,225,229],[226,229,225],[228,227,231],[232,231,227],[234,230,233],[229,233,230],[236,234,235],[233,235,234],[238,236,237],[235,237,236],[238,237,239],[240,239,237],[239,240,241],[242,241,240],[241,242,243],[244,243,242],[243,244,245],[246,245,244],[246,247,245],[248,245,247],[248,247,249],[248,249,250],[251,250,249],[253,254,252],[255,252,254],[257,258,256],[259,256,258],[261,262,260],[263,260,262],[261,260,264],[265,264,260],[264,265,266],[267,266,265],[266,267,268],[269,268,267],[271,268,270],[269,270,268],[273,274,272],[275,276,272],[273,272,276],[275,272,277],[278,277,272],[276,275,279],[278,280,277],[281,277,280],[279,275,282],[283,282,275],[280,284,281],[285,281,284],[282,283,286],[287,286,283],[284,280,288],[289,288,280],[284,290,285],[291,285,290],[286,287,292],[293,292,287],[289,294,288],[295,288,294],[284,288,290],[280,296,289],[290,297,291],[298,291,297],[292,293,299],[300,299,293],[301,302,294],[295,294,302],[303,304,296],[289,296,304],[297,305,298],[306,298,305],[299,300,307],[308,307,300],[310,306,309],[305,309,306],[307,308,311],[312,311,308],[310,313,306],[314,306,313],[311,312,315],[316,315,312],[318,319,317],[320,321,313],[314,313,321],[315,316,322],[323,322,316],[318,317,324],[325,326,320],[321,320,326],[322,323,327],[328,327,323],[329,318,324],[330,331,325],[326,325,331],[327,328,332],[333,332,328],[335,329,334],[324,334,329],[336,337,330],[331,330,337],[332,333,338],[339,338,333],[335,334,340],[341,342,336],[337,336,342],[338,339,343],[344,343,339],[345,346,341],[342,341,346],[343,344,347],[348,349,345],[346,345,349],[343,347,350],[351,352,348],[349,348,352],[350,347,353],[351,354,352],[355,352,354],[350,353,356],[354,357,355],[358,356,353],[360,361,359],[362,359,361],[354,363,357],[358,353,364],[365,360,359],[363,366,357],[367,358,364],[365,359,368],[369,368,359],[363,370,366],[371,366,370],[370,367,371],[364,371,367],[365,368,372],[374,372,373],[368,373,372],[376,374,375],[373,375,374],[376,375,377],[378,377,375],[380,377,379],[378,379,377],[382,380,381],[379,381,380],[382,381,383],[384,383,381],[383,384,385],[386,385,384],[385,386,387],[388,387,386],[387,388,389],[390,389,388],[392,389,391],[390,391,389],[394,392,393],[391,393,392],[396,394,395],[393,395,394],[398,396,397],[395,397,396],[400,398,399],[397,399,398],[400,399,401],[402,401,399],[401,402,403],[404,403,402],[403,404,405],[406,405,404],[408,405,407],[406,407,405],[409,408,407],[410,411,407],[409,407,411],[411,410,412],[413,412,410],[415,409,414],[411,414,409],[410,416,413],[418,413,417],[416,417,413],[419,420,417],[418,417,420],[422,423,421],[424,421,423],[425,420,419],[427,421,426],[424,426,421],[429,425,428],[419,428,425],[431,427,430],[426,430,427],[428,432,429],[433,429,432],[435,431,434],[430,434,431],[437,435,436],[434,436,435],[439,437,438],[436,438,437],[441,439,440],[438,440,439],[443,152,442],[444,442,152],[442,444,445],[446,445,444],[447,448,443],[152,443,448],[444,152,449],[151,449,152],[445,446,450],[451,450,446],[446,444,452],[449,452,444],[144,148,143],[147,143,148],[450,451,453],[454,453,451],[451,446,455],[456,455,446],[446,452,456],[453,454,457],[458,457,454],[454,451,459],[455,459,451],[457,458,460],[461,460,458],[458,454,462],[459,462,454],[464,465,463],[466,463,465],[468,469,467],[470,467,469],[472,473,471],[474,471,473],[476,477,475],[478,475,477],[480,481,479],[482,479,481],[484,485,483],[486,483,485],[488,489,487],[490,487,489],[492,493,491],[494,491,493],[496,497,495],[498,495,497],[500,501,499],[502,499,501],[504,505,503],[506,503,505],[508,509,507],[510,507,509],[512,513,511],[514,511,513],[516,517,515],[518,515,517],[520,521,519],[522,519,521],[524,525,523],[526,523,525],[528,529,527],[530,527,529],[532,533,531],[534,531,533],[536,537,535],[538,535,537],[540,541,539],[542,539,541],[544,545,543],[546,543,545],[548,549,547],[550,547,549],[552,553,551],[554,551,553],[556,557,555],[558,555,557],[22,29,23],[25,23,29],[28,13,423],[559,415,28],[414,28,415],[559,28,422],[423,422,28],[560,204,34],[203,34,204],[560,34,561],[31,561,34],[561,31,206],[207,206,31],[251,249,562],[563,251,562],[250,251,563],[161,564,162],[565,162,564],[564,562,565],[566,565,562],[563,562,564],[250,563,567],[564,567,563],[567,564,568],[161,568,564],[569,158,253],[254,253,158],[568,161,569],[158,569,161],[571,457,570],[460,570,457],[572,453,571],[457,571,453],[573,450,572],[453,572,450],[575,576,574],[447,574,576],[577,445,573],[450,573,445],[574,447,578],[443,578,447],[579,442,577],[445,577,442],[578,443,579],[442,579,443],[576,145,447],[448,447,145],[146,145,580],[576,580,145],[580,576,156],[157,156,576],[252,255,581],[582,581,255],[581,582,583],[584,583,582],[583,584,585],[586,585,584],[585,586,258],[259,258,586],[588,257,587],[256,587,257],[262,588,263],[587,263,588],[582,255,589],[590,589,255],[582,589,584],[591,584,589],[584,591,586],[592,586,591],[586,592,259],[593,259,592],[259,593,256],[594,256,593],[256,594,587],[595,587,594],[100,596,101],[597,101,596],[460,461,570],[598,570,461],[461,458,597],[462,597,458],[598,461,596],[597,596,461],[108,598,109],[596,109,598],[163,166,599],[600,599,166],[170,601,167],[167,601,171],[602,171,601],[603,335,601],[340,601,335],[605,174,604],[177,604,174],[607,180,606],[183,606,180],[604,177,607],[180,607,177],[605,608,174],[169,174,608],[608,609,169],[170,169,609],[609,603,170],[601,170,603],[159,160,610],[611,610,160],[159,610,612],[614,599,361],[362,361,599],[606,183,615],[154,615,183],[614,616,599],[163,599,616],[616,613,163],[164,163,613],[610,611,164],[165,164,611],[615,154,612],[159,612,154],[273,617,274],[618,274,617],[620,271,619],[270,619,271],[303,618,304],[619,304,618],[617,620,618],[619,618,620],[621,309,302],[305,302,309],[319,622,317],[301,317,622],[622,621,301],[302,301,621],[613,610,164],[625,624,623],[623,626,625],[627,623,624],[624,628,627],[624,625,629],[629,630,624],[631,625,626],[628,624,630],[630,632,628],[630,629,633],[633,634,630],[626,635,631],[632,630,634],[634,636,632],[638,637,634],[634,633,638],[631,635,639],[639,640,631],[626,641,635],[637,642,636],[636,634,637],[637,638,643],[643,644,637],[645,638,633],[633,646,645],[640,639,647],[647,648,640],[626,649,641],[636,642,650],[650,651,636],[642,637,644],[644,650,642],[652,648,647],[649,626,653],[653,654,649],[655,652,647],[647,656,655],[653,657,654],[655,656,658],[658,659,655],[659,658,660],[660,661,659],[662,661,660],[660,663,662],[664,662,663],[664,663,665],[665,666,664],[666,665,667],[667,668,666],[671,670,669],[669,672,671],[672,669,673],[673,674,672],[670,676,675],[675,669,670],[677,670,671],[671,678,677],[674,673,679],[679,680,674],[669,675,681],[681,673,669],[675,676,682],[682,683,675],[684,676,670],[670,677,684],[685,677,678],[678,686,685],[680,679,687],[687,688,680],[673,681,687],[687,679,673],[681,675,683],[683,689,681],[683,682,690],[690,691,683],[682,676,692],[692,693,682],[694,684,677],[677,685,694],[695,685,686],[686,696,695],[688,697,680],[689,683,691],[691,698,689],[681,689,698],[698,699,681],[690,682,693],[693,700,690],[693,692,701],[701,702,693],[703,694,685],[685,695,703],[704,695,696],[696,705,704],[697,688,706],[706,707,697],[699,708,681],[700,693,702],[702,709,700],[702,701,710],[710,711,702],[712,703,695],[695,704,712],[707,706,713],[713,714,707],[715,708,699],[709,702,711],[711,716,709],[711,710,717],[717,718,711],[714,713,719],[719,720,714],[715,699,721],[716,711,718],[718,722,716],[724,723,720],[720,719,724],[715,721,725],[725,726,715],[726,725,727],[727,728,726],[728,727,729],[729,730,728],[731,730,729],[729,732,731],[735,734,733],[733,736,735],[734,738,737],[737,733,734],[740,739,734],[734,735,740],[738,742,741],[741,737,738],[739,742,738],[738,734,739],[744,743,739],[739,740,744],[742,746,745],[745,741,742],[743,746,742],[742,739,743],[748,747,743],[743,744,748],[746,750,749],[749,745,746],[747,750,746],[746,743,747],[751,747,748],[748,752,751],[753,749,750],[750,754,753],[754,750,747],[747,751,754],[755,751,752],[752,756,755],[757,753,754],[754,758,757],[758,754,751],[751,755,758],[760,759,755],[755,756,760],[759,757,758],[758,755,759],[760,756,761],[760,761,762],[762,763,760],[764,761,756],[756,765,764],[763,762,766],[766,767,763],[768,764,765],[765,769,768],[772,771,770],[770,773,772],[766,775,774],[774,151,147],[770,774,147],[776,772,773],[773,777,776],[780,779,778],[778,781,780],[776,777,782],[782,783,776],[784,781,778],[778,785,784],[788,787,786],[786,789,788],[792,791,790],[790,793,792],[791,795,794],[794,790,791],[797,796,791],[791,792,797],[796,798,795],[795,791,796],[800,799,796],[796,797,800],[799,801,798],[798,796,799],[803,802,799],[799,800,803],[802,804,801],[801,799,802],[806,805,802],[802,803,806],[805,807,804],[804,802,805],[810,809,808],[808,811,810],[811,808,812],[812,813,811],[815,814,809],[809,810,815],[813,812,816],[816,817,813],[819,818,814],[814,815,819],[817,816,820],[820,821,817],[823,822,818],[818,819,823],[821,820,824],[824,825,821],[824,827,826],[826,825,824],[830,829,828],[828,831,830],[831,828,832],[832,833,831],[834,830,831],[831,835,834],[833,832,836],[836,837,833],[835,839,838],[838,834,835],[837,836,840],[840,841,837],[843,842,839],[839,835,843],[841,840,844],[844,845,841],[847,846,842],[842,843,847],[845,844,848],[848,849,845],[847,851,850],[850,846,847],[848,853,852],[852,849,848],[850,851,854],[854,855,850],[853,857,856],[856,852,853],[857,859,858],[858,856,857],[859,861,860],[860,858,859],[860,861,862],[862,863,860],[863,862,864],[864,865,863],[865,864,866],[866,867,865],[867,866,868],[868,869,867],[870,869,868],[868,871,870],[870,871,872],[872,871,873],[873,874,872],[877,876,875],[875,878,877],[881,880,879],[879,882,881],[885,884,883],[883,886,885],[883,884,887],[887,888,883],[888,887,889],[889,890,888],[890,889,891],[891,892,890],[891,894,893],[893,892,891],[897,896,895],[899,898,895],[895,896,899],[895,898,900],[900,901,895],[898,899,902],[903,901,900],[900,904,903],[898,902,905],[905,906,898],[907,903,904],[904,908,907],[906,905,909],[909,910,906],[903,907,911],[911,912,903],[913,907,908],[908,914,913],[910,909,915],[915,916,910],[917,912,911],[911,918,917],[911,907,913],[919,903,912],[920,913,914],[914,921,920],[916,915,922],[922,923,916],[925,924,917],[917,918,925],[927,926,919],[919,912,927],[928,920,921],[921,929,928],[923,922,930],[930,931,923],[929,933,932],[932,928,929],[931,930,934],[934,935,931],[936,933,929],[929,937,936],[935,934,938],[938,939,935],[942,941,940],[944,943,936],[936,937,944],[939,938,945],[945,946,939],[940,941,947],[949,948,943],[943,944,949],[946,945,950],[950,951,946],[941,952,947],[954,953,948],[948,949,954],[951,950,955],[955,956,951],[952,958,957],[957,947,952],[960,959,953],[953,954,960],[956,955,961],[961,962,956],[957,958,963],[965,964,959],[959,960,965],[962,961,966],[966,967,962],[969,968,964],[964,965,969],[967,966,970],[972,971,968],[968,969,972],[970,966,973],[975,974,971],[971,972,975],[970,973,976],[977,974,975],[975,978,977],[976,973,979],[980,977,978],[979,981,976],[984,983,982],[982,985,984],[986,977,980],[976,981,987],[983,988,982],[989,986,980],[981,990,987],[982,988,991],[991,992,982],[993,986,989],[989,994,993],[990,993,994],[994,987,990],[991,988,995],[995,997,996],[996,991,995],[997,999,998],[998,996,997],[998,999,1000],[1000,1001,998],[1000,1003,1002],[1002,1001,1000],[1003,1005,1004],[1004,1002,1003],[1004,1005,1006],[1006,1007,1004],[1007,1006,1008],[1008,1009,1007],[1009,1008,1010],[1010,1011,1009],[1011,1010,1012],[1012,1013,1011],[1012,1015,1014],[1014,1013,1012],[1015,1017,1016],[1016,1014,1015],[1017,1019,1018],[1018,1016,1017],[1019,1021,1020],[1020,1018,1019],[1021,1023,1022],[1022,1020,1021],[1022,1023,1024],[1024,1025,1022],[1025,1024,1026],[1026,1027,1025],[1027,1026,1028],[1028,1029,1027],[1028,1031,1030],[1030,1029,1028],[1031,1032,1030],[1034,1033,1030],[1030,1032,1034],[1033,1034,1035],[1035,1036,1033],[1032,1038,1037],[1037,1034,1032],[1039,1033,1036],[1036,1041,1040],[1040,1039,1036],[1043,1042,1040],[1040,1041,1043],[1046,1045,1044],[1044,1047,1046],[1043,1048,1042],[1044,1050,1049],[1049,1047,1044],[1048,1052,1051],[1051,1042,1048],[1050,1054,1053],[1053,1049,1050],[1055,1051,1052],[1052,1056,1055],[1054,1058,1057],[1057,1053,1054],[1058,1060,1059],[1059,1057,1058],[1060,1062,1061],[1061,1059,1060],[1062,1064,1063],[1063,1061,1062],[775,1066,1065],[1065,1067,775],[1067,1065,1068],[1068,1069,1067],[1071,1070,1066],[1066,775,1071],[775,1067,1072],[1072,774,775],[1069,1068,1073],[1073,1074,1069],[1067,1069,1075],[1075,1072,1067],[771,767,766],[766,770,771],[1074,1073,1076],[1076,1077,1074],[1069,1074,1078],[1078,1079,1069],[1075,1069,1079],[1077,1076,1080],[1080,1081,1077],[1074,1077,1082],[1082,1078,1074],[1081,1080,1083],[1083,1084,1081],[1077,1081,1085],[1085,1082,1077],[1088,1087,1086],[1086,1089,1088],[1092,1091,1090],[1090,1093,1092],[1096,1095,1094],[1094,1097,1096],[1100,1099,1098],[1098,1101,1100],[1104,1103,1102],[1102,1105,1104],[1108,1107,1106],[1106,1109,1108],[1112,1111,1110],[1110,1113,1112],[1116,1115,1114],[1114,1117,1116],[1120,1119,1118],[1118,1121,1120],[1124,1123,1122],[1122,1125,1124],[1128,1127,1126],[1126,1129,1128],[1132,1131,1130],[1130,1133,1132],[1136,1135,1134],[1134,1137,1136],[1140,1139,1138],[1138,1141,1140],[1144,1143,1142],[1142,1145,1144],[1148,1147,1146],[1146,1149,1148],[1152,1151,1150],[1150,1153,1152],[1156,1155,1154],[1154,1157,1156],[1160,1159,1158],[1158,1161,1160],[1164,1163,1162],[1162,1165,1164],[1168,1167,1166],[1166,1169,1168],[1172,1171,1170],[1170,1173,1172],[1176,1175,1174],[1174,1177,1176],[1180,1179,1178],[1178,1181,1180],[652,645,646],[646,648,652],[636,651,1046],[1038,1182,651],[651,1037,1038],[651,1182,1045],[1045,1046,651],[827,1183,657],[657,826,827],[657,1183,1184],[1184,654,657],[654,1184,829],[829,830,654],[872,874,1185],[874,1186,1185],[874,873,1186],[1187,784,785],[785,1188,1187],[1185,1187,1188],[1188,1189,1185],[1185,1186,1187],[1186,873,1190],[1190,1187,1186],[1187,1190,1191],[1191,784,1187],[781,1192,876],[876,877,781],[784,1191,1192],[1192,781,784],[1080,1194,1193],[1193,1083,1080],[1076,1195,1194],[1194,1080,1076],[1073,1196,1195],[1195,1076,1073],[1199,1198,1197],[1197,1070,1199],[1068,1200,1196],[1196,1073,1068],[1070,1197,1201],[1201,1066,1070],[1065,1202,1200],[1200,1068,1065],[1066,1201,1202],[1202,1065,1066],[768,1199,1070],[1070,1071,768],[768,769,1203],[1203,1199,768],[1199,1203,779],[779,780,1199],[878,875,1204],[1204,1205,878],[1205,1204,1206],[1206,1207,1205],[1207,1206,1208],[1208,1209,1207],[1209,1208,881],[881,882,1209],[880,1211,1210],[1210,879,880],[1211,885,886],[886,1210,1211],[878,1205,1212],[1212,1213,878],[1212,1205,1207],[1207,1214,1212],[1214,1207,1209],[1209,1215,1214],[1215,1209,882],[882,1216,1215],[1216,882,879],[879,1217,1216],[1217,879,1210],[1210,1218,1217],[1219,723,724],[724,1220,1219],[1084,1083,1193],[1193,1221,1084],[1081,1084,1220],[1220,1085,1081],[1084,1221,1219],[1219,1220,1084],[1221,731,732],[732,1219,1221],[789,786,1222],[1222,1223,789],[1224,793,790],[1224,790,794],[794,1225,1224],[958,1226,1224],[1224,963,958],[797,1228,1227],[1227,800,797],[803,1230,1229],[1229,806,803],[800,1227,1230],[1230,803,800],[1231,1228,797],[797,792,1231],[1232,1231,792],[792,793,1232],[1226,1232,793],[793,1224,1226],[783,782,1233],[1233,1234,783],[1233,782,1235],[1222,1237,984],[984,985,1222],[806,1229,1238],[1238,777,806],[1239,1237,1222],[1222,786,1239],[1236,1239,786],[786,787,1236],[1234,1233,787],[787,788,1234],[777,1238,1235],[1235,782,777],[1240,896,897],[897,1241,1240],[894,1243,1242],[1242,893,894],[1241,926,927],[927,1242,1241],[1243,1240,1241],[1241,1242,1243],[932,1244,925],[925,928,932],[1245,942,940],[940,924,1245],[1244,1245,924],[924,925,1244],[1233,1236,787],[721,98,102],[725,721,102],[1015,392,394],[1017,1015,394],[930,307,311],[934,930,311],[980,357,366],[989,980,366],[668,45,43],[666,668,43],[1110,487,490],[1113,1110,490],[834,211,207],[830,834,207],[918,295,302],[925,918,302],[697,74,57],[680,697,57],[706,83,90],[713,706,90],[1148,525,524],[1147,1148,524],[883,260,263],[886,883,263],[908,285,291],[914,908,291],[1003,380,382],[1005,1003,382],[765,142,146],[769,765,146],[676,53,69],[692,676,69],[966,343,350],[973,966,350],[640,17,8],[631,640,8],[732,109,596],[1219,732,596],[1046,423,13],[636,1046,13],[1044,421,427],[1050,1044,427],[1099,476,475],[1098,1099,475],[1096,473,472],[1095,1096,472],[691,68,75],[698,691,75],[998,375,373],[996,998,373],[1061,438,436],[1059,1061,436],[1195,572,571],[1194,1195,571],[932,309,621],[1244,932,621],[1213,590,255],[878,1213,255],[1203,580,156],[779,1203,156],[1217,594,593],[1216,1217,593],[1075,452,449],[1072,1075,449],[992,369,359],[982,992,359],[1005,382,383],[1006,1005,383],[818,195,191],[814,818,191],[1116,493,492],[1115,1116,492],[756,133,142],[765,756,142],[900,277,281],[904,900,281],[147,151,143],[917,294,289],[912,917,289],[953,330,325],[948,953,325],[805,182,184],[807,805,184],[1241,618,303],[926,1241,303],[1125,502,501],[1124,1125,501],[911,288,295],[918,911,295],[959,336,330],[953,959,330],[912,289,304],[927,912,304],[1233,610,613],[1236,1233,613],[896,273,276],[899,896,276],[842,219,216],[839,842,216],[955,332,338],[961,955,338],[795,172,171],[794,795,171],[906,283,275],[898,906,275],[1177,554,553],[1176,1177,553],[989,366,371],[994,989,371],[749,126,122],[745,749,122],[1179,556,555],[1178,1179,555],[1043,420,425],[1048,1043,425],[660,37,40],[663,660,40],[666,43,41],[664,666,41],[735,112,117],[740,735,117],[956,333,328],[951,956,328],[854,231,232],[855,854,232],[1092,469,468],[1091,1092,468],[757,134,130],[753,757,130],[924,301,294],[917,924,294],[710,87,94],[717,710,94],[1047,424,423],[1046,1047,423],[810,187,192],[815,810,192],[661,38,36],[659,661,36],[1193,570,598],[1221,1193,598],[916,293,287],[910,916,287],[833,210,208],[831,833,208],[1007,384,381],[1004,1007,381],[667,44,45],[668,667,45],[680,57,51],[674,680,51],[1089,466,465],[1088,1089,465],[866,243,245],[868,866,245],[760,137,136],[759,760,136],[1232,609,608],[1231,1232,608],[1180,557,556],[1179,1180,556],[819,196,200],[823,819,200],[690,67,68],[691,690,68],[855,232,227],[850,855,227],[794,171,602],[1225,794,602],[952,329,335],[958,952,335],[1206,583,585],[1208,1206,585],[1087,464,463],[1086,1087,463],[821,198,194],[817,821,194],[1107,484,483],[1106,1107,483],[925,302,305],[928,925,305],[1059,436,434],[1057,1059,434],[942,319,318],[941,942,318],[658,35,37],[660,658,37],[984,361,360],[983,984,360],[983,360,365],[988,983,365],[707,84,74],[697,707,74],[822,199,195],[818,822,195],[816,193,197],[820,816,197],[1130,507,510],[1133,1130,510],[1145,522,521],[1144,1145,521],[996,373,368],[991,996,36