// ULTRASCOPE
// Split and add sockets and pins for printing on a Replicator size bed
// Gary A. Crowell Sr.  12/3/2015

// How to use:
//      Ultrascope files and instructions are available at openspaceagency.com
//		Place this file in the same folder as the ULTRASCOPE .stl files.
//		Open this file with OpenSCAD (download from OpenSCAD.org; very easy to install).
//      Uncomment one of the 'partnum' files so select one of the original Ultrascope files to split.
//		Change the 'pin' variable below to 1, to produce the pin side, or 0, to produce the socket side.
//		Adjust the 'margin' variable for a close pin/socket fit (use partnum = 0 to produce a test fit 
//          pin and socket).
//		Preview the file, F5 key (the view might look messed up, that's ok).
//		Render the file, F6 key (this might take awhile).
//		File/export the file as .stl.  A filename will appear at the top of the results that appear in the 
//			bottom console window.  It may be cut and pasted into the file save window.
// 		It is recommended to send the resulting .stl file through Netfabb online or other similar .stl
// 			repair program, as OpenSCAD produces a very verbose file whose size can be reduced considerably.


partnum = 0;	// Create .stl for pin/socket clearance test
//partnum = 1;	// 1-HEXAGON-1
//partnum = 2;	// 2-HEXAGON-2
//partnum = 3;  // 3-HEXAGON-2-CAP
//partnum = 4;	// 4-MIRROR-PROTECTING-LID
//partnum = 6;	// 6-HEXAGON-3
//partnum = 7;	// 7-HEXAGON-4
//partnum = 8;	// 8-HEXAGON-5
//partnum = 48;	// 48-ELECTRONICS-HOUSING

pin = 0;  		// set to 1 for pin side, 0 for socket side
helpdisks = 1;	// set to 1 to include helper disks (AKA mouse ears) at the split corners to help prevent lifting.


pindia = 5;		// pin diameter
margin = 0.2;  	// hole enlargement factor for close pin fit
pindepth = 3; 	// depth of the socket and length of the pin
helpdiskthick = 0.5;// thickness of the helper disk; normally you'd want at least two printed layers.
helpdiskdia = 15;	// diameter of the helper disks.


//render (convexity = 10) {
if (partnum == 0) {
	translate ([15, 0, 0]) cube (size = [10, 10, 10], center = true); 
	translate ([10, 0, 0]) rotate (a = [0, 90, 0]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30); 
	difference() { 
		translate ([-15, 0, 0]) cube (size = [10, 10, 10], center = true); 
		translate ([-10, 0, 0]) rotate (a = [0, 90, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30); 		
	}
	echo ("Export .stl as PIN-SOCKET-TEST.stl  ");
}

if (partnum == 1) {
	echo ("1-HEXAGON-1.stl");

	if (pin == 1) {
		difference() { // split pin side
			// translate and rotate the source object to the center of coordinate axis
			rotate (a = [0, 0.07, 0]) translate ([-2, 26, 0.05]) translate ([-2, 30.5, 0]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "1-HEXAGON-1.stl"); 
			// slice off half the part
			translate ([0, -100, 0]) cube (size = [200, 200, 100], center = true);
		} // difference
		// add pins
		translate ([84, pindepth, 10]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		translate ([84, pindepth, 25]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		translate ([-84, pindepth, 10]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		translate ([-84, pindepth, 25]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);	
		echo ("Export .stl as 1-HEXAGON-1-splitpin.stl  ");
	} else { 

		difference() { // split socket side
			// translate and rotate the source object to the center of coordinate axis
			rotate (a = [0, 0.07, 0]) translate ([-2, 26, 0.05]) translate ([-2, 30.5, 0]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "1-HEXAGON-1.stl"); 
			// slice off half the part
			translate ([0, 100, 0]) cube (size = [200, 200, 100], center = true);
			// add sockets
			translate ([84, pindepth, 10]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);
			translate ([84, pindepth, 25]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);
			translate ([-84, pindepth, 10]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);
			translate ([-84, pindepth, 25]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);
		} // difference	
		echo ("Export .stl as 1-HEXAGON-1-splitsoc.stl  ");
	} // else
	
	// helpdisk placement
	mouseear(90, 0, 0);
	mouseear(76, 0, 0);
	
} // partnum = 1
	
if (partnum == 2) {	
	echo ("2-HEXAGON-2.stl");

	if (pin == 1) {
		// translate and rotate the source object to the center of coordinate axis
		difference() { 
			union () { 
				rotate (a = [0, 0.07, 0]) translate ([-2, 26, 0.05]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "2-HEXAGON-2.stl"); 
				difference() { 
					union () { 
						translate ([80, 0, -60/2-0.5]) cube (size = [20, 30, 60], center = true); 
						translate ([-80, 0, -60/2-0.5]) cube (size = [20, 30, 60], center = true);
					} // union
					cylinder (h = 200, d = 153, center = true, $fn = 60);
				} // difference
			} // union
		translate ([0, -100, -40]) cube (size = [200, 200, 100], center = true); 			
		} // differrence	

		// add pins
		translate ([84, pindepth, -50]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		translate ([84, pindepth, -10]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		translate ([-84, pindepth, -50]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		translate ([-84, pindepth, -10]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);	
		echo ("Export .stl as 2-HEXAGON-2-splitpin.stl  ");
		
	} else { 

		// translate and rotate the source object to the center of coordinate axis
		difference() { 
			union () { 
				rotate (a = [0, 0.07, 0]) translate ([-2, 26, 0.05]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "2-HEXAGON-2.stl"); 
				difference() { 
					union () { 
						translate ([80, 0, -60/2-0.5]) cube (size = [20, 30, 60], center = true); 
						translate ([-80, 0, -60/2-0.5]) cube (size = [20, 30, 60], center = true);
					} // union
					cylinder (h = 200, d = 153, center = true, $fn = 60);
				} // difference
			} // union
			translate ([0, 100, -40]) cube (size = [200, 200, 100], center = true); 
			translate ([84, pindepth, -50]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
			translate ([84, pindepth, -10]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
			translate ([-84, pindepth, -50]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
			translate ([-84, pindepth, -10]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		} // differrence	
		echo ("Export .stl as 2-HEXAGON-2-splitsoc.stl  ");
	} // else 
	
	// helpdisk placement
	mouseear(90, 0, -helpdiskthick);
	mouseear(76, 0, -helpdiskthick);
	
} // partnum = 2

if (partnum == 3) {
	echo ("3-HEXAGON-2-CAP.stl");
	
	if (pin == 1) {
		difference() { // split pin side
			// translate and rotate the source object to the center of coordinate axis
			rotate (a = [0, 0.07, 0]) translate ([-2, 30.5, 74.6]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "3-HEXAGON-2-CAP.stl"); 
			// slice off half the part
			translate ([0, -100, 0]) cube (size = [200, 200, 100], center = true);
		} // difference
		// add pins
		translate ([82, pindepth, 1.8]) scale (v = [1.5, 1, 0.4]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		translate ([-82, pindepth, 1.8]) scale (v = [1.5, 1, 0.4]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);	
		echo ("Export .stl as 3-HEXAGON-2-CAP-splitpin.stl  ");
	} else { 

		difference() { // split socket side
			// translate and rotate the source object to the center of coordinate axis
			rotate (a = [0, 0.07, 0]) translate ([-2, 30.5, 74.6]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "3-HEXAGON-2-CAP.stl"); 
			// slice off half the part
			translate ([0, 100, 0]) cube (size = [200, 200, 100], center = true);
			// add sockets
			translate ([82, pindepth, 1.8]) scale (v = [1.5, 1, 0.4]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);
			translate ([-82, pindepth, 1.8]) scale (v = [1.5, 1, 0.4]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);
		} // difference	
		echo ("Export .stl as 3-HEXAGON-2-CAP-splitsoc.stl  ");
	} // else

	// helpdisk placement
	mouseear(90, 0, 0);
	mouseear(76, 0, 0);
	
} // partnum = 3

if (partnum == 4) {
	echo ("4-MIRROR-PROTECTING-LID.stl");
	
	if (pin == 1) {
		difference() { // split pin side
			// translate and rotate the source object to the center of coordinate axis
			rotate (a = [0, 0.07, 0]) translate ([-2, 30.5, 72.6]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "4-MIRROR-PROTECTING-LID.stl"); 
			// slice off half the part
			translate ([0, -100, 0]) cube (size = [200, 200, 100], center = true);
		} // difference
		// add pins
			translate ([0, pindepth, -7]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
			translate ([0, pindepth, -19]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);			
			translate ([-64, pindepth, -2.2]) scale (v = [2, 1, 0.5]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
			translate ([64, pindepth, -2.2]) scale (v = [2, 1, 0.5]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
			translate ([-30, pindepth, -2.2]) scale (v = [2, 1, 0.5]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
			translate ([30, pindepth, -2.2]) scale (v = [2, 1, 0.5]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);	
		echo ("Export .stl as 4-MIRROR-PROTECTING-LID-splitpin.stl  ");  
	} else { 

		difference() { // split socket side
			// translate and rotate the source object to the center of coordinate axis
			rotate (a = [0, 0.07, 0]) translate ([-2, 30.5, 72.6]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "4-MIRROR-PROTECTING-LID.stl"); 
			// slice off half the part
			translate ([0, 100, 0]) cube (size = [200, 200, 100], center = true);
			// add sockets
			translate ([0, pindepth, -7]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);
			translate ([0, pindepth, -19]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);			
			translate ([-64, pindepth, -2.2]) scale (v = [2, 1, 0.5]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);
			translate ([64, pindepth, -2.2]) scale (v = [2, 1, 0.5]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);
			translate ([-30, pindepth, -2.2]) scale (v = [2, 1, 0.5]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);
			translate ([30, pindepth, -2.2]) scale (v = [2, 1, 0.5]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, $fn = 30);			
		} // difference		
		echo ("Export .stl as 4-MIRROR-PROTECTING-LID-splitsoc.stl  ");
	} // else	
	
	// helpdisk placement
	mouseear(74, 0, -helpdiskthick);
	
} // partnum = 4
	
if (partnum == 6) {
	echo ("6-HEXAGON-3.stl");
	
	if (pin == 1) {
		// translate and rotate the source object to the center of coordinate axis
		difference() { 
			union () { 
				rotate (a = [0, 0.07, 0]) translate ([-2, 26, 169]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "6-HEXAGON-3.stl"); 
				difference() { 
					union () { 
						translate ([80, 0, -15/2-0.5]) cube (size = [20, 30, 15], center = true); 
						translate ([-80, 0, -15/2-0.5]) cube (size = [20, 30, 15], center = true);
					} // union
					cylinder (h = 200, d = 153, center = true, $fn = 60);
				} // difference
			} // union
		translate ([0, -100, -40]) cube (size = [200, 200, 100], center = true); 			
		} // differrence	

		// add pins
		translate ([84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		translate ([-84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);	
		echo ("Export .stl as 6-HEXAGON-3-splitpin.stl  ");
	} else { 

		// translate and rotate the source object to the center of coordinate axis
		difference() { 
			union () { 
				rotate (a = [0, 0.07, 0]) translate ([-2, 26, 169]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "6-HEXAGON-3.stl"); 
				difference() { 
					union () { 
						translate ([80, 0, -15/2-0.5]) cube (size = [20, 30, 15], center = true); 
						translate ([-80, 0, -15/2-0.5]) cube (size = [20, 30, 15], center = true);
					} // union
					cylinder (h = 200, d = 153, center = true, $fn = 60);
				} // difference
			} // union
			translate ([0, 100, -40]) cube (size = [200, 200, 100], center = true); 
			translate ([84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
			translate ([-84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		} // differrence		
		echo ("Export .stl as 6-HEXAGON-3-splitsoc.stl  ");
	} // else

	// helpdisk placement
	mouseear(90, 0, -helpdiskthick);
	mouseear(76, 0, -helpdiskthick);
	
} // partnum = 6

if (partnum == 7) {
	echo ("7-HEXAGON-4.stl");
	
	if (pin == 1) {

		// translate and rotate the source object to the center of coordinate axis
		difference() { 
			union () { 
			rotate (a = [0, 0.07, 0]) translate ([-2, 30.5, 308.34]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "7-HEXAGON-4.stl"); 
				difference() { 
					union () { 
						translate ([78, 0, -13/2-0.5]) cube (size = [20, 30, 13], center = true); 
						translate ([-78, 0, -13/2-0.5]) cube (size = [20, 30, 13], center = true);
					} // union
					cylinder (h = 200, d = 153, center = true, $fn = 60);
				} // difference
			} // union
		translate ([0, -100, -40]) cube (size = [200, 200, 100], center = true); 			
		} // differrence	

		// add pins
		translate ([84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		translate ([-84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);	
		echo ("Export .stl as 7-HEXAGON-4-splitpin.stl  ");
		
	} else { 

		difference() { 
			union () { 
			rotate (a = [0, 0.07, 0]) translate ([-2, 30.5, 308.34]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "7-HEXAGON-4.stl"); 
				difference() { 
					union () { 
						translate ([78, 0, -13/2-0.5]) cube (size = [20, 30, 13], center = true); 
						translate ([-78, 0, -13/2-0.5]) cube (size = [20, 30, 13], center = true);
					} // union
					cylinder (h = 200, d = 153, center = true, $fn = 60);
				} // difference
			} // union
			translate ([0, 100, -40]) cube (size = [200, 200, 100], center = true); 			
			translate ([84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
			translate ([-84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);			
		} // difference		
		echo ("Export .stl as 7-HEXAGON-4-splitsoc.stl  ");
		
	} // else

	// helpdisk placement
	mouseear(90, 0, -helpdiskthick);
	mouseear(76, 0, -helpdiskthick);
	
} // partnum = 7

if (partnum == 8) {
	echo ("8-HEXAGON-5.stl");
	
	if (pin == 1) {

		// translate and rotate the source object to the center of coordinate axis
		difference() { 
			union () { 
			rotate (a = [0, 0.07, 0]) translate ([-2, 30.5, 471.23]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "8-HEXAGON-5.stl"); 			
				difference() { 
					union () { 
						translate ([78, 0, -13/2-0.5]) cube (size = [20, 30, 13], center = true); 
						translate ([-78, 0, -13/2-0.5]) cube (size = [20, 30, 13], center = true);
					} // union
					cylinder (h = 200, d = 153, center = true, $fn = 60);
				} // difference
			} // union
		translate ([0, -100, -40]) cube (size = [200, 200, 100], center = true); 			
		} // differrence	

		// add pins
		translate ([84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
		translate ([-84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);	
		echo ("Export .stl as 8-HEXAGON-5-splitpin.stl  ");	
	
	} else { 
	
		difference() { 
			union () { 
			rotate (a = [0, 0.07, 0]) translate ([-2, 30.5, 471.23]) rotate (a = [45, 0, 0]) translate ([-60, 275, 120]) import (file = "8-HEXAGON-5.stl"); 			 
				difference() { 
					union () { 
						translate ([78, 0, -13/2-0.5]) cube (size = [20, 30, 13], center = true); 
						translate ([-78, 0, -13/2-0.5]) cube (size = [20, 30, 13], center = true);
					} // union
					cylinder (h = 200, d = 153, center = true, $fn = 60);
				} // difference
			} // union
			translate ([0, 100, -40]) cube (size = [200, 200, 100], center = true); 			
			translate ([84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);
			translate ([-84, pindepth, -8]) rotate (a = [90, 0, 0]) cylinder (h = pindepth*2, d = pindia, $fn = 30);			
		} // difference		
		echo ("Export .stl as 8-HEXAGON-5-splitsoc.stl  ");	
	
	} // else	
	
	// helpdisk placement
	mouseear(90, 0, -helpdiskthick);
	mouseear(76, 0, -helpdiskthick);
	
} // partnum = 8

else if (partnum == 48) {
	echo ("48-ELECTRONICS-HOUSING.stl");
	
	if (pin == 1) {
		difference() { // split pin side
			// translate and rotate the source object to the center of coordinate axis
			translate ([283, -214, -53]) rotate (a = [90, 0, 0]) translate ([-60, 275, 120]) import (file = "48-ELECTRONICS-HOUSING.stl"); 
			// slice off half the part
			translate ([0, 0, 0]) cube (size = [200, 220, 100], center = true);
		} // difference
		// add pins
		translate ([53, 12, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);
		translate ([-53, 12, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);
		translate ([53, 54, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);
		translate ([-53, 54, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);	
		translate ([53, 90, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);
		translate ([-53, 90, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);		
		translate ([53, -28, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);
		translate ([-53, -28, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);
		translate ([53, -70, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);
		translate ([-53, -70, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);	
		translate ([53, -90, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);
		translate ([-53, -90, 50]) cylinder (h = pindepth*2, d = pindia, center = true, $fn = 30);		
		echo ("Export .stl as 48-ELECTRONICS-HOUSING-splitpin.stl  ");

		// helpdisk placement	
		mouseear(-55, 95, 129.92);
		mouseear(55, 95, 129.92);
		mouseear(-55, -95, 129.92);
		mouseear(55, -95, 129.92);		
		
	} else { 

		difference() { // split socket side
			// translate and rotate the source object to the center of coordinate axis
			translate ([283, -214, -53.4]) rotate (a = [90, 0, 0]) translate ([-60, 275, 120]) import (file = "48-ELECTRONICS-HOUSING.stl"); 
			// slice off half the part
			translate ([0, 0, 100]) cube (size = [200, 220, 100], center = true);
			// add sockets
			translate ([53, 12, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);
			translate ([-53, 12, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);
			translate ([53, 54, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);
			translate ([-53, 54, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);
			translate ([53, 90, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);
			translate ([-53, 90, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);			
			translate ([53, -28, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);
			translate ([-53, -28, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);
			translate ([53, -70, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);
			translate ([-53, -70, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);	
			translate ([53, -90, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);
			translate ([-53, -90, 50]) cylinder (h = pindepth*2 + margin*2, d = pindia + margin, center = true, $fn = 30);				
		} // difference		
		echo ("Export .stl as 48-ELECTRONICS-HOUSING-splitsoc.stl  ");
	
		// helpdisk placement		
		mouseear(-55, 95, 0);
		mouseear(55, 95, 0);
		mouseear(-55, -95, 0);
		mouseear(55, -95, 0);		
	
	} // else	
	

	
} // partnum = 48

//} // render

module mouseear(xpos, ypos, zpos) {
	if (helpdisks == 1) {
		translate ([xpos, ypos, zpos]) cylinder (h = helpdiskthick, d = helpdiskdia, $fn = 20);
		translate ([-xpos, ypos, zpos]) cylinder (h = helpdiskthick, d = helpdiskdia, $fn = 20);
	}
}