
$fn=60;

baseLength = 180;
baseHeight = 5;
baseDepth = 70;
module base()
{
  difference()
  {
      union()
      {
          //main rect
          translate([0,2.5,0])
          cube([baseLength,baseDepth-2.5,baseHeight]);
          
          //extra spool holder space
          translate([145,68,0])
              cube([35,30,baseHeight]);
          
          //servo mount base
          translate([79.75,-21,0])
              cube([26,35,baseHeight]);
      }
      
      union()
      {
          //rectangular part to erase
          translate([-0.1,38,-0.1])
              cube([70,35,baseHeight+0.2]);
          
          //diagonal part to erase
          translate([80,38,-0.1])
          rotate([0,0,45])
              cube([45,35,baseHeight+0.2]);
          
          //style between spool holders
          for(i=[0:1:5])
          {
              translate([165-11.5*i,18.5,-0.1])
                  cube([7.5,60-10*i,baseHeight+0.2]);
          }
          
          //right side
          translate([-0.1,34,-0.5])
            cube([70,7,baseHeight+1]);
          
          //under the servo
          translate([88,-15,-0.1])
              cube([10,35,baseHeight+0.2]);
      }
  }
  
    //extension for larger electromagnets
    extDist=10;
    translate([-1*extDist,2.5,0])
        cube([extDist,31.5,baseHeight]);
  
}



base();