$fn=15;
cursorWidth = 7;
screwHoleRadius = 1.5;//works with 2.5mm screw
cursorThickness = 3.5;

module cursor()
{
  cursorHeight = 76;    //changing this requires more work.
  difference()
  {
    //for the servo link location
    x=-1;
    y=40;
    z=0;
    union()
    {
        //main body
        cube([cursorWidth,cursorHeight-2,cursorThickness]);
        //servo link
        translate([x,y,z])
            cylinder(cursorThickness,2.75,2.75);
        //pivot hole reinforcement
        translate([3.5,76,-0.1])
            cylinder(cursorThickness,4.5,4.5);
    }
    //pivot hole
    translate([cursorThickness,cursorHeight,-0.1])
        cylinder(cursorThickness,screwHoleRadius,screwHoleRadius); 
    //subtract servo link hole
    translate([x,y,z])
        cylinder(cursorThickness,1.3,1.3);
    //we can set the wire to any of these heights
    for(i=[0:1:13])
    {
      translate([cursorWidth/2,5*i+2,0])
        rotate([0,0,45])
          cube([2.5,2.5,cursorThickness]);

    }
  }
}
cursor();
