$fn=30;
//number of starter holes
numHoles = 10;
//thickness of the cylinder wall
wallThickness = 3;

//these are the vars used when you view spoolform.scad in openscad
$coilIR = 14;       //Coil Inner Radius. Can be 3 to about 35
$coilWidth = 15;    //3 to about 35
$endPlateRadius = $coilIR + 5;
$endPlateThickness = 2;
$starterHoleRadius = 1;

//dont edit:
deviceWidth = $coilWidth + $endPlateThickness;

module spoolform(coilIR,coilWidth,endPlateRadius,endPlateThickness,starterHoleRadius)
{
    //subtracting shaft keyhold from basic shape
    difference()
    {
        //main cylinder and end plate
        union()
        {
            //the core
            cylinder(deviceWidth,coilIR,coilIR);
            //end plate
            translate([0,0,coilWidth])
                cylinder(endPlateThickness,endPlateRadius,endPlateRadius);
        }

        //This 'difference' will make the shaft key hole
        difference()
        {
            //general radius
            cylinder(deviceWidth+10,5.5/2,5.5/2);
            //shaft shape
            difference()
            {
              cylinder(deviceWidth+1,5.5/2,5.5/2);
              translate([-3,-3.8/2,0])
                cube([deviceWidth+1,3.8,deviceWidth+1]);
            }
        }
        //plastic usage reduction in center
        translate([0,0,-.1])
            cylinder(deviceWidth/2,coilIR-wallThickness,coilIR-wallThickness);
        //starter holes
        diag = sqrt(2) * coilIR / 2 + 1;
        for(i=[1:1:numHoles])
        {
          rotate([0,0,360 * i / numHoles])
          translate([diag,diag,coilWidth])
              cylinder(endPlateThickness,starterHoleRadius,starterHoleRadius);
        }
    }
}

spoolform($coilIR,$coilWidth,$endPlateRadius,$endPlateThickness,$starterHoleRadius);
