use <pegs_holes.scad>;
baseDepth = 70;

module coilMotorBase()
{
  difference()
  {
      translate([4,7.5,0])
      cube([69,baseDepth/2-10,27]);

      //stylish material saver
      union()
      {
        //pillars
          translate([-2.5,0,0])
          for(k=[1:1:6])
          {
              translate([10*k+5,7,15])
              cube([5,26,4]);
              translate([10*k+5,7,10])
              cube([5,26,6]);
          }
          //peg mount endentations
          translate([8.5,20.5,25])
          rotate([-90,0,0])
              pegs();

          //mount screw holes
          translate([8.5,20.5,13])
          rotate([-90,0,0])
              holes();
          //tunnel
          translate([0,20,12.5])
          rotate([0,90,0])
              cylinder(75,9,9);
      }
  }
}
coilMotorBase();
