$fa=2;

//Variables you can change!
//These are all to modify the spoolform
coilIR = 14;       //Coil Inner Radius. 3 to about 35
coilWidth = 15;       //1 to about 35
endPlateRadius = coilIR + 5;
endPlateThickness = 2;
starterHoleRadius = 1;

//These are constants, don't change them
baseLength = 180;
baseHeight = 5;
baseDepth = 70;

use <base.scad>;
use <coilMotorBase.scad>;
difference()
{
  union()
  {
    //base
    base();
    //coil motor base
    translate([-13.5,0,0])
    coilMotorBase();
  }

  //coil motor base digout
  diameter = 16;
  translate([-7.5,20-diameter/2,-7.5])
    cube([65,diameter,20]);
}


//cursor axle base
translate([70,37.5,0])
    cube([22,12.5,baseHeight]);

use <spindleHolder.scad>

//spindle holders minus holes and tops
translate([155,3,0])
spindleHolder();

translate([175,97.5,0])
rotate([0,0,180])
spindleHolder();

use <spindle.scad>
//spindle(length,squareSide,radius)
spindleLength = 76;
translate([spindleLength+64.5,77.5,-1.25])
    spindle(spindleLength,5,sqrt(2)*5/2);



use <coilMotorMountModified.scad>;

translate([17.5,35,14])
rotate([90,0,90])
    coilMotorMount();


use <pegs_holes.scad>;

//124.5 is max safe x pos
//because my spool of wire has radius 40mm

use <guide.scad>;

//modified guide
use <guideModified.scad>
guideModified();

//rubberband hooks
use <hook.scad>

$pos=118;
translate([$pos,5,2.25])
hook();

translate([$pos+5,67,2.25])
rotate([0,0,180])
hook();

// THE SERVO MOUNT
use <servomount/RexsServoMount.scad>;
translate([102.5,28,4])
rotate([0,0,180])
scale(1.02) //servo mount size fix
RexsServoMount();

use <spoolform.scad>;
//z: coilWidth + endPlateThickness
translate([51.5,57.5,coilWidth+endPlateThickness])
rotate([180,0,0])
spoolform(coilIR,coilWidth,endPlateRadius,endPlateThickness,starterHoleRadius);

//cursor
use <cursor.scad>;
translate([142.5,85,0])
rotate([0,0,90])
cursor();


/* cursor axles (two of the same item) are carefully placed
with .15mm extra room for cursor */

//cursor axle
use <cursorAxle.scad>;
translate([70,45,10])
rotate([90,90,90])
cursorAxle();

//3.75 is thickness of axle thingy
//4 is thickness of cursor,
//adding .15 seems to work??
translate([70+3.75+4.15,45,10])
rotate([90,90,90])
cursorAxle();
