$fn = 20;

//PEGS
module peg()
{
    x=3.25;
    y=1.5;
    rotate([0,0,90])
    scale(1.5)
        difference()
        {
          translate([x,y,0.5])
            cylinder(1.5,2,4.5);
          translate([x,y,2.2])
            cylinder(1.5,2,4);
        }
}


module hole()
{
  //cone shaped cut out
    x=4.75;
    rotate([0,0,90])
    translate([x,2.1,0])
      cylinder(32,1.5,1.5);
  
  //area for screw shaft
    x=4.75;
    rotate([0,0,90])
    translate([x,2,2.2])
      cylinder(2.25,3.55,4);
}

//pegs
module pegs()
{
    for(i=[0:1:3])
    {
        translate([17*i,0,0])
        union()
        {
            translate([0,0,9])
            rotate([270,0,180])
                peg();
            rotate([270,0,180])
                peg();
        }
    }
}

module holes()
{
    for(i=[0:1:3])
    {
        translate([17*i,0,0])
        union()
        {
            translate([0,0,9])
            rotate([270,0,180])
                hole();
            rotate([270,0,180])
                hole();
        }
    }
}

difference()
{
  pegs();
  holes();
}