//http://www.wolframalpha.com/input/?i=Archimedes%E2%80%99+spiral
$fn=50;
spirals = 1;
a = 0.07;
incrementBy = 10;
height = 5;
wallThickness = 15;

render(convexity = 2)
difference(){
  union(){
    for(i=[0:360/spirals:360])
    rotate([0,0,i])
    for(t=[0:incrementBy:200])
    hull(){
      translate([a*t*cos(t),a*t*sin(t),0])
      cylinder(r=wallThickness/2,h=height);

      translate([a*(t+incrementBy)*cos(t+incrementBy),a*(t+incrementBy)*sin(t+incrementBy),0])
      cylinder(r=wallThickness/2,h=height);
    }
  }
  
  cylinder(d=7,h=15);
  
  translate([-27,-35,0])
  cube([15,50,10]);

  translate([-10,-15.5,0])
  cube([5,10,10]);
}

translate([-11,5,5/2])
rotate([0,0,-90])
render(convexity = 2)
difference(){
  minkowski(){
    cube([35,height-1,20-5]);
    rotate([90,0,0])
    cylinder(d=5,h=1);
  }
  
  translate([23,5,12.5])
  rotate([90,0,0])
  cylinder(d=4, h=10);

  translate([33,5,2.5])
  rotate([90,0,0])
  cylinder(d=4, h=10);
}