/*
duck_solid.stl was created with AutoDesk's 123D-Catch from a
brass bookend obtained at a thrift store.

This is an openSCAD program which hollows duck_solid.stl,
adds a screw closure to the bottom, and also converts it to
two different dime banks.  Ourpur files are: 
duck_paper_weight.stl, duck_dime_bank.stl and duck_visible_bank.stl.



A decimated version of duck_solid.stl was created with MeshLab and
an ascii version of the stl file output.  Coordinates, triangles,
and edges were extracted from the ascii file and are included in
the openSCAD code as "cords", "faces", and "bonds".  The files were
used to create and help center the form subtracted from
duck_solid.stl.  Two files were created by this subtraction:
duck_paper_weight.stl and duck_dime_bank.stl.

Finally the outer surface of duck_dime_bank.stl was replaced with a
wire frame model using the files "cords" and "bonds" to make
duck_visible_bank.stl

Three openSCAD outputs, (for mark = 4, 5, and 6) illustrate how these
files aided the construction of the paper weight and banks.

Threads.scad has to be present in the same directory to
run the code.  It's due to Dan Kirshner and is available at
http://dkprojects.net/openscad-threads/

Threads.scad makes the screw fitting at the bottom of the hollowed
versions of duck_solid.stl and is also used to make the threaded closure.

The internal screw in the output files was created with a diameter
of 25 mm - The external screw in the closures uses a smaller diameter
so as to make the clearance for the screw - Works very well, both objects
were printed on a Replicator using PLA with 0.3 mm layers.

Closures made using diameters of 23, 23.25, and 23.5 mm  are included.
Choose the one that fits best.  Adjustments may have to be made for some
printers and software.

It's easy to change the size of the closure - The existing
closures can be made smaller or larger over a small range by
scaling x and y and leaving z unchanged - or one can change the
diameter of the closure in the code below.  It's currently set
at 23.25 mm. (mark = 7)

Setting mark to 1,2,3 or 7 makes the paper weight, banks, and
closure  i.e.


 if mark = 1  -  makes the hollow duck with threaded hole
                 serves as a paperweight - add 70 or so pennies.

 if mark = 2  -  adds a slot to make a dime bank, takes dimes
                 and pennies but not nickels or quarters

 if mark = 3  -  makes a wire frame version of the dime bank

 if mark = 4 -  shows form to be subtracted from the solid duck
                colored blue - used to check translations -
                 rotations

 if mark = 5  -  checks position of the dime slot

 if mark = 6  -  shows the identifications of the coordinates
                 which make up the wire frame version -
                 used to delete unwanted bonds and add an
                 additional bond for duck_visible_bank.stl 

 if mark = 7  -  makes the closure

 PCM  September 2016

*/

font = "Liberation Sans";
use <threads.scad>

mark = 3;


if (mark==1)

difference()
{
difference()
{
import("duck_solid.stl");
difference()
{
translate([5,0,2])
scale([0.8,0.8,.97])
polyhedron(cords,faces);
translate([-15,0,100])
 rotate([0,30,0])   // rotation prevents internal support
cube([60,60,80],center=true);
    translate([10,0,-53])
    cube([80,80,80],center=true);

}
}
  translate([10,0,-20])
 metric_thread (diameter=25, pitch=2, length=10, internal=true);
}


else


if (mark==2)

difference()
{
difference()
{
import("duck_solid.stl");
difference()
{
translate([5,0,2])
scale([0.8,0.8,.97])
polyhedron(cords,faces);
translate([-15,0,100])
 rotate([0,30,0])  // rotation prevents internal support
cube([60,60,80],center=true);
    translate([10,0,-53])
    cube([80,80,80],center=true);

}
}
 translate([15,0,113])
    rotate([0,-20,0])
    cube([20,3,50],center=true);
  translate([10,0,-20])
 metric_thread (diameter=25, pitch=2, length=10, internal=true);
}


else


  if (mark==3)


//  makes a wire frame versione
//  of the dime bank

difference()
{

 union()
 {

       color("red")
     translate([0,0,1])
//wire_frame(bonds,cords,1,6);
wire_frame(bonds,cords,0.75,8);
  difference()
{
color("blue")
polyhedron(cords,faces);
    translate([0,0,187])
    cube([400,400,400],center=true);
}
}
  translate([10,0,-20])
 metric_thread (diameter=25, pitch=2, length=10, internal=true);
}

 else

if (mark==4)


//  shows the form of the hollow space
//  compared to the wire frame

 union()
 {
    color("red")
wire_frame(bonds,cords,.5,6);

  difference()
{
translate([5,0,2])
scale([0.8,0.8,.97])
color("blue")
polyhedron(cords,faces);
translate([-15,0,100])
 rotate([0,30,0])
cube([60,60,80],center=true);
    translate([10,0,-53])
    cube([80,80,80],center=true);
}
}


 else


 if (mark==5)

  // checks the dime slot position

  union()
{
 difference()
{
translate([5,0,2])
scale([0.8,0.8,.97])
polyhedron(cords,faces);
translate([-15,0,100])
 rotate([0,30,0])
cube([60,60,80],center=true);
    translate([10,0,-53])
    cube([80,80,80],center=true);
}
     translate([15,0,113])
    rotate([0,-20,0])
    cube([20,3,50],center=true);
}



else


if (mark==6)

//  shows the numbers that identify the coordinates
//   for the wire frame

union()
 {


     for ( j =[0:204])
  {
            x = cords[[j][0]];


     translate([0,0,1])
     translate(x)
    color("black")
     rotate([-acos(x[2]/sqrt(x[0]*x[0] + x[1]*x[1] + x[2]*x[2])),0,-atan2(x[0],x[1])])
    {text(text = str(j),size =3, font ="font",halign = "center", valigh = "baseline");}
  }



    color("red")
     wire_frame(bonds,cords,.5,4);
}


else

if (mark==7)

// makes the closure

difference()
{
    metric_thread (diameter=23.25, pitch=2, length=5, internal=false, n_starts=1,
                      thread_size=-1, groove=false, square=false, rectangle=0);

  translate([0,0,7])
 cube(size=[20,3,10],center=true);
 translate([0,0,7])
 cube([3,20,10],center=true);
}


else

{}


module wire_frame(edges,points,rb,fc)
{

/* edges -  list of cylinders - rods
   points - list of coordinates - that edges points to
   rb = radius of cylinders - fc - $fn for cylinders
*/

for (i = [0:len(edges)-1])
{
pp = points[edges[i][0]];
qq = points[edges[i][1]];
tx = (qq[0] + pp[0])/2;
ty = (qq[1] + pp[1])/2;
tz = (qq[2] + pp[2])/2;
ax = qq[0] - pp[0] ;
ay = qq[1] - pp[1];
az = qq[2] - pp[2];
translate(v=[tx,ty,tz])
rotate(a = [-acos(az/sqrt(ax*ax+ay*ay+az*az)), 0, -atan2(ax, ay)])
cylinder(r=rb,h=sqrt(ax*ax+ay*ay+az*az),center=true,$fn=fc);
}
}




        cords = [
                 [   1.67325, -16.95473,   4.84857],
                 [  -3.46191, -21.02821,  -3.70678],
                 [   6.90990, -22.23167,   1.39359],
                 [  21.39612,  14.05796,  15.72808],
                 [  32.76830,  11.11837,  15.69087],
                 [  27.65457,  16.46806,   9.52330],
                 [  17.04964,  -5.84826,  80.92518],
                 [  23.38272,  -7.42837,  81.13451],
                 [  16.40335,  -8.22118,  92.42599],
                 [  13.58214,  -3.25254,  79.20163],
                 [  10.53436,  -3.94528,  88.45015],
                 [  38.27357,  -0.93924,  66.03793],
                 [  35.36671,   4.46831,  76.30162],
                 [  38.76567,   0.15214,  82.03295],
                 [  -6.62316,  -3.66130,   5.43492],
                 [  -5.71301,   8.16672,   6.35412],
                 [ -14.38021,   1.03352,  -4.77715],
                 [ -16.84891,   2.40998, -10.63064],
                 [ -13.46580,  13.80132,  -8.66759],
                 [  -2.79105,  10.95610, 113.15582],
                 [  -3.32286,  10.95089,  99.91426],
                 [  -8.03052,   8.01008, 105.95341],
                 [  20.61300,  11.01864, 111.18652],
                 [  30.84407,   6.97220, 108.73310],
                 [  29.58045,   8.50695, 102.90248],
                 [  18.40772,   9.67081,  96.87126],
                 [  11.24049,  13.02014, 109.53475],
                 [  19.20454,  11.46684, 104.39641],
                 [  26.86162,   6.45126, 115.40702],
                 [  25.18914,   0.14394, 121.03440],
                 [  34.26794,   0.16908, 111.15425],
                 [  31.23558,   6.68276,  80.70416],
                 [  27.63044,   7.30020,  59.16429],
                 [  25.04374,   7.91375,  74.13906],
                 [  36.02233,  -4.38167,  63.73119],
                 [  34.02420,  -5.88831,  52.71543],
                 [  38.21755,  -3.35409,  46.90934],
                 [   1.28938,   1.41309,  15.70880],
                 [  -0.98492,   3.62264,  11.88805],
                 [   0.88211,  -6.31514,  11.74457],
                 [  20.03365,   8.95623,  42.01122],
                 [  26.87987,   8.35575,  42.93309],
                 [  25.87477,  11.45508,  24.30998],
                 [  33.34024,   6.57602,  40.10946],
                 [  10.77199,  -3.72527,  46.98980],
                 [   8.27764,  -0.24404,  41.75862],
                 [   7.96589,  -3.82248,  30.92662],
                 [  17.89528,  -8.80979,  37.43705],
                 [  20.60993,  -7.39319,  54.27353],
                 [  15.44320,  -5.79198,  53.94046],
                 [  36.48073,  -6.12651,  33.05354],
                 [  27.28651, -10.58993,  25.20190],
                 [  33.26602, -10.94237,  15.12912],
                 [  40.18990,   1.78494,  25.40959],
                 [  39.77226,  -2.57181,  29.81085],
                 [  40.65881,  -4.77894,  16.43815],
                 [  12.35612,  28.93118, -11.62444],
                 [   9.79422,  24.82634,  -0.18862],
                 [  27.34825,  24.97705,  -3.01137],
                 [   7.40803,   6.66077, 124.96577],
                 [  -1.21474,   5.71570, 123.52692],
                 [   8.30476,   0.20269, 126.90343],
                 [  -7.22629,   6.44968, 116.15866],
                 [   3.03626,  10.88054, 118.60123],
                 [  -3.29376,   9.28551,  96.90859],
                 [ -11.27978,   8.74242,  98.15711],
                 [   6.25649, -11.64685, 108.41354],
                 [  11.71693,  -9.57703, 118.68291],
                 [   0.85982,  -6.60733, 119.71363],
                 [ -39.50541,   3.65820,  84.52496],
                 [ -41.28451,   6.87265,  88.26411],
                 [ -33.74317,   9.54630,  87.45122],
                 [ -23.07881,   6.40452,  94.39624],
                 [ -11.71889,  -5.78149,  93.65075],
                 [ -29.55075,  -0.36123,  85.43192],
                 [ -13.30407,  -0.03278,  90.22306],
                 [  26.12926,   8.58208,  91.52210],
                 [  28.94267,  -8.28717,  92.31591],
                 [  30.33990,  -7.37670, 107.53483],
                 [  19.39215, -10.99519, 108.50414],
                 [  13.83234,   7.36826,  89.63945],
                 [  14.69608,  11.76071,  97.26294],
                 [  34.31546,   4.83464,  60.90834],
                 [  11.21904,   2.89250,  53.49975],
                 [  12.52888,  -1.81008,  62.75013],
                 [  36.31216,   3.28179,  57.08038],
                 [  38.45438,   1.39408,  43.35687],
                 [   7.29454,  14.69699,  11.42713],
                 [  -2.38328,  17.17862,   2.98097],
                 [   7.43891, -13.41803,  10.56495],
                 [   6.68339,  -9.29757,  15.53267],
                 [ -15.85389,  -9.27365, -14.17885],
                 [ -11.38858, -10.95070,  -3.84099],
                 [  18.20545,  11.28108,  26.79740],
                 [  10.17024,  12.68799,  15.67664],
                 [   3.91300,   7.39531,  15.81714],
                 [  13.09549,  -8.53940,  29.91086],
                 [  16.21468, -15.61853,  10.03084],
                 [  15.19225, -12.99189,  14.90372],
                 [  36.71654,   5.17293,  34.19355],
                 [  30.66667,  -7.78265,  39.82608],
                 [  19.49033,  21.83553,   4.55646],
                 [  28.83662,  27.20926, -11.68576],
                 [ -12.08164,   2.28120, 108.18753],
                 [ -19.38805,   2.45931,  99.31384],
                 [   6.87158,  -4.71370, 124.60888],
                 [  16.68306,  -4.16170, 123.77384],
                 [  18.13592,   3.37221, 124.57824],
                 [  36.41158,   3.73832, 101.69161],
                 [  36.29588,   4.44030,  91.11328],
                 [  33.14838,  -6.22616,  84.72680],
                 [  37.88205,  -1.82202,  99.18616],
                 [  35.28138,  -5.09632,  97.14853],
                 [  19.71739,   8.18557,  83.37977],
                 [  16.68923,   6.89651,  57.76698],
                 [  21.27528,   7.70825,  65.52453],
                 [  10.40699,   7.03880,  32.94403],
                 [  13.44501,   5.30294,  54.79856],
                 [  -8.40629,  15.89813,  -1.92476],
                 [  -5.76380,  24.61938, -14.64300],
                 [  -3.52461,  23.24383,  -6.17200],
                 [   3.36731,  28.10248, -10.84942],
                 [  24.55261, -13.02649,  14.77996],
                 [  41.09588,  -9.50593, -11.00720],
                 [  39.45446, -18.14309,  -1.83872],
                 [  38.48863, -23.46725, -10.44759],
                 [ -26.41232,   2.92343,  94.85351],
                 [ -40.82677,  -0.52589,  88.41856],
                 [  -4.99669,   0.58798, 122.10731],
                 [  -7.33027,  -3.75868, 114.36434],
                 [ -15.01050,  -4.46520,  97.59359],
                 [ -19.67674,  -3.64490,  93.90910],
                 [  14.03907,  10.26821, 119.03738],
                 [   5.15920,  21.33528,   3.16388],
                 [   3.82688, -26.13112,  -6.28700],
                 [  -0.46360, -26.96905, -13.70750],
                 [  39.28713,  -8.14621,  14.64804],
                 [  29.36602, -14.24421,  12.12593],
                 [  40.18249, -11.11479,   6.43514],
                 [  40.85999,   9.10028,  11.19267],
                 [  41.40082,  10.64762,   4.47328],
                 [  37.71977,  13.36966,   8.11177],
                 [ -31.05481,   4.21232,  84.21811],
                 [   4.28625,   2.79546,  89.36480],
                 [   9.65536,   1.72973,  86.64724],
                 [  12.71982,   2.67694,  71.01347],
                 [  11.53258,   1.89300,  79.71767],
                 [   0.95041,  -6.93431,  93.80473],
                 [  19.96942,  -6.67047,  68.32825],
                 [  -6.40404, -14.22854,   0.23250],
                 [   6.05932,  13.23020,  98.73706],
                 [   3.94447,  13.35741, 107.83371],
                 [  16.23351,   6.32915,  73.08257],
                 [  15.33356,  -4.69538,  65.68128],
                 [   7.08494,   3.95289,  31.06508],
                 [  -4.68507,  -8.73011, 107.56818],
                 [  24.16227,  -6.06359, 118.08085],
                 [  16.44176, -11.23217,  22.67626],
                 [  37.64416,  18.55080,   1.40121],
                 [  41.59153,  -4.37135, -10.05615],
                 [  28.22395, -25.49632,  -6.41442],
                 [  34.09164, -20.76108,  -0.56095],
                 [  18.82149, -22.26357,   1.51830],
                 [  -1.14832, -10.21316, 101.63078],
                 [  -4.12254,  -6.13011,  94.23465],
                 [ -23.84692,   6.81032,  86.98801],
                 [  -4.94191,   5.17063,  91.96063],
                 [  32.63103, -14.28561,   8.35978],
                 [  -9.59993,  -3.25743, 107.10906],
                 [  -3.15924,   1.23454,  90.94329],
                 [   2.64017,  -0.97382,  19.45530],
                 [  17.58796, -10.93461, 104.08229],
                 [  27.04916,  -7.32442,  60.33654],
                 [ -17.62559,   8.25981,  90.72012],
                 [  12.66989, -10.83796,  95.90492],
                 [  25.31783,  -8.62703,  41.26749],
                 [ -17.44699,   8.72774, -18.64606],
                 [  11.58401, -27.94434,  -7.62672],
                 [  26.78306, -27.88280, -13.45659],
                 [  40.20463,   5.95069,  15.30593],
                 [  13.14114,  17.74851,   9.64448],
                 [   8.72110, -12.14394, 103.09315],
                 [  30.95821,  -6.76350,  75.76837],
                 [  12.64599,   9.79591,  27.82484],
                 [  -8.80225, -20.86817, -14.12029],
                 [  -3.77584, -25.79564, -18.64553],
                 [  38.77419,  22.87579,  -8.22066],
                 [   4.19613,  29.19117, -18.64891],
                 [  19.96749, -29.24844, -18.53423],
                 [   6.61939, -29.11824, -18.64732],
                 [  41.14963,  17.28169,  -2.96959],
                 [  41.71627,  13.87887, -12.48305],
                 [ -28.08312,  -3.13631,  87.67078],
                 [ -38.58677,  -2.53229,  87.15996],
                 [  40.42126,  22.93046, -18.64528],
                 [  37.13274, -25.35611, -18.64571],
                 [  40.75139,  14.38885, -18.64606],
                 [  41.14521,  -0.62289, -18.64606],
                 [  39.85486, -14.34621, -18.64606],
                 [ -15.86970,  -9.16883, -18.64606],
                 [ -14.15393,  15.15996, -18.64606],
                 [  19.69702,  29.15275, -18.64619],
                 [  31.06621,  27.00467, -18.64618],
                 [ -12.40661, -16.37338, -18.64606],
                 [  -7.19551,  23.03292, -18.64606],
                ];


           faces = [
                 [    1,    0,    2],
                 [    4,    3,    5],
                 [    7,    6,    8],
                 [    6,    9,   10],
                 [   12,   11,   13],
                 [   15,   14,   16],
                 [   16,   17,   18],
                 [   20,   19,   21],
                 [   23,   22,   24],
                 [   26,   25,   27],
                 [   29,   28,   30],
                 [   32,   31,   33],
                 [   35,   34,   36],
                 [   38,   37,   39],
                 [   32,   40,   41],
                 [   42,    4,   43],
                 [   45,   44,   46],
                 [   48,   47,   49],
                 [   51,   50,   52],
                 [   54,   53,   55],
                 [   57,   56,   58],
                 [   60,   59,   61],
                 [   62,   19,   63],
                 [   65,   64,   20],
                 [   67,   66,   68],
                 [   70,   69,   71],
                 [   70,   71,   72],
                 [   74,   73,   75],
                 [   27,   22,   26],
                 [   76,   31,   24],
                 [   78,   77,   79],
                 [   81,   80,   25],
                 [   33,   31,   76],
                 [   82,   31,   32],
                 [   32,   41,   43],
                 [   45,   83,   84],
                 [   82,   43,   85],
                 [   36,   11,   86],
                 [   88,   87,   15],
                 [   90,   89,   39],
                 [   92,   91,   16],
                 [    3,   93,   94],
                 [   94,   95,   87],
                 [    4,   42,    3],
                 [   46,   96,   90],
                 [   98,   97,   89],
                 [   99,   86,   85],
                 [   50,  100,   36],
                 [   57,   58,  101],
                 [   56,  102,   58],
                 [   21,   62,  103],
                 [  104,   21,  103],
                 [   68,  105,   67],
                 [  107,  106,   61],
                 [   27,   76,   24],
                 [  108,   24,  109],
                 [  111,  110,  112],
                 [   76,  113,   33],
                 [  115,  114,   40],
                 [  116,  114,  117],
                 [   82,   32,   43],
                 [   18,  118,   15],
                 [  120,  119,  121],
                 [   96,   46,   44],
                 [   52,  122,   51],
                 [  124,  123,  125],
                 [   70,  126,  127],
                 [  103,  128,  129],
                 [   72,  104,  126],
                 [   65,   20,   21],
                 [  131,  130,   73],
                 [   63,  132,   59],
                 [  132,   63,   26],
                 [  107,  132,   28],
                 [  132,   22,   28],
                 [   28,   23,   30],
                 [  108,   23,   24],
                 [   78,   30,  111],
                 [   15,   16,   18],
                 [   88,  120,  133],
                 [  120,   57,  133],
                 [    1,  134,  135],
                 [   52,  136,  137],
                 [  138,  123,  124],
                 [  140,  139,  141],
                 [  142,   71,   69],
                 [   80,  143,  144],
                 [   83,  117,  145],
                 [  113,  144,  146],
                 [  147,  144,  143],
                 [   48,   49,  148],
                 [   14,  149,   92],
                 [  150,   26,  151],
                 [  145,  152,  146],
                 [   80,  113,   25],
                 [  148,   49,  153],
                 [   40,   93,   41],
                 [  154,   95,  116],
                 [   54,   50,   36],
                 [   66,  155,   68],
                 [   67,  156,   78],
                 [  157,   51,  122],
                 [   58,  158,    5],
                 [  159,  123,  138],
                 [  161,  160,  162],
                 [  163,  147,  164],
                 [  165,   71,  142],
                 [  156,   30,   78],
                 [   80,   81,  150],
                 [  166,   80,  150],
                 [  114,  116,   40],
                 [  150,   64,  166],
                 [   16,   91,   17],
                 [  162,  167,  161],
                 [  155,  168,  129],
                 [   44,   45,   84],
                 [   75,  164,  169],
                 [   75,  169,  166],
                 [  105,   68,  128],
                 [  154,  170,   37],
                 [  149,   39,    0],
                 [  129,  168,  103],
                 [   77,    7,  171],
                 [  148,    7,  172],
                 [  154,   37,   95],
                 [  118,   18,  120],
                 [   71,  165,  173],
                 [   23,   28,   22],
                 [   67,  106,  156],
                 [  147,  163,  174],
                 [  111,   30,  108],
                 [  108,   13,  111],
                 [   10,    9,  144],
                 [  171,    7,    8],
                 [  146,  144,    9],
                 [  145,  117,  152],
                 [    9,   84,  146],
                 [  175,   47,   48],
                 [   85,   86,   11],
                 [   14,   39,  149],
                 [   38,   39,   14],
                 [  170,   90,   39],
                 [   17,  176,   18],
                 [  116,  117,  154],
                 [  154,   83,   45],
                 [  170,   45,   46],
                 [  178,  177,  160],
                 [   35,   36,  100],
                 [   50,   51,  100],
                 [  179,   55,   53],
                 [   94,   87,  180],
                 [   97,  137,  167],
                 [   19,   26,   63],
                 [  129,  128,   68],
                 [  127,   69,   70],
                 [   26,   22,  132],
                 [   61,  105,  128],
                 [   67,   79,   66],
                 [  147,   10,  144],
                 [  181,  171,  174],
                 [  171,   79,   77],
                 [  146,   84,  145],
                 [    6,   10,    8],
                 [  153,    9,    6],
                 [  110,  182,   77],
                 [  182,    7,   77],
                 [  153,    6,  148],
                 [    7,  148,    6],
                 [  182,   35,  172],
                 [  115,   32,   33],
                 [  172,    7,  182],
                 [  152,  114,  115],
                 [   32,  115,   40],
                 [  116,  183,   40],
                 [   84,   49,   44],
                 [   48,  172,  175],
                 [   12,   13,  109],
                 [   12,   85,   11],
                 [   11,   34,   13],
                 [  182,   34,   35],
                 [  172,   35,  100],
                 [   88,  133,   87],
                 [   14,   15,   38],
                 [   87,   95,   38],
                 [   37,  170,   39],
                 [    1,   92,  149],
                 [  185,  184,  135],
                 [  117,   83,  154],
                 [   40,  183,   93],
                 [   93,  183,   94],
                 [   93,   42,   41],
                 [   41,   42,   43],
                 [   94,  180,    3],
                 [   93,    3,   42],
                 [  141,    4,    5],
                 [    5,  180,  101],
                 [   49,   96,   44],
                 [   96,   49,   47],
                 [  175,  157,   47],
                 [  157,  175,   51],
                 [  100,  175,  172],
                 [   53,   54,   86],
                 [  136,   52,   55],
                 [   57,  121,   56],
                 [  158,   58,  186],
                 [  121,  187,   56],
                 [  138,   55,  159],
                 [    2,  177,  134],
                 [  177,  162,  160],
                 [  177,  188,  189],
                 [  104,   65,   21],
                 [   20,  151,   19],
                 [   26,   19,  151],
                 [  151,   64,  150],
                 [  151,   20,   64],
                 [  104,  168,  130],
                 [  155,   66,  163],
                 [  147,  169,  164],
                 [  163,   73,  130],
                 [  164,   73,  163],
                 [   73,  164,   75],
                 [  168,  155,  163],
                 [  142,   74,   75],
                 [  165,   75,  173],
                 [  107,   61,   59],
                 [  128,   60,   61],
                 [   59,   60,   63],
                 [  106,  107,   29],
                 [   24,   22,   27],
                 [  171,  181,   66],
                 [   66,   79,  171],
                 [  181,  174,  163],
                 [    8,  174,  171],
                 [   77,  112,  110],
                 [  152,  115,  113],
                 [   76,   25,  113],
                 [  115,   33,  113],
                 [  114,  152,  117],
                 [  145,   84,   83],
                 [   31,   82,   12],
                 [    9,  153,   84],
                 [   49,   84,  153],
                 [   31,   12,  109],
                 [  110,   13,   34],
                 [  110,   34,  182],
                 [   82,   85,   12],
                 [   87,   38,   15],
                 [   90,  170,   46],
                 [  120,   18,  119],
                 [   88,   15,  118],
                 [  187,  121,  119],
                 [  184,   91,   92],
                 [    1,  184,   92],
                 [    1,    2,  134],
                 [  184,    1,  135],
                 [  133,  180,   87],
                 [  116,   94,  183],
                 [    4,   99,   43],
                 [    3,  180,    5],
                 [   45,  170,  154],
                 [  157,   96,   47],
                 [  136,  167,  137],
                 [   36,   86,   54],
                 [  179,   99,    4],
                 [  139,  140,   55],
                 [  138,  136,   55],
                 [   50,   54,   55],
                 [   58,    5,  101],
                 [  102,  186,   58],
                 [  140,  190,  191],
                 [  191,  159,  140],
                 [  188,  177,  178],
                 [  189,  135,  177],
                 [  160,  125,  178],
                 [  127,  126,  131],
                 [   72,  126,   70],
                 [  131,  192,  193],
                 [   60,  128,   62],
                 [  168,  104,  103],
                 [   74,  192,   73],
                 [  107,   59,  132],
                 [  105,  106,   67],
                 [   68,  155,  129],
                 [   26,  150,   81],
                 [   25,   26,   81],
                 [   25,   76,   27],
                 [   30,   23,  108],
                 [   80,  144,  113],
                 [  148,  172,   48],
                 [  109,   24,   31],
                 [  120,  121,   57],
                 [   88,  118,  120],
                 [   14,   92,   16],
                 [  134,  177,  135],
                 [   98,   90,   96],
                 [    2,    0,   89],
                 [   89,   97,    2],
                 [  137,   97,   98],
                 [  157,  122,   98],
                 [   99,   85,   43],
                 [  179,    4,  141],
                 [  139,  179,  141],
                 [  158,  141,    5],
                 [   55,  179,  139],
                 [   52,   50,   55],
                 [  180,  133,   57],
                 [  101,  180,   57],
                 [  158,  140,  141],
                 [  190,  158,  186],
                 [  191,  190,  194],
                 [  140,  158,  190],
                 [  161,  167,  124],
                 [  125,  160,  161],
                 [  124,  125,  161],
                 [  125,  195,  178],
                 [  127,  131,  193],
                 [   62,  128,  103],
                 [   64,   65,  173],
                 [  192,  131,   73],
                 [  156,   29,   30],
                 [  105,   61,  106],
                 [    8,   10,  174],
                 [   89,   90,   98],
                 [  167,  162,   97],
                 [   52,  137,  122],
                 [  102,  194,  186],
                 [  186,  194,  190],
                 [  124,  167,  138],
                 [   72,   71,   65],
                 [  104,  131,  126],
                 [  130,  131,  104],
                 [  104,   72,   65],
                 [  130,  168,  163],
                 [   28,   29,  107],
                 [   97,  162,    2],
                 [  100,   51,  175],
                 [  166,  169,  143],
                 [  192,   74,  193],
                 [  143,   80,  166],
                 [  111,  112,   78],
                 [  157,   98,   96],
                 [  167,  136,  138],
                 [   62,   21,   19],
                 [   71,  173,   65],
                 [  143,  169,  147],
                 [  142,   75,  165],
                 [   69,  193,   74],
                 [   75,  166,  173],
                 [  173,  166,   64],
                 [  163,   66,  181],
                 [   29,  156,  106],
                 [  113,  146,  152],
                 [  108,  109,   13],
                 [   37,   38,   95],
                 [  149,    0,    1],
                 [  137,   98,  122],
                 [  159,  191,  123],
                 [    2,  162,  177],
                 [   10,  147,  174],
                 [   77,   78,  112],
                 [  111,   13,  110],
                 [  116,   95,   94],
                 [   60,   62,   63],
                 [   55,  140,  159],
                 [   74,  142,   69],
                 [   69,  127,  193],
                 [  179,   86,   99],
                 [   53,   86,  179],
                 [   78,   79,   67],
                 [   11,   36,   34],
                 [   39,   89,    0],
                 [  188,  195,  185],
                 [  178,  195,  188],
                 [  197,  196,  176],
                 [  198,  197,  199],
                 [  196,  194,  200],
                 [  196,  200,  176],
                 [  202,  201,  187],
                 [  201,   56,  187],
                 [  195,  198,  203],
                 [  185,  189,  188],
                 [  199,  203,  198],
                 [  176,  199,  197],
                 [  203,  185,  195],
                 [  187,  204,  202],
                 [  204,  200,  194],
                 [  202,  204,  194],
                 [   18,  176,  200],
                 [  203,  199,   91],
                 [  198,  195,  125],
                 [  187,  119,  204],
                 [  199,  176,   17],
                 [  189,  185,  135],
                 [  184,  203,   91],
                 [   17,   91,  199],
                 [  102,   56,  201],
                 [  123,  198,  125],
                 [  123,  191,  197],
                 [  197,  198,  123],
                 [  102,  202,  194],
                 [  194,  196,  191],
                 [   18,  200,  119],
                 [  184,  185,  203],
                 [  102,  201,  202],
                 [  196,  197,  191],
                 [  200,  204,  119],
                 ] ;



   bonds = [
// some bonds have been commented out to make the slit at
// the top of the duck head
//  and an extra bond - see end below - was added to close an
//  opening big enough for a coin to slip through
[   0,   1],[   0,   2],[   0,  39],[   0,  89],[   0, 149],[   1,   2],
[   1,  92],[   1, 134],[   1, 135],[   1, 149],[   1, 184],[   2,  89],
[   2,  97],[   2, 134],[   2, 162],[   2, 177],[   3,   4],[   3,   5],
[   3,  42],[   3,  93],[   3,  94],[   3, 180],[   4,   5],[   4,  42],
[   4,  43],[   4,  99],[   4, 141],[   4, 179],[   5,  58],[   5, 101],
[   5, 141],[   5, 158],[   5, 180],[   6,   7],[   6,   8],[   6,   9],
[   6,  10],[   6, 148],[   6, 153],[   7,   8],[   7,  77],[   7, 148],
[   7, 171],[   7, 172],[   7, 182],[   8,  10],[   8, 171],[   8, 174],
[   9,  10],[   9,  84],[   9, 144],[   9, 146],[   9, 153],[  10, 144],
[  10, 147],[  10, 174],[  11,  12],[  11,  13],[  11,  34],[  11,  36],
[  11,  85],[  11,  86],[  12,  13],[  12,  31],[  12,  82],[  12,  85],
[  12, 109],[  13,  34],[  13, 108],[  13, 109],[  13, 110],[  13, 111],
[  14,  15],[  14,  16],[  14,  38],[  14,  39],[  14,  92],[  14, 149],
[  15,  16],[  15,  18],[  15,  38],[  15,  87],[  15,  88],[  15, 118],
[  16,  17],[  16,  18],[  16,  91],[  16,  92],[  17,  18],[  17,  91],
[  17, 176],[  17, 199],[  18, 118],[  18, 119],[  18, 120],[  18, 176],
[  18, 200],[  19,  20],[  19,  21],[  19,  26],[  19,  62],[  19,  63],
[  19, 151],[  20,  21],[  20,  64],[  20,  65],[  20, 151],[  21,  62],
[  21,  65],[  21, 103],[  21, 104],[  22,  23],[  22,  24],[  22,  26],
[  22,  27],[  22,  28],[  22, 132],[  23,  24],[  23,  28],[  23,  30],
[  23, 108],[  24,  27],[  24,  31],[  24,  76],[  24, 108],[  24, 109],
[  25,  26],[  25,  27],[  25,  76],[  25,  80],[  25,  81],[  25, 113],
[  26,  27],[  26,  63],[  26,  81],[  26, 132],[  26, 150],[  26, 151],
[  27,  76],[  28,  29],[  28,  30],[  28, 107],[  28, 132],[  29,  30],
[  29, 106],[  29, 107],[  29, 156],[  30,  78],[  30, 108],[  30, 111],
[  30, 156],[  31,  32],[  31,  33],[  31,  76],[  31,  82],[  31, 109],
[  32,  33],[  32,  40],[  32,  41],[  32,  43],[  32,  82],[  32, 115],
[  33,  76],[  33, 113],[  33, 115],[  34,  35],[  34,  36],[  34, 110],
[  34, 182],[  35,  36],[  35, 100],[  35, 172],[  35, 182],[  36,  50],
[  36,  54],[  36,  86],[  36, 100],[  37,  38],[  37,  39],[  37,  95],
[  37, 154],[  37, 170],[  38,  39],[  38,  87],[  38,  95],[  39,  89],
[  39,  90],[  39, 149],[  39, 170],[  40,  41],[  40,  93],[  40, 114],
[  40, 115],[  40, 116],[  40, 183],[  41,  42],[  41,  43],[  41,  93],
[  42,  43],[  42,  93],[  43,  82],[  43,  85],[  43,  99],[  44,  45],
[  44,  46],[  44,  49],[  44,  84],[  44,  96],[  45,  46],[  45,  83],
[  45,  84],[  45, 154],[  45, 170],[  46,  90],[  46,  96],[  46, 170],
[  47,  48],[  47,  49],[  47,  96],[  47, 157],[  47, 175],[  48,  49],
[  48, 148],[  48, 172],[  48, 175],[  49,  84],[  49,  96],[  49, 148],
[  49, 153],[  50,  51],[  50,  52],[  50,  54],[  50,  55],[  50, 100],
[  51,  52],[  51, 100],[  51, 122],[  51, 157],[  51, 175],[  52,  55],
[  52, 122],[  52, 136],[  52, 137],[  53,  54],[  53,  55],[  53,  86],
[  53, 179],[  54,  55],[  54,  86],[  55, 136],[  55, 138],[  55, 139],
[  55, 140],[  55, 159],[  55, 179],[  56,  57],[  56,  58],[  56, 102],
[  56, 121],[  56, 187],[  56, 201],[  57,  58],[  57, 101],[  57, 120],
[  57, 121],[  57, 133],[  57, 180],[  58, 101],[  58, 102],[  58, 158],
[  58, 186],[  59,  60],//[  59,  61],
[  59,  63],[  59, 107],[  59, 132],
//[  60,  61],
[  60,  62],[  60,  63],[  60, 128],//[  61, 105],[  61, 106],
//[  61, 107],[  61, 128],
[  62,  63],[  62, 103],[  62, 128],[  63, 132],
[  64,  65],[  64, 150],[  64, 151],[  64, 166],[  64, 173],[  65,  71],
[  65,  72],[  65, 104],[  65, 173],[  66,  67],[  66,  68],[  66,  79],
[  66, 155],[  66, 163],[  66, 171],[  66, 181],[  67,  68],[  67,  78],
[  67,  79],[  67, 105],[  67, 106],[  67, 156],[  68, 105],[  68, 128],
[  68, 129],[  68, 155],[  69,  70],[  69,  71],[  69,  74],[  69, 127],
[  69, 142],[  69, 193],[  70,  71],[  70,  72],[  70, 126],[  70, 127],
[  71,  72],[  71, 142],[  71, 165],[  71, 173],[  72, 104],[  72, 126],
[  73,  74],[  73,  75],[  73, 130],[  73, 131],[  73, 163],[  73, 164],
[  73, 192],[  74,  75],[  74, 142],[  74, 192],[  74, 193],[  75, 142],
[  75, 164],[  75, 165],[  75, 166],[  75, 169],[  75, 173],[  76, 113],
[  77,  78],[  77,  79],[  77, 110],[  77, 112],[  77, 171],[  77, 182],
[  78,  79],[  78, 111],[  78, 112],[  78, 156],[  79, 171],[  80,  81],
[  80, 113],[  80, 143],[  80, 144],[  80, 150],[  80, 166],[  81, 150],
[  82,  85],[  83,  84],[  83, 117],[  83, 145],[  83, 154],[  84, 145],
[  84, 146],[  84, 153],[  85,  86],[  85,  99],[  86,  99],[  86, 179],
[  87,  88],[  87,  94],[  87,  95],[  87, 133],[  87, 180],[  88, 118],
[  88, 120],[  88, 133],[  89,  90],[  89,  97],[  89,  98],[  90,  96],
[  90,  98],[  90, 170],[  91,  92],[  91, 184],[  91, 199],[  91, 203],
[  92, 149],[  92, 184],[  93,  94],[  93, 183],[  94,  95],[  94, 116],
[  94, 180],[  94, 183],[  95, 116],[  95, 154],[  96,  98],[  96, 157],
[  97,  98],[  97, 137],[  97, 162],[  97, 167],[  98, 122],[  98, 137],
[  98, 157],[  99, 179],[ 100, 172],[ 100, 175],[ 101, 180],[ 102, 186],
[ 102, 194],[ 102, 201],[ 102, 202],[ 103, 104],[ 103, 128],[ 103, 129],
[ 103, 168],[ 104, 126],[ 104, 130],[ 104, 131],[ 104, 168],[ 105, 106],
[ 105, 128],[ 106, 107],[ 106, 156],[ 107, 132],[ 108, 109],[ 108, 111],
[ 110, 111],[ 110, 112],[ 110, 182],[ 111, 112],[ 113, 115],[ 113, 144],
[ 113, 146],[ 113, 152],[ 114, 115],[ 114, 116],[ 114, 117],[ 114, 152],
[ 115, 152],[ 116, 117],[ 116, 154],[ 116, 183],[ 117, 145],[ 117, 152],
[ 117, 154],[ 118, 120],[ 119, 120],[ 119, 121],[ 119, 187],[ 119, 200],
[ 119, 204],[ 120, 121],[ 120, 133],[ 121, 187],[ 122, 137],[ 122, 157],
[ 123, 124],[ 123, 125],[ 123, 138],[ 123, 159],[ 123, 191],[ 123, 197],
[ 123, 198],[ 124, 125],[ 124, 138],[ 124, 161],[ 124, 167],[ 125, 160],
[ 125, 161],[ 125, 178],[ 125, 195],[ 125, 198],[ 126, 127],[ 126, 131],
[ 127, 131],[ 127, 193],[ 128, 129],[ 129, 155],[ 129, 168],[ 130, 131],
[ 130, 163],[ 130, 168],[ 131, 192],[ 131, 193],[ 133, 180],[ 134, 135],
[ 134, 177],[ 135, 177],[ 135, 184],[ 135, 185],[ 135, 189],[ 136, 137],
[ 136, 138],[ 136, 167],[ 137, 167],[ 138, 159],[ 138, 167],[ 139, 140],
[ 139, 141],[ 139, 179],[ 140, 141],[ 140, 158],[ 140, 159],[ 140, 190],
[ 140, 191],[ 141, 158],[ 141, 179],[ 142, 165],[ 143, 144],[ 143, 147],
[ 143, 166],[ 143, 169],[ 144, 146],[ 144, 147],[ 145, 146],[ 145, 152],
[ 146, 152],[ 147, 163],[ 147, 164],[ 147, 169],[ 147, 174],[ 148, 153],
[ 148, 172],[ 150, 151],[ 150, 166],[ 154, 170],[ 155, 163],[ 155, 168],
[ 157, 175],[ 158, 186],[ 158, 190],[ 159, 191],[ 160, 161],[ 160, 162],
[ 160, 177],[ 160, 178],[ 161, 162],[ 161, 167],[ 162, 167],[ 162, 177],
[ 163, 164],[ 163, 168],[ 163, 174],[ 163, 181],[ 164, 169],[ 165, 173],
[ 166, 169],[ 166, 173],[ 171, 174],[ 171, 181],[ 172, 175],[ 172, 182],
[ 174, 181],[ 176, 196],[ 176, 197],[ 176, 199],[ 176, 200],[ 177, 178],
[ 177, 188],[ 177, 189],[ 178, 188],[ 178, 195],[ 184, 185],[ 184, 203],
[ 185, 188],[ 185, 189],[ 185, 195],[ 185, 203],[ 186, 190],[ 186, 194],
[ 187, 201],[ 187, 202],[ 187, 204],[ 188, 189],[ 188, 195],[ 190, 191],
[ 190, 194],[ 191, 194],[ 191, 196],[ 191, 197],[ 192, 193],[ 194, 196],
[ 194, 200],[ 194, 202],[ 194, 204],[ 195, 198],[ 195, 203],[ 196, 197],
[ 196, 200],[ 197, 198],[ 197, 199],[ 198, 199],[ 198, 203],[ 199, 203],
[ 200, 204],[ 201, 202],[ 202, 204],
      [138,140], // extra bond to fill hole
];
