/*
 Input Pullup Serial

 This example demonstrates the use of pinMode(INPUT_PULLUP). It reads a
 digital input on pin 2 and prints the results to the serial monitor.

 The circuit:
 * Momentary switch attached from pin 2 to ground
 * Built-in LED on pin 13

 Unlike pinMode(INPUT), there is no pull-down resistor necessary. An internal
 20K-ohm resistor is pulled to 5V. This configuration causes the input to
 read HIGH when the switch is open, and LOW when it is closed.

 created 14 March 2012
 by Scott Fitzgerald

 http://www.arduino.cc/en/Tutorial/InputPullupSerial

 This example code is in the public domain

 */

 /* 
 DESCRIPTION
 ====================
 Simple example of the Bounce library that switches the debug LED when 
 either of 2 buttons are pressed.
 */
#include <Gamepad.h>
#include <Bounce2.h>

#define BUTTON_PIN_1 2
#define BUTTON_PIN_2 3
#define BUTTON_PIN_3 4
#define BUTTON_PIN_4 5
#define BUTTON_PIN_5 6
#define BUTTON_PIN_6 7
#define BUTTON_PIN_7 8
#define BUTTON_PIN_8 9
#define BUTTON_PIN_9 10
#define BUTTON_PIN_10 16

//Initializing a Gamepad
Gamepad gp;

// Instantiate a Bounce object
Bounce debouncer1 = Bounce();

// Instantiate another Bounce object
Bounce debouncer2 = Bounce();

// Instantiate a Bounce object
Bounce debouncer3 = Bounce();

// Instantiate another Bounce object
Bounce debouncer4 = Bounce();

// Instantiate a Bounce object
Bounce debouncer5 = Bounce();

// Instantiate another Bounce object
Bounce debouncer6 = Bounce();

// Instantiate a Bounce object
Bounce debouncer7 = Bounce();

// Instantiate another Bounce object
Bounce debouncer8 = Bounce();

// Instantiate a Bounce object
Bounce debouncer9 = Bounce();

// Instantiate another Bounce object
Bounce debouncer10 = Bounce();

void setup() {
  //start serial connection
  Serial.begin(9600);
  
  //configure pin2 as an input and enable the internal pull-up resistor
  pinMode(BUTTON_PIN_1, INPUT_PULLUP);
  // After setting up the button, setup the Bounce instance :
  debouncer1.attach(BUTTON_PIN_1);
  debouncer1.interval(5); // interval in ms
  
  pinMode(BUTTON_PIN_2, INPUT_PULLUP);
  // After setting up the button, setup the Bounce instance :
  debouncer2.attach(BUTTON_PIN_2);
  debouncer2.interval(5); // interval in ms
  
  pinMode(BUTTON_PIN_3, INPUT_PULLUP);
  // After setting up the button, setup the Bounce instance :
  debouncer3.attach(BUTTON_PIN_3);
  debouncer3.interval(5); // interval in ms
  
  pinMode(BUTTON_PIN_4, INPUT_PULLUP);
  // After setting up the button, setup the Bounce instance :
  debouncer4.attach(BUTTON_PIN_4);
  debouncer4.interval(5); // interval in ms
  
    pinMode(BUTTON_PIN_5, INPUT_PULLUP);
  // After setting up the button, setup the Bounce instance :
  debouncer5.attach(BUTTON_PIN_5);
  debouncer5.interval(5); // interval in ms
  
  pinMode(BUTTON_PIN_6, INPUT_PULLUP);
  // After setting up the button, setup the Bounce instance :
  debouncer6.attach(BUTTON_PIN_6);
  debouncer6.interval(5); // interval in ms
  
    pinMode(BUTTON_PIN_7, INPUT_PULLUP);
  // After setting up the button, setup the Bounce instance :
  debouncer7.attach(BUTTON_PIN_7);
  debouncer7.interval(5); // interval in ms
  
  pinMode(BUTTON_PIN_8, INPUT_PULLUP);
  // After setting up the button, setup the Bounce instance :
  debouncer8.attach(BUTTON_PIN_8);
  debouncer8.interval(5); // interval in ms
  
    pinMode(BUTTON_PIN_9, INPUT_PULLUP);
  // After setting up the button, setup the Bounce instance :
  debouncer9.attach(BUTTON_PIN_9);
  debouncer9.interval(5); // interval in ms
  
  pinMode(BUTTON_PIN_10, INPUT_PULLUP);
  // After setting up the button, setup the Bounce instance :
  debouncer10.attach(BUTTON_PIN_10);
  debouncer10.interval(5); // interval in ms
  
  //pinMode(13, OUTPUT);

}

void loop() {
  
  debouncer1.update();
  debouncer2.update();
  debouncer3.update();
  debouncer4.update();
  debouncer5.update();
  debouncer6.update();
  debouncer7.update();
  debouncer8.update();
  debouncer9.update();
  debouncer10.update();

  //read the pushbutton value into a variable
  int Value1 = debouncer1.read();
  int Value2 = debouncer2.read();
  int Value3 = debouncer3.read();
  int Value4 = debouncer4.read();
  int Value5 = debouncer5.read();
  int Value6 = debouncer6.read();
  int Value7 = debouncer7.read();
  int Value8 = debouncer8.read();
  int Value9 = debouncer9.read();
  int Value10 = debouncer10.read();
  //print out the value of the pushbutton
  //Serial.println(Value1);
  //Serial.println(Value2);

  switch(Value1) {
    case 1:
      gp.setButtonState(0, false);
    break;
    case 0:
      gp.setButtonState(0, true);
    break;
  }

  switch(Value2) {
    case 1:
      gp.setButtonState(1, false);
    break;
    case 0:
      gp.setButtonState(1, true);
    break;
  }

    switch(Value3) {
    case 1:
      gp.setButtonState(2, false);
    break;
    case 0:
      gp.setButtonState(2, true);
    break;
  }

  switch(Value4) {
    case 1:
      gp.setButtonState(3, false);
    break;
    case 0:
      gp.setButtonState(3, true);
    break;
  }

  switch(Value5) {
    case 1:
      gp.setButtonState(4, false);
    break;
    case 0:
      gp.setButtonState(4, true);
    break;
  }

  switch(Value6) {
    case 1:
      gp.setButtonState(5, false);
    break;
    case 0:
      gp.setButtonState(5, true);
    break;
  }

  switch(Value7) {
    case 1:
      gp.setButtonState(6, false);
    break;
    case 0:
      gp.setButtonState(6, true);
    break;
  }

  switch(Value8) {
    case 1:
      gp.setButtonState(7, false);
    break;
    case 0:
      gp.setButtonState(7, true);
    break;
  }

  switch(Value9) {
    case 1:
      gp.setButtonState(8, false);
    break;
    case 0:
      gp.setButtonState(8, true);
    break;
  }

  switch(Value10) {
    case 1:
      gp.setButtonState(9, false);
    break;
    case 0:
      gp.setButtonState(9, true);
    break;
  }
  // Keep in mind the pullup means the pushbutton's
  // logic is inverted. It goes HIGH when it's open,
  // and LOW when it's pressed. Turn on pin 13 when the
  // button's pressed, and off when it's not:
  
}



