x = 59.75;
y = 41.3;
z = 25.5;

wall = 2;
overlap = 3;

rotate([0, 180, 0]){
union() {
    color([0.2,0.2,1])
    rotate([0, 90, 0])
    translate([0, y / 2 * -1 - 13, 0])
            gopro_connector("double");
    
    // reinforced wall
    translate([0, -y / 2 - wall - 1, 0])
        cube([x + wall * 2, 2, z + wall * 2], true); 
    
    difference() {
        cube([x + wall * 2, y + wall*2, z + wall * 2], true);
        
        // cut interior
        cube([x, y, z], true);
        
        // cut overlap
        cube([x - overlap, y - overlap, z + (wall * 4)], true);
        
        // remove bottom overlap
        translate([0, 0, -5])
            cube([x, y, z], true);
        
        // cuts arount top tab
//        translate([x/2 - 10, y/2 + 0.8, -z/4 - wall - 0.1])
//            cube([1, wall + 0.5, z/1.3], true);
//        translate([x/2 - 25, y/2 + 0.8, -z/4 - wall - 0.1])
//            cube([1, wall + 0.5, z/1.3], true);
        
        power();
        ports();
        hull() {
            volume();
            speaker();
        }
    }
    
    // tab
    translate([x/2 - 24.5, y/2 + 0.8, -z/2 - 0.5])
        rotate([0, 90, 0]){
            cylinder(14, r = 2.25, true);
        } 
}
}

module power() {
    powerR = 6;
    powerXOffset = 6.5;
    
    ledR = 2;
    ledXOffset = 18;
    ledZOffset = -6.8;
    
    hull() {
        translate([-(x + wall) / 2 + powerXOffset + powerR, y / 2 + wall + 0.1, -0.5])
            rotate([90,0,0]){
                cylinder(wall*2, r = powerR + .5, true);
            }
        translate([-(x) / 2 + ledXOffset + ledR, y / 2 + wall + 0.1, z / 2 + + ledZOffset])
            rotate([90, 0, 0]) {
                cylinder(wall*2, r = ledR + 1, true);
            }
    }
}

module volume() {
    btnHeight = 6;
    btnR = btnHeight / 2;
    btnYOffset = 12.5; // to edge of circle. Subtract R;
    btnZOffset = -4; // from center
    
    hull() {
        translate([-(x + wall)/2 - wall, btnYOffset - btnR, btnZOffset])
            rotate([90, 0, 90]){
                cylinder(wall * 3, r = btnR + 0.25, true);
            }
        translate([-(x + wall)/2 - wall, -btnYOffset + btnR, btnZOffset])
            rotate([90, 0, 90]){
                cylinder(wall * 3, r = btnR + 0.25, true);
            }
    }
}

module speaker() {
    d = 6;
    r = d / 2;
    xOffset = 10;
    zOffset = 5.5; // from top
    
    translate([-(x + wall)/2 - 1, -xOffset + r, z / 2 - zOffset])
        rotate([90, 0, 90]) {
            cylinder(wall * 2, r = r + 0.25, true);
        }
}

module ports() {
    pW = 30;
    pH = 11;
    pZOffset = -(pH / 2) + .75;
    
    translate([(x + wall) / 2 - 0.1, 0, pZOffset])
        cube([wall *2, pW, pH], true);
}


/* [Main] */

// First head kind ("example" show them all but is not printable)
gopro_primary="example"; // [example,triple,double]
// The other head kind (only for the triple or double primary kind)
gopro_secondary_what="triple"; // [double,triple,rod,clamp,none]
// If ever you rotate the seconday head you will probably need to enable support to print it
gopro_secondary_rotated=0; // [0:false,1:true]

// Optional axis-to-axis extension rod (hence, it cannot be less than 20.7)
gopro_ext_len=50;
// The wall thickness of the extension rod (2 to 6mm are good values)
gopro_ext_th=3;

/* [Rod and captive nut] */

// This tab is useful only if you have selected "rod" as the secondary head. The optional rod diameter (also the captive nut internal diameter)
gopro_captive_rod_id= 3.8;
// The angle the rod makes with the axis (0 is colinear, 90 is a right angle)
gopro_captive_rod_angle= 45; // [0:90]
// Optional captive nut thickness with freeplay (tightest would be 3.2)
gopro_rod_nut_th= 3.6;
// Optional captive nut diameter with freeplay (from corner to corner)
gopro_rod_nut_od= 8.05;
// How much is the protruding output of the rod on the rod attachment (can be zero), useful if you don't want a captive nut with still a tight coupling
gopro_captive_protruding_h= 0.5;

/* [Clamp/bar mount] */

// This tab is useful only if you have selected "clamp" as the secondary head.  The optional (handle)bar diameter
gopro_bar_rod_d= 31;
// How thick is the ring around the bar
gopro_bar_th= 3.2;
// How big is the gap between the jaws
gopro_bar_gap= 2.4;
// The jaw screw diameter
gopro_bar_screw_d= 3;
// The diameter of the head of the screw
gopro_bar_screw_head_d= 6.2;
// The diameter of the nut of the screw from corner to corner (can be zero)
gopro_bar_screw_nut_d= 6.01;
// How thick are the shoulders on which to bolt (each side)
gopro_bar_screw_shoulder_th=4.5;
// Whether to reverse the bolt orientation (from which side you will screw the bolt, defaut is from the joint)
gopro_bar_screw_reversed=false; // [true,false]

/* [Hidden] */

// The gopro connector itself (you most probably do not want to change this but for the first two)

// The locking nut on the gopro mount triple arm mount (keep it tight)
gopro_nut_d= 9.2;
// How deep is this nut embossing (keep it small to avoid over-overhangs)
gopro_nut_h= 2;
// Hole diameter for the two-arm mount part
gopro_holed_two= 5;
// Hole diameter for the three-arm mount part
gopro_holed_three= 5.5;
// Thickness of the internal arm in the 3-arm mount part
gopro_connector_th3_middle= 3.1;
// Thickness of the side arms in the 3-arm mount part
gopro_connector_th3_side= 2.7;
// Thickness of the arms in the 2-arm mount part
gopro_connector_th2= 3.04;
// The gap in the 3-arm mount part for the two-arm
gopro_connector_gap= 3.1;
// How round are the 2 and 3-arm parts
gopro_connector_roundness= 1;
// How thick are the mount walls
gopro_wall_th= 3;

gopro_connector_wall_tol=0.5+0;
gopro_tol=0.04+0;

// Can be queried from the outside
gopro_connector_z= 2*gopro_connector_th3_side+gopro_connector_th3_middle+2*gopro_connector_gap;
gopro_connector_x= gopro_connector_z;
gopro_connector_y= gopro_connector_z/2+gopro_wall_th;


module gopro_torus(r,rnd)
{
	translate([0,0,rnd/2])
		rotate_extrude(convexity= 10)
			translate([r-rnd/2, 0, 0])
				circle(r= rnd/2, $fs=0.2);
}

module gopro_rcyl(r,h, centered, rnd=1)
{
	translate([0,0,center ? -h/2 : 0])
	hull() {
		translate([0,0,0]) gopro_torus(r=r, rnd=rnd);
		translate([0,0,h-rnd]) gopro_torus(r=r, rnd=rnd);
	}
}

module gopro_connector(version="double", withnut=true, captive_nut_th=0, captive_nut_od=0, captive_rod_id=0, captive_nut_angle=0)
{
	module gopro_profile(th)
	{
		hull()
		{
			gopro_torus(r=gopro_connector_z/2, rnd=gopro_connector_roundness);
			translate([0,0,th-gopro_connector_roundness])
				gopro_torus(r=gopro_connector_z/2, rnd=gopro_connector_roundness);
			translate([-gopro_connector_z/2,gopro_connector_z/2,0])
				cube([gopro_connector_z,gopro_wall_th,th]);
		}
	}
	difference()
	{
		union()
		{
			if(version=="double")
			{
				for(mz=[-1:2:+1]) scale([1,1,mz])
						translate([0,0,gopro_connector_th3_middle/2 + (gopro_connector_gap-gopro_connector_th2)/2]) gopro_profile(gopro_connector_th2);
			}
			if(version=="triple")
			{
				translate([0,0,-gopro_connector_th3_middle/2]) gopro_profile(gopro_connector_th3_middle);
				for(mz=[-1:2:+1]) scale([1,1,mz])
					translate([0,0,gopro_connector_th3_middle/2 + gopro_connector_gap]) gopro_profile(gopro_connector_th3_side);
			}

			// add the common wall
			translate([0,gopro_connector_z/2+gopro_wall_th/2+gopro_connector_wall_tol,0])
				cube([gopro_connector_z,gopro_wall_th,gopro_connector_z], center=true);

			// add the optional nut emboss
			if(version=="triple" && withnut)
			{
				translate([0,0,gopro_connector_z/2-gopro_tol])
				difference()
				{
					cylinder(r1=gopro_connector_z/2-gopro_connector_roundness/2, r2=11.5/2, h=gopro_nut_h+gopro_tol);
					cylinder(r=gopro_nut_d/2, h=gopro_connector_z/2+3.5+gopro_tol, $fn=6);
				}
			}
		}
		// remove the axis
		translate([0,0,-gopro_tol])
			cylinder(r=(version=="double" ? gopro_holed_two : gopro_holed_three)/2, h=gopro_connector_z+4*gopro_tol, center=true, $fs=1);
	}
}