
fanductonly = true;//change to false for displaying extruder/fans/sensor

topsize=4;

tubesteps = 100;

//--------------

module cooler(size, height, holedistance, screwdiameter)
{
    difference(){

    cube([size,size,height]);

    offset = (size-holedistance)/2;

    translate([offset,offset,-1])
    cylinder(r=screwdiameter/2, h=height+2, $fn=30);

    translate([size-offset,offset,-1])
    cylinder(r=screwdiameter/2, h=height+2, $fn=30);

    translate([offset,size-offset,-1])
    cylinder(r=screwdiameter/2, h=height+2, $fn=30);

    translate([size-offset,size-offset,-1])
    cylinder(r=screwdiameter/2, h=height+2, $fn=30);

    translate([size/2,size/2,-1])
    cylinder(d=size-2, h=height+2, $fn=360);
    }
}

module cooler40()
{
    cooler(40, 11, 33, 3);
}

module cooler30()
{
    cooler(30, 10.5, 24, 3);
}

module cooler30withcrews()
{
    s=30;
    is=24;
    offset=(s-is)/2;

    sh=3;
    ss=5;
    h=10.5;
    cooler(s, h, is, 3);

    translate([offset,offset,h])cylinder(r=ss/2,h=sh, $fn=20);
    translate([s-offset,offset,h])cylinder(r=ss/2,h=sh, $fn=20);
    translate([offset,s-offset,h])cylinder(r=ss/2,h=sh, $fn=20);
    translate([s-offset,s-offset,h])cylinder(r=ss/2,h=sh, $fn=20);
}

module platform(){
    color("darkgray")
    translate([-38/2,0,0]) difference(){
        cube([38,28,5]);

        translate([19,14,-1])cylinder(d=13, h=5+2);

        translate([10.5,5,-1])cylinder(r=1.5, h=5+2, $fn=20);
        translate([38-10.5,5,-1])cylinder(r=1.5, h=5+2, $fn=20);

        translate([10.5,5+12,-1])cylinder(r=1.5, h=5+2, $fn=20);
        translate([38-10.5,5+12,-1])cylinder(r=1.5, h=5+2, $fn=20);
    }
}


module extruderpart()
{
    color("gray") cube([30,18,30]);

    rotate([90,0,0])
    {
        cooler30withcrews();
    }

    color("darkgray")translate([5,6.5,-13])cube([20,21,13]);

    translate([15,13,-21])
    {
        intersection(){
            cylinder(h=8,d=7, $fn=30);
            cylinder(r1=0,r2=10,h=10);
        }
    }
}

module sensor()
{
    $fn=60;
    d=18;

    color("gray") translate([0,0,71-15])cylinder(d=d, h=15);
    color("black") translate([0,0,10])cylinder(d=d, h=71-10-15);
    color("yellow") cylinder(d=d, h=10);

    x=20;
    color("gray") translate([0,0,x+20-6])cylinder(d=30,h=5, $fn=6);
    color("gray") translate([0,0,x+26])cylinder(d=30,h=5, $fn=6);
    color("gray") translate([0,0,x+25.2])cylinder(d=30,h=.5);
}

module dube(x0,y0,z0,xa0,ya0,za0,s0, sy0,
    x1,y1,z1, xa1,ya1,za1, s1, sy1,
    steps
){
    for(i=[0:steps]) {
        x = (x1-x0)*i/steps+x0;
        y = (y1-y0)*i/steps+y0;
        z = (z1-z0)*i/steps+z0;
        xa = (xa1-xa0)*i/steps+xa0;
        ya = (ya1-ya0)*i/steps+ya0;
        za = (za1-za0)*i/steps+za0;
        s = (s1-s0)*i/steps+s0;
        sy = (sy1-sy0)*i/steps+sy0;

        h=1;

        translate([x,y,z])
        {
            rotate([xa,ya,za])
                difference(){
                    translate([-s/2,-sy/2,-h/2]) cube([s,sy,h]);
                    translate([-(s-2)/2,-(sy-2)/2,-h]) cube([s-2,sy-2,h*2]);
            }
        }
    }
}

//--------------

module static(){
    translate([0,0,-5])platform();
    translate([-30/2,2.5,-35]) extruderpart();
}

module tube()
{
dube(
    -40,-29,-35.7, //xyz
    70,0,0, //angles
    40, 40, //size

    -28,-17,-41, //xyz
    80,0,-60, //angles
    28, 28, //size

    tubesteps
);
dube(
    -28,-17,-41, //xyz
    80,0,-60, //angles
    28, 28, //size

    -25,-10,-44, //xyz
    90,0,-30, //angles
    22, 22, //size

    tubesteps
);
dube(
    -25,-10,-44, //xyz
    90,0,-30, //angles
    22, 22, //size

    -22,0,-47, //xyz
    90,0,0, //angles
    16, 16, //size

    tubesteps
);
dube(
    -22,0,-47, //xyz
    90,0,0, //angles
    16, 16, //size

    -18,9,-48, //xyz
    90,0,-45, //angles
    14, 14, //size

    tubesteps
);
dube(
    -18,9,-48, //xyz
    90,0,-45, //angles
    14, 14, //size

    -9,14,-53, //xyz
    90,0,-90, //angles
    11, 4, //size

    tubesteps
);
}

module doublecoolerholder()
{
    s=40;
    is=33;
    offset=(s-is)/2;

    sh=topsize;
    ss=3.2;
    h=10.5;

    difference(){
    cube([s*2,s,sh]);

    translate([offset,offset,-1])cylinder(r=ss/2,h=sh+2, $fn=20);
    translate([offset,s-offset,-1])cylinder(r=ss/2,h=sh+2, $fn=20);
    translate([s-offset,offset,-1])cylinder(r=ss/2,h=sh+2, $fn=20);
    translate([s-offset,s-offset,-1])cylinder(r=ss/2,h=sh+2, $fn=20);

    translate([s+s-offset,offset,-1])cylinder(r=ss/2,h=sh+2, $fn=20);
    translate([s+s-offset,s-offset,-1])cylinder(r=ss/2,h=sh+2, $fn=20);
    translate([s+offset,offset,-1])cylinder(r=ss/2,h=sh+2, $fn=20);
    translate([s+offset,s-offset,-1])cylinder(r=ss/2,h=sh+2, $fn=20);

    translate([s+s/2,s/2,-1]) cylinder(d=s-4,h=sh+2);
    translate([s/2,s/2,-1]) cylinder(d=s-4,h=sh+2);
    }

    translate([35,40,0]) cube([10,20.65,4]);
    translate([70,40,0]) cube([10,20.65,4]);

    linear_extrude(topsize) polygon([[s-10,s],[s-5,s+5],[s+5,s+5],[s+10,s]]);

    linear_extrude(topsize) polygon([[s+s-15,s],[s+s-10,s+5],[s+s,s]]);
}

if(!fanductonly) {
    #static();
    #translate([-40,5,-55]) sensor();

    #translate([-20,-40,-53]) rotate([70,0,0]) cooler40();
    #translate([-60,-40,-53]) rotate([70,0,0]) cooler40();
}


translate([-60,-40,-53]) rotate([70,0,0]) translate([0,0,-4])doublecoolerholder();

//sensor holder
translate([-40,5,-15]) union()
{
    //ring at the side
    difference(){
        union(){
            cylinder(h=topsize,d=30);
            translate([0,-15,0]) cube([15,30,topsize]);
        }
        translate([0,0,-1]) cylinder(h=7,d=18.3);
    }

    //side part
    translate([15,-15,0]) cube([topsize,30,15]);

    translate([15,-25,0]) cube([topsize,10,15]);
    translate([15,-28,0]) cube([topsize,10,8]);

    //tube holder
    translate([15+topsize,15,-0])
    rotate([0,90,180])
    linear_extrude(topsize)
    polygon([[0,0], [26,10],
    [25.1,20],
    [19,30],
    [0,42]
    ]);
}

tube();

difference(){
    union(){
        translate([-25,5-15,0])cube([45,30,topsize]);

        translate([0,8,0]) cylinder(d=33,h=topsize);

        translate([-25,-19.254,0]) cube([10,10,topsize]);
        translate([10,-19.254,0]) cube([10,10,topsize]);

    translate([20-topsize,-20,0])
        rotate([0,90,0]) linear_extrude(topsize) polygon([[0,0],[17,-4],[0,18]]);

    }

    translate([0,14,-1]) cylinder(d=13,h=topsize+2);

    translate([-8.5,5,-1]) cylinder(d=3.3,h=topsize+2, $fn=20);
    translate([-8.5,17,-1]) cylinder(d=3.3,h=topsize+2, $fn=20);

    translate([8.5,5,-1]) cylinder(d=3.3,h=topsize+2, $fn=20);
    translate([8.5,17,-1]) cylinder(d=3.3,h=topsize+2, $fn=20);
}

