#include <EEPROM.h>

#include <Adafruit_NeoPixel.h>
#define PIN 0  // button input

// Parameter 1 = number of pixels in strip  >>>>>>>>> # how many LEDs you have # <<<<<<<<<
// Parameter 2 = pin number (most are valid)
// Parameter 3 = pixel type flags, add together as needed:
//   NEO_KHZ800  800 KHz bitstream (most NeoPixel products w/WS2812 LEDs)
//   NEO_KHZ400  400 KHz (classic 'v1' (not v2) FLORA pixels, WS2811 drivers)
//   NEO_GRB     Pixels are wired for GRB bitstream (most NeoPixel products)
//   NEO_RGB     Pixels are wired for RGB bitstream (v1 FLORA pixels, not v2)
Adafruit_NeoPixel strip = Adafruit_NeoPixel(8, PIN, NEO_GRB + NEO_KHZ800);

int buttonState = 0;  
int rom,x;

void setup() {
  strip.begin();
  strip.show();            // Initialize all pixels to 'off'
  pinMode(1, INPUT);       // button input
  digitalWrite(1, LOW);
  x=0;
}



void loop() {
  
            buttonState = digitalRead(1);
            if (buttonState == HIGH) {delay(350); x++; EEPROM.write(1, x);} 
            if(x==1) {EEPROM.write(1, 1); ranbrt('R');}  // random brightness Red
            if(x==2) {EEPROM.write(1, 2);ranbrt('W');}  // random brightness White
            if(x==3) {EEPROM.write(1, 3);flashR();}     // flashing 1 Hz red
            if(x==4) {EEPROM.write(1, 4);breath('R');}  // Breathing Red
            if(x==5) {EEPROM.write(1, 5);breath('W');}  // Breathing White
            if(x==6) {EEPROM.write(1, 6);rise('R');}    // ramping up Red
            if(x==7) {delay(400);}
            if(x==8) {EEPROM.write(1, 8);rise('W');}   // ramping up White
            if(x==9) {delay(400);}
            if(x==10) {EEPROM.write(1, 10);rainbowCycle(5);}
            if(x==11) {EEPROM.write(1, 11);rainbow(5);}
            if(x==12) {EEPROM.write(1, 0);colorWipe(strip.Color(0, 0, 0), 5); x=0;} // OFF
            
            if((x!=7) && (x!=9))
            x=EEPROM.read(1); //  read the last mode's numb
            
}

// Fill the dots one after the other with a color
void colorWipe(uint32_t c, uint8_t wait) {
  for(uint16_t i=0; i<strip.numPixels(); i++) {
      strip.setPixelColor(i, c);
      strip.show();
      delay(wait);
       buttonState = digitalRead(1);
       if (buttonState == HIGH){delay(350); x++; break;}
  }
}

void rise(char c) {
  if (c=='R') colorWipe(strip.Color(255, 0, 0), 1);
  if (c=='W') colorWipe(strip.Color(255, 255, 255), 1);
  for(int i=2;i<255;i++){
  strip.setBrightness(i);
  strip.show();
  delay(8);
          buttonState = digitalRead(1);
         if (buttonState == HIGH){delay(350); x++; break;}
  }
  x=x+1;
}

void flashR(){
  strip.setBrightness(255);
  colorWipe(strip.Color(255, 0, 0), 50);
  for(int d=0; d<200; d++){
     buttonState = digitalRead(1);
         if (buttonState == HIGH){delay(350); x++;}
         delay(4);
  }
  colorWipe(strip.Color(0, 0, 0), 0);
  for(int d=0; d<200; d++){
     buttonState = digitalRead(1);
         if (buttonState == HIGH){delay(350); x++;}
         delay(4);
  }
}

void breath(char c){
  if (c=='R') colorWipe(strip.Color(255, 0, 0), 1);
  if (c=='W') colorWipe(strip.Color(255, 255, 255), 1);
  for(int i=2;i<255;i++){
  strip.setBrightness(i);
  strip.show();
  delay(5);
         buttonState = digitalRead(1);
         if (buttonState == HIGH){delay(350); x++; break;}
  } 
  for(int i=255;i>2;i--){
  strip.setBrightness(i);
  strip.show();
  delay(5);
         buttonState = digitalRead(1);
         if (buttonState == HIGH){delay(350); x++; break;}
  } 
}

void ranbrt(char c){
  if (c=='R') colorWipe(strip.Color(255, 0, 0), 1);
  if (c=='W') colorWipe(strip.Color(255, 255, 255), 1);
  int r=random(1,10);
  //randomSeed(r);
  int r1=random(2,255);
  for(int i=2;i<r1;i++){
  strip.setBrightness(i);
  strip.show();
  delay(r);
         buttonState = digitalRead(1);
         if (buttonState == HIGH){delay(350); x++; break;}
  } 
  for(int i=r1;i>2;i--){
  strip.setBrightness(i);
  strip.show();
  delay(r);
         buttonState = digitalRead(1);
         if (buttonState == HIGH){delay(350); x++; break;}
  } 
  
         buttonState = digitalRead(1);
         if (buttonState == HIGH){delay(350); x++; }
}


void rainbow(uint8_t wait) {
  uint16_t i, j;
  for(j=0; j<256; j++) {
    for(i=0; i<strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel((i+j) & 255));
             buttonState = digitalRead(1);
       if (buttonState == HIGH){delay(350); x=12; break;}
    }
    strip.show();
    delay(wait);
           buttonState = digitalRead(1);
       if (buttonState == HIGH){delay(350); x=12; break;}
  }
}

// Slightly different, this makes the rainbow equally distributed throughout
void rainbowCycle(uint8_t wait) {
  uint16_t i, j;

  for(j=0; j<256*5; j++) { // 5 cycles of all colors on wheel
    for(i=0; i< strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel(((i * 256 / strip.numPixels()) + j) & 255));
             buttonState = digitalRead(1);
       if (buttonState == HIGH){delay(350); x++; break;}
    }
    strip.show();
    delay(wait);
           buttonState = digitalRead(1);
       if (buttonState == HIGH){delay(350); x++; break;}
  }
}

// Input a value 0 to 255 to get a color value.
// The colours are a transition r - g - b - back to r.
uint32_t Wheel(byte WheelPos) {
  if(WheelPos < 85) {
   return strip.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
  } else if(WheelPos < 170) {
   WheelPos -= 85;
   return strip.Color(255 - WheelPos * 3, 0, WheelPos * 3);
  } else {
   WheelPos -= 170;
   return strip.Color(0, WheelPos * 3, 255 - WheelPos * 3);
  }
}

