/*
  LED bar graph using a programming array with control from a potentiometer.
  
  Turns on a series of LEDs based on the value of an analog sensor.
  This is a simple way to make a bar graph display. Though this graph uses 10
  LEDs, you can use any number by changing the LED count and the pins in the
  array.
  This method can be used to control any series of digital outputs that depends
  on an analog input.

  The circuit:
  - LEDs from pins 2 through 7 to ground, each with 470 ohm resistor
  - Potentiometer is connected 5V, Analog pin 0, and Ground

  originally created 4 Sep 2010
  by Tom Igoe
  This example code is in the public domain.
  http://www.arduino.cc/en/Tutorial/BarGraph

  Modified 2 Oct 2017
  - Added serial monitor and additional code comments for clarity of what is happening
  by Rob Martin at Open Source Classroom, LLC
  check us out at www.osc3d.com
*/

// these constants won't change:
const int analogPin = A0;   // the Analog pin that the potentiometer is attached to
const int ledCount = 6;    // the total number of LEDs in the array

int ledPins[] = {2, 3, 4, 5, 6, 7};   // an array of pin numbers to which LEDs are attached

void setup() {
    Serial.begin(9600);   //Initiate Serial communication.
  
  // loop over the pin array and set them all to output:
  for (int thisLed = 0; thisLed < ledCount; thisLed++) {   
    pinMode(ledPins[thisLed], OUTPUT);
  }
}

void loop() {
// read the potentiometer: 
  int sensorReading = analogRead(analogPin);               

// map the result to a range from 0 to the number of LEDs: 
  int ledLevel = map(sensorReading, 0, 1023, 0, ledCount);  
      
// This next section shows real time data of potentiometer values and # of LEDs to the Serial Monitor
// To view the serial monitor click on "Tools->Serial Monitor" and view on computer screen
      Serial.print("When the Potentiometer value is ");     
      Serial.print(sensorReading);        
      Serial.print(", it lights up ");
      Serial.print(ledLevel);
      Serial.println(" LEDs.");
      delay(500);

// loop over the LED array:
  for (int thisLed = 0; thisLed < ledCount; thisLed++) {
    
// "if" the array element's index is less than ledLevel, turn the pin for this element on:
    if (thisLed < ledLevel) {
      digitalWrite(ledPins[thisLed], HIGH);
    }

// "else" turn off all pins higher than the ledLevel:
    else {
      digitalWrite(ledPins[thisLed], LOW);
    }
  }
}
